Accessibility compliance
===

Enabling the [Accessibility module](https://www.highcharts.com/docs/accessibility/accessibility-module) goes a long way to ensure that your charts automatically comply with existing accessibility standards, including the requirements from the US Government in Section 508, the European Web Accessibility Directive, and the international WCAG 2.1 standard. We aim to be innovative and leading in this field, and make sure we involve users with disabilities when developing our accessibility features. The features and tools provided go far beyond basic compliance, and our goal is to help you provide the most accessible charts possible.

Responsibility with the user of Highcharts
------------------------------------------

Standards such as WCAG 2.1 define guidelines for what constitutes accessible web content. Highcharts itself is however not web content, but a highly flexible tool for creation of web content through a programming interface. The users of Highcharts have complete control over the web content created, either through our official APIs or through programmatic manipulation of the library. With the Accessibility module, Highcharts helps you produce charts that are as accessible as possible. Due to the flexible nature of Highcharts, however, the final responsibility for standards compliance of the resulting web content has to be with the user of Highcharts.

Check and test your design
--------------------------

Certain configurations or design decisions, such as which colors are used in the chart, could result in a chart that is inaccessible to some users. Custom plugins and functionality could also affect chart accessibility. We therefore always recommend checking your design against established standards, and testing your charts with relevant assistive technology to verify that they are accessible.

Read more about making your charts accessible using the [Accessibility module](https://www.highcharts.com/docs/accessibility/accessibility-module) here. If you experience issues making your chart accessible, please [reach out to us](https://www.highcharts.com/blog/support/) and we will be happy to assist.
