module.exports = {
    docs: {
        Highcharts: ['index'],
        'Getting started': [
            'getting-started/system-requirements',
            'getting-started/installation',
            'getting-started/installation-with-esm',
            'getting-started/install-from-npm',
            'getting-started/installation-with-amd-commonjs',
            'getting-started/your-first-chart',
            'getting-started/how-to-set-options',
            'getting-started/frequently-asked-questions',
            'getting-started/how-to-create-custom-highcharts-packages',
            'getting-started/optional-dependencies'
        ],
        'Chart concepts': [
            'chart-concepts/understanding-highcharts',
            'chart-concepts/title-and-subtitle',
            'chart-concepts/axes',
            'chart-concepts/bubble-legend',
            'chart-concepts/series',
            'chart-concepts/tooltip',
            'chart-concepts/legend',
            'chart-concepts/scrollbar',
            'chart-concepts/plot-bands-and-plot-lines',
            'chart-concepts/zooming',
            'chart-concepts/labels-and-string-formatting',
            'chart-concepts/templating',
            'chart-concepts/drilldown',
            'chart-concepts/3d-charts',
            'chart-concepts/responsive',
            'chart-concepts/security'
        ],
        'Stock': [
            'stock/getting-started-stock',
            'stock/understanding-highcharts-stock',
            'stock/stock-tools',
            'stock/advanced-annotations',
            'stock/candlestick-chart',
            'stock/compare',
            'stock/cumulative-sum',
            'stock/hollow-candlestick-chart',
            'stock/heikinashi',
            'stock/renko',
            'stock/pointandfigure',
            'stock/data-grouping',
            'stock/depth-chart',
            'stock/flag-series',
            'stock/navigator',
            'stock/hlc-chart',
            'stock/ohlc-chart',
            'stock/range-selector',
            'stock/axis-resizer',
            'stock/technical-indicator-series',
            'stock/custom-technical-indicators',
            'stock/standalone-navigator'
        ],
        'Maps': [
            'maps/getting-started',
            'maps/mapview-and-projection',
            'maps/map-navigation',
            'maps/color-axis',
            'maps/map-collection',
            'maps/create-custom-maps',
            'maps/custom-geojson-maps',
            'maps/adding-points-and-lines',
            'maps/map-drill-down',
            'maps/map-series',
            'maps/mapline-series',
            'maps/mappoint-series',
            'maps/tiledwebmap',
            'maps/flowmap-series',
            'maps/mapbubble-series',
            'maps/marker-clusters',
            'maps/tilemap-series',
            'maps/geoheatmap-series'
        ],
        'Gantt': [
            'gantt/getting-started-gantt',
            'gantt/gantt-grouping-tasks',
            'gantt/gantt-task-dependencies',
            'gantt/gantt-axis-grid',
            'gantt/gantt-task-config'
        ],
        'Dashboards': [
            'dashboards/installation',
            'dashboards/your-first-dashboard',
            'dashboards/dashboards-with-angular',
            'dashboards/dashboards-with-react',
            'dashboards/dashboards-with-vue',
            'dashboards/layout-description',
            'dashboards/style-by-css',
            'dashboards/edit-mode',
            'dashboards/types-of-components',
            'dashboards/datagrid-component',
            'dashboards/kpi-component',
            'dashboards/highcharts-component',
            'dashboards/html-component',
            'dashboards/navigator-component',
            'dashboards/synchronize-components',
            'dashboards/light-dark-theme',
            'dashboards/data-handling',
            'dashboards/data-pool-and-connectors',
            'dashboards/data-table',
            'dashboards/data-modifiers',
            'dashboards/mathmodifier-module',
            'dashboards/custom-component',
            'dashboards/installation-with-es-modules',
            'dashboards/get-options',
            'dashboards/frequently-asked-questions',
        ],
        'DataGrid': [
            'datagrid/general',
            'datagrid/installation',
            'datagrid/understanding-datagrid',
            'datagrid/columns',
            'datagrid/header',
            'datagrid/events',
            'datagrid/performance',
            'datagrid/style-by-css',
            'datagrid/datagrid-v2-migration',
            'datagrid/datagrid-with-angular',
            'datagrid/datagrid-with-react',
            'datagrid/datagrid-with-vue'
            
        ],
        'Chart and series types': [
            'chart-and-series-types/chart-types',
            'chart-and-series-types/combining-chart-types',
            'chart-and-series-types/3d-cylinder',
            'chart-and-series-types/funnel-3d',
            'chart-and-series-types/pyramid-3d',
            'chart-and-series-types/angular-gauges',
            'chart-and-series-types/arc-diagram',
            'chart-and-series-types/area-chart',
            'chart-and-series-types/areaspline-chart',
            'chart-and-series-types/bar-chart',
            'chart-and-series-types/bell-curve-series',
            'chart-and-series-types/box-plot-series',
            'chart-and-series-types/bubble-series',
            'chart-and-series-types/bullet-chart',
            'chart-and-series-types/column-chart',
            'chart-and-series-types/column-pyramid',
            'chart-and-series-types/dependency-wheel',
            'chart-and-series-types/dumbbell-series',
            'chart-and-series-types/error-bar-series',
            'chart-and-series-types/funnel-series',
            'chart-and-series-types/heatmap',
            'chart-and-series-types/histogram-series',
            'chart-and-series-types/item-chart',
            'chart-and-series-types/line-chart',
            'chart-and-series-types/lollipop-series',
            'chart-and-series-types/network-graph',
            'chart-and-series-types/organization-chart',
            'chart-and-series-types/packed-bubble',
            'chart-and-series-types/parallel-coordinates-chart',
            'chart-and-series-types/pareto-chart',
            'chart-and-series-types/pictorial',
            'chart-and-series-types/pie-chart',
            'chart-and-series-types/polar-chart',
            'chart-and-series-types/radial-bar-chart',
            'chart-and-series-types/range-series',
            'chart-and-series-types/sankey-diagram',
            'chart-and-series-types/scatter-chart',
            'chart-and-series-types/spline-chart',
            'chart-and-series-types/stream-graph',
            'chart-and-series-types/sunburst-series',
            'chart-and-series-types/timeline-series',
            'chart-and-series-types/treegraph-chart',
            'chart-and-series-types/treemap',
            'chart-and-series-types/variable-radius-pie-chart',
            'chart-and-series-types/variwide-chart',
            'chart-and-series-types/vector-plot',
            'chart-and-series-types/venn-series',
            'chart-and-series-types/waterfall-series',
            'chart-and-series-types/wind-barbs-series',
            'chart-and-series-types/word-cloud-series',
            'chart-and-series-types/x-range-series'

        ],
        'Advanced chart features': [
            'advanced-chart-features/renderer',
            'advanced-chart-features/annotations-module',
            'advanced-chart-features/annotations-and-fibonacci-retracements',
            'advanced-chart-features/annotations-gui',
            'advanced-chart-features/boost-module',
            'advanced-chart-features/breadcrumbs',
            'advanced-chart-features/data-sorting',
            'advanced-chart-features/marker-clusters',
            'chart-concepts/bubble-legend',
            'advanced-chart-features/debugger-mode',
            'advanced-chart-features/freeform-drawing',
            'advanced-chart-features/internationalization',
            'advanced-chart-features/pie-datalabels-alignment',
            'advanced-chart-features/stacking-charts',
            'advanced-chart-features/highcharts-typescript-declarations'
        ],
        'Export module': [
            'export-module/export-module-overview',
            'export-module/client-side-export',
            'export-module/setting-up-the-server',
            'export-module/render-charts-serverside',
            'export-module/privacy-disclaimer-export'
        ],
        'Working with data': [
            'working-with-data/data-intro',
            'working-with-data/data-compression',
            'working-with-data/data-module',
            'working-with-data/custom-preprocessing',
            'working-with-data/live-data',
            'working-with-data/data-from-a-database',
            'working-with-data/getting-data-across-domains-jsonp',
            'working-with-data/server-side-data-grouping'
        ],
        'Chart design and style': [
            'chart-design-and-style/design-and-style',
            'chart-design-and-style/colors',
            'chart-design-and-style/pattern-fills',
            'chart-design-and-style/themes',
            'chart-design-and-style/style-by-css',
            'chart-design-and-style/custom-themes-in-styled-mode',
            'chart-design-and-style/gradients-shadows-and-patterns'
        ],
        'Accessibility': [
            'accessibility/accessibility-module',
            'accessibility/accessibility-module-feature-overview',
            'accessibility/configure-the-accessibility-module',
            'accessibility/accessible-dynamic-data',
            'accessibility/patterns-and-contrast',
            'accessibility/tables',
            'accessibility/compliance'
        ],
        'Audio charts': [
            'sonification/getting-started',
            'sonification/mapping',
            'sonification/advanced-mapping',
            'sonification/instruments',
            'sonification/speech',
            'sonification/conditional-tracks',
            'sonification/notifications',
            'sonification/context-cues',
            'sonification/navigation'
        ],
        'Extending Highcharts': [
            'extending-highcharts/extending-highcharts'
        ]
    }
};
