const chart = Highcharts.chart('production', {
    colors: [
        '#333399',
        '#CCCCFF',
        '#0093AF',
        '#1F75FE',
        '#545AA7',
        '#FDD023',
        '#ffa500',
        '#9C830A',
        '#D6C05E',
        '#88CC88',
        '#55AA55',
        '#2D882D',
        '#116611',
        '#004400',
        '#FFC0CB',
        '#FA8072',
        '#ED2939',
        '#960018',
        '#808080',
        '#778899',
        '#D2691E',
        '#9F8170'
    ],
    chart: {
        zooming: {
            type: 'xy'
        },
        type: 'column'
    },
    title: {
        text: '🌽 Corn Production 🌽'
    },
    subtitle: {
        text: '(drag to zoom 🔎)'
    },
    xAxis: {
        categories: [
            '1961', '1962', '1963', '1964', '1965', '1966', '1967', '1968',
            '1969', '1970', '1971', '1972', '1973', '1974', '1975', '1976',
            '1977', '1978', '1979', '1980', '1981', '1982', '1983', '1984',
            '1985', '1986', '1987', '1988', '1989', '1990', '1991', '1992',
            '1993', '1994', '1995', '1996', '1997', '1998', '1999', '2000',
            '2001', '2002', '2003', '2004', '2005', '2006', '2007', '2008',
            '2009', '2010', '2011', '2012', '2013', '2014'
        ]
    },
    yAxis: {
        min: 0,
        title: {
            text: '🚜 Total Corn Production 🚜'
        },
        stackLabels: {
            enabled: false,
            style: {
                fontWeight: 'bold',
                color: 'gray'
            }
        }
    },
    legend: {
        align: 'center',
        x: 30,
        verticalAlign: 'bottom',
        y: 0,
        floating: false,
        backgroundColor: '#b49374',
        borderColor: '#CCC',
        borderWidth: 1,
        shadow: false
    },
    tooltip: {
        formatter: function () {
            return '<b>Region: </b>' + this.series.name + '<br>' +
                '<b>Year: </b>' + this.key + ' <br>' +
                '<b>Production: </b>' +
                Highcharts.numberFormat(this.y, 0, '.', ',') + ' tonnes<br>' +
                '<b>Total: </b>' +
                Highcharts.numberFormat(this.total, 0, '.', ',') +
                ' tonnes<br>' +
                '<b>Percentage: </b>' +
                Highcharts.numberFormat(
                    this.total === 0 ? 0 : this.y / this.total * 100,
                    2,
                    '.',
                    ','
                ) + '%';
        }
    },
    plotOptions: {
        column: {
            stacking: 'normal',
            dataLabels: {
                enabled: false,
                color: 'white'
            }
        }
    },
    series: productionData()
});

const toggle = function (idx, n) {
    const series = chart.series[idx];
    const isVisible = series.visible;
    for (let i = 0; i < n; i++) {
        if (isVisible) {
            chart.series[idx + i].hide();
        } else {
            chart.series[idx + i].show();
        }
    }
};
const countries = {
    africa: [0, 5],
    americas: [5, 4],
    asia: [9, 5],
    europe: [14, 4],
    oceania: [18, 4],
    legend: [0, 1]
};
for (const [key, value] of Object.entries(countries)) {
    document.getElementById(key).addEventListener('click', function () {
        if (key !== 'legend') {
            toggle(value[0], value[1]);
        } else {
            const legend = chart.legend;
            if (legend.display) {
                legend.group.hide();
                legend.box.hide();
                legend.display = false;
            } else {
                legend.group.show();
                legend.box.show();
                legend.display = true;
            }
            chart.redraw();
            toggle(0, 1);
            toggle(0, 1);

        }
    });
}

Highcharts.chart('production_heatmap', {

    chart: {
        // zooming: {
        //     type: 'xy'
        // },
        type: 'heatmap',
        marginTop: 60,
        marginBottom: 80,
        plotBorderWidth: 1
    },

    title: {
        text: '🌽 Corn Production Heatmap  🌽'
    },
    subtitle: {
        text: '(markers indicate year over year change > 30%)'
    },
    xAxis: {
        categories: [
            '1961', '1962', '1963', '1964', '1965', '1966', '1967', '1968',
            '1969', '1970', '1971', '1972', '1973', '1974', '1975', '1976',
            '1977', '1978', '1979', '1980', '1981', '1982', '1983', '1984',
            '1985', '1986', '1987', '1988', '1989', '1990', '1991', '1992',
            '1993', '1994', '1995', '1996', '1997', '1998', '1999', '2000',
            '2001', '2002', '2003', '2004', '2005', '2006', '2007', '2008',
            '2009', '2010', '2011', '2012', '2013', '2014'
        ]
    },

    yAxis: {
        categories: [
            'Eastern Africa', 'Middle Africa', 'Northern Africa',
            'Southern Africa', 'Western Africa', 'Northern America',
            'Central America', 'Caribbean', 'South America', 'Central Asia',
            'Eastern Asia', 'Southern Asia', 'South-Eastern Asia',
            'Western Asia', 'Eastern Europe', 'Northern Europe',
            'Southern Europe', 'Western Europe', 'Australia & New Zealand',
            'Melanesia', 'Micronesia', 'Polynesia'
        ],
        title: null
    },

    colorAxis: {
        min: 1,
        minColor: '#99CCFF',
        maxColor: '#FFCC00'
    },

    legend: {
        align: 'right',
        layout: 'vertical',
        margin: 0,
        verticalAlign: 'top',
        y: 43,
        symbolHeight: 360
    },

    tooltip: {
        formatter: function () {
            return '<b>Year: </b>' + this.series.xAxis.categories[
                this.point.x
            ] + '<br>' +
            '<b>Country: </b>' + this.series.yAxis.categories[
                this.point.y
            ] + '<br>' +
            '<b>Production: </b>' + Highcharts.numberFormat(
                this.point.value, 0, '.', ','
            ) + ' tonnes<br>' +
            '<b>Last Year: </b>' + Highcharts.numberFormat(
                this.point.lastValue, 0, '.', ','
            ) + ' tonnes<br>' +
            '<b>Difference: </b>' + Highcharts.numberFormat(
                this.point.diff, 0, '.', ','
            ) + ' tonnes<br>' +
            '<b>Variance: </b>' + Highcharts.numberFormat(
                this.point.variance, 0, '.', ','
            ) + '%<br>';
        }
    },

    series: [{
        name: 'Corn Production',
        borderWidth: 1,
        data: productionHeatmap(),
        turboThreshold: 1200,
        dataLabels: {
            enabled: true,
            color: '#000000',
            formatter: function () {
                return Math.abs(this.point.variance) >= 30 ? '🌽' : '';
            }
        }
    }]
});

const chart2 = Highcharts.chart('trade', {
    colors: [
        '#333399', '#333399',
        '#CCCCFF', '#CCCCFF',
        '#0093AF', '#0093AF',
        '#1F75FE', '#1F75FE',
        '#545AA7', '#545AA7',
        '#FDD023', '#FDD023',
        '#ffa500', '#ffa500',
        '#9C830A', '#9C830A',
        '#D6C05E', '#D6C05E',
        '#88CC88', '#88CC88',
        '#55AA55', '#55AA55',
        '#2D882D', '#2D882D',
        '#116611', '#116611',
        '#004400', '#004400',
        '#FFC0CB', '#FFC0CB',
        '#FA8072', '#FA8072',
        '#ED2939', '#ED2939',
        '#960018', '#960018',
        '#808080', '#808080',
        '#778899', '#778899',
        '#D2691E', '#D2691E',
        '#9F8170', '#9F8170'
    ],
    chart: {
        zooming: {
            type: 'xy'
        },
        type: 'column'
    },

    title: {
        text: '🌽 Corn Export vs Import 🌽'
    },

    subtitle: {
        text: '(drag to zoom 🔎)'
    },

    xAxis: {
        categories: [
            '1961', '1962', '1963', '1964', '1965', '1966', '1967', '1968',
            '1969', '1970', '1971', '1972', '1973', '1974', '1975', '1976',
            '1977', '1978', '1979', '1980', '1981', '1982', '1983', '1984',
            '1985', '1986', '1987', '1988', '1989', '1990', '1991', '1992',
            '1993', '1994', '1995', '1996', '1997', '1998', '1999', '2000',
            '2001', '2002', '2003', '2004', '2005', '2006', '2007', '2008',
            '2009', '2010', '2011', '2012', '2013'
        ]
    },

    yAxis: {
        allowDecimals: false,
        min: 0,
        title: {
            text: '🚜 Tonnes of Corn 🚜'
        }
    },
    legend: {
        align: 'center',
        x: 30,
        verticalAlign: 'bottom',
        y: 0,
        floating: false,
        backgroundColor: '#b49374',
        borderColor: '#CCC',
        borderWidth: 1,
        shadow: false
    },
    tooltip: {
        formatter: function () {
            return '<b>Region: </b>' + this.series.name + ' (' +
            this.series.options.stack + ') <br>' +
            '<b>Year: </b>' + this.x + ' <br>' +
            '<b>Value: </b>' + Highcharts.numberFormat(
                this.y, 0, '.', ','
            ) + ' tonnes<br>' +
            '<b>Total: </b>' + Highcharts.numberFormat(
                this.total, 0, '.', ','
            ) + ' tonnes<br>' +
            '<b>Percentage: </b>' + Highcharts.numberFormat(
                this.total === 0 ? 0 : this.y / this.total * 100,
                2,
                '.',
                ','
            ) + '%';
        }
    },
    plotOptions: {
        column: {
            stacking: 'normal'
        }
    },

    series: tradeData()
});
const toggle2 = function (idx, n) {
    const series = chart2.series[idx];
    const isVisible = series.visible;
    for (let i = 0; i < n; i++) {
        if (isVisible) {
            chart2.series[idx + i].hide();
        } else {
            chart2.series[idx + i].show();
        }
    }
};
const toggle3 = function (idx, n) {
    const series = chart.series[idx];
    const isVisible = series.visible;
    for (let i = 0; i < n; i++) {
        chart.series[idx + i].update({
            visible: !isVisible
        });
    }
};
const countries2 = {
    africa2: [0, 10],
    americas2: [10, 8],
    asia2: [18, 10],
    europe2: [28, 8],
    oceania2: [36, 8],
    legend2: [0, 1]

};
for (const [key, value] of Object.entries(countries2)) {
    document.getElementById(key).addEventListener('click', function () {
        if (key !== 'legend2') {
            toggle2(value[0], value[1]);
        } else {
            const legend = chart2.legend;
            if (legend.display) {
                legend.group.hide();
                legend.box.hide();
                legend.display = false;
            } else {
                legend.group.show();
                legend.box.show();
                legend.display = true;
            }
            chart2.redraw();
            toggle3(0, 1);
            toggle3(0, 1);
        }
    });
}

function tradeData() {
    return [{
        name: 'Eastern Africa',
        stack: 'export',
        data: [
            290035, 465779, 241742, 74732, 68072, 318059, 757699, 803612,
            607051, 305232, 248362, 647945, 684235, 554053, 988333, 469238,
            431488, 638646, 362914, 68747, 243508, 373455, 768527, 225273,
            289493, 792053, 782520, 602750, 364727, 1029727, 560641, 95687,
            475363, 1492325, 509642, 519792, 468452, 510960, 205440, 157938,
            78592, 269116, 286884, 253044, 221702, 261195, 802438, 303246,
            102153, 265439, 1002736, 1119514, 376839
        ]
    }, {
        name: 'Eastern Africa',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            173390, 149020, 88121, 122036, 154747, 242180, 8123, 15949,
            118703, 215144, 371929, 205208, 37999, 269382, 379072, 167715,
            99586, 101835, 298323, 1247089, 690095, 564621, 448562, 1224135,
            987895, 305404, 451917, 715268, 585296, 509068, 596334, 3550652,
            2062472, 1828767, 937445, 592804, 1605158, 1782575, 642776,
            781752, 811482, 1774490, 1284102, 1240731, 890293, 1599941,
            862395, 1279002, 2859921, 862680, 1136886, 1339561, 895999
        ]
    }, {
        name: 'Middle Africa',
        stack: 'export',
        data: [
            161600, 116738, 86223, 104509, 111931, 64736, 100771, 153325,
            177395, 171762, 97053, 76686, 120051, 65127, 1, 64, 21, 14, 3,
            501, 19, 103, 0, 49, 270, 378, 197, 197, 200, 100, 4, 0, 186,
            8, 30, 63, 47, 68, 78, 104, 0, 0, 131, 17513, 121, 71, 0, 0,
            91171, 96008, 46372, 1299, 225
        ]
    }, {
        name: 'Middle Africa',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            3320, 9044, 63088, 74262, 47776, 76390, 70800, 59657, 46280,
            66261, 82210, 106525, 152557, 217183, 242088, 204336, 233721,
            283620, 276271, 295888, 455960, 246932, 184438, 224181, 186763,
            125365, 181777, 148961, 116318, 200814, 140170, 148374, 138666,
            286593, 203710, 253151, 114519, 127702, 107659, 151425, 215334,
            177368, 179175, 121386, 130329, 80062, 33297, 54188, 105444,
            67218, 38960, 56354, 108607
        ]
    }, {
        name: 'Northern Africa',
        stack: 'export',
        data: [
            14622, 27568, 110166, 53834, 61977, 17783, 624, 313, 34080, 8708,
            0, 0, 10, 587, 0, 0, 0, 0, 15, 0, 4, 0, 0, 0, 0, 20, 74, 0, 5474,
            78, 3, 28581, 38434, 7838, 13085, 1391, 2634, 24247, 350, 40776,
            62561, 95459, 73367, 72007, 15035, 4875, 8408, 5477, 21341, 9753,
            48535, 67688, 41354
        ]
    }, {
        name: 'Northern Africa',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            108568, 278189, 180112, 429303, 165119, 190485, 259014, 154627,
            55727, 97768, 71442, 162556, 166634, 472524, 529204, 629810, 918138,
            1145975, 928752, 994905, 2065885, 2245154, 2310539, 2579232,
            3091737, 3716184, 3781317, 2869795, 3449198, 3600030, 2786965,
            3104267, 4156825, 4199533, 4428321, 4205734, 5142155, 5327384,
            8935515, 8090747, 8478058, 9017985, 7519283, 6525364, 10321675,
            8661551, 10574455, 9172863, 10449247, 12297419, 12937392,
            12636530, 12323569
        ]
    }, {
        name: 'Southern Africa',
        stack: 'export',
        data: [
            1071200, 2070000, 2499200, 1418963, 326636, 46119, 2004010,
            2955570, 760669, 1200981, 1467660, 3155354, 1316671, 2158780,
            3224268, 2227031, 1900700, 2808936, 2153144, 3317301, 4400100,
            3902970, 1310105, 40119, 379541, 1775031, 2490267, 340218,
            2933090, 2001452, 375280, 524016, 218341, 3761340, 1508956,
            1949613, 1696454, 898544, 422024, 619300, 623200, 755328,
            789603, 457054, 2131819, 630619, 73113, 1078993, 1659891,
            1239271, 2563706, 1023093, 2609209
        ]
    }, {
        name: 'Southern Africa',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            28100, 24115, 24400, 23115, 28061, 313120, 58851, 28447, 337440,
            223771, 26678, 34539, 28892, 22857, 34659, 65938, 117158, 54049,
            68742, 82685, 79268, 90818, 1390154, 2820028, 544374, 332783,
            231811, 255637, 169240, 156320, 412999, 4001345, 1189870,
            338068, 1056501, 964748, 520838, 426684, 699421, 544912,
            439551, 1306903, 791316, 872084, 440456, 1336845, 1553962,
            529137, 421260, 321143, 430902, 665050, 572172
        ]
    }, {
        name: 'Western Africa',
        stack: 'export',
        data: [
            0, 400, 900, 103, 174, 182, 5763, 1312, 157, 249, 1844, 1198,
            3119, 6211, 14787, 366, 1646, 4384, 632, 342, 1024, 6575, 3388,
            37008, 61718, 20145, 26779, 20004, 30000, 33002, 30133, 186, 408,
            4790, 22679, 26307, 16447, 67227, 17783, 64768, 71206, 86242,
            16862, 69299, 12813, 34923, 47023, 7407, 16212, 70469, 32626,
            89934, 66141
        ]
    }, {
        name: 'Western Africa',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            19914, 19858, 27693, 22947, 27222, 23927, 26195, 17335, 95263,
            52213, 87106, 117841, 157406, 227054, 91467, 98417, 197401, 305687,
            204662, 315972, 400034, 543285, 260424, 276314, 346431, 161445,
            81961, 113011, 56582, 83444, 117968, 141135, 133490, 72581,
            124387, 98842, 196992, 306168, 163125, 179522, 217571, 278302,
            246570, 277778, 338481, 336375, 241765, 248411, 269489, 207756,
            178714, 428697, 253125
        ]
    }, {
        name: 'Northern America',
        stack: 'export',
        data: [
            7454435, 10831185, 11147123, 12184882, 15187822, 15557276,
            12938194, 14961000, 13968287, 14411666, 12918164, 22409435,
            33215438, 29874777, 33525886, 44692118, 40579933, 50550074,
            59413645, 63923442, 56066637, 49658001, 48083277, 49583871,
            44345021, 27473085, 41097283, 46815393, 56544098, 52293908,
            45292816, 43634372, 40721613, 36258088, 60683612, 52922700,
            42054901, 42384151, 52864588, 48244641, 48092974, 47940749,
            43679456, 49089254, 45633917, 58109332, 57500206, 54977629,
            48045456, 51762994, 46958064, 32234094, 25944386
        ]
    }, {
        name: 'Northern America',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            607188, 917289, 607246, 551625, 485729, 538640, 759926, 812516,
            691259, 547007, 249378, 447911, 824976, 1320034, 817679, 838244,
            623344, 476475, 848531, 1227961, 1276123, 806840, 351858, 541088,
            567261, 937471, 348078, 526672, 968939, 712664, 505162, 1120949,
            1188427, 1134237, 1346367, 1256524, 1300956, 1516750, 1448668,
            1823569, 3456969, 4317494, 4077658, 2380513, 2436573, 2103425,
            2913528, 3242079, 2225301, 1963739, 1716842, 2457149, 4197854
        ]
    }, {
        name: 'Central America',
        stack: 'export',
        data: [
            23973, 46104, 26378, 336297, 1413753, 905505, 1291995, 944687,
            822065, 40739, 338824, 465201, 31227, 7335, 11067, 22827, 7881,
            2049, 5134, 35883, 16606, 27407, 27432, 12805, 48486, 6578, 9105,
            6953, 5333, 1976, 16781, 27944, 51760, 47910, 139662, 108512,
            232835, 254687, 71256, 24957, 25168, 172003, 24899, 24009,
            68188, 192349, 280913, 84691, 301625, 583507, 146063, 804800,
            617427
        ]
    }, {
        name: 'Central America',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            55506, 160989, 511573, 117803, 99365, 79707, 51217, 97804,
            46375, 813745, 83133, 288566, 1365595, 1426872, 2796114, 951802,
            1818912, 1674840, 856308, 4089923, 3234724, 539683, 5024621,
            2679960, 1894852, 1872478, 3845360, 3594649, 4031921, 4619580,
            2015832, 1794549, 731375, 3647675, 3670042, 6867461, 3804889,
            6394518, 6737829, 6897032, 8166922, 7560149, 7766579, 7627088,
            7954735, 10189443, 10702151, 11616164, 9785482, 10414906,
            12296490, 12089622, 9626067
        ]
    }, {
        name: 'Caribbean',
        stack: 'export',
        data: [
            17181, 13468, 3314, 73, 2851, 4413, 181, 1153, 281, 384, 527,
            744, 3018, 3215, 58, 85, 127, 280, 637, 444, 431, 206, 54, 36, 20,
            18, 104, 141, 385, 840, 1609, 716, 1208, 76, 129, 10, 27, 41,
            177, 186, 906, 201, 1583, 2471, 15581, 8775, 2025, 670, 10368,
            6181, 379, 2786, 2029
        ]
    }, {
        name: 'Caribbean',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            66988, 131212, 119810, 285563, 226298, 261891, 261986, 252323,
            227778, 294596, 329267, 363136, 469190, 549094, 636233, 766070,
            689435, 882496, 674321, 1226713, 1055835, 844313, 877913, 974658,
            855988, 863935, 1175242, 1322957, 1404353, 1330003, 871150,
            956179, 1172045, 942593, 1263805, 1196025, 1239888, 1039063,
            1229025, 1357287, 1473080, 1624870, 1590143, 1565831, 1936122,
            2227760, 2210201, 2068279, 1898082, 2176503, 2128069,
            2074069, 2066875
        ]
    }, {
        name: 'South America',
        stack: 'export',
        data: [
            1745767, 2940206, 3153693, 3411809, 3373023, 4381812, 4759205,
            4136417, 4701876, 6740508, 7424467, 3178566, 4078065, 6654447,
            5077169, 4536637, 6856074, 5922382, 5978477, 3517649, 9181069,
            5809249, 7293391, 5719479, 7079069, 7415083, 3991253, 4228412,
            1935255, 3031332, 3916715, 6130134, 4919630, 4322058, 6346154,
            7039068, 11729957, 12789169, 8226178, 11208589, 17285113,
            12420774, 16441101, 16208233, 16299751, 16379068, 28258076,
            23005677, 18361244, 30094135, 26932394, 40491743, 49934554
        ]
    }, {
        name: 'South America',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            111475, 76429, 11386, 255120, 69409, 68105, 51614, 279466,
            383806, 299087, 244050, 133824, 486592, 592815, 444357, 700258,
            1061027, 2136716, 2394256, 3894305, 2725393, 2004528, 2299932,
            1798082, 1272255, 2926610, 1560211, 933999, 515897, 1974701,
            1989565, 3126816, 4015451, 4701120, 5092312, 4354397, 5363959,
            7333234, 6213883, 7574518, 5531632, 5350584, 5795402, 5407396,
            6209282, 8189792, 8976954, 8605254, 8713690, 9015342,
            8375146, 9720899, 10382693
        ]
    }, {
        name: 'Central Asia',
        stack: 'export',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3456, 11659, 32020, 14635,
            8672, 6625, 13410, 13990, 9479, 28854, 13984, 4265, 13391, 3064,
            1126, 4575, 8206, 11611, 12469, 6219
        ]
    }, {
        name: 'Central Asia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 779900, 238058, 15585, 10476, 14088,
            20109, 7503, 5456, 10002, 11063, 4219, 3745, 3389, 3320, 2526,
            4773, 1768, 7721, 2617, 5559, 2280, 2009
        ]
    }, {
        name: 'Eastern Asia',
        stack: 'export',
        data: [
            34650, 42814, 174300, 214203, 254905, 177856, 86225, 74703,
            43117, 14331, 105872, 110254, 68227, 130216, 315308, 432554,
            356405, 230443, 241486, 105929, 143393, 78198, 78041, 963266,
            6350142, 5642803, 3917143, 3912504, 3505451, 3405900, 7787013,
            10340661, 11138025, 8751322, 112843, 159009, 6617550, 4687441,
            4305140, 10466099, 6020615, 11678010, 16399511, 2318326,
            8611627, 3071122, 4916885, 252746, 129689, 127494, 136183,
            257519, 77750
        ]
    }, {
        name: 'Eastern Asia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            2517800, 3030800, 3240100, 3741724, 3816300, 3929996, 4488957,
            5779258, 6191104, 7047767, 6193535, 8303059, 10655670, 10432900,
            9763372, 11590649, 12728909, 15624079, 19808103, 19875359,
            20196944, 20858459, 24641105, 20475928, 20990540, 22265519,
            26599573, 26410016, 27736642, 27931351, 27895836, 28986982,
            29444633, 27537976, 37471114, 31208251, 30866499, 28806273,
            30047543, 30522725, 30547683, 31060287, 31320208, 30065924,
            30657664, 30947867, 29858927, 29962007, 28468756, 31456218,
            29121729, 32959793, 30788913
        ]
    }, {
        name: 'Southern Asia',
        stack: 'export',
        data: [
            0, 0, 0, 0, 12, 0, 3020, 1975, 2964, 22, 1470, 2533, 751, 89,
            6494, 7163, 4433, 4018, 4452, 2254, 17773, 16186, 3209, 5559,
            32790, 13411, 5520, 50, 1188, 118, 1876, 432, 26679, 18907,
            18751, 55464, 1816, 2304, 10623, 34466, 113722, 78178, 543445,
            1068753, 420020, 638372, 2735027, 3541528, 2685575, 2523147,
            4201542, 4637512, 4878350
        ]
    }, {
        name: 'Southern Asia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            125042, 96586, 86521, 128595, 178894, 71966, 337987, 111498,
            22189, 20963, 73282, 75360, 144394, 232236, 80334, 229991, 385744,
            387751, 701774, 670453, 897465, 665775, 984076, 722632, 965775,
            974696, 915702, 662895, 1188972, 984498, 1273378, 1218968,
            809185, 797722, 1245015, 987733, 1619092, 924312, 1487854,
            1621696, 2101038, 1652706, 3581709, 2179935, 2548002, 2914480,
            3202238, 3360937, 4471965, 6670432, 4414577, 5128419, 4678606
        ]
    }, {
        name: 'South-Eastern Asia',
        stack: 'export',
        data: [
            731152, 656102, 907895, 1301446, 937453, 1503886, 1384513,
            1708510, 1768589, 1779290, 2148860, 1947074, 1623195, 2550921,
            2269732, 2473654, 1762077, 2194002, 2140340, 2338159, 2701148,
            3031665, 2871117, 3555844, 2944757, 4122151, 1833692, 1534834,
            1752194, 1527673, 1493497, 481751, 496970, 405649, 350521,
            446678, 212297, 979512, 288877, 232543, 732964, 416696,
            378460, 1426755, 354369, 608340, 739164, 1353352, 1486017,
            1019498, 763634, 480376, 921145
        ]
    }, {
        name: 'South-Eastern Asia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            171791, 255797, 352434, 327828, 278664, 397088, 381911, 465688,
            505270, 474798, 523807, 762178, 672966, 750016, 876533, 897023,
            1181346, 1332565, 1335176, 1483652, 1392945, 1866963, 2066511,
            1772336, 1979467, 1635989, 1967638, 1895021, 1979104, 2024292,
            1954181, 2482222, 2776680, 3157549, 3953820, 3655944, 4478669,
            3013867, 3307169, 4553283, 3316960, 4215756, 5190373, 4509125,
            3169285, 5801477, 4162921, 3531916, 5069503, 6790965,
            7251713, 6732358, 9798391
        ]
    }, {
        name: 'Western Asia',
        stack: 'export',
        data: [
            4627, 1319, 2029, 2541, 3040, 3970, 2764, 1942, 1482, 1693,
            3119, 6837, 3437, 2028, 1605, 14547, 7560, 42785, 110886, 154928,
            40438, 53830, 10340, 7021, 11960, 7541, 13493, 21294, 23792,
            22273, 12617, 18685, 85419, 83448, 6028, 8563, 15413, 19714,
            12099, 114480, 128006, 24238, 48110, 22177, 153569, 259998,
            57864, 122163, 432041, 114360, 82357, 136904, 323103
        ]
    }, {
        name: 'Western Asia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            229723, 239942, 283922, 284108, 264659, 333558, 270596, 273282,
            269977, 285415, 320031, 403775, 362519, 317535, 548587, 585904,
            892929, 1096426, 1427871, 1991035, 2062336, 2087628, 1879439,
            2059339, 1933955, 2002530, 2253073, 2330176, 2772121, 2522417,
            1569141, 2261293, 3218363, 2177436, 3806106, 3955466, 4282450,
            4308643, 4530840, 5642274, 4634094, 5722560, 6273357, 5360978,
            5910003, 5731731, 7582400, 6865259, 7237100, 7477228, 6996742,
            7189414, 8282311
        ]
    }, {
        name: 'Eastern Europe',
        stack: 'export',
        data: [
            1362521, 2335170, 1787002, 1939007, 1376358, 828807, 1595398,
            735332, 1543606, 1116442, 883617, 946018, 1569564, 1726952,
            983119, 1535743, 1278129, 1459165, 536988, 1296759, 1062831,
            904949, 876292, 681211, 1185544, 986881, 902537, 748862, 509197,
            478228, 546162, 2751061, 315609, 397309, 998961, 511526,
            1476065, 3693117, 2793738, 1724964, 2096449, 3110292, 2940657,
            3231434, 6242941, 5770178, 7133826, 7930967, 16054458,
            10457812, 16515323, 27322019, 28506490
        ]
    }, {
        name: 'Eastern Europe',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            400003, 921657, 664798, 876348, 1050207, 787650, 738594, 953592,
            1059706, 684072, 1845233, 5056356, 6727049, 5595736, 7332562,
            15215432, 6552592, 17489481, 19077156, 15806574, 20657006,
            13900247, 7196727, 13200942, 19522362, 9164699, 10370073,
            12275216, 21187483, 14560981, 13699356, 8192952, 7649924,
            1252624, 781812, 1170729, 1020482, 818140, 1103755, 1571925,
            1143849, 886311, 816413, 1451345, 585890, 812757, 2091996,
            2416364, 1634700, 1274878, 1508804, 1875068, 1094023
        ]
    }, {
        name: 'Northern Europe',
        stack: 'export',
        data: [
            2765, 4854, 4496, 4442, 7537, 13000, 15234, 15802, 13011, 16007,
            16371, 6026, 15003, 22469, 65723, 44235, 32248, 26214, 23228,
            18428, 13638, 13807, 11450, 12638, 7208, 13454, 19994, 7532,
            26496, 16570, 15219, 19745, 14610, 23201, 14869, 41807, 14875,
            9574, 12885, 25026, 13083, 17334, 19037, 31865, 19617, 40563,
            37423, 72186, 26018, 44692, 107099, 78464, 207679
        ]
    }, {
        name: 'Northern Europe',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            3625013, 5211576, 3879402, 3892145, 3734036, 3796603, 4220070,
            4291445, 3611168, 3680578, 3457351, 3874520, 4063596, 4079998,
            3826337, 4497224, 4793110, 3857954, 3715406, 3357747, 2753843,
            2773066, 2230451, 1815808, 1658758, 1644192, 1629643, 1454525,
            1589553, 1753839, 1638998, 1992098, 1652773, 1844948, 1746721,
            1616254, 1787661, 1633619, 1589440, 1631035, 1871075, 1863135,
            1862157, 1657690, 1581941, 1493677, 1904489, 2204194, 1448925,
            1523420, 1535758, 2083784, 3449919
        ]
    }, {
        name: 'Southern Europe',
        stack: 'export',
        data: [
            377987, 36054, 212130, 233906, 728757, 544726, 806022, 395938,
            323924, 312381, 73749, 53386, 283702, 294580, 62565, 462601,
            381681, 223712, 47413, 330620, 343155, 394638, 1457434, 864844,
            1637097, 2785421, 2188502, 1036938, 1197343, 448750, 824257,
            2248024, 679998, 367382, 197679, 483628, 577902, 1004084,
            495818, 581264, 445416, 848130, 483712, 689349, 1488806,
            1766131, 878632, 1217062, 2415674, 2405804, 2287793, 2755148,
            1295810
        ]
    }, {
        name: 'Southern Europe',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            2165223, 3250961, 4911583, 4990019, 7061153, 8435583, 8337931,
            7834923, 7387928, 6650539, 7886246, 8568406, 9017923, 10443701,
            10939714, 10047863, 10418724, 11067097, 12269580, 11353713,
            10714475, 10247057, 8716247, 6569853, 6623501, 4194775, 3554464,
            4880965, 2904393, 5185333, 3591792, 4066754, 4192946, 4337293,
            5062454, 4132774, 4725525, 5180587, 6372849, 5940314, 5966411,
            6610883, 7020429, 6636315, 7942834, 8217198, 12367473,
            10488978, 8364317, 8582687, 10184794, 11206087, 12182303
        ]
    }, {
        name: 'Western Europe',
        stack: 'export',
        data: [
            705929, 318250, 723500, 1035100, 1166848, 1553169, 1960588,
            2124824, 2904687, 3554769, 5210279, 4533215, 5314343, 5695271,
            5537602, 5369420, 4083061, 4652986, 4996817, 5155051, 4451531,
            5335009, 6254528, 6944997, 5383879, 6511042, 7320432, 7203224,
            8593596, 7720388, 5270872, 7520241, 8612315, 9182366, 7299775,
            7454442, 7935923, 8735311, 8995142, 8747940, 7960206, 9473588,
            8529575, 7672988, 8809428, 7665486, 6549445, 8120429, 8457513,
            7889093, 8060416, 8829191, 8295728
        ]
    }, {
        name: 'Western Europe',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            3845400, 4890000, 5384900, 5930100, 6341700, 6765462, 7179636,
            7023983, 5924108, 7525687, 8921621, 8767292, 10665472, 11146056,
            12347759, 14260886, 12472482, 11074234, 10344883, 11907194,
            10109788, 9446279, 8601586, 7954519, 7253414, 5715326, 5720140,
            6432833, 6431012, 5310908, 4739489, 4232563, 3945367, 4869892,
            4657355, 4293149, 4158766, 3715626, 3687372, 3194354, 3569413,
            4166019, 4366963, 4797236, 5042278, 5332453, 8324009,
            7479011, 6743465, 6622922, 8054622, 9166491, 9417797
        ]
    }, {
        name: 'Australia & New Zealand',
        stack: 'export',
        data: [
            107, 400, 10004, 403, 502, 28, 2052, 2561, 188, 684, 22377,
            38472, 18700, 2720, 1420, 87934, 79303, 31932, 74903, 36901,
            51560, 24008, 72500, 55905, 185676, 117283, 103169, 28649, 9791,
            26474, 15244, 19422, 24293, 23793, 9931, 20330, 15127, 22073,
            41771, 52697, 51223, 74732, 24209, 14895, 6525, 4396, 1863,
            24055, 21563, 13720, 47364, 105651, 117557
        ]
    }, {
        name: 'Australia & New Zealand',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            60, 500, 1244, 680, 27, 1112, 2287, 2350, 708, 597, 1710, 629,
            630, 968, 1198, 616, 2106, 2712, 3108, 4011, 4609, 10687, 13810,
            9438, 10805, 9053, 8915, 5781, 15618, 41327, 22264, 162, 15457,
            20377, 17548, 22763, 7649, 1910, 14069, 7210, 18319, 24766,
            64553, 9043, 1142, 1211, 9043, 1117, 1525, 1504, 6864, 2504,
            1710
        ]
    }, {
        name: 'Melanesia',
        stack: 'export',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 9, 1, 2, 0, 3, 0, 37, 133, 69, 15, 6, 1,
            3, 12, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 120,
            1, 0, 4, 4, 3, 0, 0, 6, 0, 10, 1, 24
        ]
    }, {
        name: 'Melanesia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            27, 44, 36, 16, 18, 25, 137, 111, 70, 71, 157, 15, 632, 30,
            1097, 2123, 3692, 6716, 9227, 10791, 12579, 13710, 21207, 6590,
            11325, 14563, 11777, 5814, 5176, 4982, 7497, 9870, 5822, 2521,
            22546, 7075, 2994, 3803, 3066, 1137, 584, 1461, 2899, 504, 1125,
            760, 495, 2007, 2933, 2202, 3871, 4034, 3565
        ]
    }, {
        name: 'Micronesia',
        stack: 'export',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        ]
    }, {
        name: 'Micronesia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            180, 200, 200, 247, 282, 300, 300, 300, 300, 250, 300, 455, 300,
            300, 0, 0, 172, 240, 570, 2400, 2000, 1000, 800, 1000, 1000, 1000,
            1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1129, 1000, 1000,
            1001, 1005, 1000, 1000, 1022, 1000, 1000, 1000, 1002, 1001,
            1001, 0, 1, 2, 4, 4
        ]
    }, {
        name: 'Polynesia',
        stack: 'export',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        ]
    }, {
        name: 'Polynesia',
        linkedTo: ':previous',
        stack: 'import',
        data: [
            6, 9, 12, 10, 9, 4, 6, 16, 2, 1, 24, 2, 1, 1, 5, 5, 12, 181,
            792, 3538, 7452, 6327, 6028, 8100, 7865, 7554, 8023, 6751, 6600,
            5830, 2770, 5021, 4321, 6247, 5534, 6621, 6278, 5876, 5897, 5816,
            5495, 5204, 5547, 4426, 5012, 5120, 5315, 5129, 3961, 4189,
            3459, 3246, 2407
        ]
    }];
}

function productionData() {
    return [{
        name: 'Eastern Africa',
        data: [
            5689834, 5741847, 5706347, 5971416, 6314679, 6541392, 7748462,
            7097886, 7858678, 6607280, 8230379, 9353871, 8120498, 9401446,
            9770528, 11592761, 11172585, 10486589, 9576104, 9648920, 10866275,
            10591102, 10155329, 9654463, 12367842, 12765028, 11280865,
            14371512, 14516708, 13007348, 11846963, 9000735, 13335962,
            12203355, 13006934, 16224347, 13880099, 13892347, 15342283,
            15372862, 15737905, 15439273, 15554614, 17597443, 15978594,
            19664223, 19086970, 20755732, 20793469, 26195794, 27878009,
            27847501, 27943639, 31720698
        ]
    }, {
        name: 'Middle Africa',
        data: [
            1219400, 1189400, 1144000, 1183800, 1189800, 1163620,
            1183730, 1265140, 1441816, 1362758, 1355032, 1368900,
            1408220, 1454275, 1687820, 1502549, 1405649, 1375026,
            1370811, 1452954, 1419848, 1514541, 1528633, 1425486,
            1429347, 1630878, 1665285, 1686781, 1674734, 1667114,
            1954099, 2084220, 2067340, 2170307, 2010567, 2441160,
            2515445, 2818333, 2635653, 2519253, 2583075, 2793527,
            2965309, 2973484, 3319276, 3290109, 3480307, 3673463,
            4163997, 4302599, 4401980, 4138736, 5183562, 5169779
        ]
    }, {
        name: 'Northern Africa',
        data: [
            1762019, 2443935, 2376819, 2367845, 2489254, 2610409, 2547439,
            2703872, 2841649, 2766300, 2753781, 2805625, 2768882, 3080808,
            3209112, 3578406, 2955230, 3556539, 3294774, 3609184, 3431917,
            3625617, 3797160, 3992281, 4027176, 3953052, 3886900, 4478610,
            4965240, 5261886, 5518670, 5336673, 5172024, 5363196, 4607431,
            5455274, 6233487, 6580512, 6318477, 6629786, 6203225, 6685179,
            6724488, 6524549, 7150058, 6786206, 6412794, 7588377, 7960136,
            7358508, 7143206, 8239522, 8121851, 5951392
        ]
    }, {

        name: 'Southern Africa',
        data: [
            5453607, 6196210, 6295751, 4472297, 4773276, 5343528, 9998129,
            5546997, 5573800, 6333209, 8862295, 9738591, 4407134, 11382696,
            9358903, 7754228, 10052096, 10488497, 8697397, 11285953, 15124780,
            8960695, 4547571, 5059644, 8718352, 8813095, 8092866, 7988856,
            12756921, 9496134, 8787882, 3444760, 10201096, 13559354, 5115105,
            10522166, 10487885, 7949856, 8217257, 11691659, 8045402, 10298996,
            9886877, 9894926, 11926030, 7179013, 7269163, 12886731, 12241546,
            13103470, 10597830, 12023999, 12734715, 15246623
        ]
    }, {
        name: 'Western Africa',
        data: [
            2022383, 2000826, 2126736, 2176529, 2179719, 2243597, 2249409,
            2316322, 2410128, 2810320, 2644019, 1803266, 2065430, 1905711,
            2602474, 2179606, 1848786, 2000667, 1958351, 2134165, 2368494,
            2357880, 2456919, 3435085, 4090422, 5667611, 6663205, 7917749,
            7670586, 8254032, 8755252, 8663051, 9556692, 10221695, 10210881,
            9132842, 9018920, 8872692, 9886076, 8073254, 8815204, 9579724,
            10449128, 10625583, 11602625, 12603671, 11879750, 14048699,
            14728992, 15310591, 16218670, 17569672, 16877704, 19527545
        ]
    }, {
        name: 'Northern America',
        data: [
            92129912, 92452368, 103012118, 89846189, 105728237, 107546206,
            125341280, 115099195, 120938811, 108104797, 146366588, 144261677,
            146845141, 122040020, 152005938, 163510684, 169483944, 189092508,
            206659108, 174400208, 212904600, 215702300, 111961000, 201657500,
            232422908, 214854508, 188156800, 130563200, 197890008, 208598000,
            197279496, 245601608, 167486192, 262335892, 195239892, 242063408,
            241047008, 256834400, 248710292, 258805910, 249764235, 236764157,
            265814604, 308710363, 291592862, 276490856, 342823772, 317734010,
            342109810, 327879430, 324623473, 286880166, 367893241, 372577940
        ]
    }, {
        name: 'Central America',
        data: [
            7469003, 7671734, 8230388, 9925690, 10455222, 10808464, 10137867,
            10733198, 10151952, 10746689, 11632601, 10867793, 10497456, 9679277,
            10516501, 9969056, 12160856, 13198435, 10600448, 14524376, 16320186,
            12355044, 15484176, 15134773, 16552483, 14449372, 14344502,
            13325816, 13791875, 17545741, 16945329, 19991191, 21091434,
            20893980, 21230716, 20853460, 20074641, 20980693, 20308690,
            20283151, 22862524, 22112772, 23620703, 24413075, 22306416,
            24948428, 26937179, 27849289, 23879373, 26875712, 21274560,
            25918729, 26698843, 26944837
        ]
    }, {
        name: 'Caribbean',
        data: [
            399581, 394763, 389952, 388373, 379473, 385754, 389657, 361901,
            379872, 381467, 403007, 409963, 349897, 366654, 339829,
            359924, 346053, 338196, 330254, 330348, 322788,
            303874, 330218, 38592, 369252, 359683, 354862, 364693,
            340236, 279857, 300431, 350417, 332173, 371291, 381349, 406259,
            483183, 432417, 524169, 504867, 521697, 526108, 593421, 641667,
            609668, 548946, 676269, 571139, 651649, 709471, 758589,
            613338, 817001, 792990
        ]
    }, {
        name: 'South America',
        data: [
            16314418, 17323969, 17318192, 17573698, 20204233, 21477754,
            24619722, 22479692, 22625311, 26969852, 27412929, 23855674,
            26973049, 29533105, 27416694, 27058951, 31222188, 26613799,
            28609750, 30203374, 37738912, 35141301, 31153347, 34748816,
            38314330, 37463130, 40999380, 39020645, 36719474, 31810477,
            36589399, 46147354, 46453686, 48395304, 53524180, 48327257,
            54645156, 54524968, 51395348, 55427462, 64628023, 57804619,
            71807779, 65622587, 64738469, 67462252, 84623736, 93135669,
            74407443, 89790681, 91468649, 108004751, 127203195,
            126134176
        ]
    }, {
        name: 'Central Asia',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1209178, 1189900, 807200, 578422,
            546074, 456581, 562037, 717763, 765925, 942468, 1026291, 1097239,
            1195101, 1205558, 1200692, 1233873, 1262388, 1348151, 1302539,
            1356541, 1619671, 1691915, 1794463
        ]
    }, {
        name: 'Eastern Asia',
        data: [
            19404253, 17712402, 22168466, 24355612, 25121319, 30749939,
            32473982, 30552885, 30187062, 34793316, 37665959, 33852532,
            40575175, 45016398, 49426066, 50544842, 51885836, 58564356,
            62792515, 65572712, 62254718, 63697517, 71507153, 76985162,
            67535637, 74691575, 83230172, 81430415, 83231832, 101334558,
            103423162, 99583780, 107129606, 103310116, 113802336,
            128762830, 105748650, 135043045, 129601708, 107283708,
            115794165, 123221298, 117793293, 132239063, 141202099,
            153546211, 154089538, 167536477, 165889700, 179298290,
            194835009, 207842664, 220704550, 218488298
        ]
    }, {
        name: 'Southern Asia',
        data: [
            6421214, 6709862, 6728955, 6849137, 7025478, 7114060, 8681185,
            7974133, 8037238, 9818133, 7348008, 8739067, 8265873, 8045975,
            9750449, 8897971, 8442604, 8674798, 7969285, 9582424, 9423172,
            9067409, 10538337, 11062974, 9219240, 10289781, 8398311,
            11077643, 12614632, 12063894, 11153689, 13037729, 12788389,
            12581986, 13522639, 14703365, 14977830, 15572934, 16008693,
            16425571, 17686055, 16312707, 20510507, 21250150, 22337922,
            23093761, 28145025, 28892254, 24774977, 30840698, 31609059,
            32340535, 34156269, 35404876
        ]
    }, {
        name: 'South-Eastern Asia',
        data: [
            4711540, 5759485, 5067777, 6639631, 5319340, 6823615, 5727207,
            6760169, 6508551, 7275150, 7396364, 5859575, 8775094, 8540129,
            8952665, 8623113, 8259163, 10554998, 10243892, 10881051,
            12054461, 10183012, 12905920, 13941813, 14224852, 15348416,
            13160073, 16946481, 16329662, 16443865, 15821398, 17479676,
            15908068, 17038907, 18233026, 20108230, 19156241, 20787468,
            20490770, 21453328, 21488328, 21704761, 24180305, 25796377,
            27349327, 27506277, 30660676, 35131115, 37126445, 37538742,
            37830962, 40439298, 39884977, 40631165
        ]
    }, {
        name: 'Western Asia',
        data: [
            1064101, 846897, 1034132, 1040626, 983730, 1038776, 1086765,
            1033927, 1034650, 1076509, 1197160, 1094038, 1193522, 1304159,
            1321298, 1488213, 1482060, 1503846, 1520348, 1416923, 1371826,
            1541653, 1614944, 1670660, 2168812, 2589616, 2674395, 2323980,
            2405179, 2624748, 2790297, 3116458, 3401670, 2697923, 2734804,
            3032698, 3219960, 3345189, 3346372, 3134421, 3207571, 3275121,
            4042078, 4386358, 5592312, 5029556, 4905702, 5707077,
            5467601, 5313707, 5588181, 6116970, 7745121, 7825561
        ]
    }, {
        name: 'Eastern Europe',
        data: [
            27508049, 25722273, 23071835, 26631621, 19160035, 23091160,
            22006426, 21980814, 27371180, 22936467, 24234665, 28826197,
            26695586, 28009700, 27484309, 30638501, 30658496, 28299842,
            31891856, 29748811, 27908829, 37655287, 33915188, 34140970,
            35659532, 34593791, 32732242, 32225357, 32572043, 23171863,
            32006788, 19585387, 21693337, 19350727, 23480805, 21874290,
            32545321, 21770911, 25419477, 18793319, 25981986, 26107736,
            28692483, 42970863, 36760003, 32970312, 23421396, 42180348,
            36416169, 38412204, 59300676, 49229352, 71762060, 73540472
        ]
    }, {
        name: 'Northern Europe',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 2000, 5000, 6000, 6000, 3000, 3000,
            2000, 3000, 2000, 895, 785, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 8300, 2700, 3000, 4900, 4700, 26000,
            32000, 23800, 93200, 127200, 153900, 202900, 187900
        ]
    }, {
        name: 'Southern Europe',
        data: [
            10571090, 10387988, 11213263, 13150877, 11245759, 13749035,
            13454250, 13437106, 15065694, 14901833, 15393041, 15976059,
            16660796, 16226700, 17705900, 17185310, 19465493, 17078491,
            20076130, 20095000, 21398540, 22615185, 21806390, 23516614,
            22403019, 25319794, 21530798, 20728564, 22308983, 18535335,
            24139904, 20014368, 19125954, 20133427, 22262452, 24756762,
            28235142, 25148627, 26679969, 22678205, 28120516, 27706424,
            22854316, 29933381, 28481655, 25522830, 23030471, 26662480,
            24656346, 25109432, 26762396, 21314622, 25207883, 28703509
        ]
    }, {
        name: 'Western Europe',
        data: [
            2716061, 2121297, 4136593, 2407054, 3774243, 4765411, 4690865,
            6105104, 6876073, 8692372, 10406590, 9675104, 12423295, 10241154,
            9907729, 7191093, 10392694, 11463434, 12679463, 11424314,
            11532907, 13232309, 13092523, 13241291, 15552925, 14917173,
            15559384, 18250219, 16726984, 12891095, 16771600, 18501409,
            19499147, 17223466, 16943239, 19515157, 22185237, 20230251,
            21029297, 22035762, 22615389, 22888148, 18053992, 23616912,
            20879494, 18378541, 20972332, 24355717, 22935213, 21305749,
            24767749, 24521356, 22195644, 26994177
        ]
    }, {
        name: 'Australia & New Zealand',
        data: [
            168892, 199456, 204885, 189643, 198279, 144278, 208770, 217051,
            200158, 250224, 313178, 330153, 256307, 194104, 290899, 315935,
            354596, 304643, 347798, 307364, 324880, 382468, 281894, 392474,
            466034, 465400, 382553, 345174, 355378, 380381, 377089, 432789,
            331866, 346895, 403167, 534700, 592000, 447000, 535000, 587043,
            521800, 602847, 507182, 563000, 629925, 607054, 425506,
            592557, 613514, 516812, 567118, 661766, 708384, 627165
        ]
    }, {
        name: 'Melanesia',
        data: [
            1889, 1934, 1916, 2363, 2055, 2112, 3273, 5100, 3369, 2401,
            1956, 2130, 3039, 1961, 1782, 2648, 1951, 3351, 3736, 4443, 5304,
            5006, 5276, 3993, 5074, 4651, 3133, 4471, 3960, 6214, 4528, 5626,
            5488, 7032, 8414, 10372, 10376, 10186, 10190, 13785, 13985,
            13958, 13887, 13050, 15009, 12845, 14845, 15627, 14158, 15973,
            17338, 13974, 17260, 17340
        ]
    }, {
        name: 'Micronesia',
        data: [
            337, 291, 208, 226, 125, 50, 55, 59, 76, 68, 70, 75, 75, 75, 75,
            75, 75, 76, 78, 79, 80, 80, 56, 68, 64, 68, 68, 68, 68, 73, 17,
            24, 18, 19, 70, 93, 103, 78, 94, 104, 92, 104, 88, 98, 109, 107,
            90, 124, 128, 108, 118, 130, 140, 130
        ]
    }, {
        name: 'Polynesia',
        data: [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        ]
    }];
}

function productionHeatmap() {
    return [{
        code: 5101,
        value: 5689834,
        x: 0,
        y: 0,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5102,
        value: 1219400,
        x: 0,
        y: 1,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5103,
        value: 1762019,
        x: 0,
        y: 2,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5104,
        value: 5453607,
        x: 0,
        y: 3,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5105,
        value: 2022383,
        x: 0,
        y: 4,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5203,
        value: 92129912,
        x: 0,
        y: 5,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5204,
        value: 7469003,
        x: 0,
        y: 6,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5206,
        value: 399581,
        x: 0,
        y: 7,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5207,
        value: 16314418,
        x: 0,
        y: 8,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5301,
        value: 0,
        x: 0,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 19404253,
        x: 0,
        y: 10,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5303,
        value: 6421214,
        x: 0,
        y: 11,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5304,
        value: 4711540,
        x: 0,
        y: 12,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5305,
        value: 1064101,
        x: 0,
        y: 13,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5401,
        value: 27508049,
        x: 0,
        y: 14,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5402,
        value: 0,
        x: 0,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 10571090,
        x: 0,
        y: 16,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5404,
        value: 2716061,
        x: 0,
        y: 17,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5501,
        value: 168892,
        x: 0,
        y: 18,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5502,
        value: 1889,
        x: 0,
        y: 19,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5503,
        value: 337,
        x: 0,
        y: 20,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 0,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 5741847,
        x: 1,
        y: 0,
        lastValue: 5689834,
        diff: 52013,
        variance: 0.9141
    }, {
        code: 5102,
        value: 1189400,
        x: 1,
        y: 1,
        lastValue: 1219400,
        diff: -30000,
        variance: -2.4602
    }, {
        code: 5103,
        value: 2443935,
        x: 1,
        y: 2,
        lastValue: 1762019,
        diff: 681916,
        variance: 38.7008
    }, {
        code: 5104,
        value: 6196210,
        x: 1,
        y: 3,
        lastValue: 5453607,
        diff: 742603,
        variance: 13.6167
    }, {
        code: 5105,
        value: 2000826,
        x: 1,
        y: 4,
        lastValue: 2022383,
        diff: -21557,
        variance: -1.0659
    }, {
        code: 5203,
        value: 92452368,
        x: 1,
        y: 5,
        lastValue: 92129912,
        diff: 322456,
        variance: 0.3500
    }, {
        code: 5204,
        value: 7671734,
        x: 1,
        y: 6,
        lastValue: 7469003,
        diff: 202731,
        variance: 2.7143
    }, {
        code: 5206,
        value: 394763,
        x: 1,
        y: 7,
        lastValue: 399581,
        diff: -4818,
        variance: -1.2058
    }, {
        code: 5207,
        value: 17323969,
        x: 1,
        y: 8,
        lastValue: 16314418,
        diff: 1009551,
        variance: 6.1881
    }, {
        code: 5301,
        value: 0,
        x: 1,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 17712402,
        x: 1,
        y: 10,
        lastValue: 19404253,
        diff: -1691851,
        variance: -8.7190
    }, {
        code: 5303,
        value: 6709862,
        x: 1,
        y: 11,
        lastValue: 6421214,
        diff: 288648,
        variance: 4.4952
    }, {
        code: 5304,
        value: 5759485,
        x: 1,
        y: 12,
        lastValue: 4711540,
        diff: 1047945,
        variance: 22.2421
    }, {
        code: 5305,
        value: 846897,
        x: 1,
        y: 13,
        lastValue: 1064101,
        diff: -217204,
        variance: -20.4120
    }, {
        code: 5401,
        value: 25722273,
        x: 1,
        y: 14,
        lastValue: 27508049,
        diff: -1785776,
        variance: -6.4918
    }, {
        code: 5402,
        value: 0,
        x: 1,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 10387988,
        x: 1,
        y: 16,
        lastValue: 10571090,
        diff: -183102,
        variance: -1.7321
    }, {
        code: 5404,
        value: 2121297,
        x: 1,
        y: 17,
        lastValue: 2716061,
        diff: -594764,
        variance: -21.8980
    }, {
        code: 5501,
        value: 199456,
        x: 1,
        y: 18,
        lastValue: 168892,
        diff: 30564,
        variance: 18.0968
    }, {
        code: 5502,
        value: 1934,
        x: 1,
        y: 19,
        lastValue: 1889,
        diff: 45,
        variance: 2.3822
    }, {
        code: 5503,
        value: 291,
        x: 1,
        y: 20,
        lastValue: 337,
        diff: -46,
        variance: -13.6499
    }, {
        code: 5504,
        value: 0,
        x: 1,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 5706347,
        x: 2,
        y: 0,
        lastValue: 5741847,
        diff: -35500,
        variance: -0.6183
    }, {
        code: 5102,
        value: 1144000,
        x: 2,
        y: 1,
        lastValue: 1189400,
        diff: -45400,
        variance: -3.8171
    }, {
        code: 5103,
        value: 2376819,
        x: 2,
        y: 2,
        lastValue: 2443935,
        diff: -67116,
        variance: -2.7462
    }, {
        code: 5104,
        value: 6295751,
        x: 2,
        y: 3,
        lastValue: 6196210,
        diff: 99541,
        variance: 1.6065
    }, {
        code: 5105,
        value: 2126736,
        x: 2,
        y: 4,
        lastValue: 2000826,
        diff: 125910,
        variance: 6.2929
    }, {
        code: 5203,
        value: 103012118,
        x: 2,
        y: 5,
        lastValue: 92452368,
        diff: 10559750,
        variance: 11.4218
    }, {
        code: 5204,
        value: 8230388,
        x: 2,
        y: 6,
        lastValue: 7671734,
        diff: 558654,
        variance: 7.2820
    }, {
        code: 5206,
        value: 389952,
        x: 2,
        y: 7,
        lastValue: 394763,
        diff: -4811,
        variance: -1.2187
    }, {
        code: 5207,
        value: 17318192,
        x: 2,
        y: 8,
        lastValue: 17323969,
        diff: -5777,
        variance: -0.0333
    }, {
        code: 5301,
        value: 0,
        x: 2,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 22168466,
        x: 2,
        y: 10,
        lastValue: 17712402,
        diff: 4456064,
        variance: 25.1579
    }, {
        code: 5303,
        value: 6728955,
        x: 2,
        y: 11,
        lastValue: 6709862,
        diff: 19093,
        variance: 0.2846
    }, {
        code: 5304,
        value: 5067777,
        x: 2,
        y: 12,
        lastValue: 5759485,
        diff: -691708,
        variance: -12.0099
    }, {
        code: 5305,
        value: 1034132,
        x: 2,
        y: 13,
        lastValue: 846897,
        diff: 187235,
        variance: 22.1084
    }, {
        code: 5401,
        value: 23071835,
        x: 2,
        y: 14,
        lastValue: 25722273,
        diff: -2650438,
        variance: -10.3041
    }, {
        code: 5402,
        value: 0,
        x: 2,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 11213263,
        x: 2,
        y: 16,
        lastValue: 10387988,
        diff: 825275,
        variance: 7.9445
    }, {
        code: 5404,
        value: 4136593,
        x: 2,
        y: 17,
        lastValue: 2121297,
        diff: 2015296,
        variance: 95.0030
    }, {
        code: 5501,
        value: 204885,
        x: 2,
        y: 18,
        lastValue: 199456,
        diff: 5429,
        variance: 2.7219
    }, {
        code: 5502,
        value: 1916,
        x: 2,
        y: 19,
        lastValue: 1934,
        diff: -18,
        variance: -0.9307
    }, {
        code: 5503,
        value: 208,
        x: 2,
        y: 20,
        lastValue: 291,
        diff: -83,
        variance: -28.5223
    }, {
        code: 5504,
        value: 0,
        x: 2,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 5971416,
        x: 3,
        y: 0,
        lastValue: 5706347,
        diff: 265069,
        variance: 4.6452
    }, {
        code: 5102,
        value: 1183800,
        x: 3,
        y: 1,
        lastValue: 1144000,
        diff: 39800,
        variance: 3.4790
    }, {
        code: 5103,
        value: 2367845,
        x: 3,
        y: 2,
        lastValue: 2376819,
        diff: -8974,
        variance: -0.3776
    }, {
        code: 5104,
        value: 4472297,
        x: 3,
        y: 3,
        lastValue: 6295751,
        diff: -1823454,
        variance: -28.9632
    }, {
        code: 5105,
        value: 2176529,
        x: 3,
        y: 4,
        lastValue: 2126736,
        diff: 49793,
        variance: 2.3413
    }, {
        code: 5203,
        value: 89846189,
        x: 3,
        y: 5,
        lastValue: 103012118,
        diff: -13165929,
        variance: -12.7810
    }, {
        code: 5204,
        value: 9925690,
        x: 3,
        y: 6,
        lastValue: 8230388,
        diff: 1695302,
        variance: 20.5981
    }, {
        code: 5206,
        value: 388373,
        x: 3,
        y: 7,
        lastValue: 389952,
        diff: -1579,
        variance: -0.4049
    }, {
        code: 5207,
        value: 17573698,
        x: 3,
        y: 8,
        lastValue: 17318192,
        diff: 255506,
        variance: 1.4754
    }, {
        code: 5301,
        value: 0,
        x: 3,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 24355612,
        x: 3,
        y: 10,
        lastValue: 22168466,
        diff: 2187146,
        variance: 9.8660
    }, {
        code: 5303,
        value: 6849137,
        x: 3,
        y: 11,
        lastValue: 6728955,
        diff: 120182,
        variance: 1.7860
    }, {
        code: 5304,
        value: 6639631,
        x: 3,
        y: 12,
        lastValue: 5067777,
        diff: 1571854,
        variance: 31.0166
    }, {
        code: 5305,
        value: 1040626,
        x: 3,
        y: 13,
        lastValue: 1034132,
        diff: 6494,
        variance: 0.6280
    }, {
        code: 5401,
        value: 26631621,
        x: 3,
        y: 14,
        lastValue: 23071835,
        diff: 3559786,
        variance: 15.4291
    }, {
        code: 5402,
        value: 0,
        x: 3,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 13150877,
        x: 3,
        y: 16,
        lastValue: 11213263,
        diff: 1937614,
        variance: 17.2797
    }, {
        code: 5404,
        value: 2407054,
        x: 3,
        y: 17,
        lastValue: 4136593,
        diff: -1729539,
        variance: -41.8107
    }, {
        code: 5501,
        value: 189643,
        x: 3,
        y: 18,
        lastValue: 204885,
        diff: -15242,
        variance: -7.4393
    }, {
        code: 5502,
        value: 2363,
        x: 3,
        y: 19,
        lastValue: 1916,
        diff: 447,
        variance: 23.3299
    }, {
        code: 5503,
        value: 226,
        x: 3,
        y: 20,
        lastValue: 208,
        diff: 18,
        variance: 8.6538
    }, {
        code: 5504,
        value: 0,
        x: 3,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 6314679,
        x: 4,
        y: 0,
        lastValue: 5971416,
        diff: 343263,
        variance: 5.7484
    }, {
        code: 5102,
        value: 1189800,
        x: 4,
        y: 1,
        lastValue: 1183800,
        diff: 6000,
        variance: 0.5068
    }, {
        code: 5103,
        value: 2489254,
        x: 4,
        y: 2,
        lastValue: 2367845,
        diff: 121409,
        variance: 5.1274
    }, {
        code: 5104,
        value: 4773276,
        x: 4,
        y: 3,
        lastValue: 4472297,
        diff: 300979,
        variance: 6.7299
    }, {
        code: 5105,
        value: 2179719,
        x: 4,
        y: 4,
        lastValue: 2176529,
        diff: 3190,
        variance: 0.1466
    }, {
        code: 5203,
        value: 105728237,
        x: 4,
        y: 5,
        lastValue: 89846189,
        diff: 15882048,
        variance: 17.6769
    }, {
        code: 5204,
        value: 10455222,
        x: 4,
        y: 6,
        lastValue: 9925690,
        diff: 529532,
        variance: 5.3350
    }, {
        code: 5206,
        value: 379473,
        x: 4,
        y: 7,
        lastValue: 388373,
        diff: -8900,
        variance: -2.2916
    }, {
        code: 5207,
        value: 20204233,
        x: 4,
        y: 8,
        lastValue: 17573698,
        diff: 2630535,
        variance: 14.9686
    }, {
        code: 5301,
        value: 0,
        x: 4,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 25121319,
        x: 4,
        y: 10,
        lastValue: 24355612,
        diff: 765707,
        variance: 3.1439
    }, {
        code: 5303,
        value: 7025478,
        x: 4,
        y: 11,
        lastValue: 6849137,
        diff: 176341,
        variance: 2.5746
    }, {
        code: 5304,
        value: 5319340,
        x: 4,
        y: 12,
        lastValue: 6639631,
        diff: -1320291,
        variance: -19.8850
    }, {
        code: 5305,
        value: 983730,
        x: 4,
        y: 13,
        lastValue: 1040626,
        diff: -56896,
        variance: -5.4675
    }, {
        code: 5401,
        value: 19160035,
        x: 4,
        y: 14,
        lastValue: 26631621,
        diff: -7471586,
        variance: -28.0553
    }, {
        code: 5402,
        value: 0,
        x: 4,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 11245759,
        x: 4,
        y: 16,
        lastValue: 13150877,
        diff: -1905118,
        variance: -14.4866
    }, {
        code: 5404,
        value: 3774243,
        x: 4,
        y: 17,
        lastValue: 2407054,
        diff: 1367189,
        variance: 56.7993
    }, {
        code: 5501,
        value: 198279,
        x: 4,
        y: 18,
        lastValue: 189643,
        diff: 8636,
        variance: 4.5538
    }, {
        code: 5502,
        value: 2055,
        x: 4,
        y: 19,
        lastValue: 2363,
        diff: -308,
        variance: -13.0343
    }, {
        code: 5503,
        value: 125,
        x: 4,
        y: 20,
        lastValue: 226,
        diff: -101,
        variance: -44.6903
    }, {
        code: 5504,
        value: 0,
        x: 4,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 6541392,
        x: 5,
        y: 0,
        lastValue: 6314679,
        diff: 226713,
        variance: 3.5903
    }, {
        code: 5102,
        value: 1163620,
        x: 5,
        y: 1,
        lastValue: 1189800,
        diff: -26180,
        variance: -2.2004
    }, {
        code: 5103,
        value: 2610409,
        x: 5,
        y: 2,
        lastValue: 2489254,
        diff: 121155,
        variance: 4.8671
    }, {
        code: 5104,
        value: 5343528,
        x: 5,
        y: 3,
        lastValue: 4773276,
        diff: 570252,
        variance: 11.9468
    }, {
        code: 5105,
        value: 2243597,
        x: 5,
        y: 4,
        lastValue: 2179719,
        diff: 63878,
        variance: 2.9306
    }, {
        code: 5203,
        value: 107546206,
        x: 5,
        y: 5,
        lastValue: 105728237,
        diff: 1817969,
        variance: 1.7195
    }, {
        code: 5204,
        value: 10808464,
        x: 5,
        y: 6,
        lastValue: 10455222,
        diff: 353242,
        variance: 3.3786
    }, {
        code: 5206,
        value: 385754,
        x: 5,
        y: 7,
        lastValue: 379473,
        diff: 6281,
        variance: 1.6552
    }, {
        code: 5207,
        value: 21477754,
        x: 5,
        y: 8,
        lastValue: 20204233,
        diff: 1273521,
        variance: 6.3032
    }, {
        code: 5301,
        value: 0,
        x: 5,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 30749939,
        x: 5,
        y: 10,
        lastValue: 25121319,
        diff: 5628620,
        variance: 22.4058
    }, {
        code: 5303,
        value: 7114060,
        x: 5,
        y: 11,
        lastValue: 7025478,
        diff: 88582,
        variance: 1.2609
    }, {
        code: 5304,
        value: 6823615,
        x: 5,
        y: 12,
        lastValue: 5319340,
        diff: 1504275,
        variance: 28.2794
    }, {
        code: 5305,
        value: 1038776,
        x: 5,
        y: 13,
        lastValue: 983730,
        diff: 55046,
        variance: 5.5956
    }, {
        code: 5401,
        value: 23091160,
        x: 5,
        y: 14,
        lastValue: 19160035,
        diff: 3931125,
        variance: 20.5173
    }, {
        code: 5402,
        value: 0,
        x: 5,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 13749035,
        x: 5,
        y: 16,
        lastValue: 11245759,
        diff: 2503276,
        variance: 22.2597
    }, {
        code: 5404,
        value: 4765411,
        x: 5,
        y: 17,
        lastValue: 3774243,
        diff: 991168,
        variance: 26.2614
    }, {
        code: 5501,
        value: 144278,
        x: 5,
        y: 18,
        lastValue: 198279,
        diff: -54001,
        variance: -27.2349
    }, {
        code: 5502,
        value: 2112,
        x: 5,
        y: 19,
        lastValue: 2055,
        diff: 57,
        variance: 2.7737
    }, {
        code: 5503,
        value: 50,
        x: 5,
        y: 20,
        lastValue: 125,
        diff: -75,
        variance: -60.0000
    }, {
        code: 5504,
        value: 0,
        x: 5,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 7748462,
        x: 6,
        y: 0,
        lastValue: 6541392,
        diff: 1207070,
        variance: 18.4528
    }, {
        code: 5102,
        value: 1183730,
        x: 6,
        y: 1,
        lastValue: 1163620,
        diff: 20110,
        variance: 1.7282
    }, {
        code: 5103,
        value: 2547439,
        x: 6,
        y: 2,
        lastValue: 2610409,
        diff: -62970,
        variance: -2.4123
    }, {
        code: 5104,
        value: 9998129,
        x: 6,
        y: 3,
        lastValue: 5343528,
        diff: 4654601,
        variance: 87.1073
    }, {
        code: 5105,
        value: 2249409,
        x: 6,
        y: 4,
        lastValue: 2243597,
        diff: 5812,
        variance: 0.2590
    }, {
        code: 5203,
        value: 125341280,
        x: 6,
        y: 5,
        lastValue: 107546206,
        diff: 17795074,
        variance: 16.5464
    }, {
        code: 5204,
        value: 10137867,
        x: 6,
        y: 6,
        lastValue: 10808464,
        diff: -670597,
        variance: -6.2044
    }, {
        code: 5206,
        value: 389657,
        x: 6,
        y: 7,
        lastValue: 385754,
        diff: 3903,
        variance: 1.0118
    }, {
        code: 5207,
        value: 24619722,
        x: 6,
        y: 8,
        lastValue: 21477754,
        diff: 3141968,
        variance: 14.6289
    }, {
        code: 5301,
        value: 0,
        x: 6,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 32473982,
        x: 6,
        y: 10,
        lastValue: 30749939,
        diff: 1724043,
        variance: 5.6067
    }, {
        code: 5303,
        value: 8681185,
        x: 6,
        y: 11,
        lastValue: 7114060,
        diff: 1567125,
        variance: 22.0286
    }, {
        code: 5304,
        value: 5727207,
        x: 6,
        y: 12,
        lastValue: 6823615,
        diff: -1096408,
        variance: -16.0678
    }, {
        code: 5305,
        value: 1086765,
        x: 6,
        y: 13,
        lastValue: 1038776,
        diff: 47989,
        variance: 4.6198
    }, {
        code: 5401,
        value: 22006426,
        x: 6,
        y: 14,
        lastValue: 23091160,
        diff: -1084734,
        variance: -4.6976
    }, {
        code: 5402,
        value: 0,
        x: 6,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 13454250,
        x: 6,
        y: 16,
        lastValue: 13749035,
        diff: -294785,
        variance: -2.1440
    }, {
        code: 5404,
        value: 4690865,
        x: 6,
        y: 17,
        lastValue: 4765411,
        diff: -74546,
        variance: -1.5643
    }, {
        code: 5501,
        value: 208770,
        x: 6,
        y: 18,
        lastValue: 144278,
        diff: 64492,
        variance: 44.6998
    }, {
        code: 5502,
        value: 3273,
        x: 6,
        y: 19,
        lastValue: 2112,
        diff: 1161,
        variance: 54.9716
    }, {
        code: 5503,
        value: 55,
        x: 6,
        y: 20,
        lastValue: 50,
        diff: 5,
        variance: 10.0000
    }, {
        code: 5504,
        value: 0,
        x: 6,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 7097886,
        x: 7,
        y: 0,
        lastValue: 7748462,
        diff: -650576,
        variance: -8.3962
    }, {
        code: 5102,
        value: 1265140,
        x: 7,
        y: 1,
        lastValue: 1183730,
        diff: 81410,
        variance: 6.8774
    }, {
        code: 5103,
        value: 2703872,
        x: 7,
        y: 2,
        lastValue: 2547439,
        diff: 156433,
        variance: 6.1408
    }, {
        code: 5104,
        value: 5546997,
        x: 7,
        y: 3,
        lastValue: 9998129,
        diff: -4451132,
        variance: -44.5196
    }, {
        code: 5105,
        value: 2316322,
        x: 7,
        y: 4,
        lastValue: 2249409,
        diff: 66913,
        variance: 2.9747
    }, {
        code: 5203,
        value: 115099195,
        x: 7,
        y: 5,
        lastValue: 125341280,
        diff: -10242085,
        variance: -8.1714
    }, {
        code: 5204,
        value: 10733198,
        x: 7,
        y: 6,
        lastValue: 10137867,
        diff: 595331,
        variance: 5.8723
    }, {
        code: 5206,
        value: 361901,
        x: 7,
        y: 7,
        lastValue: 389657,
        diff: -27756,
        variance: -7.1232
    }, {
        code: 5207,
        value: 22479692,
        x: 7,
        y: 8,
        lastValue: 24619722,
        diff: -2140030,
        variance: -8.6923
    }, {
        code: 5301,
        value: 0,
        x: 7,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 30552885,
        x: 7,
        y: 10,
        lastValue: 32473982,
        diff: -1921097,
        variance: -5.9158
    }, {
        code: 5303,
        value: 7974133,
        x: 7,
        y: 11,
        lastValue: 8681185,
        diff: -707052,
        variance: -8.1446
    }, {
        code: 5304,
        value: 6760169,
        x: 7,
        y: 12,
        lastValue: 5727207,
        diff: 1032962,
        variance: 18.0361
    }, {
        code: 5305,
        value: 1033927,
        x: 7,
        y: 13,
        lastValue: 1086765,
        diff: -52838,
        variance: -4.8620
    }, {
        code: 5401,
        value: 21980814,
        x: 7,
        y: 14,
        lastValue: 22006426,
        diff: -25612,
        variance: -0.1164
    }, {
        code: 5402,
        value: 0,
        x: 7,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 13437106,
        x: 7,
        y: 16,
        lastValue: 13454250,
        diff: -17144,
        variance: -0.1274
    }, {
        code: 5404,
        value: 6105104,
        x: 7,
        y: 17,
        lastValue: 4690865,
        diff: 1414239,
        variance: 30.1488
    }, {
        code: 5501,
        value: 217051,
        x: 7,
        y: 18,
        lastValue: 208770,
        diff: 8281,
        variance: 3.9666
    }, {
        code: 5502,
        value: 5100,
        x: 7,
        y: 19,
        lastValue: 3273,
        diff: 1827,
        variance: 55.8203
    }, {
        code: 5503,
        value: 59,
        x: 7,
        y: 20,
        lastValue: 55,
        diff: 4,
        variance: 7.2727
    }, {
        code: 5504,
        value: 0,
        x: 7,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 7858678,
        x: 8,
        y: 0,
        lastValue: 7097886,
        diff: 760792,
        variance: 10.7186
    }, {
        code: 5102,
        value: 1441816,
        x: 8,
        y: 1,
        lastValue: 1265140,
        diff: 176676,
        variance: 13.9649
    }, {
        code: 5103,
        value: 2841649,
        x: 8,
        y: 2,
        lastValue: 2703872,
        diff: 137777,
        variance: 5.0955
    }, {
        code: 5104,
        value: 5573800,
        x: 8,
        y: 3,
        lastValue: 5546997,
        diff: 26803,
        variance: 0.4832
    }, {
        code: 5105,
        value: 2410128,
        x: 8,
        y: 4,
        lastValue: 2316322,
        diff: 93806,
        variance: 4.0498
    }, {
        code: 5203,
        value: 120938811,
        x: 8,
        y: 5,
        lastValue: 115099195,
        diff: 5839616,
        variance: 5.0736
    }, {
        code: 5204,
        value: 10151952,
        x: 8,
        y: 6,
        lastValue: 10733198,
        diff: -581246,
        variance: -5.4154
    }, {
        code: 5206,
        value: 379872,
        x: 8,
        y: 7,
        lastValue: 361901,
        diff: 17971,
        variance: 4.9657
    }, {
        code: 5207,
        value: 22625311,
        x: 8,
        y: 8,
        lastValue: 22479692,
        diff: 145619,
        variance: 0.6478
    }, {
        code: 5301,
        value: 0,
        x: 8,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 30187062,
        x: 8,
        y: 10,
        lastValue: 30552885,
        diff: -365823,
        variance: -1.1973
    }, {
        code: 5303,
        value: 8037238,
        x: 8,
        y: 11,
        lastValue: 7974133,
        diff: 63105,
        variance: 0.7914
    }, {
        code: 5304,
        value: 6508551,
        x: 8,
        y: 12,
        lastValue: 6760169,
        diff: -251618,
        variance: -3.7221
    }, {
        code: 5305,
        value: 1034650,
        x: 8,
        y: 13,
        lastValue: 1033927,
        diff: 723,
        variance: 0.0699
    }, {
        code: 5401,
        value: 27371180,
        x: 8,
        y: 14,
        lastValue: 21980814,
        diff: 5390366,
        variance: 24.5230
    }, {
        code: 5402,
        value: 0,
        x: 8,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 15065694,
        x: 8,
        y: 16,
        lastValue: 13437106,
        diff: 1628588,
        variance: 12.1201
    }, {
        code: 5404,
        value: 6876073,
        x: 8,
        y: 17,
        lastValue: 6105104,
        diff: 770969,
        variance: 12.6283
    }, {
        code: 5501,
        value: 200158,
        x: 8,
        y: 18,
        lastValue: 217051,
        diff: -16893,
        variance: -7.7830
    }, {
        code: 5502,
        value: 3369,
        x: 8,
        y: 19,
        lastValue: 5100,
        diff: -1731,
        variance: -33.9412
    }, {
        code: 5503,
        value: 76,
        x: 8,
        y: 20,
        lastValue: 59,
        diff: 17,
        variance: 28.8136
    }, {
        code: 5504,
        value: 0,
        x: 8,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 6607280,
        x: 9,
        y: 0,
        lastValue: 7858678,
        diff: -1251398,
        variance: -15.9238
    }, {
        code: 5102,
        value: 1362758,
        x: 9,
        y: 1,
        lastValue: 1441816,
        diff: -79058,
        variance: -5.4832
    }, {
        code: 5103,
        value: 2766300,
        x: 9,
        y: 2,
        lastValue: 2841649,
        diff: -75349,
        variance: -2.6516
    }, {
        code: 5104,
        value: 6333209,
        x: 9,
        y: 3,
        lastValue: 5573800,
        diff: 759409,
        variance: 13.6246
    }, {
        code: 5105,
        value: 2810320,
        x: 9,
        y: 4,
        lastValue: 2410128,
        diff: 400192,
        variance: 16.6046
    }, {
        code: 5203,
        value: 108104797,
        x: 9,
        y: 5,
        lastValue: 120938811,
        diff: -12834014,
        variance: -10.6120
    }, {
        code: 5204,
        value: 10746689,
        x: 9,
        y: 6,
        lastValue: 10151952,
        diff: 594737,
        variance: 5.8584
    }, {
        code: 5206,
        value: 381467,
        x: 9,
        y: 7,
        lastValue: 379872,
        diff: 1595,
        variance: 0.4199
    }, {
        code: 5207,
        value: 26969852,
        x: 9,
        y: 8,
        lastValue: 22625311,
        diff: 4344541,
        variance: 19.2021
    }, {
        code: 5301,
        value: 0,
        x: 9,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 34793316,
        x: 9,
        y: 10,
        lastValue: 30187062,
        diff: 4606254,
        variance: 15.2590
    }, {
        code: 5303,
        value: 9818133,
        x: 9,
        y: 11,
        lastValue: 8037238,
        diff: 1780895,
        variance: 22.1580
    }, {
        code: 5304,
        value: 7275150,
        x: 9,
        y: 12,
        lastValue: 6508551,
        diff: 766599,
        variance: 11.7783
    }, {
        code: 5305,
        value: 1076509,
        x: 9,
        y: 13,
        lastValue: 1034650,
        diff: 41859,
        variance: 4.0457
    }, {
        code: 5401,
        value: 22936467,
        x: 9,
        y: 14,
        lastValue: 27371180,
        diff: -4434713,
        variance: -16.2021
    }, {
        code: 5402,
        value: 2000,
        x: 9,
        y: 15,
        lastValue: 0,
        diff: 2000,
        variance: 0.0000
    }, {
        code: 5403,
        value: 14901833,
        x: 9,
        y: 16,
        lastValue: 15065694,
        diff: -163861,
        variance: -1.0876
    }, {
        code: 5404,
        value: 8692372,
        x: 9,
        y: 17,
        lastValue: 6876073,
        diff: 1816299,
        variance: 26.4148
    }, {
        code: 5501,
        value: 250224,
        x: 9,
        y: 18,
        lastValue: 200158,
        diff: 50066,
        variance: 25.0132
    }, {
        code: 5502,
        value: 2401,
        x: 9,
        y: 19,
        lastValue: 3369,
        diff: -968,
        variance: -28.7326
    }, {
        code: 5503,
        value: 68,
        x: 9,
        y: 20,
        lastValue: 76,
        diff: -8,
        variance: -10.5263
    }, {
        code: 5504,
        value: 0,
        x: 9,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 8230379,
        x: 10,
        y: 0,
        lastValue: 6607280,
        diff: 1623099,
        variance: 24.5653
    }, {
        code: 5102,
        value: 1355032,
        x: 10,
        y: 1,
        lastValue: 1362758,
        diff: -7726,
        variance: -0.5669
    }, {
        code: 5103,
        value: 2753781,
        x: 10,
        y: 2,
        lastValue: 2766300,
        diff: -12519,
        variance: -0.4526
    }, {
        code: 5104,
        value: 8862295,
        x: 10,
        y: 3,
        lastValue: 6333209,
        diff: 2529086,
        variance: 39.9337
    }, {
        code: 5105,
        value: 2644019,
        x: 10,
        y: 4,
        lastValue: 2810320,
        diff: -166301,
        variance: -5.9175
    }, {
        code: 5203,
        value: 146366588,
        x: 10,
        y: 5,
        lastValue: 108104797,
        diff: 38261791,
        variance: 35.3932
    }, {
        code: 5204,
        value: 11632601,
        x: 10,
        y: 6,
        lastValue: 10746689,
        diff: 885912,
        variance: 8.2436
    }, {
        code: 5206,
        value: 403007,
        x: 10,
        y: 7,
        lastValue: 381467,
        diff: 21540,
        variance: 5.6466
    }, {
        code: 5207,
        value: 27412929,
        x: 10,
        y: 8,
        lastValue: 26969852,
        diff: 443077,
        variance: 1.6429
    }, {
        code: 5301,
        value: 0,
        x: 10,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 37665959,
        x: 10,
        y: 10,
        lastValue: 34793316,
        diff: 2872643,
        variance: 8.2563
    }, {
        code: 5303,
        value: 7348008,
        x: 10,
        y: 11,
        lastValue: 9818133,
        diff: -2470125,
        variance: -25.1588
    }, {
        code: 5304,
        value: 7396364,
        x: 10,
        y: 12,
        lastValue: 7275150,
        diff: 121214,
        variance: 1.6661
    }, {
        code: 5305,
        value: 1197160,
        x: 10,
        y: 13,
        lastValue: 1076509,
        diff: 120651,
        variance: 11.2076
    }, {
        code: 5401,
        value: 24234665,
        x: 10,
        y: 14,
        lastValue: 22936467,
        diff: 1298198,
        variance: 5.6600
    }, {
        code: 5402,
        value: 5000,
        x: 10,
        y: 15,
        lastValue: 2000,
        diff: 3000,
        variance: 150.0000
    }, {
        code: 5403,
        value: 15393041,
        x: 10,
        y: 16,
        lastValue: 14901833,
        diff: 491208,
        variance: 3.2963
    }, {
        code: 5404,
        value: 10406590,
        x: 10,
        y: 17,
        lastValue: 8692372,
        diff: 1714218,
        variance: 19.7209
    }, {
        code: 5501,
        value: 313178,
        x: 10,
        y: 18,
        lastValue: 250224,
        diff: 62954,
        variance: 25.1591
    }, {
        code: 5502,
        value: 1956,
        x: 10,
        y: 19,
        lastValue: 2401,
        diff: -445,
        variance: -18.5339
    }, {
        code: 5503,
        value: 70,
        x: 10,
        y: 20,
        lastValue: 68,
        diff: 2,
        variance: 2.9412
    }, {
        code: 5504,
        value: 0,
        x: 10,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9353871,
        x: 11,
        y: 0,
        lastValue: 8230379,
        diff: 1123492,
        variance: 13.6505
    }, {
        code: 5102,
        value: 1368900,
        x: 11,
        y: 1,
        lastValue: 1355032,
        diff: 13868,
        variance: 1.0234
    }, {
        code: 5103,
        value: 2805625,
        x: 11,
        y: 2,
        lastValue: 2753781,
        diff: 51844,
        variance: 1.8826
    }, {
        code: 5104,
        value: 9738591,
        x: 11,
        y: 3,
        lastValue: 8862295,
        diff: 876296,
        variance: 9.8879
    }, {
        code: 5105,
        value: 1803266,
        x: 11,
        y: 4,
        lastValue: 2644019,
        diff: -840753,
        variance: -31.7983
    }, {
        code: 5203,
        value: 144261677,
        x: 11,
        y: 5,
        lastValue: 146366588,
        diff: -2104911,
        variance: -1.4381
    }, {
        code: 5204,
        value: 10867793,
        x: 11,
        y: 6,
        lastValue: 11632601,
        diff: -764808,
        variance: -6.5747
    }, {
        code: 5206,
        value: 409963,
        x: 11,
        y: 7,
        lastValue: 403007,
        diff: 6956,
        variance: 1.7260
    }, {
        code: 5207,
        value: 23855674,
        x: 11,
        y: 8,
        lastValue: 27412929,
        diff: -3557255,
        variance: -12.9766
    }, {
        code: 5301,
        value: 0,
        x: 11,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 33852532,
        x: 11,
        y: 10,
        lastValue: 37665959,
        diff: -3813427,
        variance: -10.1243
    }, {
        code: 5303,
        value: 8739067,
        x: 11,
        y: 11,
        lastValue: 7348008,
        diff: 1391059,
        variance: 18.9311
    }, {
        code: 5304,
        value: 5859575,
        x: 11,
        y: 12,
        lastValue: 7396364,
        diff: -1536789,
        variance: -20.7776
    }, {
        code: 5305,
        value: 1094038,
        x: 11,
        y: 13,
        lastValue: 1197160,
        diff: -103122,
        variance: -8.6139
    }, {
        code: 5401,
        value: 28826197,
        x: 11,
        y: 14,
        lastValue: 24234665,
        diff: 4591532,
        variance: 18.9461
    }, {
        code: 5402,
        value: 6000,
        x: 11,
        y: 15,
        lastValue: 5000,
        diff: 1000,
        variance: 20.0000
    }, {
        code: 5403,
        value: 15976059,
        x: 11,
        y: 16,
        lastValue: 15393041,
        diff: 583018,
        variance: 3.7875
    }, {
        code: 5404,
        value: 9675104,
        x: 11,
        y: 17,
        lastValue: 10406590,
        diff: -731486,
        variance: -7.0291
    }, {
        code: 5501,
        value: 330153,
        x: 11,
        y: 18,
        lastValue: 313178,
        diff: 16975,
        variance: 5.4202
    }, {
        code: 5502,
        value: 2130,
        x: 11,
        y: 19,
        lastValue: 1956,
        diff: 174,
        variance: 8.8957
    }, {
        code: 5503,
        value: 75,
        x: 11,
        y: 20,
        lastValue: 70,
        diff: 5,
        variance: 7.1429
    }, {
        code: 5504,
        value: 0,
        x: 11,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 8120498,
        x: 12,
        y: 0,
        lastValue: 9353871,
        diff: -1233373,
        variance: -13.1857
    }, {
        code: 5102,
        value: 1408220,
        x: 12,
        y: 1,
        lastValue: 1368900,
        diff: 39320,
        variance: 2.8724
    }, {
        code: 5103,
        value: 2768882,
        x: 12,
        y: 2,
        lastValue: 2805625,
        diff: -36743,
        variance: -1.3096
    }, {
        code: 5104,
        value: 4407134,
        x: 12,
        y: 3,
        lastValue: 9738591,
        diff: -5331457,
        variance: -54.7457
    }, {
        code: 5105,
        value: 2065430,
        x: 12,
        y: 4,
        lastValue: 1803266,
        diff: 262164,
        variance: 14.5383
    }, {
        code: 5203,
        value: 146845141,
        x: 12,
        y: 5,
        lastValue: 144261677,
        diff: 2583464,
        variance: 1.7908
    }, {
        code: 5204,
        value: 10497456,
        x: 12,
        y: 6,
        lastValue: 10867793,
        diff: -370337,
        variance: -3.4077
    }, {
        code: 5206,
        value: 349897,
        x: 12,
        y: 7,
        lastValue: 409963,
        diff: -60066,
        variance: -14.6516
    }, {
        code: 5207,
        value: 26973049,
        x: 12,
        y: 8,
        lastValue: 23855674,
        diff: 3117375,
        variance: 13.0676
    }, {
        code: 5301,
        value: 0,
        x: 12,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 40575175,
        x: 12,
        y: 10,
        lastValue: 33852532,
        diff: 6722643,
        variance: 19.8586
    }, {
        code: 5303,
        value: 8265873,
        x: 12,
        y: 11,
        lastValue: 8739067,
        diff: -473194,
        variance: -5.4147
    }, {
        code: 5304,
        value: 8775094,
        x: 12,
        y: 12,
        lastValue: 5859575,
        diff: 2915519,
        variance: 49.7565
    }, {
        code: 5305,
        value: 1193522,
        x: 12,
        y: 13,
        lastValue: 1094038,
        diff: 99484,
        variance: 9.0933
    }, {
        code: 5401,
        value: 26695586,
        x: 12,
        y: 14,
        lastValue: 28826197,
        diff: -2130611,
        variance: -7.3912
    }, {
        code: 5402,
        value: 6000,
        x: 12,
        y: 15,
        lastValue: 6000,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 16660796,
        x: 12,
        y: 16,
        lastValue: 15976059,
        diff: 684737,
        variance: 4.2860
    }, {
        code: 5404,
        value: 12423295,
        x: 12,
        y: 17,
        lastValue: 9675104,
        diff: 2748191,
        variance: 28.4048
    }, {
        code: 5501,
        value: 256307,
        x: 12,
        y: 18,
        lastValue: 330153,
        diff: -73846,
        variance: -22.3672
    }, {
        code: 5502,
        value: 3039,
        x: 12,
        y: 19,
        lastValue: 2130,
        diff: 909,
        variance: 42.6761
    }, {
        code: 5503,
        value: 75,
        x: 12,
        y: 20,
        lastValue: 75,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 12,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9401446,
        x: 13,
        y: 0,
        lastValue: 8120498,
        diff: 1280948,
        variance: 15.7743
    }, {
        code: 5102,
        value: 1454275,
        x: 13,
        y: 1,
        lastValue: 1408220,
        diff: 46055,
        variance: 3.2704
    }, {
        code: 5103,
        value: 3080808,
        x: 13,
        y: 2,
        lastValue: 2768882,
        diff: 311926,
        variance: 11.2654
    }, {
        code: 5104,
        value: 11382696,
        x: 13,
        y: 3,
        lastValue: 4407134,
        diff: 6975562,
        variance: 158.2789
    }, {
        code: 5105,
        value: 1905711,
        x: 13,
        y: 4,
        lastValue: 2065430,
        diff: -159719,
        variance: -7.7330
    }, {
        code: 5203,
        value: 122040020,
        x: 13,
        y: 5,
        lastValue: 146845141,
        diff: -24805121,
        variance: -16.8920
    }, {
        code: 5204,
        value: 9679277,
        x: 13,
        y: 6,
        lastValue: 10497456,
        diff: -818179,
        variance: -7.7941
    }, {
        code: 5206,
        value: 366654,
        x: 13,
        y: 7,
        lastValue: 349897,
        diff: 16757,
        variance: 4.7891
    }, {
        code: 5207,
        value: 29533105,
        x: 13,
        y: 8,
        lastValue: 26973049,
        diff: 2560056,
        variance: 9.4912
    }, {
        code: 5301,
        value: 0,
        x: 13,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 45016398,
        x: 13,
        y: 10,
        lastValue: 40575175,
        diff: 4441223,
        variance: 10.9457
    }, {
        code: 5303,
        value: 8045975,
        x: 13,
        y: 11,
        lastValue: 8265873,
        diff: -219898,
        variance: -2.6603
    }, {
        code: 5304,
        value: 8540129,
        x: 13,
        y: 12,
        lastValue: 8775094,
        diff: -234965,
        variance: -2.6776
    }, {
        code: 5305,
        value: 1304159,
        x: 13,
        y: 13,
        lastValue: 1193522,
        diff: 110637,
        variance: 9.2698
    }, {
        code: 5401,
        value: 28009700,
        x: 13,
        y: 14,
        lastValue: 26695586,
        diff: 1314114,
        variance: 4.9226
    }, {
        code: 5402,
        value: 3000,
        x: 13,
        y: 15,
        lastValue: 6000,
        diff: -3000,
        variance: -50.0000
    }, {
        code: 5403,
        value: 16226700,
        x: 13,
        y: 16,
        lastValue: 16660796,
        diff: -434096,
        variance: -2.6055
    }, {
        code: 5404,
        value: 10241154,
        x: 13,
        y: 17,
        lastValue: 12423295,
        diff: -2182141,
        variance: -17.5649
    }, {
        code: 5501,
        value: 194104,
        x: 13,
        y: 18,
        lastValue: 256307,
        diff: -62203,
        variance: -24.2689
    }, {
        code: 5502,
        value: 1961,
        x: 13,
        y: 19,
        lastValue: 3039,
        diff: -1078,
        variance: -35.4722
    }, {
        code: 5503,
        value: 75,
        x: 13,
        y: 20,
        lastValue: 75,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 13,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9770528,
        x: 14,
        y: 0,
        lastValue: 9401446,
        diff: 369082,
        variance: 3.9258
    }, {
        code: 5102,
        value: 1687820,
        x: 14,
        y: 1,
        lastValue: 1454275,
        diff: 233545,
        variance: 16.0592
    }, {
        code: 5103,
        value: 3209112,
        x: 14,
        y: 2,
        lastValue: 3080808,
        diff: 128304,
        variance: 4.1646
    }, {
        code: 5104,
        value: 9358903,
        x: 14,
        y: 3,
        lastValue: 11382696,
        diff: -2023793,
        variance: -17.7796
    }, {
        code: 5105,
        value: 2602474,
        x: 14,
        y: 4,
        lastValue: 1905711,
        diff: 696763,
        variance: 36.5618
    }, {
        code: 5203,
        value: 152005938,
        x: 14,
        y: 5,
        lastValue: 122040020,
        diff: 29965918,
        variance: 24.5542
    }, {
        code: 5204,
        value: 10516501,
        x: 14,
        y: 6,
        lastValue: 9679277,
        diff: 837224,
        variance: 8.6497
    }, {
        code: 5206,
        value: 339829,
        x: 14,
        y: 7,
        lastValue: 366654,
        diff: -26825,
        variance: -7.3162
    }, {
        code: 5207,
        value: 27416694,
        x: 14,
        y: 8,
        lastValue: 29533105,
        diff: -2116411,
        variance: -7.1662
    }, {
        code: 5301,
        value: 0,
        x: 14,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 49426066,
        x: 14,
        y: 10,
        lastValue: 45016398,
        diff: 4409668,
        variance: 9.7957
    }, {
        code: 5303,
        value: 9750449,
        x: 14,
        y: 11,
        lastValue: 8045975,
        diff: 1704474,
        variance: 21.1842
    }, {
        code: 5304,
        value: 8952665,
        x: 14,
        y: 12,
        lastValue: 8540129,
        diff: 412536,
        variance: 4.8306
    }, {
        code: 5305,
        value: 1321298,
        x: 14,
        y: 13,
        lastValue: 1304159,
        diff: 17139,
        variance: 1.3142
    }, {
        code: 5401,
        value: 27484309,
        x: 14,
        y: 14,
        lastValue: 28009700,
        diff: -525391,
        variance: -1.8757
    }, {
        code: 5402,
        value: 3000,
        x: 14,
        y: 15,
        lastValue: 3000,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 17705900,
        x: 14,
        y: 16,
        lastValue: 16226700,
        diff: 1479200,
        variance: 9.1158
    }, {
        code: 5404,
        value: 9907729,
        x: 14,
        y: 17,
        lastValue: 10241154,
        diff: -333425,
        variance: -3.2557
    }, {
        code: 5501,
        value: 290899,
        x: 14,
        y: 18,
        lastValue: 194104,
        diff: 96795,
        variance: 49.8676
    }, {
        code: 5502,
        value: 1782,
        x: 14,
        y: 19,
        lastValue: 1961,
        diff: -179,
        variance: -9.1280
    }, {
        code: 5503,
        value: 75,
        x: 14,
        y: 20,
        lastValue: 75,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 14,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 11592761,
        x: 15,
        y: 0,
        lastValue: 9770528,
        diff: 1822233,
        variance: 18.6503
    }, {
        code: 5102,
        value: 1502549,
        x: 15,
        y: 1,
        lastValue: 1687820,
        diff: -185271,
        variance: -10.9769
    }, {
        code: 5103,
        value: 3578406,
        x: 15,
        y: 2,
        lastValue: 3209112,
        diff: 369294,
        variance: 11.5077
    }, {
        code: 5104,
        value: 7754228,
        x: 15,
        y: 3,
        lastValue: 9358903,
        diff: -1604675,
        variance: -17.1460
    }, {
        code: 5105,
        value: 2179606,
        x: 15,
        y: 4,
        lastValue: 2602474,
        diff: -422868,
        variance: -16.2487
    }, {
        code: 5203,
        value: 163510684,
        x: 15,
        y: 5,
        lastValue: 152005938,
        diff: 11504746,
        variance: 7.5686
    }, {
        code: 5204,
        value: 9969056,
        x: 15,
        y: 6,
        lastValue: 10516501,
        diff: -547445,
        variance: -5.2056
    }, {
        code: 5206,
        value: 359924,
        x: 15,
        y: 7,
        lastValue: 339829,
        diff: 20095,
        variance: 5.9133
    }, {
        code: 5207,
        value: 27058951,
        x: 15,
        y: 8,
        lastValue: 27416694,
        diff: -357743,
        variance: -1.3048
    }, {
        code: 5301,
        value: 0,
        x: 15,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 50544842,
        x: 15,
        y: 10,
        lastValue: 49426066,
        diff: 1118776,
        variance: 2.2635
    }, {
        code: 5303,
        value: 8897971,
        x: 15,
        y: 11,
        lastValue: 9750449,
        diff: -852478,
        variance: -8.7430
    }, {
        code: 5304,
        value: 8623113,
        x: 15,
        y: 12,
        lastValue: 8952665,
        diff: -329552,
        variance: -3.6810
    }, {
        code: 5305,
        value: 1488213,
        x: 15,
        y: 13,
        lastValue: 1321298,
        diff: 166915,
        variance: 12.6327
    }, {
        code: 5401,
        value: 30638501,
        x: 15,
        y: 14,
        lastValue: 27484309,
        diff: 3154192,
        variance: 11.4763
    }, {
        code: 5402,
        value: 2000,
        x: 15,
        y: 15,
        lastValue: 3000,
        diff: -1000,
        variance: -33.3333
    }, {
        code: 5403,
        value: 17185310,
        x: 15,
        y: 16,
        lastValue: 17705900,
        diff: -520590,
        variance: -2.9402
    }, {
        code: 5404,
        value: 7191093,
        x: 15,
        y: 17,
        lastValue: 9907729,
        diff: -2716636,
        variance: -27.4194
    }, {
        code: 5501,
        value: 315935,
        x: 15,
        y: 18,
        lastValue: 290899,
        diff: 25036,
        variance: 8.6064
    }, {
        code: 5502,
        value: 2648,
        x: 15,
        y: 19,
        lastValue: 1782,
        diff: 866,
        variance: 48.5971
    }, {
        code: 5503,
        value: 75,
        x: 15,
        y: 20,
        lastValue: 75,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 15,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 11172585,
        x: 16,
        y: 0,
        lastValue: 11592761,
        diff: -420176,
        variance: -3.6245
    }, {
        code: 5102,
        value: 1405649,
        x: 16,
        y: 1,
        lastValue: 1502549,
        diff: -96900,
        variance: -6.4490
    }, {
        code: 5103,
        value: 2955230,
        x: 16,
        y: 2,
        lastValue: 3578406,
        diff: -623176,
        variance: -17.4149
    }, {
        code: 5104,
        value: 10052096,
        x: 16,
        y: 3,
        lastValue: 7754228,
        diff: 2297868,
        variance: 29.6337
    }, {
        code: 5105,
        value: 1848786,
        x: 16,
        y: 4,
        lastValue: 2179606,
        diff: -330820,
        variance: -15.1780
    }, {
        code: 5203,
        value: 169483944,
        x: 16,
        y: 5,
        lastValue: 163510684,
        diff: 5973260,
        variance: 3.6531
    }, {
        code: 5204,
        value: 12160856,
        x: 16,
        y: 6,
        lastValue: 9969056,
        diff: 2191800,
        variance: 21.9860
    }, {
        code: 5206,
        value: 346053,
        x: 16,
        y: 7,
        lastValue: 359924,
        diff: -13871,
        variance: -3.8539
    }, {
        code: 5207,
        value: 31222188,
        x: 16,
        y: 8,
        lastValue: 27058951,
        diff: 4163237,
        variance: 15.3858
    }, {
        code: 5301,
        value: 0,
        x: 16,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 51885836,
        x: 16,
        y: 10,
        lastValue: 50544842,
        diff: 1340994,
        variance: 2.6531
    }, {
        code: 5303,
        value: 8442604,
        x: 16,
        y: 11,
        lastValue: 8897971,
        diff: -455367,
        variance: -5.1176
    }, {
        code: 5304,
        value: 8259163,
        x: 16,
        y: 12,
        lastValue: 8623113,
        diff: -363950,
        variance: -4.2206
    }, {
        code: 5305,
        value: 1482060,
        x: 16,
        y: 13,
        lastValue: 1488213,
        diff: -6153,
        variance: -0.4134
    }, {
        code: 5401,
        value: 30658496,
        x: 16,
        y: 14,
        lastValue: 30638501,
        diff: 19995,
        variance: 0.0653
    }, {
        code: 5402,
        value: 3000,
        x: 16,
        y: 15,
        lastValue: 2000,
        diff: 1000,
        variance: 50.0000
    }, {
        code: 5403,
        value: 19465493,
        x: 16,
        y: 16,
        lastValue: 17185310,
        diff: 2280183,
        variance: 13.2682
    }, {
        code: 5404,
        value: 10392694,
        x: 16,
        y: 17,
        lastValue: 7191093,
        diff: 3201601,
        variance: 44.5218
    }, {
        code: 5501,
        value: 354596,
        x: 16,
        y: 18,
        lastValue: 315935,
        diff: 38661,
        variance: 12.2370
    }, {
        code: 5502,
        value: 1951,
        x: 16,
        y: 19,
        lastValue: 2648,
        diff: -697,
        variance: -26.3218
    }, {
        code: 5503,
        value: 75,
        x: 16,
        y: 20,
        lastValue: 75,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 16,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 10486589,
        x: 17,
        y: 0,
        lastValue: 11172585,
        diff: -685996,
        variance: -6.1400
    }, {
        code: 5102,
        value: 1375026,
        x: 17,
        y: 1,
        lastValue: 1405649,
        diff: -30623,
        variance: -2.1786
    }, {
        code: 5103,
        value: 3556539,
        x: 17,
        y: 2,
        lastValue: 2955230,
        diff: 601309,
        variance: 20.3473
    }, {
        code: 5104,
        value: 10488497,
        x: 17,
        y: 3,
        lastValue: 10052096,
        diff: 436401,
        variance: 4.3414
    }, {
        code: 5105,
        value: 2000667,
        x: 17,
        y: 4,
        lastValue: 1848786,
        diff: 151881,
        variance: 8.2152
    }, {
        code: 5203,
        value: 189092508,
        x: 17,
        y: 5,
        lastValue: 169483944,
        diff: 19608564,
        variance: 11.5696
    }, {
        code: 5204,
        value: 13198435,
        x: 17,
        y: 6,
        lastValue: 12160856,
        diff: 1037579,
        variance: 8.5321
    }, {
        code: 5206,
        value: 338196,
        x: 17,
        y: 7,
        lastValue: 346053,
        diff: -7857,
        variance: -2.2705
    }, {
        code: 5207,
        value: 26613799,
        x: 17,
        y: 8,
        lastValue: 31222188,
        diff: -4608389,
        variance: -14.7600
    }, {
        code: 5301,
        value: 0,
        x: 17,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 58564356,
        x: 17,
        y: 10,
        lastValue: 51885836,
        diff: 6678520,
        variance: 12.8716
    }, {
        code: 5303,
        value: 8674798,
        x: 17,
        y: 11,
        lastValue: 8442604,
        diff: 232194,
        variance: 2.7503
    }, {
        code: 5304,
        value: 10554998,
        x: 17,
        y: 12,
        lastValue: 8259163,
        diff: 2295835,
        variance: 27.7974
    }, {
        code: 5305,
        value: 1503846,
        x: 17,
        y: 13,
        lastValue: 1482060,
        diff: 21786,
        variance: 1.4700
    }, {
        code: 5401,
        value: 28299842,
        x: 17,
        y: 14,
        lastValue: 30658496,
        diff: -2358654,
        variance: -7.6933
    }, {
        code: 5402,
        value: 2000,
        x: 17,
        y: 15,
        lastValue: 3000,
        diff: -1000,
        variance: -33.3333
    }, {
        code: 5403,
        value: 17078491,
        x: 17,
        y: 16,
        lastValue: 19465493,
        diff: -2387002,
        variance: -12.2627
    }, {
        code: 5404,
        value: 11463434,
        x: 17,
        y: 17,
        lastValue: 10392694,
        diff: 1070740,
        variance: 10.3028
    }, {
        code: 5501,
        value: 304643,
        x: 17,
        y: 18,
        lastValue: 354596,
        diff: -49953,
        variance: -14.0873
    }, {
        code: 5502,
        value: 3351,
        x: 17,
        y: 19,
        lastValue: 1951,
        diff: 1400,
        variance: 71.7581
    }, {
        code: 5503,
        value: 76,
        x: 17,
        y: 20,
        lastValue: 75,
        diff: 1,
        variance: 1.3333
    }, {
        code: 5504,
        value: 0,
        x: 17,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9576104,
        x: 18,
        y: 0,
        lastValue: 10486589,
        diff: -910485,
        variance: -8.6824
    }, {
        code: 5102,
        value: 1370811,
        x: 18,
        y: 1,
        lastValue: 1375026,
        diff: -4215,
        variance: -0.3065
    }, {
        code: 5103,
        value: 3294774,
        x: 18,
        y: 2,
        lastValue: 3556539,
        diff: -261765,
        variance: -7.3601
    }, {
        code: 5104,
        value: 8697397,
        x: 18,
        y: 3,
        lastValue: 10488497,
        diff: -1791100,
        variance: -17.0768
    }, {
        code: 5105,
        value: 1958351,
        x: 18,
        y: 4,
        lastValue: 2000667,
        diff: -42316,
        variance: -2.1151
    }, {
        code: 5203,
        value: 206659108,
        x: 18,
        y: 5,
        lastValue: 189092508,
        diff: 17566600,
        variance: 9.2900
    }, {
        code: 5204,
        value: 10600448,
        x: 18,
        y: 6,
        lastValue: 13198435,
        diff: -2597987,
        variance: -19.6841
    }, {
        code: 5206,
        value: 330254,
        x: 18,
        y: 7,
        lastValue: 338196,
        diff: -7942,
        variance: -2.3483
    }, {
        code: 5207,
        value: 28609750,
        x: 18,
        y: 8,
        lastValue: 26613799,
        diff: 1995951,
        variance: 7.4997
    }, {
        code: 5301,
        value: 0,
        x: 18,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 62792515,
        x: 18,
        y: 10,
        lastValue: 58564356,
        diff: 4228159,
        variance: 7.2197
    }, {
        code: 5303,
        value: 7969285,
        x: 18,
        y: 11,
        lastValue: 8674798,
        diff: -705513,
        variance: -8.1329
    }, {
        code: 5304,
        value: 10243892,
        x: 18,
        y: 12,
        lastValue: 10554998,
        diff: -311106,
        variance: -2.9475
    }, {
        code: 5305,
        value: 1520348,
        x: 18,
        y: 13,
        lastValue: 1503846,
        diff: 16502,
        variance: 1.0973
    }, {
        code: 5401,
        value: 31891856,
        x: 18,
        y: 14,
        lastValue: 28299842,
        diff: 3592014,
        variance: 12.6927
    }, {
        code: 5402,
        value: 895,
        x: 18,
        y: 15,
        lastValue: 2000,
        diff: -1105,
        variance: -55.2500
    }, {
        code: 5403,
        value: 20076130,
        x: 18,
        y: 16,
        lastValue: 17078491,
        diff: 2997639,
        variance: 17.5521
    }, {
        code: 5404,
        value: 12679463,
        x: 18,
        y: 17,
        lastValue: 11463434,
        diff: 1216029,
        variance: 10.6079
    }, {
        code: 5501,
        value: 347798,
        x: 18,
        y: 18,
        lastValue: 304643,
        diff: 43155,
        variance: 14.1658
    }, {
        code: 5502,
        value: 3736,
        x: 18,
        y: 19,
        lastValue: 3351,
        diff: 385,
        variance: 11.4891
    }, {
        code: 5503,
        value: 78,
        x: 18,
        y: 20,
        lastValue: 76,
        diff: 2,
        variance: 2.6316
    }, {
        code: 5504,
        value: 0,
        x: 18,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9648920,
        x: 19,
        y: 0,
        lastValue: 9576104,
        diff: 72816,
        variance: 0.7604
    }, {
        code: 5102,
        value: 1452954,
        x: 19,
        y: 1,
        lastValue: 1370811,
        diff: 82143,
        variance: 5.9923
    }, {
        code: 5103,
        value: 3609184,
        x: 19,
        y: 2,
        lastValue: 3294774,
        diff: 314410,
        variance: 9.5427
    }, {
        code: 5104,
        value: 11285953,
        x: 19,
        y: 3,
        lastValue: 8697397,
        diff: 2588556,
        variance: 29.7624
    }, {
        code: 5105,
        value: 2134165,
        x: 19,
        y: 4,
        lastValue: 1958351,
        diff: 175814,
        variance: 8.9777
    }, {
        code: 5203,
        value: 174400208,
        x: 19,
        y: 5,
        lastValue: 206659108,
        diff: -32258900,
        variance: -15.6097
    }, {
        code: 5204,
        value: 14524376,
        x: 19,
        y: 6,
        lastValue: 10600448,
        diff: 3923928,
        variance: 37.0166
    }, {
        code: 5206,
        value: 330348,
        x: 19,
        y: 7,
        lastValue: 330254,
        diff: 94,
        variance: 0.0285
    }, {
        code: 5207,
        value: 30203374,
        x: 19,
        y: 8,
        lastValue: 28609750,
        diff: 1593624,
        variance: 5.5702
    }, {
        code: 5301,
        value: 0,
        x: 19,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 65572712,
        x: 19,
        y: 10,
        lastValue: 62792515,
        diff: 2780197,
        variance: 4.4276
    }, {
        code: 5303,
        value: 9582424,
        x: 19,
        y: 11,
        lastValue: 7969285,
        diff: 1613139,
        variance: 20.2420
    }, {
        code: 5304,
        value: 10881051,
        x: 19,
        y: 12,
        lastValue: 10243892,
        diff: 637159,
        variance: 6.2199
    }, {
        code: 5305,
        value: 1416923,
        x: 19,
        y: 13,
        lastValue: 1520348,
        diff: -103425,
        variance: -6.8027
    }, {
        code: 5401,
        value: 29748811,
        x: 19,
        y: 14,
        lastValue: 31891856,
        diff: -2143045,
        variance: -6.7197
    }, {
        code: 5402,
        value: 785,
        x: 19,
        y: 15,
        lastValue: 895,
        diff: -110,
        variance: -12.2905
    }, {
        code: 5403,
        value: 20095000,
        x: 19,
        y: 16,
        lastValue: 20076130,
        diff: 18870,
        variance: 0.0940
    }, {
        code: 5404,
        value: 11424314,
        x: 19,
        y: 17,
        lastValue: 12679463,
        diff: -1255149,
        variance: -9.8991
    }, {
        code: 5501,
        value: 307364,
        x: 19,
        y: 18,
        lastValue: 347798,
        diff: -40434,
        variance: -11.6257
    }, {
        code: 5502,
        value: 4443,
        x: 19,
        y: 19,
        lastValue: 3736,
        diff: 707,
        variance: 18.9240
    }, {
        code: 5503,
        value: 79,
        x: 19,
        y: 20,
        lastValue: 78,
        diff: 1,
        variance: 1.2821
    }, {
        code: 5504,
        value: 0,
        x: 19,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 10866275,
        x: 20,
        y: 0,
        lastValue: 9648920,
        diff: 1217355,
        variance: 12.6165
    }, {
        code: 5102,
        value: 1419848,
        x: 20,
        y: 1,
        lastValue: 1452954,
        diff: -33106,
        variance: -2.2785
    }, {
        code: 5103,
        value: 3431917,
        x: 20,
        y: 2,
        lastValue: 3609184,
        diff: -177267,
        variance: -4.9116
    }, {
        code: 5104,
        value: 15124780,
        x: 20,
        y: 3,
        lastValue: 11285953,
        diff: 3838827,
        variance: 34.0142
    }, {
        code: 5105,
        value: 2368494,
        x: 20,
        y: 4,
        lastValue: 2134165,
        diff: 234329,
        variance: 10.9799
    }, {
        code: 5203,
        value: 212904600,
        x: 20,
        y: 5,
        lastValue: 174400208,
        diff: 38504392,
        variance: 22.0782
    }, {
        code: 5204,
        value: 16320186,
        x: 20,
        y: 6,
        lastValue: 14524376,
        diff: 1795810,
        variance: 12.3641
    }, {
        code: 5206,
        value: 322788,
        x: 20,
        y: 7,
        lastValue: 330348,
        diff: -7560,
        variance: -2.2885
    }, {
        code: 5207,
        value: 37738912,
        x: 20,
        y: 8,
        lastValue: 30203374,
        diff: 7535538,
        variance: 24.9493
    }, {
        code: 5301,
        value: 0,
        x: 20,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 62254718,
        x: 20,
        y: 10,
        lastValue: 65572712,
        diff: -3317994,
        variance: -5.0600
    }, {
        code: 5303,
        value: 9423172,
        x: 20,
        y: 11,
        lastValue: 9582424,
        diff: -159252,
        variance: -1.6619
    }, {
        code: 5304,
        value: 12054461,
        x: 20,
        y: 12,
        lastValue: 10881051,
        diff: 1173410,
        variance: 10.7840
    }, {
        code: 5305,
        value: 1371826,
        x: 20,
        y: 13,
        lastValue: 1416923,
        diff: -45097,
        variance: -3.1827
    }, {
        code: 5401,
        value: 27908829,
        x: 20,
        y: 14,
        lastValue: 29748811,
        diff: -1839982,
        variance: -6.1851
    }, {
        code: 5402,
        value: 0,
        x: 20,
        y: 15,
        lastValue: 785,
        diff: -785,
        variance: -100.0000
    }, {
        code: 5403,
        value: 21398540,
        x: 20,
        y: 16,
        lastValue: 20095000,
        diff: 1303540,
        variance: 6.4869
    }, {
        code: 5404,
        value: 11532907,
        x: 20,
        y: 17,
        lastValue: 11424314,
        diff: 108593,
        variance: 0.9505
    }, {
        code: 5501,
        value: 324880,
        x: 20,
        y: 18,
        lastValue: 307364,
        diff: 17516,
        variance: 5.6988
    }, {
        code: 5502,
        value: 5304,
        x: 20,
        y: 19,
        lastValue: 4443,
        diff: 861,
        variance: 19.3788
    }, {
        code: 5503,
        value: 80,
        x: 20,
        y: 20,
        lastValue: 79,
        diff: 1,
        variance: 1.2658
    }, {
        code: 5504,
        value: 0,
        x: 20,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 10591102,
        x: 21,
        y: 0,
        lastValue: 10866275,
        diff: -275173,
        variance: -2.5324
    }, {
        code: 5102,
        value: 1514541,
        x: 21,
        y: 1,
        lastValue: 1419848,
        diff: 94693,
        variance: 6.6692
    }, {
        code: 5103,
        value: 3625617,
        x: 21,
        y: 2,
        lastValue: 3431917,
        diff: 193700,
        variance: 5.6441
    }, {
        code: 5104,
        value: 8960695,
        x: 21,
        y: 3,
        lastValue: 15124780,
        diff: -6164085,
        variance: -40.7549
    }, {
        code: 5105,
        value: 2357880,
        x: 21,
        y: 4,
        lastValue: 2368494,
        diff: -10614,
        variance: -0.4481
    }, {
        code: 5203,
        value: 215702300,
        x: 21,
        y: 5,
        lastValue: 212904600,
        diff: 2797700,
        variance: 1.3141
    }, {
        code: 5204,
        value: 12355044,
        x: 21,
        y: 6,
        lastValue: 16320186,
        diff: -3965142,
        variance: -24.2959
    }, {
        code: 5206,
        value: 303874,
        x: 21,
        y: 7,
        lastValue: 322788,
        diff: -18914,
        variance: -5.8596
    }, {
        code: 5207,
        value: 35141301,
        x: 21,
        y: 8,
        lastValue: 37738912,
        diff: -2597611,
        variance: -6.8831
    }, {
        code: 5301,
        value: 0,
        x: 21,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 63697517,
        x: 21,
        y: 10,
        lastValue: 62254718,
        diff: 1442799,
        variance: 2.3176
    }, {
        code: 5303,
        value: 9067409,
        x: 21,
        y: 11,
        lastValue: 9423172,
        diff: -355763,
        variance: -3.7754
    }, {
        code: 5304,
        value: 10183012,
        x: 21,
        y: 12,
        lastValue: 12054461,
        diff: -1871449,
        variance: -15.5249
    }, {
        code: 5305,
        value: 1541653,
        x: 21,
        y: 13,
        lastValue: 1371826,
        diff: 169827,
        variance: 12.3796
    }, {
        code: 5401,
        value: 37655287,
        x: 21,
        y: 14,
        lastValue: 27908829,
        diff: 9746458,
        variance: 34.9225
    }, {
        code: 5402,
        value: 0,
        x: 21,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 22615185,
        x: 21,
        y: 16,
        lastValue: 21398540,
        diff: 1216645,
        variance: 5.6856
    }, {
        code: 5404,
        value: 13232309,
        x: 21,
        y: 17,
        lastValue: 11532907,
        diff: 1699402,
        variance: 14.7352
    }, {
        code: 5501,
        value: 382468,
        x: 21,
        y: 18,
        lastValue: 324880,
        diff: 57588,
        variance: 17.7259
    }, {
        code: 5502,
        value: 5006,
        x: 21,
        y: 19,
        lastValue: 5304,
        diff: -298,
        variance: -5.6184
    }, {
        code: 5503,
        value: 80,
        x: 21,
        y: 20,
        lastValue: 80,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 21,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 10155329,
        x: 22,
        y: 0,
        lastValue: 10591102,
        diff: -435773,
        variance: -4.1145
    }, {
        code: 5102,
        value: 1528633,
        x: 22,
        y: 1,
        lastValue: 1514541,
        diff: 14092,
        variance: 0.9304
    }, {
        code: 5103,
        value: 3797160,
        x: 22,
        y: 2,
        lastValue: 3625617,
        diff: 171543,
        variance: 4.7314
    }, {
        code: 5104,
        value: 4547571,
        x: 22,
        y: 3,
        lastValue: 8960695,
        diff: -4413124,
        variance: -49.2498
    }, {
        code: 5105,
        value: 2456919,
        x: 22,
        y: 4,
        lastValue: 2357880,
        diff: 99039,
        variance: 4.2003
    }, {
        code: 5203,
        value: 111961000,
        x: 22,
        y: 5,
        lastValue: 215702300,
        diff: -103741300,
        variance: -48.0947
    }, {
        code: 5204,
        value: 15484176,
        x: 22,
        y: 6,
        lastValue: 12355044,
        diff: 3129132,
        variance: 25.3268
    }, {
        code: 5206,
        value: 330218,
        x: 22,
        y: 7,
        lastValue: 303874,
        diff: 26344,
        variance: 8.6694
    }, {
        code: 5207,
        value: 31153347,
        x: 22,
        y: 8,
        lastValue: 35141301,
        diff: -3987954,
        variance: -11.3483
    }, {
        code: 5301,
        value: 0,
        x: 22,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 71507153,
        x: 22,
        y: 10,
        lastValue: 63697517,
        diff: 7809636,
        variance: 12.2605
    }, {
        code: 5303,
        value: 10538337,
        x: 22,
        y: 11,
        lastValue: 9067409,
        diff: 1470928,
        variance: 16.2221
    }, {
        code: 5304,
        value: 12905920,
        x: 22,
        y: 12,
        lastValue: 10183012,
        diff: 2722908,
        variance: 26.7397
    }, {
        code: 5305,
        value: 1614944,
        x: 22,
        y: 13,
        lastValue: 1541653,
        diff: 73291,
        variance: 4.7541
    }, {
        code: 5401,
        value: 33915188,
        x: 22,
        y: 14,
        lastValue: 37655287,
        diff: -3740099,
        variance: -9.9325
    }, {
        code: 5402,
        value: 0,
        x: 22,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 21806390,
        x: 22,
        y: 16,
        lastValue: 22615185,
        diff: -808795,
        variance: -3.5763
    }, {
        code: 5404,
        value: 13092523,
        x: 22,
        y: 17,
        lastValue: 13232309,
        diff: -139786,
        variance: -1.0564
    }, {
        code: 5501,
        value: 281894,
        x: 22,
        y: 18,
        lastValue: 382468,
        diff: -100574,
        variance: -26.2961
    }, {
        code: 5502,
        value: 5276,
        x: 22,
        y: 19,
        lastValue: 5006,
        diff: 270,
        variance: 5.3935
    }, {
        code: 5503,
        value: 56,
        x: 22,
        y: 20,
        lastValue: 80,
        diff: -24,
        variance: -30.0000
    }, {
        code: 5504,
        value: 0,
        x: 22,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9654463,
        x: 23,
        y: 0,
        lastValue: 10155329,
        diff: -500866,
        variance: -4.9321
    }, {
        code: 5102,
        value: 1425486,
        x: 23,
        y: 1,
        lastValue: 1528633,
        diff: -103147,
        variance: -6.7477
    }, {
        code: 5103,
        value: 3992281,
        x: 23,
        y: 2,
        lastValue: 3797160,
        diff: 195121,
        variance: 5.1386
    }, {
        code: 5104,
        value: 5059644,
        x: 23,
        y: 3,
        lastValue: 4547571,
        diff: 512073,
        variance: 11.2604
    }, {
        code: 5105,
        value: 3435085,
        x: 23,
        y: 4,
        lastValue: 2456919,
        diff: 978166,
        variance: 39.8127
    }, {
        code: 5203,
        value: 201657500,
        x: 23,
        y: 5,
        lastValue: 111961000,
        diff: 89696500,
        variance: 80.1141
    }, {
        code: 5204,
        value: 15134773,
        x: 23,
        y: 6,
        lastValue: 15484176,
        diff: -349403,
        variance: -2.2565
    }, {
        code: 5206,
        value: 385925,
        x: 23,
        y: 7,
        lastValue: 330218,
        diff: 55707,
        variance: 16.8698
    }, {
        code: 5207,
        value: 34748816,
        x: 23,
        y: 8,
        lastValue: 31153347,
        diff: 3595469,
        variance: 11.5412
    }, {
        code: 5301,
        value: 0,
        x: 23,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 76985162,
        x: 23,
        y: 10,
        lastValue: 71507153,
        diff: 5478009,
        variance: 7.6608
    }, {
        code: 5303,
        value: 11062974,
        x: 23,
        y: 11,
        lastValue: 10538337,
        diff: 524637,
        variance: 4.9784
    }, {
        code: 5304,
        value: 13941813,
        x: 23,
        y: 12,
        lastValue: 12905920,
        diff: 1035893,
        variance: 8.0265
    }, {
        code: 5305,
        value: 1670660,
        x: 23,
        y: 13,
        lastValue: 1614944,
        diff: 55716,
        variance: 3.4500
    }, {
        code: 5401,
        value: 34140970,
        x: 23,
        y: 14,
        lastValue: 33915188,
        diff: 225782,
        variance: 0.6657
    }, {
        code: 5402,
        value: 0,
        x: 23,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 23516614,
        x: 23,
        y: 16,
        lastValue: 21806390,
        diff: 1710224,
        variance: 7.8428
    }, {
        code: 5404,
        value: 13241291,
        x: 23,
        y: 17,
        lastValue: 13092523,
        diff: 148768,
        variance: 1.1363
    }, {
        code: 5501,
        value: 392474,
        x: 23,
        y: 18,
        lastValue: 281894,
        diff: 110580,
        variance: 39.2275
    }, {
        code: 5502,
        value: 3993,
        x: 23,
        y: 19,
        lastValue: 5276,
        diff: -1283,
        variance: -24.3177
    }, {
        code: 5503,
        value: 68,
        x: 23,
        y: 20,
        lastValue: 56,
        diff: 12,
        variance: 21.4286
    }, {
        code: 5504,
        value: 0,
        x: 23,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 12367842,
        x: 24,
        y: 0,
        lastValue: 9654463,
        diff: 2713379,
        variance: 28.1049
    }, {
        code: 5102,
        value: 1429347,
        x: 24,
        y: 1,
        lastValue: 1425486,
        diff: 3861,
        variance: 0.2709
    }, {
        code: 5103,
        value: 4027176,
        x: 24,
        y: 2,
        lastValue: 3992281,
        diff: 34895,
        variance: 0.8741
    }, {
        code: 5104,
        value: 8718352,
        x: 24,
        y: 3,
        lastValue: 5059644,
        diff: 3658708,
        variance: 72.3116
    }, {
        code: 5105,
        value: 4090422,
        x: 24,
        y: 4,
        lastValue: 3435085,
        diff: 655337,
        variance: 19.0778
    }, {
        code: 5203,
        value: 232422908,
        x: 24,
        y: 5,
        lastValue: 201657500,
        diff: 30765408,
        variance: 15.2563
    }, {
        code: 5204,
        value: 16552483,
        x: 24,
        y: 6,
        lastValue: 15134773,
        diff: 1417710,
        variance: 9.3672
    }, {
        code: 5206,
        value: 369252,
        x: 24,
        y: 7,
        lastValue: 385925,
        diff: -16673,
        variance: -4.3203
    }, {
        code: 5207,
        value: 38314330,
        x: 24,
        y: 8,
        lastValue: 34748816,
        diff: 3565514,
        variance: 10.2608
    }, {
        code: 5301,
        value: 0,
        x: 24,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 67535637,
        x: 24,
        y: 10,
        lastValue: 76985162,
        diff: -9449525,
        variance: -12.2745
    }, {
        code: 5303,
        value: 9219240,
        x: 24,
        y: 11,
        lastValue: 11062974,
        diff: -1843734,
        variance: -16.6658
    }, {
        code: 5304,
        value: 14224852,
        x: 24,
        y: 12,
        lastValue: 13941813,
        diff: 283039,
        variance: 2.0301
    }, {
        code: 5305,
        value: 2168812,
        x: 24,
        y: 13,
        lastValue: 1670660,
        diff: 498152,
        variance: 29.8177
    }, {
        code: 5401,
        value: 35659532,
        x: 24,
        y: 14,
        lastValue: 34140970,
        diff: 1518562,
        variance: 4.4479
    }, {
        code: 5402,
        value: 0,
        x: 24,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 22403019,
        x: 24,
        y: 16,
        lastValue: 23516614,
        diff: -1113595,
        variance: -4.7354
    }, {
        code: 5404,
        value: 15552925,
        x: 24,
        y: 17,
        lastValue: 13241291,
        diff: 2311634,
        variance: 17.4578
    }, {
        code: 5501,
        value: 466034,
        x: 24,
        y: 18,
        lastValue: 392474,
        diff: 73560,
        variance: 18.7426
    }, {
        code: 5502,
        value: 5074,
        x: 24,
        y: 19,
        lastValue: 3993,
        diff: 1081,
        variance: 27.0724
    }, {
        code: 5503,
        value: 64,
        x: 24,
        y: 20,
        lastValue: 68,
        diff: -4,
        variance: -5.8824
    }, {
        code: 5504,
        value: 0,
        x: 24,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 12765028,
        x: 25,
        y: 0,
        lastValue: 12367842,
        diff: 397186,
        variance: 3.2114
    }, {
        code: 5102,
        value: 1630878,
        x: 25,
        y: 1,
        lastValue: 1429347,
        diff: 201531,
        variance: 14.0995
    }, {
        code: 5103,
        value: 3953052,
        x: 25,
        y: 2,
        lastValue: 4027176,
        diff: -74124,
        variance: -1.8406
    }, {
        code: 5104,
        value: 8813095,
        x: 25,
        y: 3,
        lastValue: 8718352,
        diff: 94743,
        variance: 1.0867
    }, {
        code: 5105,
        value: 5667611,
        x: 25,
        y: 4,
        lastValue: 4090422,
        diff: 1577189,
        variance: 38.5581
    }, {
        code: 5203,
        value: 214854508,
        x: 25,
        y: 5,
        lastValue: 232422908,
        diff: -17568400,
        variance: -7.5588
    }, {
        code: 5204,
        value: 14449372,
        x: 25,
        y: 6,
        lastValue: 16552483,
        diff: -2103111,
        variance: -12.7057
    }, {
        code: 5206,
        value: 359683,
        x: 25,
        y: 7,
        lastValue: 369252,
        diff: -9569,
        variance: -2.5915
    }, {
        code: 5207,
        value: 37463130,
        x: 25,
        y: 8,
        lastValue: 38314330,
        diff: -851200,
        variance: -2.2216
    }, {
        code: 5301,
        value: 0,
        x: 25,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 74691575,
        x: 25,
        y: 10,
        lastValue: 67535637,
        diff: 7155938,
        variance: 10.5958
    }, {
        code: 5303,
        value: 10289781,
        x: 25,
        y: 11,
        lastValue: 9219240,
        diff: 1070541,
        variance: 11.6120
    }, {
        code: 5304,
        value: 15348416,
        x: 25,
        y: 12,
        lastValue: 14224852,
        diff: 1123564,
        variance: 7.8986
    }, {
        code: 5305,
        value: 2589616,
        x: 25,
        y: 13,
        lastValue: 2168812,
        diff: 420804,
        variance: 19.4025
    }, {
        code: 5401,
        value: 34593791,
        x: 25,
        y: 14,
        lastValue: 35659532,
        diff: -1065741,
        variance: -2.9887
    }, {
        code: 5402,
        value: 0,
        x: 25,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 25319794,
        x: 25,
        y: 16,
        lastValue: 22403019,
        diff: 2916775,
        variance: 13.0196
    }, {
        code: 5404,
        value: 14917173,
        x: 25,
        y: 17,
        lastValue: 15552925,
        diff: -635752,
        variance: -4.0877
    }, {
        code: 5501,
        value: 465400,
        x: 25,
        y: 18,
        lastValue: 466034,
        diff: -634,
        variance: -0.1360
    }, {
        code: 5502,
        value: 4651,
        x: 25,
        y: 19,
        lastValue: 5074,
        diff: -423,
        variance: -8.3366
    }, {
        code: 5503,
        value: 68,
        x: 25,
        y: 20,
        lastValue: 64,
        diff: 4,
        variance: 6.2500
    }, {
        code: 5504,
        value: 0,
        x: 25,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 11280865,
        x: 26,
        y: 0,
        lastValue: 12765028,
        diff: -1484163,
        variance: -11.6268
    }, {
        code: 5102,
        value: 1665285,
        x: 26,
        y: 1,
        lastValue: 1630878,
        diff: 34407,
        variance: 2.1097
    }, {
        code: 5103,
        value: 3886900,
        x: 26,
        y: 2,
        lastValue: 3953052,
        diff: -66152,
        variance: -1.6734
    }, {
        code: 5104,
        value: 8092866,
        x: 26,
        y: 3,
        lastValue: 8813095,
        diff: -720229,
        variance: -8.1723
    }, {
        code: 5105,
        value: 6663205,
        x: 26,
        y: 4,
        lastValue: 5667611,
        diff: 995594,
        variance: 17.5664
    }, {
        code: 5203,
        value: 188156800,
        x: 26,
        y: 5,
        lastValue: 214854508,
        diff: -26697708,
        variance: -12.4259
    }, {
        code: 5204,
        value: 14344502,
        x: 26,
        y: 6,
        lastValue: 14449372,
        diff: -104870,
        variance: -0.7258
    }, {
        code: 5206,
        value: 354862,
        x: 26,
        y: 7,
        lastValue: 359683,
        diff: -4821,
        variance: -1.3403
    }, {
        code: 5207,
        value: 40999380,
        x: 26,
        y: 8,
        lastValue: 37463130,
        diff: 3536250,
        variance: 9.4393
    }, {
        code: 5301,
        value: 0,
        x: 26,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 83230172,
        x: 26,
        y: 10,
        lastValue: 74691575,
        diff: 8538597,
        variance: 11.4318
    }, {
        code: 5303,
        value: 8398311,
        x: 26,
        y: 11,
        lastValue: 10289781,
        diff: -1891470,
        variance: -18.3820
    }, {
        code: 5304,
        value: 13160073,
        x: 26,
        y: 12,
        lastValue: 15348416,
        diff: -2188343,
        variance: -14.2578
    }, {
        code: 5305,
        value: 2674395,
        x: 26,
        y: 13,
        lastValue: 2589616,
        diff: 84779,
        variance: 3.2738
    }, {
        code: 5401,
        value: 32732242,
        x: 26,
        y: 14,
        lastValue: 34593791,
        diff: -1861549,
        variance: -5.3812
    }, {
        code: 5402,
        value: 0,
        x: 26,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 21530798,
        x: 26,
        y: 16,
        lastValue: 25319794,
        diff: -3788996,
        variance: -14.9646
    }, {
        code: 5404,
        value: 15559384,
        x: 26,
        y: 17,
        lastValue: 14917173,
        diff: 642211,
        variance: 4.3052
    }, {
        code: 5501,
        value: 382553,
        x: 26,
        y: 18,
        lastValue: 465400,
        diff: -82847,
        variance: -17.8012
    }, {
        code: 5502,
        value: 3133,
        x: 26,
        y: 19,
        lastValue: 4651,
        diff: -1518,
        variance: -32.6381
    }, {
        code: 5503,
        value: 68,
        x: 26,
        y: 20,
        lastValue: 68,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 26,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 14371512,
        x: 27,
        y: 0,
        lastValue: 11280865,
        diff: 3090647,
        variance: 27.3973
    }, {
        code: 5102,
        value: 1686781,
        x: 27,
        y: 1,
        lastValue: 1665285,
        diff: 21496,
        variance: 1.2908
    }, {
        code: 5103,
        value: 4478610,
        x: 27,
        y: 2,
        lastValue: 3886900,
        diff: 591710,
        variance: 15.2232
    }, {
        code: 5104,
        value: 7988856,
        x: 27,
        y: 3,
        lastValue: 8092866,
        diff: -104010,
        variance: -1.2852
    }, {
        code: 5105,
        value: 7917749,
        x: 27,
        y: 4,
        lastValue: 6663205,
        diff: 1254544,
        variance: 18.8279
    }, {
        code: 5203,
        value: 130563200,
        x: 27,
        y: 5,
        lastValue: 188156800,
        diff: -57593600,
        variance: -30.6094
    }, {
        code: 5204,
        value: 13325816,
        x: 27,
        y: 6,
        lastValue: 14344502,
        diff: -1018686,
        variance: -7.1016
    }, {
        code: 5206,
        value: 364693,
        x: 27,
        y: 7,
        lastValue: 354862,
        diff: 9831,
        variance: 2.7704
    }, {
        code: 5207,
        value: 39020645,
        x: 27,
        y: 8,
        lastValue: 40999380,
        diff: -1978735,
        variance: -4.8263
    }, {
        code: 5301,
        value: 0,
        x: 27,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 81430415,
        x: 27,
        y: 10,
        lastValue: 83230172,
        diff: -1799757,
        variance: -2.1624
    }, {
        code: 5303,
        value: 11077643,
        x: 27,
        y: 11,
        lastValue: 8398311,
        diff: 2679332,
        variance: 31.9032
    }, {
        code: 5304,
        value: 16946481,
        x: 27,
        y: 12,
        lastValue: 13160073,
        diff: 3786408,
        variance: 28.7719
    }, {
        code: 5305,
        value: 2323980,
        x: 27,
        y: 13,
        lastValue: 2674395,
        diff: -350415,
        variance: -13.1026
    }, {
        code: 5401,
        value: 32225357,
        x: 27,
        y: 14,
        lastValue: 32732242,
        diff: -506885,
        variance: -1.5486
    }, {
        code: 5402,
        value: 0,
        x: 27,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 20728564,
        x: 27,
        y: 16,
        lastValue: 21530798,
        diff: -802234,
        variance: -3.7260
    }, {
        code: 5404,
        value: 18250219,
        x: 27,
        y: 17,
        lastValue: 15559384,
        diff: 2690835,
        variance: 17.2940
    }, {
        code: 5501,
        value: 345174,
        x: 27,
        y: 18,
        lastValue: 382553,
        diff: -37379,
        variance: -9.7709
    }, {
        code: 5502,
        value: 4471,
        x: 27,
        y: 19,
        lastValue: 3133,
        diff: 1338,
        variance: 42.7067
    }, {
        code: 5503,
        value: 68,
        x: 27,
        y: 20,
        lastValue: 68,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 27,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 14516708,
        x: 28,
        y: 0,
        lastValue: 14371512,
        diff: 145196,
        variance: 1.0103
    }, {
        code: 5102,
        value: 1674734,
        x: 28,
        y: 1,
        lastValue: 1686781,
        diff: -12047,
        variance: -0.7142
    }, {
        code: 5103,
        value: 4965240,
        x: 28,
        y: 2,
        lastValue: 4478610,
        diff: 486630,
        variance: 10.8656
    }, {
        code: 5104,
        value: 12756921,
        x: 28,
        y: 3,
        lastValue: 7988856,
        diff: 4768065,
        variance: 59.6840
    }, {
        code: 5105,
        value: 7670586,
        x: 28,
        y: 4,
        lastValue: 7917749,
        diff: -247163,
        variance: -3.1216
    }, {
        code: 5203,
        value: 197890008,
        x: 28,
        y: 5,
        lastValue: 130563200,
        diff: 67326808,
        variance: 51.5665
    }, {
        code: 5204,
        value: 13791875,
        x: 28,
        y: 6,
        lastValue: 13325816,
        diff: 466059,
        variance: 3.4974
    }, {
        code: 5206,
        value: 340236,
        x: 28,
        y: 7,
        lastValue: 364693,
        diff: -24457,
        variance: -6.7062
    }, {
        code: 5207,
        value: 36719474,
        x: 28,
        y: 8,
        lastValue: 39020645,
        diff: -2301171,
        variance: -5.8973
    }, {
        code: 5301,
        value: 0,
        x: 28,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 83231832,
        x: 28,
        y: 10,
        lastValue: 81430415,
        diff: 1801417,
        variance: 2.2122
    }, {
        code: 5303,
        value: 12614632,
        x: 28,
        y: 11,
        lastValue: 11077643,
        diff: 1536989,
        variance: 13.8747
    }, {
        code: 5304,
        value: 16329662,
        x: 28,
        y: 12,
        lastValue: 16946481,
        diff: -616819,
        variance: -3.6398
    }, {
        code: 5305,
        value: 2405179,
        x: 28,
        y: 13,
        lastValue: 2323980,
        diff: 81199,
        variance: 3.4940
    }, {
        code: 5401,
        value: 32572043,
        x: 28,
        y: 14,
        lastValue: 32225357,
        diff: 346686,
        variance: 1.0758
    }, {
        code: 5402,
        value: 0,
        x: 28,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 22308983,
        x: 28,
        y: 16,
        lastValue: 20728564,
        diff: 1580419,
        variance: 7.6244
    }, {
        code: 5404,
        value: 16726984,
        x: 28,
        y: 17,
        lastValue: 18250219,
        diff: -1523235,
        variance: -8.3464
    }, {
        code: 5501,
        value: 355378,
        x: 28,
        y: 18,
        lastValue: 345174,
        diff: 10204,
        variance: 2.9562
    }, {
        code: 5502,
        value: 3960,
        x: 28,
        y: 19,
        lastValue: 4471,
        diff: -511,
        variance: -11.4292
    }, {
        code: 5503,
        value: 68,
        x: 28,
        y: 20,
        lastValue: 68,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5504,
        value: 0,
        x: 28,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 13007348,
        x: 29,
        y: 0,
        lastValue: 14516708,
        diff: -1509360,
        variance: -10.3974
    }, {
        code: 5102,
        value: 1667114,
        x: 29,
        y: 1,
        lastValue: 1674734,
        diff: -7620,
        variance: -0.4550
    }, {
        code: 5103,
        value: 5261886,
        x: 29,
        y: 2,
        lastValue: 4965240,
        diff: 296646,
        variance: 5.9745
    }, {
        code: 5104,
        value: 9496134,
        x: 29,
        y: 3,
        lastValue: 12756921,
        diff: -3260787,
        variance: -25.5609
    }, {
        code: 5105,
        value: 8254032,
        x: 29,
        y: 4,
        lastValue: 7670586,
        diff: 583446,
        variance: 7.6063
    }, {
        code: 5203,
        value: 208598000,
        x: 29,
        y: 5,
        lastValue: 197890008,
        diff: 10707992,
        variance: 5.4111
    }, {
        code: 5204,
        value: 17545741,
        x: 29,
        y: 6,
        lastValue: 13791875,
        diff: 3753866,
        variance: 27.2180
    }, {
        code: 5206,
        value: 279857,
        x: 29,
        y: 7,
        lastValue: 340236,
        diff: -60379,
        variance: -17.7462
    }, {
        code: 5207,
        value: 31810477,
        x: 29,
        y: 8,
        lastValue: 36719474,
        diff: -4908997,
        variance: -13.3689
    }, {
        code: 5301,
        value: 0,
        x: 29,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 101334558,
        x: 29,
        y: 10,
        lastValue: 83231832,
        diff: 18102726,
        variance: 21.7498
    }, {
        code: 5303,
        value: 12063894,
        x: 29,
        y: 11,
        lastValue: 12614632,
        diff: -550738,
        variance: -4.3659
    }, {
        code: 5304,
        value: 16443865,
        x: 29,
        y: 12,
        lastValue: 16329662,
        diff: 114203,
        variance: 0.6994
    }, {
        code: 5305,
        value: 2624748,
        x: 29,
        y: 13,
        lastValue: 2405179,
        diff: 219569,
        variance: 9.1290
    }, {
        code: 5401,
        value: 23171863,
        x: 29,
        y: 14,
        lastValue: 32572043,
        diff: -9400180,
        variance: -28.8597
    }, {
        code: 5402,
        value: 0,
        x: 29,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 18535335,
        x: 29,
        y: 16,
        lastValue: 22308983,
        diff: -3773648,
        variance: -16.9154
    }, {
        code: 5404,
        value: 12891095,
        x: 29,
        y: 17,
        lastValue: 16726984,
        diff: -3835889,
        variance: -22.9323
    }, {
        code: 5501,
        value: 380381,
        x: 29,
        y: 18,
        lastValue: 355378,
        diff: 25003,
        variance: 7.0356
    }, {
        code: 5502,
        value: 6214,
        x: 29,
        y: 19,
        lastValue: 3960,
        diff: 2254,
        variance: 56.9192
    }, {
        code: 5503,
        value: 73,
        x: 29,
        y: 20,
        lastValue: 68,
        diff: 5,
        variance: 7.3529
    }, {
        code: 5504,
        value: 0,
        x: 29,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 11846963,
        x: 30,
        y: 0,
        lastValue: 13007348,
        diff: -1160385,
        variance: -8.9210
    }, {
        code: 5102,
        value: 1954099,
        x: 30,
        y: 1,
        lastValue: 1667114,
        diff: 286985,
        variance: 17.2145
    }, {
        code: 5103,
        value: 5518670,
        x: 30,
        y: 2,
        lastValue: 5261886,
        diff: 256784,
        variance: 4.8801
    }, {
        code: 5104,
        value: 8787882,
        x: 30,
        y: 3,
        lastValue: 9496134,
        diff: -708252,
        variance: -7.4583
    }, {
        code: 5105,
        value: 8755252,
        x: 30,
        y: 4,
        lastValue: 8254032,
        diff: 501220,
        variance: 6.0724
    }, {
        code: 5203,
        value: 197279496,
        x: 30,
        y: 5,
        lastValue: 208598000,
        diff: -11318504,
        variance: -5.4260
    }, {
        code: 5204,
        value: 16945329,
        x: 30,
        y: 6,
        lastValue: 17545741,
        diff: -600412,
        variance: -3.4220
    }, {
        code: 5206,
        value: 300431,
        x: 30,
        y: 7,
        lastValue: 279857,
        diff: 20574,
        variance: 7.3516
    }, {
        code: 5207,
        value: 36589399,
        x: 30,
        y: 8,
        lastValue: 31810477,
        diff: 4778922,
        variance: 15.0231
    }, {
        code: 5301,
        value: 0,
        x: 30,
        y: 9,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5302,
        value: 103423162,
        x: 30,
        y: 10,
        lastValue: 101334558,
        diff: 2088604,
        variance: 2.0611
    }, {
        code: 5303,
        value: 11153689,
        x: 30,
        y: 11,
        lastValue: 12063894,
        diff: -910205,
        variance: -7.5449
    }, {
        code: 5304,
        value: 15821398,
        x: 30,
        y: 12,
        lastValue: 16443865,
        diff: -622467,
        variance: -3.7854
    }, {
        code: 5305,
        value: 2790297,
        x: 30,
        y: 13,
        lastValue: 2624748,
        diff: 165549,
        variance: 6.3072
    }, {
        code: 5401,
        value: 32006788,
        x: 30,
        y: 14,
        lastValue: 23171863,
        diff: 8834925,
        variance: 38.1278
    }, {
        code: 5402,
        value: 0,
        x: 30,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 24139904,
        x: 30,
        y: 16,
        lastValue: 18535335,
        diff: 5604569,
        variance: 30.2372
    }, {
        code: 5404,
        value: 16771600,
        x: 30,
        y: 17,
        lastValue: 12891095,
        diff: 3880505,
        variance: 30.1022
    }, {
        code: 5501,
        value: 377089,
        x: 30,
        y: 18,
        lastValue: 380381,
        diff: -3292,
        variance: -0.8654
    }, {
        code: 5502,
        value: 4528,
        x: 30,
        y: 19,
        lastValue: 6214,
        diff: -1686,
        variance: -27.1323
    }, {
        code: 5503,
        value: 17,
        x: 30,
        y: 20,
        lastValue: 73,
        diff: -56,
        variance: -76.7123
    }, {
        code: 5504,
        value: 0,
        x: 30,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 9000735,
        x: 31,
        y: 0,
        lastValue: 11846963,
        diff: -2846228,
        variance: -24.0250
    }, {
        code: 5102,
        value: 2084220,
        x: 31,
        y: 1,
        lastValue: 1954099,
        diff: 130121,
        variance: 6.6589
    }, {
        code: 5103,
        value: 5336673,
        x: 31,
        y: 2,
        lastValue: 5518670,
        diff: -181997,
        variance: -3.2978
    }, {
        code: 5104,
        value: 3444760,
        x: 31,
        y: 3,
        lastValue: 8787882,
        diff: -5343122,
        variance: -60.8010
    }, {
        code: 5105,
        value: 8663051,
        x: 31,
        y: 4,
        lastValue: 8755252,
        diff: -92201,
        variance: -1.0531
    }, {
        code: 5203,
        value: 245601608,
        x: 31,
        y: 5,
        lastValue: 197279496,
        diff: 48322112,
        variance: 24.4942
    }, {
        code: 5204,
        value: 19991191,
        x: 31,
        y: 6,
        lastValue: 16945329,
        diff: 3045862,
        variance: 17.9746
    }, {
        code: 5206,
        value: 350417,
        x: 31,
        y: 7,
        lastValue: 300431,
        diff: 49986,
        variance: 16.6381
    }, {
        code: 5207,
        value: 46147354,
        x: 31,
        y: 8,
        lastValue: 36589399,
        diff: 9557955,
        variance: 26.1222
    }, {
        code: 5301,
        value: 1209178,
        x: 31,
        y: 9,
        lastValue: 0,
        diff: 1209178,
        variance: 0.0000
    }, {
        code: 5302,
        value: 99583780,
        x: 31,
        y: 10,
        lastValue: 103423162,
        diff: -3839382,
        variance: -3.7123
    }, {
        code: 5303,
        value: 13037729,
        x: 31,
        y: 11,
        lastValue: 11153689,
        diff: 1884040,
        variance: 16.8916
    }, {
        code: 5304,
        value: 17479676,
        x: 31,
        y: 12,
        lastValue: 15821398,
        diff: 1658278,
        variance: 10.4812
    }, {
        code: 5305,
        value: 3116458,
        x: 31,
        y: 13,
        lastValue: 2790297,
        diff: 326161,
        variance: 11.6891
    }, {
        code: 5401,
        value: 19585387,
        x: 31,
        y: 14,
        lastValue: 32006788,
        diff: -12421401,
        variance: -38.8086
    }, {
        code: 5402,
        value: 0,
        x: 31,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 20014368,
        x: 31,
        y: 16,
        lastValue: 24139904,
        diff: -4125536,
        variance: -17.0901
    }, {
        code: 5404,
        value: 18501409,
        x: 31,
        y: 17,
        lastValue: 16771600,
        diff: 1729809,
        variance: 10.3139
    }, {
        code: 5501,
        value: 432789,
        x: 31,
        y: 18,
        lastValue: 377089,
        diff: 55700,
        variance: 14.7710
    }, {
        code: 5502,
        value: 5626,
        x: 31,
        y: 19,
        lastValue: 4528,
        diff: 1098,
        variance: 24.2491
    }, {
        code: 5503,
        value: 24,
        x: 31,
        y: 20,
        lastValue: 17,
        diff: 7,
        variance: 41.1765
    }, {
        code: 5504,
        value: 0,
        x: 31,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 13335962,
        x: 32,
        y: 0,
        lastValue: 9000735,
        diff: 4335227,
        variance: 48.1653
    }, {
        code: 5102,
        value: 2067340,
        x: 32,
        y: 1,
        lastValue: 2084220,
        diff: -16880,
        variance: -0.8099
    }, {
        code: 5103,
        value: 5172024,
        x: 32,
        y: 2,
        lastValue: 5336673,
        diff: -164649,
        variance: -3.0852
    }, {
        code: 5104,
        value: 10201096,
        x: 32,
        y: 3,
        lastValue: 3444760,
        diff: 6756336,
        variance: 196.1337
    }, {
        code: 5105,
        value: 9556692,
        x: 32,
        y: 4,
        lastValue: 8663051,
        diff: 893641,
        variance: 10.3155
    }, {
        code: 5203,
        value: 167486192,
        x: 32,
        y: 5,
        lastValue: 245601608,
        diff: -78115416,
        variance: -31.8057
    }, {
        code: 5204,
        value: 21091434,
        x: 32,
        y: 6,
        lastValue: 19991191,
        diff: 1100243,
        variance: 5.5036
    }, {
        code: 5206,
        value: 332173,
        x: 32,
        y: 7,
        lastValue: 350417,
        diff: -18244,
        variance: -5.2064
    }, {
        code: 5207,
        value: 46453686,
        x: 32,
        y: 8,
        lastValue: 46147354,
        diff: 306332,
        variance: 0.6638
    }, {
        code: 5301,
        value: 1189900,
        x: 32,
        y: 9,
        lastValue: 1209178,
        diff: -19278,
        variance: -1.5943
    }, {
        code: 5302,
        value: 107129606,
        x: 32,
        y: 10,
        lastValue: 99583780,
        diff: 7545826,
        variance: 7.5774
    }, {
        code: 5303,
        value: 12788389,
        x: 32,
        y: 11,
        lastValue: 13037729,
        diff: -249340,
        variance: -1.9124
    }, {
        code: 5304,
        value: 15908068,
        x: 32,
        y: 12,
        lastValue: 17479676,
        diff: -1571608,
        variance: -8.9911
    }, {
        code: 5305,
        value: 3401670,
        x: 32,
        y: 13,
        lastValue: 3116458,
        diff: 285212,
        variance: 9.1518
    }, {
        code: 5401,
        value: 21693337,
        x: 32,
        y: 14,
        lastValue: 19585387,
        diff: 2107950,
        variance: 10.7629
    }, {
        code: 5402,
        value: 0,
        x: 32,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 19125954,
        x: 32,
        y: 16,
        lastValue: 20014368,
        diff: -888414,
        variance: -4.4389
    }, {
        code: 5404,
        value: 19499147,
        x: 32,
        y: 17,
        lastValue: 18501409,
        diff: 997738,
        variance: 5.3928
    }, {
        code: 5501,
        value: 331866,
        x: 32,
        y: 18,
        lastValue: 432789,
        diff: -100923,
        variance: -23.3192
    }, {
        code: 5502,
        value: 5488,
        x: 32,
        y: 19,
        lastValue: 5626,
        diff: -138,
        variance: -2.4529
    }, {
        code: 5503,
        value: 18,
        x: 32,
        y: 20,
        lastValue: 24,
        diff: -6,
        variance: -25.0000
    }, {
        code: 5504,
        value: 0,
        x: 32,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 12203355,
        x: 33,
        y: 0,
        lastValue: 13335962,
        diff: -1132607,
        variance: -8.4929
    }, {
        code: 5102,
        value: 2170307,
        x: 33,
        y: 1,
        lastValue: 2067340,
        diff: 102967,
        variance: 4.9807
    }, {
        code: 5103,
        value: 5363196,
        x: 33,
        y: 2,
        lastValue: 5172024,
        diff: 191172,
        variance: 3.6963
    }, {
        code: 5104,
        value: 13559354,
        x: 33,
        y: 3,
        lastValue: 10201096,
        diff: 3358258,
        variance: 32.9206
    }, {
        code: 5105,
        value: 10221695,
        x: 33,
        y: 4,
        lastValue: 9556692,
        diff: 665003,
        variance: 6.9585
    }, {
        code: 5203,
        value: 262335892,
        x: 33,
        y: 5,
        lastValue: 167486192,
        diff: 94849700,
        variance: 56.6314
    }, {
        code: 5204,
        value: 20893980,
        x: 33,
        y: 6,
        lastValue: 21091434,
        diff: -197454,
        variance: -0.9362
    }, {
        code: 5206,
        value: 371291,
        x: 33,
        y: 7,
        lastValue: 332173,
        diff: 39118,
        variance: 11.7764
    }, {
        code: 5207,
        value: 48395304,
        x: 33,
        y: 8,
        lastValue: 46453686,
        diff: 1941618,
        variance: 4.1797
    }, {
        code: 5301,
        value: 807200,
        x: 33,
        y: 9,
        lastValue: 1189900,
        diff: -382700,
        variance: -32.1624
    }, {
        code: 5302,
        value: 103310116,
        x: 33,
        y: 10,
        lastValue: 107129606,
        diff: -3819490,
        variance: -3.5653
    }, {
        code: 5303,
        value: 12581986,
        x: 33,
        y: 11,
        lastValue: 12788389,
        diff: -206403,
        variance: -1.6140
    }, {
        code: 5304,
        value: 17038907,
        x: 33,
        y: 12,
        lastValue: 15908068,
        diff: 1130839,
        variance: 7.1086
    }, {
        code: 5305,
        value: 2697923,
        x: 33,
        y: 13,
        lastValue: 3401670,
        diff: -703747,
        variance: -20.6883
    }, {
        code: 5401,
        value: 19350727,
        x: 33,
        y: 14,
        lastValue: 21693337,
        diff: -2342610,
        variance: -10.7988
    }, {
        code: 5402,
        value: 0,
        x: 33,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 20133427,
        x: 33,
        y: 16,
        lastValue: 19125954,
        diff: 1007473,
        variance: 5.2676
    }, {
        code: 5404,
        value: 17223466,
        x: 33,
        y: 17,
        lastValue: 19499147,
        diff: -2275681,
        variance: -11.6707
    }, {
        code: 5501,
        value: 346895,
        x: 33,
        y: 18,
        lastValue: 331866,
        diff: 15029,
        variance: 4.5286
    }, {
        code: 5502,
        value: 7032,
        x: 33,
        y: 19,
        lastValue: 5488,
        diff: 1544,
        variance: 28.1341
    }, {
        code: 5503,
        value: 19,
        x: 33,
        y: 20,
        lastValue: 18,
        diff: 1,
        variance: 5.5556
    }, {
        code: 5504,
        value: 0,
        x: 33,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 13006934,
        x: 34,
        y: 0,
        lastValue: 12203355,
        diff: 803579,
        variance: 6.5849
    }, {
        code: 5102,
        value: 2010567,
        x: 34,
        y: 1,
        lastValue: 2170307,
        diff: -159740,
        variance: -7.3602
    }, {
        code: 5103,
        value: 4607431,
        x: 34,
        y: 2,
        lastValue: 5363196,
        diff: -755765,
        variance: -14.0917
    }, {
        code: 5104,
        value: 5115105,
        x: 34,
        y: 3,
        lastValue: 13559354,
        diff: -8444249,
        variance: -62.2762
    }, {
        code: 5105,
        value: 10210881,
        x: 34,
        y: 4,
        lastValue: 10221695,
        diff: -10814,
        variance: -0.1058
    }, {
        code: 5203,
        value: 195239892,
        x: 34,
        y: 5,
        lastValue: 262335892,
        diff: -67096000,
        variance: -25.5764
    }, {
        code: 5204,
        value: 21230716,
        x: 34,
        y: 6,
        lastValue: 20893980,
        diff: 336736,
        variance: 1.6116
    }, {
        code: 5206,
        value: 381349,
        x: 34,
        y: 7,
        lastValue: 371291,
        diff: 10058,
        variance: 2.7089
    }, {
        code: 5207,
        value: 53524180,
        x: 34,
        y: 8,
        lastValue: 48395304,
        diff: 5128876,
        variance: 10.5979
    }, {
        code: 5301,
        value: 578422,
        x: 34,
        y: 9,
        lastValue: 807200,
        diff: -228778,
        variance: -28.3422
    }, {
        code: 5302,
        value: 113802336,
        x: 34,
        y: 10,
        lastValue: 103310116,
        diff: 10492220,
        variance: 10.1560
    }, {
        code: 5303,
        value: 13522639,
        x: 34,
        y: 11,
        lastValue: 12581986,
        diff: 940653,
        variance: 7.4762
    }, {
        code: 5304,
        value: 18233026,
        x: 34,
        y: 12,
        lastValue: 17038907,
        diff: 1194119,
        variance: 7.0082
    }, {
        code: 5305,
        value: 2734804,
        x: 34,
        y: 13,
        lastValue: 2697923,
        diff: 36881,
        variance: 1.3670
    }, {
        code: 5401,
        value: 23480805,
        x: 34,
        y: 14,
        lastValue: 19350727,
        diff: 4130078,
        variance: 21.3433
    }, {
        code: 5402,
        value: 0,
        x: 34,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 22262452,
        x: 34,
        y: 16,
        lastValue: 20133427,
        diff: 2129025,
        variance: 10.5746
    }, {
        code: 5404,
        value: 16943239,
        x: 34,
        y: 17,
        lastValue: 17223466,
        diff: -280227,
        variance: -1.6270
    }, {
        code: 5501,
        value: 403167,
        x: 34,
        y: 18,
        lastValue: 346895,
        diff: 56272,
        variance: 16.2216
    }, {
        code: 5502,
        value: 8414,
        x: 34,
        y: 19,
        lastValue: 7032,
        diff: 1382,
        variance: 19.6530
    }, {
        code: 5503,
        value: 70,
        x: 34,
        y: 20,
        lastValue: 19,
        diff: 51,
        variance: 268.4211
    }, {
        code: 5504,
        value: 0,
        x: 34,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 16224347,
        x: 35,
        y: 0,
        lastValue: 13006934,
        diff: 3217413,
        variance: 24.7361
    }, {
        code: 5102,
        value: 2441160,
        x: 35,
        y: 1,
        lastValue: 2010567,
        diff: 430593,
        variance: 21.4165
    }, {
        code: 5103,
        value: 5455274,
        x: 35,
        y: 2,
        lastValue: 4607431,
        diff: 847843,
        variance: 18.4016
    }, {
        code: 5104,
        value: 10522166,
        x: 35,
        y: 3,
        lastValue: 5115105,
        diff: 5407061,
        variance: 105.7077
    }, {
        code: 5105,
        value: 9132842,
        x: 35,
        y: 4,
        lastValue: 10210881,
        diff: -1078039,
        variance: -10.5577
    }, {
        code: 5203,
        value: 242063408,
        x: 35,
        y: 5,
        lastValue: 195239892,
        diff: 46823516,
        variance: 23.9826
    }, {
        code: 5204,
        value: 20853460,
        x: 35,
        y: 6,
        lastValue: 21230716,
        diff: -377256,
        variance: -1.7769
    }, {
        code: 5206,
        value: 406259,
        x: 35,
        y: 7,
        lastValue: 381349,
        diff: 24910,
        variance: 6.5321
    }, {
        code: 5207,
        value: 48327257,
        x: 35,
        y: 8,
        lastValue: 53524180,
        diff: -5196923,
        variance: -9.7095
    }, {
        code: 5301,
        value: 546074,
        x: 35,
        y: 9,
        lastValue: 578422,
        diff: -32348,
        variance: -5.5925
    }, {
        code: 5302,
        value: 128762830,
        x: 35,
        y: 10,
        lastValue: 113802336,
        diff: 14960494,
        variance: 13.1460
    }, {
        code: 5303,
        value: 14703365,
        x: 35,
        y: 11,
        lastValue: 13522639,
        diff: 1180726,
        variance: 8.7315
    }, {
        code: 5304,
        value: 20108230,
        x: 35,
        y: 12,
        lastValue: 18233026,
        diff: 1875204,
        variance: 10.2847
    }, {
        code: 5305,
        value: 3032698,
        x: 35,
        y: 13,
        lastValue: 2734804,
        diff: 297894,
        variance: 10.8927
    }, {
        code: 5401,
        value: 21874290,
        x: 35,
        y: 14,
        lastValue: 23480805,
        diff: -1606515,
        variance: -6.8418
    }, {
        code: 5402,
        value: 0,
        x: 35,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 24756762,
        x: 35,
        y: 16,
        lastValue: 22262452,
        diff: 2494310,
        variance: 11.2041
    }, {
        code: 5404,
        value: 19515157,
        x: 35,
        y: 17,
        lastValue: 16943239,
        diff: 2571918,
        variance: 15.1796
    }, {
        code: 5501,
        value: 534700,
        x: 35,
        y: 18,
        lastValue: 403167,
        diff: 131533,
        variance: 32.6249
    }, {
        code: 5502,
        value: 10372,
        x: 35,
        y: 19,
        lastValue: 8414,
        diff: 1958,
        variance: 23.2707
    }, {
        code: 5503,
        value: 93,
        x: 35,
        y: 20,
        lastValue: 70,
        diff: 23,
        variance: 32.8571
    }, {
        code: 5504,
        value: 0,
        x: 35,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 13880099,
        x: 36,
        y: 0,
        lastValue: 16224347,
        diff: -2344248,
        variance: -14.4490
    }, {
        code: 5102,
        value: 2515445,
        x: 36,
        y: 1,
        lastValue: 2441160,
        diff: 74285,
        variance: 3.0430
    }, {
        code: 5103,
        value: 6233487,
        x: 36,
        y: 2,
        lastValue: 5455274,
        diff: 778213,
        variance: 14.2653
    }, {
        code: 5104,
        value: 10487885,
        x: 36,
        y: 3,
        lastValue: 10522166,
        diff: -34281,
        variance: -0.3258
    }, {
        code: 5105,
        value: 9018920,
        x: 36,
        y: 4,
        lastValue: 9132842,
        diff: -113922,
        variance: -1.2474
    }, {
        code: 5203,
        value: 241047008,
        x: 36,
        y: 5,
        lastValue: 242063408,
        diff: -1016400,
        variance: -0.4199
    }, {
        code: 5204,
        value: 20074641,
        x: 36,
        y: 6,
        lastValue: 20853460,
        diff: -778819,
        variance: -3.7347
    }, {
        code: 5206,
        value: 483183,
        x: 36,
        y: 7,
        lastValue: 406259,
        diff: 76924,
        variance: 18.9347
    }, {
        code: 5207,
        value: 54645156,
        x: 36,
        y: 8,
        lastValue: 48327257,
        diff: 6317899,
        variance: 13.0732
    }, {
        code: 5301,
        value: 456581,
        x: 36,
        y: 9,
        lastValue: 546074,
        diff: -89493,
        variance: -16.3884
    }, {
        code: 5302,
        value: 105748650,
        x: 36,
        y: 10,
        lastValue: 128762830,
        diff: -23014180,
        variance: -17.8733
    }, {
        code: 5303,
        value: 14977830,
        x: 36,
        y: 11,
        lastValue: 14703365,
        diff: 274465,
        variance: 1.8667
    }, {
        code: 5304,
        value: 19156241,
        x: 36,
        y: 12,
        lastValue: 20108230,
        diff: -951989,
        variance: -4.7343
    }, {
        code: 5305,
        value: 3219960,
        x: 36,
        y: 13,
        lastValue: 3032698,
        diff: 187262,
        variance: 6.1748
    }, {
        code: 5401,
        value: 32545321,
        x: 36,
        y: 14,
        lastValue: 21874290,
        diff: 10671031,
        variance: 48.7834
    }, {
        code: 5402,
        value: 0,
        x: 36,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 28235142,
        x: 36,
        y: 16,
        lastValue: 24756762,
        diff: 3478380,
        variance: 14.0502
    }, {
        code: 5404,
        value: 22185237,
        x: 36,
        y: 17,
        lastValue: 19515157,
        diff: 2670080,
        variance: 13.6821
    }, {
        code: 5501,
        value: 592000,
        x: 36,
        y: 18,
        lastValue: 534700,
        diff: 57300,
        variance: 10.7163
    }, {
        code: 5502,
        value: 10376,
        x: 36,
        y: 19,
        lastValue: 10372,
        diff: 4,
        variance: 0.0386
    }, {
        code: 5503,
        value: 103,
        x: 36,
        y: 20,
        lastValue: 93,
        diff: 10,
        variance: 10.7527
    }, {
        code: 5504,
        value: 0,
        x: 36,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 13892347,
        x: 37,
        y: 0,
        lastValue: 13880099,
        diff: 12248,
        variance: 0.0882
    }, {
        code: 5102,
        value: 2818333,
        x: 37,
        y: 1,
        lastValue: 2515445,
        diff: 302888,
        variance: 12.0411
    }, {
        code: 5103,
        value: 6580512,
        x: 37,
        y: 2,
        lastValue: 6233487,
        diff: 347025,
        variance: 5.5671
    }, {
        code: 5104,
        value: 7949856,
        x: 37,
        y: 3,
        lastValue: 10487885,
        diff: -2538029,
        variance: -24.1996
    }, {
        code: 5105,
        value: 8872692,
        x: 37,
        y: 4,
        lastValue: 9018920,
        diff: -146228,
        variance: -1.6213
    }, {
        code: 5203,
        value: 256834400,
        x: 37,
        y: 5,
        lastValue: 241047008,
        diff: 15787392,
        variance: 6.5495
    }, {
        code: 5204,
        value: 20980693,
        x: 37,
        y: 6,
        lastValue: 20074641,
        diff: 906052,
        variance: 4.5134
    }, {
        code: 5206,
        value: 432417,
        x: 37,
        y: 7,
        lastValue: 483183,
        diff: -50766,
        variance: -10.5066
    }, {
        code: 5207,
        value: 54524968,
        x: 37,
        y: 8,
        lastValue: 54645156,
        diff: -120188,
        variance: -0.2199
    }, {
        code: 5301,
        value: 562037,
        x: 37,
        y: 9,
        lastValue: 456581,
        diff: 105456,
        variance: 23.0969
    }, {
        code: 5302,
        value: 135043045,
        x: 37,
        y: 10,
        lastValue: 105748650,
        diff: 29294395,
        variance: 27.7019
    }, {
        code: 5303,
        value: 15572934,
        x: 37,
        y: 11,
        lastValue: 14977830,
        diff: 595104,
        variance: 3.9732
    }, {
        code: 5304,
        value: 20787468,
        x: 37,
        y: 12,
        lastValue: 19156241,
        diff: 1631227,
        variance: 8.5154
    }, {
        code: 5305,
        value: 3345189,
        x: 37,
        y: 13,
        lastValue: 3219960,
        diff: 125229,
        variance: 3.8891
    }, {
        code: 5401,
        value: 21770911,
        x: 37,
        y: 14,
        lastValue: 32545321,
        diff: -10774410,
        variance: -33.1059
    }, {
        code: 5402,
        value: 0,
        x: 37,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 25148627,
        x: 37,
        y: 16,
        lastValue: 28235142,
        diff: -3086515,
        variance: -10.9315
    }, {
        code: 5404,
        value: 20230251,
        x: 37,
        y: 17,
        lastValue: 22185237,
        diff: -1954986,
        variance: -8.8121
    }, {
        code: 5501,
        value: 447000,
        x: 37,
        y: 18,
        lastValue: 592000,
        diff: -145000,
        variance: -24.4932
    }, {
        code: 5502,
        value: 10186,
        x: 37,
        y: 19,
        lastValue: 10376,
        diff: -190,
        variance: -1.8311
    }, {
        code: 5503,
        value: 78,
        x: 37,
        y: 20,
        lastValue: 103,
        diff: -25,
        variance: -24.2718
    }, {
        code: 5504,
        value: 0,
        x: 37,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 15342283,
        x: 38,
        y: 0,
        lastValue: 13892347,
        diff: 1449936,
        variance: 10.4369
    }, {
        code: 5102,
        value: 2635653,
        x: 38,
        y: 1,
        lastValue: 2818333,
        diff: -182680,
        variance: -6.4818
    }, {
        code: 5103,
        value: 6318477,
        x: 38,
        y: 2,
        lastValue: 6580512,
        diff: -262035,
        variance: -3.9820
    }, {
        code: 5104,
        value: 8217257,
        x: 38,
        y: 3,
        lastValue: 7949856,
        diff: 267401,
        variance: 3.3636
    }, {
        code: 5105,
        value: 9886076,
        x: 38,
        y: 4,
        lastValue: 8872692,
        diff: 1013384,
        variance: 11.4214
    }, {
        code: 5203,
        value: 248710292,
        x: 38,
        y: 5,
        lastValue: 256834400,
        diff: -8124108,
        variance: -3.1632
    }, {
        code: 5204,
        value: 20308690,
        x: 38,
        y: 6,
        lastValue: 20980693,
        diff: -672003,
        variance: -3.2030
    }, {
        code: 5206,
        value: 524169,
        x: 38,
        y: 7,
        lastValue: 432417,
        diff: 91752,
        variance: 21.2184
    }, {
        code: 5207,
        value: 51395348,
        x: 38,
        y: 8,
        lastValue: 54524968,
        diff: -3129620,
        variance: -5.7398
    }, {
        code: 5301,
        value: 717763,
        x: 38,
        y: 9,
        lastValue: 562037,
        diff: 155726,
        variance: 27.7074
    }, {
        code: 5302,
        value: 129601708,
        x: 38,
        y: 10,
        lastValue: 135043045,
        diff: -5441337,
        variance: -4.0293
    }, {
        code: 5303,
        value: 16008693,
        x: 38,
        y: 11,
        lastValue: 15572934,
        diff: 435759,
        variance: 2.7982
    }, {
        code: 5304,
        value: 20490770,
        x: 38,
        y: 12,
        lastValue: 20787468,
        diff: -296698,
        variance: -1.4273
    }, {
        code: 5305,
        value: 3346372,
        x: 38,
        y: 13,
        lastValue: 3345189,
        diff: 1183,
        variance: 0.0354
    }, {
        code: 5401,
        value: 25419477,
        x: 38,
        y: 14,
        lastValue: 21770911,
        diff: 3648566,
        variance: 16.7589
    }, {
        code: 5402,
        value: 0,
        x: 38,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 26679969,
        x: 38,
        y: 16,
        lastValue: 25148627,
        diff: 1531342,
        variance: 6.0892
    }, {
        code: 5404,
        value: 21029297,
        x: 38,
        y: 17,
        lastValue: 20230251,
        diff: 799046,
        variance: 3.9498
    }, {
        code: 5501,
        value: 535000,
        x: 38,
        y: 18,
        lastValue: 447000,
        diff: 88000,
        variance: 19.6868
    }, {
        code: 5502,
        value: 10190,
        x: 38,
        y: 19,
        lastValue: 10186,
        diff: 4,
        variance: 0.0393
    }, {
        code: 5503,
        value: 94,
        x: 38,
        y: 20,
        lastValue: 78,
        diff: 16,
        variance: 20.5128
    }, {
        code: 5504,
        value: 0,
        x: 38,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 15372862,
        x: 39,
        y: 0,
        lastValue: 15342283,
        diff: 30579,
        variance: 0.1993
    }, {
        code: 5102,
        value: 2519253,
        x: 39,
        y: 1,
        lastValue: 2635653,
        diff: -116400,
        variance: -4.4164
    }, {
        code: 5103,
        value: 6629786,
        x: 39,
        y: 2,
        lastValue: 6318477,
        diff: 311309,
        variance: 4.9270
    }, {
        code: 5104,
        value: 11691659,
        x: 39,
        y: 3,
        lastValue: 8217257,
        diff: 3474402,
        variance: 42.2818
    }, {
        code: 5105,
        value: 8073254,
        x: 39,
        y: 4,
        lastValue: 9886076,
        diff: -1812822,
        variance: -18.3371
    }, {
        code: 5203,
        value: 258805910,
        x: 39,
        y: 5,
        lastValue: 248710292,
        diff: 10095618,
        variance: 4.0592
    }, {
        code: 5204,
        value: 20283151,
        x: 39,
        y: 6,
        lastValue: 20308690,
        diff: -25539,
        variance: -0.1258
    }, {
        code: 5206,
        value: 504867,
        x: 39,
        y: 7,
        lastValue: 524169,
        diff: -19302,
        variance: -3.6824
    }, {
        code: 5207,
        value: 55427462,
        x: 39,
        y: 8,
        lastValue: 51395348,
        diff: 4032114,
        variance: 7.8453
    }, {
        code: 5301,
        value: 765925,
        x: 39,
        y: 9,
        lastValue: 717763,
        diff: 48162,
        variance: 6.7100
    }, {
        code: 5302,
        value: 107283708,
        x: 39,
        y: 10,
        lastValue: 129601708,
        diff: -22318000,
        variance: -17.2205
    }, {
        code: 5303,
        value: 16425571,
        x: 39,
        y: 11,
        lastValue: 16008693,
        diff: 416878,
        variance: 2.6041
    }, {
        code: 5304,
        value: 21453328,
        x: 39,
        y: 12,
        lastValue: 20490770,
        diff: 962558,
        variance: 4.6975
    }, {
        code: 5305,
        value: 3134421,
        x: 39,
        y: 13,
        lastValue: 3346372,
        diff: -211951,
        variance: -6.3338
    }, {
        code: 5401,
        value: 18793319,
        x: 39,
        y: 14,
        lastValue: 25419477,
        diff: -6626158,
        variance: -26.0672
    }, {
        code: 5402,
        value: 0,
        x: 39,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 22678205,
        x: 39,
        y: 16,
        lastValue: 26679969,
        diff: -4001764,
        variance: -14.9991
    }, {
        code: 5404,
        value: 22035762,
        x: 39,
        y: 17,
        lastValue: 21029297,
        diff: 1006465,
        variance: 4.7860
    }, {
        code: 5501,
        value: 587043,
        x: 39,
        y: 18,
        lastValue: 535000,
        diff: 52043,
        variance: 9.7277
    }, {
        code: 5502,
        value: 13785,
        x: 39,
        y: 19,
        lastValue: 10190,
        diff: 3595,
        variance: 35.2797
    }, {
        code: 5503,
        value: 104,
        x: 39,
        y: 20,
        lastValue: 94,
        diff: 10,
        variance: 10.6383
    }, {
        code: 5504,
        value: 0,
        x: 39,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 15737905,
        x: 40,
        y: 0,
        lastValue: 15372862,
        diff: 365043,
        variance: 2.3746
    }, {
        code: 5102,
        value: 2583075,
        x: 40,
        y: 1,
        lastValue: 2519253,
        diff: 63822,
        variance: 2.5334
    }, {
        code: 5103,
        value: 6203225,
        x: 40,
        y: 2,
        lastValue: 6629786,
        diff: -426561,
        variance: -6.4340
    }, {
        code: 5104,
        value: 8045402,
        x: 40,
        y: 3,
        lastValue: 11691659,
        diff: -3646257,
        variance: -31.1868
    }, {
        code: 5105,
        value: 8815204,
        x: 40,
        y: 4,
        lastValue: 8073254,
        diff: 741950,
        variance: 9.1902
    }, {
        code: 5203,
        value: 249764235,
        x: 40,
        y: 5,
        lastValue: 258805910,
        diff: -9041675,
        variance: -3.4936
    }, {
        code: 5204,
        value: 22862524,
        x: 40,
        y: 6,
        lastValue: 20283151,
        diff: 2579373,
        variance: 12.7168
    }, {
        code: 5206,
        value: 521697,
        x: 40,
        y: 7,
        lastValue: 504867,
        diff: 16830,
        variance: 3.3336
    }, {
        code: 5207,
        value: 64628023,
        x: 40,
        y: 8,
        lastValue: 55427462,
        diff: 9200561,
        variance: 16.5993
    }, {
        code: 5301,
        value: 942468,
        x: 40,
        y: 9,
        lastValue: 765925,
        diff: 176543,
        variance: 23.0496
    }, {
        code: 5302,
        value: 115794165,
        x: 40,
        y: 10,
        lastValue: 107283708,
        diff: 8510457,
        variance: 7.9327
    }, {
        code: 5303,
        value: 17686055,
        x: 40,
        y: 11,
        lastValue: 16425571,
        diff: 1260484,
        variance: 7.6739
    }, {
        code: 5304,
        value: 21488328,
        x: 40,
        y: 12,
        lastValue: 21453328,
        diff: 35000,
        variance: 0.1631
    }, {
        code: 5305,
        value: 3207571,
        x: 40,
        y: 13,
        lastValue: 3134421,
        diff: 73150,
        variance: 2.3338
    }, {
        code: 5401,
        value: 25981986,
        x: 40,
        y: 14,
        lastValue: 18793319,
        diff: 7188667,
        variance: 38.2512
    }, {
        code: 5402,
        value: 0,
        x: 40,
        y: 15,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5403,
        value: 28120516,
        x: 40,
        y: 16,
        lastValue: 22678205,
        diff: 5442311,
        variance: 23.9980
    }, {
        code: 5404,
        value: 22615389,
        x: 40,
        y: 17,
        lastValue: 22035762,
        diff: 579627,
        variance: 2.6304
    }, {
        code: 5501,
        value: 521800,
        x: 40,
        y: 18,
        lastValue: 587043,
        diff: -65243,
        variance: -11.1138
    }, {
        code: 5502,
        value: 13985,
        x: 40,
        y: 19,
        lastValue: 13785,
        diff: 200,
        variance: 1.4509
    }, {
        code: 5503,
        value: 92,
        x: 40,
        y: 20,
        lastValue: 104,
        diff: -12,
        variance: -11.5385
    }, {
        code: 5504,
        value: 0,
        x: 40,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 15439273,
        x: 41,
        y: 0,
        lastValue: 15737905,
        diff: -298632,
        variance: -1.8975
    }, {
        code: 5102,
        value: 2793527,
        x: 41,
        y: 1,
        lastValue: 2583075,
        diff: 210452,
        variance: 8.1473
    }, {
        code: 5103,
        value: 6685179,
        x: 41,
        y: 2,
        lastValue: 6203225,
        diff: 481954,
        variance: 7.7694
    }, {
        code: 5104,
        value: 10298996,
        x: 41,
        y: 3,
        lastValue: 8045402,
        diff: 2253594,
        variance: 28.0110
    }, {
        code: 5105,
        value: 9579724,
        x: 41,
        y: 4,
        lastValue: 8815204,
        diff: 764520,
        variance: 8.6727
    }, {
        code: 5203,
        value: 236764157,
        x: 41,
        y: 5,
        lastValue: 249764235,
        diff: -13000078,
        variance: -5.2049
    }, {
        code: 5204,
        value: 22112772,
        x: 41,
        y: 6,
        lastValue: 22862524,
        diff: -749752,
        variance: -3.2794
    }, {
        code: 5206,
        value: 526108,
        x: 41,
        y: 7,
        lastValue: 521697,
        diff: 4411,
        variance: 0.8455
    }, {
        code: 5207,
        value: 57804619,
        x: 41,
        y: 8,
        lastValue: 64628023,
        diff: -6823404,
        variance: -10.5580
    }, {
        code: 5301,
        value: 1026291,
        x: 41,
        y: 9,
        lastValue: 942468,
        diff: 83823,
        variance: 8.8940
    }, {
        code: 5302,
        value: 123221298,
        x: 41,
        y: 10,
        lastValue: 115794165,
        diff: 7427133,
        variance: 6.4141
    }, {
        code: 5303,
        value: 16312707,
        x: 41,
        y: 11,
        lastValue: 17686055,
        diff: -1373348,
        variance: -7.7651
    }, {
        code: 5304,
        value: 21704761,
        x: 41,
        y: 12,
        lastValue: 21488328,
        diff: 216433,
        variance: 1.0072
    }, {
        code: 5305,
        value: 3275121,
        x: 41,
        y: 13,
        lastValue: 3207571,
        diff: 67550,
        variance: 2.1060
    }, {
        code: 5401,
        value: 26107736,
        x: 41,
        y: 14,
        lastValue: 25981986,
        diff: 125750,
        variance: 0.4840
    }, {
        code: 5402,
        value: 8300,
        x: 41,
        y: 15,
        lastValue: 0,
        diff: 8300,
        variance: 0.0000
    }, {
        code: 5403,
        value: 27706424,
        x: 41,
        y: 16,
        lastValue: 28120516,
        diff: -414092,
        variance: -1.4726
    }, {
        code: 5404,
        value: 22888148,
        x: 41,
        y: 17,
        lastValue: 22615389,
        diff: 272759,
        variance: 1.2061
    }, {
        code: 5501,
        value: 602847,
        x: 41,
        y: 18,
        lastValue: 521800,
        diff: 81047,
        variance: 15.5322
    }, {
        code: 5502,
        value: 13958,
        x: 41,
        y: 19,
        lastValue: 13985,
        diff: -27,
        variance: -0.1931
    }, {
        code: 5503,
        value: 104,
        x: 41,
        y: 20,
        lastValue: 92,
        diff: 12,
        variance: 13.0435
    }, {
        code: 5504,
        value: 0,
        x: 41,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 15554614,
        x: 42,
        y: 0,
        lastValue: 15439273,
        diff: 115341,
        variance: 0.7471
    }, {
        code: 5102,
        value: 2965309,
        x: 42,
        y: 1,
        lastValue: 2793527,
        diff: 171782,
        variance: 6.1493
    }, {
        code: 5103,
        value: 6724488,
        x: 42,
        y: 2,
        lastValue: 6685179,
        diff: 39309,
        variance: 0.5880
    }, {
        code: 5104,
        value: 9886877,
        x: 42,
        y: 3,
        lastValue: 10298996,
        diff: -412119,
        variance: -4.0015
    }, {
        code: 5105,
        value: 10449128,
        x: 42,
        y: 4,
        lastValue: 9579724,
        diff: 869404,
        variance: 9.0755
    }, {
        code: 5203,
        value: 265814604,
        x: 42,
        y: 5,
        lastValue: 236764157,
        diff: 29050447,
        variance: 12.2698
    }, {
        code: 5204,
        value: 23620703,
        x: 42,
        y: 6,
        lastValue: 22112772,
        diff: 1507931,
        variance: 6.8193
    }, {
        code: 5206,
        value: 593421,
        x: 42,
        y: 7,
        lastValue: 526108,
        diff: 67313,
        variance: 12.7945
    }, {
        code: 5207,
        value: 71807779,
        x: 42,
        y: 8,
        lastValue: 57804619,
        diff: 14003160,
        variance: 24.2250
    }, {
        code: 5301,
        value: 1097239,
        x: 42,
        y: 9,
        lastValue: 1026291,
        diff: 70948,
        variance: 6.9130
    }, {
        code: 5302,
        value: 117793293,
        x: 42,
        y: 10,
        lastValue: 123221298,
        diff: -5428005,
        variance: -4.4051
    }, {
        code: 5303,
        value: 20510507,
        x: 42,
        y: 11,
        lastValue: 16312707,
        diff: 4197800,
        variance: 25.7333
    }, {
        code: 5304,
        value: 24180305,
        x: 42,
        y: 12,
        lastValue: 21704761,
        diff: 2475544,
        variance: 11.4055
    }, {
        code: 5305,
        value: 4042078,
        x: 42,
        y: 13,
        lastValue: 3275121,
        diff: 766957,
        variance: 23.4177
    }, {
        code: 5401,
        value: 28692483,
        x: 42,
        y: 14,
        lastValue: 26107736,
        diff: 2584747,
        variance: 9.9003
    }, {
        code: 5402,
        value: 2700,
        x: 42,
        y: 15,
        lastValue: 8300,
        diff: -5600,
        variance: -67.4699
    }, {
        code: 5403,
        value: 22854316,
        x: 42,
        y: 16,
        lastValue: 27706424,
        diff: -4852108,
        variance: -17.5126
    }, {
        code: 5404,
        value: 18053992,
        x: 42,
        y: 17,
        lastValue: 22888148,
        diff: -4834156,
        variance: -21.1208
    }, {
        code: 5501,
        value: 507182,
        x: 42,
        y: 18,
        lastValue: 602847,
        diff: -95665,
        variance: -15.8689
    }, {
        code: 5502,
        value: 13887,
        x: 42,
        y: 19,
        lastValue: 13958,
        diff: -71,
        variance: -0.5087
    }, {
        code: 5503,
        value: 88,
        x: 42,
        y: 20,
        lastValue: 104,
        diff: -16,
        variance: -15.3846
    }, {
        code: 5504,
        value: 0,
        x: 42,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 17597443,
        x: 43,
        y: 0,
        lastValue: 15554614,
        diff: 2042829,
        variance: 13.1333
    }, {
        code: 5102,
        value: 2973484,
        x: 43,
        y: 1,
        lastValue: 2965309,
        diff: 8175,
        variance: 0.2757
    }, {
        code: 5103,
        value: 6524549,
        x: 43,
        y: 2,
        lastValue: 6724488,
        diff: -199939,
        variance: -2.9733
    }, {
        code: 5104,
        value: 9894926,
        x: 43,
        y: 3,
        lastValue: 9886877,
        diff: 8049,
        variance: 0.0814
    }, {
        code: 5105,
        value: 10625583,
        x: 43,
        y: 4,
        lastValue: 10449128,
        diff: 176455,
        variance: 1.6887
    }, {
        code: 5203,
        value: 308710363,
        x: 43,
        y: 5,
        lastValue: 265814604,
        diff: 42895759,
        variance: 16.1375
    }, {
        code: 5204,
        value: 24413075,
        x: 43,
        y: 6,
        lastValue: 23620703,
        diff: 792372,
        variance: 3.3546
    }, {
        code: 5206,
        value: 641667,
        x: 43,
        y: 7,
        lastValue: 593421,
        diff: 48246,
        variance: 8.1301
    }, {
        code: 5207,
        value: 65622587,
        x: 43,
        y: 8,
        lastValue: 71807779,
        diff: -6185192,
        variance: -8.6135
    }, {
        code: 5301,
        value: 1195101,
        x: 43,
        y: 9,
        lastValue: 1097239,
        diff: 97862,
        variance: 8.9189
    }, {
        code: 5302,
        value: 132239063,
        x: 43,
        y: 10,
        lastValue: 117793293,
        diff: 14445770,
        variance: 12.2637
    }, {
        code: 5303,
        value: 21250150,
        x: 43,
        y: 11,
        lastValue: 20510507,
        diff: 739643,
        variance: 3.6062
    }, {
        code: 5304,
        value: 25796377,
        x: 43,
        y: 12,
        lastValue: 24180305,
        diff: 1616072,
        variance: 6.6834
    }, {
        code: 5305,
        value: 4386358,
        x: 43,
        y: 13,
        lastValue: 4042078,
        diff: 344280,
        variance: 8.5174
    }, {
        code: 5401,
        value: 42970863,
        x: 43,
        y: 14,
        lastValue: 28692483,
        diff: 14278380,
        variance: 49.7635
    }, {
        code: 5402,
        value: 3000,
        x: 43,
        y: 15,
        lastValue: 2700,
        diff: 300,
        variance: 11.1111
    }, {
        code: 5403,
        value: 29933381,
        x: 43,
        y: 16,
        lastValue: 22854316,
        diff: 7079065,
        variance: 30.9747
    }, {
        code: 5404,
        value: 23616912,
        x: 43,
        y: 17,
        lastValue: 18053992,
        diff: 5562920,
        variance: 30.8127
    }, {
        code: 5501,
        value: 563000,
        x: 43,
        y: 18,
        lastValue: 507182,
        diff: 55818,
        variance: 11.0055
    }, {
        code: 5502,
        value: 13050,
        x: 43,
        y: 19,
        lastValue: 13887,
        diff: -837,
        variance: -6.0272
    }, {
        code: 5503,
        value: 98,
        x: 43,
        y: 20,
        lastValue: 88,
        diff: 10,
        variance: 11.3636
    }, {
        code: 5504,
        value: 0,
        x: 43,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 15978594,
        x: 44,
        y: 0,
        lastValue: 17597443,
        diff: -1618849,
        variance: -9.1993
    }, {
        code: 5102,
        value: 3319276,
        x: 44,
        y: 1,
        lastValue: 2973484,
        diff: 345792,
        variance: 11.6292
    }, {
        code: 5103,
        value: 7150058,
        x: 44,
        y: 2,
        lastValue: 6524549,
        diff: 625509,
        variance: 9.5870
    }, {
        code: 5104,
        value: 11926030,
        x: 44,
        y: 3,
        lastValue: 9894926,
        diff: 2031104,
        variance: 20.5267
    }, {
        code: 5105,
        value: 11602625,
        x: 44,
        y: 4,
        lastValue: 10625583,
        diff: 977042,
        variance: 9.1952
    }, {
        code: 5203,
        value: 291592862,
        x: 44,
        y: 5,
        lastValue: 308710363,
        diff: -17117501,
        variance: -5.5448
    }, {
        code: 5204,
        value: 22306416,
        x: 44,
        y: 6,
        lastValue: 24413075,
        diff: -2106659,
        variance: -8.6292
    }, {
        code: 5206,
        value: 609668,
        x: 44,
        y: 7,
        lastValue: 641667,
        diff: -31999,
        variance: -4.9869
    }, {
        code: 5207,
        value: 64738469,
        x: 44,
        y: 8,
        lastValue: 65622587,
        diff: -884118,
        variance: -1.3473
    }, {
        code: 5301,
        value: 1205558,
        x: 44,
        y: 9,
        lastValue: 1195101,
        diff: 10457,
        variance: 0.8750
    }, {
        code: 5302,
        value: 141202099,
        x: 44,
        y: 10,
        lastValue: 132239063,
        diff: 8963036,
        variance: 6.7779
    }, {
        code: 5303,
        value: 22337922,
        x: 44,
        y: 11,
        lastValue: 21250150,
        diff: 1087772,
        variance: 5.1189
    }, {
        code: 5304,
        value: 27349327,
        x: 44,
        y: 12,
        lastValue: 25796377,
        diff: 1552950,
        variance: 6.0200
    }, {
        code: 5305,
        value: 5592312,
        x: 44,
        y: 13,
        lastValue: 4386358,
        diff: 1205954,
        variance: 27.4933
    }, {
        code: 5401,
        value: 36760003,
        x: 44,
        y: 14,
        lastValue: 42970863,
        diff: -6210860,
        variance: -14.4537
    }, {
        code: 5402,
        value: 4900,
        x: 44,
        y: 15,
        lastValue: 3000,
        diff: 1900,
        variance: 63.3333
    }, {
        code: 5403,
        value: 28481655,
        x: 44,
        y: 16,
        lastValue: 29933381,
        diff: -1451726,
        variance: -4.8499
    }, {
        code: 5404,
        value: 20879494,
        x: 44,
        y: 17,
        lastValue: 23616912,
        diff: -2737418,
        variance: -11.5909
    }, {
        code: 5501,
        value: 629925,
        x: 44,
        y: 18,
        lastValue: 563000,
        diff: 66925,
        variance: 11.8872
    }, {
        code: 5502,
        value: 15009,
        x: 44,
        y: 19,
        lastValue: 13050,
        diff: 1959,
        variance: 15.0115
    }, {
        code: 5503,
        value: 109,
        x: 44,
        y: 20,
        lastValue: 98,
        diff: 11,
        variance: 11.2245
    }, {
        code: 5504,
        value: 0,
        x: 44,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 19664223,
        x: 45,
        y: 0,
        lastValue: 15978594,
        diff: 3685629,
        variance: 23.0660
    }, {
        code: 5102,
        value: 3290109,
        x: 45,
        y: 1,
        lastValue: 3319276,
        diff: -29167,
        variance: -0.8787
    }, {
        code: 5103,
        value: 6786206,
        x: 45,
        y: 2,
        lastValue: 7150058,
        diff: -363852,
        variance: -5.0888
    }, {
        code: 5104,
        value: 7179013,
        x: 45,
        y: 3,
        lastValue: 11926030,
        diff: -4747017,
        variance: -39.8038
    }, {
        code: 5105,
        value: 12603671,
        x: 45,
        y: 4,
        lastValue: 11602625,
        diff: 1001046,
        variance: 8.6278
    }, {
        code: 5203,
        value: 276490856,
        x: 45,
        y: 5,
        lastValue: 291592862,
        diff: -15102006,
        variance: -5.1791
    }, {
        code: 5204,
        value: 24948428,
        x: 45,
        y: 6,
        lastValue: 22306416,
        diff: 2642012,
        variance: 11.8442
    }, {
        code: 5206,
        value: 548946,
        x: 45,
        y: 7,
        lastValue: 609668,
        diff: -60722,
        variance: -9.9598
    }, {
        code: 5207,
        value: 67462252,
        x: 45,
        y: 8,
        lastValue: 64738469,
        diff: 2723783,
        variance: 4.2074
    }, {
        code: 5301,
        value: 1200692,
        x: 45,
        y: 9,
        lastValue: 1205558,
        diff: -4866,
        variance: -0.4036
    }, {
        code: 5302,
        value: 153546211,
        x: 45,
        y: 10,
        lastValue: 141202099,
        diff: 12344112,
        variance: 8.7422
    }, {
        code: 5303,
        value: 23093761,
        x: 45,
        y: 11,
        lastValue: 22337922,
        diff: 755839,
        variance: 3.3837
    }, {
        code: 5304,
        value: 27506277,
        x: 45,
        y: 12,
        lastValue: 27349327,
        diff: 156950,
        variance: 0.5739
    }, {
        code: 5305,
        value: 5029556,
        x: 45,
        y: 13,
        lastValue: 5592312,
        diff: -562756,
        variance: -10.0630
    }, {
        code: 5401,
        value: 32970312,
        x: 45,
        y: 14,
        lastValue: 36760003,
        diff: -3789691,
        variance: -10.3093
    }, {
        code: 5402,
        value: 4700,
        x: 45,
        y: 15,
        lastValue: 4900,
        diff: -200,
        variance: -4.0816
    }, {
        code: 5403,
        value: 25522830,
        x: 45,
        y: 16,
        lastValue: 28481655,
        diff: -2958825,
        variance: -10.3885
    }, {
        code: 5404,
        value: 18378541,
        x: 45,
        y: 17,
        lastValue: 20879494,
        diff: -2500953,
        variance: -11.9780
    }, {
        code: 5501,
        value: 607054,
        x: 45,
        y: 18,
        lastValue: 629925,
        diff: -22871,
        variance: -3.6307
    }, {
        code: 5502,
        value: 12845,
        x: 45,
        y: 19,
        lastValue: 15009,
        diff: -2164,
        variance: -14.4180
    }, {
        code: 5503,
        value: 107,
        x: 45,
        y: 20,
        lastValue: 109,
        diff: -2,
        variance: -1.8349
    }, {
        code: 5504,
        value: 0,
        x: 45,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 19086970,
        x: 46,
        y: 0,
        lastValue: 19664223,
        diff: -577253,
        variance: -2.9355
    }, {
        code: 5102,
        value: 3480307,
        x: 46,
        y: 1,
        lastValue: 3290109,
        diff: 190198,
        variance: 5.7809
    }, {
        code: 5103,
        value: 6412794,
        x: 46,
        y: 2,
        lastValue: 6786206,
        diff: -373412,
        variance: -5.5025
    }, {
        code: 5104,
        value: 7269163,
        x: 46,
        y: 3,
        lastValue: 7179013,
        diff: 90150,
        variance: 1.2557
    }, {
        code: 5105,
        value: 11879750,
        x: 46,
        y: 4,
        lastValue: 12603671,
        diff: -723921,
        variance: -5.7437
    }, {
        code: 5203,
        value: 342823772,
        x: 46,
        y: 5,
        lastValue: 276490856,
        diff: 66332916,
        variance: 23.9910
    }, {
        code: 5204,
        value: 26937179,
        x: 46,
        y: 6,
        lastValue: 24948428,
        diff: 1988751,
        variance: 7.9714
    }, {
        code: 5206,
        value: 676269,
        x: 46,
        y: 7,
        lastValue: 548946,
        diff: 127323,
        variance: 23.1941
    }, {
        code: 5207,
        value: 84623736,
        x: 46,
        y: 8,
        lastValue: 67462252,
        diff: 17161484,
        variance: 25.4386
    }, {
        code: 5301,
        value: 1233873,
        x: 46,
        y: 9,
        lastValue: 1200692,
        diff: 33181,
        variance: 2.7635
    }, {
        code: 5302,
        value: 154089538,
        x: 46,
        y: 10,
        lastValue: 153546211,
        diff: 543327,
        variance: 0.3539
    }, {
        code: 5303,
        value: 28145025,
        x: 46,
        y: 11,
        lastValue: 23093761,
        diff: 5051264,
        variance: 21.8729
    }, {
        code: 5304,
        value: 30660676,
        x: 46,
        y: 12,
        lastValue: 27506277,
        diff: 3154399,
        variance: 11.4679
    }, {
        code: 5305,
        value: 4905702,
        x: 46,
        y: 13,
        lastValue: 5029556,
        diff: -123854,
        variance: -2.4625
    }, {
        code: 5401,
        value: 23421396,
        x: 46,
        y: 14,
        lastValue: 32970312,
        diff: -9548916,
        variance: -28.9622
    }, {
        code: 5402,
        value: 26000,
        x: 46,
        y: 15,
        lastValue: 4700,
        diff: 21300,
        variance: 453.1915
    }, {
        code: 5403,
        value: 23030471,
        x: 46,
        y: 16,
        lastValue: 25522830,
        diff: -2492359,
        variance: -9.7652
    }, {
        code: 5404,
        value: 20972332,
        x: 46,
        y: 17,
        lastValue: 18378541,
        diff: 2593791,
        variance: 14.1131
    }, {
        code: 5501,
        value: 425506,
        x: 46,
        y: 18,
        lastValue: 607054,
        diff: -181548,
        variance: -29.9064
    }, {
        code: 5502,
        value: 14845,
        x: 46,
        y: 19,
        lastValue: 12845,
        diff: 2000,
        variance: 15.5703
    }, {
        code: 5503,
        value: 90,
        x: 46,
        y: 20,
        lastValue: 107,
        diff: -17,
        variance: -15.8879
    }, {
        code: 5504,
        value: 0,
        x: 46,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 20755732,
        x: 47,
        y: 0,
        lastValue: 19086970,
        diff: 1668762,
        variance: 8.7429
    }, {
        code: 5102,
        value: 3673463,
        x: 47,
        y: 1,
        lastValue: 3480307,
        diff: 193156,
        variance: 5.5500
    }, {
        code: 5103,
        value: 7588377,
        x: 47,
        y: 2,
        lastValue: 6412794,
        diff: 1175583,
        variance: 18.3318
    }, {
        code: 5104,
        value: 12886731,
        x: 47,
        y: 3,
        lastValue: 7269163,
        diff: 5617568,
        variance: 77.2794
    }, {
        code: 5105,
        value: 14048699,
        x: 47,
        y: 4,
        lastValue: 11879750,
        diff: 2168949,
        variance: 18.2575
    }, {
        code: 5203,
        value: 317734010,
        x: 47,
        y: 5,
        lastValue: 342823772,
        diff: -25089762,
        variance: -7.3186
    }, {
        code: 5204,
        value: 27849289,
        x: 47,
        y: 6,
        lastValue: 26937179,
        diff: 912110,
        variance: 3.3861
    }, {
        code: 5206,
        value: 571139,
        x: 47,
        y: 7,
        lastValue: 676269,
        diff: -105130,
        variance: -15.5456
    }, {
        code: 5207,
        value: 93135669,
        x: 47,
        y: 8,
        lastValue: 84623736,
        diff: 8511933,
        variance: 10.0586
    }, {
        code: 5301,
        value: 1262388,
        x: 47,
        y: 9,
        lastValue: 1233873,
        diff: 28515,
        variance: 2.3110
    }, {
        code: 5302,
        value: 167536477,
        x: 47,
        y: 10,
        lastValue: 154089538,
        diff: 13446939,
        variance: 8.7267
    }, {
        code: 5303,
        value: 28892254,
        x: 47,
        y: 11,
        lastValue: 28145025,
        diff: 747229,
        variance: 2.6549
    }, {
        code: 5304,
        value: 35131115,
        x: 47,
        y: 12,
        lastValue: 30660676,
        diff: 4470439,
        variance: 14.5804
    }, {
        code: 5305,
        value: 5707077,
        x: 47,
        y: 13,
        lastValue: 4905702,
        diff: 801375,
        variance: 16.3356
    }, {
        code: 5401,
        value: 42180348,
        x: 47,
        y: 14,
        lastValue: 23421396,
        diff: 18758952,
        variance: 80.0932
    }, {
        code: 5402,
        value: 32000,
        x: 47,
        y: 15,
        lastValue: 26000,
        diff: 6000,
        variance: 23.0769
    }, {
        code: 5403,
        value: 26662480,
        x: 47,
        y: 16,
        lastValue: 23030471,
        diff: 3632009,
        variance: 15.7705
    }, {
        code: 5404,
        value: 24355717,
        x: 47,
        y: 17,
        lastValue: 20972332,
        diff: 3383385,
        variance: 16.1326
    }, {
        code: 5501,
        value: 592557,
        x: 47,
        y: 18,
        lastValue: 425506,
        diff: 167051,
        variance: 39.2594
    }, {
        code: 5502,
        value: 15627,
        x: 47,
        y: 19,
        lastValue: 14845,
        diff: 782,
        variance: 5.2678
    }, {
        code: 5503,
        value: 124,
        x: 47,
        y: 20,
        lastValue: 90,
        diff: 34,
        variance: 37.7778
    }, {
        code: 5504,
        value: 0,
        x: 47,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 20793469,
        x: 48,
        y: 0,
        lastValue: 20755732,
        diff: 37737,
        variance: 0.1818
    }, {
        code: 5102,
        value: 4163997,
        x: 48,
        y: 1,
        lastValue: 3673463,
        diff: 490534,
        variance: 13.3534
    }, {
        code: 5103,
        value: 7960136,
        x: 48,
        y: 2,
        lastValue: 7588377,
        diff: 371759,
        variance: 4.8991
    }, {
        code: 5104,
        value: 12241546,
        x: 48,
        y: 3,
        lastValue: 12886731,
        diff: -645185,
        variance: -5.0066
    }, {
        code: 5105,
        value: 14728992,
        x: 48,
        y: 4,
        lastValue: 14048699,
        diff: 680293,
        variance: 4.8424
    }, {
        code: 5203,
        value: 342109810,
        x: 48,
        y: 5,
        lastValue: 317734010,
        diff: 24375800,
        variance: 7.6718
    }, {
        code: 5204,
        value: 23879373,
        x: 48,
        y: 6,
        lastValue: 27849289,
        diff: -3969916,
        variance: -14.2550
    }, {
        code: 5206,
        value: 651649,
        x: 48,
        y: 7,
        lastValue: 571139,
        diff: 80510,
        variance: 14.0964
    }, {
        code: 5207,
        value: 74407443,
        x: 48,
        y: 8,
        lastValue: 93135669,
        diff: -18728226,
        variance: -20.1085
    }, {
        code: 5301,
        value: 1348151,
        x: 48,
        y: 9,
        lastValue: 1262388,
        diff: 85763,
        variance: 6.7937
    }, {
        code: 5302,
        value: 165889700,
        x: 48,
        y: 10,
        lastValue: 167536477,
        diff: -1646777,
        variance: -0.9829
    }, {
        code: 5303,
        value: 24774977,
        x: 48,
        y: 11,
        lastValue: 28892254,
        diff: -4117277,
        variance: -14.2505
    }, {
        code: 5304,
        value: 37126445,
        x: 48,
        y: 12,
        lastValue: 35131115,
        diff: 1995330,
        variance: 5.6797
    }, {
        code: 5305,
        value: 5467601,
        x: 48,
        y: 13,
        lastValue: 5707077,
        diff: -239476,
        variance: -4.1961
    }, {
        code: 5401,
        value: 36416169,
        x: 48,
        y: 14,
        lastValue: 42180348,
        diff: -5764179,
        variance: -13.6656
    }, {
        code: 5402,
        value: 23800,
        x: 48,
        y: 15,
        lastValue: 32000,
        diff: -8200,
        variance: -25.6250
    }, {
        code: 5403,
        value: 24656346,
        x: 48,
        y: 16,
        lastValue: 26662480,
        diff: -2006134,
        variance: -7.5242
    }, {
        code: 5404,
        value: 22935213,
        x: 48,
        y: 17,
        lastValue: 24355717,
        diff: -1420504,
        variance: -5.8323
    }, {
        code: 5501,
        value: 613514,
        x: 48,
        y: 18,
        lastValue: 592557,
        diff: 20957,
        variance: 3.5367
    }, {
        code: 5502,
        value: 14158,
        x: 48,
        y: 19,
        lastValue: 15627,
        diff: -1469,
        variance: -9.4004
    }, {
        code: 5503,
        value: 128,
        x: 48,
        y: 20,
        lastValue: 124,
        diff: 4,
        variance: 3.2258
    }, {
        code: 5504,
        value: 0,
        x: 48,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 26195794,
        x: 49,
        y: 0,
        lastValue: 20793469,
        diff: 5402325,
        variance: 25.9809
    }, {
        code: 5102,
        value: 4302599,
        x: 49,
        y: 1,
        lastValue: 4163997,
        diff: 138602,
        variance: 3.3286
    }, {
        code: 5103,
        value: 7358508,
        x: 49,
        y: 2,
        lastValue: 7960136,
        diff: -601628,
        variance: -7.5580
    }, {
        code: 5104,
        value: 13103470,
        x: 49,
        y: 3,
        lastValue: 12241546,
        diff: 861924,
        variance: 7.0410
    }, {
        code: 5105,
        value: 15310591,
        x: 49,
        y: 4,
        lastValue: 14728992,
        diff: 581599,
        variance: 3.9487
    }, {
        code: 5203,
        value: 327879430,
        x: 49,
        y: 5,
        lastValue: 342109810,
        diff: -14230380,
        variance: -4.1596
    }, {
        code: 5204,
        value: 26875712,
        x: 49,
        y: 6,
        lastValue: 23879373,
        diff: 2996339,
        variance: 12.5478
    }, {
        code: 5206,
        value: 709471,
        x: 49,
        y: 7,
        lastValue: 651649,
        diff: 57822,
        variance: 8.8732
    }, {
        code: 5207,
        value: 89790681,
        x: 49,
        y: 8,
        lastValue: 74407443,
        diff: 15383238,
        variance: 20.6743
    }, {
        code: 5301,
        value: 1302539,
        x: 49,
        y: 9,
        lastValue: 1348151,
        diff: -45612,
        variance: -3.3833
    }, {
        code: 5302,
        value: 179298290,
        x: 49,
        y: 10,
        lastValue: 165889700,
        diff: 13408590,
        variance: 8.0828
    }, {
        code: 5303,
        value: 30840698,
        x: 49,
        y: 11,
        lastValue: 24774977,
        diff: 6065721,
        variance: 24.4833
    }, {
        code: 5304,
        value: 37538742,
        x: 49,
        y: 12,
        lastValue: 37126445,
        diff: 412297,
        variance: 1.1105
    }, {
        code: 5305,
        value: 5313707,
        x: 49,
        y: 13,
        lastValue: 5467601,
        diff: -153894,
        variance: -2.8147
    }, {
        code: 5401,
        value: 38412204,
        x: 49,
        y: 14,
        lastValue: 36416169,
        diff: 1996035,
        variance: 5.4812
    }, {
        code: 5402,
        value: 93200,
        x: 49,
        y: 15,
        lastValue: 23800,
        diff: 69400,
        variance: 291.5966
    }, {
        code: 5403,
        value: 25109432,
        x: 49,
        y: 16,
        lastValue: 24656346,
        diff: 453086,
        variance: 1.8376
    }, {
        code: 5404,
        value: 21305749,
        x: 49,
        y: 17,
        lastValue: 22935213,
        diff: -1629464,
        variance: -7.1046
    }, {
        code: 5501,
        value: 516812,
        x: 49,
        y: 18,
        lastValue: 613514,
        diff: -96702,
        variance: -15.7620
    }, {
        code: 5502,
        value: 15973,
        x: 49,
        y: 19,
        lastValue: 14158,
        diff: 1815,
        variance: 12.8196
    }, {
        code: 5503,
        value: 108,
        x: 49,
        y: 20,
        lastValue: 128,
        diff: -20,
        variance: -15.6250
    }, {
        code: 5504,
        value: 0,
        x: 49,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 27878009,
        x: 50,
        y: 0,
        lastValue: 26195794,
        diff: 1682215,
        variance: 6.4217
    }, {
        code: 5102,
        value: 4401980,
        x: 50,
        y: 1,
        lastValue: 4302599,
        diff: 99381,
        variance: 2.3098
    }, {
        code: 5103,
        value: 7143206,
        x: 50,
        y: 2,
        lastValue: 7358508,
        diff: -215302,
        variance: -2.9259
    }, {
        code: 5104,
        value: 10597830,
        x: 50,
        y: 3,
        lastValue: 13103470,
        diff: -2505640,
        variance: -19.1220
    }, {
        code: 5105,
        value: 16218670,
        x: 50,
        y: 4,
        lastValue: 15310591,
        diff: 908079,
        variance: 5.9311
    }, {
        code: 5203,
        value: 324623473,
        x: 50,
        y: 5,
        lastValue: 327879430,
        diff: -3255957,
        variance: -0.9930
    }, {
        code: 5204,
        value: 21274560,
        x: 50,
        y: 6,
        lastValue: 26875712,
        diff: -5601152,
        variance: -20.8409
    }, {
        code: 5206,
        value: 758589,
        x: 50,
        y: 7,
        lastValue: 709471,
        diff: 49118,
        variance: 6.9232
    }, {
        code: 5207,
        value: 91468649,
        x: 50,
        y: 8,
        lastValue: 89790681,
        diff: 1677968,
        variance: 1.8688
    }, {
        code: 5301,
        value: 1356541,
        x: 50,
        y: 9,
        lastValue: 1302539,
        diff: 54002,
        variance: 4.1459
    }, {
        code: 5302,
        value: 194835009,
        x: 50,
        y: 10,
        lastValue: 179298290,
        diff: 15536719,
        variance: 8.6653
    }, {
        code: 5303,
        value: 31609059,
        x: 50,
        y: 11,
        lastValue: 30840698,
        diff: 768361,
        variance: 2.4914
    }, {
        code: 5304,
        value: 37830962,
        x: 50,
        y: 12,
        lastValue: 37538742,
        diff: 292220,
        variance: 0.7784
    }, {
        code: 5305,
        value: 5588181,
        x: 50,
        y: 13,
        lastValue: 5313707,
        diff: 274474,
        variance: 5.1654
    }, {
        code: 5401,
        value: 59300676,
        x: 50,
        y: 14,
        lastValue: 38412204,
        diff: 20888472,
        variance: 54.3798
    }, {
        code: 5402,
        value: 127200,
        x: 50,
        y: 15,
        lastValue: 93200,
        diff: 34000,
        variance: 36.4807
    }, {
        code: 5403,
        value: 26762396,
        x: 50,
        y: 16,
        lastValue: 25109432,
        diff: 1652964,
        variance: 6.5830
    }, {
        code: 5404,
        value: 24767749,
        x: 50,
        y: 17,
        lastValue: 21305749,
        diff: 3462000,
        variance: 16.2491
    }, {
        code: 5501,
        value: 567118,
        x: 50,
        y: 18,
        lastValue: 516812,
        diff: 50306,
        variance: 9.7339
    }, {
        code: 5502,
        value: 17338,
        x: 50,
        y: 19,
        lastValue: 15973,
        diff: 1365,
        variance: 8.5457
    }, {
        code: 5503,
        value: 118,
        x: 50,
        y: 20,
        lastValue: 108,
        diff: 10,
        variance: 9.2593
    }, {
        code: 5504,
        value: 0,
        x: 50,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 27847501,
        x: 51,
        y: 0,
        lastValue: 27878009,
        diff: -30508,
        variance: -0.1094
    }, {
        code: 5102,
        value: 4138736,
        x: 51,
        y: 1,
        lastValue: 4401980,
        diff: -263244,
        variance: -5.9801
    }, {
        code: 5103,
        value: 8239522,
        x: 51,
        y: 2,
        lastValue: 7143206,
        diff: 1096316,
        variance: 15.3477
    }, {
        code: 5104,
        value: 12023999,
        x: 51,
        y: 3,
        lastValue: 10597830,
        diff: 1426169,
        variance: 13.4572
    }, {
        code: 5105,
        value: 17569672,
        x: 51,
        y: 4,
        lastValue: 16218670,
        diff: 1351002,
        variance: 8.3299
    }, {
        code: 5203,
        value: 286880166,
        x: 51,
        y: 5,
        lastValue: 324623473,
        diff: -37743307,
        variance: -11.6268
    }, {
        code: 5204,
        value: 25918729,
        x: 51,
        y: 6,
        lastValue: 21274560,
        diff: 4644169,
        variance: 21.8297
    }, {
        code: 5206,
        value: 613338,
        x: 51,
        y: 7,
        lastValue: 758589,
        diff: -145251,
        variance: -19.1475
    }, {
        code: 5207,
        value: 108004751,
        x: 51,
        y: 8,
        lastValue: 91468649,
        diff: 16536102,
        variance: 18.0784
    }, {
        code: 5301,
        value: 1619671,
        x: 51,
        y: 9,
        lastValue: 1356541,
        diff: 263130,
        variance: 19.3971
    }, {
        code: 5302,
        value: 207842664,
        x: 51,
        y: 10,
        lastValue: 194835009,
        diff: 13007655,
        variance: 6.6762
    }, {
        code: 5303,
        value: 32340535,
        x: 51,
        y: 11,
        lastValue: 31609059,
        diff: 731476,
        variance: 2.3141
    }, {
        code: 5304,
        value: 40439298,
        x: 51,
        y: 12,
        lastValue: 37830962,
        diff: 2608336,
        variance: 6.8947
    }, {
        code: 5305,
        value: 6116970,
        x: 51,
        y: 13,
        lastValue: 5588181,
        diff: 528789,
        variance: 9.4626
    }, {
        code: 5401,
        value: 49229352,
        x: 51,
        y: 14,
        lastValue: 59300676,
        diff: -10071324,
        variance: -16.9835
    }, {
        code: 5402,
        value: 153900,
        x: 51,
        y: 15,
        lastValue: 127200,
        diff: 26700,
        variance: 20.9906
    }, {
        code: 5403,
        value: 21314622,
        x: 51,
        y: 16,
        lastValue: 26762396,
        diff: -5447774,
        variance: -20.3561
    }, {
        code: 5404,
        value: 24521356,
        x: 51,
        y: 17,
        lastValue: 24767749,
        diff: -246393,
        variance: -0.9948
    }, {
        code: 5501,
        value: 661766,
        x: 51,
        y: 18,
        lastValue: 567118,
        diff: 94648,
        variance: 16.6893
    }, {
        code: 5502,
        value: 13974,
        x: 51,
        y: 19,
        lastValue: 17338,
        diff: -3364,
        variance: -19.4025
    }, {
        code: 5503,
        value: 130,
        x: 51,
        y: 20,
        lastValue: 118,
        diff: 12,
        variance: 10.1695
    }, {
        code: 5504,
        value: 0,
        x: 51,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 27943639,
        x: 52,
        y: 0,
        lastValue: 27847501,
        diff: 96138,
        variance: 0.3452
    }, {
        code: 5102,
        value: 5183562,
        x: 52,
        y: 1,
        lastValue: 4138736,
        diff: 1044826,
        variance: 25.2451
    }, {
        code: 5103,
        value: 8121851,
        x: 52,
        y: 2,
        lastValue: 8239522,
        diff: -117671,
        variance: -1.4281
    }, {
        code: 5104,
        value: 12734715,
        x: 52,
        y: 3,
        lastValue: 12023999,
        diff: 710716,
        variance: 5.9108
    }, {
        code: 5105,
        value: 16877704,
        x: 52,
        y: 4,
        lastValue: 17569672,
        diff: -691968,
        variance: -3.9384
    }, {
        code: 5203,
        value: 367893241,
        x: 52,
        y: 5,
        lastValue: 286880166,
        diff: 81013075,
        variance: 28.2393
    }, {
        code: 5204,
        value: 26698843,
        x: 52,
        y: 6,
        lastValue: 25918729,
        diff: 780114,
        variance: 3.0098
    }, {
        code: 5206,
        value: 817001,
        x: 52,
        y: 7,
        lastValue: 613338,
        diff: 203663,
        variance: 33.2057
    }, {
        code: 5207,
        value: 127203195,
        x: 52,
        y: 8,
        lastValue: 108004751,
        diff: 19198444,
        variance: 17.7756
    }, {
        code: 5301,
        value: 1691915,
        x: 52,
        y: 9,
        lastValue: 1619671,
        diff: 72244,
        variance: 4.4604
    }, {
        code: 5302,
        value: 220704550,
        x: 52,
        y: 10,
        lastValue: 207842664,
        diff: 12861886,
        variance: 6.1883
    }, {
        code: 5303,
        value: 34156269,
        x: 52,
        y: 11,
        lastValue: 32340535,
        diff: 1815734,
        variance: 5.6144
    }, {
        code: 5304,
        value: 39884977,
        x: 52,
        y: 12,
        lastValue: 40439298,
        diff: -554321,
        variance: -1.3707
    }, {
        code: 5305,
        value: 7745121,
        x: 52,
        y: 13,
        lastValue: 6116970,
        diff: 1628151,
        variance: 26.6170
    }, {
        code: 5401,
        value: 71762060,
        x: 52,
        y: 14,
        lastValue: 49229352,
        diff: 22532708,
        variance: 45.7709
    }, {
        code: 5402,
        value: 202900,
        x: 52,
        y: 15,
        lastValue: 153900,
        diff: 49000,
        variance: 31.8389
    }, {
        code: 5403,
        value: 25207883,
        x: 52,
        y: 16,
        lastValue: 21314622,
        diff: 3893261,
        variance: 18.2657
    }, {
        code: 5404,
        value: 22195644,
        x: 52,
        y: 17,
        lastValue: 24521356,
        diff: -2325712,
        variance: -9.4844
    }, {
        code: 5501,
        value: 708384,
        x: 52,
        y: 18,
        lastValue: 661766,
        diff: 46618,
        variance: 7.0445
    }, {
        code: 5502,
        value: 17260,
        x: 52,
        y: 19,
        lastValue: 13974,
        diff: 3286,
        variance: 23.5151
    }, {
        code: 5503,
        value: 140,
        x: 52,
        y: 20,
        lastValue: 130,
        diff: 10,
        variance: 7.6923
    }, {
        code: 5504,
        value: 0,
        x: 52,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }, {
        code: 5101,
        value: 31720698,
        x: 53,
        y: 0,
        lastValue: 27943639,
        diff: 3777059,
        variance: 13.5167
    }, {
        code: 5102,
        value: 5169779,
        x: 53,
        y: 1,
        lastValue: 5183562,
        diff: -13783,
        variance: -0.2659
    }, {
        code: 5103,
        value: 5951392,
        x: 53,
        y: 2,
        lastValue: 8121851,
        diff: -2170459,
        variance: -26.7237
    }, {
        code: 5104,
        value: 15246623,
        x: 53,
        y: 3,
        lastValue: 12734715,
        diff: 2511908,
        variance: 19.7249
    }, {
        code: 5105,
        value: 19527545,
        x: 53,
        y: 4,
        lastValue: 16877704,
        diff: 2649841,
        variance: 15.7002
    }, {
        code: 5203,
        value: 372577940,
        x: 53,
        y: 5,
        lastValue: 367893241,
        diff: 4684699,
        variance: 1.2734
    }, {
        code: 5204,
        value: 26944837,
        x: 53,
        y: 6,
        lastValue: 26698843,
        diff: 245994,
        variance: 0.9214
    }, {
        code: 5206,
        value: 792990,
        x: 53,
        y: 7,
        lastValue: 817001,
        diff: -24011,
        variance: -2.9389
    }, {
        code: 5207,
        value: 126134176,
        x: 53,
        y: 8,
        lastValue: 127203195,
        diff: -1069019,
        variance: -0.8404
    }, {
        code: 5301,
        value: 1794463,
        x: 53,
        y: 9,
        lastValue: 1691915,
        diff: 102548,
        variance: 6.0611
    }, {
        code: 5302,
        value: 218488298,
        x: 53,
        y: 10,
        lastValue: 220704550,
        diff: -2216252,
        variance: -1.0042
    }, {
        code: 5303,
        value: 35404876,
        x: 53,
        y: 11,
        lastValue: 34156269,
        diff: 1248607,
        variance: 3.6556
    }, {
        code: 5304,
        value: 40631165,
        x: 53,
        y: 12,
        lastValue: 39884977,
        diff: 746188,
        variance: 1.8708
    }, {
        code: 5305,
        value: 7825561,
        x: 53,
        y: 13,
        lastValue: 7745121,
        diff: 80440,
        variance: 1.0386
    }, {
        code: 5401,
        value: 73540472,
        x: 53,
        y: 14,
        lastValue: 71762060,
        diff: 1778412,
        variance: 2.4782
    }, {
        code: 5402,
        value: 187900,
        x: 53,
        y: 15,
        lastValue: 202900,
        diff: -15000,
        variance: -7.3928
    }, {
        code: 5403,
        value: 28703509,
        x: 53,
        y: 16,
        lastValue: 25207883,
        diff: 3495626,
        variance: 13.8672
    }, {
        code: 5404,
        value: 26994177,
        x: 53,
        y: 17,
        lastValue: 22195644,
        diff: 4798533,
        variance: 21.6193
    }, {
        code: 5501,
        value: 627165,
        x: 53,
        y: 18,
        lastValue: 708384,
        diff: -81219,
        variance: -11.4654
    }, {
        code: 5502,
        value: 17340,
        x: 53,
        y: 19,
        lastValue: 17260,
        diff: 80,
        variance: 0.4635
    }, {
        code: 5503,
        value: 130,
        x: 53,
        y: 20,
        lastValue: 140,
        diff: -10,
        variance: -7.1429
    }, {
        code: 5504,
        value: 0,
        x: 53,
        y: 21,
        lastValue: 0,
        diff: 0,
        variance: 0.0000
    }];
}