Highcharts.chart('container', {
    title: {
        text: 'Cumulative Gross Income'
    },
    credits: {
        enabled: false
    },
    exporting: {
        enabled: false
    },
    plotOptions: {
        series: {
            turboThreshold: 0,
            dataLabels: {
                enabled: true,
                align: 'left',
                verticalAlign: 'middle',
                formatter: function () {
                    if (this.point.x === this.series.data[
                        this.series.data.length - 1].x &
                        this.series.options.showlabel
                    ) {
                        return this.series.options.extra.title;
                    }
                },
                crop: false,
                overflow: false
            }
        }
    },
    chart: {
        zooming: {
            type: 'x'
        },
        marginRight: 120
    },
    tooltip: {
        followPointer: false,
        useHTML: true,
        pointFormat: '<table>  <tr>\n    <th>Gross</th>\n    <td>$ ' +
            '{point.y}</td>\n  </tr>\n  <tr>\n    <th>Genre</th>\n    <td>' +
            '{point.series.options.extra.genre}</td>\n  </tr>\n  <tr>\n    ' +
            '<th>MPAA rating</th>\n    <td>' +
            '{point.series.options.extra.mpaaRating}</td>\n  </tr>\n</table>',
        headerFormat: '<small>{point.key} days since release</small>'
    },
    yAxis: {
        title: {
            text: 'Gross income'
        }
    },
    subtitle: {
        text: 'Only 3 movies: Jurassic Park (497 days) ET, Gladiator and ' +
            'were more than a year in theaters.'
    },
    xAxis: {
        title: {
            text: 'Days since release'
        }
    },
    series: [{
        data: [
            [
                1,
                119119282
            ],
            [
                2,
                187413486
            ],
            [
                3,
                247966675
            ],
            [
                4,
                288076417
            ],
            [
                5,
                325438146
            ],
            [
                6,
                363460329
            ],
            [
                7,
                390856054
            ],
            [
                8,
                440181717
            ],
            [
                9,
                496913249
            ],
            [
                10,
                540058914
            ],
            [
                11,
                571420943
            ],
            [
                12,
                600949526
            ],
            [
                13,
                629034583
            ],
            [
                14,
                651967269
            ],
            [
                15,
                686361421
            ],
            [
                16,
                720729671
            ],
            [
                17,
                742208942
            ],
            [
                18,
                750230824
            ],
            [
                19,
                758198252
            ],
            [
                20,
                764408684
            ],
            [
                21,
                770381043
            ],
            [
                22,
                781125423
            ],
            [
                23,
                800329495
            ],
            [
                24,
                812734828
            ],
            [
                25,
                815843529
            ],
            [
                26,
                819687937
            ],
            [
                27,
                822802874
            ],
            [
                28,
                825932841
            ],
            [
                29,
                832261795
            ],
            [
                30,
                843290309
            ],
            [
                31,
                852274958
            ],
            [
                32,
                858953106
            ],
            [
                33,
                861334016
            ],
            [
                34,
                863148249
            ],
            [
                35,
                865032346
            ],
            [
                36,
                868567603
            ],
            [
                37,
                875382255
            ],
            [
                38,
                879110994
            ],
            [
                39,
                880406736
            ],
            [
                40,
                881981219
            ],
            [
                41,
                883305698
            ],
            [
                42,
                884644162
            ],
            [
                43,
                887112863
            ],
            [
                44,
                892202825
            ],
            [
                45,
                895760846
            ],
            [
                46,
                896541631
            ],
            [
                47,
                897469134
            ],
            [
                48,
                898267924
            ],
            [
                49,
                899071469
            ],
            [
                50,
                900844232
            ],
            [
                51,
                904613971
            ],
            [
                52,
                906044785
            ],
            [
                53,
                906723418
            ],
            [
                54,
                907431461
            ],
            [
                55,
                908059656
            ],
            [
                56,
                908644964
            ],
            [
                57,
                909833552
            ],
            [
                58,
                912295455
            ],
            [
                59,
                914804240
            ],
            [
                60,
                916285655
            ],
            [
                61,
                916860978
            ],
            [
                62,
                917326764
            ],
            [
                63,
                917806295
            ],
            [
                64,
                918724209
            ],
            [
                65,
                920502103
            ],
            [
                66,
                921713590
            ],
            [
                67,
                922010468
            ],
            [
                68,
                922375795
            ],
            [
                69,
                922692449
            ],
            [
                70,
                923001884
            ],
            [
                71,
                923673403
            ],
            [
                72,
                925119143
            ],
            [
                73,
                925988323
            ],
            [
                74,
                926225742
            ],
            [
                75,
                926508202
            ],
            [
                76,
                926745956
            ],
            [
                77,
                926977515
            ],
            [
                78,
                927400587
            ],
            [
                79,
                928264716
            ],
            [
                80,
                928842219
            ],
            [
                81,
                928995339
            ],
            [
                82,
                929158968
            ],
            [
                83,
                929305738
            ],
            [
                84,
                929459260
            ],
            [
                85,
                929768721
            ],
            [
                86,
                930350640
            ],
            [
                87,
                930757012
            ]
        ],
        name: 'starwars7',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Star Wars: The Force Awakens',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#463334'
        },
        showlabel: true,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                26752099
            ],
            [
                2,
                52281135
            ],
            [
                3,
                77025481
            ],
            [
                4,
                93411301
            ],
            [
                5,
                109497762
            ],
            [
                6,
                125943053
            ],
            [
                7,
                137094051
            ],
            [
                8,
                160189097
            ],
            [
                9,
                188463503
            ],
            [
                10,
                212711184
            ],
            [
                11,
                232129323
            ],
            [
                12,
                250419951
            ],
            [
                13,
                268886074
            ],
            [
                14,
                283624210
            ],
            [
                15,
                308898218
            ],
            [
                16,
                334733769
            ],
            [
                17,
                352114898
            ],
            [
                18,
                360209452
            ],
            [
                19,
                367536685
            ],
            [
                20,
                374445852
            ],
            [
                21,
                380540297
            ],
            [
                22,
                393820950
            ],
            [
                23,
                415090487
            ],
            [
                24,
                430846514
            ],
            [
                25,
                435957707
            ],
            [
                26,
                441024441
            ],
            [
                27,
                445768203
            ],
            [
                28,
                450467005
            ],
            [
                29,
                460861269
            ],
            [
                30,
                478115377
            ],
            [
                31,
                493252617
            ],
            [
                32,
                504868451
            ],
            [
                33,
                509059398
            ],
            [
                34,
                512852205
            ],
            [
                35,
                516797418
            ],
            [
                36,
                525825912
            ],
            [
                37,
                542151962
            ],
            [
                38,
                551741499
            ],
            [
                39,
                554981691
            ],
            [
                40,
                558179737
            ],
            [
                41,
                561317325
            ],
            [
                42,
                564472387
            ],
            [
                43,
                571911813
            ],
            [
                44,
                585695694
            ],
            [
                45,
                595752416
            ],
            [
                46,
                598453037
            ],
            [
                47,
                601141551
            ],
            [
                48,
                603789348
            ],
            [
                49,
                606493323
            ],
            [
                50,
                612653642
            ],
            [
                51,
                624193440
            ],
            [
                52,
                629344204
            ],
            [
                53,
                631595771
            ],
            [
                54,
                633621035
            ],
            [
                55,
                635470349
            ],
            [
                56,
                637605653
            ],
            [
                57,
                642146324
            ],
            [
                58,
                651346762
            ],
            [
                59,
                661217278
            ],
            [
                60,
                666388502
            ],
            [
                61,
                668224829
            ],
            [
                62,
                669935879
            ],
            [
                63,
                671721154
            ],
            [
                64,
                675615172
            ],
            [
                65,
                683071751
            ],
            [
                66,
                687962011
            ],
            [
                67,
                689237048
            ],
            [
                68,
                690499726
            ],
            [
                69,
                691701910
            ],
            [
                70,
                692904794
            ],
            [
                71,
                695981544
            ],
            [
                72,
                702621374
            ],
            [
                73,
                706560068
            ],
            [
                74,
                707818745
            ],
            [
                75,
                709304322
            ],
            [
                76,
                710842764
            ],
            [
                77,
                712489342
            ],
            [
                78,
                714463378
            ],
            [
                79,
                718126396
            ],
            [
                80,
                720607444
            ],
            [
                81,
                721425412
            ],
            [
                82,
                722207106
            ],
            [
                83,
                722954237
            ],
            [
                84,
                723744022
            ],
            [
                85,
                725429879
            ],
            [
                86,
                728329714
            ],
            [
                87,
                730270443
            ],
            [
                88,
                730942185
            ],
            [
                89,
                731621183
            ],
            [
                90,
                732229805
            ],
            [
                91,
                732880952
            ],
            [
                92,
                733938158
            ],
            [
                93,
                735684163
            ],
            [
                94,
                736907957
            ],
            [
                95,
                737266471
            ],
            [
                96,
                737627370
            ],
            [
                97,
                737976702
            ],
            [
                98,
                738393054
            ],
            [
                99,
                738919556
            ],
            [
                100,
                739798846
            ],
            [
                101,
                740440529
            ],
            [
                102,
                740684275
            ],
            [
                103,
                740916066
            ],
            [
                104,
                741140003
            ],
            [
                105,
                741352439
            ],
            [
                106,
                741699502
            ],
            [
                107,
                742076465
            ],
            [
                108,
                742332678
            ],
            [
                109,
                742497942
            ],
            [
                110,
                742605267
            ],
            [
                111,
                742721098
            ],
            [
                112,
                742844322
            ],
            [
                113,
                743083175
            ],
            [
                114,
                743448904
            ],
            [
                115,
                743688973
            ],
            [
                116,
                743767458
            ],
            [
                117,
                743853911
            ],
            [
                118,
                743935257
            ],
            [
                119,
                744020453
            ],
            [
                120,
                744275947
            ],
            [
                121,
                744750989
            ],
            [
                122,
                745023267
            ],
            [
                123,
                745115019
            ],
            [
                124,
                745219191
            ],
            [
                125,
                745330634
            ],
            [
                126,
                745444933
            ],
            [
                127,
                745686489
            ],
            [
                128,
                746120670
            ],
            [
                129,
                746365137
            ],
            [
                130,
                746433508
            ],
            [
                131,
                746510111
            ],
            [
                132,
                746579530
            ],
            [
                133,
                746659357
            ],
            [
                134,
                746830110
            ],
            [
                135,
                747119231
            ],
            [
                136,
                747292481
            ],
            [
                137,
                747350763
            ],
            [
                138,
                747409335
            ],
            [
                139,
                747464115
            ],
            [
                140,
                747521330
            ],
            [
                141,
                747625319
            ],
            [
                142,
                747807571
            ],
            [
                143,
                747946415
            ],
            [
                144,
                747990164
            ],
            [
                145,
                748037195
            ],
            [
                146,
                748083861
            ],
            [
                147,
                748133199
            ],
            [
                148,
                748219486
            ],
            [
                149,
                748372762
            ],
            [
                150,
                748468373
            ],
            [
                151,
                748509613
            ],
            [
                152,
                748548157
            ],
            [
                153,
                748590962
            ],
            [
                154,
                748633160
            ],
            [
                155,
                748675358
            ],
            [
                156,
                748757357
            ],
            [
                157,
                748821665
            ],
            [
                158,
                748860222
            ],
            [
                159,
                748882285
            ],
            [
                160,
                748905564
            ],
            [
                161,
                748928859
            ],
            [
                162,
                748956828
            ],
            [
                163,
                749004090
            ],
            [
                164,
                749048939
            ],
            [
                165,
                749073100
            ],
            [
                166,
                749090092
            ],
            [
                167,
                749106053
            ],
            [
                168,
                749125398
            ],
            [
                169,
                749143485
            ],
            [
                170,
                749180329
            ],
            [
                171,
                749202090
            ],
            [
                172,
                749213502
            ],
            [
                173,
                749224990
            ],
            [
                174,
                749237761
            ],
            [
                175,
                749252032
            ],
            [
                176,
                749267995
            ],
            [
                177,
                749295708
            ],
            [
                178,
                749316799
            ],
            [
                179,
                749333092
            ],
            [
                180,
                749351711
            ],
            [
                181,
                749371407
            ],
            [
                182,
                749389769
            ],
            [
                183,
                749401863
            ],
            [
                184,
                749421334
            ],
            [
                185,
                749434950
            ],
            [
                186,
                749446322
            ],
            [
                187,
                749462370
            ],
            [
                188,
                749475963
            ],
            [
                189,
                749491002
            ],
            [
                190,
                749500636
            ],
            [
                191,
                749520515
            ],
            [
                192,
                749535574
            ],
            [
                193,
                749545029
            ],
            [
                194,
                749557279
            ],
            [
                195,
                749561612
            ],
            [
                196,
                749568158
            ],
            [
                197,
                749575182
            ],
            [
                198,
                749587187
            ],
            [
                199,
                749596887
            ],
            [
                200,
                749603864
            ],
            [
                201,
                749609548
            ],
            [
                202,
                749614235
            ],
            [
                203,
                749620438
            ],
            [
                204,
                749630881
            ],
            [
                205,
                749648672
            ],
            [
                206,
                749657409
            ],
            [
                207,
                749663362
            ],
            [
                208,
                749667910
            ],
            [
                209,
                749675406
            ],
            [
                210,
                749685805
            ],
            [
                211,
                749689645
            ],
            [
                212,
                749696871
            ],
            [
                213,
                749701420
            ],
            [
                214,
                749702913
            ],
            [
                215,
                749704539
            ],
            [
                216,
                749705969
            ],
            [
                217,
                749710176
            ],
            [
                218,
                749714957
            ],
            [
                219,
                749722641
            ],
            [
                220,
                749726993
            ],
            [
                221,
                749728743
            ],
            [
                222,
                749730229
            ],
            [
                223,
                749731535
            ],
            [
                224,
                749735275
            ],
            [
                225,
                749739321
            ],
            [
                226,
                749744182
            ],
            [
                227,
                749748303
            ],
            [
                228,
                749748874
            ],
            [
                229,
                749749646
            ],
            [
                230,
                749750520
            ],
            [
                231,
                749755628
            ],
            [
                232,
                749758313
            ],
            [
                233,
                749762141
            ],
            [
                234,
                749766139
            ]
        ],
        name: 'avatar',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Avatar',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#2F2E36'
        },
        showlabel: true,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                8658814
            ],
            [
                2,
                19330827
            ],
            [
                3,
                28638131
            ],
            [
                4,
                34216343
            ],
            [
                5,
                40219462
            ],
            [
                6,
                43790807
            ],
            [
                7,
                52969336
            ],
            [
                8,
                65091634
            ],
            [
                9,
                77558089
            ],
            [
                10,
                88425009
            ],
            [
                11,
                96367529
            ],
            [
                12,
                104380438
            ],
            [
                13,
                112594173
            ],
            [
                14,
                124152693
            ],
            [
                15,
                135851554
            ],
            [
                16,
                148578179
            ],
            [
                17,
                157467971
            ],
            [
                18,
                160490242
            ],
            [
                19,
                163535064
            ],
            [
                20,
                166376415
            ],
            [
                21,
                169165503
            ],
            [
                22,
                176903653
            ],
            [
                23,
                189661771
            ],
            [
                24,
                197881813
            ],
            [
                25,
                200051959
            ],
            [
                26,
                202438123
            ],
            [
                27,
                204533905
            ],
            [
                28,
                206734370
            ],
            [
                29,
                214152755
            ],
            [
                30,
                226510099
            ],
            [
                31,
                236745404
            ],
            [
                32,
                242748914
            ],
            [
                33,
                245071248
            ],
            [
                34,
                247148224
            ],
            [
                35,
                249361166
            ],
            [
                36,
                256392349
            ],
            [
                37,
                268867286
            ],
            [
                38,
                274599886
            ],
            [
                39,
                276501108
            ],
            [
                40,
                278423536
            ],
            [
                41,
                280231706
            ],
            [
                42,
                282193031
            ],
            [
                43,
                288845862
            ],
            [
                44,
                300809839
            ],
            [
                45,
                308100203
            ],
            [
                46,
                309605750
            ],
            [
                47,
                311342603
            ],
            [
                48,
                312791354
            ],
            [
                49,
                314327828
            ],
            [
                50,
                320040276
            ],
            [
                51,
                330858806
            ],
            [
                52,
                337355666
            ],
            [
                53,
                338710764
            ],
            [
                54,
                340217288
            ],
            [
                55,
                341677727
            ],
            [
                56,
                343394297
            ],
            [
                57,
                349124777
            ],
            [
                58,
                362173488
            ],
            [
                59,
                371562244
            ],
            [
                60,
                376270721
            ],
            [
                61,
                378144577
            ],
            [
                62,
                379772544
            ],
            [
                63,
                381525538
            ],
            [
                64,
                386765500
            ],
            [
                65,
                396691039
            ],
            [
                66,
                402561881
            ],
            [
                67,
                403739570
            ],
            [
                68,
                405030767
            ],
            [
                69,
                406083994
            ],
            [
                70,
                407350832
            ],
            [
                71,
                412090075
            ],
            [
                72,
                421465040
            ],
            [
                73,
                426983888
            ],
            [
                74,
                428046153
            ],
            [
                75,
                429334497
            ],
            [
                76,
                430387008
            ],
            [
                77,
                431551546
            ],
            [
                78,
                435915654
            ],
            [
                79,
                444274533
            ],
            [
                80,
                449157395
            ],
            [
                81,
                450213078
            ],
            [
                82,
                451454765
            ],
            [
                83,
                452570393
            ],
            [
                84,
                453867325
            ],
            [
                85,
                458212534
            ],
            [
                86,
                466382088
            ],
            [
                87,
                471446140
            ],
            [
                88,
                472758103
            ],
            [
                89,
                474234924
            ],
            [
                90,
                475716582
            ],
            [
                91,
                477349092
            ],
            [
                92,
                481668037
            ],
            [
                93,
                489671898
            ],
            [
                94,
                494514331
            ],
            [
                95,
                495573044
            ],
            [
                96,
                497178479
            ],
            [
                97,
                498610790
            ],
            [
                98,
                500049030
            ],
            [
                99,
                504255040
            ],
            [
                100,
                511584597
            ],
            [
                101,
                515262530
            ],
            [
                102,
                516040845
            ],
            [
                103,
                517059359
            ],
            [
                104,
                517947471
            ],
            [
                105,
                518873058
            ],
            [
                106,
                521904623
            ],
            [
                107,
                527679833
            ],
            [
                108,
                530406538
            ],
            [
                109,
                531180656
            ],
            [
                110,
                532113277
            ],
            [
                111,
                533002196
            ],
            [
                112,
                534295450
            ],
            [
                113,
                537565583
            ],
            [
                114,
                541058281
            ],
            [
                115,
                542853691
            ],
            [
                116,
                543867439
            ],
            [
                117,
                544879356
            ],
            [
                118,
                545767712
            ],
            [
                119,
                546659214
            ],
            [
                120,
                548811012
            ],
            [
                121,
                552306658
            ],
            [
                122,
                554067203
            ],
            [
                123,
                554475864
            ],
            [
                124,
                554924605
            ],
            [
                125,
                555273199
            ],
            [
                126,
                555676775
            ],
            [
                127,
                556974543
            ],
            [
                128,
                559422564
            ],
            [
                129,
                560615350
            ],
            [
                130,
                560873032
            ],
            [
                131,
                561187540
            ],
            [
                132,
                561446553
            ],
            [
                133,
                561724643
            ],
            [
                134,
                562754486
            ],
            [
                135,
                564844640
            ],
            [
                136,
                565736531
            ],
            [
                137,
                565953263
            ],
            [
                138,
                566209309
            ],
            [
                139,
                566423231
            ],
            [
                140,
                566641840
            ],
            [
                141,
                567408674
            ],
            [
                142,
                568896220
            ],
            [
                143,
                569820413
            ],
            [
                144,
                570032011
            ],
            [
                145,
                570264933
            ],
            [
                146,
                570447710
            ],
            [
                147,
                570601592
            ],
            [
                148,
                571138657
            ],
            [
                149,
                572169401
            ],
            [
                150,
                572713894
            ],
            [
                151,
                572899725
            ],
            [
                152,
                573048180
            ],
            [
                153,
                573202988
            ],
            [
                154,
                573387309
            ],
            [
                155,
                573985427
            ],
            [
                156,
                575161477
            ],
            [
                157,
                576357353
            ],
            [
                158,
                577060012
            ],
            [
                159,
                577247896
            ],
            [
                160,
                577435118
            ],
            [
                161,
                577635895
            ],
            [
                162,
                578081790
            ],
            [
                163,
                578927907
            ],
            [
                164,
                579419474
            ],
            [
                165,
                579603351
            ],
            [
                166,
                579815441
            ],
            [
                167,
                580020021
            ],
            [
                168,
                580241029
            ],
            [
                169,
                580659232
            ],
            [
                170,
                581436091
            ],
            [
                171,
                581889889
            ],
            [
                172,
                582065212
            ],
            [
                173,
                582283971
            ],
            [
                174,
                582465336
            ],
            [
                175,
                582670447
            ],
            [
                176,
                582968058
            ],
            [
                177,
                583520763
            ],
            [
                178,
                583885184
            ],
            [
                179,
                584029167
            ],
            [
                180,
                584202831
            ],
            [
                181,
                584356709
            ],
            [
                182,
                584514665
            ],
            [
                183,
                584801154
            ],
            [
                184,
                585253347
            ],
            [
                185,
                585544027
            ],
            [
                186,
                585687856
            ],
            [
                187,
                585850013
            ],
            [
                188,
                585991218
            ],
            [
                189,
                586148621
            ],
            [
                190,
                586407585
            ],
            [
                191,
                586825008
            ],
            [
                192,
                587071239
            ],
            [
                193,
                587197340
            ],
            [
                194,
                587354184
            ],
            [
                195,
                587454739
            ],
            [
                196,
                587581188
            ],
            [
                197,
                587807739
            ],
            [
                198,
                588017397
            ],
            [
                199,
                588205118
            ],
            [
                200,
                588287481
            ],
            [
                201,
                588373170
            ],
            [
                202,
                588454766
            ],
            [
                203,
                588526209
            ],
            [
                204,
                588648955
            ],
            [
                205,
                588823550
            ],
            [
                206,
                588931878
            ],
            [
                207,
                588978021
            ],
            [
                208,
                589039101
            ],
            [
                209,
                589095476
            ],
            [
                210,
                589152380
            ],
            [
                211,
                589481397
            ],
            [
                212,
                590003732
            ],
            [
                213,
                590489873
            ],
            [
                214,
                590772845
            ],
            [
                215,
                591105154
            ],
            [
                216,
                591423602
            ],
            [
                217,
                591758169
            ],
            [
                218,
                592187821
            ],
            [
                219,
                592766388
            ],
            [
                220,
                593234448
            ],
            [
                221,
                593486792
            ],
            [
                222,
                593768559
            ],
            [
                223,
                594025426
            ],
            [
                224,
                594298467
            ],
            [
                225,
                594629951
            ],
            [
                226,
                595090070
            ],
            [
                227,
                595467018
            ],
            [
                228,
                595671646
            ],
            [
                229,
                595898453
            ],
            [
                230,
                596113141
            ],
            [
                231,
                596320474
            ],
            [
                232,
                596582984
            ],
            [
                233,
                596958865
            ],
            [
                234,
                597285686
            ],
            [
                235,
                597436378
            ],
            [
                236,
                597601006
            ],
            [
                237,
                597749260
            ],
            [
                238,
                597907062
            ],
            [
                239,
                598092435
            ],
            [
                240,
                598385286
            ],
            [
                241,
                598614980
            ],
            [
                242,
                598732804
            ],
            [
                243,
                598868105
            ],
            [
                244,
                598993956
            ],
            [
                245,
                599117196
            ],
            [
                246,
                599257659
            ],
            [
                247,
                599488898
            ],
            [
                248,
                599657813
            ],
            [
                249,
                599737633
            ],
            [
                250,
                599847580
            ],
            [
                251,
                599940822
            ],
            [
                252,
                600038488
            ],
            [
                253,
                600125841
            ],
            [
                254,
                600275295
            ],
            [
                255,
                600374192
            ],
            [
                256,
                600401200
            ],
            [
                257,
                600429301
            ],
            [
                258,
                600449727
            ],
            [
                259,
                600471161
            ],
            [
                260,
                600488179
            ],
            [
                261,
                600515819
            ],
            [
                262,
                600541628
            ],
            [
                263,
                600562600
            ],
            [
                264,
                600568272
            ],
            [
                265,
                600573968
            ],
            [
                266,
                600581001
            ],
            [
                267,
                600596288
            ],
            [
                268,
                600624176
            ],
            [
                269,
                600638309
            ],
            [
                270,
                600642933
            ],
            [
                271,
                600649450
            ],
            [
                272,
                600654793
            ],
            [
                273,
                600660690
            ],
            [
                274,
                600664546
            ],
            [
                275,
                600671741
            ],
            [
                276,
                600674693
            ],
            [
                277,
                600675703
            ],
            [
                278,
                600676888
            ],
            [
                279,
                600677818
            ],
            [
                280,
                600678584
            ],
            [
                281,
                600679644
            ],
            [
                282,
                600681119
            ],
            [
                283,
                600681921
            ],
            [
                284,
                600682199
            ],
            [
                285,
                600682513
            ],
            [
                286,
                600682801
            ],
            [
                287,
                600683057
            ]
        ],
        name: 'titanic',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Titanic',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#443529'
        },
        showlabel: true,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                81953950
            ],
            [
                2,
                151598780
            ],
            [
                3,
                208806270
            ],
            [
                4,
                234151090
            ],
            [
                5,
                258493605
            ],
            [
                6,
                278389075
            ],
            [
                7,
                296211655
            ],
            [
                8,
                325326090
            ],
            [
                9,
                364438525
            ],
            [
                10,
                402800065
            ],
            [
                11,
                414366290
            ],
            [
                12,
                427496750
            ],
            [
                13,
                436936950
            ],
            [
                14,
                445840775
            ],
            [
                15,
                460533660
            ],
            [
                16,
                483013950
            ],
            [
                17,
                500373390
            ],
            [
                18,
                506899770
            ],
            [
                19,
                514374125
            ],
            [
                20,
                520362275
            ],
            [
                21,
                527300925
            ],
            [
                22,
                539128530
            ],
            [
                23,
                547667575
            ],
            [
                24,
                556542950
            ],
            [
                25,
                560692000
            ],
            [
                26,
                565531415
            ],
            [
                27,
                569287100
            ],
            [
                28,
                572538290
            ],
            [
                29,
                577957865
            ],
            [
                30,
                585390425
            ],
            [
                31,
                590689565
            ],
            [
                32,
                592840190
            ],
            [
                33,
                595627400
            ],
            [
                34,
                597829640
            ],
            [
                35,
                599773805
            ],
            [
                36,
                603031070
            ],
            [
                37,
                607940345
            ],
            [
                38,
                611228780
            ],
            [
                39,
                612601315
            ],
            [
                40,
                614331250
            ],
            [
                41,
                615640390
            ],
            [
                42,
                616902775
            ],
            [
                43,
                618965875
            ],
            [
                44,
                621941500
            ],
            [
                45,
                624083950
            ],
            [
                46,
                625009700
            ],
            [
                47,
                626094150
            ],
            [
                48,
                626920500
            ],
            [
                49,
                627699630
            ],
            [
                50,
                628770350
            ],
            [
                51,
                630386910
            ],
            [
                52,
                631601030
            ],
            [
                53,
                632193750
            ],
            [
                54,
                632834270
            ],
            [
                55,
                633318770
            ],
            [
                56,
                633726780
            ],
            [
                57,
                634280685
            ],
            [
                58,
                635114340
            ],
            [
                59,
                635673840
            ],
            [
                60,
                635936805
            ],
            [
                61,
                636272505
            ],
            [
                62,
                636513090
            ],
            [
                63,
                636731640
            ],
            [
                64,
                637067430
            ],
            [
                65,
                637613550
            ],
            [
                66,
                637971480
            ],
            [
                67,
                638126505
            ],
            [
                68,
                638322290
            ],
            [
                69,
                638473570
            ],
            [
                70,
                638620980
            ],
            [
                71,
                638887990
            ],
            [
                72,
                639307200
            ],
            [
                73,
                639568530
            ],
            [
                74,
                639663325
            ],
            [
                75,
                639778350
            ],
            [
                76,
                639872800
            ],
            [
                77,
                639967785
            ],
            [
                78,
                640760745
            ],
            [
                79,
                642136035
            ],
            [
                80,
                642978555
            ],
            [
                81,
                643269755
            ],
            [
                82,
                643579580
            ],
            [
                83,
                643839335
            ],
            [
                84,
                644043640
            ],
            [
                85,
                644632765
            ],
            [
                86,
                645669625
            ],
            [
                87,
                646737905
            ],
            [
                88,
                647374160
            ],
            [
                89,
                647516055
            ],
            [
                90,
                647626080
            ],
            [
                91,
                647728195
            ],
            [
                92,
                648026291
            ],
            [
                93,
                648622481
            ],
            [
                94,
                648908886
            ],
            [
                95,
                648990716
            ],
            [
                96,
                649084726
            ],
            [
                97,
                649160276
            ],
            [
                98,
                649224036
            ],
            [
                99,
                649397366
            ],
            [
                100,
                649709676
            ],
            [
                101,
                649860516
            ],
            [
                102,
                649905696
            ],
            [
                103,
                649958406
            ],
            [
                104,
                650010786
            ],
            [
                105,
                650052291
            ],
            [
                106,
                650163171
            ],
            [
                107,
                650359291
            ],
            [
                108,
                650442741
            ],
            [
                109,
                650465296
            ],
            [
                110,
                650493056
            ],
            [
                111,
                650518931
            ],
            [
                112,
                650539751
            ],
            [
                113,
                650621116
            ],
            [
                114,
                650760851
            ],
            [
                115,
                650831971
            ],
            [
                116,
                650852291
            ],
            [
                117,
                650875151
            ],
            [
                118,
                650896741
            ],
            [
                119,
                650917061
            ],
            [
                120,
                650976601
            ],
            [
                121,
                651072536
            ],
            [
                122,
                651128986
            ],
            [
                123,
                651157741
            ],
            [
                124,
                651175846
            ],
            [
                125,
                651193851
            ],
            [
                126,
                651219411
            ],
            [
                127,
                651280016
            ],
            [
                128,
                651382026
            ],
            [
                129,
                651443636
            ],
            [
                130,
                651460806
            ],
            [
                131,
                651482016
            ],
            [
                132,
                651500121
            ],
            [
                133,
                651519326
            ],
            [
                134,
                651571841
            ],
            [
                135,
                651661981
            ],
            [
                136,
                651713686
            ],
            [
                137,
                651727701
            ],
            [
                138,
                651743446
            ],
            [
                139,
                651756571
            ],
            [
                140,
                651771446
            ],
            [
                141,
                651805076
            ],
            [
                142,
                651848541
            ],
            [
                143,
                651889591
            ],
            [
                144,
                651901096
            ],
            [
                145,
                651915856
            ],
            [
                146,
                651926516
            ],
            [
                147,
                651937996
            ],
            [
                148,
                651967211
            ],
            [
                149,
                652022846
            ],
            [
                150,
                652054116
            ],
            [
                151,
                652061061
            ],
            [
                152,
                652071496
            ],
            [
                153,
                652091641
            ],
            [
                154,
                652099921
            ],
            [
                155,
                652117931
            ],
            [
                156,
                652154966
            ],
            [
                157,
                652177271
            ],
            [
                158,
                652182176
            ],
            [
                159,
                652188221
            ],
            [
                160,
                652193076
            ],
            [
                161,
                652198011
            ]
        ],
        name: 'jurassicpark4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Jurassic World',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#31485B'
        },
        showlabel: true,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                80813985
            ],
            [
                2,
                150371975
            ],
            [
                3,
                207438708
            ],
            [
                4,
                226337707
            ],
            [
                5,
                244014897
            ],
            [
                6,
                257627807
            ],
            [
                7,
                270019373
            ],
            [
                8,
                299242890
            ],
            [
                9,
                342148409
            ],
            [
                10,
                373071647
            ],
            [
                11,
                380995436
            ],
            [
                12,
                389473290
            ],
            [
                13,
                395813047
            ],
            [
                14,
                402021415
            ],
            [
                15,
                417257461
            ],
            [
                16,
                440844530
            ],
            [
                17,
                457665517
            ],
            [
                18,
                463353451
            ],
            [
                19,
                468271215
            ],
            [
                20,
                472239621
            ],
            [
                21,
                476684788
            ],
            [
                22,
                486349111
            ],
            [
                23,
                500415495
            ],
            [
                24,
                513371659
            ],
            [
                25,
                523907202
            ],
            [
                26,
                527173955
            ],
            [
                27,
                529688996
            ],
            [
                28,
                532463980
            ],
            [
                29,
                538105622
            ],
            [
                30,
                547123535
            ],
            [
                31,
                552950398
            ],
            [
                32,
                554992773
            ],
            [
                33,
                557214486
            ],
            [
                34,
                559076546
            ],
            [
                35,
                561050725
            ],
            [
                36,
                564387649
            ],
            [
                37,
                568934514
            ],
            [
                38,
                572300463
            ],
            [
                39,
                573685968
            ],
            [
                40,
                575233764
            ],
            [
                41,
                576583182
            ],
            [
                42,
                577888904
            ],
            [
                43,
                580095059
            ],
            [
                44,
                583388044
            ],
            [
                45,
                586794371
            ],
            [
                46,
                587927710
            ],
            [
                47,
                589091616
            ],
            [
                48,
                590193264
            ],
            [
                49,
                591247781
            ],
            [
                50,
                593460187
            ],
            [
                51,
                596501976
            ],
            [
                52,
                598425442
            ],
            [
                53,
                599387534
            ],
            [
                54,
                600377080
            ],
            [
                55,
                601215735
            ],
            [
                56,
                602083073
            ],
            [
                57,
                603388594
            ],
            [
                58,
                605205241
            ],
            [
                59,
                606504744
            ],
            [
                60,
                607219521
            ],
            [
                61,
                607764276
            ],
            [
                62,
                608482552
            ],
            [
                63,
                608959760
            ],
            [
                64,
                609640578
            ],
            [
                65,
                610558801
            ],
            [
                66,
                611127884
            ],
            [
                67,
                611389326
            ],
            [
                68,
                611701097
            ],
            [
                69,
                611973433
            ],
            [
                70,
                612261732
            ],
            [
                71,
                612657166
            ],
            [
                72,
                613244349
            ],
            [
                73,
                613660486
            ],
            [
                74,
                613849210
            ],
            [
                75,
                614070615
            ],
            [
                76,
                614265453
            ],
            [
                77,
                614438014
            ],
            [
                78,
                614628102
            ],
            [
                79,
                614883015
            ],
            [
                80,
                615058425
            ],
            [
                81,
                615156789
            ],
            [
                82,
                615280156
            ],
            [
                83,
                615373694
            ],
            [
                84,
                615483851
            ],
            [
                120,
                618233009
            ],
            [
                121,
                618921193
            ],
            [
                122,
                619760594
            ],
            [
                123,
                620323837
            ],
            [
                124,
                620445610
            ],
            [
                125,
                620532807
            ],
            [
                126,
                620628446
            ],
            [
                127,
                620845677
            ],
            [
                128,
                621251520
            ],
            [
                129,
                621414627
            ],
            [
                130,
                621460765
            ],
            [
                131,
                621517359
            ],
            [
                132,
                621569048
            ],
            [
                133,
                621623219
            ]
        ],
        name: 'avengers11',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Marvel´s The Avengers',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#435256'
        },
        showlabel: true,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                67165092
            ],
            [
                2,
                114815332
            ],
            [
                3,
                158411483
            ],
            [
                4,
                182904796
            ],
            [
                5,
                203773518
            ],
            [
                6,
                222150806
            ],
            [
                7,
                238615211
            ],
            [
                8,
                261847503
            ],
            [
                9,
                290119997
            ],
            [
                10,
                313781677
            ],
            [
                11,
                324299793
            ],
            [
                12,
                333929159
            ],
            [
                13,
                342684300
            ],
            [
                14,
                351086846
            ],
            [
                15,
                363795881
            ],
            [
                16,
                380987031
            ],
            [
                17,
                393751065
            ],
            [
                18,
                400038494
            ],
            [
                19,
                405699734
            ],
            [
                20,
                410777101
            ],
            [
                21,
                415511467
            ],
            [
                22,
                423088829
            ],
            [
                23,
                433591072
            ],
            [
                24,
                441628497
            ],
            [
                25,
                445370695
            ],
            [
                26,
                448886084
            ],
            [
                27,
                451888386
            ],
            [
                28,
                454702857
            ],
            [
                29,
                459640812
            ],
            [
                30,
                466349645
            ],
            [
                31,
                471082150
            ],
            [
                32,
                473194356
            ],
            [
                33,
                475342688
            ],
            [
                34,
                477148000
            ],
            [
                35,
                478874461
            ],
            [
                36,
                481865527
            ],
            [
                37,
                486339697
            ],
            [
                38,
                489416885
            ],
            [
                39,
                490600141
            ],
            [
                40,
                491702478
            ],
            [
                41,
                492688931
            ],
            [
                42,
                493671047
            ],
            [
                43,
                495812401
            ],
            [
                44,
                499058870
            ],
            [
                45,
                502293926
            ],
            [
                46,
                504798337
            ],
            [
                47,
                505417800
            ],
            [
                48,
                505954123
            ],
            [
                49,
                506482539
            ],
            [
                50,
                507947315
            ],
            [
                51,
                510683335
            ],
            [
                52,
                511997658
            ],
            [
                53,
                512374922
            ],
            [
                54,
                512829031
            ],
            [
                55,
                513238453
            ],
            [
                56,
                513664611
            ],
            [
                57,
                514780719
            ],
            [
                58,
                516732450
            ],
            [
                59,
                517792764
            ],
            [
                60,
                518070111
            ],
            [
                61,
                518376320
            ],
            [
                62,
                518668741
            ],
            [
                63,
                518974853
            ],
            [
                64,
                519777880
            ],
            [
                65,
                521169518
            ],
            [
                66,
                521890027
            ],
            [
                67,
                522106180
            ],
            [
                68,
                522341786
            ],
            [
                69,
                522573036
            ],
            [
                70,
                522810263
            ],
            [
                71,
                523237138
            ],
            [
                72,
                524058474
            ],
            [
                73,
                524474684
            ],
            [
                74,
                524599547
            ],
            [
                75,
                524740642
            ],
            [
                76,
                524874072
            ],
            [
                77,
                525003174
            ],
            [
                78,
                525234268
            ],
            [
                79,
                525625565
            ],
            [
                80,
                525831387
            ],
            [
                81,
                525904670
            ],
            [
                82,
                525983815
            ],
            [
                83,
                526068474
            ],
            [
                84,
                526162586
            ],
            [
                85,
                526314081
            ],
            [
                86,
                526549462
            ],
            [
                87,
                526690914
            ],
            [
                88,
                526783113
            ],
            [
                89,
                526831522
            ],
            [
                90,
                526880947
            ],
            [
                91,
                526944204
            ],
            [
                92,
                527074478
            ],
            [
                93,
                527259976
            ],
            [
                94,
                527356352
            ],
            [
                95,
                527394547
            ],
            [
                96,
                527441809
            ],
            [
                97,
                527482905
            ],
            [
                98,
                527526286
            ],
            [
                99,
                527615985
            ],
            [
                100,
                527750249
            ],
            [
                101,
                527822235
            ],
            [
                102,
                527847433
            ],
            [
                103,
                527878017
            ],
            [
                104,
                527909624
            ],
            [
                105,
                527942811
            ],
            [
                106,
                527992020
            ],
            [
                107,
                528133068
            ],
            [
                108,
                528213279
            ],
            [
                109,
                528241353
            ],
            [
                110,
                528268585
            ],
            [
                111,
                528291602
            ],
            [
                112,
                528315892
            ],
            [
                113,
                528376324
            ],
            [
                114,
                528476214
            ],
            [
                115,
                528535317
            ],
            [
                116,
                528567824
            ],
            [
                117,
                528607482
            ],
            [
                118,
                528622949
            ],
            [
                119,
                528640736
            ],
            [
                120,
                528781111
            ],
            [
                121,
                529010886
            ],
            [
                122,
                529143070
            ],
            [
                123,
                529186691
            ],
            [
                124,
                529235982
            ],
            [
                125,
                529281828
            ],
            [
                126,
                529325841
            ],
            [
                127,
                529436296
            ],
            [
                128,
                529600927
            ],
            [
                129,
                529696290
            ],
            [
                130,
                529733882
            ],
            [
                131,
                529783349
            ],
            [
                132,
                529852602
            ],
            [
                133,
                529915623
            ],
            [
                134,
                530051190
            ],
            [
                135,
                530190274
            ],
            [
                136,
                530258989
            ],
            [
                137,
                530280291
            ],
            [
                138,
                530303397
            ],
            [
                139,
                530327889
            ],
            [
                140,
                530353467
            ],
            [
                141,
                530406712
            ],
            [
                142,
                530487981
            ],
            [
                143,
                530540885
            ],
            [
                144,
                530559137
            ],
            [
                145,
                530576842
            ],
            [
                146,
                530594370
            ],
            [
                147,
                530611373
            ],
            [
                148,
                530642871
            ],
            [
                149,
                530696616
            ],
            [
                150,
                530723626
            ],
            [
                151,
                530732032
            ],
            [
                152,
                530741363
            ],
            [
                153,
                530750228
            ],
            [
                154,
                530759822
            ],
            [
                155,
                530774791
            ],
            [
                156,
                530796576
            ],
            [
                157,
                530811565
            ],
            [
                158,
                530822957
            ],
            [
                159,
                530833780
            ],
            [
                160,
                530839192
            ],
            [
                161,
                530846166
            ],
            [
                162,
                530864431
            ],
            [
                163,
                530885363
            ],
            [
                164,
                530896852
            ],
            [
                165,
                530907655
            ],
            [
                166,
                530917814
            ],
            [
                167,
                530924926
            ],
            [
                168,
                530936438
            ],
            [
                169,
                530960516
            ],
            [
                170,
                530986558
            ],
            [
                171,
                531001578
            ],
            [
                172,
                531006084
            ],
            [
                173,
                531010375
            ],
            [
                174,
                531014280
            ],
            [
                175,
                531018614
            ],
            [
                176,
                531021301
            ],
            [
                177,
                531026048
            ],
            [
                178,
                531026626
            ],
            [
                179,
                531027030
            ],
            [
                180,
                531027357
            ],
            [
                181,
                531027626
            ],
            [
                182,
                531027799
            ],
            [
                183,
                531029814
            ],
            [
                184,
                531036642
            ],
            [
                185,
                531037410
            ],
            [
                186,
                531037655
            ],
            [
                187,
                531038124
            ],
            [
                188,
                531038469
            ],
            [
                189,
                531039412
            ],
            [
                190,
                531233755
            ],
            [
                191,
                531531139
            ],
            [
                192,
                531706809
            ],
            [
                193,
                531757754
            ],
            [
                194,
                531813793
            ],
            [
                195,
                531867031
            ],
            [
                196,
                531919903
            ],
            [
                197,
                532042710
            ],
            [
                198,
                532286579
            ],
            [
                199,
                532356746
            ],
            [
                200,
                532388922
            ],
            [
                201,
                532419108
            ],
            [
                202,
                532448983
            ],
            [
                203,
                532478141
            ],
            [
                204,
                532566608
            ],
            [
                205,
                532735827
            ],
            [
                206,
                532831967
            ],
            [
                207,
                532852758
            ],
            [
                208,
                532874732
            ],
            [
                209,
                532895608
            ],
            [
                210,
                532916540
            ],
            [
                211,
                532941278
            ],
            [
                212,
                533009632
            ],
            [
                213,
                533044185
            ],
            [
                214,
                533062050
            ],
            [
                215,
                533070468
            ],
            [
                216,
                533078271
            ],
            [
                217,
                533090262
            ],
            [
                218,
                533115511
            ],
            [
                219,
                533164552
            ],
            [
                220,
                533184219
            ],
            [
                221,
                533192086
            ],
            [
                222,
                533197770
            ],
            [
                223,
                533204875
            ],
            [
                224,
                533213994
            ],
            [
                225,
                533237923
            ],
            [
                226,
                533292620
            ],
            [
                227,
                533316061
            ],
            [
                228,
                533323328
            ],
            [
                229,
                533330642
            ],
            [
                230,
                533337152
            ],
            [
                231,
                533345358
            ]
        ],
        name: 'darkknight',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Dark Knight',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#2D4551'
        },
        showlabel: true,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                28542349
            ],
            [
                2,
                40840267
            ],
            [
                3,
                59307780
            ],
            [
                4,
                83721903
            ],
            [
                5,
                105661237
            ],
            [
                6,
                116542509
            ],
            [
                7,
                124723784
            ],
            [
                8,
                132475660
            ],
            [
                9,
                140194760
            ],
            [
                10,
                153726321
            ],
            [
                11,
                173057101
            ],
            [
                12,
                191594623
            ],
            [
                13,
                207099058
            ],
            [
                14,
                212558695
            ],
            [
                15,
                217854543
            ],
            [
                16,
                222866471
            ],
            [
                17,
                231280254
            ],
            [
                18,
                245134578
            ],
            [
                19,
                255758124
            ],
            [
                20,
                259677495
            ],
            [
                21,
                263679744
            ],
            [
                22,
                267491901
            ],
            [
                23,
                271332050
            ],
            [
                24,
                278027376
            ],
            [
                25,
                288582722
            ],
            [
                26,
                296964911
            ],
            [
                27,
                299990176
            ],
            [
                28,
                303061673
            ],
            [
                29,
                306030682
            ],
            [
                30,
                309213848
            ],
            [
                31,
                313913571
            ],
            [
                32,
                321252062
            ],
            [
                33,
                328072869
            ],
            [
                34,
                330443466
            ],
            [
                35,
                332861798
            ],
            [
                36,
                335088273
            ],
            [
                37,
                337557762
            ],
            [
                38,
                341358058
            ],
            [
                39,
                347148476
            ],
            [
                40,
                351669681
            ],
            [
                41,
                353780085
            ],
            [
                42,
                356021057
            ],
            [
                43,
                357760813
            ],
            [
                44,
                359875311
            ],
            [
                45,
                362766434
            ],
            [
                46,
                366618828
            ],
            [
                47,
                369415693
            ],
            [
                48,
                373166970
            ],
            [
                49,
                374889918
            ],
            [
                50,
                376272871
            ],
            [
                51,
                377692976
            ],
            [
                52,
                379764163
            ],
            [
                53,
                382938277
            ],
            [
                54,
                385184373
            ],
            [
                55,
                386249482
            ],
            [
                56,
                387465405
            ],
            [
                57,
                388525146
            ],
            [
                58,
                389553609
            ],
            [
                59,
                391020073
            ],
            [
                60,
                393411782
            ],
            [
                61,
                395201250
            ],
            [
                62,
                396049197
            ],
            [
                63,
                396935225
            ],
            [
                64,
                397748777
            ],
            [
                65,
                398573626
            ],
            [
                66,
                399634853
            ],
            [
                67,
                401438178
            ],
            [
                68,
                402770726
            ],
            [
                69,
                403357141
            ],
            [
                70,
                404005833
            ],
            [
                71,
                404573895
            ],
            [
                72,
                405176312
            ],
            [
                73,
                406087436
            ],
            [
                74,
                407507745
            ],
            [
                75,
                408597032
            ],
            [
                76,
                409084394
            ],
            [
                77,
                409590536
            ],
            [
                78,
                410076929
            ],
            [
                79,
                410551953
            ],
            [
                80,
                411136305
            ],
            [
                81,
                412017281
            ],
            [
                82,
                412775151
            ],
            [
                83,
                413078199
            ],
            [
                84,
                413454282
            ],
            [
                85,
                413789230
            ],
            [
                86,
                414126705
            ],
            [
                87,
                414536568
            ],
            [
                88,
                415172414
            ],
            [
                89,
                415645312
            ],
            [
                90,
                415859856
            ],
            [
                91,
                416112048
            ],
            [
                92,
                416349911
            ],
            [
                93,
                416579492
            ],
            [
                94,
                416906880
            ],
            [
                95,
                417430661
            ],
            [
                96,
                417800897
            ],
            [
                97,
                417969425
            ],
            [
                98,
                418165536
            ],
            [
                99,
                418337535
            ],
            [
                100,
                418513721
            ],
            [
                101,
                418767483
            ],
            [
                102,
                419154643
            ],
            [
                103,
                419423967
            ],
            [
                104,
                419526792
            ],
            [
                105,
                419647257
            ],
            [
                106,
                419746342
            ],
            [
                107,
                419846896
            ],
            [
                108,
                420090328
            ],
            [
                109,
                420520139
            ],
            [
                110,
                420995738
            ],
            [
                111,
                421381756
            ],
            [
                112,
                421464015
            ],
            [
                113,
                421534687
            ],
            [
                114,
                421599674
            ],
            [
                115,
                421762882
            ],
            [
                116,
                422079020
            ],
            [
                117,
                422252998
            ],
            [
                118,
                422303304
            ],
            [
                119,
                422363559
            ],
            [
                120,
                422422603
            ],
            [
                121,
                422499719
            ],
            [
                122,
                422699966
            ],
            [
                123,
                423063595
            ],
            [
                124,
                423299088
            ],
            [
                125,
                423375256
            ],
            [
                126,
                423455814
            ],
            [
                127,
                423524933
            ],
            [
                128,
                423597795
            ],
            [
                129,
                423809480
            ],
            [
                130,
                424178821
            ],
            [
                131,
                424399730
            ],
            [
                132,
                424466271
            ],
            [
                133,
                424536942
            ],
            [
                134,
                424598131
            ],
            [
                135,
                424663188
            ],
            [
                136,
                424837518
            ],
            [
                137,
                425158196
            ],
            [
                138,
                425360285
            ],
            [
                139,
                425415671
            ],
            [
                140,
                425476913
            ],
            [
                141,
                425535850
            ],
            [
                142,
                425603608
            ],
            [
                143,
                425743396
            ],
            [
                144,
                425982420
            ],
            [
                145,
                426141814
            ],
            [
                146,
                426231842
            ],
            [
                147,
                426284622
            ],
            [
                148,
                426330344
            ],
            [
                149,
                426382547
            ],
            [
                150,
                426491859
            ],
            [
                151,
                426690085
            ],
            [
                152,
                426818051
            ],
            [
                153,
                426856130
            ],
            [
                154,
                426891167
            ],
            [
                155,
                426924507
            ],
            [
                156,
                426962430
            ],
            [
                157,
                427046077
            ],
            [
                158,
                427195487
            ],
            [
                159,
                427285100
            ],
            [
                160,
                427311268
            ],
            [
                161,
                427335999
            ],
            [
                162,
                427358724
            ],
            [
                163,
                427385273
            ],
            [
                164,
                427446960
            ],
            [
                165,
                427552043
            ],
            [
                166,
                427607869
            ],
            [
                167,
                427630283
            ],
            [
                168,
                427655389
            ],
            [
                169,
                427680179
            ],
            [
                170,
                427709795
            ]
        ],
        name: 'starwars',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Star Wars: Episode I - The Phantom Menace',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#8B5453'
        },
        showlabel: true,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                254809
            ],
            [
                2,
                493774
            ]
        ],
        name: 'starwars4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Star Wars',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#775E55'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                84424532
            ],
            [
                2,
                140951167
            ],
            [
                3,
                191271109
            ],
            [
                4,
                204499664
            ],
            [
                5,
                217632476
            ],
            [
                6,
                227042314
            ],
            [
                7,
                235655468
            ],
            [
                8,
                256887830
            ],
            [
                9,
                290723486
            ],
            [
                10,
                313402397
            ],
            [
                11,
                318801176
            ],
            [
                12,
                324791589
            ],
            [
                13,
                329133743
            ],
            [
                14,
                333170808
            ],
            [
                15,
                343189933
            ],
            [
                16,
                360394291
            ],
            [
                17,
                372030708
            ],
            [
                18,
                375466255
            ],
            [
                19,
                378486835
            ],
            [
                20,
                380816733
            ],
            [
                21,
                383170479
            ],
            [
                22,
                388526903
            ],
            [
                23,
                396813139
            ],
            [
                24,
                404862176
            ],
            [
                25,
                411369385
            ],
            [
                26,
                413318567
            ],
            [
                27,
                414747982
            ],
            [
                28,
                416150025
            ],
            [
                29,
                419033597
            ],
            [
                30,
                423951452
            ],
            [
                31,
                427551427
            ],
            [
                32,
                428633715
            ],
            [
                33,
                429894783
            ],
            [
                34,
                430868667
            ],
            [
                35,
                431813896
            ],
            [
                36,
                433656556
            ],
            [
                37,
                436312967
            ],
            [
                38,
                438153559
            ],
            [
                39,
                438901113
            ],
            [
                40,
                439752678
            ],
            [
                41,
                440471543
            ],
            [
                42,
                441102218
            ],
            [
                43,
                442166874
            ],
            [
                44,
                443689327
            ],
            [
                45,
                444777275
            ],
            [
                46,
                445228711
            ],
            [
                47,
                445730903
            ],
            [
                48,
                446173457
            ],
            [
                49,
                446599953
            ],
            [
                50,
                447334280
            ],
            [
                51,
                448375514
            ],
            [
                52,
                449447357
            ],
            [
                53,
                449772697
            ],
            [
                54,
                450162782
            ],
            [
                55,
                450479161
            ],
            [
                56,
                450785255
            ],
            [
                57,
                451267668
            ],
            [
                58,
                451970769
            ],
            [
                59,
                452474193
            ],
            [
                60,
                452722320
            ],
            [
                61,
                452963254
            ],
            [
                62,
                453126252
            ],
            [
                63,
                453345278
            ],
            [
                64,
                453708860
            ],
            [
                65,
                453978248
            ],
            [
                66,
                454231429
            ],
            [
                67,
                454371767
            ],
            [
                68,
                454526885
            ],
            [
                69,
                454662988
            ],
            [
                70,
                454783082
            ],
            [
                71,
                454911383
            ],
            [
                72,
                455097078
            ],
            [
                73,
                455238846
            ],
            [
                74,
                455308687
            ],
            [
                75,
                455392001
            ],
            [
                76,
                455466546
            ],
            [
                77,
                455530367
            ]
        ],
        name: 'avengers2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Avengers: Age of Ultron',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#5A5A65'
        },
        showlabel: true,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                75754897
            ],
            [
                2,
                120686863
            ],
            [
                3,
                160887295
            ],
            [
                4,
                180276424
            ],
            [
                5,
                198038896
            ],
            [
                6,
                211808988
            ],
            [
                7,
                225011359
            ],
            [
                8,
                242745904
            ],
            [
                9,
                267458321
            ],
            [
                10,
                287112810
            ],
            [
                11,
                295272856
            ],
            [
                12,
                304045972
            ],
            [
                13,
                311379297
            ],
            [
                14,
                318197764
            ],
            [
                15,
                328423814
            ],
            [
                16,
                342696928
            ],
            [
                17,
                353935094
            ],
            [
                18,
                358660592
            ],
            [
                19,
                363334004
            ],
            [
                20,
                367022493
            ],
            [
                21,
                370608819
            ],
            [
                22,
                376209018
            ],
            [
                23,
                384049010
            ],
            [
                24,
                389588216
            ],
            [
                25,
                391932219
            ],
            [
                26,
                394606579
            ],
            [
                27,
                396743702
            ],
            [
                28,
                398775911
            ],
            [
                29,
                401898047
            ],
            [
                30,
                406466053
            ],
            [
                31,
                409787260
            ],
            [
                32,
                411161725
            ],
            [
                33,
                412665020
            ],
            [
                34,
                413861764
            ],
            [
                35,
                415032901
            ],
            [
                36,
                417023135
            ],
            [
                37,
                420167698
            ],
            [
                38,
                422255218
            ],
            [
                39,
                423088380
            ],
            [
                40,
                423976618
            ],
            [
                41,
                424645743
            ],
            [
                42,
                425313950
            ],
            [
                43,
                426729442
            ],
            [
                44,
                428977017
            ],
            [
                45,
                431430285
            ],
            [
                46,
                433311261
            ],
            [
                47,
                433814754
            ],
            [
                48,
                434176924
            ],
            [
                49,
                434564293
            ],
            [
                50,
                435427612
            ],
            [
                51,
                436998761
            ],
            [
                52,
                437782482
            ],
            [
                53,
                438033912
            ],
            [
                54,
                438351214
            ],
            [
                55,
                438614544
            ],
            [
                56,
                438870629
            ],
            [
                57,
                439479702
            ],
            [
                58,
                440507249
            ],
            [
                59,
                441053078
            ],
            [
                60,
                441259444
            ],
            [
                61,
                441497581
            ],
            [
                62,
                441676748
            ],
            [
                63,
                441857870
            ],
            [
                64,
                442205702
            ],
            [
                65,
                442814116
            ],
            [
                66,
                443124014
            ],
            [
                67,
                443227456
            ],
            [
                68,
                443355816
            ],
            [
                69,
                443481942
            ],
            [
                70,
                443588231
            ],
            [
                71,
                443806466
            ],
            [
                72,
                444185120
            ],
            [
                73,
                444377660
            ],
            [
                74,
                444450827
            ],
            [
                75,
                444539967
            ],
            [
                76,
                444613164
            ],
            [
                77,
                444695205
            ],
            [
                78,
                444874399
            ],
            [
                79,
                445169674
            ],
            [
                80,
                445369641
            ],
            [
                81,
                445473624
            ],
            [
                82,
                445548492
            ],
            [
                83,
                445620366
            ],
            [
                84,
                445688597
            ],
            [
                85,
                445838623
            ],
            [
                86,
                446069263
            ],
            [
                87,
                446199996
            ],
            [
                88,
                446247060
            ],
            [
                89,
                446299772
            ],
            [
                90,
                446350903
            ],
            [
                91,
                446404558
            ],
            [
                92,
                446510422
            ],
            [
                93,
                446670784
            ],
            [
                94,
                446764067
            ],
            [
                95,
                446792585
            ],
            [
                96,
                446828688
            ],
            [
                97,
                446861181
            ],
            [
                98,
                446894498
            ],
            [
                99,
                446973503
            ],
            [
                100,
                447090759
            ],
            [
                101,
                447158354
            ],
            [
                102,
                447182460
            ],
            [
                103,
                447208948
            ],
            [
                104,
                447233929
            ],
            [
                105,
                447261407
            ],
            [
                106,
                447332316
            ],
            [
                107,
                447452707
            ],
            [
                108,
                447521147
            ],
            [
                109,
                447549207
            ],
            [
                110,
                447572216
            ],
            [
                111,
                447595455
            ],
            [
                112,
                447614511
            ],
            [
                113,
                447656553
            ],
            [
                114,
                447722850
            ],
            [
                115,
                447764583
            ],
            [
                116,
                447786285
            ],
            [
                117,
                447796919
            ],
            [
                118,
                447807034
            ],
            [
                119,
                447817857
            ],
            [
                120,
                447844064
            ],
            [
                121,
                447885951
            ],
            [
                122,
                447911148
            ],
            [
                123,
                447922495
            ],
            [
                124,
                447936620
            ],
            [
                125,
                447951400
            ],
            [
                126,
                447963899
            ],
            [
                127,
                447992079
            ],
            [
                128,
                448021138
            ],
            [
                129,
                448034362
            ],
            [
                130,
                448038030
            ],
            [
                131,
                448042358
            ],
            [
                132,
                448046413
            ],
            [
                133,
                448052931
            ],
            [
                134,
                448065058
            ],
            [
                135,
                448083829
            ],
            [
                136,
                448093796
            ],
            [
                137,
                448097008
            ],
            [
                138,
                448100216
            ],
            [
                139,
                448103268
            ],
            [
                140,
                448106311
            ],
            [
                141,
                448113420
            ],
            [
                142,
                448124786
            ],
            [
                143,
                448130642
            ],
            [
                144,
                448132546
            ],
            [
                145,
                448134640
            ],
            [
                146,
                448136692
            ],
            [
                147,
                448139099
            ]
        ],
        name: 'batman3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Dark Knight Rises',
            genre: 'Action Thriller',

            mpaaRating: 'PG-13',
            imgMainColor: '#402D23'
        },
        showlabel: true,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                11786415
            ],
            [
                2,
                20945182
            ],
            [
                3,
                49285477
            ],
            [
                4,
                94082519
            ],
            [
                5,
                128983060
            ],
            [
                6,
                140495380
            ],
            [
                7,
                148518679
            ],
            [
                8,
                156522146
            ],
            [
                9,
                164735354
            ],
            [
                10,
                184890392
            ],
            [
                11,
                212125502
            ],
            [
                12,
                236905717
            ],
            [
                13,
                260313719
            ],
            [
                14,
                266120395
            ],
            [
                15,
                271515827
            ],
            [
                16,
                276591486
            ],
            [
                17,
                287045206
            ],
            [
                18,
                302608864
            ],
            [
                19,
                314523202
            ],
            [
                20,
                318064963
            ],
            [
                21,
                321821215
            ],
            [
                22,
                325767202
            ],
            [
                23,
                330016397
            ],
            [
                24,
                337481436
            ],
            [
                25,
                346511753
            ],
            [
                26,
                353333317
            ],
            [
                27,
                356211204
            ],
            [
                28,
                359054821
            ],
            [
                29,
                361840005
            ],
            [
                30,
                364681313
            ],
            [
                31,
                368837503
            ],
            [
                32,
                374235745
            ],
            [
                33,
                378623263
            ],
            [
                34,
                380509910
            ],
            [
                35,
                382783646
            ],
            [
                36,
                384608284
            ],
            [
                37,
                386566083
            ],
            [
                38,
                389714732
            ],
            [
                39,
                393825312
            ],
            [
                40,
                396782535
            ],
            [
                41,
                398263014
            ],
            [
                42,
                399753526
            ],
            [
                43,
                400977740
            ],
            [
                44,
                402300825
            ],
            [
                45,
                404239250
            ],
            [
                46,
                406475278
            ],
            [
                47,
                408139196
            ],
            [
                48,
                410688506
            ],
            [
                49,
                411804318
            ],
            [
                50,
                412928508
            ],
            [
                51,
                414066842
            ],
            [
                52,
                415440867
            ],
            [
                53,
                417193398
            ],
            [
                54,
                418517158
            ],
            [
                55,
                419277884
            ],
            [
                56,
                420140444
            ],
            [
                57,
                420979198
            ],
            [
                58,
                421780860
            ],
            [
                59,
                422670285
            ],
            [
                60,
                423892732
            ],
            [
                61,
                425011646
            ],
            [
                62,
                425545150
            ],
            [
                63,
                426081270
            ],
            [
                64,
                426592176
            ],
            [
                65,
                427124631
            ],
            [
                66,
                427784311
            ],
            [
                67,
                428715869
            ],
            [
                68,
                429441294
            ],
            [
                69,
                429806006
            ],
            [
                70,
                430317578
            ],
            [
                71,
                430806699
            ],
            [
                72,
                431176122
            ],
            [
                73,
                431522984
            ],
            [
                74,
                432040000
            ],
            [
                75,
                432493392
            ],
            [
                76,
                432724124
            ],
            [
                77,
                432979072
            ],
            [
                78,
                433251960
            ],
            [
                79,
                433510973
            ],
            [
                80,
                433765285
            ],
            [
                81,
                434120887
            ],
            [
                82,
                434404842
            ],
            [
                83,
                434545517
            ],
            [
                84,
                434737788
            ],
            [
                85,
                434909809
            ],
            [
                86,
                435073190
            ],
            [
                87,
                435241910
            ],
            [
                88,
                435449431
            ],
            [
                89,
                435640772
            ],
            [
                90,
                435745893
            ],
            [
                91,
                435841134
            ],
            [
                92,
                435940815
            ],
            [
                93,
                436048250
            ],
            [
                94,
                436156384
            ],
            [
                95,
                436339891
            ],
            [
                96,
                436471036
            ],
            [
                97,
                436532440
            ],
            [
                98,
                436599373
            ],
            [
                99,
                436660341
            ],
            [
                100,
                436721703
            ]
        ],
        name: 'shrek2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Shrek 2',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#7B8291'
        },
        showlabel: true,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                3099665
            ],
            [
                2,
                7611314
            ],
            [
                3,
                11835389
            ],
            [
                4,
                14193155
            ],
            [
                5,
                16724092
            ],
            [
                6,
                19320918
            ],
            [
                7,
                21806376
            ],
            [
                8,
                25506800
            ],
            [
                9,
                30365918
            ],
            [
                10,
                34416986
            ],
            [
                11,
                36864295
            ],
            [
                12,
                39504421
            ],
            [
                13,
                42158124
            ],
            [
                14,
                44822010
            ],
            [
                15,
                48868627
            ],
            [
                16,
                54047474
            ],
            [
                17,
                58551562
            ],
            [
                18,
                61323250
            ],
            [
                19,
                64365340
            ],
            [
                20,
                67037474
            ],
            [
                21,
                69703555
            ],
            [
                22,
                73621238
            ],
            [
                23,
                78791283
            ],
            [
                24,
                82480009
            ],
            [
                25,
                86410147
            ],
            [
                26,
                88911270
            ],
            [
                27,
                91527459
            ],
            [
                28,
                94050312
            ],
            [
                29,
                97794594
            ],
            [
                30,
                102652306
            ],
            [
                31,
                106852599
            ],
            [
                32,
                109264627
            ],
            [
                33,
                111619529
            ],
            [
                34,
                114089090
            ],
            [
                35,
                116430515
            ],
            [
                36,
                120260133
            ],
            [
                37,
                125233596
            ],
            [
                38,
                129434096
            ],
            [
                39,
                131926349
            ],
            [
                40,
                134643840
            ],
            [
                41,
                136966146
            ],
            [
                42,
                139317420
            ],
            [
                43,
                142763159
            ],
            [
                44,
                147113884
            ],
            [
                45,
                150572544
            ],
            [
                46,
                152600956
            ],
            [
                47,
                154846898
            ],
            [
                48,
                157148472
            ],
            [
                49,
                159080985
            ],
            [
                50,
                162152605
            ],
            [
                51,
                166328695
            ],
            [
                52,
                169506056
            ],
            [
                53,
                171427836
            ],
            [
                54,
                173401065
            ],
            [
                55,
                175313851
            ],
            [
                56,
                177165841
            ],
            [
                57,
                179878228
            ],
            [
                58,
                183595810
            ],
            [
                59,
                186691147
            ],
            [
                60,
                188491717
            ],
            [
                61,
                190262500
            ],
            [
                62,
                191968833
            ],
            [
                63,
                193519752
            ],
            [
                64,
                196024795
            ],
            [
                65,
                199374676
            ],
            [
                66,
                201968592
            ],
            [
                67,
                203453951
            ],
            [
                68,
                205103355
            ],
            [
                69,
                206615273
            ],
            [
                70,
                208023105
            ],
            [
                71,
                210225776
            ],
            [
                72,
                213267082
            ],
            [
                73,
                215707267
            ],
            [
                74,
                217075453
            ],
            [
                75,
                218440634
            ],
            [
                76,
                219764659
            ],
            [
                77,
                220819589
            ],
            [
                78,
                222722377
            ],
            [
                79,
                225427246
            ],
            [
                80,
                227450298
            ],
            [
                81,
                228359352
            ],
            [
                82,
                229298310
            ],
            [
                83,
                230189023
            ],
            [
                84,
                230977250
            ],
            [
                85,
                232382626
            ],
            [
                86,
                234657148
            ],
            [
                87,
                236998236
            ],
            [
                88,
                238646109
            ],
            [
                89,
                239177568
            ],
            [
                90,
                239655752
            ],
            [
                91,
                240118856
            ],
            [
                92,
                241252612
            ],
            [
                93,
                243318578
            ],
            [
                94,
                244717584
            ],
            [
                95,
                245100056
            ],
            [
                96,
                245540212
            ],
            [
                97,
                245968992
            ],
            [
                98,
                246339094
            ],
            [
                99,
                247361125
            ],
            [
                100,
                249321423
            ],
            [
                101,
                250600981
            ],
            [
                102,
                250926752
            ],
            [
                103,
                251300839
            ],
            [
                104,
                251641941
            ],
            [
                105,
                251939806
            ],
            [
                106,
                252873573
            ],
            [
                107,
                254682309
            ],
            [
                108,
                256031594
            ],
            [
                109,
                256405912
            ],
            [
                110,
                256739834
            ],
            [
                111,
                257048456
            ],
            [
                112,
                257344746
            ],
            [
                113,
                258198499
            ],
            [
                114,
                259930330
            ],
            [
                115,
                261086886
            ],
            [
                116,
                261381057
            ],
            [
                117,
                261676886
            ],
            [
                118,
                261955747
            ],
            [
                119,
                262211307
            ],
            [
                120,
                263029848
            ],
            [
                121,
                264707823
            ],
            [
                122,
                265973075
            ],
            [
                123,
                266478906
            ],
            [
                124,
                266741653
            ],
            [
                125,
                266980280
            ],
            [
                126,
                267241424
            ],
            [
                127,
                267974655
            ],
            [
                128,
                269520994
            ],
            [
                129,
                270557116
            ],
            [
                130,
                270823996
            ],
            [
                131,
                271083432
            ],
            [
                132,
                271320323
            ],
            [
                133,
                271594872
            ],
            [
                134,
                272328088
            ],
            [
                135,
                273763043
            ],
            [
                136,
                274838082
            ],
            [
                137,
                275081705
            ],
            [
                138,
                275352724
            ],
            [
                139,
                275576031
            ],
            [
                140,
                275796622
            ],
            [
                141,
                276399760
            ],
            [
                142,
                277532658
            ],
            [
                143,
                278565874
            ],
            [
                144,
                278817395
            ],
            [
                145,
                279128114
            ],
            [
                146,
                279343174
            ],
            [
                147,
                279551958
            ],
            [
                148,
                280203582
            ],
            [
                149,
                281586084
            ],
            [
                150,
                282598650
            ],
            [
                151,
                282809495
            ],
            [
                152,
                283048506
            ],
            [
                153,
                283324368
            ],
            [
                154,
                283763623
            ],
            [
                155,
                284424778
            ],
            [
                156,
                285763291
            ],
            [
                157,
                286709095
            ],
            [
                158,
                286899252
            ],
            [
                159,
                287113405
            ],
            [
                160,
                287293008
            ],
            [
                161,
                287476191
            ],
            [
                162,
                288108850
            ],
            [
                163,
                289405988
            ],
            [
                164,
                290356895
            ],
            [
                165,
                290568160
            ],
            [
                166,
                290828330
            ],
            [
                167,
                291223317
            ],
            [
                168,
                292012960
            ],
            [
                169,
                293422682
            ],
            [
                170,
                295050132
            ],
            [
                171,
                295989738
            ],
            [
                172,
                296180765
            ],
            [
                173,
                296411572
            ],
            [
                174,
                296568970
            ],
            [
                176,
                297078744
            ],
            [
                177,
                298142537
            ],
            [
                178,
                298924789
            ],
            [
                179,
                299083220
            ],
            [
                180,
                299278614
            ],
            [
                181,
                299430215
            ],
            [
                182,
                299575782
            ],
            [
                183,
                299968498
            ],
            [
                184,
                300798974
            ],
            [
                185,
                301455400
            ],
            [
                186,
                301611481
            ],
            [
                187,
                301824151
            ],
            [
                188,
                302096699
            ],
            [
                189,
                302350061
            ],
            [
                190,
                302902764
            ],
            [
                191,
                303957600
            ],
            [
                192,
                304942178
            ],
            [
                193,
                305369688
            ],
            [
                194,
                305858348
            ],
            [
                195,
                306293198
            ],
            [
                196,
                306834918
            ],
            [
                197,
                307189676
            ],
            [
                198,
                307940850
            ],
            [
                199,
                309375473
            ],
            [
                200,
                310479451
            ],
            [
                201,
                311604018
            ],
            [
                202,
                312700021
            ],
            [
                203,
                313802372
            ],
            [
                204,
                314911094
            ],
            [
                205,
                316458659
            ],
            [
                206,
                317827565
            ],
            [
                207,
                318234428
            ],
            [
                208,
                318584860
            ],
            [
                209,
                318890220
            ],
            [
                210,
                319140904
            ],
            [
                211,
                319717206
            ],
            [
                212,
                320885281
            ],
            [
                213,
                321763163
            ],
            [
                214,
                321952256
            ],
            [
                215,
                322171023
            ],
            [
                216,
                322355878
            ],
            [
                217,
                321763163
            ],
            [
                218,
                322956667
            ],
            [
                219,
                323726371
            ],
            [
                220,
                324297874
            ],
            [
                221,
                324437249
            ],
            [
                222,
                324569586
            ],
            [
                223,
                324689314
            ],
            [
                224,
                324793587
            ],
            [
                225,
                325067003
            ],
            [
                226,
                325703813
            ],
            [
                227,
                326208498
            ],
            [
                228,
                326313172
            ],
            [
                229,
                326434340
            ],
            [
                230,
                326535546
            ],
            [
                231,
                326638438
            ],
            [
                232,
                326903012
            ],
            [
                233,
                327517548
            ],
            [
                234,
                327909778
            ],
            [
                235,
                328014053
            ],
            [
                236,
                328118609
            ],
            [
                237,
                328207770
            ],
            [
                238,
                328287532
            ],
            [
                239,
                328483028
            ],
            [
                240,
                328976104
            ],
            [
                241,
                329338126
            ],
            [
                242,
                329397487
            ],
            [
                243,
                329462370
            ],
            [
                244,
                329525954
            ],
            [
                245,
                329581773
            ],
            [
                246,
                329742295
            ],
            [
                247,
                330110140
            ],
            [
                248,
                330392812
            ],
            [
                249,
                330470779
            ],
            [
                250,
                330550172
            ],
            [
                251,
                330623901
            ],
            [
                252,
                330697312
            ],
            [
                253,
                331016599
            ],
            [
                254,
                331706333
            ],
            [
                255,
                332308013
            ],
            [
                256,
                332585150
            ],
            [
                257,
                332740310
            ],
            [
                258,
                332867042
            ],
            [
                259,
                332985896
            ],
            [
                260,
                333277225
            ],
            [
                261,
                333901636
            ],
            [
                262,
                334376230
            ],
            [
                263,
                334442851
            ],
            [
                264,
                334568624
            ],
            [
                265,
                334664946
            ],
            [
                266,
                334755328
            ],
            [
                267,
                334980830
            ],
            [
                268,
                335431809
            ],
            [
                269,
                335769779
            ],
            [
                270,
                335846397
            ],
            [
                271,
                335939875
            ],
            [
                272,
                336014565
            ],
            [
                273,
                336080296
            ],
            [
                274,
                336247331
            ],
            [
                275,
                336575594
            ],
            [
                276,
                336811284
            ],
            [
                277,
                336867259
            ],
            [
                278,
                336937844
            ],
            [
                279,
                336994325
            ],
            [
                280,
                337053319
            ],
            [
                281,
                337209821
            ],
            [
                282,
                337546990
            ],
            [
                283,
                337803244
            ],
            [
                284,
                337863050
            ],
            [
                285,
                337936002
            ],
            [
                286,
                338001152
            ],
            [
                287,
                338065673
            ],
            [
                288,
                338190640
            ],
            [
                289,
                338427300
            ],
            [
                290,
                338601802
            ],
            [
                291,
                338660363
            ],
            [
                292,
                338729324
            ],
            [
                293,
                338790009
            ],
            [
                295,
                339111278
            ],
            [
                296,
                339497763
            ],
            [
                297,
                339839909
            ],
            [
                298,
                340041065
            ],
            [
                299,
                340202098
            ],
            [
                300,
                340340697
            ],
            [
                301,
                340462121
            ],
            [
                302,
                340822037
            ],
            [
                303,
                341432595
            ],
            [
                304,
                341923413
            ],
            [
                305,
                342048218
            ],
            [
                306,
                342270196
            ],
            [
                307,
                342447365
            ],
            [
                308,
                342606287
            ],
            [
                309,
                342976462
            ],
            [
                310,
                343666039
            ],
            [
                311,
                344163877
            ],
            [
                312,
                344296018
            ],
            [
                313,
                344434710
            ],
            [
                314,
                344548443
            ],
            [
                315,
                344654028
            ],
            [
                316,
                344940506
            ],
            [
                317,
                345459635
            ],
            [
                318,
                345849534
            ],
            [
                319,
                345943875
            ],
            [
                320,
                346034386
            ],
            [
                321,
                346115216
            ],
            [
                322,
                346190133
            ],
            [
                323,
                346395980
            ],
            [
                324,
                346784080
            ],
            [
                325,
                347043083
            ],
            [
                326,
                347102397
            ],
            [
                327,
                347171397
            ],
            [
                328,
                347229966
            ],
            [
                329,
                347281435
            ],
            [
                330,
                347408761
            ],
            [
                331,
                347639928
            ],
            [
                332,
                347807198
            ],
            [
                333,
                347855066
            ],
            [
                334,
                347905325
            ],
            [
                335,
                347951871
            ],
            [
                336,
                347989771
            ],
            [
                337,
                348134859
            ],
            [
                338,
                348376483
            ],
            [
                339,
                348544883
            ],
            [
                340,
                348585815
            ],
            [
                341,
                348635169
            ],
            [
                342,
                348678708
            ],
            [
                343,
                348728868
            ],
            [
                344,
                348939680
            ],
            [
                345,
                349280662
            ],
            [
                346,
                349527852
            ],
            [
                347,
                349602091
            ],
            [
                348,
                349670977
            ],
            [
                349,
                349733874
            ],
            [
                350,
                349796275
            ],
            [
                351,
                350131415
            ],
            [
                352,
                350677277
            ],
            [
                353,
                351234240
            ],
            [
                354,
                351515075
            ],
            [
                355,
                351633331
            ],
            [
                356,
                351749881
            ],
            [
                357,
                351851986
            ],
            [
                358,
                352134333
            ],
            [
                359,
                352622617
            ],
            [
                360,
                352905920
            ],
            [
                361,
                353013716
            ],
            [
                362,
                353132300
            ],
            [
                363,
                353238581
            ],
            [
                364,
                353343189
            ]
        ],
        name: 'et',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'E.T.: The Extra-Terrestrial',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#353A4A'
        },
        showlabel: true,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                70950136
            ],
            [
                2,
                123569242
            ],
            [
                3,
                158074286
            ],
            [
                4,
                170396008
            ],
            [
                5,
                186356317
            ],
            [
                6,
                207164427
            ],
            [
                7,
                222116056
            ],
            [
                8,
                253686504
            ],
            [
                9,
                282087763
            ],
            [
                10,
                296295657
            ],
            [
                11,
                299698207
            ],
            [
                12,
                303708162
            ],
            [
                13,
                306725979
            ],
            [
                14,
                309664956
            ],
            [
                15,
                317440734
            ],
            [
                16,
                329363612
            ],
            [
                17,
                335850842
            ],
            [
                18,
                337794484
            ],
            [
                19,
                340167159
            ],
            [
                20,
                342022652
            ],
            [
                21,
                343831997
            ],
            [
                22,
                347937894
            ],
            [
                23,
                353684449
            ],
            [
                24,
                357503663
            ],
            [
                25,
                358823252
            ],
            [
                26,
                360346858
            ],
            [
                27,
                361589963
            ],
            [
                28,
                362953796
            ],
            [
                29,
                365458768
            ],
            [
                30,
                368860257
            ],
            [
                31,
                371718275
            ],
            [
                32,
                373997033
            ],
            [
                33,
                375355861
            ],
            [
                34,
                377884011
            ],
            [
                35,
                380923843
            ],
            [
                36,
                384356876
            ],
            [
                37,
                388053784
            ],
            [
                38,
                390985322
            ],
            [
                39,
                393474778
            ],
            [
                40,
                395526705
            ],
            [
                41,
                398407026
            ],
            [
                42,
                400088390
            ],
            [
                43,
                402531201
            ],
            [
                44,
                405577552
            ],
            [
                45,
                407139699
            ],
            [
                46,
                407703526
            ],
            [
                47,
                408372775
            ],
            [
                48,
                408896153
            ],
            [
                49,
                409392651
            ],
            [
                50,
                410600745
            ],
            [
                51,
                412684209
            ],
            [
                52,
                413775859
            ],
            [
                53,
                414069798
            ],
            [
                54,
                414423452
            ],
            [
                55,
                414714237
            ],
            [
                56,
                414999792
            ],
            [
                57,
                415630857
            ],
            [
                58,
                416775276
            ],
            [
                59,
                417450973
            ],
            [
                60,
                418019611
            ],
            [
                61,
                418182152
            ],
            [
                62,
                418329756
            ],
            [
                63,
                418481968
            ],
            [
                64,
                418879606
            ],
            [
                65,
                419627702
            ],
            [
                66,
                420021917
            ],
            [
                67,
                420127670
            ],
            [
                68,
                420255106
            ],
            [
                69,
                420357904
            ],
            [
                70,
                420468544
            ],
            [
                71,
                420746003
            ],
            [
                72,
                421256407
            ],
            [
                73,
                421408636
            ],
            [
                74,
                421490985
            ],
            [
                75,
                421592065
            ],
            [
                76,
                421669861
            ],
            [
                77,
                421750785
            ],
            [
                78,
                421915396
            ],
            [
                79,
                422238736
            ],
            [
                80,
                422411453
            ],
            [
                81,
                422461572
            ],
            [
                82,
                422511049
            ],
            [
                83,
                422541078
            ],
            [
                84,
                422575819
            ],
            [
                85,
                422748276
            ],
            [
                86,
                422964659
            ],
            [
                87,
                423111431
            ],
            [
                88,
                423202848
            ],
            [
                89,
                423239439
            ],
            [
                90,
                423273340
            ],
            [
                91,
                423307516
            ],
            [
                92,
                423395821
            ],
            [
                93,
                423547716
            ],
            [
                94,
                423626642
            ],
            [
                95,
                423646682
            ],
            [
                96,
                423671890
            ],
            [
                97,
                423694814
            ],
            [
                98,
                423719424
            ],
            [
                99,
                423768827
            ],
            [
                100,
                423860821
            ],
            [
                101,
                423905466
            ],
            [
                102,
                423921280
            ],
            [
                103,
                423939264
            ],
            [
                104,
                423953700
            ],
            [
                105,
                423969843
            ],
            [
                106,
                424004535
            ],
            [
                107,
                424060954
            ],
            [
                108,
                424088260
            ],
            [
                109,
                424098843
            ],
            [
                110,
                424112127
            ],
            [
                111,
                424122403
            ],
            [
                112,
                424133881
            ],
            [
                113,
                424194100
            ],
            [
                114,
                424282090
            ],
            [
                115,
                424339131
            ],
            [
                116,
                424357871
            ],
            [
                117,
                424379894
            ],
            [
                118,
                424399597
            ],
            [
                119,
                424417580
            ],
            [
                120,
                424449830
            ],
            [
                121,
                424500497
            ],
            [
                122,
                424532478
            ],
            [
                123,
                424543695
            ],
            [
                124,
                424557150
            ],
            [
                125,
                424569768
            ],
            [
                126,
                424582054
            ],
            [
                127,
                424600272
            ],
            [
                128,
                424628986
            ],
            [
                129,
                424645577
            ],
            [
                130,
                424650752
            ],
            [
                131,
                424656792
            ],
            [
                132,
                424662174
            ],
            [
                133,
                424668047
            ]
        ],
        name: 'catchingfire',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hunger Games: Catching Fire',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#3F1911'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                55830600
            ],
            [
                2,
                100273825
            ],
            [
                3,
                135634554
            ],
            [
                4,
                153774825
            ],
            [
                5,
                169506744
            ],
            [
                6,
                183661469
            ],
            [
                7,
                196019502
            ],
            [
                8,
                214563858
            ],
            [
                9,
                239410629
            ],
            [
                10,
                258364766
            ],
            [
                11,
                266277457
            ],
            [
                12,
                273767461
            ],
            [
                13,
                280215929
            ],
            [
                14,
                286684032
            ],
            [
                15,
                296676213
            ],
            [
                16,
                311341880
            ],
            [
                17,
                321899233
            ],
            [
                18,
                326203444
            ],
            [
                19,
                330424411
            ],
            [
                20,
                334133670
            ],
            [
                21,
                337879183
            ],
            [
                22,
                343845283
            ],
            [
                23,
                352233958
            ],
            [
                24,
                358485761
            ],
            [
                25,
                361089168
            ],
            [
                26,
                363838343
            ],
            [
                27,
                366387380
            ],
            [
                28,
                368697958
            ],
            [
                29,
                371939269
            ],
            [
                30,
                376421667
            ],
            [
                31,
                379699644
            ],
            [
                32,
                381273783
            ],
            [
                33,
                382656373
            ],
            [
                34,
                383881830
            ],
            [
                35,
                385193854
            ],
            [
                36,
                387274051
            ],
            [
                37,
                390330892
            ],
            [
                38,
                392431781
            ],
            [
                39,
                393369734
            ],
            [
                40,
                394371747
            ],
            [
                41,
                395208464
            ],
            [
                42,
                396040741
            ],
            [
                43,
                397426174
            ],
            [
                44,
                399667443
            ],
            [
                45,
                401253092
            ],
            [
                46,
                401821420
            ],
            [
                47,
                402415220
            ],
            [
                48,
                402975626
            ],
            [
                49,
                403565356
            ],
            [
                50,
                404627141
            ],
            [
                51,
                406311953
            ],
            [
                52,
                407544616
            ],
            [
                53,
                407969720
            ],
            [
                54,
                408392316
            ],
            [
                55,
                408766323
            ],
            [
                56,
                409098046
            ],
            [
                57,
                409927376
            ],
            [
                58,
                411397806
            ],
            [
                59,
                412883344
            ],
            [
                60,
                414013957
            ],
            [
                61,
                414229498
            ],
            [
                62,
                414415202
            ],
            [
                63,
                414596572
            ],
            [
                64,
                415091504
            ],
            [
                65,
                416066198
            ],
            [
                66,
                416591183
            ],
            [
                67,
                416710619
            ],
            [
                68,
                416848908
            ],
            [
                69,
                416993301
            ],
            [
                70,
                417140749
            ],
            [
                71,
                417479000
            ],
            [
                72,
                418077000
            ],
            [
                73,
                418423143
            ],
            [
                74,
                418509000
            ],
            [
                75,
                418600000
            ],
            [
                76,
                418691000
            ],
            [
                77,
                418786083
            ],
            [
                78,
                419006000
            ],
            [
                79,
                419430000
            ],
            [
                80,
                419654338
            ],
            [
                81,
                419707000
            ],
            [
                82,
                419761000
            ],
            [
                83,
                419814000
            ],
            [
                84,
                419866407
            ]
        ],
        name: 'piratesofthecaribbean2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Pirates of the Caribbean: Dead Man´s Chest',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#463D20'
        },
        showlabel: false,
        color: 'rgba(52,152,219,0.75)',
        linkedTo: 'Period'
    }, {
        data: [
            [
                1,
                41148961
            ],
            [
                2,
                78240091
            ],
            [
                3,
                110307189
            ],
            [
                4,
                125913275
            ],
            [
                5,
                141036487
            ],
            [
                6,
                154495178
            ],
            [
                7,
                167551682
            ],
            [
                8,
                185502325
            ],
            [
                9,
                208092816
            ],
            [
                10,
                226889351
            ],
            [
                11,
                235811275
            ],
            [
                12,
                244029214
            ],
            [
                13,
                251344663
            ],
            [
                14,
                258826169
            ],
            [
                15,
                269363263
            ],
            [
                16,
                280796714
            ],
            [
                17,
                289106193
            ],
            [
                18,
                301883298
            ],
            [
                19,
                307822780
            ],
            [
                20,
                313077846
            ],
            [
                21,
                318224899
            ],
            [
                22,
                324706852
            ],
            [
                23,
                333652199
            ],
            [
                24,
                339240857
            ],
            [
                25,
                342040500
            ],
            [
                26,
                345465001
            ],
            [
                27,
                348453463
            ],
            [
                28,
                350967102
            ],
            [
                29,
                354467692
            ],
            [
                30,
                359226345
            ],
            [
                31,
                362965378
            ],
            [
                32,
                364856662
            ],
            [
                33,
                366920787
            ],
            [
                34,
                368682193
            ],
            [
                35,
                370499039
            ],
            [
                36,
                373124538
            ],
            [
                37,
                376699175
            ],
            [
                38,
                379416551
            ],
            [
                39,
                380588257
            ],
            [
                40,
                381967103
            ],
            [
                41,
                383281846
            ],
            [
                42,
                384638584
            ],
            [
                43,
                386090760
            ],
            [
                44,
                388095185
            ],
            [
                45,
                389761491
            ],
            [
                46,
                390606539
            ],
            [
                47,
                391571177
            ],
            [
                48,
                392435416
            ],
            [
                49,
                393268254
            ],
            [
                50,
                394146086
            ],
            [
                51,
                395357723
            ],
            [
                52,
                396387342
            ],
            [
                53,
                396924616
            ],
            [
                54,
                397518546
            ],
            [
                55,
                398033383
            ],
            [
                56,
                398602095
            ],
            [
                57,
                399220705
            ],
            [
                58,
                400063178
            ],
            [
                59,
                400824826
            ],
            [
                60,
                401215022
            ],
            [
                61,
                401584353
            ],
            [
                62,
                401948454
            ],
            [
                63,
                402280518
            ],
            [
                64,
                402649243
            ],
            [
                65,
                403234809
            ],
            [
                66,
                403803642
            ],
            [
                67,
                404033760
            ],
            [
                68,
                404276620
            ],
            [
                69,
                404488263
            ],
            [
                70,
                404648511
            ],
            [
                71,
                404915312
            ],
            [
                72,
                405342435
            ],
            [
                73,
                405659221
            ],
            [
                74,
                405781941
            ],
            [
                75,
                405931112
            ],
            [
                76,
                406040342
            ],
            [
                77,
                406155373
            ],
            [
                78,
                406575067
            ],
            [
                79,
                407339295
            ],
            [
                80,
                408100174
            ],
            [
                81,
                408890408
            ],
            [
                82,
                409000331
            ],
            [
                83,
                409091091
            ],
            [
                84,
                409214041
            ],
            [
                85,
                409366512
            ],
            [
                86,
                409708660
            ],
            [
                87,
                409976037
            ],
            [
                88,
                410019427
            ],
            [
                89,
                410070154
            ],
            [
                90,
                410115979
            ],
            [
                91,
                410171027
            ]
        ],
        name: 'toystory3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Toy Story 3',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#A48555'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                68858555
            ],
            [
                2,
                131131773
            ],
            [
                3,
                174144585
            ],
            [
                4,
                185412195
            ],
            [
                5,
                196699091
            ],
            [
                6,
                204811482
            ],
            [
                7,
                212421084
            ],
            [
                8,
                232134916
            ],
            [
                9,
                264188043
            ],
            [
                10,
                284946699
            ],
            [
                11,
                289562441
            ],
            [
                12,
                294723579
            ],
            [
                13,
                298595076
            ],
            [
                14,
                301891883
            ],
            [
                15,
                311405998
            ],
            [
                16,
                326831976
            ],
            [
                17,
                337661977
            ],
            [
                18,
                340868034
            ],
            [
                19,
                343620220
            ],
            [
                20,
                345876981
            ],
            [
                21,
                348082524
            ],
            [
                22,
                353228940
            ],
            [
                23,
                360762094
            ],
            [
                24,
                367407116
            ],
            [
                25,
                372775931
            ],
            [
                26,
                374335928
            ],
            [
                27,
                375582715
            ],
            [
                28,
                376745285
            ],
            [
                29,
                378998131
            ],
            [
                30,
                382638451
            ],
            [
                31,
                385187736
            ],
            [
                32,
                385942966
            ],
            [
                33,
                386823292
            ],
            [
                34,
                387631585
            ],
            [
                35,
                388529665
            ],
            [
                36,
                390224698
            ],
            [
                37,
                392707303
            ],
            [
                38,
                394283326
            ],
            [
                39,
                394952363
            ],
            [
                40,
                395606691
            ],
            [
                41,
                396159803
            ],
            [
                42,
                396702239
            ],
            [
                43,
                397451305
            ],
            [
                44,
                398505292
            ],
            [
                45,
                399659094
            ],
            [
                46,
                399985196
            ],
            [
                47,
                400353801
            ],
            [
                48,
                400669434
            ],
            [
                49,
                400945222
            ],
            [
                50,
                401716045
            ],
            [
                51,
                402643042
            ],
            [
                52,
                403157804
            ],
            [
                53,
                403366227
            ],
            [
                54,
                403603089
            ],
            [
                55,
                403823046
            ],
            [
                56,
                404032056
            ],
            [
                57,
                404448236
            ],
            [
                58,
                405046013
            ],
            [
                59,
                405393205
            ],
            [
                60,
                405557106
            ],
            [
                61,
                405686271
            ],
            [
                62,
                405806520
            ],
            [
                63,
                405929319
            ],
            [
                64,
                406108823
            ],
            [
                65,
                406307654
            ],
            [
                66,
                406410987
            ],
            [
                67,
                406455862
            ],
            [
                68,
                406512887
            ],
            [
                69,
                406563649
            ],
            [
                70,
                406609688
            ]
        ],
        name: 'ironman3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Iron Man 3',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#625140'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                67263650
            ],
            [
                2,
                117658069
            ],
            [
                3,
                152535747
            ],
            [
                4,
                163359535
            ],
            [
                5,
                173707733
            ],
            [
                6,
                181759438
            ],
            [
                7,
                189932838
            ],
            [
                8,
                208585398
            ],
            [
                9,
                233324271
            ],
            [
                10,
                248483901
            ],
            [
                11,
                253006396
            ],
            [
                12,
                258330642
            ],
            [
                13,
                262939407
            ],
            [
                14,
                269339165
            ],
            [
                15,
                282138997
            ],
            [
                16,
                295156390
            ],
            [
                17,
                302450722
            ],
            [
                18,
                306593939
            ],
            [
                19,
                309887222
            ],
            [
                20,
                312737907
            ],
            [
                21,
                315569539
            ],
            [
                22,
                321973064
            ],
            [
                23,
                331290322
            ],
            [
                24,
                336666363
            ],
            [
                25,
                338063318
            ],
            [
                26,
                339629253
            ],
            [
                27,
                340961282
            ],
            [
                28,
                342400460
            ],
            [
                29,
                346414692
            ],
            [
                30,
                352914760
            ],
            [
                31,
                357066467
            ],
            [
                32,
                358075670
            ],
            [
                33,
                359219019
            ],
            [
                34,
                360163155
            ],
            [
                35,
                361204750
            ],
            [
                36,
                364197718
            ],
            [
                37,
                369164992
            ],
            [
                38,
                372019021
            ],
            [
                39,
                372740943
            ],
            [
                40,
                373605139
            ],
            [
                41,
                374317455
            ],
            [
                42,
                375026998
            ],
            [
                43,
                376657044
            ],
            [
                44,
                379083921
            ],
            [
                45,
                380614659
            ],
            [
                46,
                381039319
            ],
            [
                47,
                381574650
            ],
            [
                48,
                382035994
            ],
            [
                49,
                382501686
            ],
            [
                50,
                383689388
            ],
            [
                51,
                385545433
            ],
            [
                52,
                387007048
            ],
            [
                53,
                387405528
            ],
            [
                54,
                387870286
            ],
            [
                55,
                388246795
            ],
            [
                56,
                388631110
            ],
            [
                57,
                389455507
            ],
            [
                58,
                390726156
            ],
            [
                59,
                391581441
            ],
            [
                60,
                391934445
            ],
            [
                61,
                392280533
            ],
            [
                62,
                392609490
            ],
            [
                63,
                393008785
            ],
            [
                64,
                393609026
            ],
            [
                65,
                394490717
            ],
            [
                66,
                395320191
            ],
            [
                67,
                396022168
            ],
            [
                68,
                396271161
            ],
            [
                69,
                396506225
            ],
            [
                70,
                396773748
            ],
            [
                71,
                397228630
            ],
            [
                72,
                397906035
            ],
            [
                73,
                398340934
            ],
            [
                74,
                398549683
            ],
            [
                75,
                398768979
            ],
            [
                76,
                398974636
            ],
            [
                77,
                399200322
            ],
            [
                78,
                399519261
            ],
            [
                79,
                399950274
            ],
            [
                80,
                400272535
            ],
            [
                81,
                400429538
            ],
            [
                82,
                400601121
            ],
            [
                83,
                400758010
            ],
            [
                84,
                400913620
            ],
            [
                85,
                401161515
            ],
            [
                86,
                401499517
            ],
            [
                87,
                401766452
            ],
            [
                88,
                401903713
            ],
            [
                89,
                402050626
            ],
            [
                90,
                402193216
            ],
            [
                91,
                402339722
            ],
            [
                92,
                402524171
            ],
            [
                93,
                402779785
            ],
            [
                94,
                402964540
            ],
            [
                95,
                403061698
            ],
            [
                96,
                403168935
            ],
            [
                97,
                403266710
            ],
            [
                98,
                403371707
            ],
            [
                99,
                403485693
            ],
            [
                100,
                403643849
            ],
            [
                101,
                403768852
            ],
            [
                102,
                403844068
            ],
            [
                103,
                403913666
            ],
            [
                104,
                403995077
            ],
            [
                105,
                404066654
            ],
            [
                106,
                404164823
            ],
            [
                107,
                404293883
            ],
            [
                108,
                404382133
            ],
            [
                109,
                404428919
            ],
            [
                110,
                404481406
            ],
            [
                111,
                404532847
            ],
            [
                112,
                404584896
            ],
            [
                113,
                404666211
            ],
            [
                114,
                404782363
            ],
            [
                115,
                404864651
            ],
            [
                116,
                404906784
            ],
            [
                117,
                404954713
            ],
            [
                118,
                405000343
            ],
            [
                119,
                405045474
            ],
            [
                120,
                405101170
            ],
            [
                121,
                405173614
            ],
            [
                122,
                405227711
            ],
            [
                123,
                405259261
            ],
            [
                124,
                405295437
            ],
            [
                125,
                405328665
            ],
            [
                126,
                405363383
            ],
            [
                127,
                405515861
            ],
            [
                128,
                405719580
            ],
            [
                129,
                405882323
            ],
            [
                130,
                405974995
            ],
            [
                131,
                406079037
            ],
            [
                132,
                406172855
            ],
            [
                133,
                406267858
            ],
            [
                134,
                406397105
            ],
            [
                135,
                406569712
            ],
            [
                136,
                406697224
            ],
            [
                137,
                406763450
            ],
            [
                138,
                406833028
            ],
            [
                139,
                406900777
            ],
            [
                140,
                406970235
            ],
            [
                141,
                407069837
            ],
            [
                142,
                407202884
            ],
            [
                143,
                407294292
            ],
            [
                144,
                407340907
            ],
            [
                145,
                407392200
            ],
            [
                146,
                407436802
            ],
            [
                147,
                407483257
            ],
            [
                148,
                407549767
            ],
            [
                149,
                407633798
            ],
            [
                150,
                407688212
            ],
            [
                151,
                407708885
            ],
            [
                152,
                407730517
            ],
            [
                153,
                407749784
            ],
            [
                154,
                407769160
            ],
            [
                155,
                407802083
            ],
            [
                156,
                407852636
            ],
            [
                157,
                407884011
            ],
            [
                158,
                407894024
            ],
            [
                159,
                407904454
            ],
            [
                160,
                407913651
            ],
            [
                161,
                407923309
            ],
            [
                162,
                407936467
            ],
            [
                163,
                407961444
            ],
            [
                164,
                407981652
            ],
            [
                165,
                407999255
            ],
            [
                166,
                408003494
            ],
            [
                167,
                408006922
            ],
            [
                168,
                408010692
            ]
        ],
        name: 'hungergames',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hunger Games',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#441F0F'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                39406872
            ],
            [
                2,
                83029136
            ],
            [
                3,
                114844116
            ],
            [
                4,
                125878901
            ],
            [
                5,
                135840755
            ],
            [
                6,
                144156124
            ],
            [
                7,
                151622504
            ],
            [
                8,
                171529078
            ],
            [
                9,
                202035007
            ],
            [
                10,
                223040031
            ],
            [
                11,
                228251280
            ],
            [
                12,
                232788846
            ],
            [
                13,
                237021890
            ],
            [
                14,
                240536756
            ],
            [
                15,
                252374308
            ],
            [
                16,
                272386994
            ],
            [
                17,
                285573668
            ],
            [
                18,
                289882492
            ],
            [
                19,
                292666312
            ],
            [
                20,
                295142188
            ],
            [
                21,
                297826648
            ],
            [
                22,
                305073768
            ],
            [
                23,
                316381817
            ],
            [
                24,
                326334752
            ],
            [
                25,
                333641492
            ],
            [
                26,
                335649825
            ],
            [
                27,
                337501557
            ],
            [
                28,
                339506133
            ],
            [
                29,
                343221702
            ],
            [
                30,
                349648306
            ],
            [
                31,
                353823544
            ],
            [
                32,
                355330685
            ],
            [
                33,
                356983440
            ],
            [
                34,
                358505354
            ],
            [
                35,
                360117121
            ],
            [
                36,
                363091775
            ],
            [
                37,
                367311497
            ],
            [
                38,
                370428183
            ],
            [
                39,
                371506188
            ],
            [
                40,
                372704115
            ],
            [
                41,
                373830231
            ],
            [
                42,
                375021685
            ],
            [
                43,
                377146371
            ],
            [
                44,
                380157865
            ],
            [
                45,
                382537669
            ],
            [
                46,
                383361967
            ],
            [
                47,
                384238471
            ],
            [
                48,
                385034435
            ],
            [
                49,
                385826381
            ],
            [
                50,
                387132852
            ],
            [
                51,
                389010631
            ],
            [
                52,
                390382313
            ],
            [
                53,
                390935574
            ],
            [
                54,
                391538987
            ],
            [
                55,
                392135480
            ],
            [
                56,
                392744257
            ],
            [
                57,
                393647230
            ],
            [
                58,
                394899346
            ],
            [
                59,
                395874471
            ],
            [
                60,
                396370509
            ],
            [
                61,
                396874331
            ],
            [
                62,
                397362779
            ],
            [
                63,
                397853721
            ],
            [
                64,
                398632689
            ],
            [
                65,
                399485653
            ],
            [
                66,
                400058357
            ],
            [
                67,
                400304057
            ],
            [
                68,
                400580598
            ],
            [
                69,
                400839604
            ],
            [
                70,
                401101446
            ],
            [
                92,
                403340827
            ],
            [
                93,
                403436531
            ],
            [
                94,
                403505336
            ],
            [
                99,
                403560381
            ],
            [
                100,
                403597076
            ],
            [
                101,
                403620726
            ],
            [
                106,
                403664515
            ],
            [
                107,
                403689347
            ],
            [
                108,
                403706375
            ]
        ],
        name: 'spiderman',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Spider-Man',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#A66B38'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                0,
                3132632
            ],
            [
                1,
                18246360
            ],
            [
                2,
                35855660
            ],
            [
                3,
                50159460
            ],
            [
                4,
                58777800
            ],
            [
                5,
                67071600
            ],
            [
                6,
                74139360
            ],
            [
                7,
                81717485
            ],
            [
                8,
                92586505
            ],
            [
                9,
                108110195
            ],
            [
                10,
                120173345
            ],
            [
                11,
                126643580
            ],
            [
                12,
                132614230
            ],
            [
                13,
                138060925
            ],
            [
                14,
                143407945
            ],
            [
                15,
                151595345
            ],
            [
                16,
                162544465
            ],
            [
                17,
                171098465
            ],
            [
                18,
                175129415
            ],
            [
                19,
                179237015
            ],
            [
                20,
                182988575
            ],
            [
                21,
                186763115
            ],
            [
                22,
                193053035
            ],
            [
                23,
                200902960
            ],
            [
                24,
                205732720
            ],
            [
                25,
                212060080
            ],
            [
                26,
                215331150
            ],
            [
                27,
                218267475
            ],
            [
                28,
                221116335
            ],
            [
                29,
                225566610
            ],
            [
                30,
                231838035
            ],
            [
                31,
                236429385
            ],
            [
                32,
                238571995
            ],
            [
                33,
                240803545
            ],
            [
                34,
                242906870
            ],
            [
                35,
                244856270
            ],
            [
                36,
                247963025
            ],
            [
                37,
                252527270
            ],
            [
                38,
                255723520
            ],
            [
                39,
                257475065
            ],
            [
                40,
                259392815
            ],
            [
                41,
                260990940
            ],
            [
                42,
                262537925
            ],
            [
                43,
                264925205
            ],
            [
                44,
                268429685
            ],
            [
                45,
                270958085
            ],
            [
                46,
                272198815
            ],
            [
                47,
                273793415
            ],
            [
                48,
                274956420
            ],
            [
                49,
                276210840
            ],
            [
                50,
                278180560
            ],
            [
                51,
                281049500
            ],
            [
                52,
                283094155
            ],
            [
                53,
                284099730
            ],
            [
                54,
                285186380
            ],
            [
                55,
                286113460
            ],
            [
                56,
                287051075
            ],
            [
                57,
                288556815
            ],
            [
                58,
                290739185
            ],
            [
                59,
                292168690
            ],
            [
                60,
                292918740
            ],
            [
                61,
                293827630
            ],
            [
                62,
                294537850
            ],
            [
                63,
                295267155
            ],
            [
                64,
                296494675
            ],
            [
                65,
                298259800
            ],
            [
                66,
                299567960
            ],
            [
                67,
                300228025
            ],
            [
                68,
                301032940
            ],
            [
                69,
                301691480
            ],
            [
                70,
                302341355
            ],
            [
                71,
                303440600
            ],
            [
                72,
                305027480
            ],
            [
                73,
                306101930
            ],
            [
                74,
                306618680
            ],
            [
                75,
                307269350
            ],
            [
                76,
                307761695
            ],
            [
                77,
                308222780
            ],
            [
                78,
                309008695
            ],
            [
                79,
                310301415
            ],
            [
                80,
                311146090
            ],
            [
                81,
                311450100
            ],
            [
                82,
                311878320
            ],
            [
                83,
                312187860
            ],
            [
                84,
                312505110
            ],
            [
                85,
                313250635
            ],
            [
                86,
                314564160
            ],
            [
                87,
                315700185
            ],
            [
                88,
                316609010
            ],
            [
                89,
                316867385
            ],
            [
                90,
                317053165
            ],
            [
                91,
                317240205
            ],
            [
                92,
                317758230
            ],
            [
                93,
                318761855
            ],
            [
                94,
                319344605
            ],
            [
                95,
                319478590
            ],
            [
                96,
                319684120
            ],
            [
                97,
                319840770
            ],
            [
                98,
                320033890
            ],
            [
                99,
                320566765
            ],
            [
                100,
                321559020
            ],
            [
                101,
                322104145
            ],
            [
                102,
                322220245
            ],
            [
                103,
                322393195
            ],
            [
                104,
                322519915
            ],
            [
                105,
                322652395
            ],
            [
                106,
                323022580
            ],
            [
                107,
                323768315
            ],
            [
                108,
                324235070
            ],
            [
                109,
                324337675
            ],
            [
                110,
                324471315
            ],
            [
                111,
                324568410
            ],
            [
                112,
                324670815
            ],
            [
                113,
                324921135
            ],
            [
                114,
                325439655
            ],
            [
                115,
                325734675
            ],
            [
                116,
                325807010
            ],
            [
                117,
                325908890
            ],
            [
                118,
                325985405
            ],
            [
                119,
                326074870
            ],
            [
                120,
                326262925
            ],
            [
                121,
                326662920
            ],
            [
                122,
                326919630
            ],
            [
                123,
                327031645
            ],
            [
                124,
                327098245
            ],
            [
                125,
                327150780
            ],
            [
                126,
                327216900
            ],
            [
                127,
                327374415
            ],
            [
                128,
                327681925
            ],
            [
                129,
                327871950
            ],
            [
                130,
                327915065
            ],
            [
                131,
                327972545
            ],
            [
                132,
                328020655
            ],
            [
                133,
                328074115
            ],
            [
                134,
                328245385
            ],
            [
                135,
                328525645
            ],
            [
                136,
                328704700
            ],
            [
                137,
                328749610
            ],
            [
                138,
                328806765
            ],
            [
                139,
                328851045
            ],
            [
                140,
                328897880
            ],
            [
                141,
                329036530
            ],
            [
                142,
                329266845
            ],
            [
                143,
                329398445
            ],
            [
                144,
                329432270
            ],
            [
                145,
                329479415
            ],
            [
                146,
                329513005
            ],
            [
                147,
                329551175
            ],
            [
                148,
                329649330
            ],
            [
                149,
                329836570
            ],
            [
                150,
                329955860
            ],
            [
                151,
                329982050
            ],
            [
                152,
                330015170
            ],
            [
                153,
                330051295
            ],
            [
                154,
                330110950
            ],
            [
                155,
                330192570
            ],
            [
                156,
                330333555
            ],
            [
                157,
                330422595
            ],
            [
                158,
                330440505
            ],
            [
                159,
                330464385
            ],
            [
                160,
                330487385
            ],
            [
                161,
                330515410
            ],
            [
                162,
                330571215
            ],
            [
                163,
                330684630
            ],
            [
                164,
                330762050
            ],
            [
                165,
                330780425
            ],
            [
                166,
                330804790
            ],
            [
                167,
                331097390
            ],
            [
                168,
                331451590
            ],
            [
                169,
                332136895
            ],
            [
                170,
                332829910
            ],
            [
                171,
                333307310
            ],
            [
                172,
                333427475
            ],
            [
                173,
                333543880
            ],
            [
                174,
                333668290
            ],
            [
                175,
                333773845
            ],
            [
                176,
                334063185
            ],
            [
                177,
                334536295
            ],
            [
                178,
                334849095
            ],
            [
                179,
                334918755
            ],
            [
                180,
                334992285
            ],
            [
                181,
                335065150
            ],
            [
                182,
                335134635
            ],
            [
                183,
                335333915
            ],
            [
                184,
                335661035
            ],
            [
                185,
                335879115
            ],
            [
                186,
                335935140
            ],
            [
                187,
                335990650
            ],
            [
                188,
                336055090
            ],
            [
                189,
                336123395
            ],
            [
                190,
                336288770
            ],
            [
                191,
                336575420
            ],
            [
                192,
                336817970
            ],
            [
                193,
                336927485
            ],
            [
                194,
                337051585
            ],
            [
                195,
                337178635
            ],
            [
                196,
                337330885
            ],
            [
                197,
                337431805
            ],
            [
                198,
                337588405
            ],
            [
                199,
                337832005
            ],
            [
                200,
                338018320
            ],
            [
                201,
                338243545
            ],
            [
                202,
                338466820
            ],
            [
                203,
                338700740
            ],
            [
                204,
                338929640
            ],
            [
                205,
                339272990
            ],
            [
                206,
                339521510
            ],
            [
                207,
                339608720
            ],
            [
                208,
                339679345
            ],
            [
                209,
                339742765
            ],
            [
                210,
                339803580
            ],
            [
                211,
                339944330
            ],
            [
                212,
                340214570
            ],
            [
                213,
                340414435
            ],
            [
                214,
                340467460
            ],
            [
                215,
                340528840
            ],
            [
                216,
                340578795
            ],
            [
                217,
                340634620
            ],
            [
                218,
                340746420
            ],
            [
                219,
                340967420
            ],
            [
                220,
                341146820
            ],
            [
                221,
                341235220
            ],
            [
                222,
                341261220
            ],
            [
                223,
                341295020
            ],
            [
                224,
                341330300
            ],
            [
                225,
                341447900
            ],
            [
                226,
                341690300
            ],
            [
                227,
                341831900
            ],
            [
                228,
                341855900
            ],
            [
                229,
                341882300
            ],
            [
                230,
                341903900
            ],
            [
                231,
                341927900
            ],
            [
                232,
                342064105
            ],
            [
                233,
                342297920
            ],
            [
                234,
                342429585
            ],
            [
                235,
                342461155
            ],
            [
                236,
                342495130
            ],
            [
                237,
                342526155
            ],
            [
                238,
                342559380
            ],
            [
                239,
                342688005
            ],
            [
                240,
                342910370
            ],
            [
                241,
                343071695
            ],
            [
                242,
                343097555
            ],
            [
                243,
                343119370
            ],
            [
                244,
                343141155
            ],
            [
                245,
                343167435
            ],
            [
                246,
                343262610
            ],
            [
                247,
                343433925
            ],
            [
                248,
                343554480
            ],
            [
                249,
                343585230
            ],
            [
                250,
                343611945
            ],
            [
                251,
                343636305
            ],
            [
                252,
                343663475
            ],
            [
                253,
                343721490
            ],
            [
                254,
                343840350
            ],
            [
                255,
                343942245
            ],
            [
                256,
                344003090
            ],
            [
                257,
                344021285
            ],
            [
                258,
                344036410
            ],
            [
                259,
                344054415
            ],
            [
                260,
                344100665
            ],
            [
                261,
                344204415
            ],
            [
                262,
                344286930
            ],
            [
                263,
                344304220
            ],
            [
                264,
                344325385
            ],
            [
                265,
                344344610
            ],
            [
                266,
                344362685
            ],
            [
                267,
                344408195
            ],
            [
                268,
                344490335
            ],
            [
                269,
                344553605
            ],
            [
                270,
                344569280
            ],
            [
                271,
                344583560
            ],
            [
                272,
                344600555
            ],
            [
                273,
                344619480
            ],
            [
                274,
                344664835
            ],
            [
                275,
                344745900
            ],
            [
                276,
                344806695
            ],
            [
                277,
                344825310
            ],
            [
                278,
                344847535
            ],
            [
                279,
                344868005
            ],
            [
                280,
                344889365
            ],
            [
                281,
                344928485
            ],
            [
                282,
                344995315
            ],
            [
                283,
                345042585
            ],
            [
                284,
                345055400
            ],
            [
                285,
                345083840
            ],
            [
                286,
                345102800
            ],
            [
                287,
                345129660
            ],
            [
                288,
                345179710
            ],
            [
                289,
                345254070
            ],
            [
                290,
                345316275
            ],
            [
                291,
                345330575
            ],
            [
                292,
                345353455
            ],
            [
                293,
                345373475
            ],
            [
                294,
                345395395
            ],
            [
                295,
                345457765
            ],
            [
                296,
                345534715
            ],
            [
                297,
                345595470
            ],
            [
                298,
                345621310
            ],
            [
                299,
                345641175
            ],
            [
                300,
                345663955
            ],
            [
                301,
                345688075
            ],
            [
                302,
                345732600
            ],
            [
                303,
                345802560
            ],
            [
                304,
                345851850
            ],
            [
                305,
                345861165
            ],
            [
                306,
                345872955
            ],
            [
                307,
                345883835
            ],
            [
                308,
                345893450
            ],
            [
                309,
                345924940
            ],
            [
                310,
                345983900
            ],
            [
                311,
                346028790
            ],
            [
                312,
                346038015
            ],
            [
                313,
                346051545
            ],
            [
                314,
                346061355
            ],
            [
                315,
                346072235
            ],
            [
                316,
                346109090
            ],
            [
                317,
                346169930
            ],
            [
                318,
                346210295
            ],
            [
                319,
                346220080
            ],
            [
                320,
                346229855
            ],
            [
                321,
                346240400
            ],
            [
                322,
                346250210
            ],
            [
                330,
                352611750
            ],
            [
                338,
                352868840
            ],
            [
                346,
                353079435
            ],
            [
                354,
                353160460
            ],
            [
                362,
                353249230
            ],
            [
                370,
                353323615
            ],
            [
                378,
                353391385
            ],
            [
                379,
                353523685
            ],
            [
                387,
                353731600
            ],
            [
                395,
                353929000
            ],
            [
                403,
                354092815
            ],
            [
                411,
                354139160
            ],
            [
                419,
                354173330
            ],
            [
                427,
                354205490
            ],
            [
                428,
                354331490
            ],
            [
                436,
                354527240
            ],
            [
                444,
                354666740
            ],
            [
                452,
                354690680
            ],
            [
                460,
                354718295
            ],
            [
                461,
                354742445
            ],
            [
                462,
                354773495
            ],
            [
                463,
                354858220
            ],
            [
                464,
                355017995
            ],
            [
                465,
                355123870
            ],
            [
                466,
                355143560
            ],
            [
                467,
                355165040
            ],
            [
                468,
                355186460
            ],
            [
                469,
                355209600
            ],
            [
                470,
                355314150
            ],
            [
                471,
                355518150
            ],
            [
                472,
                355658400
            ],
            [
                473,
                355691550
            ],
            [
                474,
                355723120
            ],
            [
                475,
                355749825
            ],
            [
                476,
                355780905
            ],
            [
                477,
                355884135
            ],
            [
                478,
                356055630
            ],
            [
                479,
                356190495
            ],
            [
                480,
                356209540
            ],
            [
                481,
                356230050
            ],
            [
                482,
                356246220
            ],
            [
                483,
                356263920
            ],
            [
                484,
                356348310
            ],
            [
                485,
                356457920
            ],
            [
                486,
                356547160
            ],
            [
                487,
                356567170
            ],
            [
                488,
                356574235
            ],
            [
                489,
                356581210
            ],
            [
                490,
                356588915
            ],
            [
                491,
                356637635
            ],
            [
                492,
                356697955
            ],
            [
                493,
                356748415
            ],
            [
                494,
                356751845
            ],
            [
                495,
                356755765
            ],
            [
                496,
                356759160
            ],
            [
                497,
                356763175
            ]
        ],
        name: 'jurassicpark',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Jurassic Park',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#241A18'
        },
        showlabel: true,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                62016476
            ],
            [
                2,
                91110948
            ],
            [
                3,
                127851614
            ],
            [
                4,
                168056697
            ],
            [
                5,
                200077255
            ],
            [
                6,
                214931195
            ],
            [
                7,
                228441219
            ],
            [
                8,
                239380350
            ],
            [
                9,
                251035008
            ],
            [
                10,
                269024709
            ],
            [
                11,
                279712800
            ],
            [
                12,
                293355885
            ],
            [
                13,
                299762339
            ],
            [
                14,
                305522774
            ],
            [
                15,
                310426573
            ],
            [
                16,
                315007925
            ],
            [
                17,
                322650766
            ],
            [
                18,
                332127039
            ],
            [
                19,
                339221800
            ],
            [
                20,
                342305825
            ],
            [
                21,
                345270996
            ],
            [
                22,
                347714387
            ],
            [
                23,
                350116636
            ],
            [
                24,
                354298620
            ],
            [
                25,
                359894705
            ],
            [
                26,
                363808123
            ],
            [
                27,
                365583739
            ],
            [
                28,
                367614540
            ],
            [
                29,
                369321117
            ],
            [
                30,
                371089745
            ],
            [
                31,
                373580232
            ],
            [
                32,
                376792804
            ],
            [
                33,
                379214172
            ],
            [
                34,
                380342669
            ],
            [
                35,
                381508108
            ],
            [
                36,
                382541324
            ],
            [
                37,
                383500991
            ],
            [
                38,
                384931276
            ],
            [
                39,
                386753883
            ],
            [
                40,
                388189320
            ],
            [
                41,
                388858383
            ],
            [
                42,
                389508496
            ],
            [
                43,
                390105115
            ],
            [
                44,
                390700514
            ],
            [
                45,
                391734894
            ],
            [
                46,
                392960053
            ],
            [
                47,
                393709339
            ],
            [
                48,
                394065706
            ],
            [
                49,
                394446105
            ],
            [
                50,
                394790193
            ],
            [
                51,
                395154082
            ],
            [
                52,
                395678591
            ],
            [
                53,
                396379240
            ],
            [
                54,
                396758605
            ],
            [
                55,
                396934917
            ],
            [
                56,
                397122551
            ],
            [
                57,
                397300205
            ],
            [
                58,
                397470858
            ],
            [
                59,
                397770940
            ],
            [
                60,
                398204786
            ],
            [
                61,
                398441218
            ],
            [
                62,
                398535767
            ],
            [
                63,
                398641824
            ],
            [
                64,
                398741872
            ],
            [
                65,
                398840509
            ],
            [
                66,
                399006536
            ],
            [
                67,
                399268628
            ],
            [
                68,
                399416040
            ],
            [
                69,
                399468859
            ],
            [
                70,
                399526521
            ],
            [
                71,
                399575659
            ],
            [
                72,
                399631191
            ],
            [
                73,
                399822464
            ],
            [
                74,
                400125775
            ],
            [
                75,
                400434854
            ],
            [
                76,
                400641549
            ],
            [
                77,
                400686031
            ],
            [
                78,
                400721101
            ],
            [
                79,
                400757235
            ],
            [
                80,
                400856895
            ],
            [
                81,
                401030403
            ],
            [
                82,
                401127275
            ],
            [
                83,
                401151847
            ],
            [
                84,
                401179139
            ],
            [
                85,
                401203839
            ],
            [
                86,
                401230822
            ],
            [
                87,
                401300666
            ],
            [
                88,
                401418331
            ],
            [
                89,
                401485117
            ],
            [
                90,
                401501881
            ],
            [
                91,
                401521240
            ],
            [
                92,
                401537347
            ],
            [
                93,
                401555453
            ],
            [
                94,
                401605687
            ],
            [
                95,
                401699386
            ],
            [
                96,
                401750700
            ],
            [
                97,
                401764455
            ],
            [
                98,
                401777722
            ],
            [
                99,
                401790274
            ],
            [
                100,
                401804683
            ],
            [
                101,
                401844869
            ],
            [
                102,
                401916397
            ],
            [
                103,
                401954762
            ],
            [
                104,
                401964397
            ],
            [
                105,
                401975882
            ],
            [
                106,
                401986424
            ],
            [
                107,
                401997617
            ],
            [
                108,
                402019792
            ],
            [
                109,
                402054350
            ],
            [
                110,
                402076689
            ],
            [
                111,
                402088378
            ],
            [
                112,
                402095833
            ],
            [
                113,
                402103640
            ],
            [
                114,
                402111870
            ]
        ],
        name: 'transformers2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Transformers: Revenge of the Fallen',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#21252C'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                66498
            ],
            [
                2,
                159196
            ],
            [
                3,
                243390
            ],
            [
                4,
                291115
            ],
            [
                5,
                342839
            ],
            [
                6,
                15504088
            ],
            [
                7,
                26541900
            ],
            [
                8,
                53382136
            ],
            [
                9,
                78725318
            ],
            [
                10,
                93933226
            ],
            [
                11,
                96437874
            ],
            [
                12,
                98938411
            ],
            [
                13,
                100770260
            ],
            [
                14,
                102637436
            ],
            [
                15,
                109361256
            ],
            [
                16,
                124424493
            ],
            [
                17,
                134253666
            ],
            [
                18,
                136304818
            ],
            [
                19,
                138768437
            ],
            [
                20,
                140488559
            ],
            [
                21,
                142204073
            ],
            [
                22,
                147301284
            ],
            [
                23,
                157446099
            ],
            [
                24,
                164772211
            ],
            [
                25,
                166370951
            ],
            [
                26,
                168403281
            ],
            [
                27,
                170193888
            ],
            [
                28,
                172392010
            ],
            [
                29,
                177496302
            ],
            [
                30,
                185201855
            ],
            [
                31,
                192034117
            ],
            [
                32,
                199276806
            ],
            [
                33,
                204058551
            ],
            [
                34,
                210412773
            ],
            [
                35,
                219521476
            ],
            [
                36,
                229689382
            ],
            [
                37,
                239695910
            ],
            [
                38,
                248117795
            ],
            [
                39,
                256016197
            ],
            [
                40,
                263092648
            ],
            [
                41,
                271811587
            ],
            [
                42,
                277116204
            ],
            [
                43,
                283868258
            ],
            [
                44,
                291905733
            ],
            [
                45,
                296691729
            ],
            [
                46,
                298420339
            ],
            [
                47,
                300321753
            ],
            [
                48,
                301501543
            ],
            [
                49,
                302590988
            ],
            [
                50,
                305707287
            ],
            [
                51,
                312843634
            ],
            [
                52,
                317319106
            ],
            [
                53,
                318080546
            ],
            [
                54,
                319056905
            ],
            [
                55,
                319808258
            ],
            [
                56,
                320631361
            ],
            [
                57,
                323146637
            ],
            [
                58,
                328428836
            ],
            [
                59,
                332403215
            ],
            [
                60,
                336699913
            ],
            [
                61,
                337450104
            ],
            [
                62,
                338125385
            ],
            [
                63,
                338780205
            ],
            [
                64,
                340822228
            ],
            [
                65,
                345045033
            ],
            [
                66,
                347899011
            ],
            [
                67,
                348556513
            ],
            [
                68,
                349458295
            ],
            [
                69,
                350053022
            ],
            [
                70,
                350702329
            ],
            [
                71,
                352947287
            ],
            [
                72,
                357516392
            ],
            [
                73,
                359635842
            ],
            [
                74,
                360122304
            ],
            [
                75,
                360652004
            ],
            [
                76,
                361228411
            ],
            [
                77,
                361764626
            ],
            [
                78,
                363153465
            ],
            [
                79,
                366480124
            ],
            [
                80,
                368637437
            ],
            [
                81,
                369080767
            ],
            [
                82,
                369484152
            ],
            [
                83,
                369792787
            ],
            [
                84,
                370191214
            ],
            [
                85,
                371898426
            ],
            [
                86,
                374318216
            ],
            [
                87,
                376417794
            ],
            [
                88,
                378248347
            ],
            [
                89,
                378795613
            ],
            [
                90,
                379250586
            ],
            [
                91,
                379704335
            ],
            [
                92,
                380727773
            ],
            [
                93,
                382758785
            ],
            [
                94,
                384108132
            ],
            [
                95,
                384335209
            ],
            [
                96,
                384605905
            ],
            [
                97,
                384852424
            ],
            [
                98,
                385125143
            ],
            [
                99,
                385843169
            ],
            [
                100,
                387632118
            ],
            [
                101,
                388756783
            ],
            [
                102,
                389095081
            ],
            [
                103,
                389482313
            ],
            [
                104,
                389748225
            ],
            [
                105,
                390040114
            ],
            [
                106,
                390673235
            ],
            [
                107,
                392063223
            ],
            [
                108,
                392994668
            ],
            [
                109,
                393272301
            ],
            [
                110,
                393614508
            ],
            [
                111,
                393925776
            ],
            [
                112,
                394238850
            ],
            [
                113,
                394761394
            ],
            [
                114,
                395698639
            ],
            [
                115,
                396386593
            ],
            [
                116,
                396581728
            ],
            [
                117,
                396755786
            ],
            [
                118,
                396895073
            ],
            [
                119,
                397009261
            ],
            [
                120,
                397175551
            ],
            [
                121,
                397508050
            ],
            [
                122,
                397744862
            ],
            [
                123,
                397815938
            ],
            [
                124,
                397904633
            ],
            [
                125,
                397979972
            ],
            [
                126,
                398053875
            ],
            [
                127,
                398132914
            ],
            [
                128,
                398289355
            ],
            [
                129,
                398391611
            ],
            [
                130,
                398426656
            ],
            [
                131,
                398465119
            ],
            [
                132,
                398500962
            ],
            [
                133,
                398539013
            ],
            [
                134,
                398651486
            ],
            [
                135,
                398846049
            ],
            [
                136,
                398938890
            ],
            [
                137,
                398965500
            ],
            [
                138,
                399001514
            ],
            [
                139,
                399030622
            ],
            [
                140,
                399060242
            ],
            [
                141,
                399157272
            ],
            [
                142,
                399343658
            ],
            [
                143,
                399445248
            ],
            [
                144,
                399481693
            ],
            [
                145,
                399529935
            ],
            [
                146,
                399571604
            ],
            [
                147,
                399619073
            ],
            [
                148,
                399715393
            ],
            [
                149,
                399824159
            ],
            [
                150,
                399877967
            ],
            [
                151,
                399907380
            ],
            [
                152,
                399935327
            ],
            [
                153,
                399960215
            ],
            [
                154,
                399985439
            ],
            [
                155,
                400028181
            ],
            [
                156,
                400113811
            ],
            [
                157,
                400175401
            ],
            [
                158,
                400187565
            ],
            [
                159,
                400201943
            ],
            [
                160,
                400214993
            ],
            [
                161,
                400227936
            ]
        ],
        name: 'frozen2013',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Frozen',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#A6CAE2'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                91071119
            ],
            [
                2,
                133485465
            ],
            [
                3,
                169189427
            ],
            [
                4,
                187232508
            ],
            [
                5,
                202620674
            ],
            [
                6,
                214887891
            ],
            [
                7,
                226117069
            ],
            [
                8,
                240671184
            ],
            [
                9,
                258934716
            ],
            [
                10,
                273539281
            ],
            [
                11,
                280016609
            ],
            [
                12,
                286495885
            ],
            [
                13,
                291662354
            ],
            [
                14,
                296534509
            ],
            [
                15,
                303092462
            ],
            [
                16,
                311549473
            ],
            [
                17,
                318511602
            ],
            [
                18,
                321839842
            ],
            [
                19,
                325139206
            ],
            [
                20,
                328025686
            ],
            [
                21,
                330641014
            ],
            [
                22,
                334015125
            ],
            [
                23,
                338850124
            ],
            [
                24,
                343086045
            ],
            [
                25,
                344890382
            ],
            [
                26,
                346901620
            ],
            [
                27,
                348563937
            ],
            [
                28,
                350085941
            ],
            [
                29,
                351946172
            ],
            [
                30,
                354708050
            ],
            [
                31,
                357337355
            ],
            [
                32,
                358495410
            ],
            [
                33,
                359637778
            ],
            [
                34,
                360565265
            ],
            [
                35,
                361496489
            ],
            [
                36,
                362682829
            ],
            [
                37,
                364460313
            ],
            [
                38,
                366007900
            ],
            [
                39,
                366602118
            ],
            [
                40,
                367203359
            ],
            [
                41,
                367711640
            ],
            [
                42,
                368240692
            ],
            [
                43,
                368929574
            ],
            [
                44,
                369959013
            ],
            [
                45,
                370805062
            ],
            [
                46,
                371163237
            ],
            [
                47,
                371535432
            ],
            [
                48,
                371844889
            ],
            [
                49,
                372150983
            ],
            [
                50,
                372710770
            ],
            [
                51,
                373615016
            ],
            [
                52,
                374623584
            ],
            [
                53,
                375552093
            ],
            [
                54,
                375755398
            ],
            [
                55,
                375934867
            ],
            [
                56,
                376103101
            ],
            [
                57,
                376367393
            ],
            [
                58,
                376817200
            ],
            [
                59,
                377104684
            ],
            [
                60,
                377190929
            ],
            [
                61,
                377290111
            ],
            [
                62,
                377382350
            ],
            [
                63,
                377480123
            ],
            [
                64,
                377660516
            ],
            [
                65,
                377974744
            ],
            [
                66,
                378180621
            ],
            [
                67,
                378240326
            ],
            [
                68,
                378305007
            ],
            [
                69,
                378366054
            ],
            [
                70,
                378436868
            ],
            [
                71,
                378533676
            ],
            [
                72,
                378709043
            ],
            [
                73,
                378824316
            ],
            [
                74,
                378858898
            ],
            [
                75,
                378894909
            ],
            [
                76,
                378930760
            ],
            [
                77,
                378972347
            ],
            [
                78,
                379041779
            ],
            [
                79,
                379167184
            ],
            [
                80,
                379245610
            ],
            [
                81,
                379268754
            ],
            [
                82,
                379293585
            ],
            [
                83,
                379317920
            ],
            [
                84,
                379344886
            ],
            [
                85,
                379457055
            ],
            [
                86,
                379626528
            ],
            [
                87,
                379750747
            ],
            [
                88,
                379816310
            ],
            [
                89,
                379862860
            ],
            [
                90,
                379903359
            ],
            [
                91,
                379950852
            ],
            [
                92,
                380032613
            ],
            [
                93,
                380155410
            ],
            [
                94,
                380235400
            ],
            [
                95,
                380260197
            ],
            [
                96,
                380288858
            ],
            [
                97,
                380316659
            ],
            [
                98,
                380350637
            ],
            [
                99,
                380405841
            ],
            [
                100,
                380484066
            ],
            [
                101,
                380531427
            ],
            [
                102,
                380546404
            ],
            [
                103,
                380562478
            ],
            [
                104,
                380578231
            ],
            [
                105,
                380596554
            ],
            [
                106,
                380626896
            ],
            [
                107,
                380676149
            ],
            [
                108,
                380707704
            ],
            [
                109,
                380717822
            ],
            [
                110,
                380728650
            ],
            [
                111,
                380739670
            ],
            [
                112,
                380753265
            ],
            [
                113,
                380775329
            ],
            [
                114,
                380839203
            ],
            [
                115,
                380873020
            ],
            [
                116,
                380879042
            ],
            [
                117,
                380885728
            ],
            [
                118,
                380892146
            ],
            [
                119,
                380901821
            ],
            [
                120,
                380919404
            ],
            [
                121,
                380939741
            ],
            [
                122,
                380955619
            ],
            [
                123,
                380960907
            ],
            [
                124,
                380966300
            ],
            [
                125,
                380971855
            ],
            [
                126,
                380974762
            ],
            [
                127,
                380982415
            ],
            [
                128,
                380992752
            ],
            [
                129,
                381000185
            ],
            [
                130,
                381003478
            ],
            [
                131,
                381007522
            ],
            [
                132,
                381009525
            ],
            [
                133,
                381011219
            ]
        ],
        name: 'harrypotter72',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Deathly Hallows Part 2',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#4D5552'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                20208056
            ],
            [
                2,
                48219603
            ],
            [
                3,
                70251710
            ],
            [
                4,
                77197270
            ],
            [
                5,
                84379257
            ],
            [
                6,
                91103959
            ],
            [
                7,
                97454140
            ],
            [
                8,
                109758282
            ],
            [
                9,
                129262533
            ],
            [
                10,
                144043789
            ],
            [
                11,
                148546480
            ],
            [
                12,
                153211818
            ],
            [
                13,
                158049373
            ],
            [
                14,
                163102728
            ],
            [
                15,
                171643083
            ],
            [
                16,
                182961377
            ],
            [
                17,
                191487211
            ],
            [
                18,
                195066147
            ],
            [
                19,
                199033691
            ],
            [
                20,
                203263253
            ],
            [
                21,
                207410464
            ],
            [
                22,
                213703783
            ],
            [
                23,
                221950891
            ],
            [
                24,
                228549216
            ],
            [
                25,
                231282056
            ],
            [
                26,
                234108411
            ],
            [
                27,
                236938822
            ],
            [
                28,
                240023561
            ],
            [
                29,
                244227800
            ],
            [
                30,
                249705947
            ],
            [
                31,
                253991677
            ],
            [
                32,
                256514037
            ],
            [
                33,
                258988352
            ],
            [
                34,
                261201998
            ],
            [
                35,
                263877833
            ],
            [
                36,
                266782245
            ],
            [
                37,
                271401136
            ],
            [
                38,
                274936974
            ],
            [
                39,
                276792872
            ],
            [
                40,
                278832411
            ],
            [
                41,
                280730487
            ],
            [
                42,
                282603345
            ],
            [
                43,
                285402467
            ],
            [
                44,
                288674600
            ],
            [
                45,
                291068455
            ],
            [
                46,
                292374253
            ],
            [
                47,
                293778463
            ],
            [
                48,
                295232316
            ],
            [
                49,
                296519997
            ],
            [
                50,
                299218800
            ],
            [
                51,
                301815991
            ],
            [
                52,
                303795720
            ],
            [
                53,
                304986395
            ],
            [
                54,
                306282514
            ],
            [
                55,
                307566224
            ],
            [
                56,
                308728248
            ],
            [
                57,
                310000777
            ],
            [
                58,
                311741088
            ],
            [
                59,
                313119898
            ],
            [
                60,
                313820324
            ],
            [
                61,
                314583575
            ],
            [
                62,
                315343659
            ],
            [
                63,
                316160298
            ],
            [
                64,
                317278150
            ],
            [
                65,
                318798686
            ],
            [
                66,
                320020760
            ],
            [
                67,
                320703507
            ],
            [
                68,
                321384619
            ],
            [
                69,
                321911122
            ],
            [
                70,
                322403838
            ],
            [
                71,
                323102522
            ],
            [
                72,
                324117817
            ],
            [
                73,
                324916113
            ],
            [
                74,
                325313584
            ],
            [
                75,
                325741532
            ],
            [
                76,
                326117174
            ],
            [
                77,
                326434293
            ],
            [
                78,
                326755012
            ],
            [
                79,
                327334183
            ],
            [
                80,
                327793194
            ],
            [
                81,
                328020456
            ],
            [
                82,
                328272500
            ],
            [
                83,
                328517513
            ],
            [
                84,
                328751122
            ],
            [
                85,
                329027535
            ],
            [
                86,
                329458067
            ],
            [
                87,
                329790041
            ],
            [
                88,
                329939269
            ],
            [
                89,
                330107234
            ],
            [
                90,
                330247731
            ],
            [
                91,
                330385344
            ],
            [
                92,
                330696638
            ],
            [
                93,
                331295039
            ],
            [
                94,
                331921877
            ],
            [
                95,
                332722962
            ],
            [
                96,
                332854283
            ],
            [
                97,
                332955066
            ],
            [
                98,
                333039240
            ],
            [
                99,
                333190517
            ],
            [
                100,
                333561399
            ],
            [
                101,
                333843390
            ],
            [
                102,
                333895613
            ],
            [
                103,
                333952209
            ],
            [
                104,
                334007377
            ],
            [
                105,
                334065792
            ],
            [
                106,
                334163792
            ],
            [
                107,
                334461000
            ],
            [
                108,
                334702727
            ],
            [
                109,
                334735727
            ],
            [
                110,
                334771727
            ],
            [
                111,
                334804727
            ],
            [
                112,
                334838586
            ],
            [
                113,
                334915586
            ],
            [
                114,
                335102586
            ],
            [
                115,
                335258448
            ],
            [
                116,
                335299448
            ]
        ],
        name: 'findingnemo',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Finding Nemo',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#3D6382'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                50013859
            ],
            [
                2,
                83543472
            ],
            [
                3,
                124237232
            ],
            [
                4,
                158449700
            ],
            [
                5,
                172802507
            ],
            [
                6,
                182710218
            ],
            [
                7,
                191363169
            ],
            [
                8,
                200442739
            ],
            [
                9,
                216022081
            ],
            [
                10,
                236940421
            ],
            [
                11,
                255648711
            ],
            [
                12,
                270489794
            ],
            [
                13,
                274896433
            ],
            [
                14,
                278901370
            ],
            [
                15,
                282804625
            ],
            [
                16,
                289880802
            ],
            [
                17,
                300336979
            ],
            [
                18,
                307892961
            ],
            [
                19,
                310314752
            ],
            [
                20,
                312659891
            ],
            [
                21,
                314971587
            ],
            [
                22,
                317257697
            ],
            [
                23,
                321263036
            ],
            [
                24,
                327531977
            ],
            [
                25,
                332109171
            ],
            [
                26,
                333797980
            ],
            [
                27,
                335384779
            ],
            [
                28,
                336736523
            ],
            [
                29,
                338102187
            ],
            [
                30,
                340685003
            ],
            [
                31,
                344628653
            ],
            [
                32,
                348140685
            ],
            [
                33,
                349270153
            ],
            [
                34,
                350346885
            ],
            [
                35,
                351390871
            ],
            [
                36,
                352356148
            ],
            [
                37,
                354058518
            ],
            [
                38,
                356548035
            ],
            [
                39,
                358469219
            ],
            [
                40,
                359298932
            ],
            [
                41,
                360143707
            ],
            [
                42,
                360797421
            ],
            [
                43,
                361471114
            ],
            [
                44,
                362667481
            ],
            [
                45,
                364172243
            ],
            [
                46,
                365553264
            ],
            [
                47,
                366502577
            ],
            [
                48,
                367113992
            ],
            [
                49,
                367688930
            ],
            [
                50,
                368219089
            ],
            [
                51,
                368984475
            ],
            [
                52,
                370076860
            ],
            [
                53,
                370819889
            ],
            [
                54,
                371154119
            ],
            [
                55,
                371504532
            ],
            [
                56,
                371863119
            ],
            [
                57,
                372222826
            ],
            [
                58,
                372677022
            ],
            [
                59,
                373390631
            ],
            [
                60,
                373926219
            ],
            [
                61,
                374151313
            ],
            [
                62,
                374377483
            ],
            [
                63,
                374599161
            ],
            [
                64,
                374829666
            ],
            [
                65,
                375119603
            ],
            [
                66,
                375550971
            ],
            [
                67,
                375876648
            ],
            [
                68,
                376032137
            ],
            [
                69,
                376197747
            ],
            [
                70,
                376352006
            ],
            [
                71,
                376507594
            ],
            [
                72,
                376661259
            ],
            [
                73,
                376899507
            ],
            [
                74,
                377080716
            ],
            [
                75,
                377176573
            ],
            [
                76,
                377262649
            ],
            [
                77,
                377347814
            ],
            [
                78,
                377441286
            ],
            [
                79,
                377560981
            ],
            [
                80,
                377735878
            ],
            [
                81,
                377864535
            ],
            [
                82,
                377926556
            ],
            [
                83,
                377993465
            ],
            [
                84,
                378063671
            ],
            [
                85,
                378130477
            ],
            [
                86,
                378220373
            ],
            [
                87,
                378357723
            ],
            [
                88,
                378461703
            ],
            [
                89,
                378508466
            ],
            [
                90,
                378556517
            ],
            [
                91,
                378602706
            ],
            [
                92,
                378650106
            ],
            [
                93,
                378740701
            ],
            [
                94,
                378881377
            ],
            [
                95,
                378977117
            ],
            [
                96,
                379017346
            ],
            [
                97,
                379065283
            ],
            [
                98,
                379106087
            ],
            [
                99,
                379144487
            ],
            [
                100,
                379210709
            ],
            [
                101,
                379319012
            ],
            [
                102,
                379392611
            ],
            [
                103,
                379419488
            ],
            [
                104,
                379448769
            ],
            [
                105,
                379474503
            ],
            [
                106,
                379498649
            ],
            [
                107,
                379555718
            ],
            [
                108,
                379649437
            ],
            [
                109,
                379743566
            ],
            [
                110,
                379807894
            ],
            [
                111,
                379823309
            ],
            [
                112,
                379838145
            ],
            [
                113,
                379853511
            ],
            [
                114,
                379885313
            ],
            [
                115,
                379940828
            ],
            [
                116,
                379972309
            ],
            [
                117,
                379980949
            ],
            [
                118,
                379992015
            ],
            [
                119,
                380003128
            ],
            [
                120,
                380013303
            ],
            [
                121,
                380036596
            ],
            [
                122,
                380079588
            ],
            [
                123,
                380101660
            ],
            [
                124,
                380108153
            ],
            [
                125,
                380115652
            ],
            [
                126,
                380123204
            ],
            [
                127,
                380130992
            ],
            [
                128,
                380143538
            ],
            [
                129,
                380164523
            ],
            [
                130,
                380176196
            ],
            [
                131,
                380179223
            ],
            [
                132,
                380182435
            ],
            [
                133,
                380185014
            ],
            [
                134,
                380188242
            ],
            [
                135,
                380194417
            ],
            [
                136,
                380204694
            ],
            [
                137,
                380209351
            ],
            [
                138,
                380211065
            ],
            [
                139,
                380213453
            ],
            [
                140,
                380215435
            ],
            [
                141,
                380217829
            ],
            [
                142,
                380223080
            ],
            [
                143,
                380231897
            ],
            [
                144,
                380237988
            ],
            [
                145,
                380243785
            ],
            [
                146,
                380245797
            ],
            [
                147,
                380247539
            ],
            [
                148,
                380249594
            ],
            [
                149,
                380253435
            ],
            [
                150,
                380259129
            ],
            [
                151,
                380262555
            ],
            [
                152,
                380264481
            ],
            [
                153,
                380266617
            ],
            [
                154,
                380268303
            ],
            [
                155,
                380270577
            ]
        ],
        name: 'starwars3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Star Wars: Episode III - Revenge of the Sith',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#402F2B'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                34450834
            ],
            [
                2,
                51470821
            ],
            [
                3,
                73282370
            ],
            [
                4,
                100774423
            ],
            [
                5,
                124100534
            ],
            [
                6,
                137663742
            ],
            [
                7,
                150139984
            ],
            [
                8,
                157684384
            ],
            [
                9,
                171670604
            ],
            [
                10,
                190822800
            ],
            [
                11,
                208072067
            ],
            [
                12,
                222268708
            ],
            [
                13,
                232321296
            ],
            [
                14,
                241936536
            ],
            [
                15,
                249445927
            ],
            [
                16,
                262230583
            ],
            [
                17,
                272832713
            ],
            [
                18,
                283395934
            ],
            [
                19,
                290410961
            ],
            [
                20,
                292639432
            ],
            [
                21,
                294654872
            ],
            [
                22,
                296459931
            ],
            [
                23,
                298111838
            ],
            [
                24,
                301788798
            ],
            [
                25,
                308228208
            ],
            [
                26,
                312320936
            ],
            [
                27,
                313419033
            ],
            [
                28,
                314567189
            ],
            [
                29,
                315556593
            ],
            [
                30,
                316592632
            ],
            [
                31,
                318968891
            ],
            [
                32,
                323583085
            ],
            [
                33,
                326812102
            ],
            [
                34,
                329040393
            ],
            [
                35,
                329779717
            ],
            [
                36,
                330390338
            ],
            [
                37,
                331032242
            ],
            [
                38,
                332541888
            ],
            [
                39,
                335700055
            ],
            [
                40,
                337817998
            ],
            [
                41,
                338345008
            ],
            [
                42,
                338891856
            ],
            [
                43,
                339468746
            ],
            [
                44,
                340021012
            ],
            [
                45,
                341392421
            ],
            [
                46,
                344131995
            ],
            [
                47,
                345331815
            ],
            [
                48,
                345719530
            ],
            [
                49,
                346118913
            ],
            [
                50,
                346487251
            ],
            [
                51,
                346839672
            ],
            [
                52,
                347747482
            ],
            [
                53,
                349762348
            ],
            [
                54,
                351133343
            ],
            [
                55,
                351428929
            ],
            [
                56,
                351711227
            ],
            [
                57,
                351974399
            ],
            [
                58,
                352277575
            ],
            [
                59,
                353077188
            ],
            [
                60,
                355035095
            ],
            [
                61,
                356464770
            ],
            [
                62,
                357367856
            ],
            [
                63,
                357677413
            ],
            [
                64,
                357975216
            ],
            [
                65,
                358268479
            ],
            [
                66,
                358922181
            ],
            [
                67,
                360222047
            ],
            [
                68,
                361118934
            ],
            [
                69,
                361329662
            ],
            [
                70,
                361554774
            ],
            [
                71,
                361742495
            ],
            [
                72,
                361940947
            ],
            [
                73,
                362436661
            ],
            [
                74,
                363458415
            ],
            [
                75,
                364115612
            ],
            [
                76,
                364394027
            ],
            [
                77,
                364675286
            ],
            [
                78,
                364920123
            ],
            [
                79,
                365172348
            ],
            [
                80,
                365892919
            ],
            [
                81,
                367326659
            ],
            [
                82,
                368210170
            ],
            [
                83,
                368432916
            ],
            [
                84,
                368672025
            ],
            [
                85,
                368890651
            ],
            [
                86,
                369126293
            ],
            [
                87,
                369612988
            ],
            [
                88,
                370521028
            ],
            [
                89,
                371147794
            ],
            [
                90,
                371355728
            ],
            [
                91,
                371585257
            ],
            [
                92,
                371784723
            ],
            [
                93,
                372008809
            ],
            [
                94,
                372370614
            ],
            [
                95,
                372968676
            ],
            [
                96,
                373359557
            ],
            [
                97,
                373480504
            ],
            [
                98,
                373603224
            ],
            [
                99,
                373720131
            ],
            [
                100,
                373850755
            ],
            [
                101,
                374028579
            ],
            [
                102,
                374359649
            ],
            [
                103,
                374556572
            ],
            [
                104,
                374618206
            ],
            [
                105,
                374685152
            ],
            [
                106,
                374757103
            ],
            [
                107,
                374830647
            ],
            [
                108,
                374930356
            ],
            [
                109,
                375095462
            ],
            [
                110,
                375204550
            ],
            [
                111,
                375242873
            ],
            [
                112,
                375288167
            ],
            [
                113,
                375328318
            ],
            [
                114,
                375378000
            ],
            [
                115,
                375474875
            ],
            [
                116,
                375594905
            ],
            [
                117,
                375667233
            ],
            [
                118,
                375716277
            ],
            [
                119,
                375757584
            ],
            [
                120,
                375794870
            ],
            [
                121,
                375831230
            ],
            [
                122,
                375894225
            ],
            [
                123,
                375997379
            ],
            [
                124,
                376058551
            ],
            [
                125,
                376076663
            ],
            [
                126,
                376098769
            ],
            [
                127,
                376119995
            ],
            [
                128,
                376142702
            ],
            [
                129,
                376193716
            ],
            [
                130,
                376278206
            ],
            [
                131,
                376337432
            ],
            [
                132,
                376353893
            ],
            [
                133,
                376370038
            ],
            [
                134,
                376385713
            ],
            [
                135,
                376401952
            ],
            [
                136,
                376441668
            ],
            [
                137,
                376511533
            ],
            [
                138,
                376556583
            ],
            [
                139,
                376570162
            ],
            [
                140,
                376584254
            ],
            [
                141,
                376598825
            ],
            [
                142,
                376612619
            ],
            [
                143,
                376640262
            ],
            [
                144,
                376685312
            ],
            [
                145,
                376716328
            ],
            [
                146,
                376726334
            ],
            [
                147,
                376737238
            ],
            [
                148,
                376748397
            ],
            [
                149,
                376760431
            ],
            [
                150,
                376783973
            ],
            [
                151,
                376825906
            ],
            [
                152,
                376853002
            ],
            [
                153,
                376861127
            ],
            [
                154,
                376869751
            ],
            [
                155,
                376877518
            ],
            [
                156,
                376886789
            ],
            [
                157,
                376906145
            ],
            [
                158,
                376937607
            ],
            [
                159,
                376958965
            ],
            [
                160,
                376968416
            ],
            [
                161,
                376974463
            ],
            [
                162,
                376980723
            ],
            [
                163,
                376987769
            ],
            [
                164,
                376994759
            ],
            [
                165,
                377004524
            ],
            [
                166,
                377013073
            ],
            [
                167,
                377019252
            ],
            [
                168,
                377021578
            ],
            [
                169,
                377024076
            ],
            [
                170,
                377027325
            ]
        ],
        name: 'returnoftheking',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Lord of the Rings: The Return of the King',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#6F5838'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                40442604
            ],
            [
                2,
                64255524
            ],
            [
                3,
                96707866
            ],
            [
                4,
                130456123
            ],
            [
                5,
                152411751
            ],
            [
                6,
                180072888
            ],
            [
                7,
                192085360
            ],
            [
                8,
                202120073
            ],
            [
                9,
                211257583
            ],
            [
                10,
                225116345
            ],
            [
                11,
                243032969
            ],
            [
                12,
                256438326
            ],
            [
                13,
                262205594
            ],
            [
                14,
                267638277
            ],
            [
                15,
                272674954
            ],
            [
                16,
                277512432
            ],
            [
                17,
                284637833
            ],
            [
                18,
                294579826
            ],
            [
                19,
                302287882
            ],
            [
                20,
                305304586
            ],
            [
                21,
                308212667
            ],
            [
                22,
                310766413
            ],
            [
                23,
                313452891
            ],
            [
                24,
                317922598
            ],
            [
                25,
                324088209
            ],
            [
                26,
                328468763
            ],
            [
                27,
                330335827
            ],
            [
                28,
                332378153
            ],
            [
                29,
                334212884
            ],
            [
                30,
                335826901
            ],
            [
                31,
                338264735
            ],
            [
                32,
                341772127
            ],
            [
                33,
                344440594
            ],
            [
                34,
                345683315
            ],
            [
                35,
                346871797
            ],
            [
                36,
                347976111
            ],
            [
                37,
                349070083
            ],
            [
                38,
                350681868
            ],
            [
                39,
                352914946
            ],
            [
                40,
                354501860
            ],
            [
                41,
                355215323
            ],
            [
                42,
                356006990
            ],
            [
                43,
                356749553
            ],
            [
                44,
                357461241
            ],
            [
                45,
                358505874
            ],
            [
                46,
                359914731
            ],
            [
                47,
                360973268
            ],
            [
                48,
                361446680
            ],
            [
                49,
                361891163
            ],
            [
                50,
                362315693
            ],
            [
                51,
                362752028
            ],
            [
                52,
                363411937
            ],
            [
                53,
                364504392
            ],
            [
                54,
                365173462
            ],
            [
                55,
                365450576
            ],
            [
                56,
                365732747
            ],
            [
                57,
                365995921
            ],
            [
                58,
                366241738
            ],
            [
                59,
                366671641
            ],
            [
                60,
                367377481
            ],
            [
                61,
                367816575
            ],
            [
                62,
                367971657
            ],
            [
                63,
                368120841
            ],
            [
                64,
                368245822
            ],
            [
                65,
                368368396
            ],
            [
                66,
                368628032
            ],
            [
                67,
                369064028
            ],
            [
                68,
                369534309
            ],
            [
                69,
                369888512
            ],
            [
                70,
                369957255
            ],
            [
                71,
                370019970
            ],
            [
                72,
                370078207
            ],
            [
                73,
                370219151
            ],
            [
                74,
                370497521
            ],
            [
                75,
                370651825
            ],
            [
                76,
                370691542
            ],
            [
                77,
                370731374
            ],
            [
                78,
                370776671
            ],
            [
                79,
                370825461
            ],
            [
                80,
                370913770
            ],
            [
                81,
                371077956
            ],
            [
                82,
                371168083
            ],
            [
                87,
                371329254
            ],
            [
                88,
                371469307
            ],
            [
                89,
                371538616
            ],
            [
                94,
                371664471
            ],
            [
                95,
                371753356
            ],
            [
                96,
                371795119
            ],
            [
                101,
                371929676
            ],
            [
                102,
                372082887
            ],
            [
                103,
                372191244
            ],
            [
                108,
                372394758
            ],
            [
                109,
                372513192
            ],
            [
                110,
                372585847
            ],
            [
                115,
                372721003
            ],
            [
                116,
                372813355
            ],
            [
                117,
                372871182
            ],
            [
                122,
                372974767
            ],
            [
                123,
                373036672
            ],
            [
                124,
                373068126
            ],
            [
                129,
                373153457
            ],
            [
                130,
                373213580
            ],
            [
                131,
                373247668
            ],
            [
                136,
                373310948
            ],
            [
                137,
                373353536
            ],
            [
                138,
                373377893
            ]
        ],
        name: 'spiderman2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Spider-Man 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#723925'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                26556573
            ],
            [
                2,
                41337889
            ],
            [
                3,
                64247837
            ],
            [
                4,
                97325776
            ],
            [
                5,
                125185971
            ],
            [
                6,
                135317847
            ],
            [
                7,
                144600923
            ],
            [
                8,
                153003285
            ],
            [
                9,
                160641939
            ],
            [
                10,
                174307053
            ],
            [
                11,
                196236096
            ],
            [
                12,
                213888740
            ],
            [
                13,
                218892679
            ],
            [
                14,
                223720260
            ],
            [
                15,
                228133890
            ],
            [
                16,
                232379231
            ],
            [
                17,
                240339179
            ],
            [
                18,
                253792087
            ],
            [
                19,
                264510209
            ],
            [
                20,
                267680889
            ],
            [
                21,
                270706537
            ],
            [
                22,
                273311111
            ],
            [
                23,
                276092867
            ],
            [
                24,
                281034042
            ],
            [
                25,
                289004202
            ],
            [
                26,
                295507244
            ],
            [
                27,
                297280146
            ],
            [
                28,
                299121441
            ],
            [
                29,
                300753003
            ],
            [
                30,
                302558804
            ],
            [
                31,
                305673628
            ],
            [
                32,
                310860490
            ],
            [
                33,
                315152778
            ],
            [
                34,
                316345913
            ],
            [
                35,
                317697565
            ],
            [
                36,
                318972677
            ],
            [
                37,
                320251865
            ],
            [
                38,
                322756546
            ],
            [
                39,
                326852950
            ],
            [
                40,
                330856971
            ],
            [
                41,
                332148696
            ],
            [
                42,
                333751215
            ],
            [
                43,
                335525803
            ],
            [
                44,
                337789628
            ],
            [
                45,
                344366712
            ],
            [
                46,
                349340005
            ],
            [
                47,
                353006351
            ],
            [
                48,
                354304281
            ],
            [
                49,
                355236096
            ],
            [
                50,
                356020828
            ],
            [
                51,
                356710507
            ],
            [
                52,
                357837980
            ],
            [
                53,
                359530498
            ],
            [
                54,
                360761619
            ],
            [
                55,
                361117712
            ],
            [
                56,
                361483659
            ],
            [
                57,
                361845525
            ],
            [
                58,
                362198530
            ],
            [
                59,
                362768293
            ],
            [
                60,
                363683801
            ],
            [
                61,
                364414581
            ],
            [
                62,
                364641738
            ],
            [
                63,
                364870422
            ],
            [
                64,
                365075712
            ],
            [
                65,
                365277616
            ],
            [
                66,
                365620755
            ],
            [
                67,
                366225926
            ],
            [
                68,
                366685267
            ],
            [
                69,
                366834477
            ],
            [
                70,
                366980305
            ],
            [
                71,
                367114842
            ],
            [
                72,
                367241879
            ],
            [
                73,
                367424333
            ],
            [
                74,
                367736645
            ],
            [
                75,
                368027248
            ],
            [
                76,
                368115866
            ],
            [
                77,
                368205546
            ],
            [
                78,
                368299201
            ],
            [
                79,
                368394004
            ],
            [
                80,
                368517299
            ],
            [
                81,
                368722835
            ],
            [
                82,
                368894610
            ],
            [
                83,
                368954856
            ],
            [
                84,
                369025797
            ],
            [
                85,
                369044910
            ],
            [
                86,
                369065495
            ],
            [
                87,
                369126401
            ],
            [
                88,
                369236540
            ],
            [
                89,
                369336919
            ],
            [
                90,
                369379047
            ],
            [
                91,
                369416657
            ],
            [
                92,
                369456172
            ],
            [
                93,
                369501023
            ],
            [
                94,
                369537952
            ],
            [
                95,
                369595027
            ],
            [
                96,
                369664388
            ],
            [
                97,
                369727030
            ],
            [
                98,
                369748288
            ],
            [
                99,
                369770846
            ],
            [
                100,
                369797378
            ],
            [
                101,
                369822220
            ],
            [
                102,
                369860090
            ],
            [
                103,
                369895388
            ]
        ],
        name: 'passionofthechrist',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Passion of the Christ',
            genre: 'Historical Drama',

            mpaaRating: 'R',
            imgMainColor: '#4E2810'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                35010665
            ],
            [
                2,
                59557645
            ],
            [
                3,
                90034770
            ],
            [
                4,
                119412720
            ],
            [
                5,
                143074960
            ],
            [
                6,
                153587070
            ],
            [
                7,
                165658010
            ],
            [
                8,
                175330750
            ],
            [
                9,
                184483880
            ],
            [
                10,
                197933960
            ],
            [
                11,
                215367025
            ],
            [
                12,
                228376775
            ],
            [
                13,
                234021005
            ],
            [
                14,
                240866135
            ],
            [
                15,
                246099530
            ],
            [
                16,
                251100035
            ],
            [
                17,
                258568120
            ],
            [
                18,
                268595595
            ],
            [
                19,
                276006395
            ],
            [
                20,
                279463495
            ],
            [
                21,
                283818295
            ],
            [
                22,
                287179700
            ],
            [
                23,
                290388585
            ],
            [
                24,
                295255020
            ],
            [
                25,
                301650860
            ],
            [
                26,
                306812720
            ],
            [
                27,
                309089500
            ],
            [
                28,
                311818160
            ],
            [
                29,
                313957310
            ],
            [
                30,
                316277465
            ],
            [
                31,
                319372220
            ],
            [
                32,
                323525285
            ],
            [
                33,
                326411585
            ],
            [
                34,
                327966980
            ],
            [
                35,
                329730420
            ],
            [
                36,
                331183945
            ],
            [
                37,
                332566195
            ],
            [
                38,
                334470220
            ],
            [
                39,
                336757445
            ],
            [
                40,
                338481845
            ],
            [
                41,
                339391970
            ],
            [
                42,
                340613420
            ],
            [
                43,
                341475645
            ],
            [
                44,
                342206120
            ],
            [
                45,
                343278740
            ],
            [
                46,
                344860400
            ],
            [
                47,
                346114855
            ],
            [
                48,
                346642075
            ],
            [
                49,
                347223835
            ],
            [
                50,
                347639040
            ],
            [
                51,
                348100420
            ],
            [
                52,
                348815440
            ],
            [
                53,
                349916015
            ],
            [
                54,
                350701135
            ],
            [
                55,
                351037615
            ],
            [
                56,
                351388170
            ],
            [
                57,
                351676590
            ],
            [
                58,
                351938790
            ],
            [
                59,
                352535850
            ],
            [
                60,
                353607895
            ],
            [
                61,
                354699250
            ],
            [
                62,
                355739290
            ],
            [
                63,
                355886950
            ],
            [
                64,
                355983250
            ],
            [
                65,
                356098810
            ],
            [
                66,
                356408560
            ],
            [
                67,
                357133060
            ],
            [
                68,
                357558315
            ],
            [
                69,
                357626565
            ],
            [
                70,
                357705315
            ],
            [
                71,
                357768325
            ],
            [
                72,
                357831320
            ],
            [
                73,
                358102945
            ],
            [
                74,
                358716605
            ],
            [
                75,
                359113975
            ],
            [
                76,
                359179365
            ],
            [
                77,
                359249785
            ],
            [
                78,
                359310145
            ],
            [
                79,
                359370400
            ],
            [
                80,
                359656540
            ],
            [
                81,
                360339260
            ],
            [
                82,
                360730820
            ],
            [
                83,
                360796080
            ],
            [
                84,
                360866360
            ],
            [
                85,
                360926600
            ],
            [
                86,
                360981820
            ],
            [
                87,
                361172575
            ],
            [
                88,
                361554055
            ],
            [
                89,
                361774715
            ],
            [
                90,
                361819595
            ],
            [
                91,
                361868215
            ],
            [
                92,
                361909565
            ],
            [
                93,
                361950600
            ],
            [
                94,
                362067010
            ],
            [
                95,
                362297385
            ],
            [
                96,
                362435610
            ],
            [
                97,
                362464710
            ],
            [
                98,
                362496235
            ],
            [
                99,
                362522910
            ],
            [
                100,
                362554515
            ],
            [
                101,
                362689055
            ],
            [
                102,
                362916905
            ],
            [
                103,
                363060130
            ],
            [
                104,
                363151270
            ],
            [
                105,
                363188160
            ],
            [
                106,
                363216170
            ],
            [
                107,
                363255230
            ],
            [
                108,
                363381630
            ],
            [
                109,
                363612705
            ],
            [
                110,
                363741080
            ],
            [
                111,
                363770885
            ],
            [
                112,
                363800595
            ],
            [
                113,
                363826465
            ],
            [
                114,
                363858260
            ],
            [
                115,
                363960590
            ],
            [
                116,
                364136825
            ],
            [
                117,
                364248630
            ],
            [
                118,
                364275185
            ],
            [
                119,
                364299820
            ],
            [
                120,
                364320665
            ],
            [
                121,
                364350985
            ],
            [
                122,
                364451410
            ],
            [
                123,
                364659995
            ],
            [
                124,
                364774325
            ],
            [
                125,
                364800590
            ],
            [
                126,
                364833035
            ],
            [
                127,
                364856210
            ],
            [
                128,
                364879305
            ],
            [
                129,
                364992455
            ],
            [
                130,
                365212555
            ],
            [
                131,
                365353620
            ],
            [
                132,
                365451270
            ],
            [
                133,
                365477620
            ],
            [
                134,
                365502420
            ],
            [
                135,
                365525670
            ],
            [
                136,
                365626320
            ],
            [
                137,
                365835245
            ],
            [
                138,
                365943520
            ],
            [
                139,
                365966395
            ],
            [
                140,
                365990780
            ],
            [
                141,
                366012130
            ],
            [
                142,
                366031955
            ],
            [
                143,
                366111605
            ],
            [
                144,
                366281230
            ],
            [
                145,
                366375650
            ],
            [
                146,
                366418425
            ],
            [
                147,
                366474435
            ],
            [
                148,
                366553025
            ],
            [
                149,
                366592320
            ],
            [
                150,
                366727875
            ],
            [
                151,
                366864730
            ],
            [
                152,
                366932480
            ],
            [
                153,
                366947265
            ],
            [
                154,
                366960870
            ],
            [
                155,
                366973180
            ],
            [
                156,
                366986595
            ],
            [
                157,
                367025655
            ],
            [
                158,
                367108815
            ],
            [
                159,
                367157955
            ],
            [
                160,
                367171815
            ],
            [
                161,
                367186935
            ],
            [
                162,
                367200710
            ],
            [
                163,
                367212050
            ],
            [
                164,
                367243270
            ],
            [
                165,
                367314630
            ],
            [
                166,
                367355885
            ],
            [
                167,
                367365815
            ],
            [
                168,
                367378080
            ],
            [
                169,
                367391860
            ],
            [
                170,
                367405655
            ],
            [
                171,
                367431270
            ],
            [
                172,
                367472640
            ],
            [
                173,
                367504160
            ],
            [
                174,
                367535680
            ],
            [
                175,
                367553410
            ],
            [
                176,
                367573535
            ],
            [
                177,
                367607660
            ],
            [
                178,
                367651385
            ],
            [
                179,
                367700870
            ],
            [
                180,
                367736345
            ],
            [
                181,
                367766870
            ],
            [
                182,
                367793270
            ],
            [
                183,
                367835345
            ],
            [
                184,
                367860095
            ],
            [
                185,
                367893315
            ],
            [
                186,
                367935595
            ],
            [
                187,
                367956735
            ],
            [
                188,
                367964290
            ],
            [
                189,
                367971865
            ],
            [
                190,
                367977905
            ],
            [
                191,
                367983190
            ],
            [
                192,
                367996205
            ],
            [
                193,
                368029770
            ],
            [
                194,
                368049635
            ],
            [
                195,
                368053060
            ],
            [
                196,
                368057170
            ],
            [
                197,
                368061265
            ],
            [
                198,
                368065385
            ]
        ],
        name: 'despicableme2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Despicable Me 2',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#D0C6A9'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                34266177
            ],
            [
                2,
                65208670
            ],
            [
                3,
                90440272
            ],
            [
                4,
                100925912
            ],
            [
                5,
                113964720
            ],
            [
                6,
                123339570
            ],
            [
                7,
                132817010
            ],
            [
                8,
                147803863
            ],
            [
                9,
                168928089
            ],
            [
                10,
                185140364
            ],
            [
                11,
                192061039
            ],
            [
                12,
                200844477
            ],
            [
                13,
                208335932
            ],
            [
                14,
                216120171
            ],
            [
                15,
                228679481
            ],
            [
                16,
                236889029
            ],
            [
                17,
                245891395
            ],
            [
                18,
                250845401
            ],
            [
                19,
                257285774
            ],
            [
                20,
                262308400
            ],
            [
                21,
                266530304
            ],
            [
                22,
                271999560
            ],
            [
                23,
                278957386
            ],
            [
                24,
                284196100
            ],
            [
                25,
                286592302
            ],
            [
                26,
                289886341
            ],
            [
                27,
                292470389
            ],
            [
                28,
                294702966
            ],
            [
                29,
                298076126
            ],
            [
                30,
                302882902
            ],
            [
                31,
                306247046
            ],
            [
                32,
                307830350
            ],
            [
                33,
                309944068
            ],
            [
                34,
                311472923
            ],
            [
                35,
                312978811
            ],
            [
                36,
                315179995
            ],
            [
                37,
                318109815
            ],
            [
                38,
                320393339
            ],
            [
                39,
                321545325
            ],
            [
                40,
                322944913
            ],
            [
                41,
                324010768
            ],
            [
                42,
                325076892
            ],
            [
                43,
                326388708
            ],
            [
                44,
                328199667
            ],
            [
                45,
                329587896
            ],
            [
                46,
                330388314
            ],
            [
                47,
                331333285
            ],
            [
                48,
                332026895
            ],
            [
                49,
                332686150
            ],
            [
                50,
                333459447
            ],
            [
                51,
                334547356
            ],
            [
                52,
                335390545
            ],
            [
                53,
                335852827
            ],
            [
                54,
                336491884
            ],
            [
                55,
                336926075
            ],
            [
                56,
                337319497
            ],
            [
                57,
                337882892
            ],
            [
                58,
                338725582
            ],
            [
                59,
                339365573
            ],
            [
                60,
                339695765
            ],
            [
                61,
                340132364
            ],
            [
                62,
                340458012
            ],
            [
                63,
                340758415
            ],
            [
                64,
                341200661
            ],
            [
                65,
                341857068
            ],
            [
                66,
                342353075
            ],
            [
                67,
                342553567
            ],
            [
                68,
                342806331
            ],
            [
                69,
                342994075
            ],
            [
                70,
                343169107
            ],
            [
                71,
                343484260
            ],
            [
                72,
                344104957
            ],
            [
                73,
                344519079
            ],
            [
                74,
                344671046
            ],
            [
                75,
                344824515
            ],
            [
                76,
                344950104
            ],
            [
                77,
                345073280
            ],
            [
                78,
                345709668
            ],
            [
                79,
                346992697
            ],
            [
                80,
                348310170
            ],
            [
                81,
                349526793
            ],
            [
                82,
                349712242
            ],
            [
                83,
                349854676
            ],
            [
                84,
                349996363
            ],
            [
                85,
                350279893
            ],
            [
                86,
                351037588
            ],
            [
                87,
                351525709
            ],
            [
                88,
                351643444
            ],
            [
                89,
                351752491
            ],
            [
                90,
                351840283
            ],
            [
                91,
                351919169
            ],
            [
                92,
                352107777
            ],
            [
                93,
                352563827
            ],
            [
                94,
                352846548
            ],
            [
                95,
                352907907
            ],
            [
                96,
                352976903
            ],
            [
                97,
                353063164
            ],
            [
                98,
                353130093
            ],
            [
                99,
                353220374
            ],
            [
                100,
                353394170
            ],
            [
                101,
                353495492
            ],
            [
                102,
                353525555
            ],
            [
                103,
                353554263
            ],
            [
                104,
                353584508
            ],
            [
                105,
                353612737
            ]
        ],
        name: 'pixar2014',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Inside Out',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#6A7183'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                67407340
            ],
            [
                2,
                114033920
            ],
            [
                3,
                147187040
            ],
            [
                4,
                161202390
            ],
            [
                5,
                174514030
            ],
            [
                6,
                183701580
            ],
            [
                7,
                191930470
            ],
            [
                8,
                210793650
            ],
            [
                9,
                236252910
            ],
            [
                10,
                251516400
            ],
            [
                11,
                255156380
            ],
            [
                12,
                259520250
            ],
            [
                13,
                262437800
            ],
            [
                14,
                265354080
            ],
            [
                15,
                273678480
            ],
            [
                16,
                286601120
            ],
            [
                17,
                294510675
            ],
            [
                18,
                296532315
            ],
            [
                19,
                298829565
            ],
            [
                20,
                300534085
            ],
            [
                21,
                302260135
            ],
            [
                22,
                307134375
            ],
            [
                23,
                315550055
            ],
            [
                24,
                320081575
            ],
            [
                25,
                321241725
            ],
            [
                26,
                322669420
            ],
            [
                27,
                323661305
            ],
            [
                28,
                324424355
            ],
            [
                29,
                326604165
            ],
            [
                30,
                329200175
            ],
            [
                31,
                331068495
            ],
            [
                32,
                331562645
            ],
            [
                33,
                332172980
            ],
            [
                34,
                332653095
            ],
            [
                35,
                333147935
            ],
            [
                36,
                334589855
            ],
            [
                37,
                336947995
            ],
            [
                38,
                338555135
            ],
            [
                39,
                338962145
            ],
            [
                40,
                339441295
            ],
            [
                41,
                339816615
            ],
            [
                42,
                340133495
            ],
            [
                43,
                341130010
            ],
            [
                44,
                342786130
            ],
            [
                45,
                343782475
            ],
            [
                46,
                344094705
            ],
            [
                47,
                344386455
            ],
            [
                48,
                344632905
            ],
            [
                49,
                344889185
            ],
            [
                50,
                345458740
            ],
            [
                51,
                346334790
            ],
            [
                52,
                347161270
            ],
            [
                53,
                347723320
            ],
            [
                54,
                347930725
            ],
            [
                55,
                348103470
            ],
            [
                56,
                348243950
            ],
            [
                57,
                348532400
            ],
            [
                58,
                348980195
            ],
            [
                59,
                349249360
            ],
            [
                60,
                349346140
            ],
            [
                61,
                349447600
            ],
            [
                62,
                349526785
            ],
            [
                63,
                349597795
            ],
            [
                64,
                349725150
            ],
            [
                65,
                349923195
            ],
            [
                66,
                350034110
            ],
            [
                67,
                350081220
            ],
            [
                68,
                350133000
            ],
            [
                69,
                350182455
            ],
            [
                70,
                350222520
            ],
            [
                71,
                350418870
            ],
            [
                72,
                350704470
            ],
            [
                73,
                350827635
            ],
            [
                74,
                350872260
            ],
            [
                75,
                350922240
            ],
            [
                76,
                350981145
            ],
            [
                77,
                351032910
            ]
        ],
        name: 'fast7',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Furious 7',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#6A6A69'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                0,
                5500000
            ],
            [
                1,
                43225329
            ],
            [
                2,
                64765347
            ],
            [
                3,
                97754230
            ],
            [
                4,
                132242114
            ],
            [
                5,
                162618212
            ],
            [
                6,
                180651397
            ],
            [
                7,
                194088858
            ],
            [
                8,
                204421287
            ],
            [
                9,
                213975424
            ],
            [
                10,
                228818138
            ],
            [
                11,
                247145003
            ],
            [
                12,
                261078700
            ],
            [
                13,
                266944138
            ],
            [
                14,
                273009241
            ],
            [
                15,
                277633524
            ],
            [
                16,
                281550252
            ],
            [
                17,
                287865039
            ],
            [
                18,
                296487753
            ],
            [
                19,
                302878797
            ],
            [
                20,
                305717867
            ],
            [
                21,
                308775871
            ],
            [
                22,
                311239379
            ],
            [
                23,
                313789450
            ],
            [
                24,
                317369164
            ],
            [
                25,
                322208872
            ],
            [
                26,
                325841185
            ],
            [
                27,
                327418686
            ],
            [
                28,
                329134061
            ],
            [
                29,
                330534176
            ],
            [
                30,
                331921414
            ],
            [
                31,
                333715081
            ],
            [
                32,
                336181865
            ],
            [
                33,
                338007725
            ],
            [
                34,
                338838869
            ],
            [
                35,
                339690805
            ],
            [
                36,
                340435839
            ],
            [
                37,
                341158341
            ],
            [
                38,
                342018562
            ],
            [
                39,
                343270593
            ],
            [
                40,
                344244486
            ],
            [
                41,
                344666713
            ],
            [
                42,
                345152286
            ],
            [
                43,
                345528029
            ],
            [
                44,
                345884168
            ],
            [
                45,
                346269300
            ],
            [
                46,
                346843821
            ],
            [
                47,
                347268800
            ],
            [
                48,
                347440989
            ],
            [
                49,
                347624217
            ],
            [
                50,
                347776785
            ],
            [
                51,
                347933730
            ],
            [
                52,
                348104302
            ],
            [
                53,
                348360601
            ],
            [
                54,
                348540006
            ],
            [
                55,
                348610183
            ],
            [
                56,
                348687050
            ],
            [
                57,
                348752065
            ],
            [
                58,
                348816955
            ],
            [
                59,
                348994766
            ],
            [
                60,
                349273584
            ],
            [
                61,
                349457208
            ],
            [
                62,
                349530419
            ],
            [
                63,
                349614219
            ],
            [
                64,
                349684855
            ],
            [
                65,
                349759744
            ],
            [
                66,
                349894563
            ],
            [
                67,
                350118110
            ],
            [
                68,
                350348225
            ],
            [
                69,
                350500012
            ],
            [
                70,
                350544784
            ],
            [
                71,
                350586168
            ],
            [
                72,
                350625139
            ],
            [
                73,
                350672117
            ],
            [
                74,
                350755109
            ],
            [
                75,
                350800077
            ],
            [
                76,
                350813745
            ],
            [
                77,
                350832076
            ],
            [
                78,
                350847747
            ],
            [
                79,
                350862779
            ],
            [
                80,
                350980623
            ],
            [
                81,
                351188671
            ],
            [
                82,
                351331987
            ],
            [
                83,
                351372490
            ],
            [
                84,
                351418946
            ],
            [
                85,
                351458166
            ],
            [
                86,
                351501539
            ],
            [
                87,
                351603303
            ],
            [
                88,
                351781681
            ],
            [
                89,
                351902625
            ],
            [
                90,
                351931519
            ],
            [
                91,
                351962681
            ],
            [
                92,
                351991232
            ],
            [
                93,
                352021378
            ],
            [
                94,
                352073903
            ],
            [
                95,
                352165905
            ],
            [
                96,
                352222098
            ],
            [
                97,
                352235347
            ],
            [
                98,
                352249359
            ],
            [
                99,
                352262443
            ],
            [
                100,
                352275878
            ],
            [
                101,
                352298118
            ],
            [
                102,
                352334012
            ],
            [
                103,
                352358779
            ],
            [
                104,
                352369061
            ],
            [
                105,
                352376573
            ],
            [
                106,
                352382933
            ],
            [
                107,
                352390543
            ]
        ],
        name: 'transformers3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Transformers: Dark of the Moon',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#4B4440'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                240211
            ],
            [
                2,
                439692
            ],
            [
                3,
                655550
            ],
            [
                4,
                873667
            ],
            [
                5,
                1040111
            ],
            [
                6,
                1204312
            ],
            [
                7,
                1329299
            ],
            [
                8,
                1552379
            ],
            [
                9,
                1786098
            ],
            [
                10,
                2024960
            ],
            [
                11,
                2229288
            ],
            [
                12,
                2329793
            ],
            [
                13,
                2418851
            ],
            [
                14,
                2512183
            ],
            [
                15,
                2595151
            ],
            [
                16,
                2751511
            ],
            [
                17,
                2985721
            ],
            [
                18,
                3174669
            ],
            [
                19,
                3234852
            ],
            [
                20,
                3303452
            ],
            [
                21,
                3372722
            ],
            [
                22,
                3424778
            ],
            [
                23,
                33763266
            ],
            [
                24,
                68310550
            ],
            [
                25,
                92693844
            ],
            [
                26,
                110636235
            ],
            [
                27,
                120560352
            ],
            [
                28,
                128115621
            ],
            [
                29,
                135772113
            ],
            [
                30,
                153985667
            ],
            [
                31,
                182620802
            ],
            [
                32,
                200400417
            ],
            [
                33,
                204583784
            ],
            [
                34,
                209600822
            ],
            [
                35,
                213423957
            ],
            [
                36,
                217092013
            ],
            [
                37,
                226997629
            ],
            [
                38,
                243508165
            ],
            [
                39,
                247752541
            ],
            [
                40,
                250397650
            ],
            [
                41,
                253320791
            ],
            [
                42,
                255594133
            ],
            [
                43,
                258100239
            ],
            [
                44,
                264263604
            ],
            [
                45,
                275296051
            ],
            [
                46,
                281389352
            ],
            [
                47,
                282979594
            ],
            [
                48,
                284752955
            ],
            [
                49,
                286221115
            ],
            [
                50,
                287698293
            ],
            [
                51,
                291443856
            ],
            [
                52,
                299267928
            ],
            [
                53,
                304113098
            ],
            [
                54,
                306478136
            ],
            [
                55,
                307762521
            ],
            [
                56,
                308800018
            ],
            [
                57,
                309957178
            ],
            [
                58,
                312675300
            ],
            [
                59,
                317271043
            ],
            [
                60,
                320009625
            ],
            [
                61,
                320845846
            ],
            [
                62,
                321794342
            ],
            [
                63,
                322586443
            ],
            [
                64,
                323408447
            ],
            [
                65,
                325311916
            ],
            [
                66,
                328913643
            ],
            [
                67,
                330802740
            ],
            [
                68,
                331304919
            ],
            [
                69,
                331812237
            ],
            [
                70,
                332241639
            ],
            [
                71,
                332698979
            ],
            [
                72,
                333845819
            ],
            [
                73,
                336004358
            ],
            [
                74,
                337100370
            ],
            [
                75,
                337442628
            ],
            [
                76,
                337852209
            ],
            [
                77,
                338215533
            ],
            [
                78,
                338569563
            ],
            [
                79,
                339325331
            ],
            [
                80,
                340707737
            ],
            [
                81,
                341380905
            ],
            [
                82,
                341612973
            ],
            [
                83,
                341868356
            ],
            [
                84,
                342124666
            ],
            [
                85,
                342360752
            ],
            [
                86,
                342793490
            ],
            [
                87,
                343578903
            ],
            [
                88,
                343969003
            ],
            [
                89,
                344121396
            ],
            [
                90,
                344276641
            ],
            [
                91,
                344414087
            ],
            [
                92,
                344540234
            ],
            [
                93,
                344787171
            ],
            [
                94,
                345211045
            ],
            [
                95,
                345414287
            ],
            [
                96,
                345495500
            ],
            [
                97,
                345586824
            ],
            [
                98,
                345670073
            ],
            [
                99,
                345758428
            ],
            [
                100,
                345989306
            ],
            [
                101,
                346250796
            ],
            [
                102,
                346386488
            ],
            [
                103,
                346441961
            ],
            [
                104,
                346503536
            ],
            [
                105,
                346559053
            ],
            [
                106,
                346616236
            ],
            [
                107,
                346796514
            ],
            [
                108,
                347098782
            ],
            [
                109,
                347211277
            ],
            [
                110,
                347251832
            ],
            [
                111,
                347300219
            ],
            [
                112,
                347344678
            ],
            [
                113,
                347383183
            ],
            [
                114,
                347488055
            ],
            [
                115,
                347673246
            ],
            [
                116,
                347762901
            ],
            [
                117,
                347800074
            ],
            [
                118,
                347842467
            ],
            [
                119,
                347879710
            ],
            [
                120,
                347920677
            ],
            [
                121,
                348017253
            ],
            [
                122,
                348204661
            ],
            [
                123,
                348295276
            ],
            [
                124,
                348326991
            ],
            [
                125,
                348361848
            ],
            [
                126,
                348391476
            ],
            [
                127,
                348417548
            ],
            [
                128,
                348541447
            ],
            [
                129,
                348713204
            ],
            [
                130,
                348861463
            ],
            [
                131,
                348907423
            ],
            [
                132,
                348957979
            ],
            [
                133,
                348997918
            ],
            [
                134,
                349033865
            ],
            [
                135,
                349120195
            ],
            [
                136,
                349239350
            ],
            [
                137,
                349324606
            ],
            [
                138,
                349358708
            ],
            [
                139,
                349396221
            ],
            [
                140,
                349424355
            ],
            [
                141,
                349451927
            ],
            [
                142,
                349506511
            ],
            [
                143,
                349595222
            ],
            [
                144,
                349640908
            ],
            [
                145,
                349656798
            ],
            [
                146,
                349673800
            ],
            [
                147,
                349689951
            ],
            [
                148,
                349709071
            ],
            [
                149,
                349752421
            ],
            [
                150,
                349821648
            ],
            [
                151,
                349894088
            ],
            [
                152,
                349936617
            ],
            [
                153,
                349949801
            ],
            [
                154,
                349960743
            ],
            [
                155,
                349973107
            ],
            [
                156,
                349992136
            ],
            [
                157,
                350020183
            ],
            [
                158,
                350040510
            ],
            [
                159,
                350046837
            ],
            [
                160,
                350053913
            ],
            [
                161,
                350060565
            ],
            [
                162,
                350066882
            ],
            [
                163,
                350073413
            ],
            [
                164,
                350084272
            ],
            [
                165,
                350090029
            ],
            [
                166,
                350092526
            ],
            [
                167,
                350095047
            ],
            [
                168,
                350097698
            ],
            [
                169,
                350100544
            ],
            [
                170,
                350103672
            ],
            [
                171,
                350108900
            ],
            [
                172,
                350112192
            ],
            [
                173,
                350113554
            ],
            [
                174,
                350115090
            ],
            [
                175,
                350116992
            ],
            [
                176,
                350118902
            ],
            [
                177,
                350120025
            ],
            [
                178,
                350121839
            ],
            [
                179,
                350123553
            ],
            [
                180,
                350124160
            ],
            [
                181,
                350124949
            ],
            [
                182,
                350125656
            ],
            [
                183,
                350126372
            ]
        ],
        name: 'americansniper',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'American Sniper',
            genre: 'Drama',

            mpaaRating: 'R',
            imgMainColor: '#A7A3A1'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                47335592
            ],
            [
                2,
                89843617
            ],
            [
                3,
                132434639
            ],
            [
                4,
                152193853
            ],
            [
                5,
                163753459
            ],
            [
                6,
                172371048
            ],
            [
                7,
                180394887
            ],
            [
                8,
                196612895
            ],
            [
                9,
                220904669
            ],
            [
                10,
                236865054
            ],
            [
                11,
                241330567
            ],
            [
                12,
                246489373
            ],
            [
                13,
                250285148
            ],
            [
                14,
                254139009
            ],
            [
                15,
                263018288
            ],
            [
                16,
                277179070
            ],
            [
                17,
                285254204
            ],
            [
                18,
                287585111
            ],
            [
                19,
                290439707
            ],
            [
                20,
                292654249
            ],
            [
                21,
                294758132
            ],
            [
                22,
                299450814
            ],
            [
                23,
                306791134
            ],
            [
                24,
                311484061
            ],
            [
                25,
                312912129
            ],
            [
                26,
                314584172
            ],
            [
                27,
                315915561
            ],
            [
                28,
                317277425
            ],
            [
                29,
                320279046
            ],
            [
                30,
                325108725
            ],
            [
                31,
                328219729
            ]
        ],
        name: 'deadpool2016',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Deadpool',
            genre: 'Action',

            mpaaRating: 'R',
            imgMainColor: '#91717B'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                26159972
            ],
            [
                2,
                40038684
            ],
            [
                3,
                59263024
            ],
            [
                4,
                82015081
            ],
            [
                5,
                102046212
            ],
            [
                6,
                115556154
            ],
            [
                7,
                123346204
            ],
            [
                8,
                135727511
            ],
            [
                9,
                151182682
            ],
            [
                10,
                168056221
            ],
            [
                11,
                185283282
            ],
            [
                12,
                200058231
            ],
            [
                13,
                210153082
            ],
            [
                14,
                218595905
            ],
            [
                15,
                229636178
            ],
            [
                16,
                236014322
            ],
            [
                17,
                243590544
            ],
            [
                18,
                254290037
            ],
            [
                19,
                261031601
            ],
            [
                20,
                263165066
            ],
            [
                21,
                265320641
            ],
            [
                22,
                267068847
            ],
            [
                23,
                268666211
            ],
            [
                24,
                272561063
            ],
            [
                25,
                279199045
            ],
            [
                26,
                283421517
            ],
            [
                27,
                284460743
            ],
            [
                28,
                285656037
            ],
            [
                29,
                286637101
            ],
            [
                30,
                287628062
            ],
            [
                31,
                290292649
            ],
            [
                32,
                294814282
            ],
            [
                33,
                297892450
            ],
            [
                34,
                300122052
            ],
            [
                35,
                300898684
            ],
            [
                36,
                301532292
            ],
            [
                37,
                302209601
            ],
            [
                38,
                303959195
            ],
            [
                39,
                307406571
            ],
            [
                40,
                308821306
            ],
            [
                41,
                309357400
            ],
            [
                42,
                309916006
            ],
            [
                43,
                310407214
            ],
            [
                44,
                310938073
            ],
            [
                45,
                312157419
            ],
            [
                46,
                314497684
            ],
            [
                47,
                316026494
            ],
            [
                48,
                316340631
            ],
            [
                49,
                316702284
            ],
            [
                50,
                317019413
            ],
            [
                51,
                317340310
            ],
            [
                52,
                318148497
            ],
            [
                53,
                319764713
            ],
            [
                54,
                320857049
            ],
            [
                55,
                321086387
            ],
            [
                56,
                321346057
            ],
            [
                57,
                321598084
            ],
            [
                58,
                321849361
            ],
            [
                59,
                322653345
            ],
            [
                60,
                323961909
            ],
            [
                61,
                324921599
            ],
            [
                62,
                325446438
            ],
            [
                63,
                325730904
            ],
            [
                64,
                325970898
            ],
            [
                65,
                326231250
            ],
            [
                66,
                326719985
            ],
            [
                67,
                327611676
            ],
            [
                68,
                328156417
            ],
            [
                69,
                328285425
            ],
            [
                70,
                328435381
            ],
            [
                71,
                328574452
            ],
            [
                72,
                328720136
            ],
            [
                73,
                329100557
            ],
            [
                74,
                329842711
            ],
            [
                75,
                330338275
            ],
            [
                76,
                330462640
            ],
            [
                77,
                330599870
            ],
            [
                78,
                330723097
            ],
            [
                79,
                330847924
            ],
            [
                80,
                331139227
            ],
            [
                81,
                331692227
            ],
            [
                82,
                332075527
            ],
            [
                83,
                332194788
            ],
            [
                84,
                332342555
            ],
            [
                85,
                332471207
            ],
            [
                86,
                332609244
            ],
            [
                87,
                332874487
            ],
            [
                88,
                333338680
            ],
            [
                89,
                333623857
            ],
            [
                90,
                333710828
            ],
            [
                91,
                333824501
            ],
            [
                92,
                333920339
            ],
            [
                93,
                334022318
            ],
            [
                94,
                334219158
            ],
            [
                95,
                334584123
            ],
            [
                96,
                334790872
            ],
            [
                97,
                334883417
            ],
            [
                98,
                334986259
            ],
            [
                99,
                335077422
            ],
            [
                100,
                335176527
            ],
            [
                101,
                335337599
            ],
            [
                102,
                335616244
            ],
            [
                103,
                335800124
            ],
            [
                104,
                335852646
            ],
            [
                105,
                335914454
            ],
            [
                106,
                335967575
            ],
            [
                107,
                336021026
            ],
            [
                108,
                336142528
            ],
            [
                109,
                336364012
            ],
            [
                110,
                336500653
            ],
            [
                111,
                336538891
            ],
            [
                112,
                336587170
            ],
            [
                113,
                336628077
            ],
            [
                114,
                336673235
            ],
            [
                115,
                336762836
            ],
            [
                116,
                336918804
            ],
            [
                117,
                337013432
            ],
            [
                118,
                337047418
            ],
            [
                119,
                337088845
            ],
            [
                120,
                337126099
            ],
            [
                121,
                337174762
            ],
            [
                122,
                337301233
            ],
            [
                123,
                337439753
            ],
            [
                124,
                337526600
            ],
            [
                125,
                337577839
            ],
            [
                126,
                337619072
            ],
            [
                127,
                337659854
            ],
            [
                128,
                337702863
            ],
            [
                129,
                337770714
            ],
            [
                130,
                337887458
            ],
            [
                131,
                337949941
            ],
            [
                132,
                337971678
            ],
            [
                133,
                337998864
            ],
            [
                134,
                338020450
            ],
            [
                135,
                338043829
            ],
            [
                136,
                338092642
            ],
            [
                137,
                338175057
            ],
            [
                138,
                338230249
            ],
            [
                139,
                338247505
            ],
            [
                140,
                338267680
            ],
            [
                141,
                338285833
            ],
            [
                142,
                338305321
            ],
            [
                143,
                338344495
            ],
            [
                144,
                338408574
            ],
            [
                145,
                338457054
            ],
            [
                146,
                338474078
            ],
            [
                147,
                338493291
            ],
            [
                148,
                338508645
            ],
            [
                149,
                338521055
            ],
            [
                150,
                338548137
            ],
            [
                151,
                338592405
            ],
            [
                152,
                338622570
            ],
            [
                153,
                338639359
            ],
            [
                154,
                338652234
            ],
            [
                155,
                338663780
            ],
            [
                156,
                338678321
            ],
            [
                157,
                338705067
            ],
            [
                158,
                338751333
            ],
            [
                159,
                338794804
            ],
            [
                160,
                338829378
            ],
            [
                161,
                338841498
            ],
            [
                162,
                338853700
            ],
            [
                163,
                338866415
            ],
            [
                164,
                338889571
            ],
            [
                165,
                338929463
            ],
            [
                166,
                338955859
            ],
            [
                167,
                338967043
            ],
            [
                168,
                338980148
            ],
            [
                169,
                338992748
            ],
            [
                170,
                339022783
            ],
            [
                171,
                339045619
            ],
            [
                172,
                339079184
            ],
            [
                173,
                339104919
            ],
            [
                174,
                339117373
            ],
            [
                175,
                339130401
            ],
            [
                176,
                339142517
            ],
            [
                177,
                339156537
            ],
            [
                178,
                339176311
            ],
            [
                179,
                339206968
            ],
            [
                180,
                339230928
            ],
            [
                181,
                339243039
            ],
            [
                182,
                339256321
            ],
            [
                183,
                339269962
            ],
            [
                184,
                339284469
            ],
            [
                185,
                339301029
            ],
            [
                186,
                339324391
            ],
            [
                187,
                339344075
            ],
            [
                188,
                339354673
            ],
            [
                189,
                339365309
            ],
            [
                190,
                339375065
            ],
            [
                191,
                339384598
            ],
            [
                192,
                339406604
            ],
            [
                193,
                339435820
            ],
            [
                194,
                339457993
            ],
            [
                195,
                339470444
            ],
            [
                196,
                339481658
            ],
            [
                197,
                339490103
            ],
            [
                198,
                339503386
            ],
            [
                199,
                339515013
            ],
            [
                200,
                339537257
            ],
            [
                201,
                339554276
            ],
            [
                202,
                339563220
            ],
            [
                203,
                339573518
            ],
            [
                204,
                339584083
            ],
            [
                205,
                339593358
            ],
            [
                206,
                339602763
            ],
            [
                207,
                339617106
            ],
            [
                208,
                339628782
            ],
            [
                209,
                339636025
            ],
            [
                210,
                339643471
            ],
            [
                211,
                339650951
            ],
            [
                212,
                339658608
            ],
            [
                213,
                339666731
            ],
            [
                214,
                339677973
            ],
            [
                215,
                339687608
            ],
            [
                216,
                339693061
            ],
            [
                217,
                339699631
            ],
            [
                218,
                339705413
            ],
            [
                219,
                339711774
            ],
            [
                220,
                339718531
            ],
            [
                221,
                339727076
            ],
            [
                222,
                339734454
            ],
            [
                223,
                339738403
            ],
            [
                224,
                339743018
            ],
            [
                225,
                339747661
            ],
            [
                226,
                339751253
            ],
            [
                227,
                339752982
            ],
            [
                228,
                339756388
            ],
            [
                229,
                339758803
            ],
            [
                230,
                339760236
            ],
            [
                231,
                339761699
            ],
            [
                232,
                339763152
            ],
            [
                233,
                339764716
            ],
            [
                234,
                339766786
            ],
            [
                235,
                339769854
            ],
            [
                236,
                339772508
            ],
            [
                237,
                339773736
            ],
            [
                238,
                339775164
            ],
            [
                239,
                339776642
            ],
            [
                241,
                339777784
            ],
            [
                242,
                339779856
            ],
            [
                243,
                339781747
            ],
            [
                244,
                339782539
            ],
            [
                245,
                339783332
            ],
            [
                246,
                339784202
            ],
            [
                247,
                339785181
            ]
        ],
        name: 'twotowers',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Lord of the Rings: The Two Towers',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#2D6252'
        },
        showlabel: true,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                55139942
            ],
            [
                2,
                96045815
            ],
            [
                3,
                121897634
            ],
            [
                4,
                130875952
            ],
            [
                5,
                143007805
            ],
            [
                6,
                157628322
            ],
            [
                7,
                168708305
            ],
            [
                8,
                192907747
            ],
            [
                9,
                214899972
            ],
            [
                10,
                225680904
            ],
            [
                11,
                228316339
            ],
            [
                12,
                231476484
            ],
            [
                13,
                233808937
            ],
            [
                14,
                236126831
            ],
            [
                15,
                242789511
            ],
            [
                16,
                252704200
            ],
            [
                17,
                258153593
            ],
            [
                18,
                259591489
            ],
            [
                19,
                261377267
            ],
            [
                20,
                262766666
            ],
            [
                21,
                264198249
            ],
            [
                22,
                267941108
            ],
            [
                23,
                273669538
            ],
            [
                24,
                276884991
            ],
            [
                25,
                277996824
            ],
            [
                26,
                279367978
            ],
            [
                27,
                280389796
            ],
            [
                28,
                281476689
            ],
            [
                29,
                283752598
            ],
            [
                30,
                286897747
            ],
            [
                31,
                289356110
            ],
            [
                32,
                291072394
            ],
            [
                33,
                292982568
            ],
            [
                34,
                293970225
            ],
            [
                35,
                296655981
            ],
            [
                36,
                300182013
            ],
            [
                37,
                303846537
            ],
            [
                38,
                306719406
            ],
            [
                39,
                308939828
            ],
            [
                40,
                311329053
            ],
            [
                41,
                313282914
            ],
            [
                42,
                316174548
            ],
            [
                43,
                319160173
            ],
            [
                44,
                322054292
            ],
            [
                45,
                323734502
            ],
            [
                46,
                324301247
            ],
            [
                47,
                324876190
            ],
            [
                48,
                325347716
            ],
            [
                49,
                325774553
            ],
            [
                50,
                326834187
            ],
            [
                51,
                328620719
            ],
            [
                52,
                329540446
            ],
            [
                53,
                329793175
            ],
            [
                54,
                330136517
            ],
            [
                55,
                330416865
            ],
            [
                56,
                330643639
            ],
            [
                57,
                331128565
            ],
            [
                58,
                331973779
            ],
            [
                59,
                332516441
            ],
            [
                60,
                332930936
            ],
            [
                61,
                333074231
            ],
            [
                62,
                333180638
            ],
            [
                63,
                333285445
            ],
            [
                64,
                333551939
            ],
            [
                65,
                334067160
            ],
            [
                66,
                334325799
            ],
            [
                67,
                334386377
            ],
            [
                68,
                334460626
            ],
            [
                69,
                334522187
            ],
            [
                70,
                334577672
            ],
            [
                71,
                334747289
            ],
            [
                72,
                335042808
            ],
            [
                73,
                335127925
            ],
            [
                74,
                335170996
            ],
            [
                75,
                335218921
            ],
            [
                76,
                335258414
            ],
            [
                77,
                335293974
            ],
            [
                78,
                335400579
            ],
            [
                79,
                335601544
            ],
            [
                80,
                335704905
            ],
            [
                81,
                335735777
            ],
            [
                82,
                335768100
            ],
            [
                83,
                335796445
            ],
            [
                84,
                335825078
            ],
            [
                85,
                335890266
            ],
            [
                86,
                336043006
            ],
            [
                87,
                336128043
            ],
            [
                88,
                336187659
            ],
            [
                89,
                336208800
            ],
            [
                90,
                336228643
            ],
            [
                91,
                336248113
            ],
            [
                92,
                336296510
            ],
            [
                93,
                336369261
            ],
            [
                94,
                336410376
            ],
            [
                95,
                336423376
            ],
            [
                96,
                336438120
            ],
            [
                97,
                336450352
            ],
            [
                98,
                336464000
            ],
            [
                99,
                336526159
            ],
            [
                100,
                336645139
            ],
            [
                101,
                336717292
            ],
            [
                102,
                336736926
            ],
            [
                103,
                336758273
            ],
            [
                104,
                336775442
            ],
            [
                105,
                336796655
            ],
            [
                106,
                336844110
            ],
            [
                107,
                336921530
            ],
            [
                108,
                336962335
            ],
            [
                109,
                336976310
            ],
            [
                110,
                336992285
            ],
            [
                111,
                337005123
            ],
            [
                112,
                337018555
            ],
            [
                113,
                337043958
            ],
            [
                114,
                337083332
            ],
            [
                115,
                337103873
            ],
            [
                116,
                337111046
            ],
            [
                117,
                337119467
            ],
            [
                118,
                337127178
            ],
            [
                119,
                337135885
            ]
        ],
        name: 'hungergames3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hunger Games: Mockingjay - Part 1',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#532C1B'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                59841919
            ],
            [
                2,
                111178651
            ],
            [
                3,
                151116516
            ],
            [
                4,
                161401784
            ],
            [
                5,
                169444466
            ],
            [
                6,
                176161954
            ],
            [
                7,
                182070572
            ],
            [
                8,
                199232268
            ],
            [
                9,
                224411133
            ],
            [
                10,
                240236828
            ],
            [
                11,
                243829653
            ],
            [
                12,
                247287180
            ],
            [
                13,
                250433791
            ],
            [
                14,
                253357629
            ],
            [
                15,
                261336658
            ],
            [
                16,
                273714983
            ],
            [
                17,
                282379655
            ],
            [
                18,
                284729332
            ],
            [
                19,
                286385002
            ],
            [
                20,
                287939746
            ],
            [
                21,
                289642322
            ],
            [
                22,
                293443001
            ],
            [
                23,
                298969116
            ],
            [
                24,
                303977758
            ],
            [
                25,
                307754583
            ],
            [
                26,
                308788638
            ],
            [
                27,
                309752119
            ],
            [
                28,
                310764055
            ],
            [
                29,
                312786864
            ],
            [
                30,
                316005192
            ],
            [
                31,
                318342110
            ],
            [
                32,
                319099696
            ],
            [
                33,
                319846841
            ],
            [
                34,
                320558568
            ],
            [
                35,
                321280163
            ],
            [
                36,
                322520563
            ],
            [
                37,
                324404916
            ],
            [
                38,
                325585149
            ],
            [
                39,
                326055191
            ],
            [
                40,
                326528216
            ],
            [
                41,
                327010825
            ],
            [
                42,
                327515986
            ],
            [
                43,
                328204276
            ],
            [
                44,
                329202532
            ],
            [
                45,
                330021137
            ],
            [
                46,
                330323361
            ],
            [
                47,
                330631989
            ],
            [
                48,
                330937927
            ],
            [
                49,
                331248484
            ],
            [
                50,
                331597020
            ],
            [
                51,
                332128481
            ],
            [
                52,
                332486258
            ],
            [
                53,
                332656946
            ],
            [
                54,
                332832534
            ],
            [
                55,
                332959256
            ],
            [
                56,
                333091273
            ],
            [
                57,
                333276391
            ],
            [
                58,
                333518162
            ],
            [
                59,
                333693426
            ],
            [
                60,
                333790022
            ],
            [
                61,
                333868344
            ],
            [
                62,
                333969352
            ],
            [
                63,
                334040730
            ],
            [
                64,
                334130247
            ],
            [
                65,
                334250917
            ],
            [
                66,
                334344283
            ],
            [
                67,
                334395166
            ],
            [
                68,
                334440789
            ],
            [
                69,
                334466962
            ],
            [
                70,
                334489968
            ],
            [
                71,
                334639575
            ],
            [
                72,
                334846460
            ],
            [
                73,
                335002361
            ],
            [
                74,
                335073357
            ],
            [
                75,
                335156910
            ],
            [
                76,
                335231068
            ],
            [
                77,
                335310056
            ],
            [
                78,
                335409799
            ],
            [
                79,
                335534707
            ],
            [
                80,
                335625539
            ],
            [
                85,
                335872316
            ],
            [
                86,
                335962086
            ],
            [
                87,
                336027292
            ],
            [
                92,
                336188395
            ],
            [
                93,
                336241101
            ],
            [
                94,
                336279383
            ],
            [
                99,
                336382092
            ],
            [
                100,
                336413760
            ],
            [
                101,
                336436184
            ],
            [
                106,
                336491472
            ],
            [
                107,
                336514838
            ],
            [
                108,
                336530303
            ]
        ],
        name: 'spiderman3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Spider-Man 3',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#1C1A1C'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                46042205
            ],
            [
                2,
                84901740
            ],
            [
                3,
                115718405
            ],
            [
                4,
                128664415
            ],
            [
                5,
                145502830
            ],
            [
                6,
                157008005
            ],
            [
                7,
                166491710
            ],
            [
                8,
                181062890
            ],
            [
                9,
                201281480
            ],
            [
                10,
                215766440
            ],
            [
                11,
                221543540
            ],
            [
                12,
                229562000
            ],
            [
                13,
                234735200
            ],
            [
                14,
                239520410
            ],
            [
                15,
                246330960
            ],
            [
                16,
                255337150
            ],
            [
                17,
                262454370
            ],
            [
                18,
                265544530
            ],
            [
                19,
                269549810
            ],
            [
                20,
                272370765
            ],
            [
                21,
                275191275
            ],
            [
                22,
                278819900
            ],
            [
                23,
                283789150
            ],
            [
                24,
                287578650
            ],
            [
                25,
                289580495
            ],
            [
                26,
                291957870
            ],
            [
                27,
                293709620
            ],
            [
                28,
                295354120
            ],
            [
                29,
                297571150
            ],
            [
                30,
                300570370
            ],
            [
                31,
                302803140
            ],
            [
                32,
                303911805
            ],
            [
                33,
                305769990
            ],
            [
                34,
                306831810
            ],
            [
                35,
                307768710
            ],
            [
                36,
                309207510
            ],
            [
                37,
                311359215
            ],
            [
                38,
                312916835
            ],
            [
                39,
                313655040
            ],
            [
                40,
                314724685
            ],
            [
                41,
                315516675
            ],
            [
                42,
                316255325
            ],
            [
                43,
                317346065
            ],
            [
                44,
                318926525
            ],
            [
                45,
                320084045
            ],
            [
                46,
                320518115
            ],
            [
                47,
                321108005
            ],
            [
                48,
                321520530
            ],
            [
                49,
                321880590
            ],
            [
                50,
                322552430
            ],
            [
                51,
                323876350
            ],
            [
                52,
                324755670
            ],
            [
                53,
                325052310
            ],
            [
                54,
                325377915
            ],
            [
                55,
                325624740
            ],
            [
                56,
                325871460
            ],
            [
                57,
                326488720
            ],
            [
                58,
                327644900
            ],
            [
                59,
                328839955
            ],
            [
                60,
                329774550
            ],
            [
                61,
                329909440
            ],
            [
                62,
                329996155
            ],
            [
                63,
                330073195
            ],
            [
                64,
                330342645
            ],
            [
                65,
                331118615
            ],
            [
                66,
                331586135
            ],
            [
                67,
                331681250
            ],
            [
                68,
                331753300
            ],
            [
                69,
                331815930
            ],
            [
                70,
                331863705
            ],
            [
                71,
                332050815
            ],
            [
                72,
                332561115
            ],
            [
                73,
                332850665
            ],
            [
                74,
                332896175
            ],
            [
                75,
                332952765
            ],
            [
                76,
                333032145
            ],
            [
                77,
                333083175
            ],
            [
                78,
                333189645
            ],
            [
                79,
                333405120
            ],
            [
                80,
                333519195
            ],
            [
                81,
                333539700
            ],
            [
                82,
                333562515
            ],
            [
                83,
                333582795
            ],
            [
                84,
                333600540
            ],
            [
                85,
                333664140
            ],
            [
                86,
                333824465
            ],
            [
                87,
                333909265
            ],
            [
                88,
                333923840
            ],
            [
                89,
                333941065
            ],
            [
                90,
                333954315
            ],
            [
                91,
                333970210
            ],
            [
                92,
                334034805
            ],
            [
                93,
                334148500
            ],
            [
                94,
                334215500
            ],
            [
                95,
                334254595
            ],
            [
                96,
                334269775
            ],
            [
                97,
                334283615
            ],
            [
                98,
                334303855
            ],
            [
                99,
                334371895
            ],
            [
                100,
                334480030
            ],
            [
                101,
                334544425
            ],
            [
                102,
                334560220
            ],
            [
                103,
                334574800
            ],
            [
                104,
                334588050
            ],
            [
                105,
                334601455
            ],
            [
                106,
                334648810
            ],
            [
                107,
                334743520
            ],
            [
                108,
                334798960
            ],
            [
                109,
                334811765
            ],
            [
                110,
                334824480
            ],
            [
                111,
                334837075
            ],
            [
                112,
                334849695
            ],
            [
                113,
                334888305
            ],
            [
                114,
                334933935
            ],
            [
                115,
                334992380
            ],
            [
                116,
                335007535
            ],
            [
                117,
                335025085
            ],
            [
                118,
                335036900
            ],
            [
                119,
                335049770
            ],
            [
                120,
                335092895
            ],
            [
                121,
                335189475
            ],
            [
                122,
                335243940
            ],
            [
                123,
                335254055
            ],
            [
                124,
                335267580
            ],
            [
                125,
                335315360
            ],
            [
                126,
                335326710
            ],
            [
                127,
                335362700
            ],
            [
                128,
                335440945
            ],
            [
                129,
                335485230
            ],
            [
                130,
                335493570
            ],
            [
                131,
                335501715
            ],
            [
                132,
                335509020
            ],
            [
                133,
                335517165
            ],
            [
                134,
                335540840
            ],
            [
                135,
                335598220
            ],
            [
                136,
                335632780
            ],
            [
                137,
                335650110
            ],
            [
                138,
                335673715
            ],
            [
                139,
                335702495
            ],
            [
                140,
                335715935
            ],
            [
                141,
                335765230
            ],
            [
                142,
                335819690
            ],
            [
                143,
                335846465
            ],
            [
                144,
                335852520
            ],
            [
                145,
                335856845
            ],
            [
                146,
                335861250
            ],
            [
                147,
                335865645
            ],
            [
                148,
                335881710
            ],
            [
                149,
                335922550
            ],
            [
                150,
                335947255
            ],
            [
                151,
                335952005
            ],
            [
                152,
                335957710
            ],
            [
                153,
                335962485
            ],
            [
                154,
                335968155
            ],
            [
                155,
                335980160
            ],
            [
                156,
                336009820
            ],
            [
                157,
                336029560
            ],
            [
                158,
                336033085
            ],
            [
                159,
                336037315
            ],
            [
                160,
                336041500
            ],
            [
                161,
                336045770
            ]
        ],
        name: 'minions',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Minions',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#EDEADD'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                40804962
            ],
            [
                2,
                85014035
            ],
            [
                3,
                116101023
            ],
            [
                4,
                125109453
            ],
            [
                5,
                133085561
            ],
            [
                6,
                139858359
            ],
            [
                7,
                146625356
            ],
            [
                8,
                163906691
            ],
            [
                9,
                190803629
            ],
            [
                10,
                209339432
            ],
            [
                11,
                215393542
            ],
            [
                12,
                221403614
            ],
            [
                13,
                226120535
            ],
            [
                14,
                231243668
            ],
            [
                15,
                241059300
            ],
            [
                16,
                255505533
            ],
            [
                17,
                265433637
            ],
            [
                18,
                268193975
            ],
            [
                19,
                270876890
            ],
            [
                20,
                273253011
            ],
            [
                21,
                275827077
            ],
            [
                22,
                280743590
            ],
            [
                23,
                288177701
            ],
            [
                24,
                293534935
            ],
            [
                25,
                295513657
            ],
            [
                26,
                297550891
            ],
            [
                27,
                299459690
            ],
            [
                28,
                301525693
            ],
            [
                29,
                304535869
            ],
            [
                30,
                307678639
            ],
            [
                31,
                309733753
            ],
            [
                32,
                310965601
            ],
            [
                33,
                311922801
            ],
            [
                34,
                312796786
            ],
            [
                35,
                313707788
            ],
            [
                36,
                315338811
            ],
            [
                37,
                317601189
            ],
            [
                38,
                319009518
            ],
            [
                39,
                319380754
            ],
            [
                40,
                319774453
            ],
            [
                41,
                320120369
            ],
            [
                42,
                320474859
            ],
            [
                43,
                321400968
            ],
            [
                44,
                323093546
            ],
            [
                45,
                324131301
            ],
            [
                46,
                324412674
            ],
            [
                47,
                324721612
            ],
            [
                48,
                324989710
            ],
            [
                49,
                325272926
            ],
            [
                50,
                325860649
            ],
            [
                51,
                326866751
            ],
            [
                52,
                327537023
            ],
            [
                53,
                327711455
            ],
            [
                54,
                327899227
            ],
            [
                55,
                328052376
            ],
            [
                56,
                328208441
            ],
            [
                57,
                328603162
            ],
            [
                58,
                329276207
            ],
            [
                59,
                329686666
            ],
            [
                60,
                329804952
            ],
            [
                61,
                329925996
            ],
            [
                62,
                330035358
            ],
            [
                63,
                330145228
            ],
            [
                64,
                330306009
            ],
            [
                65,
                330588436
            ],
            [
                66,
                330857949
            ],
            [
                67,
                330915607
            ],
            [
                68,
                330976851
            ],
            [
                69,
                331034946
            ],
            [
                70,
                331093713
            ],
            [
                71,
                331206928
            ],
            [
                72,
                331411227
            ],
            [
                73,
                331533915
            ],
            [
                74,
                331573472
            ],
            [
                75,
                331622148
            ],
            [
                76,
                331666065
            ],
            [
                77,
                331709509
            ],
            [
                78,
                331836854
            ],
            [
                79,
                332046831
            ],
            [
                80,
                332194266
            ],
            [
                81,
                332254082
            ],
            [
                82,
                332316522
            ],
            [
                83,
                332370579
            ],
            [
                84,
                332430200
            ]
        ],
        name: 'aliceinwonderland10',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Alice in Wonderland (2010)',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#7A7769'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                37845336
            ],
            [
                2,
                68835193
            ],
            [
                3,
                94320883
            ],
            [
                4,
                106043239
            ],
            [
                5,
                117951060
            ],
            [
                6,
                126759442
            ],
            [
                7,
                134390839
            ],
            [
                8,
                146703522
            ],
            [
                9,
                163650634
            ],
            [
                10,
                176515761
            ],
            [
                11,
                181859666
            ],
            [
                12,
                188469200
            ],
            [
                13,
                193319081
            ],
            [
                14,
                197545821
            ],
            [
                15,
                204486397
            ],
            [
                16,
                214840279
            ],
            [
                17,
                222661385
            ],
            [
                18,
                225546287
            ],
            [
                19,
                229057703
            ],
            [
                20,
                231680832
            ],
            [
                21,
                234253857
            ],
            [
                22,
                239072406
            ],
            [
                23,
                246553294
            ],
            [
                24,
                251456069
            ],
            [
                25,
                253118471
            ],
            [
                26,
                255227773
            ],
            [
                27,
                256734812
            ],
            [
                28,
                258297268
            ],
            [
                29,
                262143691
            ],
            [
                30,
                268363965
            ],
            [
                31,
                275379530
            ],
            [
                32,
                281204119
            ],
            [
                33,
                282592034
            ],
            [
                34,
                283566704
            ],
            [
                35,
                284407854
            ],
            [
                36,
                287115133
            ],
            [
                37,
                292165484
            ],
            [
                38,
                294765199
            ],
            [
                39,
                295486958
            ],
            [
                40,
                296428705
            ],
            [
                41,
                297157587
            ],
            [
                42,
                297884832
            ],
            [
                43,
                299998997
            ],
            [
                44,
                303904198
            ],
            [
                45,
                305987190
            ],
            [
                46,
                306566055
            ],
            [
                47,
                307344958
            ],
            [
                48,
                307931409
            ],
            [
                49,
                308489031
            ],
            [
                50,
                309871852
            ],
            [
                51,
                312347805
            ],
            [
                52,
                313731317
            ],
            [
                53,
                314095356
            ],
            [
                54,
                314543546
            ],
            [
                55,
                314926408
            ],
            [
                56,
                315403275
            ],
            [
                57,
                316428277
            ],
            [
                58,
                318199811
            ],
            [
                59,
                319169216
            ],
            [
                60,
                319453527
            ],
            [
                61,
                319794624
            ],
            [
                62,
                320068353
            ],
            [
                63,
                320326404
            ],
            [
                64,
                321127936
            ],
            [
                65,
                322589442
            ],
            [
                66,
                323331487
            ],
            [
                67,
                323545823
            ],
            [
                68,
                323816724
            ],
            [
                69,
                324045645
            ],
            [
                70,
                324269904
            ],
            [
                71,
                324774109
            ],
            [
                72,
                325592520
            ],
            [
                73,
                326094767
            ],
            [
                74,
                326404453
            ],
            [
                75,
                326565358
            ],
            [
                76,
                326708491
            ],
            [
                77,
                326832731
            ],
            [
                78,
                327113437
            ],
            [
                79,
                327565272
            ],
            [
                80,
                327792643
            ],
            [
                81,
                327871720
            ],
            [
                82,
                327954942
            ],
            [
                83,
                328025796
            ],
            [
                84,
                328095589
            ]
        ],
        name: 'marvel2014a',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Guardians of the Galaxy',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#454451'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                0,
                907339
            ],
            [
                1,
                39334330
            ],
            [
                2,
                86411827
            ],
            [
                3,
                122536609
            ],
            [
                4,
                132168748
            ],
            [
                5,
                138706832
            ],
            [
                6,
                144478827
            ],
            [
                7,
                150338458
            ],
            [
                8,
                164551485
            ],
            [
                9,
                185178621
            ],
            [
                10,
                203378450
            ],
            [
                11,
                217348470
            ],
            [
                12,
                220983194
            ],
            [
                13,
                224426248
            ],
            [
                14,
                227906792
            ],
            [
                15,
                235262860
            ],
            [
                16,
                246730424
            ],
            [
                17,
                255927783
            ],
            [
                18,
                258553839
            ],
            [
                19,
                261139048
            ],
            [
                20,
                263640920
            ],
            [
                21,
                266142451
            ],
            [
                22,
                270565362
            ],
            [
                23,
                277048810
            ],
            [
                24,
                281460065
            ],
            [
                25,
                283095177
            ],
            [
                26,
                284781832
            ],
            [
                27,
                286485097
            ],
            [
                28,
                288242056
            ],
            [
                29,
                290920945
            ],
            [
                30,
                294435731
            ],
            [
                31,
                297245100
            ],
            [
                32,
                298399656
            ],
            [
                33,
                299663175
            ],
            [
                34,
                300965639
            ],
            [
                35,
                302154854
            ],
            [
                36,
                303906766
            ],
            [
                37,
                306214081
            ],
            [
                38,
                307807439
            ],
            [
                39,
                308617678
            ],
            [
                40,
                309452117
            ],
            [
                41,
                310249415
            ],
            [
                42,
                311065826
            ],
            [
                43,
                311927785
            ],
            [
                44,
                312967570
            ],
            [
                45,
                313739703
            ],
            [
                46,
                314132750
            ],
            [
                47,
                314434910
            ],
            [
                48,
                314858394
            ],
            [
                49,
                315202414
            ],
            [
                50,
                315686319
            ],
            [
                51,
                316285305
            ],
            [
                52,
                316740255
            ],
            [
                53,
                316959197
            ],
            [
                54,
                317180922
            ],
            [
                55,
                317300242
            ],
            [
                56,
                317417794
            ],
            [
                57,
                317615864
            ],
            [
                58,
                317883407
            ],
            [
                59,
                318079835
            ],
            [
                60,
                318172378
            ],
            [
                61,
                318288853
            ],
            [
                62,
                318418262
            ],
            [
                63,
                318553830
            ],
            [
                64,
                318676286
            ],
            [
                65,
                318831933
            ],
            [
                66,
                318937940
            ],
            [
                67,
                319005061
            ],
            [
                68,
                319077033
            ],
            [
                69,
                319136527
            ],
            [
                70,
                319201132
            ],
            [
                71,
                319395151
            ],
            [
                72,
                319655303
            ],
            [
                73,
                319835929
            ],
            [
                74,
                319927736
            ],
            [
                75,
                320035124
            ],
            [
                76,
                320140817
            ],
            [
                77,
                320246557
            ],
            [
                78,
                320383479
            ],
            [
                79,
                320564279
            ],
            [
                80,
                320706665
            ],
            [
                81,
                320780150
            ],
            [
                82,
                320862509
            ],
            [
                83,
                320938145
            ],
            [
                84,
                321012359
            ]
        ],
        name: 'shrek3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Shrek the Third',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#93A9A4'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                0,
                8801025
            ],
            [
                1,
                36652041
            ],
            [
                2,
                65725939
            ],
            [
                3,
                84903028
            ],
            [
                4,
                107559448
            ],
            [
                5,
                133261287
            ],
            [
                6,
                155405412
            ],
            [
                7,
                165333052
            ],
            [
                8,
                173586828
            ],
            [
                9,
                180589886
            ],
            [
                10,
                186981682
            ],
            [
                11,
                197813608
            ],
            [
                12,
                212308683
            ],
            [
                13,
                224009583
            ],
            [
                14,
                228950080
            ],
            [
                15,
                233693904
            ],
            [
                16,
                238202379
            ],
            [
                17,
                242463503
            ],
            [
                18,
                248561249
            ],
            [
                19,
                256587821
            ],
            [
                20,
                262978000
            ],
            [
                21,
                265802674
            ],
            [
                22,
                268416682
            ],
            [
                23,
                270721514
            ],
            [
                24,
                273034005
            ],
            [
                25,
                276334484
            ],
            [
                26,
                281002278
            ],
            [
                27,
                284677134
            ],
            [
                28,
                286203726
            ],
            [
                29,
                287614487
            ],
            [
                30,
                288974026
            ],
            [
                31,
                290357856
            ],
            [
                32,
                292043529
            ],
            [
                33,
                294441536
            ],
            [
                34,
                296379328
            ],
            [
                35,
                297314158
            ],
            [
                36,
                298142217
            ],
            [
                37,
                298897881
            ],
            [
                38,
                299633598
            ],
            [
                39,
                300560008
            ],
            [
                40,
                301849828
            ],
            [
                41,
                302869658
            ],
            [
                42,
                303299935
            ],
            [
                43,
                303719648
            ],
            [
                44,
                304126202
            ],
            [
                45,
                304539823
            ],
            [
                46,
                305062376
            ],
            [
                47,
                305857444
            ],
            [
                48,
                306487922
            ],
            [
                49,
                306746846
            ],
            [
                50,
                306996948
            ],
            [
                51,
                307223485
            ],
            [
                52,
                307448289
            ],
            [
                53,
                307766814
            ],
            [
                54,
                308259664
            ],
            [
                55,
                308597165
            ],
            [
                56,
                308714893
            ],
            [
                57,
                308831640
            ],
            [
                58,
                308934291
            ],
            [
                59,
                309034150
            ],
            [
                60,
                309280224
            ],
            [
                61,
                309715188
            ],
            [
                62,
                310182848
            ],
            [
                63,
                310578372
            ],
            [
                64,
                310651240
            ],
            [
                65,
                310713745
            ],
            [
                66,
                310776218
            ],
            [
                67,
                310928333
            ],
            [
                68,
                311210407
            ],
            [
                69,
                311381546
            ],
            [
                70,
                311421339
            ],
            [
                71,
                311463962
            ],
            [
                72,
                311504976
            ],
            [
                73,
                311550690
            ],
            [
                74,
                311677317
            ],
            [
                75,
                311900540
            ],
            [
                76,
                312024658
            ],
            [
                77,
                312055459
            ],
            [
                78,
                312086344
            ],
            [
                79,
                312118506
            ],
            [
                80,
                312151771
            ],
            [
                81,
                312520557
            ],
            [
                82,
                313184339
            ],
            [
                83,
                313588051
            ],
            [
                84,
                313684385
            ],
            [
                85,
                313780217
            ],
            [
                86,
                313875988
            ],
            [
                87,
                313974288
            ],
            [
                88,
                314274835
            ],
            [
                89,
                314828507
            ],
            [
                90,
                315175018
            ],
            [
                91,
                315262482
            ],
            [
                92,
                315360074
            ],
            [
                93,
                315450527
            ],
            [
                94,
                315542821
            ],
            [
                95,
                315776364
            ],
            [
                96,
                316185864
            ],
            [
                97,
                316476438
            ],
            [
                98,
                316609842
            ],
            [
                99,
                316688685
            ],
            [
                100,
                316765688
            ],
            [
                101,
                316848897
            ],
            [
                102,
                317045715
            ],
            [
                103,
                317384163
            ],
            [
                104,
                317601309
            ],
            [
                105,
                317667377
            ],
            [
                106,
                317725024
            ],
            [
                107,
                317782628
            ],
            [
                108,
                317846471
            ],
            [
                109,
                317982396
            ],
            [
                110,
                318204072
            ],
            [
                111,
                318326165
            ],
            [
                112,
                318359211
            ],
            [
                113,
                318394920
            ],
            [
                114,
                318427999
            ],
            [
                115,
                318468407
            ],
            [
                116,
                318542827
            ],
            [
                117,
                318676679
            ],
            [
                118,
                318759914
            ],
            [
                119,
                318781032
            ],
            [
                120,
                318801116
            ],
            [
                121,
                318821775
            ],
            [
                122,
                318843396
            ],
            [
                123,
                318885138
            ],
            [
                124,
                318970676
            ],
            [
                125,
                319014499
            ],
            [
                126,
                319026190
            ],
            [
                127,
                319041524
            ],
            [
                128,
                319055891
            ],
            [
                129,
                319071806
            ]
        ],
        name: 'transformers06',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Transformers',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#644036'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                0,
                3500000
            ],
            [
                1,
                38734361
            ],
            [
                2,
                76084460
            ],
            [
                3,
                102118668
            ],
            [
                4,
                109053236
            ],
            [
                5,
                115559020
            ],
            [
                6,
                121306364
            ],
            [
                7,
                126634395
            ],
            [
                8,
                141507587
            ],
            [
                9,
                162882216
            ],
            [
                10,
                177825024
            ],
            [
                11,
                181675868
            ],
            [
                12,
                185033014
            ],
            [
                13,
                188116002
            ],
            [
                14,
                191285389
            ],
            [
                15,
                199944628
            ],
            [
                16,
                213375983
            ],
            [
                17,
                223124385
            ],
            [
                18,
                226196567
            ],
            [
                19,
                228416495
            ],
            [
                20,
                230342753
            ],
            [
                21,
                232167416
            ],
            [
                22,
                237604542
            ],
            [
                23,
                245503384
            ],
            [
                24,
                252614669
            ],
            [
                25,
                258278546
            ],
            [
                26,
                259839619
            ],
            [
                27,
                261235207
            ],
            [
                28,
                262625072
            ],
            [
                29,
                266408309
            ],
            [
                30,
                272476435
            ],
            [
                31,
                276166336
            ],
            [
                32,
                277397055
            ],
            [
                33,
                278733064
            ],
            [
                34,
                280045742
            ],
            [
                35,
                281370201
            ],
            [
                36,
                283557530
            ],
            [
                37,
                286722088
            ],
            [
                38,
                288847640
            ],
            [
                39,
                289741611
            ],
            [
                40,
                290601389
            ],
            [
                41,
                291459326
            ],
            [
                42,
                292297954
            ],
            [
                43,
                293764080
            ],
            [
                44,
                295883267
            ],
            [
                45,
                297918329
            ],
            [
                46,
                298639217
            ],
            [
                47,
                299319470
            ],
            [
                48,
                300042790
            ],
            [
                49,
                300785869
            ],
            [
                50,
                301916400
            ],
            [
                51,
                303561186
            ],
            [
                52,
                304816141
            ],
            [
                53,
                305369088
            ],
            [
                54,
                305881416
            ],
            [
                55,
                306384581
            ],
            [
                56,
                306922205
            ],
            [
                57,
                307559158
            ],
            [
                58,
                308487809
            ],
            [
                59,
                309179318
            ],
            [
                60,
                309516225
            ],
            [
                61,
                309760401
            ],
            [
                62,
                309954481
            ],
            [
                63,
                310248520
            ],
            [
                64,
                310653809
            ],
            [
                65,
                311281305
            ],
            [
                66,
                311708133
            ],
            [
                67,
                311898804
            ],
            [
                68,
                312090570
            ],
            [
                69,
                312284414
            ],
            [
                70,
                312481891
            ],
            [
                71,
                312748436
            ],
            [
                72,
                313141743
            ],
            [
                73,
                313421025
            ],
            [
                74,
                313547131
            ],
            [
                75,
                313671653
            ],
            [
                76,
                313804568
            ],
            [
                77,
                313925130
            ],
            [
                78,
                314066705
            ],
            [
                79,
                314256674
            ],
            [
                80,
                314376968
            ],
            [
                81,
                314432189
            ],
            [
                82,
                314489281
            ],
            [
                83,
                314551977
            ],
            [
                84,
                314615301
            ],
            [
                85,
                314707473
            ],
            [
                86,
                314835082
            ],
            [
                87,
                314925955
            ],
            [
                88,
                314967980
            ],
            [
                89,
                315018372
            ],
            [
                90,
                315064601
            ],
            [
                91,
                315107589
            ],
            [
                92,
                315281601
            ],
            [
                93,
                315515786
            ],
            [
                94,
                315687768
            ],
            [
                95,
                315779208
            ],
            [
                96,
                315873917
            ],
            [
                97,
                315958428
            ],
            [
                98,
                316042315
            ],
            [
                99,
                316165799
            ],
            [
                100,
                316342881
            ],
            [
                101,
                316468817
            ],
            [
                102,
                316528951
            ],
            [
                103,
                316590841
            ],
            [
                104,
                316653730
            ],
            [
                105,
                316717117
            ],
            [
                106,
                316818769
            ],
            [
                107,
                316965355
            ],
            [
                108,
                317058295
            ],
            [
                109,
                317099466
            ],
            [
                110,
                317146297
            ],
            [
                111,
                317189757
            ],
            [
                112,
                317230110
            ],
            [
                113,
                317303064
            ],
            [
                114,
                317409427
            ],
            [
                115,
                317473452
            ],
            [
                116,
                317495641
            ],
            [
                117,
                317521757
            ],
            [
                118,
                317545933
            ],
            [
                119,
                317570520
            ],
            [
                120,
                317620121
            ],
            [
                121,
                317704761
            ],
            [
                122,
                317794156
            ],
            [
                123,
                317847676
            ],
            [
                124,
                317858838
            ],
            [
                125,
                317869143
            ],
            [
                126,
                317880036
            ],
            [
                127,
                317915421
            ],
            [
                128,
                317977386
            ],
            [
                129,
                318006770
            ],
            [
                130,
                318013962
            ],
            [
                131,
                318022539
            ],
            [
                132,
                318030804
            ],
            [
                133,
                318039924
            ],
            [
                134,
                318066027
            ],
            [
                135,
                318112815
            ],
            [
                136,
                318134740
            ],
            [
                137,
                318140292
            ],
            [
                138,
                318146675
            ],
            [
                139,
                318153372
            ],
            [
                140,
                318160117
            ],
            [
                141,
                318175773
            ],
            [
                142,
                318203593
            ],
            [
                143,
                318219154
            ],
            [
                144,
                318223785
            ],
            [
                145,
                318229516
            ],
            [
                146,
                318234471
            ],
            [
                147,
                318239816
            ],
            [
                148,
                318256758
            ],
            [
                149,
                318285594
            ],
            [
                150,
                318298180
            ],
            [
                151,
                318301917
            ],
            [
                152,
                318305950
            ],
            [
                153,
                318309405
            ],
            [
                154,
                318313199
            ],
            [
                161,
                318604126
            ]
        ],
        name: 'ironman',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Iron Man',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#28242B'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                32333203
            ],
            [
                2,
                65846144
            ],
            [
                3,
                90294621
            ],
            [
                4,
                96937323
            ],
            [
                5,
                104590892
            ],
            [
                6,
                117232892
            ],
            [
                7,
                129490758
            ],
            [
                8,
                152477758
            ],
            [
                9,
                173565758
            ],
            [
                10,
                186978513
            ],
            [
                11,
                189504513
            ],
            [
                12,
                191887513
            ],
            [
                13,
                193953513
            ],
            [
                14,
                196027962
            ],
            [
                15,
                202109962
            ],
            [
                16,
                212628962
            ],
            [
                17,
                219670289
            ],
            [
                18,
                220931289
            ],
            [
                19,
                222342289
            ],
            [
                20,
                223647289
            ],
            [
                21,
                224921846
            ],
            [
                22,
                228716846
            ],
            [
                23,
                235325846
            ],
            [
                24,
                239659542
            ],
            [
                25,
                240527542
            ],
            [
                26,
                241558542
            ],
            [
                27,
                242447542
            ],
            [
                28,
                243349983
            ],
            [
                29,
                245633983
            ],
            [
                30,
                250162983
            ],
            [
                31,
                253269579
            ],
            [
                32,
                254081579
            ],
            [
                33,
                255003579
            ],
            [
                34,
                255914579
            ],
            [
                35,
                257003050
            ],
            [
                36,
                258756050
            ],
            [
                37,
                261393050
            ],
            [
                38,
                264095956
            ],
            [
                39,
                265814956
            ],
            [
                40,
                267750733
            ],
            [
                41,
                271143733
            ],
            [
                42,
                274655414
            ],
            [
                43,
                278281414
            ],
            [
                44,
                282122414
            ],
            [
                45,
                285634174
            ],
            [
                46,
                288516174
            ],
            [
                47,
                291594218
            ],
            [
                48,
                293206218
            ],
            [
                49,
                294474009
            ],
            [
                50,
                296178009
            ],
            [
                51,
                298696009
            ],
            [
                52,
                300404434
            ],
            [
                53,
                300739434
            ],
            [
                54,
                301082434
            ],
            [
                55,
                301368434
            ],
            [
                56,
                301637555
            ],
            [
                57,
                302405555
            ],
            [
                58,
                304097555
            ],
            [
                59,
                305311880
            ],
            [
                60,
                305532880
            ],
            [
                61,
                305774880
            ],
            [
                62,
                305988880
            ],
            [
                63,
                306206530
            ],
            [
                64,
                306735530
            ],
            [
                65,
                307810530
            ],
            [
                66,
                308793051
            ],
            [
                67,
                309659297
            ],
            [
                68,
                309848297
            ],
            [
                69,
                310004297
            ],
            [
                70,
                310171603
            ],
            [
                95,
                314320476
            ]
        ],
        name: 'harrypotter',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Sorcerer´s Stone',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#735F4E'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                25041072
            ],
            [
                2,
                55612347
            ],
            [
                3,
                92146186
            ],
            [
                4,
                125178907
            ],
            [
                5,
                151958445
            ],
            [
                6,
                159563051
            ],
            [
                7,
                165603944
            ],
            [
                8,
                170881284
            ],
            [
                9,
                183101562
            ],
            [
                10,
                202929293
            ],
            [
                11,
                215635899
            ],
            [
                12,
                219165676
            ],
            [
                13,
                223025853
            ],
            [
                14,
                226664201
            ],
            [
                15,
                230221120
            ],
            [
                16,
                236825547
            ],
            [
                17,
                246400282
            ],
            [
                18,
                253014750
            ],
            [
                19,
                255349616
            ],
            [
                20,
                257620035
            ],
            [
                21,
                259756424
            ],
            [
                22,
                261782431
            ],
            [
                23,
                265534560
            ],
            [
                24,
                271155355
            ],
            [
                25,
                276524265
            ],
            [
                26,
                278017529
            ],
            [
                27,
                279472621
            ],
            [
                28,
                280951091
            ],
            [
                29,
                282420731
            ],
            [
                30,
                284771419
            ],
            [
                31,
                288310588
            ],
            [
                32,
                290961044
            ],
            [
                33,
                291988244
            ],
            [
                34,
                292966296
            ],
            [
                35,
                293891068
            ],
            [
                36,
                294905487
            ],
            [
                37,
                296295399
            ],
            [
                38,
                298488071
            ],
            [
                39,
                300085447
            ],
            [
                40,
                300819519
            ],
            [
                41,
                301394348
            ],
            [
                42,
                301884941
            ],
            [
                43,
                302653714
            ],
            [
                44,
                303774660
            ],
            [
                45,
                305390802
            ],
            [
                46,
                306428521
            ],
            [
                47,
                306868090
            ],
            [
                48,
                307327977
            ],
            [
                49,
                307795294
            ],
            [
                50,
                308227287
            ],
            [
                51,
                308843993
            ],
            [
                52,
                309819299
            ],
            [
                53,
                310487614
            ],
            [
                54,
                310760256
            ],
            [
                55,
                311040397
            ],
            [
                56,
                311330905
            ],
            [
                57,
                311613615
            ],
            [
                58,
                311885695
            ],
            [
                59,
                312298309
            ],
            [
                60,
                312569461
            ],
            [
                61,
                312684340
            ],
            [
                62,
                312809594
            ],
            [
                63,
                312939492
            ],
            [
                64,
                313075911
            ],
            [
                65,
                313233300
            ],
            [
                66,
                313476586
            ],
            [
                67,
                313646685
            ],
            [
                68,
                313719527
            ],
            [
                69,
                313801986
            ],
            [
                70,
                313887421
            ],
            [
                71,
                313972312
            ],
            [
                72,
                314071066
            ],
            [
                73,
                314228475
            ],
            [
                74,
                314331661
            ],
            [
                75,
                314383595
            ],
            [
                76,
                314433055
            ],
            [
                77,
                314475978
            ],
            [
                78,
                314515278
            ],
            [
                79,
                314581283
            ],
            [
                80,
                314681269
            ],
            [
                81,
                314749809
            ],
            [
                82,
                314782570
            ],
            [
                83,
                314819219
            ],
            [
                84,
                314848652
            ],
            [
                85,
                314879669
            ],
            [
                86,
                314933670
            ],
            [
                87,
                315025397
            ],
            [
                88,
                315070993
            ],
            [
                89,
                315089984
            ],
            [
                90,
                315119373
            ],
            [
                91,
                315142719
            ],
            [
                92,
                315168233
            ],
            [
                93,
                315202821
            ],
            [
                94,
                315253251
            ],
            [
                95,
                315286725
            ],
            [
                96,
                315298268
            ],
            [
                97,
                315313082
            ],
            [
                98,
                315325091
            ],
            [
                99,
                315337154
            ],
            [
                100,
                315436527
            ],
            [
                101,
                315586260
            ],
            [
                102,
                315733805
            ],
            [
                103,
                315844754
            ],
            [
                104,
                315873722
            ],
            [
                105,
                315898859
            ],
            [
                106,
                315923170
            ],
            [
                107,
                316002661
            ],
            [
                108,
                316133355
            ],
            [
                109,
                316202690
            ],
            [
                110,
                316220552
            ],
            [
                111,
                316244191
            ],
            [
                112,
                316264736
            ],
            [
                113,
                316286130
            ],
            [
                114,
                316340470
            ],
            [
                115,
                316435626
            ],
            [
                116,
                316489033
            ],
            [
                117,
                316501166
            ],
            [
                118,
                316515680
            ],
            [
                119,
                316529074
            ],
            [
                120,
                316542583
            ],
            [
                121,
                316577650
            ],
            [
                122,
                316637349
            ],
            [
                123,
                316670320
            ],
            [
                124,
                316678795
            ],
            [
                125,
                316689007
            ],
            [
                126,
                316698965
            ],
            [
                127,
                316708350
            ],
            [
                128,
                316751702
            ],
            [
                129,
                316821417
            ],
            [
                130,
                316849472
            ],
            [
                131,
                316856992
            ],
            [
                132,
                316867229
            ],
            [
                133,
                316875717
            ],
            [
                134,
                316884872
            ],
            [
                135,
                316908269
            ],
            [
                136,
                316940235
            ],
            [
                137,
                316957122
            ],
            [
                138,
                316962180
            ],
            [
                139,
                316967933
            ],
            [
                140,
                316973197
            ],
            [
                141,
                316979453
            ],
            [
                142,
                316988082
            ],
            [
                143,
                317001811
            ],
            [
                144,
                317011114
            ],
            [
                145,
                317015244
            ],
            [
                146,
                317017651
            ],
            [
                147,
                317020471
            ],
            [
                148,
                317023851
            ]
        ],
        name: 'indianajones4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Indiana Jones and the Kingdom of the Crystal Skull',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#66482A'
        },
        showlabel: false,
        color: 'rgba(52,152,219,0.75)',
        linkedTo: 'Period'
    }, {
        data: [
            [
                1,
                18214211
            ],
            [
                2,
                27917978
            ],
            [
                3,
                42150919
            ],
            [
                4,
                59213690
            ],
            [
                5,
                75129468
            ],
            [
                6,
                82462416
            ],
            [
                7,
                94032719
            ],
            [
                8,
                106146821
            ],
            [
                9,
                117166830
            ],
            [
                10,
                129734559
            ],
            [
                11,
                143733272
            ],
            [
                12,
                155862412
            ],
            [
                13,
                163871215
            ],
            [
                14,
                174119499
            ],
            [
                15,
                178735912
            ],
            [
                16,
                182503422
            ],
            [
                17,
                189286662
            ],
            [
                18,
                199400725
            ],
            [
                19,
                205509869
            ],
            [
                20,
                207220679
            ],
            [
                21,
                209199151
            ],
            [
                22,
                210724501
            ],
            [
                23,
                212119615
            ],
            [
                24,
                216360664
            ],
            [
                25,
                223628781
            ],
            [
                26,
                228320875
            ],
            [
                27,
                229458069
            ],
            [
                28,
                230763390
            ],
            [
                29,
                231848287
            ],
            [
                30,
                232944803
            ],
            [
                31,
                236146861
            ],
            [
                32,
                241181693
            ],
            [
                33,
                245418551
            ],
            [
                34,
                248212887
            ],
            [
                35,
                249125207
            ],
            [
                36,
                249870396
            ],
            [
                37,
                250646197
            ],
            [
                38,
                252650703
            ],
            [
                39,
                256408014
            ],
            [
                40,
                258449272
            ],
            [
                41,
                258972325
            ],
            [
                42,
                259564736
            ],
            [
                43,
                260065515
            ],
            [
                44,
                260569940
            ],
            [
                45,
                262061227
            ],
            [
                46,
                265028400
            ],
            [
                47,
                266274199
            ],
            [
                48,
                266634660
            ],
            [
                49,
                267051095
            ],
            [
                50,
                267426402
            ],
            [
                51,
                267798522
            ],
            [
                52,
                268613461
            ],
            [
                53,
                270287299
            ],
            [
                54,
                271416919
            ],
            [
                55,
                271678039
            ],
            [
                56,
                272009551
            ],
            [
                57,
                272335213
            ],
            [
                58,
                272933520
            ],
            [
                59,
                273982492
            ],
            [
                60,
                275987527
            ],
            [
                61,
                277635371
            ],
            [
                62,
                278643479
            ],
            [
                63,
                279053435
            ],
            [
                64,
                279383472
            ],
            [
                65,
                279733224
            ],
            [
                66,
                280611371
            ],
            [
                67,
                282274437
            ],
            [
                68,
                283191086
            ],
            [
                69,
                283439555
            ],
            [
                70,
                283725189
            ],
            [
                71,
                283980036
            ],
            [
                72,
                284255274
            ],
            [
                73,
                285028889
            ],
            [
                74,
                286550224
            ],
            [
                75,
                287573505
            ],
            [
                76,
                287793921
            ],
            [
                77,
                288015368
            ],
            [
                78,
                288247249
            ],
            [
                79,
                288466140
            ],
            [
                80,
                289117024
            ],
            [
                81,
                290345822
            ],
            [
                82,
                291149457
            ],
            [
                83,
                291397393
            ],
            [
                84,
                291698724
            ],
            [
                85,
                291954083
            ],
            [
                86,
                292225469
            ],
            [
                87,
                292780505
            ],
            [
                88,
                293759416
            ],
            [
                89,
                294343844
            ],
            [
                90,
                294536807
            ],
            [
                91,
                294761211
            ],
            [
                92,
                294959855
            ],
            [
                93,
                295167094
            ],
            [
                94,
                295761611
            ],
            [
                95,
                296898111
            ],
            [
                96,
                297530963
            ],
            [
                97,
                297863424
            ],
            [
                98,
                298214875
            ],
            [
                99,
                298533623
            ],
            [
                100,
                298925611
            ],
            [
                101,
                299815605
            ],
            [
                102,
                300715498
            ],
            [
                103,
                301308405
            ],
            [
                104,
                301626337
            ],
            [
                105,
                301879336
            ],
            [
                106,
                302127053
            ],
            [
                107,
                302376987
            ],
            [
                108,
                302865287
            ],
            [
                109,
                303663977
            ],
            [
                110,
                304117086
            ],
            [
                111,
                304231971
            ],
            [
                112,
                304367412
            ],
            [
                113,
                304482005
            ],
            [
                114,
                304600196
            ],
            [
                115,
                304922474
            ],
            [
                116,
                305493494
            ],
            [
                117,
                305819565
            ],
            [
                118,
                305918289
            ],
            [
                119,
                306026089
            ],
            [
                120,
                306127295
            ],
            [
                121,
                306227803
            ],
            [
                122,
                306428359
            ],
            [
                123,
                306779401
            ],
            [
                124,
                306999514
            ],
            [
                125,
                307069848
            ],
            [
                126,
                307139232
            ],
            [
                127,
                307206614
            ],
            [
                128,
                307280989
            ],
            [
                129,
                307483063
            ],
            [
                130,
                307847506
            ],
            [
                131,
                308078986
            ],
            [
                132,
                308138976
            ],
            [
                133,
                308206809
            ],
            [
                134,
                308270024
            ],
            [
                135,
                308339923
            ],
            [
                136,
                308465760
            ],
            [
                137,
                308676646
            ],
            [
                138,
                308791984
            ],
            [
                139,
                308830801
            ],
            [
                140,
                308876955
            ],
            [
                141,
                308922997
            ],
            [
                142,
                308969505
            ],
            [
                143,
                309088667
            ],
            [
                144,
                309311604
            ],
            [
                145,
                309471992
            ],
            [
                146,
                309525292
            ],
            [
                147,
                309580527
            ],
            [
                148,
                309628015
            ],
            [
                149,
                309667455
            ],
            [
                150,
                309782946
            ],
            [
                151,
                309963394
            ],
            [
                152,
                310078970
            ],
            [
                153,
                310133112
            ],
            [
                154,
                310179026
            ],
            [
                155,
                310222355
            ],
            [
                156,
                310271162
            ],
            [
                157,
                310362593
            ],
            [
                158,
                310504608
            ],
            [
                159,
                310629729
            ],
            [
                160,
                310714976
            ],
            [
                161,
                310748649
            ],
            [
                162,
                310786475
            ],
            [
                163,
                310828464
            ],
            [
                164,
                310886798
            ],
            [
                165,
                310989427
            ],
            [
                166,
                311053126
            ],
            [
                167,
                311081433
            ],
            [
                168,
                311113397
            ],
            [
                169,
                311147689
            ],
            [
                170,
                311184032
            ],
            [
                171,
                311246222
            ],
            [
                172,
                311335761
            ],
            [
                173,
                311407091
            ],
            [
                174,
                311434605
            ],
            [
                175,
                311462267
            ],
            [
                176,
                311492378
            ],
            [
                177,
                311526299
            ],
            [
                178,
                311575180
            ],
            [
                179,
                311646903
            ],
            [
                180,
                311705137
            ],
            [
                181,
                311736668
            ],
            [
                182,
                311771987
            ],
            [
                183,
                311826109
            ],
            [
                184,
                311858003
            ],
            [
                185,
                311902555
            ],
            [
                186,
                311965843
            ],
            [
                187,
                312014743
            ],
            [
                188,
                312040997
            ],
            [
                189,
                312070162
            ],
            [
                190,
                312097359
            ],
            [
                191,
                312125121
            ],
            [
                192,
                312165571
            ],
            [
                193,
                312225076
            ],
            [
                194,
                312274288
            ],
            [
                195,
                312306244
            ],
            [
                196,
                312336655
            ],
            [
                197,
                312366691
            ],
            [
                198,
                312399410
            ],
            [
                199,
                312446317
            ],
            [
                200,
                312502949
            ],
            [
                201,
                312549779
            ],
            [
                202,
                312574107
            ],
            [
                203,
                312599492
            ],
            [
                204,
                312624038
            ],
            [
                205,
                312647842
            ],
            [
                206,
                312679768
            ],
            [
                207,
                312724952
            ],
            [
                208,
                312762385
            ],
            [
                209,
                312785014
            ],
            [
                210,
                312809420
            ],
            [
                211,
                312835485
            ],
            [
                212,
                312858953
            ],
            [
                213,
                312889746
            ],
            [
                214,
                312931609
            ],
            [
                215,
                312965191
            ],
            [
                216,
                312981725
            ],
            [
                217,
                312998413
            ],
            [
                218,
                313014525
            ],
            [
                219,
                313030186
            ],
            [
                220,
                313053700
            ],
            [
                221,
                313085459
            ],
            [
                222,
                313111364
            ],
            [
                223,
                313126238
            ],
            [
                224,
                313141224
            ],
            [
                225,
                313157022
            ],
            [
                226,
                313171091
            ],
            [
                227,
                313191320
            ],
            [
                228,
                313217919
            ],
            [
                229,
                313240158
            ],
            [
                230,
                313252506
            ],
            [
                231,
                313261753
            ],
            [
                232,
                313270081
            ],
            [
                233,
                313278429
            ],
            [
                234,
                313292105
            ],
            [
                235,
                313309541
            ],
            [
                236,
                313322223
            ],
            [
                237,
                313328131
            ],
            [
                238,
                313334484
            ],
            [
                239,
                313340498
            ],
            [
                240,
                313346080
            ],
            [
                241,
                313351478
            ],
            [
                242,
                313359131
            ],
            [
                243,
                313364114
            ]
        ],
        name: 'fellowshipofthering',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Lord of the Rings: The Fellowship of the Ring',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#58573F'
        },
        showlabel: true,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                51239677
            ],
            [
                2,
                97015847
            ],
            [
                3,
                128122480
            ],
            [
                4,
                137489462
            ],
            [
                5,
                145869697
            ],
            [
                6,
                152821023
            ],
            [
                7,
                159159871
            ],
            [
                8,
                174280820
            ],
            [
                9,
                196923384
            ],
            [
                10,
                211200876
            ],
            [
                11,
                214916361
            ],
            [
                12,
                218481425
            ],
            [
                13,
                221626976
            ],
            [
                14,
                224664803
            ],
            [
                15,
                232214312
            ],
            [
                16,
                243719704
            ],
            [
                17,
                251026061
            ],
            [
                18,
                253241439
            ],
            [
                19,
                255051931
            ],
            [
                20,
                256736686
            ],
            [
                21,
                258576910
            ],
            [
                22,
                263017382
            ],
            [
                23,
                269183356
            ],
            [
                24,
                275035900
            ],
            [
                25,
                279653149
            ],
            [
                26,
                281039167
            ],
            [
                27,
                282259624
            ],
            [
                28,
                283511162
            ],
            [
                29,
                285700361
            ],
            [
                30,
                289182375
            ],
            [
                31,
                291429870
            ],
            [
                32,
                292232099
            ],
            [
                33,
                293059560
            ],
            [
                34,
                293907591
            ],
            [
                35,
                294761184
            ],
            [
                36,
                296103247
            ],
            [
                37,
                298039885
            ],
            [
                38,
                299282390
            ],
            [
                39,
                299820425
            ],
            [
                40,
                300331985
            ],
            [
                41,
                300868500
            ],
            [
                42,
                301338077
            ],
            [
                43,
                302053494
            ],
            [
                44,
                303102635
            ],
            [
                45,
                304210329
            ],
            [
                46,
                304553236
            ],
            [
                47,
                304885151
            ],
            [
                48,
                305185164
            ],
            [
                49,
                305507269
            ],
            [
                50,
                305918235
            ],
            [
                51,
                306512001
            ],
            [
                52,
                306943647
            ],
            [
                53,
                307138110
            ],
            [
                54,
                307318350
            ],
            [
                55,
                307493516
            ],
            [
                56,
                307654463
            ],
            [
                57,
                307869542
            ],
            [
                58,
                308112705
            ],
            [
                59,
                308292777
            ],
            [
                60,
                308530297
            ],
            [
                61,
                308636849
            ],
            [
                62,
                308738470
            ],
            [
                63,
                308844539
            ],
            [
                64,
                308966182
            ],
            [
                65,
                309137177
            ],
            [
                66,
                309237294
            ],
            [
                67,
                309290805
            ],
            [
                68,
                309352020
            ],
            [
                69,
                309407309
            ],
            [
                70,
                309456850
            ],
            [
                71,
                309624997
            ],
            [
                72,
                309846840
            ],
            [
                73,
                310018590
            ],
            [
                74,
                310110316
            ],
            [
                75,
                310218645
            ],
            [
                76,
                310309300
            ],
            [
                77,
                310401849
            ],
            [
                78,
                310538485
            ],
            [
                79,
                310716842
            ],
            [
                80,
                310840824
            ],
            [
                81,
                310908007
            ],
            [
                82,
                310982917
            ],
            [
                83,
                311050651
            ],
            [
                84,
                311115730
            ],
            [
                85,
                311207080
            ],
            [
                86,
                311329563
            ],
            [
                87,
                311417007
            ],
            [
                88,
                311465015
            ],
            [
                89,
                311517683
            ],
            [
                90,
                311564816
            ],
            [
                91,
                311612666
            ],
            [
                92,
                311669468
            ],
            [
                93,
                311750352
            ],
            [
                94,
                311806181
            ],
            [
                95,
                311835512
            ],
            [
                96,
                311870609
            ],
            [
                97,
                311900686
            ],
            [
                98,
                311930555
            ],
            [
                99,
                311965938
            ],
            [
                100,
                312019642
            ],
            [
                101,
                312057433
            ],
            [
                102,
                312074316
            ],
            [
                103,
                312093360
            ],
            [
                104,
                312110161
            ],
            [
                105,
                312128345
            ]
        ],
        name: 'ironman2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Iron Man 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#241D1B'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                30141471
            ],
            [
                2,
                54546228
            ],
            [
                3,
                85799846
            ],
            [
                4,
                110169285
            ],
            [
                5,
                120829626
            ],
            [
                6,
                128332422
            ],
            [
                7,
                134869257
            ],
            [
                8,
                141305821
            ],
            [
                9,
                154093786
            ],
            [
                10,
                172654450
            ],
            [
                11,
                189186353
            ],
            [
                12,
                201309770
            ],
            [
                13,
                204853416
            ],
            [
                14,
                208049699
            ],
            [
                15,
                211321947
            ],
            [
                16,
                216685058
            ],
            [
                17,
                225836569
            ],
            [
                18,
                232324823
            ],
            [
                19,
                234539950
            ],
            [
                20,
                236818662
            ],
            [
                21,
                238923113
            ],
            [
                22,
                241094693
            ],
            [
                23,
                245003772
            ],
            [
                24,
                250707632
            ],
            [
                25,
                255106406
            ],
            [
                26,
                256589714
            ],
            [
                27,
                258244390
            ],
            [
                28,
                259739676
            ],
            [
                29,
                261313924
            ],
            [
                30,
                263723368
            ],
            [
                31,
                267443659
            ],
            [
                32,
                270752531
            ],
            [
                33,
                271762477
            ],
            [
                34,
                272791097
            ],
            [
                35,
                273751880
            ],
            [
                36,
                274677737
            ],
            [
                37,
                276073023
            ],
            [
                38,
                278180486
            ],
            [
                39,
                279828766
            ],
            [
                40,
                280490185
            ],
            [
                41,
                281192626
            ],
            [
                42,
                281883659
            ],
            [
                43,
                282585594
            ],
            [
                44,
                283568538
            ],
            [
                45,
                285027870
            ],
            [
                46,
                286253887
            ],
            [
                47,
                286908009
            ],
            [
                48,
                287529188
            ],
            [
                49,
                288161451
            ],
            [
                50,
                288846797
            ],
            [
                51,
                289679958
            ],
            [
                52,
                290580095
            ],
            [
                53,
                291297451
            ],
            [
                54,
                291583739
            ],
            [
                55,
                291908623
            ],
            [
                56,
                292217280
            ],
            [
                57,
                292535701
            ],
            [
                58,
                292873497
            ],
            [
                59,
                293401606
            ],
            [
                60,
                293817458
            ],
            [
                61,
                293997355
            ],
            [
                62,
                294202821
            ],
            [
                63,
                294394508
            ],
            [
                64,
                294600973
            ],
            [
                65,
                294884882
            ],
            [
                66,
                295293202
            ],
            [
                67,
                295621611
            ],
            [
                68,
                295766859
            ],
            [
                69,
                295924864
            ],
            [
                70,
                296067789
            ],
            [
                71,
                296205467
            ],
            [
                72,
                296415550
            ],
            [
                73,
                296732405
            ],
            [
                74,
                296976622
            ],
            [
                75,
                297089980
            ],
            [
                76,
                297222081
            ],
            [
                77,
                297348895
            ],
            [
                78,
                297480553
            ],
            [
                79,
                297651895
            ],
            [
                80,
                297898706
            ],
            [
                81,
                298104876
            ],
            [
                82,
                298216981
            ],
            [
                83,
                298322651
            ],
            [
                84,
                298409275
            ],
            [
                85,
                298497009
            ],
            [
                86,
                298596134
            ],
            [
                87,
                298738398
            ],
            [
                88,
                298843890
            ],
            [
                89,
                298896119
            ],
            [
                90,
                298957139
            ],
            [
                91,
                299016645
            ],
            [
                92,
                299075352
            ],
            [
                93,
                299172246
            ],
            [
                94,
                299309943
            ],
            [
                95,
                299401865
            ],
            [
                96,
                299451901
            ],
            [
                97,
                299505378
            ],
            [
                98,
                299550832
            ],
            [
                99,
                299602121
            ],
            [
                100,
                299693095
            ],
            [
                101,
                299830077
            ],
            [
                102,
                299916358
            ],
            [
                103,
                299956711
            ],
            [
                104,
                300001541
            ],
            [
                105,
                300039401
            ],
            [
                106,
                300082607
            ],
            [
                107,
                300198119
            ],
            [
                108,
                300372586
            ],
            [
                109,
                300556038
            ],
            [
                110,
                300669374
            ],
            [
                111,
                300711690
            ],
            [
                112,
                300736865
            ],
            [
                113,
                300769143
            ],
            [
                114,
                300868386
            ],
            [
                115,
                301042340
            ],
            [
                116,
                301131584
            ],
            [
                117,
                301153647
            ],
            [
                118,
                301184644
            ],
            [
                119,
                301210628
            ],
            [
                120,
                301231528
            ],
            [
                121,
                301305111
            ],
            [
                122,
                301426635
            ],
            [
                123,
                301500502
            ],
            [
                124,
                301517738
            ],
            [
                125,
                301539831
            ],
            [
                126,
                301559423
            ],
            [
                127,
                301575569
            ],
            [
                128,
                301629762
            ],
            [
                129,
                301722126
            ],
            [
                130,
                301765141
            ],
            [
                131,
                301777922
            ],
            [
                132,
                301792673
            ],
            [
                133,
                301803830
            ],
            [
                134,
                301814586
            ],
            [
                135,
                301844770
            ],
            [
                136,
                301894160
            ],
            [
                137,
                301921139
            ],
            [
                138,
                301930941
            ],
            [
                139,
                301938424
            ],
            [
                140,
                301945521
            ],
            [
                141,
                301952557
            ],
            [
                142,
                301976746
            ],
            [
                143,
                302014630
            ],
            [
                144,
                302036290
            ],
            [
                145,
                302043428
            ],
            [
                146,
                302050408
            ],
            [
                147,
                302057316
            ],
            [
                148,
                302063822
            ],
            [
                149,
                302074722
            ],
            [
                150,
                302093611
            ],
            [
                151,
                302105639
            ],
            [
                152,
                302111585
            ],
            [
                153,
                302116635
            ],
            [
                154,
                302121145
            ],
            [
                155,
                302125666
            ],
            [
                156,
                302134096
            ],
            [
                157,
                302147904
            ],
            [
                158,
                302155373
            ],
            [
                159,
                302158244
            ],
            [
                160,
                302162407
            ],
            [
                161,
                302165315
            ],
            [
                162,
                302167664
            ],
            [
                163,
                302172048
            ],
            [
                164,
                302177962
            ],
            [
                165,
                302181179
            ],
            [
                166,
                302181962
            ],
            [
                167,
                302182787
            ],
            [
                168,
                302183567
            ],
            [
                169,
                302184643
            ],
            [
                170,
                302186553
            ],
            [
                171,
                302189606
            ],
            [
                172,
                302191252
            ]
        ],
        name: 'starwars2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Star Wars: Episode II - Attack of the Clones',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#2B1A14'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                0,
                13240044
            ],
            [
                1,
                56150436
            ],
            [
                2,
                93851487
            ],
            [
                3,
                127972864
            ],
            [
                4,
                153042234
            ],
            [
                5,
                160831171
            ],
            [
                6,
                167236619
            ],
            [
                7,
                173339068
            ],
            [
                8,
                186157549
            ],
            [
                9,
                204031150
            ],
            [
                10,
                217545728
            ],
            [
                11,
                221696526
            ],
            [
                12,
                225491113
            ],
            [
                13,
                228969881
            ],
            [
                14,
                232297818
            ],
            [
                15,
                238464654
            ],
            [
                16,
                247400459
            ],
            [
                17,
                253441723
            ],
            [
                18,
                255610936
            ],
            [
                19,
                257687300
            ],
            [
                20,
                259697522
            ],
            [
                21,
                261733724
            ],
            [
                22,
                264956639
            ],
            [
                23,
                270127127
            ],
            [
                24,
                274145510
            ],
            [
                25,
                275607610
            ],
            [
                26,
                277050417
            ],
            [
                27,
                278455146
            ],
            [
                28,
                279799630
            ],
            [
                29,
                281873078
            ],
            [
                30,
                284813425
            ],
            [
                31,
                287001716
            ],
            [
                32,
                287984700
            ],
            [
                33,
                288951288
            ],
            [
                34,
                289838885
            ],
            [
                35,
                290742707
            ],
            [
                36,
                292240304
            ],
            [
                37,
                294223884
            ],
            [
                38,
                295703075
            ],
            [
                39,
                296454390
            ],
            [
                40,
                297184648
            ],
            [
                41,
                298013394
            ],
            [
                42,
                298716729
            ],
            [
                43,
                299675597
            ],
            [
                44,
                300870959
            ],
            [
                45,
                301725691
            ],
            [
                46,
                302156352
            ],
            [
                47,
                302562030
            ],
            [
                48,
                302822845
            ],
            [
                49,
                303057674
            ],
            [
                50,
                303459754
            ],
            [
                51,
                304054987
            ],
            [
                52,
                304454423
            ],
            [
                53,
                304641560
            ],
            [
                54,
                304852581
            ],
            [
                55,
                305073625
            ],
            [
                56,
                305304399
            ],
            [
                57,
                305529295
            ],
            [
                58,
                305828180
            ],
            [
                59,
                306034458
            ],
            [
                60,
                306145052
            ],
            [
                61,
                306263273
            ],
            [
                62,
                306371841
            ],
            [
                63,
                306483088
            ]
        ],
        name: 'piratesofthecaribbean3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Pirates of the Caribbean: At World´s End',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#A5A9B1'
        },
        showlabel: false,
        color: 'rgba(52,152,219,0.75)',
        linkedTo: 'Period'
    }, {
        data: [
            [
                1,
                6219629
            ],
            [
                2,
                10640780
            ],
            [
                3,
                17077785
            ],
            [
                4,
                25220293
            ],
            [
                5,
                33660398
            ],
            [
                6,
                41131399
            ],
            [
                7,
                45311004
            ],
            [
                8,
                49147393
            ],
            [
                9,
                52910693
            ],
            [
                10,
                57995112
            ],
            [
                11,
                64841280
            ],
            [
                12,
                70040387
            ]
        ],
        name: 'starwars6',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Return of the Jedi',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#454952'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                0,
                11124456
            ],
            [
                1,
                28530600
            ],
            [
                2,
                45873988
            ],
            [
                3,
                63619859
            ],
            [
                4,
                81526839
            ],
            [
                5,
                96102252
            ],
            [
                6,
                104327633
            ],
            [
                7,
                112075619
            ],
            [
                8,
                118882629
            ],
            [
                9,
                125070007
            ],
            [
                10,
                135372640
            ],
            [
                11,
                150092784
            ],
            [
                12,
                160312716
            ],
            [
                13,
                165242033
            ],
            [
                14,
                169888490
            ],
            [
                15,
                173838942
            ],
            [
                16,
                177729552
            ],
            [
                17,
                183977018
            ],
            [
                18,
                192848503
            ],
            [
                19,
                199004369
            ],
            [
                20,
                201680625
            ],
            [
                21,
                204619850
            ],
            [
                22,
                206987937
            ],
            [
                23,
                209315796
            ],
            [
                24,
                213304054
            ],
            [
                25,
                219081108
            ],
            [
                26,
                223114893
            ],
            [
                27,
                224939686
            ],
            [
                28,
                227091708
            ],
            [
                29,
                228992170
            ],
            [
                30,
                230877807
            ],
            [
                31,
                234018648
            ],
            [
                32,
                238713751
            ],
            [
                33,
                241874121
            ],
            [
                34,
                243377547
            ],
            [
                35,
                244978607
            ],
            [
                36,
                246465076
            ],
            [
                37,
                248075387
            ],
            [
                38,
                250668099
            ],
            [
                39,
                254309803
            ],
            [
                40,
                256756659
            ],
            [
                41,
                257890467
            ],
            [
                42,
                259195258
            ],
            [
                43,
                260158223
            ],
            [
                44,
                261152823
            ],
            [
                45,
                262844845
            ],
            [
                46,
                265348200
            ],
            [
                47,
                266963804
            ],
            [
                48,
                267663226
            ],
            [
                49,
                268454375
            ],
            [
                50,
                269121565
            ],
            [
                51,
                269765528
            ],
            [
                52,
                271135132
            ],
            [
                53,
                273274156
            ],
            [
                54,
                274504698
            ],
            [
                55,
                274987630
            ],
            [
                56,
                275522137
            ],
            [
                57,
                275976438
            ],
            [
                58,
                276400038
            ],
            [
                59,
                277446078
            ],
            [
                60,
                279179861
            ],
            [
                61,
                280766972
            ],
            [
                62,
                281937276
            ],
            [
                63,
                282253261
            ],
            [
                64,
                282511776
            ],
            [
                65,
                282772244
            ],
            [
                66,
                283526156
            ],
            [
                67,
                284887396
            ],
            [
                68,
                285620448
            ],
            [
                69,
                285796384
            ],
            [
                70,
                286007045
            ],
            [
                71,
                286193535
            ],
            [
                72,
                286380877
            ],
            [
                73,
                286922501
            ],
            [
                74,
                287934743
            ],
            [
                75,
                288445301
            ],
            [
                76,
                288584758
            ],
            [
                77,
                288746103
            ],
            [
                78,
                288882820
            ],
            [
                79,
                289013251
            ],
            [
                80,
                289413006
            ],
            [
                81,
                290178537
            ],
            [
                82,
                290605002
            ],
            [
                83,
                290728315
            ],
            [
                84,
                290848155
            ],
            [
                85,
                290957159
            ],
            [
                86,
                291066712
            ],
            [
                87,
                291668729
            ],
            [
                88,
                293063270
            ],
            [
                89,
                293617050
            ],
            [
                90,
                293769650
            ],
            [
                91,
                293935887
            ],
            [
                92,
                294088865
            ],
            [
                93,
                294249633
            ],
            [
                94,
                294671649
            ],
            [
                95,
                295322301
            ],
            [
                96,
                295730534
            ],
            [
                97,
                295828008
            ],
            [
                98,
                295937119
            ],
            [
                99,
                296032463
            ],
            [
                100,
                296136850
            ],
            [
                101,
                296498152
            ],
            [
                102,
                297037832
            ],
            [
                103,
                297433529
            ],
            [
                104,
                297576603
            ],
            [
                105,
                297682856
            ],
            [
                106,
                297775308
            ],
            [
                107,
                297868700
            ],
            [
                108,
                298243419
            ],
            [
                109,
                298835529
            ],
            [
                110,
                299213307
            ],
            [
                111,
                299320102
            ],
            [
                112,
                299431580
            ],
            [
                113,
                299543526
            ],
            [
                114,
                299663286
            ],
            [
                115,
                300012195
            ],
            [
                116,
                300515804
            ],
            [
                117,
                300880790
            ],
            [
                118,
                300976256
            ],
            [
                119,
                301072525
            ],
            [
                120,
                301162259
            ],
            [
                121,
                301277435
            ],
            [
                122,
                301544357
            ],
            [
                123,
                301990137
            ],
            [
                124,
                302279158
            ],
            [
                125,
                302361863
            ],
            [
                126,
                302456009
            ],
            [
                127,
                302559882
            ],
            [
                128,
                302646582
            ],
            [
                129,
                302914872
            ],
            [
                130,
                303321818
            ],
            [
                131,
                303624796
            ],
            [
                132,
                303765283
            ],
            [
                133,
                303842991
            ],
            [
                134,
                303917484
            ],
            [
                135,
                303993137
            ],
            [
                136,
                304197904
            ],
            [
                137,
                304522020
            ],
            [
                138,
                304738610
            ],
            [
                139,
                304801306
            ],
            [
                140,
                304867542
            ],
            [
                141,
                304933756
            ],
            [
                142,
                304995909
            ],
            [
                143,
                305111670
            ],
            [
                144,
                305298852
            ],
            [
                145,
                305400802
            ],
            [
                146,
                305437950
            ],
            [
                147,
                305480542
            ],
            [
                148,
                305532022
            ],
            [
                149,
                305596124
            ],
            [
                150,
                305707739
            ],
            [
                151,
                305824658
            ],
            [
                152,
                305891406
            ],
            [
                153,
                305910670
            ],
            [
                154,
                305929498
            ],
            [
                155,
                305946139
            ],
            [
                156,
                305961447
            ],
            [
                157,
                305986656
            ],
            [
                158,
                306030870
            ],
            [
                159,
                306052958
            ],
            [
                160,
                306061180
            ],
            [
                161,
                306070178
            ],
            [
                162,
                306078426
            ],
            [
                163,
                306087290
            ],
            [
                164,
                306097177
            ],
            [
                165,
                306114229
            ],
            [
                166,
                306124059
            ],
            [
                167,
                306127449
            ],
            [
                168,
                306131020
            ],
            [
                169,
                306134277
            ],
            [
                170,
                306137970
            ],
            [
                171,
                306139294
            ],
            [
                172,
                306141398
            ],
            [
                173,
                306143214
            ],
            [
                174,
                306144389
            ],
            [
                175,
                306144894
            ],
            [
                176,
                306145801
            ],
            [
                177,
                306146846
            ],
            [
                178,
                306148796
            ],
            [
                179,
                306151575
            ],
            [
                180,
                306153456
            ],
            [
                181,
                306154976
            ],
            [
                182,
                306156090
            ],
            [
                183,
                306157684
            ],
            [
                184,
                306158924
            ],
            [
                185,
                306161785
            ],
            [
                186,
                306164608
            ],
            [
                187,
                306167040
            ],
            [
                188,
                306168070
            ],
            [
                189,
                306168550
            ],
            [
                190,
                306168871
            ],
            [
                191,
                306169231
            ],
            [
                192,
                306169239
            ],
            [
                193,
                306169252
            ],
            [
                194,
                306169255
            ]
        ],
        name: 'independenceday',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Independence Day',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#494941'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                13509262
            ],
            [
                2,
                23995281
            ],
            [
                3,
                38836375
            ],
            [
                4,
                56251068
            ],
            [
                5,
                70625971
            ],
            [
                6,
                78130538
            ],
            [
                7,
                85481675
            ],
            [
                8,
                92538277
            ],
            [
                9,
                98972817
            ],
            [
                10,
                109478015
            ],
            [
                11,
                122573429
            ],
            [
                12,
                133007414
            ],
            [
                13,
                138339699
            ],
            [
                14,
                143788932
            ],
            [
                15,
                148870944
            ],
            [
                16,
                153702126
            ],
            [
                17,
                160516745
            ],
            [
                18,
                169482545
            ],
            [
                19,
                176838155
            ],
            [
                20,
                180420744
            ],
            [
                21,
                184016944
            ],
            [
                22,
                187291717
            ],
            [
                23,
                190687248
            ],
            [
                24,
                196338959
            ],
            [
                25,
                203744844
            ],
            [
                26,
                209531292
            ],
            [
                27,
                212373229
            ],
            [
                28,
                215120764
            ],
            [
                29,
                217413683
            ],
            [
                30,
                219728159
            ],
            [
                31,
                223521426
            ],
            [
                32,
                228804295
            ],
            [
                33,
                232750629
            ],
            [
                34,
                234585563
            ],
            [
                35,
                236438631
            ],
            [
                36,
                238090433
            ],
            [
                37,
                239553386
            ],
            [
                38,
                242116801
            ],
            [
                39,
                245975424
            ],
            [
                40,
                248720985
            ],
            [
                41,
                249988792
            ],
            [
                42,
                251296996
            ],
            [
                43,
                252455172
            ],
            [
                44,
                253650250
            ],
            [
                45,
                255823530
            ],
            [
                46,
                258852271
            ],
            [
                47,
                260925697
            ],
            [
                48,
                261760515
            ],
            [
                49,
                262672512
            ],
            [
                50,
                263453833
            ],
            [
                51,
                264199762
            ],
            [
                52,
                266115664
            ],
            [
                53,
                269082937
            ],
            [
                54,
                272169924
            ],
            [
                55,
                275018547
            ],
            [
                56,
                275611442
            ],
            [
                57,
                276102480
            ],
            [
                58,
                276559924
            ],
            [
                59,
                277987309
            ],
            [
                60,
                280440199
            ],
            [
                61,
                281831452
            ],
            [
                62,
                282167858
            ],
            [
                63,
                282601728
            ],
            [
                64,
                282976937
            ],
            [
                65,
                283377972
            ],
            [
                66,
                284540875
            ],
            [
                67,
                286723991
            ],
            [
                68,
                287884372
            ],
            [
                69,
                288140777
            ],
            [
                70,
                288449559
            ],
            [
                71,
                288726283
            ],
            [
                72,
                289014944
            ],
            [
                73,
                290042859
            ],
            [
                74,
                291635655
            ],
            [
                75,
                292495912
            ],
            [
                76,
                292694592
            ],
            [
                77,
                292935283
            ],
            [
                78,
                293134595
            ],
            [
                79,
                293338779
            ],
            [
                80,
                293966591
            ],
            [
                81,
                295087048
            ],
            [
                82,
                295713028
            ],
            [
                83,
                295854512
            ],
            [
                84,
                296019087
            ],
            [
                85,
                296160106
            ],
            [
                86,
                296301501
            ],
            [
                87,
                296736901
            ],
            [
                88,
                297512007
            ],
            [
                89,
                297930745
            ],
            [
                90,
                298063982
            ],
            [
                91,
                298199474
            ],
            [
                93,
                298446752
            ],
            [
                94,
                298719251
            ],
            [
                95,
                299170254
            ],
            [
                96,
                299468874
            ],
            [
                97,
                299645669
            ],
            [
                98,
                299744461
            ],
            [
                99,
                299815192
            ],
            [
                100,
                299903856
            ],
            [
                101,
                300086778
            ],
            [
                102,
                300384744
            ],
            [
                103,
                300557571
            ],
            [
                104,
                300606406
            ],
            [
                105,
                300658188
            ],
            [
                106,
                300706564
            ],
            [
                107,
                300761777
            ],
            [
                108,
                300891777
            ],
            [
                109,
                301103000
            ],
            [
                110,
                301243790
            ],
            [
                115,
                301485093
            ],
            [
                116,
                301694093
            ],
            [
                117,
                301823371
            ],
            [
                122,
                302122298
            ],
            [
                123,
                302415298
            ],
            [
                124,
                302609731
            ],
            [
                125,
                302703731
            ],
            [
                126,
                302845731
            ],
            [
                127,
                302908731
            ],
            [
                128,
                302977271
            ]
        ],
        name: 'piratesofthecaribbean',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Pirates of the Caribbean: The Curse of the Black Pearl',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#493427'
        },
        showlabel: false,
        color: 'rgba(52,152,219,0.75)',
        linkedTo: 'Period'
    }, {
        data: [
            [
                0,
                2200000
            ],
            [
                1,
                32704077
            ],
            [
                2,
                66563621
            ],
            [
                3,
                90564714
            ],
            [
                4,
                101892378
            ],
            [
                5,
                109108232
            ],
            [
                6,
                114650165
            ],
            [
                7,
                119837108
            ],
            [
                8,
                132089864
            ],
            [
                9,
                149776859
            ],
            [
                10,
                160941621
            ],
            [
                11,
                164955549
            ],
            [
                12,
                170595344
            ],
            [
                13,
                177997320
            ],
            [
                14,
                185641149
            ],
            [
                15,
                200319497
            ],
            [
                16,
                214291699
            ],
            [
                17,
                221144122
            ],
            [
                18,
                223067688
            ],
            [
                19,
                225341845
            ],
            [
                20,
                227164911
            ],
            [
                21,
                229029189
            ],
            [
                22,
                233896096
            ],
            [
                23,
                241539475
            ],
            [
                24,
                245585083
            ],
            [
                25,
                246712819
            ],
            [
                26,
                248219280
            ],
            [
                27,
                249433656
            ],
            [
                28,
                250620080
            ],
            [
                29,
                253742176
            ],
            [
                30,
                258761089
            ],
            [
                31,
                261400281
            ],
            [
                32,
                262288449
            ],
            [
                33,
                263450532
            ],
            [
                34,
                264414319
            ],
            [
                35,
                265366063
            ],
            [
                36,
                267185882
            ],
            [
                37,
                270229938
            ],
            [
                38,
                271921795
            ],
            [
                39,
                272623067
            ],
            [
                40,
                273507818
            ],
            [
                41,
                274250511
            ],
            [
                42,
                275091774
            ],
            [
                43,
                276369660
            ],
            [
                44,
                278284811
            ],
            [
                45,
                279959314
            ],
            [
                46,
                281041059
            ],
            [
                47,
                282400140
            ],
            [
                48,
                283733038
            ],
            [
                49,
                285027378
            ],
            [
                50,
                286502805
            ],
            [
                51,
                288184841
            ],
            [
                52,
                289559202
            ],
            [
                53,
                290904271
            ],
            [
                54,
                292300121
            ],
            [
                55,
                293046816
            ],
            [
                56,
                293729570
            ],
            [
                57,
                294734769
            ],
            [
                58,
                296099935
            ],
            [
                59,
                296804366
            ],
            [
                60,
                297025010
            ],
            [
                61,
                297309483
            ],
            [
                62,
                297549764
            ],
            [
                63,
                297793213
            ],
            [
                64,
                298255456
            ],
            [
                65,
                298988987
            ],
            [
                66,
                299349015
            ],
            [
                67,
                299466261
            ],
            [
                68,
                299627928
            ],
            [
                69,
                299754729
            ],
            [
                70,
                299887074
            ],
            [
                71,
                300149583
            ],
            [
                72,
                300607022
            ],
            [
                73,
                300856315
            ],
            [
                74,
                301030969
            ],
            [
                75,
                301113921
            ],
            [
                76,
                301180024
            ],
            [
                77,
                301252887
            ],
            [
                78,
                301449945
            ],
            [
                79,
                301845386
            ],
            [
                80,
                302044126
            ],
            [
                85,
                302461810
            ],
            [
                86,
                302742675
            ],
            [
                87,
                302823504
            ],
            [
                92,
                303140953
            ],
            [
                93,
                303349880
            ],
            [
                94,
                303460116
            ],
            [
                99,
                303703685
            ],
            [
                100,
                303819941
            ],
            [
                101,
                303898781
            ],
            [
                102,
                303954360
            ],
            [
                106,
                304065789
            ],
            [
                107,
                304135609
            ],
            [
                108,
                304164760
            ]
        ],
        name: 'bond23',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Skyfall',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#262525'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                37125547
            ],
            [
                2,
                64865362
            ],
            [
                3,
                84617303
            ],
            [
                4,
                92355596
            ],
            [
                5,
                100210686
            ],
            [
                6,
                106537873
            ],
            [
                7,
                113152900
            ],
            [
                8,
                123231727
            ],
            [
                9,
                137391893
            ],
            [
                10,
                150041265
            ],
            [
                11,
                156938532
            ],
            [
                12,
                168177061
            ],
            [
                13,
                179565290
            ],
            [
                14,
                189700814
            ],
            [
                15,
                200320148
            ],
            [
                16,
                211908785
            ],
            [
                17,
                221626882
            ],
            [
                18,
                228546604
            ],
            [
                19,
                238001325
            ],
            [
                20,
                242450337
            ],
            [
                21,
                246289507
            ],
            [
                22,
                251461852
            ],
            [
                23,
                259090870
            ],
            [
                24,
                263834893
            ],
            [
                25,
                265146005
            ],
            [
                26,
                266717281
            ],
            [
                27,
                267891777
            ],
            [
                28,
                269044187
            ],
            [
                29,
                271393243
            ],
            [
                30,
                275583907
            ],
            [
                31,
                278212618
            ],
            [
                32,
                278869783
            ],
            [
                33,
                279689070
            ],
            [
                34,
                280327393
            ],
            [
                35,
                280989741
            ],
            [
                36,
                282442200
            ],
            [
                37,
                285262419
            ],
            [
                38,
                287166682
            ],
            [
                39,
                288613051
            ],
            [
                40,
                289121058
            ],
            [
                41,
                289530240
            ],
            [
                42,
                289938470
            ],
            [
                43,
                290655265
            ],
            [
                44,
                292303032
            ],
            [
                45,
                293323831
            ],
            [
                46,
                293562965
            ],
            [
                47,
                293831138
            ],
            [
                48,
                294051480
            ],
            [
                49,
                294292520
            ],
            [
                50,
                294791435
            ],
            [
                51,
                295799649
            ],
            [
                52,
                296193684
            ],
            [
                53,
                296348737
            ],
            [
                54,
                296541937
            ],
            [
                55,
                296696970
            ],
            [
                56,
                296865052
            ],
            [
                57,
                297174579
            ],
            [
                58,
                297877452
            ],
            [
                59,
                298333426
            ],
            [
                60,
                298481792
            ],
            [
                61,
                298609930
            ],
            [
                62,
                298722132
            ],
            [
                63,
                298884345
            ],
            [
                64,
                299101408
            ],
            [
                65,
                299527804
            ],
            [
                66,
                299874706
            ],
            [
                67,
                300161285
            ],
            [
                68,
                300249423
            ],
            [
                69,
                300322891
            ],
            [
                70,
                300401896
            ],
            [
                71,
                300532101
            ],
            [
                72,
                300797269
            ],
            [
                73,
                300952379
            ],
            [
                74,
                300997848
            ],
            [
                75,
                301044732
            ],
            [
                76,
                301085807
            ],
            [
                77,
                301134992
            ],
            [
                78,
                301198249
            ],
            [
                79,
                301324866
            ],
            [
                80,
                301402746
            ],
            [
                81,
                301424668
            ],
            [
                82,
                301451679
            ],
            [
                83,
                301473018
            ],
            [
                84,
                301495997
            ],
            [
                85,
                301592562
            ],
            [
                86,
                301765469
            ],
            [
                87,
                301874933
            ],
            [
                88,
                301921098
            ],
            [
                89,
                301976034
            ],
            [
                90,
                302023697
            ],
            [
                91,
                302075203
            ],
            [
                92,
                302162441
            ],
            [
                93,
                302304675
            ],
            [
                94,
                302393021
            ],
            [
                95,
                302421626
            ],
            [
                96,
                302454449
            ],
            [
                97,
                302485958
            ],
            [
                98,
                302517733
            ],
            [
                99,
                302567059
            ],
            [
                100,
                302648445
            ],
            [
                101,
                302695938
            ],
            [
                102,
                302715735
            ],
            [
                103,
                302738507
            ],
            [
                104,
                302757024
            ],
            [
                105,
                302779925
            ],
            [
                106,
                302805622
            ],
            [
                107,
                302833169
            ],
            [
                108,
                302849493
            ],
            [
                109,
                302860946
            ],
            [
                110,
                302871198
            ],
            [
                111,
                302880835
            ],
            [
                112,
                302893299
            ],
            [
                113,
                302905358
            ],
            [
                114,
                302922520
            ],
            [
                115,
                302932624
            ],
            [
                116,
                302935557
            ],
            [
                117,
                302938604
            ],
            [
                118,
                302941346
            ],
            [
                119,
                302944389
            ],
            [
                120,
                302953301
            ],
            [
                121,
                302966623
            ],
            [
                122,
                302975075
            ],
            [
                123,
                302976741
            ],
            [
                124,
                302978573
            ],
            [
                125,
                302980257
            ],
            [
                126,
                302982412
            ],
            [
                127,
                302988570
            ],
            [
                128,
                302996253
            ],
            [
                129,
                303001229
            ],
            [
                130,
                303001722
            ],
            [
                131,
                303002274
            ],
            [
                132,
                303002765
            ],
            [
                133,
                303003568
            ]
        ],
        name: 'hobbit',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hobbit: An Unexpected Journey',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#35321F'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                58175412
            ],
            [
                2,
                80186627
            ],
            [
                3,
                107007199
            ],
            [
                4,
                136241423
            ],
            [
                5,
                158022354
            ],
            [
                6,
                167946763
            ],
            [
                7,
                177457914
            ],
            [
                8,
                184976152
            ],
            [
                9,
                191833631
            ],
            [
                10,
                201167852
            ],
            [
                11,
                212360848
            ],
            [
                12,
                221295818
            ],
            [
                13,
                225318990
            ],
            [
                14,
                229338358
            ],
            [
                15,
                233920753
            ],
            [
                16,
                237762860
            ],
            [
                17,
                243138489
            ],
            [
                18,
                249893845
            ],
            [
                19,
                255672245
            ],
            [
                20,
                258190624
            ],
            [
                21,
                260610864
            ],
            [
                22,
                262803216
            ],
            [
                23,
                264920284
            ],
            [
                24,
                267502123
            ],
            [
                25,
                270977685
            ],
            [
                26,
                273848633
            ],
            [
                27,
                275140006
            ],
            [
                28,
                276456321
            ],
            [
                29,
                277609743
            ],
            [
                30,
                278737953
            ],
            [
                31,
                280192999
            ],
            [
                32,
                282238071
            ],
            [
                33,
                283879025
            ],
            [
                34,
                284616272
            ],
            [
                35,
                285375636
            ],
            [
                36,
                286072062
            ],
            [
                37,
                286760375
            ],
            [
                38,
                287732054
            ],
            [
                39,
                289167953
            ],
            [
                40,
                290238524
            ],
            [
                41,
                290644750
            ],
            [
                42,
                291051145
            ],
            [
                43,
                291439349
            ],
            [
                44,
                291791652
            ],
            [
                45,
                292431424
            ],
            [
                46,
                293553701
            ],
            [
                47,
                294258075
            ],
            [
                48,
                294486205
            ],
            [
                49,
                294707345
            ],
            [
                50,
                294904348
            ],
            [
                51,
                295112118
            ],
            [
                52,
                295514962
            ],
            [
                53,
                296197431
            ],
            [
                54,
                296940258
            ],
            [
                55,
                297614366
            ],
            [
                56,
                297742596
            ],
            [
                57,
                297839740
            ],
            [
                58,
                297936218
            ],
            [
                59,
                298155342
            ],
            [
                60,
                298588795
            ],
            [
                61,
                298844700
            ],
            [
                62,
                298916152
            ],
            [
                63,
                298989374
            ],
            [
                64,
                299066782
            ],
            [
                65,
                299149308
            ],
            [
                66,
                299251785
            ],
            [
                67,
                299456739
            ],
            [
                68,
                299576295
            ],
            [
                69,
                299609771
            ],
            [
                70,
                299641573
            ],
            [
                71,
                299668923
            ],
            [
                72,
                299695999
            ],
            [
                73,
                299765661
            ],
            [
                74,
                299887119
            ],
            [
                75,
                299967829
            ],
            [
                76,
                299991266
            ],
            [
                77,
                300011724
            ],
            [
                78,
                300033000
            ],
            [
                79,
                300056680
            ],
            [
                80,
                300101273
            ],
            [
                81,
                300181586
            ],
            [
                82,
                300232058
            ],
            [
                83,
                300247445
            ],
            [
                84,
                300261293
            ],
            [
                85,
                300274819
            ],
            [
                86,
                300290780
            ],
            [
                87,
                300397962
            ],
            [
                88,
                300574482
            ],
            [
                89,
                300699217
            ],
            [
                90,
                300761086
            ],
            [
                91,
                300800421
            ],
            [
                92,
                300839206
            ],
            [
                93,
                300880041
            ],
            [
                94,
                300959316
            ],
            [
                95,
                301082222
            ],
            [
                96,
                301153382
            ],
            [
                97,
                301174730
            ],
            [
                98,
                301196318
            ],
            [
                99,
                301216215
            ],
            [
                100,
                301238300
            ],
            [
                101,
                301291184
            ],
            [
                102,
                301370267
            ],
            [
                103,
                301420102
            ],
            [
                104,
                301433060
            ],
            [
                105,
                301447061
            ],
            [
                106,
                301460022
            ],
            [
                107,
                301475004
            ],
            [
                108,
                301506475
            ],
            [
                109,
                301540576
            ],
            [
                110,
                301577469
            ],
            [
                111,
                301588168
            ],
            [
                112,
                301599723
            ],
            [
                113,
                301610121
            ],
            [
                114,
                301622718
            ],
            [
                115,
                301646692
            ],
            [
                116,
                301684625
            ],
            [
                117,
                301707444
            ],
            [
                118,
                301714703
            ],
            [
                119,
                301723865
            ],
            [
                120,
                301739556
            ],
            [
                121,
                301747148
            ],
            [
                122,
                301762841
            ],
            [
                123,
                301791769
            ],
            [
                124,
                301809058
            ],
            [
                125,
                301814491
            ],
            [
                126,
                301819516
            ],
            [
                127,
                301826185
            ],
            [
                128,
                301830720
            ],
            [
                129,
                301841030
            ],
            [
                130,
                301856903
            ],
            [
                131,
                301865854
            ],
            [
                132,
                301869544
            ],
            [
                133,
                301873998
            ],
            [
                134,
                301880484
            ],
            [
                135,
                301885585
            ],
            [
                136,
                301898526
            ],
            [
                137,
                301912551
            ],
            [
                138,
                301920409
            ],
            [
                139,
                301922914
            ],
            [
                140,
                301925544
            ],
            [
                141,
                301927039
            ],
            [
                142,
                301930002
            ],
            [
                143,
                301934883
            ],
            [
                144,
                301942780
            ],
            [
                145,
                301948049
            ],
            [
                146,
                301949123
            ],
            [
                147,
                301949939
            ],
            [
                148,
                301950875
            ],
            [
                149,
                301951830
            ],
            [
                150,
                301953306
            ],
            [
                151,
                301955647
            ],
            [
                152,
                301956980
            ],
            [
                153,
                301957434
            ],
            [
                154,
                301958137
            ],
            [
                155,
                301958630
            ],
            [
                156,
                301959197
            ]
        ],
        name: 'harrypotter6',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Half-Blood Prince',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#405055'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                68533840
            ],
            [
                2,
                92744978
            ],
            [
                3,
                120898294
            ],
            [
                4,
                144318923
            ],
            [
                5,
                157577169
            ],
            [
                6,
                176382220
            ],
            [
                7,
                186950082
            ],
            [
                8,
                195731290
            ],
            [
                9,
                203662377
            ],
            [
                10,
                214731017
            ],
            [
                11,
                227019720
            ],
            [
                12,
                235370815
            ],
            [
                13,
                239699029
            ],
            [
                14,
                244209577
            ],
            [
                15,
                247931714
            ],
            [
                16,
                251371417
            ],
            [
                17,
                255835262
            ],
            [
                18,
                260969703
            ],
            [
                19,
                264791897
            ],
            [
                20,
                266828360
            ],
            [
                21,
                268916972
            ],
            [
                22,
                270752885
            ],
            [
                23,
                272641092
            ],
            [
                24,
                274993549
            ],
            [
                25,
                277753614
            ],
            [
                26,
                279827262
            ],
            [
                27,
                280909882
            ],
            [
                28,
                282063266
            ],
            [
                29,
                283126985
            ],
            [
                30,
                284184954
            ],
            [
                31,
                285466740
            ],
            [
                32,
                287003133
            ],
            [
                33,
                288199907
            ],
            [
                34,
                288848358
            ],
            [
                35,
                289545112
            ],
            [
                36,
                290187610
            ],
            [
                37,
                290811608
            ],
            [
                38,
                291535744
            ],
            [
                39,
                292435125
            ],
            [
                40,
                293101870
            ],
            [
                41,
                293491146
            ],
            [
                42,
                293877997
            ],
            [
                43,
                294218322
            ],
            [
                44,
                294562794
            ],
            [
                45,
                294962222
            ],
            [
                46,
                295455581
            ],
            [
                47,
                295842444
            ],
            [
                48,
                296057156
            ],
            [
                49,
                296268343
            ],
            [
                50,
                296459791
            ],
            [
                51,
                296649934
            ],
            [
                52,
                296825113
            ],
            [
                53,
                297053728
            ],
            [
                54,
                297216798
            ],
            [
                55,
                297292615
            ],
            [
                56,
                297368060
            ],
            [
                57,
                297439330
            ],
            [
                58,
                297513099
            ],
            [
                59,
                297661771
            ],
            [
                60,
                297879109
            ],
            [
                61,
                298027752
            ],
            [
                62,
                298087231
            ],
            [
                63,
                298147250
            ],
            [
                64,
                298200597
            ],
            [
                65,
                298253221
            ],
            [
                66,
                298366778
            ],
            [
                67,
                298530255
            ],
            [
                68,
                298687341
            ],
            [
                69,
                298798466
            ],
            [
                70,
                298829151
            ],
            [
                71,
                298859646
            ],
            [
                72,
                298890399
            ],
            [
                73,
                299108366
            ],
            [
                74,
                299435636
            ],
            [
                75,
                299633864
            ],
            [
                76,
                299696897
            ],
            [
                77,
                299762214
            ],
            [
                78,
                299823339
            ],
            [
                79,
                299894595
            ],
            [
                80,
                299955119
            ],
            [
                81,
                300047908
            ],
            [
                82,
                300103072
            ],
            [
                83,
                300120411
            ],
            [
                84,
                300137500
            ],
            [
                85,
                300155447
            ],
            [
                86,
                300174331
            ],
            [
                87,
                300210368
            ],
            [
                88,
                300265329
            ],
            [
                89,
                300298740
            ],
            [
                90,
                300308826
            ],
            [
                91,
                300319854
            ],
            [
                92,
                300330227
            ],
            [
                93,
                300342944
            ],
            [
                94,
                300362570
            ],
            [
                95,
                300393458
            ],
            [
                96,
                300412216
            ],
            [
                97,
                300418145
            ],
            [
                98,
                300424141
            ],
            [
                99,
                300430812
            ],
            [
                100,
                300438766
            ],
            [
                101,
                300451352
            ],
            [
                102,
                300467530
            ],
            [
                103,
                300476779
            ],
            [
                104,
                300482411
            ],
            [
                105,
                300486119
            ],
            [
                106,
                300489847
            ],
            [
                107,
                300494753
            ],
            [
                108,
                300504050
            ],
            [
                109,
                300517057
            ],
            [
                110,
                300523113
            ],
            [
                111,
                300525239
            ],
            [
                112,
                300527315
            ],
            [
                113,
                300529203
            ],
            [
                114,
                300531751
            ]
        ],
        name: 'eclipse',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Twilight Saga: Eclipse',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#20262C'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                72703754
            ],
            [
                2,
                114992635
            ],
            [
                3,
                142839137
            ],
            [
                4,
                153345623
            ],
            [
                5,
                164674318
            ],
            [
                6,
                178873121
            ],
            [
                7,
                188077665
            ],
            [
                8,
                205788929
            ],
            [
                9,
                222312298
            ],
            [
                10,
                230947696
            ],
            [
                11,
                233334668
            ],
            [
                12,
                235729643
            ],
            [
                13,
                237830629
            ],
            [
                14,
                239935424
            ],
            [
                15,
                245049663
            ],
            [
                16,
                251530186
            ],
            [
                17,
                255363052
            ],
            [
                18,
                256392782
            ],
            [
                19,
                257469075
            ],
            [
                20,
                258374906
            ],
            [
                21,
                259360583
            ],
            [
                22,
                261801174
            ],
            [
                23,
                265239569
            ],
            [
                24,
                267320977
            ],
            [
                25,
                268024129
            ],
            [
                26,
                268761019
            ],
            [
                27,
                269469446
            ],
            [
                28,
                270190721
            ],
            [
                29,
                271578179
            ],
            [
                30,
                273220014
            ],
            [
                31,
                274598319
            ],
            [
                32,
                275569901
            ],
            [
                33,
                276620062
            ],
            [
                34,
                277523522
            ],
            [
                35,
                277918499
            ],
            [
                36,
                278580670
            ],
            [
                37,
                279828507
            ],
            [
                38,
                280962758
            ],
            [
                39,
                281919694
            ],
            [
                40,
                282874182
            ],
            [
                41,
                283870180
            ],
            [
                42,
                284512392
            ],
            [
                43,
                285802158
            ],
            [
                44,
                287180562
            ],
            [
                45,
                287954655
            ],
            [
                46,
                288269091
            ],
            [
                47,
                288548185
            ],
            [
                48,
                288798541
            ],
            [
                49,
                289039470
            ],
            [
                50,
                289520696
            ],
            [
                51,
                290277863
            ],
            [
                52,
                290743279
            ],
            [
                53,
                290872087
            ],
            [
                54,
                291013646
            ],
            [
                55,
                291149228
            ],
            [
                56,
                291300411
            ],
            [
                57,
                291550109
            ],
            [
                58,
                291934933
            ],
            [
                59,
                292229350
            ],
            [
                60,
                292434830
            ],
            [
                61,
                292509377
            ],
            [
                62,
                292579491
            ],
            [
                63,
                292661450
            ],
            [
                64,
                292793194
            ],
            [
                65,
                293029562
            ],
            [
                66,
                293175475
            ],
            [
                67,
                293223221
            ],
            [
                68,
                293274586
            ],
            [
                69,
                293326128
            ],
            [
                70,
                293379881
            ],
            [
                71,
                293493968
            ],
            [
                72,
                293688584
            ],
            [
                73,
                293815426
            ],
            [
                74,
                293856559
            ],
            [
                75,
                293897327
            ],
            [
                76,
                293937929
            ],
            [
                77,
                293977961
            ],
            [
                78,
                294054828
            ],
            [
                79,
                294196696
            ],
            [
                80,
                294254358
            ],
            [
                81,
                294283741
            ],
            [
                82,
                294311847
            ],
            [
                83,
                294339517
            ],
            [
                84,
                294372909
            ],
            [
                85,
                294496278
            ],
            [
                86,
                294715959
            ],
            [
                87,
                294931622
            ],
            [
                88,
                295061295
            ],
            [
                89,
                295114155
            ],
            [
                90,
                295165706
            ],
            [
                91,
                295216182
            ],
            [
                92,
                295322462
            ],
            [
                93,
                295494309
            ],
            [
                94,
                295598642
            ],
            [
                95,
                295628917
            ],
            [
                96,
                295659082
            ],
            [
                97,
                295689319
            ],
            [
                98,
                295723151
            ],
            [
                99,
                295798717
            ],
            [
                100,
                295931730
            ],
            [
                101,
                296012199
            ],
            [
                102,
                296035043
            ],
            [
                103,
                296060235
            ],
            [
                104,
                296085333
            ],
            [
                105,
                296113798
            ],
            [
                106,
                296168074
            ],
            [
                107,
                296255680
            ],
            [
                108,
                296301843
            ],
            [
                109,
                296316973
            ],
            [
                110,
                296332608
            ],
            [
                111,
                296348141
            ],
            [
                112,
                296368364
            ],
            [
                113,
                296402028
            ],
            [
                114,
                296453031
            ],
            [
                115,
                296482320
            ],
            [
                116,
                296496490
            ],
            [
                117,
                296512436
            ],
            [
                118,
                296525237
            ],
            [
                119,
                296540598
            ],
            [
                120,
                296564146
            ],
            [
                121,
                296583555
            ],
            [
                122,
                296593070
            ],
            [
                123,
                296596319
            ],
            [
                124,
                296599500
            ],
            [
                125,
                296603020
            ],
            [
                126,
                296607170
            ],
            [
                127,
                296611342
            ],
            [
                128,
                296616705
            ],
            [
                129,
                296619304
            ],
            [
                130,
                296620241
            ],
            [
                131,
                296621418
            ],
            [
                132,
                296622442
            ],
            [
                133,
                296623634
            ]
        ],
        name: 'newmoon',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Twilight Saga: New Moon',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#2C1F14'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                61684550
            ],
            [
                2,
                99910804
            ],
            [
                3,
                125017372
            ],
            [
                4,
                133802832
            ],
            [
                5,
                144067185
            ],
            [
                6,
                158493048
            ],
            [
                7,
                169969028
            ],
            [
                8,
                190801679
            ],
            [
                9,
                209530619
            ],
            [
                10,
                219056129
            ],
            [
                11,
                221395291
            ],
            [
                12,
                223673772
            ],
            [
                13,
                225609158
            ],
            [
                14,
                227500641
            ],
            [
                15,
                232302408
            ],
            [
                16,
                239748482
            ],
            [
                17,
                244519116
            ],
            [
                18,
                245657482
            ],
            [
                19,
                246936701
            ],
            [
                20,
                248066339
            ],
            [
                21,
                249188405
            ],
            [
                22,
                251585745
            ],
            [
                23,
                255337232
            ],
            [
                24,
                257672721
            ],
            [
                25,
                258393849
            ],
            [
                26,
                259196947
            ],
            [
                27,
                259924254
            ],
            [
                28,
                260701257
            ],
            [
                29,
                262021812
            ],
            [
                30,
                264102283
            ],
            [
                31,
                265723618
            ],
            [
                32,
                266686635
            ],
            [
                33,
                267808784
            ],
            [
                34,
                268711916
            ],
            [
                35,
                269818287
            ],
            [
                36,
                270527686
            ],
            [
                37,
                271598360
            ],
            [
                38,
                272994635
            ],
            [
                39,
                274432306
            ],
            [
                40,
                275826603
            ],
            [
                41,
                277314301
            ],
            [
                42,
                278881516
            ],
            [
                43,
                280230127
            ],
            [
                44,
                282101489
            ],
            [
                45,
                283533215
            ],
            [
                46,
                284158711
            ],
            [
                47,
                284606713
            ],
            [
                48,
                284967896
            ],
            [
                49,
                285308372
            ],
            [
                50,
                285951380
            ],
            [
                51,
                287020595
            ],
            [
                52,
                287661770
            ],
            [
                53,
                287833113
            ],
            [
                54,
                288021547
            ],
            [
                55,
                288205868
            ],
            [
                56,
                288404268
            ],
            [
                57,
                288750710
            ],
            [
                58,
                289330955
            ],
            [
                59,
                289803472
            ],
            [
                60,
                290153345
            ],
            [
                61,
                290257461
            ],
            [
                62,
                290349084
            ],
            [
                63,
                290442497
            ],
            [
                64,
                290674124
            ],
            [
                65,
                291122346
            ],
            [
                66,
                291340768
            ],
            [
                67,
                291410780
            ],
            [
                68,
                291483201
            ],
            [
                69,
                291545304
            ],
            [
                70,
                291622563
            ],
            [
                71,
                291759910
            ],
            [
                72,
                292042358
            ],
            [
                73,
                292223492
            ],
            [
                74,
                292264965
            ],
            [
                75,
                292303121
            ],
            [
                76,
                292343711
            ],
            [
                77,
                292387836
            ],
            [
                78,
                292484655
            ],
            [
                79,
                292682197
            ],
            [
                80,
                292761214
            ],
            [
                81,
                292791821
            ],
            [
                82,
                292822346
            ],
            [
                83,
                292853786
            ],
            [
                84,
                292890256
            ],
            [
                85,
                293001182
            ],
            [
                86,
                293214434
            ],
            [
                87,
                293355408
            ],
            [
                88,
                293420257
            ],
            [
                89,
                293461112
            ],
            [
                90,
                293500742
            ],
            [
                91,
                293542749
            ],
            [
                92,
                293628178
            ],
            [
                93,
                293778793
            ],
            [
                94,
                293901794
            ],
            [
                95,
                293989138
            ],
            [
                96,
                294021980
            ],
            [
                97,
                294052852
            ],
            [
                98,
                294086193
            ],
            [
                99,
                294148448
            ],
            [
                100,
                294257582
            ],
            [
                101,
                294325810
            ],
            [
                102,
                294343741
            ],
            [
                103,
                294362857
            ],
            [
                104,
                294381914
            ],
            [
                105,
                294403739
            ],
            [
                106,
                294440029
            ],
            [
                107,
                294512744
            ],
            [
                108,
                294562162
            ],
            [
                109,
                294575505
            ],
            [
                110,
                294588181
            ],
            [
                111,
                294600097
            ],
            [
                112,
                294614753
            ],
            [
                113,
                294642112
            ],
            [
                114,
                294684114
            ],
            [
                115,
                294713608
            ],
            [
                116,
                294723791
            ],
            [
                117,
                294735705
            ],
            [
                118,
                294746666
            ],
            [
                119,
                294758215
            ],
            [
                120,
                294777458
            ],
            [
                121,
                294805913
            ],
            [
                122,
                294825350
            ],
            [
                123,
                294833319
            ],
            [
                124,
                294840890
            ],
            [
                125,
                294848280
            ],
            [
                126,
                294856409
            ],
            [
                127,
                294871962
            ],
            [
                128,
                294897683
            ],
            [
                129,
                294915214
            ],
            [
                130,
                294923279
            ],
            [
                131,
                294929415
            ],
            [
                132,
                294935796
            ],
            [
                133,
                294943653
            ],
            [
                134,
                294953818
            ],
            [
                135,
                294969515
            ],
            [
                136,
                294980434
            ],
            [
                137,
                294985532
            ],
            [
                138,
                294991649
            ],
            [
                139,
                294996114
            ],
            [
                140,
                295001070
            ]
        ],
        name: 'harrypotter7',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Deathly Hallows Part 1',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#303A3F'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                8005000
            ],
            [
                2,
                17655000
            ],
            [
                3,
                26681262
            ],
            [
                4,
                31031574
            ],
            [
                5,
                35452746
            ],
            [
                6,
                39619154
            ],
            [
                7,
                43896663
            ],
            [
                8,
                51516663
            ],
            [
                9,
                61541663
            ],
            [
                10,
                69661654
            ],
            [
                11,
                73207523
            ],
            [
                12,
                76866243
            ],
            [
                13,
                80246377
            ],
            [
                14,
                83556273
            ],
            [
                15,
                90719273
            ],
            [
                16,
                100550273
            ],
            [
                17,
                107506281
            ],
            [
                18,
                110348578
            ],
            [
                19,
                113370529
            ],
            [
                20,
                116110422
            ],
            [
                21,
                118754754
            ],
            [
                22,
                124562754
            ],
            [
                23,
                133094754
            ],
            [
                24,
                138853903
            ],
            [
                25,
                140917446
            ],
            [
                26,
                143097886
            ],
            [
                27,
                145036427
            ],
            [
                28,
                146974136
            ],
            [
                29,
                152327136
            ],
            [
                30,
                160755136
            ],
            [
                31,
                176245282
            ],
            [
                32,
                176245282
            ],
            [
                33,
                177982062
            ],
            [
                34,
                179591126
            ],
            [
                35,
                181153817
            ],
            [
                36,
                186073817
            ],
            [
                37,
                193496817
            ],
            [
                38,
                197665281
            ],
            [
                39,
                198677775
            ],
            [
                40,
                199882162
            ],
            [
                41,
                200964306
            ],
            [
                42,
                202068412
            ],
            [
                43,
                205529412
            ],
            [
                44,
                210366412
            ],
            [
                45,
                213275834
            ],
            [
                46,
                214138418
            ],
            [
                47,
                215085966
            ],
            [
                48,
                215873563
            ],
            [
                49,
                216607083
            ],
            [
                50,
                219018083
            ],
            [
                51,
                223075083
            ],
            [
                52,
                225042276
            ],
            [
                53,
                225613823
            ],
            [
                54,
                226293428
            ],
            [
                55,
                226907907
            ],
            [
                56,
                227522683
            ],
            [
                57,
                229524683
            ],
            [
                58,
                232889683
            ],
            [
                59,
                234547781
            ],
            [
                60,
                235024985
            ],
            [
                61,
                235565790
            ],
            [
                62,
                236062102
            ],
            [
                63,
                236586228
            ],
            [
                64,
                238237228
            ],
            [
                65,
                241036228
            ],
            [
                66,
                242710195
            ],
            [
                67,
                243401213
            ],
            [
                68,
                243841201
            ],
            [
                69,
                244255508
            ],
            [
                70,
                244690218
            ],
            [
                71,
                246110218
            ],
            [
                72,
                248620218
            ],
            [
                73,
                249858389
            ],
            [
                74,
                250208911
            ],
            [
                75,
                250614682
            ],
            [
                76,
                251022731
            ],
            [
                77,
                251443160
            ],
            [
                78,
                252653160
            ],
            [
                79,
                254658160
            ],
            [
                80,
                255501006
            ],
            [
                81,
                255759952
            ],
            [
                82,
                256061004
            ],
            [
                83,
                256335880
            ],
            [
                84,
                256634871
            ],
            [
                85,
                257594871
            ],
            [
                86,
                259089871
            ],
            [
                87,
                259835832
            ],
            [
                88,
                260082710
            ],
            [
                89,
                260380693
            ],
            [
                90,
                260633885
            ],
            [
                91,
                260911157
            ],
            [
                92,
                261831157
            ],
            [
                93,
                263372157
            ],
            [
                94,
                264042695
            ],
            [
                95,
                264214025
            ],
            [
                96,
                264422468
            ],
            [
                97,
                264722351
            ],
            [
                98,
                265179317
            ],
            [
                99,
                265989317
            ],
            [
                100,
                267148317
            ],
            [
                101,
                267741966
            ],
            [
                102,
                267883751
            ],
            [
                103,
                268052104
            ],
            [
                104,
                268203376
            ],
            [
                105,
                268360331
            ],
            [
                106,
                268867331
            ],
            [
                107,
                269648331
            ],
            [
                108,
                269975523
            ],
            [
                109,
                270088655
            ],
            [
                110,
                270256491
            ],
            [
                115,
                272318916
            ],
            [
                116,
                272384180
            ],
            [
                117,
                272453101
            ],
            [
                118,
                272516564
            ],
            [
                119,
                272583384
            ],
            [
                122,
                273549908
            ],
            [
                123,
                273609773
            ],
            [
                124,
                273678296
            ],
            [
                125,
                273744634
            ],
            [
                126,
                273811037
            ],
            [
                129,
                274477963
            ],
            [
                130,
                274523540
            ],
            [
                131,
                274573875
            ],
            [
                132,
                274626246
            ],
            [
                133,
                274685000
            ],
            [
                136,
                275176668
            ],
            [
                137,
                275259526
            ],
            [
                138,
                275355092
            ],
            [
                144,
                275792609
            ],
            [
                145,
                275869900
            ],
            [
                146,
                275949207
            ]
        ],
        name: 'sixthsense',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Sixth Sense',
            genre: 'Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#090B0E'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                21481834
            ],
            [
                2,
                47876153
            ],
            [
                3,
                68108790
            ],
            [
                4,
                74379941
            ],
            [
                5,
                80785838
            ],
            [
                6,
                86902484
            ],
            [
                7,
                93072435
            ],
            [
                8,
                106144174
            ],
            [
                9,
                124004233
            ],
            [
                10,
                137210701
            ],
            [
                11,
                141916287
            ],
            [
                12,
                146819075
            ],
            [
                13,
                151537818
            ],
            [
                14,
                156663709
            ],
            [
                15,
                165462740
            ],
            [
                16,
                178744416
            ],
            [
                17,
                187425989
            ],
            [
                18,
                191041612
            ],
            [
                19,
                195019750
            ],
            [
                20,
                198836362
            ],
            [
                21,
                202776255
            ],
            [
                22,
                208907795
            ],
            [
                23,
                217807796
            ],
            [
                24,
                226268932
            ],
            [
                25,
                229059138
            ],
            [
                26,
                231970466
            ],
            [
                27,
                234660796
            ],
            [
                28,
                237172817
            ],
            [
                29,
                241154244
            ],
            [
                30,
                246187028
            ],
            [
                31,
                250234554
            ],
            [
                32,
                252395385
            ],
            [
                33,
                254967154
            ],
            [
                34,
                256551863
            ],
            [
                35,
                258295305
            ],
            [
                36,
                261015946
            ],
            [
                37,
                262847554
            ],
            [
                38,
                264816694
            ],
            [
                39,
                265851836
            ],
            [
                40,
                267032381
            ],
            [
                41,
                268117384
            ],
            [
                42,
                269119015
            ],
            [
                43,
                270546109
            ],
            [
                44,
                272463580
            ],
            [
                45,
                273834761
            ],
            [
                46,
                274526070
            ],
            [
                47,
                275270868
            ],
            [
                48,
                275822368
            ],
            [
                49,
                276411268
            ],
            [
                50,
                277392723
            ],
            [
                51,
                278669860
            ],
            [
                52,
                279583282
            ],
            [
                53,
                280063791
            ],
            [
                54,
                280774310
            ],
            [
                55,
                281364419
            ],
            [
                56,
                282002924
            ],
            [
                57,
                282510944
            ],
            [
                58,
                283165584
            ],
            [
                59,
                283690231
            ],
            [
                60,
                283945084
            ],
            [
                61,
                284239283
            ],
            [
                62,
                284578994
            ],
            [
                63,
                284878665
            ],
            [
                64,
                285219693
            ],
            [
                65,
                285657523
            ],
            [
                66,
                286053296
            ],
            [
                67,
                286228674
            ],
            [
                68,
                286409185
            ],
            [
                69,
                286578548
            ],
            [
                70,
                286767486
            ],
            [
                102,
                290866563
            ]
        ],
        name: 'up',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Up',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#6C8186'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                21782199
            ],
            [
                2,
                43573807
            ],
            [
                3,
                62785337
            ],
            [
                4,
                72970702
            ],
            [
                5,
                82735839
            ],
            [
                6,
                91595161
            ],
            [
                7,
                100158412
            ],
            [
                8,
                113242131
            ],
            [
                9,
                129755003
            ],
            [
                10,
                142883424
            ],
            [
                11,
                148948901
            ],
            [
                12,
                155017120
            ],
            [
                13,
                160539271
            ],
            [
                14,
                165828496
            ],
            [
                15,
                174022724
            ],
            [
                16,
                184734433
            ],
            [
                17,
                193313741
            ],
            [
                18,
                197603131
            ],
            [
                19,
                201725628
            ],
            [
                20,
                205513834
            ],
            [
                21,
                209132099
            ],
            [
                22,
                214684135
            ],
            [
                23,
                222066943
            ],
            [
                24,
                227637569
            ],
            [
                25,
                230168703
            ],
            [
                26,
                232790746
            ],
            [
                27,
                235007121
            ],
            [
                28,
                237184431
            ],
            [
                29,
                240534666
            ],
            [
                30,
                245109347
            ],
            [
                31,
                248469482
            ],
            [
                32,
                250001841
            ],
            [
                33,
                251543257
            ],
            [
                34,
                252914303
            ],
            [
                35,
                254193415
            ],
            [
                36,
                256369989
            ],
            [
                37,
                259591932
            ],
            [
                38,
                262031594
            ],
            [
                39,
                262995039
            ],
            [
                40,
                263980341
            ],
            [
                41,
                264851540
            ],
            [
                42,
                265643564
            ],
            [
                43,
                267080412
            ],
            [
                44,
                269177315
            ],
            [
                45,
                270519920
            ],
            [
                46,
                271034171
            ],
            [
                47,
                271618513
            ],
            [
                48,
                272091844
            ],
            [
                49,
                272573254
            ],
            [
                50,
                273731041
            ],
            [
                51,
                275428323
            ],
            [
                52,
                277145503
            ],
            [
                53,
                278457609
            ],
            [
                54,
                278786943
            ],
            [
                55,
                279096351
            ],
            [
                56,
                279409588
            ],
            [
                57,
                280240959
            ],
            [
                58,
                281545938
            ],
            [
                59,
                282211978
            ],
            [
                60,
                282423176
            ],
            [
                61,
                282681228
            ],
            [
                62,
                282910644
            ],
            [
                63,
                283162718
            ],
            [
                64,
                283756520
            ],
            [
                65,
                284667199
            ],
            [
                66,
                285129855
            ],
            [
                67,
                285285981
            ],
            [
                68,
                285464113
            ],
            [
                69,
                285630280
            ],
            [
                70,
                285806286
            ],
            [
                71,
                286186454
            ],
            [
                72,
                286752223
            ],
            [
                73,
                287053292
            ],
            [
                74,
                287162351
            ],
            [
                75,
                287286362
            ],
            [
                76,
                287390686
            ],
            [
                77,
                287501168
            ],
            [
                78,
                287747677
            ],
            [
                79,
                288218801
            ],
            [
                80,
                288405376
            ],
            [
                81,
                288473692
            ],
            [
                82,
                288547701
            ],
            [
                83,
                288617960
            ],
            [
                84,
                288691296
            ],
            [
                85,
                288834210
            ],
            [
                86,
                289050885
            ],
            [
                87,
                289183607
            ],
            [
                88,
                289260086
            ],
            [
                89,
                289305974
            ],
            [
                90,
                289350076
            ],
            [
                91,
                289403621
            ],
            [
                92,
                289513715
            ],
            [
                93,
                289675498
            ],
            [
                94,
                289751947
            ],
            [
                95,
                289782527
            ],
            [
                96,
                289814553
            ],
            [
                97,
                289846799
            ],
            [
                98,
                289881124
            ],
            [
                99,
                290032216
            ],
            [
                100,
                290249239
            ],
            [
                101,
                290381264
            ],
            [
                102,
                290432773
            ],
            [
                103,
                290485827
            ],
            [
                104,
                290534298
            ],
            [
                105,
                290585677
            ],
            [
                106,
                290707149
            ],
            [
                107,
                290860263
            ],
            [
                108,
                290948208
            ],
            [
                109,
                290989663
            ],
            [
                110,
                291036750
            ],
            [
                111,
                291081483
            ],
            [
                112,
                291130914
            ],
            [
                113,
                291229134
            ],
            [
                114,
                291372655
            ],
            [
                115,
                291448103
            ],
            [
                116,
                291475429
            ],
            [
                117,
                291506627
            ],
            [
                118,
                291541268
            ],
            [
                119,
                291598079
            ],
            [
                120,
                291673925
            ],
            [
                121,
                291776496
            ],
            [
                122,
                291832593
            ],
            [
                123,
                291851666
            ],
            [
                124,
                291872747
            ],
            [
                125,
                291893655
            ],
            [
                126,
                291914445
            ],
            [
                127,
                291961256
            ],
            [
                128,
                292030157
            ],
            [
                129,
                292068095
            ],
            [
                130,
                292086685
            ],
            [
                131,
                292109784
            ],
            [
                132,
                292134454
            ],
            [
                133,
                292158289
            ],
            [
                134,
                292206346
            ],
            [
                135,
                292256470
            ],
            [
                136,
                292277755
            ],
            [
                137,
                292285843
            ],
            [
                138,
                292295872
            ],
            [
                139,
                292306278
            ],
            [
                140,
                292316474
            ],
            [
                141,
                292337628
            ],
            [
                142,
                292368529
            ],
            [
                143,
                292383900
            ],
            [
                144,
                292390103
            ],
            [
                145,
                292397527
            ],
            [
                146,
                292404654
            ],
            [
                147,
                292412237
            ],
            [
                148,
                292428991
            ],
            [
                149,
                292450670
            ],
            [
                150,
                292462233
            ],
            [
                151,
                292467452
            ],
            [
                152,
                292473458
            ],
            [
                153,
                292479104
            ],
            [
                154,
                292485544
            ],
            [
                155,
                292494108
            ],
            [
                156,
                292504404
            ],
            [
                157,
                292511473
            ],
            [
                158,
                292517082
            ],
            [
                159,
                292522501
            ],
            [
                160,
                292525041
            ],
            [
                161,
                292528592
            ],
            [
                162,
                292531112
            ],
            [
                163,
                292534130
            ],
            [
                164,
                292537649
            ],
            [
                165,
                292541086
            ],
            [
                166,
                292544734
            ],
            [
                167,
                292548316
            ],
            [
                168,
                292553519
            ],
            [
                169,
                292558188
            ],
            [
                170,
                292565212
            ],
            [
                171,
                292568851
            ],
            [
                172,
                292571392
            ],
            [
                173,
                292572697
            ],
            [
                174,
                292574501
            ],
            [
                175,
                292576195
            ]
        ],
        name: 'inception',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Inception',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#2A4452'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                71167839
            ],
            [
                2,
                112610986
            ],
            [
                3,
                141067634
            ],
            [
                4,
                151158344
            ],
            [
                5,
                162930682
            ],
            [
                6,
                175709969
            ],
            [
                7,
                183724670
            ],
            [
                8,
                201270703
            ],
            [
                9,
                218287679
            ],
            [
                10,
                227366118
            ],
            [
                11,
                229919176
            ],
            [
                12,
                232640798
            ],
            [
                13,
                235025078
            ],
            [
                14,
                237182504
            ],
            [
                15,
                242683487
            ],
            [
                16,
                250209035
            ],
            [
                17,
                254598866
            ],
            [
                18,
                255813342
            ],
            [
                19,
                257255379
            ],
            [
                20,
                258392715
            ],
            [
                21,
                259534764
            ],
            [
                22,
                262368468
            ],
            [
                23,
                266338445
            ],
            [
                24,
                268691029
            ],
            [
                25,
                269403203
            ],
            [
                26,
                270260131
            ],
            [
                27,
                270972532
            ],
            [
                28,
                271690069
            ],
            [
                29,
                273174876
            ],
            [
                30,
                275431112
            ],
            [
                31,
                276826143
            ],
            [
                32,
                277349871
            ],
            [
                33,
                277958025
            ],
            [
                34,
                278452299
            ],
            [
                35,
                279005734
            ],
            [
                36,
                279767245
            ],
            [
                37,
                280777073
            ],
            [
                38,
                281632689
            ],
            [
                39,
                281978951
            ],
            [
                40,
                282440200
            ],
            [
                41,
                283023753
            ],
            [
                42,
                283679776
            ],
            [
                43,
                284456103
            ],
            [
                44,
                285314150
            ],
            [
                45,
                286039065
            ],
            [
                46,
                286422893
            ],
            [
                47,
                287027873
            ],
            [
                48,
                287405261
            ],
            [
                49,
                287756286
            ],
            [
                50,
                288206817
            ],
            [
                51,
                288810496
            ],
            [
                52,
                289133356
            ],
            [
                53,
                289235462
            ],
            [
                54,
                289342066
            ],
            [
                55,
                289434980
            ],
            [
                56,
                289529578
            ],
            [
                57,
                289705078
            ],
            [
                58,
                290003237
            ],
            [
                59,
                290177709
            ],
            [
                60,
                290226048
            ],
            [
                61,
                290281174
            ],
            [
                62,
                290330268
            ],
            [
                63,
                290380023
            ],
            [
                64,
                290465049
            ],
            [
                65,
                290611508
            ],
            [
                66,
                290713795
            ],
            [
                67,
                290783012
            ],
            [
                68,
                290808255
            ],
            [
                69,
                290830614
            ],
            [
                70,
                290854955
            ],
            [
                71,
                290906852
            ],
            [
                72,
                291012683
            ],
            [
                73,
                291075689
            ],
            [
                74,
                291093659
            ],
            [
                75,
                291110574
            ],
            [
                76,
                291126795
            ],
            [
                77,
                291145090
            ],
            [
                78,
                291186388
            ],
            [
                79,
                291255883
            ],
            [
                80,
                291281778
            ],
            [
                81,
                291293425
            ],
            [
                82,
                291305993
            ],
            [
                83,
                291317196
            ],
            [
                84,
                291329468
            ],
            [
                85,
                291354213
            ],
            [
                86,
                291402865
            ],
            [
                87,
                291429273
            ],
            [
                88,
                291437864
            ],
            [
                89,
                291445450
            ],
            [
                90,
                291452597
            ],
            [
                91,
                291493506
            ],
            [
                92,
                291562677
            ],
            [
                93,
                291681738
            ],
            [
                94,
                291779219
            ],
            [
                95,
                291838804
            ],
            [
                96,
                291864406
            ],
            [
                97,
                291887115
            ],
            [
                98,
                291910431
            ],
            [
                99,
                291967156
            ],
            [
                100,
                292064574
            ],
            [
                101,
                292123221
            ],
            [
                102,
                292138468
            ],
            [
                103,
                292153900
            ],
            [
                104,
                292169318
            ],
            [
                105,
                292184928
            ],
            [
                106,
                292219306
            ],
            [
                107,
                292270006
            ],
            [
                108,
                292298923
            ],
            [
                109,
                292305827
            ],
            [
                110,
                292312252
            ],
            [
                111,
                292318344
            ],
            [
                112,
                292324737
            ]
        ],
        name: 'breakingdawn2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Twilight Saga: Breaking Dawn Part 2',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#282324'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                44232338
            ],
            [
                2,
                62606743
            ],
            [
                3,
                88448728
            ],
            [
                4,
                116759603
            ],
            [
                5,
                139715157
            ],
            [
                6,
                150130637
            ],
            [
                7,
                159300110
            ],
            [
                8,
                167738316
            ],
            [
                9,
                175355515
            ],
            [
                10,
                185570955
            ],
            [
                11,
                197852087
            ],
            [
                12,
                207866865
            ],
            [
                13,
                212681190
            ],
            [
                14,
                217083411
            ],
            [
                15,
                220998765
            ],
            [
                16,
                224706129
            ],
            [
                17,
                229771951
            ],
            [
                18,
                236845162
            ],
            [
                19,
                242439214
            ],
            [
                20,
                244877588
            ],
            [
                21,
                247191583
            ],
            [
                22,
                249357836
            ],
            [
                23,
                251505177
            ],
            [
                24,
                254167413
            ],
            [
                25,
                257955350
            ],
            [
                26,
                261027397
            ],
            [
                27,
                262654623
            ],
            [
                28,
                264078779
            ],
            [
                29,
                265421089
            ],
            [
                30,
                266615258
            ],
            [
                31,
                268189964
            ],
            [
                32,
                270279145
            ],
            [
                33,
                272047388
            ],
            [
                34,
                272828538
            ],
            [
                35,
                273600922
            ],
            [
                36,
                274339341
            ],
            [
                37,
                275105738
            ],
            [
                38,
                276024166
            ],
            [
                39,
                277478561
            ],
            [
                40,
                278762117
            ],
            [
                41,
                279316414
            ],
            [
                42,
                279874898
            ],
            [
                43,
                280357192
            ],
            [
                44,
                280828522
            ],
            [
                45,
                281449810
            ],
            [
                46,
                282474644
            ],
            [
                47,
                283230934
            ],
            [
                48,
                283497083
            ],
            [
                49,
                283758464
            ],
            [
                50,
                284001859
            ],
            [
                51,
                284250119
            ],
            [
                52,
                284676422
            ],
            [
                53,
                285382001
            ],
            [
                54,
                286143377
            ],
            [
                55,
                286825495
            ],
            [
                56,
                286953794
            ],
            [
                57,
                287061120
            ],
            [
                58,
                287169841
            ],
            [
                59,
                287400025
            ],
            [
                60,
                287872348
            ],
            [
                61,
                288201180
            ],
            [
                62,
                288272389
            ],
            [
                63,
                288352825
            ],
            [
                64,
                288431663
            ],
            [
                65,
                288522854
            ],
            [
                66,
                288709631
            ],
            [
                67,
                289101136
            ],
            [
                68,
                289326081
            ],
            [
                69,
                289378233
            ],
            [
                70,
                289427462
            ],
            [
                71,
                289474993
            ],
            [
                72,
                289527287
            ],
            [
                73,
                289602519
            ],
            [
                74,
                289763733
            ],
            [
                75,
                289855714
            ],
            [
                76,
                289877935
            ],
            [
                77,
                289899666
            ],
            [
                78,
                289923160
            ],
            [
                79,
                289945599
            ],
            [
                80,
                290001838
            ],
            [
                81,
                290109640
            ],
            [
                82,
                290175378
            ],
            [
                83,
                290189393
            ],
            [
                84,
                290204624
            ],
            [
                85,
                290219263
            ],
            [
                86,
                290234807
            ],
            [
                87,
                290327071
            ],
            [
                88,
                290481029
            ],
            [
                89,
                290598256
            ],
            [
                90,
                290657775
            ],
            [
                91,
                290690107
            ],
            [
                92,
                290721282
            ],
            [
                93,
                290753534
            ],
            [
                94,
                290829377
            ],
            [
                95,
                290959632
            ],
            [
                96,
                291041408
            ],
            [
                97,
                291063228
            ],
            [
                98,
                291085520
            ],
            [
                99,
                291107643
            ],
            [
                100,
                291132139
            ],
            [
                101,
                291190799
            ],
            [
                102,
                291287507
            ],
            [
                103,
                291340445
            ],
            [
                104,
                291354592
            ],
            [
                105,
                291371246
            ],
            [
                106,
                291387658
            ],
            [
                107,
                291404188
            ],
            [
                108,
                291444790
            ],
            [
                109,
                291512115
            ],
            [
                110,
                291551968
            ],
            [
                111,
                291562236
            ],
            [
                112,
                291573302
            ],
            [
                113,
                291585591
            ],
            [
                114,
                291597207
            ],
            [
                115,
                291624499
            ],
            [
                116,
                291679480
            ],
            [
                117,
                291704500
            ],
            [
                118,
                291710663
            ],
            [
                119,
                291717080
            ],
            [
                120,
                291722636
            ],
            [
                121,
                291729787
            ],
            [
                122,
                291752116
            ],
            [
                123,
                291787663
            ],
            [
                124,
                291808642
            ],
            [
                125,
                291818699
            ],
            [
                126,
                291822222
            ],
            [
                127,
                291825691
            ],
            [
                128,
                291829680
            ],
            [
                129,
                291843436
            ],
            [
                130,
                291866602
            ],
            [
                131,
                291880420
            ],
            [
                132,
                291884213
            ],
            [
                133,
                291888789
            ],
            [
                134,
                291895526
            ],
            [
                135,
                291899574
            ],
            [
                136,
                291914232
            ],
            [
                137,
                291934860
            ],
            [
                138,
                291946208
            ],
            [
                139,
                291948969
            ],
            [
                140,
                291951868
            ],
            [
                141,
                291954450
            ],
            [
                142,
                291957074
            ],
            [
                143,
                291963190
            ],
            [
                144,
                291972312
            ],
            [
                145,
                291980108
            ],
            [
                146,
                291982804
            ],
            [
                147,
                291985483
            ],
            [
                148,
                291987958
            ],
            [
                149,
                291990592
            ],
            [
                150,
                291993034
            ],
            [
                151,
                291997435
            ],
            [
                152,
                292000866
            ],
            [
                153,
                292001817
            ],
            [
                154,
                292002846
            ],
            [
                155,
                292003714
            ],
            [
                156,
                292004738
            ]
        ],
        name: 'harrypotter5',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Order of the Phoenix',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#292228'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                23006856
            ],
            [
                2,
                48332871
            ],
            [
                3,
                65556312
            ],
            [
                4,
                70159464
            ],
            [
                5,
                74186139
            ],
            [
                6,
                77693647
            ],
            [
                7,
                81331961
            ],
            [
                8,
                90342036
            ],
            [
                9,
                103345544
            ],
            [
                10,
                113169644
            ],
            [
                11,
                117824308
            ],
            [
                12,
                122739357
            ],
            [
                13,
                127679743
            ],
            [
                14,
                133442840
            ],
            [
                15,
                141373715
            ],
            [
                16,
                146114483
            ],
            [
                17,
                153220802
            ],
            [
                18,
                165135135
            ],
            [
                19,
                174359262
            ],
            [
                20,
                183116192
            ],
            [
                21,
                191991322
            ],
            [
                22,
                201694884
            ],
            [
                23,
                209440087
            ],
            [
                24,
                217677877
            ],
            [
                25,
                225703346
            ],
            [
                26,
                228281863
            ],
            [
                27,
                230181967
            ],
            [
                28,
                232134689
            ],
            [
                29,
                236161362
            ],
            [
                30,
                243291068
            ],
            [
                31,
                247777824
            ],
            [
                32,
                248649542
            ],
            [
                33,
                249524985
            ],
            [
                34,
                250357188
            ],
            [
                35,
                251211092
            ],
            [
                36,
                253544785
            ],
            [
                37,
                257928733
            ],
            [
                38,
                261270848
            ],
            [
                39,
                264020859
            ],
            [
                40,
                264587877
            ],
            [
                41,
                265086453
            ],
            [
                42,
                265615568
            ],
            [
                43,
                267056212
            ],
            [
                44,
                270103044
            ],
            [
                45,
                271852138
            ],
            [
                46,
                272245169
            ],
            [
                47,
                272603413
            ],
            [
                48,
                272958563
            ],
            [
                49,
                273362318
            ],
            [
                50,
                274394934
            ],
            [
                51,
                276442471
            ],
            [
                52,
                277867308
            ],
            [
                53,
                278133732
            ],
            [
                54,
                278379730
            ],
            [
                55,
                278613817
            ],
            [
                56,
                278862289
            ],
            [
                57,
                279582921
            ],
            [
                58,
                281305928
            ],
            [
                59,
                281934379
            ],
            [
                60,
                282115799
            ],
            [
                61,
                282292434
            ],
            [
                62,
                282461094
            ],
            [
                63,
                282669443
            ],
            [
                64,
                283128172
            ],
            [
                65,
                284129478
            ],
            [
                66,
                284742799
            ],
            [
                67,
                284905791
            ],
            [
                68,
                285163208
            ],
            [
                69,
                285283677
            ],
            [
                70,
                285418612
            ],
            [
                71,
                285683065
            ],
            [
                72,
                286254179
            ],
            [
                73,
                286745514
            ],
            [
                74,
                287153504
            ],
            [
                75,
                287265777
            ],
            [
                76,
                287371320
            ],
            [
                77,
                287482269
            ]
        ],
        name: 'narnia',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Chronicles of Narnia: The Lion, the Witch and the ' +
                'Wardrobe',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#7B8473'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                0,
                12062124
            ],
            [
                1,
                56075491
            ],
            [
                2,
                92390809
            ],
            [
                3,
                128681486
            ],
            [
                4,
                141266491
            ],
            [
                5,
                152777618
            ],
            [
                6,
                161779897
            ],
            [
                7,
                168790947
            ],
            [
                8,
                181337960
            ],
            [
                9,
                197549357
            ],
            [
                10,
                210078153
            ],
            [
                11,
                214615316
            ],
            [
                12,
                219812745
            ],
            [
                13,
                223924818
            ],
            [
                14,
                227840106
            ],
            [
                15,
                233848694
            ],
            [
                16,
                242212479
            ],
            [
                17,
                248577596
            ],
            [
                18,
                251621616
            ],
            [
                19,
                254405846
            ],
            [
                20,
                256758983
            ],
            [
                21,
                259774153
            ],
            [
                22,
                263680363
            ],
            [
                23,
                267939736
            ],
            [
                24,
                271188450
            ],
            [
                25,
                272461943
            ],
            [
                26,
                273930420
            ],
            [
                27,
                275158775
            ],
            [
                28,
                276169878
            ],
            [
                29,
                277533036
            ],
            [
                30,
                279477877
            ],
            [
                31,
                280888962
            ],
            [
                32,
                281481205
            ],
            [
                33,
                282193653
            ],
            [
                34,
                282735742
            ],
            [
                35,
                283181087
            ],
            [
                36,
                283685516
            ],
            [
                37,
                284430380
            ],
            [
                38,
                285000474
            ],
            [
                39,
                285253826
            ],
            [
                40,
                285574854
            ],
            [
                41,
                285827010
            ],
            [
                42,
                286058272
            ],
            [
                43,
                286271454
            ],
            [
                44,
                286579932
            ],
            [
                45,
                286807505
            ],
            [
                46,
                286912067
            ],
            [
                47,
                287034077
            ],
            [
                48,
                287122365
            ],
            [
                49,
                287214823
            ],
            [
                50,
                287352684
            ],
            [
                51,
                287542311
            ],
            [
                52,
                287681397
            ],
            [
                53,
                287756503
            ],
            [
                54,
                287829106
            ],
            [
                55,
                287879627
            ],
            [
                56,
                287931663
            ],
            [
                57,
                288147988
            ],
            [
                58,
                288446624
            ],
            [
                59,
                288681970
            ],
            [
                60,
                288793806
            ],
            [
                61,
                288923009
            ],
            [
                62,
                289023787
            ],
            [
                63,
                289121541
            ],
            [
                64,
                289267114
            ],
            [
                65,
                289478094
            ],
            [
                66,
                289633849
            ],
            [
                67,
                289694329
            ],
            [
                68,
                289760857
            ],
            [
                69,
                289816740
            ],
            [
                70,
                289875976
            ],
            [
                71,
                289977702
            ],
            [
                72,
                290132377
            ],
            [
                73,
                290229822
            ],
            [
                74,
                290265876
            ],
            [
                75,
                290298851
            ],
            [
                76,
                290327998
            ],
            [
                77,
                290360082
            ],
            [
                78,
                290429085
            ],
            [
                79,
                290539762
            ],
            [
                80,
                290650276
            ],
            [
                81,
                290750257
            ],
            [
                82,
                290769852
            ],
            [
                83,
                290787683
            ],
            [
                84,
                290804657
            ],
            [
                85,
                290835765
            ],
            [
                86,
                290891835
            ],
            [
                87,
                290925471
            ],
            [
                88,
                290933455
            ],
            [
                89,
                290942556
            ],
            [
                90,
                290951711
            ],
            [
                91,
                290960548
            ],
            [
                92,
                290978103
            ],
            [
                93,
                291005463
            ],
            [
                94,
                291021565
            ],
            [
                95,
                291027297
            ],
            [
                96,
                291033976
            ],
            [
                97,
                291039585
            ],
            [
                98,
                291045518
            ]
        ],
        name: 'superman2012',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Man of Steel',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#54555E'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                1333305
            ],
            [
                2,
                2341114
            ],
            [
                3,
                3738470
            ],
            [
                4,
                5473664
            ],
            [
                5,
                7244308
            ],
            [
                6,
                8756918
            ],
            [
                7,
                9612663
            ]
        ],
        name: 'starwars5',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Empire Strikes Back',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#6F6776'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                40118363
            ],
            [
                2,
                76837498
            ],
            [
                3,
                102685961
            ],
            [
                4,
                110741182
            ],
            [
                5,
                119743524
            ],
            [
                6,
                133873907
            ],
            [
                7,
                146283069
            ],
            [
                8,
                169054371
            ],
            [
                9,
                189258709
            ],
            [
                10,
                201010207
            ],
            [
                11,
                203451580
            ],
            [
                12,
                205596807
            ],
            [
                13,
                207544120
            ],
            [
                14,
                209388580
            ],
            [
                15,
                214759672
            ],
            [
                16,
                223645889
            ],
            [
                17,
                229266716
            ],
            [
                18,
                230406014
            ],
            [
                19,
                231560213
            ],
            [
                20,
                232682657
            ],
            [
                21,
                233803862
            ],
            [
                22,
                236505381
            ],
            [
                23,
                241081967
            ],
            [
                24,
                244069305
            ],
            [
                25,
                244763756
            ],
            [
                26,
                245469136
            ],
            [
                27,
                246064434
            ],
            [
                28,
                246645807
            ],
            [
                29,
                248143019
            ],
            [
                30,
                250661379
            ],
            [
                31,
                252598259
            ],
            [
                32,
                253482480
            ],
            [
                33,
                254485801
            ],
            [
                34,
                255492998
            ],
            [
                35,
                256715413
            ],
            [
                36,
                258323753
            ],
            [
                37,
                259322733
            ],
            [
                38,
                260631396
            ],
            [
                39,
                263139532
            ],
            [
                40,
                265344891
            ],
            [
                41,
                267407264
            ],
            [
                42,
                269447715
            ],
            [
                43,
                271513749
            ],
            [
                44,
                273281180
            ],
            [
                45,
                275132632
            ],
            [
                46,
                277083157
            ],
            [
                47,
                277724469
            ],
            [
                48,
                278194876
            ],
            [
                49,
                278658114
            ],
            [
                50,
                279361975
            ],
            [
                51,
                280587070
            ],
            [
                52,
                281516498
            ],
            [
                53,
                281694723
            ],
            [
                54,
                281877727
            ],
            [
                55,
                282050064
            ],
            [
                56,
                282228377
            ],
            [
                57,
                282537890
            ],
            [
                58,
                283257991
            ],
            [
                59,
                283872840
            ],
            [
                60,
                284361860
            ],
            [
                61,
                284462320
            ],
            [
                62,
                284553620
            ],
            [
                63,
                284649794
            ],
            [
                64,
                284819289
            ],
            [
                65,
                285258059
            ],
            [
                66,
                285538219
            ],
            [
                67,
                285594228
            ],
            [
                68,
                285646194
            ],
            [
                69,
                285704252
            ],
            [
                70,
                285762909
            ],
            [
                71,
                285864352
            ],
            [
                72,
                286114734
            ],
            [
                73,
                286301035
            ],
            [
                74,
                286335255
            ],
            [
                75,
                286368477
            ],
            [
                76,
                286400914
            ],
            [
                77,
                286435732
            ],
            [
                78,
                286526288
            ],
            [
                79,
                286731761
            ],
            [
                80,
                286822905
            ],
            [
                81,
                286844768
            ],
            [
                82,
                286868174
            ],
            [
                83,
                286891550
            ],
            [
                84,
                286919411
            ],
            [
                85,
                286979339
            ],
            [
                86,
                287109964
            ],
            [
                87,
                287180682
            ],
            [
                88,
                287199126
            ],
            [
                89,
                287228711
            ],
            [
                90,
                287246765
            ],
            [
                91,
                287265347
            ],
            [
                92,
                287403465
            ],
            [
                93,
                287688005
            ],
            [
                94,
                287917479
            ],
            [
                95,
                288060759
            ],
            [
                96,
                288116995
            ],
            [
                97,
                288167238
            ],
            [
                98,
                288218866
            ],
            [
                99,
                288346874
            ],
            [
                100,
                288584493
            ],
            [
                101,
                288733970
            ],
            [
                102,
                288768020
            ],
            [
                103,
                288801149
            ],
            [
                104,
                288832035
            ],
            [
                105,
                288870728
            ],
            [
                106,
                288945835
            ],
            [
                107,
                289094189
            ],
            [
                108,
                289188779
            ],
            [
                109,
                289210520
            ],
            [
                110,
                289231066
            ],
            [
                111,
                289249651
            ],
            [
                112,
                289271112
            ],
            [
                113,
                289321661
            ],
            [
                114,
                289413229
            ],
            [
                115,
                289472171
            ],
            [
                116,
                289489093
            ],
            [
                117,
                289509862
            ],
            [
                118,
                289527647
            ],
            [
                119,
                289546416
            ],
            [
                120,
                289590103
            ],
            [
                121,
                289663408
            ],
            [
                122,
                289710552
            ],
            [
                123,
                289719985
            ],
            [
                124,
                289730990
            ],
            [
                125,
                289740529
            ],
            [
                126,
                289751002
            ],
            [
                127,
                289785952
            ],
            [
                128,
                289842397
            ],
            [
                129,
                289877755
            ],
            [
                130,
                289884829
            ],
            [
                131,
                289893302
            ],
            [
                132,
                289900226
            ],
            [
                133,
                289908213
            ],
            [
                134,
                289932678
            ],
            [
                135,
                289971061
            ],
            [
                136,
                289994397
            ],
            [
                137,
                289998641
            ],
            [
                138,
                290004148
            ],
            [
                139,
                290008164
            ],
            [
                140,
                290013036
            ]
        ],
        name: 'harrypotter4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Goblet of Fire',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#1C262B'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                17806294
            ],
            [
                2,
                44336578
            ],
            [
                3,
                62577067
            ],
            [
                4,
                66324282
            ],
            [
                5,
                70375603
            ],
            [
                6,
                73265584
            ],
            [
                7,
                76599345
            ],
            [
                8,
                87957717
            ],
            [
                9,
                107752209
            ],
            [
                10,
                122150373
            ],
            [
                11,
                128884312
            ],
            [
                12,
                130559368
            ],
            [
                13,
                132075351
            ],
            [
                14,
                133624433
            ],
            [
                15,
                139381561
            ],
            [
                16,
                149648898
            ],
            [
                17,
                156341118
            ],
            [
                18,
                157743626
            ],
            [
                19,
                159711222
            ],
            [
                20,
                163713833
            ],
            [
                21,
                168174824
            ],
            [
                22,
                178088639
            ],
            [
                23,
                187387850
            ],
            [
                24,
                192229825
            ],
            [
                25,
                193010497
            ],
            [
                26,
                193702361
            ],
            [
                27,
                194288867
            ],
            [
                28,
                194920064
            ],
            [
                29,
                197176459
            ],
            [
                30,
                201402277
            ],
            [
                31,
                204025728
            ],
            [
                32,
                204434943
            ],
            [
                33,
                204906369
            ],
            [
                34,
                205334355
            ],
            [
                35,
                205793571
            ],
            [
                36,
                207390778
            ],
            [
                37,
                210538427
            ],
            [
                38,
                212391025
            ],
            [
                39,
                212729515
            ],
            [
                40,
                213112345
            ],
            [
                41,
                213472323
            ],
            [
                42,
                213834889
            ],
            [
                43,
                214989143
            ],
            [
                44,
                217313177
            ],
            [
                45,
                218815112
            ],
            [
                46,
                219182893
            ],
            [
                47,
                219623764
            ],
            [
                48,
                220074784
            ],
            [
                49,
                220649024
            ],
            [
                50,
                221631742
            ],
            [
                51,
                223100894
            ],
            [
                52,
                224450540
            ],
            [
                53,
                225385745
            ],
            [
                54,
                226348671
            ],
            [
                55,
                227923855
            ],
            [
                56,
                229744970
            ],
            [
                57,
                231827828
            ],
            [
                58,
                234008282
            ],
            [
                59,
                235848871
            ],
            [
                60,
                237466244
            ],
            [
                61,
                239190413
            ],
            [
                62,
                240066064
            ],
            [
                63,
                240760811
            ],
            [
                64,
                241753523
            ],
            [
                65,
                243705559
            ],
            [
                66,
                244638458
            ],
            [
                67,
                244833161
            ],
            [
                68,
                244993157
            ],
            [
                69,
                245124042
            ],
            [
                70,
                245262817
            ],
            [
                71,
                245688044
            ],
            [
                72,
                246775172
            ],
            [
                73,
                247458486
            ],
            [
                74,
                247574084
            ],
            [
                75,
                247690334
            ],
            [
                76,
                247798021
            ],
            [
                77,
                247907283
            ],
            [
                78,
                248161906
            ],
            [
                79,
                248775349
            ],
            [
                80,
                249291311
            ],
            [
                81,
                249919653
            ],
            [
                82,
                249995864
            ],
            [
                83,
                250058575
            ],
            [
                84,
                250121379
            ],
            [
                85,
                250211850
            ],
            [
                86,
                250490315
            ],
            [
                87,
                250676747
            ],
            [
                88,
                250716060
            ],
            [
                89,
                250750795
            ],
            [
                90,
                250786271
            ],
            [
                91,
                250822376
            ]
        ],
        name: 'monstersinc',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Monsters, Inc.',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#B2C8C7'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                45579056
            ],
            [
                2,
                79420425
            ],
            [
                3,
                102665981
            ],
            [
                4,
                111206338
            ],
            [
                5,
                122562341
            ],
            [
                6,
                136225792
            ],
            [
                7,
                146540534
            ],
            [
                8,
                167804466
            ],
            [
                9,
                188019699
            ],
            [
                10,
                198545129
            ],
            [
                11,
                201091347
            ],
            [
                12,
                204193802
            ],
            [
                13,
                206380154
            ],
            [
                14,
                208512000
            ],
            [
                15,
                214176847
            ],
            [
                16,
                222477857
            ],
            [
                17,
                227369547
            ],
            [
                18,
                228735455
            ],
            [
                19,
                230525838
            ],
            [
                20,
                231906120
            ],
            [
                21,
                233190956
            ],
            [
                22,
                236497731
            ],
            [
                23,
                241519565
            ],
            [
                24,
                244604272
            ],
            [
                25,
                245626798
            ],
            [
                26,
                246883184
            ],
            [
                27,
                247913304
            ],
            [
                28,
                248788774
            ],
            [
                29,
                250332197
            ],
            [
                30,
                252631324
            ],
            [
                31,
                254481457
            ],
            [
                32,
                255685045
            ],
            [
                33,
                257118683
            ],
            [
                34,
                258443061
            ],
            [
                35,
                259262857
            ],
            [
                36,
                260765485
            ],
            [
                37,
                262824809
            ],
            [
                38,
                264540685
            ],
            [
                39,
                265885848
            ],
            [
                40,
                267244461
            ],
            [
                41,
                268547959
            ],
            [
                42,
                269569121
            ],
            [
                43,
                271309533
            ],
            [
                44,
                273156255
            ],
            [
                45,
                274185395
            ],
            [
                46,
                274573566
            ],
            [
                47,
                274934139
            ],
            [
                48,
                275222668
            ],
            [
                49,
                275471610
            ],
            [
                50,
                276060848
            ],
            [
                51,
                277042909
            ],
            [
                52,
                277578497
            ],
            [
                53,
                277723849
            ],
            [
                54,
                277901047
            ],
            [
                55,
                278050410
            ],
            [
                56,
                278178868
            ],
            [
                57,
                278475812
            ],
            [
                58,
                278964297
            ],
            [
                59,
                279311004
            ],
            [
                60,
                279599584
            ],
            [
                61,
                279691680
            ],
            [
                62,
                279757333
            ],
            [
                63,
                279825074
            ],
            [
                64,
                279954145
            ],
            [
                65,
                280196900
            ],
            [
                66,
                280302457
            ],
            [
                67,
                280340080
            ],
            [
                68,
                280388309
            ],
            [
                69,
                280429452
            ],
            [
                70,
                280467490
            ],
            [
                71,
                280540492
            ],
            [
                72,
                280670293
            ],
            [
                73,
                280737534
            ],
            [
                74,
                280757126
            ],
            [
                75,
                280779813
            ],
            [
                76,
                280798321
            ],
            [
                77,
                280813773
            ],
            [
                78,
                280863508
            ],
            [
                79,
                280950463
            ],
            [
                80,
                280976000
            ],
            [
                81,
                280989632
            ],
            [
                82,
                281005174
            ],
            [
                83,
                281018635
            ],
            [
                84,
                281032486
            ],
            [
                85,
                281103773
            ],
            [
                86,
                281226658
            ],
            [
                87,
                281340856
            ],
            [
                88,
                281402464
            ],
            [
                89,
                281428973
            ],
            [
                90,
                281450204
            ],
            [
                91,
                281473188
            ],
            [
                92,
                281524890
            ],
            [
                93,
                281613822
            ],
            [
                94,
                281666058
            ],
            [
                95,
                281679486
            ],
            [
                96,
                281694464
            ],
            [
                97,
                281708566
            ],
            [
                98,
                281723902
            ]
        ],
        name: 'hungergames4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hunger Games: Mockingjay - Part 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#692C18'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                0,
                5000000
            ],
            [
                1,
                42508303
            ],
            [
                2,
                73838696
            ],
            [
                3,
                108227933
            ],
            [
                4,
                134282716
            ],
            [
                5,
                144391066
            ],
            [
                6,
                151919513
            ],
            [
                7,
                158242565
            ],
            [
                8,
                163869725
            ],
            [
                9,
                174197918
            ],
            [
                10,
                188645514
            ],
            [
                11,
                200773759
            ],
            [
                12,
                209481877
            ],
            [
                13,
                212271109
            ],
            [
                14,
                214706401
            ],
            [
                15,
                217013805
            ],
            [
                16,
                221334173
            ],
            [
                17,
                228246730
            ],
            [
                18,
                232701046
            ],
            [
                19,
                234183237
            ],
            [
                20,
                235801657
            ],
            [
                21,
                237185030
            ],
            [
                22,
                238592411
            ],
            [
                23,
                241161591
            ],
            [
                24,
                245143156
            ],
            [
                25,
                247778753
            ],
            [
                26,
                248755932
            ],
            [
                27,
                249783329
            ],
            [
                28,
                250729765
            ],
            [
                29,
                251741215
            ],
            [
                30,
                253282914
            ],
            [
                31,
                255659501
            ],
            [
                32,
                257486680
            ],
            [
                33,
                258191894
            ],
            [
                34,
                258958101
            ],
            [
                35,
                259696494
            ],
            [
                36,
                260458950
            ],
            [
                37,
                261565554
            ],
            [
                38,
                263190913
            ],
            [
                39,
                264401442
            ],
            [
                40,
                264889557
            ],
            [
                41,
                265432894
            ],
            [
                42,
                265916314
            ],
            [
                43,
                266404336
            ],
            [
                44,
                267123013
            ],
            [
                45,
                268186586
            ],
            [
                46,
                268979763
            ],
            [
                47,
                269409164
            ],
            [
                48,
                269764559
            ],
            [
                49,
                270030677
            ],
            [
                50,
                270382129
            ],
            [
                51,
                270750220
            ],
            [
                52,
                271479352
            ],
            [
                53,
                271936550
            ],
            [
                54,
                272158979
            ],
            [
                55,
                272403452
            ],
            [
                56,
                272591636
            ],
            [
                57,
                272793059
            ],
            [
                58,
                273141511
            ],
            [
                59,
                273601213
            ],
            [
                60,
                273905370
            ],
            [
                61,
                274053718
            ],
            [
                62,
                274226007
            ],
            [
                63,
                274395156
            ],
            [
                64,
                274536813
            ],
            [
                65,
                274745978
            ],
            [
                66,
                275040397
            ],
            [
                67,
                275254281
            ],
            [
                68,
                275363721
            ],
            [
                69,
                275490913
            ],
            [
                70,
                275606049
            ],
            [
                71,
                275720183
            ],
            [
                72,
                275861715
            ],
            [
                73,
                276087756
            ],
            [
                74,
                276231510
            ],
            [
                75,
                276309671
            ],
            [
                76,
                276397114
            ],
            [
                77,
                276480241
            ],
            [
                78,
                276572478
            ],
            [
                79,
                276722203
            ],
            [
                80,
                276933266
            ],
            [
                81,
                277084749
            ],
            [
                82,
                277162049
            ],
            [
                83,
                277248553
            ],
            [
                84,
                277326774
            ],
            [
                85,
                277404217
            ],
            [
                86,
                277507027
            ],
            [
                87,
                277656614
            ],
            [
                88,
                277767531
            ],
            [
                89,
                277824740
            ],
            [
                90,
                277886167
            ],
            [
                91,
                277940853
            ],
            [
                92,
                277990218
            ],
            [
                93,
                278069675
            ],
            [
                94,
                278196905
            ],
            [
                95,
                278285565
            ],
            [
                96,
                278336774
            ],
            [
                97,
                278395393
            ],
            [
                98,
                278452455
            ],
            [
                99,
                278507722
            ],
            [
                100,
                278593714
            ],
            [
                101,
                278726872
            ],
            [
                102,
                278821645
            ],
            [
                103,
                278869997
            ],
            [
                104,
                278912261
            ],
            [
                105,
                278951610
            ],
            [
                106,
                278996682
            ],
            [
                107,
                279138009
            ],
            [
                108,
                279372421
            ],
            [
                109,
                279617572
            ],
            [
                110,
                279771818
            ],
            [
                111,
                279839016
            ],
            [
                112,
                279894376
            ],
            [
                113,
                279944861
            ],
            [
                114,
                280053597
            ],
            [
                115,
                280226920
            ],
            [
                116,
                280332223
            ],
            [
                117,
                280360125
            ],
            [
                118,
                280394271
            ],
            [
                119,
                280422549
            ],
            [
                120,
                280451587
            ],
            [
                121,
                280507077
            ],
            [
                122,
                280591193
            ],
            [
                123,
                280644783
            ],
            [
                124,
                280663243
            ],
            [
                125,
                280690113
            ],
            [
                126,
                280714088
            ],
            [
                127,
                280738253
            ],
            [
                128,
                280779296
            ],
            [
                129,
                280839798
            ],
            [
                130,
                280872150
            ],
            [
                131,
                280884126
            ],
            [
                132,
                280900365
            ],
            [
                133,
                280916911
            ],
            [
                134,
                280931812
            ],
            [
                135,
                280963314
            ],
            [
                136,
                281022240
            ],
            [
                137,
                281048966
            ],
            [
                138,
                281060109
            ],
            [
                139,
                281071684
            ],
            [
                140,
                281083738
            ],
            [
                141,
                281097951
            ],
            [
                142,
                281124748
            ],
            [
                143,
                281170700
            ],
            [
                144,
                281193463
            ],
            [
                145,
                281202593
            ],
            [
                146,
                281213130
            ],
            [
                147,
                281222974
            ],
            [
                148,
                281232980
            ],
            [
                149,
                281253060
            ],
            [
                150,
                281287950
            ],
            [
                151,
                281311105
            ],
            [
                152,
                281324446
            ],
            [
                153,
                281333135
            ],
            [
                154,
                281341246
            ],
            [
                155,
                281348916
            ],
            [
                156,
                281367190
            ],
            [
                157,
                281397289
            ],
            [
                158,
                281414042
            ],
            [
                159,
                281419044
            ],
            [
                160,
                281425656
            ],
            [
                161,
                281431594
            ],
            [
                162,
                281437768
            ],
            [
                163,
                281452580
            ],
            [
                164,
                281477784
            ],
            [
                165,
                281492479
            ],
            [
                166,
                281497391
            ],
            [
                167,
                281502133
            ],
            [
                168,
                281509438
            ],
            [
                169,
                281519061
            ]
        ],
        name: 'matrixreloaded',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Matrix Reloaded',
            genre: 'Sci-Fi Action',

            mpaaRating: 'R',
            imgMainColor: '#BFCEC9'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                71642526
            ],
            [
                2,
                111671729
            ],
            [
                3,
                138122261
            ],
            [
                4,
                147975742
            ],
            [
                5,
                158978162
            ],
            [
                6,
                171415726
            ],
            [
                7,
                179148435
            ],
            [
                8,
                195837646
            ],
            [
                9,
                212201624
            ],
            [
                10,
                220832009
            ],
            [
                11,
                223357778
            ],
            [
                12,
                226000702
            ],
            [
                13,
                228151826
            ],
            [
                14,
                230390944
            ],
            [
                15,
                235843083
            ],
            [
                16,
                242923514
            ],
            [
                17,
                246926409
            ],
            [
                18,
                248073698
            ],
            [
                19,
                249388809
            ],
            [
                20,
                250457900
            ],
            [
                21,
                251583267
            ],
            [
                22,
                254039462
            ],
            [
                23,
                257437655
            ],
            [
                24,
                259402669
            ],
            [
                25,
                260051891
            ],
            [
                26,
                260800141
            ],
            [
                27,
                261451406
            ],
            [
                28,
                262130081
            ],
            [
                29,
                263408396
            ],
            [
                30,
                265122670
            ],
            [
                31,
                266327974
            ],
            [
                32,
                266979401
            ],
            [
                33,
                267677356
            ],
            [
                34,
                268192542
            ],
            [
                35,
                268801901
            ],
            [
                36,
                269473777
            ],
            [
                37,
                269756147
            ],
            [
                38,
                270268207
            ],
            [
                39,
                271182842
            ],
            [
                40,
                271954045
            ],
            [
                41,
                272707327
            ],
            [
                42,
                273469796
            ],
            [
                43,
                274336476
            ],
            [
                44,
                274841954
            ],
            [
                45,
                275530738
            ],
            [
                46,
                276125476
            ],
            [
                47,
                276424872
            ],
            [
                48,
                276675234
            ],
            [
                49,
                276943638
            ],
            [
                50,
                277381260
            ],
            [
                51,
                278046837
            ],
            [
                52,
                278415733
            ],
            [
                53,
                278523854
            ],
            [
                54,
                278649777
            ],
            [
                55,
                278762429
            ],
            [
                56,
                278869685
            ],
            [
                57,
                279071595
            ],
            [
                58,
                279399659
            ],
            [
                59,
                279638999
            ],
            [
                60,
                279795163
            ],
            [
                61,
                279846752
            ],
            [
                62,
                279897264
            ],
            [
                63,
                279953739
            ],
            [
                64,
                280037393
            ],
            [
                65,
                280186187
            ],
            [
                66,
                280262457
            ],
            [
                67,
                280288438
            ],
            [
                68,
                280315261
            ],
            [
                69,
                280342554
            ],
            [
                70,
                280371424
            ],
            [
                71,
                280417912
            ],
            [
                72,
                280493660
            ],
            [
                73,
                280536135
            ],
            [
                74,
                280549715
            ],
            [
                75,
                280565334
            ],
            [
                76,
                280580142
            ],
            [
                77,
                280596710
            ],
            [
                78,
                280680424
            ],
            [
                79,
                280817765
            ],
            [
                80,
                280876465
            ],
            [
                81,
                280903699
            ],
            [
                82,
                280935066
            ],
            [
                83,
                280961542
            ],
            [
                84,
                280989889
            ],
            [
                85,
                281042709
            ],
            [
                86,
                281117198
            ],
            [
                87,
                281158172
            ],
            [
                88,
                281170130
            ],
            [
                89,
                281190708
            ],
            [
                90,
                281200993
            ],
            [
                91,
                281213345
            ],
            [
                92,
                281228461
            ],
            [
                93,
                281251357
            ],
            [
                94,
                281267663
            ],
            [
                95,
                281275991
            ],
            [
                96,
                281279968
            ],
            [
                97,
                281283220
            ],
            [
                98,
                281287133
            ]
        ],
        name: 'breakingdawn',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Twilight Saga: Breaking Dawn Part 1',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#4E2E23'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                12066740
            ],
            [
                2,
                24396740
            ],
            [
                3,
                31555870
            ],
            [
                4,
                51098360
            ],
            [
                5,
                70517720
            ],
            [
                6,
                84431410
            ],
            [
                7,
                97061030
            ],
            [
                8,
                108547305
            ],
            [
                9,
                120719585
            ],
            [
                10,
                132859765
            ],
            [
                11,
                151131705
            ],
            [
                12,
                162461370
            ],
            [
                13,
                166883990
            ],
            [
                14,
                170073210
            ],
            [
                15,
                172874790
            ],
            [
                16,
                175799710
            ],
            [
                17,
                184634845
            ],
            [
                18,
                197578935
            ],
            [
                19,
                204297870
            ],
            [
                20,
                206149545
            ],
            [
                21,
                208196540
            ],
            [
                22,
                209959990
            ],
            [
                23,
                211794030
            ],
            [
                24,
                217409350
            ],
            [
                25,
                225636965
            ],
            [
                26,
                231110125
            ],
            [
                27,
                234308680
            ],
            [
                28,
                235499270
            ],
            [
                29,
                236494390
            ],
            [
                30,
                237560725
            ],
            [
                31,
                240799965
            ],
            [
                32,
                245055775
            ],
            [
                33,
                247243985
            ],
            [
                34,
                248019335
            ],
            [
                35,
                248829900
            ],
            [
                36,
                249570790
            ],
            [
                37,
                250346140
            ],
            [
                38,
                252585610
            ],
            [
                39,
                256343255
            ],
            [
                40,
                258372305
            ],
            [
                41,
                258839430
            ],
            [
                42,
                259350450
            ],
            [
                43,
                259844945
            ],
            [
                44,
                260355910
            ],
            [
                45,
                261858265
            ],
            [
                46,
                264399825
            ],
            [
                47,
                265163545
            ],
            [
                48,
                265500670
            ],
            [
                49,
                265827425
            ],
            [
                50,
                266140310
            ],
            [
                51,
                266490305
            ],
            [
                52,
                267357425
            ],
            [
                53,
                269070955
            ],
            [
                54,
                269946550
            ],
            [
                55,
                270483205
            ],
            [
                56,
                270718580
            ],
            [
                57,
                270925710
            ],
            [
                58,
                271142255
            ],
            [
                59,
                271670130
            ],
            [
                60,
                272611100
            ],
            [
                61,
                273159325
            ],
            [
                62,
                273488020
            ],
            [
                63,
                273636005
            ],
            [
                64,
                273778130
            ],
            [
                65,
                273926905
            ],
            [
                66,
                274239525
            ],
            [
                67,
                274779390
            ],
            [
                68,
                275027050
            ],
            [
                69,
                275096070
            ],
            [
                70,
                275169150
            ],
            [
                71,
                275242155
            ],
            [
                72,
                275331620
            ],
            [
                73,
                275501570
            ],
            [
                74,
                275797695
            ],
            [
                75,
                275936745
            ],
            [
                76,
                275980520
            ],
            [
                77,
                276037170
            ],
            [
                78,
                276093565
            ],
            [
                79,
                276142490
            ],
            [
                80,
                276261590
            ],
            [
                81,
                276468030
            ],
            [
                82,
                276573235
            ],
            [
                83,
                276614920
            ],
            [
                84,
                276662560
            ],
            [
                85,
                276706230
            ],
            [
                86,
                276751885
            ],
            [
                87,
                276861075
            ],
            [
                88,
                277034705
            ],
            [
                89,
                277125990
            ],
            [
                90,
                277163580
            ],
            [
                91,
                277206540
            ],
            [
                92,
                277247710
            ],
            [
                93,
                277292460
            ],
            [
                94,
                277418420
            ],
            [
                95,
                277560170
            ],
            [
                96,
                277642295
            ],
            [
                97,
                277700045
            ],
            [
                98,
                277747380
            ],
            [
                99,
                277791130
            ],
            [
                100,
                277838350
            ],
            [
                101,
                277930685
            ],
            [
                102,
                278052755
            ],
            [
                103,
                278115340
            ],
            [
                104,
                278137265
            ],
            [
                105,
                278165435
            ],
            [
                106,
                278190630
            ],
            [
                107,
                278220285
            ],
            [
                108,
                278302510
            ],
            [
                109,
                278426595
            ],
            [
                110,
                278487890
            ],
            [
                111,
                278511810
            ],
            [
                112,
                278538695
            ],
            [
                113,
                278562540
            ],
            [
                114,
                278586485
            ],
            [
                115,
                278650565
            ],
            [
                116,
                278754695
            ],
            [
                117,
                278808080
            ],
            [
                118,
                278826805
            ],
            [
                119,
                278849500
            ],
            [
                120,
                278870860
            ],
            [
                121,
                278890885
            ],
            [
                122,
                278932715
            ],
            [
                123,
                279000350
            ],
            [
                124,
                279035060
            ],
            [
                125,
                279044850
            ],
            [
                126,
                279057310
            ],
            [
                127,
                279067990
            ],
            [
                128,
                279078615
            ],
            [
                129,
                279105025
            ],
            [
                130,
                279147420
            ],
            [
                131,
                279167575
            ],
            [
                132,
                279175220
            ],
            [
                133,
                279184950
            ],
            [
                134,
                279192595
            ],
            [
                135,
                279200300
            ]
        ],
        name: 'meetthefockers',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Meet the Fockers',
            genre: 'Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#EFE9EA'
        },
        showlabel: false,
        color: 'rgba(26,188,156,0.75)',
        linkedTo: 'Comedy'
    }, {
        data: [
            [
                1,
                16734033
            ],
            [
                2,
                31790804
            ],
            [
                3,
                44979319
            ],
            [
                4,
                52638427
            ],
            [
                5,
                59227850
            ],
            [
                6,
                65883078
            ],
            [
                7,
                71974102
            ],
            [
                8,
                82284612
            ],
            [
                9,
                94887954
            ],
            [
                10,
                104768489
            ],
            [
                11,
                110299949
            ],
            [
                12,
                115828257
            ],
            [
                13,
                120878530
            ],
            [
                14,
                126063542
            ],
            [
                15,
                134474576
            ],
            [
                16,
                144870863
            ],
            [
                17,
                152817015
            ],
            [
                18,
                156628400
            ],
            [
                19,
                160120726
            ],
            [
                20,
                163204970
            ],
            [
                21,
                166032101
            ],
            [
                22,
                171339202
            ],
            [
                23,
                177924931
            ],
            [
                24,
                183054267
            ],
            [
                25,
                185632384
            ],
            [
                26,
                188381740
            ],
            [
                27,
                190775902
            ],
            [
                28,
                193769820
            ],
            [
                29,
                198260300
            ],
            [
                30,
                201073670
            ],
            [
                31,
                205038233
            ],
            [
                32,
                207015476
            ],
            [
                33,
                208966655
            ],
            [
                34,
                210791312
            ],
            [
                35,
                212511668
            ],
            [
                36,
                215661286
            ],
            [
                37,
                219582932
            ],
            [
                38,
                222444906
            ],
            [
                39,
                223766214
            ],
            [
                40,
                225081501
            ],
            [
                41,
                226309780
            ],
            [
                42,
                227567151
            ],
            [
                43,
                230137739
            ],
            [
                44,
                233483035
            ],
            [
                45,
                235744423
            ],
            [
                46,
                236862562
            ],
            [
                47,
                238206804
            ],
            [
                48,
                239378032
            ],
            [
                49,
                240612396
            ],
            [
                50,
                242606628
            ],
            [
                51,
                245250120
            ],
            [
                52,
                247073766
            ],
            [
                53,
                247929964
            ],
            [
                54,
                248857162
            ],
            [
                55,
                249808203
            ],
            [
                56,
                250696417
            ],
            [
                57,
                252257735
            ],
            [
                58,
                254330669
            ],
            [
                59,
                255890892
            ],
            [
                60,
                256580964
            ],
            [
                61,
                257269418
            ],
            [
                62,
                257937802
            ],
            [
                63,
                258610153
            ],
            [
                64,
                259633245
            ],
            [
                65,
                261038904
            ],
            [
                66,
                261979331
            ],
            [
                67,
                262440819
            ],
            [
                68,
                262899044
            ],
            [
                69,
                263357061
            ],
            [
                70,
                263801466
            ],
            [
                71,
                264422247
            ],
            [
                72,
                265277504
            ],
            [
                73,
                265790452
            ],
            [
                74,
                266043670
            ],
            [
                75,
                266301420
            ],
            [
                76,
                266553834
            ],
            [
                77,
                266803320
            ],
            [
                78,
                267258675
            ],
            [
                79,
                267925104
            ],
            [
                80,
                268277556
            ],
            [
                81,
                268430708
            ],
            [
                82,
                268592004
            ],
            [
                83,
                268749272
            ],
            [
                84,
                268897612
            ],
            [
                85,
                269314257
            ],
            [
                86,
                269952421
            ],
            [
                87,
                270237753
            ],
            [
                88,
                270349000
            ],
            [
                89,
                270467025
            ],
            [
                90,
                270582232
            ],
            [
                91,
                270699482
            ],
            [
                92,
                271001078
            ],
            [
                93,
                271437318
            ],
            [
                94,
                271921527
            ],
            [
                95,
                272197388
            ],
            [
                96,
                272281640
            ],
            [
                97,
                272355971
            ],
            [
                98,
                272427055
            ],
            [
                99,
                272652555
            ],
            [
                100,
                272997376
            ],
            [
                101,
                273136280
            ],
            [
                102,
                273193507
            ],
            [
                103,
                273258847
            ],
            [
                104,
                273326181
            ],
            [
                105,
                273396228
            ],
            [
                106,
                273547846
            ],
            [
                107,
                273761824
            ],
            [
                108,
                273863601
            ],
            [
                109,
                273900474
            ],
            [
                110,
                273944926
            ],
            [
                111,
                273987411
            ],
            [
                112,
                274029620
            ],
            [
                113,
                274160264
            ],
            [
                114,
                274361864
            ],
            [
                115,
                274452813
            ],
            [
                116,
                274487284
            ],
            [
                117,
                274526780
            ],
            [
                118,
                274563907
            ],
            [
                119,
                274603632
            ],
            [
                120,
                274774853
            ],
            [
                121,
                275028770
            ],
            [
                122,
                275156197
            ],
            [
                123,
                275205894
            ],
            [
                124,
                275268015
            ],
            [
                125,
                275326194
            ],
            [
                126,
                275386118
            ],
            [
                127,
                275523127
            ],
            [
                128,
                275706215
            ],
            [
                129,
                275813456
            ],
            [
                130,
                275868349
            ],
            [
                131,
                275914899
            ],
            [
                132,
                275961980
            ],
            [
                133,
                276009202
            ],
            [
                134,
                276094955
            ],
            [
                135,
                276218704
            ],
            [
                136,
                276276785
            ],
            [
                137,
                276298936
            ],
            [
                138,
                276325760
            ],
            [
                139,
                276352952
            ],
            [
                140,
                276381875
            ],
            [
                141,
                276449745
            ],
            [
                142,
                276540432
            ],
            [
                143,
                276583220
            ],
            [
                144,
                276599791
            ],
            [
                145,
                276618687
            ],
            [
                146,
                276636450
            ],
            [
                147,
                276654074
            ],
            [
                148,
                276696782
            ],
            [
                149,
                276736189
            ],
            [
                150,
                276771408
            ],
            [
                151,
                276784444
            ],
            [
                152,
                276800348
            ],
            [
                153,
                276815616
            ],
            [
                154,
                276833111
            ],
            [
                155,
                276869026
            ],
            [
                156,
                276919504
            ],
            [
                157,
                276942541
            ],
            [
                158,
                276951487
            ],
            [
                159,
                276964638
            ],
            [
                160,
                276979556
            ],
            [
                161,
                276989452
            ],
            [
                162,
                277017402
            ],
            [
                163,
                277054690
            ],
            [
                164,
                277069721
            ],
            [
                165,
                277076936
            ],
            [
                166,
                277084285
            ],
            [
                167,
                277091761
            ],
            [
                168,
                277099511
            ],
            [
                169,
                277118365
            ],
            [
                170,
                277144651
            ],
            [
                171,
                277156483
            ],
            [
                172,
                277162304
            ],
            [
                173,
                277170253
            ],
            [
                174,
                277180403
            ],
            [
                175,
                277190373
            ],
            [
                176,
                277211102
            ],
            [
                177,
                277232769
            ],
            [
                178,
                277240744
            ],
            [
                179,
                277244014
            ],
            [
                180,
                277247684
            ],
            [
                181,
                277251541
            ],
            [
                182,
                277255442
            ],
            [
                183,
                277264863
            ],
            [
                184,
                277278726
            ],
            [
                185,
                277283642
            ],
            [
                186,
                277286214
            ],
            [
                187,
                277288934
            ],
            [
                188,
                277291709
            ],
            [
                189,
                277294415
            ],
            [
                190,
                277300848
            ],
            [
                191,
                277309155
            ],
            [
                192,
                277313371
            ],
            [
                193,
                277315648
            ],
            [
                194,
                277317996
            ],
            [
                195,
                277320090
            ],
            [
                196,
                277322503
            ]
        ],
        name: 'hangover',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hangover',
            genre: 'Comedy',

            mpaaRating: 'R',
            imgMainColor: '#907A63'
        },
        showlabel: false,
        color: 'rgba(26,188,156,0.75)',
        linkedTo: 'Comedy'
    }, {
        data: [
            [
                1,
                17484818
            ],
            [
                2,
                40486171
            ],
            [
                3,
                55785112
            ],
            [
                4,
                61812240
            ],
            [
                5,
                68450707
            ],
            [
                6,
                73788739
            ],
            [
                7,
                79134919
            ],
            [
                8,
                91735987
            ],
            [
                9,
                110197316
            ],
            [
                10,
                122323175
            ],
            [
                11,
                128524251
            ],
            [
                12,
                132525377
            ],
            [
                13,
                136013643
            ],
            [
                14,
                139536130
            ],
            [
                15,
                148552203
            ],
            [
                16,
                162161396
            ],
            [
                17,
                169563291
            ],
            [
                18,
                171968814
            ],
            [
                19,
                174919886
            ],
            [
                20,
                177237186
            ],
            [
                21,
                179514361
            ],
            [
                22,
                185594655
            ],
            [
                23,
                194613790
            ],
            [
                24,
                199649748
            ],
            [
                25,
                201152052
            ],
            [
                26,
                202996177
            ],
            [
                27,
                204427244
            ],
            [
                28,
                206066013
            ],
            [
                29,
                209645694
            ],
            [
                30,
                215768648
            ],
            [
                31,
                218891359
            ],
            [
                32,
                219784838
            ],
            [
                33,
                220939433
            ],
            [
                34,
                221833695
            ],
            [
                35,
                222714492
            ],
            [
                36,
                225009203
            ],
            [
                37,
                228863828
            ],
            [
                38,
                231249831
            ],
            [
                39,
                232479037
            ],
            [
                40,
                233142205
            ],
            [
                41,
                233704465
            ],
            [
                42,
                234275614
            ],
            [
                43,
                235989279
            ],
            [
                44,
                238931337
            ],
            [
                45,
                240379710
            ],
            [
                46,
                240803879
            ],
            [
                47,
                241356931
            ],
            [
                48,
                241819248
            ],
            [
                49,
                242197604
            ],
            [
                50,
                243089569
            ],
            [
                51,
                244580794
            ],
            [
                52,
                245407759
            ],
            [
                53,
                245743924
            ],
            [
                54,
                246177041
            ],
            [
                55,
                246631491
            ],
            [
                56,
                247142861
            ],
            [
                57,
                248217837
            ],
            [
                58,
                249227667
            ],
            [
                59,
                249699049
            ],
            [
                60,
                249835339
            ],
            [
                61,
                250000975
            ],
            [
                62,
                250137200
            ],
            [
                63,
                250275254
            ],
            [
                64,
                250606204
            ],
            [
                65,
                251183300
            ],
            [
                66,
                251486533
            ],
            [
                67,
                251604851
            ],
            [
                68,
                251764184
            ],
            [
                69,
                251894418
            ],
            [
                70,
                252033608
            ],
            [
                71,
                252248860
            ],
            [
                72,
                252563686
            ],
            [
                73,
                252779065
            ],
            [
                74,
                252871195
            ],
            [
                75,
                252976073
            ],
            [
                76,
                253052842
            ],
            [
                77,
                253135785
            ],
            [
                78,
                253242977
            ],
            [
                79,
                253414778
            ],
            [
                80,
                253567282
            ],
            [
                81,
                253694288
            ],
            [
                82,
                253809990
            ],
            [
                83,
                253946403
            ],
            [
                84,
                254085404
            ],
            [
                85,
                254246242
            ],
            [
                86,
                254444232
            ],
            [
                87,
                254593554
            ],
            [
                88,
                254723083
            ],
            [
                89,
                254861229
            ],
            [
                90,
                255041963
            ],
            [
                91,
                255144426
            ],
            [
                92,
                255296828
            ],
            [
                93,
                255504224
            ],
            [
                94,
                255621667
            ],
            [
                95,
                255662874
            ],
            [
                96,
                255709910
            ],
            [
                97,
                255754350
            ],
            [
                98,
                255805704
            ],
            [
                99,
                255918546
            ],
            [
                100,
                256114529
            ],
            [
                101,
                256224796
            ],
            [
                102,
                256268146
            ],
            [
                103,
                256314185
            ],
            [
                104,
                256352541
            ],
            [
                105,
                256410669
            ],
            [
                106,
                256876072
            ],
            [
                107,
                257786788
            ],
            [
                108,
                258277706
            ],
            [
                109,
                258717930
            ],
            [
                110,
                258875011
            ],
            [
                111,
                259029277
            ],
            [
                112,
                259183469
            ],
            [
                113,
                259676051
            ],
            [
                114,
                260633584
            ],
            [
                115,
                261208962
            ],
            [
                116,
                261387253
            ],
            [
                117,
                261598729
            ],
            [
                118,
                261774254
            ],
            [
                119,
                261967346
            ],
            [
                120,
                262553924
            ],
            [
                121,
                263645351
            ],
            [
                122,
                263989374
            ],
            [
                123,
                264171486
            ],
            [
                124,
                264379618
            ],
            [
                125,
                264581641
            ],
            [
                126,
                264802800
            ],
            [
                127,
                265178283
            ],
            [
                128,
                266001077
            ],
            [
                129,
                266474237
            ],
            [
                130,
                266615700
            ],
            [
                131,
                266787772
            ],
            [
                132,
                266850233
            ],
            [
                133,
                266921610
            ],
            [
                134,
                267216163
            ],
            [
                135,
                267620309
            ],
            [
                136,
                267958269
            ],
            [
                137,
                268172926
            ],
            [
                138,
                268262383
            ],
            [
                139,
                268345782
            ],
            [
                140,
                268428128
            ],
            [
                141,
                268648565
            ],
            [
                142,
                269036253
            ],
            [
                143,
                269275323
            ],
            [
                144,
                269347748
            ],
            [
                145,
                269429937
            ],
            [
                146,
                269502099
            ],
            [
                147,
                269589531
            ],
            [
                148,
                269804771
            ],
            [
                149,
                270255085
            ],
            [
                150,
                270478831
            ],
            [
                151,
                270600947
            ],
            [
                152,
                270720997
            ],
            [
                153,
                270819443
            ],
            [
                154,
                270912606
            ],
            [
                155,
                271152620
            ],
            [
                156,
                271584350
            ],
            [
                157,
                271814796
            ],
            [
                158,
                271885959
            ],
            [
                159,
                271974168
            ],
            [
                160,
                272051527
            ],
            [
                161,
                272124892
            ],
            [
                162,
                272275153
            ],
            [
                163,
                272525747
            ],
            [
                164,
                272672181
            ],
            [
                165,
                272720400
            ],
            [
                166,
                272774851
            ],
            [
                167,
                272819785
            ],
            [
                168,
                272864283
            ],
            [
                169,
                272920838
            ],
            [
                170,
                273026826
            ],
            [
                171,
                273089375
            ],
            [
                172,
                273112569
            ],
            [
                173,
                273142493
            ],
            [
                174,
                273167226
            ],
            [
                175,
                273190658
            ],
            [
                176,
                273225527
            ],
            [
                177,
                273281862
            ],
            [
                178,
                273312639
            ],
            [
                179,
                273325688
            ],
            [
                180,
                273339603
            ],
            [
                181,
                273351709
            ],
            [
                182,
                273363308
            ],
            [
                183,
                273435218
            ],
            [
                184,
                273536674
            ],
            [
                185,
                273605314
            ],
            [
                186,
                273628538
            ],
            [
                187,
                273658529
            ],
            [
                188,
                273682021
            ],
            [
                189,
                273704338
            ],
            [
                190,
                273743182
            ],
            [
                191,
                273799855
            ],
            [
                192,
                273838269
            ],
            [
                193,
                273852834
            ],
            [
                194,
                273872688
            ],
            [
                195,
                273888865
            ],
            [
                196,
                273908685
            ],
            [
                197,
                273932884
            ],
            [
                198,
                273964011
            ],
            [
                199,
                273980132
            ],
            [
                200,
                273987347
            ],
            [
                201,
                273996221
            ],
            [
                202,
                274004651
            ],
            [
                203,
                274012743
            ],
            [
                204,
                274023599
            ],
            [
                205,
                274041706
            ],
            [
                206,
                274052110
            ],
            [
                207,
                274054961
            ],
            [
                208,
                274058729
            ],
            [
                209,
                274062042
            ],
            [
                210,
                274065620
            ],
            [
                211,
                274071091
            ],
            [
                212,
                274080055
            ],
            [
                213,
                274084951
            ],
            [
                214,
                274086615
            ],
            [
                215,
                274088678
            ],
            [
                216,
                274090596
            ],
            [
                217,
                274092705
            ]
        ],
        name: 'gravity',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Gravity',
            genre: 'Sci-Fi Thriller',

            mpaaRating: 'PG-13',
            imgMainColor: '#273340'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                30473099
            ],
            [
                2,
                59207090
            ],
            [
                3,
                82429469
            ],
            [
                4,
                93448671
            ],
            [
                5,
                105296735
            ],
            [
                6,
                115333157
            ],
            [
                7,
                124825448
            ],
            [
                8,
                139242031
            ],
            [
                9,
                156910695
            ],
            [
                10,
                170433193
            ],
            [
                11,
                178331953
            ],
            [
                12,
                185905021
            ],
            [
                13,
                191309030
            ],
            [
                14,
                196537632
            ],
            [
                15,
                203739645
            ],
            [
                16,
                210901879
            ],
            [
                17,
                216253979
            ],
            [
                18,
                218814952
            ],
            [
                19,
                221990710
            ],
            [
                20,
                224629892
            ],
            [
                21,
                227139427
            ],
            [
                22,
                230455915
            ],
            [
                23,
                234760624
            ],
            [
                24,
                237771003
            ],
            [
                25,
                239289059
            ],
            [
                26,
                241220190
            ],
            [
                27,
                242664821
            ],
            [
                28,
                243992254
            ],
            [
                29,
                245504920
            ],
            [
                30,
                247559382
            ],
            [
                31,
                249114132
            ],
            [
                32,
                249906652
            ],
            [
                33,
                250940258
            ],
            [
                34,
                251777375
            ],
            [
                35,
                252612188
            ],
            [
                36,
                253418103
            ],
            [
                37,
                254514346
            ],
            [
                38,
                255467026
            ],
            [
                39,
                255910948
            ],
            [
                40,
                256425170
            ],
            [
                41,
                256790589
            ],
            [
                42,
                257161691
            ],
            [
                43,
                257562072
            ],
            [
                44,
                258137410
            ],
            [
                45,
                258565238
            ],
            [
                46,
                258813738
            ],
            [
                47,
                259089841
            ],
            [
                48,
                259293996
            ],
            [
                49,
                259487516
            ],
            [
                50,
                259709029
            ],
            [
                51,
                259977221
            ],
            [
                52,
                260171175
            ],
            [
                53,
                260295905
            ],
            [
                54,
                260455526
            ],
            [
                55,
                260566991
            ],
            [
                56,
                260673604
            ],
            [
                71,
                262305855
            ],
            [
                72,
                262905944
            ],
            [
                73,
                263568953
            ],
            [
                74,
                264286369
            ],
            [
                75,
                264385381
            ],
            [
                76,
                264449975
            ],
            [
                77,
                264537017
            ],
            [
                78,
                264634350
            ],
            [
                79,
                264853554
            ],
            [
                80,
                264989136
            ],
            [
                81,
                265014357
            ],
            [
                82,
                265041793
            ],
            [
                83,
                265067070
            ],
            [
                84,
                265092054
            ]
        ],
        name: 'monstersinc2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Monsters University',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#8A8F96'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                20099
            ],
            [
                2,
                39588
            ],
            [
                3,
                11612603
            ],
            [
                4,
                29135915
            ],
            [
                5,
                42387348
            ],
            [
                6,
                46460873
            ],
            [
                7,
                50000472
            ],
            [
                8,
                53117948
            ],
            [
                9,
                56537780
            ],
            [
                10,
                66427296
            ],
            [
                11,
                83527976
            ],
            [
                12,
                99019205
            ],
            [
                13,
                111753400
            ],
            [
                14,
                114677618
            ],
            [
                15,
                117326994
            ],
            [
                16,
                120188552
            ],
            [
                17,
                126952634
            ],
            [
                18,
                139605953
            ],
            [
                19,
                148361421
            ],
            [
                20,
                150844164
            ],
            [
                21,
                153648432
            ],
            [
                22,
                156468969
            ],
            [
                23,
                159549376
            ],
            [
                24,
                164088577
            ],
            [
                25,
                171099046
            ],
            [
                26,
                176069428
            ],
            [
                27,
                177961087
            ],
            [
                28,
                180095133
            ],
            [
                29,
                182133662
            ],
            [
                30,
                184346428
            ],
            [
                31,
                187945813
            ],
            [
                32,
                193236425
            ],
            [
                33,
                197528004
            ],
            [
                34,
                199149664
            ],
            [
                35,
                200873205
            ],
            [
                36,
                202692510
            ],
            [
                37,
                204826286
            ],
            [
                38,
                207933715
            ],
            [
                39,
                212312950
            ],
            [
                40,
                215232017
            ],
            [
                41,
                216432671
            ],
            [
                42,
                217750903
            ],
            [
                43,
                219072661
            ],
            [
                44,
                220434926
            ],
            [
                45,
                222496368
            ],
            [
                46,
                225556336
            ],
            [
                47,
                228142129
            ],
            [
                48,
                229470914
            ],
            [
                49,
                231170167
            ],
            [
                50,
                233298753
            ],
            [
                51,
                234553132
            ],
            [
                52,
                236319337
            ],
            [
                53,
                238603661
            ],
            [
                54,
                240560159
            ],
            [
                55,
                241268584
            ],
            [
                56,
                242105952
            ],
            [
                57,
                242925496
            ],
            [
                58,
                243676732
            ],
            [
                59,
                244748171
            ],
            [
                60,
                246186859
            ],
            [
                61,
                247280575
            ],
            [
                62,
                247805106
            ],
            [
                63,
                248537074
            ],
            [
                64,
                249138623
            ],
            [
                65,
                249646960
            ],
            [
                66,
                250280187
            ],
            [
                67,
                251190706
            ],
            [
                68,
                251922192
            ],
            [
                69,
                252296643
            ],
            [
                70,
                252768921
            ],
            [
                71,
                253228304
            ],
            [
                72,
                253733562
            ],
            [
                73,
                254217625
            ],
            [
                74,
                254913603
            ],
            [
                75,
                255526280
            ],
            [
                76,
                255810708
            ],
            [
                77,
                256165068
            ],
            [
                78,
                256491593
            ],
            [
                79,
                256846372
            ],
            [
                80,
                257151461
            ],
            [
                81,
                257581918
            ],
            [
                82,
                257919287
            ],
            [
                83,
                258116694
            ],
            [
                84,
                258330619
            ],
            [
                85,
                258545031
            ],
            [
                86,
                258772376
            ],
            [
                87,
                258965617
            ],
            [
                88,
                259222405
            ],
            [
                89,
                259456747
            ],
            [
                90,
                259566999
            ],
            [
                91,
                259682447
            ],
            [
                92,
                259784010
            ],
            [
                93,
                259905461
            ],
            [
                94,
                260043064
            ],
            [
                95,
                260245463
            ],
            [
                96,
                260444228
            ],
            [
                97,
                260532701
            ],
            [
                98,
                260632341
            ],
            [
                99,
                260723586
            ],
            [
                100,
                260814955
            ],
            [
                101,
                260956302
            ],
            [
                102,
                261190354
            ],
            [
                103,
                261398217
            ],
            [
                104,
                261483652
            ],
            [
                105,
                261594714
            ],
            [
                106,
                261673271
            ],
            [
                107,
                261750467
            ],
            [
                108,
                261934958
            ],
            [
                109,
                262243191
            ],
            [
                110,
                262536751
            ],
            [
                111,
                262908727
            ],
            [
                112,
                262968755
            ],
            [
                113,
                263007998
            ],
            [
                114,
                263046762
            ],
            [
                115,
                263128848
            ],
            [
                116,
                263324824
            ],
            [
                117,
                263482327
            ],
            [
                118,
                263505869
            ],
            [
                119,
                263526047
            ],
            [
                120,
                263551500
            ],
            [
                121,
                263576715
            ],
            [
                122,
                263658903
            ],
            [
                123,
                263845966
            ],
            [
                124,
                263977441
            ],
            [
                125,
                263999830
            ],
            [
                126,
                264034305
            ],
            [
                127,
                264062364
            ],
            [
                128,
                264090028
            ],
            [
                129,
                264215288
            ],
            [
                130,
                264518586
            ],
            [
                131,
                264752789
            ],
            [
                132,
                264795242
            ],
            [
                133,
                264869354
            ],
            [
                134,
                264919616
            ],
            [
                135,
                264986351
            ],
            [
                136,
                265091833
            ],
            [
                137,
                265299884
            ],
            [
                138,
                265448253
            ],
            [
                139,
                265471439
            ],
            [
                140,
                265495696
            ],
            [
                141,
                265522045
            ],
            [
                142,
                265551323
            ],
            [
                143,
                265622479
            ],
            [
                144,
                265780407
            ],
            [
                145,
                265883866
            ],
            [
                146,
                265951982
            ],
            [
                147,
                265975511
            ],
            [
                148,
                265998916
            ],
            [
                149,
                266023587
            ],
            [
                150,
                266073776
            ],
            [
                151,
                266185922
            ],
            [
                152,
                266283207
            ],
            [
                153,
                266302646
            ],
            [
                154,
                266321171
            ],
            [
                155,
                266339361
            ],
            [
                156,
                266364609
            ],
            [
                157,
                266431795
            ],
            [
                158,
                266549278
            ],
            [
                159,
                266636479
            ],
            [
                160,
                266654871
            ],
            [
                161,
                266678418
            ],
            [
                162,
                266697786
            ],
            [
                163,
                266720791
            ],
            [
                164,
                266786211
            ],
            [
                165,
                266898569
            ],
            [
                166,
                266982666
            ],
            [
                167,
                266998121
            ],
            [
                168,
                267015189
            ],
            [
                169,
                267035511
            ],
            [
                170,
                267055666
            ],
            [
                171,
                267097208
            ],
            [
                172,
                267162291
            ],
            [
                173,
                267202507
            ],
            [
                174,
                267211690
            ],
            [
                175,
                267225192
            ],
            [
                176,
                267234638
            ],
            [
                177,
                267245967
            ],
            [
                178,
                267280085
            ],
            [
                179,
                267332118
            ],
            [
                180,
                267367187
            ],
            [
                181,
                267382563
            ],
            [
                182,
                267390646
            ],
            [
                183,
                267397188
            ],
            [
                184,
                267403311
            ],
            [
                185,
                267417561
            ],
            [
                186,
                267451102
            ],
            [
                187,
                267467391
            ],
            [
                188,
                267471946
            ],
            [
                189,
                267479271
            ],
            [
                190,
                267490292
            ],
            [
                191,
                267502596
            ],
            [
                192,
                267537610
            ],
            [
                193,
                267573772
            ],
            [
                194,
                267590891
            ],
            [
                195,
                267595212
            ],
            [
                196,
                267600332
            ],
            [
                197,
                267604865
            ],
            [
                198,
                267609294
            ],
            [
                199,
                267620580
            ],
            [
                200,
                267640832
            ],
            [
                201,
                267652016
            ],
            [
                202,
                267655231
            ],
            [
                203,
                267658655
            ],
            [
                204,
                267661752
            ],
            [
                205,
                267665011
            ]
        ],
        name: 'shrek',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Shrek',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#A28E84'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                0,
                850000
            ],
            [
                1,
                35866884
            ],
            [
                2,
                59202809
            ],
            [
                3,
                75017570
            ],
            [
                4,
                95497609
            ],
            [
                5,
                119154713
            ],
            [
                6,
                137022258
            ],
            [
                7,
                144578697
            ],
            [
                8,
                153210348
            ],
            [
                9,
                159713629
            ],
            [
                10,
                165872247
            ],
            [
                11,
                176070659
            ],
            [
                12,
                189953583
            ],
            [
                13,
                200500351
            ],
            [
                14,
                204853977
            ],
            [
                15,
                210293031
            ],
            [
                16,
                214314784
            ],
            [
                17,
                217724314
            ],
            [
                18,
                221171631
            ],
            [
                19,
                225426204
            ],
            [
                20,
                228611425
            ],
            [
                21,
                230161774
            ],
            [
                22,
                232198265
            ],
            [
                23,
                233672436
            ],
            [
                24,
                235252610
            ],
            [
                25,
                237148066
            ],
            [
                26,
                239911945
            ],
            [
                27,
                241953721
            ],
            [
                28,
                242955672
            ],
            [
                29,
                244281030
            ],
            [
                30,
                245327116
            ],
            [
                31,
                246340333
            ],
            [
                32,
                247583733
            ],
            [
                33,
                249328151
            ],
            [
                34,
                250740648
            ],
            [
                35,
                251426210
            ],
            [
                36,
                252188219
            ],
            [
                37,
                252768504
            ],
            [
                38,
                253343442
            ],
            [
                39,
                253972858
            ],
            [
                40,
                254855547
            ],
            [
                41,
                255464677
            ],
            [
                42,
                255761521
            ],
            [
                43,
                256159253
            ],
            [
                44,
                256422240
            ],
            [
                45,
                256676518
            ],
            [
                46,
                256906012
            ],
            [
                47,
                257220588
            ],
            [
                48,
                257435325
            ],
            [
                49,
                257538273
            ],
            [
                50,
                257672448
            ],
            [
                51,
                257769664
            ],
            [
                52,
                257863937
            ],
            [
                53,
                258010151
            ],
            [
                54,
                258222644
            ],
            [
                55,
                258355827
            ],
            [
                56,
                258423379
            ],
            [
                57,
                258498943
            ],
            [
                58,
                258548927
            ],
            [
                59,
                258600057
            ],
            [
                60,
                258815453
            ],
            [
                61,
                259166795
            ],
            [
                62,
                259524833
            ],
            [
                63,
                259811206
            ],
            [
                64,
                259890769
            ],
            [
                65,
                259946733
            ],
            [
                66,
                260005361
            ],
            [
                67,
                260150569
            ],
            [
                68,
                260418505
            ],
            [
                69,
                260571241
            ],
            [
                74,
                260844063
            ],
            [
                75,
                261005584
            ],
            [
                76,
                261102260
            ],
            [
                81,
                261292416
            ],
            [
                82,
                261406855
            ],
            [
                83,
                261471268
            ],
            [
                88,
                261612657
            ],
            [
                89,
                261721446
            ],
            [
                90,
                261765954
            ],
            [
                95,
                261850903
            ],
            [
                96,
                261907613
            ],
            [
                97,
                261939214
            ],
            [
                102,
                261994808
            ],
            [
                103,
                262018902
            ],
            [
                104,
                262030663
            ]
        ],
        name: 'spiderman4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Amazing Spider-Man',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#403240'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                29631453
            ],
            [
                2,
                63845256
            ],
            [
                3,
                88357488
            ],
            [
                4,
                93678789
            ],
            [
                5,
                98421061
            ],
            [
                6,
                102453546
            ],
            [
                7,
                106131568
            ],
            [
                8,
                117138823
            ],
            [
                9,
                135845151
            ],
            [
                10,
                148358831
            ],
            [
                11,
                150920102
            ],
            [
                12,
                154408081
            ],
            [
                13,
                160822000
            ],
            [
                14,
                168041516
            ],
            [
                15,
                181419676
            ],
            [
                16,
                193446308
            ],
            [
                17,
                200159012
            ],
            [
                18,
                201207172
            ],
            [
                19,
                202160354
            ],
            [
                20,
                202997203
            ],
            [
                21,
                203884698
            ],
            [
                22,
                206478449
            ],
            [
                23,
                211116578
            ],
            [
                24,
                213970962
            ],
            [
                25,
                214533188
            ],
            [
                26,
                215161380
            ],
            [
                27,
                215740821
            ],
            [
                28,
                216294988
            ],
            [
                29,
                217723188
            ],
            [
                30,
                220610665
            ],
            [
                31,
                222619375
            ],
            [
                32,
                223066343
            ],
            [
                33,
                223573786
            ],
            [
                34,
                224006940
            ],
            [
                35,
                224450272
            ],
            [
                36,
                225454018
            ],
            [
                37,
                227163586
            ],
            [
                38,
                228821682
            ],
            [
                39,
                230158075
            ],
            [
                40,
                231000499
            ],
            [
                41,
                231950777
            ],
            [
                42,
                233833266
            ],
            [
                43,
                236014651
            ],
            [
                44,
                238246913
            ],
            [
                45,
                240307533
            ],
            [
                46,
                242129704
            ],
            [
                47,
                243867371
            ],
            [
                48,
                245996312
            ],
            [
                49,
                247444556
            ],
            [
                50,
                248875790
            ],
            [
                51,
                250741823
            ],
            [
                52,
                252097945
            ],
            [
                53,
                252390263
            ],
            [
                54,
                252636341
            ],
            [
                55,
                252843617
            ],
            [
                56,
                253040825
            ],
            [
                57,
                253490940
            ],
            [
                58,
                254593196
            ],
            [
                59,
                255449301
            ],
            [
                60,
                255576566
            ],
            [
                61,
                255730901
            ],
            [
                62,
                255856763
            ],
            [
                63,
                255993116
            ],
            [
                65,
                256870249
            ],
            [
                66,
                257405375
            ],
            [
                67,
                257897677
            ],
            [
                68,
                257976889
            ],
            [
                69,
                258044347
            ],
            [
                70,
                258119640
            ],
            [
                71,
                258255448
            ],
            [
                72,
                258642000
            ],
            [
                73,
                258898102
            ],
            [
                74,
                258968210
            ],
            [
                75,
                259018343
            ],
            [
                76,
                259065521
            ],
            [
                77,
                259119624
            ],
            [
                78,
                259202081
            ],
            [
                79,
                259437310
            ],
            [
                80,
                259626842
            ],
            [
                81,
                259647175
            ],
            [
                82,
                259670518
            ],
            [
                83,
                259694253
            ],
            [
                84,
                259720120
            ],
            [
                85,
                259764578
            ],
            [
                86,
                259902545
            ],
            [
                87,
                260023267
            ],
            [
                88,
                260042432
            ],
            [
                89,
                260057951
            ],
            [
                90,
                260074110
            ],
            [
                91,
                260087936
            ],
            [
                92,
                260150490
            ],
            [
                93,
                260291741
            ],
            [
                94,
                260416152
            ],
            [
                95,
                260492052
            ],
            [
                96,
                260524245
            ],
            [
                97,
                260552995
            ],
            [
                98,
                260581103
            ],
            [
                99,
                260641283
            ],
            [
                100,
                260759681
            ],
            [
                101,
                260839888
            ],
            [
                102,
                260855311
            ],
            [
                103,
                260870621
            ],
            [
                104,
                260885761
            ],
            [
                105,
                260901621
            ],
            [
                106,
                260950376
            ],
            [
                107,
                261049620
            ],
            [
                108,
                261123736
            ],
            [
                109,
                261142213
            ],
            [
                110,
                261158131
            ],
            [
                111,
                261173905
            ],
            [
                112,
                261190950
            ],
            [
                113,
                261233262
            ],
            [
                114,
                261309243
            ],
            [
                115,
                261370976
            ],
            [
                116,
                261393096
            ],
            [
                117,
                261418257
            ],
            [
                118,
                261442745
            ],
            [
                119,
                261466852
            ],
            [
                120,
                261500126
            ],
            [
                121,
                261553113
            ],
            [
                122,
                261588213
            ],
            [
                123,
                261600000
            ],
            [
                124,
                261613781
            ],
            [
                125,
                261624972
            ],
            [
                126,
                261637574
            ],
            [
                127,
                261660006
            ],
            [
                128,
                261700188
            ],
            [
                129,
                261724299
            ],
            [
                130,
                261732657
            ],
            [
                131,
                261742099
            ],
            [
                132,
                261751196
            ],
            [
                133,
                261761716
            ],
            [
                134,
                261779489
            ],
            [
                135,
                261812629
            ],
            [
                136,
                261835892
            ],
            [
                137,
                261843145
            ],
            [
                138,
                261849781
            ],
            [
                139,
                261855995
            ],
            [
                140,
                261862955
            ],
            [
                141,
                261876864
            ],
            [
                142,
                261906514
            ],
            [
                143,
                261924727
            ],
            [
                144,
                261930121
            ],
            [
                145,
                261936912
            ],
            [
                146,
                261942505
            ],
            [
                147,
                261948750
            ],
            [
                148,
                261954603
            ],
            [
                149,
                261964006
            ],
            [
                150,
                261970615
            ],
            [
                151,
                261972509
            ],
            [
                152,
                261974895
            ],
            [
                153,
                261977124
            ],
            [
                154,
                261979634
            ],
            [
                155,
                261981386
            ],
            [
                156,
                261983001
            ],
            [
                157,
                261983944
            ],
            [
                158,
                261984527
            ],
            [
                159,
                261985021
            ],
            [
                160,
                261985421
            ],
            [
                162,
                261986049
            ],
            [
                163,
                261987395
            ],
            [
                164,
                261987880
            ],
            [
                165,
                261987992
            ],
            [
                166,
                261988109
            ],
            [
                167,
                261988227
            ],
            [
                168,
                261988325
            ],
            [
                169,
                261988405
            ],
            [
                170,
                261988464
            ],
            [
                171,
                261988482
            ]
        ],
        name: 'harrypotter2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Chamber of Secrets',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#292F37'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                20503078
            ],
            [
                2,
                50027012
            ],
            [
                3,
                70467623
            ],
            [
                4,
                74270103
            ],
            [
                5,
                77482702
            ],
            [
                6,
                81992796
            ],
            [
                7,
                93004485
            ],
            [
                8,
                106932122
            ],
            [
                9,
                129306113
            ],
            [
                10,
                143255844
            ],
            [
                11,
                145396468
            ],
            [
                12,
                147363767
            ],
            [
                13,
                149181562
            ],
            [
                14,
                151031633
            ],
            [
                15,
                157699866
            ],
            [
                16,
                169911453
            ],
            [
                17,
                177555485
            ],
            [
                18,
                179257620
            ],
            [
                19,
                181485791
            ],
            [
                20,
                185926773
            ],
            [
                21,
                190713756
            ],
            [
                22,
                200616158
            ],
            [
                23,
                209654649
            ],
            [
                24,
                214294035
            ],
            [
                25,
                215034304
            ],
            [
                26,
                215668895
            ],
            [
                27,
                216245723
            ],
            [
                28,
                216842991
            ],
            [
                29,
                219182469
            ],
            [
                30,
                223353755
            ],
            [
                31,
                225858787
            ],
            [
                32,
                226281941
            ],
            [
                33,
                226731973
            ],
            [
                34,
                227141381
            ],
            [
                35,
                227536615
            ],
            [
                36,
                228745970
            ],
            [
                37,
                231150039
            ],
            [
                38,
                232573246
            ],
            [
                39,
                232864231
            ],
            [
                40,
                233175372
            ],
            [
                41,
                233500245
            ],
            [
                42,
                233857885
            ],
            [
                43,
                234624144
            ],
            [
                44,
                235966381
            ],
            [
                45,
                236978426
            ],
            [
                46,
                237668952
            ],
            [
                47,
                238450986
            ],
            [
                48,
                239134653
            ],
            [
                49,
                240008667
            ],
            [
                50,
                240713808
            ],
            [
                51,
                241424704
            ],
            [
                52,
                242425976
            ],
            [
                53,
                243564448
            ],
            [
                54,
                244839175
            ],
            [
                55,
                246140488
            ],
            [
                56,
                247496609
            ],
            [
                57,
                248939765
            ],
            [
                58,
                250428514
            ],
            [
                59,
                251657004
            ],
            [
                60,
                252097556
            ],
            [
                61,
                252317635
            ],
            [
                62,
                252496777
            ],
            [
                63,
                252680838
            ],
            [
                64,
                253058475
            ],
            [
                65,
                254051833
            ],
            [
                66,
                254738382
            ],
            [
                67,
                254848457
            ],
            [
                68,
                254962300
            ],
            [
                69,
                255071355
            ],
            [
                70,
                255183860
            ],
            [
                71,
                255349693
            ],
            [
                72,
                255834513
            ],
            [
                73,
                256240051
            ],
            [
                74,
                256739602
            ],
            [
                75,
                256795555
            ],
            [
                76,
                256837021
            ],
            [
                77,
                256887647
            ]
        ],
        name: 'incredibles',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Incredibles',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#7F3E2C'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                15635225
            ],
            [
                2,
                38352880
            ],
            [
                3,
                55082330
            ],
            [
                4,
                58694015
            ],
            [
                5,
                63572135
            ],
            [
                6,
                72942795
            ],
            [
                7,
                84977355
            ],
            [
                8,
                104721580
            ],
            [
                9,
                124544130
            ],
            [
                10,
                137095800
            ],
            [
                11,
                139273930
            ],
            [
                12,
                141311030
            ],
            [
                13,
                143081740
            ],
            [
                14,
                144899460
            ],
            [
                15,
                151520640
            ],
            [
                16,
                163680390
            ],
            [
                17,
                171996090
            ],
            [
                18,
                173188530
            ],
            [
                19,
                174553560
            ],
            [
                20,
                175744455
            ],
            [
                21,
                176999655
            ],
            [
                22,
                181358995
            ],
            [
                23,
                190061765
            ],
            [
                24,
                195646175
            ],
            [
                25,
                196505315
            ],
            [
                26,
                197698565
            ],
            [
                27,
                198684120
            ],
            [
                28,
                199828935
            ],
            [
                29,
                203036095
            ],
            [
                30,
                209157375
            ],
            [
                31,
                213634400
            ],
            [
                32,
                214839120
            ],
            [
                33,
                216418280
            ],
            [
                34,
                218177405
            ],
            [
                35,
                220391530
            ],
            [
                36,
                224378170
            ],
            [
                37,
                229867710
            ],
            [
                38,
                232636205
            ],
            [
                39,
                235119990
            ],
            [
                40,
                238394730
            ],
            [
                41,
                241400285
            ],
            [
                42,
                244342805
            ],
            [
                43,
                247329950
            ],
            [
                44,
                249858745
            ],
            [
                45,
                251628905
            ],
            [
                46,
                253367455
            ],
            [
                47,
                254315750
            ],
            [
                48,
                254853120
            ],
            [
                49,
                255327115
            ],
            [
                50,
                255988585
            ],
            [
                51,
                257116975
            ],
            [
                52,
                257830325
            ],
            [
                53,
                257959990
            ],
            [
                54,
                258088985
            ],
            [
                55,
                258191470
            ],
            [
                56,
                258295695
            ],
            [
                57,
                258386880
            ],
            [
                58,
                258642240
            ],
            [
                59,
                258833760
            ],
            [
                60,
                259011600
            ],
            [
                61,
                259038960
            ],
            [
                62,
                259061745
            ],
            [
                63,
                259084590
            ],
            [
                64,
                259122390
            ],
            [
                65,
                259215630
            ],
            [
                66,
                259286185
            ],
            [
                67,
                259296265
            ],
            [
                68,
                259308865
            ],
            [
                69,
                259319010
            ],
            [
                70,
                259329065
            ],
            [
                71,
                259362555
            ],
            [
                72,
                259441350
            ],
            [
                73,
                259484690
            ],
            [
                74,
                259496510
            ],
            [
                75,
                259510300
            ],
            [
                76,
                259520150
            ],
            [
                77,
                259530195
            ],
            [
                78,
                259558980
            ],
            [
                79,
                259627155
            ],
            [
                80,
                259674120
            ],
            [
                81,
                259683210
            ],
            [
                82,
                259693815
            ],
            [
                83,
                259701390
            ],
            [
                84,
                259709015
            ],
            [
                85,
                259727475
            ],
            [
                86,
                259772915
            ],
            [
                87,
                259806995
            ],
            [
                88,
                259815600
            ],
            [
                89,
                259822700
            ],
            [
                90,
                259831220
            ],
            [
                91,
                259838305
            ],
            [
                92,
                259856085
            ],
            [
                93,
                259896720
            ],
            [
                94,
                259928470
            ],
            [
                95,
                259951325
            ],
            [
                96,
                259958945
            ],
            [
                97,
                259965295
            ],
            [
                98,
                259971710
            ],
            [
                99,
                259984595
            ],
            [
                100,
                260011255
            ],
            [
                101,
                260031035
            ],
            [
                102,
                260035330
            ],
            [
                103,
                260038770
            ],
            [
                104,
                260041350
            ],
            [
                105,
                260044825
            ]
        ],
        name: 'grinch',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'How the Grinch Stole Christmas',
            genre: 'Family Comedy',

            mpaaRating: 'PG',
            imgMainColor: '#444E50'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                36926192
            ],
            [
                2,
                71593056
            ],
            [
                3,
                95023721
            ],
            [
                4,
                101243273
            ],
            [
                5,
                108220329
            ],
            [
                6,
                113026031
            ],
            [
                7,
                117608171
            ],
            [
                8,
                129474912
            ],
            [
                9,
                147209267
            ],
            [
                10,
                158883032
            ],
            [
                11,
                162345947
            ],
            [
                12,
                167072687
            ],
            [
                13,
                170596745
            ],
            [
                14,
                174914454
            ],
            [
                15,
                184418202
            ],
            [
                16,
                194754995
            ],
            [
                17,
                200501510
            ],
            [
                18,
                203096637
            ],
            [
                19,
                205301885
            ],
            [
                20,
                207075438
            ],
            [
                21,
                208840216
            ],
            [
                22,
                213255737
            ],
            [
                23,
                220574145
            ],
            [
                24,
                225059241
            ],
            [
                25,
                226126753
            ],
            [
                26,
                227466993
            ],
            [
                27,
                228529867
            ],
            [
                28,
                229381211
            ],
            [
                29,
                231480995
            ],
            [
                30,
                235004950
            ],
            [
                31,
                237155480
            ],
            [
                32,
                237666580
            ],
            [
                33,
                238330585
            ],
            [
                34,
                238868692
            ],
            [
                35,
                239377745
            ],
            [
                36,
                240864992
            ],
            [
                37,
                243416292
            ],
            [
                38,
                245128338
            ],
            [
                39,
                245539157
            ],
            [
                40,
                246043328
            ],
            [
                41,
                246464860
            ],
            [
                42,
                246868246
            ],
            [
                43,
                247888643
            ],
            [
                44,
                249510424
            ],
            [
                45,
                250532304
            ],
            [
                46,
                250905982
            ],
            [
                47,
                251251967
            ],
            [
                48,
                251546149
            ],
            [
                49,
                251840998
            ],
            [
                50,
                252285235
            ],
            [
                51,
                252955776
            ],
            [
                52,
                253585725
            ],
            [
                53,
                254112096
            ],
            [
                54,
                254273264
            ],
            [
                55,
                254419639
            ],
            [
                56,
                254549284
            ],
            [
                57,
                254728932
            ],
            [
                58,
                255019094
            ],
            [
                59,
                255176550
            ],
            [
                60,
                255241134
            ],
            [
                61,
                255315779
            ],
            [
                62,
                255384620
            ],
            [
                63,
                255447104
            ]
        ],
        name: 'marvel14b',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Captain America: The Winter Soldier',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#5B5E5C'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                31190587
            ],
            [
                2,
                55621003
            ],
            [
                3,
                73645197
            ],
            [
                4,
                79847401
            ],
            [
                5,
                86142832
            ],
            [
                6,
                90998253
            ],
            [
                7,
                96045417
            ],
            [
                8,
                104671476
            ],
            [
                9,
                116942036
            ],
            [
                10,
                127550695
            ],
            [
                11,
                135373784
            ],
            [
                12,
                140639480
            ],
            [
                13,
                149945775
            ],
            [
                14,
                160469546
            ],
            [
                15,
                170474667
            ],
            [
                16,
                181060189
            ],
            [
                17,
                189501278
            ],
            [
                18,
                196014832
            ],
            [
                19,
                201542078
            ],
            [
                20,
                209334252
            ],
            [
                21,
                213384422
            ],
            [
                22,
                218481838
            ],
            [
                23,
                225152946
            ],
            [
                24,
                229059642
            ],
            [
                25,
                230360654
            ],
            [
                26,
                231928906
            ],
            [
                27,
                233100248
            ],
            [
                28,
                234204435
            ],
            [
                29,
                236249502
            ],
            [
                30,
                239939300
            ],
            [
                31,
                242226788
            ],
            [
                32,
                242844948
            ],
            [
                33,
                243628184
            ],
            [
                34,
                244222639
            ],
            [
                35,
                244819845
            ],
            [
                36,
                245714065
            ],
            [
                37,
                247465176
            ],
            [
                38,
                248524802
            ],
            [
                39,
                249360009
            ],
            [
                40,
                249681194
            ],
            [
                41,
                249928468
            ],
            [
                42,
                250178924
            ],
            [
                43,
                250679199
            ],
            [
                44,
                251680488
            ],
            [
                45,
                252326338
            ],
            [
                46,
                252488560
            ],
            [
                47,
                252701565
            ],
            [
                48,
                252861318
            ],
            [
                49,
                253029814
            ],
            [
                50,
                253367459
            ],
            [
                51,
                254024573
            ],
            [
                52,
                254264916
            ],
            [
                53,
                254373056
            ],
            [
                54,
                254497516
            ],
            [
                55,
                254599912
            ],
            [
                56,
                254710178
            ],
            [
                57,
                254867885
            ],
            [
                58,
                255194930
            ],
            [
                59,
                255398374
            ],
            [
                60,
                255464576
            ],
            [
                61,
                255534070
            ],
            [
                62,
                255576240
            ],
            [
                63,
                255625377
            ],
            [
                64,
                255768974
            ],
            [
                65,
                255966978
            ],
            [
                66,
                256122886
            ],
            [
                67,
                256231641
            ],
            [
                68,
                256274853
            ],
            [
                69,
                256309318
            ],
            [
                70,
                256343744
            ],
            [
                71,
                256418657
            ],
            [
                72,
                256558495
            ],
            [
                73,
                256636874
            ],
            [
                74,
                256661251
            ],
            [
                75,
                256693502
            ],
            [
                76,
                256719001
            ],
            [
                77,
                256748112
            ],
            [
                78,
                256800863
            ],
            [
                79,
                256901034
            ],
            [
                80,
                256961185
            ],
            [
                81,
                256982291
            ],
            [
                82,
                257010760
            ],
            [
                83,
                257028997
            ],
            [
                84,
                257053307
            ],
            [
                85,
                257140616
            ],
            [
                86,
                257296927
            ],
            [
                87,
                257397516
            ],
            [
                88,
                257435546
            ],
            [
                89,
                257479615
            ],
            [
                90,
                257516050
            ],
            [
                91,
                257557425
            ],
            [
                92,
                257625839
            ],
            [
                93,
                257735871
            ],
            [
                94,
                257805640
            ],
            [
                95,
                257827966
            ],
            [
                96,
                257855596
            ],
            [
                97,
                257879181
            ],
            [
                98,
                257903709
            ],
            [
                99,
                257939365
            ],
            [
                100,
                257998952
            ],
            [
                101,
                258039176
            ],
            [
                102,
                258054063
            ],
            [
                103,
                258070038
            ],
            [
                104,
                258085872
            ],
            [
                105,
                258102656
            ],
            [
                106,
                258131481
            ],
            [
                107,
                258179384
            ],
            [
                108,
                258206253
            ],
            [
                109,
                258216400
            ],
            [
                110,
                258226423
            ],
            [
                111,
                258236387
            ],
            [
                112,
                258246584
            ],
            [
                113,
                258264154
            ],
            [
                114,
                258289806
            ],
            [
                115,
                258307304
            ],
            [
                116,
                258312353
            ],
            [
                117,
                258317855
            ],
            [
                118,
                258322697
            ],
            [
                119,
                258327975
            ],
            [
                120,
                258335388
            ],
            [
                121,
                258347722
            ],
            [
                122,
                258355354
            ],
            [
                123,
                258357625
            ],
            [
                124,
                258360282
            ],
            [
                125,
                258363104
            ],
            [
                126,
                258366855
            ]
        ],
        name: 'hobbit2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hobbit: The Desolation of Smaug',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#372D20'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                17094132
            ],
            [
                2,
                47907731
            ],
            [
                3,
                69050279
            ],
            [
                4,
                72544343
            ],
            [
                5,
                75675447
            ],
            [
                6,
                77861671
            ],
            [
                7,
                80302930
            ],
            [
                8,
                93101604
            ],
            [
                9,
                113364021
            ],
            [
                10,
                130149360
            ],
            [
                11,
                142781396
            ],
            [
                12,
                146333594
            ],
            [
                13,
                149006940
            ],
            [
                14,
                151710096
            ],
            [
                15,
                158985835
            ],
            [
                16,
                173464868
            ],
            [
                17,
                183015455
            ],
            [
                18,
                184256605
            ],
            [
                19,
                185829929
            ],
            [
                20,
                187047966
            ],
            [
                21,
                188310084
            ],
            [
                22,
                192721994
            ],
            [
                23,
                202987811
            ],
            [
                24,
                209138440
            ],
            [
                25,
                210406935
            ],
            [
                26,
                211954057
            ],
            [
                27,
                212928472
            ],
            [
                28,
                213966612
            ],
            [
                29,
                216493151
            ],
            [
                30,
                221606983
            ],
            [
                31,
                224877997
            ],
            [
                32,
                225845025
            ],
            [
                33,
                227123377
            ],
            [
                34,
                228142711
            ],
            [
                35,
                229226928
            ],
            [
                36,
                231280318
            ],
            [
                37,
                234628399
            ],
            [
                38,
                236928237
            ],
            [
                39,
                237541707
            ],
            [
                40,
                238205322
            ],
            [
                41,
                238753354
            ],
            [
                42,
                239236674
            ],
            [
                43,
                240213180
            ],
            [
                44,
                242064979
            ],
            [
                45,
                243385918
            ],
            [
                46,
                243796694
            ],
            [
                47,
                244327702
            ],
            [
                48,
                244767854
            ],
            [
                49,
                245198720
            ],
            [
                50,
                245921628
            ],
            [
                51,
                247345902
            ],
            [
                52,
                248216780
            ],
            [
                53,
                248466064
            ],
            [
                54,
                248749247
            ],
            [
                55,
                248981712
            ],
            [
                56,
                249206303
            ],
            [
                57,
                249566394
            ],
            [
                58,
                250196189
            ],
            [
                59,
                250608584
            ],
            [
                60,
                250729663
            ],
            [
                61,
                250860428
            ],
            [
                62,
                250963732
            ],
            [
                63,
                251058771
            ],
            [
                64,
                251178965
            ],
            [
                65,
                251395075
            ],
            [
                66,
                251560804
            ],
            [
                67,
                251618809
            ],
            [
                68,
                251710777
            ],
            [
                69,
                251779672
            ],
            [
                70,
                251859590
            ],
            [
                71,
                252021043
            ],
            [
                72,
                252176396
            ],
            [
                73,
                252259056
            ],
            [
                74,
                252326549
            ],
            [
                75,
                252365392
            ],
            [
                76,
                252405232
            ],
            [
                77,
                252442478
            ],
            [
                78,
                252525956
            ],
            [
                79,
                252694698
            ],
            [
                80,
                252798441
            ],
            [
                81,
                252819786
            ],
            [
                82,
                252840917
            ],
            [
                83,
                252859723
            ],
            [
                84,
                252877964
            ],
            [
                85,
                252932340
            ],
            [
                86,
                253037002
            ],
            [
                87,
                253106875
            ],
            [
                88,
                253121548
            ],
            [
                89,
                253143246
            ],
            [
                90,
                253160557
            ],
            [
                91,
                253178106
            ],
            [
                92,
                253297197
            ],
            [
                93,
                253511434
            ],
            [
                94,
                253666490
            ],
            [
                95,
                253703337
            ],
            [
                96,
                253743500
            ],
            [
                97,
                253780046
            ],
            [
                98,
                253817652
            ],
            [
                99,
                253943936
            ],
            [
                100,
                254182337
            ],
            [
                101,
                254342250
            ],
            [
                102,
                254391823
            ],
            [
                103,
                254434447
            ],
            [
                104,
                254472429
            ],
            [
                105,
                254514488
            ],
            [
                106,
                254612385
            ],
            [
                107,
                254774915
            ],
            [
                108,
                254921743
            ],
            [
                109,
                255055805
            ],
            [
                110,
                255089694
            ],
            [
                111,
                255122566
            ],
            [
                112,
                255160511
            ],
            [
                113,
                255235848
            ],
            [
                114,
                255352759
            ],
            [
                115,
                255436997
            ],
            [
                116,
                255469249
            ],
            [
                117,
                255507918
            ],
            [
                118,
                255548520
            ],
            [
                119,
                255590340
            ],
            [
                120,
                255676885
            ],
            [
                121,
                255793913
            ],
            [
                122,
                255878392
            ],
            [
                123,
                255925796
            ],
            [
                124,
                255981549
            ],
            [
                125,
                256041204
            ],
            [
                126,
                256103031
            ],
            [
                127,
                256169386
            ],
            [
                128,
                256250586
            ],
            [
                129,
                256330271
            ],
            [
                130,
                256373719
            ],
            [
                131,
                256417582
            ],
            [
                132,
                256480713
            ],
            [
                133,
                256523725
            ],
            [
                134,
                256580457
            ],
            [
                135,
                256648286
            ],
            [
                136,
                256696317
            ],
            [
                137,
                256728844
            ],
            [
                138,
                256770706
            ],
            [
                139,
                256813462
            ],
            [
                140,
                256853726
            ],
            [
                141,
                256902692
            ],
            [
                142,
                256956996
            ],
            [
                143,
                257000260
            ],
            [
                144,
                257029805
            ],
            [
                145,
                257061167
            ],
            [
                146,
                257092045
            ],
            [
                147,
                257122203
            ],
            [
                148,
                257140904
            ],
            [
                149,
                257164974
            ],
            [
                150,
                257186165
            ],
            [
                151,
                257202393
            ],
            [
                152,
                257221361
            ],
            [
                153,
                257238953
            ],
            [
                154,
                257257169
            ],
            [
                155,
                257282176
            ],
            [
                156,
                257310950
            ],
            [
                157,
                257335781
            ],
            [
                158,
                257360168
            ],
            [
                159,
                257386649
            ],
            [
                160,
                257417504
            ],
            [
                161,
                257442541
            ],
            [
                162,
                257457399
            ],
            [
                163,
                257471951
            ],
            [
                164,
                257484827
            ],
            [
                165,
                257497614
            ],
            [
                166,
                257514046
            ],
            [
                167,
                257529703
            ],
            [
                168,
                257546492
            ],
            [
                169,
                257558136
            ],
            [
                170,
                257569513
            ],
            [
                171,
                257582914
            ],
            [
                172,
                257592581
            ],
            [
                173,
                257633962
            ],
            [
                174,
                257687552
            ],
            [
                175,
                257709556
            ],
            [
                176,
                257711715
            ],
            [
                177,
                257714297
            ],
            [
                178,
                257716507
            ],
            [
                179,
                257718668
            ],
            [
                180,
                257724678
            ],
            [
                181,
                257725907
            ],
            [
                182,
                257726852
            ],
            [
                183,
                257728146
            ],
            [
                184,
                257729616
            ],
            [
                185,
                257731107
            ],
            [
                186,
                257732595
            ],
            [
                187,
                257734359
            ],
            [
                188,
                257737068
            ],
            [
                189,
                257740531
            ],
            [
                190,
                257741614
            ],
            [
                191,
                257742752
            ],
            [
                192,
                257743820
            ],
            [
                193,
                257745430
            ],
            [
                194,
                257746769
            ],
            [
                195,
                257748132
            ],
            [
                196,
                257749270
            ],
            [
                197,
                257749440
            ],
            [
                198,
                257749590
            ],
            [
                199,
                257749647
            ],
            [
                200,
                257749702
            ],
            [
                201,
                257750038
            ],
            [
                202,
                257750402
            ],
            [
                203,
                257750702
            ],
            [
                204,
                257752034
            ],
            [
                205,
                257753341
            ],
            [
                206,
                257754698
            ],
            [
                207,
                257756197
            ],
            [
                208,
                257757671
            ],
            [
                209,
                257759191
            ],
            [
                210,
                257760692
            ]
        ],
        name: 'lego',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The LEGO Movie',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#5F597D'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                0,
                4000000
            ],
            [
                1,
                30893975
            ],
            [
                2,
                58142588
            ],
            [
                3,
                79204289
            ],
            [
                4,
                86706315
            ],
            [
                5,
                93212090
            ],
            [
                6,
                99002539
            ],
            [
                7,
                104610837
            ],
            [
                8,
                116370953
            ],
            [
                9,
                134655023
            ],
            [
                10,
                147645384
            ],
            [
                11,
                152175578
            ],
            [
                12,
                155536131
            ],
            [
                13,
                158653970
            ],
            [
                14,
                161634019
            ],
            [
                15,
                167528194
            ],
            [
                16,
                176029128
            ],
            [
                17,
                184526281
            ],
            [
                18,
                191014403
            ],
            [
                19,
                193027281
            ],
            [
                20,
                194828380
            ],
            [
                21,
                196700157
            ],
            [
                22,
                200319725
            ],
            [
                23,
                205705246
            ],
            [
                24,
                209313884
            ],
            [
                25,
                210586019
            ],
            [
                26,
                211908809
            ],
            [
                27,
                213171805
            ],
            [
                28,
                214401695
            ],
            [
                29,
                216882420
            ],
            [
                30,
                220422696
            ],
            [
                31,
                222712175
            ],
            [
                32,
                223638905
            ],
            [
                33,
                224564055
            ],
            [
                34,
                225473885
            ],
            [
                35,
                226428402
            ],
            [
                36,
                227976174
            ],
            [
                37,
                230367638
            ],
            [
                38,
                231882965
            ],
            [
                39,
                232557467
            ],
            [
                40,
                233291888
            ],
            [
                41,
                233992475
            ],
            [
                42,
                234743906
            ],
            [
                43,
                235976885
            ],
            [
                44,
                237968898
            ],
            [
                45,
                240255340
            ],
            [
                46,
                240823706
            ],
            [
                47,
                241361911
            ],
            [
                48,
                242063184
            ],
            [
                49,
                242619214
            ],
            [
                50,
                243802725
            ],
            [
                51,
                245367595
            ],
            [
                52,
                246331182
            ],
            [
                53,
                246779912
            ],
            [
                54,
                247306259
            ],
            [
                55,
                247625972
            ],
            [
                56,
                248068172
            ],
            [
                57,
                248805036
            ],
            [
                58,
                249334504
            ],
            [
                59,
                249838139
            ],
            [
                60,
                250088417
            ],
            [
                61,
                250335827
            ],
            [
                62,
                250570144
            ],
            [
                63,
                250806379
            ],
            [
                64,
                251171644
            ],
            [
                65,
                251655655
            ],
            [
                66,
                251970795
            ],
            [
                67,
                252119599
            ],
            [
                68,
                252266670
            ],
            [
                69,
                252365299
            ],
            [
                70,
                252473974
            ],
            [
                71,
                252677040
            ],
            [
                72,
                252976117
            ],
            [
                73,
                253164613
            ],
            [
                74,
                253251652
            ],
            [
                75,
                253359387
            ],
            [
                76,
                253460512
            ],
            [
                77,
                253580933
            ],
            [
                78,
                253710838
            ],
            [
                79,
                253892841
            ],
            [
                80,
                254020378
            ],
            [
                81,
                254089632
            ],
            [
                82,
                254170379
            ],
            [
                83,
                254255507
            ],
            [
                84,
                254334469
            ],
            [
                85,
                254426936
            ],
            [
                86,
                254557321
            ],
            [
                87,
                254661846
            ],
            [
                88,
                254719311
            ],
            [
                89,
                254777330
            ],
            [
                90,
                254834025
            ],
            [
                91,
                254889130
            ],
            [
                92,
                255020651
            ],
            [
                93,
                255202930
            ],
            [
                94,
                255327784
            ],
            [
                95,
                255396149
            ],
            [
                96,
                255471687
            ],
            [
                97,
                255541196
            ],
            [
                98,
                255612397
            ],
            [
                99,
                255711760
            ],
            [
                100,
                255846203
            ],
            [
                101,
                255936227
            ],
            [
                102,
                255985786
            ],
            [
                103,
                256038213
            ],
            [
                104,
                256083762
            ],
            [
                105,
                256133843
            ],
            [
                106,
                256210077
            ],
            [
                107,
                256313314
            ],
            [
                108,
                256374154
            ],
            [
                109,
                256402634
            ],
            [
                110,
                256428821
            ],
            [
                111,
                256457790
            ],
            [
                112,
                256490791
            ],
            [
                113,
                256545569
            ],
            [
                114,
                256629655
            ],
            [
                115,
                256673273
            ],
            [
                116,
                256694793
            ],
            [
                117,
                256717048
            ],
            [
                118,
                256739608
            ],
            [
                119,
                256764966
            ],
            [
                120,
                256841638
            ],
            [
                121,
                256961236
            ],
            [
                122,
                257094634
            ],
            [
                123,
                257171491
            ],
            [
                124,
                257191845
            ],
            [
                125,
                257209773
            ],
            [
                126,
                257233992
            ],
            [
                127,
                257289823
            ],
            [
                128,
                257383678
            ],
            [
                129,
                257424306
            ],
            [
                130,
                257440581
            ],
            [
                131,
                257458458
            ],
            [
                132,
                257479558
            ],
            [
                133,
                257503685
            ],
            [
                134,
                257535408
            ],
            [
                135,
                257584462
            ],
            [
                136,
                257604001
            ],
            [
                137,
                257611714
            ],
            [
                138,
                257619036
            ],
            [
                139,
                257628094
            ],
            [
                140,
                257638255
            ],
            [
                141,
                257657973
            ],
            [
                142,
                257690448
            ],
            [
                143,
                257704099
            ],
            [
                144,
                257710778
            ],
            [
                145,
                257716123
            ],
            [
                146,
                257721833
            ],
            [
                147,
                257730019
            ]
        ],
        name: 'startrek11',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Star Trek',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#8E979B'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                30059386
            ],
            [
                2,
                58854500
            ],
            [
                3,
                77211321
            ],
            [
                4,
                84676771
            ],
            [
                5,
                91179888
            ],
            [
                6,
                97201184
            ],
            [
                7,
                103265293
            ],
            [
                8,
                114173200
            ],
            [
                9,
                126575006
            ],
            [
                10,
                136768494
            ],
            [
                11,
                141169517
            ],
            [
                12,
                150950671
            ],
            [
                13,
                159672020
            ],
            [
                14,
                167075237
            ],
            [
                15,
                176360519
            ],
            [
                16,
                186245378
            ],
            [
                17,
                194489704
            ],
            [
                18,
                199345154
            ],
            [
                19,
                206129574
            ],
            [
                20,
                209506903
            ],
            [
                21,
                212338204
            ],
            [
                22,
                217524065
            ],
            [
                23,
                224370732
            ],
            [
                24,
                228055662
            ],
            [
                25,
                229118908
            ],
            [
                26,
                230187062
            ],
            [
                27,
                231170492
            ],
            [
                28,
                232103841
            ],
            [
                29,
                234657832
            ],
            [
                30,
                238342192
            ],
            [
                31,
                240283451
            ],
            [
                32,
                240869820
            ],
            [
                33,
                241444213
            ],
            [
                34,
                241995994
            ],
            [
                35,
                242577424
            ],
            [
                36,
                243961942
            ],
            [
                37,
                246171454
            ],
            [
                38,
                247468797
            ],
            [
                39,
                248482867
            ],
            [
                40,
                248815030
            ],
            [
                41,
                249122328
            ],
            [
                42,
                249455640
            ],
            [
                43,
                250049656
            ],
            [
                44,
                251113537
            ],
            [
                45,
                251666936
            ],
            [
                46,
                251820178
            ],
            [
                47,
                251962543
            ],
            [
                48,
                252106654
            ],
            [
                49,
                252247711
            ],
            [
                50,
                252545958
            ],
            [
                51,
                253105383
            ],
            [
                52,
                253263158
            ],
            [
                53,
                253347464
            ],
            [
                54,
                253420893
            ],
            [
                55,
                253493274
            ],
            [
                56,
                253571734
            ],
            [
                57,
                253726349
            ],
            [
                58,
                254011393
            ],
            [
                59,
                254161107
            ],
            [
                60,
                254205399
            ],
            [
                61,
                254244650
            ],
            [
                62,
                254280993
            ],
            [
                63,
                254324468
            ],
            [
                64,
                254391955
            ],
            [
                65,
                254507764
            ],
            [
                66,
                254592462
            ],
            [
                67,
                254643034
            ],
            [
                68,
                254660926
            ],
            [
                69,
                254677693
            ],
            [
                70,
                254695259
            ],
            [
                71,
                254735176
            ],
            [
                72,
                254805378
            ],
            [
                73,
                254846426
            ],
            [
                74,
                254856495
            ],
            [
                75,
                254867239
            ],
            [
                76,
                254876501
            ],
            [
                77,
                254887764
            ],
            [
                78,
                254988274
            ],
            [
                79,
                255165109
            ],
            [
                80,
                255268029
            ],
            [
                81,
                255299643
            ],
            [
                82,
                255331126
            ],
            [
                83,
                255360875
            ],
            [
                84,
                255392764
            ],
            [
                85,
                255476605
            ],
            [
                86,
                255610983
            ],
            [
                87,
                255687117
            ],
            [
                88,
                255711141
            ],
            [
                89,
                255735812
            ],
            [
                90,
                255759710
            ],
            [
                91,
                255786554
            ],
            [
                92,
                255849048
            ],
            [
                93,
                255952386
            ],
            [
                94,
                256015411
            ],
            [
                95,
                256037850
            ],
            [
                96,
                256060567
            ],
            [
                97,
                256084161
            ],
            [
                98,
                256112613
            ],
            [
                99,
                256153119
            ],
            [
                100,
                256199982
            ],
            [
                101,
                256227323
            ],
            [
                102,
                256242250
            ],
            [
                103,
                256254878
            ],
            [
                104,
                256266812
            ],
            [
                105,
                256279068
            ],
            [
                106,
                256296978
            ],
            [
                107,
                256325045
            ],
            [
                108,
                256339571
            ],
            [
                109,
                256343491
            ],
            [
                110,
                256347494
            ],
            [
                111,
                256351306
            ],
            [
                112,
                256356018
            ],
            [
                113,
                256364599
            ],
            [
                114,
                256379239
            ],
            [
                115,
                256386216
            ],
            [
                116,
                256388100
            ],
            [
                117,
                256390149
            ],
            [
                118,
                256391475
            ],
            [
                119,
                256393010
            ]
        ],
        name: 'iamlegend',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'I Am Legend',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#837044'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                11038423
            ],
            [
                2,
                24780866
            ],
            [
                3,
                34119372
            ],
            [
                4,
                37777442
            ],
            [
                5,
                42719653
            ],
            [
                6,
                50638142
            ],
            [
                7,
                60127477
            ],
            [
                8,
                76313333
            ],
            [
                9,
                92186267
            ],
            [
                10,
                100238841
            ],
            [
                11,
                102302162
            ],
            [
                12,
                104619548
            ],
            [
                13,
                106747005
            ],
            [
                14,
                108824378
            ],
            [
                15,
                115593204
            ],
            [
                16,
                124141096
            ],
            [
                17,
                128867559
            ],
            [
                18,
                130309730
            ],
            [
                19,
                131879132
            ],
            [
                20,
                133293080
            ],
            [
                21,
                134761539
            ],
            [
                22,
                139487248
            ],
            [
                23,
                146365508
            ],
            [
                24,
                149816797
            ],
            [
                25,
                150910191
            ],
            [
                26,
                152178442
            ],
            [
                27,
                153390852
            ],
            [
                28,
                154704245
            ],
            [
                29,
                157885546
            ],
            [
                30,
                161792920
            ],
            [
                31,
                164725525
            ],
            [
                32,
                166726943
            ],
            [
                33,
                168945040
            ],
            [
                34,
                171122488
            ],
            [
                35,
                172676636
            ],
            [
                36,
                176049041
            ],
            [
                37,
                180705468
            ],
            [
                38,
                184195981
            ],
            [
                39,
                187028691
            ],
            [
                40,
                190032257
            ],
            [
                41,
                193098093
            ],
            [
                42,
                196563318
            ],
            [
                43,
                201118097
            ],
            [
                44,
                206115756
            ],
            [
                45,
                208476067
            ],
            [
                46,
                209300187
            ],
            [
                47,
                210068528
            ],
            [
                48,
                210808692
            ],
            [
                49,
                211446909
            ],
            [
                50,
                213666162
            ],
            [
                51,
                217118901
            ],
            [
                52,
                218978376
            ],
            [
                53,
                219479602
            ],
            [
                54,
                220033786
            ],
            [
                55,
                220602183
            ],
            [
                56,
                221209265
            ],
            [
                57,
                222786647
            ],
            [
                58,
                225141023
            ],
            [
                59,
                226766539
            ],
            [
                60,
                228181615
            ],
            [
                61,
                228628890
            ],
            [
                62,
                229038168
            ],
            [
                63,
                229512266
            ],
            [
                64,
                230746409
            ],
            [
                65,
                232850310
            ],
            [
                66,
                233678402
            ],
            [
                67,
                233982624
            ],
            [
                68,
                234295385
            ],
            [
                69,
                234593473
            ],
            [
                70,
                234893488
            ],
            [
                71,
                235691598
            ],
            [
                72,
                237129113
            ],
            [
                73,
                237914805
            ],
            [
                74,
                238142164
            ],
            [
                75,
                238430210
            ],
            [
                76,
                238732222
            ],
            [
                77,
                239026369
            ],
            [
                78,
                239799924
            ],
            [
                79,
                241146044
            ],
            [
                80,
                241529593
            ],
            [
                81,
                241740702
            ],
            [
                82,
                241979020
            ],
            [
                83,
                242200104
            ],
            [
                84,
                242466341
            ],
            [
                85,
                242929538
            ],
            [
                86,
                243853133
            ],
            [
                87,
                244728128
            ],
            [
                88,
                245133549
            ],
            [
                89,
                245295717
            ],
            [
                90,
                245450449
            ],
            [
                91,
                245619952
            ],
            [
                92,
                246012595
            ],
            [
                93,
                246723649
            ],
            [
                94,
                247071052
            ],
            [
                95,
                247180382
            ],
            [
                96,
                247286743
            ],
            [
                97,
                247399187
            ],
            [
                98,
                247517504
            ],
            [
                99,
                247834488
            ],
            [
                100,
                248484298
            ],
            [
                101,
                248755981
            ],
            [
                102,
                248839100
            ],
            [
                103,
                248953327
            ],
            [
                104,
                249075698
            ],
            [
                105,
                249209861
            ],
            [
                106,
                249545415
            ],
            [
                107,
                250181633
            ],
            [
                108,
                250467047
            ],
            [
                109,
                250629341
            ],
            [
                110,
                250799483
            ],
            [
                111,
                250953663
            ],
            [
                112,
                251132171
            ],
            [
                113,
                251604582
            ],
            [
                114,
                252317220
            ],
            [
                115,
                252736267
            ],
            [
                116,
                252900318
            ],
            [
                117,
                253075641
            ],
            [
                118,
                253231923
            ],
            [
                119,
                253396245
            ],
            [
                120,
                253656038
            ],
            [
                121,
                254042731
            ],
            [
                122,
                254273981
            ],
            [
                123,
                254357322
            ],
            [
                124,
                254442096
            ],
            [
                125,
                254517962
            ],
            [
                126,
                254596838
            ],
            [
                127,
                254747501
            ],
            [
                128,
                254952920
            ],
            [
                129,
                255071943
            ],
            [
                130,
                255119553
            ],
            [
                131,
                255170020
            ],
            [
                132,
                255216449
            ],
            [
                133,
                255263128
            ],
            [
                134,
                255349536
            ],
            [
                135,
                255440304
            ],
            [
                136,
                255492549
            ],
            [
                137,
                255522074
            ],
            [
                138,
                255549109
            ],
            [
                139,
                255575729
            ],
            [
                140,
                255603947
            ],
            [
                141,
                255650306
            ],
            [
                142,
                255713779
            ],
            [
                143,
                255740350
            ],
            [
                144,
                255748419
            ],
            [
                145,
                255759189
            ],
            [
                146,
                255768167
            ],
            [
                147,
                255778045
            ],
            [
                148,
                255798645
            ],
            [
                149,
                255832713
            ],
            [
                150,
                255846167
            ],
            [
                151,
                255850871
            ],
            [
                152,
                255856255
            ],
            [
                153,
                255861997
            ],
            [
                154,
                255867313
            ],
            [
                155,
                255877670
            ],
            [
                156,
                255891402
            ],
            [
                157,
                255899261
            ],
            [
                158,
                255902119
            ],
            [
                159,
                255905095
            ],
            [
                160,
                255907512
            ],
            [
                161,
                255910443
            ],
            [
                162,
                255914695
            ],
            [
                163,
                255925725
            ],
            [
                164,
                255929947
            ],
            [
                165,
                255930961
            ],
            [
                166,
                255932390
            ],
            [
                167,
                255933584
            ],
            [
                168,
                255935011
            ],
            [
                169,
                255937678
            ],
            [
                170,
                255942097
            ],
            [
                171,
                255944818
            ],
            [
                172,
                255945460
            ],
            [
                173,
                255946471
            ],
            [
                174,
                255947187
            ],
            [
                175,
                255947990
            ],
            [
                176,
                255948694
            ],
            [
                177,
                255949718
            ],
            [
                178,
                255950375
            ],
            [
                179,
                255950527
            ],
            [
                180,
                255950756
            ],
            [
                181,
                255950991
            ],
            [
                182,
                255951749
            ]
        ],
        name: 'blindside',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Blind Side',
            genre: 'Sports Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#74766F'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                1,
                24452117
            ],
            [
                2,
                34407210
            ],
            [
                3,
                50970581
            ],
            [
                4,
                72367595
            ],
            [
                5,
                89131544
            ],
            [
                6,
                98138554
            ],
            [
                7,
                107941968
            ],
            [
                8,
                113966100
            ],
            [
                9,
                127096118
            ],
            [
                10,
                142704972
            ],
            [
                11,
                157007428
            ],
            [
                12,
                168017513
            ],
            [
                13,
                175575347
            ],
            [
                14,
                183547654
            ],
            [
                15,
                189549326
            ],
            [
                16,
                198869927
            ],
            [
                17,
                207171126
            ],
            [
                18,
                215307016
            ],
            [
                19,
                220602017
            ],
            [
                20,
                222379434
            ],
            [
                21,
                224308892
            ],
            [
                22,
                225747311
            ],
            [
                23,
                227082487
            ],
            [
                24,
                229534084
            ],
            [
                25,
                233763132
            ],
            [
                26,
                236459605
            ],
            [
                27,
                237180324
            ],
            [
                28,
                238182655
            ],
            [
                29,
                238969825
            ],
            [
                30,
                239677115
            ],
            [
                31,
                240862948
            ],
            [
                32,
                243102411
            ],
            [
                33,
                244581810
            ],
            [
                34,
                245656417
            ],
            [
                35,
                246120862
            ],
            [
                36,
                246448344
            ],
            [
                37,
                246770959
            ],
            [
                38,
                247433531
            ],
            [
                39,
                248734835
            ],
            [
                40,
                249545262
            ],
            [
                41,
                249746308
            ],
            [
                42,
                250000941
            ],
            [
                43,
                250206946
            ],
            [
                44,
                250397988
            ],
            [
                45,
                250753102
            ],
            [
                46,
                251434885
            ],
            [
                47,
                251688921
            ],
            [
                48,
                251810229
            ],
            [
                49,
                251946522
            ],
            [
                50,
                252054610
            ],
            [
                51,
                252150902
            ],
            [
                52,
                252329626
            ],
            [
                53,
                252685055
            ],
            [
                54,
                252906934
            ],
            [
                55,
                252980968
            ],
            [
                56,
                253048438
            ],
            [
                57,
                253104782
            ],
            [
                58,
                253161689
            ],
            [
                59,
                253243571
            ],
            [
                60,
                253439737
            ],
            [
                61,
                253573010
            ],
            [
                62,
                253668587
            ],
            [
                63,
                253702950
            ],
            [
                64,
                253732502
            ],
            [
                65,
                253763236
            ],
            [
                66,
                253814387
            ],
            [
                67,
                253896796
            ],
            [
                68,
                253949155
            ],
            [
                69,
                253971146
            ],
            [
                70,
                253997535
            ],
            [
                71,
                254017854
            ],
            [
                72,
                254038783
            ],
            [
                73,
                254111647
            ],
            [
                74,
                254240570
            ],
            [
                75,
                254326629
            ],
            [
                76,
                254359774
            ],
            [
                77,
                254396565
            ],
            [
                78,
                254425998
            ],
            [
                79,
                254456608
            ],
            [
                80,
                254512378
            ],
            [
                81,
                254612496
            ],
            [
                82,
                254672205
            ],
            [
                83,
                254696686
            ],
            [
                84,
                254725573
            ],
            [
                85,
                254748382
            ],
            [
                86,
                254775296
            ],
            [
                87,
                254812558
            ],
            [
                88,
                254875855
            ],
            [
                89,
                254916285
            ],
            [
                90,
                254927762
            ],
            [
                91,
                254940387
            ],
            [
                92,
                254953264
            ],
            [
                93,
                254967930
            ],
            [
                94,
                254988320
            ],
            [
                95,
                255021938
            ],
            [
                96,
                255043150
            ],
            [
                97,
                255050634
            ],
            [
                98,
                255057692
            ],
            [
                99,
                255064405
            ],
            [
                100,
                255071340
            ],
            [
                101,
                255082414
            ],
            [
                102,
                255099393
            ],
            [
                103,
                255108370
            ],
            [
                104,
                255110960
            ],
            [
                105,
                255113783
            ],
            [
                106,
                255116583
            ],
            [
                107,
                255119788
            ]
        ],
        name: 'hobbit3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hobbit: The Battle of the Five Armies',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#414647'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                31610367
            ],
            [
                2,
                61592547
            ],
            [
                3,
                91282555
            ],
            [
                4,
                117556661
            ],
            [
                5,
                135037242
            ],
            [
                6,
                142622321
            ],
            [
                7,
                148915509
            ],
            [
                8,
                154426960
            ],
            [
                9,
                165044408
            ],
            [
                10,
                177870031
            ],
            [
                11,
                185808194
            ],
            [
                12,
                189055393
            ],
            [
                13,
                192314465
            ],
            [
                14,
                195218708
            ],
            [
                15,
                198060132
            ],
            [
                16,
                203759537
            ],
            [
                17,
                211342815
            ],
            [
                18,
                215727461
            ],
            [
                19,
                217611859
            ],
            [
                20,
                219685324
            ],
            [
                21,
                221317031
            ],
            [
                22,
                223039278
            ],
            [
                23,
                226284251
            ],
            [
                24,
                230331745
            ],
            [
                25,
                233110617
            ],
            [
                26,
                234344093
            ],
            [
                27,
                235629560
            ],
            [
                28,
                236850667
            ],
            [
                29,
                238077681
            ],
            [
                30,
                239894257
            ],
            [
                31,
                242211989
            ],
            [
                32,
                243651860
            ],
            [
                33,
                244295348
            ],
            [
                34,
                244948646
            ],
            [
                35,
                245377688
            ],
            [
                36,
                245851882
            ],
            [
                37,
                246549402
            ],
            [
                38,
                247415588
            ],
            [
                39,
                248243615
            ],
            [
                40,
                248651272
            ],
            [
                41,
                248987657
            ],
            [
                42,
                249304706
            ],
            [
                43,
                249619183
            ],
            [
                44,
                250013174
            ],
            [
                45,
                250506220
            ],
            [
                46,
                250817247
            ],
            [
                47,
                250961401
            ],
            [
                48,
                251118756
            ],
            [
                49,
                251255860
            ],
            [
                50,
                251377150
            ],
            [
                51,
                251538932
            ],
            [
                52,
                251756876
            ],
            [
                53,
                251881953
            ],
            [
                54,
                251949495
            ],
            [
                55,
                252025142
            ],
            [
                56,
                252090955
            ],
            [
                57,
                252160717
            ],
            [
                58,
                252257423
            ],
            [
                59,
                252383615
            ],
            [
                60,
                252459309
            ],
            [
                61,
                252500941
            ],
            [
                62,
                252546319
            ],
            [
                63,
                252586252
            ],
            [
                64,
                252628017
            ],
            [
                65,
                252744277
            ],
            [
                66,
                252900898
            ],
            [
                67,
                253027043
            ],
            [
                68,
                253095542
            ],
            [
                69,
                253167645
            ],
            [
                70,
                253234700
            ],
            [
                71,
                253296004
            ],
            [
                72,
                253387186
            ],
            [
                73,
                253503323
            ],
            [
                74,
                253589163
            ],
            [
                75,
                253632942
            ],
            [
                76,
                253680198
            ],
            [
                77,
                253721784
            ],
            [
                78,
                253759628
            ],
            [
                79,
                253813574
            ],
            [
                80,
                253886769
            ],
            [
                81,
                253941292
            ],
            [
                82,
                253967554
            ],
            [
                83,
                253995054
            ],
            [
                84,
                254019329
            ],
            [
                85,
                254042976
            ],
            [
                86,
                254082317
            ],
            [
                87,
                254138229
            ],
            [
                88,
                254174506
            ],
            [
                89,
                254190294
            ],
            [
                90,
                254206513
            ],
            [
                91,
                254222084
            ],
            [
                92,
                254236410
            ],
            [
                93,
                254256383
            ],
            [
                94,
                254285042
            ],
            [
                95,
                254302056
            ],
            [
                96,
                254309713
            ],
            [
                97,
                254318114
            ],
            [
                98,
                254325595
            ],
            [
                99,
                254333102
            ],
            [
                100,
                254348066
            ],
            [
                101,
                254375119
            ],
            [
                102,
                254404872
            ],
            [
                103,
                254416436
            ],
            [
                104,
                254420562
            ],
            [
                105,
                254424152
            ],
            [
                106,
                254427606
            ],
            [
                107,
                254436817
            ],
            [
                108,
                254450912
            ],
            [
                109,
                254455986
            ],
            [
                110,
                254457929
            ],
            [
                111,
                254460203
            ],
            [
                112,
                254462204
            ],
            [
                113,
                254464305
            ]
        ],
        name: 'hangover2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'The Hangover Part II',
            genre: 'Comedy',

            mpaaRating: 'R',
            imgMainColor: '#8A6B4C'
        },
        showlabel: false,
        color: 'rgba(26,188,156,0.75)',
        linkedTo: 'Comedy'
    }, {
        data: [
            [
                1,
                21342640
            ],
            [
                2,
                42181260
            ],
            [
                3,
                56397125
            ],
            [
                4,
                63922665
            ],
            [
                5,
                72073885
            ],
            [
                6,
                79233770
            ],
            [
                7,
                85630895
            ],
            [
                8,
                95766290
            ],
            [
                9,
                108491715
            ],
            [
                10,
                118434555
            ],
            [
                11,
                123318450
            ],
            [
                12,
                128534940
            ],
            [
                13,
                133016220
            ],
            [
                14,
                137600845
            ],
            [
                15,
                145052970
            ],
            [
                16,
                154306020
            ],
            [
                17,
                161289905
            ],
            [
                18,
                164422130
            ],
            [
                19,
                168039465
            ],
            [
                20,
                171350870
            ],
            [
                21,
                174806195
            ],
            [
                22,
                179506805
            ],
            [
                23,
                185594440
            ],
            [
                24,
                190330425
            ],
            [
                25,
                192743765
            ],
            [
                26,
                195373890
            ],
            [
                27,
                197697485
            ],
            [
                28,
                200003985
            ],
            [
                29,
                202853840
            ],
            [
                30,
                206488685
            ],
            [
                31,
                209287345
            ],
            [
                32,
                210754935
            ],
            [
                33,
                212444440
            ],
            [
                34,
                213826705
            ],
            [
                35,
                215226035
            ],
            [
                36,
                217315980
            ],
            [
                37,
                220078215
            ],
            [
                38,
                222197390
            ],
            [
                39,
                223293385
            ],
            [
                40,
                224402670
            ],
            [
                41,
                225514175
            ],
            [
                42,
                226394925
            ],
            [
                43,
                227613545
            ],
            [
                44,
                229469430
            ],
            [
                45,
                231056990
            ],
            [
                46,
                231716435
            ],
            [
                47,
                232398415
            ],
            [
                48,
                232958410
            ],
            [
                49,
                233416405
            ],
            [
                50,
                234167930
            ],
            [
                51,
                235405410
            ],
            [
                52,
                236276085
            ],
            [
                53,
                236568770
            ],
            [
                54,
                236935195
            ],
            [
                55,
                237197300
            ],
            [
                56,
                237450950
            ],
            [
                57,
                238122835
            ],
            [
                58,
                239282865
            ],
            [
                59,
                240434965
            ],
            [
                60,
                241498630
            ],
            [
                61,
                241634615
            ],
            [
                62,
                241738645
            ],
            [
                63,
                241874870
            ],
            [
                64,
                242218620
            ],
            [
                65,
                242988845
            ],
            [
                66,
                243531970
            ],
            [
                67,
                243600965
            ],
            [
                68,
                243684130
            ],
            [
                69,
                243752355
            ],
            [
                70,
                243828050
            ],
            [
                71,
                244026295
            ],
            [
                72,
                244460535
            ],
            [
                73,
                244739015
            ],
            [
                74,
                244786200
            ],
            [
                75,
                244838185
            ],
            [
                76,
                244885070
            ],
            [
                77,
                244932080
            ],
            [
                78,
                245078505
            ],
            [
                79,
                245343855
            ],
            [
                80,
                245514665
            ],
            [
                81,
                245551210
            ],
            [
                82,
                245587875
            ],
            [
                83,
                245618370
            ],
            [
                84,
                245651920
            ],
            [
                85,
                245760725
            ],
            [
                86,
                245966760
            ],
            [
                87,
                246091770
            ],
            [
                88,
                246121865
            ],
            [
                89,
                246151975
            ],
            [
                90,
                246179755
            ],
            [
                91,
                246209750
            ],
            [
                92,
                246303295
            ],
            [
                93,
                246455085
            ],
            [
                94,
                246557455
            ],
            [
                95,
                246624525
            ],
            [
                96,
                246649235
            ],
            [
                97,
                246672180
            ],
            [
                98,
                246705715
            ],
            [
                99,
                246803655
            ],
            [
                100,
                246958035
            ],
            [
                101,
                247050995
            ],
            [
                102,
                247075740
            ],
            [
                103,
                247097470
            ],
            [
                104,
                247120775
            ],
            [
                105,
                247148995
            ],
            [
                106,
                247247815
            ],
            [
                107,
                247416270
            ],
            [
                108,
                247519950
            ],
            [
                109,
                247544285
            ],
            [
                110,
                247565345
            ],
            [
                111,
                247584785
            ],
            [
                112,
                247609095
            ],
            [
                113,
                247688970
            ],
            [
                114,
                247813220
            ],
            [
                115,
                247877105
            ],
            [
                116,
                247903880
            ],
            [
                117,
                247935705
            ],
            [
                118,
                247958990
            ],
            [
                119,
                247984010
            ],
            [
                120,
                248066900
            ],
            [
                121,
                248220415
            ],
            [
                122,
                248312500
            ],
            [
                123,
                248332455
            ],
            [
                124,
                248352545
            ],
            [
                125,
                248375570
            ],
            [
                126,
                248452320
            ],
            [
                127,
                248554695
            ],
            [
                128,
                248714400
            ],
            [
                129,
                248815410
            ],
            [
                130,
                248835885
            ],
            [
                131,
                248860455
            ],
            [
                132,
                248879565
            ],
            [
                133,
                248900040
            ],
            [
                134,
                248963020
            ],
            [
                135,
                249092990
            ],
            [
                136,
                249169375
            ],
            [
                137,
                249202875
            ],
            [
                138,
                249249840
            ],
            [
                139,
                249322990
            ],
            [
                140,
                249361560
            ],
            [
                141,
                249501210
            ],
            [
                142,
                249650170
            ],
            [
                143,
                249724650
            ],
            [
                144,
                249740645
            ],
            [
                145,
                249756475
            ],
            [
                146,
                249771105
            ],
            [
                147,
                249787065
            ],
            [
                148,
                249841650
            ],
            [
                149,
                249939640
            ],
            [
                150,
                250004040
            ],
            [
                151,
                250017900
            ],
            [
                152,
                250033160
            ],
            [
                153,
                250047035
            ],
            [
                154,
                250060965
            ],
            [
                155,
                250104315
            ],
            [
                156,
                250196115
            ],
            [
                157,
                250252285
            ],
            [
                158,
                250267570
            ],
            [
                159,
                250285420
            ],
            [
                160,
                250303190
            ],
            [
                161,
                250322315
            ],
            [
                162,
                250363090
            ],
            [
                163,
                250438815
            ],
            [
                164,
                250493640
            ],
            [
                165,
                250534415
            ],
            [
                166,
                250588005
            ],
            [
                167,
                250638100
            ],
            [
                168,
                250689360
            ],
            [
                169,
                250715415
            ],
            [
                170,
                250748225
            ],
            [
                171,
                250791650
            ],
            [
                172,
                250838935
            ],
            [
                173,
                250902625
            ],
            [
                174,
                250966220
            ],
            [
                175,
                251032805
            ],
            [
                176,
                251083040
            ],
            [
                177,
                251155930
            ],
            [
                178,
                251203225
            ],
            [
                179,
                251225880
            ],
            [
                180,
                251242625
            ],
            [
                181,
                251255430
            ],
            [
                182,
                251266265
            ],
            [
                183,
                251292950
            ],
            [
                184,
                251351690
            ],
            [
                185,
                251384620
            ],
            [
                186,
                251389960
            ],
            [
                187,
                251397970
            ],
            [
                188,
                251405090
            ],
            [
                189,
                251413975
            ],
            [
                190,
                251426310
            ],
            [
                191,
                251453695
            ],
            [
                192,
                251476985
            ],
            [
                193,
                251501645
            ],
            [
                194,
                251505755
            ],
            [
                195,
                251509840
            ],
            [
                196,
                251513985
            ]
        ],
        name: 'despicableme',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Despicable Me',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#717B86'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                0,
                2216138
            ],
            [
                1,
                15377781
            ],
            [
                2,
                29980468
            ],
            [
                3,
                42705884
            ],
            [
                4,
                49945010
            ],
            [
                5,
                57153250
            ],
            [
                6,
                63783535
            ],
            [
                7,
                70144480
            ],
            [
                8,
                78936997
            ],
            [
                9,
                90057798
            ],
            [
                10,
                100219669
            ],
            [
                11,
                107958264
            ],
            [
                12,
                113703047
            ],
            [
                13,
                118061136
            ],
            [
                14,
                122410792
            ],
            [
                15,
                128476389
            ],
            [
                16,
                136086972
            ],
            [
                17,
                141659121
            ],
            [
                18,
                144463967
            ],
            [
                19,
                147204021
            ],
            [
                20,
                149854064
            ],
            [
                21,
                152520733
            ],
            [
                22,
                156831494
            ],
            [
                23,
                162904420
            ],
            [
                24,
                167635148
            ],
            [
                25,
                169835250
            ],
            [
                26,
                172052688
            ],
            [
                27,
                174151848
            ],
            [
                28,
                176357131
            ],
            [
                29,
                179545350
            ],
            [
                30,
                184296772
            ],
            [
                31,
                187521450
            ],
            [
                32,
                189080955
            ],
            [
                33,
                190747700
            ],
            [
                34,
                192294459
            ],
            [
                35,
                193914570
            ],
            [
                36,
                196412592
            ],
            [
                37,
                200212401
            ],
            [
                38,
                202867563
            ],
            [
                39,
                204123594
            ],
            [
                40,
                205429848
            ],
            [
                41,
                206581312
            ],
            [
                42,
                207651005
            ],
            [
                43,
                209575202
            ],
            [
                44,
                212326974
            ],
            [
                45,
                214353921
            ],
            [
                46,
                215313398
            ],
            [
                47,
                216266211
            ],
            [
                48,
                217113599
            ],
            [
                49,
                217949973
            ],
            [
                50,
                219417435
            ],
            [
                51,
                221504398
            ],
            [
                52,
                222976331
            ],
            [
                53,
                223662559
            ],
            [
                54,
                224432796
            ],
            [
                55,
                225060436
            ],
            [
                56,
                225681145
            ],
            [
                57,
                226675877
            ],
            [
                58,
                228066793
            ],
            [
                59,
                229120869
            ],
            [
                60,
                229613123
            ],
            [
                61,
                230140325
            ],
            [
                62,
                230607486
            ],
            [
                63,
                231055636
            ],
            [
                64,
                231806271
            ],
            [
                65,
                232922436
            ],
            [
                66,
                233653196
            ],
            [
                67,
                234004496
            ],
            [
                68,
                234400055
            ],
            [
                69,
                234710967
            ],
            [
                70,
                235019740
            ],
            [
                71,
                235705461
            ],
            [
                72,
                236820232
            ],
            [
                73,
                237886300
            ],
            [
                74,
                238559567
            ],
            [
                75,
                238821951
            ],
            [
                76,
                239013417
            ],
            [
                77,
                239202201
            ],
            [
                78,
                239713190
            ],
            [
                79,
                240610919
            ],
            [
                80,
                241089760
            ],
            [
                81,
                241225863
            ],
            [
                82,
                241380801
            ],
            [
                83,
                241518593
            ],
            [
                84,
                241667348
            ],
            [
                85,
                242047570
            ],
            [
                86,
                242759247
            ],
            [
                87,
                243139754
            ],
            [
                88,
                243241244
            ],
            [
                89,
                243358750
            ],
            [
                90,
                243467344
            ],
            [
                91,
                243569147
            ],
            [
                92,
                243853880
            ],
            [
                93,
                244395163
            ],
            [
                94,
                244670914
            ],
            [
                95,
                244751117
            ],
            [
                96,
                244845187
            ],
            [
                97,
                244927995
            ],
            [
                98,
                245015280
            ],
            [
                99,
                245246353
            ],
            [
                100,
                245665714
            ],
            [
                101,
                245893171
            ],
            [
                102,
                245952581
            ],
            [
                103,
                246017071
            ],
            [
                104,
                246077384
            ],
            [
                105,
                246141960
            ],
            [
                106,
                246324100
            ],
            [
                107,
                246643909
            ],
            [
                108,
                246842109
            ],
            [
                109,
                246931118
            ],
            [
                110,
                246988135
            ],
            [
                111,
                247039796
            ],
            [
                112,
                247095238
            ],
            [
                113,
                247209294
            ],
            [
                114,
                247393404
            ],
            [
                115,
                247501202
            ],
            [
                116,
                247531915
            ],
            [
                117,
                247563788
            ],
            [
                118,
                247595298
            ],
            [
                119,
                247633223
            ],
            [
                120,
                247711837
            ],
            [
                121,
                247855505
            ],
            [
                122,
                247932803
            ],
            [
                123,
                247956602
            ],
            [
                124,
                247983139
            ],
            [
                125,
                248007974
            ],
            [
                126,
                248034112
            ],
            [
                127,
                248238011
            ],
            [
                128,
                248579042
            ],
            [
                129,
                248839030
            ],
            [
                130,
                248915507
            ],
            [
                131,
                248987508
            ],
            [
                132,
                249078923
            ],
            [
                133,
                249177498
            ],
            [
                134,
                249388468
            ],
            [
                135,
                249747560
            ],
            [
                136,
                250003913
            ],
            [
                137,
                250055988
            ],
            [
                138,
                250107463
            ],
            [
                139,
                250154355
            ],
            [
                140,
                250209818
            ],
            [
                141,
                250357458
            ],
            [
                142,
                250583371
            ],
            [
                143,
                250713403
            ],
            [
                144,
                250741823
            ],
            [
                145,
                250769329
            ],
            [
                146,
                250795030
            ],
            [
                147,
                250820573
            ],
            [
                148,
                250864195
            ],
            [
                149,
                250948314
            ],
            [
                150,
                250994366
            ],
            [
                151,
                251005893
            ],
            [
                152,
                251019322
            ],
            [
                153,
                251033893
            ],
            [
                154,
                251057886
            ],
            [
                155,
                251078254
            ],
            [
                156,
                251095680
            ],
            [
                157,
                251108315
            ],
            [
                158,
                251113922
            ],
            [
                159,
                251119620
            ],
            [
                160,
                251125125
            ],
            [
                161,
                251130554
            ],
            [
                162,
                251140828
            ],
            [
                163,
                251155245
            ],
            [
                164,
                251161818
            ],
            [
                165,
                251164550
            ],
            [
                166,
                251167758
            ],
            [
                167,
                251170718
            ],
            [
                168,
                251174274
            ],
            [
                169,
                251176896
            ],
            [
                170,
                251181990
            ],
            [
                171,
                251185407
            ],
            [
                172,
                251186329
            ],
            [
                173,
                251187074
            ],
            [
                174,
                251187883
            ],
            [
                175,
                251188924
            ]
        ],
        name: 'batman',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Batman',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#443230'
        },
        showlabel: false,
        color: 'rgba(241,196,15,0.75)',
        linkedTo: 'Action'
    }, {
        data: [
            [
                1,
                12134015
            ],
            [
                2,
                24725279
            ],
            [
                3,
                30433781
            ],
            [
                4,
                42212651
            ],
            [
                5,
                55718681
            ],
            [
                6,
                67661033
            ],
            [
                7,
                79055249
            ],
            [
                8,
                92598820
            ],
            [
                9,
                106337184
            ],
            [
                10,
                115822154
            ],
            [
                11,
                127286780
            ],
            [
                12,
                133001248
            ],
            [
                13,
                136688682
            ],
            [
                14,
                140096754
            ],
            [
                15,
                147203393
            ],
            [
                16,
                157688762
            ],
            [
                17,
                163840714
            ],
            [
                18,
                165150384
            ],
            [
                19,
                166378984
            ],
            [
                20,
                167501274
            ],
            [
                21,
                168655751
            ],
            [
                22,
                172825236
            ],
            [
                23,
                180268462
            ],
            [
                24,
                185818108
            ],
            [
                25,
                190503618
            ],
            [
                26,
                191329744
            ],
            [
                27,
                192094485
            ],
            [
                28,
                192839932
            ],
            [
                29,
                195937844
            ],
            [
                30,
                202038665
            ],
            [
                31,
                204852656
            ],
            [
                32,
                205520102
            ],
            [
                33,
                206107721
            ],
            [
                34,
                206671090
            ],
            [
                35,
                207287959
            ],
            [
                36,
                209554781
            ],
            [
                37,
                214131702
            ],
            [
                38,
                216845623
            ],
            [
                39,
                217312990
            ],
            [
                40,
                217742977
            ],
            [
                41,
                218173474
            ],
            [
                42,
                218615492
            ],
            [
                43,
                220302288
            ],
            [
                44,
                223740931
            ],
            [
                45,
                225001335
            ],
            [
                46,
                225390476
            ],
            [
                47,
                225751033
            ],
            [
                48,
                226072308
            ],
            [
                49,
                226395996
            ],
            [
                50,
                227670831
            ],
            [
                51,
                230495979
            ],
            [
                52,
                232150355
            ],
            [
                53,
                232477280
            ],
            [
                54,
                232713817
            ],
            [
                55,
                233295750
            ],
            [
                56,
                233633598
            ],
            [
                57,
                234476484
            ],
            [
                58,
                236089415
            ],
            [
                59,
                237338322
            ],
            [
                60,
                238500531
            ],
            [
                61,
                238837286
            ],
            [
                62,
                239140913
            ],
            [
                63,
                239470145
            ],
            [
                64,
                240038934
            ],
            [
                65,
                241061944
            ],
            [
                66,
                241640806
            ],
            [
                67,
                241757025
            ],
            [
                68,
                241856549
            ],
            [
                69,
                241957171
            ],
            [
                70,
                242073469
            ],
            [
                71,
                242384866
            ],
            [
                72,
                243097731
            ],
            [
                73,
                243529237
            ],
            [
                74,
                243607567
            ],
            [
                75,
                243682040
            ],
            [
                76,
                243760687
            ],
            [
                77,
                243844088
            ],
            [
                78,
                244074782
            ],
            [
                79,
                244518338
            ],
            [
                80,
                244766562
            ],
            [
                81,
                244875110
            ],
            [
                82,
                244996357
            ],
            [
                83,
                245115387
            ],
            [
                84,
                245252338
            ],
            [
                85,
                245498781
            ],
            [
                86,
                245870663
            ],
            [
                87,
                246092265
            ],
            [
                88,
                246157847
            ],
            [
                89,
                246224312
            ],
            [
                90,
                246290339
            ],
            [
                91,
                246362856
            ],
            [
                92,
                246523283
            ],
            [
                93,
                246790169
            ],
            [
                94,
                246926396
            ],
            [
                95,
                246968742
            ],
            [
                96,
                247015354
            ],
            [
                97,
                247065177
            ],
            [
                98,
                247115718
            ],
            [
                99,
                247290719
            ],
            [
                100,
                247562220
            ],
            [
                101,
                247718328
            ],
            [
                102,
                247769516
            ],
            [
                103,
                247835724
            ],
            [
                104,
                247905074
            ],
            [
                105,
                247992161
            ],
            [
                106,
                248198243
            ],
            [
                107,
                248425574
            ],
            [
                108,
                248532584
            ],
            [
                109,
                248610582
            ],
            [
                110,
                248674017
            ],
            [
                111,
                248738401
            ],
            [
                112,
                248803583
            ],
            [
                113,
                248947843
            ],
            [
                114,
                249192187
            ],
            [
                115,
                249326139
            ],
            [
                116,
                249360710
            ],
            [
                117,
                249400612
            ],
            [
                118,
                249440648
            ],
            [
                119,
                249478795
            ],
            [
                120,
                249589580
            ],
            [
                121,
                249775113
            ],
            [
                122,
                249869448
            ],
            [
                123,
                249887037
            ],
            [
                124,
                249907861
            ],
            [
                125,
                249927806
            ],
            [
                126,
                249949828
            ],
            [
                127,
                250027721
            ],
            [
                128,
                250150816
            ],
            [
                129,
                250210624
            ],
            [
                130,
                250224440
            ],
            [
                131,
                250239052
            ],
            [
                132,
                250253311
            ],
            [
                133,
                250268315
            ],
            [
                134,
                250321058
            ],
            [
                135,
                250401645
            ],
            [
                136,
                250447698
            ],
            [
                137,
                250457011
            ],
            [
                138,
                250467433
            ],
            [
                139,
                250477416
            ],
            [
                140,
                250487485
            ],
            [
                141,
                250519463
            ],
            [
                142,
                250570620
            ],
            [
                143,
                250603633
            ],
            [
                144,
                250611850
            ],
            [
                145,
                250621377
            ],
            [
                146,
                250630462
            ],
            [
                147,
                250639976
            ],
            [
                148,
                250661854
            ],
            [
                149,
                250697035
            ],
            [
                150,
                250714157
            ],
            [
                151,
                250719528
            ],
            [
                152,
                250723987
            ],
            [
                153,
                250728235
            ],
            [
                154,
                250733126
            ],
            [
                155,
                250742899
            ],
            [
                156,
                250757445
            ],
            [
                157,
                250770411
            ],
            [
                158,
                250781332
            ],
            [
                159,
                250784661
            ],
            [
                160,
                250788378
            ],
            [
                161,
                250792287
            ],
            [
                162,
                250800093
            ],
            [
                163,
                250809145
            ],
            [
                164,
                250815386
            ],
            [
                165,
                250817625
            ],
            [
                166,
                250820109
            ],
            [
                167,
                250822780
            ],
            [
                168,
                250826886
            ],
            [
                169,
                250830715
            ],
            [
                170,
                250836077
            ],
            [
                171,
                250839624
            ],
            [
                172,
                250840981
            ],
            [
                173,
                250842662
            ],
            [
                174,
                250845069
            ],
            [
                175,
                250847073
            ],
            [
                176,
                250849175
            ],
            [
                177,
                250852372
            ],
            [
                178,
                250854474
            ],
            [
                179,
                250855423
            ],
            [
                180,
                250856998
            ],
            [
                181,
                250858920
            ],
            [
                182,
                250860439
            ]
        ],
        name: 'nightatthemuseum',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Night at the Museum',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#56402B'
        },
        showlabel: false,
        color: 'rgba(155,89,182,0.75)',
        linkedTo: 'Other'
    }, {
        data: [
            [
                0,
                4815427
            ],
            [
                1,
                18858737
            ],
            [
                2,
                33065445
            ],
            [
                3,
                48787760
            ],
            [
                4,
                69007897
            ],
            [
                5,
                84133900
            ],
            [
                6,
                91567160
            ],
            [
                7,
                98402686
            ],
            [
                8,
                104419095
            ],
            [
                9,
                109522653
            ],
            [
                10,
                118777580
            ],
            [
                11,
                130966320
            ],
            [
                12,
                139584970
            ],
            [
                13,
                143095712
            ],
            [
                14,
                146904238
            ],
            [
                15,
                150061026
            ],
            [
                16,
                153115865
            ],
            [
                17,
                158895927
            ],
            [
                18,
                166800161
            ],
            [
                19,
                172145793
            ],
            [
                20,
                174553076
            ],
            [
                21,
                177159454
            ],
            [
                22,
                179373063
            ],
            [
                23,
                181685906
            ],
            [
                24,
                185403700
            ],
            [
                25,
                190406364
            ],
            [
                26,
                194036790
            ],
            [
                27,
                195560875
            ],
            [
                28,
                197232178
            ],
            [
                29,
                198673993
            ],
            [
                30,
                200111208
            ],
            [
                31,
                202428826
            ],
            [
                32,
                205730809
            ],
            [
                33,
                208122305
            ],
            [
                34,
                209249069
            ],
            [
                35,
                210427501
            ],
            [
                36,
                211413781
            ],
            [
                37,
                212352590
            ],
            [
                38,
                213956298
            ],
            [
                39,
                216339248
            ],
            [
                40,
                218004940
            ],
            [
                41,
                218747817
            ],
            [
                42,
                219579659
            ],
            [
                43,
                220387413
            ],
            [
                44,
                221100224
            ],
            [
                45,
                222300852
            ],
            [
                46,
                224064003
            ],
            [
                47,
                225304729
            ],
            [
                48,
                225839914
            ],
            [
                49,
                226424799
            ],
            [
                50,
                227019477
            ],
            [
                51,
                227621456
            ],
            [
                52,
                228466724
            ],
            [
                53,
                229688643
            ],
            [
                54,
                230502569
            ],
            [
                55,
                230807455
            ],
            [
                56,
                231125727
            ],
            [
                57,
                231394304
            ],
            [
                58,
                231702119
            ],
            [
                59,
                232333072
            ],
            [
                60,
                233365630
            ],
            [
                61,
                234281015
            ],
            [
                62,
                235057188
            ],
            [
                63,
                235228429
            ],
            [
                64,
                235373096
            ],
            [
                65,
                235507984
            ],
            [
                66,
                235974523
            ],
            [
                67,
                236846705
            ],
            [
                68,
                237311281
            ],
            [
                69,
                237417733
            ],
            [
                70,
                237542822
            ],
            [
                71,
                237657874
            ],
            [
                72,
                237776607
            ],
            [
                73,
                238178803
            ],
            [
                74,
                238966653
            ],
            [
                75,
                239354920
            ],
            [
                76,
                239440657
            ],
            [
                77,
                239546588
            ],
            [
                78,
                239636919
            ],
            [
                79,
                239734400
            ],
            [
                80,
                240038488
            ],
            [
                81,
                240642676
            ],
            [
                82,
                240942775
            ],
            [
                83,
                241007297
            ],
            [
                84,
                241081099
            ],
            [
                85,
                241144423
            ],
            [
                86,
                241210546
            ],
            [
                87,
                241431280
            ],
            [
                88,
                241881303
            ],
            [
                89,
                242117436
            ],
            [
                90,
                242166074
            ],
            [
                91,
                242218193
            ],
            [
                92,
                242265944
            ],
            [
                93,
                242330085
            ],
            [
                94,
                242508832
            ],
            [
                95,
                242847148
            ],
            [
                96,
                243017806
            ],
            [
                97,
                243055621
            ],
            [
                98,
                243097872
            ],
            [
                99,
                243135495
            ],
            [
                100,
                243186036
            ],
            [
                101,
                243304258
            ],
            [
                102,
                243504763
            ],
            [
                103,
                243629478
            ],
            [
                104,
                243680717
            ],
            [
                105,
                243707987
            ],
            [
                106,
                243734192
            ],
            [
                107,
                243762835
            ],
            [
                108,
                243839062
            ],
            [
                109,
                243981932
            ],
            [
                110,
                244064365
            ],
            [
                111,
                244081091
            ],
            [
                112,
                244100348
            ],
            [
                113,
                244117556
            ],
            [
                114,
                244136451
            ],
            [
                115,
                244188278
            ],
            [
                116,
                244282110
            ],
            [
                117,
                244337321
            ],
            [
                118,
                244350803
            ],
            [
                119,
                244366225
            ],
            [
                120,
                244380014
            ],
            [
                121,
                244391696
            ],
            [
                122,
                244521142
            ],
            [
                123,
                244841133
            ],
            [
                124,
                245012779
            ],
            [
                125,
                245047541
            ],
            [
                126,
                245089930
            ],
            [
                127,
                245126067
            ],
            [
                128,
                245167104
            ],
            [
                129,
                245238708
            ],
            [
                130,
                245352883
            ],
            [
                131,
                245419734
            ],
            [
                132,
                245446939
            ],
            [
                133,
                245487480
            ],
            [
                134,
                245512342
            ],
            [
                135,
                245541878
            ],
            [
                136,
                246377098
            ],
            [
                137,
                247234036
            ],
            [
                138,
                247659078
            ],
            [
                139,
                247704431
            ],
            [
                140,
                247756318
            ],
            [
                141,
                247804105
            ],
            [
                142,
                247850171
            ],
            [
                143,
                248003058
            ],
            [
                144,
                248254400
            ],
            [
                145,
                248408779
            ],
            [
                146,
                248429204
            ],
            [
                147,
                248456351
            ],
            [
                148,
                248501226
            ],
            [
                149,
                248553908
            ]
        ],
        name: 'meninblack',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Men in Black',
            genre: 'Sci-Fi Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#394450'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                38268295
            ],
            [
                2,
                69762162
            ],
            [
                3,
                93687367
            ],
            [
                4,
                102115798
            ],
            [
                5,
                109363094
            ],
            [
                6,
                116241576
            ],
            [
                7,
                123064649
            ],
            [
                8,
                134405065
            ],
            [
                9,
                147946953
            ],
            [
                10,
                157975042
            ],
            [
                11,
                161963462
            ],
            [
                12,
                165705930
            ],
            [
                13,
                169329428
            ],
            [
                14,
                172897787
            ],
            [
                15,
                178198989
            ],
            [
                16,
                185308202
            ],
            [
                17,
                190925253
            ],
            [
                18,
                193290508
            ],
            [
                19,
                195896665
            ],
            [
                20,
                198051737
            ],
            [
                21,
                200290136
            ],
            [
                22,
                203699214
            ],
            [
                23,
                208167392
            ],
            [
                24,
                211537548
            ],
            [
                25,
                213113702
            ],
            [
                26,
                214672927
            ],
            [
                27,
                215877149
            ],
            [
                28,
                217178539
            ],
            [
                29,
                219094839
            ],
            [
                30,
                221402205
            ],
            [
                31,
                223117013
            ],
            [
                32,
                225719716
            ],
            [
                33,
                226805163
            ],
            [
                34,
                227755902
            ],
            [
                35,
                228743375
            ],
            [
                36,
                229900678
            ],
            [
                37,
                231478906
            ],
            [
                38,
                232795692
            ],
            [
                39,
                233483882
            ],
            [
                40,
                234205100
            ],
            [
                41,
                234911432
            ],
            [
                42,
                235586634
            ],
            [
                43,
                236318852
            ],
            [
                44,
                237361841
            ],
            [
                45,
                238344679
            ],
            [
                46,
                238786174
            ],
            [
                47,
                239234461
            ],
            [
                48,
                239661642
            ],
            [
                49,
                240092901
            ],
            [
                50,
                240538477
            ],
            [
                51,
                241216997
            ],
            [
                52,
                241770359
            ],
            [
                53,
                242025848
            ],
            [
                54,
                242349326
            ],
            [
                55,
                242663627
            ],
            [
                56,
                242921093
            ],
            [
                57,
                243162196
            ],
            [
                58,
                243549316
            ],
            [
                59,
                243910542
            ],
            [
                60,
                244080766
            ],
            [
                61,
                244252784
            ],
            [
                62,
                244426276
            ],
            [
                63,
                244603966
            ],
            [
                64,
                244797610
            ],
            [
                65,
                245085524
            ],
            [
                66,
                245332214
            ],
            [
                67,
                245446688
            ],
            [
                68,
                245569094
            ],
            [
                69,
                245681479
            ],
            [
                70,
                245792785
            ],
            [
                71,
                245921402
            ],
            [
                72,
                246093513
            ],
            [
                73,
                246244214
            ],
            [
                74,
                246317636
            ],
            [
                75,
                246392718
            ],
            [
                76,
                246468133
            ],
            [
                77,
                246547311
            ],
            [
                78,
                246632102
            ],
            [
                79,
                246789016
            ],
            [
                80,
                246900818
            ],
            [
                81,
                246955792
            ],
            [
                82,
                247010832
            ],
            [
                83,
                247062263
            ],
            [
                84,
                247112921
            ],
            [
                85,
                247234454
            ],
            [
                86,
                247434941
            ],
            [
                87,
                247598604
            ],
            [
                88,
                247650996
            ],
            [
                89,
                247700608
            ],
            [
                90,
                247740632
            ],
            [
                91,
                247782190
            ],
            [
                92,
                247869353
            ],
            [
                93,
                248031901
            ],
            [
                94,
                248195631
            ],
            [
                95,
                248344516
            ],
            [
                96,
                248369189
            ],
            [
                97,
                248392636
            ],
            [
                98,
                248415371
            ],
            [
                99,
                248456927
            ],
            [
                100,
                248546225
            ],
            [
                101,
                248619248
            ],
            [
                102,
                248634726
            ],
            [
                103,
                248649538
            ],
            [
                104,
                248665224
            ],
            [
                105,
                248684766
            ],
            [
                106,
                248720678
            ],
            [
                107,
                248800909
            ],
            [
                108,
                248854854
            ],
            [
                109,
                248865262
            ],
            [
                110,
                248875135
            ],
            [
                111,
                248884815
            ],
            [
                112,
                248894017
            ],
            [
                113,
                248925464
            ],
            [
                114,
                248989000
            ],
            [
                115,
                249031885
            ],
            [
                116,
                249041275
            ],
            [
                117,
                249051304
            ],
            [
                118,
                249060243
            ],
            [
                119,
                249069395
            ],
            [
                120,
                249084058
            ],
            [
                121,
                249114626
            ],
            [
                122,
                249133782
            ],
            [
                123,
                249138342
            ],
            [
                124,
                249142630
            ],
            [
                125,
                249146454
            ],
            [
                126,
                249151025
            ],
            [
                127,
                249160821
            ],
            [
                128,
                249180185
            ],
            [
                129,
                249194525
            ],
            [
                130,
                249204304
            ],
            [
                131,
                249207444
            ],
            [
                132,
                249210154
            ],
            [
                133,
                249214277
            ],
            [
                134,
                249226056
            ],
            [
                135,
                249249738
            ],
            [
                136,
                249266986
            ],
            [
                137,
                249268668
            ],
            [
                138,
                249270174
            ],
            [
                139,
                249271215
            ],
            [
                140,
                249276315
            ],
            [
                141,
                249288131
            ],
            [
                142,
                249306297
            ],
            [
                143,
                249319248
            ],
            [
                144,
                249320822
            ],
            [
                145,
                249323740
            ],
            [
                146,
                249325388
            ],
            [
                147,
                249327065
            ],
            [
                148,
                249334513
            ],
            [
                149,
                249353324
            ],
            [
                150,
                249358727
            ],
            [
                151,
                249360363
            ],
            [
                152,
                249364217
            ],
            [
                153,
                249365686
            ],
            [
                154,
                249367187
            ]
        ],
        name: 'harrypotter3',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Harry Potter and the Prisoner of Azkaban',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#2D3135'
        },
        showlabel: false,
        color: 'rgba(52,73,94,0.75)',
        linkedTo: 'Fantasy'
    }, {
        data: [
            [
                1,
                88664
            ],
            [
                2,
                199380
            ],
            [
                3,
                300163
            ],
            [
                4,
                343916
            ],
            [
                5,
                379178
            ],
            [
                6,
                9950089
            ],
            [
                7,
                23093123
            ],
            [
                8,
                45699525
            ],
            [
                9,
                67050146
            ],
            [
                10,
                80481962
            ],
            [
                11,
                82993048
            ],
            [
                12,
                85197080
            ],
            [
                13,
                87148543
            ],
            [
                14,
                89021116
            ],
            [
                15,
                95525842
            ],
            [
                16,
                108321659
            ],
            [
                17,
                116781392
            ],
            [
                18,
                118123483
            ],
            [
                19,
                119535125
            ],
            [
                20,
                120841199
            ],
            [
                21,
                122100485
            ],
            [
                22,
                126237304
            ],
            [
                23,
                134775677
            ],
            [
                24,
                140350365
            ],
            [
                25,
                141263667
            ],
            [
                26,
                142230779
            ],
            [
                27,
                143191494
            ],
            [
                28,
                144224888
            ],
            [
                29,
                147051825
            ],
            [
                30,
                152373559
            ],
            [
                31,
                156354721
            ],
            [
                32,
                158521094
            ],
            [
                33,
                161041131
            ],
            [
                34,
                163710476
            ],
            [
                35,
                167168645
            ],
            [
                36,
                169647906
            ],
            [
                37,
                172766853
            ],
            [
                38,
                177545321
            ],
            [
                39,
                182308299
            ],
            [
                40,
                187131374
            ],
            [
                41,
                191763200
            ],
            [
                42,
                196426718
            ],
            [
                43,
                199843054
            ],
            [
                44,
                204817418
            ],
            [
                45,
                208851257
            ],
            [
                46,
                210309895
            ],
            [
                47,
                211215635
            ],
            [
                48,
                211898419
            ],
            [
                49,
                212552266
            ],
            [
                50,
                214192465
            ],
            [
                51,
                217534413
            ],
            [
                52,
                219705755
            ],
            [
                53,
                220029284
            ],
            [
                54,
                220374251
            ],
            [
                55,
                220667091
            ],
            [
                56,
                220983916
            ],
            [
                57,
                222031589
            ],
            [
                58,
                224299813
            ],
            [
                59,
                226056757
            ],
            [
                60,
                227615332
            ],
            [
                61,
                227878302
            ],
            [
                62,
                228069480
            ],
            [
                63,
                228280286
            ],
            [
                64,
                228877884
            ],
            [
                65,
                230318305
            ],
            [
                66,
                231228567
            ],
            [
                67,
                231437021
            ],
            [
                68,
                231599308
            ],
            [
                69,
                231779219
            ],
            [
                70,
                231960062
            ],
            [
                71,
                232477411
            ],
            [
                72,
                233698632
            ],
            [
                73,
                234301509
            ],
            [
                74,
                234480631
            ],
            [
                75,
                234615150
            ],
            [
                76,
                234736050
            ],
            [
                77,
                234858442
            ],
            [
                78,
                235284943
            ],
            [
                79,
                236376415
            ],
            [
                80,
                237113435
            ],
            [
                81,
                237230280
            ],
            [
                82,
                237339147
            ],
            [
                83,
                237435990
            ],
            [
                84,
                237537630
            ],
            [
                85,
                237724790
            ],
            [
                86,
                238272397
            ],
            [
                87,
                238691281
            ],
            [
                88,
                238803523
            ],
            [
                89,
                238863496
            ],
            [
                90,
                238922600
            ],
            [
                91,
                238988596
            ],
            [
                92,
                239077587
            ],
            [
                93,
                239376751
            ],
            [
                94,
                239664408
            ],
            [
                95,
                239930711
            ],
            [
                96,
                239999442
            ],
            [
                97,
                240058951
            ],
            [
                98,
                240122940
            ],
            [
                99,
                240217051
            ],
            [
                100,
                240445395
            ],
            [
                101,
                240627332
            ],
            [
                102,
                240659292
            ],
            [
                103,
                240686299
            ],
            [
                104,
                240710925
            ],
            [
                105,
                240740912
            ],
            [
                106,
                240785787
            ],
            [
                107,
                240909405
            ],
            [
                108,
                241003665
            ],
            [
                109,
                241023747
            ],
            [
                110,
                241043046
            ],
            [
                111,
                241060544
            ],
            [
                112,
                241081469
            ],
            [
                113,
                241132808
            ],
            [
                114,
                241260602
            ],
            [
                115,
                241357162
            ],
            [
                116,
                241403406
            ],
            [
                117,
                241457042
            ],
            [
                118,
                241511019
            ],
            [
                119,
                241569717
            ],
            [
                120,
                241650872
            ],
            [
                121,
                241780045
            ],
            [
                122,
                241878319
            ],
            [
                123,
                241905179
            ],
            [
                124,
                241940135
            ],
            [
                125,
                241970793
            ],
            [
                126,
                242002443
            ],
            [
                127,
                242058650
            ],
            [
                128,
                242154217
            ],
            [
                129,
                242221297
            ],
            [
                130,
                242249259
            ],
            [
                131,
                242280158
            ],
            [
                132,
                242309832
            ],
            [
                133,
                242345699
            ],
            [
                134,
                242409803
            ],
            [
                135,
                242515212
            ],
            [
                136,
                242602418
            ],
            [
                137,
                242630411
            ],
            [
                138,
                242662983
            ],
            [
                139,
                242690491
            ],
            [
                140,
                242721397
            ],
            [
                141,
                242782639
            ],
            [
                142,
                242884683
            ],
            [
                143,
                242947795
            ]
        ],
        name: 'toystory2',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Toy Story 2',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#B3695E'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                41868135
            ],
            [
                2,
                74302843
            ],
            [
                3,
                100038390
            ],
            [
                4,
                110542664
            ],
            [
                5,
                120953107
            ],
            [
                6,
                128685351
            ],
            [
                7,
                138345769
            ],
            [
                8,
                148965438
            ],
            [
                9,
                163770694
            ],
            [
                10,
                175395954
            ],
            [
                11,
                180166140
            ],
            [
                12,
                185396529
            ],
            [
                13,
                189081100
            ],
            [
                14,
                192531298
            ],
            [
                15,
                197451453
            ],
            [
                16,
                204108469
            ],
            [
                17,
                208833713
            ],
            [
                18,
                210850231
            ],
            [
                19,
                213444938
            ],
            [
                20,
                215395566
            ],
            [
                21,
                217156888
            ],
            [
                22,
                219950118
            ],
            [
                23,
                224036972
            ],
            [
                24,
                227002608
            ],
            [
                25,
                228174874
            ],
            [
                26,
                229616681
            ],
            [
                27,
                230802453
            ],
            [
                28,
                231752475
            ],
            [
                29,
                233075005
            ],
            [
                30,
                234961717
            ],
            [
                31,
                236455028
            ],
            [
                32,
                237124208
            ],
            [
                33,
                237875634
            ],
            [
                34,
                238460789
            ],
            [
                35,
                238965915
            ],
            [
                36,
                239584651
            ],
            [
                37,
                240510342
            ],
            [
                38,
                241206987
            ],
            [
                39,
                241526510
            ],
            [
                40,
                241868334
            ],
            [
                41,
                242124910
            ],
            [
                42,
                242303575
            ],
            [
                43,
                242467792
            ],
            [
                44,
                242716613
            ],
            [
                45,
                242880031
            ],
            [
                46,
                242950166
            ],
            [
                47,
                243030978
            ],
            [
                48,
                243089383
            ],
            [
                49,
                243136930
            ],
            [
                50,
                243191397
            ],
            [
                51,
                243279167
            ],
            [
                52,
                243342459
            ],
            [
                53,
                243364809
            ],
            [
                54,
                243392711
            ],
            [
                55,
                243416587
            ],
            [
                56,
                243439603
            ],
            [
                57,
                243537270
            ],
            [
                58,
                243705649
            ],
            [
                59,
                243822062
            ],
            [
                60,
                243853989
            ],
            [
                61,
                243890199
            ],
            [
                62,
                243919647
            ],
            [
                63,
                243950966
            ],
            [
                64,
                244030996
            ],
            [
                65,
                244177536
            ],
            [
                66,
                244327641
            ],
            [
                67,
                244435833
            ],
            [
                68,
                244459861
            ],
            [
                69,
                244480845
            ],
            [
                70,
                244498662
            ],
            [
                71,
                244554688
            ],
            [
                72,
                244667709
            ],
            [
                73,
                244736069
            ],
            [
                74,
                244750740
            ],
            [
                75,
                244769458
            ],
            [
                76,
                244785672
            ],
            [
                77,
                244803687
            ],
            [
                78,
                244873705
            ],
            [
                79,
                244994086
            ],
            [
                80,
                245064448
            ],
            [
                81,
                245087189
            ],
            [
                82,
                245112671
            ],
            [
                83,
                245135728
            ],
            [
                84,
                245151963
            ],
            [
                85,
                245176672
            ],
            [
                86,
                245227452
            ],
            [
                87,
                245259125
            ],
            [
                88,
                245265231
            ],
            [
                89,
                245272736
            ],
            [
                90,
                245280051
            ],
            [
                91,
                245288377
            ],
            [
                92,
                245307008
            ],
            [
                93,
                245346609
            ],
            [
                94,
                245370666
            ],
            [
                95,
                245376669
            ],
            [
                96,
                245382033
            ],
            [
                97,
                245386935
            ],
            [
                98,
                245392023
            ],
            [
                99,
                245400833
            ],
            [
                100,
                245418060
            ],
            [
                101,
                245428211
            ],
            [
                102,
                245430672
            ],
            [
                103,
                245433244
            ],
            [
                104,
                245436073
            ],
            [
                105,
                245439076
            ]
        ],
        name: 'transformers4',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Transformers: Age of Extinction',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#67645E'
        },
        showlabel: false,
        color: 'rgba(231,76,60,0.75)',
        linkedTo: 'Sci-Fi'
    }, {
        data: [
            [
                1,
                19713746
            ],
            [
                2,
                42994673
            ],
            [
                3,
                60119509
            ],
            [
                4,
                66527416
            ],
            [
                5,
                72270878
            ],
            [
                6,
                78008209
            ],
            [
                7,
                83323649
            ],
            [
                8,
                92529465
            ],
            [
                9,
                105444420
            ],
            [
                10,
                117055283
            ],
            [
                11,
                121115860
            ],
            [
                12,
                125128007
            ],
            [
                13,
                129228871
            ],
            [
                14,
                133379549
            ],
            [
                15,
                139812147
            ],
            [
                16,
                149134116
            ],
            [
                17,
                156664916
            ],
            [
                18,
                159768282
            ],
            [
                19,
                162710312
            ],
            [
                20,
                165365996
            ],
            [
                21,
                168021783
            ],
            [
                22,
                172086819
            ],
            [
                23,
                177297509
            ],
            [
                24,
                182591139
            ],
            [
                25,
                186947868
            ],
            [
                26,
                190506108
            ],
            [
                27,
                192908800
            ],
            [
                28,
                195174402
            ],
            [
                29,
                198641776
            ],
            [
                30,
                202923427
            ],
            [
                31,
                205908484
            ],
            [
                32,
                207315250
            ],
            [
                33,
                208918481
            ],
            [
                34,
                210595357
            ],
            [
                35,
                212160461
            ],
            [
                36,
                214448236
            ],
            [
                37,
                217771323
            ],
            [
                38,
                220001446
            ],
            [
                39,
                221090490
            ],
            [
                40,
                222273736
            ],
            [
                41,
                223359127
            ],
            [
                42,
                224538438
            ],
            [
                43,
                225899304
            ],
            [
                44,
                228074393
            ],
            [
                45,
                229485636
            ],
            [
                46,
                230127742
            ],
            [
                47,
                230821008
            ],
            [
                48,
                231480230
            ],
            [
                49,
                232181886
            ],
            [
                50,
                232909712
            ],
            [
                51,
                234003915
            ],
            [
                52,
                234802642
            ],
            [
                53,
                235163554
            ],
            [
                54,
                235589472
            ],
            [
                55,
                236033142
            ],
            [
                56,
                236432622
            ],
            [
                57,
                236742105
            ],
            [
                58,
                237197696
            ],
            [
                59,
                237517306
            ],
            [
                60,
                237701801
            ],
            [
                61,
                237880818
            ],
            [
                62,
                238037860
            ],
            [
                63,
                238220320
            ],
            [
                64,
                238397830
            ],
            [
                65,
                238660946
            ],
            [
                66,
                238841296
            ],
            [
                67,
                238924816
            ],
            [
                68,
                239014683
            ],
            [
                69,
                239096604
            ],
            [
                70,
                239179271
            ],
            [
                71,
                239288699
            ],
            [
                72,
                239475391
            ],
            [
                73,
                239618177
            ],
            [
                74,
                239668952
            ],
            [
                75,
                239720251
            ],
            [
                76,
                239769512
            ],
            [
                77,
                239821060
            ],
            [
                78,
                240009001
            ],
            [
                79,
                240322061
            ],
            [
                80,
                240555222
            ],
            [
                81,
                240637758
            ],
            [
                82,
                240736043
            ],
            [
                83,
                240820161
            ],
            [
                84,
                240894281
            ],
            [
                85,
                241088455
            ],
            [
                86,
                241426455
            ],
            [
                87,
                241743295
            ],
            [
                88,
                241979000
            ],
            [
                89,
                242036844
            ],
            [
                90,
                242087945
            ],
            [
                91,
                242140418
            ]
        ],
        name: 'cars',
        showInLegend: false,
        marker: {
            enabled: false
        },
        extra: {
            title: 'Cars',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#835C4F'
        },
        showlabel: false,
        color: 'rgba(46,204,113,0.75)',
        linkedTo: 'Animation'
    }, {
        data: [
            [
                1,
                20114325
            ],
            [
                2,
                45540225
            ],
            [
                3,
                67953330
            ],
            [
                4,
                85734045
            ],
            [
                5,
                90871470
            ],
            [
                6,
                95556105
            ],
            [
                7,
                100066590
            ],
            [
                8,
                111118770
            ],
            [
                9,
                126989910
            ],
            [
                10,
                137396070
            ],
            [
                11,
                140294430
            ],
            [
                12,
                143472150
            ],
            [
                13,
                146300670
            ],
            [
                14,
                149076810
            ],
            [
                15,
                155784420
            ],
            [
                16,
                165473190
            ],
            [
                17,
                171435525
            ],
            [
                18,
                173405220
            ],
            [
                19,
                175516875
        