Highcharts.chart('container', {
    title: {
        text: 'Cumulative Gross Income'
    },
    credits: {
        enabled: false
    },
    exporting: {
        enabled: false
    },
    plotOptions: {
        series: {
            turboThreshold: 0,
            dataLabels: {
                enabled: true,
                align: 'left',
                verticalAlign: 'middle',
                formatter: function () {
                    if (this.point.x === this.series.data[
                        this.series.data.length - 1].x &
                        this.series.options.showlabel
                    ) {
                        return this.series.options.extra.title;
                    }
                },
                crop: false,
                overflow: false
            }
        }
    },
    chart: {
        zooming: {
            type: 'x'
        },
        marginRight: 120
    },
    tooltip: {
        followPointer: false,
        useHTML: true,
        pointFormat: '<table>  <tr>\n    <th>Gross</th>\n    <td>$ ' +
            '{point.y}</td>\n  </tr>\n  <tr>\n    <th>Genre</th>\n    <td>' +
            '{point.series.options.extra.genre}</td>\n  </tr>\n  <tr>\n    ' +
            '<th>MPAA rating</th>\n    <td>' +
            '{point.series.options.extra.mpaaRating}</td>\n  </tr>\n</table>'
    },
    yAxis: {
        title: {
            text: 'Gross income'
        }
    },
    subtitle: {
        text: 'Titanic (1997),  Avatar (2009) and Star Wars VII (2016) are ' +
            'the movies with most gross income in the film history.'
    },
    xAxis: {
        title: {
            text: 'Date'
        },
        type: 'datetime'
    },
    series: [{
        marker: {
            enabled: false
        },
        data: [
            [
                1450396800000, 119119282
            ],
            [1450483200000, 187413486],
            [1450569600000, 247966675],
            [1450656000000, 288076417],
            [1450742400000, 325438146],
            [1450828800000, 363460329],
            [1450915200000, 390856054],
            [1451001600000, 440181717],
            [1451088000000, 496913249],
            [1451174400000, 540058914],
            [1451260800000, 571420943],
            [1451347200000, 600949526],
            [1451433600000, 629034583],
            [1451520000000, 651967269],
            [1451606400000, 686361421],
            [1451692800000, 720729671],
            [1451779200000, 742208942],
            [1451865600000, 750230824],
            [1451952000000, 758198252],
            [1452038400000, 764408684],
            [1452124800000, 770381043],
            [1452211200000, 781125423],
            [1452297600000, 800329495],
            [1452384000000, 812734828],
            [1452470400000, 815843529],
            [1452556800000, 819687937],
            [1452643200000, 822802874],
            [1452729600000, 825932841],
            [1452816000000, 832261795],
            [1452902400000, 843290309],
            [1452988800000, 852274958],
            [1453075200000, 858953106],
            [1453161600000, 861334016],
            [1453248000000, 863148249],
            [1453334400000, 865032346],
            [1453420800000, 868567603],
            [1453507200000, 875382255],
            [1453593600000, 879110994],
            [1453680000000, 880406736],
            [1453766400000, 881981219],
            [1453852800000, 883305698],
            [1453939200000, 884644162],
            [1454025600000, 887112863],
            [1454112000000, 892202825],
            [1454198400000, 895760846],
            [1454284800000, 896541631],
            [1454371200000, 897469134],
            [1454457600000, 898267924],
            [1454544000000, 899071469],
            [1454630400000, 900844232],
            [1454716800000, 904613971],
            [1454803200000, 906044785],
            [1454889600000, 906723418],
            [1454976000000, 907431461],
            [1455062400000, 908059656],
            [1455148800000, 908644964],
            [1455235200000, 909833552],
            [1455321600000, 912295455],
            [1455408000000, 914804240],
            [1455494400000, 916285655],
            [1455580800000, 916860978],
            [1455667200000, 917326764],
            [1455753600000, 917806295],
            [1455840000000, 918724209],
            [1455926400000, 920502103],
            [1456012800000, 921713590],
            [1456099200000, 922010468],
            [1456185600000, 922375795],
            [1456272000000, 922692449],
            [1456358400000, 923001884],
            [1456444800000, 923673403],
            [1456531200000, 925119143],
            [1456617600000, 925988323],
            [1456704000000, 926225742],
            [1456790400000, 926508202],
            [1456876800000, 926745956],
            [1456963200000, 926977515],
            [1457049600000, 927400587],
            [1457136000000, 928264716],
            [1457222400000, 928842219],
            [1457308800000, 928995339],
            [1457395200000, 929158968],
            [1457481600000, 929305738],
            [1457568000000, 929459260],
            [1457654400000, 929768721],
            [1457740800000, 930350640],
            [1457827200000, 930757012]
        ],
        name: 'starwars7',
        showInLegend: false,
        extra: {
            title: 'Star Wars: The Force Awakens',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#463334'
        },
        showlabel: true,
        color: 'rgba(70,51,52,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1261094400000, 26752099
            ],
            [1261180800000, 52281135],
            [1261267200000, 77025481],
            [1261353600000, 93411301],
            [1261440000000, 109497762],
            [1261526400000, 125943053],
            [1261612800000, 137094051],
            [1261699200000, 160189097],
            [1261785600000, 188463503],
            [1261872000000, 212711184],
            [1261958400000, 232129323],
            [1262044800000, 250419951],
            [1262131200000, 268886074],
            [1262217600000, 283624210],
            [1262304000000, 308898218],
            [1262390400000, 334733769],
            [1262476800000, 352114898],
            [1262563200000, 360209452],
            [1262649600000, 367536685],
            [1262736000000, 374445852],
            [1262822400000, 380540297],
            [1262908800000, 393820950],
            [1262995200000, 415090487],
            [1263081600000, 430846514],
            [1263168000000, 435957707],
            [1263254400000, 441024441],
            [1263340800000, 445768203],
            [1263427200000, 450467005],
            [1263513600000, 460861269],
            [1263600000000, 478115377],
            [1263686400000, 493252617],
            [1263772800000, 504868451],
            [1263859200000, 509059398],
            [1263945600000, 512852205],
            [1264032000000, 516797418],
            [1264118400000, 525825912],
            [1264204800000, 542151962],
            [1264291200000, 551741499],
            [1264377600000, 554981691],
            [1264464000000, 558179737],
            [1264550400000, 561317325],
            [1264636800000, 564472387],
            [1264723200000, 571911813],
            [1264809600000, 585695694],
            [1264896000000, 595752416],
            [1264982400000, 598453037],
            [1265068800000, 601141551],
            [1265155200000, 603789348],
            [1265241600000, 606493323],
            [1265328000000, 612653642],
            [1265414400000, 624193440],
            [1265500800000, 629344204],
            [1265587200000, 631595771],
            [1265673600000, 633621035],
            [1265760000000, 635470349],
            [1265846400000, 637605653],
            [1265932800000, 642146324],
            [1266019200000, 651346762],
            [1266105600000, 661217278],
            [1266192000000, 666388502],
            [1266278400000, 668224829],
            [1266364800000, 669935879],
            [1266451200000, 671721154],
            [1266537600000, 675615172],
            [1266624000000, 683071751],
            [1266710400000, 687962011],
            [1266796800000, 689237048],
            [1266883200000, 690499726],
            [1266969600000, 691701910],
            [1267056000000, 692904794],
            [1267142400000, 695981544],
            [1267228800000, 702621374],
            [1267315200000, 706560068],
            [1267401600000, 707818745],
            [1267488000000, 709304322],
            [1267574400000, 710842764],
            [1267660800000, 712489342],
            [1267747200000, 714463378],
            [1267833600000, 718126396],
            [1267920000000, 720607444],
            [1268006400000, 721425412],
            [1268092800000, 722207106],
            [1268179200000, 722954237],
            [1268265600000, 723744022],
            [1268352000000, 725429879],
            [1268438400000, 728329714],
            [1268524800000, 730270443],
            [1268611200000, 730942185],
            [1268697600000, 731621183],
            [1268784000000, 732229805],
            [1268870400000, 732880952],
            [1268956800000, 733938158],
            [1269043200000, 735684163],
            [1269129600000, 736907957],
            [1269216000000, 737266471],
            [1269302400000, 737627370],
            [1269388800000, 737976702],
            [1269475200000, 738393054],
            [1269561600000, 738919556],
            [1269648000000, 739798846],
            [1269734400000, 740440529],
            [1269820800000, 740684275],
            [1269907200000, 740916066],
            [1269993600000, 741140003],
            [1270080000000, 741352439],
            [1270166400000, 741699502],
            [1270252800000, 742076465],
            [1270339200000, 742332678],
            [1270425600000, 742497942],
            [1270512000000, 742605267],
            [1270598400000, 742721098],
            [1270684800000, 742844322],
            [1270771200000, 743083175],
            [1270857600000, 743448904],
            [1270944000000, 743688973],
            [1271030400000, 743767458],
            [1271116800000, 743853911],
            [1271203200000, 743935257],
            [1271289600000, 744020453],
            [1271376000000, 744275947],
            [1271462400000, 744750989],
            [1271548800000, 745023267],
            [1271635200000, 745115019],
            [1271721600000, 745219191],
            [1271808000000, 745330634],
            [1271894400000, 745444933],
            [1271980800000, 745686489],
            [1272067200000, 746120670],
            [1272153600000, 746365137],
            [1272240000000, 746433508],
            [1272326400000, 746510111],
            [1272412800000, 746579530],
            [1272499200000, 746659357],
            [1272585600000, 746830110],
            [1272672000000, 747119231],
            [1272758400000, 747292481],
            [1272844800000, 747350763],
            [1272931200000, 747409335],
            [1273017600000, 747464115],
            [1273104000000, 747521330],
            [1273190400000, 747625319],
            [1273276800000, 747807571],
            [1273363200000, 747946415],
            [1273449600000, 747990164],
            [1273536000000, 748037195],
            [1273622400000, 748083861],
            [1273708800000, 748133199],
            [1273795200000, 748219486],
            [1273881600000, 748372762],
            [1273968000000, 748468373],
            [1274054400000, 748509613],
            [1274140800000, 748548157],
            [1274227200000, 748590962],
            [1274313600000, 748633160],
            [1274400000000, 748675358],
            [1274486400000, 748757357],
            [1274572800000, 748821665],
            [1274659200000, 748860222],
            [1274745600000, 748882285],
            [1274832000000, 748905564],
            [1274918400000, 748928859],
            [1275004800000, 748956828],
            [1275091200000, 749004090],
            [1275177600000, 749048939],
            [1275264000000, 749073100],
            [1275350400000, 749090092],
            [1275436800000, 749106053],
            [1275523200000, 749125398],
            [1275609600000, 749143485],
            [1275696000000, 749180329],
            [1275782400000, 749202090],
            [1275868800000, 749213502],
            [1275955200000, 749224990],
            [1276041600000, 749237761],
            [1276128000000, 749252032],
            [1276214400000, 749267995],
            [1276300800000, 749295708],
            [1276387200000, 749316799],
            [1276473600000, 749333092],
            [1276560000000, 749351711],
            [1276646400000, 749371407],
            [1276732800000, 749389769],
            [1276819200000, 749401863],
            [1276905600000, 749421334],
            [1276992000000, 749434950],
            [1277078400000, 749446322],
            [1277164800000, 749462370],
            [1277251200000, 749475963],
            [1277337600000, 749491002],
            [1277424000000, 749500636],
            [1277510400000, 749520515],
            [1277596800000, 749535574],
            [1277683200000, 749545029],
            [1277769600000, 749557279],
            [1277856000000, 749561612],
            [1277942400000, 749568158],
            [1278028800000, 749575182],
            [1278115200000, 749587187],
            [1278201600000, 749596887],
            [1278288000000, 749603864],
            [1278374400000, 749609548],
            [1278460800000, 749614235],
            [1278547200000, 749620438],
            [1278633600000, 749630881],
            [1278720000000, 749648672],
            [1278806400000, 749657409],
            [1278892800000, 749663362],
            [1278979200000, 749667910],
            [1279065600000, 749675406],
            [1279152000000, 749685805],
            [1279238400000, 749689645],
            [1279324800000, 749696871],
            [1279411200000, 749701420],
            [1279497600000, 749702913],
            [1279584000000, 749704539],
            [1279670400000, 749705969],
            [1279756800000, 749710176],
            [1279843200000, 749714957],
            [1279929600000, 749722641],
            [1280016000000, 749726993],
            [1280102400000, 749728743],
            [1280188800000, 749730229],
            [1280275200000, 749731535],
            [1280361600000, 749735275],
            [1280448000000, 749739321],
            [1280534400000, 749744182],
            [1280620800000, 749748303],
            [1280707200000, 749748874],
            [1280793600000, 749749646],
            [1280880000000, 749750520],
            [1280966400000, 749755628],
            [1281052800000, 749758313],
            [1281139200000, 749762141],
            [1281225600000, 749766139]
        ],
        name: 'avatar',
        showInLegend: false,
        extra: {
            title: 'Avatar',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#2F2E36'
        },
        showlabel: true,
        color: 'rgba(47,46,54,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                882489600000, 8658814
            ],
            [882576000000, 19330827],
            [882662400000, 28638131],
            [882748800000, 34216343],
            [882835200000, 40219462],
            [882921600000, 43790807],
            [883008000000, 52969336],
            [883094400000, 65091634],
            [883180800000, 77558089],
            [883267200000, 88425009],
            [883353600000, 96367529],
            [883440000000, 104380438],
            [883526400000, 112594173],
            [883612800000, 124152693],
            [883699200000, 135851554],
            [883785600000, 148578179],
            [883872000000, 157467971],
            [883958400000, 160490242],
            [884044800000, 163535064],
            [884131200000, 166376415],
            [884217600000, 169165503],
            [884304000000, 176903653],
            [884390400000, 189661771],
            [884476800000, 197881813],
            [884563200000, 200051959],
            [884649600000, 202438123],
            [884736000000, 204533905],
            [884822400000, 206734370],
            [884908800000, 214152755],
            [884995200000, 226510099],
            [885081600000, 236745404],
            [885168000000, 242748914],
            [885254400000, 245071248],
            [885340800000, 247148224],
            [885427200000, 249361166],
            [885513600000, 256392349],
            [885600000000, 268867286],
            [885686400000, 274599886],
            [885772800000, 276501108],
            [885859200000, 278423536],
            [885945600000, 280231706],
            [886032000000, 282193031],
            [886118400000, 288845862],
            [886204800000, 300809839],
            [886291200000, 308100203],
            [886377600000, 309605750],
            [886464000000, 311342603],
            [886550400000, 312791354],
            [886636800000, 314327828],
            [886723200000, 320040276],
            [886809600000, 330858806],
            [886896000000, 337355666],
            [886982400000, 338710764],
            [887068800000, 340217288],
            [887155200000, 341677727],
            [887241600000, 343394297],
            [887328000000, 349124777],
            [887414400000, 362173488],
            [887500800000, 371562244],
            [887587200000, 376270721],
            [887673600000, 378144577],
            [887760000000, 379772544],
            [887846400000, 381525538],
            [887932800000, 386765500],
            [888019200000, 396691039],
            [888105600000, 402561881],
            [888192000000, 403739570],
            [888278400000, 405030767],
            [888364800000, 406083994],
            [888451200000, 407350832],
            [888537600000, 412090075],
            [888624000000, 421465040],
            [888710400000, 426983888],
            [888796800000, 428046153],
            [888883200000, 429334497],
            [888969600000, 430387008],
            [889056000000, 431551546],
            [889142400000, 435915654],
            [889228800000, 444274533],
            [889315200000, 449157395],
            [889401600000, 450213078],
            [889488000000, 451454765],
            [889574400000, 452570393],
            [889660800000, 453867325],
            [889747200000, 458212534],
            [889833600000, 466382088],
            [889920000000, 471446140],
            [890006400000, 472758103],
            [890092800000, 474234924],
            [890179200000, 475716582],
            [890265600000, 477349092],
            [890352000000, 481668037],
            [890438400000, 489671898],
            [890524800000, 494514331],
            [890611200000, 495573044],
            [890697600000, 497178479],
            [890784000000, 498610790],
            [890870400000, 500049030],
            [890956800000, 504255040],
            [891043200000, 511584597],
            [891129600000, 515262530],
            [891216000000, 516040845],
            [891302400000, 517059359],
            [891388800000, 517947471],
            [891475200000, 518873058],
            [891561600000, 521904623],
            [891648000000, 527679833],
            [891734400000, 530406538],
            [891820800000, 531180656],
            [891907200000, 532113277],
            [891993600000, 533002196],
            [892080000000, 534295450],
            [892166400000, 537565583],
            [892252800000, 541058281],
            [892339200000, 542853691],
            [892425600000, 543867439],
            [892512000000, 544879356],
            [892598400000, 545767712],
            [892684800000, 546659214],
            [892771200000, 548811012],
            [892857600000, 552306658],
            [892944000000, 554067203],
            [893030400000, 554475864],
            [893116800000, 554924605],
            [893203200000, 555273199],
            [893289600000, 555676775],
            [893376000000, 556974543],
            [893462400000, 559422564],
            [893548800000, 560615350],
            [893635200000, 560873032],
            [893721600000, 561187540],
            [893808000000, 561446553],
            [893894400000, 561724643],
            [893980800000, 562754486],
            [894067200000, 564844640],
            [894153600000, 565736531],
            [894240000000, 565953263],
            [894326400000, 566209309],
            [894412800000, 566423231],
            [894499200000, 566641840],
            [894585600000, 567408674],
            [894672000000, 568896220],
            [894758400000, 569820413],
            [894844800000, 570032011],
            [894931200000, 570264933],
            [895017600000, 570447710],
            [895104000000, 570601592],
            [895190400000, 571138657],
            [895276800000, 572169401],
            [895363200000, 572713894],
            [895449600000, 572899725],
            [895536000000, 573048180],
            [895622400000, 573202988],
            [895708800000, 573387309],
            [895795200000, 573985427],
            [895881600000, 575161477],
            [895968000000, 576357353],
            [896054400000, 577060012],
            [896140800000, 577247896],
            [896227200000, 577435118],
            [896313600000, 577635895],
            [896400000000, 578081790],
            [896486400000, 578927907],
            [896572800000, 579419474],
            [896659200000, 579603351],
            [896745600000, 579815441],
            [896832000000, 580020021],
            [896918400000, 580241029],
            [897004800000, 580659232],
            [897091200000, 581436091],
            [897177600000, 581889889],
            [897264000000, 582065212],
            [897350400000, 582283971],
            [897436800000, 582465336],
            [897523200000, 582670447],
            [897609600000, 582968058],
            [897696000000, 583520763],
            [897782400000, 583885184],
            [897868800000, 584029167],
            [897955200000, 584202831],
            [898041600000, 584356709],
            [898128000000, 584514665],
            [898214400000, 584801154],
            [898300800000, 585253347],
            [898387200000, 585544027],
            [898473600000, 585687856],
            [898560000000, 585850013],
            [898646400000, 585991218],
            [898732800000, 586148621],
            [898819200000, 586407585],
            [898905600000, 586825008],
            [898992000000, 587071239],
            [899078400000, 587197340],
            [899164800000, 587354184],
            [899251200000, 587454739],
            [899337600000, 587581188],
            [899424000000, 587807739],
            [899510400000, 588017397],
            [899596800000, 588205118],
            [899683200000, 588287481],
            [899769600000, 588373170],
            [899856000000, 588454766],
            [899942400000, 588526209],
            [900028800000, 588648955],
            [900115200000, 588823550],
            [900201600000, 588931878],
            [900288000000, 588978021],
            [900374400000, 589039101],
            [900460800000, 589095476],
            [900547200000, 589152380],
            [900633600000, 589481397],
            [900720000000, 590003732],
            [900806400000, 590489873],
            [900892800000, 590772845],
            [900979200000, 591105154],
            [901065600000, 591423602],
            [901152000000, 591758169],
            [901238400000, 592187821],
            [901324800000, 592766388],
            [901411200000, 593234448],
            [901497600000, 593486792],
            [901584000000, 593768559],
            [901670400000, 594025426],
            [901756800000, 594298467],
            [901843200000, 594629951],
            [901929600000, 595090070],
            [902016000000, 595467018],
            [902102400000, 595671646],
            [902188800000, 595898453],
            [902275200000, 596113141],
            [902361600000, 596320474],
            [902448000000, 596582984],
            [902534400000, 596958865],
            [902620800000, 597285686],
            [902707200000, 597436378],
            [902793600000, 597601006],
            [902880000000, 597749260],
            [902966400000, 597907062],
            [903052800000, 598092435],
            [903139200000, 598385286],
            [903225600000, 598614980],
            [903312000000, 598732804],
            [903398400000, 598868105],
            [903484800000, 598993956],
            [903571200000, 599117196],
            [903657600000, 599257659],
            [903744000000, 599488898],
            [903830400000, 599657813],
            [903916800000, 599737633],
            [904003200000, 599847580],
            [904089600000, 599940822],
            [904176000000, 600038488],
            [904262400000, 600125841],
            [904348800000, 600275295],
            [904435200000, 600374192],
            [904521600000, 600401200],
            [904608000000, 600429301],
            [904694400000, 600449727],
            [904780800000, 600471161],
            [904867200000, 600488179],
            [904953600000, 600515819],
            [905040000000, 600541628],
            [905126400000, 600562600],
            [905212800000, 600568272],
            [905299200000, 600573968],
            [905385600000, 600581001],
            [905472000000, 600596288],
            [905558400000, 600624176],
            [905644800000, 600638309],
            [905731200000, 600642933],
            [905817600000, 600649450],
            [905904000000, 600654793],
            [905990400000, 600660690],
            [906076800000, 600664546],
            [906163200000, 600671741],
            [906249600000, 600674693],
            [906336000000, 600675703],
            [906422400000, 600676888],
            [906508800000, 600677818],
            [906595200000, 600678584],
            [906681600000, 600679644],
            [906768000000, 600681119],
            [906854400000, 600681921],
            [906940800000, 600682199],
            [907027200000, 600682513],
            [907113600000, 600682801],
            [907200000000, 600683057]
        ],
        name: 'titanic',
        showInLegend: false,
        extra: {
            title: 'Titanic',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#443529'
        },
        showlabel: true,
        color: 'rgba(68,53,41,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1434067200000, 81953950
            ],
            [1434153600000, 151598780],
            [1434240000000, 208806270],
            [1434326400000, 234151090],
            [1434412800000, 258493605],
            [1434499200000, 278389075],
            [1434585600000, 296211655],
            [1434672000000, 325326090],
            [1434758400000, 364438525],
            [1434844800000, 402800065],
            [1434931200000, 414366290],
            [1435017600000, 427496750],
            [1435104000000, 436936950],
            [1435190400000, 445840775],
            [1435276800000, 460533660],
            [1435363200000, 483013950],
            [1435449600000, 500373390],
            [1435536000000, 506899770],
            [1435622400000, 514374125],
            [1435708800000, 520362275],
            [1435795200000, 527300925],
            [1435881600000, 539128530],
            [1435968000000, 547667575],
            [1436054400000, 556542950],
            [1436140800000, 560692000],
            [1436227200000, 565531415],
            [1436313600000, 569287100],
            [1436400000000, 572538290],
            [1436486400000, 577957865],
            [1436572800000, 585390425],
            [1436659200000, 590689565],
            [1436745600000, 592840190],
            [1436832000000, 595627400],
            [1436918400000, 597829640],
            [1437004800000, 599773805],
            [1437091200000, 603031070],
            [1437177600000, 607940345],
            [1437264000000, 611228780],
            [1437350400000, 612601315],
            [1437436800000, 614331250],
            [1437523200000, 615640390],
            [1437609600000, 616902775],
            [1437696000000, 618965875],
            [1437782400000, 621941500],
            [1437868800000, 624083950],
            [1437955200000, 625009700],
            [1438041600000, 626094150],
            [1438128000000, 626920500],
            [1438214400000, 627699630],
            [1438300800000, 628770350],
            [1438387200000, 630386910],
            [1438473600000, 631601030],
            [1438560000000, 632193750],
            [1438646400000, 632834270],
            [1438732800000, 633318770],
            [1438819200000, 633726780],
            [1438905600000, 634280685],
            [1438992000000, 635114340],
            [1439078400000, 635673840],
            [1439164800000, 635936805],
            [1439251200000, 636272505],
            [1439337600000, 636513090],
            [1439424000000, 636731640],
            [1439510400000, 637067430],
            [1439596800000, 637613550],
            [1439683200000, 637971480],
            [1439769600000, 638126505],
            [1439856000000, 638322290],
            [1439942400000, 638473570],
            [1440028800000, 638620980],
            [1440115200000, 638887990],
            [1440201600000, 639307200],
            [1440288000000, 639568530],
            [1440374400000, 639663325],
            [1440460800000, 639778350],
            [1440547200000, 639872800],
            [1440633600000, 639967785],
            [1440720000000, 640760745],
            [1440806400000, 642136035],
            [1440892800000, 642978555],
            [1440979200000, 643269755],
            [1441065600000, 643579580],
            [1441152000000, 643839335],
            [1441238400000, 644043640],
            [1441324800000, 644632765],
            [1441411200000, 645669625],
            [1441497600000, 646737905],
            [1441584000000, 647374160],
            [1441670400000, 647516055],
            [1441756800000, 647626080],
            [1441843200000, 647728195],
            [1441929600000, 648026291],
            [1442016000000, 648622481],
            [1442102400000, 648908886],
            [1442188800000, 648990716],
            [1442275200000, 649084726],
            [1442361600000, 649160276],
            [1442448000000, 649224036],
            [1442534400000, 649397366],
            [1442620800000, 649709676],
            [1442707200000, 649860516],
            [1442793600000, 649905696],
            [1442880000000, 649958406],
            [1442966400000, 650010786],
            [1443052800000, 650052291],
            [1443139200000, 650163171],
            [1443225600000, 650359291],
            [1443312000000, 650442741],
            [1443398400000, 650465296],
            [1443484800000, 650493056],
            [1443571200000, 650518931],
            [1443657600000, 650539751],
            [1443744000000, 650621116],
            [1443830400000, 650760851],
            [1443916800000, 650831971],
            [1444003200000, 650852291],
            [1444089600000, 650875151],
            [1444176000000, 650896741],
            [1444262400000, 650917061],
            [1444348800000, 650976601],
            [1444435200000, 651072536],
            [1444521600000, 651128986],
            [1444608000000, 651157741],
            [1444694400000, 651175846],
            [1444780800000, 651193851],
            [1444867200000, 651219411],
            [1444953600000, 651280016],
            [1445040000000, 651382026],
            [1445126400000, 651443636],
            [1445212800000, 651460806],
            [1445299200000, 651482016],
            [1445385600000, 651500121],
            [1445472000000, 651519326],
            [1445558400000, 651571841],
            [1445644800000, 651661981],
            [1445731200000, 651713686],
            [1445817600000, 651727701],
            [1445904000000, 651743446],
            [1445990400000, 651756571],
            [1446076800000, 651771446],
            [1446163200000, 651805076],
            [1446249600000, 651848541],
            [1446336000000, 651889591],
            [1446422400000, 651901096],
            [1446508800000, 651915856],
            [1446595200000, 651926516],
            [1446681600000, 651937996],
            [1446768000000, 651967211],
            [1446854400000, 652022846],
            [1446940800000, 652054116],
            [1447027200000, 652061061],
            [1447113600000, 652071496],
            [1447200000000, 652091641],
            [1447286400000, 652099921],
            [1447372800000, 652117931],
            [1447459200000, 652154966],
            [1447545600000, 652177271],
            [1447632000000, 652182176],
            [1447718400000, 652188221],
            [1447804800000, 652193076],
            [1447891200000, 652198011]
        ],
        name: 'jurassicpark4',
        showInLegend: false,
        extra: {
            title: 'Jurassic World',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#31485B'
        },
        showlabel: true,
        color: 'rgba(49,72,91,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1336089600000, 80813985
            ],
            [1336176000000, 150371975],
            [1336262400000, 207438708],
            [1336348800000, 226337707],
            [1336435200000, 244014897],
            [1336521600000, 257627807],
            [1336608000000, 270019373],
            [1336694400000, 299242890],
            [1336780800000, 342148409],
            [1336867200000, 373071647],
            [1336953600000, 380995436],
            [1337040000000, 389473290],
            [1337126400000, 395813047],
            [1337212800000, 402021415],
            [1337299200000, 417257461],
            [1337385600000, 440844530],
            [1337472000000, 457665517],
            [1337558400000, 463353451],
            [1337644800000, 468271215],
            [1337731200000, 472239621],
            [1337817600000, 476684788],
            [1337904000000, 486349111],
            [1337990400000, 500415495],
            [1338076800000, 513371659],
            [1338163200000, 523907202],
            [1338249600000, 527173955],
            [1338336000000, 529688996],
            [1338422400000, 532463980],
            [1338508800000, 538105622],
            [1338595200000, 547123535],
            [1338681600000, 552950398],
            [1338768000000, 554992773],
            [1338854400000, 557214486],
            [1338940800000, 559076546],
            [1339027200000, 561050725],
            [1339113600000, 564387649],
            [1339200000000, 568934514],
            [1339286400000, 572300463],
            [1339372800000, 573685968],
            [1339459200000, 575233764],
            [1339545600000, 576583182],
            [1339632000000, 577888904],
            [1339718400000, 580095059],
            [1339804800000, 583388044],
            [1339891200000, 586794371],
            [1339977600000, 587927710],
            [1340064000000, 589091616],
            [1340150400000, 590193264],
            [1340236800000, 591247781],
            [1340323200000, 593460187],
            [1340409600000, 596501976],
            [1340496000000, 598425442],
            [1340582400000, 599387534],
            [1340668800000, 600377080],
            [1340755200000, 601215735],
            [1340841600000, 602083073],
            [1340928000000, 603388594],
            [1341014400000, 605205241],
            [1341100800000, 606504744],
            [1341187200000, 607219521],
            [1341273600000, 607764276],
            [1341360000000, 608482552],
            [1341446400000, 608959760],
            [1341532800000, 609640578],
            [1341619200000, 610558801],
            [1341705600000, 611127884],
            [1341792000000, 611389326],
            [1341878400000, 611701097],
            [1341964800000, 611973433],
            [1342051200000, 612261732],
            [1342137600000, 612657166],
            [1342224000000, 613244349],
            [1342310400000, 613660486],
            [1342396800000, 613849210],
            [1342483200000, 614070615],
            [1342569600000, 614265453],
            [1342656000000, 614438014],
            [1342742400000, 614628102],
            [1342828800000, 614883015],
            [1342915200000, 615058425],
            [1343001600000, 615156789],
            [1343088000000, 615280156],
            [1343174400000, 615373694],
            [1343260800000, 615483851],
            [1346371200000, 618233009],
            [1346457600000, 618921193],
            [1346544000000, 619760594],
            [1346630400000, 620323837],
            [1346716800000, 620445610],
            [1346803200000, 620532807],
            [1346889600000, 620628446],
            [1346976000000, 620845677],
            [1347062400000, 621251520],
            [1347148800000, 621414627],
            [1347235200000, 621460765],
            [1347321600000, 621517359],
            [1347408000000, 621569048],
            [1347494400000, 621623219]
        ],
        name: 'avengers11',
        showInLegend: false,
        extra: {
            title: 'Marvel´s The Avengers',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#435256'
        },
        showlabel: true,
        color: 'rgba(67,82,86,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1216339200000, 67165092
            ],
            [1216425600000, 114815332],
            [1216512000000, 158411483],
            [1216598400000, 182904796],
            [1216684800000, 203773518],
            [1216771200000, 222150806],
            [1216857600000, 238615211],
            [1216944000000, 261847503],
            [1217030400000, 290119997],
            [1217116800000, 313781677],
            [1217203200000, 324299793],
            [1217289600000, 333929159],
            [1217376000000, 342684300],
            [1217462400000, 351086846],
            [1217548800000, 363795881],
            [1217635200000, 380987031],
            [1217721600000, 393751065],
            [1217808000000, 400038494],
            [1217894400000, 405699734],
            [1217980800000, 410777101],
            [1218067200000, 415511467],
            [1218153600000, 423088829],
            [1218240000000, 433591072],
            [1218326400000, 441628497],
            [1218412800000, 445370695],
            [1218499200000, 448886084],
            [1218585600000, 451888386],
            [1218672000000, 454702857],
            [1218758400000, 459640812],
            [1218844800000, 466349645],
            [1218931200000, 471082150],
            [1219017600000, 473194356],
            [1219104000000, 475342688],
            [1219190400000, 477148000],
            [1219276800000, 478874461],
            [1219363200000, 481865527],
            [1219449600000, 486339697],
            [1219536000000, 489416885],
            [1219622400000, 490600141],
            [1219708800000, 491702478],
            [1219795200000, 492688931],
            [1219881600000, 493671047],
            [1219968000000, 495812401],
            [1220054400000, 499058870],
            [1220140800000, 502293926],
            [1220227200000, 504798337],
            [1220313600000, 505417800],
            [1220400000000, 505954123],
            [1220486400000, 506482539],
            [1220572800000, 507947315],
            [1220659200000, 510683335],
            [1220745600000, 511997658],
            [1220832000000, 512374922],
            [1220918400000, 512829031],
            [1221004800000, 513238453],
            [1221091200000, 513664611],
            [1221177600000, 514780719],
            [1221264000000, 516732450],
            [1221350400000, 517792764],
            [1221436800000, 518070111],
            [1221523200000, 518376320],
            [1221609600000, 518668741],
            [1221696000000, 518974853],
            [1221782400000, 519777880],
            [1221868800000, 521169518],
            [1221955200000, 521890027],
            [1222041600000, 522106180],
            [1222128000000, 522341786],
            [1222214400000, 522573036],
            [1222300800000, 522810263],
            [1222387200000, 523237138],
            [1222473600000, 524058474],
            [1222560000000, 524474684],
            [1222646400000, 524599547],
            [1222732800000, 524740642],
            [1222819200000, 524874072],
            [1222905600000, 525003174],
            [1222992000000, 525234268],
            [1223078400000, 525625565],
            [1223164800000, 525831387],
            [1223251200000, 525904670],
            [1223337600000, 525983815],
            [1223424000000, 526068474],
            [1223510400000, 526162586],
            [1223596800000, 526314081],
            [1223683200000, 526549462],
            [1223769600000, 526690914],
            [1223856000000, 526783113],
            [1223942400000, 526831522],
            [1224028800000, 526880947],
            [1224115200000, 526944204],
            [1224201600000, 527074478],
            [1224288000000, 527259976],
            [1224374400000, 527356352],
            [1224460800000, 527394547],
            [1224547200000, 527441809],
            [1224633600000, 527482905],
            [1224720000000, 527526286],
            [1224806400000, 527615985],
            [1224892800000, 527750249],
            [1224979200000, 527822235],
            [1225065600000, 527847433],
            [1225152000000, 527878017],
            [1225238400000, 527909624],
            [1225324800000, 527942811],
            [1225411200000, 527992020],
            [1225497600000, 528133068],
            [1225584000000, 528213279],
            [1225670400000, 528241353],
            [1225756800000, 528268585],
            [1225843200000, 528291602],
            [1225929600000, 528315892],
            [1226016000000, 528376324],
            [1226102400000, 528476214],
            [1226188800000, 528535317],
            [1226275200000, 528567824],
            [1226361600000, 528607482],
            [1226448000000, 528622949],
            [1226534400000, 528640736],
            [1226620800000, 528781111],
            [1226707200000, 529010886],
            [1226793600000, 529143070],
            [1226880000000, 529186691],
            [1226966400000, 529235982],
            [1227052800000, 529281828],
            [1227139200000, 529325841],
            [1227225600000, 529436296],
            [1227312000000, 529600927],
            [1227398400000, 529696290],
            [1227484800000, 529733882],
            [1227571200000, 529783349],
            [1227657600000, 529852602],
            [1227744000000, 529915623],
            [1227830400000, 530051190],
            [1227916800000, 530190274],
            [1228003200000, 530258989],
            [1228089600000, 530280291],
            [1228176000000, 530303397],
            [1228262400000, 530327889],
            [1228348800000, 530353467],
            [1228435200000, 530406712],
            [1228521600000, 530487981],
            [1228608000000, 530540885],
            [1228694400000, 530559137],
            [1228780800000, 530576842],
            [1228867200000, 530594370],
            [1228953600000, 530611373],
            [1229040000000, 530642871],
            [1229126400000, 530696616],
            [1229212800000, 530723626],
            [1229299200000, 530732032],
            [1229385600000, 530741363],
            [1229472000000, 530750228],
            [1229558400000, 530759822],
            [1229644800000, 530774791],
            [1229731200000, 530796576],
            [1229817600000, 530811565],
            [1229904000000, 530822957],
            [1229990400000, 530833780],
            [1230076800000, 530839192],
            [1230163200000, 530846166],
            [1230249600000, 530864431],
            [1230336000000, 530885363],
            [1230422400000, 530896852],
            [1230508800000, 530907655],
            [1230595200000, 530917814],
            [1230681600000, 530924926],
            [1230768000000, 530936438],
            [1230854400000, 530960516],
            [1230940800000, 530986558],
            [1231027200000, 531001578],
            [1231113600000, 531006084],
            [1231200000000, 531010375],
            [1231286400000, 531014280],
            [1231372800000, 531018614],
            [1231459200000, 531021301],
            [1231545600000, 531026048],
            [1231632000000, 531026626],
            [1231718400000, 531027030],
            [1231804800000, 531027357],
            [1231891200000, 531027626],
            [1231977600000, 531027799],
            [1232064000000, 531029814],
            [1232150400000, 531036642],
            [1232236800000, 531037410],
            [1232323200000, 531037655],
            [1232409600000, 531038124],
            [1232496000000, 531038469],
            [1232582400000, 531039412],
            [1232668800000, 531233755],
            [1232755200000, 531531139],
            [1232841600000, 531706809],
            [1232928000000, 531757754],
            [1233014400000, 531813793],
            [1233100800000, 531867031],
            [1233187200000, 531919903],
            [1233273600000, 532042710],
            [1233360000000, 532286579],
            [1233446400000, 532356746],
            [1233532800000, 532388922],
            [1233619200000, 532419108],
            [1233705600000, 532448983],
            [1233792000000, 532478141],
            [1233878400000, 532566608],
            [1233964800000, 532735827],
            [1234051200000, 532831967],
            [1234137600000, 532852758],
            [1234224000000, 532874732],
            [1234310400000, 532895608],
            [1234396800000, 532916540],
            [1234483200000, 532941278],
            [1234569600000, 533009632],
            [1234656000000, 533044185],
            [1234742400000, 533062050],
            [1234828800000, 533070468],
            [1234915200000, 533078271],
            [1235001600000, 533090262],
            [1235088000000, 533115511],
            [1235174400000, 533164552],
            [1235260800000, 533184219],
            [1235347200000, 533192086],
            [1235433600000, 533197770],
            [1235520000000, 533204875],
            [1235606400000, 533213994],
            [1235692800000, 533237923],
            [1235779200000, 533292620],
            [1235865600000, 533316061],
            [1235952000000, 533323328],
            [1236038400000, 533330642],
            [1236124800000, 533337152],
            [1236211200000, 533345358]
        ],
        name: 'darkknight',
        showInLegend: false,
        extra: {
            title: 'The Dark Knight',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#2D4551'
        },
        showlabel: true,
        color: 'rgba(45,69,81,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                927072000000, 28542349
            ],
            [927158400000, 40840267],
            [927244800000, 59307780],
            [927331200000, 83721903],
            [927417600000, 105661237],
            [927504000000, 116542509],
            [927590400000, 124723784],
            [927676800000, 132475660],
            [927763200000, 140194760],
            [927849600000, 153726321],
            [927936000000, 173057101],
            [928022400000, 191594623],
            [928108800000, 207099058],
            [928195200000, 212558695],
            [928281600000, 217854543],
            [928368000000, 222866471],
            [928454400000, 231280254],
            [928540800000, 245134578],
            [928627200000, 255758124],
            [928713600000, 259677495],
            [928800000000, 263679744],
            [928886400000, 267491901],
            [928972800000, 271332050],
            [929059200000, 278027376],
            [929145600000, 288582722],
            [929232000000, 296964911],
            [929318400000, 299990176],
            [929404800000, 303061673],
            [929491200000, 306030682],
            [929577600000, 309213848],
            [929664000000, 313913571],
            [929750400000, 321252062],
            [929836800000, 328072869],
            [929923200000, 330443466],
            [930009600000, 332861798],
            [930096000000, 335088273],
            [930182400000, 337557762],
            [930268800000, 341358058],
            [930355200000, 347148476],
            [930441600000, 351669681],
            [930528000000, 353780085],
            [930614400000, 356021057],
            [930700800000, 357760813],
            [930787200000, 359875311],
            [930873600000, 362766434],
            [930960000000, 366618828],
            [931046400000, 369415693],
            [931132800000, 373166970],
            [931219200000, 374889918],
            [931305600000, 376272871],
            [931392000000, 377692976],
            [931478400000, 379764163],
            [931564800000, 382938277],
            [931651200000, 385184373],
            [931737600000, 386249482],
            [931824000000, 387465405],
            [931910400000, 388525146],
            [931996800000, 389553609],
            [932083200000, 391020073],
            [932169600000, 393411782],
            [932256000000, 395201250],
            [932342400000, 396049197],
            [932428800000, 396935225],
            [932515200000, 397748777],
            [932601600000, 398573626],
            [932688000000, 399634853],
            [932774400000, 401438178],
            [932860800000, 402770726],
            [932947200000, 403357141],
            [933033600000, 404005833],
            [933120000000, 404573895],
            [933206400000, 405176312],
            [933292800000, 406087436],
            [933379200000, 407507745],
            [933465600000, 408597032],
            [933552000000, 409084394],
            [933638400000, 409590536],
            [933724800000, 410076929],
            [933811200000, 410551953],
            [933897600000, 411136305],
            [933984000000, 412017281],
            [934070400000, 412775151],
            [934156800000, 413078199],
            [934243200000, 413454282],
            [934329600000, 413789230],
            [934416000000, 414126705],
            [934502400000, 414536568],
            [934588800000, 415172414],
            [934675200000, 415645312],
            [934761600000, 415859856],
            [934848000000, 416112048],
            [934934400000, 416349911],
            [935020800000, 416579492],
            [935107200000, 416906880],
            [935193600000, 417430661],
            [935280000000, 417800897],
            [935366400000, 417969425],
            [935452800000, 418165536],
            [935539200000, 418337535],
            [935625600000, 418513721],
            [935712000000, 418767483],
            [935798400000, 419154643],
            [935884800000, 419423967],
            [935971200000, 419526792],
            [936057600000, 419647257],
            [936144000000, 419746342],
            [936230400000, 419846896],
            [936316800000, 420090328],
            [936403200000, 420520139],
            [936489600000, 420995738],
            [936576000000, 421381756],
            [936662400000, 421464015],
            [936748800000, 421534687],
            [936835200000, 421599674],
            [936921600000, 421762882],
            [937008000000, 422079020],
            [937094400000, 422252998],
            [937180800000, 422303304],
            [937267200000, 422363559],
            [937353600000, 422422603],
            [937440000000, 422499719],
            [937526400000, 422699966],
            [937612800000, 423063595],
            [937699200000, 423299088],
            [937785600000, 423375256],
            [937872000000, 423455814],
            [937958400000, 423524933],
            [938044800000, 423597795],
            [938131200000, 423809480],
            [938217600000, 424178821],
            [938304000000, 424399730],
            [938390400000, 424466271],
            [938476800000, 424536942],
            [938563200000, 424598131],
            [938649600000, 424663188],
            [938736000000, 424837518],
            [938822400000, 425158196],
            [938908800000, 425360285],
            [938995200000, 425415671],
            [939081600000, 425476913],
            [939168000000, 425535850],
            [939254400000, 425603608],
            [939340800000, 425743396],
            [939427200000, 425982420],
            [939513600000, 426141814],
            [939600000000, 426231842],
            [939686400000, 426284622],
            [939772800000, 426330344],
            [939859200000, 426382547],
            [939945600000, 426491859],
            [940032000000, 426690085],
            [940118400000, 426818051],
            [940204800000, 426856130],
            [940291200000, 426891167],
            [940377600000, 426924507],
            [940464000000, 426962430],
            [940550400000, 427046077],
            [940636800000, 427195487],
            [940723200000, 427285100],
            [940809600000, 427311268],
            [940896000000, 427335999],
            [940982400000, 427358724],
            [941068800000, 427385273],
            [941155200000, 427446960],
            [941241600000, 427552043],
            [941328000000, 427607869],
            [941414400000, 427630283],
            [941500800000, 427655389],
            [941587200000, 427680179],
            [941673600000, 427709795]
        ],
        name: 'starwars',
        showInLegend: false,
        extra: {
            title: 'Star Wars: Episode I - The Phantom Menace',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#8B5453'
        },
        showlabel: true,
        color: 'rgba(139,84,83,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                233366400000, 254809
            ],
            [233452800000, 493774]
        ],
        name: 'starwars4',
        showInLegend: false,
        extra: {
            title: 'Star Wars',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#775E55'
        },
        showlabel: false,
        color: 'rgba(119,94,85,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1430438400000, 84424532
            ],
            [1430524800000, 140951167],
            [1430611200000, 191271109],
            [1430697600000, 204499664],
            [1430784000000, 217632476],
            [1430870400000, 227042314],
            [1430956800000, 235655468],
            [1431043200000, 256887830],
            [1431129600000, 290723486],
            [1431216000000, 313402397],
            [1431302400000, 318801176],
            [1431388800000, 324791589],
            [1431475200000, 329133743],
            [1431561600000, 333170808],
            [1431648000000, 343189933],
            [1431734400000, 360394291],
            [1431820800000, 372030708],
            [1431907200000, 375466255],
            [1431993600000, 378486835],
            [1432080000000, 380816733],
            [1432166400000, 383170479],
            [1432252800000, 388526903],
            [1432339200000, 396813139],
            [1432425600000, 404862176],
            [1432512000000, 411369385],
            [1432598400000, 413318567],
            [1432684800000, 414747982],
            [1432771200000, 416150025],
            [1432857600000, 419033597],
            [1432944000000, 423951452],
            [1433030400000, 427551427],
            [1433116800000, 428633715],
            [1433203200000, 429894783],
            [1433289600000, 430868667],
            [1433376000000, 431813896],
            [1433462400000, 433656556],
            [1433548800000, 436312967],
            [1433635200000, 438153559],
            [1433721600000, 438901113],
            [1433808000000, 439752678],
            [1433894400000, 440471543],
            [1433980800000, 441102218],
            [1434067200000, 442166874],
            [1434153600000, 443689327],
            [1434240000000, 444777275],
            [1434326400000, 445228711],
            [1434412800000, 445730903],
            [1434499200000, 446173457],
            [1434585600000, 446599953],
            [1434672000000, 447334280],
            [1434758400000, 448375514],
            [1434844800000, 449447357],
            [1434931200000, 449772697],
            [1435017600000, 450162782],
            [1435104000000, 450479161],
            [1435190400000, 450785255],
            [1435276800000, 451267668],
            [1435363200000, 451970769],
            [1435449600000, 452474193],
            [1435536000000, 452722320],
            [1435622400000, 452963254],
            [1435708800000, 453126252],
            [1435795200000, 453345278],
            [1435881600000, 453708860],
            [1435968000000, 453978248],
            [1436054400000, 454231429],
            [1436140800000, 454371767],
            [1436227200000, 454526885],
            [1436313600000, 454662988],
            [1436400000000, 454783082],
            [1436486400000, 454911383],
            [1436572800000, 455097078],
            [1436659200000, 455238846],
            [1436745600000, 455308687],
            [1436832000000, 455392001],
            [1436918400000, 455466546],
            [1437004800000, 455530367]
        ],
        name: 'avengers2',
        showInLegend: false,
        extra: {
            title: 'Avengers: Age of Ultron',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#5A5A65'
        },
        showlabel: true,
        color: 'rgba(90,90,101,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1342742400000, 75754897
            ],
            [1342828800000, 120686863],
            [1342915200000, 160887295],
            [1343001600000, 180276424],
            [1343088000000, 198038896],
            [1343174400000, 211808988],
            [1343260800000, 225011359],
            [1343347200000, 242745904],
            [1343433600000, 267458321],
            [1343520000000, 287112810],
            [1343606400000, 295272856],
            [1343692800000, 304045972],
            [1343779200000, 311379297],
            [1343865600000, 318197764],
            [1343952000000, 328423814],
            [1344038400000, 342696928],
            [1344124800000, 353935094],
            [1344211200000, 358660592],
            [1344297600000, 363334004],
            [1344384000000, 367022493],
            [1344470400000, 370608819],
            [1344556800000, 376209018],
            [1344643200000, 384049010],
            [1344729600000, 389588216],
            [1344816000000, 391932219],
            [1344902400000, 394606579],
            [1344988800000, 396743702],
            [1345075200000, 398775911],
            [1345161600000, 401898047],
            [1345248000000, 406466053],
            [1345334400000, 409787260],
            [1345420800000, 411161725],
            [1345507200000, 412665020],
            [1345593600000, 413861764],
            [1345680000000, 415032901],
            [1345766400000, 417023135],
            [1345852800000, 420167698],
            [1345939200000, 422255218],
            [1346025600000, 423088380],
            [1346112000000, 423976618],
            [1346198400000, 424645743],
            [1346284800000, 425313950],
            [1346371200000, 426729442],
            [1346457600000, 428977017],
            [1346544000000, 431430285],
            [1346630400000, 433311261],
            [1346716800000, 433814754],
            [1346803200000, 434176924],
            [1346889600000, 434564293],
            [1346976000000, 435427612],
            [1347062400000, 436998761],
            [1347148800000, 437782482],
            [1347235200000, 438033912],
            [1347321600000, 438351214],
            [1347408000000, 438614544],
            [1347494400000, 438870629],
            [1347580800000, 439479702],
            [1347667200000, 440507249],
            [1347753600000, 441053078],
            [1347840000000, 441259444],
            [1347926400000, 441497581],
            [1348012800000, 441676748],
            [1348099200000, 441857870],
            [1348185600000, 442205702],
            [1348272000000, 442814116],
            [1348358400000, 443124014],
            [1348444800000, 443227456],
            [1348531200000, 443355816],
            [1348617600000, 443481942],
            [1348704000000, 443588231],
            [1348790400000, 443806466],
            [1348876800000, 444185120],
            [1348963200000, 444377660],
            [1349049600000, 444450827],
            [1349136000000, 444539967],
            [1349222400000, 444613164],
            [1349308800000, 444695205],
            [1349395200000, 444874399],
            [1349481600000, 445169674],
            [1349568000000, 445369641],
            [1349654400000, 445473624],
            [1349740800000, 445548492],
            [1349827200000, 445620366],
            [1349913600000, 445688597],
            [1350000000000, 445838623],
            [1350086400000, 446069263],
            [1350172800000, 446199996],
            [1350259200000, 446247060],
            [1350345600000, 446299772],
            [1350432000000, 446350903],
            [1350518400000, 446404558],
            [1350604800000, 446510422],
            [1350691200000, 446670784],
            [1350777600000, 446764067],
            [1350864000000, 446792585],
            [1350950400000, 446828688],
            [1351036800000, 446861181],
            [1351123200000, 446894498],
            [1351209600000, 446973503],
            [1351296000000, 447090759],
            [1351382400000, 447158354],
            [1351468800000, 447182460],
            [1351555200000, 447208948],
            [1351641600000, 447233929],
            [1351728000000, 447261407],
            [1351814400000, 447332316],
            [1351900800000, 447452707],
            [1351987200000, 447521147],
            [1352073600000, 447549207],
            [1352160000000, 447572216],
            [1352246400000, 447595455],
            [1352332800000, 447614511],
            [1352419200000, 447656553],
            [1352505600000, 447722850],
            [1352592000000, 447764583],
            [1352678400000, 447786285],
            [1352764800000, 447796919],
            [1352851200000, 447807034],
            [1352937600000, 447817857],
            [1353024000000, 447844064],
            [1353110400000, 447885951],
            [1353196800000, 447911148],
            [1353283200000, 447922495],
            [1353369600000, 447936620],
            [1353456000000, 447951400],
            [1353542400000, 447963899],
            [1353628800000, 447992079],
            [1353715200000, 448021138],
            [1353801600000, 448034362],
            [1353888000000, 448038030],
            [1353974400000, 448042358],
            [1354060800000, 448046413],
            [1354147200000, 448052931],
            [1354233600000, 448065058],
            [1354320000000, 448083829],
            [1354406400000, 448093796],
            [1354492800000, 448097008],
            [1354579200000, 448100216],
            [1354665600000, 448103268],
            [1354752000000, 448106311],
            [1354838400000, 448113420],
            [1354924800000, 448124786],
            [1355011200000, 448130642],
            [1355097600000, 448132546],
            [1355184000000, 448134640],
            [1355270400000, 448136692],
            [1355356800000, 448139099]
        ],
        name: 'batman3',
        showInLegend: false,
        extra: {
            title: 'The Dark Knight Rises',
            genre: 'Action Thriller',

            mpaaRating: 'PG-13',
            imgMainColor: '#402D23'
        },
        showlabel: true,
        color: 'rgba(64,45,35,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1084924800000, 11786415
            ],
            [1085011200000, 20945182],
            [1085097600000, 49285477],
            [1085184000000, 94082519],
            [1085270400000, 128983060],
            [1085356800000, 140495380],
            [1085443200000, 148518679],
            [1085529600000, 156522146],
            [1085616000000, 164735354],
            [1085702400000, 184890392],
            [1085788800000, 212125502],
            [1085875200000, 236905717],
            [1085961600000, 260313719],
            [1086048000000, 266120395],
            [1086134400000, 271515827],
            [1086220800000, 276591486],
            [1086307200000, 287045206],
            [1086393600000, 302608864],
            [1086480000000, 314523202],
            [1086566400000, 318064963],
            [1086652800000, 321821215],
            [1086739200000, 325767202],
            [1086825600000, 330016397],
            [1086912000000, 337481436],
            [1086998400000, 346511753],
            [1087084800000, 353333317],
            [1087171200000, 356211204],
            [1087257600000, 359054821],
            [1087344000000, 361840005],
            [1087430400000, 364681313],
            [1087516800000, 368837503],
            [1087603200000, 374235745],
            [1087689600000, 378623263],
            [1087776000000, 380509910],
            [1087862400000, 382783646],
            [1087948800000, 384608284],
            [1088035200000, 386566083],
            [1088121600000, 389714732],
            [1088208000000, 393825312],
            [1088294400000, 396782535],
            [1088380800000, 398263014],
            [1088467200000, 399753526],
            [1088553600000, 400977740],
            [1088640000000, 402300825],
            [1088726400000, 404239250],
            [1088812800000, 406475278],
            [1088899200000, 408139196],
            [1088985600000, 410688506],
            [1089072000000, 411804318],
            [1089158400000, 412928508],
            [1089244800000, 414066842],
            [1089331200000, 415440867],
            [1089417600000, 417193398],
            [1089504000000, 418517158],
            [1089590400000, 419277884],
            [1089676800000, 420140444],
            [1089763200000, 420979198],
            [1089849600000, 421780860],
            [1089936000000, 422670285],
            [1090022400000, 423892732],
            [1090108800000, 425011646],
            [1090195200000, 425545150],
            [1090281600000, 426081270],
            [1090368000000, 426592176],
            [1090454400000, 427124631],
            [1090540800000, 427784311],
            [1090627200000, 428715869],
            [1090713600000, 429441294],
            [1090800000000, 429806006],
            [1090886400000, 430317578],
            [1090972800000, 430806699],
            [1091059200000, 431176122],
            [1091145600000, 431522984],
            [1091232000000, 432040000],
            [1091318400000, 432493392],
            [1091404800000, 432724124],
            [1091491200000, 432979072],
            [1091577600000, 433251960],
            [1091664000000, 433510973],
            [1091750400000, 433765285],
            [1091836800000, 434120887],
            [1091923200000, 434404842],
            [1092009600000, 434545517],
            [1092096000000, 434737788],
            [1092182400000, 434909809],
            [1092268800000, 435073190],
            [1092355200000, 435241910],
            [1092441600000, 435449431],
            [1092528000000, 435640772],
            [1092614400000, 435745893],
            [1092700800000, 435841134],
            [1092787200000, 435940815],
            [1092873600000, 436048250],
            [1092960000000, 436156384],
            [1093046400000, 436339891],
            [1093132800000, 436471036],
            [1093219200000, 436532440],
            [1093305600000, 436599373],
            [1093392000000, 436660341],
            [1093478400000, 436721703]
        ],
        name: 'shrek2',
        showInLegend: false,
        extra: {
            title: 'Shrek 2',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#7B8291'
        },
        showlabel: true,
        color: 'rgba(123,130,145,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                392601600000, 3099665
            ],
            [392688000000, 7611314],
            [392774400000, 11835389],
            [392860800000, 14193155],
            [392947200000, 16724092],
            [393033600000, 19320918],
            [393120000000, 21806376],
            [393206400000, 25506800],
            [393292800000, 30365918],
            [393379200000, 34416986],
            [393465600000, 36864295],
            [393552000000, 39504421],
            [393638400000, 42158124],
            [393724800000, 44822010],
            [393811200000, 48868627],
            [393897600000, 54047474],
            [393984000000, 58551562],
            [394070400000, 61323250],
            [394156800000, 64365340],
            [394243200000, 67037474],
            [394329600000, 69703555],
            [394416000000, 73621238],
            [394502400000, 78791283],
            [394588800000, 82480009],
            [394675200000, 86410147],
            [394761600000, 88911270],
            [394848000000, 91527459],
            [394934400000, 94050312],
            [395020800000, 97794594],
            [395107200000, 102652306],
            [395193600000, 106852599],
            [395280000000, 109264627],
            [395366400000, 111619529],
            [395452800000, 114089090],
            [395539200000, 116430515],
            [395625600000, 120260133],
            [395712000000, 125233596],
            [395798400000, 129434096],
            [395884800000, 131926349],
            [395971200000, 134643840],
            [396057600000, 136966146],
            [396144000000, 139317420],
            [396230400000, 142763159],
            [396316800000, 147113884],
            [396403200000, 150572544],
            [396489600000, 152600956],
            [396576000000, 154846898],
            [396662400000, 157148472],
            [396748800000, 159080985],
            [396835200000, 162152605],
            [396921600000, 166328695],
            [397008000000, 169506056],
            [397094400000, 171427836],
            [397180800000, 173401065],
            [397267200000, 175313851],
            [397353600000, 177165841],
            [397440000000, 179878228],
            [397526400000, 183595810],
            [397612800000, 186691147],
            [397699200000, 188491717],
            [397785600000, 190262500],
            [397872000000, 191968833],
            [397958400000, 193519752],
            [398044800000, 196024795],
            [398131200000, 199374676],
            [398217600000, 201968592],
            [398304000000, 203453951],
            [398390400000, 205103355],
            [398476800000, 206615273],
            [398563200000, 208023105],
            [398649600000, 210225776],
            [398736000000, 213267082],
            [398822400000, 215707267],
            [398908800000, 217075453],
            [398995200000, 218440634],
            [399081600000, 219764659],
            [399168000000, 220819589],
            [399254400000, 222722377],
            [399340800000, 225427246],
            [399427200000, 227450298],
            [399513600000, 228359352],
            [399600000000, 229298310],
            [399686400000, 230189023],
            [399772800000, 230977250],
            [399859200000, 232382626],
            [399945600000, 234657148],
            [400032000000, 236998236],
            [400118400000, 238646109],
            [400204800000, 239177568],
            [400291200000, 239655752],
            [400377600000, 240118856],
            [400464000000, 241252612],
            [400550400000, 243318578],
            [400636800000, 244717584],
            [400723200000, 245100056],
            [400809600000, 245540212],
            [400896000000, 245968992],
            [400982400000, 246339094],
            [401068800000, 247361125],
            [401155200000, 249321423],
            [401241600000, 250600981],
            [401328000000, 250926752],
            [401414400000, 251300839],
            [401500800000, 251641941],
            [401587200000, 251939806],
            [401673600000, 252873573],
            [401760000000, 254682309],
            [401846400000, 256031594],
            [401932800000, 256405912],
            [402019200000, 256739834],
            [402105600000, 257048456],
            [402192000000, 257344746],
            [402278400000, 258198499],
            [402364800000, 259930330],
            [402451200000, 261086886],
            [402537600000, 261381057],
            [402624000000, 261676886],
            [402710400000, 261955747],
            [402796800000, 262211307],
            [402883200000, 263029848],
            [402969600000, 264707823],
            [403056000000, 265973075],
            [403142400000, 266478906],
            [403228800000, 266741653],
            [403315200000, 266980280],
            [403401600000, 267241424],
            [403488000000, 267974655],
            [403574400000, 269520994],
            [403660800000, 270557116],
            [403747200000, 270823996],
            [403833600000, 271083432],
            [403920000000, 271320323],
            [404006400000, 271594872],
            [404092800000, 272328088],
            [404179200000, 273763043],
            [404265600000, 274838082],
            [404352000000, 275081705],
            [404438400000, 275352724],
            [404524800000, 275576031],
            [404611200000, 275796622],
            [404697600000, 276399760],
            [404784000000, 277532658],
            [404870400000, 278565874],
            [404956800000, 278817395],
            [405043200000, 279128114],
            [405129600000, 279343174],
            [405216000000, 279551958],
            [405302400000, 280203582],
            [405388800000, 281586084],
            [405475200000, 282598650],
            [405561600000, 282809495],
            [405648000000, 283048506],
            [405734400000, 283324368],
            [405820800000, 283763623],
            [405907200000, 284424778],
            [405993600000, 285763291],
            [406080000000, 286709095],
            [406166400000, 286899252],
            [406252800000, 287113405],
            [406339200000, 287293008],
            [406425600000, 287476191],
            [406512000000, 288108850],
            [406598400000, 289405988],
            [406684800000, 290356895],
            [406771200000, 290568160],
            [406857600000, 290828330],
            [406944000000, 291223317],
            [407030400000, 292012960],
            [407116800000, 293422682],
            [407203200000, 295050132],
            [407289600000, 295989738],
            [407376000000, 296180765],
            [407462400000, 296411572],
            [407548800000, 296568970],
            [407721600000, 297078744],
            [407808000000, 298142537],
            [407894400000, 298924789],
            [407980800000, 299083220],
            [408067200000, 299278614],
            [408153600000, 299430215],
            [408240000000, 299575782],
            [408326400000, 299968498],
            [408412800000, 300798974],
            [408499200000, 301455400],
            [408585600000, 301611481],
            [408672000000, 301824151],
            [408758400000, 302096699],
            [408844800000, 302350061],
            [408931200000, 302902764],
            [409017600000, 303957600],
            [409104000000, 304942178],
            [409190400000, 305369688],
            [409276800000, 305858348],
            [409363200000, 306293198],
            [409449600000, 306834918],
            [409536000000, 307189676],
            [409622400000, 307940850],
            [409708800000, 309375473],
            [409795200000, 310479451],
            [409881600000, 311604018],
            [409968000000, 312700021],
            [410054400000, 313802372],
            [410140800000, 314911094],
            [410227200000, 316458659],
            [410313600000, 317827565],
            [410400000000, 318234428],
            [410486400000, 318584860],
            [410572800000, 318890220],
            [410659200000, 319140904],
            [410745600000, 319717206],
            [410832000000, 320885281],
            [410918400000, 321763163],
            [411004800000, 321952256],
            [411091200000, 322171023],
            [411177600000, 322355878],
            [411264000000, 321763163],
            [411350400000, 322956667],
            [411436800000, 323726371],
            [411523200000, 324297874],
            [411609600000, 324437249],
            [411696000000, 324569586],
            [411782400000, 324689314],
            [411868800000, 324793587],
            [411955200000, 325067003],
            [412041600000, 325703813],
            [412128000000, 326208498],
            [412214400000, 326313172],
            [412300800000, 326434340],
            [412387200000, 326535546],
            [412473600000, 326638438],
            [412560000000, 326903012],
            [412646400000, 327517548],
            [412732800000, 327909778],
            [412819200000, 328014053],
            [412905600000, 328118609],
            [412992000000, 328207770],
            [413078400000, 328287532],
            [413164800000, 328483028],
            [413251200000, 328976104],
            [413337600000, 329338126],
            [413424000000, 329397487],
            [413510400000, 329462370],
            [413596800000, 329525954],
            [413683200000, 329581773],
            [413769600000, 329742295],
            [413856000000, 330110140],
            [413942400000, 330392812],
            [414028800000, 330470779],
            [414115200000, 330550172],
            [414201600000, 330623901],
            [414288000000, 330697312],
            [414374400000, 331016599],
            [414460800000, 331706333],
            [414547200000, 332308013],
            [414633600000, 332585150],
            [414720000000, 332740310],
            [414806400000, 332867042],
            [414892800000, 332985896],
            [414979200000, 333277225],
            [415065600000, 333901636],
            [415152000000, 334376230],
            [415238400000, 334442851],
            [415324800000, 334568624],
            [415411200000, 334664946],
            [415497600000, 334755328],
            [415584000000, 334980830],
            [415670400000, 335431809],
            [415756800000, 335769779],
            [415843200000, 335846397],
            [415929600000, 335939875],
            [416016000000, 336014565],
            [416102400000, 336080296],
            [416188800000, 336247331],
            [416275200000, 336575594],
            [416361600000, 336811284],
            [416448000000, 336867259],
            [416534400000, 336937844],
            [416620800000, 336994325],
            [416707200000, 337053319],
            [416793600000, 337209821],
            [416880000000, 337546990],
            [416966400000, 337803244],
            [417052800000, 337863050],
            [417139200000, 337936002],
            [417225600000, 338001152],
            [417312000000, 338065673],
            [417398400000, 338190640],
            [417484800000, 338427300],
            [417571200000, 338601802],
            [417657600000, 338660363],
            [417744000000, 338729324],
            [417830400000, 338790009],
            [418003200000, 339111278],
            [418089600000, 339497763],
            [418176000000, 339839909],
            [418262400000, 340041065],
            [418348800000, 340202098],
            [418435200000, 340340697],
            [418521600000, 340462121],
            [418608000000, 340822037],
            [418694400000, 341432595],
            [418780800000, 341923413],
            [418867200000, 342048218],
            [418953600000, 342270196],
            [419040000000, 342447365],
            [419126400000, 342606287],
            [419212800000, 342976462],
            [419299200000, 343666039],
            [419385600000, 344163877],
            [419472000000, 344296018],
            [419558400000, 344434710],
            [419644800000, 344548443],
            [419731200000, 344654028],
            [419817600000, 344940506],
            [419904000000, 345459635],
            [419990400000, 345849534],
            [420076800000, 345943875],
            [420163200000, 346034386],
            [420249600000, 346115216],
            [420336000000, 346190133],
            [420422400000, 346395980],
            [420508800000, 346784080],
            [420595200000, 347043083],
            [420681600000, 347102397],
            [420768000000, 347171397],
            [420854400000, 347229966],
            [420940800000, 347281435],
            [421027200000, 347408761],
            [421113600000, 347639928],
            [421200000000, 347807198],
            [421286400000, 347855066],
            [421372800000, 347905325],
            [421459200000, 347951871],
            [421545600000, 347989771],
            [421632000000, 348134859],
            [421718400000, 348376483],
            [421804800000, 348544883],
            [421891200000, 348585815],
            [421977600000, 348635169],
            [422064000000, 348678708],
            [422150400000, 348728868],
            [422236800000, 348939680],
            [422323200000, 349280662],
            [422409600000, 349527852],
            [422496000000, 349602091],
            [422582400000, 349670977],
            [422668800000, 349733874],
            [422755200000, 349796275],
            [422841600000, 350131415],
            [422928000000, 350677277],
            [423014400000, 351234240],
            [423100800000, 351515075],
            [423187200000, 351633331],
            [423273600000, 351749881],
            [423360000000, 351851986],
            [423446400000, 352134333],
            [423532800000, 352622617],
            [423619200000, 352905920],
            [423705600000, 353013716],
            [423792000000, 353132300],
            [423878400000, 353238581],
            [423964800000, 353343189]
        ],
        name: 'et',
        showInLegend: false,
        extra: {
            title: 'E.T.: The Extra-Terrestrial',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#353A4A'
        },
        showlabel: true,
        color: 'rgba(53,58,74,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1385078400000, 70950136
            ],
            [1385164800000, 123569242],
            [1385251200000, 158074286],
            [1385337600000, 170396008],
            [1385424000000, 186356317],
            [1385510400000, 207164427],
            [1385596800000, 222116056],
            [1385683200000, 253686504],
            [1385769600000, 282087763],
            [1385856000000, 296295657],
            [1385942400000, 299698207],
            [1386028800000, 303708162],
            [1386115200000, 306725979],
            [1386201600000, 309664956],
            [1386288000000, 317440734],
            [1386374400000, 329363612],
            [1386460800000, 335850842],
            [1386547200000, 337794484],
            [1386633600000, 340167159],
            [1386720000000, 342022652],
            [1386806400000, 343831997],
            [1386892800000, 347937894],
            [1386979200000, 353684449],
            [1387065600000, 357503663],
            [1387152000000, 358823252],
            [1387238400000, 360346858],
            [1387324800000, 361589963],
            [1387411200000, 362953796],
            [1387497600000, 365458768],
            [1387584000000, 368860257],
            [1387670400000, 371718275],
            [1387756800000, 373997033],
            [1387843200000, 375355861],
            [1387929600000, 377884011],
            [1388016000000, 380923843],
            [1388102400000, 384356876],
            [1388188800000, 388053784],
            [1388275200000, 390985322],
            [1388361600000, 393474778],
            [1388448000000, 395526705],
            [1388534400000, 398407026],
            [1388620800000, 400088390],
            [1388707200000, 402531201],
            [1388793600000, 405577552],
            [1388880000000, 407139699],
            [1388966400000, 407703526],
            [1389052800000, 408372775],
            [1389139200000, 408896153],
            [1389225600000, 409392651],
            [1389312000000, 410600745],
            [1389398400000, 412684209],
            [1389484800000, 413775859],
            [1389571200000, 414069798],
            [1389657600000, 414423452],
            [1389744000000, 414714237],
            [1389830400000, 414999792],
            [1389916800000, 415630857],
            [1390003200000, 416775276],
            [1390089600000, 417450973],
            [1390176000000, 418019611],
            [1390262400000, 418182152],
            [1390348800000, 418329756],
            [1390435200000, 418481968],
            [1390521600000, 418879606],
            [1390608000000, 419627702],
            [1390694400000, 420021917],
            [1390780800000, 420127670],
            [1390867200000, 420255106],
            [1390953600000, 420357904],
            [1391040000000, 420468544],
            [1391126400000, 420746003],
            [1391212800000, 421256407],
            [1391299200000, 421408636],
            [1391385600000, 421490985],
            [1391472000000, 421592065],
            [1391558400000, 421669861],
            [1391644800000, 421750785],
            [1391731200000, 421915396],
            [1391817600000, 422238736],
            [1391904000000, 422411453],
            [1391990400000, 422461572],
            [1392076800000, 422511049],
            [1392163200000, 422541078],
            [1392249600000, 422575819],
            [1392336000000, 422748276],
            [1392422400000, 422964659],
            [1392508800000, 423111431],
            [1392595200000, 423202848],
            [1392681600000, 423239439],
            [1392768000000, 423273340],
            [1392854400000, 423307516],
            [1392940800000, 423395821],
            [1393027200000, 423547716],
            [1393113600000, 423626642],
            [1393200000000, 423646682],
            [1393286400000, 423671890],
            [1393372800000, 423694814],
            [1393459200000, 423719424],
            [1393545600000, 423768827],
            [1393632000000, 423860821],
            [1393718400000, 423905466],
            [1393804800000, 423921280],
            [1393891200000, 423939264],
            [1393977600000, 423953700],
            [1394064000000, 423969843],
            [1394150400000, 424004535],
            [1394236800000, 424060954],
            [1394323200000, 424088260],
            [1394409600000, 424098843],
            [1394496000000, 424112127],
            [1394582400000, 424122403],
            [1394668800000, 424133881],
            [1394755200000, 424194100],
            [1394841600000, 424282090],
            [1394928000000, 424339131],
            [1395014400000, 424357871],
            [1395100800000, 424379894],
            [1395187200000, 424399597],
            [1395273600000, 424417580],
            [1395360000000, 424449830],
            [1395446400000, 424500497],
            [1395532800000, 424532478],
            [1395619200000, 424543695],
            [1395705600000, 424557150],
            [1395792000000, 424569768],
            [1395878400000, 424582054],
            [1395964800000, 424600272],
            [1396051200000, 424628986],
            [1396137600000, 424645577],
            [1396224000000, 424650752],
            [1396310400000, 424656792],
            [1396396800000, 424662174],
            [1396483200000, 424668047]
        ],
        name: 'catchingfire',
        showInLegend: false,
        extra: {
            title: 'The Hunger Games: Catching Fire',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#3F1911'
        },
        showlabel: false,
        color: 'rgba(63,25,17,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1152230400000, 55830600
            ],
            [1152316800000, 100273825],
            [1152403200000, 135634554],
            [1152489600000, 153774825],
            [1152576000000, 169506744],
            [1152662400000, 183661469],
            [1152748800000, 196019502],
            [1152835200000, 214563858],
            [1152921600000, 239410629],
            [1153008000000, 258364766],
            [1153094400000, 266277457],
            [1153180800000, 273767461],
            [1153267200000, 280215929],
            [1153353600000, 286684032],
            [1153440000000, 296676213],
            [1153526400000, 311341880],
            [1153612800000, 321899233],
            [1153699200000, 326203444],
            [1153785600000, 330424411],
            [1153872000000, 334133670],
            [1153958400000, 337879183],
            [1154044800000, 343845283],
            [1154131200000, 352233958],
            [1154217600000, 358485761],
            [1154304000000, 361089168],
            [1154390400000, 363838343],
            [1154476800000, 366387380],
            [1154563200000, 368697958],
            [1154649600000, 371939269],
            [1154736000000, 376421667],
            [1154822400000, 379699644],
            [1154908800000, 381273783],
            [1154995200000, 382656373],
            [1155081600000, 383881830],
            [1155168000000, 385193854],
            [1155254400000, 387274051],
            [1155340800000, 390330892],
            [1155427200000, 392431781],
            [1155513600000, 393369734],
            [1155600000000, 394371747],
            [1155686400000, 395208464],
            [1155772800000, 396040741],
            [1155859200000, 397426174],
            [1155945600000, 399667443],
            [1156032000000, 401253092],
            [1156118400000, 401821420],
            [1156204800000, 402415220],
            [1156291200000, 402975626],
            [1156377600000, 403565356],
            [1156464000000, 404627141],
            [1156550400000, 406311953],
            [1156636800000, 407544616],
            [1156723200000, 407969720],
            [1156809600000, 408392316],
            [1156896000000, 408766323],
            [1156982400000, 409098046],
            [1157068800000, 409927376],
            [1157155200000, 411397806],
            [1157241600000, 412883344],
            [1157328000000, 414013957],
            [1157414400000, 414229498],
            [1157500800000, 414415202],
            [1157587200000, 414596572],
            [1157673600000, 415091504],
            [1157760000000, 416066198],
            [1157846400000, 416591183],
            [1157932800000, 416710619],
            [1158019200000, 416848908],
            [1158105600000, 416993301],
            [1158192000000, 417140749],
            [1158278400000, 417479000],
            [1158364800000, 418077000],
            [1158451200000, 418423143],
            [1158537600000, 418509000],
            [1158624000000, 418600000],
            [1158710400000, 418691000],
            [1158796800000, 418786083],
            [1158883200000, 419006000],
            [1158969600000, 419430000],
            [1159056000000, 419654338],
            [1159142400000, 419707000],
            [1159228800000, 419761000],
            [1159315200000, 419814000],
            [1159401600000, 419866407]
        ],
        name: 'piratesofthecaribbean2',
        showInLegend: false,
        extra: {
            title: 'Pirates of the Caribbean: Dead Man´s Chest',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#463D20'
        },
        showlabel: false,
        color: 'rgba(70,61,32,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1276819200000, 41148961
            ],
            [1276905600000, 78240091],
            [1276992000000, 110307189],
            [1277078400000, 125913275],
            [1277164800000, 141036487],
            [1277251200000, 154495178],
            [1277337600000, 167551682],
            [1277424000000, 185502325],
            [1277510400000, 208092816],
            [1277596800000, 226889351],
            [1277683200000, 235811275],
            [1277769600000, 244029214],
            [1277856000000, 251344663],
            [1277942400000, 258826169],
            [1278028800000, 269363263],
            [1278115200000, 280796714],
            [1278201600000, 289106193],
            [1278288000000, 301883298],
            [1278374400000, 307822780],
            [1278460800000, 313077846],
            [1278547200000, 318224899],
            [1278633600000, 324706852],
            [1278720000000, 333652199],
            [1278806400000, 339240857],
            [1278892800000, 342040500],
            [1278979200000, 345465001],
            [1279065600000, 348453463],
            [1279152000000, 350967102],
            [1279238400000, 354467692],
            [1279324800000, 359226345],
            [1279411200000, 362965378],
            [1279497600000, 364856662],
            [1279584000000, 366920787],
            [1279670400000, 368682193],
            [1279756800000, 370499039],
            [1279843200000, 373124538],
            [1279929600000, 376699175],
            [1280016000000, 379416551],
            [1280102400000, 380588257],
            [1280188800000, 381967103],
            [1280275200000, 383281846],
            [1280361600000, 384638584],
            [1280448000000, 386090760],
            [1280534400000, 388095185],
            [1280620800000, 389761491],
            [1280707200000, 390606539],
            [1280793600000, 391571177],
            [1280880000000, 392435416],
            [1280966400000, 393268254],
            [1281052800000, 394146086],
            [1281139200000, 395357723],
            [1281225600000, 396387342],
            [1281312000000, 396924616],
            [1281398400000, 397518546],
            [1281484800000, 398033383],
            [1281571200000, 398602095],
            [1281657600000, 399220705],
            [1281744000000, 400063178],
            [1281830400000, 400824826],
            [1281916800000, 401215022],
            [1282003200000, 401584353],
            [1282089600000, 401948454],
            [1282176000000, 402280518],
            [1282262400000, 402649243],
            [1282348800000, 403234809],
            [1282435200000, 403803642],
            [1282521600000, 404033760],
            [1282608000000, 404276620],
            [1282694400000, 404488263],
            [1282780800000, 404648511],
            [1282867200000, 404915312],
            [1282953600000, 405342435],
            [1283040000000, 405659221],
            [1283126400000, 405781941],
            [1283212800000, 405931112],
            [1283299200000, 406040342],
            [1283385600000, 406155373],
            [1283472000000, 406575067],
            [1283558400000, 407339295],
            [1283644800000, 408100174],
            [1283731200000, 408890408],
            [1283817600000, 409000331],
            [1283904000000, 409091091],
            [1283990400000, 409214041],
            [1284076800000, 409366512],
            [1284163200000, 409708660],
            [1284249600000, 409976037],
            [1284336000000, 410019427],
            [1284422400000, 410070154],
            [1284508800000, 410115979],
            [1284595200000, 410171027]
        ],
        name: 'toystory3',
        showInLegend: false,
        extra: {
            title: 'Toy Story 3',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#A48555'
        },
        showlabel: false,
        color: 'rgba(164,133,85,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1367539200000, 68858555
            ],
            [1367625600000, 131131773],
            [1367712000000, 174144585],
            [1367798400000, 185412195],
            [1367884800000, 196699091],
            [1367971200000, 204811482],
            [1368057600000, 212421084],
            [1368144000000, 232134916],
            [1368230400000, 264188043],
            [1368316800000, 284946699],
            [1368403200000, 289562441],
            [1368489600000, 294723579],
            [1368576000000, 298595076],
            [1368662400000, 301891883],
            [1368748800000, 311405998],
            [1368835200000, 326831976],
            [1368921600000, 337661977],
            [1369008000000, 340868034],
            [1369094400000, 343620220],
            [1369180800000, 345876981],
            [1369267200000, 348082524],
            [1369353600000, 353228940],
            [1369440000000, 360762094],
            [1369526400000, 367407116],
            [1369612800000, 372775931],
            [1369699200000, 374335928],
            [1369785600000, 375582715],
            [1369872000000, 376745285],
            [1369958400000, 378998131],
            [1370044800000, 382638451],
            [1370131200000, 385187736],
            [1370217600000, 385942966],
            [1370304000000, 386823292],
            [1370390400000, 387631585],
            [1370476800000, 388529665],
            [1370563200000, 390224698],
            [1370649600000, 392707303],
            [1370736000000, 394283326],
            [1370822400000, 394952363],
            [1370908800000, 395606691],
            [1370995200000, 396159803],
            [1371081600000, 396702239],
            [1371168000000, 397451305],
            [1371254400000, 398505292],
            [1371340800000, 399659094],
            [1371427200000, 399985196],
            [1371513600000, 400353801],
            [1371600000000, 400669434],
            [1371686400000, 400945222],
            [1371772800000, 401716045],
            [1371859200000, 402643042],
            [1371945600000, 403157804],
            [1372032000000, 403366227],
            [1372118400000, 403603089],
            [1372204800000, 403823046],
            [1372291200000, 404032056],
            [1372377600000, 404448236],
            [1372464000000, 405046013],
            [1372550400000, 405393205],
            [1372636800000, 405557106],
            [1372723200000, 405686271],
            [1372809600000, 405806520],
            [1372896000000, 405929319],
            [1372982400000, 406108823],
            [1373068800000, 406307654],
            [1373155200000, 406410987],
            [1373241600000, 406455862],
            [1373328000000, 406512887],
            [1373414400000, 406563649],
            [1373500800000, 406609688]
        ],
        name: 'ironman3',
        showInLegend: false,
        extra: {
            title: 'Iron Man 3',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#625140'
        },
        showlabel: false,
        color: 'rgba(98,81,64,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1332460800000, 67263650
            ],
            [1332547200000, 117658069],
            [1332633600000, 152535747],
            [1332720000000, 163359535],
            [1332806400000, 173707733],
            [1332892800000, 181759438],
            [1332979200000, 189932838],
            [1333065600000, 208585398],
            [1333152000000, 233324271],
            [1333238400000, 248483901],
            [1333324800000, 253006396],
            [1333411200000, 258330642],
            [1333497600000, 262939407],
            [1333584000000, 269339165],
            [1333670400000, 282138997],
            [1333756800000, 295156390],
            [1333843200000, 302450722],
            [1333929600000, 306593939],
            [1334016000000, 309887222],
            [1334102400000, 312737907],
            [1334188800000, 315569539],
            [1334275200000, 321973064],
            [1334361600000, 331290322],
            [1334448000000, 336666363],
            [1334534400000, 338063318],
            [1334620800000, 339629253],
            [1334707200000, 340961282],
            [1334793600000, 342400460],
            [1334880000000, 346414692],
            [1334966400000, 352914760],
            [1335052800000, 357066467],
            [1335139200000, 358075670],
            [1335225600000, 359219019],
            [1335312000000, 360163155],
            [1335398400000, 361204750],
            [1335484800000, 364197718],
            [1335571200000, 369164992],
            [1335657600000, 372019021],
            [1335744000000, 372740943],
            [1335830400000, 373605139],
            [1335916800000, 374317455],
            [1336003200000, 375026998],
            [1336089600000, 376657044],
            [1336176000000, 379083921],
            [1336262400000, 380614659],
            [1336348800000, 381039319],
            [1336435200000, 381574650],
            [1336521600000, 382035994],
            [1336608000000, 382501686],
            [1336694400000, 383689388],
            [1336780800000, 385545433],
            [1336867200000, 387007048],
            [1336953600000, 387405528],
            [1337040000000, 387870286],
            [1337126400000, 388246795],
            [1337212800000, 388631110],
            [1337299200000, 389455507],
            [1337385600000, 390726156],
            [1337472000000, 391581441],
            [1337558400000, 391934445],
            [1337644800000, 392280533],
            [1337731200000, 392609490],
            [1337817600000, 393008785],
            [1337904000000, 393609026],
            [1337990400000, 394490717],
            [1338076800000, 395320191],
            [1338163200000, 396022168],
            [1338249600000, 396271161],
            [1338336000000, 396506225],
            [1338422400000, 396773748],
            [1338508800000, 397228630],
            [1338595200000, 397906035],
            [1338681600000, 398340934],
            [1338768000000, 398549683],
            [1338854400000, 398768979],
            [1338940800000, 398974636],
            [1339027200000, 399200322],
            [1339113600000, 399519261],
            [1339200000000, 399950274],
            [1339286400000, 400272535],
            [1339372800000, 400429538],
            [1339459200000, 400601121],
            [1339545600000, 400758010],
            [1339632000000, 400913620],
            [1339718400000, 401161515],
            [1339804800000, 401499517],
            [1339891200000, 401766452],
            [1339977600000, 401903713],
            [1340064000000, 402050626],
            [1340150400000, 402193216],
            [1340236800000, 402339722],
            [1340323200000, 402524171],
            [1340409600000, 402779785],
            [1340496000000, 402964540],
            [1340582400000, 403061698],
            [1340668800000, 403168935],
            [1340755200000, 403266710],
            [1340841600000, 403371707],
            [1340928000000, 403485693],
            [1341014400000, 403643849],
            [1341100800000, 403768852],
            [1341187200000, 403844068],
            [1341273600000, 403913666],
            [1341360000000, 403995077],
            [1341446400000, 404066654],
            [1341532800000, 404164823],
            [1341619200000, 404293883],
            [1341705600000, 404382133],
            [1341792000000, 404428919],
            [1341878400000, 404481406],
            [1341964800000, 404532847],
            [1342051200000, 404584896],
            [1342137600000, 404666211],
            [1342224000000, 404782363],
            [1342310400000, 404864651],
            [1342396800000, 404906784],
            [1342483200000, 404954713],
            [1342569600000, 405000343],
            [1342656000000, 405045474],
            [1342742400000, 405101170],
            [1342828800000, 405173614],
            [1342915200000, 405227711],
            [1343001600000, 405259261],
            [1343088000000, 405295437],
            [1343174400000, 405328665],
            [1343260800000, 405363383],
            [1343347200000, 405515861],
            [1343433600000, 405719580],
            [1343520000000, 405882323],
            [1343606400000, 405974995],
            [1343692800000, 406079037],
            [1343779200000, 406172855],
            [1343865600000, 406267858],
            [1343952000000, 406397105],
            [1344038400000, 406569712],
            [1344124800000, 406697224],
            [1344211200000, 406763450],
            [1344297600000, 406833028],
            [1344384000000, 406900777],
            [1344470400000, 406970235],
            [1344556800000, 407069837],
            [1344643200000, 407202884],
            [1344729600000, 407294292],
            [1344816000000, 407340907],
            [1344902400000, 407392200],
            [1344988800000, 407436802],
            [1345075200000, 407483257],
            [1345161600000, 407549767],
            [1345248000000, 407633798],
            [1345334400000, 407688212],
            [1345420800000, 407708885],
            [1345507200000, 407730517],
            [1345593600000, 407749784],
            [1345680000000, 407769160],
            [1345766400000, 407802083],
            [1345852800000, 407852636],
            [1345939200000, 407884011],
            [1346025600000, 407894024],
            [1346112000000, 407904454],
            [1346198400000, 407913651],
            [1346284800000, 407923309],
            [1346371200000, 407936467],
            [1346457600000, 407961444],
            [1346544000000, 407981652],
            [1346630400000, 407999255],
            [1346716800000, 408003494],
            [1346803200000, 408006922],
            [1346889600000, 408010692]
        ],
        name: 'hungergames',
        showInLegend: false,
        extra: {
            title: 'The Hunger Games',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#441F0F'
        },
        showlabel: false,
        color: 'rgba(68,31,15,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1020384000000, 39406872
            ],
            [1020470400000, 83029136],
            [1020556800000, 114844116],
            [1020643200000, 125878901],
            [1020729600000, 135840755],
            [1020816000000, 144156124],
            [1020902400000, 151622504],
            [1020988800000, 171529078],
            [1021075200000, 202035007],
            [1021161600000, 223040031],
            [1021248000000, 228251280],
            [1021334400000, 232788846],
            [1021420800000, 237021890],
            [1021507200000, 240536756],
            [1021593600000, 252374308],
            [1021680000000, 272386994],
            [1021766400000, 285573668],
            [1021852800000, 289882492],
            [1021939200000, 292666312],
            [1022025600000, 295142188],
            [1022112000000, 297826648],
            [1022198400000, 305073768],
            [1022284800000, 316381817],
            [1022371200000, 326334752],
            [1022457600000, 333641492],
            [1022544000000, 335649825],
            [1022630400000, 337501557],
            [1022716800000, 339506133],
            [1022803200000, 343221702],
            [1022889600000, 349648306],
            [1022976000000, 353823544],
            [1023062400000, 355330685],
            [1023148800000, 356983440],
            [1023235200000, 358505354],
            [1023321600000, 360117121],
            [1023408000000, 363091775],
            [1023494400000, 367311497],
            [1023580800000, 370428183],
            [1023667200000, 371506188],
            [1023753600000, 372704115],
            [1023840000000, 373830231],
            [1023926400000, 375021685],
            [1024012800000, 377146371],
            [1024099200000, 380157865],
            [1024185600000, 382537669],
            [1024272000000, 383361967],
            [1024358400000, 384238471],
            [1024444800000, 385034435],
            [1024531200000, 385826381],
            [1024617600000, 387132852],
            [1024704000000, 389010631],
            [1024790400000, 390382313],
            [1024876800000, 390935574],
            [1024963200000, 391538987],
            [1025049600000, 392135480],
            [1025136000000, 392744257],
            [1025222400000, 393647230],
            [1025308800000, 394899346],
            [1025395200000, 395874471],
            [1025481600000, 396370509],
            [1025568000000, 396874331],
            [1025654400000, 397362779],
            [1025740800000, 397853721],
            [1025827200000, 398632689],
            [1025913600000, 399485653],
            [1026000000000, 400058357],
            [1026086400000, 400304057],
            [1026172800000, 400580598],
            [1026259200000, 400839604],
            [1026345600000, 401101446],
            [1028246400000, 403340827],
            [1028332800000, 403436531],
            [1028419200000, 403505336],
            [1028851200000, 403560381],
            [1028937600000, 403597076],
            [1029024000000, 403620726],
            [1029456000000, 403664515],
            [1029542400000, 403689347],
            [1029628800000, 403706375]
        ],
        name: 'spiderman',
        showInLegend: false,
        extra: {
            title: 'Spider-Man',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#A66B38'
        },
        showlabel: false,
        color: 'rgba(166,107,56,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                739670400000, 3132632
            ],
            [739756800000, 18246360],
            [739843200000, 35855660],
            [739929600000, 50159460],
            [740016000000, 58777800],
            [740102400000, 67071600],
            [740188800000, 74139360],
            [740275200000, 81717485],
            [740361600000, 92586505],
            [740448000000, 108110195],
            [740534400000, 120173345],
            [740620800000, 126643580],
            [740707200000, 132614230],
            [740793600000, 138060925],
            [740880000000, 143407945],
            [740966400000, 151595345],
            [741052800000, 162544465],
            [741139200000, 171098465],
            [741225600000, 175129415],
            [741312000000, 179237015],
            [741398400000, 182988575],
            [741484800000, 186763115],
            [741571200000, 193053035],
            [741657600000, 200902960],
            [741744000000, 205732720],
            [741830400000, 212060080],
            [741916800000, 215331150],
            [742003200000, 218267475],
            [742089600000, 221116335],
            [742176000000, 225566610],
            [742262400000, 231838035],
            [742348800000, 236429385],
            [742435200000, 238571995],
            [742521600000, 240803545],
            [742608000000, 242906870],
            [742694400000, 244856270],
            [742780800000, 247963025],
            [742867200000, 252527270],
            [742953600000, 255723520],
            [743040000000, 257475065],
            [743126400000, 259392815],
            [743212800000, 260990940],
            [743299200000, 262537925],
            [743385600000, 264925205],
            [743472000000, 268429685],
            [743558400000, 270958085],
            [743644800000, 272198815],
            [743731200000, 273793415],
            [743817600000, 274956420],
            [743904000000, 276210840],
            [743990400000, 278180560],
            [744076800000, 281049500],
            [744163200000, 283094155],
            [744249600000, 284099730],
            [744336000000, 285186380],
            [744422400000, 286113460],
            [744508800000, 287051075],
            [744595200000, 288556815],
            [744681600000, 290739185],
            [744768000000, 292168690],
            [744854400000, 292918740],
            [744940800000, 293827630],
            [745027200000, 294537850],
            [745113600000, 295267155],
            [745200000000, 296494675],
            [745286400000, 298259800],
            [745372800000, 299567960],
            [745459200000, 300228025],
            [745545600000, 301032940],
            [745632000000, 301691480],
            [745718400000, 302341355],
            [745804800000, 303440600],
            [745891200000, 305027480],
            [745977600000, 306101930],
            [746064000000, 306618680],
            [746150400000, 307269350],
            [746236800000, 307761695],
            [746323200000, 308222780],
            [746409600000, 309008695],
            [746496000000, 310301415],
            [746582400000, 311146090],
            [746668800000, 311450100],
            [746755200000, 311878320],
            [746841600000, 312187860],
            [746928000000, 312505110],
            [747014400000, 313250635],
            [747100800000, 314564160],
            [747187200000, 315700185],
            [747273600000, 316609010],
            [747360000000, 316867385],
            [747446400000, 317053165],
            [747532800000, 317240205],
            [747619200000, 317758230],
            [747705600000, 318761855],
            [747792000000, 319344605],
            [747878400000, 319478590],
            [747964800000, 319684120],
            [748051200000, 319840770],
            [748137600000, 320033890],
            [748224000000, 320566765],
            [748310400000, 321559020],
            [748396800000, 322104145],
            [748483200000, 322220245],
            [748569600000, 322393195],
            [748656000000, 322519915],
            [748742400000, 322652395],
            [748828800000, 323022580],
            [748915200000, 323768315],
            [749001600000, 324235070],
            [749088000000, 324337675],
            [749174400000, 324471315],
            [749260800000, 324568410],
            [749347200000, 324670815],
            [749433600000, 324921135],
            [749520000000, 325439655],
            [749606400000, 325734675],
            [749692800000, 325807010],
            [749779200000, 325908890],
            [749865600000, 325985405],
            [749952000000, 326074870],
            [750038400000, 326262925],
            [750124800000, 326662920],
            [750211200000, 326919630],
            [750297600000, 327031645],
            [750384000000, 327098245],
            [750470400000, 327150780],
            [750556800000, 327216900],
            [750643200000, 327374415],
            [750729600000, 327681925],
            [750816000000, 327871950],
            [750902400000, 327915065],
            [750988800000, 327972545],
            [751075200000, 328020655],
            [751161600000, 328074115],
            [751248000000, 328245385],
            [751334400000, 328525645],
            [751420800000, 328704700],
            [751507200000, 328749610],
            [751593600000, 328806765],
            [751680000000, 328851045],
            [751766400000, 328897880],
            [751852800000, 329036530],
            [751939200000, 329266845],
            [752025600000, 329398445],
            [752112000000, 329432270],
            [752198400000, 329479415],
            [752284800000, 329513005],
            [752371200000, 329551175],
            [752457600000, 329649330],
            [752544000000, 329836570],
            [752630400000, 329955860],
            [752716800000, 329982050],
            [752803200000, 330015170],
            [752889600000, 330051295],
            [752976000000, 330110950],
            [753062400000, 330192570],
            [753148800000, 330333555],
            [753235200000, 330422595],
            [753321600000, 330440505],
            [753408000000, 330464385],
            [753494400000, 330487385],
            [753580800000, 330515410],
            [753667200000, 330571215],
            [753753600000, 330684630],
            [753840000000, 330762050],
            [753926400000, 330780425],
            [754012800000, 330804790],
            [754099200000, 331097390],
            [754185600000, 331451590],
            [754272000000, 332136895],
            [754358400000, 332829910],
            [754444800000, 333307310],
            [754531200000, 333427475],
            [754617600000, 333543880],
            [754704000000, 333668290],
            [754790400000, 333773845],
            [754876800000, 334063185],
            [754963200000, 334536295],
            [755049600000, 334849095],
            [755136000000, 334918755],
            [755222400000, 334992285],
            [755308800000, 335065150],
            [755395200000, 335134635],
            [755481600000, 335333915],
            [755568000000, 335661035],
            [755654400000, 335879115],
            [755740800000, 335935140],
            [755827200000, 335990650],
            [755913600000, 336055090],
            [756000000000, 336123395],
            [756086400000, 336288770],
            [756172800000, 336575420],
            [756259200000, 336817970],
            [756345600000, 336927485],
            [756432000000, 337051585],
            [756518400000, 337178635],
            [756604800000, 337330885],
            [756691200000, 337431805],
            [756777600000, 337588405],
            [756864000000, 337832005],
            [756950400000, 338018320],
            [757036800000, 338243545],
            [757123200000, 338466820],
            [757209600000, 338700740],
            [757296000000, 338929640],
            [757382400000, 339272990],
            [757468800000, 339521510],
            [757555200000, 339608720],
            [757641600000, 339679345],
            [757728000000, 339742765],
            [757814400000, 339803580],
            [757900800000, 339944330],
            [757987200000, 340214570],
            [758073600000, 340414435],
            [758160000000, 340467460],
            [758246400000, 340528840],
            [758332800000, 340578795],
            [758419200000, 340634620],
            [758505600000, 340746420],
            [758592000000, 340967420],
            [758678400000, 341146820],
            [758764800000, 341235220],
            [758851200000, 341261220],
            [758937600000, 341295020],
            [759024000000, 341330300],
            [759110400000, 341447900],
            [759196800000, 341690300],
            [759283200000, 341831900],
            [759369600000, 341855900],
            [759456000000, 341882300],
            [759542400000, 341903900],
            [759628800000, 341927900],
            [759715200000, 342064105],
            [759801600000, 342297920],
            [759888000000, 342429585],
            [759974400000, 342461155],
            [760060800000, 342495130],
            [760147200000, 342526155],
            [760233600000, 342559380],
            [760320000000, 342688005],
            [760406400000, 342910370],
            [760492800000, 343071695],
            [760579200000, 343097555],
            [760665600000, 343119370],
            [760752000000, 343141155],
            [760838400000, 343167435],
            [760924800000, 343262610],
            [761011200000, 343433925],
            [761097600000, 343554480],
            [761184000000, 343585230],
            [761270400000, 343611945],
            [761356800000, 343636305],
            [761443200000, 343663475],
            [761529600000, 343721490],
            [761616000000, 343840350],
            [761702400000, 343942245],
            [761788800000, 344003090],
            [761875200000, 344021285],
            [761961600000, 344036410],
            [762048000000, 344054415],
            [762134400000, 344100665],
            [762220800000, 344204415],
            [762307200000, 344286930],
            [762393600000, 344304220],
            [762480000000, 344325385],
            [762566400000, 344344610],
            [762652800000, 344362685],
            [762739200000, 344408195],
            [762825600000, 344490335],
            [762912000000, 344553605],
            [762998400000, 344569280],
            [763084800000, 344583560],
            [763171200000, 344600555],
            [763257600000, 344619480],
            [763344000000, 344664835],
            [763430400000, 344745900],
            [763516800000, 344806695],
            [763603200000, 344825310],
            [763689600000, 344847535],
            [763776000000, 344868005],
            [763862400000, 344889365],
            [763948800000, 344928485],
            [764035200000, 344995315],
            [764121600000, 345042585],
            [764208000000, 345055400],
            [764294400000, 345083840],
            [764380800000, 345102800],
            [764467200000, 345129660],
            [764553600000, 345179710],
            [764640000000, 345254070],
            [764726400000, 345316275],
            [764812800000, 345330575],
            [764899200000, 345353455],
            [764985600000, 345373475],
            [765072000000, 345395395],
            [765158400000, 345457765],
            [765244800000, 345534715],
            [765331200000, 345595470],
            [765417600000, 345621310],
            [765504000000, 345641175],
            [765590400000, 345663955],
            [765676800000, 345688075],
            [765763200000, 345732600],
            [765849600000, 345802560],
            [765936000000, 345851850],
            [766022400000, 345861165],
            [766108800000, 345872955],
            [766195200000, 345883835],
            [766281600000, 345893450],
            [766368000000, 345924940],
            [766454400000, 345983900],
            [766540800000, 346028790],
            [766627200000, 346038015],
            [766713600000, 346051545],
            [766800000000, 346061355],
            [766886400000, 346072235],
            [766972800000, 346109090],
            [767059200000, 346169930],
            [767145600000, 346210295],
            [767232000000, 346220080],
            [767318400000, 346229855],
            [767404800000, 346240400],
            [767491200000, 346250210],
            [777859200000, 352611750],
            [777945600000, 352868840],
            [778032000000, 353079435],
            [778118400000, 353160460],
            [778204800000, 353249230],
            [778291200000, 353323615],
            [778377600000, 353391385],
            [778464000000, 353523685],
            [778550400000, 353731600],
            [778636800000, 353929000],
            [778723200000, 354092815],
            [778809600000, 354139160],
            [778896000000, 354173330],
            [778982400000, 354205490],
            [779068800000, 354331490],
            [779155200000, 354527240],
            [779241600000, 354666740],
            [779328000000, 354690680],
            [779414400000, 354718295],
            [779500800000, 354742445],
            [779587200000, 354773495],
            [779673600000, 354858220],
            [779760000000, 355017995],
            [779846400000, 355123870],
            [779932800000, 355143560],
            [780019200000, 355165040],
            [780105600000, 355186460],
            [780192000000, 355209600],
            [780278400000, 355314150],
            [780364800000, 355518150],
            [780451200000, 355658400],
            [780537600000, 355691550],
            [780624000000, 355723120],
            [780710400000, 355749825],
            [780796800000, 355780905],
            [780883200000, 355884135],
            [780969600000, 356055630],
            [781056000000, 356190495],
            [781142400000, 356209540],
            [781228800000, 356230050],
            [781315200000, 356246220],
            [781401600000, 356263920],
            [781488000000, 356348310],
            [781574400000, 356457920],
            [781660800000, 356547160],
            [781747200000, 356567170],
            [781833600000, 356574235],
            [781920000000, 356581210],
            [782006400000, 356588915],
            [782092800000, 356637635],
            [782179200000, 356697955],
            [782265600000, 356748415],
            [782352000000, 356751845],
            [782438400000, 356755765],
            [782524800000, 356759160],
            [782611200000, 356763175]
        ],
        name: 'jurassicpark',
        showInLegend: false,
        extra: {
            title: 'Jurassic Park',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#241A18'
        },
        showlabel: true,
        color: 'rgba(36,26,24,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1245801600000, 62016476
            ],
            [1245888000000, 91110948],
            [1245974400000, 127851614],
            [1246060800000, 168056697],
            [1246147200000, 200077255],
            [1246233600000, 214931195],
            [1246320000000, 228441219],
            [1246406400000, 239380350],
            [1246492800000, 251035008],
            [1246579200000, 269024709],
            [1246665600000, 279712800],
            [1246752000000, 293355885],
            [1246838400000, 299762339],
            [1246924800000, 305522774],
            [1247011200000, 310426573],
            [1247097600000, 315007925],
            [1247184000000, 322650766],
            [1247270400000, 332127039],
            [1247356800000, 339221800],
            [1247443200000, 342305825],
            [1247529600000, 345270996],
            [1247616000000, 347714387],
            [1247702400000, 350116636],
            [1247788800000, 354298620],
            [1247875200000, 359894705],
            [1247961600000, 363808123],
            [1248048000000, 365583739],
            [1248134400000, 367614540],
            [1248220800000, 369321117],
            [1248307200000, 371089745],
            [1248393600000, 373580232],
            [1248480000000, 376792804],
            [1248566400000, 379214172],
            [1248652800000, 380342669],
            [1248739200000, 381508108],
            [1248825600000, 382541324],
            [1248912000000, 383500991],
            [1248998400000, 384931276],
            [1249084800000, 386753883],
            [1249171200000, 388189320],
            [1249257600000, 388858383],
            [1249344000000, 389508496],
            [1249430400000, 390105115],
            [1249516800000, 390700514],
            [1249603200000, 391734894],
            [1249689600000, 392960053],
            [1249776000000, 393709339],
            [1249862400000, 394065706],
            [1249948800000, 394446105],
            [1250035200000, 394790193],
            [1250121600000, 395154082],
            [1250208000000, 395678591],
            [1250294400000, 396379240],
            [1250380800000, 396758605],
            [1250467200000, 396934917],
            [1250553600000, 397122551],
            [1250640000000, 397300205],
            [1250726400000, 397470858],
            [1250812800000, 397770940],
            [1250899200000, 398204786],
            [1250985600000, 398441218],
            [1251072000000, 398535767],
            [1251158400000, 398641824],
            [1251244800000, 398741872],
            [1251331200000, 398840509],
            [1251417600000, 399006536],
            [1251504000000, 399268628],
            [1251590400000, 399416040],
            [1251676800000, 399468859],
            [1251763200000, 399526521],
            [1251849600000, 399575659],
            [1251936000000, 399631191],
            [1252022400000, 399822464],
            [1252108800000, 400125775],
            [1252195200000, 400434854],
            [1252281600000, 400641549],
            [1252368000000, 400686031],
            [1252454400000, 400721101],
            [1252540800000, 400757235],
            [1252627200000, 400856895],
            [1252713600000, 401030403],
            [1252800000000, 401127275],
            [1252886400000, 401151847],
            [1252972800000, 401179139],
            [1253059200000, 401203839],
            [1253145600000, 401230822],
            [1253232000000, 401300666],
            [1253318400000, 401418331],
            [1253404800000, 401485117],
            [1253491200000, 401501881],
            [1253577600000, 401521240],
            [1253664000000, 401537347],
            [1253750400000, 401555453],
            [1253836800000, 401605687],
            [1253923200000, 401699386],
            [1254009600000, 401750700],
            [1254096000000, 401764455],
            [1254182400000, 401777722],
            [1254268800000, 401790274],
            [1254355200000, 401804683],
            [1254441600000, 401844869],
            [1254528000000, 401916397],
            [1254614400000, 401954762],
            [1254700800000, 401964397],
            [1254787200000, 401975882],
            [1254873600000, 401986424],
            [1254960000000, 401997617],
            [1255046400000, 402019792],
            [1255132800000, 402054350],
            [1255219200000, 402076689],
            [1255305600000, 402088378],
            [1255392000000, 402095833],
            [1255478400000, 402103640],
            [1255564800000, 402111870]
        ],
        name: 'transformers2',
        showInLegend: false,
        extra: {
            title: 'Transformers: Revenge of the Fallen',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#21252C'
        },
        showlabel: false,
        color: 'rgba(33,37,44,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1385078400000, 66498
            ],
            [1385164800000, 159196],
            [1385251200000, 243390],
            [1385337600000, 291115],
            [1385424000000, 342839],
            [1385510400000, 15504088],
            [1385596800000, 26541900],
            [1385683200000, 53382136],
            [1385769600000, 78725318],
            [1385856000000, 93933226],
            [1385942400000, 96437874],
            [1386028800000, 98938411],
            [1386115200000, 100770260],
            [1386201600000, 102637436],
            [1386288000000, 109361256],
            [1386374400000, 124424493],
            [1386460800000, 134253666],
            [1386547200000, 136304818],
            [1386633600000, 138768437],
            [1386720000000, 140488559],
            [1386806400000, 142204073],
            [1386892800000, 147301284],
            [1386979200000, 157446099],
            [1387065600000, 164772211],
            [1387152000000, 166370951],
            [1387238400000, 168403281],
            [1387324800000, 170193888],
            [1387411200000, 172392010],
            [1387497600000, 177496302],
            [1387584000000, 185201855],
            [1387670400000, 192034117],
            [1387756800000, 199276806],
            [1387843200000, 204058551],
            [1387929600000, 210412773],
            [1388016000000, 219521476],
            [1388102400000, 229689382],
            [1388188800000, 239695910],
            [1388275200000, 248117795],
            [1388361600000, 256016197],
            [1388448000000, 263092648],
            [1388534400000, 271811587],
            [1388620800000, 277116204],
            [1388707200000, 283868258],
            [1388793600000, 291905733],
            [1388880000000, 296691729],
            [1388966400000, 298420339],
            [1389052800000, 300321753],
            [1389139200000, 301501543],
            [1389225600000, 302590988],
            [1389312000000, 305707287],
            [1389398400000, 312843634],
            [1389484800000, 317319106],
            [1389571200000, 318080546],
            [1389657600000, 319056905],
            [1389744000000, 319808258],
            [1389830400000, 320631361],
            [1389916800000, 323146637],
            [1390003200000, 328428836],
            [1390089600000, 332403215],
            [1390176000000, 336699913],
            [1390262400000, 337450104],
            [1390348800000, 338125385],
            [1390435200000, 338780205],
            [1390521600000, 340822228],
            [1390608000000, 345045033],
            [1390694400000, 347899011],
            [1390780800000, 348556513],
            [1390867200000, 349458295],
            [1390953600000, 350053022],
            [1391040000000, 350702329],
            [1391126400000, 352947287],
            [1391212800000, 357516392],
            [1391299200000, 359635842],
            [1391385600000, 360122304],
            [1391472000000, 360652004],
            [1391558400000, 361228411],
            [1391644800000, 361764626],
            [1391731200000, 363153465],
            [1391817600000, 366480124],
            [1391904000000, 368637437],
            [1391990400000, 369080767],
            [1392076800000, 369484152],
            [1392163200000, 369792787],
            [1392249600000, 370191214],
            [1392336000000, 371898426],
            [1392422400000, 374318216],
            [1392508800000, 376417794],
            [1392595200000, 378248347],
            [1392681600000, 378795613],
            [1392768000000, 379250586],
            [1392854400000, 379704335],
            [1392940800000, 380727773],
            [1393027200000, 382758785],
            [1393113600000, 384108132],
            [1393200000000, 384335209],
            [1393286400000, 384605905],
            [1393372800000, 384852424],
            [1393459200000, 385125143],
            [1393545600000, 385843169],
            [1393632000000, 387632118],
            [1393718400000, 388756783],
            [1393804800000, 389095081],
            [1393891200000, 389482313],
            [1393977600000, 389748225],
            [1394064000000, 390040114],
            [1394150400000, 390673235],
            [1394236800000, 392063223],
            [1394323200000, 392994668],
            [1394409600000, 393272301],
            [1394496000000, 393614508],
            [1394582400000, 393925776],
            [1394668800000, 394238850],
            [1394755200000, 394761394],
            [1394841600000, 395698639],
            [1394928000000, 396386593],
            [1395014400000, 396581728],
            [1395100800000, 396755786],
            [1395187200000, 396895073],
            [1395273600000, 397009261],
            [1395360000000, 397175551],
            [1395446400000, 397508050],
            [1395532800000, 397744862],
            [1395619200000, 397815938],
            [1395705600000, 397904633],
            [1395792000000, 397979972],
            [1395878400000, 398053875],
            [1395964800000, 398132914],
            [1396051200000, 398289355],
            [1396137600000, 398391611],
            [1396224000000, 398426656],
            [1396310400000, 398465119],
            [1396396800000, 398500962],
            [1396483200000, 398539013],
            [1396569600000, 398651486],
            [1396656000000, 398846049],
            [1396742400000, 398938890],
            [1396828800000, 398965500],
            [1396915200000, 399001514],
            [1397001600000, 399030622],
            [1397088000000, 399060242],
            [1397174400000, 399157272],
            [1397260800000, 399343658],
            [1397347200000, 399445248],
            [1397433600000, 399481693],
            [1397520000000, 399529935],
            [1397606400000, 399571604],
            [1397692800000, 399619073],
            [1397779200000, 399715393],
            [1397865600000, 399824159],
            [1397952000000, 399877967],
            [1398038400000, 399907380],
            [1398124800000, 399935327],
            [1398211200000, 399960215],
            [1398297600000, 399985439],
            [1398384000000, 400028181],
            [1398470400000, 400113811],
            [1398556800000, 400175401],
            [1398643200000, 400187565],
            [1398729600000, 400201943],
            [1398816000000, 400214993],
            [1398902400000, 400227936]
        ],
        name: 'frozen2013',
        showInLegend: false,
        extra: {
            title: 'Frozen',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#A6CAE2'
        },
        showlabel: false,
        color: 'rgba(166,202,226,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1310688000000, 91071119
            ],
            [1310774400000, 133485465],
            [1310860800000, 169189427],
            [1310947200000, 187232508],
            [1311033600000, 202620674],
            [1311120000000, 214887891],
            [1311206400000, 226117069],
            [1311292800000, 240671184],
            [1311379200000, 258934716],
            [1311465600000, 273539281],
            [1311552000000, 280016609],
            [1311638400000, 286495885],
            [1311724800000, 291662354],
            [1311811200000, 296534509],
            [1311897600000, 303092462],
            [1311984000000, 311549473],
            [1312070400000, 318511602],
            [1312156800000, 321839842],
            [1312243200000, 325139206],
            [1312329600000, 328025686],
            [1312416000000, 330641014],
            [1312502400000, 334015125],
            [1312588800000, 338850124],
            [1312675200000, 343086045],
            [1312761600000, 344890382],
            [1312848000000, 346901620],
            [1312934400000, 348563937],
            [1313020800000, 350085941],
            [1313107200000, 351946172],
            [1313193600000, 354708050],
            [1313280000000, 357337355],
            [1313366400000, 358495410],
            [1313452800000, 359637778],
            [1313539200000, 360565265],
            [1313625600000, 361496489],
            [1313712000000, 362682829],
            [1313798400000, 364460313],
            [1313884800000, 366007900],
            [1313971200000, 366602118],
            [1314057600000, 367203359],
            [1314144000000, 367711640],
            [1314230400000, 368240692],
            [1314316800000, 368929574],
            [1314403200000, 369959013],
            [1314489600000, 370805062],
            [1314576000000, 371163237],
            [1314662400000, 371535432],
            [1314748800000, 371844889],
            [1314835200000, 372150983],
            [1314921600000, 372710770],
            [1315008000000, 373615016],
            [1315094400000, 374623584],
            [1315180800000, 375552093],
            [1315267200000, 375755398],
            [1315353600000, 375934867],
            [1315440000000, 376103101],
            [1315526400000, 376367393],
            [1315612800000, 376817200],
            [1315699200000, 377104684],
            [1315785600000, 377190929],
            [1315872000000, 377290111],
            [1315958400000, 377382350],
            [1316044800000, 377480123],
            [1316131200000, 377660516],
            [1316217600000, 377974744],
            [1316304000000, 378180621],
            [1316390400000, 378240326],
            [1316476800000, 378305007],
            [1316563200000, 378366054],
            [1316649600000, 378436868],
            [1316736000000, 378533676],
            [1316822400000, 378709043],
            [1316908800000, 378824316],
            [1316995200000, 378858898],
            [1317081600000, 378894909],
            [1317168000000, 378930760],
            [1317254400000, 378972347],
            [1317340800000, 379041779],
            [1317427200000, 379167184],
            [1317513600000, 379245610],
            [1317600000000, 379268754],
            [1317686400000, 379293585],
            [1317772800000, 379317920],
            [1317859200000, 379344886],
            [1317945600000, 379457055],
            [1318032000000, 379626528],
            [1318118400000, 379750747],
            [1318204800000, 379816310],
            [1318291200000, 379862860],
            [1318377600000, 379903359],
            [1318464000000, 379950852],
            [1318550400000, 380032613],
            [1318636800000, 380155410],
            [1318723200000, 380235400],
            [1318809600000, 380260197],
            [1318896000000, 380288858],
            [1318982400000, 380316659],
            [1319068800000, 380350637],
            [1319155200000, 380405841],
            [1319241600000, 380484066],
            [1319328000000, 380531427],
            [1319414400000, 380546404],
            [1319500800000, 380562478],
            [1319587200000, 380578231],
            [1319673600000, 380596554],
            [1319760000000, 380626896],
            [1319846400000, 380676149],
            [1319932800000, 380707704],
            [1320019200000, 380717822],
            [1320105600000, 380728650],
            [1320192000000, 380739670],
            [1320278400000, 380753265],
            [1320364800000, 380775329],
            [1320451200000, 380839203],
            [1320537600000, 380873020],
            [1320624000000, 380879042],
            [1320710400000, 380885728],
            [1320796800000, 380892146],
            [1320883200000, 380901821],
            [1320969600000, 380919404],
            [1321056000000, 380939741],
            [1321142400000, 380955619],
            [1321228800000, 380960907],
            [1321315200000, 380966300],
            [1321401600000, 380971855],
            [1321488000000, 380974762],
            [1321574400000, 380982415],
            [1321660800000, 380992752],
            [1321747200000, 381000185],
            [1321833600000, 381003478],
            [1321920000000, 381007522],
            [1322006400000, 381009525],
            [1322092800000, 381011219]
        ],
        name: 'harrypotter72',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Deathly Hallows Part 2',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#4D5552'
        },
        showlabel: false,
        color: 'rgba(77,85,82,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1054252800000, 20208056
            ],
            [1054339200000, 48219603],
            [1054425600000, 70251710],
            [1054512000000, 77197270],
            [1054598400000, 84379257],
            [1054684800000, 91103959],
            [1054771200000, 97454140],
            [1054857600000, 109758282],
            [1054944000000, 129262533],
            [1055030400000, 144043789],
            [1055116800000, 148546480],
            [1055203200000, 153211818],
            [1055289600000, 158049373],
            [1055376000000, 163102728],
            [1055462400000, 171643083],
            [1055548800000, 182961377],
            [1055635200000, 191487211],
            [1055721600000, 195066147],
            [1055808000000, 199033691],
            [1055894400000, 203263253],
            [1055980800000, 207410464],
            [1056067200000, 213703783],
            [1056153600000, 221950891],
            [1056240000000, 228549216],
            [1056326400000, 231282056],
            [1056412800000, 234108411],
            [1056499200000, 236938822],
            [1056585600000, 240023561],
            [1056672000000, 244227800],
            [1056758400000, 249705947],
            [1056844800000, 253991677],
            [1056931200000, 256514037],
            [1057017600000, 258988352],
            [1057104000000, 261201998],
            [1057190400000, 263877833],
            [1057276800000, 266782245],
            [1057363200000, 271401136],
            [1057449600000, 274936974],
            [1057536000000, 276792872],
            [1057622400000, 278832411],
            [1057708800000, 280730487],
            [1057795200000, 282603345],
            [1057881600000, 285402467],
            [1057968000000, 288674600],
            [1058054400000, 291068455],
            [1058140800000, 292374253],
            [1058227200000, 293778463],
            [1058313600000, 295232316],
            [1058400000000, 296519997],
            [1058486400000, 299218800],
            [1058572800000, 301815991],
            [1058659200000, 303795720],
            [1058745600000, 304986395],
            [1058832000000, 306282514],
            [1058918400000, 307566224],
            [1059004800000, 308728248],
            [1059091200000, 310000777],
            [1059177600000, 311741088],
            [1059264000000, 313119898],
            [1059350400000, 313820324],
            [1059436800000, 314583575],
            [1059523200000, 315343659],
            [1059609600000, 316160298],
            [1059696000000, 317278150],
            [1059782400000, 318798686],
            [1059868800000, 320020760],
            [1059955200000, 320703507],
            [1060041600000, 321384619],
            [1060128000000, 321911122],
            [1060214400000, 322403838],
            [1060300800000, 323102522],
            [1060387200000, 324117817],
            [1060473600000, 324916113],
            [1060560000000, 325313584],
            [1060646400000, 325741532],
            [1060732800000, 326117174],
            [1060819200000, 326434293],
            [1060905600000, 326755012],
            [1060992000000, 327334183],
            [1061078400000, 327793194],
            [1061164800000, 328020456],
            [1061251200000, 328272500],
            [1061337600000, 328517513],
            [1061424000000, 328751122],
            [1061510400000, 329027535],
            [1061596800000, 329458067],
            [1061683200000, 329790041],
            [1061769600000, 329939269],
            [1061856000000, 330107234],
            [1061942400000, 330247731],
            [1062028800000, 330385344],
            [1062115200000, 330696638],
            [1062201600000, 331295039],
            [1062288000000, 331921877],
            [1062374400000, 332722962],
            [1062460800000, 332854283],
            [1062547200000, 332955066],
            [1062633600000, 333039240],
            [1062720000000, 333190517],
            [1062806400000, 333561399],
            [1062892800000, 333843390],
            [1062979200000, 333895613],
            [1063065600000, 333952209],
            [1063152000000, 334007377],
            [1063238400000, 334065792],
            [1063324800000, 334163792],
            [1063411200000, 334461000],
            [1063497600000, 334702727],
            [1063584000000, 334735727],
            [1063670400000, 334771727],
            [1063756800000, 334804727],
            [1063843200000, 334838586],
            [1063929600000, 334915586],
            [1064016000000, 335102586],
            [1064102400000, 335258448],
            [1064188800000, 335299448]
        ],
        name: 'findingnemo',
        showInLegend: false,
        extra: {
            title: 'Finding Nemo',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#3D6382'
        },
        showlabel: false,
        color: 'rgba(61,99,130,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1116460800000, 50013859
            ],
            [1116547200000, 83543472],
            [1116633600000, 124237232],
            [1116720000000, 158449700],
            [1116806400000, 172802507],
            [1116892800000, 182710218],
            [1116979200000, 191363169],
            [1117065600000, 200442739],
            [1117152000000, 216022081],
            [1117238400000, 236940421],
            [1117324800000, 255648711],
            [1117411200000, 270489794],
            [1117497600000, 274896433],
            [1117584000000, 278901370],
            [1117670400000, 282804625],
            [1117756800000, 289880802],
            [1117843200000, 300336979],
            [1117929600000, 307892961],
            [1118016000000, 310314752],
            [1118102400000, 312659891],
            [1118188800000, 314971587],
            [1118275200000, 317257697],
            [1118361600000, 321263036],
            [1118448000000, 327531977],
            [1118534400000, 332109171],
            [1118620800000, 333797980],
            [1118707200000, 335384779],
            [1118793600000, 336736523],
            [1118880000000, 338102187],
            [1118966400000, 340685003],
            [1119052800000, 344628653],
            [1119139200000, 348140685],
            [1119225600000, 349270153],
            [1119312000000, 350346885],
            [1119398400000, 351390871],
            [1119484800000, 352356148],
            [1119571200000, 354058518],
            [1119657600000, 356548035],
            [1119744000000, 358469219],
            [1119830400000, 359298932],
            [1119916800000, 360143707],
            [1120003200000, 360797421],
            [1120089600000, 361471114],
            [1120176000000, 362667481],
            [1120262400000, 364172243],
            [1120348800000, 365553264],
            [1120435200000, 366502577],
            [1120521600000, 367113992],
            [1120608000000, 367688930],
            [1120694400000, 368219089],
            [1120780800000, 368984475],
            [1120867200000, 370076860],
            [1120953600000, 370819889],
            [1121040000000, 371154119],
            [1121126400000, 371504532],
            [1121212800000, 371863119],
            [1121299200000, 372222826],
            [1121385600000, 372677022],
            [1121472000000, 373390631],
            [1121558400000, 373926219],
            [1121644800000, 374151313],
            [1121731200000, 374377483],
            [1121817600000, 374599161],
            [1121904000000, 374829666],
            [1121990400000, 375119603],
            [1122076800000, 375550971],
            [1122163200000, 375876648],
            [1122249600000, 376032137],
            [1122336000000, 376197747],
            [1122422400000, 376352006],
            [1122508800000, 376507594],
            [1122595200000, 376661259],
            [1122681600000, 376899507],
            [1122768000000, 377080716],
            [1122854400000, 377176573],
            [1122940800000, 377262649],
            [1123027200000, 377347814],
            [1123113600000, 377441286],
            [1123200000000, 377560981],
            [1123286400000, 377735878],
            [1123372800000, 377864535],
            [1123459200000, 377926556],
            [1123545600000, 377993465],
            [1123632000000, 378063671],
            [1123718400000, 378130477],
            [1123804800000, 378220373],
            [1123891200000, 378357723],
            [1123977600000, 378461703],
            [1124064000000, 378508466],
            [1124150400000, 378556517],
            [1124236800000, 378602706],
            [1124323200000, 378650106],
            [1124409600000, 378740701],
            [1124496000000, 378881377],
            [1124582400000, 378977117],
            [1124668800000, 379017346],
            [1124755200000, 379065283],
            [1124841600000, 379106087],
            [1124928000000, 379144487],
            [1125014400000, 379210709],
            [1125100800000, 379319012],
            [1125187200000, 379392611],
            [1125273600000, 379419488],
            [1125360000000, 379448769],
            [1125446400000, 379474503],
            [1125532800000, 379498649],
            [1125619200000, 379555718],
            [1125705600000, 379649437],
            [1125792000000, 379743566],
            [1125878400000, 379807894],
            [1125964800000, 379823309],
            [1126051200000, 379838145],
            [1126137600000, 379853511],
            [1126224000000, 379885313],
            [1126310400000, 379940828],
            [1126396800000, 379972309],
            [1126483200000, 379980949],
            [1126569600000, 379992015],
            [1126656000000, 380003128],
            [1126742400000, 380013303],
            [1126828800000, 380036596],
            [1126915200000, 380079588],
            [1127001600000, 380101660],
            [1127088000000, 380108153],
            [1127174400000, 380115652],
            [1127260800000, 380123204],
            [1127347200000, 380130992],
            [1127433600000, 380143538],
            [1127520000000, 380164523],
            [1127606400000, 380176196],
            [1127692800000, 380179223],
            [1127779200000, 380182435],
            [1127865600000, 380185014],
            [1127952000000, 380188242],
            [1128038400000, 380194417],
            [1128124800000, 380204694],
            [1128211200000, 380209351],
            [1128297600000, 380211065],
            [1128384000000, 380213453],
            [1128470400000, 380215435],
            [1128556800000, 380217829],
            [1128643200000, 380223080],
            [1128729600000, 380231897],
            [1128816000000, 380237988],
            [1128902400000, 380243785],
            [1128988800000, 380245797],
            [1129075200000, 380247539],
            [1129161600000, 380249594],
            [1129248000000, 380253435],
            [1129334400000, 380259129],
            [1129420800000, 380262555],
            [1129507200000, 380264481],
            [1129593600000, 380266617],
            [1129680000000, 380268303],
            [1129766400000, 380270577]
        ],
        name: 'starwars3',
        showInLegend: false,
        extra: {
            title: 'Star Wars: Episode III - Revenge of the Sith',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#402F2B'
        },
        showlabel: false,
        color: 'rgba(64,47,43,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1071619200000, 34450834
            ],
            [1071705600000, 51470821],
            [1071792000000, 73282370],
            [1071878400000, 100774423],
            [1071964800000, 124100534],
            [1072051200000, 137663742],
            [1072137600000, 150139984],
            [1072224000000, 157684384],
            [1072310400000, 171670604],
            [1072396800000, 190822800],
            [1072483200000, 208072067],
            [1072569600000, 222268708],
            [1072656000000, 232321296],
            [1072742400000, 241936536],
            [1072828800000, 249445927],
            [1072915200000, 262230583],
            [1073001600000, 272832713],
            [1073088000000, 283395934],
            [1073174400000, 290410961],
            [1073260800000, 292639432],
            [1073347200000, 294654872],
            [1073433600000, 296459931],
            [1073520000000, 298111838],
            [1073606400000, 301788798],
            [1073692800000, 308228208],
            [1073779200000, 312320936],
            [1073865600000, 313419033],
            [1073952000000, 314567189],
            [1074038400000, 315556593],
            [1074124800000, 316592632],
            [1074211200000, 318968891],
            [1074297600000, 323583085],
            [1074384000000, 326812102],
            [1074470400000, 329040393],
            [1074556800000, 329779717],
            [1074643200000, 330390338],
            [1074729600000, 331032242],
            [1074816000000, 332541888],
            [1074902400000, 335700055],
            [1074988800000, 337817998],
            [1075075200000, 338345008],
            [1075161600000, 338891856],
            [1075248000000, 339468746],
            [1075334400000, 340021012],
            [1075420800000, 341392421],
            [1075507200000, 344131995],
            [1075593600000, 345331815],
            [1075680000000, 345719530],
            [1075766400000, 346118913],
            [1075852800000, 346487251],
            [1075939200000, 346839672],
            [1076025600000, 347747482],
            [1076112000000, 349762348],
            [1076198400000, 351133343],
            [1076284800000, 351428929],
            [1076371200000, 351711227],
            [1076457600000, 351974399],
            [1076544000000, 352277575],
            [1076630400000, 353077188],
            [1076716800000, 355035095],
            [1076803200000, 356464770],
            [1076889600000, 357367856],
            [1076976000000, 357677413],
            [1077062400000, 357975216],
            [1077148800000, 358268479],
            [1077235200000, 358922181],
            [1077321600000, 360222047],
            [1077408000000, 361118934],
            [1077494400000, 361329662],
            [1077580800000, 361554774],
            [1077667200000, 361742495],
            [1077753600000, 361940947],
            [1077840000000, 362436661],
            [1077926400000, 363458415],
            [1078012800000, 364115612],
            [1078099200000, 364394027],
            [1078185600000, 364675286],
            [1078272000000, 364920123],
            [1078358400000, 365172348],
            [1078444800000, 365892919],
            [1078531200000, 367326659],
            [1078617600000, 368210170],
            [1078704000000, 368432916],
            [1078790400000, 368672025],
            [1078876800000, 368890651],
            [1078963200000, 369126293],
            [1079049600000, 369612988],
            [1079136000000, 370521028],
            [1079222400000, 371147794],
            [1079308800000, 371355728],
            [1079395200000, 371585257],
            [1079481600000, 371784723],
            [1079568000000, 372008809],
            [1079654400000, 372370614],
            [1079740800000, 372968676],
            [1079827200000, 373359557],
            [1079913600000, 373480504],
            [1080000000000, 373603224],
            [1080086400000, 373720131],
            [1080172800000, 373850755],
            [1080259200000, 374028579],
            [1080345600000, 374359649],
            [1080432000000, 374556572],
            [1080518400000, 374618206],
            [1080604800000, 374685152],
            [1080691200000, 374757103],
            [1080777600000, 374830647],
            [1080864000000, 374930356],
            [1080950400000, 375095462],
            [1081036800000, 375204550],
            [1081123200000, 375242873],
            [1081209600000, 375288167],
            [1081296000000, 375328318],
            [1081382400000, 375378000],
            [1081468800000, 375474875],
            [1081555200000, 375594905],
            [1081641600000, 375667233],
            [1081728000000, 375716277],
            [1081814400000, 375757584],
            [1081900800000, 375794870],
            [1081987200000, 375831230],
            [1082073600000, 375894225],
            [1082160000000, 375997379],
            [1082246400000, 376058551],
            [1082332800000, 376076663],
            [1082419200000, 376098769],
            [1082505600000, 376119995],
            [1082592000000, 376142702],
            [1082678400000, 376193716],
            [1082764800000, 376278206],
            [1082851200000, 376337432],
            [1082937600000, 376353893],
            [1083024000000, 376370038],
            [1083110400000, 376385713],
            [1083196800000, 376401952],
            [1083283200000, 376441668],
            [1083369600000, 376511533],
            [1083456000000, 376556583],
            [1083542400000, 376570162],
            [1083628800000, 376584254],
            [1083715200000, 376598825],
            [1083801600000, 376612619],
            [1083888000000, 376640262],
            [1083974400000, 376685312],
            [1084060800000, 376716328],
            [1084147200000, 376726334],
            [1084233600000, 376737238],
            [1084320000000, 376748397],
            [1084406400000, 376760431],
            [1084492800000, 376783973],
            [1084579200000, 376825906],
            [1084665600000, 376853002],
            [1084752000000, 376861127],
            [1084838400000, 376869751],
            [1084924800000, 376877518],
            [1085011200000, 376886789],
            [1085097600000, 376906145],
            [1085184000000, 376937607],
            [1085270400000, 376958965],
            [1085356800000, 376968416],
            [1085443200000, 376974463],
            [1085529600000, 376980723],
            [1085616000000, 376987769],
            [1085702400000, 376994759],
            [1085788800000, 377004524],
            [1085875200000, 377013073],
            [1085961600000, 377019252],
            [1086048000000, 377021578],
            [1086134400000, 377024076],
            [1086220800000, 377027325]
        ],
        name: 'returnoftheking',
        showInLegend: false,
        extra: {
            title: 'The Lord of the Rings: The Return of the King',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#6F5838'
        },
        showlabel: false,
        color: 'rgba(111,88,56,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1088553600000, 40442604
            ],
            [1088640000000, 64255524],
            [1088726400000, 96707866],
            [1088812800000, 130456123],
            [1088899200000, 152411751],
            [1088985600000, 180072888],
            [1089072000000, 192085360],
            [1089158400000, 202120073],
            [1089244800000, 211257583],
            [1089331200000, 225116345],
            [1089417600000, 243032969],
            [1089504000000, 256438326],
            [1089590400000, 262205594],
            [1089676800000, 267638277],
            [1089763200000, 272674954],
            [1089849600000, 277512432],
            [1089936000000, 284637833],
            [1090022400000, 294579826],
            [1090108800000, 302287882],
            [1090195200000, 305304586],
            [1090281600000, 308212667],
            [1090368000000, 310766413],
            [1090454400000, 313452891],
            [1090540800000, 317922598],
            [1090627200000, 324088209],
            [1090713600000, 328468763],
            [1090800000000, 330335827],
            [1090886400000, 332378153],
            [1090972800000, 334212884],
            [1091059200000, 335826901],
            [1091145600000, 338264735],
            [1091232000000, 341772127],
            [1091318400000, 344440594],
            [1091404800000, 345683315],
            [1091491200000, 346871797],
            [1091577600000, 347976111],
            [1091664000000, 349070083],
            [1091750400000, 350681868],
            [1091836800000, 352914946],
            [1091923200000, 354501860],
            [1092009600000, 355215323],
            [1092096000000, 356006990],
            [1092182400000, 356749553],
            [1092268800000, 357461241],
            [1092355200000, 358505874],
            [1092441600000, 359914731],
            [1092528000000, 360973268],
            [1092614400000, 361446680],
            [1092700800000, 361891163],
            [1092787200000, 362315693],
            [1092873600000, 362752028],
            [1092960000000, 363411937],
            [1093046400000, 364504392],
            [1093132800000, 365173462],
            [1093219200000, 365450576],
            [1093305600000, 365732747],
            [1093392000000, 365995921],
            [1093478400000, 366241738],
            [1093564800000, 366671641],
            [1093651200000, 367377481],
            [1093737600000, 367816575],
            [1093824000000, 367971657],
            [1093910400000, 368120841],
            [1093996800000, 368245822],
            [1094083200000, 368368396],
            [1094169600000, 368628032],
            [1094256000000, 369064028],
            [1094342400000, 369534309],
            [1094428800000, 369888512],
            [1094515200000, 369957255],
            [1094601600000, 370019970],
            [1094688000000, 370078207],
            [1094774400000, 370219151],
            [1094860800000, 370497521],
            [1094947200000, 370651825],
            [1095033600000, 370691542],
            [1095120000000, 370731374],
            [1095206400000, 370776671],
            [1095292800000, 370825461],
            [1095379200000, 370913770],
            [1095465600000, 371077956],
            [1095552000000, 371168083],
            [1095984000000, 371329254],
            [1096070400000, 371469307],
            [1096156800000, 371538616],
            [1096588800000, 371664471],
            [1096675200000, 371753356],
            [1096761600000, 371795119],
            [1097193600000, 371929676],
            [1097280000000, 372082887],
            [1097366400000, 372191244],
            [1097798400000, 372394758],
            [1097884800000, 372513192],
            [1097971200000, 372585847],
            [1098403200000, 372721003],
            [1098489600000, 372813355],
            [1098576000000, 372871182],
            [1099008000000, 372974767],
            [1099094400000, 373036672],
            [1099180800000, 373068126],
            [1099612800000, 373153457],
            [1099699200000, 373213580],
            [1099785600000, 373247668],
            [1100217600000, 373310948],
            [1100304000000, 373353536],
            [1100390400000, 373377893]
        ],
        name: 'spiderman2',
        showInLegend: false,
        extra: {
            title: 'Spider-Man 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#723925'
        },
        showlabel: false,
        color: 'rgba(114,57,37,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1077667200000, 26556573
            ],
            [1077753600000, 41337889],
            [1077840000000, 64247837],
            [1077926400000, 97325776],
            [1078012800000, 125185971],
            [1078099200000, 135317847],
            [1078185600000, 144600923],
            [1078272000000, 153003285],
            [1078358400000, 160641939],
            [1078444800000, 174307053],
            [1078531200000, 196236096],
            [1078617600000, 213888740],
            [1078704000000, 218892679],
            [1078790400000, 223720260],
            [1078876800000, 228133890],
            [1078963200000, 232379231],
            [1079049600000, 240339179],
            [1079136000000, 253792087],
            [1079222400000, 264510209],
            [1079308800000, 267680889],
            [1079395200000, 270706537],
            [1079481600000, 273311111],
            [1079568000000, 276092867],
            [1079654400000, 281034042],
            [1079740800000, 289004202],
            [1079827200000, 295507244],
            [1079913600000, 297280146],
            [1080000000000, 299121441],
            [1080086400000, 300753003],
            [1080172800000, 302558804],
            [1080259200000, 305673628],
            [1080345600000, 310860490],
            [1080432000000, 315152778],
            [1080518400000, 316345913],
            [1080604800000, 317697565],
            [1080691200000, 318972677],
            [1080777600000, 320251865],
            [1080864000000, 322756546],
            [1080950400000, 326852950],
            [1081036800000, 330856971],
            [1081123200000, 332148696],
            [1081209600000, 333751215],
            [1081296000000, 335525803],
            [1081382400000, 337789628],
            [1081468800000, 344366712],
            [1081555200000, 349340005],
            [1081641600000, 353006351],
            [1081728000000, 354304281],
            [1081814400000, 355236096],
            [1081900800000, 356020828],
            [1081987200000, 356710507],
            [1082073600000, 357837980],
            [1082160000000, 359530498],
            [1082246400000, 360761619],
            [1082332800000, 361117712],
            [1082419200000, 361483659],
            [1082505600000, 361845525],
            [1082592000000, 362198530],
            [1082678400000, 362768293],
            [1082764800000, 363683801],
            [1082851200000, 364414581],
            [1082937600000, 364641738],
            [1083024000000, 364870422],
            [1083110400000, 365075712],
            [1083196800000, 365277616],
            [1083283200000, 365620755],
            [1083369600000, 366225926],
            [1083456000000, 366685267],
            [1083542400000, 366834477],
            [1083628800000, 366980305],
            [1083715200000, 367114842],
            [1083801600000, 367241879],
            [1083888000000, 367424333],
            [1083974400000, 367736645],
            [1084060800000, 368027248],
            [1084147200000, 368115866],
            [1084233600000, 368205546],
            [1084320000000, 368299201],
            [1084406400000, 368394004],
            [1084492800000, 368517299],
            [1084579200000, 368722835],
            [1084665600000, 368894610],
            [1084752000000, 368954856],
            [1084838400000, 369025797],
            [1084924800000, 369044910],
            [1085011200000, 369065495],
            [1085097600000, 369126401],
            [1085184000000, 369236540],
            [1085270400000, 369336919],
            [1085356800000, 369379047],
            [1085443200000, 369416657],
            [1085529600000, 369456172],
            [1085616000000, 369501023],
            [1085702400000, 369537952],
            [1085788800000, 369595027],
            [1085875200000, 369664388],
            [1085961600000, 369727030],
            [1086048000000, 369748288],
            [1086134400000, 369770846],
            [1086220800000, 369797378],
            [1086307200000, 369822220],
            [1086393600000, 369860090],
            [1086480000000, 369895388]
        ],
        name: 'passionofthechrist',
        showInLegend: false,
        extra: {
            title: 'The Passion of the Christ',
            genre: 'Historical Drama',

            mpaaRating: 'R',
            imgMainColor: '#4E2810'
        },
        showlabel: false,
        color: 'rgba(78,40,16,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1372809600000, 35010665
            ],
            [1372896000000, 59557645],
            [1372982400000, 90034770],
            [1373068800000, 119412720],
            [1373155200000, 143074960],
            [1373241600000, 153587070],
            [1373328000000, 165658010],
            [1373414400000, 175330750],
            [1373500800000, 184483880],
            [1373587200000, 197933960],
            [1373673600000, 215367025],
            [1373760000000, 228376775],
            [1373846400000, 234021005],
            [1373932800000, 240866135],
            [1374019200000, 246099530],
            [1374105600000, 251100035],
            [1374192000000, 258568120],
            [1374278400000, 268595595],
            [1374364800000, 276006395],
            [1374451200000, 279463495],
            [1374537600000, 283818295],
            [1374624000000, 287179700],
            [1374710400000, 290388585],
            [1374796800000, 295255020],
            [1374883200000, 301650860],
            [1374969600000, 306812720],
            [1375056000000, 309089500],
            [1375142400000, 311818160],
            [1375228800000, 313957310],
            [1375315200000, 316277465],
            [1375401600000, 319372220],
            [1375488000000, 323525285],
            [1375574400000, 326411585],
            [1375660800000, 327966980],
            [1375747200000, 329730420],
            [1375833600000, 331183945],
            [1375920000000, 332566195],
            [1376006400000, 334470220],
            [1376092800000, 336757445],
            [1376179200000, 338481845],
            [1376265600000, 339391970],
            [1376352000000, 340613420],
            [1376438400000, 341475645],
            [1376524800000, 342206120],
            [1376611200000, 343278740],
            [1376697600000, 344860400],
            [1376784000000, 346114855],
            [1376870400000, 346642075],
            [1376956800000, 347223835],
            [1377043200000, 347639040],
            [1377129600000, 348100420],
            [1377216000000, 348815440],
            [1377302400000, 349916015],
            [1377388800000, 350701135],
            [1377475200000, 351037615],
            [1377561600000, 351388170],
            [1377648000000, 351676590],
            [1377734400000, 351938790],
            [1377820800000, 352535850],
            [1377907200000, 353607895],
            [1377993600000, 354699250],
            [1378080000000, 355739290],
            [1378166400000, 355886950],
            [1378252800000, 355983250],
            [1378339200000, 356098810],
            [1378425600000, 356408560],
            [1378512000000, 357133060],
            [1378598400000, 357558315],
            [1378684800000, 357626565],
            [1378771200000, 357705315],
            [1378857600000, 357768325],
            [1378944000000, 357831320],
            [1379030400000, 358102945],
            [1379116800000, 358716605],
            [1379203200000, 359113975],
            [1379289600000, 359179365],
            [1379376000000, 359249785],
            [1379462400000, 359310145],
            [1379548800000, 359370400],
            [1379635200000, 359656540],
            [1379721600000, 360339260],
            [1379808000000, 360730820],
            [1379894400000, 360796080],
            [1379980800000, 360866360],
            [1380067200000, 360926600],
            [1380153600000, 360981820],
            [1380240000000, 361172575],
            [1380326400000, 361554055],
            [1380412800000, 361774715],
            [1380499200000, 361819595],
            [1380585600000, 361868215],
            [1380672000000, 361909565],
            [1380758400000, 361950600],
            [1380844800000, 362067010],
            [1380931200000, 362297385],
            [1381017600000, 362435610],
            [1381104000000, 362464710],
            [1381190400000, 362496235],
            [1381276800000, 362522910],
            [1381363200000, 362554515],
            [1381449600000, 362689055],
            [1381536000000, 362916905],
            [1381622400000, 363060130],
            [1381708800000, 363151270],
            [1381795200000, 363188160],
            [1381881600000, 363216170],
            [1381968000000, 363255230],
            [1382054400000, 363381630],
            [1382140800000, 363612705],
            [1382227200000, 363741080],
            [1382313600000, 363770885],
            [1382400000000, 363800595],
            [1382486400000, 363826465],
            [1382572800000, 363858260],
            [1382659200000, 363960590],
            [1382745600000, 364136825],
            [1382832000000, 364248630],
            [1382918400000, 364275185],
            [1383004800000, 364299820],
            [1383091200000, 364320665],
            [1383177600000, 364350985],
            [1383264000000, 364451410],
            [1383350400000, 364659995],
            [1383436800000, 364774325],
            [1383523200000, 364800590],
            [1383609600000, 364833035],
            [1383696000000, 364856210],
            [1383782400000, 364879305],
            [1383868800000, 364992455],
            [1383955200000, 365212555],
            [1384041600000, 365353620],
            [1384128000000, 365451270],
            [1384214400000, 365477620],
            [1384300800000, 365502420],
            [1384387200000, 365525670],
            [1384473600000, 365626320],
            [1384560000000, 365835245],
            [1384646400000, 365943520],
            [1384732800000, 365966395],
            [1384819200000, 365990780],
            [1384905600000, 366012130],
            [1384992000000, 366031955],
            [1385078400000, 366111605],
            [1385164800000, 366281230],
            [1385251200000, 366375650],
            [1385337600000, 366418425],
            [1385424000000, 366474435],
            [1385510400000, 366553025],
            [1385596800000, 366592320],
            [1385683200000, 366727875],
            [1385769600000, 366864730],
            [1385856000000, 366932480],
            [1385942400000, 366947265],
            [1386028800000, 366960870],
            [1386115200000, 366973180],
            [1386201600000, 366986595],
            [1386288000000, 367025655],
            [1386374400000, 367108815],
            [1386460800000, 367157955],
            [1386547200000, 367171815],
            [1386633600000, 367186935],
            [1386720000000, 367200710],
            [1386806400000, 367212050],
            [1386892800000, 367243270],
            [1386979200000, 367314630],
            [1387065600000, 367355885],
            [1387152000000, 367365815],
            [1387238400000, 367378080],
            [1387324800000, 367391860],
            [1387411200000, 367405655],
            [1387497600000, 367431270],
            [1387584000000, 367472640],
            [1387670400000, 367504160],
            [1387756800000, 367535680],
            [1387843200000, 367553410],
            [1387929600000, 367573535],
            [1388016000000, 367607660],
            [1388102400000, 367651385],
            [1388188800000, 367700870],
            [1388275200000, 367736345],
            [1388361600000, 367766870],
            [1388448000000, 367793270],
            [1388534400000, 367835345],
            [1388620800000, 367860095],
            [1388707200000, 367893315],
            [1388793600000, 367935595],
            [1388880000000, 367956735],
            [1388966400000, 367964290],
            [1389052800000, 367971865],
            [1389139200000, 367977905],
            [1389225600000, 367983190],
            [1389312000000, 367996205],
            [1389398400000, 368029770],
            [1389484800000, 368049635],
            [1389571200000, 368053060],
            [1389657600000, 368057170],
            [1389744000000, 368061265],
            [1389830400000, 368065385]
        ],
        name: 'despicableme2',
        showInLegend: false,
        extra: {
            title: 'Despicable Me 2',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#D0C6A9'
        },
        showlabel: false,
        color: 'rgba(208,198,169,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1434672000000, 34266177
            ],
            [1434758400000, 65208670],
            [1434844800000, 90440272],
            [1434931200000, 100925912],
            [1435017600000, 113964720],
            [1435104000000, 123339570],
            [1435190400000, 132817010],
            [1435276800000, 147803863],
            [1435363200000, 168928089],
            [1435449600000, 185140364],
            [1435536000000, 192061039],
            [1435622400000, 200844477],
            [1435708800000, 208335932],
            [1435795200000, 216120171],
            [1435881600000, 228679481],
            [1435968000000, 236889029],
            [1436054400000, 245891395],
            [1436140800000, 250845401],
            [1436227200000, 257285774],
            [1436313600000, 262308400],
            [1436400000000, 266530304],
            [1436486400000, 271999560],
            [1436572800000, 278957386],
            [1436659200000, 284196100],
            [1436745600000, 286592302],
            [1436832000000, 289886341],
            [1436918400000, 292470389],
            [1437004800000, 294702966],
            [1437091200000, 298076126],
            [1437177600000, 302882902],
            [1437264000000, 306247046],
            [1437350400000, 307830350],
            [1437436800000, 309944068],
            [1437523200000, 311472923],
            [1437609600000, 312978811],
            [1437696000000, 315179995],
            [1437782400000, 318109815],
            [1437868800000, 320393339],
            [1437955200000, 321545325],
            [1438041600000, 322944913],
            [1438128000000, 324010768],
            [1438214400000, 325076892],
            [1438300800000, 326388708],
            [1438387200000, 328199667],
            [1438473600000, 329587896],
            [1438560000000, 330388314],
            [1438646400000, 331333285],
            [1438732800000, 332026895],
            [1438819200000, 332686150],
            [1438905600000, 333459447],
            [1438992000000, 334547356],
            [1439078400000, 335390545],
            [1439164800000, 335852827],
            [1439251200000, 336491884],
            [1439337600000, 336926075],
            [1439424000000, 337319497],
            [1439510400000, 337882892],
            [1439596800000, 338725582],
            [1439683200000, 339365573],
            [1439769600000, 339695765],
            [1439856000000, 340132364],
            [1439942400000, 340458012],
            [1440028800000, 340758415],
            [1440115200000, 341200661],
            [1440201600000, 341857068],
            [1440288000000, 342353075],
            [1440374400000, 342553567],
            [1440460800000, 342806331],
            [1440547200000, 342994075],
            [1440633600000, 343169107],
            [1440720000000, 343484260],
            [1440806400000, 344104957],
            [1440892800000, 344519079],
            [1440979200000, 344671046],
            [1441065600000, 344824515],
            [1441152000000, 344950104],
            [1441238400000, 345073280],
            [1441324800000, 345709668],
            [1441411200000, 346992697],
            [1441497600000, 348310170],
            [1441584000000, 349526793],
            [1441670400000, 349712242],
            [1441756800000, 349854676],
            [1441843200000, 349996363],
            [1441929600000, 350279893],
            [1442016000000, 351037588],
            [1442102400000, 351525709],
            [1442188800000, 351643444],
            [1442275200000, 351752491],
            [1442361600000, 351840283],
            [1442448000000, 351919169],
            [1442534400000, 352107777],
            [1442620800000, 352563827],
            [1442707200000, 352846548],
            [1442793600000, 352907907],
            [1442880000000, 352976903],
            [1442966400000, 353063164],
            [1443052800000, 353130093],
            [1443139200000, 353220374],
            [1443225600000, 353394170],
            [1443312000000, 353495492],
            [1443398400000, 353525555],
            [1443484800000, 353554263],
            [1443571200000, 353584508],
            [1443657600000, 353612737]
        ],
        name: 'pixar2014',
        showInLegend: false,
        extra: {
            title: 'Inside Out',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#6A7183'
        },
        showlabel: false,
        color: 'rgba(106,113,131,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1428019200000, 67407340
            ],
            [1428105600000, 114033920],
            [1428192000000, 147187040],
            [1428278400000, 161202390],
            [1428364800000, 174514030],
            [1428451200000, 183701580],
            [1428537600000, 191930470],
            [1428624000000, 210793650],
            [1428710400000, 236252910],
            [1428796800000, 251516400],
            [1428883200000, 255156380],
            [1428969600000, 259520250],
            [1429056000000, 262437800],
            [1429142400000, 265354080],
            [1429228800000, 273678480],
            [1429315200000, 286601120],
            [1429401600000, 294510675],
            [1429488000000, 296532315],
            [1429574400000, 298829565],
            [1429660800000, 300534085],
            [1429747200000, 302260135],
            [1429833600000, 307134375],
            [1429920000000, 315550055],
            [1430006400000, 320081575],
            [1430092800000, 321241725],
            [1430179200000, 322669420],
            [1430265600000, 323661305],
            [1430352000000, 324424355],
            [1430438400000, 326604165],
            [1430524800000, 329200175],
            [1430611200000, 331068495],
            [1430697600000, 331562645],
            [1430784000000, 332172980],
            [1430870400000, 332653095],
            [1430956800000, 333147935],
            [1431043200000, 334589855],
            [1431129600000, 336947995],
            [1431216000000, 338555135],
            [1431302400000, 338962145],
            [1431388800000, 339441295],
            [1431475200000, 339816615],
            [1431561600000, 340133495],
            [1431648000000, 341130010],
            [1431734400000, 342786130],
            [1431820800000, 343782475],
            [1431907200000, 344094705],
            [1431993600000, 344386455],
            [1432080000000, 344632905],
            [1432166400000, 344889185],
            [1432252800000, 345458740],
            [1432339200000, 346334790],
            [1432425600000, 347161270],
            [1432512000000, 347723320],
            [1432598400000, 347930725],
            [1432684800000, 348103470],
            [1432771200000, 348243950],
            [1432857600000, 348532400],
            [1432944000000, 348980195],
            [1433030400000, 349249360],
            [1433116800000, 349346140],
            [1433203200000, 349447600],
            [1433289600000, 349526785],
            [1433376000000, 349597795],
            [1433462400000, 349725150],
            [1433548800000, 349923195],
            [1433635200000, 350034110],
            [1433721600000, 350081220],
            [1433808000000, 350133000],
            [1433894400000, 350182455],
            [1433980800000, 350222520],
            [1434067200000, 350418870],
            [1434153600000, 350704470],
            [1434240000000, 350827635],
            [1434326400000, 350872260],
            [1434412800000, 350922240],
            [1434499200000, 350981145],
            [1434585600000, 351032910]
        ],
        name: 'fast7',
        showInLegend: false,
        extra: {
            title: 'Furious 7',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#6A6A69'
        },
        showlabel: false,
        color: 'rgba(106,106,105,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1309219200000, 5500000
            ],
            [1309305600000, 43225329],
            [1309392000000, 64765347],
            [1309478400000, 97754230],
            [1309564800000, 132242114],
            [1309651200000, 162618212],
            [1309737600000, 180651397],
            [1309824000000, 194088858],
            [1309910400000, 204421287],
            [1309996800000, 213975424],
            [1310083200000, 228818138],
            [1310169600000, 247145003],
            [1310256000000, 261078700],
            [1310342400000, 266944138],
            [1310428800000, 273009241],
            [1310515200000, 277633524],
            [1310601600000, 281550252],
            [1310688000000, 287865039],
            [1310774400000, 296487753],
            [1310860800000, 302878797],
            [1310947200000, 305717867],
            [1311033600000, 308775871],
            [1311120000000, 311239379],
            [1311206400000, 313789450],
            [1311292800000, 317369164],
            [1311379200000, 322208872],
            [1311465600000, 325841185],
            [1311552000000, 327418686],
            [1311638400000, 329134061],
            [1311724800000, 330534176],
            [1311811200000, 331921414],
            [1311897600000, 333715081],
            [1311984000000, 336181865],
            [1312070400000, 338007725],
            [1312156800000, 338838869],
            [1312243200000, 339690805],
            [1312329600000, 340435839],
            [1312416000000, 341158341],
            [1312502400000, 342018562],
            [1312588800000, 343270593],
            [1312675200000, 344244486],
            [1312761600000, 344666713],
            [1312848000000, 345152286],
            [1312934400000, 345528029],
            [1313020800000, 345884168],
            [1313107200000, 346269300],
            [1313193600000, 346843821],
            [1313280000000, 347268800],
            [1313366400000, 347440989],
            [1313452800000, 347624217],
            [1313539200000, 347776785],
            [1313625600000, 347933730],
            [1313712000000, 348104302],
            [1313798400000, 348360601],
            [1313884800000, 348540006],
            [1313971200000, 348610183],
            [1314057600000, 348687050],
            [1314144000000, 348752065],
            [1314230400000, 348816955],
            [1314316800000, 348994766],
            [1314403200000, 349273584],
            [1314489600000, 349457208],
            [1314576000000, 349530419],
            [1314662400000, 349614219],
            [1314748800000, 349684855],
            [1314835200000, 349759744],
            [1314921600000, 349894563],
            [1315008000000, 350118110],
            [1315094400000, 350348225],
            [1315180800000, 350500012],
            [1315267200000, 350544784],
            [1315353600000, 350586168],
            [1315440000000, 350625139],
            [1315526400000, 350672117],
            [1315612800000, 350755109],
            [1315699200000, 350800077],
            [1315785600000, 350813745],
            [1315872000000, 350832076],
            [1315958400000, 350847747],
            [1316044800000, 350862779],
            [1316131200000, 350980623],
            [1316217600000, 351188671],
            [1316304000000, 351331987],
            [1316390400000, 351372490],
            [1316476800000, 351418946],
            [1316563200000, 351458166],
            [1316649600000, 351501539],
            [1316736000000, 351603303],
            [1316822400000, 351781681],
            [1316908800000, 351902625],
            [1316995200000, 351931519],
            [1317081600000, 351962681],
            [1317168000000, 351991232],
            [1317254400000, 352021378],
            [1317340800000, 352073903],
            [1317427200000, 352165905],
            [1317513600000, 352222098],
            [1317600000000, 352235347],
            [1317686400000, 352249359],
            [1317772800000, 352262443],
            [1317859200000, 352275878],
            [1317945600000, 352298118],
            [1318032000000, 352334012],
            [1318118400000, 352358779],
            [1318204800000, 352369061],
            [1318291200000, 352376573],
            [1318377600000, 352382933],
            [1318464000000, 352390543]
        ],
        name: 'transformers3',
        showInLegend: false,
        extra: {
            title: 'Transformers: Dark of the Moon',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#4B4440'
        },
        showlabel: false,
        color: 'rgba(75,68,64,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1419465600000, 240211
            ],
            [1419552000000, 439692],
            [1419638400000, 655550],
            [1419724800000, 873667],
            [1419811200000, 1040111],
            [1419897600000, 1204312],
            [1419984000000, 1329299],
            [1420070400000, 1552379],
            [1420156800000, 1786098],
            [1420243200000, 2024960],
            [1420329600000, 2229288],
            [1420416000000, 2329793],
            [1420502400000, 2418851],
            [1420588800000, 2512183],
            [1420675200000, 2595151],
            [1420761600000, 2751511],
            [1420848000000, 2985721],
            [1420934400000, 3174669],
            [1421020800000, 3234852],
            [1421107200000, 3303452],
            [1421193600000, 3372722],
            [1421280000000, 3424778],
            [1421366400000, 33763266],
            [1421452800000, 68310550],
            [1421539200000, 92693844],
            [1421625600000, 110636235],
            [1421712000000, 120560352],
            [1421798400000, 128115621],
            [1421884800000, 135772113],
            [1421971200000, 153985667],
            [1422057600000, 182620802],
            [1422144000000, 200400417],
            [1422230400000, 204583784],
            [1422316800000, 209600822],
            [1422403200000, 213423957],
            [1422489600000, 217092013],
            [1422576000000, 226997629],
            [1422662400000, 243508165],
            [1422748800000, 247752541],
            [1422835200000, 250397650],
            [1422921600000, 253320791],
            [1423008000000, 255594133],
            [1423094400000, 258100239],
            [1423180800000, 264263604],
            [1423267200000, 275296051],
            [1423353600000, 281389352],
            [1423440000000, 282979594],
            [1423526400000, 284752955],
            [1423612800000, 286221115],
            [1423699200000, 287698293],
            [1423785600000, 291443856],
            [1423872000000, 299267928],
            [1423958400000, 304113098],
            [1424044800000, 306478136],
            [1424131200000, 307762521],
            [1424217600000, 308800018],
            [1424304000000, 309957178],
            [1424390400000, 312675300],
            [1424476800000, 317271043],
            [1424563200000, 320009625],
            [1424649600000, 320845846],
            [1424736000000, 321794342],
            [1424822400000, 322586443],
            [1424908800000, 323408447],
            [1424995200000, 325311916],
            [1425081600000, 328913643],
            [1425168000000, 330802740],
            [1425254400000, 331304919],
            [1425340800000, 331812237],
            [1425427200000, 332241639],
            [1425513600000, 332698979],
            [1425600000000, 333845819],
            [1425686400000, 336004358],
            [1425772800000, 337100370],
            [1425859200000, 337442628],
            [1425945600000, 337852209],
            [1426032000000, 338215533],
            [1426118400000, 338569563],
            [1426204800000, 339325331],
            [1426291200000, 340707737],
            [1426377600000, 341380905],
            [1426464000000, 341612973],
            [1426550400000, 341868356],
            [1426636800000, 342124666],
            [1426723200000, 342360752],
            [1426809600000, 342793490],
            [1426896000000, 343578903],
            [1426982400000, 343969003],
            [1427068800000, 344121396],
            [1427155200000, 344276641],
            [1427241600000, 344414087],
            [1427328000000, 344540234],
            [1427414400000, 344787171],
            [1427500800000, 345211045],
            [1427587200000, 345414287],
            [1427673600000, 345495500],
            [1427760000000, 345586824],
            [1427846400000, 345670073],
            [1427932800000, 345758428],
            [1428019200000, 345989306],
            [1428105600000, 346250796],
            [1428192000000, 346386488],
            [1428278400000, 346441961],
            [1428364800000, 346503536],
            [1428451200000, 346559053],
            [1428537600000, 346616236],
            [1428624000000, 346796514],
            [1428710400000, 347098782],
            [1428796800000, 347211277],
            [1428883200000, 347251832],
            [1428969600000, 347300219],
            [1429056000000, 347344678],
            [1429142400000, 347383183],
            [1429228800000, 347488055],
            [1429315200000, 347673246],
            [1429401600000, 347762901],
            [1429488000000, 347800074],
            [1429574400000, 347842467],
            [1429660800000, 347879710],
            [1429747200000, 347920677],
            [1429833600000, 348017253],
            [1429920000000, 348204661],
            [1430006400000, 348295276],
            [1430092800000, 348326991],
            [1430179200000, 348361848],
            [1430265600000, 348391476],
            [1430352000000, 348417548],
            [1430438400000, 348541447],
            [1430524800000, 348713204],
            [1430611200000, 348861463],
            [1430697600000, 348907423],
            [1430784000000, 348957979],
            [1430870400000, 348997918],
            [1430956800000, 349033865],
            [1431043200000, 349120195],
            [1431129600000, 349239350],
            [1431216000000, 349324606],
            [1431302400000, 349358708],
            [1431388800000, 349396221],
            [1431475200000, 349424355],
            [1431561600000, 349451927],
            [1431648000000, 349506511],
            [1431734400000, 349595222],
            [1431820800000, 349640908],
            [1431907200000, 349656798],
            [1431993600000, 349673800],
            [1432080000000, 349689951],
            [1432166400000, 349709071],
            [1432252800000, 349752421],
            [1432339200000, 349821648],
            [1432425600000, 349894088],
            [1432512000000, 349936617],
            [1432598400000, 349949801],
            [1432684800000, 349960743],
            [1432771200000, 349973107],
            [1432857600000, 349992136],
            [1432944000000, 350020183],
            [1433030400000, 350040510],
            [1433116800000, 350046837],
            [1433203200000, 350053913],
            [1433289600000, 350060565],
            [1433376000000, 350066882],
            [1433462400000, 350073413],
            [1433548800000, 350084272],
            [1433635200000, 350090029],
            [1433721600000, 350092526],
            [1433808000000, 350095047],
            [1433894400000, 350097698],
            [1433980800000, 350100544],
            [1434067200000, 350103672],
            [1434153600000, 350108900],
            [1434240000000, 350112192],
            [1434326400000, 350113554],
            [1434412800000, 350115090],
            [1434499200000, 350116992],
            [1434585600000, 350118902],
            [1434672000000, 350120025],
            [1434758400000, 350121839],
            [1434844800000, 350123553],
            [1434931200000, 350124160],
            [1435017600000, 350124949],
            [1435104000000, 350125656],
            [1435190400000, 350126372]
        ],
        name: 'americansniper',
        showInLegend: false,
        extra: {
            title: 'American Sniper',
            genre: 'Drama',

            mpaaRating: 'R',
            imgMainColor: '#A7A3A1'
        },
        showlabel: false,
        color: 'rgba(167,163,161,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1040169600000, 26159972
            ],
            [1040256000000, 40038684],
            [1040342400000, 59263024],
            [1040428800000, 82015081],
            [1040515200000, 102046212],
            [1040601600000, 115556154],
            [1040688000000, 123346204],
            [1040774400000, 135727511],
            [1040860800000, 151182682],
            [1040947200000, 168056221],
            [1041033600000, 185283282],
            [1041120000000, 200058231],
            [1041206400000, 210153082],
            [1041292800000, 218595905],
            [1041379200000, 229636178],
            [1041465600000, 236014322],
            [1041552000000, 243590544],
            [1041638400000, 254290037],
            [1041724800000, 261031601],
            [1041811200000, 263165066],
            [1041897600000, 265320641],
            [1041984000000, 267068847],
            [1042070400000, 268666211],
            [1042156800000, 272561063],
            [1042243200000, 279199045],
            [1042329600000, 283421517],
            [1042416000000, 284460743],
            [1042502400000, 285656037],
            [1042588800000, 286637101],
            [1042675200000, 287628062],
            [1042761600000, 290292649],
            [1042848000000, 294814282],
            [1042934400000, 297892450],
            [1043020800000, 300122052],
            [1043107200000, 300898684],
            [1043193600000, 301532292],
            [1043280000000, 302209601],
            [1043366400000, 303959195],
            [1043452800000, 307406571],
            [1043539200000, 308821306],
            [1043625600000, 309357400],
            [1043712000000, 309916006],
            [1043798400000, 310407214],
            [1043884800000, 310938073],
            [1043971200000, 312157419],
            [1044057600000, 314497684],
            [1044144000000, 316026494],
            [1044230400000, 316340631],
            [1044316800000, 316702284],
            [1044403200000, 317019413],
            [1044489600000, 317340310],
            [1044576000000, 318148497],
            [1044662400000, 319764713],
            [1044748800000, 320857049],
            [1044835200000, 321086387],
            [1044921600000, 321346057],
            [1045008000000, 321598084],
            [1045094400000, 321849361],
            [1045180800000, 322653345],
            [1045267200000, 323961909],
            [1045353600000, 324921599],
            [1045440000000, 325446438],
            [1045526400000, 325730904],
            [1045612800000, 325970898],
            [1045699200000, 326231250],
            [1045785600000, 326719985],
            [1045872000000, 327611676],
            [1045958400000, 328156417],
            [1046044800000, 328285425],
            [1046131200000, 328435381],
            [1046217600000, 328574452],
            [1046304000000, 328720136],
            [1046390400000, 329100557],
            [1046476800000, 329842711],
            [1046563200000, 330338275],
            [1046649600000, 330462640],
            [1046736000000, 330599870],
            [1046822400000, 330723097],
            [1046908800000, 330847924],
            [1046995200000, 331139227],
            [1047081600000, 331692227],
            [1047168000000, 332075527],
            [1047254400000, 332194788],
            [1047340800000, 332342555],
            [1047427200000, 332471207],
            [1047513600000, 332609244],
            [1047600000000, 332874487],
            [1047686400000, 333338680],
            [1047772800000, 333623857],
            [1047859200000, 333710828],
            [1047945600000, 333824501],
            [1048032000000, 333920339],
            [1048118400000, 334022318],
            [1048204800000, 334219158],
            [1048291200000, 334584123],
            [1048377600000, 334790872],
            [1048464000000, 334883417],
            [1048550400000, 334986259],
            [1048636800000, 335077422],
            [1048723200000, 335176527],
            [1048809600000, 335337599],
            [1048896000000, 335616244],
            [1048982400000, 335800124],
            [1049068800000, 335852646],
            [1049155200000, 335914454],
            [1049241600000, 335967575],
            [1049328000000, 336021026],
            [1049414400000, 336142528],
            [1049500800000, 336364012],
            [1049587200000, 336500653],
            [1049673600000, 336538891],
            [1049760000000, 336587170],
            [1049846400000, 336628077],
            [1049932800000, 336673235],
            [1050019200000, 336762836],
            [1050105600000, 336918804],
            [1050192000000, 337013432],
            [1050278400000, 337047418],
            [1050364800000, 337088845],
            [1050451200000, 337126099],
            [1050537600000, 337174762],
            [1050624000000, 337301233],
            [1050710400000, 337439753],
            [1050796800000, 337526600],
            [1050883200000, 337577839],
            [1050969600000, 337619072],
            [1051056000000, 337659854],
            [1051142400000, 337702863],
            [1051228800000, 337770714],
            [1051315200000, 337887458],
            [1051401600000, 337949941],
            [1051488000000, 337971678],
            [1051574400000, 337998864],
            [1051660800000, 338020450],
            [1051747200000, 338043829],
            [1051833600000, 338092642],
            [1051920000000, 338175057],
            [1052006400000, 338230249],
            [1052092800000, 338247505],
            [1052179200000, 338267680],
            [1052265600000, 338285833],
            [1052352000000, 338305321],
            [1052438400000, 338344495],
            [1052524800000, 338408574],
            [1052611200000, 338457054],
            [1052697600000, 338474078],
            [1052784000000, 338493291],
            [1052870400000, 338508645],
            [1052956800000, 338521055],
            [1053043200000, 338548137],
            [1053129600000, 338592405],
            [1053216000000, 338622570],
            [1053302400000, 338639359],
            [1053388800000, 338652234],
            [1053475200000, 338663780],
            [1053561600000, 338678321],
            [1053648000000, 338705067],
            [1053734400000, 338751333],
            [1053820800000, 338794804],
            [1053907200000, 338829378],
            [1053993600000, 338841498],
            [1054080000000, 338853700],
            [1054166400000, 338866415],
            [1054252800000, 338889571],
            [1054339200000, 338929463],
            [1054425600000, 338955859],
            [1054512000000, 338967043],
            [1054598400000, 338980148],
            [1054684800000, 338992748],
            [1054771200000, 339022783],
            [1054857600000, 339045619],
            [1054944000000, 339079184],
            [1055030400000, 339104919],
            [1055116800000, 339117373],
            [1055203200000, 339130401],
            [1055289600000, 339142517],
            [1055376000000, 339156537],
            [1055462400000, 339176311],
            [1055548800000, 339206968],
            [1055635200000, 339230928],
            [1055721600000, 339243039],
            [1055808000000, 339256321],
            [1055894400000, 339269962],
            [1055980800000, 339284469],
            [1056067200000, 339301029],
            [1056153600000, 339324391],
            [1056240000000, 339344075],
            [1056326400000, 339354673],
            [1056412800000, 339365309],
            [1056499200000, 339375065],
            [1056585600000, 339384598],
            [1056672000000, 339406604],
            [1056758400000, 339435820],
            [1056844800000, 339457993],
            [1056931200000, 339470444],
            [1057017600000, 339481658],
            [1057104000000, 339490103],
            [1057190400000, 339503386],
            [1057276800000, 339515013],
            [1057363200000, 339537257],
            [1057449600000, 339554276],
            [1057536000000, 339563220],
            [1057622400000, 339573518],
            [1057708800000, 339584083],
            [1057795200000, 339593358],
            [1057881600000, 339602763],
            [1057968000000, 339617106],
            [1058054400000, 339628782],
            [1058140800000, 339636025],
            [1058227200000, 339643471],
            [1058313600000, 339650951],
            [1058400000000, 339658608],
            [1058486400000, 339666731],
            [1058572800000, 339677973],
            [1058659200000, 339687608],
            [1058745600000, 339693061],
            [1058832000000, 339699631],
            [1058918400000, 339705413],
            [1059004800000, 339711774],
            [1059091200000, 339718531],
            [1059177600000, 339727076],
            [1059264000000, 339734454],
            [1059350400000, 339738403],
            [1059436800000, 339743018],
            [1059523200000, 339747661],
            [1059609600000, 339751253],
            [1059696000000, 339752982],
            [1059782400000, 339756388],
            [1059868800000, 339758803],
            [1059955200000, 339760236],
            [1060041600000, 339761699],
            [1060128000000, 339763152],
            [1060214400000, 339764716],
            [1060300800000, 339766786],
            [1060387200000, 339769854],
            [1060473600000, 339772508],
            [1060560000000, 339773736],
            [1060646400000, 339775164],
            [1060732800000, 339776642],
            [1060905600000, 339777784],
            [1060992000000, 339779856],
            [1061078400000, 339781747],
            [1061164800000, 339782539],
            [1061251200000, 339783332],
            [1061337600000, 339784202],
            [1061424000000, 339785181]
        ],
        name: 'twotowers',
        showInLegend: false,
        extra: {
            title: 'The Lord of the Rings: The Two Towers',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#2D6252'
        },
        showlabel: true,
        color: 'rgba(45,98,82,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1416528000000, 55139942
            ],
            [1416614400000, 96045815],
            [1416700800000, 121897634],
            [1416787200000, 130875952],
            [1416873600000, 143007805],
            [1416960000000, 157628322],
            [1417046400000, 168708305],
            [1417132800000, 192907747],
            [1417219200000, 214899972],
            [1417305600000, 225680904],
            [1417392000000, 228316339],
            [1417478400000, 231476484],
            [1417564800000, 233808937],
            [1417651200000, 236126831],
            [1417737600000, 242789511],
            [1417824000000, 252704200],
            [1417910400000, 258153593],
            [1417996800000, 259591489],
            [1418083200000, 261377267],
            [1418169600000, 262766666],
            [1418256000000, 264198249],
            [1418342400000, 267941108],
            [1418428800000, 273669538],
            [1418515200000, 276884991],
            [1418601600000, 277996824],
            [1418688000000, 279367978],
            [1418774400000, 280389796],
            [1418860800000, 281476689],
            [1418947200000, 283752598],
            [1419033600000, 286897747],
            [1419120000000, 289356110],
            [1419206400000, 291072394],
            [1419292800000, 292982568],
            [1419379200000, 293970225],
            [1419465600000, 296655981],
            [1419552000000, 300182013],
            [1419638400000, 303846537],
            [1419724800000, 306719406],
            [1419811200000, 308939828],
            [1419897600000, 311329053],
            [1419984000000, 313282914],
            [1420070400000, 316174548],
            [1420156800000, 319160173],
            [1420243200000, 322054292],
            [1420329600000, 323734502],
            [1420416000000, 324301247],
            [1420502400000, 324876190],
            [1420588800000, 325347716],
            [1420675200000, 325774553],
            [1420761600000, 326834187],
            [1420848000000, 328620719],
            [1420934400000, 329540446],
            [1421020800000, 329793175],
            [1421107200000, 330136517],
            [1421193600000, 330416865],
            [1421280000000, 330643639],
            [1421366400000, 331128565],
            [1421452800000, 331973779],
            [1421539200000, 332516441],
            [1421625600000, 332930936],
            [1421712000000, 333074231],
            [1421798400000, 333180638],
            [1421884800000, 333285445],
            [1421971200000, 333551939],
            [1422057600000, 334067160],
            [1422144000000, 334325799],
            [1422230400000, 334386377],
            [1422316800000, 334460626],
            [1422403200000, 334522187],
            [1422489600000, 334577672],
            [1422576000000, 334747289],
            [1422662400000, 335042808],
            [1422748800000, 335127925],
            [1422835200000, 335170996],
            [1422921600000, 335218921],
            [1423008000000, 335258414],
            [1423094400000, 335293974],
            [1423180800000, 335400579],
            [1423267200000, 335601544],
            [1423353600000, 335704905],
            [1423440000000, 335735777],
            [1423526400000, 335768100],
            [1423612800000, 335796445],
            [1423699200000, 335825078],
            [1423785600000, 335890266],
            [1423872000000, 336043006],
            [1423958400000, 336128043],
            [1424044800000, 336187659],
            [1424131200000, 336208800],
            [1424217600000, 336228643],
            [1424304000000, 336248113],
            [1424390400000, 336296510],
            [1424476800000, 336369261],
            [1424563200000, 336410376],
            [1424649600000, 336423376],
            [1424736000000, 336438120],
            [1424822400000, 336450352],
            [1424908800000, 336464000],
            [1424995200000, 336526159],
            [1425081600000, 336645139],
            [1425168000000, 336717292],
            [1425254400000, 336736926],
            [1425340800000, 336758273],
            [1425427200000, 336775442],
            [1425513600000, 336796655],
            [1425600000000, 336844110],
            [1425686400000, 336921530],
            [1425772800000, 336962335],
            [1425859200000, 336976310],
            [1425945600000, 336992285],
            [1426032000000, 337005123],
            [1426118400000, 337018555],
            [1426204800000, 337043958],
            [1426291200000, 337083332],
            [1426377600000, 337103873],
            [1426464000000, 337111046],
            [1426550400000, 337119467],
            [1426636800000, 337127178],
            [1426723200000, 337135885]
        ],
        name: 'hungergames3',
        showInLegend: false,
        extra: {
            title: 'The Hunger Games: Mockingjay - Part 1',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#532C1B'
        },
        showlabel: false,
        color: 'rgba(83,44,27,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1178236800000, 59841919
            ],
            [1178323200000, 111178651],
            [1178409600000, 151116516],
            [1178496000000, 161401784],
            [1178582400000, 169444466],
            [1178668800000, 176161954],
            [1178755200000, 182070572],
            [1178841600000, 199232268],
            [1178928000000, 224411133],
            [1179014400000, 240236828],
            [1179100800000, 243829653],
            [1179187200000, 247287180],
            [1179273600000, 250433791],
            [1179360000000, 253357629],
            [1179446400000, 261336658],
            [1179532800000, 273714983],
            [1179619200000, 282379655],
            [1179705600000, 284729332],
            [1179792000000, 286385002],
            [1179878400000, 287939746],
            [1179964800000, 289642322],
            [1180051200000, 293443001],
            [1180137600000, 298969116],
            [1180224000000, 303977758],
            [1180310400000, 307754583],
            [1180396800000, 308788638],
            [1180483200000, 309752119],
            [1180569600000, 310764055],
            [1180656000000, 312786864],
            [1180742400000, 316005192],
            [1180828800000, 318342110],
            [1180915200000, 319099696],
            [1181001600000, 319846841],
            [1181088000000, 320558568],
            [1181174400000, 321280163],
            [1181260800000, 322520563],
            [1181347200000, 324404916],
            [1181433600000, 325585149],
            [1181520000000, 326055191],
            [1181606400000, 326528216],
            [1181692800000, 327010825],
            [1181779200000, 327515986],
            [1181865600000, 328204276],
            [1181952000000, 329202532],
            [1182038400000, 330021137],
            [1182124800000, 330323361],
            [1182211200000, 330631989],
            [1182297600000, 330937927],
            [1182384000000, 331248484],
            [1182470400000, 331597020],
            [1182556800000, 332128481],
            [1182643200000, 332486258],
            [1182729600000, 332656946],
            [1182816000000, 332832534],
            [1182902400000, 332959256],
            [1182988800000, 333091273],
            [1183075200000, 333276391],
            [1183161600000, 333518162],
            [1183248000000, 333693426],
            [1183334400000, 333790022],
            [1183420800000, 333868344],
            [1183507200000, 333969352],
            [1183593600000, 334040730],
            [1183680000000, 334130247],
            [1183766400000, 334250917],
            [1183852800000, 334344283],
            [1183939200000, 334395166],
            [1184025600000, 334440789],
            [1184112000000, 334466962],
            [1184198400000, 334489968],
            [1184284800000, 334639575],
            [1184371200000, 334846460],
            [1184457600000, 335002361],
            [1184544000000, 335073357],
            [1184630400000, 335156910],
            [1184716800000, 335231068],
            [1184803200000, 335310056],
            [1184889600000, 335409799],
            [1184976000000, 335534707],
            [1185062400000, 335625539],
            [1185494400000, 335872316],
            [1185580800000, 335962086],
            [1185667200000, 336027292],
            [1186099200000, 336188395],
            [1186185600000, 336241101],
            [1186272000000, 336279383],
            [1186704000000, 336382092],
            [1186790400000, 336413760],
            [1186876800000, 336436184],
            [1187308800000, 336491472],
            [1187395200000, 336514838],
            [1187481600000, 336530303]
        ],
        name: 'spiderman3',
        showInLegend: false,
        extra: {
            title: 'Spider-Man 3',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#1C1A1C'
        },
        showlabel: false,
        color: 'rgba(28,26,28,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1436486400000, 46042205
            ],
            [1436572800000, 84901740],
            [1436659200000, 115718405],
            [1436745600000, 128664415],
            [1436832000000, 145502830],
            [1436918400000, 157008005],
            [1437004800000, 166491710],
            [1437091200000, 181062890],
            [1437177600000, 201281480],
            [1437264000000, 215766440],
            [1437350400000, 221543540],
            [1437436800000, 229562000],
            [1437523200000, 234735200],
            [1437609600000, 239520410],
            [1437696000000, 246330960],
            [1437782400000, 255337150],
            [1437868800000, 262454370],
            [1437955200000, 265544530],
            [1438041600000, 269549810],
            [1438128000000, 272370765],
            [1438214400000, 275191275],
            [1438300800000, 278819900],
            [1438387200000, 283789150],
            [1438473600000, 287578650],
            [1438560000000, 289580495],
            [1438646400000, 291957870],
            [1438732800000, 293709620],
            [1438819200000, 295354120],
            [1438905600000, 297571150],
            [1438992000000, 300570370],
            [1439078400000, 302803140],
            [1439164800000, 303911805],
            [1439251200000, 305769990],
            [1439337600000, 306831810],
            [1439424000000, 307768710],
            [1439510400000, 309207510],
            [1439596800000, 311359215],
            [1439683200000, 312916835],
            [1439769600000, 313655040],
            [1439856000000, 314724685],
            [1439942400000, 315516675],
            [1440028800000, 316255325],
            [1440115200000, 317346065],
            [1440201600000, 318926525],
            [1440288000000, 320084045],
            [1440374400000, 320518115],
            [1440460800000, 321108005],
            [1440547200000, 321520530],
            [1440633600000, 321880590],
            [1440720000000, 322552430],
            [1440806400000, 323876350],
            [1440892800000, 324755670],
            [1440979200000, 325052310],
            [1441065600000, 325377915],
            [1441152000000, 325624740],
            [1441238400000, 325871460],
            [1441324800000, 326488720],
            [1441411200000, 327644900],
            [1441497600000, 328839955],
            [1441584000000, 329774550],
            [1441670400000, 329909440],
            [1441756800000, 329996155],
            [1441843200000, 330073195],
            [1441929600000, 330342645],
            [1442016000000, 331118615],
            [1442102400000, 331586135],
            [1442188800000, 331681250],
            [1442275200000, 331753300],
            [1442361600000, 331815930],
            [1442448000000, 331863705],
            [1442534400000, 332050815],
            [1442620800000, 332561115],
            [1442707200000, 332850665],
            [1442793600000, 332896175],
            [1442880000000, 332952765],
            [1442966400000, 333032145],
            [1443052800000, 333083175],
            [1443139200000, 333189645],
            [1443225600000, 333405120],
            [1443312000000, 333519195],
            [1443398400000, 333539700],
            [1443484800000, 333562515],
            [1443571200000, 333582795],
            [1443657600000, 333600540],
            [1443744000000, 333664140],
            [1443830400000, 333824465],
            [1443916800000, 333909265],
            [1444003200000, 333923840],
            [1444089600000, 333941065],
            [1444176000000, 333954315],
            [1444262400000, 333970210],
            [1444348800000, 334034805],
            [1444435200000, 334148500],
            [1444521600000, 334215500],
            [1444608000000, 334254595],
            [1444694400000, 334269775],
            [1444780800000, 334283615],
            [1444867200000, 334303855],
            [1444953600000, 334371895],
            [1445040000000, 334480030],
            [1445126400000, 334544425],
            [1445212800000, 334560220],
            [1445299200000, 334574800],
            [1445385600000, 334588050],
            [1445472000000, 334601455],
            [1445558400000, 334648810],
            [1445644800000, 334743520],
            [1445731200000, 334798960],
            [1445817600000, 334811765],
            [1445904000000, 334824480],
            [1445990400000, 334837075],
            [1446076800000, 334849695],
            [1446163200000, 334888305],
            [1446249600000, 334933935],
            [1446336000000, 334992380],
            [1446422400000, 335007535],
            [1446508800000, 335025085],
            [1446595200000, 335036900],
            [1446681600000, 335049770],
            [1446768000000, 335092895],
            [1446854400000, 335189475],
            [1446940800000, 335243940],
            [1447027200000, 335254055],
            [1447113600000, 335267580],
            [1447200000000, 335315360],
            [1447286400000, 335326710],
            [1447372800000, 335362700],
            [1447459200000, 335440945],
            [1447545600000, 335485230],
            [1447632000000, 335493570],
            [1447718400000, 335501715],
            [1447804800000, 335509020],
            [1447891200000, 335517165],
            [1447977600000, 335540840],
            [1448064000000, 335598220],
            [1448150400000, 335632780],
            [1448236800000, 335650110],
            [1448323200000, 335673715],
            [1448409600000, 335702495],
            [1448496000000, 335715935],
            [1448582400000, 335765230],
            [1448668800000, 335819690],
            [1448755200000, 335846465],
            [1448841600000, 335852520],
            [1448928000000, 335856845],
            [1449014400000, 335861250],
            [1449100800000, 335865645],
            [1449187200000, 335881710],
            [1449273600000, 335922550],
            [1449360000000, 335947255],
            [1449446400000, 335952005],
            [1449532800000, 335957710],
            [1449619200000, 335962485],
            [1449705600000, 335968155],
            [1449792000000, 335980160],
            [1449878400000, 336009820],
            [1449964800000, 336029560],
            [1450051200000, 336033085],
            [1450137600000, 336037315],
            [1450224000000, 336041500],
            [1450310400000, 336045770]
        ],
        name: 'minions',
        showInLegend: false,
        extra: {
            title: 'Minions',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#EDEADD'
        },
        showlabel: false,
        color: 'rgba(237,234,221,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1267747200000, 40804962
            ],
            [1267833600000, 85014035],
            [1267920000000, 116101023],
            [1268006400000, 125109453],
            [1268092800000, 133085561],
            [1268179200000, 139858359],
            [1268265600000, 146625356],
            [1268352000000, 163906691],
            [1268438400000, 190803629],
            [1268524800000, 209339432],
            [1268611200000, 215393542],
            [1268697600000, 221403614],
            [1268784000000, 226120535],
            [1268870400000, 231243668],
            [1268956800000, 241059300],
            [1269043200000, 255505533],
            [1269129600000, 265433637],
            [1269216000000, 268193975],
            [1269302400000, 270876890],
            [1269388800000, 273253011],
            [1269475200000, 275827077],
            [1269561600000, 280743590],
            [1269648000000, 288177701],
            [1269734400000, 293534935],
            [1269820800000, 295513657],
            [1269907200000, 297550891],
            [1269993600000, 299459690],
            [1270080000000, 301525693],
            [1270166400000, 304535869],
            [1270252800000, 307678639],
            [1270339200000, 309733753],
            [1270425600000, 310965601],
            [1270512000000, 311922801],
            [1270598400000, 312796786],
            [1270684800000, 313707788],
            [1270771200000, 315338811],
            [1270857600000, 317601189],
            [1270944000000, 319009518],
            [1271030400000, 319380754],
            [1271116800000, 319774453],
            [1271203200000, 320120369],
            [1271289600000, 320474859],
            [1271376000000, 321400968],
            [1271462400000, 323093546],
            [1271548800000, 324131301],
            [1271635200000, 324412674],
            [1271721600000, 324721612],
            [1271808000000, 324989710],
            [1271894400000, 325272926],
            [1271980800000, 325860649],
            [1272067200000, 326866751],
            [1272153600000, 327537023],
            [1272240000000, 327711455],
            [1272326400000, 327899227],
            [1272412800000, 328052376],
            [1272499200000, 328208441],
            [1272585600000, 328603162],
            [1272672000000, 329276207],
            [1272758400000, 329686666],
            [1272844800000, 329804952],
            [1272931200000, 329925996],
            [1273017600000, 330035358],
            [1273104000000, 330145228],
            [1273190400000, 330306009],
            [1273276800000, 330588436],
            [1273363200000, 330857949],
            [1273449600000, 330915607],
            [1273536000000, 330976851],
            [1273622400000, 331034946],
            [1273708800000, 331093713],
            [1273795200000, 331206928],
            [1273881600000, 331411227],
            [1273968000000, 331533915],
            [1274054400000, 331573472],
            [1274140800000, 331622148],
            [1274227200000, 331666065],
            [1274313600000, 331709509],
            [1274400000000, 331836854],
            [1274486400000, 332046831],
            [1274572800000, 332194266],
            [1274659200000, 332254082],
            [1274745600000, 332316522],
            [1274832000000, 332370579],
            [1274918400000, 332430200]
        ],
        name: 'aliceinwonderland10',
        showInLegend: false,
        extra: {
            title: 'Alice in Wonderland (2010)',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#7A7769'
        },
        showlabel: false,
        color: 'rgba(122,119,105,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1406851200000, 37845336
            ],
            [1406937600000, 68835193],
            [1407024000000, 94320883],
            [1407110400000, 106043239],
            [1407196800000, 117951060],
            [1407283200000, 126759442],
            [1407369600000, 134390839],
            [1407456000000, 146703522],
            [1407542400000, 163650634],
            [1407628800000, 176515761],
            [1407715200000, 181859666],
            [1407801600000, 188469200],
            [1407888000000, 193319081],
            [1407974400000, 197545821],
            [1408060800000, 204486397],
            [1408147200000, 214840279],
            [1408233600000, 222661385],
            [1408320000000, 225546287],
            [1408406400000, 229057703],
            [1408492800000, 231680832],
            [1408579200000, 234253857],
            [1408665600000, 239072406],
            [1408752000000, 246553294],
            [1408838400000, 251456069],
            [1408924800000, 253118471],
            [1409011200000, 255227773],
            [1409097600000, 256734812],
            [1409184000000, 258297268],
            [1409270400000, 262143691],
            [1409356800000, 268363965],
            [1409443200000, 275379530],
            [1409529600000, 281204119],
            [1409616000000, 282592034],
            [1409702400000, 283566704],
            [1409788800000, 284407854],
            [1409875200000, 287115133],
            [1409961600000, 292165484],
            [1410048000000, 294765199],
            [1410134400000, 295486958],
            [1410220800000, 296428705],
            [1410307200000, 297157587],
            [1410393600000, 297884832],
            [1410480000000, 299998997],
            [1410566400000, 303904198],
            [1410652800000, 305987190],
            [1410739200000, 306566055],
            [1410825600000, 307344958],
            [1410912000000, 307931409],
            [1410998400000, 308489031],
            [1411084800000, 309871852],
            [1411171200000, 312347805],
            [1411257600000, 313731317],
            [1411344000000, 314095356],
            [1411430400000, 314543546],
            [1411516800000, 314926408],
            [1411603200000, 315403275],
            [1411689600000, 316428277],
            [1411776000000, 318199811],
            [1411862400000, 319169216],
            [1411948800000, 319453527],
            [1412035200000, 319794624],
            [1412121600000, 320068353],
            [1412208000000, 320326404],
            [1412294400000, 321127936],
            [1412380800000, 322589442],
            [1412467200000, 323331487],
            [1412553600000, 323545823],
            [1412640000000, 323816724],
            [1412726400000, 324045645],
            [1412812800000, 324269904],
            [1412899200000, 324774109],
            [1412985600000, 325592520],
            [1413072000000, 326094767],
            [1413158400000, 326404453],
            [1413244800000, 326565358],
            [1413331200000, 326708491],
            [1413417600000, 326832731],
            [1413504000000, 327113437],
            [1413590400000, 327565272],
            [1413676800000, 327792643],
            [1413763200000, 327871720],
            [1413849600000, 327954942],
            [1413936000000, 328025796],
            [1414022400000, 328095589]
        ],
        name: 'marvel2014a',
        showInLegend: false,
        extra: {
            title: 'Guardians of the Galaxy',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#454451'
        },
        showlabel: false,
        color: 'rgba(69,68,81,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1455235200000, 47335592
            ],
            [1455321600000, 89843617],
            [1455408000000, 132434639],
            [1455494400000, 152193853],
            [1455580800000, 163753459],
            [1455667200000, 172371048],
            [1455753600000, 180394887],
            [1455840000000, 196612895],
            [1455926400000, 220904669],
            [1456012800000, 236865054],
            [1456099200000, 241330567],
            [1456185600000, 246489373],
            [1456272000000, 250285148],
            [1456358400000, 254139009],
            [1456444800000, 263018288],
            [1456531200000, 277179070],
            [1456617600000, 285254204],
            [1456704000000, 287585111],
            [1456790400000, 290439707],
            [1456876800000, 292654249],
            [1456963200000, 294758132],
            [1457049600000, 299450814],
            [1457136000000, 306791134],
            [1457222400000, 311484061],
            [1457308800000, 312912129],
            [1457395200000, 314584172],
            [1457481600000, 315915561],
            [1457568000000, 317277425],
            [1457654400000, 320279046],
            [1457740800000, 325108725],
            [1457827200000, 328219729]
        ],
        name: 'deadpool2016',
        showInLegend: false,
        extra: {
            title: 'Deadpool',
            genre: 'Action',

            mpaaRating: 'R',
            imgMainColor: '#91717B'
        },
        showlabel: false,
        color: 'rgba(145,113,123,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1179360000000, 907339
            ],
            [1179446400000, 39334330],
            [1179532800000, 86411827],
            [1179619200000, 122536609],
            [1179705600000, 132168748],
            [1179792000000, 138706832],
            [1179878400000, 144478827],
            [1179964800000, 150338458],
            [1180051200000, 164551485],
            [1180137600000, 185178621],
            [1180224000000, 203378450],
            [1180310400000, 217348470],
            [1180396800000, 220983194],
            [1180483200000, 224426248],
            [1180569600000, 227906792],
            [1180656000000, 235262860],
            [1180742400000, 246730424],
            [1180828800000, 255927783],
            [1180915200000, 258553839],
            [1181001600000, 261139048],
            [1181088000000, 263640920],
            [1181174400000, 266142451],
            [1181260800000, 270565362],
            [1181347200000, 277048810],
            [1181433600000, 281460065],
            [1181520000000, 283095177],
            [1181606400000, 284781832],
            [1181692800000, 286485097],
            [1181779200000, 288242056],
            [1181865600000, 290920945],
            [1181952000000, 294435731],
            [1182038400000, 297245100],
            [1182124800000, 298399656],
            [1182211200000, 299663175],
            [1182297600000, 300965639],
            [1182384000000, 302154854],
            [1182470400000, 303906766],
            [1182556800000, 306214081],
            [1182643200000, 307807439],
            [1182729600000, 308617678],
            [1182816000000, 309452117],
            [1182902400000, 310249415],
            [1182988800000, 311065826],
            [1183075200000, 311927785],
            [1183161600000, 312967570],
            [1183248000000, 313739703],
            [1183334400000, 314132750],
            [1183420800000, 314434910],
            [1183507200000, 314858394],
            [1183593600000, 315202414],
            [1183680000000, 315686319],
            [1183766400000, 316285305],
            [1183852800000, 316740255],
            [1183939200000, 316959197],
            [1184025600000, 317180922],
            [1184112000000, 317300242],
            [1184198400000, 317417794],
            [1184284800000, 317615864],
            [1184371200000, 317883407],
            [1184457600000, 318079835],
            [1184544000000, 318172378],
            [1184630400000, 318288853],
            [1184716800000, 318418262],
            [1184803200000, 318553830],
            [1184889600000, 318676286],
            [1184976000000, 318831933],
            [1185062400000, 318937940],
            [1185148800000, 319005061],
            [1185235200000, 319077033],
            [1185321600000, 319136527],
            [1185408000000, 319201132],
            [1185494400000, 319395151],
            [1185580800000, 319655303],
            [1185667200000, 319835929],
            [1185753600000, 319927736],
            [1185840000000, 320035124],
            [1185926400000, 320140817],
            [1186012800000, 320246557],
            [1186099200000, 320383479],
            [1186185600000, 320564279],
            [1186272000000, 320706665],
            [1186358400000, 320780150],
            [1186444800000, 320862509],
            [1186531200000, 320938145],
            [1186617600000, 321012359]
        ],
        name: 'shrek3',
        showInLegend: false,
        extra: {
            title: 'Shrek the Third',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#93A9A4'
        },
        showlabel: false,
        color: 'rgba(147,169,164,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1183334400000, 8801025
            ],
            [1183420800000, 36652041],
            [1183507200000, 65725939],
            [1183593600000, 84903028],
            [1183680000000, 107559448],
            [1183766400000, 133261287],
            [1183852800000, 155405412],
            [1183939200000, 165333052],
            [1184025600000, 173586828],
            [1184112000000, 180589886],
            [1184198400000, 186981682],
            [1184284800000, 197813608],
            [1184371200000, 212308683],
            [1184457600000, 224009583],
            [1184544000000, 228950080],
            [1184630400000, 233693904],
            [1184716800000, 238202379],
            [1184803200000, 242463503],
            [1184889600000, 248561249],
            [1184976000000, 256587821],
            [1185062400000, 262978000],
            [1185148800000, 265802674],
            [1185235200000, 268416682],
            [1185321600000, 270721514],
            [1185408000000, 273034005],
            [1185494400000, 276334484],
            [1185580800000, 281002278],
            [1185667200000, 284677134],
            [1185753600000, 286203726],
            [1185840000000, 287614487],
            [1185926400000, 288974026],
            [1186012800000, 290357856],
            [1186099200000, 292043529],
            [1186185600000, 294441536],
            [1186272000000, 296379328],
            [1186358400000, 297314158],
            [1186444800000, 298142217],
            [1186531200000, 298897881],
            [1186617600000, 299633598],
            [1186704000000, 300560008],
            [1186790400000, 301849828],
            [1186876800000, 302869658],
            [1186963200000, 303299935],
            [1187049600000, 303719648],
            [1187136000000, 304126202],
            [1187222400000, 304539823],
            [1187308800000, 305062376],
            [1187395200000, 305857444],
            [1187481600000, 306487922],
            [1187568000000, 306746846],
            [1187654400000, 306996948],
            [1187740800000, 307223485],
            [1187827200000, 307448289],
            [1187913600000, 307766814],
            [1188000000000, 308259664],
            [1188086400000, 308597165],
            [1188172800000, 308714893],
            [1188259200000, 308831640],
            [1188345600000, 308934291],
            [1188432000000, 309034150],
            [1188518400000, 309280224],
            [1188604800000, 309715188],
            [1188691200000, 310182848],
            [1188777600000, 310578372],
            [1188864000000, 310651240],
            [1188950400000, 310713745],
            [1189036800000, 310776218],
            [1189123200000, 310928333],
            [1189209600000, 311210407],
            [1189296000000, 311381546],
            [1189382400000, 311421339],
            [1189468800000, 311463962],
            [1189555200000, 311504976],
            [1189641600000, 311550690],
            [1189728000000, 311677317],
            [1189814400000, 311900540],
            [1189900800000, 312024658],
            [1189987200000, 312055459],
            [1190073600000, 312086344],
            [1190160000000, 312118506],
            [1190246400000, 312151771],
            [1190332800000, 312520557],
            [1190419200000, 313184339],
            [1190505600000, 313588051],
            [1190592000000, 313684385],
            [1190678400000, 313780217],
            [1190764800000, 313875988],
            [1190851200000, 313974288],
            [1190937600000, 314274835],
            [1191024000000, 314828507],
            [1191110400000, 315175018],
            [1191196800000, 315262482],
            [1191283200000, 315360074],
            [1191369600000, 315450527],
            [1191456000000, 315542821],
            [1191542400000, 315776364],
            [1191628800000, 316185864],
            [1191715200000, 316476438],
            [1191801600000, 316609842],
            [1191888000000, 316688685],
            [1191974400000, 316765688],
            [1192060800000, 316848897],
            [1192147200000, 317045715],
            [1192233600000, 317384163],
            [1192320000000, 317601309],
            [1192406400000, 317667377],
            [1192492800000, 317725024],
            [1192579200000, 317782628],
            [1192665600000, 317846471],
            [1192752000000, 317982396],
            [1192838400000, 318204072],
            [1192924800000, 318326165],
            [1193011200000, 318359211],
            [1193097600000, 318394920],
            [1193184000000, 318427999],
            [1193270400000, 318468407],
            [1193356800000, 318542827],
            [1193443200000, 318676679],
            [1193529600000, 318759914],
            [1193616000000, 318781032],
            [1193702400000, 318801116],
            [1193788800000, 318821775],
            [1193875200000, 318843396],
            [1193961600000, 318885138],
            [1194048000000, 318970676],
            [1194134400000, 319014499],
            [1194220800000, 319026190],
            [1194307200000, 319041524],
            [1194393600000, 319055891],
            [1194480000000, 319071806]
        ],
        name: 'transformers06',
        showInLegend: false,
        extra: {
            title: 'Transformers',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#644036'
        },
        showlabel: false,
        color: 'rgba(100,64,54,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1209600000000, 3500000
            ],
            [1209686400000, 38734361],
            [1209772800000, 76084460],
            [1209859200000, 102118668],
            [1209945600000, 109053236],
            [1210032000000, 115559020],
            [1210118400000, 121306364],
            [1210204800000, 126634395],
            [1210291200000, 141507587],
            [1210377600000, 162882216],
            [1210464000000, 177825024],
            [1210550400000, 181675868],
            [1210636800000, 185033014],
            [1210723200000, 188116002],
            [1210809600000, 191285389],
            [1210896000000, 199944628],
            [1210982400000, 213375983],
            [1211068800000, 223124385],
            [1211155200000, 226196567],
            [1211241600000, 228416495],
            [1211328000000, 230342753],
            [1211414400000, 232167416],
            [1211500800000, 237604542],
            [1211587200000, 245503384],
            [1211673600000, 252614669],
            [1211760000000, 258278546],
            [1211846400000, 259839619],
            [1211932800000, 261235207],
            [1212019200000, 262625072],
            [1212105600000, 266408309],
            [1212192000000, 272476435],
            [1212278400000, 276166336],
            [1212364800000, 277397055],
            [1212451200000, 278733064],
            [1212537600000, 280045742],
            [1212624000000, 281370201],
            [1212710400000, 283557530],
            [1212796800000, 286722088],
            [1212883200000, 288847640],
            [1212969600000, 289741611],
            [1213056000000, 290601389],
            [1213142400000, 291459326],
            [1213228800000, 292297954],
            [1213315200000, 293764080],
            [1213401600000, 295883267],
            [1213488000000, 297918329],
            [1213574400000, 298639217],
            [1213660800000, 299319470],
            [1213747200000, 300042790],
            [1213833600000, 300785869],
            [1213920000000, 301916400],
            [1214006400000, 303561186],
            [1214092800000, 304816141],
            [1214179200000, 305369088],
            [1214265600000, 305881416],
            [1214352000000, 306384581],
            [1214438400000, 306922205],
            [1214524800000, 307559158],
            [1214611200000, 308487809],
            [1214697600000, 309179318],
            [1214784000000, 309516225],
            [1214870400000, 309760401],
            [1214956800000, 309954481],
            [1215043200000, 310248520],
            [1215129600000, 310653809],
            [1215216000000, 311281305],
            [1215302400000, 311708133],
            [1215388800000, 311898804],
            [1215475200000, 312090570],
            [1215561600000, 312284414],
            [1215648000000, 312481891],
            [1215734400000, 312748436],
            [1215820800000, 313141743],
            [1215907200000, 313421025],
            [1215993600000, 313547131],
            [1216080000000, 313671653],
            [1216166400000, 313804568],
            [1216252800000, 313925130],
            [1216339200000, 314066705],
            [1216425600000, 314256674],
            [1216512000000, 314376968],
            [1216598400000, 314432189],
            [1216684800000, 314489281],
            [1216771200000, 314551977],
            [1216857600000, 314615301],
            [1216944000000, 314707473],
            [1217030400000, 314835082],
            [1217116800000, 314925955],
            [1217203200000, 314967980],
            [1217289600000, 315018372],
            [1217376000000, 315064601],
            [1217462400000, 315107589],
            [1217548800000, 315281601],
            [1217635200000, 315515786],
            [1217721600000, 315687768],
            [1217808000000, 315779208],
            [1217894400000, 315873917],
            [1217980800000, 315958428],
            [1218067200000, 316042315],
            [1218153600000, 316165799],
            [1218240000000, 316342881],
            [1218326400000, 316468817],
            [1218412800000, 316528951],
            [1218499200000, 316590841],
            [1218585600000, 316653730],
            [1218672000000, 316717117],
            [1218758400000, 316818769],
            [1218844800000, 316965355],
            [1218931200000, 317058295],
            [1219017600000, 317099466],
            [1219104000000, 317146297],
            [1219190400000, 317189757],
            [1219276800000, 317230110],
            [1219363200000, 317303064],
            [1219449600000, 317409427],
            [1219536000000, 317473452],
            [1219622400000, 317495641],
            [1219708800000, 317521757],
            [1219795200000, 317545933],
            [1219881600000, 317570520],
            [1219968000000, 317620121],
            [1220054400000, 317704761],
            [1220140800000, 317794156],
            [1220227200000, 317847676],
            [1220313600000, 317858838],
            [1220400000000, 317869143],
            [1220486400000, 317880036],
            [1220572800000, 317915421],
            [1220659200000, 317977386],
            [1220745600000, 318006770],
            [1220832000000, 318013962],
            [1220918400000, 318022539],
            [1221004800000, 318030804],
            [1221091200000, 318039924],
            [1221177600000, 318066027],
            [1221264000000, 318112815],
            [1221350400000, 318134740],
            [1221436800000, 318140292],
            [1221523200000, 318146675],
            [1221609600000, 318153372],
            [1221696000000, 318160117],
            [1221782400000, 318175773],
            [1221868800000, 318203593],
            [1221955200000, 318219154],
            [1222041600000, 318223785],
            [1222128000000, 318229516],
            [1222214400000, 318234471],
            [1222300800000, 318239816],
            [1222387200000, 318256758],
            [1222473600000, 318285594],
            [1222560000000, 318298180],
            [1222646400000, 318301917],
            [1222732800000, 318305950],
            [1222819200000, 318309405],
            [1222905600000, 318313199],
            [1273104000000, 318604126]
        ],
        name: 'ironman',
        showInLegend: false,
        extra: {
            title: 'Iron Man',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#28242B'
        },
        showlabel: false,
        color: 'rgba(40,36,43,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1005868800000, 32333203
            ],
            [1005955200000, 65846144],
            [1006041600000, 90294621],
            [1006128000000, 96937323],
            [1006214400000, 104590892],
            [1006300800000, 117232892],
            [1006387200000, 129490758],
            [1006473600000, 152477758],
            [1006560000000, 173565758],
            [1006646400000, 186978513],
            [1006732800000, 189504513],
            [1006819200000, 191887513],
            [1006905600000, 193953513],
            [1006992000000, 196027962],
            [1007078400000, 202109962],
            [1007164800000, 212628962],
            [1007251200000, 219670289],
            [1007337600000, 220931289],
            [1007424000000, 222342289],
            [1007510400000, 223647289],
            [1007596800000, 224921846],
            [1007683200000, 228716846],
            [1007769600000, 235325846],
            [1007856000000, 239659542],
            [1007942400000, 240527542],
            [1008028800000, 241558542],
            [1008115200000, 242447542],
            [1008201600000, 243349983],
            [1008288000000, 245633983],
            [1008374400000, 250162983],
            [1008460800000, 253269579],
            [1008547200000, 254081579],
            [1008633600000, 255003579],
            [1008720000000, 255914579],
            [1008806400000, 257003050],
            [1008892800000, 258756050],
            [1008979200000, 261393050],
            [1009065600000, 264095956],
            [1009152000000, 265814956],
            [1009238400000, 267750733],
            [1009324800000, 271143733],
            [1009411200000, 274655414],
            [1009497600000, 278281414],
            [1009584000000, 282122414],
            [1009670400000, 285634174],
            [1009756800000, 288516174],
            [1009843200000, 291594218],
            [1009929600000, 293206218],
            [1010016000000, 294474009],
            [1010102400000, 296178009],
            [1010188800000, 298696009],
            [1010275200000, 300404434],
            [1010361600000, 300739434],
            [1010448000000, 301082434],
            [1010534400000, 301368434],
            [1010620800000, 301637555],
            [1010707200000, 302405555],
            [1010793600000, 304097555],
            [1010880000000, 305311880],
            [1010966400000, 305532880],
            [1011052800000, 305774880],
            [1011139200000, 305988880],
            [1011225600000, 306206530],
            [1011312000000, 306735530],
            [1011398400000, 307810530],
            [1011484800000, 308793051],
            [1011571200000, 309659297],
            [1011657600000, 309848297],
            [1011744000000, 310004297],
            [1011830400000, 310171603],
            [1013990400000, 314320476]
        ],
        name: 'harrypotter',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Sorcerer´s Stone',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#735F4E'
        },
        showlabel: false,
        color: 'rgba(115,95,78,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1211414400000, 25041072
            ],
            [1211500800000, 55612347],
            [1211587200000, 92146186],
            [1211673600000, 125178907],
            [1211760000000, 151958445],
            [1211846400000, 159563051],
            [1211932800000, 165603944],
            [1212019200000, 170881284],
            [1212105600000, 183101562],
            [1212192000000, 202929293],
            [1212278400000, 215635899],
            [1212364800000, 219165676],
            [1212451200000, 223025853],
            [1212537600000, 226664201],
            [1212624000000, 230221120],
            [1212710400000, 236825547],
            [1212796800000, 246400282],
            [1212883200000, 253014750],
            [1212969600000, 255349616],
            [1213056000000, 257620035],
            [1213142400000, 259756424],
            [1213228800000, 261782431],
            [1213315200000, 265534560],
            [1213401600000, 271155355],
            [1213488000000, 276524265],
            [1213574400000, 278017529],
            [1213660800000, 279472621],
            [1213747200000, 280951091],
            [1213833600000, 282420731],
            [1213920000000, 284771419],
            [1214006400000, 288310588],
            [1214092800000, 290961044],
            [1214179200000, 291988244],
            [1214265600000, 292966296],
            [1214352000000, 293891068],
            [1214438400000, 294905487],
            [1214524800000, 296295399],
            [1214611200000, 298488071],
            [1214697600000, 300085447],
            [1214784000000, 300819519],
            [1214870400000, 301394348],
            [1214956800000, 301884941],
            [1215043200000, 302653714],
            [1215129600000, 303774660],
            [1215216000000, 305390802],
            [1215302400000, 306428521],
            [1215388800000, 306868090],
            [1215475200000, 307327977],
            [1215561600000, 307795294],
            [1215648000000, 308227287],
            [1215734400000, 308843993],
            [1215820800000, 309819299],
            [1215907200000, 310487614],
            [1215993600000, 310760256],
            [1216080000000, 311040397],
            [1216166400000, 311330905],
            [1216252800000, 311613615],
            [1216339200000, 311885695],
            [1216425600000, 312298309],
            [1216512000000, 312569461],
            [1216598400000, 312684340],
            [1216684800000, 312809594],
            [1216771200000, 312939492],
            [1216857600000, 313075911],
            [1216944000000, 313233300],
            [1217030400000, 313476586],
            [1217116800000, 313646685],
            [1217203200000, 313719527],
            [1217289600000, 313801986],
            [1217376000000, 313887421],
            [1217462400000, 313972312],
            [1217548800000, 314071066],
            [1217635200000, 314228475],
            [1217721600000, 314331661],
            [1217808000000, 314383595],
            [1217894400000, 314433055],
            [1217980800000, 314475978],
            [1218067200000, 314515278],
            [1218153600000, 314581283],
            [1218240000000, 314681269],
            [1218326400000, 314749809],
            [1218412800000, 314782570],
            [1218499200000, 314819219],
            [1218585600000, 314848652],
            [1218672000000, 314879669],
            [1218758400000, 314933670],
            [1218844800000, 315025397],
            [1218931200000, 315070993],
            [1219017600000, 315089984],
            [1219104000000, 315119373],
            [1219190400000, 315142719],
            [1219276800000, 315168233],
            [1219363200000, 315202821],
            [1219449600000, 315253251],
            [1219536000000, 315286725],
            [1219622400000, 315298268],
            [1219708800000, 315313082],
            [1219795200000, 315325091],
            [1219881600000, 315337154],
            [1219968000000, 315436527],
            [1220054400000, 315586260],
            [1220140800000, 315733805],
            [1220227200000, 315844754],
            [1220313600000, 315873722],
            [1220400000000, 315898859],
            [1220486400000, 315923170],
            [1220572800000, 316002661],
            [1220659200000, 316133355],
            [1220745600000, 316202690],
            [1220832000000, 316220552],
            [1220918400000, 316244191],
            [1221004800000, 316264736],
            [1221091200000, 316286130],
            [1221177600000, 316340470],
            [1221264000000, 316435626],
            [1221350400000, 316489033],
            [1221436800000, 316501166],
            [1221523200000, 316515680],
            [1221609600000, 316529074],
            [1221696000000, 316542583],
            [1221782400000, 316577650],
            [1221868800000, 316637349],
            [1221955200000, 316670320],
            [1222041600000, 316678795],
            [1222128000000, 316689007],
            [1222214400000, 316698965],
            [1222300800000, 316708350],
            [1222387200000, 316751702],
            [1222473600000, 316821417],
            [1222560000000, 316849472],
            [1222646400000, 316856992],
            [1222732800000, 316867229],
            [1222819200000, 316875717],
            [1222905600000, 316884872],
            [1222992000000, 316908269],
            [1223078400000, 316940235],
            [1223164800000, 316957122],
            [1223251200000, 316962180],
            [1223337600000, 316967933],
            [1223424000000, 316973197],
            [1223510400000, 316979453],
            [1223596800000, 316988082],
            [1223683200000, 317001811],
            [1223769600000, 317011114],
            [1223856000000, 317015244],
            [1223942400000, 317017651],
            [1224028800000, 317020471],
            [1224115200000, 317023851]
        ],
        name: 'indianajones4',
        showInLegend: false,
        extra: {
            title: 'Indiana Jones and the Kingdom of the Crystal Skull',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#66482A'
        },
        showlabel: false,
        color: 'rgba(102,72,42,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1008720000000, 18214211
            ],
            [1008806400000, 27917978],
            [1008892800000, 42150919],
            [1008979200000, 59213690],
            [1009065600000, 75129468],
            [1009152000000, 82462416],
            [1009238400000, 94032719],
            [1009324800000, 106146821],
            [1009411200000, 117166830],
            [1009497600000, 129734559],
            [1009584000000, 143733272],
            [1009670400000, 155862412],
            [1009756800000, 163871215],
            [1009843200000, 174119499],
            [1009929600000, 178735912],
            [1010016000000, 182503422],
            [1010102400000, 189286662],
            [1010188800000, 199400725],
            [1010275200000, 205509869],
            [1010361600000, 207220679],
            [1010448000000, 209199151],
            [1010534400000, 210724501],
            [1010620800000, 212119615],
            [1010707200000, 216360664],
            [1010793600000, 223628781],
            [1010880000000, 228320875],
            [1010966400000, 229458069],
            [1011052800000, 230763390],
            [1011139200000, 231848287],
            [1011225600000, 232944803],
            [1011312000000, 236146861],
            [1011398400000, 241181693],
            [1011484800000, 245418551],
            [1011571200000, 248212887],
            [1011657600000, 249125207],
            [1011744000000, 249870396],
            [1011830400000, 250646197],
            [1011916800000, 252650703],
            [1012003200000, 256408014],
            [1012089600000, 258449272],
            [1012176000000, 258972325],
            [1012262400000, 259564736],
            [1012348800000, 260065515],
            [1012435200000, 260569940],
            [1012521600000, 262061227],
            [1012608000000, 265028400],
            [1012694400000, 266274199],
            [1012780800000, 266634660],
            [1012867200000, 267051095],
            [1012953600000, 267426402],
            [1013040000000, 267798522],
            [1013126400000, 268613461],
            [1013212800000, 270287299],
            [1013299200000, 271416919],
            [1013385600000, 271678039],
            [1013472000000, 272009551],
            [1013558400000, 272335213],
            [1013644800000, 272933520],
            [1013731200000, 273982492],
            [1013817600000, 275987527],
            [1013904000000, 277635371],
            [1013990400000, 278643479],
            [1014076800000, 279053435],
            [1014163200000, 279383472],
            [1014249600000, 279733224],
            [1014336000000, 280611371],
            [1014422400000, 282274437],
            [1014508800000, 283191086],
            [1014595200000, 283439555],
            [1014681600000, 283725189],
            [1014768000000, 283980036],
            [1014854400000, 284255274],
            [1014940800000, 285028889],
            [1015027200000, 286550224],
            [1015113600000, 287573505],
            [1015200000000, 287793921],
            [1015286400000, 288015368],
            [1015372800000, 288247249],
            [1015459200000, 288466140],
            [1015545600000, 289117024],
            [1015632000000, 290345822],
            [1015718400000, 291149457],
            [1015804800000, 291397393],
            [1015891200000, 291698724],
            [1015977600000, 291954083],
            [1016064000000, 292225469],
            [1016150400000, 292780505],
            [1016236800000, 293759416],
            [1016323200000, 294343844],
            [1016409600000, 294536807],
            [1016496000000, 294761211],
            [1016582400000, 294959855],
            [1016668800000, 295167094],
            [1016755200000, 295761611],
            [1016841600000, 296898111],
            [1016928000000, 297530963],
            [1017014400000, 297863424],
            [1017100800000, 298214875],
            [1017187200000, 298533623],
            [1017273600000, 298925611],
            [1017360000000, 299815605],
            [1017446400000, 300715498],
            [1017532800000, 301308405],
            [1017619200000, 301626337],
            [1017705600000, 301879336],
            [1017792000000, 302127053],
            [1017878400000, 302376987],
            [1017964800000, 302865287],
            [1018051200000, 303663977],
            [1018137600000, 304117086],
            [1018224000000, 304231971],
            [1018310400000, 304367412],
            [1018396800000, 304482005],
            [1018483200000, 304600196],
            [1018569600000, 304922474],
            [1018656000000, 305493494],
            [1018742400000, 305819565],
            [1018828800000, 305918289],
            [1018915200000, 306026089],
            [1019001600000, 306127295],
            [1019088000000, 306227803],
            [1019174400000, 306428359],
            [1019260800000, 306779401],
            [1019347200000, 306999514],
            [1019433600000, 307069848],
            [1019520000000, 307139232],
            [1019606400000, 307206614],
            [1019692800000, 307280989],
            [1019779200000, 307483063],
            [1019865600000, 307847506],
            [1019952000000, 308078986],
            [1020038400000, 308138976],
            [1020124800000, 308206809],
            [1020211200000, 308270024],
            [1020297600000, 308339923],
            [1020384000000, 308465760],
            [1020470400000, 308676646],
            [1020556800000, 308791984],
            [1020643200000, 308830801],
            [1020729600000, 308876955],
            [1020816000000, 308922997],
            [1020902400000, 308969505],
            [1020988800000, 309088667],
            [1021075200000, 309311604],
            [1021161600000, 309471992],
            [1021248000000, 309525292],
            [1021334400000, 309580527],
            [1021420800000, 309628015],
            [1021507200000, 309667455],
            [1021593600000, 309782946],
            [1021680000000, 309963394],
            [1021766400000, 310078970],
            [1021852800000, 310133112],
            [1021939200000, 310179026],
            [1022025600000, 310222355],
            [1022112000000, 310271162],
            [1022198400000, 310362593],
            [1022284800000, 310504608],
            [1022371200000, 310629729],
            [1022457600000, 310714976],
            [1022544000000, 310748649],
            [1022630400000, 310786475],
            [1022716800000, 310828464],
            [1022803200000, 310886798],
            [1022889600000, 310989427],
            [1022976000000, 311053126],
            [1023062400000, 311081433],
            [1023148800000, 311113397],
            [1023235200000, 311147689],
            [1023321600000, 311184032],
            [1023408000000, 311246222],
            [1023494400000, 311335761],
            [1023580800000, 311407091],
            [1023667200000, 311434605],
            [1023753600000, 311462267],
            [1023840000000, 311492378],
            [1023926400000, 311526299],
            [1024012800000, 311575180],
            [1024099200000, 311646903],
            [1024185600000, 311705137],
            [1024272000000, 311736668],
            [1024358400000, 311771987],
            [1024444800000, 311826109],
            [1024531200000, 311858003],
            [1024617600000, 311902555],
            [1024704000000, 311965843],
            [1024790400000, 312014743],
            [1024876800000, 312040997],
            [1024963200000, 312070162],
            [1025049600000, 312097359],
            [1025136000000, 312125121],
            [1025222400000, 312165571],
            [1025308800000, 312225076],
            [1025395200000, 312274288],
            [1025481600000, 312306244],
            [1025568000000, 312336655],
            [1025654400000, 312366691],
            [1025740800000, 312399410],
            [1025827200000, 312446317],
            [1025913600000, 312502949],
            [1026000000000, 312549779],
            [1026086400000, 312574107],
            [1026172800000, 312599492],
            [1026259200000, 312624038],
            [1026345600000, 312647842],
            [1026432000000, 312679768],
            [1026518400000, 312724952],
            [1026604800000, 312762385],
            [1026691200000, 312785014],
            [1026777600000, 312809420],
            [1026864000000, 312835485],
            [1026950400000, 312858953],
            [1027036800000, 312889746],
            [1027123200000, 312931609],
            [1027209600000, 312965191],
            [1027296000000, 312981725],
            [1027382400000, 312998413],
            [1027468800000, 313014525],
            [1027555200000, 313030186],
            [1027641600000, 313053700],
            [1027728000000, 313085459],
            [1027814400000, 313111364],
            [1027900800000, 313126238],
            [1027987200000, 313141224],
            [1028073600000, 313157022],
            [1028160000000, 313171091],
            [1028246400000, 313191320],
            [1028332800000, 313217919],
            [1028419200000, 313240158],
            [1028505600000, 313252506],
            [1028592000000, 313261753],
            [1028678400000, 313270081],
            [1028764800000, 313278429],
            [1028851200000, 313292105],
            [1028937600000, 313309541],
            [1029024000000, 313322223],
            [1029110400000, 313328131],
            [1029196800000, 313334484],
            [1029283200000, 313340498],
            [1029369600000, 313346080],
            [1029456000000, 313351478],
            [1029542400000, 313359131],
            [1029628800000, 313364114]
        ],
        name: 'fellowshipofthering',
        showInLegend: false,
        extra: {
            title: 'The Lord of the Rings: The Fellowship of the Ring',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#58573F'
        },
        showlabel: true,
        color: 'rgba(88,87,63,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1273190400000, 51239677
            ],
            [1273276800000, 97015847],
            [1273363200000, 128122480],
            [1273449600000, 137489462],
            [1273536000000, 145869697],
            [1273622400000, 152821023],
            [1273708800000, 159159871],
            [1273795200000, 174280820],
            [1273881600000, 196923384],
            [1273968000000, 211200876],
            [1274054400000, 214916361],
            [1274140800000, 218481425],
            [1274227200000, 221626976],
            [1274313600000, 224664803],
            [1274400000000, 232214312],
            [1274486400000, 243719704],
            [1274572800000, 251026061],
            [1274659200000, 253241439],
            [1274745600000, 255051931],
            [1274832000000, 256736686],
            [1274918400000, 258576910],
            [1275004800000, 263017382],
            [1275091200000, 269183356],
            [1275177600000, 275035900],
            [1275264000000, 279653149],
            [1275350400000, 281039167],
            [1275436800000, 282259624],
            [1275523200000, 283511162],
            [1275609600000, 285700361],
            [1275696000000, 289182375],
            [1275782400000, 291429870],
            [1275868800000, 292232099],
            [1275955200000, 293059560],
            [1276041600000, 293907591],
            [1276128000000, 294761184],
            [1276214400000, 296103247],
            [1276300800000, 298039885],
            [1276387200000, 299282390],
            [1276473600000, 299820425],
            [1276560000000, 300331985],
            [1276646400000, 300868500],
            [1276732800000, 301338077],
            [1276819200000, 302053494],
            [1276905600000, 303102635],
            [1276992000000, 304210329],
            [1277078400000, 304553236],
            [1277164800000, 304885151],
            [1277251200000, 305185164],
            [1277337600000, 305507269],
            [1277424000000, 305918235],
            [1277510400000, 306512001],
            [1277596800000, 306943647],
            [1277683200000, 307138110],
            [1277769600000, 307318350],
            [1277856000000, 307493516],
            [1277942400000, 307654463],
            [1278028800000, 307869542],
            [1278115200000, 308112705],
            [1278201600000, 308292777],
            [1278288000000, 308530297],
            [1278374400000, 308636849],
            [1278460800000, 308738470],
            [1278547200000, 308844539],
            [1278633600000, 308966182],
            [1278720000000, 309137177],
            [1278806400000, 309237294],
            [1278892800000, 309290805],
            [1278979200000, 309352020],
            [1279065600000, 309407309],
            [1279152000000, 309456850],
            [1279238400000, 309624997],
            [1279324800000, 309846840],
            [1279411200000, 310018590],
            [1279497600000, 310110316],
            [1279584000000, 310218645],
            [1279670400000, 310309300],
            [1279756800000, 310401849],
            [1279843200000, 310538485],
            [1279929600000, 310716842],
            [1280016000000, 310840824],
            [1280102400000, 310908007],
            [1280188800000, 310982917],
            [1280275200000, 311050651],
            [1280361600000, 311115730],
            [1280448000000, 311207080],
            [1280534400000, 311329563],
            [1280620800000, 311417007],
            [1280707200000, 311465015],
            [1280793600000, 311517683],
            [1280880000000, 311564816],
            [1280966400000, 311612666],
            [1281052800000, 311669468],
            [1281139200000, 311750352],
            [1281225600000, 311806181],
            [1281312000000, 311835512],
            [1281398400000, 311870609],
            [1281484800000, 311900686],
            [1281571200000, 311930555],
            [1281657600000, 311965938],
            [1281744000000, 312019642],
            [1281830400000, 312057433],
            [1281916800000, 312074316],
            [1282003200000, 312093360],
            [1282089600000, 312110161],
            [1282176000000, 312128345]
        ],
        name: 'ironman2',
        showInLegend: false,
        extra: {
            title: 'Iron Man 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#241D1B'
        },
        showlabel: false,
        color: 'rgba(36,29,27,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1021507200000, 30141471
            ],
            [1021593600000, 54546228],
            [1021680000000, 85799846],
            [1021766400000, 110169285],
            [1021852800000, 120829626],
            [1021939200000, 128332422],
            [1022025600000, 134869257],
            [1022112000000, 141305821],
            [1022198400000, 154093786],
            [1022284800000, 172654450],
            [1022371200000, 189186353],
            [1022457600000, 201309770],
            [1022544000000, 204853416],
            [1022630400000, 208049699],
            [1022716800000, 211321947],
            [1022803200000, 216685058],
            [1022889600000, 225836569],
            [1022976000000, 232324823],
            [1023062400000, 234539950],
            [1023148800000, 236818662],
            [1023235200000, 238923113],
            [1023321600000, 241094693],
            [1023408000000, 245003772],
            [1023494400000, 250707632],
            [1023580800000, 255106406],
            [1023667200000, 256589714],
            [1023753600000, 258244390],
            [1023840000000, 259739676],
            [1023926400000, 261313924],
            [1024012800000, 263723368],
            [1024099200000, 267443659],
            [1024185600000, 270752531],
            [1024272000000, 271762477],
            [1024358400000, 272791097],
            [1024444800000, 273751880],
            [1024531200000, 274677737],
            [1024617600000, 276073023],
            [1024704000000, 278180486],
            [1024790400000, 279828766],
            [1024876800000, 280490185],
            [1024963200000, 281192626],
            [1025049600000, 281883659],
            [1025136000000, 282585594],
            [1025222400000, 283568538],
            [1025308800000, 285027870],
            [1025395200000, 286253887],
            [1025481600000, 286908009],
            [1025568000000, 287529188],
            [1025654400000, 288161451],
            [1025740800000, 288846797],
            [1025827200000, 289679958],
            [1025913600000, 290580095],
            [1026000000000, 291297451],
            [1026086400000, 291583739],
            [1026172800000, 291908623],
            [1026259200000, 292217280],
            [1026345600000, 292535701],
            [1026432000000, 292873497],
            [1026518400000, 293401606],
            [1026604800000, 293817458],
            [1026691200000, 293997355],
            [1026777600000, 294202821],
            [1026864000000, 294394508],
            [1026950400000, 294600973],
            [1027036800000, 294884882],
            [1027123200000, 295293202],
            [1027209600000, 295621611],
            [1027296000000, 295766859],
            [1027382400000, 295924864],
            [1027468800000, 296067789],
            [1027555200000, 296205467],
            [1027641600000, 296415550],
            [1027728000000, 296732405],
            [1027814400000, 296976622],
            [1027900800000, 297089980],
            [1027987200000, 297222081],
            [1028073600000, 297348895],
            [1028160000000, 297480553],
            [1028246400000, 297651895],
            [1028332800000, 297898706],
            [1028419200000, 298104876],
            [1028505600000, 298216981],
            [1028592000000, 298322651],
            [1028678400000, 298409275],
            [1028764800000, 298497009],
            [1028851200000, 298596134],
            [1028937600000, 298738398],
            [1029024000000, 298843890],
            [1029110400000, 298896119],
            [1029196800000, 298957139],
            [1029283200000, 299016645],
            [1029369600000, 299075352],
            [1029456000000, 299172246],
            [1029542400000, 299309943],
            [1029628800000, 299401865],
            [1029715200000, 299451901],
            [1029801600000, 299505378],
            [1029888000000, 299550832],
            [1029974400000, 299602121],
            [1030060800000, 299693095],
            [1030147200000, 299830077],
            [1030233600000, 299916358],
            [1030320000000, 299956711],
            [1030406400000, 300001541],
            [1030492800000, 300039401],
            [1030579200000, 300082607],
            [1030665600000, 300198119],
            [1030752000000, 300372586],
            [1030838400000, 300556038],
            [1030924800000, 300669374],
            [1031011200000, 300711690],
            [1031097600000, 300736865],
            [1031184000000, 300769143],
            [1031270400000, 300868386],
            [1031356800000, 301042340],
            [1031443200000, 301131584],
            [1031529600000, 301153647],
            [1031616000000, 301184644],
            [1031702400000, 301210628],
            [1031788800000, 301231528],
            [1031875200000, 301305111],
            [1031961600000, 301426635],
            [1032048000000, 301500502],
            [1032134400000, 301517738],
            [1032220800000, 301539831],
            [1032307200000, 301559423],
            [1032393600000, 301575569],
            [1032480000000, 301629762],
            [1032566400000, 301722126],
            [1032652800000, 301765141],
            [1032739200000, 301777922],
            [1032825600000, 301792673],
            [1032912000000, 301803830],
            [1032998400000, 301814586],
            [1033084800000, 301844770],
            [1033171200000, 301894160],
            [1033257600000, 301921139],
            [1033344000000, 301930941],
            [1033430400000, 301938424],
            [1033516800000, 301945521],
            [1033603200000, 301952557],
            [1033689600000, 301976746],
            [1033776000000, 302014630],
            [1033862400000, 302036290],
            [1033948800000, 302043428],
            [1034035200000, 302050408],
            [1034121600000, 302057316],
            [1034208000000, 302063822],
            [1034294400000, 302074722],
            [1034380800000, 302093611],
            [1034467200000, 302105639],
            [1034553600000, 302111585],
            [1034640000000, 302116635],
            [1034726400000, 302121145],
            [1034812800000, 302125666],
            [1034899200000, 302134096],
            [1034985600000, 302147904],
            [1035072000000, 302155373],
            [1035158400000, 302158244],
            [1035244800000, 302162407],
            [1035331200000, 302165315],
            [1035417600000, 302167664],
            [1035504000000, 302172048],
            [1035590400000, 302177962],
            [1035676800000, 302181179],
            [1035763200000, 302181962],
            [1035849600000, 302182787],
            [1035936000000, 302183567],
            [1036022400000, 302184643],
            [1036108800000, 302186553],
            [1036195200000, 302189606],
            [1036281600000, 302191252]
        ],
        name: 'starwars2',
        showInLegend: false,
        extra: {
            title: 'Star Wars: Episode II - Attack of the Clones',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#2B1A14'
        },
        showlabel: false,
        color: 'rgba(43,26,20,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1179964800000, 13240044
            ],
            [1180051200000, 56150436],
            [1180137600000, 93851487],
            [1180224000000, 127972864],
            [1180310400000, 153042234],
            [1180396800000, 160831171],
            [1180483200000, 167236619],
            [1180569600000, 173339068],
            [1180656000000, 186157549],
            [1180742400000, 204031150],
            [1180828800000, 217545728],
            [1180915200000, 221696526],
            [1181001600000, 225491113],
            [1181088000000, 228969881],
            [1181174400000, 232297818],
            [1181260800000, 238464654],
            [1181347200000, 247400459],
            [1181433600000, 253441723],
            [1181520000000, 255610936],
            [1181606400000, 257687300],
            [1181692800000, 259697522],
            [1181779200000, 261733724],
            [1181865600000, 264956639],
            [1181952000000, 270127127],
            [1182038400000, 274145510],
            [1182124800000, 275607610],
            [1182211200000, 277050417],
            [1182297600000, 278455146],
            [1182384000000, 279799630],
            [1182470400000, 281873078],
            [1182556800000, 284813425],
            [1182643200000, 287001716],
            [1182729600000, 287984700],
            [1182816000000, 288951288],
            [1182902400000, 289838885],
            [1182988800000, 290742707],
            [1183075200000, 292240304],
            [1183161600000, 294223884],
            [1183248000000, 295703075],
            [1183334400000, 296454390],
            [1183420800000, 297184648],
            [1183507200000, 298013394],
            [1183593600000, 298716729],
            [1183680000000, 299675597],
            [1183766400000, 300870959],
            [1183852800000, 301725691],
            [1183939200000, 302156352],
            [1184025600000, 302562030],
            [1184112000000, 302822845],
            [1184198400000, 303057674],
            [1184284800000, 303459754],
            [1184371200000, 304054987],
            [1184457600000, 304454423],
            [1184544000000, 304641560],
            [1184630400000, 304852581],
            [1184716800000, 305073625],
            [1184803200000, 305304399],
            [1184889600000, 305529295],
            [1184976000000, 305828180],
            [1185062400000, 306034458],
            [1185148800000, 306145052],
            [1185235200000, 306263273],
            [1185321600000, 306371841],
            [1185408000000, 306483088]
        ],
        name: 'piratesofthecaribbean3',
        showInLegend: false,
        extra: {
            title: 'Pirates of the Caribbean: At World´s End',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#A5A9B1'
        },
        showlabel: false,
        color: 'rgba(165,169,177,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                422668800000, 6219629
            ],
            [422755200000, 10640780],
            [422841600000, 17077785],
            [422928000000, 25220293],
            [423014400000, 33660398],
            [423100800000, 41131399],
            [423187200000, 45311004],
            [423273600000, 49147393],
            [423360000000, 52910693],
            [423446400000, 57995112],
            [423532800000, 64841280],
            [423619200000, 70040387]
        ],
        name: 'starwars6',
        showInLegend: false,
        extra: {
            title: 'Return of the Jedi',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#454952'
        },
        showlabel: false,
        color: 'rgba(69,73,82,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                836265600000, 11124456
            ],
            [836352000000, 28530600],
            [836438400000, 45873988],
            [836524800000, 63619859],
            [836611200000, 81526839],
            [836697600000, 96102252],
            [836784000000, 104327633],
            [836870400000, 112075619],
            [836956800000, 118882629],
            [837043200000, 125070007],
            [837129600000, 135372640],
            [837216000000, 150092784],
            [837302400000, 160312716],
            [837388800000, 165242033],
            [837475200000, 169888490],
            [837561600000, 173838942],
            [837648000000, 177729552],
            [837734400000, 183977018],
            [837820800000, 192848503],
            [837907200000, 199004369],
            [837993600000, 201680625],
            [838080000000, 204619850],
            [838166400000, 206987937],
            [838252800000, 209315796],
            [838339200000, 213304054],
            [838425600000, 219081108],
            [838512000000, 223114893],
            [838598400000, 224939686],
            [838684800000, 227091708],
            [838771200000, 228992170],
            [838857600000, 230877807],
            [838944000000, 234018648],
            [839030400000, 238713751],
            [839116800000, 241874121],
            [839203200000, 243377547],
            [839289600000, 244978607],
            [839376000000, 246465076],
            [839462400000, 248075387],
            [839548800000, 250668099],
            [839635200000, 254309803],
            [839721600000, 256756659],
            [839808000000, 257890467],
            [839894400000, 259195258],
            [839980800000, 260158223],
            [840067200000, 261152823],
            [840153600000, 262844845],
            [840240000000, 265348200],
            [840326400000, 266963804],
            [840412800000, 267663226],
            [840499200000, 268454375],
            [840585600000, 269121565],
            [840672000000, 269765528],
            [840758400000, 271135132],
            [840844800000, 273274156],
            [840931200000, 274504698],
            [841017600000, 274987630],
            [841104000000, 275522137],
            [841190400000, 275976438],
            [841276800000, 276400038],
            [841363200000, 277446078],
            [841449600000, 279179861],
            [841536000000, 280766972],
            [841622400000, 281937276],
            [841708800000, 282253261],
            [841795200000, 282511776],
            [841881600000, 282772244],
            [841968000000, 283526156],
            [842054400000, 284887396],
            [842140800000, 285620448],
            [842227200000, 285796384],
            [842313600000, 286007045],
            [842400000000, 286193535],
            [842486400000, 286380877],
            [842572800000, 286922501],
            [842659200000, 287934743],
            [842745600000, 288445301],
            [842832000000, 288584758],
            [842918400000, 288746103],
            [843004800000, 288882820],
            [843091200000, 289013251],
            [843177600000, 289413006],
            [843264000000, 290178537],
            [843350400000, 290605002],
            [843436800000, 290728315],
            [843523200000, 290848155],
            [843609600000, 290957159],
            [843696000000, 291066712],
            [843782400000, 291668729],
            [843868800000, 293063270],
            [843955200000, 293617050],
            [844041600000, 293769650],
            [844128000000, 293935887],
            [844214400000, 294088865],
            [844300800000, 294249633],
            [844387200000, 294671649],
            [844473600000, 295322301],
            [844560000000, 295730534],
            [844646400000, 295828008],
            [844732800000, 295937119],
            [844819200000, 296032463],
            [844905600000, 296136850],
            [844992000000, 296498152],
            [845078400000, 297037832],
            [845164800000, 297433529],
            [845251200000, 297576603],
            [845337600000, 297682856],
            [845424000000, 297775308],
            [845510400000, 297868700],
            [845596800000, 298243419],
            [845683200000, 298835529],
            [845769600000, 299213307],
            [845856000000, 299320102],
            [845942400000, 299431580],
            [846028800000, 299543526],
            [846115200000, 299663286],
            [846201600000, 300012195],
            [846288000000, 300515804],
            [846374400000, 300880790],
            [846460800000, 300976256],
            [846547200000, 301072525],
            [846633600000, 301162259],
            [846720000000, 301277435],
            [846806400000, 301544357],
            [846892800000, 301990137],
            [846979200000, 302279158],
            [847065600000, 302361863],
            [847152000000, 302456009],
            [847238400000, 302559882],
            [847324800000, 302646582],
            [847411200000, 302914872],
            [847497600000, 303321818],
            [847584000000, 303624796],
            [847670400000, 303765283],
            [847756800000, 303842991],
            [847843200000, 303917484],
            [847929600000, 303993137],
            [848016000000, 304197904],
            [848102400000, 304522020],
            [848188800000, 304738610],
            [848275200000, 304801306],
            [848361600000, 304867542],
            [848448000000, 304933756],
            [848534400000, 304995909],
            [848620800000, 305111670],
            [848707200000, 305298852],
            [848793600000, 305400802],
            [848880000000, 305437950],
            [848966400000, 305480542],
            [849052800000, 305532022],
            [849139200000, 305596124],
            [849225600000, 305707739],
            [849312000000, 305824658],
            [849398400000, 305891406],
            [849484800000, 305910670],
            [849571200000, 305929498],
            [849657600000, 305946139],
            [849744000000, 305961447],
            [849830400000, 305986656],
            [849916800000, 306030870],
            [850003200000, 306052958],
            [850089600000, 306061180],
            [850176000000, 306070178],
            [850262400000, 306078426],
            [850348800000, 306087290],
            [850435200000, 306097177],
            [850521600000, 306114229],
            [850608000000, 306124059],
            [850694400000, 306127449],
            [850780800000, 306131020],
            [850867200000, 306134277],
            [850953600000, 306137970],
            [851040000000, 306139294],
            [851126400000, 306141398],
            [851212800000, 306143214],
            [851299200000, 306144389],
            [851385600000, 306144894],
            [851472000000, 306145801],
            [851558400000, 306146846],
            [851644800000, 306148796],
            [851731200000, 306151575],
            [851817600000, 306153456],
            [851904000000, 306154976],
            [851990400000, 306156090],
            [852076800000, 306157684],
            [852163200000, 306158924],
            [852249600000, 306161785],
            [852336000000, 306164608],
            [852422400000, 306167040],
            [852508800000, 306168070],
            [852595200000, 306168550],
            [852681600000, 306168871],
            [852768000000, 306169231],
            [852854400000, 306169239],
            [852940800000, 306169252],
            [853027200000, 306169255]
        ],
        name: 'independenceday',
        showInLegend: false,
        extra: {
            title: 'Independence Day',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#494941'
        },
        showlabel: false,
        color: 'rgba(73,73,65,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1057708800000, 13509262
            ],
            [1057795200000, 23995281],
            [1057881600000, 38836375],
            [1057968000000, 56251068],
            [1058054400000, 70625971],
            [1058140800000, 78130538],
            [1058227200000, 85481675],
            [1058313600000, 92538277],
            [1058400000000, 98972817],
            [1058486400000, 109478015],
            [1058572800000, 122573429],
            [1058659200000, 133007414],
            [1058745600000, 138339699],
            [1058832000000, 143788932],
            [1058918400000, 148870944],
            [1059004800000, 153702126],
            [1059091200000, 160516745],
            [1059177600000, 169482545],
            [1059264000000, 176838155],
            [1059350400000, 180420744],
            [1059436800000, 184016944],
            [1059523200000, 187291717],
            [1059609600000, 190687248],
            [1059696000000, 196338959],
            [1059782400000, 203744844],
            [1059868800000, 209531292],
            [1059955200000, 212373229],
            [1060041600000, 215120764],
            [1060128000000, 217413683],
            [1060214400000, 219728159],
            [1060300800000, 223521426],
            [1060387200000, 228804295],
            [1060473600000, 232750629],
            [1060560000000, 234585563],
            [1060646400000, 236438631],
            [1060732800000, 238090433],
            [1060819200000, 239553386],
            [1060905600000, 242116801],
            [1060992000000, 245975424],
            [1061078400000, 248720985],
            [1061164800000, 249988792],
            [1061251200000, 251296996],
            [1061337600000, 252455172],
            [1061424000000, 253650250],
            [1061510400000, 255823530],
            [1061596800000, 258852271],
            [1061683200000, 260925697],
            [1061769600000, 261760515],
            [1061856000000, 262672512],
            [1061942400000, 263453833],
            [1062028800000, 264199762],
            [1062115200000, 266115664],
            [1062201600000, 269082937],
            [1062288000000, 272169924],
            [1062374400000, 275018547],
            [1062460800000, 275611442],
            [1062547200000, 276102480],
            [1062633600000, 276559924],
            [1062720000000, 277987309],
            [1062806400000, 280440199],
            [1062892800000, 281831452],
            [1062979200000, 282167858],
            [1063065600000, 282601728],
            [1063152000000, 282976937],
            [1063238400000, 283377972],
            [1063324800000, 284540875],
            [1063411200000, 286723991],
            [1063497600000, 287884372],
            [1063584000000, 288140777],
            [1063670400000, 288449559],
            [1063756800000, 288726283],
            [1063843200000, 289014944],
            [1063929600000, 290042859],
            [1064016000000, 291635655],
            [1064102400000, 292495912],
            [1064188800000, 292694592],
            [1064275200000, 292935283],
            [1064361600000, 293134595],
            [1064448000000, 293338779],
            [1064534400000, 293966591],
            [1064620800000, 295087048],
            [1064707200000, 295713028],
            [1064793600000, 295854512],
            [1064880000000, 296019087],
            [1064966400000, 296160106],
            [1065052800000, 296301501],
            [1065139200000, 296736901],
            [1065225600000, 297512007],
            [1065312000000, 297930745],
            [1065398400000, 298063982],
            [1065484800000, 298199474],
            [1065657600000, 298446752],
            [1065744000000, 298719251],
            [1065830400000, 299170254],
            [1065916800000, 299468874],
            [1066003200000, 299645669],
            [1066089600000, 299744461],
            [1066176000000, 299815192],
            [1066262400000, 299903856],
            [1066348800000, 300086778],
            [1066435200000, 300384744],
            [1066521600000, 300557571],
            [1066608000000, 300606406],
            [1066694400000, 300658188],
            [1066780800000, 300706564],
            [1066867200000, 300761777],
            [1066953600000, 300891777],
            [1067040000000, 301103000],
            [1067126400000, 301243790],
            [1067558400000, 301485093],
            [1067644800000, 301694093],
            [1067731200000, 301823371],
            [1068163200000, 302122298],
            [1068249600000, 302415298],
            [1068336000000, 302609731],
            [1068422400000, 302703731],
            [1068508800000, 302845731],
            [1068595200000, 302908731],
            [1068681600000, 302977271]
        ],
        name: 'piratesofthecaribbean',
        showInLegend: false,
        extra: {
            title: 'Pirates of the Caribbean: The Curse of the Black Pearl',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#493427'
        },
        showlabel: false,
        color: 'rgba(73,52,39,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1352332800000, 2200000
            ],
            [1352419200000, 32704077],
            [1352505600000, 66563621],
            [1352592000000, 90564714],
            [1352678400000, 101892378],
            [1352764800000, 109108232],
            [1352851200000, 114650165],
            [1352937600000, 119837108],
            [1353024000000, 132089864],
            [1353110400000, 149776859],
            [1353196800000, 160941621],
            [1353283200000, 164955549],
            [1353369600000, 170595344],
            [1353456000000, 177997320],
            [1353542400000, 185641149],
            [1353628800000, 200319497],
            [1353715200000, 214291699],
            [1353801600000, 221144122],
            [1353888000000, 223067688],
            [1353974400000, 225341845],
            [1354060800000, 227164911],
            [1354147200000, 229029189],
            [1354233600000, 233896096],
            [1354320000000, 241539475],
            [1354406400000, 245585083],
            [1354492800000, 246712819],
            [1354579200000, 248219280],
            [1354665600000, 249433656],
            [1354752000000, 250620080],
            [1354838400000, 253742176],
            [1354924800000, 258761089],
            [1355011200000, 261400281],
            [1355097600000, 262288449],
            [1355184000000, 263450532],
            [1355270400000, 264414319],
            [1355356800000, 265366063],
            [1355443200000, 267185882],
            [1355529600000, 270229938],
            [1355616000000, 271921795],
            [1355702400000, 272623067],
            [1355788800000, 273507818],
            [1355875200000, 274250511],
            [1355961600000, 275091774],
            [1356048000000, 276369660],
            [1356134400000, 278284811],
            [1356220800000, 279959314],
            [1356307200000, 281041059],
            [1356393600000, 282400140],
            [1356480000000, 283733038],
            [1356566400000, 285027378],
            [1356652800000, 286502805],
            [1356739200000, 288184841],
            [1356825600000, 289559202],
            [1356912000000, 290904271],
            [1356998400000, 292300121],
            [1357084800000, 293046816],
            [1357171200000, 293729570],
            [1357257600000, 294734769],
            [1357344000000, 296099935],
            [1357430400000, 296804366],
            [1357516800000, 297025010],
            [1357603200000, 297309483],
            [1357689600000, 297549764],
            [1357776000000, 297793213],
            [1357862400000, 298255456],
            [1357948800000, 298988987],
            [1358035200000, 299349015],
            [1358121600000, 299466261],
            [1358208000000, 299627928],
            [1358294400000, 299754729],
            [1358380800000, 299887074],
            [1358467200000, 300149583],
            [1358553600000, 300607022],
            [1358640000000, 300856315],
            [1358726400000, 301030969],
            [1358812800000, 301113921],
            [1358899200000, 301180024],
            [1358985600000, 301252887],
            [1359072000000, 301449945],
            [1359158400000, 301845386],
            [1359244800000, 302044126],
            [1359676800000, 302461810],
            [1359763200000, 302742675],
            [1359849600000, 302823504],
            [1360281600000, 303140953],
            [1360368000000, 303349880],
            [1360454400000, 303460116],
            [1360886400000, 303703685],
            [1360972800000, 303819941],
            [1361059200000, 303898781],
            [1361145600000, 303954360],
            [1361491200000, 304065789],
            [1361577600000, 304135609],
            [1361664000000, 304164760]
        ],
        name: 'bond23',
        showInLegend: false,
        extra: {
            title: 'Skyfall',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#262525'
        },
        showlabel: false,
        color: 'rgba(38,37,37,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1355443200000, 37125547
            ],
            [1355529600000, 64865362],
            [1355616000000, 84617303],
            [1355702400000, 92355596],
            [1355788800000, 100210686],
            [1355875200000, 106537873],
            [1355961600000, 113152900],
            [1356048000000, 123231727],
            [1356134400000, 137391893],
            [1356220800000, 150041265],
            [1356307200000, 156938532],
            [1356393600000, 168177061],
            [1356480000000, 179565290],
            [1356566400000, 189700814],
            [1356652800000, 200320148],
            [1356739200000, 211908785],
            [1356825600000, 221626882],
            [1356912000000, 228546604],
            [1356998400000, 238001325],
            [1357084800000, 242450337],
            [1357171200000, 246289507],
            [1357257600000, 251461852],
            [1357344000000, 259090870],
            [1357430400000, 263834893],
            [1357516800000, 265146005],
            [1357603200000, 266717281],
            [1357689600000, 267891777],
            [1357776000000, 269044187],
            [1357862400000, 271393243],
            [1357948800000, 275583907],
            [1358035200000, 278212618],
            [1358121600000, 278869783],
            [1358208000000, 279689070],
            [1358294400000, 280327393],
            [1358380800000, 280989741],
            [1358467200000, 282442200],
            [1358553600000, 285262419],
            [1358640000000, 287166682],
            [1358726400000, 288613051],
            [1358812800000, 289121058],
            [1358899200000, 289530240],
            [1358985600000, 289938470],
            [1359072000000, 290655265],
            [1359158400000, 292303032],
            [1359244800000, 293323831],
            [1359331200000, 293562965],
            [1359417600000, 293831138],
            [1359504000000, 294051480],
            [1359590400000, 294292520],
            [1359676800000, 294791435],
            [1359763200000, 295799649],
            [1359849600000, 296193684],
            [1359936000000, 296348737],
            [1360022400000, 296541937],
            [1360108800000, 296696970],
            [1360195200000, 296865052],
            [1360281600000, 297174579],
            [1360368000000, 297877452],
            [1360454400000, 298333426],
            [1360540800000, 298481792],
            [1360627200000, 298609930],
            [1360713600000, 298722132],
            [1360800000000, 298884345],
            [1360886400000, 299101408],
            [1360972800000, 299527804],
            [1361059200000, 299874706],
            [1361145600000, 300161285],
            [1361232000000, 300249423],
            [1361318400000, 300322891],
            [1361404800000, 300401896],
            [1361491200000, 300532101],
            [1361577600000, 300797269],
            [1361664000000, 300952379],
            [1361750400000, 300997848],
            [1361836800000, 301044732],
            [1361923200000, 301085807],
            [1362009600000, 301134992],
            [1362096000000, 301198249],
            [1362182400000, 301324866],
            [1362268800000, 301402746],
            [1362355200000, 301424668],
            [1362441600000, 301451679],
            [1362528000000, 301473018],
            [1362614400000, 301495997],
            [1362700800000, 301592562],
            [1362787200000, 301765469],
            [1362873600000, 301874933],
            [1362960000000, 301921098],
            [1363046400000, 301976034],
            [1363132800000, 302023697],
            [1363219200000, 302075203],
            [1363305600000, 302162441],
            [1363392000000, 302304675],
            [1363478400000, 302393021],
            [1363564800000, 302421626],
            [1363651200000, 302454449],
            [1363737600000, 302485958],
            [1363824000000, 302517733],
            [1363910400000, 302567059],
            [1363996800000, 302648445],
            [1364083200000, 302695938],
            [1364169600000, 302715735],
            [1364256000000, 302738507],
            [1364342400000, 302757024],
            [1364428800000, 302779925],
            [1364515200000, 302805622],
            [1364601600000, 302833169],
            [1364688000000, 302849493],
            [1364774400000, 302860946],
            [1364860800000, 302871198],
            [1364947200000, 302880835],
            [1365033600000, 302893299],
            [1365120000000, 302905358],
            [1365206400000, 302922520],
            [1365292800000, 302932624],
            [1365379200000, 302935557],
            [1365465600000, 302938604],
            [1365552000000, 302941346],
            [1365638400000, 302944389],
            [1365724800000, 302953301],
            [1365811200000, 302966623],
            [1365897600000, 302975075],
            [1365984000000, 302976741],
            [1366070400000, 302978573],
            [1366156800000, 302980257],
            [1366243200000, 302982412],
            [1366329600000, 302988570],
            [1366416000000, 302996253],
            [1366502400000, 303001229],
            [1366588800000, 303001722],
            [1366675200000, 303002274],
            [1366761600000, 303002765],
            [1366848000000, 303003568]
        ],
        name: 'hobbit',
        showInLegend: false,
        extra: {
            title: 'The Hobbit: An Unexpected Journey',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#35321F'
        },
        showlabel: false,
        color: 'rgba(53,50,31,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1247616000000, 58175412
            ],
            [1247702400000, 80186627],
            [1247788800000, 107007199],
            [1247875200000, 136241423],
            [1247961600000, 158022354],
            [1248048000000, 167946763],
            [1248134400000, 177457914],
            [1248220800000, 184976152],
            [1248307200000, 191833631],
            [1248393600000, 201167852],
            [1248480000000, 212360848],
            [1248566400000, 221295818],
            [1248652800000, 225318990],
            [1248739200000, 229338358],
            [1248825600000, 233920753],
            [1248912000000, 237762860],
            [1248998400000, 243138489],
            [1249084800000, 249893845],
            [1249171200000, 255672245],
            [1249257600000, 258190624],
            [1249344000000, 260610864],
            [1249430400000, 262803216],
            [1249516800000, 264920284],
            [1249603200000, 267502123],
            [1249689600000, 270977685],
            [1249776000000, 273848633],
            [1249862400000, 275140006],
            [1249948800000, 276456321],
            [1250035200000, 277609743],
            [1250121600000, 278737953],
            [1250208000000, 280192999],
            [1250294400000, 282238071],
            [1250380800000, 283879025],
            [1250467200000, 284616272],
            [1250553600000, 285375636],
            [1250640000000, 286072062],
            [1250726400000, 286760375],
            [1250812800000, 287732054],
            [1250899200000, 289167953],
            [1250985600000, 290238524],
            [1251072000000, 290644750],
            [1251158400000, 291051145],
            [1251244800000, 291439349],
            [1251331200000, 291791652],
            [1251417600000, 292431424],
            [1251504000000, 293553701],
            [1251590400000, 294258075],
            [1251676800000, 294486205],
            [1251763200000, 294707345],
            [1251849600000, 294904348],
            [1251936000000, 295112118],
            [1252022400000, 295514962],
            [1252108800000, 296197431],
            [1252195200000, 296940258],
            [1252281600000, 297614366],
            [1252368000000, 297742596],
            [1252454400000, 297839740],
            [1252540800000, 297936218],
            [1252627200000, 298155342],
            [1252713600000, 298588795],
            [1252800000000, 298844700],
            [1252886400000, 298916152],
            [1252972800000, 298989374],
            [1253059200000, 299066782],
            [1253145600000, 299149308],
            [1253232000000, 299251785],
            [1253318400000, 299456739],
            [1253404800000, 299576295],
            [1253491200000, 299609771],
            [1253577600000, 299641573],
            [1253664000000, 299668923],
            [1253750400000, 299695999],
            [1253836800000, 299765661],
            [1253923200000, 299887119],
            [1254009600000, 299967829],
            [1254096000000, 299991266],
            [1254182400000, 300011724],
            [1254268800000, 300033000],
            [1254355200000, 300056680],
            [1254441600000, 300101273],
            [1254528000000, 300181586],
            [1254614400000, 300232058],
            [1254700800000, 300247445],
            [1254787200000, 300261293],
            [1254873600000, 300274819],
            [1254960000000, 300290780],
            [1255046400000, 300397962],
            [1255132800000, 300574482],
            [1255219200000, 300699217],
            [1255305600000, 300761086],
            [1255392000000, 300800421],
            [1255478400000, 300839206],
            [1255564800000, 300880041],
            [1255651200000, 300959316],
            [1255737600000, 301082222],
            [1255824000000, 301153382],
            [1255910400000, 301174730],
            [1255996800000, 301196318],
            [1256083200000, 301216215],
            [1256169600000, 301238300],
            [1256256000000, 301291184],
            [1256342400000, 301370267],
            [1256428800000, 301420102],
            [1256515200000, 301433060],
            [1256601600000, 301447061],
            [1256688000000, 301460022],
            [1256774400000, 301475004],
            [1256860800000, 301506475],
            [1256947200000, 301540576],
            [1257033600000, 301577469],
            [1257120000000, 301588168],
            [1257206400000, 301599723],
            [1257292800000, 301610121],
            [1257379200000, 301622718],
            [1257465600000, 301646692],
            [1257552000000, 301684625],
            [1257638400000, 301707444],
            [1257724800000, 301714703],
            [1257811200000, 301723865],
            [1257897600000, 301739556],
            [1257984000000, 301747148],
            [1258070400000, 301762841],
            [1258156800000, 301791769],
            [1258243200000, 301809058],
            [1258329600000, 301814491],
            [1258416000000, 301819516],
            [1258502400000, 301826185],
            [1258588800000, 301830720],
            [1258675200000, 301841030],
            [1258761600000, 301856903],
            [1258848000000, 301865854],
            [1258934400000, 301869544],
            [1259020800000, 301873998],
            [1259107200000, 301880484],
            [1259193600000, 301885585],
            [1259280000000, 301898526],
            [1259366400000, 301912551],
            [1259452800000, 301920409],
            [1259539200000, 301922914],
            [1259625600000, 301925544],
            [1259712000000, 301927039],
            [1259798400000, 301930002],
            [1259884800000, 301934883],
            [1259971200000, 301942780],
            [1260057600000, 301948049],
            [1260144000000, 301949123],
            [1260230400000, 301949939],
            [1260316800000, 301950875],
            [1260403200000, 301951830],
            [1260489600000, 301953306],
            [1260576000000, 301955647],
            [1260662400000, 301956980],
            [1260748800000, 301957434],
            [1260835200000, 301958137],
            [1260921600000, 301958630],
            [1261008000000, 301959197]
        ],
        name: 'harrypotter6',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Half-Blood Prince',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#405055'
        },
        showlabel: false,
        color: 'rgba(64,80,85,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1277856000000, 68533840
            ],
            [1277942400000, 92744978],
            [1278028800000, 120898294],
            [1278115200000, 144318923],
            [1278201600000, 157577169],
            [1278288000000, 176382220],
            [1278374400000, 186950082],
            [1278460800000, 195731290],
            [1278547200000, 203662377],
            [1278633600000, 214731017],
            [1278720000000, 227019720],
            [1278806400000, 235370815],
            [1278892800000, 239699029],
            [1278979200000, 244209577],
            [1279065600000, 247931714],
            [1279152000000, 251371417],
            [1279238400000, 255835262],
            [1279324800000, 260969703],
            [1279411200000, 264791897],
            [1279497600000, 266828360],
            [1279584000000, 268916972],
            [1279670400000, 270752885],
            [1279756800000, 272641092],
            [1279843200000, 274993549],
            [1279929600000, 277753614],
            [1280016000000, 279827262],
            [1280102400000, 280909882],
            [1280188800000, 282063266],
            [1280275200000, 283126985],
            [1280361600000, 284184954],
            [1280448000000, 285466740],
            [1280534400000, 287003133],
            [1280620800000, 288199907],
            [1280707200000, 288848358],
            [1280793600000, 289545112],
            [1280880000000, 290187610],
            [1280966400000, 290811608],
            [1281052800000, 291535744],
            [1281139200000, 292435125],
            [1281225600000, 293101870],
            [1281312000000, 293491146],
            [1281398400000, 293877997],
            [1281484800000, 294218322],
            [1281571200000, 294562794],
            [1281657600000, 294962222],
            [1281744000000, 295455581],
            [1281830400000, 295842444],
            [1281916800000, 296057156],
            [1282003200000, 296268343],
            [1282089600000, 296459791],
            [1282176000000, 296649934],
            [1282262400000, 296825113],
            [1282348800000, 297053728],
            [1282435200000, 297216798],
            [1282521600000, 297292615],
            [1282608000000, 297368060],
            [1282694400000, 297439330],
            [1282780800000, 297513099],
            [1282867200000, 297661771],
            [1282953600000, 297879109],
            [1283040000000, 298027752],
            [1283126400000, 298087231],
            [1283212800000, 298147250],
            [1283299200000, 298200597],
            [1283385600000, 298253221],
            [1283472000000, 298366778],
            [1283558400000, 298530255],
            [1283644800000, 298687341],
            [1283731200000, 298798466],
            [1283817600000, 298829151],
            [1283904000000, 298859646],
            [1283990400000, 298890399],
            [1284076800000, 299108366],
            [1284163200000, 299435636],
            [1284249600000, 299633864],
            [1284336000000, 299696897],
            [1284422400000, 299762214],
            [1284508800000, 299823339],
            [1284595200000, 299894595],
            [1284681600000, 299955119],
            [1284768000000, 300047908],
            [1284854400000, 300103072],
            [1284940800000, 300120411],
            [1285027200000, 300137500],
            [1285113600000, 300155447],
            [1285200000000, 300174331],
            [1285286400000, 300210368],
            [1285372800000, 300265329],
            [1285459200000, 300298740],
            [1285545600000, 300308826],
            [1285632000000, 300319854],
            [1285718400000, 300330227],
            [1285804800000, 300342944],
            [1285891200000, 300362570],
            [1285977600000, 300393458],
            [1286064000000, 300412216],
            [1286150400000, 300418145],
            [1286236800000, 300424141],
            [1286323200000, 300430812],
            [1286409600000, 300438766],
            [1286496000000, 300451352],
            [1286582400000, 300467530],
            [1286668800000, 300476779],
            [1286755200000, 300482411],
            [1286841600000, 300486119],
            [1286928000000, 300489847],
            [1287014400000, 300494753],
            [1287100800000, 300504050],
            [1287187200000, 300517057],
            [1287273600000, 300523113],
            [1287360000000, 300525239],
            [1287446400000, 300527315],
            [1287532800000, 300529203],
            [1287619200000, 300531751]
        ],
        name: 'eclipse',
        showInLegend: false,
        extra: {
            title: 'The Twilight Saga: Eclipse',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#20262C'
        },
        showlabel: false,
        color: 'rgba(32,38,44,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1258675200000, 72703754
            ],
            [1258761600000, 114992635],
            [1258848000000, 142839137],
            [1258934400000, 153345623],
            [1259020800000, 164674318],
            [1259107200000, 178873121],
            [1259193600000, 188077665],
            [1259280000000, 205788929],
            [1259366400000, 222312298],
            [1259452800000, 230947696],
            [1259539200000, 233334668],
            [1259625600000, 235729643],
            [1259712000000, 237830629],
            [1259798400000, 239935424],
            [1259884800000, 245049663],
            [1259971200000, 251530186],
            [1260057600000, 255363052],
            [1260144000000, 256392782],
            [1260230400000, 257469075],
            [1260316800000, 258374906],
            [1260403200000, 259360583],
            [1260489600000, 261801174],
            [1260576000000, 265239569],
            [1260662400000, 267320977],
            [1260748800000, 268024129],
            [1260835200000, 268761019],
            [1260921600000, 269469446],
            [1261008000000, 270190721],
            [1261094400000, 271578179],
            [1261180800000, 273220014],
            [1261267200000, 274598319],
            [1261353600000, 275569901],
            [1261440000000, 276620062],
            [1261526400000, 277523522],
            [1261612800000, 277918499],
            [1261699200000, 278580670],
            [1261785600000, 279828507],
            [1261872000000, 280962758],
            [1261958400000, 281919694],
            [1262044800000, 282874182],
            [1262131200000, 283870180],
            [1262217600000, 284512392],
            [1262304000000, 285802158],
            [1262390400000, 287180562],
            [1262476800000, 287954655],
            [1262563200000, 288269091],
            [1262649600000, 288548185],
            [1262736000000, 288798541],
            [1262822400000, 289039470],
            [1262908800000, 289520696],
            [1262995200000, 290277863],
            [1263081600000, 290743279],
            [1263168000000, 290872087],
            [1263254400000, 291013646],
            [1263340800000, 291149228],
            [1263427200000, 291300411],
            [1263513600000, 291550109],
            [1263600000000, 291934933],
            [1263686400000, 292229350],
            [1263772800000, 292434830],
            [1263859200000, 292509377],
            [1263945600000, 292579491],
            [1264032000000, 292661450],
            [1264118400000, 292793194],
            [1264204800000, 293029562],
            [1264291200000, 293175475],
            [1264377600000, 293223221],
            [1264464000000, 293274586],
            [1264550400000, 293326128],
            [1264636800000, 293379881],
            [1264723200000, 293493968],
            [1264809600000, 293688584],
            [1264896000000, 293815426],
            [1264982400000, 293856559],
            [1265068800000, 293897327],
            [1265155200000, 293937929],
            [1265241600000, 293977961],
            [1265328000000, 294054828],
            [1265414400000, 294196696],
            [1265500800000, 294254358],
            [1265587200000, 294283741],
            [1265673600000, 294311847],
            [1265760000000, 294339517],
            [1265846400000, 294372909],
            [1265932800000, 294496278],
            [1266019200000, 294715959],
            [1266105600000, 294931622],
            [1266192000000, 295061295],
            [1266278400000, 295114155],
            [1266364800000, 295165706],
            [1266451200000, 295216182],
            [1266537600000, 295322462],
            [1266624000000, 295494309],
            [1266710400000, 295598642],
            [1266796800000, 295628917],
            [1266883200000, 295659082],
            [1266969600000, 295689319],
            [1267056000000, 295723151],
            [1267142400000, 295798717],
            [1267228800000, 295931730],
            [1267315200000, 296012199],
            [1267401600000, 296035043],
            [1267488000000, 296060235],
            [1267574400000, 296085333],
            [1267660800000, 296113798],
            [1267747200000, 296168074],
            [1267833600000, 296255680],
            [1267920000000, 296301843],
            [1268006400000, 296316973],
            [1268092800000, 296332608],
            [1268179200000, 296348141],
            [1268265600000, 296368364],
            [1268352000000, 296402028],
            [1268438400000, 296453031],
            [1268524800000, 296482320],
            [1268611200000, 296496490],
            [1268697600000, 296512436],
            [1268784000000, 296525237],
            [1268870400000, 296540598],
            [1268956800000, 296564146],
            [1269043200000, 296583555],
            [1269129600000, 296593070],
            [1269216000000, 296596319],
            [1269302400000, 296599500],
            [1269388800000, 296603020],
            [1269475200000, 296607170],
            [1269561600000, 296611342],
            [1269648000000, 296616705],
            [1269734400000, 296619304],
            [1269820800000, 296620241],
            [1269907200000, 296621418],
            [1269993600000, 296622442],
            [1270080000000, 296623634]
        ],
        name: 'newmoon',
        showInLegend: false,
        extra: {
            title: 'The Twilight Saga: New Moon',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#2C1F14'
        },
        showlabel: false,
        color: 'rgba(44,31,20,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1290124800000, 61684550
            ],
            [1290211200000, 99910804],
            [1290297600000, 125017372],
            [1290384000000, 133802832],
            [1290470400000, 144067185],
            [1290556800000, 158493048],
            [1290643200000, 169969028],
            [1290729600000, 190801679],
            [1290816000000, 209530619],
            [1290902400000, 219056129],
            [1290988800000, 221395291],
            [1291075200000, 223673772],
            [1291161600000, 225609158],
            [1291248000000, 227500641],
            [1291334400000, 232302408],
            [1291420800000, 239748482],
            [1291507200000, 244519116],
            [1291593600000, 245657482],
            [1291680000000, 246936701],
            [1291766400000, 248066339],
            [1291852800000, 249188405],
            [1291939200000, 251585745],
            [1292025600000, 255337232],
            [1292112000000, 257672721],
            [1292198400000, 258393849],
            [1292284800000, 259196947],
            [1292371200000, 259924254],
            [1292457600000, 260701257],
            [1292544000000, 262021812],
            [1292630400000, 264102283],
            [1292716800000, 265723618],
            [1292803200000, 266686635],
            [1292889600000, 267808784],
            [1292976000000, 268711916],
            [1293062400000, 269818287],
            [1293148800000, 270527686],
            [1293235200000, 271598360],
            [1293321600000, 272994635],
            [1293408000000, 274432306],
            [1293494400000, 275826603],
            [1293580800000, 277314301],
            [1293667200000, 278881516],
            [1293753600000, 280230127],
            [1293840000000, 282101489],
            [1293926400000, 283533215],
            [1294012800000, 284158711],
            [1294099200000, 284606713],
            [1294185600000, 284967896],
            [1294272000000, 285308372],
            [1294358400000, 285951380],
            [1294444800000, 287020595],
            [1294531200000, 287661770],
            [1294617600000, 287833113],
            [1294704000000, 288021547],
            [1294790400000, 288205868],
            [1294876800000, 288404268],
            [1294963200000, 288750710],
            [1295049600000, 289330955],
            [1295136000000, 289803472],
            [1295222400000, 290153345],
            [1295308800000, 290257461],
            [1295395200000, 290349084],
            [1295481600000, 290442497],
            [1295568000000, 290674124],
            [1295654400000, 291122346],
            [1295740800000, 291340768],
            [1295827200000, 291410780],
            [1295913600000, 291483201],
            [1296000000000, 291545304],
            [1296086400000, 291622563],
            [1296172800000, 291759910],
            [1296259200000, 292042358],
            [1296345600000, 292223492],
            [1296432000000, 292264965],
            [1296518400000, 292303121],
            [1296604800000, 292343711],
            [1296691200000, 292387836],
            [1296777600000, 292484655],
            [1296864000000, 292682197],
            [1296950400000, 292761214],
            [1297036800000, 292791821],
            [1297123200000, 292822346],
            [1297209600000, 292853786],
            [1297296000000, 292890256],
            [1297382400000, 293001182],
            [1297468800000, 293214434],
            [1297555200000, 293355408],
            [1297641600000, 293420257],
            [1297728000000, 293461112],
            [1297814400000, 293500742],
            [1297900800000, 293542749],
            [1297987200000, 293628178],
            [1298073600000, 293778793],
            [1298160000000, 293901794],
            [1298246400000, 293989138],
            [1298332800000, 294021980],
            [1298419200000, 294052852],
            [1298505600000, 294086193],
            [1298592000000, 294148448],
            [1298678400000, 294257582],
            [1298764800000, 294325810],
            [1298851200000, 294343741],
            [1298937600000, 294362857],
            [1299024000000, 294381914],
            [1299110400000, 294403739],
            [1299196800000, 294440029],
            [1299283200000, 294512744],
            [1299369600000, 294562162],
            [1299456000000, 294575505],
            [1299542400000, 294588181],
            [1299628800000, 294600097],
            [1299715200000, 294614753],
            [1299801600000, 294642112],
            [1299888000000, 294684114],
            [1299974400000, 294713608],
            [1300060800000, 294723791],
            [1300147200000, 294735705],
            [1300233600000, 294746666],
            [1300320000000, 294758215],
            [1300406400000, 294777458],
            [1300492800000, 294805913],
            [1300579200000, 294825350],
            [1300665600000, 294833319],
            [1300752000000, 294840890],
            [1300838400000, 294848280],
            [1300924800000, 294856409],
            [1301011200000, 294871962],
            [1301097600000, 294897683],
            [1301184000000, 294915214],
            [1301270400000, 294923279],
            [1301356800000, 294929415],
            [1301443200000, 294935796],
            [1301529600000, 294943653],
            [1301616000000, 294953818],
            [1301702400000, 294969515],
            [1301788800000, 294980434],
            [1301875200000, 294985532],
            [1301961600000, 294991649],
            [1302048000000, 294996114],
            [1302134400000, 295001070]
        ],
        name: 'harrypotter7',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Deathly Hallows Part 1',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#303A3F'
        },
        showlabel: false,
        color: 'rgba(48,58,63,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                933897600000, 8005000
            ],
            [933984000000, 17655000],
            [934070400000, 26681262],
            [934156800000, 31031574],
            [934243200000, 35452746],
            [934329600000, 39619154],
            [934416000000, 43896663],
            [934502400000, 51516663],
            [934588800000, 61541663],
            [934675200000, 69661654],
            [934761600000, 73207523],
            [934848000000, 76866243],
            [934934400000, 80246377],
            [935020800000, 83556273],
            [935107200000, 90719273],
            [935193600000, 100550273],
            [935280000000, 107506281],
            [935366400000, 110348578],
            [935452800000, 113370529],
            [935539200000, 116110422],
            [935625600000, 118754754],
            [935712000000, 124562754],
            [935798400000, 133094754],
            [935884800000, 138853903],
            [935971200000, 140917446],
            [936057600000, 143097886],
            [936144000000, 145036427],
            [936230400000, 146974136],
            [936316800000, 152327136],
            [936403200000, 160755136],
            [936489600000, 176245282],
            [936576000000, 176245282],
            [936662400000, 177982062],
            [936748800000, 179591126],
            [936835200000, 181153817],
            [936921600000, 186073817],
            [937008000000, 193496817],
            [937094400000, 197665281],
            [937180800000, 198677775],
            [937267200000, 199882162],
            [937353600000, 200964306],
            [937440000000, 202068412],
            [937526400000, 205529412],
            [937612800000, 210366412],
            [937699200000, 213275834],
            [937785600000, 214138418],
            [937872000000, 215085966],
            [937958400000, 215873563],
            [938044800000, 216607083],
            [938131200000, 219018083],
            [938217600000, 223075083],
            [938304000000, 225042276],
            [938390400000, 225613823],
            [938476800000, 226293428],
            [938563200000, 226907907],
            [938649600000, 227522683],
            [938736000000, 229524683],
            [938822400000, 232889683],
            [938908800000, 234547781],
            [938995200000, 235024985],
            [939081600000, 235565790],
            [939168000000, 236062102],
            [939254400000, 236586228],
            [939340800000, 238237228],
            [939427200000, 241036228],
            [939513600000, 242710195],
            [939600000000, 243401213],
            [939686400000, 243841201],
            [939772800000, 244255508],
            [939859200000, 244690218],
            [939945600000, 246110218],
            [940032000000, 248620218],
            [940118400000, 249858389],
            [940204800000, 250208911],
            [940291200000, 250614682],
            [940377600000, 251022731],
            [940464000000, 251443160],
            [940550400000, 252653160],
            [940636800000, 254658160],
            [940723200000, 255501006],
            [940809600000, 255759952],
            [940896000000, 256061004],
            [940982400000, 256335880],
            [941068800000, 256634871],
            [941155200000, 257594871],
            [941241600000, 259089871],
            [941328000000, 259835832],
            [941414400000, 260082710],
            [941500800000, 260380693],
            [941587200000, 260633885],
            [941673600000, 260911157],
            [941760000000, 261831157],
            [941846400000, 263372157],
            [941932800000, 264042695],
            [942019200000, 264214025],
            [942105600000, 264422468],
            [942192000000, 264722351],
            [942278400000, 265179317],
            [942364800000, 265989317],
            [942451200000, 267148317],
            [942537600000, 267741966],
            [942624000000, 267883751],
            [942710400000, 268052104],
            [942796800000, 268203376],
            [942883200000, 268360331],
            [942969600000, 268867331],
            [943056000000, 269648331],
            [943142400000, 269975523],
            [943228800000, 270088655],
            [943315200000, 270256491],
            [943747200000, 272318916],
            [943833600000, 272384180],
            [943920000000, 272453101],
            [944006400000, 272516564],
            [944092800000, 272583384],
            [944352000000, 273549908],
            [944438400000, 273609773],
            [944524800000, 273678296],
            [944611200000, 273744634],
            [944697600000, 273811037],
            [944956800000, 274477963],
            [945043200000, 274523540],
            [945129600000, 274573875],
            [945216000000, 274626246],
            [945302400000, 274685000],
            [945561600000, 275176668],
            [945648000000, 275259526],
            [945734400000, 275355092],
            [946252800000, 275792609],
            [946339200000, 275869900],
            [946425600000, 275949207]
        ],
        name: 'sixthsense',
        showInLegend: false,
        extra: {
            title: 'The Sixth Sense',
            genre: 'Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#090B0E'
        },
        showlabel: false,
        color: 'rgba(9,11,14,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1243555200000, 21481834
            ],
            [1243641600000, 47876153],
            [1243728000000, 68108790],
            [1243814400000, 74379941],
            [1243900800000, 80785838],
            [1243987200000, 86902484],
            [1244073600000, 93072435],
            [1244160000000, 106144174],
            [1244246400000, 124004233],
            [1244332800000, 137210701],
            [1244419200000, 141916287],
            [1244505600000, 146819075],
            [1244592000000, 151537818],
            [1244678400000, 156663709],
            [1244764800000, 165462740],
            [1244851200000, 178744416],
            [1244937600000, 187425989],
            [1245024000000, 191041612],
            [1245110400000, 195019750],
            [1245196800000, 198836362],
            [1245283200000, 202776255],
            [1245369600000, 208907795],
            [1245456000000, 217807796],
            [1245542400000, 226268932],
            [1245628800000, 229059138],
            [1245715200000, 231970466],
            [1245801600000, 234660796],
            [1245888000000, 237172817],
            [1245974400000, 241154244],
            [1246060800000, 246187028],
            [1246147200000, 250234554],
            [1246233600000, 252395385],
            [1246320000000, 254967154],
            [1246406400000, 256551863],
            [1246492800000, 258295305],
            [1246579200000, 261015946],
            [1246665600000, 262847554],
            [1246752000000, 264816694],
            [1246838400000, 265851836],
            [1246924800000, 267032381],
            [1247011200000, 268117384],
            [1247097600000, 269119015],
            [1247184000000, 270546109],
            [1247270400000, 272463580],
            [1247356800000, 273834761],
            [1247443200000, 274526070],
            [1247529600000, 275270868],
            [1247616000000, 275822368],
            [1247702400000, 276411268],
            [1247788800000, 277392723],
            [1247875200000, 278669860],
            [1247961600000, 279583282],
            [1248048000000, 280063791],
            [1248134400000, 280774310],
            [1248220800000, 281364419],
            [1248307200000, 282002924],
            [1248393600000, 282510944],
            [1248480000000, 283165584],
            [1248566400000, 283690231],
            [1248652800000, 283945084],
            [1248739200000, 284239283],
            [1248825600000, 284578994],
            [1248912000000, 284878665],
            [1248998400000, 285219693],
            [1249084800000, 285657523],
            [1249171200000, 286053296],
            [1249257600000, 286228674],
            [1249344000000, 286409185],
            [1249430400000, 286578548],
            [1249516800000, 286767486],
            [1252281600000, 290866563]
        ],
        name: 'up',
        showInLegend: false,
        extra: {
            title: 'Up',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#6C8186'
        },
        showlabel: false,
        color: 'rgba(108,129,134,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1279238400000, 21782199
            ],
            [1279324800000, 43573807],
            [1279411200000, 62785337],
            [1279497600000, 72970702],
            [1279584000000, 82735839],
            [1279670400000, 91595161],
            [1279756800000, 100158412],
            [1279843200000, 113242131],
            [1279929600000, 129755003],
            [1280016000000, 142883424],
            [1280102400000, 148948901],
            [1280188800000, 155017120],
            [1280275200000, 160539271],
            [1280361600000, 165828496],
            [1280448000000, 174022724],
            [1280534400000, 184734433],
            [1280620800000, 193313741],
            [1280707200000, 197603131],
            [1280793600000, 201725628],
            [1280880000000, 205513834],
            [1280966400000, 209132099],
            [1281052800000, 214684135],
            [1281139200000, 222066943],
            [1281225600000, 227637569],
            [1281312000000, 230168703],
            [1281398400000, 232790746],
            [1281484800000, 235007121],
            [1281571200000, 237184431],
            [1281657600000, 240534666],
            [1281744000000, 245109347],
            [1281830400000, 248469482],
            [1281916800000, 250001841],
            [1282003200000, 251543257],
            [1282089600000, 252914303],
            [1282176000000, 254193415],
            [1282262400000, 256369989],
            [1282348800000, 259591932],
            [1282435200000, 262031594],
            [1282521600000, 262995039],
            [1282608000000, 263980341],
            [1282694400000, 264851540],
            [1282780800000, 265643564],
            [1282867200000, 267080412],
            [1282953600000, 269177315],
            [1283040000000, 270519920],
            [1283126400000, 271034171],
            [1283212800000, 271618513],
            [1283299200000, 272091844],
            [1283385600000, 272573254],
            [1283472000000, 273731041],
            [1283558400000, 275428323],
            [1283644800000, 277145503],
            [1283731200000, 278457609],
            [1283817600000, 278786943],
            [1283904000000, 279096351],
            [1283990400000, 279409588],
            [1284076800000, 280240959],
            [1284163200000, 281545938],
            [1284249600000, 282211978],
            [1284336000000, 282423176],
            [1284422400000, 282681228],
            [1284508800000, 282910644],
            [1284595200000, 283162718],
            [1284681600000, 283756520],
            [1284768000000, 284667199],
            [1284854400000, 285129855],
            [1284940800000, 285285981],
            [1285027200000, 285464113],
            [1285113600000, 285630280],
            [1285200000000, 285806286],
            [1285286400000, 286186454],
            [1285372800000, 286752223],
            [1285459200000, 287053292],
            [1285545600000, 287162351],
            [1285632000000, 287286362],
            [1285718400000, 287390686],
            [1285804800000, 287501168],
            [1285891200000, 287747677],
            [1285977600000, 288218801],
            [1286064000000, 288405376],
            [1286150400000, 288473692],
            [1286236800000, 288547701],
            [1286323200000, 288617960],
            [1286409600000, 288691296],
            [1286496000000, 288834210],
            [1286582400000, 289050885],
            [1286668800000, 289183607],
            [1286755200000, 289260086],
            [1286841600000, 289305974],
            [1286928000000, 289350076],
            [1287014400000, 289403621],
            [1287100800000, 289513715],
            [1287187200000, 289675498],
            [1287273600000, 289751947],
            [1287360000000, 289782527],
            [1287446400000, 289814553],
            [1287532800000, 289846799],
            [1287619200000, 289881124],
            [1287705600000, 290032216],
            [1287792000000, 290249239],
            [1287878400000, 290381264],
            [1287964800000, 290432773],
            [1288051200000, 290485827],
            [1288137600000, 290534298],
            [1288224000000, 290585677],
            [1288310400000, 290707149],
            [1288396800000, 290860263],
            [1288483200000, 290948208],
            [1288569600000, 290989663],
            [1288656000000, 291036750],
            [1288742400000, 291081483],
            [1288828800000, 291130914],
            [1288915200000, 291229134],
            [1289001600000, 291372655],
            [1289088000000, 291448103],
            [1289174400000, 291475429],
            [1289260800000, 291506627],
            [1289347200000, 291541268],
            [1289433600000, 291598079],
            [1289520000000, 291673925],
            [1289606400000, 291776496],
            [1289692800000, 291832593],
            [1289779200000, 291851666],
            [1289865600000, 291872747],
            [1289952000000, 291893655],
            [1290038400000, 291914445],
            [1290124800000, 291961256],
            [1290211200000, 292030157],
            [1290297600000, 292068095],
            [1290384000000, 292086685],
            [1290470400000, 292109784],
            [1290556800000, 292134454],
            [1290643200000, 292158289],
            [1290729600000, 292206346],
            [1290816000000, 292256470],
            [1290902400000, 292277755],
            [1290988800000, 292285843],
            [1291075200000, 292295872],
            [1291161600000, 292306278],
            [1291248000000, 292316474],
            [1291334400000, 292337628],
            [1291420800000, 292368529],
            [1291507200000, 292383900],
            [1291593600000, 292390103],
            [1291680000000, 292397527],
            [1291766400000, 292404654],
            [1291852800000, 292412237],
            [1291939200000, 292428991],
            [1292025600000, 292450670],
            [1292112000000, 292462233],
            [1292198400000, 292467452],
            [1292284800000, 292473458],
            [1292371200000, 292479104],
            [1292457600000, 292485544],
            [1292544000000, 292494108],
            [1292630400000, 292504404],
            [1292716800000, 292511473],
            [1292803200000, 292517082],
            [1292889600000, 292522501],
            [1292976000000, 292525041],
            [1293062400000, 292528592],
            [1293148800000, 292531112],
            [1293235200000, 292534130],
            [1293321600000, 292537649],
            [1293408000000, 292541086],
            [1293494400000, 292544734],
            [1293580800000, 292548316],
            [1293667200000, 292553519],
            [1293753600000, 292558188],
            [1293840000000, 292565212],
            [1293926400000, 292568851],
            [1294012800000, 292571392],
            [1294099200000, 292572697],
            [1294185600000, 292574501],
            [1294272000000, 292576195]
        ],
        name: 'inception',
        showInLegend: false,
        extra: {
            title: 'Inception',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#2A4452'
        },
        showlabel: false,
        color: 'rgba(42,68,82,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1353024000000, 71167839
            ],
            [1353110400000, 112610986],
            [1353196800000, 141067634],
            [1353283200000, 151158344],
            [1353369600000, 162930682],
            [1353456000000, 175709969],
            [1353542400000, 183724670],
            [1353628800000, 201270703],
            [1353715200000, 218287679],
            [1353801600000, 227366118],
            [1353888000000, 229919176],
            [1353974400000, 232640798],
            [1354060800000, 235025078],
            [1354147200000, 237182504],
            [1354233600000, 242683487],
            [1354320000000, 250209035],
            [1354406400000, 254598866],
            [1354492800000, 255813342],
            [1354579200000, 257255379],
            [1354665600000, 258392715],
            [1354752000000, 259534764],
            [1354838400000, 262368468],
            [1354924800000, 266338445],
            [1355011200000, 268691029],
            [1355097600000, 269403203],
            [1355184000000, 270260131],
            [1355270400000, 270972532],
            [1355356800000, 271690069],
            [1355443200000, 273174876],
            [1355529600000, 275431112],
            [1355616000000, 276826143],
            [1355702400000, 277349871],
            [1355788800000, 277958025],
            [1355875200000, 278452299],
            [1355961600000, 279005734],
            [1356048000000, 279767245],
            [1356134400000, 280777073],
            [1356220800000, 281632689],
            [1356307200000, 281978951],
            [1356393600000, 282440200],
            [1356480000000, 283023753],
            [1356566400000, 283679776],
            [1356652800000, 284456103],
            [1356739200000, 285314150],
            [1356825600000, 286039065],
            [1356912000000, 286422893],
            [1356998400000, 287027873],
            [1357084800000, 287405261],
            [1357171200000, 287756286],
            [1357257600000, 288206817],
            [1357344000000, 288810496],
            [1357430400000, 289133356],
            [1357516800000, 289235462],
            [1357603200000, 289342066],
            [1357689600000, 289434980],
            [1357776000000, 289529578],
            [1357862400000, 289705078],
            [1357948800000, 290003237],
            [1358035200000, 290177709],
            [1358121600000, 290226048],
            [1358208000000, 290281174],
            [1358294400000, 290330268],
            [1358380800000, 290380023],
            [1358467200000, 290465049],
            [1358553600000, 290611508],
            [1358640000000, 290713795],
            [1358726400000, 290783012],
            [1358812800000, 290808255],
            [1358899200000, 290830614],
            [1358985600000, 290854955],
            [1359072000000, 290906852],
            [1359158400000, 291012683],
            [1359244800000, 291075689],
            [1359331200000, 291093659],
            [1359417600000, 291110574],
            [1359504000000, 291126795],
            [1359590400000, 291145090],
            [1359676800000, 291186388],
            [1359763200000, 291255883],
            [1359849600000, 291281778],
            [1359936000000, 291293425],
            [1360022400000, 291305993],
            [1360108800000, 291317196],
            [1360195200000, 291329468],
            [1360281600000, 291354213],
            [1360368000000, 291402865],
            [1360454400000, 291429273],
            [1360540800000, 291437864],
            [1360627200000, 291445450],
            [1360713600000, 291452597],
            [1360800000000, 291493506],
            [1360886400000, 291562677],
            [1360972800000, 291681738],
            [1361059200000, 291779219],
            [1361145600000, 291838804],
            [1361232000000, 291864406],
            [1361318400000, 291887115],
            [1361404800000, 291910431],
            [1361491200000, 291967156],
            [1361577600000, 292064574],
            [1361664000000, 292123221],
            [1361750400000, 292138468],
            [1361836800000, 292153900],
            [1361923200000, 292169318],
            [1362009600000, 292184928],
            [1362096000000, 292219306],
            [1362182400000, 292270006],
            [1362268800000, 292298923],
            [1362355200000, 292305827],
            [1362441600000, 292312252],
            [1362528000000, 292318344],
            [1362614400000, 292324737]
        ],
        name: 'breakingdawn2',
        showInLegend: false,
        extra: {
            title: 'The Twilight Saga: Breaking Dawn Part 2',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#282324'
        },
        showlabel: false,
        color: 'rgba(40,35,36,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1184112000000, 44232338
            ],
            [1184198400000, 62606743],
            [1184284800000, 88448728],
            [1184371200000, 116759603],
            [1184457600000, 139715157],
            [1184544000000, 150130637],
            [1184630400000, 159300110],
            [1184716800000, 167738316],
            [1184803200000, 175355515],
            [1184889600000, 185570955],
            [1184976000000, 197852087],
            [1185062400000, 207866865],
            [1185148800000, 212681190],
            [1185235200000, 217083411],
            [1185321600000, 220998765],
            [1185408000000, 224706129],
            [1185494400000, 229771951],
            [1185580800000, 236845162],
            [1185667200000, 242439214],
            [1185753600000, 244877588],
            [1185840000000, 247191583],
            [1185926400000, 249357836],
            [1186012800000, 251505177],
            [1186099200000, 254167413],
            [1186185600000, 257955350],
            [1186272000000, 261027397],
            [1186358400000, 262654623],
            [1186444800000, 264078779],
            [1186531200000, 265421089],
            [1186617600000, 266615258],
            [1186704000000, 268189964],
            [1186790400000, 270279145],
            [1186876800000, 272047388],
            [1186963200000, 272828538],
            [1187049600000, 273600922],
            [1187136000000, 274339341],
            [1187222400000, 275105738],
            [1187308800000, 276024166],
            [1187395200000, 277478561],
            [1187481600000, 278762117],
            [1187568000000, 279316414],
            [1187654400000, 279874898],
            [1187740800000, 280357192],
            [1187827200000, 280828522],
            [1187913600000, 281449810],
            [1188000000000, 282474644],
            [1188086400000, 283230934],
            [1188172800000, 283497083],
            [1188259200000, 283758464],
            [1188345600000, 284001859],
            [1188432000000, 284250119],
            [1188518400000, 284676422],
            [1188604800000, 285382001],
            [1188691200000, 286143377],
            [1188777600000, 286825495],
            [1188864000000, 286953794],
            [1188950400000, 287061120],
            [1189036800000, 287169841],
            [1189123200000, 287400025],
            [1189209600000, 287872348],
            [1189296000000, 288201180],
            [1189382400000, 288272389],
            [1189468800000, 288352825],
            [1189555200000, 288431663],
            [1189641600000, 288522854],
            [1189728000000, 288709631],
            [1189814400000, 289101136],
            [1189900800000, 289326081],
            [1189987200000, 289378233],
            [1190073600000, 289427462],
            [1190160000000, 289474993],
            [1190246400000, 289527287],
            [1190332800000, 289602519],
            [1190419200000, 289763733],
            [1190505600000, 289855714],
            [1190592000000, 289877935],
            [1190678400000, 289899666],
            [1190764800000, 289923160],
            [1190851200000, 289945599],
            [1190937600000, 290001838],
            [1191024000000, 290109640],
            [1191110400000, 290175378],
            [1191196800000, 290189393],
            [1191283200000, 290204624],
            [1191369600000, 290219263],
            [1191456000000, 290234807],
            [1191542400000, 290327071],
            [1191628800000, 290481029],
            [1191715200000, 290598256],
            [1191801600000, 290657775],
            [1191888000000, 290690107],
            [1191974400000, 290721282],
            [1192060800000, 290753534],
            [1192147200000, 290829377],
            [1192233600000, 290959632],
            [1192320000000, 291041408],
            [1192406400000, 291063228],
            [1192492800000, 291085520],
            [1192579200000, 291107643],
            [1192665600000, 291132139],
            [1192752000000, 291190799],
            [1192838400000, 291287507],
            [1192924800000, 291340445],
            [1193011200000, 291354592],
            [1193097600000, 291371246],
            [1193184000000, 291387658],
            [1193270400000, 291404188],
            [1193356800000, 291444790],
            [1193443200000, 291512115],
            [1193529600000, 291551968],
            [1193616000000, 291562236],
            [1193702400000, 291573302],
            [1193788800000, 291585591],
            [1193875200000, 291597207],
            [1193961600000, 291624499],
            [1194048000000, 291679480],
            [1194134400000, 291704500],
            [1194220800000, 291710663],
            [1194307200000, 291717080],
            [1194393600000, 291722636],
            [1194480000000, 291729787],
            [1194566400000, 291752116],
            [1194652800000, 291787663],
            [1194739200000, 291808642],
            [1194825600000, 291818699],
            [1194912000000, 291822222],
            [1194998400000, 291825691],
            [1195084800000, 291829680],
            [1195171200000, 291843436],
            [1195257600000, 291866602],
            [1195344000000, 291880420],
            [1195430400000, 291884213],
            [1195516800000, 291888789],
            [1195603200000, 291895526],
            [1195689600000, 291899574],
            [1195776000000, 291914232],
            [1195862400000, 291934860],
            [1195948800000, 291946208],
            [1196035200000, 291948969],
            [1196121600000, 291951868],
            [1196208000000, 291954450],
            [1196294400000, 291957074],
            [1196380800000, 291963190],
            [1196467200000, 291972312],
            [1196553600000, 291980108],
            [1196640000000, 291982804],
            [1196726400000, 291985483],
            [1196812800000, 291987958],
            [1196899200000, 291990592],
            [1196985600000, 291993034],
            [1197072000000, 291997435],
            [1197158400000, 292000866],
            [1197244800000, 292001817],
            [1197331200000, 292002846],
            [1197417600000, 292003714],
            [1197504000000, 292004738]
        ],
        name: 'harrypotter5',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Order of the Phoenix',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#292228'
        },
        showlabel: false,
        color: 'rgba(41,34,40,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1134086400000, 23006856
            ],
            [1134172800000, 48332871],
            [1134259200000, 65556312],
            [1134345600000, 70159464],
            [1134432000000, 74186139],
            [1134518400000, 77693647],
            [1134604800000, 81331961],
            [1134691200000, 90342036],
            [1134777600000, 103345544],
            [1134864000000, 113169644],
            [1134950400000, 117824308],
            [1135036800000, 122739357],
            [1135123200000, 127679743],
            [1135209600000, 133442840],
            [1135296000000, 141373715],
            [1135382400000, 146114483],
            [1135468800000, 153220802],
            [1135555200000, 165135135],
            [1135641600000, 174359262],
            [1135728000000, 183116192],
            [1135814400000, 191991322],
            [1135900800000, 201694884],
            [1135987200000, 209440087],
            [1136073600000, 217677877],
            [1136160000000, 225703346],
            [1136246400000, 228281863],
            [1136332800000, 230181967],
            [1136419200000, 232134689],
            [1136505600000, 236161362],
            [1136592000000, 243291068],
            [1136678400000, 247777824],
            [1136764800000, 248649542],
            [1136851200000, 249524985],
            [1136937600000, 250357188],
            [1137024000000, 251211092],
            [1137110400000, 253544785],
            [1137196800000, 257928733],
            [1137283200000, 261270848],
            [1137369600000, 264020859],
            [1137456000000, 264587877],
            [1137542400000, 265086453],
            [1137628800000, 265615568],
            [1137715200000, 267056212],
            [1137801600000, 270103044],
            [1137888000000, 271852138],
            [1137974400000, 272245169],
            [1138060800000, 272603413],
            [1138147200000, 272958563],
            [1138233600000, 273362318],
            [1138320000000, 274394934],
            [1138406400000, 276442471],
            [1138492800000, 277867308],
            [1138579200000, 278133732],
            [1138665600000, 278379730],
            [1138752000000, 278613817],
            [1138838400000, 278862289],
            [1138924800000, 279582921],
            [1139011200000, 281305928],
            [1139097600000, 281934379],
            [1139184000000, 282115799],
            [1139270400000, 282292434],
            [1139356800000, 282461094],
            [1139443200000, 282669443],
            [1139529600000, 283128172],
            [1139616000000, 284129478],
            [1139702400000, 284742799],
            [1139788800000, 284905791],
            [1139875200000, 285163208],
            [1139961600000, 285283677],
            [1140048000000, 285418612],
            [1140134400000, 285683065],
            [1140220800000, 286254179],
            [1140307200000, 286745514],
            [1140393600000, 287153504],
            [1140480000000, 287265777],
            [1140566400000, 287371320],
            [1140652800000, 287482269]
        ],
        name: 'narnia',
        showInLegend: false,
        extra: {
            title: 'The Chronicles of Narnia: The Lion, the Witch and the ' +
                'Wardrobe',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#7B8473'
        },
        showlabel: false,
        color: 'rgba(123,132,115,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1371081600000, 12062124
            ],
            [1371168000000, 56075491],
            [1371254400000, 92390809],
            [1371340800000, 128681486],
            [1371427200000, 141266491],
            [1371513600000, 152777618],
            [1371600000000, 161779897],
            [1371686400000, 168790947],
            [1371772800000, 181337960],
            [1371859200000, 197549357],
            [1371945600000, 210078153],
            [1372032000000, 214615316],
            [1372118400000, 219812745],
            [1372204800000, 223924818],
            [1372291200000, 227840106],
            [1372377600000, 233848694],
            [1372464000000, 242212479],
            [1372550400000, 248577596],
            [1372636800000, 251621616],
            [1372723200000, 254405846],
            [1372809600000, 256758983],
            [1372896000000, 259774153],
            [1372982400000, 263680363],
            [1373068800000, 267939736],
            [1373155200000, 271188450],
            [1373241600000, 272461943],
            [1373328000000, 273930420],
            [1373414400000, 275158775],
            [1373500800000, 276169878],
            [1373587200000, 277533036],
            [1373673600000, 279477877],
            [1373760000000, 280888962],
            [1373846400000, 281481205],
            [1373932800000, 282193653],
            [1374019200000, 282735742],
            [1374105600000, 283181087],
            [1374192000000, 283685516],
            [1374278400000, 284430380],
            [1374364800000, 285000474],
            [1374451200000, 285253826],
            [1374537600000, 285574854],
            [1374624000000, 285827010],
            [1374710400000, 286058272],
            [1374796800000, 286271454],
            [1374883200000, 286579932],
            [1374969600000, 286807505],
            [1375056000000, 286912067],
            [1375142400000, 287034077],
            [1375228800000, 287122365],
            [1375315200000, 287214823],
            [1375401600000, 287352684],
            [1375488000000, 287542311],
            [1375574400000, 287681397],
            [1375660800000, 287756503],
            [1375747200000, 287829106],
            [1375833600000, 287879627],
            [1375920000000, 287931663],
            [1376006400000, 288147988],
            [1376092800000, 288446624],
            [1376179200000, 288681970],
            [1376265600000, 288793806],
            [1376352000000, 288923009],
            [1376438400000, 289023787],
            [1376524800000, 289121541],
            [1376611200000, 289267114],
            [1376697600000, 289478094],
            [1376784000000, 289633849],
            [1376870400000, 289694329],
            [1376956800000, 289760857],
            [1377043200000, 289816740],
            [1377129600000, 289875976],
            [1377216000000, 289977702],
            [1377302400000, 290132377],
            [1377388800000, 290229822],
            [1377475200000, 290265876],
            [1377561600000, 290298851],
            [1377648000000, 290327998],
            [1377734400000, 290360082],
            [1377820800000, 290429085],
            [1377907200000, 290539762],
            [1377993600000, 290650276],
            [1378080000000, 290750257],
            [1378166400000, 290769852],
            [1378252800000, 290787683],
            [1378339200000, 290804657],
            [1378425600000, 290835765],
            [1378512000000, 290891835],
            [1378598400000, 290925471],
            [1378684800000, 290933455],
            [1378771200000, 290942556],
            [1378857600000, 290951711],
            [1378944000000, 290960548],
            [1379030400000, 290978103],
            [1379116800000, 291005463],
            [1379203200000, 291021565],
            [1379289600000, 291027297],
            [1379376000000, 291033976],
            [1379462400000, 291039585],
            [1379548800000, 291045518]
        ],
        name: 'superman2012',
        showInLegend: false,
        extra: {
            title: 'Man of Steel',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#54555E'
        },
        showlabel: false,
        color: 'rgba(84,85,94,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                327715200000, 1333305
            ],
            [327801600000, 2341114],
            [327888000000, 3738470],
            [327974400000, 5473664],
            [328060800000, 7244308],
            [328147200000, 8756918],
            [328233600000, 9612663]
        ],
        name: 'starwars5',
        showInLegend: false,
        extra: {
            title: 'The Empire Strikes Back',
            genre: 'Sci-Fi Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#6F6776'
        },
        showlabel: false,
        color: 'rgba(111,103,118,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1132272000000, 40118363
            ],
            [1132358400000, 76837498],
            [1132444800000, 102685961],
            [1132531200000, 110741182],
            [1132617600000, 119743524],
            [1132704000000, 133873907],
            [1132790400000, 146283069],
            [1132876800000, 169054371],
            [1132963200000, 189258709],
            [1133049600000, 201010207],
            [1133136000000, 203451580],
            [1133222400000, 205596807],
            [1133308800000, 207544120],
            [1133395200000, 209388580],
            [1133481600000, 214759672],
            [1133568000000, 223645889],
            [1133654400000, 229266716],
            [1133740800000, 230406014],
            [1133827200000, 231560213],
            [1133913600000, 232682657],
            [1134000000000, 233803862],
            [1134086400000, 236505381],
            [1134172800000, 241081967],
            [1134259200000, 244069305],
            [1134345600000, 244763756],
            [1134432000000, 245469136],
            [1134518400000, 246064434],
            [1134604800000, 246645807],
            [1134691200000, 248143019],
            [1134777600000, 250661379],
            [1134864000000, 252598259],
            [1134950400000, 253482480],
            [1135036800000, 254485801],
            [1135123200000, 255492998],
            [1135209600000, 256715413],
            [1135296000000, 258323753],
            [1135382400000, 259322733],
            [1135468800000, 260631396],
            [1135555200000, 263139532],
            [1135641600000, 265344891],
            [1135728000000, 267407264],
            [1135814400000, 269447715],
            [1135900800000, 271513749],
            [1135987200000, 273281180],
            [1136073600000, 275132632],
            [1136160000000, 277083157],
            [1136246400000, 277724469],
            [1136332800000, 278194876],
            [1136419200000, 278658114],
            [1136505600000, 279361975],
            [1136592000000, 280587070],
            [1136678400000, 281516498],
            [1136764800000, 281694723],
            [1136851200000, 281877727],
            [1136937600000, 282050064],
            [1137024000000, 282228377],
            [1137110400000, 282537890],
            [1137196800000, 283257991],
            [1137283200000, 283872840],
            [1137369600000, 284361860],
            [1137456000000, 284462320],
            [1137542400000, 284553620],
            [1137628800000, 284649794],
            [1137715200000, 284819289],
            [1137801600000, 285258059],
            [1137888000000, 285538219],
            [1137974400000, 285594228],
            [1138060800000, 285646194],
            [1138147200000, 285704252],
            [1138233600000, 285762909],
            [1138320000000, 285864352],
            [1138406400000, 286114734],
            [1138492800000, 286301035],
            [1138579200000, 286335255],
            [1138665600000, 286368477],
            [1138752000000, 286400914],
            [1138838400000, 286435732],
            [1138924800000, 286526288],
            [1139011200000, 286731761],
            [1139097600000, 286822905],
            [1139184000000, 286844768],
            [1139270400000, 286868174],
            [1139356800000, 286891550],
            [1139443200000, 286919411],
            [1139529600000, 286979339],
            [1139616000000, 287109964],
            [1139702400000, 287180682],
            [1139788800000, 287199126],
            [1139875200000, 287228711],
            [1139961600000, 287246765],
            [1140048000000, 287265347],
            [1140134400000, 287403465],
            [1140220800000, 287688005],
            [1140307200000, 287917479],
            [1140393600000, 288060759],
            [1140480000000, 288116995],
            [1140566400000, 288167238],
            [1140652800000, 288218866],
            [1140739200000, 288346874],
            [1140825600000, 288584493],
            [1140912000000, 288733970],
            [1140998400000, 288768020],
            [1141084800000, 288801149],
            [1141171200000, 288832035],
            [1141257600000, 288870728],
            [1141344000000, 288945835],
            [1141430400000, 289094189],
            [1141516800000, 289188779],
            [1141603200000, 289210520],
            [1141689600000, 289231066],
            [1141776000000, 289249651],
            [1141862400000, 289271112],
            [1141948800000, 289321661],
            [1142035200000, 289413229],
            [1142121600000, 289472171],
            [1142208000000, 289489093],
            [1142294400000, 289509862],
            [1142380800000, 289527647],
            [1142467200000, 289546416],
            [1142553600000, 289590103],
            [1142640000000, 289663408],
            [1142726400000, 289710552],
            [1142812800000, 289719985],
            [1142899200000, 289730990],
            [1142985600000, 289740529],
            [1143072000000, 289751002],
            [1143158400000, 289785952],
            [1143244800000, 289842397],
            [1143331200000, 289877755],
            [1143417600000, 289884829],
            [1143504000000, 289893302],
            [1143590400000, 289900226],
            [1143676800000, 289908213],
            [1143763200000, 289932678],
            [1143849600000, 289971061],
            [1143936000000, 289994397],
            [1144022400000, 289998641],
            [1144108800000, 290004148],
            [1144195200000, 290008164],
            [1144281600000, 290013036]
        ],
        name: 'harrypotter4',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Goblet of Fire',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#1C262B'
        },
        showlabel: false,
        color: 'rgba(28,38,43,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1004659200000, 17806294
            ],
            [1004745600000, 44336578],
            [1004832000000, 62577067],
            [1004918400000, 66324282],
            [1005004800000, 70375603],
            [1005091200000, 73265584],
            [1005177600000, 76599345],
            [1005264000000, 87957717],
            [1005350400000, 107752209],
            [1005436800000, 122150373],
            [1005523200000, 128884312],
            [1005609600000, 130559368],
            [1005696000000, 132075351],
            [1005782400000, 133624433],
            [1005868800000, 139381561],
            [1005955200000, 149648898],
            [1006041600000, 156341118],
            [1006128000000, 157743626],
            [1006214400000, 159711222],
            [1006300800000, 163713833],
            [1006387200000, 168174824],
            [1006473600000, 178088639],
            [1006560000000, 187387850],
            [1006646400000, 192229825],
            [1006732800000, 193010497],
            [1006819200000, 193702361],
            [1006905600000, 194288867],
            [1006992000000, 194920064],
            [1007078400000, 197176459],
            [1007164800000, 201402277],
            [1007251200000, 204025728],
            [1007337600000, 204434943],
            [1007424000000, 204906369],
            [1007510400000, 205334355],
            [1007596800000, 205793571],
            [1007683200000, 207390778],
            [1007769600000, 210538427],
            [1007856000000, 212391025],
            [1007942400000, 212729515],
            [1008028800000, 213112345],
            [1008115200000, 213472323],
            [1008201600000, 213834889],
            [1008288000000, 214989143],
            [1008374400000, 217313177],
            [1008460800000, 218815112],
            [1008547200000, 219182893],
            [1008633600000, 219623764],
            [1008720000000, 220074784],
            [1008806400000, 220649024],
            [1008892800000, 221631742],
            [1008979200000, 223100894],
            [1009065600000, 224450540],
            [1009152000000, 225385745],
            [1009238400000, 226348671],
            [1009324800000, 227923855],
            [1009411200000, 229744970],
            [1009497600000, 231827828],
            [1009584000000, 234008282],
            [1009670400000, 235848871],
            [1009756800000, 237466244],
            [1009843200000, 239190413],
            [1009929600000, 240066064],
            [1010016000000, 240760811],
            [1010102400000, 241753523],
            [1010188800000, 243705559],
            [1010275200000, 244638458],
            [1010361600000, 244833161],
            [1010448000000, 244993157],
            [1010534400000, 245124042],
            [1010620800000, 245262817],
            [1010707200000, 245688044],
            [1010793600000, 246775172],
            [1010880000000, 247458486],
            [1010966400000, 247574084],
            [1011052800000, 247690334],
            [1011139200000, 247798021],
            [1011225600000, 247907283],
            [1011312000000, 248161906],
            [1011398400000, 248775349],
            [1011484800000, 249291311],
            [1011571200000, 249919653],
            [1011657600000, 249995864],
            [1011744000000, 250058575],
            [1011830400000, 250121379],
            [1011916800000, 250211850],
            [1012003200000, 250490315],
            [1012089600000, 250676747],
            [1012176000000, 250716060],
            [1012262400000, 250750795],
            [1012348800000, 250786271],
            [1012435200000, 250822376]
        ],
        name: 'monstersinc',
        showInLegend: false,
        extra: {
            title: 'Monsters, Inc.',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#B2C8C7'
        },
        showlabel: false,
        color: 'rgba(178,200,199,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1447977600000, 45579056
            ],
            [1448064000000, 79420425],
            [1448150400000, 102665981],
            [1448236800000, 111206338],
            [1448323200000, 122562341],
            [1448409600000, 136225792],
            [1448496000000, 146540534],
            [1448582400000, 167804466],
            [1448668800000, 188019699],
            [1448755200000, 198545129],
            [1448841600000, 201091347],
            [1448928000000, 204193802],
            [1449014400000, 206380154],
            [1449100800000, 208512000],
            [1449187200000, 214176847],
            [1449273600000, 222477857],
            [1449360000000, 227369547],
            [1449446400000, 228735455],
            [1449532800000, 230525838],
            [1449619200000, 231906120],
            [1449705600000, 233190956],
            [1449792000000, 236497731],
            [1449878400000, 241519565],
            [1449964800000, 244604272],
            [1450051200000, 245626798],
            [1450137600000, 246883184],
            [1450224000000, 247913304],
            [1450310400000, 248788774],
            [1450396800000, 250332197],
            [1450483200000, 252631324],
            [1450569600000, 254481457],
            [1450656000000, 255685045],
            [1450742400000, 257118683],
            [1450828800000, 258443061],
            [1450915200000, 259262857],
            [1451001600000, 260765485],
            [1451088000000, 262824809],
            [1451174400000, 264540685],
            [1451260800000, 265885848],
            [1451347200000, 267244461],
            [1451433600000, 268547959],
            [1451520000000, 269569121],
            [1451606400000, 271309533],
            [1451692800000, 273156255],
            [1451779200000, 274185395],
            [1451865600000, 274573566],
            [1451952000000, 274934139],
            [1452038400000, 275222668],
            [1452124800000, 275471610],
            [1452211200000, 276060848],
            [1452297600000, 277042909],
            [1452384000000, 277578497],
            [1452470400000, 277723849],
            [1452556800000, 277901047],
            [1452643200000, 278050410],
            [1452729600000, 278178868],
            [1452816000000, 278475812],
            [1452902400000, 278964297],
            [1452988800000, 279311004],
            [1453075200000, 279599584],
            [1453161600000, 279691680],
            [1453248000000, 279757333],
            [1453334400000, 279825074],
            [1453420800000, 279954145],
            [1453507200000, 280196900],
            [1453593600000, 280302457],
            [1453680000000, 280340080],
            [1453766400000, 280388309],
            [1453852800000, 280429452],
            [1453939200000, 280467490],
            [1454025600000, 280540492],
            [1454112000000, 280670293],
            [1454198400000, 280737534],
            [1454284800000, 280757126],
            [1454371200000, 280779813],
            [1454457600000, 280798321],
            [1454544000000, 280813773],
            [1454630400000, 280863508],
            [1454716800000, 280950463],
            [1454803200000, 280976000],
            [1454889600000, 280989632],
            [1454976000000, 281005174],
            [1455062400000, 281018635],
            [1455148800000, 281032486],
            [1455235200000, 281103773],
            [1455321600000, 281226658],
            [1455408000000, 281340856],
            [1455494400000, 281402464],
            [1455580800000, 281428973],
            [1455667200000, 281450204],
            [1455753600000, 281473188],
            [1455840000000, 281524890],
            [1455926400000, 281613822],
            [1456012800000, 281666058],
            [1456099200000, 281679486],
            [1456185600000, 281694464],
            [1456272000000, 281708566],
            [1456358400000, 281723902]
        ],
        name: 'hungergames4',
        showInLegend: false,
        extra: {
            title: 'The Hunger Games: Mockingjay - Part 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#692C18'
        },
        showlabel: false,
        color: 'rgba(105,44,24,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1052870400000, 5000000
            ],
            [1052956800000, 42508303],
            [1053043200000, 73838696],
            [1053129600000, 108227933],
            [1053216000000, 134282716],
            [1053302400000, 144391066],
            [1053388800000, 151919513],
            [1053475200000, 158242565],
            [1053561600000, 163869725],
            [1053648000000, 174197918],
            [1053734400000, 188645514],
            [1053820800000, 200773759],
            [1053907200000, 209481877],
            [1053993600000, 212271109],
            [1054080000000, 214706401],
            [1054166400000, 217013805],
            [1054252800000, 221334173],
            [1054339200000, 228246730],
            [1054425600000, 232701046],
            [1054512000000, 234183237],
            [1054598400000, 235801657],
            [1054684800000, 237185030],
            [1054771200000, 238592411],
            [1054857600000, 241161591],
            [1054944000000, 245143156],
            [1055030400000, 247778753],
            [1055116800000, 248755932],
            [1055203200000, 249783329],
            [1055289600000, 250729765],
            [1055376000000, 251741215],
            [1055462400000, 253282914],
            [1055548800000, 255659501],
            [1055635200000, 257486680],
            [1055721600000, 258191894],
            [1055808000000, 258958101],
            [1055894400000, 259696494],
            [1055980800000, 260458950],
            [1056067200000, 261565554],
            [1056153600000, 263190913],
            [1056240000000, 264401442],
            [1056326400000, 264889557],
            [1056412800000, 265432894],
            [1056499200000, 265916314],
            [1056585600000, 266404336],
            [1056672000000, 267123013],
            [1056758400000, 268186586],
            [1056844800000, 268979763],
            [1056931200000, 269409164],
            [1057017600000, 269764559],
            [1057104000000, 270030677],
            [1057190400000, 270382129],
            [1057276800000, 270750220],
            [1057363200000, 271479352],
            [1057449600000, 271936550],
            [1057536000000, 272158979],
            [1057622400000, 272403452],
            [1057708800000, 272591636],
            [1057795200000, 272793059],
            [1057881600000, 273141511],
            [1057968000000, 273601213],
            [1058054400000, 273905370],
            [1058140800000, 274053718],
            [1058227200000, 274226007],
            [1058313600000, 274395156],
            [1058400000000, 274536813],
            [1058486400000, 274745978],
            [1058572800000, 275040397],
            [1058659200000, 275254281],
            [1058745600000, 275363721],
            [1058832000000, 275490913],
            [1058918400000, 275606049],
            [1059004800000, 275720183],
            [1059091200000, 275861715],
            [1059177600000, 276087756],
            [1059264000000, 276231510],
            [1059350400000, 276309671],
            [1059436800000, 276397114],
            [1059523200000, 276480241],
            [1059609600000, 276572478],
            [1059696000000, 276722203],
            [1059782400000, 276933266],
            [1059868800000, 277084749],
            [1059955200000, 277162049],
            [1060041600000, 277248553],
            [1060128000000, 277326774],
            [1060214400000, 277404217],
            [1060300800000, 277507027],
            [1060387200000, 277656614],
            [1060473600000, 277767531],
            [1060560000000, 277824740],
            [1060646400000, 277886167],
            [1060732800000, 277940853],
            [1060819200000, 277990218],
            [1060905600000, 278069675],
            [1060992000000, 278196905],
            [1061078400000, 278285565],
            [1061164800000, 278336774],
            [1061251200000, 278395393],
            [1061337600000, 278452455],
            [1061424000000, 278507722],
            [1061510400000, 278593714],
            [1061596800000, 278726872],
            [1061683200000, 278821645],
            [1061769600000, 278869997],
            [1061856000000, 278912261],
            [1061942400000, 278951610],
            [1062028800000, 278996682],
            [1062115200000, 279138009],
            [1062201600000, 279372421],
            [1062288000000, 279617572],
            [1062374400000, 279771818],
            [1062460800000, 279839016],
            [1062547200000, 279894376],
            [1062633600000, 279944861],
            [1062720000000, 280053597],
            [1062806400000, 280226920],
            [1062892800000, 280332223],
            [1062979200000, 280360125],
            [1063065600000, 280394271],
            [1063152000000, 280422549],
            [1063238400000, 280451587],
            [1063324800000, 280507077],
            [1063411200000, 280591193],
            [1063497600000, 280644783],
            [1063584000000, 280663243],
            [1063670400000, 280690113],
            [1063756800000, 280714088],
            [1063843200000, 280738253],
            [1063929600000, 280779296],
            [1064016000000, 280839798],
            [1064102400000, 280872150],
            [1064188800000, 280884126],
            [1064275200000, 280900365],
            [1064361600000, 280916911],
            [1064448000000, 280931812],
            [1064534400000, 280963314],
            [1064620800000, 281022240],
            [1064707200000, 281048966],
            [1064793600000, 281060109],
            [1064880000000, 281071684],
            [1064966400000, 281083738],
            [1065052800000, 281097951],
            [1065139200000, 281124748],
            [1065225600000, 281170700],
            [1065312000000, 281193463],
            [1065398400000, 281202593],
            [1065484800000, 281213130],
            [1065571200000, 281222974],
            [1065657600000, 281232980],
            [1065744000000, 281253060],
            [1065830400000, 281287950],
            [1065916800000, 281311105],
            [1066003200000, 281324446],
            [1066089600000, 281333135],
            [1066176000000, 281341246],
            [1066262400000, 281348916],
            [1066348800000, 281367190],
            [1066435200000, 281397289],
            [1066521600000, 281414042],
            [1066608000000, 281419044],
            [1066694400000, 281425656],
            [1066780800000, 281431594],
            [1066867200000, 281437768],
            [1066953600000, 281452580],
            [1067040000000, 281477784],
            [1067126400000, 281492479],
            [1067212800000, 281497391],
            [1067299200000, 281502133],
            [1067385600000, 281509438],
            [1067472000000, 281519061]
        ],
        name: 'matrixreloaded',
        showInLegend: false,
        extra: {
            title: 'The Matrix Reloaded',
            genre: 'Sci-Fi Action',

            mpaaRating: 'R',
            imgMainColor: '#BFCEC9'
        },
        showlabel: false,
        color: 'rgba(191,206,201,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1321574400000, 71642526
            ],
            [1321660800000, 111671729],
            [1321747200000, 138122261],
            [1321833600000, 147975742],
            [1321920000000, 158978162],
            [1322006400000, 171415726],
            [1322092800000, 179148435],
            [1322179200000, 195837646],
            [1322265600000, 212201624],
            [1322352000000, 220832009],
            [1322438400000, 223357778],
            [1322524800000, 226000702],
            [1322611200000, 228151826],
            [1322697600000, 230390944],
            [1322784000000, 235843083],
            [1322870400000, 242923514],
            [1322956800000, 246926409],
            [1323043200000, 248073698],
            [1323129600000, 249388809],
            [1323216000000, 250457900],
            [1323302400000, 251583267],
            [1323388800000, 254039462],
            [1323475200000, 257437655],
            [1323561600000, 259402669],
            [1323648000000, 260051891],
            [1323734400000, 260800141],
            [1323820800000, 261451406],
            [1323907200000, 262130081],
            [1323993600000, 263408396],
            [1324080000000, 265122670],
            [1324166400000, 266327974],
            [1324252800000, 266979401],
            [1324339200000, 267677356],
            [1324425600000, 268192542],
            [1324512000000, 268801901],
            [1324598400000, 269473777],
            [1324684800000, 269756147],
            [1324771200000, 270268207],
            [1324857600000, 271182842],
            [1324944000000, 271954045],
            [1325030400000, 272707327],
            [1325116800000, 273469796],
            [1325203200000, 274336476],
            [1325289600000, 274841954],
            [1325376000000, 275530738],
            [1325462400000, 276125476],
            [1325548800000, 276424872],
            [1325635200000, 276675234],
            [1325721600000, 276943638],
            [1325808000000, 277381260],
            [1325894400000, 278046837],
            [1325980800000, 278415733],
            [1326067200000, 278523854],
            [1326153600000, 278649777],
            [1326240000000, 278762429],
            [1326326400000, 278869685],
            [1326412800000, 279071595],
            [1326499200000, 279399659],
            [1326585600000, 279638999],
            [1326672000000, 279795163],
            [1326758400000, 279846752],
            [1326844800000, 279897264],
            [1326931200000, 279953739],
            [1327017600000, 280037393],
            [1327104000000, 280186187],
            [1327190400000, 280262457],
            [1327276800000, 280288438],
            [1327363200000, 280315261],
            [1327449600000, 280342554],
            [1327536000000, 280371424],
            [1327622400000, 280417912],
            [1327708800000, 280493660],
            [1327795200000, 280536135],
            [1327881600000, 280549715],
            [1327968000000, 280565334],
            [1328054400000, 280580142],
            [1328140800000, 280596710],
            [1328227200000, 280680424],
            [1328313600000, 280817765],
            [1328400000000, 280876465],
            [1328486400000, 280903699],
            [1328572800000, 280935066],
            [1328659200000, 280961542],
            [1328745600000, 280989889],
            [1328832000000, 281042709],
            [1328918400000, 281117198],
            [1329004800000, 281158172],
            [1329091200000, 281170130],
            [1329177600000, 281190708],
            [1329264000000, 281200993],
            [1329350400000, 281213345],
            [1329436800000, 281228461],
            [1329523200000, 281251357],
            [1329609600000, 281267663],
            [1329696000000, 281275991],
            [1329782400000, 281279968],
            [1329868800000, 281283220],
            [1329955200000, 281287133]
        ],
        name: 'breakingdawn',
        showInLegend: false,
        extra: {
            title: 'The Twilight Saga: Breaking Dawn Part 1',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#4E2E23'
        },
        showlabel: false,
        color: 'rgba(78,46,35,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1103673600000, 12066740
            ],
            [1103760000000, 24396740],
            [1103846400000, 31555870],
            [1103932800000, 51098360],
            [1104019200000, 70517720],
            [1104105600000, 84431410],
            [1104192000000, 97061030],
            [1104278400000, 108547305],
            [1104364800000, 120719585],
            [1104451200000, 132859765],
            [1104537600000, 151131705],
            [1104624000000, 162461370],
            [1104710400000, 166883990],
            [1104796800000, 170073210],
            [1104883200000, 172874790],
            [1104969600000, 175799710],
            [1105056000000, 184634845],
            [1105142400000, 197578935],
            [1105228800000, 204297870],
            [1105315200000, 206149545],
            [1105401600000, 208196540],
            [1105488000000, 209959990],
            [1105574400000, 211794030],
            [1105660800000, 217409350],
            [1105747200000, 225636965],
            [1105833600000, 231110125],
            [1105920000000, 234308680],
            [1106006400000, 235499270],
            [1106092800000, 236494390],
            [1106179200000, 237560725],
            [1106265600000, 240799965],
            [1106352000000, 245055775],
            [1106438400000, 247243985],
            [1106524800000, 248019335],
            [1106611200000, 248829900],
            [1106697600000, 249570790],
            [1106784000000, 250346140],
            [1106870400000, 252585610],
            [1106956800000, 256343255],
            [1107043200000, 258372305],
            [1107129600000, 258839430],
            [1107216000000, 259350450],
            [1107302400000, 259844945],
            [1107388800000, 260355910],
            [1107475200000, 261858265],
            [1107561600000, 264399825],
            [1107648000000, 265163545],
            [1107734400000, 265500670],
            [1107820800000, 265827425],
            [1107907200000, 266140310],
            [1107993600000, 266490305],
            [1108080000000, 267357425],
            [1108166400000, 269070955],
            [1108252800000, 269946550],
            [1108339200000, 270483205],
            [1108425600000, 270718580],
            [1108512000000, 270925710],
            [1108598400000, 271142255],
            [1108684800000, 271670130],
            [1108771200000, 272611100],
            [1108857600000, 273159325],
            [1108944000000, 273488020],
            [1109030400000, 273636005],
            [1109116800000, 273778130],
            [1109203200000, 273926905],
            [1109289600000, 274239525],
            [1109376000000, 274779390],
            [1109462400000, 275027050],
            [1109548800000, 275096070],
            [1109635200000, 275169150],
            [1109721600000, 275242155],
            [1109808000000, 275331620],
            [1109894400000, 275501570],
            [1109980800000, 275797695],
            [1110067200000, 275936745],
            [1110153600000, 275980520],
            [1110240000000, 276037170],
            [1110326400000, 276093565],
            [1110412800000, 276142490],
            [1110499200000, 276261590],
            [1110585600000, 276468030],
            [1110672000000, 276573235],
            [1110758400000, 276614920],
            [1110844800000, 276662560],
            [1110931200000, 276706230],
            [1111017600000, 276751885],
            [1111104000000, 276861075],
            [1111190400000, 277034705],
            [1111276800000, 277125990],
            [1111363200000, 277163580],
            [1111449600000, 277206540],
            [1111536000000, 277247710],
            [1111622400000, 277292460],
            [1111708800000, 277418420],
            [1111795200000, 277560170],
            [1111881600000, 277642295],
            [1111968000000, 277700045],
            [1112054400000, 277747380],
            [1112140800000, 277791130],
            [1112227200000, 277838350],
            [1112313600000, 277930685],
            [1112400000000, 278052755],
            [1112486400000, 278115340],
            [1112572800000, 278137265],
            [1112659200000, 278165435],
            [1112745600000, 278190630],
            [1112832000000, 278220285],
            [1112918400000, 278302510],
            [1113004800000, 278426595],
            [1113091200000, 278487890],
            [1113177600000, 278511810],
            [1113264000000, 278538695],
            [1113350400000, 278562540],
            [1113436800000, 278586485],
            [1113523200000, 278650565],
            [1113609600000, 278754695],
            [1113696000000, 278808080],
            [1113782400000, 278826805],
            [1113868800000, 278849500],
            [1113955200000, 278870860],
            [1114041600000, 278890885],
            [1114128000000, 278932715],
            [1114214400000, 279000350],
            [1114300800000, 279035060],
            [1114387200000, 279044850],
            [1114473600000, 279057310],
            [1114560000000, 279067990],
            [1114646400000, 279078615],
            [1114732800000, 279105025],
            [1114819200000, 279147420],
            [1114905600000, 279167575],
            [1114992000000, 279175220],
            [1115078400000, 279184950],
            [1115164800000, 279192595],
            [1115251200000, 279200300]
        ],
        name: 'meetthefockers',
        showInLegend: false,
        extra: {
            title: 'Meet the Fockers',
            genre: 'Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#EFE9EA'
        },
        showlabel: false,
        color: 'rgba(239,233,234,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1244160000000, 16734033
            ],
            [1244246400000, 31790804],
            [1244332800000, 44979319],
            [1244419200000, 52638427],
            [1244505600000, 59227850],
            [1244592000000, 65883078],
            [1244678400000, 71974102],
            [1244764800000, 82284612],
            [1244851200000, 94887954],
            [1244937600000, 104768489],
            [1245024000000, 110299949],
            [1245110400000, 115828257],
            [1245196800000, 120878530],
            [1245283200000, 126063542],
            [1245369600000, 134474576],
            [1245456000000, 144870863],
            [1245542400000, 152817015],
            [1245628800000, 156628400],
            [1245715200000, 160120726],
            [1245801600000, 163204970],
            [1245888000000, 166032101],
            [1245974400000, 171339202],
            [1246060800000, 177924931],
            [1246147200000, 183054267],
            [1246233600000, 185632384],
            [1246320000000, 188381740],
            [1246406400000, 190775902],
            [1246492800000, 193769820],
            [1246579200000, 198260300],
            [1246665600000, 201073670],
            [1246752000000, 205038233],
            [1246838400000, 207015476],
            [1246924800000, 208966655],
            [1247011200000, 210791312],
            [1247097600000, 212511668],
            [1247184000000, 215661286],
            [1247270400000, 219582932],
            [1247356800000, 222444906],
            [1247443200000, 223766214],
            [1247529600000, 225081501],
            [1247616000000, 226309780],
            [1247702400000, 227567151],
            [1247788800000, 230137739],
            [1247875200000, 233483035],
            [1247961600000, 235744423],
            [1248048000000, 236862562],
            [1248134400000, 238206804],
            [1248220800000, 239378032],
            [1248307200000, 240612396],
            [1248393600000, 242606628],
            [1248480000000, 245250120],
            [1248566400000, 247073766],
            [1248652800000, 247929964],
            [1248739200000, 248857162],
            [1248825600000, 249808203],
            [1248912000000, 250696417],
            [1248998400000, 252257735],
            [1249084800000, 254330669],
            [1249171200000, 255890892],
            [1249257600000, 256580964],
            [1249344000000, 257269418],
            [1249430400000, 257937802],
            [1249516800000, 258610153],
            [1249603200000, 259633245],
            [1249689600000, 261038904],
            [1249776000000, 261979331],
            [1249862400000, 262440819],
            [1249948800000, 262899044],
            [1250035200000, 263357061],
            [1250121600000, 263801466],
            [1250208000000, 264422247],
            [1250294400000, 265277504],
            [1250380800000, 265790452],
            [1250467200000, 266043670],
            [1250553600000, 266301420],
            [1250640000000, 266553834],
            [1250726400000, 266803320],
            [1250812800000, 267258675],
            [1250899200000, 267925104],
            [1250985600000, 268277556],
            [1251072000000, 268430708],
            [1251158400000, 268592004],
            [1251244800000, 268749272],
            [1251331200000, 268897612],
            [1251417600000, 269314257],
            [1251504000000, 269952421],
            [1251590400000, 270237753],
            [1251676800000, 270349000],
            [1251763200000, 270467025],
            [1251849600000, 270582232],
            [1251936000000, 270699482],
            [1252022400000, 271001078],
            [1252108800000, 271437318],
            [1252195200000, 271921527],
            [1252281600000, 272197388],
            [1252368000000, 272281640],
            [1252454400000, 272355971],
            [1252540800000, 272427055],
            [1252627200000, 272652555],
            [1252713600000, 272997376],
            [1252800000000, 273136280],
            [1252886400000, 273193507],
            [1252972800000, 273258847],
            [1253059200000, 273326181],
            [1253145600000, 273396228],
            [1253232000000, 273547846],
            [1253318400000, 273761824],
            [1253404800000, 273863601],
            [1253491200000, 273900474],
            [1253577600000, 273944926],
            [1253664000000, 273987411],
            [1253750400000, 274029620],
            [1253836800000, 274160264],
            [1253923200000, 274361864],
            [1254009600000, 274452813],
            [1254096000000, 274487284],
            [1254182400000, 274526780],
            [1254268800000, 274563907],
            [1254355200000, 274603632],
            [1254441600000, 274774853],
            [1254528000000, 275028770],
            [1254614400000, 275156197],
            [1254700800000, 275205894],
            [1254787200000, 275268015],
            [1254873600000, 275326194],
            [1254960000000, 275386118],
            [1255046400000, 275523127],
            [1255132800000, 275706215],
            [1255219200000, 275813456],
            [1255305600000, 275868349],
            [1255392000000, 275914899],
            [1255478400000, 275961980],
            [1255564800000, 276009202],
            [1255651200000, 276094955],
            [1255737600000, 276218704],
            [1255824000000, 276276785],
            [1255910400000, 276298936],
            [1255996800000, 276325760],
            [1256083200000, 276352952],
            [1256169600000, 276381875],
            [1256256000000, 276449745],
            [1256342400000, 276540432],
            [1256428800000, 276583220],
            [1256515200000, 276599791],
            [1256601600000, 276618687],
            [1256688000000, 276636450],
            [1256774400000, 276654074],
            [1256860800000, 276696782],
            [1256947200000, 276736189],
            [1257033600000, 276771408],
            [1257120000000, 276784444],
            [1257206400000, 276800348],
            [1257292800000, 276815616],
            [1257379200000, 276833111],
            [1257465600000, 276869026],
            [1257552000000, 276919504],
            [1257638400000, 276942541],
            [1257724800000, 276951487],
            [1257811200000, 276964638],
            [1257897600000, 276979556],
            [1257984000000, 276989452],
            [1258070400000, 277017402],
            [1258156800000, 277054690],
            [1258243200000, 277069721],
            [1258329600000, 277076936],
            [1258416000000, 277084285],
            [1258502400000, 277091761],
            [1258588800000, 277099511],
            [1258675200000, 277118365],
            [1258761600000, 277144651],
            [1258848000000, 277156483],
            [1258934400000, 277162304],
            [1259020800000, 277170253],
            [1259107200000, 277180403],
            [1259193600000, 277190373],
            [1259280000000, 277211102],
            [1259366400000, 277232769],
            [1259452800000, 277240744],
            [1259539200000, 277244014],
            [1259625600000, 277247684],
            [1259712000000, 277251541],
            [1259798400000, 277255442],
            [1259884800000, 277264863],
            [1259971200000, 277278726],
            [1260057600000, 277283642],
            [1260144000000, 277286214],
            [1260230400000, 277288934],
            [1260316800000, 277291709],
            [1260403200000, 277294415],
            [1260489600000, 277300848],
            [1260576000000, 277309155],
            [1260662400000, 277313371],
            [1260748800000, 277315648],
            [1260835200000, 277317996],
            [1260921600000, 277320090],
            [1261008000000, 277322503]
        ],
        name: 'hangover',
        showInLegend: false,
        extra: {
            title: 'The Hangover',
            genre: 'Comedy',

            mpaaRating: 'R',
            imgMainColor: '#907A63'
        },
        showlabel: false,
        color: 'rgba(144,122,99,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1380844800000, 17484818
            ],
            [1380931200000, 40486171],
            [1381017600000, 55785112],
            [1381104000000, 61812240],
            [1381190400000, 68450707],
            [1381276800000, 73788739],
            [1381363200000, 79134919],
            [1381449600000, 91735987],
            [1381536000000, 110197316],
            [1381622400000, 122323175],
            [1381708800000, 128524251],
            [1381795200000, 132525377],
            [1381881600000, 136013643],
            [1381968000000, 139536130],
            [1382054400000, 148552203],
            [1382140800000, 162161396],
            [1382227200000, 169563291],
            [1382313600000, 171968814],
            [1382400000000, 174919886],
            [1382486400000, 177237186],
            [1382572800000, 179514361],
            [1382659200000, 185594655],
            [1382745600000, 194613790],
            [1382832000000, 199649748],
            [1382918400000, 201152052],
            [1383004800000, 202996177],
            [1383091200000, 204427244],
            [1383177600000, 206066013],
            [1383264000000, 209645694],
            [1383350400000, 215768648],
            [1383436800000, 218891359],
            [1383523200000, 219784838],
            [1383609600000, 220939433],
            [1383696000000, 221833695],
            [1383782400000, 222714492],
            [1383868800000, 225009203],
            [1383955200000, 228863828],
            [1384041600000, 231249831],
            [1384128000000, 232479037],
            [1384214400000, 233142205],
            [1384300800000, 233704465],
            [1384387200000, 234275614],
            [1384473600000, 235989279],
            [1384560000000, 238931337],
            [1384646400000, 240379710],
            [1384732800000, 240803879],
            [1384819200000, 241356931],
            [1384905600000, 241819248],
            [1384992000000, 242197604],
            [1385078400000, 243089569],
            [1385164800000, 244580794],
            [1385251200000, 245407759],
            [1385337600000, 245743924],
            [1385424000000, 246177041],
            [1385510400000, 246631491],
            [1385596800000, 247142861],
            [1385683200000, 248217837],
            [1385769600000, 249227667],
            [1385856000000, 249699049],
            [1385942400000, 249835339],
            [1386028800000, 250000975],
            [1386115200000, 250137200],
            [1386201600000, 250275254],
            [1386288000000, 250606204],
            [1386374400000, 251183300],
            [1386460800000, 251486533],
            [1386547200000, 251604851],
            [1386633600000, 251764184],
            [1386720000000, 251894418],
            [1386806400000, 252033608],
            [1386892800000, 252248860],
            [1386979200000, 252563686],
            [1387065600000, 252779065],
            [1387152000000, 252871195],
            [1387238400000, 252976073],
            [1387324800000, 253052842],
            [1387411200000, 253135785],
            [1387497600000, 253242977],
            [1387584000000, 253414778],
            [1387670400000, 253567282],
            [1387756800000, 253694288],
            [1387843200000, 253809990],
            [1387929600000, 253946403],
            [1388016000000, 254085404],
            [1388102400000, 254246242],
            [1388188800000, 254444232],
            [1388275200000, 254593554],
            [1388361600000, 254723083],
            [1388448000000, 254861229],
            [1388534400000, 255041963],
            [1388620800000, 255144426],
            [1388707200000, 255296828],
            [1388793600000, 255504224],
            [1388880000000, 255621667],
            [1388966400000, 255662874],
            [1389052800000, 255709910],
            [1389139200000, 255754350],
            [1389225600000, 255805704],
            [1389312000000, 255918546],
            [1389398400000, 256114529],
            [1389484800000, 256224796],
            [1389571200000, 256268146],
            [1389657600000, 256314185],
            [1389744000000, 256352541],
            [1389830400000, 256410669],
            [1389916800000, 256876072],
            [1390003200000, 257786788],
            [1390089600000, 258277706],
            [1390176000000, 258717930],
            [1390262400000, 258875011],
            [1390348800000, 259029277],
            [1390435200000, 259183469],
            [1390521600000, 259676051],
            [1390608000000, 260633584],
            [1390694400000, 261208962],
            [1390780800000, 261387253],
            [1390867200000, 261598729],
            [1390953600000, 261774254],
            [1391040000000, 261967346],
            [1391126400000, 262553924],
            [1391212800000, 263645351],
            [1391299200000, 263989374],
            [1391385600000, 264171486],
            [1391472000000, 264379618],
            [1391558400000, 264581641],
            [1391644800000, 264802800],
            [1391731200000, 265178283],
            [1391817600000, 266001077],
            [1391904000000, 266474237],
            [1391990400000, 266615700],
            [1392076800000, 266787772],
            [1392163200000, 266850233],
            [1392249600000, 266921610],
            [1392336000000, 267216163],
            [1392422400000, 267620309],
            [1392508800000, 267958269],
            [1392595200000, 268172926],
            [1392681600000, 268262383],
            [1392768000000, 268345782],
            [1392854400000, 268428128],
            [1392940800000, 268648565],
            [1393027200000, 269036253],
            [1393113600000, 269275323],
            [1393200000000, 269347748],
            [1393286400000, 269429937],
            [1393372800000, 269502099],
            [1393459200000, 269589531],
            [1393545600000, 269804771],
            [1393632000000, 270255085],
            [1393718400000, 270478831],
            [1393804800000, 270600947],
            [1393891200000, 270720997],
            [1393977600000, 270819443],
            [1394064000000, 270912606],
            [1394150400000, 271152620],
            [1394236800000, 271584350],
            [1394323200000, 271814796],
            [1394409600000, 271885959],
            [1394496000000, 271974168],
            [1394582400000, 272051527],
            [1394668800000, 272124892],
            [1394755200000, 272275153],
            [1394841600000, 272525747],
            [1394928000000, 272672181],
            [1395014400000, 272720400],
            [1395100800000, 272774851],
            [1395187200000, 272819785],
            [1395273600000, 272864283],
            [1395360000000, 272920838],
            [1395446400000, 273026826],
            [1395532800000, 273089375],
            [1395619200000, 273112569],
            [1395705600000, 273142493],
            [1395792000000, 273167226],
            [1395878400000, 273190658],
            [1395964800000, 273225527],
            [1396051200000, 273281862],
            [1396137600000, 273312639],
            [1396224000000, 273325688],
            [1396310400000, 273339603],
            [1396396800000, 273351709],
            [1396483200000, 273363308],
            [1396569600000, 273435218],
            [1396656000000, 273536674],
            [1396742400000, 273605314],
            [1396828800000, 273628538],
            [1396915200000, 273658529],
            [1397001600000, 273682021],
            [1397088000000, 273704338],
            [1397174400000, 273743182],
            [1397260800000, 273799855],
            [1397347200000, 273838269],
            [1397433600000, 273852834],
            [1397520000000, 273872688],
            [1397606400000, 273888865],
            [1397692800000, 273908685],
            [1397779200000, 273932884],
            [1397865600000, 273964011],
            [1397952000000, 273980132],
            [1398038400000, 273987347],
            [1398124800000, 273996221],
            [1398211200000, 274004651],
            [1398297600000, 274012743],
            [1398384000000, 274023599],
            [1398470400000, 274041706],
            [1398556800000, 274052110],
            [1398643200000, 274054961],
            [1398729600000, 274058729],
            [1398816000000, 274062042],
            [1398902400000, 274065620],
            [1398988800000, 274071091],
            [1399075200000, 274080055],
            [1399161600000, 274084951],
            [1399248000000, 274086615],
            [1399334400000, 274088678],
            [1399420800000, 274090596],
            [1399507200000, 274092705]
        ],
        name: 'gravity',
        showInLegend: false,
        extra: {
            title: 'Gravity',
            genre: 'Sci-Fi Thriller',

            mpaaRating: 'PG-13',
            imgMainColor: '#273340'
        },
        showlabel: false,
        color: 'rgba(39,51,64,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1371772800000, 30473099
            ],
            [1371859200000, 59207090],
            [1371945600000, 82429469],
            [1372032000000, 93448671],
            [1372118400000, 105296735],
            [1372204800000, 115333157],
            [1372291200000, 124825448],
            [1372377600000, 139242031],
            [1372464000000, 156910695],
            [1372550400000, 170433193],
            [1372636800000, 178331953],
            [1372723200000, 185905021],
            [1372809600000, 191309030],
            [1372896000000, 196537632],
            [1372982400000, 203739645],
            [1373068800000, 210901879],
            [1373155200000, 216253979],
            [1373241600000, 218814952],
            [1373328000000, 221990710],
            [1373414400000, 224629892],
            [1373500800000, 227139427],
            [1373587200000, 230455915],
            [1373673600000, 234760624],
            [1373760000000, 237771003],
            [1373846400000, 239289059],
            [1373932800000, 241220190],
            [1374019200000, 242664821],
            [1374105600000, 243992254],
            [1374192000000, 245504920],
            [1374278400000, 247559382],
            [1374364800000, 249114132],
            [1374451200000, 249906652],
            [1374537600000, 250940258],
            [1374624000000, 251777375],
            [1374710400000, 252612188],
            [1374796800000, 253418103],
            [1374883200000, 254514346],
            [1374969600000, 255467026],
            [1375056000000, 255910948],
            [1375142400000, 256425170],
            [1375228800000, 256790589],
            [1375315200000, 257161691],
            [1375401600000, 257562072],
            [1375488000000, 258137410],
            [1375574400000, 258565238],
            [1375660800000, 258813738],
            [1375747200000, 259089841],
            [1375833600000, 259293996],
            [1375920000000, 259487516],
            [1376006400000, 259709029],
            [1376092800000, 259977221],
            [1376179200000, 260171175],
            [1376265600000, 260295905],
            [1376352000000, 260455526],
            [1376438400000, 260566991],
            [1376524800000, 260673604],
            [1377820800000, 262305855],
            [1377907200000, 262905944],
            [1377993600000, 263568953],
            [1378080000000, 264286369],
            [1378166400000, 264385381],
            [1378252800000, 264449975],
            [1378339200000, 264537017],
            [1378425600000, 264634350],
            [1378512000000, 264853554],
            [1378598400000, 264989136],
            [1378684800000, 265014357],
            [1378771200000, 265041793],
            [1378857600000, 265067070],
            [1378944000000, 265092054]
        ],
        name: 'monstersinc2',
        showInLegend: false,
        extra: {
            title: 'Monsters University',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#8A8F96'
        },
        showlabel: false,
        color: 'rgba(138,143,150,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                989971200000, 20099
            ],
            [990057600000, 39588],
            [990144000000, 11612603],
            [990230400000, 29135915],
            [990316800000, 42387348],
            [990403200000, 46460873],
            [990489600000, 50000472],
            [990576000000, 53117948],
            [990662400000, 56537780],
            [990748800000, 66427296],
            [990835200000, 83527976],
            [990921600000, 99019205],
            [991008000000, 111753400],
            [991094400000, 114677618],
            [991180800000, 117326994],
            [991267200000, 120188552],
            [991353600000, 126952634],
            [991440000000, 139605953],
            [991526400000, 148361421],
            [991612800000, 150844164],
            [991699200000, 153648432],
            [991785600000, 156468969],
            [991872000000, 159549376],
            [991958400000, 164088577],
            [992044800000, 171099046],
            [992131200000, 176069428],
            [992217600000, 177961087],
            [992304000000, 180095133],
            [992390400000, 182133662],
            [992476800000, 184346428],
            [992563200000, 187945813],
            [992649600000, 193236425],
            [992736000000, 197528004],
            [992822400000, 199149664],
            [992908800000, 200873205],
            [992995200000, 202692510],
            [993081600000, 204826286],
            [993168000000, 207933715],
            [993254400000, 212312950],
            [993340800000, 215232017],
            [993427200000, 216432671],
            [993513600000, 217750903],
            [993600000000, 219072661],
            [993686400000, 220434926],
            [993772800000, 222496368],
            [993859200000, 225556336],
            [993945600000, 228142129],
            [994032000000, 229470914],
            [994118400000, 231170167],
            [994204800000, 233298753],
            [994291200000, 234553132],
            [994377600000, 236319337],
            [994464000000, 238603661],
            [994550400000, 240560159],
            [994636800000, 241268584],
            [994723200000, 242105952],
            [994809600000, 242925496],
            [994896000000, 243676732],
            [994982400000, 244748171],
            [995068800000, 246186859],
            [995155200000, 247280575],
            [995241600000, 247805106],
            [995328000000, 248537074],
            [995414400000, 249138623],
            [995500800000, 249646960],
            [995587200000, 250280187],
            [995673600000, 251190706],
            [995760000000, 251922192],
            [995846400000, 252296643],
            [995932800000, 252768921],
            [996019200000, 253228304],
            [996105600000, 253733562],
            [996192000000, 254217625],
            [996278400000, 254913603],
            [996364800000, 255526280],
            [996451200000, 255810708],
            [996537600000, 256165068],
            [996624000000, 256491593],
            [996710400000, 256846372],
            [996796800000, 257151461],
            [996883200000, 257581918],
            [996969600000, 257919287],
            [997056000000, 258116694],
            [997142400000, 258330619],
            [997228800000, 258545031],
            [997315200000, 258772376],
            [997401600000, 258965617],
            [997488000000, 259222405],
            [997574400000, 259456747],
            [997660800000, 259566999],
            [997747200000, 259682447],
            [997833600000, 259784010],
            [997920000000, 259905461],
            [998006400000, 260043064],
            [998092800000, 260245463],
            [998179200000, 260444228],
            [998265600000, 260532701],
            [998352000000, 260632341],
            [998438400000, 260723586],
            [998524800000, 260814955],
            [998611200000, 260956302],
            [998697600000, 261190354],
            [998784000000, 261398217],
            [998870400000, 261483652],
            [998956800000, 261594714],
            [999043200000, 261673271],
            [999129600000, 261750467],
            [999216000000, 261934958],
            [999302400000, 262243191],
            [999388800000, 262536751],
            [999475200000, 262908727],
            [999561600000, 262968755],
            [999648000000, 263007998],
            [999734400000, 263046762],
            [999820800000, 263128848],
            [999907200000, 263324824],
            [999993600000, 263482327],
            [1000080000000, 263505869],
            [1000166400000, 263526047],
            [1000252800000, 263551500],
            [1000339200000, 263576715],
            [1000425600000, 263658903],
            [1000512000000, 263845966],
            [1000598400000, 263977441],
            [1000684800000, 263999830],
            [1000771200000, 264034305],
            [1000857600000, 264062364],
            [1000944000000, 264090028],
            [1001030400000, 264215288],
            [1001116800000, 264518586],
            [1001203200000, 264752789],
            [1001289600000, 264795242],
            [1001376000000, 264869354],
            [1001462400000, 264919616],
            [1001548800000, 264986351],
            [1001635200000, 265091833],
            [1001721600000, 265299884],
            [1001808000000, 265448253],
            [1001894400000, 265471439],
            [1001980800000, 265495696],
            [1002067200000, 265522045],
            [1002153600000, 265551323],
            [1002240000000, 265622479],
            [1002326400000, 265780407],
            [1002412800000, 265883866],
            [1002499200000, 265951982],
            [1002585600000, 265975511],
            [1002672000000, 265998916],
            [1002758400000, 266023587],
            [1002844800000, 266073776],
            [1002931200000, 266185922],
            [1003017600000, 266283207],
            [1003104000000, 266302646],
            [1003190400000, 266321171],
            [1003276800000, 266339361],
            [1003363200000, 266364609],
            [1003449600000, 266431795],
            [1003536000000, 266549278],
            [1003622400000, 266636479],
            [1003708800000, 266654871],
            [1003795200000, 266678418],
            [1003881600000, 266697786],
            [1003968000000, 266720791],
            [1004054400000, 266786211],
            [1004140800000, 266898569],
            [1004227200000, 266982666],
            [1004313600000, 266998121],
            [1004400000000, 267015189],
            [1004486400000, 267035511],
            [1004572800000, 267055666],
            [1004659200000, 267097208],
            [1004745600000, 267162291],
            [1004832000000, 267202507],
            [1004918400000, 267211690],
            [1005004800000, 267225192],
            [1005091200000, 267234638],
            [1005177600000, 267245967],
            [1005264000000, 267280085],
            [1005350400000, 267332118],
            [1005436800000, 267367187],
            [1005523200000, 267382563],
            [1005609600000, 267390646],
            [1005696000000, 267397188],
            [1005782400000, 267403311],
            [1005868800000, 267417561],
            [1005955200000, 267451102],
            [1006041600000, 267467391],
            [1006128000000, 267471946],
            [1006214400000, 267479271],
            [1006300800000, 267490292],
            [1006387200000, 267502596],
            [1006473600000, 267537610],
            [1006560000000, 267573772],
            [1006646400000, 267590891],
            [1006732800000, 267595212],
            [1006819200000, 267600332],
            [1006905600000, 267604865],
            [1006992000000, 267609294],
            [1007078400000, 267620580],
            [1007164800000, 267640832],
            [1007251200000, 267652016],
            [1007337600000, 267655231],
            [1007424000000, 267658655],
            [1007510400000, 267661752],
            [1007596800000, 267665011]
        ],
        name: 'shrek',
        showInLegend: false,
        extra: {
            title: 'Shrek',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#A28E84'
        },
        showlabel: false,
        color: 'rgba(162,142,132,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1341187200000, 850000
            ],
            [1341273600000, 35866884],
            [1341360000000, 59202809],
            [1341446400000, 75017570],
            [1341532800000, 95497609],
            [1341619200000, 119154713],
            [1341705600000, 137022258],
            [1341792000000, 144578697],
            [1341878400000, 153210348],
            [1341964800000, 159713629],
            [1342051200000, 165872247],
            [1342137600000, 176070659],
            [1342224000000, 189953583],
            [1342310400000, 200500351],
            [1342396800000, 204853977],
            [1342483200000, 210293031],
            [1342569600000, 214314784],
            [1342656000000, 217724314],
            [1342742400000, 221171631],
            [1342828800000, 225426204],
            [1342915200000, 228611425],
            [1343001600000, 230161774],
            [1343088000000, 232198265],
            [1343174400000, 233672436],
            [1343260800000, 235252610],
            [1343347200000, 237148066],
            [1343433600000, 239911945],
            [1343520000000, 241953721],
            [1343606400000, 242955672],
            [1343692800000, 244281030],
            [1343779200000, 245327116],
            [1343865600000, 246340333],
            [1343952000000, 247583733],
            [1344038400000, 249328151],
            [1344124800000, 250740648],
            [1344211200000, 251426210],
            [1344297600000, 252188219],
            [1344384000000, 252768504],
            [1344470400000, 253343442],
            [1344556800000, 253972858],
            [1344643200000, 254855547],
            [1344729600000, 255464677],
            [1344816000000, 255761521],
            [1344902400000, 256159253],
            [1344988800000, 256422240],
            [1345075200000, 256676518],
            [1345161600000, 256906012],
            [1345248000000, 257220588],
            [1345334400000, 257435325],
            [1345420800000, 257538273],
            [1345507200000, 257672448],
            [1345593600000, 257769664],
            [1345680000000, 257863937],
            [1345766400000, 258010151],
            [1345852800000, 258222644],
            [1345939200000, 258355827],
            [1346025600000, 258423379],
            [1346112000000, 258498943],
            [1346198400000, 258548927],
            [1346284800000, 258600057],
            [1346371200000, 258815453],
            [1346457600000, 259166795],
            [1346544000000, 259524833],
            [1346630400000, 259811206],
            [1346716800000, 259890769],
            [1346803200000, 259946733],
            [1346889600000, 260005361],
            [1346976000000, 260150569],
            [1347062400000, 260418505],
            [1347148800000, 260571241],
            [1347580800000, 260844063],
            [1347667200000, 261005584],
            [1347753600000, 261102260],
            [1348185600000, 261292416],
            [1348272000000, 261406855],
            [1348358400000, 261471268],
            [1348790400000, 261612657],
            [1348876800000, 261721446],
            [1348963200000, 261765954],
            [1349395200000, 261850903],
            [1349481600000, 261907613],
            [1349568000000, 261939214],
            [1350000000000, 261994808],
            [1350086400000, 262018902],
            [1350172800000, 262030663]
        ],
        name: 'spiderman4',
        showInLegend: false,
        extra: {
            title: 'The Amazing Spider-Man',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#403240'
        },
        showlabel: false,
        color: 'rgba(64,50,64,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1037318400000, 29631453
            ],
            [1037404800000, 63845256],
            [1037491200000, 88357488],
            [1037577600000, 93678789],
            [1037664000000, 98421061],
            [1037750400000, 102453546],
            [1037836800000, 106131568],
            [1037923200000, 117138823],
            [1038009600000, 135845151],
            [1038096000000, 148358831],
            [1038182400000, 150920102],
            [1038268800000, 154408081],
            [1038355200000, 160822000],
            [1038441600000, 168041516],
            [1038528000000, 181419676],
            [1038614400000, 193446308],
            [1038700800000, 200159012],
            [1038787200000, 201207172],
            [1038873600000, 202160354],
            [1038960000000, 202997203],
            [1039046400000, 203884698],
            [1039132800000, 206478449],
            [1039219200000, 211116578],
            [1039305600000, 213970962],
            [1039392000000, 214533188],
            [1039478400000, 215161380],
            [1039564800000, 215740821],
            [1039651200000, 216294988],
            [1039737600000, 217723188],
            [1039824000000, 220610665],
            [1039910400000, 222619375],
            [1039996800000, 223066343],
            [1040083200000, 223573786],
            [1040169600000, 224006940],
            [1040256000000, 224450272],
            [1040342400000, 225454018],
            [1040428800000, 227163586],
            [1040515200000, 228821682],
            [1040601600000, 230158075],
            [1040688000000, 231000499],
            [1040774400000, 231950777],
            [1040860800000, 233833266],
            [1040947200000, 236014651],
            [1041033600000, 238246913],
            [1041120000000, 240307533],
            [1041206400000, 242129704],
            [1041292800000, 243867371],
            [1041379200000, 245996312],
            [1041465600000, 247444556],
            [1041552000000, 248875790],
            [1041638400000, 250741823],
            [1041724800000, 252097945],
            [1041811200000, 252390263],
            [1041897600000, 252636341],
            [1041984000000, 252843617],
            [1042070400000, 253040825],
            [1042156800000, 253490940],
            [1042243200000, 254593196],
            [1042329600000, 255449301],
            [1042416000000, 255576566],
            [1042502400000, 255730901],
            [1042588800000, 255856763],
            [1042675200000, 255993116],
            [1042848000000, 256870249],
            [1042934400000, 257405375],
            [1043020800000, 257897677],
            [1043107200000, 257976889],
            [1043193600000, 258044347],
            [1043280000000, 258119640],
            [1043366400000, 258255448],
            [1043452800000, 258642000],
            [1043539200000, 258898102],
            [1043625600000, 258968210],
            [1043712000000, 259018343],
            [1043798400000, 259065521],
            [1043884800000, 259119624],
            [1043971200000, 259202081],
            [1044057600000, 259437310],
            [1044144000000, 259626842],
            [1044230400000, 259647175],
            [1044316800000, 259670518],
            [1044403200000, 259694253],
            [1044489600000, 259720120],
            [1044576000000, 259764578],
            [1044662400000, 259902545],
            [1044748800000, 260023267],
            [1044835200000, 260042432],
            [1044921600000, 260057951],
            [1045008000000, 260074110],
            [1045094400000, 260087936],
            [1045180800000, 260150490],
            [1045267200000, 260291741],
            [1045353600000, 260416152],
            [1045440000000, 260492052],
            [1045526400000, 260524245],
            [1045612800000, 260552995],
            [1045699200000, 260581103],
            [1045785600000, 260641283],
            [1045872000000, 260759681],
            [1045958400000, 260839888],
            [1046044800000, 260855311],
            [1046131200000, 260870621],
            [1046217600000, 260885761],
            [1046304000000, 260901621],
            [1046390400000, 260950376],
            [1046476800000, 261049620],
            [1046563200000, 261123736],
            [1046649600000, 261142213],
            [1046736000000, 261158131],
            [1046822400000, 261173905],
            [1046908800000, 261190950],
            [1046995200000, 261233262],
            [1047081600000, 261309243],
            [1047168000000, 261370976],
            [1047254400000, 261393096],
            [1047340800000, 261418257],
            [1047427200000, 261442745],
            [1047513600000, 261466852],
            [1047600000000, 261500126],
            [1047686400000, 261553113],
            [1047772800000, 261588213],
            [1047859200000, 261600000],
            [1047945600000, 261613781],
            [1048032000000, 261624972],
            [1048118400000, 261637574],
            [1048204800000, 261660006],
            [1048291200000, 261700188],
            [1048377600000, 261724299],
            [1048464000000, 261732657],
            [1048550400000, 261742099],
            [1048636800000, 261751196],
            [1048723200000, 261761716],
            [1048809600000, 261779489],
            [1048896000000, 261812629],
            [1048982400000, 261835892],
            [1049068800000, 261843145],
            [1049155200000, 261849781],
            [1049241600000, 261855995],
            [1049328000000, 261862955],
            [1049414400000, 261876864],
            [1049500800000, 261906514],
            [1049587200000, 261924727],
            [1049673600000, 261930121],
            [1049760000000, 261936912],
            [1049846400000, 261942505],
            [1049932800000, 261948750],
            [1050019200000, 261954603],
            [1050105600000, 261964006],
            [1050192000000, 261970615],
            [1050278400000, 261972509],
            [1050364800000, 261974895],
            [1050451200000, 261977124],
            [1050537600000, 261979634],
            [1050624000000, 261981386],
            [1050710400000, 261983001],
            [1050796800000, 261983944],
            [1050883200000, 261984527],
            [1050969600000, 261985021],
            [1051056000000, 261985421],
            [1051228800000, 261986049],
            [1051315200000, 261987395],
            [1051401600000, 261987880],
            [1051488000000, 261987992],
            [1051574400000, 261988109],
            [1051660800000, 261988227],
            [1051747200000, 261988325],
            [1051833600000, 261988405],
            [1051920000000, 261988464],
            [1052006400000, 261988482]
        ],
        name: 'harrypotter2',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Chamber of Secrets',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#292F37'
        },
        showlabel: false,
        color: 'rgba(41,47,55,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1099612800000, 20503078
            ],
            [1099699200000, 50027012],
            [1099785600000, 70467623],
            [1099872000000, 74270103],
            [1099958400000, 77482702],
            [1100044800000, 81992796],
            [1100131200000, 93004485],
            [1100217600000, 106932122],
            [1100304000000, 129306113],
            [1100390400000, 143255844],
            [1100476800000, 145396468],
            [1100563200000, 147363767],
            [1100649600000, 149181562],
            [1100736000000, 151031633],
            [1100822400000, 157699866],
            [1100908800000, 169911453],
            [1100995200000, 177555485],
            [1101081600000, 179257620],
            [1101168000000, 181485791],
            [1101254400000, 185926773],
            [1101340800000, 190713756],
            [1101427200000, 200616158],
            [1101513600000, 209654649],
            [1101600000000, 214294035],
            [1101686400000, 215034304],
            [1101772800000, 215668895],
            [1101859200000, 216245723],
            [1101945600000, 216842991],
            [1102032000000, 219182469],
            [1102118400000, 223353755],
            [1102204800000, 225858787],
            [1102291200000, 226281941],
            [1102377600000, 226731973],
            [1102464000000, 227141381],
            [1102550400000, 227536615],
            [1102636800000, 228745970],
            [1102723200000, 231150039],
            [1102809600000, 232573246],
            [1102896000000, 232864231],
            [1102982400000, 233175372],
            [1103068800000, 233500245],
            [1103155200000, 233857885],
            [1103241600000, 234624144],
            [1103328000000, 235966381],
            [1103414400000, 236978426],
            [1103500800000, 237668952],
            [1103587200000, 238450986],
            [1103673600000, 239134653],
            [1103760000000, 240008667],
            [1103846400000, 240713808],
            [1103932800000, 241424704],
            [1104019200000, 242425976],
            [1104105600000, 243564448],
            [1104192000000, 244839175],
            [1104278400000, 246140488],
            [1104364800000, 247496609],
            [1104451200000, 248939765],
            [1104537600000, 250428514],
            [1104624000000, 251657004],
            [1104710400000, 252097556],
            [1104796800000, 252317635],
            [1104883200000, 252496777],
            [1104969600000, 252680838],
            [1105056000000, 253058475],
            [1105142400000, 254051833],
            [1105228800000, 254738382],
            [1105315200000, 254848457],
            [1105401600000, 254962300],
            [1105488000000, 255071355],
            [1105574400000, 255183860],
            [1105660800000, 255349693],
            [1105747200000, 255834513],
            [1105833600000, 256240051],
            [1105920000000, 256739602],
            [1106006400000, 256795555],
            [1106092800000, 256837021],
            [1106179200000, 256887647]
        ],
        name: 'incredibles',
        showInLegend: false,
        extra: {
            title: 'The Incredibles',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#7F3E2C'
        },
        showlabel: false,
        color: 'rgba(127,62,44,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                974419200000, 15635225
            ],
            [974505600000, 38352880],
            [974592000000, 55082330],
            [974678400000, 58694015],
            [974764800000, 63572135],
            [974851200000, 72942795],
            [974937600000, 84977355],
            [975024000000, 104721580],
            [975110400000, 124544130],
            [975196800000, 137095800],
            [975283200000, 139273930],
            [975369600000, 141311030],
            [975456000000, 143081740],
            [975542400000, 144899460],
            [975628800000, 151520640],
            [975715200000, 163680390],
            [975801600000, 171996090],
            [975888000000, 173188530],
            [975974400000, 174553560],
            [976060800000, 175744455],
            [976147200000, 176999655],
            [976233600000, 181358995],
            [976320000000, 190061765],
            [976406400000, 195646175],
            [976492800000, 196505315],
            [976579200000, 197698565],
            [976665600000, 198684120],
            [976752000000, 199828935],
            [976838400000, 203036095],
            [976924800000, 209157375],
            [977011200000, 213634400],
            [977097600000, 214839120],
            [977184000000, 216418280],
            [977270400000, 218177405],
            [977356800000, 220391530],
            [977443200000, 224378170],
            [977529600000, 229867710],
            [977616000000, 232636205],
            [977702400000, 235119990],
            [977788800000, 238394730],
            [977875200000, 241400285],
            [977961600000, 244342805],
            [978048000000, 247329950],
            [978134400000, 249858745],
            [978220800000, 251628905],
            [978307200000, 253367455],
            [978393600000, 254315750],
            [978480000000, 254853120],
            [978566400000, 255327115],
            [978652800000, 255988585],
            [978739200000, 257116975],
            [978825600000, 257830325],
            [978912000000, 257959990],
            [978998400000, 258088985],
            [979084800000, 258191470],
            [979171200000, 258295695],
            [979257600000, 258386880],
            [979344000000, 258642240],
            [979430400000, 258833760],
            [979516800000, 259011600],
            [979603200000, 259038960],
            [979689600000, 259061745],
            [979776000000, 259084590],
            [979862400000, 259122390],
            [979948800000, 259215630],
            [980035200000, 259286185],
            [980121600000, 259296265],
            [980208000000, 259308865],
            [980294400000, 259319010],
            [980380800000, 259329065],
            [980467200000, 259362555],
            [980553600000, 259441350],
            [980640000000, 259484690],
            [980726400000, 259496510],
            [980812800000, 259510300],
            [980899200000, 259520150],
            [980985600000, 259530195],
            [981072000000, 259558980],
            [981158400000, 259627155],
            [981244800000, 259674120],
            [981331200000, 259683210],
            [981417600000, 259693815],
            [981504000000, 259701390],
            [981590400000, 259709015],
            [981676800000, 259727475],
            [981763200000, 259772915],
            [981849600000, 259806995],
            [981936000000, 259815600],
            [982022400000, 259822700],
            [982108800000, 259831220],
            [982195200000, 259838305],
            [982281600000, 259856085],
            [982368000000, 259896720],
            [982454400000, 259928470],
            [982540800000, 259951325],
            [982627200000, 259958945],
            [982713600000, 259965295],
            [982800000000, 259971710],
            [982886400000, 259984595],
            [982972800000, 260011255],
            [983059200000, 260031035],
            [983145600000, 260035330],
            [983232000000, 260038770],
            [983318400000, 260041350],
            [983404800000, 260044825]
        ],
        name: 'grinch',
        showInLegend: false,
        extra: {
            title: 'How the Grinch Stole Christmas',
            genre: 'Family Comedy',

            mpaaRating: 'PG',
            imgMainColor: '#444E50'
        },
        showlabel: false,
        color: 'rgba(68,78,80,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1396569600000, 36926192
            ],
            [1396656000000, 71593056],
            [1396742400000, 95023721],
            [1396828800000, 101243273],
            [1396915200000, 108220329],
            [1397001600000, 113026031],
            [1397088000000, 117608171],
            [1397174400000, 129474912],
            [1397260800000, 147209267],
            [1397347200000, 158883032],
            [1397433600000, 162345947],
            [1397520000000, 167072687],
            [1397606400000, 170596745],
            [1397692800000, 174914454],
            [1397779200000, 184418202],
            [1397865600000, 194754995],
            [1397952000000, 200501510],
            [1398038400000, 203096637],
            [1398124800000, 205301885],
            [1398211200000, 207075438],
            [1398297600000, 208840216],
            [1398384000000, 213255737],
            [1398470400000, 220574145],
            [1398556800000, 225059241],
            [1398643200000, 226126753],
            [1398729600000, 227466993],
            [1398816000000, 228529867],
            [1398902400000, 229381211],
            [1398988800000, 231480995],
            [1399075200000, 235004950],
            [1399161600000, 237155480],
            [1399248000000, 237666580],
            [1399334400000, 238330585],
            [1399420800000, 238868692],
            [1399507200000, 239377745],
            [1399593600000, 240864992],
            [1399680000000, 243416292],
            [1399766400000, 245128338],
            [1399852800000, 245539157],
            [1399939200000, 246043328],
            [1400025600000, 246464860],
            [1400112000000, 246868246],
            [1400198400000, 247888643],
            [1400284800000, 249510424],
            [1400371200000, 250532304],
            [1400457600000, 250905982],
            [1400544000000, 251251967],
            [1400630400000, 251546149],
            [1400716800000, 251840998],
            [1400803200000, 252285235],
            [1400889600000, 252955776],
            [1400976000000, 253585725],
            [1401062400000, 254112096],
            [1401148800000, 254273264],
            [1401235200000, 254419639],
            [1401321600000, 254549284],
            [1401408000000, 254728932],
            [1401494400000, 255019094],
            [1401580800000, 255176550],
            [1401667200000, 255241134],
            [1401753600000, 255315779],
            [1401840000000, 255384620],
            [1401926400000, 255447104]
        ],
        name: 'marvel14b',
        showInLegend: false,
        extra: {
            title: 'Captain America: The Winter Soldier',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#5B5E5C'
        },
        showlabel: false,
        color: 'rgba(91,94,92,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1386892800000, 31190587
            ],
            [1386979200000, 55621003],
            [1387065600000, 73645197],
            [1387152000000, 79847401],
            [1387238400000, 86142832],
            [1387324800000, 90998253],
            [1387411200000, 96045417],
            [1387497600000, 104671476],
            [1387584000000, 116942036],
            [1387670400000, 127550695],
            [1387756800000, 135373784],
            [1387843200000, 140639480],
            [1387929600000, 149945775],
            [1388016000000, 160469546],
            [1388102400000, 170474667],
            [1388188800000, 181060189],
            [1388275200000, 189501278],
            [1388361600000, 196014832],
            [1388448000000, 201542078],
            [1388534400000, 209334252],
            [1388620800000, 213384422],
            [1388707200000, 218481838],
            [1388793600000, 225152946],
            [1388880000000, 229059642],
            [1388966400000, 230360654],
            [1389052800000, 231928906],
            [1389139200000, 233100248],
            [1389225600000, 234204435],
            [1389312000000, 236249502],
            [1389398400000, 239939300],
            [1389484800000, 242226788],
            [1389571200000, 242844948],
            [1389657600000, 243628184],
            [1389744000000, 244222639],
            [1389830400000, 244819845],
            [1389916800000, 245714065],
            [1390003200000, 247465176],
            [1390089600000, 248524802],
            [1390176000000, 249360009],
            [1390262400000, 249681194],
            [1390348800000, 249928468],
            [1390435200000, 250178924],
            [1390521600000, 250679199],
            [1390608000000, 251680488],
            [1390694400000, 252326338],
            [1390780800000, 252488560],
            [1390867200000, 252701565],
            [1390953600000, 252861318],
            [1391040000000, 253029814],
            [1391126400000, 253367459],
            [1391212800000, 254024573],
            [1391299200000, 254264916],
            [1391385600000, 254373056],
            [1391472000000, 254497516],
            [1391558400000, 254599912],
            [1391644800000, 254710178],
            [1391731200000, 254867885],
            [1391817600000, 255194930],
            [1391904000000, 255398374],
            [1391990400000, 255464576],
            [1392076800000, 255534070],
            [1392163200000, 255576240],
            [1392249600000, 255625377],
            [1392336000000, 255768974],
            [1392422400000, 255966978],
            [1392508800000, 256122886],
            [1392595200000, 256231641],
            [1392681600000, 256274853],
            [1392768000000, 256309318],
            [1392854400000, 256343744],
            [1392940800000, 256418657],
            [1393027200000, 256558495],
            [1393113600000, 256636874],
            [1393200000000, 256661251],
            [1393286400000, 256693502],
            [1393372800000, 256719001],
            [1393459200000, 256748112],
            [1393545600000, 256800863],
            [1393632000000, 256901034],
            [1393718400000, 256961185],
            [1393804800000, 256982291],
            [1393891200000, 257010760],
            [1393977600000, 257028997],
            [1394064000000, 257053307],
            [1394150400000, 257140616],
            [1394236800000, 257296927],
            [1394323200000, 257397516],
            [1394409600000, 257435546],
            [1394496000000, 257479615],
            [1394582400000, 257516050],
            [1394668800000, 257557425],
            [1394755200000, 257625839],
            [1394841600000, 257735871],
            [1394928000000, 257805640],
            [1395014400000, 257827966],
            [1395100800000, 257855596],
            [1395187200000, 257879181],
            [1395273600000, 257903709],
            [1395360000000, 257939365],
            [1395446400000, 257998952],
            [1395532800000, 258039176],
            [1395619200000, 258054063],
            [1395705600000, 258070038],
            [1395792000000, 258085872],
            [1395878400000, 258102656],
            [1395964800000, 258131481],
            [1396051200000, 258179384],
            [1396137600000, 258206253],
            [1396224000000, 258216400],
            [1396310400000, 258226423],
            [1396396800000, 258236387],
            [1396483200000, 258246584],
            [1396569600000, 258264154],
            [1396656000000, 258289806],
            [1396742400000, 258307304],
            [1396828800000, 258312353],
            [1396915200000, 258317855],
            [1397001600000, 258322697],
            [1397088000000, 258327975],
            [1397174400000, 258335388],
            [1397260800000, 258347722],
            [1397347200000, 258355354],
            [1397433600000, 258357625],
            [1397520000000, 258360282],
            [1397606400000, 258363104],
            [1397692800000, 258366855]
        ],
        name: 'hobbit2',
        showInLegend: false,
        extra: {
            title: 'The Hobbit: The Desolation of Smaug',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#372D20'
        },
        showlabel: false,
        color: 'rgba(55,45,32,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1391731200000, 17094132
            ],
            [1391817600000, 47907731],
            [1391904000000, 69050279],
            [1391990400000, 72544343],
            [1392076800000, 75675447],
            [1392163200000, 77861671],
            [1392249600000, 80302930],
            [1392336000000, 93101604],
            [1392422400000, 113364021],
            [1392508800000, 130149360],
            [1392595200000, 142781396],
            [1392681600000, 146333594],
            [1392768000000, 149006940],
            [1392854400000, 151710096],
            [1392940800000, 158985835],
            [1393027200000, 173464868],
            [1393113600000, 183015455],
            [1393200000000, 184256605],
            [1393286400000, 185829929],
            [1393372800000, 187047966],
            [1393459200000, 188310084],
            [1393545600000, 192721994],
            [1393632000000, 202987811],
            [1393718400000, 209138440],
            [1393804800000, 210406935],
            [1393891200000, 211954057],
            [1393977600000, 212928472],
            [1394064000000, 213966612],
            [1394150400000, 216493151],
            [1394236800000, 221606983],
            [1394323200000, 224877997],
            [1394409600000, 225845025],
            [1394496000000, 227123377],
            [1394582400000, 228142711],
            [1394668800000, 229226928],
            [1394755200000, 231280318],
            [1394841600000, 234628399],
            [1394928000000, 236928237],
            [1395014400000, 237541707],
            [1395100800000, 238205322],
            [1395187200000, 238753354],
            [1395273600000, 239236674],
            [1395360000000, 240213180],
            [1395446400000, 242064979],
            [1395532800000, 243385918],
            [1395619200000, 243796694],
            [1395705600000, 244327702],
            [1395792000000, 244767854],
            [1395878400000, 245198720],
            [1395964800000, 245921628],
            [1396051200000, 247345902],
            [1396137600000, 248216780],
            [1396224000000, 248466064],
            [1396310400000, 248749247],
            [1396396800000, 248981712],
            [1396483200000, 249206303],
            [1396569600000, 249566394],
            [1396656000000, 250196189],
            [1396742400000, 250608584],
            [1396828800000, 250729663],
            [1396915200000, 250860428],
            [1397001600000, 250963732],
            [1397088000000, 251058771],
            [1397174400000, 251178965],
            [1397260800000, 251395075],
            [1397347200000, 251560804],
            [1397433600000, 251618809],
            [1397520000000, 251710777],
            [1397606400000, 251779672],
            [1397692800000, 251859590],
            [1397779200000, 252021043],
            [1397865600000, 252176396],
            [1397952000000, 252259056],
            [1398038400000, 252326549],
            [1398124800000, 252365392],
            [1398211200000, 252405232],
            [1398297600000, 252442478],
            [1398384000000, 252525956],
            [1398470400000, 252694698],
            [1398556800000, 252798441],
            [1398643200000, 252819786],
            [1398729600000, 252840917],
            [1398816000000, 252859723],
            [1398902400000, 252877964],
            [1398988800000, 252932340],
            [1399075200000, 253037002],
            [1399161600000, 253106875],
            [1399248000000, 253121548],
            [1399334400000, 253143246],
            [1399420800000, 253160557],
            [1399507200000, 253178106],
            [1399593600000, 253297197],
            [1399680000000, 253511434],
            [1399766400000, 253666490],
            [1399852800000, 253703337],
            [1399939200000, 253743500],
            [1400025600000, 253780046],
            [1400112000000, 253817652],
            [1400198400000, 253943936],
            [1400284800000, 254182337],
            [1400371200000, 254342250],
            [1400457600000, 254391823],
            [1400544000000, 254434447],
            [1400630400000, 254472429],
            [1400716800000, 254514488],
            [1400803200000, 254612385],
            [1400889600000, 254774915],
            [1400976000000, 254921743],
            [1401062400000, 255055805],
            [1401148800000, 255089694],
            [1401235200000, 255122566],
            [1401321600000, 255160511],
            [1401408000000, 255235848],
            [1401494400000, 255352759],
            [1401580800000, 255436997],
            [1401667200000, 255469249],
            [1401753600000, 255507918],
            [1401840000000, 255548520],
            [1401926400000, 255590340],
            [1402012800000, 255676885],
            [1402099200000, 255793913],
            [1402185600000, 255878392],
            [1402272000000, 255925796],
            [1402358400000, 255981549],
            [1402444800000, 256041204],
            [1402531200000, 256103031],
            [1402617600000, 256169386],
            [1402704000000, 256250586],
            [1402790400000, 256330271],
            [1402876800000, 256373719],
            [1402963200000, 256417582],
            [1403049600000, 256480713],
            [1403136000000, 256523725],
            [1403222400000, 256580457],
            [1403308800000, 256648286],
            [1403395200000, 256696317],
            [1403481600000, 256728844],
            [1403568000000, 256770706],
            [1403654400000, 256813462],
            [1403740800000, 256853726],
            [1403827200000, 256902692],
            [1403913600000, 256956996],
            [1404000000000, 257000260],
            [1404086400000, 257029805],
            [1404172800000, 257061167],
            [1404259200000, 257092045],
            [1404345600000, 257122203],
            [1404432000000, 257140904],
            [1404518400000, 257164974],
            [1404604800000, 257186165],
            [1404691200000, 257202393],
            [1404777600000, 257221361],
            [1404864000000, 257238953],
            [1404950400000, 257257169],
            [1405036800000, 257282176],
            [1405123200000, 257310950],
            [1405209600000, 257335781],
            [1405296000000, 257360168],
            [1405382400000, 257386649],
            [1405468800000, 257417504],
            [1405555200000, 257442541],
            [1405641600000, 257457399],
            [1405728000000, 257471951],
            [1405814400000, 257484827],
            [1405900800000, 257497614],
            [1405987200000, 257514046],
            [1406073600000, 257529703],
            [1406160000000, 257546492],
            [1406246400000, 257558136],
            [1406332800000, 257569513],
            [1406419200000, 257582914],
            [1406505600000, 257592581],
            [1406592000000, 257633962],
            [1406678400000, 257687552],
            [1406764800000, 257709556],
            [1406851200000, 257711715],
            [1406937600000, 257714297],
            [1407024000000, 257716507],
            [1407110400000, 257718668],
            [1407196800000, 257724678],
            [1407283200000, 257725907],
            [1407369600000, 257726852],
            [1407456000000, 257728146],
            [1407542400000, 257729616],
            [1407628800000, 257731107],
            [1407715200000, 257732595],
            [1407801600000, 257734359],
            [1407888000000, 257737068],
            [1407974400000, 257740531],
            [1408060800000, 257741614],
            [1408147200000, 257742752],
            [1408233600000, 257743820],
            [1408320000000, 257745430],
            [1408406400000, 257746769],
            [1408492800000, 257748132],
            [1408579200000, 257749270],
            [1408665600000, 257749440],
            [1408752000000, 257749590],
            [1408838400000, 257749647],
            [1408924800000, 257749702],
            [1409011200000, 257750038],
            [1409097600000, 257750402],
            [1409184000000, 257750702],
            [1409270400000, 257752034],
            [1409356800000, 257753341],
            [1409443200000, 257754698],
            [1409529600000, 257756197],
            [1409616000000, 257757671],
            [1409702400000, 257759191],
            [1409788800000, 257760692]
        ],
        name: 'lego',
        showInLegend: false,
        extra: {
            title: 'The LEGO Movie',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#5F597D'
        },
        showlabel: false,
        color: 'rgba(95,89,125,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1241654400000, 4000000
            ],
            [1241740800000, 30893975],
            [1241827200000, 58142588],
            [1241913600000, 79204289],
            [1242000000000, 86706315],
            [1242086400000, 93212090],
            [1242172800000, 99002539],
            [1242259200000, 104610837],
            [1242345600000, 116370953],
            [1242432000000, 134655023],
            [1242518400000, 147645384],
            [1242604800000, 152175578],
            [1242691200000, 155536131],
            [1242777600000, 158653970],
            [1242864000000, 161634019],
            [1242950400000, 167528194],
            [1243036800000, 176029128],
            [1243123200000, 184526281],
            [1243209600000, 191014403],
            [1243296000000, 193027281],
            [1243382400000, 194828380],
            [1243468800000, 196700157],
            [1243555200000, 200319725],
            [1243641600000, 205705246],
            [1243728000000, 209313884],
            [1243814400000, 210586019],
            [1243900800000, 211908809],
            [1243987200000, 213171805],
            [1244073600000, 214401695],
            [1244160000000, 216882420],
            [1244246400000, 220422696],
            [1244332800000, 222712175],
            [1244419200000, 223638905],
            [1244505600000, 224564055],
            [1244592000000, 225473885],
            [1244678400000, 226428402],
            [1244764800000, 227976174],
            [1244851200000, 230367638],
            [1244937600000, 231882965],
            [1245024000000, 232557467],
            [1245110400000, 233291888],
            [1245196800000, 233992475],
            [1245283200000, 234743906],
            [1245369600000, 235976885],
            [1245456000000, 237968898],
            [1245542400000, 240255340],
            [1245628800000, 240823706],
            [1245715200000, 241361911],
            [1245801600000, 242063184],
            [1245888000000, 242619214],
            [1245974400000, 243802725],
            [1246060800000, 245367595],
            [1246147200000, 246331182],
            [1246233600000, 246779912],
            [1246320000000, 247306259],
            [1246406400000, 247625972],
            [1246492800000, 248068172],
            [1246579200000, 248805036],
            [1246665600000, 249334504],
            [1246752000000, 249838139],
            [1246838400000, 250088417],
            [1246924800000, 250335827],
            [1247011200000, 250570144],
            [1247097600000, 250806379],
            [1247184000000, 251171644],
            [1247270400000, 251655655],
            [1247356800000, 251970795],
            [1247443200000, 252119599],
            [1247529600000, 252266670],
            [1247616000000, 252365299],
            [1247702400000, 252473974],
            [1247788800000, 252677040],
            [1247875200000, 252976117],
            [1247961600000, 253164613],
            [1248048000000, 253251652],
            [1248134400000, 253359387],
            [1248220800000, 253460512],
            [1248307200000, 253580933],
            [1248393600000, 253710838],
            [1248480000000, 253892841],
            [1248566400000, 254020378],
            [1248652800000, 254089632],
            [1248739200000, 254170379],
            [1248825600000, 254255507],
            [1248912000000, 254334469],
            [1248998400000, 254426936],
            [1249084800000, 254557321],
            [1249171200000, 254661846],
            [1249257600000, 254719311],
            [1249344000000, 254777330],
            [1249430400000, 254834025],
            [1249516800000, 254889130],
            [1249603200000, 255020651],
            [1249689600000, 255202930],
            [1249776000000, 255327784],
            [1249862400000, 255396149],
            [1249948800000, 255471687],
            [1250035200000, 255541196],
            [1250121600000, 255612397],
            [1250208000000, 255711760],
            [1250294400000, 255846203],
            [1250380800000, 255936227],
            [1250467200000, 255985786],
            [1250553600000, 256038213],
            [1250640000000, 256083762],
            [1250726400000, 256133843],
            [1250812800000, 256210077],
            [1250899200000, 256313314],
            [1250985600000, 256374154],
            [1251072000000, 256402634],
            [1251158400000, 256428821],
            [1251244800000, 256457790],
            [1251331200000, 256490791],
            [1251417600000, 256545569],
            [1251504000000, 256629655],
            [1251590400000, 256673273],
            [1251676800000, 256694793],
            [1251763200000, 256717048],
            [1251849600000, 256739608],
            [1251936000000, 256764966],
            [1252022400000, 256841638],
            [1252108800000, 256961236],
            [1252195200000, 257094634],
            [1252281600000, 257171491],
            [1252368000000, 257191845],
            [1252454400000, 257209773],
            [1252540800000, 257233992],
            [1252627200000, 257289823],
            [1252713600000, 257383678],
            [1252800000000, 257424306],
            [1252886400000, 257440581],
            [1252972800000, 257458458],
            [1253059200000, 257479558],
            [1253145600000, 257503685],
            [1253232000000, 257535408],
            [1253318400000, 257584462],
            [1253404800000, 257604001],
            [1253491200000, 257611714],
            [1253577600000, 257619036],
            [1253664000000, 257628094],
            [1253750400000, 257638255],
            [1253836800000, 257657973],
            [1253923200000, 257690448],
            [1254009600000, 257704099],
            [1254096000000, 257710778],
            [1254182400000, 257716123],
            [1254268800000, 257721833],
            [1254355200000, 257730019]
        ],
        name: 'startrek11',
        showInLegend: false,
        extra: {
            title: 'Star Trek',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#8E979B'
        },
        showlabel: false,
        color: 'rgba(142,151,155,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1197590400000, 30059386
            ],
            [1197676800000, 58854500],
            [1197763200000, 77211321],
            [1197849600000, 84676771],
            [1197936000000, 91179888],
            [1198022400000, 97201184],
            [1198108800000, 103265293],
            [1198195200000, 114173200],
            [1198281600000, 126575006],
            [1198368000000, 136768494],
            [1198454400000, 141169517],
            [1198540800000, 150950671],
            [1198627200000, 159672020],
            [1198713600000, 167075237],
            [1198800000000, 176360519],
            [1198886400000, 186245378],
            [1198972800000, 194489704],
            [1199059200000, 199345154],
            [1199145600000, 206129574],
            [1199232000000, 209506903],
            [1199318400000, 212338204],
            [1199404800000, 217524065],
            [1199491200000, 224370732],
            [1199577600000, 228055662],
            [1199664000000, 229118908],
            [1199750400000, 230187062],
            [1199836800000, 231170492],
            [1199923200000, 232103841],
            [1200009600000, 234657832],
            [1200096000000, 238342192],
            [1200182400000, 240283451],
            [1200268800000, 240869820],
            [1200355200000, 241444213],
            [1200441600000, 241995994],
            [1200528000000, 242577424],
            [1200614400000, 243961942],
            [1200700800000, 246171454],
            [1200787200000, 247468797],
            [1200873600000, 248482867],
            [1200960000000, 248815030],
            [1201046400000, 249122328],
            [1201132800000, 249455640],
            [1201219200000, 250049656],
            [1201305600000, 251113537],
            [1201392000000, 251666936],
            [1201478400000, 251820178],
            [1201564800000, 251962543],
            [1201651200000, 252106654],
            [1201737600000, 252247711],
            [1201824000000, 252545958],
            [1201910400000, 253105383],
            [1201996800000, 253263158],
            [1202083200000, 253347464],
            [1202169600000, 253420893],
            [1202256000000, 253493274],
            [1202342400000, 253571734],
            [1202428800000, 253726349],
            [1202515200000, 254011393],
            [1202601600000, 254161107],
            [1202688000000, 254205399],
            [1202774400000, 254244650],
            [1202860800000, 254280993],
            [1202947200000, 254324468],
            [1203033600000, 254391955],
            [1203120000000, 254507764],
            [1203206400000, 254592462],
            [1203292800000, 254643034],
            [1203379200000, 254660926],
            [1203465600000, 254677693],
            [1203552000000, 254695259],
            [1203638400000, 254735176],
            [1203724800000, 254805378],
            [1203811200000, 254846426],
            [1203897600000, 254856495],
            [1203984000000, 254867239],
            [1204070400000, 254876501],
            [1204156800000, 254887764],
            [1204243200000, 254988274],
            [1204329600000, 255165109],
            [1204416000000, 255268029],
            [1204502400000, 255299643],
            [1204588800000, 255331126],
            [1204675200000, 255360875],
            [1204761600000, 255392764],
            [1204848000000, 255476605],
            [1204934400000, 255610983],
            [1205020800000, 255687117],
            [1205107200000, 255711141],
            [1205193600000, 255735812],
            [1205280000000, 255759710],
            [1205366400000, 255786554],
            [1205452800000, 255849048],
            [1205539200000, 255952386],
            [1205625600000, 256015411],
            [1205712000000, 256037850],
            [1205798400000, 256060567],
            [1205884800000, 256084161],
            [1205971200000, 256112613],
            [1206057600000, 256153119],
            [1206144000000, 256199982],
            [1206230400000, 256227323],
            [1206316800000, 256242250],
            [1206403200000, 256254878],
            [1206489600000, 256266812],
            [1206576000000, 256279068],
            [1206662400000, 256296978],
            [1206748800000, 256325045],
            [1206835200000, 256339571],
            [1206921600000, 256343491],
            [1207008000000, 256347494],
            [1207094400000, 256351306],
            [1207180800000, 256356018],
            [1207267200000, 256364599],
            [1207353600000, 256379239],
            [1207440000000, 256386216],
            [1207526400000, 256388100],
            [1207612800000, 256390149],
            [1207699200000, 256391475],
            [1207785600000, 256393010]
        ],
        name: 'iamlegend',
        showInLegend: false,
        extra: {
            title: 'I Am Legend',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#837044'
        },
        showlabel: false,
        color: 'rgba(131,112,68,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1258675200000, 11038423
            ],
            [1258761600000, 24780866],
            [1258848000000, 34119372],
            [1258934400000, 37777442],
            [1259020800000, 42719653],
            [1259107200000, 50638142],
            [1259193600000, 60127477],
            [1259280000000, 76313333],
            [1259366400000, 92186267],
            [1259452800000, 100238841],
            [1259539200000, 102302162],
            [1259625600000, 104619548],
            [1259712000000, 106747005],
            [1259798400000, 108824378],
            [1259884800000, 115593204],
            [1259971200000, 124141096],
            [1260057600000, 128867559],
            [1260144000000, 130309730],
            [1260230400000, 131879132],
            [1260316800000, 133293080],
            [1260403200000, 134761539],
            [1260489600000, 139487248],
            [1260576000000, 146365508],
            [1260662400000, 149816797],
            [1260748800000, 150910191],
            [1260835200000, 152178442],
            [1260921600000, 153390852],
            [1261008000000, 154704245],
            [1261094400000, 157885546],
            [1261180800000, 161792920],
            [1261267200000, 164725525],
            [1261353600000, 166726943],
            [1261440000000, 168945040],
            [1261526400000, 171122488],
            [1261612800000, 172676636],
            [1261699200000, 176049041],
            [1261785600000, 180705468],
            [1261872000000, 184195981],
            [1261958400000, 187028691],
            [1262044800000, 190032257],
            [1262131200000, 193098093],
            [1262217600000, 196563318],
            [1262304000000, 201118097],
            [1262390400000, 206115756],
            [1262476800000, 208476067],
            [1262563200000, 209300187],
            [1262649600000, 210068528],
            [1262736000000, 210808692],
            [1262822400000, 211446909],
            [1262908800000, 213666162],
            [1262995200000, 217118901],
            [1263081600000, 218978376],
            [1263168000000, 219479602],
            [1263254400000, 220033786],
            [1263340800000, 220602183],
            [1263427200000, 221209265],
            [1263513600000, 222786647],
            [1263600000000, 225141023],
            [1263686400000, 226766539],
            [1263772800000, 228181615],
            [1263859200000, 228628890],
            [1263945600000, 229038168],
            [1264032000000, 229512266],
            [1264118400000, 230746409],
            [1264204800000, 232850310],
            [1264291200000, 233678402],
            [1264377600000, 233982624],
            [1264464000000, 234295385],
            [1264550400000, 234593473],
            [1264636800000, 234893488],
            [1264723200000, 235691598],
            [1264809600000, 237129113],
            [1264896000000, 237914805],
            [1264982400000, 238142164],
            [1265068800000, 238430210],
            [1265155200000, 238732222],
            [1265241600000, 239026369],
            [1265328000000, 239799924],
            [1265414400000, 241146044],
            [1265500800000, 241529593],
            [1265587200000, 241740702],
            [1265673600000, 241979020],
            [1265760000000, 242200104],
            [1265846400000, 242466341],
            [1265932800000, 242929538],
            [1266019200000, 243853133],
            [1266105600000, 244728128],
            [1266192000000, 245133549],
            [1266278400000, 245295717],
            [1266364800000, 245450449],
            [1266451200000, 245619952],
            [1266537600000, 246012595],
            [1266624000000, 246723649],
            [1266710400000, 247071052],
            [1266796800000, 247180382],
            [1266883200000, 247286743],
            [1266969600000, 247399187],
            [1267056000000, 247517504],
            [1267142400000, 247834488],
            [1267228800000, 248484298],
            [1267315200000, 248755981],
            [1267401600000, 248839100],
            [1267488000000, 248953327],
            [1267574400000, 249075698],
            [1267660800000, 249209861],
            [1267747200000, 249545415],
            [1267833600000, 250181633],
            [1267920000000, 250467047],
            [1268006400000, 250629341],
            [1268092800000, 250799483],
            [1268179200000, 250953663],
            [1268265600000, 251132171],
            [1268352000000, 251604582],
            [1268438400000, 252317220],
            [1268524800000, 252736267],
            [1268611200000, 252900318],
            [1268697600000, 253075641],
            [1268784000000, 253231923],
            [1268870400000, 253396245],
            [1268956800000, 253656038],
            [1269043200000, 254042731],
            [1269129600000, 254273981],
            [1269216000000, 254357322],
            [1269302400000, 254442096],
            [1269388800000, 254517962],
            [1269475200000, 254596838],
            [1269561600000, 254747501],
            [1269648000000, 254952920],
            [1269734400000, 255071943],
            [1269820800000, 255119553],
            [1269907200000, 255170020],
            [1269993600000, 255216449],
            [1270080000000, 255263128],
            [1270166400000, 255349536],
            [1270252800000, 255440304],
            [1270339200000, 255492549],
            [1270425600000, 255522074],
            [1270512000000, 255549109],
            [1270598400000, 255575729],
            [1270684800000, 255603947],
            [1270771200000, 255650306],
            [1270857600000, 255713779],
            [1270944000000, 255740350],
            [1271030400000, 255748419],
            [1271116800000, 255759189],
            [1271203200000, 255768167],
            [1271289600000, 255778045],
            [1271376000000, 255798645],
            [1271462400000, 255832713],
            [1271548800000, 255846167],
            [1271635200000, 255850871],
            [1271721600000, 255856255],
            [1271808000000, 255861997],
            [1271894400000, 255867313],
            [1271980800000, 255877670],
            [1272067200000, 255891402],
            [1272153600000, 255899261],
            [1272240000000, 255902119],
            [1272326400000, 255905095],
            [1272412800000, 255907512],
            [1272499200000, 255910443],
            [1272585600000, 255914695],
            [1272672000000, 255925725],
            [1272758400000, 255929947],
            [1272844800000, 255930961],
            [1272931200000, 255932390],
            [1273017600000, 255933584],
            [1273104000000, 255935011],
            [1273190400000, 255937678],
            [1273276800000, 255942097],
            [1273363200000, 255944818],
            [1273449600000, 255945460],
            [1273536000000, 255946471],
            [1273622400000, 255947187],
            [1273708800000, 255947990],
            [1273795200000, 255948694],
            [1273881600000, 255949718],
            [1273968000000, 255950375],
            [1274054400000, 255950527],
            [1274140800000, 255950756],
            [1274227200000, 255950991],
            [1274313600000, 255951749]
        ],
        name: 'blindside',
        showInLegend: false,
        extra: {
            title: 'The Blind Side',
            genre: 'Sports Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#74766F'
        },
        showlabel: false,
        color: 'rgba(116,118,111,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1418774400000, 24452117
            ],
            [1418860800000, 34407210],
            [1418947200000, 50970581],
            [1419033600000, 72367595],
            [1419120000000, 89131544],
            [1419206400000, 98138554],
            [1419292800000, 107941968],
            [1419379200000, 113966100],
            [1419465600000, 127096118],
            [1419552000000, 142704972],
            [1419638400000, 157007428],
            [1419724800000, 168017513],
            [1419811200000, 175575347],
            [1419897600000, 183547654],
            [1419984000000, 189549326],
            [1420070400000, 198869927],
            [1420156800000, 207171126],
            [1420243200000, 215307016],
            [1420329600000, 220602017],
            [1420416000000, 222379434],
            [1420502400000, 224308892],
            [1420588800000, 225747311],
            [1420675200000, 227082487],
            [1420761600000, 229534084],
            [1420848000000, 233763132],
            [1420934400000, 236459605],
            [1421020800000, 237180324],
            [1421107200000, 238182655],
            [1421193600000, 238969825],
            [1421280000000, 239677115],
            [1421366400000, 240862948],
            [1421452800000, 243102411],
            [1421539200000, 244581810],
            [1421625600000, 245656417],
            [1421712000000, 246120862],
            [1421798400000, 246448344],
            [1421884800000, 246770959],
            [1421971200000, 247433531],
            [1422057600000, 248734835],
            [1422144000000, 249545262],
            [1422230400000, 249746308],
            [1422316800000, 250000941],
            [1422403200000, 250206946],
            [1422489600000, 250397988],
            [1422576000000, 250753102],
            [1422662400000, 251434885],
            [1422748800000, 251688921],
            [1422835200000, 251810229],
            [1422921600000, 251946522],
            [1423008000000, 252054610],
            [1423094400000, 252150902],
            [1423180800000, 252329626],
            [1423267200000, 252685055],
            [1423353600000, 252906934],
            [1423440000000, 252980968],
            [1423526400000, 253048438],
            [1423612800000, 253104782],
            [1423699200000, 253161689],
            [1423785600000, 253243571],
            [1423872000000, 253439737],
            [1423958400000, 253573010],
            [1424044800000, 253668587],
            [1424131200000, 253702950],
            [1424217600000, 253732502],
            [1424304000000, 253763236],
            [1424390400000, 253814387],
            [1424476800000, 253896796],
            [1424563200000, 253949155],
            [1424649600000, 253971146],
            [1424736000000, 253997535],
            [1424822400000, 254017854],
            [1424908800000, 254038783],
            [1424995200000, 254111647],
            [1425081600000, 254240570],
            [1425168000000, 254326629],
            [1425254400000, 254359774],
            [1425340800000, 254396565],
            [1425427200000, 254425998],
            [1425513600000, 254456608],
            [1425600000000, 254512378],
            [1425686400000, 254612496],
            [1425772800000, 254672205],
            [1425859200000, 254696686],
            [1425945600000, 254725573],
            [1426032000000, 254748382],
            [1426118400000, 254775296],
            [1426204800000, 254812558],
            [1426291200000, 254875855],
            [1426377600000, 254916285],
            [1426464000000, 254927762],
            [1426550400000, 254940387],
            [1426636800000, 254953264],
            [1426723200000, 254967930],
            [1426809600000, 254988320],
            [1426896000000, 255021938],
            [1426982400000, 255043150],
            [1427068800000, 255050634],
            [1427155200000, 255057692],
            [1427241600000, 255064405],
            [1427328000000, 255071340],
            [1427414400000, 255082414],
            [1427500800000, 255099393],
            [1427587200000, 255108370],
            [1427673600000, 255110960],
            [1427760000000, 255113783],
            [1427846400000, 255116583],
            [1427932800000, 255119788]
        ],
        name: 'hobbit3',
        showInLegend: false,
        extra: {
            title: 'The Hobbit: The Battle of the Five Armies',
            genre: 'Fantasy',

            mpaaRating: 'PG-13',
            imgMainColor: '#414647'
        },
        showlabel: false,
        color: 'rgba(65,70,71,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1306368000000, 31610367
            ],
            [1306454400000, 61592547],
            [1306540800000, 91282555],
            [1306627200000, 117556661],
            [1306713600000, 135037242],
            [1306800000000, 142622321],
            [1306886400000, 148915509],
            [1306972800000, 154426960],
            [1307059200000, 165044408],
            [1307145600000, 177870031],
            [1307232000000, 185808194],
            [1307318400000, 189055393],
            [1307404800000, 192314465],
            [1307491200000, 195218708],
            [1307577600000, 198060132],
            [1307664000000, 203759537],
            [1307750400000, 211342815],
            [1307836800000, 215727461],
            [1307923200000, 217611859],
            [1308009600000, 219685324],
            [1308096000000, 221317031],
            [1308182400000, 223039278],
            [1308268800000, 226284251],
            [1308355200000, 230331745],
            [1308441600000, 233110617],
            [1308528000000, 234344093],
            [1308614400000, 235629560],
            [1308700800000, 236850667],
            [1308787200000, 238077681],
            [1308873600000, 239894257],
            [1308960000000, 242211989],
            [1309046400000, 243651860],
            [1309132800000, 244295348],
            [1309219200000, 244948646],
            [1309305600000, 245377688],
            [1309392000000, 245851882],
            [1309478400000, 246549402],
            [1309564800000, 247415588],
            [1309651200000, 248243615],
            [1309737600000, 248651272],
            [1309824000000, 248987657],
            [1309910400000, 249304706],
            [1309996800000, 249619183],
            [1310083200000, 250013174],
            [1310169600000, 250506220],
            [1310256000000, 250817247],
            [1310342400000, 250961401],
            [1310428800000, 251118756],
            [1310515200000, 251255860],
            [1310601600000, 251377150],
            [1310688000000, 251538932],
            [1310774400000, 251756876],
            [1310860800000, 251881953],
            [1310947200000, 251949495],
            [1311033600000, 252025142],
            [1311120000000, 252090955],
            [1311206400000, 252160717],
            [1311292800000, 252257423],
            [1311379200000, 252383615],
            [1311465600000, 252459309],
            [1311552000000, 252500941],
            [1311638400000, 252546319],
            [1311724800000, 252586252],
            [1311811200000, 252628017],
            [1311897600000, 252744277],
            [1311984000000, 252900898],
            [1312070400000, 253027043],
            [1312156800000, 253095542],
            [1312243200000, 253167645],
            [1312329600000, 253234700],
            [1312416000000, 253296004],
            [1312502400000, 253387186],
            [1312588800000, 253503323],
            [1312675200000, 253589163],
            [1312761600000, 253632942],
            [1312848000000, 253680198],
            [1312934400000, 253721784],
            [1313020800000, 253759628],
            [1313107200000, 253813574],
            [1313193600000, 253886769],
            [1313280000000, 253941292],
            [1313366400000, 253967554],
            [1313452800000, 253995054],
            [1313539200000, 254019329],
            [1313625600000, 254042976],
            [1313712000000, 254082317],
            [1313798400000, 254138229],
            [1313884800000, 254174506],
            [1313971200000, 254190294],
            [1314057600000, 254206513],
            [1314144000000, 254222084],
            [1314230400000, 254236410],
            [1314316800000, 254256383],
            [1314403200000, 254285042],
            [1314489600000, 254302056],
            [1314576000000, 254309713],
            [1314662400000, 254318114],
            [1314748800000, 254325595],
            [1314835200000, 254333102],
            [1314921600000, 254348066],
            [1315008000000, 254375119],
            [1315094400000, 254404872],
            [1315180800000, 254416436],
            [1315267200000, 254420562],
            [1315353600000, 254424152],
            [1315440000000, 254427606],
            [1315526400000, 254436817],
            [1315612800000, 254450912],
            [1315699200000, 254455986],
            [1315785600000, 254457929],
            [1315872000000, 254460203],
            [1315958400000, 254462204],
            [1316044800000, 254464305]
        ],
        name: 'hangover2',
        showInLegend: false,
        extra: {
            title: 'The Hangover Part II',
            genre: 'Comedy',

            mpaaRating: 'R',
            imgMainColor: '#8A6B4C'
        },
        showlabel: false,
        color: 'rgba(138,107,76,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1278633600000, 21342640
            ],
            [1278720000000, 42181260],
            [1278806400000, 56397125],
            [1278892800000, 63922665],
            [1278979200000, 72073885],
            [1279065600000, 79233770],
            [1279152000000, 85630895],
            [1279238400000, 95766290],
            [1279324800000, 108491715],
            [1279411200000, 118434555],
            [1279497600000, 123318450],
            [1279584000000, 128534940],
            [1279670400000, 133016220],
            [1279756800000, 137600845],
            [1279843200000, 145052970],
            [1279929600000, 154306020],
            [1280016000000, 161289905],
            [1280102400000, 164422130],
            [1280188800000, 168039465],
            [1280275200000, 171350870],
            [1280361600000, 174806195],
            [1280448000000, 179506805],
            [1280534400000, 185594440],
            [1280620800000, 190330425],
            [1280707200000, 192743765],
            [1280793600000, 195373890],
            [1280880000000, 197697485],
            [1280966400000, 200003985],
            [1281052800000, 202853840],
            [1281139200000, 206488685],
            [1281225600000, 209287345],
            [1281312000000, 210754935],
            [1281398400000, 212444440],
            [1281484800000, 213826705],
            [1281571200000, 215226035],
            [1281657600000, 217315980],
            [1281744000000, 220078215],
            [1281830400000, 222197390],
            [1281916800000, 223293385],
            [1282003200000, 224402670],
            [1282089600000, 225514175],
            [1282176000000, 226394925],
            [1282262400000, 227613545],
            [1282348800000, 229469430],
            [1282435200000, 231056990],
            [1282521600000, 231716435],
            [1282608000000, 232398415],
            [1282694400000, 232958410],
            [1282780800000, 233416405],
            [1282867200000, 234167930],
            [1282953600000, 235405410],
            [1283040000000, 236276085],
            [1283126400000, 236568770],
            [1283212800000, 236935195],
            [1283299200000, 237197300],
            [1283385600000, 237450950],
            [1283472000000, 238122835],
            [1283558400000, 239282865],
            [1283644800000, 240434965],
            [1283731200000, 241498630],
            [1283817600000, 241634615],
            [1283904000000, 241738645],
            [1283990400000, 241874870],
            [1284076800000, 242218620],
            [1284163200000, 242988845],
            [1284249600000, 243531970],
            [1284336000000, 243600965],
            [1284422400000, 243684130],
            [1284508800000, 243752355],
            [1284595200000, 243828050],
            [1284681600000, 244026295],
            [1284768000000, 244460535],
            [1284854400000, 244739015],
            [1284940800000, 244786200],
            [1285027200000, 244838185],
            [1285113600000, 244885070],
            [1285200000000, 244932080],
            [1285286400000, 245078505],
            [1285372800000, 245343855],
            [1285459200000, 245514665],
            [1285545600000, 245551210],
            [1285632000000, 245587875],
            [1285718400000, 245618370],
            [1285804800000, 245651920],
            [1285891200000, 245760725],
            [1285977600000, 245966760],
            [1286064000000, 246091770],
            [1286150400000, 246121865],
            [1286236800000, 246151975],
            [1286323200000, 246179755],
            [1286409600000, 246209750],
            [1286496000000, 246303295],
            [1286582400000, 246455085],
            [1286668800000, 246557455],
            [1286755200000, 246624525],
            [1286841600000, 246649235],
            [1286928000000, 246672180],
            [1287014400000, 246705715],
            [1287100800000, 246803655],
            [1287187200000, 246958035],
            [1287273600000, 247050995],
            [1287360000000, 247075740],
            [1287446400000, 247097470],
            [1287532800000, 247120775],
            [1287619200000, 247148995],
            [1287705600000, 247247815],
            [1287792000000, 247416270],
            [1287878400000, 247519950],
            [1287964800000, 247544285],
            [1288051200000, 247565345],
            [1288137600000, 247584785],
            [1288224000000, 247609095],
            [1288310400000, 247688970],
            [1288396800000, 247813220],
            [1288483200000, 247877105],
            [1288569600000, 247903880],
            [1288656000000, 247935705],
            [1288742400000, 247958990],
            [1288828800000, 247984010],
            [1288915200000, 248066900],
            [1289001600000, 248220415],
            [1289088000000, 248312500],
            [1289174400000, 248332455],
            [1289260800000, 248352545],
            [1289347200000, 248375570],
            [1289433600000, 248452320],
            [1289520000000, 248554695],
            [1289606400000, 248714400],
            [1289692800000, 248815410],
            [1289779200000, 248835885],
            [1289865600000, 248860455],
            [1289952000000, 248879565],
            [1290038400000, 248900040],
            [1290124800000, 248963020],
            [1290211200000, 249092990],
            [1290297600000, 249169375],
            [1290384000000, 249202875],
            [1290470400000, 249249840],
            [1290556800000, 249322990],
            [1290643200000, 249361560],
            [1290729600000, 249501210],
            [1290816000000, 249650170],
            [1290902400000, 249724650],
            [1290988800000, 249740645],
            [1291075200000, 249756475],
            [1291161600000, 249771105],
            [1291248000000, 249787065],
            [1291334400000, 249841650],
            [1291420800000, 249939640],
            [1291507200000, 250004040],
            [1291593600000, 250017900],
            [1291680000000, 250033160],
            [1291766400000, 250047035],
            [1291852800000, 250060965],
            [1291939200000, 250104315],
            [1292025600000, 250196115],
            [1292112000000, 250252285],
            [1292198400000, 250267570],
            [1292284800000, 250285420],
            [1292371200000, 250303190],
            [1292457600000, 250322315],
            [1292544000000, 250363090],
            [1292630400000, 250438815],
            [1292716800000, 250493640],
            [1292803200000, 250534415],
            [1292889600000, 250588005],
            [1292976000000, 250638100],
            [1293062400000, 250689360],
            [1293148800000, 250715415],
            [1293235200000, 250748225],
            [1293321600000, 250791650],
            [1293408000000, 250838935],
            [1293494400000, 250902625],
            [1293580800000, 250966220],
            [1293667200000, 251032805],
            [1293753600000, 251083040],
            [1293840000000, 251155930],
            [1293926400000, 251203225],
            [1294012800000, 251225880],
            [1294099200000, 251242625],
            [1294185600000, 251255430],
            [1294272000000, 251266265],
            [1294358400000, 251292950],
            [1294444800000, 251351690],
            [1294531200000, 251384620],
            [1294617600000, 251389960],
            [1294704000000, 251397970],
            [1294790400000, 251405090],
            [1294876800000, 251413975],
            [1294963200000, 251426310],
            [1295049600000, 251453695],
            [1295136000000, 251476985],
            [1295222400000, 251501645],
            [1295308800000, 251505755],
            [1295395200000, 251509840],
            [1295481600000, 251513985]
        ],
        name: 'despicableme',
        showInLegend: false,
        extra: {
            title: 'Despicable Me',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#717B86'
        },
        showlabel: false,
        color: 'rgba(113,123,134,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                614476800000, 2216138
            ],
            [614563200000, 15377781],
            [614649600000, 29980468],
            [614736000000, 42705884],
            [614822400000, 49945010],
            [614908800000, 57153250],
            [614995200000, 63783535],
            [615081600000, 70144480],
            [615168000000, 78936997],
            [615254400000, 90057798],
            [615340800000, 100219669],
            [615427200000, 107958264],
            [615513600000, 113703047],
            [615600000000, 118061136],
            [615686400000, 122410792],
            [615772800000, 128476389],
            [615859200000, 136086972],
            [615945600000, 141659121],
            [616032000000, 144463967],
            [616118400000, 147204021],
            [616204800000, 149854064],
            [616291200000, 152520733],
            [616377600000, 156831494],
            [616464000000, 162904420],
            [616550400000, 167635148],
            [616636800000, 169835250],
            [616723200000, 172052688],
            [616809600000, 174151848],
            [616896000000, 176357131],
            [616982400000, 179545350],
            [617068800000, 184296772],
            [617155200000, 187521450],
            [617241600000, 189080955],
            [617328000000, 190747700],
            [617414400000, 192294459],
            [617500800000, 193914570],
            [617587200000, 196412592],
            [617673600000, 200212401],
            [617760000000, 202867563],
            [617846400000, 204123594],
            [617932800000, 205429848],
            [618019200000, 206581312],
            [618105600000, 207651005],
            [618192000000, 209575202],
            [618278400000, 212326974],
            [618364800000, 214353921],
            [618451200000, 215313398],
            [618537600000, 216266211],
            [618624000000, 217113599],
            [618710400000, 217949973],
            [618796800000, 219417435],
            [618883200000, 221504398],
            [618969600000, 222976331],
            [619056000000, 223662559],
            [619142400000, 224432796],
            [619228800000, 225060436],
            [619315200000, 225681145],
            [619401600000, 226675877],
            [619488000000, 228066793],
            [619574400000, 229120869],
            [619660800000, 229613123],
            [619747200000, 230140325],
            [619833600000, 230607486],
            [619920000000, 231055636],
            [620006400000, 231806271],
            [620092800000, 232922436],
            [620179200000, 233653196],
            [620265600000, 234004496],
            [620352000000, 234400055],
            [620438400000, 234710967],
            [620524800000, 235019740],
            [620611200000, 235705461],
            [620697600000, 236820232],
            [620784000000, 237886300],
            [620870400000, 238559567],
            [620956800000, 238821951],
            [621043200000, 239013417],
            [621129600000, 239202201],
            [621216000000, 239713190],
            [621302400000, 240610919],
            [621388800000, 241089760],
            [621475200000, 241225863],
            [621561600000, 241380801],
            [621648000000, 241518593],
            [621734400000, 241667348],
            [621820800000, 242047570],
            [621907200000, 242759247],
            [621993600000, 243139754],
            [622080000000, 243241244],
            [622166400000, 243358750],
            [622252800000, 243467344],
            [622339200000, 243569147],
            [622425600000, 243853880],
            [622512000000, 244395163],
            [622598400000, 244670914],
            [622684800000, 244751117],
            [622771200000, 244845187],
            [622857600000, 244927995],
            [622944000000, 245015280],
            [623030400000, 245246353],
            [623116800000, 245665714],
            [623203200000, 245893171],
            [623289600000, 245952581],
            [623376000000, 246017071],
            [623462400000, 246077384],
            [623548800000, 246141960],
            [623635200000, 246324100],
            [623721600000, 246643909],
            [623808000000, 246842109],
            [623894400000, 246931118],
            [623980800000, 246988135],
            [624067200000, 247039796],
            [624153600000, 247095238],
            [624240000000, 247209294],
            [624326400000, 247393404],
            [624412800000, 247501202],
            [624499200000, 247531915],
            [624585600000, 247563788],
            [624672000000, 247595298],
            [624758400000, 247633223],
            [624844800000, 247711837],
            [624931200000, 247855505],
            [625017600000, 247932803],
            [625104000000, 247956602],
            [625190400000, 247983139],
            [625276800000, 248007974],
            [625363200000, 248034112],
            [625449600000, 248238011],
            [625536000000, 248579042],
            [625622400000, 248839030],
            [625708800000, 248915507],
            [625795200000, 248987508],
            [625881600000, 249078923],
            [625968000000, 249177498],
            [626054400000, 249388468],
            [626140800000, 249747560],
            [626227200000, 250003913],
            [626313600000, 250055988],
            [626400000000, 250107463],
            [626486400000, 250154355],
            [626572800000, 250209818],
            [626659200000, 250357458],
            [626745600000, 250583371],
            [626832000000, 250713403],
            [626918400000, 250741823],
            [627004800000, 250769329],
            [627091200000, 250795030],
            [627177600000, 250820573],
            [627264000000, 250864195],
            [627350400000, 250948314],
            [627436800000, 250994366],
            [627523200000, 251005893],
            [627609600000, 251019322],
            [627696000000, 251033893],
            [627782400000, 251057886],
            [627868800000, 251078254],
            [627955200000, 251095680],
            [628041600000, 251108315],
            [628128000000, 251113922],
            [628214400000, 251119620],
            [628300800000, 251125125],
            [628387200000, 251130554],
            [628473600000, 251140828],
            [628560000000, 251155245],
            [628646400000, 251161818],
            [628732800000, 251164550],
            [628819200000, 251167758],
            [628905600000, 251170718],
            [628992000000, 251174274],
            [629078400000, 251176896],
            [629164800000, 251181990],
            [629251200000, 251185407],
            [629337600000, 251186329],
            [629424000000, 251187074],
            [629510400000, 251187883],
            [629596800000, 251188924]
        ],
        name: 'batman',
        showInLegend: false,
        extra: {
            title: 'Batman',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#443230'
        },
        showlabel: false,
        color: 'rgba(68,50,48,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1166745600000, 12134015
            ],
            [1166832000000, 24725279],
            [1166918400000, 30433781],
            [1167004800000, 42212651],
            [1167091200000, 55718681],
            [1167177600000, 67661033],
            [1167264000000, 79055249],
            [1167350400000, 92598820],
            [1167436800000, 106337184],
            [1167523200000, 115822154],
            [1167609600000, 127286780],
            [1167696000000, 133001248],
            [1167782400000, 136688682],
            [1167868800000, 140096754],
            [1167955200000, 147203393],
            [1168041600000, 157688762],
            [1168128000000, 163840714],
            [1168214400000, 165150384],
            [1168300800000, 166378984],
            [1168387200000, 167501274],
            [1168473600000, 168655751],
            [1168560000000, 172825236],
            [1168646400000, 180268462],
            [1168732800000, 185818108],
            [1168819200000, 190503618],
            [1168905600000, 191329744],
            [1168992000000, 192094485],
            [1169078400000, 192839932],
            [1169164800000, 195937844],
            [1169251200000, 202038665],
            [1169337600000, 204852656],
            [1169424000000, 205520102],
            [1169510400000, 206107721],
            [1169596800000, 206671090],
            [1169683200000, 207287959],
            [1169769600000, 209554781],
            [1169856000000, 214131702],
            [1169942400000, 216845623],
            [1170028800000, 217312990],
            [1170115200000, 217742977],
            [1170201600000, 218173474],
            [1170288000000, 218615492],
            [1170374400000, 220302288],
            [1170460800000, 223740931],
            [1170547200000, 225001335],
            [1170633600000, 225390476],
            [1170720000000, 225751033],
            [1170806400000, 226072308],
            [1170892800000, 226395996],
            [1170979200000, 227670831],
            [1171065600000, 230495979],
            [1171152000000, 232150355],
            [1171238400000, 232477280],
            [1171324800000, 232713817],
            [1171411200000, 233295750],
            [1171497600000, 233633598],
            [1171584000000, 234476484],
            [1171670400000, 236089415],
            [1171756800000, 237338322],
            [1171843200000, 238500531],
            [1171929600000, 238837286],
            [1172016000000, 239140913],
            [1172102400000, 239470145],
            [1172188800000, 240038934],
            [1172275200000, 241061944],
            [1172361600000, 241640806],
            [1172448000000, 241757025],
            [1172534400000, 241856549],
            [1172620800000, 241957171],
            [1172707200000, 242073469],
            [1172793600000, 242384866],
            [1172880000000, 243097731],
            [1172966400000, 243529237],
            [1173052800000, 243607567],
            [1173139200000, 243682040],
            [1173225600000, 243760687],
            [1173312000000, 243844088],
            [1173398400000, 244074782],
            [1173484800000, 244518338],
            [1173571200000, 244766562],
            [1173657600000, 244875110],
            [1173744000000, 244996357],
            [1173830400000, 245115387],
            [1173916800000, 245252338],
            [1174003200000, 245498781],
            [1174089600000, 245870663],
            [1174176000000, 246092265],
            [1174262400000, 246157847],
            [1174348800000, 246224312],
            [1174435200000, 246290339],
            [1174521600000, 246362856],
            [1174608000000, 246523283],
            [1174694400000, 246790169],
            [1174780800000, 246926396],
            [1174867200000, 246968742],
            [1174953600000, 247015354],
            [1175040000000, 247065177],
            [1175126400000, 247115718],
            [1175212800000, 247290719],
            [1175299200000, 247562220],
            [1175385600000, 247718328],
            [1175472000000, 247769516],
            [1175558400000, 247835724],
            [1175644800000, 247905074],
            [1175731200000, 247992161],
            [1175817600000, 248198243],
            [1175904000000, 248425574],
            [1175990400000, 248532584],
            [1176076800000, 248610582],
            [1176163200000, 248674017],
            [1176249600000, 248738401],
            [1176336000000, 248803583],
            [1176422400000, 248947843],
            [1176508800000, 249192187],
            [1176595200000, 249326139],
            [1176681600000, 249360710],
            [1176768000000, 249400612],
            [1176854400000, 249440648],
            [1176940800000, 249478795],
            [1177027200000, 249589580],
            [1177113600000, 249775113],
            [1177200000000, 249869448],
            [1177286400000, 249887037],
            [1177372800000, 249907861],
            [1177459200000, 249927806],
            [1177545600000, 249949828],
            [1177632000000, 250027721],
            [1177718400000, 250150816],
            [1177804800000, 250210624],
            [1177891200000, 250224440],
            [1177977600000, 250239052],
            [1178064000000, 250253311],
            [1178150400000, 250268315],
            [1178236800000, 250321058],
            [1178323200000, 250401645],
            [1178409600000, 250447698],
            [1178496000000, 250457011],
            [1178582400000, 250467433],
            [1178668800000, 250477416],
            [1178755200000, 250487485],
            [1178841600000, 250519463],
            [1178928000000, 250570620],
            [1179014400000, 250603633],
            [1179100800000, 250611850],
            [1179187200000, 250621377],
            [1179273600000, 250630462],
            [1179360000000, 250639976],
            [1179446400000, 250661854],
            [1179532800000, 250697035],
            [1179619200000, 250714157],
            [1179705600000, 250719528],
            [1179792000000, 250723987],
            [1179878400000, 250728235],
            [1179964800000, 250733126],
            [1180051200000, 250742899],
            [1180137600000, 250757445],
            [1180224000000, 250770411],
            [1180310400000, 250781332],
            [1180396800000, 250784661],
            [1180483200000, 250788378],
            [1180569600000, 250792287],
            [1180656000000, 250800093],
            [1180742400000, 250809145],
            [1180828800000, 250815386],
            [1180915200000, 250817625],
            [1181001600000, 250820109],
            [1181088000000, 250822780],
            [1181174400000, 250826886],
            [1181260800000, 250830715],
            [1181347200000, 250836077],
            [1181433600000, 250839624],
            [1181520000000, 250840981],
            [1181606400000, 250842662],
            [1181692800000, 250845069],
            [1181779200000, 250847073],
            [1181865600000, 250849175],
            [1181952000000, 250852372],
            [1182038400000, 250854474],
            [1182124800000, 250855423],
            [1182211200000, 250856998],
            [1182297600000, 250858920],
            [1182384000000, 250860439]
        ],
        name: 'nightatthemuseum',
        showInLegend: false,
        extra: {
            title: 'Night at the Museum',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#56402B'
        },
        showlabel: false,
        color: 'rgba(86,64,43,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                867715200000, 4815427
            ],
            [867801600000, 18858737],
            [867888000000, 33065445],
            [867974400000, 48787760],
            [868060800000, 69007897],
            [868147200000, 84133900],
            [868233600000, 91567160],
            [868320000000, 98402686],
            [868406400000, 104419095],
            [868492800000, 109522653],
            [868579200000, 118777580],
            [868665600000, 130966320],
            [868752000000, 139584970],
            [868838400000, 143095712],
            [868924800000, 146904238],
            [869011200000, 150061026],
            [869097600000, 153115865],
            [869184000000, 158895927],
            [869270400000, 166800161],
            [869356800000, 172145793],
            [869443200000, 174553076],
            [869529600000, 177159454],
            [869616000000, 179373063],
            [869702400000, 181685906],
            [869788800000, 185403700],
            [869875200000, 190406364],
            [869961600000, 194036790],
            [870048000000, 195560875],
            [870134400000, 197232178],
            [870220800000, 198673993],
            [870307200000, 200111208],
            [870393600000, 202428826],
            [870480000000, 205730809],
            [870566400000, 208122305],
            [870652800000, 209249069],
            [870739200000, 210427501],
            [870825600000, 211413781],
            [870912000000, 212352590],
            [870998400000, 213956298],
            [871084800000, 216339248],
            [871171200000, 218004940],
            [871257600000, 218747817],
            [871344000000, 219579659],
            [871430400000, 220387413],
            [871516800000, 221100224],
            [871603200000, 222300852],
            [871689600000, 224064003],
            [871776000000, 225304729],
            [871862400000, 225839914],
            [871948800000, 226424799],
            [872035200000, 227019477],
            [872121600000, 227621456],
            [872208000000, 228466724],
            [872294400000, 229688643],
            [872380800000, 230502569],
            [872467200000, 230807455],
            [872553600000, 231125727],
            [872640000000, 231394304],
            [872726400000, 231702119],
            [872812800000, 232333072],
            [872899200000, 233365630],
            [872985600000, 234281015],
            [873072000000, 235057188],
            [873158400000, 235228429],
            [873244800000, 235373096],
            [873331200000, 235507984],
            [873417600000, 235974523],
            [873504000000, 236846705],
            [873590400000, 237311281],
            [873676800000, 237417733],
            [873763200000, 237542822],
            [873849600000, 237657874],
            [873936000000, 237776607],
            [874022400000, 238178803],
            [874108800000, 238966653],
            [874195200000, 239354920],
            [874281600000, 239440657],
            [874368000000, 239546588],
            [874454400000, 239636919],
            [874540800000, 239734400],
            [874627200000, 240038488],
            [874713600000, 240642676],
            [874800000000, 240942775],
            [874886400000, 241007297],
            [874972800000, 241081099],
            [875059200000, 241144423],
            [875145600000, 241210546],
            [875232000000, 241431280],
            [875318400000, 241881303],
            [875404800000, 242117436],
            [875491200000, 242166074],
            [875577600000, 242218193],
            [875664000000, 242265944],
            [875750400000, 242330085],
            [875836800000, 242508832],
            [875923200000, 242847148],
            [876009600000, 243017806],
            [876096000000, 243055621],
            [876182400000, 243097872],
            [876268800000, 243135495],
            [876355200000, 243186036],
            [876441600000, 243304258],
            [876528000000, 243504763],
            [876614400000, 243629478],
            [876700800000, 243680717],
            [876787200000, 243707987],
            [876873600000, 243734192],
            [876960000000, 243762835],
            [877046400000, 243839062],
            [877132800000, 243981932],
            [877219200000, 244064365],
            [877305600000, 244081091],
            [877392000000, 244100348],
            [877478400000, 244117556],
            [877564800000, 244136451],
            [877651200000, 244188278],
            [877737600000, 244282110],
            [877824000000, 244337321],
            [877910400000, 244350803],
            [877996800000, 244366225],
            [878083200000, 244380014],
            [878169600000, 244391696],
            [878256000000, 244521142],
            [878342400000, 244841133],
            [878428800000, 245012779],
            [878515200000, 245047541],
            [878601600000, 245089930],
            [878688000000, 245126067],
            [878774400000, 245167104],
            [878860800000, 245238708],
            [878947200000, 245352883],
            [879033600000, 245419734],
            [879120000000, 245446939],
            [879206400000, 245487480],
            [879292800000, 245512342],
            [879379200000, 245541878],
            [879465600000, 246377098],
            [879552000000, 247234036],
            [879638400000, 247659078],
            [879724800000, 247704431],
            [879811200000, 247756318],
            [879897600000, 247804105],
            [879984000000, 247850171],
            [880070400000, 248003058],
            [880156800000, 248254400],
            [880243200000, 248408779],
            [880329600000, 248429204],
            [880416000000, 248456351],
            [880502400000, 248501226],
            [880588800000, 248553908]
        ],
        name: 'meninblack',
        showInLegend: false,
        extra: {
            title: 'Men in Black',
            genre: 'Sci-Fi Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#394450'
        },
        showlabel: false,
        color: 'rgba(57,68,80,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1086307200000, 38268295
            ],
            [1086393600000, 69762162],
            [1086480000000, 93687367],
            [1086566400000, 102115798],
            [1086652800000, 109363094],
            [1086739200000, 116241576],
            [1086825600000, 123064649],
            [1086912000000, 134405065],
            [1086998400000, 147946953],
            [1087084800000, 157975042],
            [1087171200000, 161963462],
            [1087257600000, 165705930],
            [1087344000000, 169329428],
            [1087430400000, 172897787],
            [1087516800000, 178198989],
            [1087603200000, 185308202],
            [1087689600000, 190925253],
            [1087776000000, 193290508],
            [1087862400000, 195896665],
            [1087948800000, 198051737],
            [1088035200000, 200290136],
            [1088121600000, 203699214],
            [1088208000000, 208167392],
            [1088294400000, 211537548],
            [1088380800000, 213113702],
            [1088467200000, 214672927],
            [1088553600000, 215877149],
            [1088640000000, 217178539],
            [1088726400000, 219094839],
            [1088812800000, 221402205],
            [1088899200000, 223117013],
            [1088985600000, 225719716],
            [1089072000000, 226805163],
            [1089158400000, 227755902],
            [1089244800000, 228743375],
            [1089331200000, 229900678],
            [1089417600000, 231478906],
            [1089504000000, 232795692],
            [1089590400000, 233483882],
            [1089676800000, 234205100],
            [1089763200000, 234911432],
            [1089849600000, 235586634],
            [1089936000000, 236318852],
            [1090022400000, 237361841],
            [1090108800000, 238344679],
            [1090195200000, 238786174],
            [1090281600000, 239234461],
            [1090368000000, 239661642],
            [1090454400000, 240092901],
            [1090540800000, 240538477],
            [1090627200000, 241216997],
            [1090713600000, 241770359],
            [1090800000000, 242025848],
            [1090886400000, 242349326],
            [1090972800000, 242663627],
            [1091059200000, 242921093],
            [1091145600000, 243162196],
            [1091232000000, 243549316],
            [1091318400000, 243910542],
            [1091404800000, 244080766],
            [1091491200000, 244252784],
            [1091577600000, 244426276],
            [1091664000000, 244603966],
            [1091750400000, 244797610],
            [1091836800000, 245085524],
            [1091923200000, 245332214],
            [1092009600000, 245446688],
            [1092096000000, 245569094],
            [1092182400000, 245681479],
            [1092268800000, 245792785],
            [1092355200000, 245921402],
            [1092441600000, 246093513],
            [1092528000000, 246244214],
            [1092614400000, 246317636],
            [1092700800000, 246392718],
            [1092787200000, 246468133],
            [1092873600000, 246547311],
            [1092960000000, 246632102],
            [1093046400000, 246789016],
            [1093132800000, 246900818],
            [1093219200000, 246955792],
            [1093305600000, 247010832],
            [1093392000000, 247062263],
            [1093478400000, 247112921],
            [1093564800000, 247234454],
            [1093651200000, 247434941],
            [1093737600000, 247598604],
            [1093824000000, 247650996],
            [1093910400000, 247700608],
            [1093996800000, 247740632],
            [1094083200000, 247782190],
            [1094169600000, 247869353],
            [1094256000000, 248031901],
            [1094342400000, 248195631],
            [1094428800000, 248344516],
            [1094515200000, 248369189],
            [1094601600000, 248392636],
            [1094688000000, 248415371],
            [1094774400000, 248456927],
            [1094860800000, 248546225],
            [1094947200000, 248619248],
            [1095033600000, 248634726],
            [1095120000000, 248649538],
            [1095206400000, 248665224],
            [1095292800000, 248684766],
            [1095379200000, 248720678],
            [1095465600000, 248800909],
            [1095552000000, 248854854],
            [1095638400000, 248865262],
            [1095724800000, 248875135],
            [1095811200000, 248884815],
            [1095897600000, 248894017],
            [1095984000000, 248925464],
            [1096070400000, 248989000],
            [1096156800000, 249031885],
            [1096243200000, 249041275],
            [1096329600000, 249051304],
            [1096416000000, 249060243],
            [1096502400000, 249069395],
            [1096588800000, 249084058],
            [1096675200000, 249114626],
            [1096761600000, 249133782],
            [1096848000000, 249138342],
            [1096934400000, 249142630],
            [1097020800000, 249146454],
            [1097107200000, 249151025],
            [1097193600000, 249160821],
            [1097280000000, 249180185],
            [1097366400000, 249194525],
            [1097452800000, 249204304],
            [1097539200000, 249207444],
            [1097625600000, 249210154],
            [1097712000000, 249214277],
            [1097798400000, 249226056],
            [1097884800000, 249249738],
            [1097971200000, 249266986],
            [1098057600000, 249268668],
            [1098144000000, 249270174],
            [1098230400000, 249271215],
            [1098316800000, 249276315],
            [1098403200000, 249288131],
            [1098489600000, 249306297],
            [1098576000000, 249319248],
            [1098662400000, 249320822],
            [1098748800000, 249323740],
            [1098835200000, 249325388],
            [1098921600000, 249327065],
            [1099008000000, 249334513],
            [1099094400000, 249353324],
            [1099180800000, 249358727],
            [1099267200000, 249360363],
            [1099353600000, 249364217],
            [1099440000000, 249365686],
            [1099526400000, 249367187]
        ],
        name: 'harrypotter3',
        showInLegend: false,
        extra: {
            title: 'Harry Potter and the Prisoner of Azkaban',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#2D3135'
        },
        showlabel: false,
        color: 'rgba(45,49,53,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                942969600000, 88664
            ],
            [943056000000, 199380],
            [943142400000, 300163],
            [943228800000, 343916],
            [943315200000, 379178],
            [943401600000, 9950089],
            [943488000000, 23093123],
            [943574400000, 45699525],
            [943660800000, 67050146],
            [943747200000, 80481962],
            [943833600000, 82993048],
            [943920000000, 85197080],
            [944006400000, 87148543],
            [944092800000, 89021116],
            [944179200000, 95525842],
            [944265600000, 108321659],
            [944352000000, 116781392],
            [944438400000, 118123483],
            [944524800000, 119535125],
            [944611200000, 120841199],
            [944697600000, 122100485],
            [944784000000, 126237304],
            [944870400000, 134775677],
            [944956800000, 140350365],
            [945043200000, 141263667],
            [945129600000, 142230779],
            [945216000000, 143191494],
            [945302400000, 144224888],
            [945388800000, 147051825],
            [945475200000, 152373559],
            [945561600000, 156354721],
            [945648000000, 158521094],
            [945734400000, 161041131],
            [945820800000, 163710476],
            [945907200000, 167168645],
            [945993600000, 169647906],
            [946080000000, 172766853],
            [946166400000, 177545321],
            [946252800000, 182308299],
            [946339200000, 187131374],
            [946425600000, 191763200],
            [946512000000, 196426718],
            [946598400000, 199843054],
            [946684800000, 204817418],
            [946771200000, 208851257],
            [946857600000, 210309895],
            [946944000000, 211215635],
            [947030400000, 211898419],
            [947116800000, 212552266],
            [947203200000, 214192465],
            [947289600000, 217534413],
            [947376000000, 219705755],
            [947462400000, 220029284],
            [947548800000, 220374251],
            [947635200000, 220667091],
            [947721600000, 220983916],
            [947808000000, 222031589],
            [947894400000, 224299813],
            [947980800000, 226056757],
            [948067200000, 227615332],
            [948153600000, 227878302],
            [948240000000, 228069480],
            [948326400000, 228280286],
            [948412800000, 228877884],
            [948499200000, 230318305],
            [948585600000, 231228567],
            [948672000000, 231437021],
            [948758400000, 231599308],
            [948844800000, 231779219],
            [948931200000, 231960062],
            [949017600000, 232477411],
            [949104000000, 233698632],
            [949190400000, 234301509],
            [949276800000, 234480631],
            [949363200000, 234615150],
            [949449600000, 234736050],
            [949536000000, 234858442],
            [949622400000, 235284943],
            [949708800000, 236376415],
            [949795200000, 237113435],
            [949881600000, 237230280],
            [949968000000, 237339147],
            [950054400000, 237435990],
            [950140800000, 237537630],
            [950227200000, 237724790],
            [950313600000, 238272397],
            [950400000000, 238691281],
            [950486400000, 238803523],
            [950572800000, 238863496],
            [950659200000, 238922600],
            [950745600000, 238988596],
            [950832000000, 239077587],
            [950918400000, 239376751],
            [951004800000, 239664408],
            [951091200000, 239930711],
            [951177600000, 239999442],
            [951264000000, 240058951],
            [951350400000, 240122940],
            [951436800000, 240217051],
            [951523200000, 240445395],
            [951609600000, 240627332],
            [951696000000, 240659292],
            [951782400000, 240686299],
            [951868800000, 240710925],
            [951955200000, 240740912],
            [952041600000, 240785787],
            [952128000000, 240909405],
            [952214400000, 241003665],
            [952300800000, 241023747],
            [952387200000, 241043046],
            [952473600000, 241060544],
            [952560000000, 241081469],
            [952646400000, 241132808],
            [952732800000, 241260602],
            [952819200000, 241357162],
            [952905600000, 241403406],
            [952992000000, 241457042],
            [953078400000, 241511019],
            [953164800000, 241569717],
            [953251200000, 241650872],
            [953337600000, 241780045],
            [953424000000, 241878319],
            [953510400000, 241905179],
            [953596800000, 241940135],
            [953683200000, 241970793],
            [953769600000, 242002443],
            [953856000000, 242058650],
            [953942400000, 242154217],
            [954028800000, 242221297],
            [954115200000, 242249259],
            [954201600000, 242280158],
            [954288000000, 242309832],
            [954374400000, 242345699],
            [954460800000, 242409803],
            [954547200000, 242515212],
            [954633600000, 242602418],
            [954720000000, 242630411],
            [954806400000, 242662983],
            [954892800000, 242690491],
            [954979200000, 242721397],
            [955065600000, 242782639],
            [955152000000, 242884683],
            [955238400000, 242947795]
        ],
        name: 'toystory2',
        showInLegend: false,
        extra: {
            title: 'Toy Story 2',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#B3695E'
        },
        showlabel: false,
        color: 'rgba(179,105,94,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1403827200000, 41868135
            ],
            [1403913600000, 74302843],
            [1404000000000, 100038390],
            [1404086400000, 110542664],
            [1404172800000, 120953107],
            [1404259200000, 128685351],
            [1404345600000, 138345769],
            [1404432000000, 148965438],
            [1404518400000, 163770694],
            [1404604800000, 175395954],
            [1404691200000, 180166140],
            [1404777600000, 185396529],
            [1404864000000, 189081100],
            [1404950400000, 192531298],
            [1405036800000, 197451453],
            [1405123200000, 204108469],
            [1405209600000, 208833713],
            [1405296000000, 210850231],
            [1405382400000, 213444938],
            [1405468800000, 215395566],
            [1405555200000, 217156888],
            [1405641600000, 219950118],
            [1405728000000, 224036972],
            [1405814400000, 227002608],
            [1405900800000, 228174874],
            [1405987200000, 229616681],
            [1406073600000, 230802453],
            [1406160000000, 231752475],
            [1406246400000, 233075005],
            [1406332800000, 234961717],
            [1406419200000, 236455028],
            [1406505600000, 237124208],
            [1406592000000, 237875634],
            [1406678400000, 238460789],
            [1406764800000, 238965915],
            [1406851200000, 239584651],
            [1406937600000, 240510342],
            [1407024000000, 241206987],
            [1407110400000, 241526510],
            [1407196800000, 241868334],
            [1407283200000, 242124910],
            [1407369600000, 242303575],
            [1407456000000, 242467792],
            [1407542400000, 242716613],
            [1407628800000, 242880031],
            [1407715200000, 242950166],
            [1407801600000, 243030978],
            [1407888000000, 243089383],
            [1407974400000, 243136930],
            [1408060800000, 243191397],
            [1408147200000, 243279167],
            [1408233600000, 243342459],
            [1408320000000, 243364809],
            [1408406400000, 243392711],
            [1408492800000, 243416587],
            [1408579200000, 243439603],
            [1408665600000, 243537270],
            [1408752000000, 243705649],
            [1408838400000, 243822062],
            [1408924800000, 243853989],
            [1409011200000, 243890199],
            [1409097600000, 243919647],
            [1409184000000, 243950966],
            [1409270400000, 244030996],
            [1409356800000, 244177536],
            [1409443200000, 244327641],
            [1409529600000, 244435833],
            [1409616000000, 244459861],
            [1409702400000, 244480845],
            [1409788800000, 244498662],
            [1409875200000, 244554688],
            [1409961600000, 244667709],
            [1410048000000, 244736069],
            [1410134400000, 244750740],
            [1410220800000, 244769458],
            [1410307200000, 244785672],
            [1410393600000, 244803687],
            [1410480000000, 244873705],
            [1410566400000, 244994086],
            [1410652800000, 245064448],
            [1410739200000, 245087189],
            [1410825600000, 245112671],
            [1410912000000, 245135728],
            [1410998400000, 245151963],
            [1411084800000, 245176672],
            [1411171200000, 245227452],
            [1411257600000, 245259125],
            [1411344000000, 245265231],
            [1411430400000, 245272736],
            [1411516800000, 245280051],
            [1411603200000, 245288377],
            [1411689600000, 245307008],
            [1411776000000, 245346609],
            [1411862400000, 245370666],
            [1411948800000, 245376669],
            [1412035200000, 245382033],
            [1412121600000, 245386935],
            [1412208000000, 245392023],
            [1412294400000, 245400833],
            [1412380800000, 245418060],
            [1412467200000, 245428211],
            [1412553600000, 245430672],
            [1412640000000, 245433244],
            [1412726400000, 245436073],
            [1412812800000, 245439076]
        ],
        name: 'transformers4',
        showInLegend: false,
        extra: {
            title: 'Transformers: Age of Extinction',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#67645E'
        },
        showlabel: false,
        color: 'rgba(103,100,94,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1149811200000, 19713746
            ],
            [1149897600000, 42994673],
            [1149984000000, 60119509],
            [1150070400000, 66527416],
            [1150156800000, 72270878],
            [1150243200000, 78008209],
            [1150329600000, 83323649],
            [1150416000000, 92529465],
            [1150502400000, 105444420],
            [1150588800000, 117055283],
            [1150675200000, 121115860],
            [1150761600000, 125128007],
            [1150848000000, 129228871],
            [1150934400000, 133379549],
            [1151020800000, 139812147],
            [1151107200000, 149134116],
            [1151193600000, 156664916],
            [1151280000000, 159768282],
            [1151366400000, 162710312],
            [1151452800000, 165365996],
            [1151539200000, 168021783],
            [1151625600000, 172086819],
            [1151712000000, 177297509],
            [1151798400000, 182591139],
            [1151884800000, 186947868],
            [1151971200000, 190506108],
            [1152057600000, 192908800],
            [1152144000000, 195174402],
            [1152230400000, 198641776],
            [1152316800000, 202923427],
            [1152403200000, 205908484],
            [1152489600000, 207315250],
            [1152576000000, 208918481],
            [1152662400000, 210595357],
            [1152748800000, 212160461],
            [1152835200000, 214448236],
            [1152921600000, 217771323],
            [1153008000000, 220001446],
            [1153094400000, 221090490],
            [1153180800000, 222273736],
            [1153267200000, 223359127],
            [1153353600000, 224538438],
            [1153440000000, 225899304],
            [1153526400000, 228074393],
            [1153612800000, 229485636],
            [1153699200000, 230127742],
            [1153785600000, 230821008],
            [1153872000000, 231480230],
            [1153958400000, 232181886],
            [1154044800000, 232909712],
            [1154131200000, 234003915],
            [1154217600000, 234802642],
            [1154304000000, 235163554],
            [1154390400000, 235589472],
            [1154476800000, 236033142],
            [1154563200000, 236432622],
            [1154649600000, 236742105],
            [1154736000000, 237197696],
            [1154822400000, 237517306],
            [1154908800000, 237701801],
            [1154995200000, 237880818],
            [1155081600000, 238037860],
            [1155168000000, 238220320],
            [1155254400000, 238397830],
            [1155340800000, 238660946],
            [1155427200000, 238841296],
            [1155513600000, 238924816],
            [1155600000000, 239014683],
            [1155686400000, 239096604],
            [1155772800000, 239179271],
            [1155859200000, 239288699],
            [1155945600000, 239475391],
            [1156032000000, 239618177],
            [1156118400000, 239668952],
            [1156204800000, 239720251],
            [1156291200000, 239769512],
            [1156377600000, 239821060],
            [1156464000000, 240009001],
            [1156550400000, 240322061],
            [1156636800000, 240555222],
            [1156723200000, 240637758],
            [1156809600000, 240736043],
            [1156896000000, 240820161],
            [1156982400000, 240894281],
            [1157068800000, 241088455],
            [1157155200000, 241426455],
            [1157241600000, 241743295],
            [1157328000000, 241979000],
            [1157414400000, 242036844],
            [1157500800000, 242087945],
            [1157587200000, 242140418]
        ],
        name: 'cars',
        showInLegend: false,
        extra: {
            title: 'Cars',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#835C4F'
        },
        showlabel: false,
        color: 'rgba(131,92,79,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1053648000000, 20114325
            ],
            [1053734400000, 45540225],
            [1053820800000, 67953330],
            [1053907200000, 85734045],
            [1053993600000, 90871470],
            [1054080000000, 95556105],
            [1054166400000, 100066590],
            [1054252800000, 111118770],
            [1054339200000, 126989910],
            [1054425600000, 137396070],
            [1054512000000, 140294430],
            [1054598400000, 143472150],
            [1054684800000, 146300670],
            [1054771200000, 149076810],
            [1054857600000, 155784420],
            [1054944000000, 165473190],
            [1055030400000, 171435525],
            [1055116800000, 173405220],
            [1055203200000, 175516875],
            [1055289600000, 177468825],
            [1055376000000, 179579820],
            [1055462400000, 184012995],
            [1055548800000, 189889125],
            [1055635200000, 193818135],
            [1055721600000, 195434940],
            [1055808000000, 197208210],
            [1055894400000, 198964095],
            [1055980800000, 200736650],
            [1056067200000, 203872130],
            [1056153600000, 207883700],
            [1056240000000, 210542710],
            [1056326400000, 211664720],
            [1056412800000, 212848210],
            [1056499200000, 213986960],
            [1056585600000, 215139710],
            [1056672000000, 217021920],
            [1056758400000, 219580135],
            [1056844800000, 221329795],
            [1056931200000, 222244390],
            [1057017600000, 223119220],
            [1057104000000, 223805080],
            [1057190400000, 224634250],
            [1057276800000, 225627685],
            [1057363200000, 227460235],
            [1057449600000, 228646570],
            [1057536000000, 229234915],
            [1057622400000, 229853140],
            [1057708800000, 230330165],
            [1057795200000, 230816030],
            [1057881600000, 231594835],
            [1057968000000, 232573700],
            [1058054400000, 233195315],
            [1058140800000, 233516840],
            [1058227200000, 233859800],
            [1058313600000, 234195615],
            [1058400000000, 234517140],
            [1058486400000, 234975275],
            [1058572800000, 235557935],
            [1058659200000, 235941390],
            [1058745600000, 236150550],
            [1058832000000, 236379535],
            [1058918400000, 236603530],
            [1059004800000, 236812480],
            [1059091200000, 237036445],
            [1059177600000, 237332300],
            [1059264000000, 237531380],
            [1059350400000, 237630920],
            [1059436800000, 237733225],
            [1059523200000, 237832850],
            [1059609600000, 237937920],
            [1059696000000, 238123305],
            [1059782400000, 238367265],
            [1059868800000, 238542825],
            [1059955200000, 238643270],
            [1060041600000, 238743590],
            [1060128000000, 238818830],
            [1060214400000, 238898655],
            [1060300800000, 239021475],
            [1060387200000, 239187790],
            [1060473600000, 239308750],
            [1060560000000, 239371050],
            [1060646400000, 239435310],
            [1060732800000, 239484450],
            [1060819200000, 239529810],
            [1060905600000, 239628515],
            [1060992000000, 239768340],
            [1061078400000, 239855525],
            [1061164800000, 239901585],
            [1061251200000, 239950935],
            [1061337600000, 239995350],
            [1061424000000, 240036475],
            [1061510400000, 240131095],
            [1061596800000, 240267215],
            [1061683200000, 240356850],
            [1061769600000, 240399945],
            [1061856000000, 240444765],
            [1061942400000, 240484605],
            [1062028800000, 240517790],
            [1062115200000, 240605935],
            [1062201600000, 240734540],
            [1062288000000, 240863285],
            [1062374400000, 240964435],
            [1062460800000, 240996225],
            [1062547200000, 241022235],
            [1062633600000, 241046800],
            [1062720000000, 241127740],
            [1062806400000, 241249860],
            [1062892800000, 241326540],
            [1062979200000, 241346405],
            [1063065600000, 241369125],
            [1063152000000, 241390420],
            [1063238400000, 241411655],
            [1063324800000, 241487240],
            [1063411200000, 241611980],
            [1063497600000, 241686320],
            [1063584000000, 241705205],
            [1063670400000, 241726625],
            [1063756800000, 241745550],
            [1063843200000, 241763190],
            [1063929600000, 241822815],
            [1064016000000, 241920690],
            [1064102400000, 241976935],
            [1064188800000, 241991560],
            [1064275200000, 242007310],
            [1064361600000, 242021905],
            [1064448000000, 242035410],
            [1064534400000, 242080290],
            [1064620800000, 242160870],
            [1064707200000, 242202690],
            [1064793600000, 242214930],
            [1064880000000, 242228190],
            [1064966400000, 242239410],
            [1065052800000, 242251635],
            [1065139200000, 242287305],
            [1065225600000, 242344725],
            [1065312000000, 242375175],
            [1065398400000, 242384745],
            [1065484800000, 242395185],
            [1065571200000, 242403910],
            [1065657600000, 242412560],
            [1065744000000, 242436500],
            [1065830400000, 242473040],
            [1065916800000, 242495090],
            [1066003200000, 242505800],
            [1066089600000, 242513360],
            [1066176000000, 242520290],
            [1066262400000, 242527245],
            [1066348800000, 242546810],
            [1066435200000, 242574565],
            [1066521600000, 242589580],
            [1066608000000, 242595495],
            [1066694400000, 242602320],
            [1066780800000, 242608215],
            [1066867200000, 242614125]
        ],
        name: 'brucealmighty',
        showInLegend: false,
        extra: {
            title: 'Bruce Almighty',
            genre: 'Fantasy Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#717890'
        },
        showlabel: false,
        color: 'rgba(113,120,144,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                455500800000, 3891105
            ],
            [455587200000, 9104982],
            [455673600000, 13578151],
            [455760000000, 15969918],
            [455846400000, 18123415],
            [455932800000, 20620623],
            [456019200000, 23167337],
            [456105600000, 27506208],
            [456192000000, 33141380],
            [456278400000, 38261242],
            [456364800000, 40999420],
            [456451200000, 43585999],
            [456537600000, 46034542],
            [456624000000, 48421923],
            [456710400000, 52181232],
            [456796800000, 57136207],
            [456883200000, 61481351],
            [456969600000, 63444355],
            [457056000000, 65534215],
            [457142400000, 67515708],
            [457228800000, 69487919],
            [457315200000, 72625998],
            [457401600000, 77104771],
            [457488000000, 80636536],
            [457574400000, 82307748],
            [457660800000, 84530794],
            [457747200000, 86629655],
            [457833600000, 88515111],
            [457920000000, 91926083],
            [458006400000, 96489141],
            [458092800000, 99651245],
            [458179200000, 101172407],
            [458265600000, 102749416],
            [458352000000, 104358080],
            [458438400000, 105874118],
            [458524800000, 108665055],
            [458611200000, 112617760],
            [458697600000, 115635510],
            [458784000000, 117145101],
            [458870400000, 118707630],
            [458956800000, 120321280],
            [459043200000, 121641283],
            [459129600000, 123985055],
            [459216000000, 127669233],
            [459302400000, 130135144],
            [459388800000, 131319971],
            [459475200000, 132647295],
            [459561600000, 133850753],
            [459648000000, 135006673],
            [459734400000, 137342932],
            [459820800000, 140392094],
            [459907200000, 142440431],
            [459993600000, 143457228],
            [460080000000, 144516590],
            [460166400000, 145511986],
            [460252800000, 146541621],
            [460339200000, 148331060],
            [460425600000, 150985582],
            [460512000000, 152985267],
            [460598400000, 153922142],
            [460684800000, 154947184],
            [460771200000, 155861874],
            [460857600000, 156807773],
            [460944000000, 158395393],
            [461030400000, 160824501],
            [461116800000, 162590937],
            [461203200000, 163442354],
            [461289600000, 164387376],
            [461376000000, 165255011],
            [461462400000, 166085430],
            [461548800000, 167572570],
            [461635200000, 169730950],
            [461721600000, 171491420],
            [461808000000, 172283587],
            [461894400000, 173116171],
            [461980800000, 173896427],
            [462067200000, 174698963],
            [462153600000, 176054114],
            [462240000000, 178052206],
            [462326400000, 179381173],
            [462412800000, 179944529],
            [462499200000, 180571490],
            [462585600000, 181142450],
            [462672000000, 181699276],
            [462758400000, 182846259],
            [462844800000, 184770543],
            [462931200000, 186704084],
            [463017600000, 188058969],
            [463104000000, 188469475],
            [463190400000, 188814022],
            [463276800000, 189115606],
            [463363200000, 190032740],
            [463449600000, 191739662],
            [463536000000, 192781806],
            [463622400000, 193021159],
            [463708800000, 193315984],
            [463795200000, 193571908],
            [463881600000, 193821511],
            [463968000000, 194691947],
            [464054400000, 196393290],
            [464140800000, 197279137],
            [464227200000, 197493018],
            [464313600000, 197743445],
            [464400000000, 197964138],
            [464486400000, 198185745],
            [464572800000, 198899686],
            [464659200000, 200246149],
            [464745600000, 201036554],
            [464832000000, 201204649],
            [464918400000, 201400943],
            [465004800000, 201573371],
            [465091200000, 201706630],
            [465177600000, 202284283],
            [465264000000, 203449462],
            [465350400000, 204079999],
            [465436800000, 204230397],
            [465523200000, 204409996],
            [465609600000, 204550622],
            [465696000000, 204692131],
            [465782400000, 205170600],
            [465868800000, 206089576],
            [465955200000, 206722052],
            [466041600000, 206954779],
            [466128000000, 207098447],
            [466214400000, 207214843],
            [466300800000, 207352541],
            [466387200000, 207776875],
            [466473600000, 208623382],
            [466560000000, 209096247],
            [466646400000, 209206943],
            [466732800000, 209342775],
            [466819200000, 209458846],
            [466905600000, 209559908],
            [466992000000, 209937368],
            [467078400000, 210687403],
            [467164800000, 211132507],
            [467251200000, 211239676],
            [467337600000, 211364117],
            [467424000000, 211470936],
            [467510400000, 211582788],
            [467596800000, 211848010],
            [467683200000, 212325076],
            [467769600000, 212640893],
            [467856000000, 212724360],
            [467942400000, 212814957],
            [468028800000, 212896144],
            [468115200000, 212974973],
            [468201600000, 213257063],
            [468288000000, 213835014],
            [468374400000, 214191229],
            [468460800000, 214282330],
            [468547200000, 214389579],
            [468633600000, 214461834],
            [468720000000, 214520889],
            [468806400000, 214774680],
            [468892800000, 215270676],
            [468979200000, 215627420],
            [469065600000, 215758699],
            [469152000000, 215829106],
            [469238400000, 215887695],
            [469324800000, 215950172],
            [469411200000, 216131226],
            [469497600000, 216478107],
            [469584000000, 216680652],
            [469670400000, 216727895],
            [469756800000, 216788405],
            [469843200000, 216891266],
            [469929600000, 217032144],
            [470016000000, 217400868],
            [470102400000, 217828461],
            [470188800000, 218023669],
            [470275200000, 218067497],
            [470361600000, 218120114],
            [470448000000, 218155134],
            [470534400000, 218186322],
            [470620800000, 218356000],
            [470707200000, 218688012],
            [470793600000, 218865876],
            [470880000000, 218905670],
            [470966400000, 218955539],
            [471052800000, 218985840],
            [471139200000, 219015953],
            [471225600000, 219104501],
            [471312000000, 219277991],
            [471398400000, 219376581],
            [471484800000, 219400749],
            [471571200000, 219432662],
            [471657600000, 219455739],
            [471744000000, 219478459],
            [471830400000, 219535602],
            [471916800000, 219646111],
            [472003200000, 219719235],
            [472089600000, 219737324],
            [472176000000, 219763617],
            [472262400000, 219787830],
            [472348800000, 219809118],
            [472435200000, 219871167],
            [472521600000, 219977362],
            [472608000000, 220099314],
            [472694400000, 220130195],
            [472780800000, 220178110],
            [472867200000, 220267917],
            [472953600000, 220372806],
            [473040000000, 220504989],
            [473126400000, 220671241],
            [473212800000, 220824579],
            [473299200000, 220919997],
            [473385600000, 221007660],
            [473472000000, 221041459],
            [473558400000, 221072172]
        ],
        name: 'ghostbusters',
        showInLegend: false,
        extra: {
            title: 'Ghostbusters',
            genre: 'Horror Comedy',

            mpaaRating: 'PG',
            imgMainColor: '#343836'
        },
        showlabel: false,
        color: 'rgba(52,56,54,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                833155200000, 144969158
            ]
        ],
        name: 'twister',
        showInLegend: false,
        extra: {
            title: 'Twister',
            genre: 'Action Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#564A33'
        },
        showlabel: false,
        color: 'rgba(86,74,51,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1021507200000, 4534499
            ],
            [1021593600000, 4822499],
            [1021680000000, 5330499],
            [1021766400000, 5669706],
            [1021852800000, 5763706],
            [1021939200000, 5867706],
            [1022025600000, 5970706],
            [1022112000000, 6052799],
            [1022198400000, 6343000],
            [1022284800000, 6830000],
            [1022371200000, 7300000],
            [1022457600000, 7642884],
            [1028246400000, 38014390],
            [1028332800000, 39253894],
            [1028419200000, 40172975],
            [1028505600000, 40595801],
            [1028592000000, 41013774],
            [1028678400000, 41462145],
            [1028764800000, 41930663],
            [1028851200000, 42804358],
            [1028937600000, 44093796],
            [1029024000000, 45063979],
            [1029110400000, 45533979],
            [1029196800000, 46053979],
            [1029283200000, 46593979],
            [1029369600000, 47077098],
            [1029456000000, 48666615],
            [1029542400000, 51072146],
            [1029628800000, 52777170],
            [1029715200000, 53579170],
            [1029801600000, 54602170],
            [1029888000000, 55490170],
            [1029974400000, 56428888],
            [1030060800000, 58526169],
            [1030147200000, 61724173],
            [1030233600000, 63690730],
            [1030320000000, 64543730],
            [1030406400000, 65608730],
            [1030492800000, 66639062],
            [1030579200000, 67747446],
            [1030665600000, 70425509],
            [1030752000000, 74509302],
            [1030838400000, 78848210],
            [1030924800000, 82556992],
            [1031011200000, 83576526],
            [1031097600000, 84479526],
            [1031184000000, 85452416],
            [1031270400000, 88202416],
            [1031356800000, 92587416],
            [1031443200000, 95824732],
            [1031529600000, 96609732],
            [1031616000000, 97719732],
            [1031702400000, 98649732],
            [1031788800000, 99671522],
            [1031875200000, 102721522],
            [1031961600000, 107621522],
            [1032048000000, 110443668],
            [1032134400000, 111418668],
            [1032220800000, 112488668],
            [1032307200000, 113408668],
            [1032393600000, 114304018],
            [1032480000000, 117204018],
            [1032566400000, 121754018],
            [1032652800000, 124052987],
            [1032739200000, 124737987],
            [1032825600000, 125637987],
            [1032912000000, 126387987],
            [1032998400000, 127194060],
            [1033084800000, 130179060],
            [1033171200000, 134524060],
            [1033257600000, 136628662],
            [1033344000000, 137248662],
            [1033430400000, 138068662],
            [1033516800000, 138793662],
            [1033603200000, 139494027],
            [1033689600000, 141969027],
            [1033776000000, 145944027],
            [1033862400000, 147717828],
            [1033948800000, 148277828],
            [1034035200000, 149077828],
            [1034121600000, 149772828],
            [1034208000000, 150500895],
            [1034294400000, 152815895],
            [1034380800000, 156555895],
            [1034467200000, 158954054],
            [1034553600000, 160118484],
            [1034640000000, 160838484],
            [1034726400000, 161503484],
            [1034812800000, 162147670],
            [1034899200000, 164287670],
            [1034985600000, 167717670],
            [1035072000000, 169292979],
            [1035158400000, 169767979],
            [1035244800000, 170407979],
            [1035331200000, 170932979],
            [1035417600000, 171488947],
            [1035504000000, 173388947],
            [1035590400000, 176288947],
            [1035676800000, 177698447],
            [1035763200000, 178113447],
            [1035849600000, 178668447],
            [1035936000000, 179113447],
            [1036022400000, 179621827],
            [1036108800000, 181221827],
            [1036195200000, 183921827],
            [1036281600000, 185244976],
            [1036368000000, 185619976],
            [1036454400000, 186144976],
            [1036540800000, 186549976],
            [1036627200000, 187003160],
            [1036713600000, 188603160],
            [1036800000000, 191263160],
            [1036886400000, 192857165],
            [1036972800000, 193672165],
            [1037059200000, 194102165],
            [1037145600000, 194482165],
            [1037232000000, 194860906],
            [1037318400000, 196185906],
            [1037404800000, 198385906],
            [1037491200000, 199574370],
            [1037577600000, 199852121],
            [1037664000000, 200217641],
            [1037750400000, 200512641],
            [1037836800000, 200863166],
            [1037923200000, 201938166],
            [1038009600000, 203588166],
            [1038096000000, 204520221],
            [1038182400000, 204790221],
            [1038268800000, 205178098],
            [1038528000000, 208266425],
            [1038614400000, 209886425],
            [1038700800000, 210585352],
            [1038787200000, 210745352],
            [1038873600000, 210925352],
            [1038960000000, 211085352],
            [1039046400000, 211250119],
            [1039132800000, 212085119],
            [1039219200000, 213020119],
            [1039305600000, 213263148],
            [1039392000000, 213413148],
            [1039478400000, 213588148],
            [1039564800000, 213753148],
            [1039651200000, 213936034],
            [1039996800000, 215800319],
            [1040083200000, 215980319],
            [1040169600000, 216150319],
            [1040256000000, 216304440],
            [1041811200000, 228103505],
            [1041897600000, 228346505],
            [1041984000000, 228568505],
            [1042070400000, 228774165],
            [1042156800000, 229349165],
            [1042243200000, 230349165],
            [1042329600000, 230876712],
            [1042416000000, 231051712],
            [1042502400000, 231276712],
            [1042588800000, 231471712],
            [1042675200000, 231667882],
            [1042761600000, 232242882],
            [1042848000000, 233247882],
            [1042934400000, 233841212],
            [1043020800000, 234268965],
            [1043107200000, 234438965],
            [1043193600000, 234578965],
            [1043280000000, 234744267],
            [1043366400000, 235259267],
            [1043452800000, 236154267],
            [1043539200000, 236448697],
            [1043625600000, 236577697],
            [1043712000000, 236723697],
            [1043798400000, 236859697],
            [1043884800000, 237002345],
            [1043971200000, 237402345],
            [1044057600000, 238082345],
            [1044144000000, 238540872],
            [1044230400000, 238627872],
            [1044316800000, 238742872],
            [1044403200000, 238847872],
            [1044489600000, 238948961],
            [1044576000000, 239238961],
            [1044662400000, 239708961],
            [1044748800000, 239952321],
            [1044835200000, 240010321],
            [1044921600000, 240075321],
            [1045008000000, 240148321],
            [1045094400000, 240211037],
            [1045440000000, 240742368],
            [1045526400000, 240777368],
            [1045612800000, 240807368],
            [1045699200000, 240840576]
        ],
        name: 'mybigfatgreekwedding',
        showInLegend: false,
        extra: {
            title: 'My Big Fat Greek Wedding',
            genre: 'Romantic Comedy',

            mpaaRating: 'PG',
            imgMainColor: '#979BA5'
        },
        showlabel: true,
        color: 'rgba(151,155,165,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1401408000000, 24297459
            ],
            [1401494400000, 50048100],
            [1401580800000, 69431298],
            [1401667200000, 75639040],
            [1401753600000, 82835248],
            [1401840000000, 88447851],
            [1401926400000, 93846968],
            [1402012800000, 104036838],
            [1402099200000, 117500116],
            [1402185600000, 128175232],
            [1402272000000, 132223097],
            [1402358400000, 136935682],
            [1402444800000, 140922583],
            [1402531200000, 144516532],
            [1402617600000, 150364961],
            [1402704000000, 157676482],
            [1402790400000, 163021529],
            [1402876800000, 165291458],
            [1402963200000, 168133068],
            [1403049600000, 170526582],
            [1403136000000, 172968568],
            [1403222400000, 176967689],
            [1403308800000, 182218341],
            [1403395200000, 185879334],
            [1403481600000, 187628178],
            [1403568000000, 189943593],
            [1403654400000, 191884928],
            [1403740800000, 193633390],
            [1403827200000, 196232041],
            [1403913600000, 199539534],
            [1404000000000, 202010064],
            [1404086400000, 203451550],
            [1404172800000, 205025903],
            [1404259200000, 206231009],
            [1404345600000, 207760488],
            [1404432000000, 209591932],
            [1404518400000, 212026316],
            [1404604800000, 213919664],
            [1404691200000, 214871017],
            [1404777600000, 216020353],
            [1404864000000, 216926318],
            [1404950400000, 217824808],
            [1405036800000, 219078277],
            [1405123200000, 220752008],
            [1405209600000, 222005394],
            [1405296000000, 222716901],
            [1405382400000, 223698480],
            [1405468800000, 224486306],
            [1405555200000, 225065235],
            [1405641600000, 226032147],
            [1405728000000, 227383789],
            [1405814400000, 228303448],
            [1405900800000, 228763874],
            [1405987200000, 229329691],
            [1406073600000, 229842583],
            [1406160000000, 230339184],
            [1406246400000, 230881978],
            [1406332800000, 231603529],
            [1406419200000, 232174422],
            [1406505600000, 232515544],
            [1406592000000, 232878635],
            [1406678400000, 233184622],
            [1406764800000, 233468131],
            [1406851200000, 233829099],
            [1406937600000, 234350262],
            [1407024000000, 234740473],
            [1407110400000, 234952324],
            [1407196800000, 235169264],
            [1407283200000, 235350301],
            [1407369600000, 235514974],
            [1407456000000, 235683162],
            [1407542400000, 235910267],
            [1407628800000, 236053668],
            [1407715200000, 236144566],
            [1407801600000, 236255109],
            [1407888000000, 236341107],
            [1407974400000, 236412469]
        ],
        name: 'maleficient',
        showInLegend: false,
        extra: {
            title: 'Maleficent',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#314F5C'
        },
        showlabel: false,
        color: 'rgba(49,79,92,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1305849600000, 34860549
            ],
            [1305936000000, 66782023],
            [1306022400000, 90151958],
            [1306108800000, 98295110],
            [1306195200000, 104347774],
            [1306281600000, 109053677],
            [1306368000000, 113595287],
            [1306454400000, 124522653],
            [1306540800000, 139704853],
            [1306627200000, 153424261],
            [1306713600000, 163607625],
            [1306800000000, 166774780],
            [1306886400000, 169490241],
            [1306972800000, 172246277],
            [1307059200000, 177381824],
            [1307145600000, 185027935],
            [1307232000000, 190200880],
            [1307318400000, 192058078],
            [1307404800000, 194151054],
            [1307491200000, 196004120],
            [1307577600000, 197927494],
            [1307664000000, 201075288],
            [1307750400000, 205745942],
            [1307836800000, 208873258],
            [1307923200000, 210112617],
            [1308009600000, 211523683],
            [1308096000000, 212776028],
            [1308182400000, 214100253],
            [1308268800000, 215884095],
            [1308355200000, 218349248],
            [1308441600000, 220746502],
            [1308528000000, 221590351],
            [1308614400000, 222513548],
            [1308700800000, 223405976],
            [1308787200000, 224358301],
            [1308873600000, 225993407],
            [1308960000000, 228014668],
            [1309046400000, 229287226],
            [1309132800000, 229917248],
            [1309219200000, 230564522],
            [1309305600000, 231011968],
            [1309392000000, 231547893],
            [1309478400000, 232204030],
            [1309564800000, 232992075],
            [1309651200000, 233738401],
            [1309737600000, 234176965],
            [1309824000000, 234512072],
            [1309910400000, 234836968],
            [1309996800000, 235195785],
            [1310083200000, 235527282],
            [1310169600000, 235968140],
            [1310256000000, 236250479],
            [1310342400000, 236401423],
            [1310428800000, 236573379],
            [1310515200000, 236717399],
            [1310601600000, 236860479],
            [1310688000000, 237005066],
            [1310774400000, 237212719],
            [1310860800000, 237353634],
            [1310947200000, 237436920],
            [1311033600000, 237530409],
            [1311120000000, 237614580],
            [1311206400000, 237710309]
        ],
        name: 'piratesofthecaribbean4',
        showInLegend: false,
        extra: {
            title: 'Pirates of the Caribbean: On Stranger Tides',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#4F4835'
        },
        showlabel: false,
        color: 'rgba(79,72,53,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1274400000000, 20802341
            ],
            [1274486400000, 49692928],
            [1274572800000, 70838207],
            [1274659200000, 76543595],
            [1274745600000, 81231825],
            [1274832000000, 85308441],
            [1274918400000, 89750351],
            [1275004800000, 101111188],
            [1275091200000, 118026614],
            [1275177600000, 133061414],
            [1275264000000, 146810785],
            [1275350400000, 150687105],
            [1275436800000, 154132920],
            [1275523200000, 157742988],
            [1275609600000, 164235537],
            [1275696000000, 175029690],
            [1275782400000, 183229453],
            [1275868800000, 185655338],
            [1275955200000, 188602643],
            [1276041600000, 191467791],
            [1276128000000, 194252066],
            [1276214400000, 198715437],
            [1276300800000, 205302140],
            [1276387200000, 210022557],
            [1276473600000, 211893539],
            [1276560000000, 213895667],
            [1276646400000, 215791971],
            [1276732800000, 217456527],
            [1276819200000, 219142341],
            [1276905600000, 221275898],
            [1276992000000, 223076925],
            [1277078400000, 223828770],
            [1277164800000, 224720876],
            [1277251200000, 225536287],
            [1277337600000, 226437724],
            [1277424000000, 227310190],
            [1277510400000, 228550683],
            [1277596800000, 229539089],
            [1277683200000, 230054325],
            [1277769600000, 230579276],
            [1277856000000, 231079496],
            [1277942400000, 231388475],
            [1278028800000, 231681129],
            [1278115200000, 232009634],
            [1278201600000, 232278641],
            [1278288000000, 232664432],
            [1278374400000, 232873520],
            [1278460800000, 233077350],
            [1278547200000, 233282505],
            [1278633600000, 233447456],
            [1278720000000, 233654838],
            [1278806400000, 233784897],
            [1278892800000, 233855061],
            [1278979200000, 233958902],
            [1279065600000, 234042007],
            [1279152000000, 234113209],
            [1279238400000, 234199109],
            [1279324800000, 234314116],
            [1279411200000, 234393583],
            [1279497600000, 234444701],
            [1279584000000, 234515225],
            [1279670400000, 234570090],
            [1279756800000, 234620150],
            [1279843200000, 234696597],
            [1279929600000, 234787733],
            [1280016000000, 234845975],
            [1280102400000, 234879864],
            [1280188800000, 234930116],
            [1280275200000, 235003522],
            [1280361600000, 235072928],
            [1280448000000, 235246406],
            [1280534400000, 235472439],
            [1280620800000, 235646952],
            [1280707200000, 235753203],
            [1280793600000, 235895124],
            [1280880000000, 236010570],
            [1280966400000, 236119800],
            [1281052800000, 236251786],
            [1281139200000, 236422070],
            [1281225600000, 236554025],
            [1281312000000, 236627446],
            [1281398400000, 236722479],
            [1281484800000, 236801512],
            [1281571200000, 236875709],
            [1281657600000, 236983541],
            [1281744000000, 237126797],
            [1281830400000, 237235936],
            [1281916800000, 237290662],
            [1282003200000, 237356203],
            [1282089600000, 237409223],
            [1282176000000, 237459246],
            [1282262400000, 237533333],
            [1282348800000, 237651066],
            [1282435200000, 237736710],
            [1282521600000, 237770532],
            [1282608000000, 237806218],
            [1282694400000, 237834535],
            [1282780800000, 237861152],
            [1282867200000, 237910255],
            [1282953600000, 237998495],
            [1283040000000, 238053790],
            [1283126400000, 238070960],
            [1283212800000, 238091234],
            [1283299200000, 238107363],
            [1283385600000, 238123685],
            [1283472000000, 238161913],
            [1283558400000, 238240392],
            [1283644800000, 238319043],
            [1283731200000, 238371987],
            [1283817600000, 238380811],
            [1283904000000, 238388379],
            [1283990400000, 238395990]
        ],
        name: 'shrek4',
        showInLegend: false,
        extra: {
            title: 'Shrek Forever After',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#8F918A'
        },
        showlabel: false,
        color: 'rgba(143,145,138,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1369353600000, 38737505
            ],
            [1369440000000, 70434075],
            [1369526400000, 97375245],
            [1369612800000, 117036995],
            [1369699200000, 125066305],
            [1369785600000, 130846355],
            [1369872000000, 135839525],
            [1369958400000, 146584215],
            [1370044800000, 160627875],
            [1370131200000, 171003965],
            [1370217600000, 173972465],
            [1370304000000, 177529455],
            [1370390400000, 180349245],
            [1370476800000, 183185695],
            [1370563200000, 189274110],
            [1370649600000, 197476615],
            [1370736000000, 202812580],
            [1370822400000, 204960175],
            [1370908800000, 207032380],
            [1370995200000, 208652930],
            [1371081600000, 210140625],
            [1371168000000, 212960290],
            [1371254400000, 216637515],
            [1371340800000, 219723955],
            [1371427200000, 220804725],
            [1371513600000, 221950590],
            [1371600000000, 222928095],
            [1371686400000, 223687470],
            [1371772800000, 225186015],
            [1371859200000, 227192125],
            [1371945600000, 228618155],
            [1372032000000, 229186150],
            [1372118400000, 229851375],
            [1372204800000, 230407285],
            [1372291200000, 230902770],
            [1372377600000, 231623520],
            [1372464000000, 232615515],
            [1372550400000, 233351765],
            [1372636800000, 233700515],
            [1372723200000, 233979500],
            [1372809600000, 234202450],
            [1372896000000, 234415110],
            [1372982400000, 234794565],
            [1373068800000, 235232620],
            [1373155200000, 235488675],
            [1373241600000, 235605905],
            [1373328000000, 235741645],
            [1373414400000, 235861960],
            [1373500800000, 235985355],
            [1373587200000, 236160770],
            [1373673600000, 236394010],
            [1373760000000, 236533170],
            [1373846400000, 236599810],
            [1373932800000, 236678225],
            [1374019200000, 236739405],
            [1374105600000, 236798975],
            [1374192000000, 236898025],
            [1374278400000, 237027760],
            [1374364800000, 237121225],
            [1374451200000, 237164470],
            [1374537600000, 237214690],
            [1374624000000, 237260725],
            [1374710400000, 237303850],
            [1374796800000, 237393295],
            [1374883200000, 237521455],
            [1374969600000, 237614905],
            [1375056000000, 237657625],
            [1375142400000, 237704380],
            [1375228800000, 237747075],
            [1375315200000, 237791130],
            [1375401600000, 237855530],
            [1375488000000, 237947540],
            [1375574400000, 238019990],
            [1375660800000, 238052190],
            [1375747200000, 238084440],
            [1375833600000, 238110890],
            [1375920000000, 238139655],
            [1376006400000, 238180720],
            [1376092800000, 238240800],
            [1376179200000, 238286640],
            [1376265600000, 238304785],
            [1376352000000, 238322950],
            [1376438400000, 238340140],
            [1376524800000, 238358265],
            [1376611200000, 238383645],
            [1376697600000, 238424535],
            [1376784000000, 238454145],
            [1376870400000, 238464720],
            [1376956800000, 238476000],
            [1377043200000, 238486620],
            [1377129600000, 238497875],
            [1377216000000, 238511105],
            [1377302400000, 238534625],
            [1377388800000, 238550310],
            [1377475200000, 238555700],
            [1377561600000, 238561580],
            [1377648000000, 238566985],
            [1377734400000, 238571890],
            [1377820800000, 238586345],
            [1377907200000, 238623810],
            [1377993600000, 238664225],
            [1378080000000, 238673370],
            [1378166400000, 238675730],
            [1378252800000, 238677795],
            [1378339200000, 238679850]
        ],
        name: 'fast6',
        showInLegend: false,
        extra: {
            title: 'Fast & Furious 6',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#677A84'
        },
        showlabel: false,
        color: 'rgba(103,122,132,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1340323200000, 24635336
            ],
            [1340409600000, 48317451],
            [1340496000000, 66323594],
            [1340582400000, 75271765],
            [1340668800000, 84198540],
            [1340755200000, 91032679],
            [1340841600000, 97673691],
            [1340928000000, 108041370],
            [1341014400000, 121390734],
            [1341100800000, 131768334],
            [1341187200000, 137156457],
            [1341273600000, 142936958],
            [1341360000000, 149357744],
            [1341446400000, 154356971],
            [1341532800000, 160644366],
            [1341619200000, 168439892],
            [1341705600000, 173969341],
            [1341792000000, 176510299],
            [1341878400000, 179663513],
            [1341964800000, 182313615],
            [1342051200000, 184900797],
            [1342137600000, 188190072],
            [1342224000000, 192594772],
            [1342310400000, 196061319],
            [1342396800000, 197568791],
            [1342483200000, 199588261],
            [1342569600000, 201217358],
            [1342656000000, 202749186],
            [1342742400000, 204685383],
            [1342828800000, 206974418],
            [1342915200000, 208774173],
            [1343001600000, 209748406],
            [1343088000000, 210985777],
            [1343174400000, 211915861],
            [1343260800000, 213024519],
            [1343347200000, 214278315],
            [1343433600000, 215991838],
            [1343520000000, 217329672],
            [1343606400000, 218004024],
            [1343692800000, 218894314],
            [1343779200000, 219683026],
            [1343865600000, 220434040],
            [1343952000000, 221240260],
            [1344038400000, 222424008],
            [1344124800000, 223420254],
            [1344211200000, 223930002],
            [1344297600000, 224476127],
            [1344384000000, 224944628],
            [1344470400000, 225442866],
            [1344556800000, 225981150],
            [1344643200000, 226710296],
            [1344729600000, 227245531],
            [1344816000000, 227502102],
            [1344902400000, 227838771],
            [1344988800000, 228078779],
            [1345075200000, 228305518],
            [1345161600000, 228530217],
            [1345248000000, 228867922],
            [1345334400000, 229121303],
            [1345420800000, 229236468],
            [1345507200000, 229365193],
            [1345593600000, 229471133],
            [1345680000000, 229572266],
            [1345766400000, 229705875],
            [1345852800000, 229930669],
            [1345939200000, 230089038],
            [1346025600000, 230174296],
            [1346112000000, 230254753],
            [1346198400000, 230314785],
            [1346284800000, 230374177],
            [1346371200000, 230651013],
            [1346457600000, 231201543],
            [1346544000000, 231801179],
            [1346630400000, 232430114],
            [1346716800000, 232538812],
            [1346803200000, 232611434],
            [1346889600000, 232677392],
            [1346976000000, 232816477],
            [1347062400000, 233181588],
            [1347148800000, 233397964],
            [1347235200000, 233435872],
            [1347321600000, 233476349],
            [1347408000000, 233515172],
            [1347494400000, 233558247]
        ],
        name: 'bearandthebow',
        showInLegend: false,
        extra: {
            title: 'Brave',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#455C63'
        },
        showlabel: false,
        color: 'rgba(69,92,99,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1362700800000, 24096622
            ],
            [1362787200000, 57114192],
            [1362873600000, 79110453],
            [1362960000000, 85432469],
            [1363046400000, 92540469],
            [1363132800000, 97674850],
            [1363219200000, 102803624],
            [1363305600000, 114187771],
            [1363392000000, 132409762],
            [1363478400000, 144056326],
            [1363564800000, 146960044],
            [1363651200000, 150253436],
            [1363737600000, 152945940],
            [1363824000000, 155528133],
            [1363910400000, 161165189],
            [1363996800000, 170909439],
            [1364083200000, 177097090],
            [1364169600000, 179348352],
            [1364256000000, 182047930],
            [1364342400000, 184206524],
            [1364428800000, 186672400],
            [1364515200000, 190982707],
            [1364601600000, 195439055],
            [1364688000000, 198374716],
            [1364774400000, 200229389],
            [1364860800000, 201792571],
            [1364947200000, 203119402],
            [1365033600000, 204596718],
            [1365120000000, 207047174],
            [1365206400000, 210501929],
            [1365292800000, 212606952],
            [1365379200000, 213050537],
            [1365465600000, 213590410],
            [1365552000000, 214035037],
            [1365638400000, 214521412],
            [1365724800000, 215757610],
            [1365811200000, 218032425],
            [1365897600000, 219381370],
            [1365984000000, 219707081],
            [1366070400000, 220090740],
            [1366156800000, 220399743],
            [1366243200000, 220722108],
            [1366329600000, 221486742],
            [1366416000000, 222922354],
            [1366502400000, 223726752],
            [1366588800000, 223894955],
            [1366675200000, 224099056],
            [1366761600000, 224275891],
            [1366848000000, 224448139],
            [1366934400000, 224877775],
            [1367020800000, 225713527],
            [1367107200000, 226258745],
            [1367193600000, 226388008],
            [1367280000000, 226521554],
            [1367366400000, 226630112],
            [1367452800000, 226745932],
            [1367539200000, 227470030],
            [1367625600000, 228506066],
            [1367712000000, 228858941],
            [1367798400000, 228938914],
            [1367884800000, 229025504],
            [1367971200000, 229102022],
            [1368057600000, 229182320],
            [1368144000000, 229458940],
            [1368230400000, 229976530],
            [1368316800000, 230260553],
            [1368403200000, 230320165],
            [1368489600000, 230381718],
            [1368576000000, 230433735],
            [1368662400000, 230479996],
            [1368748800000, 230728032],
            [1368835200000, 231132397],
            [1368921600000, 231351161],
            [1369008000000, 231414417],
            [1369094400000, 231467270],
            [1369180800000, 231520565],
            [1369267200000, 231563051],
            [1369353600000, 231727257],
            [1369440000000, 231982423],
            [1369526400000, 232214564],
            [1369612800000, 232416130],
            [1369699200000, 232485225],
            [1369785600000, 232546560],
            [1369872000000, 232613195]
        ],
        name: 'oz',
        showInLegend: false,
        extra: {
            title: 'Oz The Great and Powerful',
            genre: 'Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#716E57'
        },
        showlabel: false,
        color: 'rgba(113,110,87,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1148601600000, 45102265
            ],
            [1148688000000, 77100108],
            [1148774400000, 102750665],
            [1148860800000, 122861157],
            [1148947200000, 130150700],
            [1149033600000, 135955809],
            [1149120000000, 141331162],
            [1149206400000, 151640643],
            [1149292800000, 165969435],
            [1149379200000, 175348409],
            [1149465600000, 178281306],
            [1149552000000, 181307083],
            [1149638400000, 183778985],
            [1149724800000, 186166074],
            [1149811200000, 191128432],
            [1149897600000, 197827850],
            [1149984000000, 202244652],
            [1150070400000, 203913170],
            [1150156800000, 205448161],
            [1150243200000, 206959236],
            [1150329600000, 208398600],
            [1150416000000, 210634537],
            [1150502400000, 213650847],
            [1150588800000, 216218853],
            [1150675200000, 217103585],
            [1150761600000, 217963855],
            [1150848000000, 218806943],
            [1150934400000, 219664212],
            [1151020800000, 221076807],
            [1151107200000, 223039408],
            [1151193600000, 224506162],
            [1151280000000, 225131616],
            [1151366400000, 225707984],
            [1151452800000, 226089043],
            [1151539200000, 226483394],
            [1151625600000, 227096716],
            [1151712000000, 227901868],
            [1151798400000, 228691003],
            [1151884800000, 229326962],
            [1151971200000, 229805892],
            [1152057600000, 230119823],
            [1152144000000, 230413405],
            [1152230400000, 230712037],
            [1152316800000, 231089903],
            [1152403200000, 231333947],
            [1152489600000, 231447319],
            [1152576000000, 231567377],
            [1152662400000, 231687159],
            [1152748800000, 231802193],
            [1152835200000, 231949191],
            [1152921600000, 232169443],
            [1153008000000, 232329982],
            [1153094400000, 232405899],
            [1153180800000, 232484164],
            [1153267200000, 232556315],
            [1153353600000, 232631145],
            [1153440000000, 232716758],
            [1153526400000, 232848256],
            [1153612800000, 232937297],
            [1153699200000, 232980279],
            [1153785600000, 233025813],
            [1153872000000, 233068898],
            [1153958400000, 233115252],
            [1154044800000, 233189167],
            [1154131200000, 233291365],
            [1154217600000, 233369859],
            [1154304000000, 233408226],
            [1154390400000, 233452144],
            [1154476800000, 233488165],
            [1154563200000, 233524650],
            [1154649600000, 233578993],
            [1154736000000, 233655441],
            [1154822400000, 233713415],
            [1154908800000, 233742340],
            [1154995200000, 233772356],
            [1155081600000, 233800133],
            [1155168000000, 233828542],
            [1155254400000, 233870343],
            [1155340800000, 233930634],
            [1155427200000, 233972204],
            [1155513600000, 233992734],
            [1155600000000, 234013639],
            [1155686400000, 234032445],
            [1155772800000, 234051421],
            [1155859200000, 234080401],
            [1155945600000, 234122499],
            [1156032000000, 234150411],
            [1156118400000, 234162340],
            [1156204800000, 234175512],
            [1156291200000, 234187916],
            [1156377600000, 234200461],
            [1156464000000, 234213138],
            [1156550400000, 234232396],
            [1156636800000, 234245748],
            [1156723200000, 234250044],
            [1156809600000, 234254421],
            [1156896000000, 234258934],
            [1156982400000, 234263625],
            [1157068800000, 234271606],
            [1157155200000, 234284894],
            [1157241600000, 234298832],
            [1157328000000, 234306945],
            [1157414400000, 234309459],
            [1157500800000, 234311600],
            [1157587200000, 234313651],
            [1157673600000, 234317790],
            [1157760000000, 234325013],
            [1157846400000, 234329411],
            [1157932800000, 234330982],
            [1158019200000, 234333500],
            [1158105600000, 234335149],
            [1158192000000, 234337076]
        ],
        name: 'x3',
        showInLegend: false,
        extra: {
            title: 'X-Men: The Last Stand',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#233234'
        },
        showlabel: false,
        color: 'rgba(35,50,52,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1120003200000, 21256483
            ],
            [1120089600000, 35682400],
            [1120176000000, 57602976],
            [1120262400000, 80785176],
            [1120348800000, 100561125],
            [1120435200000, 112744353],
            [1120521600000, 121197381],
            [1120608000000, 128321572],
            [1120694400000, 134509164],
            [1120780800000, 144222891],
            [1120867200000, 156514700],
            [1120953600000, 164978282],
            [1121040000000, 168256749],
            [1121126400000, 171334671],
            [1121212800000, 174319438],
            [1121299200000, 177191173],
            [1121385600000, 181592129],
            [1121472000000, 187826223],
            [1121558400000, 192426922],
            [1121644800000, 194345519],
            [1121731200000, 196159547],
            [1121817600000, 197808521],
            [1121904000000, 199496038],
            [1121990400000, 202116023],
            [1122076800000, 205827443],
            [1122163200000, 208421643],
            [1122249600000, 209578221],
            [1122336000000, 210761647],
            [1122422400000, 211839879],
            [1122508800000, 212888025],
            [1122595200000, 214458063],
            [1122681600000, 216718899],
            [1122768000000, 218369264],
            [1122854400000, 219100387],
            [1122940800000, 219782801],
            [1123027200000, 220415036],
            [1123113600000, 221066743],
            [1123200000000, 222095066],
            [1123286400000, 223556853],
            [1123372800000, 224615038],
            [1123459200000, 225067650],
            [1123545600000, 225545628],
            [1123632000000, 225986675],
            [1123718400000, 226411999],
            [1123804800000, 227024208],
            [1123891200000, 227941724],
            [1123977600000, 228570693],
            [1124064000000, 228832848],
            [1124150400000, 229099626],
            [1124236800000, 229330644],
            [1124323200000, 229557485],
            [1124409600000, 229847262],
            [1124496000000, 230311556],
            [1124582400000, 230614825],
            [1124668800000, 230725666],
            [1124755200000, 230841716],
            [1124841600000, 230945482],
            [1124928000000, 231048141],
            [1125014400000, 231251622],
            [1125100800000, 231595835],
            [1125187200000, 231806280],
            [1125273600000, 231875040],
            [1125360000000, 231944929],
            [1125446400000, 232002113],
            [1125532800000, 232053587],
            [1125619200000, 232156816],
            [1125705600000, 232328043],
            [1125792000000, 232500642],
            [1125878400000, 232606871],
            [1125964800000, 232630821],
            [1126051200000, 232652248],
            [1126137600000, 232674625],
            [1126224000000, 232736555],
            [1126310400000, 232845684],
            [1126396800000, 232901322],
            [1126483200000, 232918205],
            [1126569600000, 232936984],
            [1126656000000, 232954958],
            [1126742400000, 232973624],
            [1126828800000, 233015902],
            [1126915200000, 233089406],
            [1127001600000, 233122751],
            [1127088000000, 233133060],
            [1127174400000, 233144389],
            [1127260800000, 233152877],
            [1127347200000, 233163795],
            [1127433600000, 233187270],
            [1127520000000, 233227625],
            [1127606400000, 233250863],
            [1127692800000, 233257429],
            [1127779200000, 233264192],
            [1127865600000, 233270899],
            [1127952000000, 233275313],
            [1128038400000, 233291175],
            [1128124800000, 233316667],
            [1128211200000, 233331057],
            [1128297600000, 233336978],
            [1128384000000, 233343194],
            [1128470400000, 233348632],
            [1128556800000, 233353848],
            [1128643200000, 233415322],
            [1128729600000, 233512113],
            [1128816000000, 233575986],
            [1128902400000, 233604519],
            [1128988800000, 233628459],
            [1129075200000, 233648915],
            [1129161600000, 233674084],
            [1129248000000, 233722195],
            [1129334400000, 233799478],
            [1129420800000, 233846752],
            [1129507200000, 233864018],
            [1129593600000, 233882927],
            [1129680000000, 233900951],
            [1129766400000, 233923621],
            [1129852800000, 233959054],
            [1129939200000, 234012576],
            [1130025600000, 234043462],
            [1130112000000, 234052608],
            [1130198400000, 234061527],
            [1130284800000, 234070083],
            [1130371200000, 234079816],
            [1130457600000, 234098426],
            [1130544000000, 234125906],
            [1130630400000, 234141872],
            [1130716800000, 234147465],
            [1130803200000, 234154255],
            [1130889600000, 234160959],
            [1130976000000, 234167095],
            [1131062400000, 234178283],
            [1131148800000, 234196327],
            [1131235200000, 234206993],
            [1131321600000, 234210273],
            [1131408000000, 234213206],
            [1131494400000, 234216784],
            [1131580800000, 234222387],
            [1131667200000, 234231568],
            [1131753600000, 234242607],
            [1131840000000, 234249189],
            [1131926400000, 234251374],
            [1132012800000, 234254488],
            [1132099200000, 234257189],
            [1132185600000, 234259853],
            [1132272000000, 234264675],
            [1132358400000, 234271925],
            [1132444800000, 234277056],
            [1132531200000, 234278646],
            [1132617600000, 234280354]
        ],
        name: 'waroftheworlds',
        showInLegend: false,
        extra: {
            title: 'War of the Worlds',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#261918'
        },
        showlabel: false,
        color: 'rgba(38,25,24,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1400803200000, 35511974
            ],
            [1400889600000, 64795624],
            [1400976000000, 90823660],
            [1401062400000, 110576604],
            [1401148800000, 118784278],
            [1401235200000, 124500629],
            [1401321600000, 129469103],
            [1401408000000, 138885350],
            [1401494400000, 152680342],
            [1401580800000, 162020201],
            [1401667200000, 165184109],
            [1401753600000, 168972004],
            [1401840000000, 171796141],
            [1401926400000, 174401266],
            [1402012800000, 178911283],
            [1402099200000, 185087823],
            [1402185600000, 189556080],
            [1402272000000, 191321387],
            [1402358400000, 193343016],
            [1402444800000, 195050480],
            [1402531200000, 196440161],
            [1402617600000, 199165626],
            [1402704000000, 202895779],
            [1402790400000, 206256610],
            [1402876800000, 207290131],
            [1402963200000, 208532577],
            [1403049600000, 209567948],
            [1403136000000, 210594250],
            [1403222400000, 212446102],
            [1403308800000, 215058107],
            [1403395200000, 216744710],
            [1403481600000, 217536652],
            [1403568000000, 218579891],
            [1403654400000, 219411155],
            [1403740800000, 220093472],
            [1403827200000, 221059943],
            [1403913600000, 222407427],
            [1404000000000, 223414899],
            [1404086400000, 223976645],
            [1404172800000, 224517107],
            [1404259200000, 224809730],
            [1404345600000, 225220002],
            [1404432000000, 225757864],
            [1404518400000, 226541639],
            [1404604800000, 227113129],
            [1404691200000, 227389753],
            [1404777600000, 227688282],
            [1404864000000, 227917699],
            [1404950400000, 228137071],
            [1405036800000, 228451545],
            [1405123200000, 228883910],
            [1405209600000, 229162436],
            [1405296000000, 229313541],
            [1405382400000, 229498627],
            [1405468800000, 229642438],
            [1405555200000, 229774662],
            [1405641600000, 229972319],
            [1405728000000, 230284264],
            [1405814400000, 230485366],
            [1405900800000, 230580569],
            [1405987200000, 230695150],
            [1406073600000, 230791969],
            [1406160000000, 230877809],
            [1406246400000, 230991566],
            [1406332800000, 231153146],
            [1406419200000, 231272870],
            [1406505600000, 231331687],
            [1406592000000, 231399484],
            [1406678400000, 231457477],
            [1406764800000, 231509253],
            [1406851200000, 231564196],
            [1406937600000, 231641535],
            [1407024000000, 231696337],
            [1407110400000, 231725041],
            [1407196800000, 231755727],
            [1407283200000, 231779700],
            [1407369600000, 231799370],
            [1407456000000, 231878279],
            [1407542400000, 231992036],
            [1407628800000, 232077846],
            [1407715200000, 232118585],
            [1407801600000, 232165894],
            [1407888000000, 232204004],
            [1407974400000, 232240053],
            [1408060800000, 232305400],
            [1408147200000, 232406628],
            [1408233600000, 232480814],
            [1408320000000, 232511746],
            [1408406400000, 232545631],
            [1408492800000, 232575428],
            [1408579200000, 232603581],
            [1408665600000, 232645402],
            [1408752000000, 232707401],
            [1408838400000, 232749987],
            [1408924800000, 232765600],
            [1409011200000, 232782530],
            [1409097600000, 232798366],
            [1409184000000, 232814528],
            [1409270400000, 232923282],
            [1409356800000, 233094397],
            [1409443200000, 233283151],
            [1409529600000, 233407513],
            [1409616000000, 233446604],
            [1409702400000, 233477751],
            [1409788800000, 233506334],
            [1409875200000, 233549779],
            [1409961600000, 233624750],
            [1410048000000, 233660474],
            [1410134400000, 233673080],
            [1410220800000, 233687502],
            [1410307200000, 233700525],
            [1410393600000, 233713155],
            [1410480000000, 233732735],
            [1410566400000, 233764296],
            [1410652800000, 233783836],
            [1410739200000, 233789672],
            [1410825600000, 233797694],
            [1410912000000, 233804186],
            [1410998400000, 233810203],
            [1411084800000, 233824373],
            [1411171200000, 233846288],
            [1411257600000, 233855197],
            [1411344000000, 233857844],
            [1411430400000, 233860747],
            [1411516800000, 233863515],
            [1411603200000, 233866513],
            [1411689600000, 233874734],
            [1411776000000, 233887886],
            [1411862400000, 233893992],
            [1411948800000, 233896590],
            [1412035200000, 233899529],
            [1412121600000, 233902091],
            [1412208000000, 233904517]
        ],
        name: 'xmen2014',
        showInLegend: false,
        extra: {
            title: 'X-Men: Days of Future Past',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#7C7461'
        },
        showlabel: false,
        color: 'rgba(124,116,97,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                977443200000, 11755000
            ],
            [977529600000, 23900000],
            [977616000000, 28883406],
            [977702400000, 39852075],
            [977788800000, 51521864],
            [977875200000, 60815039],
            [977961600000, 69650725],
            [978048000000, 80770725],
            [978134400000, 92096725],
            [978220800000, 100628594],
            [978307200000, 109689440]
        ],
        name: 'castaway',
        showInLegend: false,
        extra: {
            title: 'Cast Away',
            genre: 'Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#98857E'
        },
        showlabel: false,
        color: 'rgba(152,133,126,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                864259200000, 2567184
            ],
            [864345600000, 24172569],
            [864432000000, 48616019],
            [864518400000, 74699969],
            [864604800000, 92729064],
            [864691200000, 98388789],
            [864777600000, 103014999],
            [864864000000, 107427944],
            [864950400000, 116880104],
            [865036800000, 131681924],
            [865123200000, 141544334],
            [865209600000, 144596594],
            [865296000000, 147648949],
            [865382400000, 150011989],
            [865468800000, 152539129],
            [865555200000, 157515734],
            [865641600000, 166076174],
            [865728000000, 171103734],
            [865814400000, 172955099],
            [865900800000, 174823449],
            [865987200000, 176352099],
            [866073600000, 178220449],
            [866160000000, 181500249],
            [866246400000, 186776464],
            [866332800000, 190697964],
            [866419200000, 192209249],
            [866505600000, 193878689],
            [866592000000, 195477989],
            [866678400000, 196914929],
            [866764800000, 199183139],
            [866851200000, 202562309],
            [866937600000, 204953959],
            [867024000000, 205869559],
            [867110400000, 206921464],
            [867196800000, 207774344],
            [867283200000, 208687249],
            [867369600000, 210003784],
            [867456000000, 211776544],
            [867542400000, 213223429],
            [867628800000, 213976859],
            [867715200000, 214658339],
            [867801600000, 215105459],
            [867888000000, 215729779],
            [867974400000, 216464359],
            [868060800000, 217590079],
            [868147200000, 218334199],
            [868233600000, 218658824],
            [868320000000, 219046904],
            [868406400000, 219384899],
            [868492800000, 219704624],
            [868579200000, 220074344],
            [868665600000, 220678694],
            [868752000000, 221055524],
            [868838400000, 221258774],
            [868924800000, 221479544],
            [869011200000, 221656244],
            [869097600000, 221828294],
            [869184000000, 222031109],
            [869270400000, 222335319],
            [869356800000, 222529669],
            [869443200000, 222635749],
            [869529600000, 222752619],
            [869616000000, 222857399],
            [869702400000, 222967289],
            [869788800000, 223086829],
            [869875200000, 223259189],
            [869961600000, 223375949],
            [870048000000, 223437244],
            [870134400000, 223510184],
            [870220800000, 223570099],
            [870307200000, 223627114],
            [870393600000, 223699144],
            [870480000000, 223807189],
            [870566400000, 223886079],
            [870652800000, 223928069],
            [870739200000, 223970769],
            [870825600000, 224008209],
            [870912000000, 224044224],
            [870998400000, 224326419],
            [871084800000, 224753874],
            [871171200000, 225098329],
            [871257600000, 225258724],
            [871344000000, 225418524],
            [871430400000, 225562344],
            [871516800000, 225690184],
            [871603200000, 225898739],
            [871689600000, 226197799],
            [871776000000, 226437834],
            [871862400000, 226540704],
            [871948800000, 226642899],
            [872035200000, 226737524],
            [872121600000, 226836319],
            [872208000000, 226959959],
            [872294400000, 227162279],
            [872380800000, 227308399],
            [872467200000, 227349949],
            [872553600000, 227391199],
            [872640000000, 227426884],
            [872726400000, 227462699],
            [872812800000, 227529254],
            [872899200000, 227664829],
            [872985600000, 227788079],
            [873072000000, 227881749],
            [873158400000, 227905399],
            [873244800000, 227926459],
            [873331200000, 227945139],
            [873417600000, 227993739],
            [873504000000, 228094989],
            [873590400000, 228157764],
            [873676800000, 228175449],
            [873763200000, 228208514],
            [873849600000, 228227929],
            [873936000000, 228249269],
            [874022400000, 228302484],
            [874108800000, 228401574],
            [874195200000, 228467634],
            [874281600000, 228480094],
            [874368000000, 228495979],
            [874454400000, 228510139],
            [874540800000, 228524419],
            [874627200000, 228565999],
            [874713600000, 228655314],
            [874800000000, 228709214],
            [874886400000, 228719749],
            [874972800000, 228731709],
            [875059200000, 228740649],
            [875145600000, 228751044],
            [875232000000, 228785539],
            [875318400000, 228848789],
            [875404800000, 228893639],
            [875491200000, 228900254],
            [875577600000, 228907919],
            [875664000000, 228914489],
            [875750400000, 228923249],
            [875836800000, 228940334],
            [875923200000, 228982544],
            [876009600000, 229013699],
            [876096000000, 229018949],
            [876182400000, 229024164],
            [876268800000, 229028514],
            [876355200000, 229033589],
            [876441600000, 229042904],
            [876528000000, 229061039],
            [876614400000, 229074524],
            [876700800000, 229080569],
            [876787200000, 229082494],
            [876873600000, 229084399],
            [876960000000, 229086679]
        ],
        name: 'jurassicpark2',
        showInLegend: false,
        extra: {
            title: 'The Lost World: Jurassic Park',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#37352D'
        },
        showlabel: false,
        color: 'rgba(55,53,45,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1368576000000, 2000000
            ],
            [1368662400000, 13536422],
            [1368748800000, 35159424],
            [1368835200000, 62107246],
            [1368921600000, 83701981],
            [1369008000000, 91684816],
            [1369094400000, 98446262],
            [1369180800000, 103773288],
            [1369267200000, 108826566],
            [1369353600000, 118812963],
            [1369440000000, 133235029],
            [1369526400000, 146117582],
            [1369612800000, 156013879],
            [1369699200000, 159452337],
            [1369785600000, 162193907],
            [1369872000000, 164756486],
            [1369958400000, 169210542],
            [1370044800000, 176335361],
            [1370131200000, 181537381],
            [1370217600000, 183169614],
            [1370304000000, 185050586],
            [1370390400000, 186681718],
            [1370476800000, 188440439],
            [1370563200000, 191670851],
            [1370649600000, 196606375],
            [1370736000000, 199866194],
            [1370822400000, 201200543],
            [1370908800000, 202578928],
            [1370995200000, 203715975],
            [1371081600000, 204830694],
            [1371168000000, 206286482],
            [1371254400000, 208466299],
            [1371340800000, 211086948],
            [1371427200000, 211732773],
            [1371513600000, 212456669],
            [1371600000000, 213088052],
            [1371686400000, 213610916],
            [1371772800000, 214482016],
            [1371859200000, 215785127],
            [1371945600000, 216777625],
            [1372032000000, 217169951],
            [1372118400000, 217649868],
            [1372204800000, 218063851],
            [1372291200000, 218460867],
            [1372377600000, 219013071],
            [1372464000000, 219894524],
            [1372550400000, 220591070],
            [1372636800000, 220945947],
            [1372723200000, 221208929],
            [1372809600000, 221431376],
            [1372896000000, 221754563],
            [1372982400000, 222195981],
            [1373068800000, 222706916],
            [1373155200000, 223065011],
            [1373241600000, 223211320],
            [1373328000000, 223381060],
            [1373414400000, 223523979],
            [1373500800000, 223674724],
            [1373587200000, 223864900],
            [1373673600000, 224160833],
            [1373760000000, 224360905],
            [1373846400000, 224459201],
            [1373932800000, 224569384],
            [1374019200000, 224655809],
            [1374105600000, 224733703],
            [1374192000000, 224844211],
            [1374278400000, 225008414],
            [1374364800000, 225120966],
            [1374451200000, 225176491],
            [1374537600000, 225239412],
            [1374624000000, 225297507],
            [1374710400000, 225352743],
            [1374796800000, 225419020],
            [1374883200000, 225532693],
            [1374969600000, 225602796],
            [1375056000000, 225635958],
            [1375142400000, 225674575],
            [1375228800000, 225708503],
            [1375315200000, 225744027],
            [1375401600000, 225885269],
            [1375488000000, 226078618],
            [1375574400000, 226222380],
            [1375660800000, 226300625],
            [1375747200000, 226379251],
            [1375833600000, 226447445],
            [1375920000000, 226513226],
            [1376006400000, 226600012],
            [1376092800000, 226716716],
            [1376179200000, 226801056],
            [1376265600000, 226841897],
            [1376352000000, 226887104],
            [1376438400000, 226927100],
            [1376524800000, 226967532],
            [1376611200000, 227023858],
            [1376697600000, 227105255],
            [1376784000000, 227161815],
            [1376870400000, 227188185],
            [1376956800000, 227217750],
            [1377043200000, 227244180],
            [1377129600000, 227271488],
            [1377216000000, 227300792],
            [1377302400000, 227347082],
            [1377388800000, 227377844],
            [1377475200000, 227393091],
            [1377561600000, 227408787],
            [1377648000000, 227424110],
            [1377734400000, 227440810],
            [1377820800000, 227611644],
            [1377907200000, 227901486],
            [1377993600000, 228225160],
            [1378080000000, 228496824],
            [1378166400000, 228568049],
            [1378252800000, 228628937],
            [1378339200000, 228696481],
            [1378425600000, 228713167],
            [1378512000000, 228740674],
            [1378598400000, 228756232],
            [1378684800000, 228762233],
            [1378771200000, 228768274],
            [1378857600000, 228773450],
            [1378944000000, 228778661]
        ],
        name: 'startrek12',
        showInLegend: false,
        extra: {
            title: 'Star Trek Into Darkness',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#68727B'
        },
        showlabel: false,
        color: 'rgba(104,114,123,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1443744000000, 18145681
            ],
            [1443830400000, 40397446],
            [1443916800000, 54308575],
            [1444003200000, 58709746],
            [1444089600000, 64166986],
            [1444176000000, 67908516],
            [1444262400000, 71710329],
            [1444348800000, 82439900],
            [1444435200000, 98317435],
            [1444521600000, 108715595],
            [1444608000000, 113616378],
            [1444694400000, 117070711],
            [1444780800000, 119705048],
            [1444867200000, 122295658],
            [1444953600000, 128573081],
            [1445040000000, 138029471],
            [1445126400000, 143595778],
            [1445212800000, 145190068],
            [1445299200000, 147290238],
            [1445385600000, 148865268],
            [1445472000000, 150455148],
            [1445558400000, 154809074],
            [1445644800000, 162074401],
            [1445731200000, 166188055],
            [1445817600000, 167403182],
            [1445904000000, 168978179],
            [1445990400000, 170229660],
            [1446076800000, 171406753],
            [1446163200000, 174881848],
            [1446249600000, 179446657],
            [1446336000000, 183121850],
            [1446422400000, 184272949],
            [1446508800000, 185745438],
            [1446595200000, 186812231],
            [1446681600000, 187767346],
            [1446768000000, 190354904],
            [1446854400000, 194644914],
            [1446940800000, 196841665],
            [1447027200000, 197458376],
            [1447113600000, 198507516],
            [1447200000000, 200009441],
            [1447286400000, 200682616],
            [1447372800000, 202611064],
            [1447459200000, 205804901],
            [1447545600000, 207394787],
            [1447632000000, 207850615],
            [1447718400000, 208455239],
            [1447804800000, 208922337],
            [1447891200000, 209339442],
            [1447977600000, 210355769],
            [1448064000000, 212101444],
            [1448150400000, 213137212],
            [1448236800000, 213580575],
            [1448323200000, 214090849],
            [1448409600000, 214694512],
            [1448496000000, 215315848],
            [1448582400000, 216657827],
            [1448668800000, 217968230],
            [1448755200000, 218536914],
            [1448841600000, 218700851],
            [1448928000000, 218889878],
            [1449014400000, 219047062],
            [1449100800000, 219198188],
            [1449187200000, 219650091],
            [1449273600000, 220419562],
            [1449360000000, 220804548],
            [1449446400000, 220936858],
            [1449532800000, 221110305],
            [1449619200000, 221256579],
            [1449705600000, 221400035],
            [1449792000000, 221797300],
            [1449878400000, 222473658],
            [1449964800000, 222857395],
            [1450051200000, 223006015],
            [1450137600000, 223181681],
            [1450224000000, 223340672],
            [1450310400000, 223429423],
            [1450396800000, 223543034],
            [1450483200000, 223737145],
            [1450569600000, 223879433],
            [1450656000000, 224003532],
            [1450742400000, 224147998],
            [1450828800000, 224271733],
            [1450915200000, 224366075],
            [1451001600000, 224494103],
            [1451088000000, 224698203],
            [1451174400000, 224853519],
            [1451260800000, 224969871],
            [1451347200000, 225099234],
            [1451433600000, 225230402],
            [1451520000000, 225345353],
            [1451606400000, 225566908],
            [1451692800000, 225799748],
            [1451779200000, 225910757],
            [1451865600000, 225959845],
            [1451952000000, 226013103],
            [1452038400000, 226060608],
            [1452124800000, 226111022],
            [1452211200000, 226219296],
            [1452297600000, 226395250],
            [1452384000000, 226486935],
            [1452470400000, 226527358],
            [1452556800000, 226579382],
            [1452643200000, 226621697],
            [1452729600000, 226673040],
            [1452816000000, 226803399],
            [1452902400000, 226990283],
            [1452988800000, 227126112],
            [1453075200000, 227228785],
            [1453161600000, 227267955],
            [1453248000000, 227300929],
            [1453334400000, 227335414],
            [1453420800000, 227412534],
            [1453507200000, 227557300],
            [1453593600000, 227616581],
            [1453680000000, 227640428],
            [1453766400000, 227670698],
            [1453852800000, 227698543],
            [1453939200000, 227726706],
            [1454025600000, 227782840],
            [1454112000000, 227879824],
            [1454198400000, 227938641],
            [1454284800000, 227954994],
            [1454371200000, 227973068],
            [1454457600000, 227989763],
            [1454544000000, 228006339],
            [1454630400000, 228040107],
            [1454716800000, 228102100],
            [1454803200000, 228120056],
            [1454889600000, 228130698],
            [1454976000000, 228143921],
            [1455062400000, 228154213],
            [1455148800000, 228167401],
            [1455235200000, 228184660],
            [1455321600000, 228217850],
            [1455408000000, 228252568],
            [1455494400000, 228268141],
            [1455580800000, 228275757],
            [1455667200000, 228282752],
            [1455753600000, 228289428],
            [1455840000000, 228298585],
            [1455926400000, 228325066],
            [1456012800000, 228334654],
            [1456099200000, 228337289],
            [1456185600000, 228342485],
            [1456272000000, 228346128],
            [1456358400000, 228349433],
            [1456444800000, 228355677],
            [1456531200000, 228373362],
            [1456617600000, 228380115],
            [1456704000000, 228383455],
            [1456790400000, 228387492],
            [1456876800000, 228391970],
            [1456963200000, 228395947]
        ],
        name: 'scott2016',
        showInLegend: false,
        extra: {
            title: 'The Martian',
            genre: 'Sci-Fi',

            mpaaRating: 'PG-13',
            imgMainColor: '#76645C'
        },
        showlabel: false,
        color: 'rgba(118,100,92,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1028246400000, 20884660
            ],
            [1028332800000, 42568319],
            [1028419200000, 60117080],
            [1028505600000, 68890718],
            [1028592000000, 76206559],
            [1028678400000, 82457960],
            [1028764800000, 88264037],
            [1028851200000, 97599654],
            [1028937600000, 109065264],
            [1029024000000, 117718640],
            [1029110400000, 121268574],
            [1029196800000, 124925090],
            [1029283200000, 128131661],
            [1029369600000, 131150457],
            [1029456000000, 137205877],
            [1029542400000, 145241307],
            [1029628800000, 150513131],
            [1029715200000, 152679612],
            [1029801600000, 154930821],
            [1029888000000, 156820179],
            [1029974400000, 158822707],
            [1030060800000, 163257765],
            [1030147200000, 169416382],
            [1030233600000, 173107735],
            [1030320000000, 174472619],
            [1030406400000, 175940137],
            [1030492800000, 177231649],
            [1030579200000, 178539342],
            [1030665600000, 181935926],
            [1030752000000, 186954575],
            [1030838400000, 191980536],
            [1030924800000, 195582456],
            [1031011200000, 196457492],
            [1031097600000, 197159582],
            [1031184000000, 197845087],
            [1031270400000, 200143168],
            [1031356800000, 203897718],
            [1031443200000, 205696958],
            [1031529600000, 206158190],
            [1031616000000, 206699685],
            [1031702400000, 207172908],
            [1031788800000, 207627239],
            [1031875200000, 209181655],
            [1031961600000, 211681943],
            [1032048000000, 213032514],
            [1032134400000, 213411117],
            [1032220800000, 213779727],
            [1032307200000, 214111335],
            [1032393600000, 214440493],
            [1032480000000, 215466804],
            [1032566400000, 217143310],
            [1032652800000, 217941210],
            [1032739200000, 218139387],
            [1032825600000, 218371867],
            [1032912000000, 218581940],
            [1032998400000, 218791237],
            [1033084800000, 219510197],
            [1033171200000, 220638156],
            [1033257600000, 221155028],
            [1033344000000, 221296435],
            [1033430400000, 221457986],
            [1033516800000, 221604591],
            [1033603200000, 221747567],
            [1033689600000, 222250696],
            [1033776000000, 223043662],
            [1033862400000, 223400036],
            [1033948800000, 223493264],
            [1034035200000, 223608066],
            [1034121600000, 223711162],
            [1034208000000, 223832926],
            [1034294400000, 224071841],
            [1034380800000, 224441029],
            [1034467200000, 224635135],
            [1034553600000, 224719837],
            [1034640000000, 224771020],
            [1034726400000, 224819530],
            [1034812800000, 224874066],
            [1034899200000, 224994341],
            [1034985600000, 225184580],
            [1035072000000, 225266143],
            [1035158400000, 225290281],
            [1035244800000, 225317598],
            [1035331200000, 225341938],
            [1035417600000, 225371719],
            [1041379200000, 227622389],
            [1041465600000, 227647707]
        ],
        name: 'signs',
        showInLegend: false,
        extra: {
            title: 'Signs',
            genre: 'Sci-Fi Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#6A250E'
        },
        showlabel: false,
        color: 'rgba(106,37,14,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1214870400000, 6835034
            ],
            [1214956800000, 24221400],
            [1215043200000, 41273567],
            [1215129600000, 59801534],
            [1215216000000, 85582938],
            [1215302400000, 103877446],
            [1215388800000, 112359061],
            [1215475200000, 119782276],
            [1215561600000, 126194279],
            [1215648000000, 132034444],
            [1215734400000, 142391181],
            [1215820800000, 155158422],
            [1215907200000, 164115004],
            [1215993600000, 167923822],
            [1216080000000, 171434779],
            [1216166400000, 174596940],
            [1216252800000, 177503801],
            [1216339200000, 182061534],
            [1216425600000, 187514276],
            [1216512000000, 191543979],
            [1216598400000, 193228764],
            [1216684800000, 194937182],
            [1216771200000, 196566863],
            [1216857600000, 198170884],
            [1216944000000, 200806172],
            [1217030400000, 204109207],
            [1217116800000, 206482007],
            [1217203200000, 207560589],
            [1217289600000, 208691711],
            [1217376000000, 209744025],
            [1217462400000, 210795466],
            [1217548800000, 212335062],
            [1217635200000, 214470173],
            [1217721600000, 215883222],
            [1217808000000, 216601200],
            [1217894400000, 217295054],
            [1217980800000, 217881055],
            [1218067200000, 218409341],
            [1218153600000, 219436636],
            [1218240000000, 220807504],
            [1218326400000, 221726791],
            [1218412800000, 222169969],
            [1218499200000, 222625918],
            [1218585600000, 222977356],
            [1218672000000, 223302346],
            [1218758400000, 223847123],
            [1218844800000, 224599615],
            [1218931200000, 225022587],
            [1219017600000, 225214837],
            [1219104000000, 225418257],
            [1219190400000, 225569544],
            [1219276800000, 225713937],
            [1219363200000, 225908076],
            [1219449600000, 226198589],
            [1219536000000, 226357065],
            [1219622400000, 226412418],
            [1219708800000, 226466909],
            [1219795200000, 226507190],
            [1219881600000, 226547044],
            [1219968000000, 226710719],
            [1220054400000, 226965509],
            [1220140800000, 227211630],
            [1220227200000, 227381199],
            [1220572800000, 227596883],
            [1220659200000, 227830976],
            [1220745600000, 227946274]
        ],
        name: 'hancock',
        showInLegend: false,
        extra: {
            title: 'Hancock',
            genre: 'Fantasy Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#6E5651'
        },
        showlabel: false,
        color: 'rgba(110,86,81,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1186099200000, 24668225
            ],
            [1186185600000, 49958890],
            [1186272000000, 69283690],
            [1186358400000, 78415390],
            [1186444800000, 85881790],
            [1186531200000, 92616000],
            [1186617600000, 98673300],
            [1186704000000, 109067820],
            [1186790400000, 122300560],
            [1186876800000, 131552425],
            [1186963200000, 135107850],
            [1187049600000, 138444055],
            [1187136000000, 141614610],
            [1187222400000, 144820320],
            [1187308800000, 150575375],
            [1187395200000, 158754585],
            [1187481600000, 164694690],
            [1187568000000, 166915290],
            [1187654400000, 169117385],
            [1187740800000, 170985835],
            [1187827200000, 172781400],
            [1187913600000, 176497190],
            [1188000000000, 181942110],
            [1188086400000, 185253615],
            [1188172800000, 186357315],
            [1188259200000, 187443760],
            [1188345600000, 188423035],
            [1188432000000, 189420115],
            [1188518400000, 192019200],
            [1188604800000, 195852050],
            [1188691200000, 199832950],
            [1188777600000, 202810455],
            [1188864000000, 203484905],
            [1188950400000, 204060655],
            [1189036800000, 204620755],
            [1189123200000, 206291305],
            [1189209600000, 208985255],
            [1189296000000, 210294605],
            [1189382400000, 210700955],
            [1189468800000, 211168905],
            [1189555200000, 211590380],
            [1189641600000, 212041880],
            [1189728000000, 213282105],
            [1189814400000, 215305630],
            [1189900800000, 216167260],
            [1189987200000, 216441415],
            [1190073600000, 216754920],
            [1190160000000, 217054945],
            [1190246400000, 217367170],
            [1190332800000, 218231040],
            [1190419200000, 219637035],
            [1190505600000, 220239735],
            [1190592000000, 220430590],
            [1190678400000, 220631115],
            [1190764800000, 220832100],
            [1190851200000, 221042705],
            [1190937600000, 221568245],
            [1191024000000, 222415625],
            [1191110400000, 222788180],
            [1191196800000, 222905060],
            [1191283200000, 223037055],
            [1191369600000, 223160960],
            [1191456000000, 223291925],
            [1191542400000, 223638050],
            [1191628800000, 224174300],
            [1191715200000, 224476610],
            [1191801600000, 224647235],
            [1191888000000, 224735360],
            [1191974400000, 224827865],
            [1192060800000, 224929860],
            [1192147200000, 225131490],
            [1192233600000, 225436975],
            [1192320000000, 225568340],
            [1192406400000, 225614165],
            [1192492800000, 225666100],
            [1192579200000, 225718145],
            [1192665600000, 225775920],
            [1192752000000, 225882160],
            [1192838400000, 226029900],
            [1192924800000, 226096325],
            [1193011200000, 226121250],
            [1193097600000, 226149375],
            [1193184000000, 226177690],
            [1193270400000, 226205910],
            [1193356800000, 226294095],
            [1193443200000, 226417575],
            [1193529600000, 226474905],
            [1193616000000, 226496955],
            [1193702400000, 226519080],
            [1193788800000, 226549845],
            [1193875200000, 226574870],
            [1193961600000, 226641560],
            [1194048000000, 226737890],
            [1194134400000, 226776175],
            [1194220800000, 226790995],
            [1194307200000, 226808190],
            [1194393600000, 226825585],
            [1194480000000, 226842875],
            [1194566400000, 226894640],
            [1194652800000, 226973810],
            [1194739200000, 227015425],
            [1194825600000, 227036740],
            [1194912000000, 227051050],
            [1194998400000, 227064145],
            [1195084800000, 227077350],
            [1195171200000, 227124825],
            [1195257600000, 227193400],
            [1195344000000, 227225045],
            [1195430400000, 227238760],
            [1195516800000, 227254665],
            [1195603200000, 227279235],
            [1195689600000, 227300025],
            [1195776000000, 227355210],
            [1195862400000, 227413170],
            [1195948800000, 227437090],
            [1196035200000, 227444450],
            [1196121600000, 227453635],
            [1196208000000, 227461915],
            [1196294400000, 227471070]
        ],
        name: 'bourneultimatum',
        showInLegend: false,
        extra: {
            title: 'The Bourne Ultimatum',
            genre: 'Action Thriller',

            mpaaRating: 'PG-13',
            imgMainColor: '#363637'
        },
        showlabel: false,
        color: 'rgba(54,54,55,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                996796800000, 23108000
            ],
            [996883200000, 47453000],
            [996969600000, 67408222],
            [997056000000, 76879392],
            [997142400000, 85711327],
            [997228800000, 93014381],
            [997315200000, 100408069],
            [997401600000, 110710069],
            [997488000000, 123509069],
            [997574400000, 133525381],
            [997660800000, 137507262],
            [997747200000, 141507533],
            [997833600000, 144780674],
            [997920000000, 147632620],
            [998006400000, 152814620],
            [998092800000, 160874620],
            [998179200000, 164656828],
            [998265600000, 166939150],
            [998352000000, 169359981]
        ],
        name: 'rushhour2',
        showInLegend: false,
        extra: {
            title: 'Rush Hour 2',
            genre: 'Action Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#A396A6'
        },
        showlabel: false,
        color: 'rgba(163,150,166,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1214524800000, 23164108
            ],
            [1214611200000, 45280305],
            [1214697600000, 63087526],
            [1214784000000, 72000812],
            [1214870400000, 79601894],
            [1214956800000, 86311330],
            [1215043200000, 94686825],
            [1215129600000, 103687413],
            [1215216000000, 117309220],
            [1215302400000, 127196028],
            [1215388800000, 131701577],
            [1215475200000, 136117014],
            [1215561600000, 140400408],
            [1215648000000, 144262312],
            [1215734400000, 149893838],
            [1215820800000, 157369928],
            [1215907200000, 163055900],
            [1215993600000, 165635698],
            [1216080000000, 168099359],
            [1216166400000, 170460303],
            [1216252800000, 172662313],
            [1216339200000, 175648516],
            [1216425600000, 179582614],
            [1216512000000, 182732709],
            [1216598400000, 184158235],
            [1216684800000, 185706378],
            [1216771200000, 187311409],
            [1216857600000, 188885890],
            [1216944000000, 190756493],
            [1217030400000, 193221634],
            [1217116800000, 195308076],
            [1217203200000, 196249794],
            [1217289600000, 197330404],
            [1217376000000, 198397847],
            [1217462400000, 199474897],
            [1217548800000, 200769839],
            [1217635200000, 202699406],
            [1217721600000, 204078076],
            [1217808000000, 204836763],
            [1217894400000, 205623556],
            [1217980800000, 206387786],
            [1218067200000, 207066499],
            [1218153600000, 207985025],
            [1218240000000, 209214315],
            [1218326400000, 210206582],
            [1218412800000, 210767640],
            [1218499200000, 211332152],
            [1218585600000, 211834786],
            [1218672000000, 212293611],
            [1218758400000, 212839131],
            [1218844800000, 213573848],
            [1218931200000, 214129943],
            [1219017600000, 214414367],
            [1219104000000, 214749990],
            [1219190400000, 215031069],
            [1219276800000, 215286444],
            [1219363200000, 215536074],
            [1219449600000, 215918022],
            [1219536000000, 216252003],
            [1219622400000, 216396896],
            [1219708800000, 216532830],
            [1219795200000, 216668606],
            [1219881600000, 216798080],
            [1219968000000, 217058880],
            [1220054400000, 217518280],
            [1220140800000, 217973943],
            [1220227200000, 218447803],
            [1220313600000, 218522103],
            [1220400000000, 218577395],
            [1220486400000, 218623790],
            [1220572800000, 218761794],
            [1220659200000, 219159649],
            [1220745600000, 219398090],
            [1220832000000, 219433299],
            [1220918400000, 219474267],
            [1221004800000, 219511310],
            [1221091200000, 219549391],
            [1230076800000, 223782114],
            [1230163200000, 223783432],
            [1230768000000, 223799741]
        ],
        name: 'wall-e',
        showInLegend: false,
        extra: {
            title: 'WALL-E',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#316289'
        },
        showlabel: false,
        color: 'rgba(49,98,137,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1415318400000, 15809055
            ],
            [1415404800000, 39859650],
            [1415491200000, 56215889],
            [1415577600000, 61375017],
            [1415664000000, 71883199],
            [1415750400000, 73760135],
            [1415836800000, 75643891],
            [1415923200000, 83627292],
            [1416009600000, 100032143],
            [1416096000000, 110306598],
            [1416182400000, 111617471],
            [1416268800000, 113309621],
            [1416355200000, 114472033],
            [1416441600000, 115622069],
            [1416528000000, 120071305],
            [1416614400000, 129620181],
            [1416700800000, 135746235],
            [1416787200000, 137931085],
            [1416873600000, 141204274],
            [1416960000000, 145370104],
            [1417046400000, 148402760],
            [1417132800000, 156140847],
            [1417219200000, 163371786],
            [1417305600000, 167219558],
            [1417392000000, 167832114],
            [1417478400000, 168465363],
            [1417564800000, 168936048],
            [1417651200000, 169418239],
            [1417737600000, 171225234],
            [1417824000000, 175158295],
            [1417910400000, 177461157],
            [1417996800000, 177841551],
            [1418083200000, 178348125],
            [1418169600000, 178751127],
            [1418256000000, 179180009],
            [1418342400000, 180566149],
            [1418428800000, 183482907],
            [1418515200000, 185235910],
            [1418601600000, 185611522],
            [1418688000000, 186101489],
            [1418774400000, 186474712],
            [1418860800000, 186878423],
            [1418947200000, 187752093],
            [1419033600000, 189280710],
            [1419120000000, 190520749],
            [1419206400000, 191610083],
            [1419292800000, 192946619],
            [1419379200000, 193783160],
            [1419465600000, 195077578],
            [1419552000000, 196739622],
            [1419638400000, 198579516],
            [1419724800000, 200084063],
            [1419811200000, 201498903],
            [1419897600000, 203198664],
            [1419984000000, 204576654],
            [1420070400000, 206452220],
            [1420156800000, 208316845],
            [1420243200000, 210069378],
            [1420329600000, 211207036],
            [1420416000000, 211561351],
            [1420502400000, 211798980],
            [1420588800000, 212006266],
            [1420675200000, 212208958],
            [1420761600000, 212636782],
            [1420848000000, 213785826],
            [1420934400000, 214517894],
            [1421020800000, 214640132],
            [1421107200000, 214781686],
            [1421193600000, 214908683],
            [1421280000000, 215018530],
            [1421366400000, 215209837],
            [1421452800000, 215716351],
            [1421539200000, 216092561],
            [1421625600000, 216615498],
            [1421712000000, 216681518],
            [1421798400000, 216726104],
            [1421884800000, 216772237],
            [1421971200000, 216898224],
            [1422057600000, 217238281],
            [1422144000000, 217456064],
            [1422230400000, 217498498],
            [1422316800000, 217536892],
            [1422403200000, 217572411],
            [1422489600000, 217603425],
            [1432512000000, 222520426]
        ],
        name: 'disney2014',
        showInLegend: false,
        extra: {
            title: 'Big Hero 6',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#C1C3CC'
        },
        showlabel: false,
        color: 'rgba(193,195,204,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1198195200000, 16739339
            ],
            [1198281600000, 32083987],
            [1198368000000, 44783772],
            [1198454400000, 51788067],
            [1198540800000, 65444195],
            [1198627200000, 77885462],
            [1198713600000, 88402703],
            [1198800000000, 100663964],
            [1198886400000, 113337359],
            [1198972800000, 124075411],
            [1199059200000, 133263682],
            [1199145600000, 142943238],
            [1199232000000, 147227857],
            [1199318400000, 150808111],
            [1199404800000, 157151213],
            [1199491200000, 165905443],
            [1199577600000, 170870795],
            [1199664000000, 172173479],
            [1199750400000, 173487657],
            [1199836800000, 174667392],
            [1199923200000, 175812945],
            [1200009600000, 179081905],
            [1200096000000, 184252119],
            [1200182400000, 187114947],
            [1200268800000, 187829224],
            [1200355200000, 188529929],
            [1200441600000, 189171937],
            [1200528000000, 189882845],
            [1200614400000, 191903532],
            [1200700800000, 195373363],
            [1200787200000, 197433099],
            [1200873600000, 199489171],
            [1200960000000, 199936064],
            [1201046400000, 200322147],
            [1201132800000, 200756607],
            [1201219200000, 201957418],
            [1201305600000, 204290199],
            [1201392000000, 205672738],
            [1201478400000, 205988174],
            [1201564800000, 206268562],
            [1201651200000, 206557914],
            [1201737600000, 206829041],
            [1201824000000, 207671226],
            [1201910400000, 209288571],
            [1201996800000, 209792593],
            [1202083200000, 210001309],
            [1202169600000, 210201764],
            [1202256000000, 210393004],
            [1202342400000, 210602252],
            [1202428800000, 211138990],
            [1202515200000, 212178909],
            [1202601600000, 212752399],
            [1202688000000, 212882717],
            [1202774400000, 213008679],
            [1202860800000, 213150585],
            [1202947200000, 213365784],
            [1203033600000, 213683686],
            [1203120000000, 214283824],
            [1203206400000, 214682908],
            [1203292800000, 215022515],
            [1203379200000, 215116885],
            [1203465600000, 215208706],
            [1203552000000, 215306145],
            [1203638400000, 215481000],
            [1203724800000, 215821000],
            [1203811200000, 216001504]
        ],
        name: 'nationaltreasure2',
        showInLegend: false,
        extra: {
            title: 'National Treasure: Book of Secrets',
            genre: 'Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#514536'
        },
        showlabel: false,
        color: 'rgba(81,69,54,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1261526400000, 18801277
            ],
            [1261612800000, 26713633],
            [1261699200000, 40603644],
            [1261785600000, 60445675],
            [1261872000000, 75589048],
            [1261958400000, 87685940],
            [1262044800000, 100217975],
            [1262131200000, 111995269],
            [1262217600000, 120727282],
            [1262304000000, 133725546],
            [1262390400000, 148098819],
            [1262476800000, 155916935],
            [1262563200000, 158134760],
            [1262649600000, 159687650],
            [1262736000000, 160865424],
            [1262822400000, 161884676],
            [1262908800000, 165353332],
            [1262995200000, 173403160],
            [1263081600000, 178451165],
            [1263168000000, 179106580],
            [1263254400000, 179834568],
            [1263340800000, 180448165],
            [1263427200000, 181091843],
            [1263513600000, 183511452],
            [1263600000000, 188779317],
            [1263686400000, 192711792],
            [1263772800000, 196397651],
            [1263859200000, 196943298],
            [1263945600000, 197326536],
            [1264032000000, 197736844],
            [1264118400000, 199134661],
            [1264204800000, 202374650],
            [1264291200000, 204140348],
            [1264377600000, 204484323],
            [1264464000000, 204777208],
            [1264550400000, 205027069],
            [1264636800000, 205297861],
            [1264723200000, 206107322],
            [1264809600000, 208020293],
            [1264896000000, 209294997],
            [1264982400000, 209515803],
            [1265068800000, 209703049],
            [1265155200000, 209876138],
            [1265241600000, 210030215],
            [1265328000000, 210455904],
            [1265414400000, 211600106],
            [1265500800000, 212156137],
            [1265587200000, 212286930],
            [1265673600000, 212393689],
            [1265760000000, 212493272],
            [1265846400000, 212615471],
            [1265932800000, 212824272],
            [1266019200000, 213355012],
            [1266105600000, 213896122],
            [1266192000000, 214311806],
            [1266278400000, 214433476],
            [1266364800000, 214535546],
            [1266451200000, 214645988],
            [1266537600000, 214838923],
            [1266624000000, 215290200],
            [1266710400000, 215581073],
            [1266796800000, 215632797],
            [1266883200000, 215682905],
            [1266969600000, 215733759],
            [1267056000000, 215785616],
            [1267142400000, 215930874],
            [1267228800000, 216319757],
            [1267315200000, 216556981],
            [1267401600000, 216624221],
            [1267488000000, 216698174],
            [1267574400000, 216759904],
            [1267660800000, 216822641],
            [1267747200000, 216949430],
            [1267833600000, 217207263],
            [1267920000000, 217367092],
            [1268006400000, 217400711],
            [1268092800000, 217436542],
            [1268179200000, 217467386],
            [1268265600000, 217501492],
            [1268352000000, 217605347],
            [1268438400000, 217819816],
            [1268524800000, 217963072],
            [1268611200000, 218035365],
            [1268697600000, 218122139],
            [1268784000000, 218192219],
            [1268870400000, 218263248],
            [1268956800000, 218379718],
            [1269043200000, 218539317],
            [1269129600000, 218641790],
            [1269216000000, 218669185],
            [1269302400000, 218696709],
            [1269388800000, 218722513],
            [1269475200000, 218752541],
            [1269561600000, 218825001],
            [1269648000000, 218946643],
            [1269734400000, 219028490],
            [1269820800000, 219061449],
            [1269907200000, 219099351],
            [1269993600000, 219132378],
            [1270080000000, 219169160],
            [1270166400000, 219226050],
            [1270252800000, 219278717],
            [1270339200000, 219304216],
            [1270425600000, 219332115],
            [1270512000000, 219355966],
            [1270598400000, 219380534],
            [1270684800000, 219407028],
            [1270771200000, 219431561],
            [1270857600000, 219464834],
            [1270944000000, 219485915],
            [1271030400000, 219490671],
            [1271116800000, 219495766],
            [1271203200000, 219500145],
            [1271289600000, 219505059],
            [1271376000000, 219512145],
            [1271462400000, 219531139],
            [1271548800000, 219543166],
            [1271635200000, 219545364],
            [1271721600000, 219548271],
            [1271808000000, 219550840],
            [1271894400000, 219553378]
        ],
        name: 'alvinandthechipmunksii',
        showInLegend: false,
        extra: {
            title: 'Alvin and the Chipmunks: The Squeakquel',
            genre: 'Family Comedy',

            mpaaRating: 'PG',
            imgMainColor: '#C19D43'
        },
        showlabel: false,
        color: 'rgba(193,157,67,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1340928000000, 20583845
            ],
            [1341014400000, 38463130],
            [1341100800000, 54415205],
            [1341187200000, 63144310],
            [1341273600000, 71598100],
            [1341360000000, 79614625],
            [1341446400000, 87647345],
            [1341532800000, 98229900],
            [1341619200000, 110114300],
            [1341705600000, 119849740],
            [1341792000000, 124327075],
            [1341878400000, 129080835],
            [1341964800000, 133085715],
            [1342051200000, 136846395],
            [1342137600000, 143749665],
            [1342224000000, 152453070],
            [1342310400000, 159257250],
            [1342396800000, 162196920],
            [1342483200000, 165514890],
            [1342569600000, 168173775],
            [1342656000000, 170419815],
            [1342742400000, 173665955],
            [1342828800000, 177554895],
            [1342915200000, 180431425],
            [1343001600000, 181861655],
            [1343088000000, 183549005],
            [1343174400000, 184867510],
            [1343260800000, 186265600],
            [1343347200000, 188440255],
            [1343433600000, 191459740],
            [1343520000000, 193618750],
            [1343606400000, 194635675],
            [1343692800000, 195855985],
            [1343779200000, 196918310],
            [1343865600000, 197935235],
            [1343952000000, 199567765],
            [1344038400000, 201836705],
            [1344124800000, 203579915],
            [1344211200000, 204396180],
            [1344297600000, 205267785],
            [1344384000000, 205952810],
            [1344470400000, 206624910],
            [1344556800000, 207618505],
            [1344643200000, 208987465],
            [1344729600000, 209848585],
            [1344816000000, 210257065],
            [1344902400000, 210753865],
            [1344988800000, 211142420],
            [1345075200000, 211521305],
            [1345161600000, 212006440],
            [1345248000000, 212684460],
            [1345334400000, 213064385],
            [1345420800000, 213263135],
            [1345507200000, 213479400],
            [1345593600000, 213647370],
            [1345680000000, 213815375],
            [1345766400000, 214109000],
            [1345852800000, 214535735],
            [1345939200000, 214762805],
            [1346025600000, 214880255],
            [1346112000000, 215001620],
            [1346198400000, 215083100],
            [1346284800000, 215164905],
            [1346371200000, 215361255],
            [1346457600000, 215650170],
            [1346544000000, 215975550],
            [1346630400000, 216124215],
            [1346716800000, 216191535],
            [1346803200000, 216247620],
            [1346889600000, 216309330],
            [1346976000000, 216471810],
            [1347062400000, 216737035],
            [1347148800000, 216858060],
            [1347235200000, 216904410],
            [1347321600000, 216958485],
            [1347408000000, 217004835],
            [1347494400000, 217053760],
            [1347580800000, 217170895],
            [1347667200000, 217345570],
            [1347753600000, 217431880],
            [1347840000000, 217468870],
            [1347926400000, 217516135],
            [1348012800000, 217555180],
            [1348099200000, 217594245],
            [1348185600000, 217666030],
            [1348272000000, 217777370],
            [1348358400000, 217838900],
            [1348444800000, 217862340],
            [1348531200000, 217891505],
            [1348617600000, 217918020],
            [1348704000000, 217943065],
            [1348790400000, 217994815],
            [1348876800000, 218075800],
            [1348963200000, 218118550],
            [1349049600000, 218135425],
            [1349136000000, 218157925],
            [1349222400000, 218177050],
            [1349308800000, 218197300],
            [1349395200000, 218240310],
            [1349481600000, 218303890],
            [1349568000000, 218344095],
            [1349654400000, 218364665],
            [1349740800000, 218381495],
            [1349827200000, 218398380],
            [1349913600000, 218416145],
            [1350000000000, 218445100],
            [1350086400000, 218487875],
            [1350172800000, 218511800],
            [1350259200000, 218523400],
            [1350345600000, 218535725],
            [1350432000000, 218547310],
            [1350518400000, 218558935],
            [1350604800000, 218580720],
            [1350691200000, 218612330],
            [1350777600000, 218628680],
            [1350864000000, 218639035],
            [1350950400000, 218648845],
            [1351036800000, 218657565],
            [1351123200000, 218665740]
        ],
        name: 'ted',
        showInLegend: false,
        extra: {
            title: 'Ted',
            genre: 'Comedy',

            mpaaRating: 'R',
            imgMainColor: '#B8B7AE'
        },
        showlabel: false,
        color: 'rgba(184,183,174,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1134518400000, 9755745
            ],
            [1134604800000, 16051500],
            [1134691200000, 30519740],
            [1134777600000, 50625420],
            [1134864000000, 66181645],
            [1134950400000, 71819770],
            [1135036800000, 77064730],
            [1135123200000, 81935050],
            [1135209600000, 87322730],
            [1135296000000, 95172050],
            [1135382400000, 99731450],
            [1135468800000, 108582050],
            [1135555200000, 120597410],
            [1135641600000, 128516635],
            [1135728000000, 135632875],
            [1135814400000, 142732900],
            [1135900800000, 151546510],
            [1135987200000, 158709835],
            [1136073600000, 167505310],
            [1136160000000, 174559825],
            [1136246400000, 176826950],
            [1136332800000, 178440965],
            [1136419200000, 180056520],
            [1136505600000, 183468880],
            [1136592000000, 189214215],
            [1136678400000, 192678805],
            [1136764800000, 193427435],
            [1136851200000, 194159990],
            [1136937600000, 194820415],
            [1137024000000, 195466000],
            [1137110400000, 197253500],
            [1137196800000, 200503670],
            [1137283200000, 202994060],
            [1137369600000, 204527690],
            [1137456000000, 204920915],
            [1137542400000, 205287420],
            [1137628800000, 205653325],
            [1137715200000, 206667630],
            [1137801600000, 208773405],
            [1137888000000, 209875885],
            [1137974400000, 210129460],
            [1138060800000, 210361685],
            [1138147200000, 210581810],
            [1138233600000, 210813615],
            [1138320000000, 211349025],
            [1138406400000, 212439675],
            [1138492800000, 213160170],
            [1138579200000, 213298980],
            [1138665600000, 213430575],
            [1138752000000, 213556700],
            [1138838400000, 213682750],
            [1138924800000, 213993790],
            [1139011200000, 214624555],
            [1139097600000, 214870795],
            [1139184000000, 214952875],
            [1139270400000, 215026315],
            [1139356800000, 215091320],
            [1139443200000, 215164315],
            [1139529600000, 215287795],
            [1139616000000, 215543575],
            [1139702400000, 215699910],
            [1139788800000, 215741805],
            [1139875200000, 215807955],
            [1139961600000, 215838825],
            [1140048000000, 215876310],
            [1140134400000, 215960715],
            [1140220800000, 216126215],
            [1140307200000, 216253650],
            [1140393600000, 216326425],
            [1140480000000, 216356215],
            [1140566400000, 216380990],
            [1140652800000, 216409195],
            [1140739200000, 216476515],
            [1140825600000, 216604560],
            [1140912000000, 216682440],
            [1140998400000, 216699600],
            [1141084800000, 216716705],
            [1141171200000, 216733800],
            [1141257600000, 216752280],
            [1141344000000, 216803120],
            [1141430400000, 216902305],
            [1141516800000, 216959345],
            [1141603200000, 216975465],
            [1141689600000, 216994065],
            [1141776000000, 217010185],
            [1141862400000, 217027545],
            [1141948800000, 217094795],
            [1142035200000, 217214500],
            [1142121600000, 217295200],
            [1142208000000, 217320755],
            [1142294400000, 217349000],
            [1142380800000, 217377305],
            [1142467200000, 217404255],
            [1142553600000, 217458540],
            [1142640000000, 217553250],
            [1142726400000, 217619085],
            [1142812800000, 217639875],
            [1142899200000, 217661830],
            [1142985600000, 217681465],
            [1143072000000, 217703470],
            [1143158400000, 217751490],
            [1143244800000, 217834785],
            [1143331200000, 217888685],
            [1143417600000, 217906325],
            [1143504000000, 217925910],
            [1143590400000, 217941590],
            [1143676800000, 217958250],
            [1143763200000, 217986415],
            [1143849600000, 218027680],
            [1143936000000, 218051260],
            [1144022400000, 218058465],
            [1144108800000, 218065660],
            [1144195200000, 218072815],
            [1144281600000, 218080025]
        ],
        name: 'kingkong05',
        showInLegend: false,
        extra: {
            title: 'King Kong',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#2C2520'
        },
        showlabel: false,
        color: 'rgba(44,37,32,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1269561600000, 12111766
            ],
            [1269648000000, 29631129],
            [1269734400000, 43732319],
            [1269820800000, 48546356],
            [1269907200000, 53349384],
            [1269993600000, 57883758],
            [1270080000000, 63125872],
            [1270166400000, 74154464],
            [1270252800000, 85238738],
            [1270339200000, 92135916],
            [1270425600000, 97421955],
            [1270512000000, 101249677],
            [1270598400000, 104734787],
            [1270684800000, 108540903],
            [1270771200000, 115675218],
            [1270857600000, 126198538],
            [1270944000000, 133404438],
            [1271030400000, 134787856],
            [1271116800000, 136176769],
            [1271203200000, 137352994],
            [1271289600000, 138617746],
            [1271376000000, 143022006],
            [1271462400000, 152133279],
            [1271548800000, 158251066],
            [1271635200000, 159457334],
            [1271721600000, 160664564],
            [1271808000000, 161771986],
            [1271894400000, 162995714],
            [1271980800000, 166536205],
            [1272067200000, 173312012],
            [1272153600000, 178345927],
            [1272240000000, 179190648],
            [1272326400000, 180051585],
            [1272412800000, 180789348],
            [1272499200000, 181559461],
            [1272585600000, 184095814],
            [1272672000000, 188910309],
            [1272758400000, 192173750],
            [1272844800000, 192779027],
            [1272931200000, 193361713],
            [1273017600000, 193856228],
            [1273104000000, 194333493],
            [1273190400000, 195872398],
            [1273276800000, 198721848],
            [1273363200000, 201013867],
            [1273449600000, 201395933],
            [1273536000000, 201831179],
            [1273622400000, 202241491],
            [1273708800000, 202644160],
            [1273795200000, 203876674],
            [1273881600000, 206254334],
            [1273968000000, 207647696],
            [1274054400000, 208000613],
            [1274140800000, 208397784],
            [1274227200000, 208734342],
            [1274313600000, 209089707],
            [1274400000000, 209566917],
            [1274486400000, 210426449],
            [1274572800000, 210990918],
            [1274659200000, 211181910],
            [1274745600000, 211327568],
            [1274832000000, 211470955],
            [1274918400000, 211604219],
            [1275004800000, 211889900],
            [1275091200000, 212350813],
            [1275177600000, 212755053],
            [1275264000000, 213117896],
            [1275350400000, 213208783],
            [1275436800000, 213296279],
            [1275523200000, 213394860],
            [1275609600000, 213529957],
            [1275696000000, 213735833],
            [1275782400000, 213883143],
            [1275868800000, 213927417],
            [1275955200000, 213983553],
            [1276041600000, 214042992],
            [1276128000000, 214095922],
            [1276214400000, 214192750],
            [1276300800000, 214336618],
            [1276387200000, 214426381],
            [1276473600000, 214467516],
            [1276560000000, 214511729],
            [1276646400000, 214555206],
            [1276732800000, 214597215],
            [1276819200000, 214647781],
            [1276905600000, 214711067],
            [1276992000000, 214764298],
            [1277078400000, 214792123],
            [1277164800000, 214826555],
            [1277251200000, 214889307],
            [1277337600000, 214945029],
            [1277424000000, 215094166],
            [1277510400000, 215280326],
            [1277596800000, 215422528],
            [1277683200000, 215511663],
            [1277769600000, 215622731],
            [1277856000000, 215714814],
            [1277942400000, 215815234],
            [1278028800000, 215944617],
            [1278115200000, 216075167],
            [1278201600000, 216156994],
            [1278288000000, 216296739],
            [1278374400000, 216387290],
            [1278460800000, 216476025],
            [1278547200000, 216576044],
            [1278633600000, 216684502],
            [1278720000000, 216811028],
            [1278806400000, 216893967],
            [1278892800000, 216949853],
            [1278979200000, 217022918],
            [1279065600000, 217084535],
            [1279152000000, 217150605],
            [1279238400000, 217225795],
            [1279324800000, 217321846],
            [1279411200000, 217387997],
            [1279497600000, 217431252],
            [1279584000000, 217484213],
            [1279670400000, 217531002],
            [1279756800000, 217581231]
        ],
        name: 'howtotrainyourdragon',
        showInLegend: false,
        extra: {
            title: 'How to Train Your Dragon',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#23406D'
        },
        showlabel: false,
        color: 'rgba(35,64,109,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1147996800000, 28630324
            ],
            [1148083200000, 55947620],
            [1148169600000, 77073388],
            [1148256000000, 85885320],
            [1148342400000, 92048850],
            [1148428800000, 97176624],
            [1148515200000, 102481037],
            [1148601600000, 112697353],
            [1148688000000, 125290824],
            [1148774400000, 136512707],
            [1148860800000, 144918409],
            [1148947200000, 147841337],
            [1149033600000, 150622529],
            [1149120000000, 153355964],
            [1149206400000, 158604409],
            [1149292800000, 166753433],
            [1149379200000, 171966151],
            [1149465600000, 173644652],
            [1149552000000, 175489807],
            [1149638400000, 177133609],
            [1149724800000, 178727984],
            [1149811200000, 181776301],
            [1149897600000, 186283325],
            [1149984000000, 189171331],
            [1150070400000, 190284137],
            [1150156800000, 191379611],
            [1150243200000, 192482816],
            [1150329600000, 193501251],
            [1150416000000, 194946907],
            [1150502400000, 197059303],
            [1150588800000, 198767811],
            [1150675200000, 199424804],
            [1150761600000, 200127912],
            [1150848000000, 200824246],
            [1150934400000, 201538898],
            [1151020800000, 202636963],
            [1151107200000, 204315601],
            [1151193600000, 205589742],
            [1151280000000, 206130765],
            [1151366400000, 206660979],
            [1151452800000, 207074692],
            [1151539200000, 207492832],
            [1151625600000, 208140895],
            [1151712000000, 209010668],
            [1151798400000, 209917990],
            [1151884800000, 210653873],
            [1151971200000, 211239443],
            [1152057600000, 211573956],
            [1152144000000, 211888564],
            [1152230400000, 212273105],
            [1152316800000, 212845396],
            [1152403200000, 213210326],
            [1152489600000, 213388494],
            [1152576000000, 213586385],
            [1152662400000, 213800519],
            [1152748800000, 213991243],
            [1152835200000, 214219924],
            [1152921600000, 214621862],
            [1153008000000, 214891691],
            [1153094400000, 215015015],
            [1153180800000, 215150165],
            [1153267200000, 215273880],
            [1153353600000, 215403918],
            [1153440000000, 215524434],
            [1153526400000, 215739408],
            [1153612800000, 215874848],
            [1154044800000, 216208133],
            [1154131200000, 216312277],
            [1154217600000, 216385837],
            [1154649600000, 216620694],
            [1154736000000, 216744308],
            [1154822400000, 216838676],
            [1155254400000, 217083851],
            [1155340800000, 217178315],
            [1155427200000, 217250093],
            [1155859200000, 217416241],
            [1155945600000, 217486808],
            [1156032000000, 217536138]
        ],
        name: 'davincicode',
        showInLegend: false,
        extra: {
            title: 'The Da Vinci Code',
            genre: 'Thriller',

            mpaaRating: 'PG-13',
            imgMainColor: '#514948'
        },
        showlabel: false,
        color: 'rgba(81,73,72,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1197590400000, 13300713
            ],
            [1197676800000, 32184545],
            [1197763200000, 44307417],
            [1197849600000, 46949283],
            [1197936000000, 49449882],
            [1198022400000, 52225887],
            [1198108800000, 55866797],
            [1198195200000, 64306715],
            [1198281600000, 75192472],
            [1198368000000, 84046353],
            [1198454400000, 88437312],
            [1198540800000, 94476107],
            [1198627200000, 102854103],
            [1198713600000, 112374569],
            [1198800000000, 122674016],
            [1198886400000, 133181344],
            [1198972800000, 141404467],
            [1199059200000, 147077315],
            [1199145600000, 153632443],
            [1199232000000, 157516476],
            [1199318400000, 160737736],
            [1199404800000, 165375350],
            [1199491200000, 172158311],
            [1199577600000, 176283861],
            [1199664000000, 177045782],
            [1199750400000, 177617452],
            [1199836800000, 178137721],
            [1199923200000, 178640479],
            [1200009600000, 180658225],
            [1200096000000, 185009381],
            [1200182400000, 187943374],
            [1200268800000, 188327307],
            [1200355200000, 188671443],
            [1200441600000, 188994145],
            [1200528000000, 189380181],
            [1200614400000, 190917217],
            [1200700800000, 194059253],
            [1200787200000, 196329292],
            [1200873600000, 198813230],
            [1200960000000, 199138605],
            [1201046400000, 199367040],
            [1201132800000, 199609133],
            [1201219200000, 200477819],
            [1201305600000, 202678125],
            [1201392000000, 204121451],
            [1201478400000, 204333567],
            [1201564800000, 204494975],
            [1201651200000, 204668782],
            [1201737600000, 204839241],
            [1201824000000, 205381100],
            [1201910400000, 206866568],
            [1201996800000, 207623154],
            [1202083200000, 207747308],
            [1202169600000, 207874189],
            [1202256000000, 207985682],
            [1202342400000, 208104863],
            [1202428800000, 208405095],
            [1202515200000, 209311099],
            [1202601600000, 209927879],
            [1202688000000, 210034498],
            [1202774400000, 210108277],
            [1202860800000, 210187221],
            [1202947200000, 210265191],
            [1203033600000, 210463753],
            [1203120000000, 210953930],
            [1203206400000, 211342438],
            [1203292800000, 211812206],
            [1203379200000, 211920143],
            [1203465600000, 212017063],
            [1203552000000, 212119515],
            [1203638400000, 212261426],
            [1203724800000, 212627163],
            [1203811200000, 212867991],
            [1203897600000, 212904096],
            [1203984000000, 212939070],
            [1204070400000, 212974736],
            [1204156800000, 213013422],
            [1204243200000, 213140039],
            [1204329600000, 213461928],
            [1204416000000, 213675858],
            [1204502400000, 213736112],
            [1204588800000, 213796658],
            [1204675200000, 213846468],
            [1204761600000, 213902904],
            [1204848000000, 214015605],
            [1204934400000, 214272992],
            [1205020800000, 214434383],
            [1205107200000, 214486974],
            [1205193600000, 214553620],
            [1205280000000, 214618125],
            [1205366400000, 214684806],
            [1205452800000, 214817050],
            [1205539200000, 215032663],
            [1205625600000, 215163603],
            [1205712000000, 215209142],
            [1205798400000, 215262983],
            [1205884800000, 215320491],
            [1205971200000, 215388440],
            [1206057600000, 215536913],
            [1206144000000, 215681198],
            [1206230400000, 215760497],
            [1206316800000, 215843787],
            [1206403200000, 215912497],
            [1206489600000, 215977612],
            [1206576000000, 216050880],
            [1206662400000, 216185587],
            [1206748800000, 216383894],
            [1206835200000, 216501860],
            [1206921600000, 216533749],
            [1207008000000, 216567559],
            [1207094400000, 216597972],
            [1207180800000, 216631294],
            [1207267200000, 216698390],
            [1207353600000, 216810119],
            [1207440000000, 216873487],
            [1207526400000, 216888959],
            [1207612800000, 216905793],
            [1207699200000, 216920501],
            [1207785600000, 216935984],
            [1207872000000, 216971045],
            [1207958400000, 217037900],
            [1208044800000, 217075500],
            [1208131200000, 217082177],
            [1208217600000, 217088859],
            [1208304000000, 217094600],
            [1208390400000, 217101143],
            [1208476800000, 217119108],
            [1208563200000, 217153139],
            [1208649600000, 217172612],
            [1208736000000, 217176264],
            [1208822400000, 217180143],
            [1208908800000, 217183977],
            [1208995200000, 217187835],
            [1209081600000, 217200526],
            [1209168000000, 217222246],
            [1209254400000, 217235428],
            [1209340800000, 217238175],
            [1209427200000, 217241645],
            [1209513600000, 217245159],
            [1209600000000, 217248792],
            [1209686400000, 217253331],
            [1209772800000, 217264884],
            [1209859200000, 217272684],
            [1209945600000, 217273702],
            [1210032000000, 217274760],
            [1210118400000, 217275958],
            [1210204800000, 217277500],
            [1210291200000, 217280433],
            [1210377600000, 217287104],
            [1210464000000, 217292442],
            [1210550400000, 217293218],
            [1210636800000, 217294056],
            [1210723200000, 217294836],
            [1210809600000, 217295846],
            [1210896000000, 217298702],
            [1210982400000, 217304584],
            [1211068800000, 217308635],
            [1211155200000, 217311187],
            [1211241600000, 217311794],
            [1211328000000, 217312599],
            [1211414400000, 217313244]
        ],
        name: 'alvinandthechipmunks',
        showInLegend: false,
        extra: {
            title: 'Alvin and the Chipmunks',
            genre: 'Family Comedy',

            mpaaRating: 'PG',
            imgMainColor: '#AC5945'
        },
        showlabel: false,
        color: 'rgba(172,89,69,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                901238400000, 9757046
            ],
            [901324800000, 20963531],
            [901411200000, 30576104],
            [901497600000, 35807573],
            [901584000000, 40843565],
            [901670400000, 45416614],
            [901756800000, 49760360],
            [901843200000, 56719609],
            [901929600000, 65955209],
            [902016000000, 73362161],
            [902102400000, 76773667],
            [902188800000, 80182292],
            [902275200000, 83325520],
            [902361600000, 86372977],
            [902448000000, 91244417],
            [902534400000, 98203617],
            [902620800000, 103770977],
            [902707200000, 106178264],
            [902793600000, 108633288],
            [902880000000, 110845129],
            [902966400000, 112877875],
            [903052800000, 116469298],
            [903139200000, 122024466],
            [903225600000, 126035694],
            [903312000000, 127787961],
            [903398400000, 129639148],
            [903484800000, 131180171],
            [903571200000, 132605993],
            [903657600000, 135288297],
            [903744000000, 139599946],
            [903830400000, 142748038],
            [903916800000, 143858282],
            [904003200000, 145132304],
            [904089600000, 146194502],
            [904176000000, 147196648],
            [904262400000, 149387054],
            [904348800000, 153088157],
            [904435200000, 155289398],
            [904521600000, 156011847],
            [904608000000, 156836889],
            [904694400000, 157551218],
            [904780800000, 158246500],
            [904867200000, 159851634],
            [904953600000, 162485850],
            [905040000000, 165036969],
            [905126400000, 167071590],
            [905212800000, 167601405],
            [905299200000, 168101447],
            [905385600000, 168572490],
            [905472000000, 169786512],
            [905558400000, 171995925],
            [905644800000, 173076992],
            [905731200000, 173422101],
            [905817600000, 173898235],
            [905904000000, 174283704],
            [905990400000, 174686395],
            [906076800000, 175576037],
            [906163200000, 177210310],
            [906249600000, 178091556],
            [906336000000, 178375035],
            [906422400000, 178752134],
            [906508800000, 179035612],
            [906595200000, 179307000],
            [906681600000, 179970826],
            [906768000000, 181204469],
            [906854400000, 181818565],
            [906940800000, 182000990],
            [907027200000, 182256469],
            [907113600000, 182487117],
            [907200000000, 182667745],
            [907286400000, 183106027],
            [907372800000, 183925638],
            [907459200000, 184341779],
            [907545600000, 184472855],
            [907632000000, 184642269],
            [907718400000, 184794336],
            [907804800000, 184957955],
            [907891200000, 185294337],
            [907977600000, 185898625],
            [908064000000, 186258536],
            [908150400000, 186445958],
            [908236800000, 186570076],
            [908323200000, 186691052],
            [908409600000, 186816743],
            [908496000000, 187060762],
            [908582400000, 187493374],
            [908668800000, 187722738],
            [908755200000, 187798160],
            [908841600000, 187884071],
            [908928000000, 187969273],
            [909014400000, 188066420],
            [909100800000, 188267729],
            [909187200000, 188619593],
            [909273600000, 188807215],
            [909360000000, 188864326],
            [909446400000, 188941461],
            [909532800000, 189016807],
            [909619200000, 189089818],
            [909705600000, 189262281],
            [909792000000, 189490492],
            [909878400000, 189658496],
            [909964800000, 189714540],
            [910051200000, 189786187],
            [910137600000, 189853095],
            [910224000000, 189924950],
            [910310400000, 190045592],
            [910396800000, 190266873],
            [910483200000, 190373184],
            [910569600000, 190410059],
            [910656000000, 190471202],
            [910742400000, 190584620],
            [910828800000, 190639415],
            [910915200000, 190641335],
            [911001600000, 190644700],
            [911088000000, 190649028],
            [911174400000, 190651052],
            [911260800000, 190652955],
            [911347200000, 190655305],
            [911433600000, 190657057],
            [918172800000, 191926749],
            [918259200000, 193557993],
            [918345600000, 194634361],
            [918432000000, 194928728],
            [918518400000, 195298792],
            [918604800000, 195638201],
            [918691200000, 195963182],
            [918777600000, 196719583],
            [918864000000, 198107658],
            [918950400000, 199323269],
            [919036800000, 199915673],
            [919123200000, 200218052],
            [919209600000, 200467084],
            [919296000000, 200734375],
            [919382400000, 201306424],
            [919468800000, 202444389],
            [919555200000, 203151532],
            [919641600000, 203340004],
            [919728000000, 203554793],
            [919814400000, 203743196],
            [919900800000, 203929588],
            [919987200000, 204330811],
            [920073600000, 205083777],
            [920160000000, 205564906],
            [920246400000, 205692811],
            [920332800000, 205853113],
            [920419200000, 205988806],
            [920505600000, 206138843],
            [920592000000, 206418957],
            [920678400000, 206975365],
            [920764800000, 207316586],
            [920851200000, 207428189],
            [920937600000, 207561991],
            [921024000000, 207686320],
            [921110400000, 207812024],
            [921196800000, 208027430],
            [921283200000, 208414342],
            [921369600000, 208670649],
            [921456000000, 208780928],
            [921542400000, 208911137],
            [921628800000, 209012899],
            [921715200000, 209153127],
            [921801600000, 209423230],
            [921888000000, 209926934],
            [921974400000, 210213533],
            [922060800000, 210349567],
            [922147200000, 210490275],
            [922233600000, 210605705],
            [922320000000, 210727368],
            [922406400000, 210982970],
            [922492800000, 211415689],
            [922579200000, 211697803],
            [922665600000, 211782702],
            [922752000000, 211893135],
            [922838400000, 211987443],
            [922924800000, 212118047],
            [923011200000, 212337259],
            [923097600000, 212624660],
            [923184000000, 212823939],
            [923270400000, 212899658],
            [923356800000, 212973157],
            [923443200000, 213041952],
            [923529600000, 213108365],
            [923616000000, 213232456],
            [923702400000, 213444062],
            [923788800000, 213563877],
            [923875200000, 213597488],
            [923961600000, 213639401],
            [924048000000, 213675113],
            [924134400000, 213716544],
            [924220800000, 213854390],
            [924307200000, 214105602],
            [924393600000, 214275406],
            [924480000000, 214332819],
            [924566400000, 214398030],
            [924652800000, 214458221],
            [924739200000, 214523028],
            [924825600000, 214647447],
            [924912000000, 214839070],
            [924998400000, 214954781],
            [925084800000, 214997895],
            [925171200000, 215049097],
            [925257600000, 215091973],
            [925344000000, 215137494],
            [925430400000, 215218158],
            [925516800000, 215336560],
            [925603200000, 215406153],
            [925689600000, 215431494],
            [925776000000, 215460212],
            [925862400000, 215492358],
            [925948800000, 215526073],
            [926035200000, 215577786],
            [926121600000, 215659565],
            [926208000000, 215708216],
            [926294400000, 215729894],
            [926380800000, 215755678],
            [926467200000, 215778892],
            [926553600000, 215803654],
            [926640000000, 215847356],
            [926726400000, 215909145],
            [926812800000, 215947236],
            [926899200000, 215966151],
            [926985600000, 215984643],
            [927072000000, 215997785],
            [927158400000, 216012924],
            [927244800000, 216038568],
            [927331200000, 216082280],
            [927417600000, 216118802],
            [927504000000, 216134597],
            [927590400000, 216146731],
            [927676800000, 216157930],
            [927763200000, 216172633]
        ],
        name: 'savingprivateryan',
        showInLegend: false,
        extra: {
            title: 'Saving Private Ryan',
            genre: 'War',

            mpaaRating: 'R',
            imgMainColor: '#6E6B6A'
        },
        showlabel: true,
        color: 'rgba(110,107,106,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1339113600000, 20650819
            ],
            [1339200000000, 43220011],
            [1339286400000, 60316738],
            [1339372800000, 66645606],
            [1339459200000, 73785626],
            [1339545600000, 79539287],
            [1339632000000, 84950532],
            [1339718400000, 94982946],
            [1339804800000, 108330034],
            [1339891200000, 119006006],
            [1339977600000, 123386851],
            [1340064000000, 128419137],
            [1340150400000, 132930142],
            [1340236800000, 137373722],
            [1340323200000, 143555098],
            [1340409600000, 151318394],
            [1340496000000, 157086037],
            [1340582400000, 160149723],
            [1340668800000, 163352301],
            [1340755200000, 165775150],
            [1340841600000, 168196522],
            [1340928000000, 171806783],
            [1341014400000, 176461006],
            [1341100800000, 180036798],
            [1341187200000, 182024929],
            [1341273600000, 184187834],
            [1341360000000, 186551082],
            [1341446400000, 188384436],
            [1341532800000, 190747196],
            [1341619200000, 193808216],
            [1341705600000, 195905126],
            [1341792000000, 196847297],
            [1341878400000, 198129143],
            [1341964800000, 199196845],
            [1342051200000, 200231722],
            [1342137600000, 201299284],
            [1342224000000, 202757287],
            [1342310400000, 203901397],
            [1342396800000, 204401562],
            [1342483200000, 205141630],
            [1342569600000, 205729986],
            [1342656000000, 206275255],
            [1342742400000, 206732332],
            [1342828800000, 207237618],
            [1342915200000, 207626201],
            [1343001600000, 207847051],
            [1343088000000, 208147843],
            [1343174400000, 208372072],
            [1343260800000, 208670400],
            [1343347200000, 208936504],
            [1343433600000, 209290414],
            [1343520000000, 209570970],
            [1343606400000, 209709815],
            [1343692800000, 209903246],
            [1343779200000, 210093698],
            [1343865600000, 210264830],
            [1343952000000, 210425804],
            [1344038400000, 210649358],
            [1344124800000, 210852342],
            [1344211200000, 210954103],
            [1344297600000, 211069146],
            [1344384000000, 211160931],
            [1344470400000, 211264764],
            [1344556800000, 211399009],
            [1344643200000, 211570376],
            [1344729600000, 211686199],
            [1344816000000, 211750828],
            [1344902400000, 211849322],
            [1344988800000, 211917400],
            [1345075200000, 211976677],
            [1345161600000, 212181476],
            [1345248000000, 212471974],
            [1345334400000, 212684700],
            [1345420800000, 212779251],
            [1345507200000, 212903360],
            [1345593600000, 212994570],
            [1345680000000, 213083261],
            [1345766400000, 213251097],
            [1345852800000, 213512875],
            [1345939200000, 213689062],
            [1346025600000, 213742849],
            [1346112000000, 213808279],
            [1346198400000, 213858920],
            [1346284800000, 213909449],
            [1346371200000, 214042638],
            [1346457600000, 214292546],
            [1346544000000, 214539658],
            [1346630400000, 214772538],
            [1346716800000, 214813868],
            [1346803200000, 214837610],
            [1346889600000, 214859182],
            [1346976000000, 214938288],
            [1347062400000, 215129467],
            [1347148800000, 215240165],
            [1347235200000, 215257009],
            [1347321600000, 215278335],
            [1347408000000, 215296854],
            [1347494400000, 215315228],
            [1347580800000, 215380730],
            [1347667200000, 215519392],
            [1347753600000, 215604243],
            [1347840000000, 215622762],
            [1347926400000, 215641011],
            [1348012800000, 215657204],
            [1348099200000, 215672792],
            [1348185600000, 215723281],
            [1348272000000, 215830420],
            [1348358400000, 215896451],
            [1348444800000, 215907001],
            [1348531200000, 215920704],
            [1348617600000, 215936226],
            [1348704000000, 215947174],
            [1348790400000, 215980658],
            [1348876800000, 216051551],
            [1348963200000, 216096344],
            [1349049600000, 216103455],
            [1349136000000, 216114430],
            [1349222400000, 216122874],
            [1349308800000, 216132292],
            [1349395200000, 216155517],
            [1349481600000, 216201419],
            [1349568000000, 216233754],
            [1349654400000, 216253387],
            [1349740800000, 216262769],
            [1349827200000, 216270420],
            [1349913600000, 216280108],
            [1350000000000, 216299808],
            [1350086400000, 216339528],
            [1350172800000, 216366733],
            [1350259200000, 216372183],
            [1350345600000, 216377089],
            [1350432000000, 216382258],
            [1350518400000, 216391482]
        ],
        name: 'madagascar3',
        showInLegend: false,
        extra: {
            title: 'Madagascar 3: Europe´s Most Wanted',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#3E83A2'
        },
        showlabel: false,
        color: 'rgba(62,131,162,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1212710400000, 20303918
            ],
            [1212796800000, 42953856],
            [1212883200000, 60239130],
            [1212969600000, 66555637],
            [1213056000000, 72620491],
            [1213142400000, 78285995],
            [1213228800000, 83677338],
            [1213315200000, 93713503],
            [1213401600000, 106744265],
            [1213488000000, 117289932],
            [1213574400000, 121450707],
            [1213660800000, 125599476],
            [1213747200000, 129790915],
            [1213833600000, 133896159],
            [1213920000000, 140160897],
            [1214006400000, 148718256],
            [1214092800000, 155830875],
            [1214179200000, 158861401],
            [1214265600000, 161736569],
            [1214352000000, 164492490],
            [1214438400000, 167584693],
            [1214524800000, 171024747],
            [1214611200000, 175626234],
            [1214697600000, 179276754],
            [1214784000000, 181077324],
            [1214870400000, 182662882],
            [1214956800000, 184050717],
            [1215043200000, 185903232],
            [1215129600000, 187909019],
            [1215216000000, 191007785],
            [1215302400000, 193221867],
            [1215388800000, 194320130],
            [1215475200000, 195488320],
            [1215561600000, 196680294],
            [1215648000000, 197742899],
            [1215734400000, 199009771],
            [1215820800000, 200762970],
            [1215907200000, 202154311],
            [1215993600000, 202838838],
            [1216080000000, 203500614],
            [1216166400000, 204143653],
            [1216252800000, 204755527],
            [1216339200000, 205277749],
            [1216425600000, 206003042],
            [1216512000000, 206616381],
            [1216598400000, 206898748],
            [1216684800000, 207221026],
            [1216771200000, 207575941],
            [1216857600000, 207941754],
            [1216944000000, 208231057],
            [1217030400000, 208640703],
            [1217116800000, 208997686],
            [1217203200000, 209159482],
            [1217289600000, 209340795],
            [1217376000000, 209591374],
            [1217462400000, 209854538],
            [1217548800000, 210021338],
            [1217635200000, 210287421],
            [1217721600000, 210480901],
            [1217808000000, 210587971],
            [1217894400000, 210699068],
            [1217980800000, 210791339],
            [1218067200000, 210882410],
            [1218153600000, 211020369],
            [1218240000000, 211211834],
            [1218326400000, 211355837],
            [1218412800000, 211430051],
            [1218499200000, 211507723],
            [1218585600000, 211577666],
            [1218672000000, 211650259],
            [1218758400000, 211738129],
            [1218844800000, 211855396],
            [1218931200000, 211933936],
            [1219017600000, 211976579],
            [1219104000000, 212024264],
            [1219190400000, 212065880],
            [1219276800000, 212105817],
            [1219363200000, 212269059],
            [1219449600000, 212518045],
            [1219536000000, 212685098],
            [1219622400000, 212751705],
            [1219708800000, 212821962],
            [1219795200000, 212888768],
            [1219881600000, 212958340],
            [1219968000000, 213112528],
            [1220054400000, 213356567],
            [1220140800000, 213591364],
            [1220227200000, 213762199],
            [1220313600000, 213792690],
            [1220400000000, 213816074],
            [1220486400000, 213839472],
            [1220572800000, 213929542],
            [1220659200000, 214123052],
            [1220745600000, 214227690],
            [1220832000000, 214245208],
            [1220918400000, 214265067],
            [1221004800000, 214282408],
            [1221091200000, 214301367],
            [1221177600000, 214372150],
            [1221264000000, 214535594],
            [1221350400000, 214637586],
            [1221436800000, 214653326],
            [1221523200000, 214669830],
            [1221609600000, 214685315],
            [1221696000000, 214700999],
            [1221782400000, 214763476],
            [1221868800000, 214882144],
            [1221955200000, 214949523],
            [1222041600000, 214962763],
            [1222128000000, 214975407],
            [1222214400000, 214987763],
            [1222300800000, 215000431],
            [1222387200000, 215051705],
            [1222473600000, 215151310],
            [1222560000000, 215207213],
            [1222646400000, 215216472],
            [1222732800000, 215227613],
            [1222819200000, 215238232],
            [1222905600000, 215251220],
            [1222992000000, 215288122],
            [1223078400000, 215355833],
            [1223164800000, 215395021],
            [1223251200000, 215404380],
            [1223337600000, 215413485],
            [1223424000000, 215422559],
            [1223510400000, 215434591]
        ],
        name: 'kungfupanda',
        showInLegend: false,
        extra: {
            title: 'Kung Fu Panda',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#954D2B'
        },
        showlabel: false,
        color: 'rgba(149,77,43,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                959126400000, 12516528
            ],
            [959212800000, 21002839],
            [959299200000, 37490174],
            [959385600000, 59611480],
            [959472000000, 78848136],
            [959558400000, 91819054],
            [959644800000, 96344357],
            [959731200000, 100080777],
            [959817600000, 103703888],
            [959904000000, 111620538],
            [959990400000, 123697584],
            [960076800000, 130719917],
            [960163200000, 133427542],
            [960249600000, 136374865],
            [960336000000, 138508339],
            [960422400000, 140837326],
            [960508800000, 145711314],
            [960595200000, 153383031],
            [960681600000, 158068698],
            [960768000000, 159905346],
            [960854400000, 161823800],
            [960940800000, 163467025],
            [961027200000, 165219236],
            [961113600000, 168337991],
            [961200000000, 173130946],
            [961286400000, 176581244],
            [961372800000, 177658590],
            [961459200000, 178919924],
            [961545600000, 180104244],
            [961632000000, 181301371],
            [961718400000, 183524818],
            [961804800000, 186848478],
            [961891200000, 188889787],
            [961977600000, 189741613],
            [962064000000, 190670178],
            [962150400000, 191390473],
            [962236800000, 192174463],
            [962323200000, 193540370],
            [962409600000, 195403260],
            [962496000000, 197083711],
            [962582400000, 198631933],
            [962668800000, 199706573],
            [962755200000, 200220997],
            [962841600000, 200726110],
            [962928000000, 201714605],
            [963014400000, 203126808],
            [963100800000, 204013487],
            [963187200000, 204371905],
            [963273600000, 204743357],
            [963360000000, 205049027],
            [963446400000, 205357463],
            [963532800000, 206041134],
            [963619200000, 207056943],
            [963705600000, 207669110],
            [963792000000, 207929591],
            [963878400000, 208211353],
            [963964800000, 208429739],
            [964051200000, 208627595],
            [964137600000, 209002046],
            [964224000000, 209568780],
            [964310400000, 209901228],
            [964396800000, 210074879],
            [964483200000, 210215736],
            [964569600000, 210346120],
            [964656000000, 210433160],
            [964742400000, 210686464],
            [964828800000, 211051623],
            [964915200000, 211273842],
            [965001600000, 211366818],
            [965088000000, 211482624],
            [965174400000, 211569518],
            [965260800000, 211655313],
            [965520000000, 212126649],
            [965606400000, 212182900],
            [965692800000, 212240705],
            [965779200000, 212287723],
            [965865600000, 212334866]
        ],
        name: 'mi2',
        showInLegend: false,
        extra: {
            title: 'Mission: Impossible II',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#884D28'
        },
        showlabel: false,
        color: 'rgba(136,77,40,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1051833600000, 31247979
            ],
            [1051920000000, 63248608],
            [1052006400000, 85558731],
            [1052092800000, 92108448],
            [1052179200000, 98146251],
            [1052265600000, 103042715],
            [1052352000000, 107644861],
            [1052438400000, 120017293],
            [1052524800000, 137125638],
            [1052611200000, 147677021],
            [1052697600000, 150679799],
            [1052784000000, 153265141],
            [1052870400000, 155303395],
            [1052956800000, 156870738],
            [1053043200000, 161875285],
            [1053129600000, 169360328],
            [1053216000000, 174172025],
            [1053302400000, 175534022],
            [1053388800000, 176641710],
            [1053475200000, 177711514],
            [1053561600000, 178960445],
            [1053648000000, 181643100],
            [1053734400000, 185863128],
            [1053820800000, 189459127],
            [1053907200000, 192197843],
            [1053993600000, 192918711],
            [1054080000000, 193587076],
            [1054166400000, 194268094],
            [1054252800000, 195634744],
            [1054339200000, 197870931],
            [1054425600000, 199365037],
            [1054512000000, 199817014],
            [1054598400000, 200322298],
            [1054684800000, 200782385],
            [1054771200000, 201256659],
            [1054857600000, 202100114],
            [1054944000000, 203406492],
            [1055030400000, 204263302],
            [1055116800000, 204569713],
            [1055203200000, 204896236],
            [1055289600000, 205211345],
            [1055376000000, 205565070],
            [1055462400000, 206047293],
            [1055548800000, 206736446],
            [1055635200000, 207305599],
            [1055721600000, 207526859],
            [1055808000000, 207768800],
            [1055894400000, 208024566],
            [1055980800000, 208277663],
            [1056067200000, 208699017],
            [1056153600000, 209247141],
            [1056240000000, 209628659],
            [1056326400000, 209805709],
            [1056412800000, 210000387],
            [1056499200000, 210184251],
            [1056585600000, 210385710],
            [1056672000000, 210650181],
            [1056758400000, 211025730],
            [1056844800000, 211317906],
            [1056931200000, 211487266],
            [1057017600000, 211645362],
            [1057104000000, 211779922],
            [1057190400000, 211953685],
            [1057276800000, 212229037],
            [1057363200000, 212721720],
            [1057449600000, 213097409],
            [1057536000000, 213276306],
            [1057622400000, 213462735],
            [1057708800000, 213557363],
            [1057795200000, 213653663],
            [1057881600000, 213719941],
            [1057968000000, 213810168],
            [1058054400000, 213871302],
            [1058140800000, 213901126],
            [1058227200000, 213939373],
            [1058313600000, 213974014],
            [1058400000000, 214007670],
            [1058486400000, 214057755],
            [1058572800000, 214127373],
            [1058659200000, 214181675],
            [1058745600000, 214208802],
            [1058832000000, 214238718],
            [1058918400000, 214267149],
            [1059004800000, 214293546],
            [1059091200000, 214326940],
            [1059177600000, 214374026],
            [1059264000000, 214411695],
            [1059350400000, 214431621],
            [1059436800000, 214451177],
            [1059523200000, 214470238],
            [1059609600000, 214488742],
            [1059696000000, 214517328],
            [1059782400000, 214558492],
            [1059868800000, 214591423],
            [1059955200000, 214607561],
            [1060041600000, 214624789],
            [1060128000000, 214640156],
            [1060214400000, 214655501],
            [1060300800000, 214674959],
            [1060387200000, 214705897],
            [1060473600000, 214728327],
            [1060560000000, 214739454],
            [1060646400000, 214751665],
            [1060732800000, 214761370],
            [1060819200000, 214771767],
            [1060905600000, 214782549],
            [1060992000000, 214800987],
            [1061078400000, 214813155],
            [1061164800000, 214817711],
            [1061251200000, 214824244],
            [1061337600000, 214830467],
            [1061424000000, 214836193],
            [1061510400000, 214845506],
            [1061596800000, 214859699],
            [1061683200000, 214869324],
            [1061769600000, 214873729],
            [1061856000000, 214877849],
            [1061942400000, 214881426],
            [1062028800000, 214884711],
            [1062115200000, 214888671],
            [1062201600000, 214895183],
            [1062288000000, 214901352],
            [1062374400000, 214907213],
            [1062460800000, 214909261],
            [1062547200000, 214910822],
            [1062633600000, 214912467],
            [1062720000000, 214917466],
            [1062806400000, 214925760],
            [1062892800000, 214930077],
            [1062979200000, 214932011],
            [1063065600000, 214933996],
            [1063152000000, 214935344],
            [1063238400000, 214937510],
            [1063324800000, 214939340],
            [1063411200000, 214942552],
            [1063497600000, 214944062],
            [1063584000000, 214944526],
            [1063670400000, 214945233],
            [1063756800000, 214945648],
            [1063843200000, 214946072]
        ],
        name: 'x2',
        showInLegend: false,
        extra: {
            title: 'X2: X-Men United',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#766F73'
        },
        showlabel: false,
        color: 'rgba(118,111,115,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1330646400000, 17526300
            ],
            [1330732800000, 48812610],
            [1330819200000, 70217070],
            [1330905600000, 73702820],
            [1330992000000, 77377730],
            [1331078400000, 79988855],
            [1331164800000, 82878830],
            [1331251200000, 92449860],
            [1331337600000, 110355740],
            [1331424000000, 121724850],
            [1331510400000, 125151510],
            [1331596800000, 129067560],
            [1331683200000, 132194010],
            [1331769600000, 135623015],
            [1331856000000, 142407215],
            [1331942400000, 151999320],
            [1332028800000, 158387775],
            [1332115200000, 159838840],
            [1332201600000, 161459510],
            [1332288000000, 162816635],
            [1332374400000, 164230010],
            [1332460800000, 167465770],
            [1332547200000, 173385740],
            [1332633600000, 177412055],
            [1332720000000, 178423230],
            [1332806400000, 179543830],
            [1332892800000, 180499855],
            [1332979200000, 181547800],
            [1333065600000, 183620440],
            [1333152000000, 187161885],
            [1333238400000, 189332445],
            [1333324800000, 190133010],
            [1333411200000, 191144850],
            [1333497600000, 192036600],
            [1333584000000, 193174350],
            [1333670400000, 195426600],
            [1333756800000, 197138310],
            [1333843200000, 198204375],
            [1333929600000, 199210380],
            [1334016000000, 199991160],
            [1334102400000, 200786955],
            [1334188800000, 201462630],
            [1334275200000, 202328550],
            [1334361600000, 203648585],
            [1334448000000, 204513915],
            [1334534400000, 204693435],
            [1334620800000, 204883515],
            [1334707200000, 205063120],
            [1334793600000, 205253265],
            [1334880000000, 205649015],
            [1334966400000, 206488005],
            [1335052800000, 207152865],
            [1335139200000, 207263850],
            [1335225600000, 207382575],
            [1335312000000, 207477555],
            [1335398400000, 207587680],
            [1335484800000, 207781940],
            [1335571200000, 208184095],
            [1335657600000, 208435750],
            [1335744000000, 208479900],
            [1335830400000, 208528465],
            [1335916800000, 208568200],
            [1336003200000, 208607645],
            [1336089600000, 208714450],
            [1336176000000, 208909825],
            [1336262400000, 209034865],
            [1336348800000, 209066125],
            [1336435200000, 209099990],
            [1336521600000, 209128415],
            [1336608000000, 209159690],
            [1336694400000, 209266615],
            [1336780800000, 209446340],
            [1336867200000, 209591935],
            [1336953600000, 209628335],
            [1337040000000, 209664830],
            [1337126400000, 209699750],
            [1337212800000, 209732730],
            [1337299200000, 209850225],
            [1337385600000, 210051095],
            [1337472000000, 210191325],
            [1337558400000, 210238700],
            [1337644800000, 210280390],
            [1337731200000, 210318290],
            [1337817600000, 210363770],
            [1337904000000, 210486620],
            [1337990400000, 210685505],
            [1338076800000, 210839555],
            [1338163200000, 210985805],
            [1338249600000, 211040360],
            [1338336000000, 211089110],
            [1338422400000, 211145660],
            [1338508800000, 211248035],
            [1338595200000, 211389785],
            [1338681600000, 211485860],
            [1338768000000, 211533110],
            [1338854400000, 211588235],
            [1338940800000, 211638680],
            [1339027200000, 211690655],
            [1339113600000, 211802310],
            [1339200000000, 211942960],
            [1339286400000, 212028510],
            [1339372800000, 212073460],
            [1339459200000, 212128420],
            [1339545600000, 212177580],
            [1339632000000, 212229870],
            [1339718400000, 212317125],
            [1339804800000, 212421000],
            [1339891200000, 212490250],
            [1339977600000, 212533185],
            [1340064000000, 212589970],
            [1340150400000, 212641215],
            [1340236800000, 212695350],
            [1340323200000, 212762040],
            [1340409600000, 212842775],
            [1340496000000, 212901275],
            [1340582400000, 212932865],
            [1340668800000, 212979650],
            [1340755200000, 213021745],
            [1340841600000, 213063795],
            [1340928000000, 213113285],
            [1341014400000, 213171865],
            [1341100800000, 213218330],
            [1341187200000, 213248630],
            [1341273600000, 213287010],
            [1341360000000, 213324380],
            [1341446400000, 213361715],
            [1341532800000, 213404590],
            [1341619200000, 213456215],
            [1341705600000, 213494660],
            [1341792000000, 213515665],
            [1341878400000, 213546290],
            [1341964800000, 213574285],
            [1342051200000, 213602260],
            [1342137600000, 213650980],
            [1342224000000, 213708940],
            [1342310400000, 213745895],
            [1342396800000, 213767735],
            [1342483200000, 213801340],
            [1342569600000, 213830740],
            [1342656000000, 213863500],
            [1342742400000, 213895230],
            [1342828800000, 213926125],
            [1342915200000, 213949505],
            [1343001600000, 213964535],
            [1343088000000, 213988750],
            [1343174400000, 214007955],
            [1343260800000, 214030500]
        ],
        name: 'lorax',
        showInLegend: false,
        extra: {
            title: 'Dr. Seuss´ The Lorax',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#DC913B'
        },
        showlabel: false,
        color: 'rgba(220,145,59,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1027555200000, 3553719
            ],
            [1027641600000, 30006070],
            [1027728000000, 55650432],
            [1027814400000, 76624907],
            [1027900800000, 86825146],
            [1027987200000, 95989198],
            [1028073600000, 103634461],
            [1028160000000, 110559220],
            [1028246400000, 120884549],
            [1028332800000, 132434480],
            [1028419200000, 141678328],
            [1028505600000, 145754397],
            [1028592000000, 149364851],
            [1028678400000, 152261247],
            [1028764800000, 154720343],
            [1028851200000, 158902435],
            [1028937600000, 164006189],
            [1029024000000, 167779791],
            [1029110400000, 169509791],
            [1029196800000, 171414791],
            [1029283200000, 173064791],
            [1029369600000, 175167481],
            [1029456000000, 177886417],
            [1029542400000, 181442757],
            [1029628800000, 183897219],
            [1029715200000, 185050219],
            [1029801600000, 186313219],
            [1029888000000, 187304219],
            [1029974400000, 188332837],
            [1030060800000, 190034717],
            [1030147200000, 192377622],
            [1030233600000, 193875866],
            [1030320000000, 194500866],
            [1030406400000, 195200866],
            [1030492800000, 195815866],
            [1030579200000, 196401834],
            [1030665600000, 197816898],
            [1030752000000, 199842665],
            [1030838400000, 201939245],
            [1030924800000, 203471220],
            [1031011200000, 203821220],
            [1031097600000, 204101220],
            [1031184000000, 197816898],
            [1031270400000, 198571898],
            [1031356800000, 199846898],
            [1031443200000, 207051562],
            [1031529600000, 207216562],
            [1031616000000, 207428562],
            [1031702400000, 207611562],
            [1031788800000, 207780000],
            [1031875200000, 208275000],
            [1031961600000, 210484700],
            [1032048000000, 209634700],
            [1032134400000, 209792700],
            [1032220800000, 209921700],
            [1032307200000, 210038700],
            [1032393600000, 210150000]
        ],
        name: 'austinpowers3',
        showInLegend: false,
        extra: {
            title: 'Austin Powers in Goldmember',
            genre: 'Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#6B7575'
        },
        showlabel: false,
        color: 'rgba(107,117,117,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1173398400000, 28106731
            ],
            [1173484800000, 52787575],
            [1173571200000, 70885301],
            [1173657600000, 78502504],
            [1173744000000, 85017803],
            [1173830400000, 90840175],
            [1173916800000, 96288328],
            [1174003200000, 106360658],
            [1174089600000, 118918100],
            [1174176000000, 129165656],
            [1174262400000, 132620872],
            [1174348800000, 135939283],
            [1174435200000, 138927393],
            [1174521600000, 141843655],
            [1174608000000, 147859425],
            [1174694400000, 156195649],
            [1174780800000, 161706146],
            [1174867200000, 163524393],
            [1174953600000, 165231713],
            [1175040000000, 166844117],
            [1175126400000, 168507482],
            [1175212800000, 171840759],
            [1175299200000, 176488891],
            [1175385600000, 179941919],
            [1175472000000, 181036176],
            [1175558400000, 182194337],
            [1175644800000, 183489736],
            [1175731200000, 185034077],
            [1175817600000, 187940468],
            [1175904000000, 191300961],
            [1175990400000, 193402459],
            [1176076800000, 194380900],
            [1176163200000, 195112060],
            [1176249600000, 195799408],
            [1176336000000, 196510780],
            [1176422400000, 197763548],
            [1176508800000, 199707467],
            [1176595200000, 200965135],
            [1176681600000, 201352418],
            [1176768000000, 201704585],
            [1176854400000, 202063629],
            [1176940800000, 202392025],
            [1177027200000, 203034519],
            [1177113600000, 204011855],
            [1177200000000, 204644259],
            [1177286400000, 204855627],
            [1177372800000, 205068107],
            [1177459200000, 205284199],
            [1177545600000, 205510419],
            [1177632000000, 205909135],
            [1177718400000, 206513056],
            [1177804800000, 206897885],
            [1177891200000, 207040365],
            [1177977600000, 207177453],
            [1178064000000, 207320869],
            [1178150400000, 207451729],
            [1178236800000, 207584729],
            [1178323200000, 207747597],
            [1178409600000, 207871046],
            [1178496000000, 207916821],
            [1178582400000, 207963475],
            [1178668800000, 208012928],
            [1178755200000, 208063965],
            [1178841600000, 208139642],
            [1178928000000, 208255879],
            [1179014400000, 208323517],
            [1179100800000, 208353598],
            [1179187200000, 208384660],
            [1179273600000, 208417166],
            [1179360000000, 208448832],
            [1179446400000, 208505942],
            [1179532800000, 208590917],
            [1179619200000, 208656942],
            [1179705600000, 208684519],
            [1179792000000, 208707746],
            [1179878400000, 208729043],
            [1179964800000, 208748855],
            [1180051200000, 208839615],
            [1180137600000, 208965880],
            [1180224000000, 209094683],
            [1180310400000, 209184269],
            [1180396800000, 209228547],
            [1180483200000, 209271049],
            [1180569600000, 209313972],
            [1180656000000, 209388749],
            [1180742400000, 209491153],
            [1180828800000, 209577214],
            [1180915200000, 209611055],
            [1181001600000, 209645906],
            [1181088000000, 209682182],
            [1181174400000, 209716307],
            [1181260800000, 209792930],
            [1181347200000, 209900237],
            [1181433600000, 209960532],
            [1181520000000, 209992255],
            [1181606400000, 210022571],
            [1181692800000, 210055261],
            [1181779200000, 210086967],
            [1181865600000, 210134234],
            [1181952000000, 210194632],
            [1182038400000, 210234156],
            [1182124800000, 210250922],
            [1182211200000, 210267049],
            [1182297600000, 210282555],
            [1182384000000, 210300035],
            [1182470400000, 210333213],
            [1182556800000, 210377083],
            [1182643200000, 210403344],
            [1182729600000, 210416610],
            [1182816000000, 210427639],
            [1182902400000, 210436894],
            [1182988800000, 210447211],
            [1183075200000, 210467806],
            [1183161600000, 210498518],
            [1183248000000, 210515491],
            [1183334400000, 210524305],
            [1183420800000, 210535944],
            [1183507200000, 210545283],
            [1183593600000, 210556253],
            [1183680000000, 210567139],
            [1183766400000, 210581171],
            [1183852800000, 210592590],
            [1183939200000, 210597530],
            [1184025600000, 210602759],
            [1184112000000, 210609234],
            [1184198400000, 210614939]
        ],
        name: '300',
        showInLegend: false,
        extra: {
            title: '300',
            genre: 'Period Action',

            mpaaRating: 'R',
            imgMainColor: '#5C4538'
        },
        showlabel: false,
        color: 'rgba(92,69,56,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                489196800000, 1729890
            ],
            [489283200000, 3592539],
            [489369600000, 7253299],
            [489456000000, 11538679],
            [489542400000, 14745039],
            [489628800000, 16534239],
            [489715200000, 18476850],
            [489801600000, 20294450],
            [489888000000, 22025630],
            [489974400000, 25150429],
            [490060800000, 29004906],
            [490147200000, 32580763],
            [490233600000, 34496488],
            [490320000000, 36432388],
            [490406400000, 38196208],
            [490492800000, 39917008],
            [490579200000, 42944493],
            [490665600000, 47025573],
            [490752000000, 50232313],
            [490838400000, 51921963],
            [490924800000, 53739768],
            [491011200000, 55448608],
            [491097600000, 57173008],
            [491184000000, 60258913],
            [491270400000, 63973668],
            [491356800000, 66639288],
            [491443200000, 68199033],
            [491529600000, 69894408],
            [491616000000, 71654968],
            [491702400000, 73161888],
            [491788800000, 75611328],
            [491875200000, 78954240],
            [491961600000, 81590340],
            [492048000000, 83057950],
            [492134400000, 84555820],
            [492220800000, 86048820],
            [492307200000, 87552300],
            [492393600000, 89871765],
            [492480000000, 93132795],
            [492566400000, 95626695],
            [492652800000, 96902575],
            [492739200000, 98293055],
            [492825600000, 99617195],
            [492912000000, 100986995],
            [492998400000, 103083215],
            [493084800000, 106009215],
            [493171200000, 108239135],
            [493257600000, 109413260],
            [493344000000, 110693435],
            [493430400000, 111888705],
            [493516800000, 112978065],
            [493603200000, 114821265],
            [493689600000, 117647505],
            [493776000000, 119905425],
            [493862400000, 120846990],
            [493948800000, 121829390],
            [494035200000, 122725610],
            [494121600000, 123614750],
            [494208000000, 125399179],
            [494294400000, 128164306],
            [494380800000, 130764095],
            [494467200000, 132664418],
            [494553600000, 133233478],
            [494640000000, 133717003],
            [494726400000, 134177803],
            [494812800000, 135622670],
            [494899200000, 138071652],
            [494985600000, 139392468],
            [495072000000, 139714968],
            [495158400000, 140112203],
            [495244800000, 140464233],
            [495331200000, 140794893],
            [495417600000, 141932885],
            [495504000000, 143952017],
            [495590400000, 144929150],
            [495676800000, 145256525],
            [495763200000, 145626785],
            [495849600000, 145916985],
            [495936000000, 146186715],
            [496022400000, 147201023],
            [496108800000, 149109662],
            [496195200000, 150110865],
            [496281600000, 150332360],
            [496368000000, 150653885],
            [496454400000, 150937485],
            [496540800000, 151187560],
            [496627200000, 152180470],
            [496713600000, 154195070],
            [496800000000, 155159200],
            [496886400000, 155398730],
            [496972800000, 155659395],
            [497059200000, 155905095],
            [497145600000, 156144115],
            [497232000000, 157016869],
            [497318400000, 158766861],
            [497404800000, 159526773],
            [497491200000, 159697593],
            [497577600000, 159907993],
            [497664000000, 160106443],
            [497750400000, 160319883],
            [497836800000, 161043021],
            [497923200000, 162440455],
            [498009600000, 163299302],
            [498096000000, 163607921],
            [498182400000, 163787866],
            [498268800000, 163948286],
            [498355200000, 164127796],
            [498441600000, 164844886],
            [498528000000, 166279326],
            [498614400000, 167008916],
            [498700800000, 167167041],
            [498787200000, 167356791],
            [498873600000, 167527296],
            [498960000000, 167692526],
            [499046400000, 168316250],
            [499132800000, 169401824],
            [499219200000, 169936837],
            [499305600000, 170081622],
            [499392000000, 170258302],
            [499478400000, 170402857],
            [499564800000, 170560607],
            [499651200000, 171116723],
            [499737600000, 172332713],
            [499824000000, 172920843],
            [499910400000, 173051253],
            [499996800000, 173232533],
            [500083200000, 173373033],
            [500169600000, 173518373],
            [500256000000, 174087073],
            [500342400000, 175083553],
            [500428800000, 175741903],
            [500515200000, 176044573],
            [500601600000, 176187933],
            [500688000000, 176305348],
            [500774400000, 176428708],
            [500860800000, 176937944],
            [500947200000, 177915727],
            [501033600000, 178376369],
            [501120000000, 178471504],
            [501206400000, 178610689],
            [501292800000, 178721713],
            [501379200000, 178830178],
            [501465600000, 179271173],
            [501552000000, 180109205],
            [501638400000, 180524247],
            [501724800000, 180626047],
            [501811200000, 180768147],
            [501897600000, 181048947],
            [501984000000, 181453947],
            [502070400000, 182262909],
            [502156800000, 183196741],
            [502243200000, 183576861],
            [502329600000, 183647841],
            [502416000000, 183756041],
            [502502400000, 183842826],
            [502588800000, 183919476],
            [502675200000, 184172047],
            [502761600000, 184639420],
            [502848000000, 184904944],
            [502934400000, 184958044],
            [503020800000, 185028124],
            [503107200000, 185088199],
            [503193600000, 185144059],
            [503280000000, 185319350],
            [503366400000, 185637001],
            [503452800000, 185844291],
            [503539200000, 185890441],
            [503625600000, 185950536],
            [503712000000, 186014256],
            [503798400000, 186075031],
            [503884800000, 186272746],
            [503971200000, 186635896],
            [504057600000, 186980485],
            [504144000000, 187183210],
            [504230400000, 187287886],
            [504316800000, 187517479],
            [504403200000, 187887229],
            [504489600000, 188435437],
            [504576000000, 189117043],
            [504662400000, 189747077],
            [504748800000, 190180051],
            [504835200000, 190581407],
            [504921600000, 191142267],
            [505008000000, 191470267],
            [505094400000, 191937189],
            [505180800000, 192598796],
            [505267200000, 192957781],
            [505353600000, 193072016],
            [505440000000, 193189936],
            [505526400000, 193300486],
            [505612800000, 193407206],
            [505699200000, 193737353],
            [505785600000, 194362152],
            [505872000000, 194658001],
            [505958400000, 194742126],
            [506044800000, 194836346],
            [506131200000, 194923836],
            [506217600000, 195016176],
            [506304000000, 195303276],
            [506390400000, 195857176],
            [506476800000, 196303776],
            [506563200000, 196471776],
            [506649600000, 196566636],
            [506736000000, 196641426],
            [506822400000, 196711051],
            [506908800000, 196964828],
            [506995200000, 197424359],
            [507081600000, 197596245],
            [507168000000, 197637195],
            [507254400000, 197715630],
            [507340800000, 197773930],
            [507427200000, 197832030],
            [507513600000, 197987430],
            [507600000000, 198276030],
            [507686400000, 198442630],
            [507772800000, 198482500],
            [507859200000, 198526800],
            [507945600000, 198568100],
            [508032000000, 198605630],
            [508118400000, 198755255],
            [508204800000, 199040540],
            [508291200000, 199200140],
            [508377600000, 199225880],
            [508464000000, 199267900],
            [508550400000, 199300030],
            [508636800000, 199332160],
            [508723200000, 199438660],
            [508809600000, 199660535],
            [508896000000, 199846910],
            [508982400000, 199946030],
            [509068800000, 199992370],
            [509155200000, 200035660],
            [509241600000, 200072180],
            [509328000000, 200208180],
            [509414400000, 200454680],
            [509500800000, 200599180],
            [509587200000, 200631005],
            [509673600000, 200667965],
            [509760000000, 200701365],
            [509846400000, 200735065],
            [509932800000, 200851705],
            [510019200000, 201069455],
            [510105600000, 201193040],
            [510192000000, 201224040],
            [510278400000, 201260880],
            [510364800000, 201283755],
            [510451200000, 201306630],
            [510537600000, 201429130],
            [510624000000, 201667130],
            [510710400000, 201807130],
            [510796800000, 201847810],
            [510883200000, 201896530],
            [510969600000, 201942025],
            [511056000000, 201985705],
            [511142400000, 202117341],
            [511228800000, 202342852],
            [511315200000, 202484520],
            [511401600000, 202517920],
            [511488000000, 202564960],
            [511574400000, 202601260],
            [511660800000, 202634060]
        ],
        name: 'backtothefuture',
        showInLegend: false,
        extra: {
            title: 'Back to the Future',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#6A6562'
        },
        showlabel: true,
        color: 'rgba(106,101,98,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1304035200000, 34399360
            ],
            [1304121600000, 64334820],
            [1304208000000, 86198765],
            [1304294400000, 92430005],
            [1304380800000, 98588365],
            [1304467200000, 103216245],
            [1304553600000, 107333965],
            [1304640000000, 117972075],
            [1304726400000, 130752455],
            [1304812800000, 139779285],
            [1304899200000, 142306070],
            [1304985600000, 144997640],
            [1305072000000, 147138865],
            [1305158400000, 149246200],
            [1305244800000, 155163280],
            [1305331200000, 164095795],
            [1305417600000, 169690470],
            [1305504000000, 171283530],
            [1305590400000, 173009345],
            [1305676800000, 174317930],
            [1305763200000, 175588585],
            [1305849600000, 178739725],
            [1305936000000, 183212895],
            [1306022400000, 186165450],
            [1306108800000, 187214875],
            [1306195200000, 188065755],
            [1306281600000, 188789180],
            [1306368000000, 189409100],
            [1306454400000, 191212605],
            [1306540800000, 193657025],
            [1306627200000, 195818250],
            [1306713600000, 197308750],
            [1306800000000, 197860235],
            [1306886400000, 198322290],
            [1306972800000, 198814310],
            [1307059200000, 199787405],
            [1307145600000, 201163160],
            [1307232000000, 201979665],
            [1307318400000, 202326400],
            [1307404800000, 202673405],
            [1307491200000, 203008955],
            [1307577600000, 203366875],
            [1307664000000, 203891320],
            [1307750400000, 204642345],
            [1307836800000, 205094205],
            [1307923200000, 205306845],
            [1308009600000, 205526130],
            [1308096000000, 205732080],
            [1308182400000, 205944720],
            [1308268800000, 206196915],
            [1308355200000, 206535965],
            [1308441600000, 206816880],
            [1308528000000, 206922585],
            [1308614400000, 207028645],
            [1308700800000, 207134525],
            [1308787200000, 207243875],
            [1308873600000, 207404160],
            [1308960000000, 207607940],
            [1309046400000, 207752210],
            [1309132800000, 207816330],
            [1309219200000, 207880550],
            [1309305600000, 207925140],
            [1309392000000, 207971445],
            [1309478400000, 208069595],
            [1309564800000, 208191905],
            [1309651200000, 208303660],
            [1309737600000, 208362550],
            [1309824000000, 208415400],
            [1309910400000, 208468305],
            [1309996800000, 208521200],
            [1310083200000, 208599525],
            [1310169600000, 208701950],
            [1310256000000, 208782685],
            [1310342400000, 208820040],
            [1310428800000, 208861010],
            [1310515200000, 208895955],
            [1310601600000, 208928490],
            [1310688000000, 208991045],
            [1310774400000, 209076905],
            [1310860800000, 209142635],
            [1310947200000, 209173375],
            [1311033600000, 209209415],
            [1311120000000, 209242275],
            [1311206400000, 209276125],
            [1311292800000, 209323975],
            [1311379200000, 209391835],
            [1311465600000, 209445775],
            [1311552000000, 209470135],
            [1311638400000, 209497975],
            [1311724800000, 209524070],
            [1311811200000, 209550125],
            [1311897600000, 209590110],
            [1311984000000, 209644485],
            [1312070400000, 209688235],
            [1312156800000, 209702610],
            [1312243200000, 209717575],
            [1312329600000, 209731325],
            [1312416000000, 209746950],
            [1312502400000, 209763290],
            [1312588800000, 209786940],
            [1312675200000, 209805005],
            [1312761600000, 209813175],
            [1312848000000, 209821735],
            [1312934400000, 209829935],
            [1313020800000, 209837675]
        ],
        name: 'fastfive',
        showInLegend: false,
        extra: {
            title: 'Fast Five',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#628198'
        },
        showlabel: false,
        color: 'rgba(98,129,152,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1323907200000, 600000
            ],
            [1323993600000, 4702843],
            [1324080000000, 9451410],
            [1324166400000, 13385204],
            [1324252800000, 15406209],
            [1324339200000, 17094314],
            [1324425600000, 26015359],
            [1324512000000, 32436461],
            [1324598400000, 42112369],
            [1324684800000, 48339440],
            [1324771200000, 61993090],
            [1324857600000, 76555244],
            [1324944000000, 86219421],
            [1325030400000, 94737639],
            [1325116800000, 102984207],
            [1325203200000, 113615355],
            [1325289600000, 122347325],
            [1325376000000, 132406086],
            [1325462400000, 141186646],
            [1325548800000, 144614663],
            [1325635200000, 147249529],
            [1325721600000, 149700912],
            [1325808000000, 155841777],
            [1325894400000, 164863451],
            [1325980800000, 169568971],
            [1326067200000, 170857682],
            [1326153600000, 172558998],
            [1326240000000, 173925467],
            [1326326400000, 175246789],
            [1326412800000, 178501578],
            [1326499200000, 183259151],
            [1326585600000, 186933406],
            [1326672000000, 189448612],
            [1326758400000, 190341057],
            [1326844800000, 191065602],
            [1326931200000, 191809187],
            [1327017600000, 193351500],
            [1327104000000, 196212636],
            [1327190400000, 197363441],
            [1327276800000, 197800131],
            [1327363200000, 198274642],
            [1327449600000, 198670065],
            [1327536000000, 199091325],
            [1327622400000, 200027203],
            [1327708800000, 201698630],
            [1327795200000, 202565203],
            [1327881600000, 202790734],
            [1327968000000, 203047583],
            [1328054400000, 203264874],
            [1328140800000, 203497862],
            [1328227200000, 204023157],
            [1328313600000, 204949375],
            [1328400000000, 205200776],
            [1328486400000, 205343091],
            [1328572800000, 205514946],
            [1328659200000, 205657755],
            [1328745600000, 205807801],
            [1328832000000, 205994717],
            [1328918400000, 206335822],
            [1329004800000, 206514768],
            [1329091200000, 206570093],
            [1329177600000, 206695686],
            [1329264000000, 206750308],
            [1329350400000, 206813423],
            [1329436800000, 206935798],
            [1329523200000, 207141868],
            [1329609600000, 207299479],
            [1329696000000, 207404961],
            [1329782400000, 207455023],
            [1329868800000, 207494250],
            [1329955200000, 207533800],
            [1330041600000, 207602157],
            [1330128000000, 207714780],
            [1330214400000, 207771027],
            [1330300800000, 207789903],
            [1330387200000, 207818131],
            [1330473600000, 207839002],
            [1330560000000, 207861460],
            [1330646400000, 207905518],
            [1330732800000, 207982194],
            [1330819200000, 208019613],
            [1330905600000, 208033402],
            [1330992000000, 208052513],
            [1331078400000, 208065319],
            [1331164800000, 208083766],
            [1331251200000, 208171206],
            [1331337600000, 208313546],
            [1331424000000, 208394554],
            [1331510400000, 208429808],
            [1331596800000, 208471627],
            [1331683200000, 208506422],
            [1331769600000, 208545311],
            [1331856000000, 208616662],
            [1331942400000, 208719690],
            [1332028800000, 208782805],
            [1332115200000, 208805884],
            [1332201600000, 208833966],
            [1332288000000, 208857092],
            [1332374400000, 208881637],
            [1332460800000, 208935157],
            [1332547200000, 209021962],
            [1332633600000, 209065119],
            [1332720000000, 209081660],
            [1332806400000, 209100100],
            [1332892800000, 209115772],
            [1332979200000, 209132472],
            [1333065600000, 209165280],
            [1333152000000, 209214499],
            [1333238400000, 209239679],
            [1333324800000, 209250715],
            [1333411200000, 209264977],
            [1333497600000, 209278301],
            [1333584000000, 209294762],
            [1333670400000, 209323494],
            [1333756800000, 209352518],
            [1333843200000, 209364921],
            [1333929600000, 209373251],
            [1334016000000, 209380781],
            [1334102400000, 209388747],
            [1334188800000, 209397903]
        ],
        name: 'mi4',
        showInLegend: false,
        extra: {
            title: 'Mission: Impossible - Ghost Protocol',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#725536'
        },
        showlabel: false,
        color: 'rgba(114,85,54,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1121385600000, 10447000
            ],
            [1121472000000, 22737000],
            [1121558400000, 33900720],
            [1121644800000, 39696000],
            [1121731200000, 45084000],
            [1121817600000, 50040000],
            [1121904000000, 54701439],
            [1121990400000, 62271000],
            [1122076800000, 71987000],
            [1122163200000, 80366504],
            [1122249600000, 84360000],
            [1122336000000, 88470000],
            [1122422400000, 92250000],
            [1122508800000, 95598980],
            [1122595200000, 101422000],
            [1122681600000, 109160000],
            [1122768000000, 115622139],
            [1122854400000, 118978000],
            [1122940800000, 122006000],
            [1123027200000, 124858000],
            [1123113600000, 127599177],
            [1123200000000, 132435000],
            [1123286400000, 138799000],
            [1123372800000, 143634354],
            [1123459200000, 145799000],
            [1123545600000, 148022000],
            [1123632000000, 150065000],
            [1123718400000, 152026116],
            [1123804800000, 155522000],
            [1123891200000, 160416000],
            [1123977600000, 163860730],
            [1124064000000, 165363000],
            [1124150400000, 166916000],
            [1124236800000, 168299000],
            [1124323200000, 169639990],
            [1124409600000, 172044000],
            [1124496000000, 175462000],
            [1124582400000, 177642603],
            [1124668800000, 178623000],
            [1124755200000, 179642000],
            [1124841600000, 180583000],
            [1124928000000, 181467758],
            [1125014400000, 183197000],
            [1125100800000, 185892000],
            [1125187200000, 187519203],
            [1125273600000, 188150000],
            [1125360000000, 188847000],
            [1125446400000, 189457000],
            [1125532800000, 189976593],
            [1125619200000, 191139000],
            [1125705600000, 192921000],
            [1125792000000, 194729075],
            [1125878400000, 195801693],
            [1125964800000, 196142000],
            [1126051200000, 196466000],
            [1126137600000, 196769759],
            [1126224000000, 197754000],
            [1126310400000, 199284000],
            [1126396800000, 200021913],
            [1126483200000, 200261000],
            [1126569600000, 200534000],
            [1126656000000, 200807000],
            [1126742400000, 201093086],
            [1126828800000, 201876000],
            [1126915200000, 203095000],
            [1127001600000, 203620728],
            [1127088000000, 203769000],
            [1127174400000, 203947000],
            [1127260800000, 204108000],
            [1127347200000, 204273801],
            [1127433600000, 204643000],
            [1127520000000, 205262000],
            [1127606400000, 205540048]
        ],
        name: 'weddingcrashers',
        showInLegend: false,
        extra: {
            title: 'Wedding Crashers',
            genre: 'Comedy',

            mpaaRating: 'R',
            imgMainColor: '#855A54'
        },
        showlabel: false,
        color: 'rgba(133,90,84,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1261699200000, 24608941
            ],
            [1261785600000, 46446116],
            [1261872000000, 62304277],
            [1261958400000, 73470490],
            [1262044800000, 83687532],
            [1262131200000, 93411175],
            [1262217600000, 102102956],
            [1262304000000, 116992838],
            [1262390400000, 131366402],
            [1262476800000, 138715437],
            [1262563200000, 141626898],
            [1262649600000, 144329320],
            [1262736000000, 146648646],
            [1262822400000, 148567766],
            [1262908800000, 153641575],
            [1262995200000, 160974126],
            [1263081600000, 165153093],
            [1263168000000, 166380468],
            [1263254400000, 167784681],
            [1263340800000, 168988929],
            [1263427200000, 170193400],
            [1263513600000, 173023936],
            [1263600000000, 177142144],
            [1263686400000, 180082554],
            [1263772800000, 182226907],
            [1263859200000, 183033191],
            [1263945600000, 183721546],
            [1264032000000, 184448783],
            [1264118400000, 186418839],
            [1264204800000, 189715032],
            [1264291200000, 191076852],
            [1264377600000, 191561194],
            [1264464000000, 192094470],
            [1264550400000, 192576937],
            [1264636800000, 193086178],
            [1264723200000, 194301680],
            [1264809600000, 196401750],
            [1264896000000, 197601522],
            [1264982400000, 197940574],
            [1265068800000, 198286107],
            [1265155200000, 198621217],
            [1265241600000, 198949296],
            [1265328000000, 199731713],
            [1265414400000, 201084843],
            [1265500800000, 201484470],
            [1265587200000, 201721901],
            [1265673600000, 201968068],
            [1265760000000, 202196497],
            [1265846400000, 202463599],
            [1265932800000, 202790427],
            [1266019200000, 203420509],
            [1266105600000, 204055200],
            [1266192000000, 204350996],
            [1266278400000, 204461213],
            [1266364800000, 204568124],
            [1266451200000, 204687708],
            [1266537600000, 204921839],
            [1266624000000, 205333913],
            [1266710400000, 205534198],
            [1266796800000, 205598319],
            [1266883200000, 205665420],
            [1266969600000, 205734782],
            [1267056000000, 205811216],
            [1267142400000, 205978637],
            [1267228800000, 206284728],
            [1267315200000, 206419248],
            [1267401600000, 206463640],
            [1267488000000, 206515722],
            [1267574400000, 206564159],
            [1267660800000, 206616070],
            [1267747200000, 206740497],
            [1267833600000, 206937086],
            [1267920000000, 207022408],
            [1268006400000, 207053978],
            [1268092800000, 207090283],
            [1268179200000, 207126300],
            [1268265600000, 207162797],
            [1268352000000, 207235163],
            [1268438400000, 207346622],
            [1268524800000, 207401207],
            [1268611200000, 207423979],
            [1268697600000, 207450166],
            [1268784000000, 207472164],
            [1268870400000, 207497381],
            [1268956800000, 207622021],
            [1269043200000, 207795022],
            [1269129600000, 207902824],
            [1269216000000, 207947023],
            [1269302400000, 207991590],
            [1269388800000, 208032668],
            [1269475200000, 208079524],
            [1269561600000, 208178327],
            [1269648000000, 208313281],
            [1269734400000, 208394875],
            [1269820800000, 208429960],
            [1269907200000, 208468553],
            [1269993600000, 208503672],
            [1270080000000, 208545761],
            [1270166400000, 208608371],
            [1270252800000, 208674926],
            [1270339200000, 208711166],
            [1270425600000, 208733110],
            [1270512000000, 208754773],
            [1270598400000, 208775287],
            [1270684800000, 208798028],
            [1270771200000, 208830731],
            [1270857600000, 208877139],
            [1270944000000, 208897390],
            [1271030400000, 208905896],
            [1271116800000, 208914427],
            [1271203200000, 208922405],
            [1271289600000, 208930861],
            [1271376000000, 208946479],
            [1271462400000, 208968515],
            [1271548800000, 208978879],
            [1271635200000, 208982618],
            [1271721600000, 208986711],
            [1271808000000, 208991131],
            [1271894400000, 208995829],
            [1271980800000, 209002734],
            [1272067200000, 209014166],
            [1272153600000, 209019489],
            [1272240000000, 209021786],
            [1272326400000, 209023929],
            [1272412800000, 209026246],
            [1272499200000, 209028679]
        ],
        name: 'sherlockholmes',
        showInLegend: false,
        extra: {
            title: 'Sherlock Holmes',
            genre: 'Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#4B6A6E'
        },
        showlabel: false,
        color: 'rgba(75,106,110,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1405036800000, 27645087
            ],
            [1405123200000, 53146310],
            [1405209600000, 72611427],
            [1405296000000, 80828184],
            [1405382400000, 90449372],
            [1405468800000, 97126068],
            [1405555200000, 102952844],
            [1405641600000, 113373611],
            [1405728000000, 128147656],
            [1405814400000, 139207154],
            [1405900800000, 143413707],
            [1405987200000, 148490279],
            [1406073600000, 152376446],
            [1406160000000, 155688629],
            [1406246400000, 160452368],
            [1406332800000, 167142672],
            [1406419200000, 172455889],
            [1406505600000, 174667537],
            [1406592000000, 177174377],
            [1406678400000, 179020564],
            [1406764800000, 180629673],
            [1406851200000, 183070104],
            [1406937600000, 186609108],
            [1407024000000, 189319987],
            [1407110400000, 190463536],
            [1407196800000, 191749506],
            [1407283200000, 192693727],
            [1407369600000, 193433624],
            [1407456000000, 194679700],
            [1407542400000, 196467341],
            [1407628800000, 197768156],
            [1407715200000, 198319042],
            [1407801600000, 199051045],
            [1407888000000, 199544638],
            [1407974400000, 199912360],
            [1408060800000, 200447166],
            [1408147200000, 201281479],
            [1408233600000, 201897136],
            [1408320000000, 202139896],
            [1408406400000, 202442801],
            [1408492800000, 202668551],
            [1408579200000, 202860970],
            [1408665600000, 203167527],
            [1408752000000, 203652813],
            [1408838400000, 203937551],
            [1408924800000, 204052522],
            [1409011200000, 204209341],
            [1409097600000, 204316955],
            [1409184000000, 204419991],
            [1409270400000, 204613388],
            [1409356800000, 204931466],
            [1409443200000, 205281257],
            [1409529600000, 205531338],
            [1409616000000, 205606489],
            [1409702400000, 205660399],
            [1409788800000, 205706534],
            [1409875200000, 205841100],
            [1409961600000, 206091531],
            [1410048000000, 206225085],
            [1410134400000, 206270266],
            [1410220800000, 206335978],
            [1410307200000, 206384672],
            [1410393600000, 206435479],
            [1410480000000, 206541961],
            [1410566400000, 206723082],
            [1410652800000, 206827518],
            [1410739200000, 206863475],
            [1410825600000, 206913699],
            [1410912000000, 206957880],
            [1410998400000, 206996593],
            [1411084800000, 207071101],
            [1411171200000, 207192971],
            [1411257600000, 207265287],
            [1411344000000, 207288492],
            [1411430400000, 207319638],
            [1411516800000, 207343559],
            [1411603200000, 207367537],
            [1411689600000, 207429170],
            [1411776000000, 207538784],
            [1411862400000, 207604340],
            [1411948800000, 207625595],
            [1412035200000, 207649407],
            [1412121600000, 207671108],
            [1412208000000, 207689886],
            [1412294400000, 207736026],
            [1412380800000, 207818974],
            [1412467200000, 207872668],
            [1412553600000, 207889176],
            [1412640000000, 207908525],
            [1412726400000, 207925538],
            [1412812800000, 207943345],
            [1412899200000, 207985979],
            [1412985600000, 208060382],
            [1413072000000, 208108174],
            [1413158400000, 208128595],
            [1413244800000, 208143178],
            [1413331200000, 208155286],
            [1413417600000, 208168226],
            [1413504000000, 208193976],
            [1413590400000, 208239292],
            [1413676800000, 208268003],
            [1413763200000, 208276223],
            [1413849600000, 208285945],
            [1413936000000, 208294446],
            [1414022400000, 208303743],
            [1414108800000, 208319550],
            [1414195200000, 208347647],
            [1414281600000, 208365305],
            [1414368000000, 208369846],
            [1414454400000, 208375237],
            [1414540800000, 208379856],
            [1414627200000, 208384821],
            [1414713600000, 208392407],
            [1414800000000, 208415815],
            [1414886400000, 208429999],
            [1414972800000, 208433412],
            [1415059200000, 208437197],
            [1415145600000, 208440783],
            [1415232000000, 208444587],
            [1415318400000, 208452449],
            [1415404800000, 208467682],
            [1415491200000, 208477397],
            [1415577600000, 208480858],
            [1415664000000, 208486455],
            [1415750400000, 208488457],
            [1415836800000, 208490841]
        ],
        name: 'dawnoftheapes',
        showInLegend: false,
        extra: {
            title: 'Dawn of the Planet of the Apes',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#2D1E1C'
        },
        showlabel: false,
        color: 'rgba(45,30,28,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1118793600000, 15068368
            ],
            [1118880000000, 24151546],
            [1118966400000, 39223788],
            [1119052800000, 57240835],
            [1119139200000, 72896986],
            [1119225600000, 79524398],
            [1119312000000, 84928817],
            [1119398400000, 90446984],
            [1119484800000, 94922424],
            [1119571200000, 103192167],
            [1119657600000, 113856497],
            [1119744000000, 122511813],
            [1119830400000, 126521851],
            [1119916800000, 130249189],
            [1120003200000, 132823668],
            [1120089600000, 135460937],
            [1120176000000, 140035127],
            [1120262400000, 145711040],
            [1120348800000, 151070575],
            [1120435200000, 154800369],
            [1120521600000, 157335686],
            [1120608000000, 159680978],
            [1120694400000, 161889333],
            [1120780800000, 164944169],
            [1120867200000, 168915279],
            [1120953600000, 171901777],
            [1121040000000, 173217244],
            [1121126400000, 174525652],
            [1121212800000, 175839109],
            [1121299200000, 177105550],
            [1121385600000, 178850893],
            [1121472000000, 181300218],
            [1121558400000, 183140850],
            [1121644800000, 183968964],
            [1121731200000, 184805322],
            [1121817600000, 185583513],
            [1121904000000, 186377725],
            [1121990400000, 187601872],
            [1122076800000, 189825801],
            [1122163200000, 191105194],
            [1122249600000, 191693621],
            [1122336000000, 192304996],
            [1122422400000, 192883034],
            [1122508800000, 193427307],
            [1122595200000, 194103161],
            [1122681600000, 195114906],
            [1122768000000, 195875532],
            [1122854400000, 196253007],
            [1122940800000, 196590195],
            [1123027200000, 196921540],
            [1123113600000, 197265941],
            [1123200000000, 197804231],
            [1123286400000, 198548642],
            [1123372800000, 199088386],
            [1123459200000, 199332540],
            [1123545600000, 199594742],
            [1123632000000, 199853183],
            [1123718400000, 200099489],
            [1123804800000, 200388988],
            [1123891200000, 200850775],
            [1123977600000, 201149986],
            [1124064000000, 201294240],
            [1124150400000, 201422402],
            [1124236800000, 201533896],
            [1124323200000, 201653269],
            [1124409600000, 201836656],
            [1124496000000, 202108892],
            [1124582400000, 202285638],
            [1124668800000, 202358091],
            [1124755200000, 202431919],
            [1124841600000, 202502041],
            [1124928000000, 202573682],
            [1125014400000, 202696201],
            [1125100800000, 202896447],
            [1125187200000, 203019055],
            [1125273600000, 203065964],
            [1125360000000, 203116153],
            [1125446400000, 203162209],
            [1125532800000, 203202248],
            [1125619200000, 203285998],
            [1125705600000, 203417194],
            [1125792000000, 203550460],
            [1125878400000, 203641815],
            [1125964800000, 203664605],
            [1126051200000, 203684748],
            [1126137600000, 203705410],
            [1126224000000, 203822210],
            [1126310400000, 204013430],
            [1126396800000, 204145879],
            [1126483200000, 204181569],
            [1126569600000, 204222519],
            [1126656000000, 204260839],
            [1126742400000, 204303093],
            [1126828800000, 204399579],
            [1126915200000, 204560350],
            [1127001600000, 204646787],
            [1127088000000, 204668623],
            [1127174400000, 204694147],
            [1127260800000, 204715641],
            [1127347200000, 204738659],
            [1127433600000, 204788865],
            [1127520000000, 204867215],
            [1127606400000, 204910076],
            [1127692800000, 204923903],
            [1127779200000, 204939350],
            [1127865600000, 204954093],
            [1127952000000, 204970174],
            [1128038400000, 205005268],
            [1128124800000, 205056017],
            [1128211200000, 205085404],
            [1128297600000, 205095534],
            [1128384000000, 205106149],
            [1128470400000, 205115299],
            [1128556800000, 205126806],
            [1128643200000, 205148041],
            [1128729600000, 205178914],
            [1128816000000, 205197285],
            [1128902400000, 205205347],
            [1128988800000, 205211893],
            [1129075200000, 205217789],
            [1129161600000, 205225535],
            [1129248000000, 205242532],
            [1129334400000, 205266350],
            [1129420800000, 205279168],
            [1129507200000, 205283460],
            [1129593600000, 205287568],
            [1129680000000, 205291576],
            [1129766400000, 205297580],
            [1129852800000, 205307350],
            [1129939200000, 205319539],
            [1130025600000, 205324662],
            [1130112000000, 205326735],
            [1130198400000, 205328644],
            [1130284800000, 205330169],
            [1130371200000, 205333246],
            [1130457600000, 205336231],
            [1130544000000, 205341510],
            [1130630400000, 205343774]
        ],
        name: 'batmanbegins',
        showInLegend: false,
        extra: {
            title: 'Batman Begins',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#5B3C25'
        },
        showlabel: false,
        color: 'rgba(91,60,37,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1121385600000, 20714395
            ],
            [1121472000000, 40065722],
            [1121558400000, 56178450],
            [1121644800000, 64712928],
            [1121731200000, 72481155],
            [1121817600000, 79365494],
            [1121904000000, 85805554],
            [1121990400000, 94871705],
            [1122076800000, 105487519],
            [1122163200000, 114058892],
            [1122249600000, 118684383],
            [1122336000000, 123416733],
            [1122422400000, 127843959],
            [1122508800000, 131711190],
            [1122595200000, 136764108],
            [1122681600000, 143051809],
            [1122768000000, 148095522],
            [1122854400000, 150927875],
            [1122940800000, 153484965],
            [1123027200000, 155970146],
            [1123113600000, 158458387],
            [1123200000000, 161937600],
            [1123286400000, 166111923],
            [1123372800000, 169426750],
            [1123459200000, 171284006],
            [1123545600000, 173222371],
            [1123632000000, 174932573],
            [1123718400000, 176527906],
            [1123804800000, 178682684],
            [1123891200000, 181625844],
            [1123977600000, 183940297],
            [1124064000000, 185082569],
            [1124150400000, 186223994],
            [1124236800000, 187231213],
            [1124323200000, 188203635],
            [1124409600000, 189511572],
            [1124496000000, 191329362],
            [1124582400000, 192638088],
            [1124668800000, 193219376],
            [1124755200000, 193842621],
            [1124841600000, 194392018],
            [1124928000000, 194883375],
            [1125014400000, 195579124],
            [1125100800000, 196712775],
            [1125187200000, 197578822],
            [1125273600000, 197922851],
            [1125360000000, 198341331],
            [1125446400000, 198724283],
            [1125532800000, 198957750],
            [1125619200000, 199358996],
            [1125705600000, 200041100],
            [1125792000000, 200713172],
            [1125878400000, 201335082],
            [1125964800000, 201437392],
            [1126051200000, 201517580],
            [1126137600000, 201603626],
            [1126224000000, 201815008],
            [1126310400000, 202286233],
            [1126396800000, 202596015],
            [1126483200000, 202655284],
            [1126569600000, 202710088],
            [1126656000000, 202765513],
            [1126742400000, 202826883],
            [1126828800000, 202981276],
            [1126915200000, 203354809],
            [1127001600000, 203563984],
            [1127088000000, 203603305],
            [1127174400000, 203644529],
            [1127260800000, 203681539],
            [1127347200000, 203720854],
            [1127433600000, 203808404],
            [1127520000000, 203987210],
            [1127606400000, 204100877],
            [1127692800000, 204128673],
            [1127779200000, 204150285],
            [1127865600000, 204169971],
            [1127952000000, 204190038],
            [1128038400000, 204265570],
            [1128124800000, 204411154],
            [1128211200000, 204482131],
            [1128297600000, 204500450],
            [1128384000000, 204519041],
            [1128470400000, 204536523],
            [1128556800000, 204559285],
            [1128643200000, 204650134],
            [1128729600000, 204823301],
            [1128816000000, 204921809],
            [1128902400000, 204975605],
            [1128988800000, 205004441],
            [1129075200000, 205029824],
            [1129161600000, 205064404],
            [1129248000000, 205134899],
            [1129334400000, 205265159],
            [1129420800000, 205336261],
            [1129507200000, 205357725],
            [1129593600000, 205377091],
            [1129680000000, 205397068],
            [1129766400000, 205425739],
            [1129852800000, 205492631],
            [1129939200000, 205598976],
            [1130025600000, 205663945],
            [1130112000000, 205682413],
            [1130198400000, 205698689],
            [1130284800000, 205714652],
            [1130371200000, 205733411],
            [1130457600000, 205775538],
            [1130544000000, 205847505],
            [1130630400000, 205892084],
            [1130716800000, 205907582],
            [1130803200000, 205921832],
            [1130889600000, 205936130],
            [1130976000000, 205954127],
            [1131062400000, 205993718],
            [1131148800000, 206064704],
            [1131235200000, 206108092],
            [1131321600000, 206116697],
            [1131408000000, 206125588],
            [1131494400000, 206133185],
            [1131580800000, 206147880],
            [1131667200000, 206193534],
            [1131753600000, 206249584],
            [1131840000000, 206278008],
            [1131926400000, 206283590],
            [1132012800000, 206288588],
            [1132099200000, 206292421],
            [1132185600000, 206298841],
            [1132272000000, 206318140],
            [1132358400000, 206355650],
            [1132444800000, 206376804],
            [1132531200000, 206381294],
            [1132617600000, 206388180],
            [1132704000000, 206398552],
            [1132790400000, 206405633],
            [1132876800000, 206418694],
            [1132963200000, 206431919],
            [1133049600000, 206438942],
            [1133136000000, 206440339],
            [1133222400000, 206441688],
            [1133308800000, 206443153],
            [1133395200000, 206444501],
            [1133481600000, 206447439],
            [1133568000000, 206453158],
            [1133654400000, 206456431],
            [1133740800000, 206456929],
            [1133827200000, 206457524],
            [1133913600000, 206458281],
            [1134000000000, 206459076]
        ],
        name: 'charliechocolate',
        showInLegend: false,
        extra: {
            title: 'Charlie and the Chocolate Factory',
            genre: 'Family Adventure',

            mpaaRating: 'PG',
            imgMainColor: '#6F6D80'
        },
        showlabel: false,
        color: 'rgba(111,109,128,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1183075200000, 16452942
            ],
            [1183161600000, 33429087],
            [1183248000000, 47027395],
            [1183334400000, 54578355],
            [1183420800000, 62456353],
            [1183507200000, 72661432],
            [1183593600000, 80517305],
            [1183680000000, 89947854],
            [1183766400000, 100804214],
            [1183852800000, 109531598],
            [1183939200000, 113600498],
            [1184025600000, 117752774],
            [1184112000000, 121674427],
            [1184198400000, 124984886],
            [1184284800000, 130353597],
            [1184371200000, 137507564],
            [1184457600000, 142997082],
            [1184544000000, 145521742],
            [1184630400000, 148425089],
            [1184716800000, 151650816],
            [1184803200000, 154620776],
            [1184889600000, 158137616],
            [1184976000000, 162340455],
            [1185062400000, 165519955],
            [1185148800000, 167386622],
            [1185235200000, 169175907],
            [1185321600000, 170803117],
            [1185408000000, 172448802],
            [1185494400000, 174668520],
            [1185580800000, 177632001],
            [1185667200000, 179904396],
            [1185753600000, 180969194],
            [1185840000000, 182061530],
            [1185926400000, 183136312],
            [1186012800000, 184258413],
            [1186099200000, 185442334],
            [1186185600000, 187025670],
            [1186272000000, 188246213],
            [1186358400000, 189001812],
            [1186444800000, 189710838],
            [1186531200000, 190419220],
            [1186617600000, 191042064],
            [1186704000000, 191784026],
            [1186790400000, 192690749],
            [1186876800000, 193415480],
            [1186963200000, 193766272],
            [1187049600000, 194142699],
            [1187136000000, 194544483],
            [1187222400000, 194976996],
            [1187308800000, 195368920],
            [1187395200000, 196000779],
            [1187481600000, 196620846],
            [1187568000000, 196953427],
            [1187654400000, 197322082],
            [1187740800000, 197614304],
            [1187827200000, 197896216],
            [1187913600000, 198195862],
            [1188000000000, 198702492],
            [1188086400000, 199064945],
            [1188172800000, 199195584],
            [1188259200000, 199331589],
            [1188345600000, 199452057],
            [1188432000000, 199574419],
            [1188518400000, 199832653],
            [1188604800000, 200298119],
            [1188691200000, 200776098],
            [1188777600000, 201249448],
            [1188864000000, 201321358],
            [1188950400000, 201375775],
            [1189036800000, 201423520]
        ],
        name: 'ratatouille',
        showInLegend: false,
        extra: {
            title: 'Ratatouille',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#A29895'
        },
        showlabel: false,
        color: 'rgba(162,152,149,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1383868800000, 31899210
            ],
            [1383955200000, 63977220],
            [1384041600000, 85737841],
            [1384128000000, 96155035],
            [1384214400000, 101399146],
            [1384300800000, 104964877],
            [1384387200000, 108511114],
            [1384473600000, 119035584],
            [1384560000000, 135797011],
            [1384646400000, 145097130],
            [1384732800000, 147306753],
            [1384819200000, 150036561],
            [1384905600000, 152040829],
            [1384992000000, 153720821],
            [1385078400000, 157762308],
            [1385164800000, 164140641],
            [1385251200000, 167917123],
            [1385337600000, 169277785],
            [1385424000000, 171219285],
            [1385510400000, 173565644],
            [1385596800000, 175619790],
            [1385683200000, 180097212],
            [1385769600000, 184558900],
            [1385856000000, 186705086],
            [1385942400000, 187236287],
            [1386028800000, 187891632],
            [1386115200000, 188390574],
            [1386201600000, 188899642],
            [1386288000000, 190195619],
            [1386374400000, 192468599],
            [1386460800000, 193711187],
            [1386547200000, 194108665],
            [1386633600000, 194618631],
            [1386720000000, 195019868],
            [1386806400000, 195425689],
            [1386892800000, 196227275],
            [1386979200000, 197433358],
            [1387065600000, 198245744],
            [1387152000000, 198547263],
            [1387238400000, 198889827],
            [1387324800000, 199163732],
            [1387411200000, 199438108],
            [1387497600000, 199799955],
            [1387584000000, 200322623],
            [1387670400000, 200779871],
            [1387756800000, 201145411],
            [1387843200000, 201407296],
            [1387929600000, 201558622],
            [1388016000000, 201727537],
            [1388102400000, 201936733],
            [1388188800000, 202185167],
            [1388275200000, 202363610],
            [1388361600000, 202515122],
            [1388448000000, 202651732],
            [1388534400000, 202856752],
            [1388620800000, 202972697],
            [1388707200000, 203138372],
            [1388793600000, 203343938],
            [1388880000000, 203449204],
            [1388966400000, 203493010],
            [1389052800000, 203542579],
            [1389139200000, 203582036],
            [1389225600000, 203619586],
            [1389312000000, 203704674],
            [1389398400000, 203856044],
            [1389484800000, 203934480],
            [1389571200000, 203959025],
            [1389657600000, 203988735],
            [1389744000000, 204014660],
            [1389830400000, 204041762]
        ],
        name: 'thor2',
        showInLegend: false,
        extra: {
            title: 'Thor: The Dark World',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#4B5E63'
        },
        showlabel: false,
        color: 'rgba(75,94,99,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                928972800000, 2525078
            ],
            [929059200000, 17981900],
            [929145600000, 38353000],
            [929232000000, 57442682],
            [929318400000, 65052000],
            [929404800000, 72237000],
            [929491200000, 78490000],
            [929577600000, 84741585],
            [929664000000, 95221000],
            [929750400000, 106936000],
            [929836800000, 116148215]
        ],
        name: 'austinpowers2',
        showInLegend: false,
        extra: {
            title: 'Austin Powers: The Spy Who Shagged Me',
            genre: 'Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#CA8C81'
        },
        showlabel: false,
        color: 'rgba(202,140,129,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                678412800000, 2400000
            ],
            [678499200000, 11661072],
            [678585600000, 20541042],
            [678672000000, 31767780],
            [678758400000, 42971778],
            [678844800000, 52306548],
            [678931200000, 57354828],
            [679017600000, 61748196],
            [679104000000, 65875506],
            [679190400000, 69691278],
            [679276800000, 75928803],
            [679363200000, 84340878],
            [679449600000, 90429618],
            [679536000000, 92947518],
            [679622400000, 95522643],
            [679708800000, 97981029],
            [679795200000, 100418814],
            [679881600000, 104748499],
            [679968000000, 110791169],
            [680054400000, 115314239],
            [680140800000, 117111224],
            [680227200000, 119119619],
            [680313600000, 120775664],
            [680400000000, 122560904],
            [680486400000, 125824979],
            [680572800000, 130470479],
            [680659200000, 133612304],
            [680745600000, 135115979],
            [680832000000, 136754129],
            [680918400000, 137964404],
            [681004800000, 139125779],
            [681091200000, 141545929],
            [681177600000, 145093819],
            [681264000000, 147713569],
            [681350400000, 148873744],
            [681436800000, 150208569],
            [681523200000, 151306369],
            [681609600000, 152441594],
            [681696000000, 154520024],
            [681782400000, 157291264],
            [681868800000, 159166629],
            [681955200000, 160014724],
            [682041600000, 161113664],
            [682128000000, 161985649],
            [682214400000, 162905414],
            [682300800000, 164466884],
            [682387200000, 166775144],
            [682473600000, 168449764],
            [682560000000, 169196554],
            [682646400000, 170113069],
            [682732800000, 170837229],
            [682819200000, 171493499],
            [682905600000, 172666439],
            [682992000000, 174431039],
            [683078400000, 175583219],
            [683164800000, 176091839],
            [683251200000, 176745779],
            [683337600000, 177223259],
            [683424000000, 177721499],
            [683510400000, 178843810],
            [683596800000, 180597896],
            [683683200000, 182182182],
            [683769600000, 183122792],
            [683856000000, 183557032],
            [683942400000, 183857224],
            [684028800000, 184146088],
            [684115200000, 184977883],
            [684201600000, 186461083],
            [684288000000, 187253083],
            [684374400000, 187494283],
            [684460800000, 187816483],
            [684547200000, 188043283],
            [684633600000, 188264683],
            [684720000000, 188930036],
            [684806400000, 190110501],
            [684892800000, 190746136],
            [684979200000, 190907934],
            [685065600000, 191168792],
            [685152000000, 191375167],
            [685238400000, 191561730],
            [685324800000, 192157138],
            [685411200000, 193129850],
            [685497600000, 193624962],
            [685584000000, 193771426],
            [685670400000, 193997490],
            [685756800000, 194164650],
            [685843200000, 194319074],
            [685929600000, 194668066],
            [686016000000, 195263714],
            [686102400000, 195572034],
            [686188800000, 195675682],
            [686275200000, 195818690],
            [686361600000, 195934146],
            [686448000000, 196053538],
            [686534400000, 196323724],
            [686620800000, 196792414],
            [686707200000, 197063519],
            [686793600000, 197133363],
            [686880000000, 197220668],
            [686966400000, 197292350],
            [687052800000, 197373222],
            [687139200000, 197547642],
            [687225600000, 197853642],
            [687312000000, 198037242],
            [687398400000, 198116802],
            [687484800000, 198180450],
            [687571200000, 198233694],
            [687657600000, 198282654],
            [687744000000, 198440581],
            [687830400000, 198708464],
            [687916800000, 198849143],
            [688003200000, 198899809],
            [688089600000, 198961794],
            [688176000000, 199002219],
            [688262400000, 199048034],
            [688348800000, 199229094],
            [688435200000, 199541834],
            [688521600000, 199698204],
            [688608000000, 199738531],
            [688694400000, 199791203],
            [688780800000, 199837291],
            [688867200000, 199885025],
            [688953600000, 200003660],
            [689040000000, 200248120],
            [689126400000, 200348780],
            [689212800000, 200382573],
            [689299200000, 200424275],
            [689385600000, 200463101],
            [689472000000, 200500489],
            [689558400000, 200646713],
            [689644800000, 200917849],
            [689731200000, 201122089],
            [689817600000, 201177737],
            [689904000000, 201209705],
            [689990400000, 201240489],
            [690076800000, 201270089]
        ],
        name: 'terminator2',
        showInLegend: false,
        extra: {
            title: 'Terminator 2: Judgment Day',
            genre: 'Sci-Fi Action',

            mpaaRating: 'R',
            imgMainColor: '#2A2F38'
        },
        showlabel: false,
        color: 'rgba(42,47,56,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1398988800000, 35167017
            ],
            [1399075200000, 68328154],
            [1399161600000, 91608337],
            [1399248000000, 96776618],
            [1399334400000, 103016349],
            [1399420800000, 107139985],
            [1399507200000, 110700722],
            [1399593600000, 120721906],
            [1399680000000, 136181517],
            [1399766400000, 146201934],
            [1399852800000, 148456086],
            [1399939200000, 151360994],
            [1400025600000, 153429874],
            [1400112000000, 155366637],
            [1400198400000, 159918028],
            [1400284800000, 167306762],
            [1400371200000, 172169864],
            [1400457600000, 173691717],
            [1400544000000, 175048230],
            [1400630400000, 176070775],
            [1400716800000, 177101192],
            [1400803200000, 179148611],
            [1400889600000, 182218812],
            [1400976000000, 184924580],
            [1401062400000, 187111831],
            [1401148800000, 187839909],
            [1401235200000, 188425981],
            [1401321600000, 188957297],
            [1401408000000, 189981395],
            [1401494400000, 191644383],
            [1401580800000, 192735902],
            [1401667200000, 193114244],
            [1401753600000, 193615363],
            [1401840000000, 194017425],
            [1401926400000, 194388396],
            [1402012800000, 194937507],
            [1402099200000, 195752161],
            [1402185600000, 196350239],
            [1402272000000, 196621297],
            [1402358400000, 196937194],
            [1402444800000, 197216624],
            [1402531200000, 197432294],
            [1402617600000, 197709829],
            [1402704000000, 198089783],
            [1402790400000, 198386221],
            [1402876800000, 198504086],
            [1402963200000, 198637994],
            [1403049600000, 198755252],
            [1403136000000, 198877205],
            [1403222400000, 199074401],
            [1403308800000, 199345561],
            [1403395200000, 199510835],
            [1403481600000, 199596734],
            [1403568000000, 199695402],
            [1403654400000, 199786428],
            [1403740800000, 199863081],
            [1403827200000, 199959718],
            [1403913600000, 200094341],
            [1404000000000, 200185511],
            [1404086400000, 200245707],
            [1404172800000, 200300256],
            [1404259200000, 200376363],
            [1404345600000, 200477612],
            [1404432000000, 200593340],
            [1404518400000, 200785124],
            [1404604800000, 200938015],
            [1405036800000, 201356049],
            [1405123200000, 201499065],
            [1405209600000, 201597625],
            [1405641600000, 201915073],
            [1405728000000, 202014441],
            [1405814400000, 202084843],
            [1406246400000, 202283835],
            [1406332800000, 202354344],
            [1406419200000, 202408526],
            [1406851200000, 202558650],
            [1406937600000, 202607255],
            [1407024000000, 202644001],
            [1407456000000, 202736295],
            [1407542400000, 202760182],
            [1407628800000, 202778224],
            [1408060800000, 202826858],
            [1408147200000, 202842107],
            [1408233600000, 202853933]
        ],
        name: 'amazingspiderman2',
        showInLegend: false,
        extra: {
            title: 'The Amazing Spider-Man 2',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#6C626A'
        },
        showlabel: false,
        color: 'rgba(108,98,106,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1371772800000, 25196879
            ],
            [1371859200000, 47816213],
            [1371945600000, 66411834],
            [1372032000000, 74087200],
            [1372118400000, 82068368],
            [1372204800000, 88294543],
            [1372291200000, 93922294],
            [1372377600000, 102917020],
            [1372464000000, 114560051],
            [1372550400000, 123696919],
            [1372636800000, 128084078],
            [1372723200000, 132190495],
            [1372809600000, 136225317],
            [1372896000000, 140580675],
            [1372982400000, 146968693],
            [1373068800000, 153757810],
            [1373155200000, 158989638],
            [1373241600000, 161240821],
            [1373328000000, 163765088],
            [1373414400000, 165831036],
            [1373500800000, 167656920],
            [1373587200000, 170445052],
            [1373673600000, 174195182],
            [1373760000000, 176971782],
            [1373846400000, 178189259],
            [1373932800000, 179620072],
            [1374019200000, 180770604],
            [1374105600000, 181741067],
            [1374192000000, 183291476],
            [1374278400000, 185398653],
            [1374364800000, 186932608],
            [1374451200000, 187652614],
            [1374537600000, 188529044],
            [1374624000000, 189224428],
            [1374710400000, 189859546],
            [1374796800000, 190671603],
            [1374883200000, 191806034],
            [1374969600000, 192660231],
            [1375056000000, 193047805],
            [1375142400000, 193486326],
            [1375228800000, 193780151],
            [1375315200000, 194073962],
            [1375401600000, 194590199],
            [1375488000000, 195333757],
            [1375574400000, 195882193],
            [1375660800000, 196158375],
            [1375747200000, 196424717],
            [1375833600000, 196630587],
            [1375920000000, 196803632],
            [1376006400000, 197003766],
            [1376092800000, 197274959],
            [1376179200000, 197458107],
            [1376265600000, 197558857],
            [1376352000000, 197680880],
            [1376438400000, 197778968],
            [1376524800000, 197866133],
            [1376611200000, 197999047],
            [1376697600000, 198183715],
            [1376784000000, 198303509],
            [1376870400000, 198362073],
            [1376956800000, 198428715],
            [1377043200000, 198482967],
            [1377129600000, 198540021],
            [1377216000000, 198631906],
            [1377302400000, 198766662],
            [1377388800000, 198854941],
            [1377475200000, 198900578],
            [1377561600000, 198947243],
            [1377648000000, 198987069],
            [1377734400000, 199023831],
            [1377820800000, 199304090],
            [1377907200000, 199793941],
            [1377993600000, 200286551],
            [1378080000000, 200674205],
            [1378166400000, 200765547],
            [1378252800000, 200841325],
            [1378339200000, 200920537],
            [1378425600000, 201038383],
            [1378512000000, 201239387],
            [1378598400000, 201359019],
            [1378684800000, 201396927],
            [1378771200000, 201441087],
            [1378857600000, 201480800],
            [1378944000000, 201518833],
            [1379030400000, 201612318],
            [1379116800000, 201742802],
            [1379203200000, 201835676],
            [1379289600000, 201866747],
            [1379376000000, 201897680],
            [1379462400000, 201922757],
            [1379548800000, 201948971],
            [1379635200000, 202000541],
            [1379721600000, 202086644],
            [1379808000000, 202136145],
            [1379894400000, 202148787],
            [1379980800000, 202164278],
            [1380067200000, 202177951],
            [1380153600000, 202190728],
            [1380240000000, 202214285],
            [1380326400000, 202255816],
            [1380412800000, 202278858],
            [1380499200000, 202285264],
            [1380585600000, 202293134],
            [1380672000000, 202300188],
            [1380758400000, 202308340],
            [1380844800000, 202320444],
            [1380931200000, 202340076],
            [1381017600000, 202349504],
            [1381104000000, 202351905],
            [1381190400000, 202354408],
            [1381276800000, 202356823],
            [1381363200000, 202359711]
        ],
        name: 'worldwarz',
        showInLegend: false,
        extra: {
            title: 'World War Z',
            genre: 'Action Horror',

            mpaaRating: 'PG-13',
            imgMainColor: '#4F5052'
        },
        showlabel: false,
        color: 'rgba(79,80,82,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                988934400000, 23381875
            ],
            [989020800000, 50300790],
            [989107200000, 68139035],
            [989193600000, 73070485],
            [989280000000, 77559805],
            [989366400000, 81096845],
            [989452800000, 84293785],
            [989539200000, 94097480],
            [989625600000, 108572855],
            [989712000000, 118035540],
            [989798400000, 120183565],
            [989884800000, 122400460],
            [989971200000, 124224810],
            [990057600000, 126015060],
            [990144000000, 131848940],
            [990230400000, 140772360],
            [990316800000, 146450900],
            [990403200000, 148038820],
            [990489600000, 149315045],
            [990576000000, 150420495],
            [990662400000, 151547050],
            [990748800000, 155348760],
            [990835200000, 161300035],
            [990921600000, 166682830],
            [991008000000, 170691055],
            [991094400000, 171703660],
            [991180800000, 172555455],
            [991267200000, 173427505],
            [991353600000, 175462045],
            [991440000000, 179002465],
            [991526400000, 181181185],
            [991612800000, 181870710],
            [991699200000, 182607630],
            [991785600000, 183248430],
            [991872000000, 184049430],
            [991958400000, 185344985],
            [992044800000, 187403035],
            [992131200000, 188749560],
            [992217600000, 189282960],
            [992304000000, 189803655],
            [992390400000, 190273680],
            [992476800000, 190781690],
            [992563200000, 191483605],
            [992649600000, 192612000],
            [992736000000, 193482730],
            [992822400000, 193767050],
            [992908800000, 194060045],
            [992995200000, 194345070],
            [993081600000, 194638625],
            [993168000000, 195124955],
            [993254400000, 195762215],
            [993340800000, 196209370],
            [993427200000, 196377055],
            [993513600000, 196556180],
            [993600000000, 196724205],
            [993686400000, 196908430],
            [993772800000, 197235115],
            [993859200000, 197710305],
            [993945600000, 198051820],
            [994032000000, 198215170],
            [994118400000, 198418120],
            [994204800000, 198566675],
            [994291200000, 198682160],
            [994377600000, 198894855],
            [994464000000, 199185545],
            [994550400000, 199391125],
            [994636800000, 199476205],
            [994723200000, 199579010],
            [994809600000, 199667635],
            [994896000000, 199759805],
            [994982400000, 199890265],
            [995068800000, 200082990],
            [995155200000, 200219380],
            [995241600000, 200281645],
            [995328000000, 200355770],
            [995414400000, 200415225],
            [995500800000, 200468595],
            [995587200000, 200538255],
            [995673600000, 200635005],
            [995760000000, 200691120],
            [995846400000, 200720145],
            [995932800000, 200754975],
            [996019200000, 200787870],
            [996105600000, 200818830],
            [996192000000, 200856345],
            [996278400000, 200916360],
            [996364800000, 200945110],
            [996451200000, 200965095],
            [996537600000, 200986345],
            [996624000000, 201006370],
            [996710400000, 201027495],
            [996796800000, 201055315],
            [996883200000, 201093835],
            [996969600000, 201121610],
            [997056000000, 201136590],
            [997142400000, 201152640],
            [997228800000, 201167645],
            [997315200000, 201182600],
            [997401600000, 201207850],
            [997488000000, 201243215],
            [997574400000, 201270485],
            [997660800000, 201283615],
            [997747200000, 201298765],
            [997833600000, 201312905],
            [997920000000, 201327130],
            [998006400000, 201349550],
            [998092800000, 201383770],
            [998179200000, 201408515],
            [998265600000, 201421495],
            [998352000000, 201436835],
            [998438400000, 201450930],
            [998524800000, 201465035],
            [998611200000, 201485465],
            [998697600000, 201518470],
            [998784000000, 201541245],
            [998870400000, 201552595],
            [998956800000, 201566215],
            [999043200000, 201578700],
            [999129600000, 201591095],
            [999216000000, 201608860],
            [999302400000, 201644390],
            [999388800000, 201678875],
            [999475200000, 201707090],
            [999561600000, 201716505],
            [999648000000, 201724930],
            [999734400000, 201733280],
            [999820800000, 201749930],
            [999907200000, 201782305],
            [999993600000, 201801730],
            [1000080000000, 201807285],
            [1000166400000, 201810895],
            [1000252800000, 201816520],
            [1000339200000, 201822045],
            [1000425600000, 201836340],
            [1000512000000, 201862395],
            [1000598400000, 201880060],
            [1000684800000, 201885100],
            [1000771200000, 201890980],
            [1000857600000, 201895975],
            [1000944000000, 201900940],
            [1001030400000, 201912375],
            [1001116800000, 201935970],
            [1001203200000, 201950275],
            [1001289600000, 201954570],
            [1001376000000, 201958885],
            [1001462400000, 201963130],
            [1001548800000, 201967365],
            [1001635200000, 201977060],
            [1001721600000, 201996485],
            [1001808000000, 202007640],
            [1001894400000, 202010550],
            [1001980800000, 202013445],
            [1002067200000, 202016390],
            [1002153600000, 202019785]
        ],
        name: 'mummyreturns',
        showInLegend: false,
        extra: {
            title: 'The Mummy Returns',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#5B301F'
        },
        showlabel: false,
        color: 'rgba(91,48,31,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                899251200000, 9668216
            ],
            [899337600000, 18112703]
        ],
        name: 'armageddon',
        showInLegend: false,
        extra: {
            title: 'Armageddon',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#3F1C1A'
        },
        showlabel: false,
        color: 'rgba(63,28,26,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1426204800000, 22996095
            ],
            [1426291200000, 50051849],
            [1426377600000, 67877361],
            [1426464000000, 72688668],
            [1426550400000, 78505261],
            [1426636800000, 83077630],
            [1426723200000, 87549134],
            [1426809600000, 97022847],
            [1426896000000, 112310347],
            [1426982400000, 122516793],
            [1427068800000, 125008699],
            [1427155200000, 128043988],
            [1427241600000, 130268607],
            [1427328000000, 132507529],
            [1427414400000, 137324846],
            [1427500800000, 144832385],
            [1427587200000, 149551020],
            [1427673600000, 151131952],
            [1427760000000, 153247557],
            [1427846400000, 154916199],
            [1427932800000, 156961118],
            [1428019200000, 161041826],
            [1428105600000, 164852616],
            [1428192000000, 167139868],
            [1428278400000, 168992044],
            [1428364800000, 170799171],
            [1428451200000, 172210312],
            [1428537600000, 173548726],
            [1428624000000, 175838354],
            [1428710400000, 178932478],
            [1428796800000, 180686540],
            [1428883200000, 181079591],
            [1428969600000, 181633138],
            [1429056000000, 182036467],
            [1429142400000, 182453013],
            [1429228800000, 183527455],
            [1429315200000, 185306565],
            [1429401600000, 186478482],
            [1429488000000, 186805015],
            [1429574400000, 187178992],
            [1429660800000, 187476656],
            [1429747200000, 187794430],
            [1429833600000, 188489040],
            [1429920000000, 189823751],
            [1430006400000, 190559996],
            [1430092800000, 190732980],
            [1430179200000, 190954301],
            [1430265600000, 191121276],
            [1430352000000, 191293370],
            [1430438400000, 192270170],
            [1430524800000, 193546851],
            [1430611200000, 194038460],
            [1430697600000, 194168634],
            [1430784000000, 194319691],
            [1430870400000, 194455621],
            [1430956800000, 194592419],
            [1431043200000, 195021634],
            [1431129600000, 195749710],
            [1431216000000, 196273979],
            [1431302400000, 196356635],
            [1431388800000, 196450113],
            [1431475200000, 196530668],
            [1431561600000, 196599551],
            [1431648000000, 196763084],
            [1431734400000, 197040183],
            [1431820800000, 197231159],
            [1431907200000, 197286859],
            [1431993600000, 197340672],
            [1432080000000, 197387498],
            [1432166400000, 197442446],
            [1432512000000, 197998802]
        ],
        name: 'cinderella2015',
        showInLegend: false,
        extra: {
            title: 'Cinderella (2015)',
            genre: 'Fantasy',

            mpaaRating: 'PG',
            imgMainColor: '#46546C'
        },
        showlabel: false,
        color: 'rgba(70,84,108,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1290556800000, 11869194
            ],
            [1290643200000, 19939246],
            [1290729600000, 39488071],
            [1290816000000, 58041144],
            [1290902400000, 68706298],
            [1290988800000, 70477467],
            [1291075200000, 72174989],
            [1291161600000, 73534340],
            [1291248000000, 74961921],
            [1291334400000, 80108319],
            [1291420800000, 90055829],
            [1291507200000, 96570812],
            [1291593600000, 97620466],
            [1291680000000, 98875621],
            [1291766400000, 99972124],
            [1291852800000, 101063873],
            [1291939200000, 104485091],
            [1292025600000, 111175112],
            [1292112000000, 115395560],
            [1292198400000, 116267638],
            [1292284800000, 117269824],
            [1292371200000, 118136279],
            [1292457600000, 119142932],
            [1292544000000, 121325231],
            [1292630400000, 125111987],
            [1292716800000, 127918276],
            [1292803200000, 129906950],
            [1292889600000, 132369375],
            [1292976000000, 134624911],
            [1293062400000, 137267507],
            [1293148800000, 138989800],
            [1293235200000, 141063978],
            [1293321600000, 143695323],
            [1293408000000, 146933756],
            [1293494400000, 150559830],
            [1293580800000, 154278547],
            [1293667200000, 158018895],
            [1293753600000, 161284390],
            [1293840000000, 165041116],
            [1293926400000, 167821986],
            [1294012800000, 168953925],
            [1294099200000, 169668269],
            [1294185600000, 170182089],
            [1294272000000, 170668398],
            [1294358400000, 171836832],
            [1294444800000, 174275710],
            [1294531200000, 175779496],
            [1294617600000, 176055242],
            [1294704000000, 176374327],
            [1294790400000, 176697860],
            [1294876800000, 177028039],
            [1294963200000, 177860789],
            [1295049600000, 179630053],
            [1295136000000, 181011048],
            [1295222400000, 182666695],
            [1295308800000, 182910770],
            [1295395200000, 183086683],
            [1295481600000, 183274499],
            [1295568000000, 183924775],
            [1295654400000, 185488577],
            [1295740800000, 186356425],
            [1295827200000, 186540029],
            [1295913600000, 186702672],
            [1296000000000, 186851747],
            [1296086400000, 187050224],
            [1296172800000, 187553019],
            [1296259200000, 188766536],
            [1296345600000, 189576785],
            [1296432000000, 189725515],
            [1296518400000, 189863934],
            [1296604800000, 190049768],
            [1296691200000, 190222675],
            [1296777600000, 190619704],
            [1296864000000, 191618427],
            [1296950400000, 192073303],
            [1297036800000, 192177237],
            [1297123200000, 192277221],
            [1297209600000, 192376711],
            [1297296000000, 192490847],
            [1297382400000, 192649144],
            [1297468800000, 193048261],
            [1297555200000, 193304696],
            [1297641600000, 193410635],
            [1297728000000, 193459198],
            [1297814400000, 193505998],
            [1297900800000, 193563587],
            [1298332800000, 194361955],
            [1298419200000, 194407915],
            [1298505600000, 194459788],
            [1306713600000, 200807262]
        ],
        name: 'rapunzel',
        showInLegend: false,
        extra: {
            title: 'Tangled',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#647057'
        },
        showlabel: false,
        color: 'rgba(100,112,87,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1400198400000, 38410607
            ],
            [1400284800000, 70570970],
            [1400371200000, 93188384],
            [1400457600000, 100860422],
            [1400544000000, 107804839],
            [1400630400000, 112767036],
            [1400716800000, 117348367],
            [1400803200000, 126148302],
            [1400889600000, 137921427],
            [1400976000000, 148294783],
            [1401062400000, 155785665],
            [1401148800000, 158475065],
            [1401235200000, 160584332],
            [1401321600000, 162431557],
            [1401408000000, 165776077],
            [1401494400000, 171022099],
            [1401580800000, 174439686],
            [1401667200000, 175592665],
            [1401753600000, 176962800],
            [1401840000000, 178079801],
            [1401926400000, 179093006],
            [1402012800000, 180874434],
            [1402099200000, 183383565],
            [1402185600000, 185214185],
            [1402272000000, 185966351],
            [1402358400000, 186821483],
            [1402444800000, 187564600],
            [1402531200000, 188146009],
            [1402617600000, 189026296],
            [1402704000000, 190236206],
            [1402790400000, 191457194],
            [1402876800000, 191840656],
            [1402963200000, 192298758],
            [1403049600000, 192695911],
            [1403136000000, 193095084],
            [1403222400000, 193649614],
            [1403308800000, 194428943],
            [1403395200000, 194983388],
            [1403481600000, 195246498],
            [1403568000000, 195576736],
            [1403654400000, 195860744],
            [1403740800000, 196085100],
            [1403827200000, 196382810],
            [1403913600000, 196755173],
            [1404000000000, 197020138],
            [1404086400000, 197167286],
            [1404172800000, 197309422],
            [1404259200000, 197378517],
            [1404345600000, 197483614],
            [1404432000000, 197595179],
            [1404518400000, 197777509],
            [1404604800000, 197902722],
            [1404691200000, 197955311],
            [1404777600000, 198013685],
            [1404864000000, 198060384],
            [1404950400000, 198108951],
            [1405036800000, 198186710],
            [1405123200000, 198284421],
            [1405209600000, 198355185],
            [1405296000000, 198390567],
            [1405382400000, 198432086],
            [1405468800000, 198468622],
            [1405555200000, 198504792],
            [1405641600000, 198652263],
            [1405728000000, 198863001],
            [1405814400000, 199019979],
            [1405900800000, 199090849],
            [1405987200000, 199170223],
            [1406073600000, 199244834],
            [1406160000000, 199317206],
            [1406246400000, 199427917],
            [1406332800000, 199579897],
            [1406419200000, 199704025],
            [1406505600000, 199760646],
            [1406592000000, 199818664],
            [1406678400000, 199870300],
            [1406764800000, 199922103],
            [1406851200000, 199993378],
            [1406937600000, 200087140],
            [1407024000000, 200163953],
            [1407110400000, 200199287],
            [1407196800000, 200239568],
            [1407283200000, 200270209],
            [1407369600000, 200300724],
            [1407456000000, 200338952],
            [1407542400000, 200392764],
            [1407628800000, 200435308],
            [1407715200000, 200453763],
            [1407801600000, 200472956],
            [1407888000000, 200490121],
            [1407974400000, 200506545],
            [1408060800000, 200527340],
            [1408147200000, 200560716],
            [1408233600000, 200587132],
            [1408320000000, 200597134],
            [1408406400000, 200607036],
            [1408492800000, 200616740],
            [1408579200000, 200626327],
            [1408665600000, 200635442],
            [1408752000000, 200651731],
            [1408838400000, 200661309],
            [1408924800000, 200664806],
            [1409011200000, 200668407],
            [1409097600000, 200672193],
            [1409184000000, 200676069]
        ],
        name: 'godzilla2012',
        showInLegend: false,
        extra: {
            title: 'Godzilla (2014)',
            genre: 'Sci-Fi Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#644C46'
        },
        showlabel: false,
        color: 'rgba(100,76,70,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1151366400000, 3000000
            ],
            [1151452800000, 21037277],
            [1151539200000, 32058444],
            [1151625600000, 48376870],
            [1151712000000, 66795937],
            [1151798400000, 84593540],
            [1151884800000, 97581594],
            [1151971200000, 108091711],
            [1152057600000, 114516981],
            [1152144000000, 119827424],
            [1152230400000, 126785796],
            [1152316800000, 135293439],
            [1152403200000, 141642667],
            [1152489600000, 144297955],
            [1152576000000, 146926451],
            [1152662400000, 149580601],
            [1152748800000, 152027786],
            [1152835200000, 155398932],
            [1152921600000, 160349817],
            [1153008000000, 164316103],
            [1153094400000, 166017362],
            [1153180800000, 167742734],
            [1153267200000, 169310014],
            [1153353600000, 170967498],
            [1153440000000, 172928938],
            [1153526400000, 176001351],
            [1153612800000, 178342711],
            [1153699200000, 179297795],
            [1153785600000, 180245955],
            [1153872000000, 181118165],
            [1153958400000, 182006455],
            [1154044800000, 183037450],
            [1154131200000, 184592241],
            [1154217600000, 185794683],
            [1154304000000, 186352835],
            [1154390400000, 186921324],
            [1154476800000, 187475542],
            [1154563200000, 188018343],
            [1154649600000, 188636020],
            [1154736000000, 189518749],
            [1154822400000, 190176570],
            [1154908800000, 190524000],
            [1154995200000, 190827245],
            [1155081600000, 191088406],
            [1155168000000, 191351698],
            [1155254400000, 191700378],
            [1155340800000, 192224888],
            [1155427200000, 192594159],
            [1155513600000, 192777481],
            [1155600000000, 192961820],
            [1155686400000, 193139220],
            [1155772800000, 193317491],
            [1155859200000, 193538851],
            [1155945600000, 193914906],
            [1156032000000, 194165746],
            [1156118400000, 194278004],
            [1156204800000, 194386206],
            [1156291200000, 194493540],
            [1156377600000, 194607832],
            [1156464000000, 194813705],
            [1156550400000, 195153637],
            [1156636800000, 195388237],
            [1156723200000, 195476617],
            [1156809600000, 195559823],
            [1156896000000, 195631947],
            [1156982400000, 195701916],
            [1157068800000, 195877918],
            [1157155200000, 196224473],
            [1157241600000, 196576057],
            [1157328000000, 196817144],
            [1157414400000, 196875477],
            [1157500800000, 196927967],
            [1157587200000, 196977353],
            [1157673600000, 197086124],
            [1157760000000, 197301029],
            [1157846400000, 197430626],
            [1157932800000, 197472088],
            [1158019200000, 197519424],
            [1158105600000, 197568180],
            [1158192000000, 197621681],
            [1158278400000, 197724420],
            [1158364800000, 197902148],
            [1158451200000, 198008105],
            [1158537600000, 198041447],
            [1158624000000, 198078865],
            [1158710400000, 198113009],
            [1158796800000, 198145682],
            [1158883200000, 198226228],
            [1158969600000, 198373826],
            [1159056000000, 198447055],
            [1159142400000, 198466604],
            [1159228800000, 198484797],
            [1159315200000, 198507265],
            [1159401600000, 198532563],
            [1159488000000, 198637340],
            [1159574400000, 198811270],
            [1159660800000, 198935940],
            [1159747200000, 198976323],
            [1159833600000, 199018781],
            [1159920000000, 199056144],
            [1160006400000, 199098030],
            [1160092800000, 199179548],
            [1160179200000, 199313700],
            [1160265600000, 199394532],
            [1160352000000, 199429968],
            [1160438400000, 199460092],
            [1160524800000, 199487722],
            [1160611200000, 199516475],
            [1160697600000, 199578759],
            [1160784000000, 199675190],
            [1160870400000, 199732905],
            [1160956800000, 199755531],
            [1161043200000, 199783341],
            [1161129600000, 199806686],
            [1161216000000, 199833005],
            [1161302400000, 199882023],
            [1161388800000, 199959920],
            [1161475200000, 200006305],
            [1161561600000, 200011869],
            [1161648000000, 200017484],
            [1161734400000, 200022181],
            [1161820800000, 200028903],
            [1161907200000, 200044461],
            [1161993600000, 200059988],
            [1162080000000, 200069408],
            [1162166400000, 200072600],
            [1162252800000, 200075112],
            [1162339200000, 200077851],
            [1162425600000, 200081192]
        ],
        name: 'superman06',
        showInLegend: false,
        extra: {
            title: 'Superman Returns',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#4B4A44'
        },
        showlabel: false,
        color: 'rgba(75,74,68,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1446768000000, 27434579
            ],
            [1446854400000, 53718385],
            [1446940800000, 70403148],
            [1447027200000, 75720027],
            [1447113600000, 83041709],
            [1447200000000, 90957011],
            [1447286400000, 95300181],
            [1447372800000, 105416135],
            [1447459200000, 120488438],
            [1447545600000, 128981285],
            [1447632000000, 131411839],
            [1447718400000, 134659531],
            [1447804800000, 137042589],
            [1447891200000, 139102879],
            [1447977600000, 143375129],
            [1448064000000, 149928253],
            [1448150400000, 154146608],
            [1448236800000, 155716059],
            [1448323200000, 157901967],
            [1448409600000, 160560179],
            [1448496000000, 163237407],
            [1448582400000, 168493003],
            [1448668800000, 173578228],
            [1448755200000, 176125179],
            [1448841600000, 176837257],
            [1448928000000, 177732119],
            [1449014400000, 178416219],
            [1449100800000, 179095343],
            [1449187200000, 180703878],
            [1449273600000, 183216227],
            [1449360000000, 184618701],
            [1449446400000, 185092708],
            [1449532800000, 185745058],
            [1449619200000, 186258571],
            [1449705600000, 186767660],
            [1449792000000, 187885170],
            [1449878400000, 189736398],
            [1449964800000, 190812769],
            [1450051200000, 191221467],
            [1450137600000, 191738839],
            [1450224000000, 192180199],
            [1450310400000, 192476132],
            [1450396800000, 192833480],
            [1450483200000, 193446975],
            [1450569600000, 193910089],
            [1450656000000, 194257356],
            [1450742400000, 194674955],
            [1450828800000, 195057914],
            [1450915200000, 195381545],
            [1451001600000, 195650100],
            [1451088000000, 195989063],
            [1451174400000, 196268667],
            [1451260800000, 196488760],
            [1451347200000, 196704209],
            [1451433600000, 196921234],
            [1451520000000, 197102585],
            [1451606400000, 197379892],
            [1451692800000, 197682067],
            [1451779200000, 197833291],
            [1451865600000, 197902769],
            [1451952000000, 197978617],
            [1452038400000, 198038905],
            [1452124800000, 198096529],
            [1452211200000, 198212194],
            [1452297600000, 198398921],
            [1452384000000, 198500048],
            [1452470400000, 198532644],
            [1452556800000, 198579597],
            [1452643200000, 198619963],
            [1452729600000, 198659613],
            [1452816000000, 198741503],
            [1452902400000, 198864135],
            [1452988800000, 198951014],
            [1453075200000, 199010902],
            [1453161600000, 199044149],
            [1453248000000, 199072464],
            [1453334400000, 199100327],
            [1453420800000, 199152595],
            [1453507200000, 199234198],
            [1453593600000, 199270555],
            [1453680000000, 199285272],
            [1453766400000, 199304678],
            [1453852800000, 199322749],
            [1453939200000, 199343065],
            [1454025600000, 199380757],
            [1454112000000, 199442492],
            [1454198400000, 199475816],
            [1454284800000, 199486820],
            [1454371200000, 199499323],
            [1454457600000, 199510902],
            [1454544000000, 199524144],
            [1454630400000, 199547236],
            [1454716800000, 199582193],
            [1454803200000, 199591466],
            [1454889600000, 199597969],
            [1454976000000, 199605015],
            [1455062400000, 199611642],
            [1455148800000, 199620334],
            [1455235200000, 199630395],
            [1455321600000, 199647072],
            [1455408000000, 199658147],
            [1455494400000, 199662807],
            [1455580800000, 199665313],
            [1455667200000, 199667391],
            [1455753600000, 199669852],
            [1455840000000, 199698007],
            [1455926400000, 199748728],
            [1456012800000, 199778275],
            [1456099200000, 199789033],
            [1456185600000, 199801022],
            [1456272000000, 199813997],
            [1456358400000, 199824527],
            [1456444800000, 199831296],
            [1456531200000, 199841615],
            [1456617600000, 199847683],
            [1456704000000, 199851020],
            [1456790400000, 199854632],
            [1456876800000, 199857903],
            [1456963200000, 199860885],
            [1457049600000, 199869199],
            [1457136000000, 199882003],
            [1457222400000, 199890642],
            [1457308800000, 199894416],
            [1457395200000, 199898500],
            [1457481600000, 199902225],
            [1457568000000, 199906501],
            [1457654400000, 199920997],
            [1457740800000, 199941247],
            [1457827200000, 199948480]
        ],
        name: 'bond24',
        showInLegend: false,
        extra: {
            title: 'Spectre',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#47505A'
        },
        showlabel: false,
        color: 'rgba(71,80,90,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                990748800000, 18698412
            ],
            [990835200000, 39329051],
            [990921600000, 59078912],
            [991008000000, 75177654],
            [991094400000, 80644106],
            [991180800000, 85079974],
            [991267200000, 89245163],
            [991353600000, 97933163],
            [991440000000, 110828163],
            [991526400000, 118853439],
            [991612800000, 121584453],
            [991699200000, 124488499],
            [991785600000, 126918835],
            [991872000000, 129266081],
            [991958400000, 133624081],
            [992044800000, 139989081],
            [992131200000, 143987500],
            [992217600000, 145687723],
            [992304000000, 147423263],
            [992390400000, 148903638],
            [992476800000, 150499372],
            [992563200000, 153181372],
            [992649600000, 157304372],
            [992736000000, 160358492],
            [992822400000, 161487847],
            [992908800000, 162698845],
            [992995200000, 163830761],
            [993081600000, 165067822],
            [993168000000, 167113822],
            [993254400000, 170045822],
            [993340800000, 171886718],
            [993427200000, 172657199],
            [993513600000, 173478667],
            [993600000000, 174251514],
            [993686400000, 175008658],
            [993772800000, 176300658],
            [993859200000, 178277658],
            [993945600000, 179731614],
            [994032000000, 180442915],
            [994118400000, 181483774],
            [994204800000, 182689055],
            [994291200000, 183257746],
            [994377600000, 184205746],
            [994464000000, 185536746],
            [994550400000, 186599845],
            [994636800000, 186979827],
            [994723200000, 187402519],
            [994809600000, 187780939],
            [994896000000, 188144073]
        ],
        name: 'pearlharbor',
        showInLegend: false,
        extra: {
            title: 'Pearl Harbor',
            genre: 'War',

            mpaaRating: 'PG-13',
            imgMainColor: '#3F4035'
        },
        showlabel: false,
        color: 'rgba(63,64,53,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1238112000000, 16754032
            ],
            [1238198400000, 41038807],
            [1238284800000, 59321095],
            [1238371200000, 62843553],
            [1238457600000, 66213625],
            [1238544000000, 69223789],
            [1238630400000, 72190222],
            [1238716800000, 80981758],
            [1238803200000, 95301242],
            [1238889600000, 104799387],
            [1238976000000, 108000778],
            [1239062400000, 111541943],
            [1239148800000, 114699054],
            [1239235200000, 118391546],
            [1239321600000, 127498021],
            [1239408000000, 135610628],
            [1239494400000, 140203799],
            [1239580800000, 143582621],
            [1239667200000, 146002220],
            [1239753600000, 148054400],
            [1239840000000, 149823232],
            [1239926400000, 153344846],
            [1240012800000, 158934176],
            [1240099200000, 163063465],
            [1240185600000, 163944982],
            [1240272000000, 164820177],
            [1240358400000, 165553958],
            [1240444800000, 166293004],
            [1240531200000, 168320343],
            [1240617600000, 172121277],
            [1240704000000, 174813830],
            [1240790400000, 175262372],
            [1240876800000, 175735612],
            [1240963200000, 176157854],
            [1241049600000, 176604542],
            [1241136000000, 177908173],
            [1241222400000, 180536287],
            [1241308800000, 182407971],
            [1241395200000, 182708212],
            [1241481600000, 183000296],
            [1241568000000, 183290526],
            [1241654400000, 183513652],
            [1241740800000, 184190214],
            [1241827200000, 185644716],
            [1241913600000, 186774092],
            [1242000000000, 186959750],
            [1242086400000, 187151273],
            [1242172800000, 187343868],
            [1242259200000, 187551681],
            [1242345600000, 188139411],
            [1242432000000, 189612557],
            [1242518400000, 190733766],
            [1242604800000, 191084637],
            [1242691200000, 191287457],
            [1242777600000, 191460101],
            [1242864000000, 191645864],
            [1242950400000, 191940843],
            [1243036800000, 192531519],
            [1243123200000, 193105062],
            [1243209600000, 193706544],
            [1243296000000, 193841084],
            [1243382400000, 193972168],
            [1243468800000, 194101824],
            [1243555200000, 194186936],
            [1243641600000, 194326982],
            [1243728000000, 194421864],
            [1243814400000, 194457022],
            [1243900800000, 194496467],
            [1243987200000, 194537432],
            [1244073600000, 194583608],
            [1244160000000, 194657717],
            [1244246400000, 194778930],
            [1244332800000, 194854481],
            [1244419200000, 194885266],
            [1244505600000, 194925752],
            [1244592000000, 194970154],
            [1244678400000, 195015626],
            [1244764800000, 195083406],
            [1244851200000, 195168072],
            [1244937600000, 195220748],
            [1245024000000, 195246609],
            [1245110400000, 195283263],
            [1245196800000, 195314804],
            [1245283200000, 195348551],
            [1245369600000, 195397851],
            [1245456000000, 195459579],
            [1245542400000, 195513959],
            [1245628800000, 195536087],
            [1245715200000, 195565262],
            [1245801600000, 195591968],
            [1245888000000, 195618975],
            [1245974400000, 195736266],
            [1246060800000, 195877458],
            [1246147200000, 195984055],
            [1246233600000, 196049680],
            [1246320000000, 196139512],
            [1246406400000, 196216732],
            [1246492800000, 196305740],
            [1246579200000, 196417434],
            [1246665600000, 196485314],
            [1246752000000, 196564095],
            [1246838400000, 196614318],
            [1246924800000, 196677035],
            [1247011200000, 196774612],
            [1247097600000, 196866513],
            [1247184000000, 196948353],
            [1247270400000, 197049321],
            [1247356800000, 197116821],
            [1247443200000, 197154779],
            [1247529600000, 197206222],
            [1247616000000, 197251650],
            [1247702400000, 197297256],
            [1247788800000, 197358343],
            [1247875200000, 197431697],
            [1247961600000, 197482447],
            [1248048000000, 197512077],
            [1248134400000, 197556095],
            [1248220800000, 197600244],
            [1248307200000, 197643168],
            [1248393600000, 197685862],
            [1248480000000, 197741375],
            [1248566400000, 197777362],
            [1248652800000, 197798762],
            [1248739200000, 197830081],
            [1248825600000, 197863834],
            [1248912000000, 197895942],
            [1248998400000, 197926692],
            [1249084800000, 197961656],
            [1249171200000, 197987264],
            [1249257600000, 198001228],
            [1249344000000, 198021110],
            [1249430400000, 198038526],
            [1249516800000, 198057578],
            [1249603200000, 198081884],
            [1249689600000, 198115880],
            [1249776000000, 198135894],
            [1249862400000, 198146611],
            [1249948800000, 198162530],
            [1250035200000, 198184815],
            [1250121600000, 198200119],
            [1250208000000, 198216576],
            [1250294400000, 198239680],
            [1250380800000, 198255437],
            [1250467200000, 198262937],
            [1250553600000, 198273272],
            [1250640000000, 198282222],
            [1250726400000, 198291863],
            [1250812800000, 198302871],
            [1250899200000, 198319668],
            [1250985600000, 198332128],
            [1251072000000, 198336693],
            [1251158400000, 198341752],
            [1251244800000, 198346452],
            [1251331200000, 198351526]
        ],
        name: 'monstersvsaliens',
        showInLegend: false,
        extra: {
            title: 'Monsters Vs. Aliens',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#5E7B9B'
        },
        showlabel: false,
        color: 'rgba(94,123,155,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1163721600000, 12257221
            ],
            [1163808000000, 29385354],
            [1163894400000, 41533432],
            [1163980800000, 44555879],
            [1164067200000, 48611248],
            [1164153600000, 56073511],
            [1164240000000, 62218720],
            [1164326400000, 77540999],
            [1164412800000, 91469361],
            [1164499200000, 99256766],
            [1164585600000, 100611069],
            [1164672000000, 101794475],
            [1164758400000, 102872472],
            [1164844800000, 103955600],
            [1164931200000, 108258829],
            [1165017600000, 116486219],
            [1165104000000, 121501018],
            [1165190400000, 122328314],
            [1165276800000, 123212756],
            [1165363200000, 124100113],
            [1165449600000, 125028428],
            [1165536000000, 128112940],
            [1165622400000, 134122491],
            [1165708800000, 137932841],
            [1165795200000, 138612221],
            [1165881600000, 139344614],
            [1165968000000, 140096949],
            [1166054400000, 140886370],
            [1166140800000, 142980522],
            [1166227200000, 146689742],
            [1166313600000, 149244791],
            [1166400000000, 150171217],
            [1166486400000, 151217515],
            [1166572800000, 152410947],
            [1166659200000, 153956163],
            [1166745600000, 155791587],
            [1166832000000, 158003237],
            [1166918400000, 159119637],
            [1167004800000, 160521910],
            [1167091200000, 162982116],
            [1167177600000, 165616333],
            [1167264000000, 168317446],
            [1167350400000, 171180852],
            [1167436800000, 173998891],
            [1167523200000, 175967627],
            [1167609600000, 178325897],
            [1167696000000, 179670135],
            [1167782400000, 180571407],
            [1167868800000, 181409720],
            [1167955200000, 182440982],
            [1168041600000, 184161812],
            [1168128000000, 185414182],
            [1168214400000, 185625671],
            [1168300800000, 185808923],
            [1168387200000, 185993411],
            [1168473600000, 186185850],
            [1168560000000, 186503227],
            [1168646400000, 187430536],
            [1168732800000, 188209088],
            [1168819200000, 189052102],
            [1168905600000, 189170286],
            [1168992000000, 189283564],
            [1169078400000, 189387661],
            [1169164800000, 189594338],
            [1169251200000, 190270121],
            [1169337600000, 190695949],
            [1169424000000, 190787359],
            [1169510400000, 190858381],
            [1169596800000, 190928847],
            [1169683200000, 191006974],
            [1169769600000, 191158263],
            [1169856000000, 191584611],
            [1169942400000, 191927188],
            [1170028800000, 191985613],
            [1170115200000, 192028939],
            [1170201600000, 192073014],
            [1170288000000, 192117396],
            [1170374400000, 192220912],
            [1170460800000, 192529795],
            [1170547200000, 192708687],
            [1170633600000, 192745702],
            [1170720000000, 192785010],
            [1170806400000, 192817393],
            [1170892800000, 192850112],
            [1170979200000, 192927427],
            [1171065600000, 193180787],
            [1171152000000, 193383272],
            [1171238400000, 193420639],
            [1171324800000, 193443128],
            [1171411200000, 193476347],
            [1171497600000, 193510595],
            [1171584000000, 193559845],
            [1171670400000, 193686285],
            [1171756800000, 193800551],
            [1171843200000, 193920972],
            [1171929600000, 193957250],
            [1172016000000, 193994061],
            [1172102400000, 194033061],
            [1172188800000, 194083880],
            [1172275200000, 194183114],
            [1172361600000, 194254584],
            [1172448000000, 194270777],
            [1172534400000, 194282842],
            [1172620800000, 194295736],
            [1172707200000, 194309949],
            [1172793600000, 194379736],
            [1172880000000, 194589796],
            [1172966400000, 194776258],
            [1173052800000, 194812561],
            [1173139200000, 194853788],
            [1173225600000, 194889977],
            [1173312000000, 194929043],
            [1173398400000, 195073764],
            [1173484800000, 195358577],
            [1173571200000, 195551539],
            [1173657600000, 195634003],
            [1173744000000, 195732015],
            [1173830400000, 195836281],
            [1173916800000, 195945660],
            [1174003200000, 196123862],
            [1174089600000, 196382577],
            [1174176000000, 196561994],
            [1174262400000, 196618328],
            [1174348800000, 196679533],
            [1174435200000, 196743638],
            [1174521600000, 196811996],
            [1174608000000, 196918078],
            [1174694400000, 197100919],
            [1174780800000, 197207309],
            [1174867200000, 197241776],
            [1174953600000, 197281865],
            [1175040000000, 197320044],
            [1175126400000, 197359338],
            [1175212800000, 197415467],
            [1175299200000, 197504210],
            [1175385600000, 197560897],
            [1175472000000, 197576259],
            [1175558400000, 197596164],
            [1175644800000, 197618169],
            [1175731200000, 197645436],
            [1175817600000, 197690627],
            [1175904000000, 197735813],
            [1175990400000, 197756995],
            [1176076800000, 197772703],
            [1176163200000, 197784956],
            [1176249600000, 197797059],
            [1176336000000, 197809622],
            [1176422400000, 197824038],
            [1176508800000, 197850509],
            [1176595200000, 197865227],
            [1176681600000, 197867858],
            [1176768000000, 197871231],
            [1176854400000, 197875520],
            [1176940800000, 197880068],
            [1177027200000, 197889493],
            [1177113600000, 197907949],
            [1177200000000, 197918727],
            [1177286400000, 197920733],
            [1177372800000, 197923431],
            [1177459200000, 197927077],
            [1177545600000, 197930988],
            [1177632000000, 197938186],
            [1177718400000, 197952528],
            [1177804800000, 197961083],
            [1177891200000, 197962788],
            [1177977600000, 197965028],
            [1178064000000, 197968091],
            [1178150400000, 197971415],
            [1178236800000, 197976454],
            [1178323200000, 197986924],
            [1178409600000, 197992827],
            [1178496000000, 197994021],
            [1178582400000, 197995634],
            [1178668800000, 197997824],
            [1178755200000, 198000317]
        ],
        name: 'happyfeet',
        showInLegend: false,
        extra: {
            title: 'Happy Feet',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#90ADC9'
        },
        showlabel: false,
        color: 'rgba(144,173,201,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                612144000000, 17889583
            ],
            [612230400000, 29071012],
            [612316800000, 39255220],
            [612403200000, 46931772]
        ],
        name: 'indianajonesandthelastcrusade',
        showInLegend: false,
        extra: {
            title: 'Indiana Jones and the Last Crusade',
            genre: 'Period Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#C29E98'
        },
        showlabel: false,
        color: 'rgba(194,158,152,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1246406400000, 13791157
            ],
            [1246492800000, 25042486],
            [1246579200000, 42239887],
            [1246665600000, 53562393],
            [1246752000000, 66732868],
            [1246838400000, 73341295],
            [1246924800000, 80417460],
            [1247011200000, 86565945],
            [1247097600000, 92072696],
            [1247184000000, 100562891],
            [1247270400000, 111612968],
            [1247356800000, 119680193],
            [1247443200000, 123306978],
            [1247529600000, 127389669],
            [1247616000000, 130801167],
            [1247702400000, 134304581],
            [1247788800000, 139726163],
            [1247875200000, 146864128],
            [1247961600000, 151865987],
            [1248048000000, 154241190],
            [1248134400000, 157622050],
            [1248220800000, 160328318],
            [1248307200000, 163090671],
            [1248393600000, 165718620],
            [1248480000000, 168946050],
            [1248566400000, 171499101],
            [1248652800000, 172649364],
            [1248739200000, 173984570],
            [1248825600000, 175341309],
            [1248912000000, 176542789],
            [1248998400000, 178227569],
            [1249084800000, 180238539],
            [1249171200000, 182068804],
            [1249257600000, 182834011],
            [1249344000000, 183660946],
            [1249430400000, 184416992],
            [1249516800000, 185200845],
            [1249603200000, 185950645],
            [1249689600000, 186981638],
            [1249776000000, 187871005],
            [1249862400000, 188290217],
            [1249948800000, 188764152],
            [1250035200000, 189167072],
            [1250121600000, 189586747],
            [1250208000000, 189946498],
            [1250294400000, 190459768],
            [1250380800000, 190855447],
            [1250467200000, 191038252],
            [1250553600000, 191275144],
            [1250640000000, 191455470],
            [1250726400000, 191646521],
            [1250812800000, 191865541],
            [1250899200000, 192175689],
            [1250985600000, 192388059],
            [1251072000000, 192466827],
            [1251158400000, 192559205],
            [1251244800000, 192640002],
            [1251331200000, 192713610],
            [1251417600000, 192841788],
            [1251504000000, 193090981],
            [1251590400000, 193250211],
            [1251676800000, 193296935],
            [1251763200000, 193348280],
            [1251849600000, 193384067],
            [1251936000000, 193421688],
            [1252022400000, 193554670],
            [1252108800000, 193796560],
            [1252195200000, 194036834],
            [1252281600000, 194224066],
            [1252368000000, 194254067],
            [1252454400000, 194274851],
            [1252540800000, 194294898],
            [1252627200000, 194380267],
            [1252713600000, 194564996],
            [1252800000000, 194670074],
            [1252886400000, 194688731],
            [1252972800000, 194710103],
            [1253059200000, 194729017],
            [1253145600000, 194749490],
            [1253232000000, 194816450],
            [1253318400000, 194944386],
            [1253404800000, 195028506],
            [1253491200000, 195046675],
            [1253577600000, 195067769],
            [1253664000000, 195087276],
            [1253750400000, 195105433],
            [1253836800000, 195176499],
            [1253923200000, 195309804],
            [1254009600000, 195391552],
            [1254096000000, 195410547],
            [1254182400000, 195429976],
            [1254268800000, 195448014],
            [1254355200000, 195471287],
            [1254441600000, 195527883],
            [1254528000000, 195637081],
            [1254614400000, 195703253],
            [1254700800000, 195716528],
            [1254787200000, 195730537],
            [1254873600000, 195742487],
            [1254960000000, 195757564],
            [1255046400000, 195798919],
            [1255132800000, 195870362],
            [1255219200000, 195919073],
            [1255305600000, 195945497],
            [1255392000000, 195957387],
            [1255478400000, 195968410],
            [1255564800000, 195982114],
            [1255651200000, 196015646],
            [1255737600000, 196075147],
            [1255824000000, 196112522],
            [1255910400000, 196121189],
            [1255996800000, 196130685],
            [1256083200000, 196139715],
            [1256169600000, 196149907],
            [1256256000000, 196180293],
            [1256342400000, 196234804],
            [1256428800000, 196268716],
            [1256515200000, 196277557],
            [1256601600000, 196286316],
            [1256688000000, 196294544],
            [1256774400000, 196303657],
            [1256860800000, 196319592],
            [1256947200000, 196340014],
            [1257033600000, 196363405],
            [1257120000000, 196368654],
            [1257206400000, 196375512],
            [1257292800000, 196380608],
            [1257379200000, 196386285],
            [1257465600000, 196399860],
            [1257552000000, 196427084],
            [1257638400000, 196442957],
            [1257724800000, 196446880],
            [1257811200000, 196452961],
            [1257897600000, 196467737],
            [1257984000000, 196472300]
        ],
        name: 'iceage3',
        showInLegend: false,
        extra: {
            title: 'Ice Age: Dawn of the Dinosaurs',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#4F5B52'
        },
        showlabel: false,
        color: 'rgba(79,91,82,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1143763200000, 21788862
            ],
            [1143849600000, 49739637],
            [1143936000000, 68033544],
            [1144022400000, 72017777],
            [1144108800000, 75647917],
            [1144195200000, 78850362],
            [1144281600000, 81928079],
            [1144368000000, 90544980],
            [1144454400000, 106318965],
            [1144540800000, 115751973],
            [1144627200000, 118310489],
            [1144713600000, 120935523],
            [1144800000000, 123562834],
            [1144886400000, 127200291],
            [1144972800000, 135156351],
            [1145059200000, 142560370],
            [1145145600000, 147226916],
            [1145232000000, 150314711],
            [1145318400000, 152036035],
            [1145404800000, 153593547],
            [1145491200000, 155063727],
            [1145577600000, 158451413],
            [1145664000000, 164379058],
            [1145750400000, 168348135],
            [1145836800000, 168952383],
            [1145923200000, 169544432],
            [1146009600000, 170094881],
            [1146096000000, 170658113],
            [1146182400000, 172365470],
            [1146268800000, 175698363],
            [1146355200000, 177863073],
            [1146441600000, 178233397],
            [1146528000000, 178593788],
            [1146614400000, 178932769],
            [1146700800000, 179274213],
            [1146787200000, 180217361],
            [1146873600000, 182126783],
            [1146960000000, 183435937],
            [1147046400000, 183680150],
            [1147132800000, 183918985],
            [1147219200000, 184156904],
            [1147305600000, 184420315],
            [1147392000000, 185058571],
            [1147478400000, 186392868],
            [1147564800000, 187570805],
            [1147651200000, 187763732],
            [1147737600000, 187966863],
            [1147824000000, 188127017],
            [1147910400000, 188310781],
            [1147996800000, 188513963],
            [1148083200000, 188937084],
            [1148169600000, 189298746],
            [1148256000000, 189454077],
            [1148342400000, 189531002],
            [1148428800000, 189609635],
            [1148515200000, 189708822],
            [1148601600000, 189918524],
            [1148688000000, 190222436],
            [1148774400000, 190496877],
            [1148860800000, 190694600],
            [1148947200000, 190762251],
            [1149033600000, 190830800],
            [1149120000000, 190914235],
            [1149206400000, 191086907],
            [1149292800000, 191366444],
            [1149379200000, 191537740],
            [1149465600000, 191596529],
            [1149552000000, 191661312],
            [1149638400000, 191725188],
            [1149724800000, 191790013],
            [1149811200000, 191920472],
            [1149897600000, 192116797],
            [1149984000000, 192237880],
            [1150070400000, 192291094],
            [1150156800000, 192351416],
            [1150243200000, 192412248],
            [1150329600000, 192470228],
            [1150416000000, 192579279],
            [1150502400000, 192724751],
            [1150588800000, 192831967],
            [1150675200000, 192878361],
            [1150761600000, 192934814],
            [1150848000000, 192991926],
            [1150934400000, 193050973],
            [1151020800000, 193165432],
            [1151107200000, 193315882],
            [1151193600000, 193418469],
            [1151280000000, 193466771],
            [1151366400000, 193530179],
            [1151452800000, 193585117],
            [1151539200000, 193640718],
            [1151625600000, 193716419],
            [1151712000000, 193809233],
            [1151798400000, 193895570],
            [1151884800000, 193964146],
            [1151971200000, 194018792],
            [1152057600000, 194069758],
            [1152144000000, 194121228],
            [1152230400000, 194180790],
            [1152316800000, 194256512],
            [1152403200000, 194313007],
            [1152489600000, 194343308],
            [1152576000000, 194386000],
            [1152662400000, 194428651],
            [1152748800000, 194470271],
            [1152835200000, 194518015],
            [1152921600000, 194582016],
            [1153008000000, 194631351],
            [1153094400000, 194657970],
            [1153180800000, 194693096],
            [1153267200000, 194725110],
            [1153353600000, 194760034],
            [1153440000000, 194796994],
            [1153526400000, 194848106],
            [1153612800000, 194893938],
            [1153699200000, 194914465],
            [1153785600000, 194942595],
            [1153872000000, 194967739],
            [1153958400000, 194995682],
            [1154044800000, 195016982],
            [1154131200000, 195045562],
            [1154217600000, 195068166],
            [1154304000000, 195079863],
            [1154390400000, 195094094],
            [1154476800000, 195107599],
            [1154563200000, 195122952],
            [1154649600000, 195136594],
            [1154736000000, 195154421],
            [1154822400000, 195167863],
            [1154908800000, 195175719],
            [1154995200000, 195184803],
            [1155081600000, 195198233],
            [1155168000000, 195212368],
            [1155254400000, 195223715],
            [1155340800000, 195240440],
            [1155427200000, 195251850],
            [1155513600000, 195258478],
            [1155600000000, 195265757],
            [1155686400000, 195273835],
            [1155772800000, 195280719],
            [1155859200000, 195284723],
            [1155945600000, 195291559],
            [1156032000000, 195297762],
            [1156118400000, 195299501],
            [1156204800000, 195301804],
            [1156291200000, 195304236],
            [1156377600000, 195306682]
        ],
        name: 'iceage2',
        showInLegend: false,
        extra: {
            title: 'Ice Age: The Meltdown',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#477C86'
        },
        showlabel: false,
        color: 'rgba(71,124,134,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1438300800000, 20301126
            ],
            [1438387200000, 39953552],
            [1438473600000, 55520089],
            [1438560000000, 62310176],
            [1438646400000, 69542460],
            [1438732800000, 74743725],
            [1438819200000, 79254207],
            [1438905600000, 87424633],
            [1438992000000, 99302769],
            [1439078400000, 107756579],
            [1439164800000, 111072404],
            [1439251200000, 115635932],
            [1439337600000, 118566417],
            [1439424000000, 121136555],
            [1439510400000, 126057270],
            [1439596800000, 133339405],
            [1439683200000, 138323095],
            [1439769600000, 140178353],
            [1439856000000, 142605538],
            [1439942400000, 144362593],
            [1440028800000, 146063039],
            [1440115200000, 149407820],
            [1440201600000, 154374221],
            [1440288000000, 157514785],
            [1440374400000, 158566597],
            [1440460800000, 160031069],
            [1440547200000, 161063391],
            [1440633600000, 162086530],
            [1440720000000, 164262846],
            [1440806400000, 167994524],
            [1440892800000, 170242111],
            [1440979200000, 170968984],
            [1441065600000, 171861055],
            [1441152000000, 172551678],
            [1441238400000, 173236692],
            [1441324800000, 174927099],
            [1441411200000, 177616469],
            [1441497600000, 180472698],
            [1441584000000, 182662211],
            [1441670400000, 183188977],
            [1441756800000, 183612153],
            [1441843200000, 184022518],
            [1441929600000, 185118145],
            [1442016000000, 187106776],
            [1442102400000, 188122923],
            [1442188800000, 188463250],
            [1442275200000, 188901593],
            [1442361600000, 189209649],
            [1442448000000, 189482210],
            [1442534400000, 190114982],
            [1442620800000, 191169083],
            [1442707200000, 191695570],
            [1442793600000, 191875944],
            [1442880000000, 192130346],
            [1442966400000, 192351771],
            [1443052800000, 192554302],
            [1443139200000, 192813137],
            [1443225600000, 193251917],
            [1443312000000, 193455919],
            [1443398400000, 193530363],
            [1443484800000, 193635192],
            [1443571200000, 193715765],
            [1443657600000, 193776369],
            [1443744000000, 193872805],
            [1443830400000, 194026852],
            [1443916800000, 194109254],
            [1444003200000, 194135991],
            [1444089600000, 194173059],
            [1444176000000, 194201724],
            [1444262400000, 194228588],
            [1444348800000, 194316156],
            [1444435200000, 194443842],
            [1444521600000, 194522893],
            [1444608000000, 194566094],
            [1444694400000, 194599568],
            [1444780800000, 194626425],
            [1444867200000, 194654239],
            [1444953600000, 194708546],
            [1445040000000, 194786967],
            [1445126400000, 194829972],
            [1445212800000, 194844836],
            [1445299200000, 194863486],
            [1445385600000, 194879789],
            [1445472000000, 194897146],
            [1445558400000, 194928796],
            [1445644800000, 194975763],
            [1445731200000, 195000874],
            [1445817600000, 195009952],
            [1445904000000, 195021361],
            [1445990400000, 195030645],
            [1446076800000, 195042377]
        ],
        name: 'mi5',
        showInLegend: false,
        extra: {
            title: 'Mission: Impossible - Rogue Nation',
            genre: 'Action',

            mpaaRating: 'PG-13',
            imgMainColor: '#A6B4B2'
        },
        showlabel: false,
        color: 'rgba(166,180,178,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1117152000000, 13947637
            ],
            [1117238400000, 31806233],
            [1117324800000, 47224594],
            [1117411200000, 61012130],
            [1117497600000, 64847402],
            [1117584000000, 68623633],
            [1117670400000, 72267556],
            [1117756800000, 80363272],
            [1117843200000, 91966734],
            [1117929600000, 100377791],
            [1118016000000, 102926320],
            [1118102400000, 105600999],
            [1118188800000, 108377310],
            [1118275200000, 111233533],
            [1118361600000, 116101994],
            [1118448000000, 123143031],
            [1118534400000, 128414334],
            [1118620800000, 130345454],
            [1118707200000, 132293403],
            [1118793600000, 134137273],
            [1118880000000, 136094521],
            [1118966400000, 139383815],
            [1119052800000, 143624971],
            [1119139200000, 146831846],
            [1119225600000, 148282498],
            [1119312000000, 149767351],
            [1119398400000, 151314720],
            [1119484800000, 152756325],
            [1119571200000, 154965343],
            [1119657600000, 157886580],
            [1119744000000, 160191242],
            [1119830400000, 161429214],
            [1119916800000, 162816774],
            [1120003200000, 164124363],
            [1120089600000, 165429493],
            [1120176000000, 167249279],
            [1120262400000, 169207258],
            [1120348800000, 170872831],
            [1120435200000, 172131077],
            [1120521600000, 173159610],
            [1120608000000, 174257297],
            [1120694400000, 175250167],
            [1120780800000, 176637224],
            [1120867200000, 178209593],
            [1120953600000, 179259220],
            [1121040000000, 179806617],
            [1121126400000, 180444225],
            [1121212800000, 181119684],
            [1121299200000, 181774885],
            [1121385600000, 182388673],
            [1121472000000, 183272760],
            [1121558400000, 184083054],
            [1121644800000, 184439927],
            [1121731200000, 184816380],
            [1121817600000, 185170185],
            [1121904000000, 185531031],
            [1121990400000, 185856061],
            [1122076800000, 186309782],
            [1122163200000, 186730236],
            [1122249600000, 186953423],
            [1122336000000, 187221699],
            [1122422400000, 187478796],
            [1122508800000, 187673584],
            [1122595200000, 187822731],
            [1122681600000, 188038108],
            [1122768000000, 188238726],
            [1122854400000, 188360406],
            [1122940800000, 188469068],
            [1123027200000, 188582022],
            [1123113600000, 188707954],
            [1123200000000, 188823253],
            [1123286400000, 188980122],
            [1123372800000, 189114004],
            [1123459200000, 189185996],
            [1123545600000, 189280111],
            [1123632000000, 189369117],
            [1123718400000, 189458351],
            [1123804800000, 189546727],
            [1123891200000, 189669104],
            [1123977600000, 189788366],
            [1124064000000, 189840116],
            [1124150400000, 189898715],
            [1124236800000, 189949200],
            [1124323200000, 190001070],
            [1124409600000, 190062901],
            [1124496000000, 190168829],
            [1124582400000, 190252852],
            [1124668800000, 190283678],
            [1124755200000, 190325211],
            [1124841600000, 190358240],
            [1124928000000, 190386234],
            [1125014400000, 190489063],
            [1125100800000, 190687442],
            [1125187200000, 190832874],
            [1125273600000, 190874558],
            [1125360000000, 190927446],
            [1125446400000, 190976819],
            [1125532800000, 191014326],
            [1125619200000, 191116321],
            [1125705600000, 191295537],
            [1125792000000, 191465386],
            [1125878400000, 191591306],
            [1125964800000, 191615426],
            [1126051200000, 191635779],
            [1126137600000, 191657035],
            [1126224000000, 191723414],
            [1126310400000, 191862653],
            [1126396800000, 191952758],
            [1126483200000, 191982031],
            [1126569600000, 192014903],
            [1126656000000, 192042094],
            [1126742400000, 192069067],
            [1126828800000, 192132210],
            [1126915200000, 192261187],
            [1127001600000, 192342140],
            [1127088000000, 192360378],
            [1127174400000, 192381429],
            [1127260800000, 192401297],
            [1127347200000, 192423073],
            [1127433600000, 192479093],
            [1127520000000, 192586143],
            [1127606400000, 192664956],
            [1127692800000, 192688636],
            [1127779200000, 192711459],
            [1127865600000, 192728050],
            [1127952000000, 192747188],
            [1128038400000, 192794386],
            [1128124800000, 192879249],
            [1128211200000, 192933489],
            [1128297600000, 192948237],
            [1128384000000, 192965913],
            [1128470400000, 192980645],
            [1128556800000, 193000036],
            [1128643200000, 193033797],
            [1128729600000, 193096190],
            [1128816000000, 193136719],
            [1128902400000, 193166575],
            [1128988800000, 193177903],
            [1129075200000, 193187569],
            [1129161600000, 193202933]
        ],
        name: 'madagascar',
        showInLegend: false,
        extra: {
            title: 'Madagascar',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#55494B'
        },
        showlabel: false,
        color: 'rgba(85,73,75,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1227225600000, 35978348
            ],
            [1227312000000, 57265377],
            [1227398400000, 69637740],
            [1227484800000, 74152985],
            [1227571200000, 80165620],
            [1227657600000, 88130501],
            [1227744000000, 93362477],
            [1227830400000, 104236400],
            [1227916800000, 114497107],
            [1228003200000, 119706509],
            [1228089600000, 121181783],
            [1228176000000, 122658216],
            [1228262400000, 123986449],
            [1228348800000, 125355346],
            [1228435200000, 129909011],
            [1228521600000, 135250814],
            [1228608000000, 138402068],
            [1228694400000, 139337895],
            [1228780800000, 140263758],
            [1228867200000, 141173059],
            [1228953600000, 142094695],
            [1229040000000, 144673629],
            [1229126400000, 148065413],
            [1229212800000, 150045826],
            [1229299200000, 150758754],
            [1229385600000, 151533441],
            [1229472000000, 152320664],
            [1229558400000, 153233899],
            [1229644800000, 154838977],
            [1229731200000, 156850924],
            [1229817600000, 158423218],
            [1229904000000, 159776480],
            [1229990400000, 161076207],
            [1230076800000, 161591279],
            [1230163200000, 162582765],
            [1230249600000, 164180439],
            [1230336000000, 165848981],
            [1230422400000, 167325198],
            [1230508800000, 168628130],
            [1230595200000, 169925169],
            [1230681600000, 170672976],
            [1230768000000, 172274208],
            [1230854400000, 174039767],
            [1230940800000, 175827545],
            [1231027200000, 176922850],
            [1231113600000, 177355145],
            [1231200000000, 177766840],
            [1231286400000, 178167045],
            [1231372800000, 178606790],
            [1231459200000, 179505938],
            [1231545600000, 180707059],
            [1231632000000, 181448642],
            [1231718400000, 181679810],
            [1231804800000, 181921096],
            [1231891200000, 182172744],
            [1231977600000, 182465611],
            [1232064000000, 182960248],
            [1232150400000, 183672668],
            [1232236800000, 184208531],
            [1232323200000, 184585393],
            [1232409600000, 184727709],
            [1232496000000, 184871145],
            [1232582400000, 185049042],
            [1232668800000, 185323155],
            [1232755200000, 185751861],
            [1232841600000, 186027660],
            [1232928000000, 186106151],
            [1233014400000, 186191477],
            [1233100800000, 186277378],
            [1233187200000, 186387034],
            [1233273600000, 186581156],
            [1233360000000, 186878548],
            [1233446400000, 187010870],
            [1233532800000, 187066718],
            [1233619200000, 187131696],
            [1233705600000, 187194170],
            [1233792000000, 187268032],
            [1233878400000, 187402256],
            [1233964800000, 187617390],
            [1234051200000, 187748420],
            [1234137600000, 187787731],
            [1234224000000, 187828055],
            [1234310400000, 187867690],
            [1234396800000, 187922311],
            [1234483200000, 188091192],
            [1234569600000, 188397027],
            [1234656000000, 188615708],
            [1234742400000, 188753617],
            [1234828800000, 188818564],
            [1234915200000, 188881987],
            [1235001600000, 188953963],
            [1235088000000, 189097776],
            [1235174400000, 189309319],
            [1235260800000, 189443645],
            [1235347200000, 189486692],
            [1235433600000, 189533006],
            [1235520000000, 189578616],
            [1235606400000, 189633521],
            [1235692800000, 189767658],
            [1235779200000, 189976575],
            [1235865600000, 190109313],
            [1235952000000, 190160116],
            [1236038400000, 190221999],
            [1236124800000, 190279572],
            [1236211200000, 190341818],
            [1236297600000, 190450183],
            [1236384000000, 190603086],
            [1236470400000, 190691803],
            [1236556800000, 190723849],
            [1236643200000, 190757878],
            [1236729600000, 190793120],
            [1236816000000, 190838209],
            [1236902400000, 190914013],
            [1236988800000, 191028498],
            [1237075200000, 191098026],
            [1237161600000, 191130483],
            [1237248000000, 191160731],
            [1237334400000, 191195655],
            [1237420800000, 191235470],
            [1237507200000, 191290813],
            [1237593600000, 191341553],
            [1237680000000, 191368384],
            [1237766400000, 191377579],
            [1237852800000, 191388127],
            [1237939200000, 191397304],
            [1238025600000, 191407041],
            [1238112000000, 191419993],
            [1238198400000, 191438231],
            [1238284800000, 191449475],
            [1238371200000, 191453148],
            [1238457600000, 191457159],
            [1238544000000, 191460931],
            [1238630400000, 191465414],
            [1258588800000, 192769854]
        ],
        name: 'twilight08',
        showInLegend: false,
        extra: {
            title: 'Twilight',
            genre: 'Romance',

            mpaaRating: 'PG-13',
            imgMainColor: '#291E1A'
        },
        showlabel: false,
        color: 'rgba(41,30,26,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                816998400000, 4805397
            ],
            [817084800000, 9930559],
            [817171200000, 21423618],
            [817257600000, 32196904],
            [817344000000, 39071176],
            [817430400000, 40435455],
            [817516800000, 41838557],
            [817603200000, 43143864],
            [817689600000, 44509964],
            [817776000000, 49104807],
            [817862400000, 58358422],
            [817948800000, 64674626],
            [818035200000, 65783394],
            [818121600000, 67005290],
            [818208000000, 68081294],
            [818294400000, 69170281],
            [818380800000, 72305599],
            [818467200000, 78500612],
            [818553600000, 83050084],
            [818640000000, 83819863],
            [818726400000, 84748086],
            [818812800000, 85588681],
            [818899200000, 86483633],
            [818985600000, 88931054],
            [819072000000, 93836879],
            [819158400000, 97458735],
            [819244800000, 98642416],
            [819331200000, 100097755],
            [819417600000, 101684015],
            [819504000000, 103594948],
            [819590400000, 106929682],
            [819676800000, 111383106],
            [819763200000, 113453646],
            [819849600000, 115708897],
            [819936000000, 120527183],
            [820022400000, 125479891],
            [820108800000, 130609907],
            [820195200000, 136411143],
            [820281600000, 142109467],
            [820368000000, 146198683],
            [820454400000, 150004917],
            [820540800000, 151735511],
            [820627200000, 152773896],
            [820713600000, 153739624],
            [820800000000, 155641012],
            [820886400000, 158973864],
            [820972800000, 160800738],
            [821059200000, 161176916],
            [821145600000, 161631881],
            [821232000000, 162013693],
            [821318400000, 162383864],
            [821404800000, 163401995],
            [821491200000, 166373354],
            [821577600000, 168257728],
            [821664000000, 169753776],
            [821750400000, 170084505],
            [821836800000, 170335455],
            [821923200000, 170572436],
            [822009600000, 171239600],
            [822096000000, 172997566],
            [822182400000, 174243923],
            [822268800000, 174441898],
            [822355200000, 174640507],
            [822441600000, 174810523],
            [822528000000, 174984748],
            [822614400000, 175462127],
            [822700800000, 176804842],
            [822787200000, 177363558],
            [822873600000, 177494176],
            [822960000000, 177630495],
            [823046400000, 177745653],
            [823132800000, 177856021],
            [823219200000, 178107578],
            [823305600000, 178837677],
            [823392000000, 179411323],
            [823478400000, 179491482],
            [823564800000, 179574799],
            [823651200000, 179645130],
            [823737600000, 179714075],
            [823824000000, 179863086],
            [823910400000, 180302611],
            [823996800000, 180653741],
            [824083200000, 180747180],
            [824169600000, 180803651],
            [824256000000, 180881116],
            [824342400000, 180944980],
            [824428800000, 181079237],
            [824515200000, 181578334],
            [824601600000, 182063509],
            [824688000000, 182447988],
            [824774400000, 182563680],
            [824860800000, 182674465],
            [824947200000, 182782993],
            [825033600000, 182890969],
            [825120000000, 183160475],
            [825206400000, 183372334],
            [825292800000, 183400347],
            [825379200000, 183431235],
            [825465600000, 183461210],
            [825552000000, 183489944],
            [841708800000, 191780865]
        ],
        name: 'toystory',
        showInLegend: false,
        extra: {
            title: 'Toy Story',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#97B1B9'
        },
        showlabel: true,
        color: 'rgba(151,177,185,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1402617600000, 25144490
            ],
            [1402704000000, 43871359],
            [1402790400000, 57071445],
            [1402876800000, 63902371],
            [1402963200000, 71251279],
            [1403049600000, 77025650],
            [1403136000000, 82450130],
            [1403222400000, 91775306],
            [1403308800000, 102588043],
            [1403395200000, 109911125],
            [1403481600000, 113549575],
            [1403568000000, 118015151],
            [1403654400000, 121507427],
            [1403740800000, 124436892],
            [1403827200000, 129572323],
            [1403913600000, 135744534],
            [1404000000000, 140279267],
            [1404086400000, 142719235],
            [1404172800000, 145003982],
            [1404259200000, 146974343],
            [1404345600000, 149466293],
            [1404432000000, 152003356],
            [1404518400000, 156152918],
            [1404604800000, 159269625],
            [1404691200000, 160818945],
            [1404777600000, 162565087],
            [1404864000000, 163937960],
            [1404950400000, 165261139],
            [1405036800000, 167317919],
            [1405123200000, 169940884],
            [1405209600000, 171762697],
            [1405296000000, 172759315],
            [1405382400000, 174027035],
            [1405468800000, 175036448],
            [1405555200000, 175809111],
            [1405641600000, 177229858],
            [1405728000000, 179183449],
            [1405814400000, 180512464],
            [1405900800000, 181159782],
            [1405987200000, 181946663],
            [1406073600000, 182614565],
            [1406160000000, 183154099],
            [1406246400000, 183947747],
            [1406332800000, 184982060],
            [1406419200000, 185754570],
            [1406505600000, 186161802],
            [1406592000000, 186600357],
            [1406678400000, 186960620],
            [1406764800000, 187261082],
            [1406851200000, 187606790],
            [1406937600000, 188091204],
            [1407024000000, 188441614],
            [1407110400000, 188647295],
            [1407196800000, 188855042],
            [1407283200000, 189009821],
            [1407369600000, 189124616],
            [1407456000000, 189233774],
            [1407542400000, 189378007],
            [1407628800000, 189477824],
            [1407715200000, 189539103],
            [1407801600000, 189617934],
            [1407888000000, 189668086],
            [1407974400000, 189710100],
            [1408060800000, 189784894],
            [1408147200000, 189885325],
            [1408233600000, 189947032],
            [1408320000000, 189980521],
            [1408406400000, 190022300],
            [1408492800000, 190059410],
            [1408579200000, 190091244],
            [1408665600000, 190148255],
            [1408752000000, 190231246],
            [1408838400000, 190267743],
            [1409270400000, 190402474],
            [1409356800000, 190487377],
            [1409443200000, 190615518],
            [1409529600000, 190651027],
            [1409875200000, 190738037],
            [1409961600000, 190800383],
            [1410048000000, 190822916],
            [1410480000000, 190903650],
            [1410566400000, 190942910],
            [1410652800000, 190962963],
            [1411084800000, 191023325],
            [1411171200000, 191047721],
            [1411257600000, 191059924],
            [1414108800000, 191232013],
            [1414195200000, 191294821],
            [1414281600000, 191330864],
            [1414368000000, 191344415],
            [1414454400000, 191359113],
            [1414540800000, 191373911],
            [1414627200000, 191385230],
            [1414713600000, 191401515],
            [1414800000000, 191451901],
            [1414886400000, 191484389],
            [1415318400000, 191554874],
            [1415404800000, 191592935],
            [1415491200000, 191616238],
            [1415923200000, 191673182],
            [1416009600000, 191701915],
            [1416096000000, 191719337]
        ],
        name: '21jumpstreet2',
        showInLegend: false,
        extra: {
            title: '22 Jump Street',
            genre: 'Action Comedy',

            mpaaRating: 'R',
            imgMainColor: '#B1776A'
        },
        showlabel: false,
        color: 'rgba(177,119,106,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1308873600000, 25717785
            ],
            [1308960000000, 49091998],
            [1309046400000, 66135507],
            [1309132800000, 73093997],
            [1309219200000, 80183410],
            [1309305600000, 85723603],
            [1309392000000, 90930615],
            [1309478400000, 98867049],
            [1309564800000, 108385981],
            [1309651200000, 117204002],
            [1309737600000, 122560310],
            [1309824000000, 126382598],
            [1309910400000, 130037549],
            [1309996800000, 133619515],
            [1310083200000, 138477341],
            [1310169600000, 144517603],
            [1310256000000, 148831530],
            [1310342400000, 150818203],
            [1310428800000, 153222596],
            [1310515200000, 155179395],
            [1310601600000, 156982225],
            [1310688000000, 159416996],
            [1310774400000, 162887716],
            [1310860800000, 165389754],
            [1310947200000, 166625464],
            [1311033600000, 168030668],
            [1311120000000, 169300196],
            [1311206400000, 170719438],
            [1311292800000, 172421616],
            [1311379200000, 174714589],
            [1311465600000, 176375295],
            [1311552000000, 177209552],
            [1311638400000, 178141093],
            [1311724800000, 178955441],
            [1311811200000, 179769548],
            [1311897600000, 180464091],
            [1311984000000, 181383597],
            [1312070400000, 182118690],
            [1312156800000, 182480343],
            [1312243200000, 182861974],
            [1312329600000, 183235516],
            [1312416000000, 183584494],
            [1312502400000, 183889231],
            [1312588800000, 184369577],
            [1312675200000, 184807330],
            [1312761600000, 184988095],
            [1312848000000, 185212373],
            [1312934400000, 185382906],
            [1313020800000, 185536656],
            [1313107200000, 185699758],
            [1313193600000, 185956606],
            [1313280000000, 186196557],
            [1313366400000, 186313416],
            [1313452800000, 186425801],
            [1313539200000, 186509603],
            [1313625600000, 186603239],
            [1314921600000, 187717470],
            [1315008000000, 188178126],
            [1315094400000, 188686317],
            [1315180800000, 189256895],
            [1315267200000, 189341134],
            [1315353600000, 189398957],
            [1315440000000, 189449208]
        ],
        name: 'cars2',
        showInLegend: false,
        extra: {
            title: 'Cars 2',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#495267'
        },
        showlabel: false,
        color: 'rgba(73,82,103,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1407456000000, 25602161
            ],
            [1407542400000, 47764220],
            [1407628800000, 65575105],
            [1407715200000, 72245243],
            [1407801600000, 79815360],
            [1407888000000, 84925028],
            [1407974400000, 89242236],
            [1408060800000, 97252723],
            [1408147200000, 108870827],
            [1408233600000, 117765383],
            [1408320000000, 120567003],
            [1408406400000, 124080722],
            [1408492800000, 126487608],
            [1408579200000, 128809806],
            [1408665600000, 133351866],
            [1408752000000, 140639100],
            [1408838400000, 145535253],
            [1408924800000, 146829042],
            [1409011200000, 148490010],
            [1409097600000, 149576365],
            [1409184000000, 150655980],
            [1409270400000, 153352551],
            [1409356800000, 157885480],
            [1409443200000, 162574009],
            [1409529600000, 166277985],
            [1409616000000, 167138686],
            [1409702400000, 167684505],
            [1409788800000, 168146529],
            [1409875200000, 169665398],
            [1409961600000, 172893322],
            [1410048000000, 174653217],
            [1410134400000, 175013938],
            [1410220800000, 175506244],
            [1410307200000, 175872969],
            [1410393600000, 176241491],
            [1410480000000, 177422611],
            [1410566400000, 179743834],
            [1410652800000, 181096627],
            [1410739200000, 181399921],
            [1410825600000, 181801752],
            [1410912000000, 182102145],
            [1410998400000, 182367989],
            [1411084800000, 182991190],
            [1411171200000, 184253221],
            [1411257600000, 185018334],
            [1411344000000, 185175047],
            [1411430400000, 185368548],
            [1411516800000, 185524288],
            [1411603200000, 185732132],
            [1411689600000, 186076906],
            [1411776000000, 186764920],
            [1411862400000, 187182309],
            [1411948800000, 187274043],
            [1412035200000, 187385483],
            [1412121600000, 187477367],
            [1412208000000, 187553151],
            [1412294400000, 187724642],
            [1412380800000, 188099476],
            [1412467200000, 188322741],
            [1412553600000, 188379473],
            [1412640000000, 188449520],
            [1412726400000, 188505552],
            [1412812800000, 188559771],
            [1412899200000, 188652634],
            [1412985600000, 188821199],
            [1413072000000, 188925103],
            [1413158400000, 188982248],
            [1413244800000, 189011795],
            [1413331200000, 189036166],
            [1413417600000, 189063211],
            [1413504000000, 189195846],
            [1413590400000, 189433926],
            [1413676800000, 189588745],
            [1413763200000, 189628211],
            [1413849600000, 189669315],
            [1413936000000, 189705238],
            [1414022400000, 189740446],
            [1414108800000, 189830056],
            [1414195200000, 189999121],
            [1414281600000, 190115983],
            [1414368000000, 190138638],
            [1414454400000, 190161851],
            [1414540800000, 190183873],
            [1414627200000, 190203837],
            [1414713600000, 190241574],
            [1414800000000, 190408596],
            [1414886400000, 190514843],
            [1414972800000, 190537684],
            [1415059200000, 190567488],
            [1415145600000, 190586563],
            [1415232000000, 190606517],
            [1415318400000, 190669546],
            [1415404800000, 190795701],
            [1415491200000, 190871240],
            [1415577600000, 190898142],
            [1415664000000, 190951870],
            [1415750400000, 190964546],
            [1415836800000, 190977931],
            [1415923200000, 191019053],
            [1416009600000, 191109110],
            [1416096000000, 191163715],
            [1416182400000, 191173777],
            [1416268800000, 191184717],
            [1416355200000, 191194878],
            [1416441600000, 191204754]
        ],
        name: 'tmnt2013',
        showInLegend: false,
        extra: {
            title: 'Teenage Mutant Ninja Turtles (2014)',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#1E1E16'
        },
        showlabel: false,
        color: 'rgba(30,30,22,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1025654400000, 18599621
            ],
            [1025740800000, 35092835],
            [1025827200000, 54914493],
            [1025913600000, 73430498],
            [1026000000000, 87241586],
            [1026086400000, 93105774],
            [1026172800000, 99009132],
            [1026259200000, 103920016],
            [1026345600000, 108278200],
            [1026432000000, 115648067],
            [1026518400000, 125391031],
            [1026604800000, 132688511],
            [1026691200000, 135496081],
            [1026777600000, 138405840],
            [1026864000000, 140958381],
            [1026950400000, 143575294],
            [1027036800000, 148023429],
            [1027123200000, 153903425],
            [1027209600000, 158127629],
            [1027296000000, 159911391],
            [1027382400000, 161800885],
            [1027468800000, 163446599],
            [1027555200000, 164903536],
            [1027641600000, 167386469],
            [1027728000000, 170914371],
            [1027814400000, 173380738],
            [1027900800000, 174386935],
            [1027987200000, 175425245],
            [1028073600000, 176331402],
            [1028160000000, 177270309],
            [1028246400000, 178708173],
            [1028332800000, 180644750],
            [1028419200000, 182077620],
            [1028505600000, 182751267],
            [1028592000000, 183377461],
            [1028678400000, 183901292],
            [1028764800000, 184403694],
            [1028851200000, 185042662],
            [1028937600000, 185910262],
            [1029024000000, 186461835],
            [1029110400000, 186708891],
            [1029196800000, 186982558],
            [1029283200000, 187242627],
            [1029369600000, 187500731],
            [1029456000000, 187804935],
            [1029542400000, 188247349],
            [1029628800000, 188504665],
            [1029715200000, 188615365],
            [1029801600000, 188735210],
            [1029888000000, 188842971],
            [1029974400000, 188952685],
            [1030060800000, 189118643],
            [1030147200000, 189363478],
            [1030233600000, 189506435],
            [1030320000000, 189558300],
            [1030406400000, 189618948],
            [1030492800000, 189671990],
            [1030579200000, 189728814],
            [1030665600000, 189859915],
            [1030752000000, 190067190],
            [1030838400000, 190270308],
            [1030924800000, 190418803]
        ],
        name: 'meninblack2',
        showInLegend: false,
        extra: {
            title: 'Men in Black II',
            genre: 'Sci-Fi Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#A5A4A5'
        },
        showlabel: false,
        color: 'rgba(165,164,165,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1351814400000, 13506640
            ],
            [1351900800000, 34805982],
            [1351987200000, 49038712],
            [1352073600000, 51999844],
            [1352160000000, 56750657],
            [1352246400000, 58572670],
            [1352332800000, 60634609],
            [1352419200000, 68510691],
            [1352505600000, 83382648],
            [1352592000000, 93647405],
            [1352678400000, 99556758],
            [1352764800000, 101011607],
            [1352851200000, 102086078],
            [1352937600000, 103167290],
            [1353024000000, 107577224],
            [1353110400000, 116200049],
            [1353196800000, 121750227],
            [1353283200000, 123688969],
            [1353369600000, 126501953],
            [1353456000000, 130226568],
            [1353542400000, 132706030],
            [1353628800000, 139350540],
            [1353715200000, 145797593],
            [1353801600000, 149278699],
            [1353888000000, 149840275],
            [1353974400000, 150381382],
            [1354060800000, 150800391],
            [1354147200000, 151236263],
            [1354233600000, 152891795],
            [1354320000000, 156209770],
            [1354406400000, 158184813],
            [1354492800000, 158493580],
            [1354579200000, 158897053],
            [1354665600000, 159213887],
            [1354752000000, 159543566],
            [1354838400000, 160671596],
            [1354924800000, 163015360],
            [1355011200000, 164402934],
            [1355097600000, 164654975],
            [1355184000000, 164973969],
            [1355270400000, 165239527],
            [1355356800000, 165505549],
            [1355443200000, 166195734],
            [1355529600000, 167740117],
            [1355616000000, 168721592],
            [1355702400000, 168979348],
            [1355788800000, 169316727],
            [1355875200000, 169568351],
            [1355961600000, 169922525],
            [1356048000000, 170397377],
            [1356134400000, 171123593],
            [1356220800000, 171741561],
            [1356307200000, 172257456],
            [1356393600000, 172611821],
            [1356480000000, 173079576],
            [1356566400000, 173650119],
            [1356652800000, 174314221],
            [1356739200000, 174978208],
            [1356825600000, 175505332],
            [1356912000000, 175990019],
            [1356998400000, 176606980],
            [1357084800000, 176983603],
            [1357171200000, 177319916],
            [1357257600000, 177683388],
            [1357344000000, 178162636],
            [1357430400000, 178501640],
            [1357516800000, 178580645],
            [1357603200000, 178632457],
            [1357689600000, 178676449],
            [1357776000000, 178721773],
            [1357862400000, 178834129],
            [1357948800000, 179157040],
            [1358035200000, 179379615],
            [1358121600000, 179411616],
            [1358208000000, 179443773],
            [1358294400000, 179474838],
            [1358380800000, 179507304],
            [1358467200000, 179719198],
            [1358553600000, 180338015],
            [1358640000000, 180809778],
            [1358726400000, 181557914],
            [1358812800000, 181647644],
            [1358899200000, 181700136],
            [1358985600000, 181752761],
            [1359072000000, 181874322],
            [1359158400000, 182237786],
            [1359244800000, 182484640],
            [1359331200000, 182531108],
            [1359417600000, 182567303],
            [1359504000000, 182598619],
            [1359590400000, 182629642],
            [1359676800000, 182737468],
            [1359763200000, 183069059],
            [1359849600000, 183223816],
            [1359936000000, 183256216],
            [1360022400000, 183285240],
            [1360108800000, 183314812],
            [1360195200000, 183348715],
            [1360281600000, 183550395],
            [1360368000000, 184065745],
            [1360454400000, 184414532],
            [1360540800000, 184504376],
            [1360627200000, 184570499],
            [1360713600000, 184622677],
            [1360800000000, 184733859],
            [1360886400000, 184908283],
            [1360972800000, 185252045],
            [1361059200000, 185527331],
            [1361145600000, 185835929],
            [1361232000000, 185903973],
            [1361318400000, 185965662],
            [1361404800000, 186030541],
            [1361491200000, 186177757],
            [1361577600000, 186493358],
            [1361664000000, 186676411],
            [1361750400000, 186709080],
            [1361836800000, 186743579],
            [1361923200000, 186777330],
            [1362009600000, 186816706]
        ],
        name: 'rebootralph',
        showInLegend: false,
        extra: {
            title: 'Wreck-It Ralph',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#6C3E47'
        },
        showlabel: false,
        color: 'rgba(108,62,71,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1415145600000, 1350209
            ],
            [1415232000000, 2151453],
            [1415318400000, 19022462],
            [1415404800000, 37315453],
            [1415491200000, 49661813],
            [1415577600000, 54936670],
            [1415664000000, 61837040],
            [1415750400000, 65253194],
            [1415836800000, 68619855],
            [1415923200000, 76922504],
            [1416009600000, 89433479],
            [1416096000000, 96927481],
            [1416182400000, 99091009],
            [1416268800000, 101757321],
            [1416355200000, 103780264],
            [1416441600000, 105592067],
            [1416528000000, 109812474],
            [1416614400000, 116617794],
            [1416700800000, 120933234],
            [1416787200000, 122660050],
            [1416873600000, 125080272],
            [1416960000000, 128252404],
            [1417046400000, 131292477],
            [1417132800000, 137897051],
            [1417219200000, 144008590],
            [1417305600000, 147035482],
            [1417392000000, 147883147],
            [1417478400000, 148929713],
            [1417564800000, 149780549],
            [1417651200000, 150656962],
            [1417737600000, 152792226],
            [1417824000000, 156373436],
            [1417910400000, 158445319],
            [1417996800000, 159095554],
            [1418083200000, 159920901],
            [1418169600000, 160605161],
            [1418256000000, 161299576],
            [1418342400000, 162799615],
            [1418428800000, 165240049],
            [1418515200000, 166752480],
            [1418601600000, 167275624],
            [1418688000000, 167932412],
            [1418774400000, 168373167],
            [1418860800000, 168833242],
            [1418947200000, 169553819],
            [1419033600000, 170624626],
            [1419120000000, 171535531],
            [1419206400000, 172196263],
            [1419292800000, 172959513],
            [1419379200000, 173390457],
            [1419465600000, 174384559],
            [1419552000000, 175448585],
            [1419638400000, 176528827],
            [1419724800000, 177387217],
            [1419811200000, 178080502],
            [1419897600000, 178808130],
            [1419984000000, 179387895],
            [1420070400000, 180342023],
            [1420156800000, 181294038],
            [1420243200000, 182230397],
            [1420329600000, 182802094],
            [1420416000000, 183028010],
            [1420502400000, 183257986],
            [1420588800000, 183463763],
            [1420675200000, 183648849],
            [1420761600000, 183980939],
            [1420848000000, 184507459],
            [1420934400000, 184809001],
            [1421020800000, 184903741],
            [1421107200000, 185027422],
            [1421193600000, 185136958],
            [1421280000000, 185228526],
            [1421366400000, 185367616],
            [1421452800000, 185618684],
            [1421539200000, 185773864],
            [1421625600000, 185881828],
            [1421712000000, 185927916],
            [1421798400000, 185968174],
            [1421884800000, 186015432],
            [1421971200000, 186101461],
            [1422057600000, 186258056],
            [1422144000000, 186350542],
            [1422230400000, 186376357],
            [1422316800000, 186409262],
            [1422403200000, 186437358],
            [1422489600000, 186465500],
            [1422576000000, 186521025],
            [1422662400000, 186623418],
            [1422748800000, 186657114],
            [1422835200000, 186675041],
            [1422921600000, 186696220],
            [1423008000000, 186713721],
            [1423094400000, 186733149],
            [1423180800000, 186775380],
            [1423267200000, 186849759],
            [1423353600000, 186894702],
            [1423440000000, 186910738],
            [1423526400000, 186927535],
            [1423612800000, 186943910],
            [1423699200000, 186959681],
            [1423785600000, 187013441],
            [1423872000000, 187122249],
            [1423958400000, 187194554],
            [1424044800000, 187233228],
            [1424131200000, 187255480],
            [1424217600000, 187274414],
            [1424304000000, 187295972],
            [1424390400000, 187346425],
            [1424476800000, 187508068],
            [1424563200000, 187557086],
            [1424649600000, 187577644],
            [1424736000000, 187600002],
            [1424822400000, 187620176],
            [1424908800000, 187642651],
            [1424995200000, 187672475],
            [1425081600000, 187730342],
            [1425168000000, 187763327],
            [1425254400000, 187773946],
            [1425340800000, 187785310],
            [1425427200000, 187794542],
            [1425513600000, 187806784],
            [1425600000000, 187828680],
            [1425686400000, 187867095],
            [1425772800000, 187888097],
            [1425859200000, 187897469],
            [1425945600000, 187908774],
            [1426032000000, 187918949],
            [1426118400000, 187930551],
            [1426204800000, 187948027],
            [1426291200000, 187977138],
            [1426377600000, 187993562],
            [1426464000000, 187998898],
            [1426550400000, 188005024],
            [1426636800000, 188012462],
            [1426723200000, 188020017]
        ],
        name: 'interstellar',
        showInLegend: false,
        extra: {
            title: 'Interstellar',
            genre: 'Sci-Fi Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#98A6A9'
        },
        showlabel: false,
        color: 'rgba(152,166,169,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                957484800000, 11135359
            ],
            [957571200000, 24750578],
            [957657600000, 34819017],
            [957744000000, 38570328],
            [957830400000, 42438071],
            [957916800000, 45843807],
            [958003200000, 49016336],
            [958089600000, 56188240],
            [958176000000, 66691881],
            [958262400000, 73661465],
            [958348800000, 76161691],
            [958435200000, 78858144],
            [958521600000, 81134303],
            [958608000000, 83390792],
            [958694400000, 88941406],
            [958780800000, 97264003],
            [958867200000, 103140065],
            [958953600000, 105365462],
            [959040000000, 107267920],
            [959126400000, 108594017],
            [959212800000, 109931886],
            [959299200000, 113024536],
            [959385600000, 118269718],
            [959472000000, 123362264],
            [959558400000, 126996389],
            [959644800000, 128277107],
            [959731200000, 129437622],
            [959817600000, 130581569],
            [959904000000, 132797208],
            [959990400000, 136473531],
            [960076800000, 138958290],
            [960163200000, 139983085],
            [960249600000, 141189413],
            [960336000000, 142090745],
            [960422400000, 143100327],
            [960508800000, 144954656],
            [960595200000, 147958877],
            [960681600000, 150174374],
            [960768000000, 151042733],
            [960854400000, 151983554],
            [960940800000, 152783879],
            [961027200000, 153631531],
            [961113600000, 154918053],
            [961200000000, 157073051],
            [961286400000, 158993824],
            [961372800000, 159580378],
            [961459200000, 160279376],
            [961545600000, 160927585],
            [961632000000, 161584264],
            [961718400000, 162572283],
            [961804800000, 164182530],
            [961891200000, 165436188],
            [961977600000, 165922131],
            [962064000000, 166462323],
            [962150400000, 166866846],
            [962236800000, 167326428],
            [962323200000, 167922050],
            [962409600000, 168812811],
            [962496000000, 169753300],
            [962582400000, 170607235],
            [962668800000, 171247508],
            [962755200000, 171588861],
            [962841600000, 171942339],
            [962928000000, 172481545],
            [963014400000, 173317081],
            [963100800000, 173971075],
            [963187200000, 174225909],
            [963273600000, 174502906],
            [963360000000, 174746924],
            [963446400000, 175010197],
            [963532800000, 175415854],
            [963619200000, 176106339],
            [963705600000, 176582114],
            [963792000000, 176781757],
            [963878400000, 177017278],
            [963964800000, 177235155],
            [964051200000, 177444590],
            [964137600000, 177714945],
            [964224000000, 178159623],
            [964310400000, 178496604],
            [964396800000, 178635332],
            [964483200000, 178792186],
            [964569600000, 178939425],
            [964656000000, 179091107],
            [964742400000, 179327649],
            [964828800000, 179692430],
            [964915200000, 179965669],
            [965001600000, 180082543],
            [965088000000, 180227872],
            [965174400000, 180349547],
            [965260800000, 180479090],
            [965347200000, 180612015],
            [965433600000, 180806708],
            [965520000000, 180973015],
            [965606400000, 181055659],
            [965692800000, 181138054],
            [965779200000, 181213260],
            [965865600000, 181290101],
            [965952000000, 181382903],
            [966038400000, 181531466],
            [966124800000, 181632938],
            [966211200000, 181679737],
            [966297600000, 181733760],
            [966384000000, 181781281],
            [966470400000, 181834768],
            [966556800000, 181919288],
            [966643200000, 182044167],
            [966729600000, 182131600],
            [966816000000, 182169654],
            [966902400000, 182219341],
            [966988800000, 182258670],
            [967075200000, 182298361],
            [967161600000, 182408299],
            [967248000000, 182598565],
            [967334400000, 182749280],
            [967420800000, 182804703],
            [967507200000, 182859386],
            [967593600000, 182908543],
            [967680000000, 182965844],
            [967766400000, 183082385],
            [967852800000, 183278357],
            [967939200000, 183479397],
            [968025600000, 183637370],
            [968112000000, 183674211],
            [968198400000, 183711540],
            [968284800000, 183746224],
            [968371200000, 183866574],
            [968457600000, 184089015],
            [968544000000, 184229225],
            [968630400000, 184274018],
            [968716800000, 184358401],
            [968803200000, 184412605],
            [968889600000, 184468388],
            [968976000000, 184600875],
            [969062400000, 184840436],
            [969148800000, 184986532],
            [969235200000, 185036329],
            [969321600000, 185110347],
            [969408000000, 185167318],
            [969494400000, 185227475],
            [969580800000, 185330132],
            [969667200000, 185534624],
            [969753600000, 185635772],
            [969840000000, 185670294],
            [969926400000, 185725763],
            [970012800000, 185766948],
            [970099200000, 185815744],
            [970185600000, 185890365],
            [970272000000, 186017778],
            [970358400000, 186089136],
            [970444800000, 186114308],
            [970531200000, 186150739],
            [970617600000, 186180007],
            [970704000000, 186213912],
            [970790400000, 186261772],
            [970876800000, 186339366],
            [970963200000, 186398654],
            [971049600000, 186433984],
            [971136000000, 186455719],
            [971222400000, 186476343],
            [971308800000, 186495293],
            [971395200000, 186526773],
            [971481600000, 186578496],
            [971568000000, 186610052],
            [982281600000, 186621708],
            [982368000000, 186646713],
            [982454400000, 186669000],
            [982540800000, 186682944],
            [982627200000, 186687944],
            [982713600000, 186693426],
            [982800000000, 186699448],
            [982886400000, 186703756],
            [982972800000, 186714956],
            [983059200000, 186721485],
            [983145600000, 186722544],
            [983232000000, 186723555],
            [983318400000, 186726065],
            [983404800000, 186728399],
            [983491200000, 186733645],
            [983577600000, 186745728],
            [983664000000, 186750876],
            [983750400000, 186754965],
            [983836800000, 186758196],
            [983923200000, 186761601],
            [984009600000, 186764931],
            [984096000000, 186776926],
            [984182400000, 186785552],
            [984268800000, 186789524],
            [984355200000, 186792525],
            [984441600000, 186794677],
            [984528000000, 186796357],
            [984614400000, 186797730],
            [984700800000, 186805360],
            [984787200000, 186815387],
            [984873600000, 186825344],
            [984960000000, 186829506],
            [985046400000, 186833856],
            [985132800000, 186837477],
            [985219200000, 186843520],
            [985305600000, 186849584],
            [985392000000, 186865807],
            [985478400000, 186870377],
            [985564800000, 186874612],
            [985651200000, 186879296],
            [985737600000, 186883747],
            [985824000000, 186887819],
            [985910400000, 187011068],
            [985996800000, 187222516],
            [986083200000, 187344551],
            [986169600000, 187380819],
            [986256000000, 187427876],
            [986342400000, 187472004],
            [986428800000, 187513437],
            [986515200000, 187539766],
            [986601600000, 187579191],
            [986688000000, 187601773],
            [986774400000, 187612140],
            [986860800000, 187624122],
            [986947200000, 187633525],
            [987033600000, 187645063],
            [987120000000, 187653221],
            [987206400000, 187664424],
            [987292800000, 187670866],
            [987379200000, 187673911],
            [987465600000, 187677130],
            [987552000000, 187680559],
            [987638400000, 187683805],
            [987724800000, 187686393],
            [987811200000, 187692038],
            [987897600000, 187694880],
            [987984000000, 187696240],
            [988070400000, 187697668],
            [988156800000, 187698687],
            [988243200000, 187699624],
            [988329600000, 187700333],
            [988416000000, 187702065],
            [988502400000, 187703467],
            [988588800000, 187703791],
            [988675200000, 187704092],
            [988761600000, 187704563],
            [988848000000, 187704885],
            [988934400000, 187704985],
            [989020800000, 187705108],
            [989107200000, 187705261],
            [989193600000, 187705299],
            [989280000000, 187705325],
            [989366400000, 187705382],
            [989452800000, 187705427]
        ],
        name: 'gladiator',
        showInLegend: false,
        extra: {
            title: 'Gladiator',
            genre: 'Historical Epic',

            mpaaRating: 'R',
            imgMainColor: '#67614D'
        },
        showlabel: true,
        color: 'rgba(103,97,77,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1363910400000, 11645354
            ],
            [1363996800000, 30626216],
            [1364083200000, 43639736],
            [1364169600000, 47840842],
            [1364256000000, 52865984],
            [1364342400000, 57093284],
            [1364428800000, 62182077],
            [1364515200000, 72886649],
            [1364601600000, 82568999],
            [1364688000000, 88887945],
            [1364774400000, 93893394],
            [1364860800000, 97759994],
            [1364947200000, 101037548],
            [1365033600000, 104700202],
            [1365120000000, 110702564],
            [1365206400000, 119526250],
            [1365292800000, 125351896],
            [1365379200000, 126321008],
            [1365465600000, 127458629],
            [1365552000000, 128346620],
            [1365638400000, 129324070],
            [1365724800000, 132377046],
            [1365811200000, 138534746],
            [1365897600000, 142439144],
            [1365984000000, 143159236],
            [1366070400000, 144017580],
            [1366156800000, 144672604],
            [1366243200000, 145397742],
            [1366329600000, 147629993],
            [1366416000000, 152042153],
            [1366502400000, 154633037],
            [1366588800000, 155034502],
            [1366675200000, 155564992],
            [1366761600000, 155996471],
            [1366848000000, 156424783],
            [1366934400000, 157995634],
            [1367020800000, 161151214],
            [1367107200000, 163151701],
            [1367193600000, 163524658],
            [1367280000000, 163930383],
            [1367366400000, 164231594],
            [1367452800000, 164518159],
            [1367539200000, 165490199],
            [1367625600000, 167493426],
            [1367712000000, 168720798],
            [1367798400000, 168933957],
            [1367884800000, 169174707],
            [1367971200000, 169384911],
            [1368057600000, 169615477],
            [1368144000000, 170306758],
            [1368230400000, 171923666],
            [1368316800000, 173224505],
            [1368403200000, 173415936],
            [1368489600000, 173636798],
            [1368576000000, 173828413],
            [1368662400000, 174000183],
            [1368748800000, 174615597],
            [1368835200000, 175972607],
            [1368921600000, 177024785],
            [1369008000000, 177369851],
            [1369094400000, 177594882],
            [1369180800000, 177804100],
            [1369267200000, 178023288],
            [1369353600000, 178293595],
            [1369440000000, 178801143],
            [1369526400000, 179243218],
            [1369612800000, 179657546],
            [1369699200000, 179749451],
            [1369785600000, 179833013],
            [1369872000000, 179923061],
            [1369958400000, 180094832],
            [1370044800000, 180386289],
            [1370131200000, 180588685],
            [1370217600000, 180654730],
            [1370304000000, 180736855],
            [1370390400000, 180820837],
            [1370476800000, 180924038],
            [1370563200000, 181149808],
            [1370649600000, 181450334],
            [1370736000000, 181649007],
            [1370822400000, 181756860],
            [1370908800000, 181866311],
            [1370995200000, 181971874],
            [1371081600000, 182081097],
            [1371168000000, 182251761],
            [1371254400000, 182460807],
            [1371340800000, 182651450],
            [1371427200000, 182738267],
            [1371513600000, 182856759],
            [1371600000000, 182960537],
            [1371686400000, 183062625],
            [1371772800000, 183216698],
            [1371859200000, 183411619],
            [1371945600000, 183566525],
            [1372032000000, 183647427],
            [1372118400000, 183762498],
            [1372204800000, 183857349],
            [1372291200000, 183952270],
            [1372377600000, 184095456],
            [1372464000000, 184281155],
            [1372550400000, 184419441],
            [1372636800000, 184506353],
            [1372723200000, 184611163],
            [1372809600000, 184691744],
            [1372896000000, 184782846],
            [1372982400000, 184897912],
            [1373068800000, 185032926],
            [1373155200000, 185125189],
            [1373241600000, 185177383],
            [1373328000000, 185247328],
            [1373414400000, 185310203],
            [1373500800000, 185374469],
            [1373587200000, 185451062],
            [1373673600000, 185553309],
            [1373760000000, 185630101],
            [1373846400000, 185672994],
            [1373932800000, 185729364],
            [1374019200000, 185778846],
            [1374105600000, 185829523],
            [1374192000000, 185892455],
            [1374278400000, 185977346],
            [1374364800000, 186039196],
            [1374451200000, 186073378],
            [1374537600000, 186119673],
            [1374624000000, 186163265],
            [1374710400000, 186204796],
            [1374796800000, 186258739],
            [1374883200000, 186332356],
            [1374969600000, 186383777],
            [1375056000000, 186411132],
            [1375142400000, 186445880],
            [1375228800000, 186478546],
            [1375315200000, 186510211],
            [1375401600000, 186553984],
            [1375488000000, 186610614],
            [1375574400000, 186651133],
            [1375660800000, 186674990],
            [1375747200000, 186704297],
            [1375833600000, 186732309],
            [1375920000000, 186759916],
            [1376006400000, 186789512],
            [1376092800000, 186827416],
            [1376179200000, 186855008],
            [1376265600000, 186869376],
            [1376352000000, 186887619],
            [1376438400000, 186902812],
            [1376524800000, 186917813],
            [1376611200000, 186938766],
            [1376697600000, 186972159],
            [1376784000000, 186992792],
            [1376870400000, 187001703],
            [1376956800000, 187013179],
            [1377043200000, 187023690],
            [1377129600000, 187033567],
            [1377216000000, 187043004],
            [1377302400000, 187060894],
            [1377388800000, 187073697],
            [1377475200000, 187076490],
            [1377561600000, 187080241],
            [1377648000000, 187083614],
            [1377734400000, 187087070],
            [1377820800000, 187093516],
            [1377907200000, 187105205],
            [1377993600000, 187116898],
            [1378080000000, 187130667],
            [1378166400000, 187132523],
            [1378252800000, 187134174],
            [1378339200000, 187136275],
            [1378425600000, 187138572],
            [1378512000000, 187145833],
            [1378598400000, 187150638],
            [1378684800000, 187151196],
            [1378771200000, 187151915],
            [1378857600000, 187152768],
            [1378944000000, 187153646],
            [1379030400000, 187156004],
            [1379116800000, 187161244],
            [1379203200000, 187165546],
            [1379289600000, 187166222],
            [1379376000000, 187167054],
            [1379462400000, 187167700],
            [1379548800000, 187168425]
        ],
        name: 'croods',
        showInLegend: false,
        extra: {
            title: 'The Croods',
            genre: 'Animation',

            mpaaRating: 'PG',
            imgMainColor: '#6A827C'
        },
        showlabel: false,
        color: 'rgba(106,130,124,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1323993600000, 14607982
            ],
            [1324080000000, 29302445],
            [1324166400000, 39637079],
            [1324252800000, 44563207],
            [1324339200000, 49725274],
            [1324425600000, 54008573],
            [1324512000000, 58753622],
            [1324598400000, 65508993],
            [1324684800000, 69407684],
            [1324771200000, 79024177],
            [1324857600000, 89854135],
            [1324944000000, 97175202],
            [1325030400000, 103691198],
            [1325116800000, 110022326],
            [1325203200000, 117650599],
            [1325289600000, 124051629],
            [1325376000000, 130903746],
            [1325462400000, 136910219],
            [1325548800000, 139468339],
            [1325635200000, 141481689],
            [1325721600000, 143360061],
            [1325808000000, 147594635],
            [1325894400000, 153643482],
            [1325980800000, 157049382],
            [1326067200000, 158101723],
            [1326153600000, 159445181],
            [1326240000000, 160547449],
            [1326326400000, 161599644],
            [1326412800000, 164006799],
            [1326499200000, 167503738],
            [1326585600000, 170192301],
            [1326672000000, 172043715],
            [1326758400000, 172694863],
            [1326844800000, 173238222],
            [1326931200000, 173806229],
            [1327017600000, 175085511],
            [1327104000000, 177376953],
            [1327190400000, 178321726],
            [1327276800000, 178667811],
            [1327363200000, 179049036],
            [1327449600000, 179380446],
            [1327536000000, 179738916],
            [1327622400000, 180424322],
            [1327708800000, 181610910],
            [1327795200000, 182211057],
            [1327881600000, 182371225],
            [1327968000000, 182547473],
            [1328054400000, 182697943],
            [1328140800000, 182859118],
            [1328227200000, 183191227],
            [1328313600000, 183726361],
            [1328400000000, 183885123],
            [1328486400000, 183971380],
            [1328572800000, 184070574],
            [1328659200000, 184154982],
            [1328745600000, 184244298],
            [1328832000000, 184338763],
            [1328918400000, 184500721],
            [1329004800000, 184573200],
            [1329091200000, 184599568],
            [1329177600000, 184660205],
            [1329264000000, 184688238],
            [1329350400000, 184717354],
            [1329436800000, 184867452],
            [1329523200000, 185100971],
            [1329609600000, 185271156],
            [1329696000000, 185386501],
            [1329782400000, 185442021],
            [1329868800000, 185489569],
            [1329955200000, 185538618],
            [1330041600000, 185641612],
            [1330128000000, 185806792],
            [1330214400000, 185888953],
            [1330300800000, 185917190],
            [1330387200000, 185951557],
            [1330473600000, 185980958],
            [1330560000000, 186013793],
            [1330646400000, 186085222],
            [1330732800000, 186209549],
            [1330819200000, 186271351],
            [1330905600000, 186292582],
            [1330992000000, 186317975],
            [1331078400000, 186340575],
            [1331164800000, 186365173],
            [1331251200000, 186414901],
            [1331337600000, 186487268],
            [1331424000000, 186523366],
            [1331510400000, 186538528],
            [1331596800000, 186556874],
            [1331683200000, 186573402],
            [1331769600000, 186591613],
            [1331856000000, 186620169],
            [1331942400000, 186658800],
            [1332028800000, 186677304],
            [1332115200000, 186685931],
            [1332201600000, 186694903],
            [1332288000000, 186702889],
            [1332374400000, 186711434],
            [1332460800000, 186727724],
            [1332547200000, 186752847],
            [1332633600000, 186764258],
            [1332720000000, 186770428],
            [1332806400000, 186778487],
            [1332892800000, 186785359],
            [1332979200000, 186792893],
            [1333065600000, 186805480],
            [1333152000000, 186822252],
            [1333238400000, 186830669],
            [1333324800000, 186833897],
            [1333411200000, 186838662],
            [1333497600000, 186842737],
            [1333584000000, 186848418]
        ],
        name: 'sherlockholmes2',
        showInLegend: false,
        extra: {
            title: 'Sherlock Holmes: A Game of Shadows',
            genre: 'Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#203342'
        },
        showlabel: false,
        color: 'rgba(32,51,66,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1085702400000, 23504430
            ],
            [1085788800000, 47294053],
            [1085875200000, 68743584],
            [1085961600000, 85807341],
            [1086048000000, 91655563],
            [1086134400000, 96464949],
            [1086220800000, 100609179],
            [1086307200000, 109147101],
            [1086393600000, 120434052],
            [1086480000000, 128478844],
            [1086566400000, 131079558],
            [1086652800000, 133582245],
            [1086739200000, 136102184],
            [1086825600000, 138606588],
            [1086912000000, 143275275],
            [1086998400000, 149272353],
            [1087084800000, 153144814],
            [1087171200000, 154819427],
            [1087257600000, 156326018],
            [1087344000000, 157761707],
            [1087430400000, 159206167],
            [1087516800000, 161564868],
            [1087603200000, 164832717],
            [1087689600000, 167310267],
            [1087776000000, 168275485],
            [1087862400000, 169293857],
            [1087948800000, 170068593],
            [1088035200000, 170871408],
            [1088121600000, 172297855],
            [1088208000000, 174289124],
            [1088294400000, 175626913],
            [1088380800000, 176222530],
            [1088467200000, 176819208],
            [1088553600000, 177162699],
            [1088640000000, 177512523],
            [1088726400000, 178171801],
            [1088812800000, 179004534],
            [1088899200000, 179546080],
            [1088985600000, 180215404],
            [1089072000000, 180539735],
            [1089158400000, 180781083],
            [1089244800000, 181031276],
            [1089331200000, 181345657],
            [1089417600000, 181802767],
            [1089504000000, 182109550],
            [1089590400000, 182249009],
            [1089676800000, 182394105],
            [1089763200000, 182540607],
            [1089849600000, 182687765],
            [1089936000000, 182875050],
            [1090022400000, 183133937],
            [1090108800000, 183304973],
            [1090195200000, 183387177],
            [1090281600000, 183477537],
            [1090368000000, 183560087],
            [1090454400000, 183646786],
            [1090540800000, 183788352],
            [1090627200000, 183985494],
            [1090713600000, 184110900],
            [1090800000000, 184179562],
            [1090886400000, 184255962],
            [1090972800000, 184316597],
            [1091059200000, 184379733],
            [1091145600000, 184466712],
            [1091232000000, 184592103],
            [1091318400000, 184674202],
            [1091404800000, 184732308],
            [1091491200000, 184790229],
            [1091577600000, 184844949],
            [1091664000000, 184897027],
            [1091750400000, 184992699],
            [1091836800000, 185122481],
            [1091923200000, 185220683],
            [1092009600000, 185271105],
            [1092096000000, 185334835],
            [1092182400000, 185387893],
            [1092268800000, 185437591],
            [1092355200000, 185506963],
            [1092441600000, 185603377],
            [1092528000000, 185667752],
            [1092614400000, 185694320],
            [1092700800000, 185724509],
            [1092787200000, 185751442],
            [1092873600000, 185777531],
            [1092960000000, 185834584],
            [1093046400000, 185922716],
            [1093132800000, 185984768],
            [1093219200000, 186009886],
            [1093305600000, 186036333],
            [1093392000000, 186058067],
            [1093478400000, 186081521],
            [1093564800000, 186108933],
            [1093651200000, 186156338],
            [1093737600000, 186188336],
            [1093824000000, 186203791],
            [1093910400000, 186219448],
            [1093996800000, 186232935],
            [1094083200000, 186245352],
            [1094169600000, 186267658],
            [1094256000000, 186303966],
            [1094342400000, 186342374],
            [1094428800000, 186369548],
            [1094515200000, 186381945],
            [1094601600000, 186392359],
            [1094688000000, 186402045],
            [1094774400000, 186419865],
            [1094860800000, 186450019],
            [1094947200000, 186474798],
            [1095033600000, 186479876],
            [1095120000000, 186485721],
            [1095206400000, 186491497],
            [1095292800000, 186496357],
            [1095379200000, 186517537],
            [1095465600000, 186561080],
            [1095552000000, 186583549],
            [1095638400000, 186589568],
            [1095724800000, 186595624],
            [1095811200000, 186601322],
            [1095897600000, 186606781],
            [1095984000000, 186616208],
            [1096070400000, 186633145],
            [1096156800000, 186645502],
            [1096243200000, 186648971],
            [1096329600000, 186652431],
            [1096416000000, 186655506],
            [1096502400000, 186658429],
            [1096588800000, 186665317],
            [1096675200000, 186677910],
            [1096761600000, 186687402],
            [1096848000000, 186690130],
            [1096934400000, 186692997],
            [1097020800000, 186695640],
            [1097107200000, 186698552],
            [1097193600000, 186701612],
            [1097280000000, 186707089],
            [1097366400000, 186712078],
            [1097452800000, 186714069],
            [1097539200000, 186715020],
            [1097625600000, 186715842],
            [1097712000000, 186716750]
        ],
        name: 'dayaftertomorrow',
        showInLegend: false,
        extra: {
            title: 'The Day After Tomorrow',
            genre: 'Action Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#6F7E93'
        },
        showlabel: false,
        color: 'rgba(111,126,147,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1118361600000, 17474908
            ],
            [1118448000000, 36370115],
            [1118534400000, 50342878],
            [1118620800000, 56507996],
            [1118707200000, 61868932],
            [1118793600000, 66422405],
            [1118880000000, 70660963],
            [1118966400000, 79125179],
            [1119052800000, 89506009],
            [1119139200000, 96697986],
            [1119225600000, 99924115],
            [1119312000000, 102941781],
            [1119398400000, 106010525],
            [1119484800000, 108688274],
            [1119571200000, 113941830],
            [1119657600000, 120672569],
            [1119744000000, 125513483],
            [1119830400000, 127789540],
            [1119916800000, 130051914],
            [1120003200000, 131675588],
            [1120089600000, 133358891],
            [1120176000000, 136589761],
            [1120262400000, 140492056],
            [1120348800000, 143931499],
            [1120435200000, 146082474],
            [1120521600000, 147754593],
            [1120608000000, 149315903],
            [1120694400000, 150797034],
            [1120780800000, 153276868],
            [1120867200000, 156540360],
            [1120953600000, 158669309],
            [1121040000000, 159728982],
            [1121126400000, 160839849],
            [1121212800000, 161954056],
            [1121299200000, 163041748],
            [1121385600000, 164618105],
            [1121472000000, 166789651],
            [1121558400000, 168276570],
            [1121644800000, 168936462],
            [1121731200000, 169627532],
            [1121817600000, 170272489],
            [1121904000000, 170942503],
            [1121990400000, 172069212],
            [1122076800000, 173615321],
            [1122163200000, 174644345],
            [1122249600000, 175150518],
            [1122336000000, 175701801],
            [1122422400000, 176217345],
            [1122508800000, 176706929],
            [1122595200000, 177260377],
            [1122681600000, 178020116],
            [1122768000000, 178540329],
            [1122854400000, 178818907],
            [1122940800000, 179092110],
            [1123027200000, 179364128],
            [1123113600000, 179655429],
            [1123200000000, 180054958],
            [1123286400000, 180600260],
            [1123372800000, 180959870],
            [1123459200000, 181138929],
            [1123545600000, 181333258],
            [1123632000000, 181517785],
            [1123718400000, 181703857],
            [1123804800000, 181953568],
            [1123891200000, 182303189],
            [1123977600000, 182521560],
            [1124064000000, 182618741],
            [1124150400000, 182729439],
            [1124236800000, 182828289],
            [1124323200000, 182928911],
            [1124409600000, 183069208],
            [1124496000000, 183268956],
            [1124582400000, 183386949],
            [1124668800000, 183438987],
            [1124755200000, 183500077],
            [1124841600000, 183554091],
            [1124928000000, 183606186],
            [1125014400000, 183717666],
            [1125100800000, 183884827],
            [1125187200000, 183979256],
            [1125273600000, 184020197],
            [1125360000000, 184070441],
            [1125446400000, 184111169],
            [1125532800000, 184148919],
            [1125619200000, 184248002],
            [1125705600000, 184399599],
            [1125792000000, 184550477],
            [1125878400000, 184636051],
            [1125964800000, 184666371],
            [1126051200000, 184693737],
            [1126137600000, 184723804],
            [1126224000000, 184818101],
            [1126310400000, 184960129],
            [1126396800000, 185032410],
            [1126483200000, 185056865],
            [1126569600000, 185085224],
            [1126656000000, 185113605],
            [1126742400000, 185141136],
            [1126828800000, 185205468],
            [1126915200000, 185301437],
            [1127001600000, 185346461],
            [1127088000000, 185362114],
            [1127174400000, 185380968],
            [1127260800000, 185396591],
            [1127347200000, 185414134],
            [1127433600000, 185461921],
            [1127520000000, 185536189],
            [1127606400000, 185576334],
            [1127692800000, 185591020],
            [1127779200000, 185606625],
            [1127865600000, 185622433],
            [1127952000000, 185636925],
            [1128038400000, 185676833],
            [1128124800000, 185740339],
            [1128211200000, 185774715],
            [1128297600000, 185786484],
            [1128384000000, 185799869],
            [1128470400000, 185810758],
            [1128556800000, 185824148],
            [1128643200000, 185853467],
            [1128729600000, 185896445],
            [1128816000000, 185921664],
            [1128902400000, 185938653],
            [1128988800000, 185951814],
            [1129075200000, 185964601],
            [1129161600000, 185979774],
            [1129248000000, 186004852],
            [1129334400000, 186042664],
            [1129420800000, 186064011],
            [1129507200000, 186073803],
            [1129593600000, 186084760],
            [1129680000000, 186094746],
            [1129766400000, 186106790],
            [1129852800000, 186123683],
            [1129939200000, 186148304],
            [1130025600000, 186160823],
            [1130112000000, 186165867],
            [1130198400000, 186171803],
            [1130284800000, 186177283],
            [1130371200000, 186183620],
            [1130457600000, 186195073],
            [1130544000000, 186212111],
            [1130630400000, 186219280],
            [1130716800000, 186222668],
            [1130803200000, 186226281],
            [1130889600000, 186230158],
            [1130976000000, 186234664],
            [1131062400000, 186245581],
            [1131148800000, 186260407],
            [1131235200000, 186267775],
            [1131321600000, 186270962],
            [1131408000000, 186275146],
            [1131494400000, 186278760],
            [1131580800000, 186283815]
        ],
        name: 'mrandmrssmith',
        showInLegend: false,
        extra: {
            title: 'Mr. & Mrs. Smith',
            genre: 'Action Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#C1BDBC'
        },
        showlabel: false,
        color: 'rgba(193,189,188,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1431648000000, 28009745
            ],
            [1431734400000, 52754870],
            [1431820800000, 69216890],
            [1431907200000, 74426390],
            [1431993600000, 79705350],
            [1432080000000, 83577745],
            [1432166400000, 87486595],
            [1432252800000, 97169795],
            [1432339200000, 108241395],
            [1432425600000, 118298395],
            [1432512000000, 125738795],
            [1432598400000, 128606360],
            [1432684800000, 130669520],
            [1432771200000, 132698720],
            [1432857600000, 137292830],
            [1432944000000, 143387880],
            [1433030400000, 147521860],
            [1433116800000, 148947500],
            [1433203200000, 150687020],
            [1433289600000, 152003570],
            [1433376000000, 153281595],
            [1433462400000, 155869145],
            [1433548800000, 158915205],
            [1433635200000, 160854945],
            [1433721600000, 161789170],
            [1433808000000, 162911000],
            [1433894400000, 163845940],
            [1433980800000, 164715385],
            [1434067200000, 166883755],
            [1434153600000, 169587525],
            [1434240000000, 171113415],
            [1434326400000, 171837440],
            [1434412800000, 172680695],
            [1434499200000, 173442540],
            [1434585600000, 174164080],
            [1434672000000, 175440950],
            [1434758400000, 176889500],
            [1434844800000, 177683820],
            [1434931200000, 178134480],
            [1435017600000, 178703170],
            [1435104000000, 179164560],
            [1435190400000, 179593760],
            [1435276800000, 180034075],
            [1435363200000, 180649455],
            [1435449600000, 181057940],
            [1435536000000, 181291360],
            [1435622400000, 181513690],
            [1435708800000, 181630330],
            [1435795200000, 181778560],
            [1435881600000, 182019180],
            [1435968000000, 182180350],
            [1436054400000, 182346060],
            [1436140800000, 182452750],
            [1436227200000, 182577600],
            [1436313600000, 182695640],
            [1436400000000, 182784170],
            [1436486400000, 182875050],
            [1436572800000, 182981550],
            [1436659200000, 183058230],
            [1436745600000, 183102250],
            [1436832000000, 183154790],
            [1436918400000, 183197390],
            [1437004800000, 183238570],
            [1437091200000, 183300140],
            [1437177600000, 183381360],
            [1437264000000, 183436380],
            [1437350400000, 183467820],
            [1437436800000, 183501880],
            [1437523200000, 183532105],
            [1437609600000, 183560925],
            [1437696000000, 183603085],
            [1437782400000, 183652685],
            [1437868800000, 183692485],
            [1437955200000, 183716045],
            [1438041600000, 183739535],
            [1438128000000, 183761855],
            [1438214400000, 183785415]
        ],
        name: 'pitchperfect2',
        showInLegend: false,
        extra: {
            title: 'Pitch Perfect 2',
            genre: 'Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#6D6853'
        },
        showlabel: false,
        color: 'rgba(109,104,83,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                803260800000, 20046461
            ],
            [803347200000, 38204272],
            [803433600000, 52784433],
            [803520000000, 59848074],
            [803606400000, 66349262],
            [803692800000, 72177187],
            [803779200000, 77403197],
            [803865600000, 86466339],
            [803952000000, 97783600],
            [804038400000, 106614713],
            [804124800000, 110192676],
            [804211200000, 113880916],
            [804297600000, 117036359],
            [804384000000, 120068586],
            [804470400000, 124591876],
            [804556800000, 130426241],
            [804643200000, 135391292],
            [804729600000, 138856954],
            [804816000000, 141822825],
            [804902400000, 143742898],
            [804988800000, 145589273],
            [805075200000, 148483847],
            [805161600000, 152124320],
            [805248000000, 154850165],
            [805334400000, 155969207],
            [805420800000, 157302513],
            [805507200000, 158343673],
            [805593600000, 159357704],
            [805680000000, 160873261],
            [805766400000, 163107910],
            [805852800000, 164642784],
            [805939200000, 165422625],
            [806025600000, 166308003],
            [806112000000, 166923000],
            [806198400000, 167548991],
            [806284800000, 168608712],
            [806371200000, 170095789],
            [806457600000, 171150654],
            [806544000000, 171632548],
            [806630400000, 172201678],
            [806716800000, 172702257],
            [806803200000, 173175124],
            [806889600000, 173655548],
            [806976000000, 174456313],
            [807062400000, 174939168],
            [807148800000, 175182542],
            [807235200000, 175474888],
            [807321600000, 175737085],
            [807408000000, 175997767],
            [807494400000, 176227694],
            [807580800000, 176554341],
            [807667200000, 176802473],
            [807753600000, 176916356],
            [807840000000, 177043549],
            [807926400000, 177149170],
            [808012800000, 177257083],
            [808099200000, 177391493],
            [808185600000, 177584351],
            [808272000000, 177713627],
            [808358400000, 177777694],
            [808444800000, 177851129],
            [808531200000, 177917682],
            [808617600000, 177976462],
            [808704000000, 178056285],
            [808790400000, 178155495],
            [808876800000, 178229666],
            [808963200000, 178267110],
            [809049600000, 178311957],
            [809136000000, 178349919],
            [809222400000, 178386979],
            [809308800000, 178678015],
            [809395200000, 179129669],
            [809481600000, 179477383],
            [809568000000, 179621172],
            [809654400000, 179756085],
            [809740800000, 179878320],
            [809827200000, 179995528],
            [809913600000, 180237705],
            [810000000000, 180605662],
            [810086400000, 180939732],
            [810172800000, 181180518],
            [810259200000, 181266131],
            [810345600000, 181335068],
            [810432000000, 181401070],
            [810518400000, 181556153],
            [810604800000, 181821590],
            [810691200000, 181976456],
            [810777600000, 182016028],
            [810864000000, 182058062],
            [810950400000, 182096546],
            [811036800000, 182135157],
            [811123200000, 182238872],
            [811209600000, 182427679],
            [811296000000, 182548832],
            [811382400000, 182578364],
            [811468800000, 182607933],
            [811555200000, 182635904],
            [811641600000, 182663873],
            [811728000000, 182734316],
            [811814400000, 182861871],
            [811900800000, 182935928],
            [811987200000, 182957158],
            [812073600000, 182976684],
            [812160000000, 182994563],
            [812246400000, 183012974],
            [812332800000, 183056377],
            [812419200000, 183137859],
            [812505600000, 183197567],
            [812592000000, 183210573],
            [812678400000, 183223285],
            [812764800000, 183237614],
            [812851200000, 183253816],
            [812937600000, 183282462],
            [813024000000, 183337870],
            [813110400000, 183380860],
            [813196800000, 183391525],
            [813283200000, 183401186],
            [813369600000, 183411789],
            [813456000000, 183423941],
            [813542400000, 183441702],
            [813628800000, 183479379],
            [813715200000, 183506893],
            [813801600000, 183514571],
            [813888000000, 183521334],
            [813974400000, 183528862],
            [814060800000, 183537611],
            [814147200000, 183569936],
            [814233600000, 183637755],
            [814320000000, 183686730],
            [814406400000, 183699936],
            [814492800000, 183711433],
            [814579200000, 183723779],
            [814665600000, 183738215],
            [814752000000, 183764722],
            [814838400000, 183818977],
            [814924800000, 183858647],
            [815011200000, 183869212],
            [815097600000, 183877950],
            [815184000000, 183887827],
            [815270400000, 183899520],
            [815356800000, 183920991],
            [815443200000, 183966565],
            [815529600000, 183997904],
            [815616000000, 184006673],
            [815702400000, 184013838],
            [815788800000, 184021641],
            [815875200000, 184031112]
        ],
        name: 'batmanforever',
        showInLegend: false,
        extra: {
            title: 'Batman Forever',
            genre: 'Action / Adventure',

            mpaaRating: 'PG-13',
            imgMainColor: '#545854'
        },
        showlabel: false,
        color: 'rgba(84,88,84,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1007683200000, 13333298
            ],
            [1007769600000, 28986548],
            [1007856000000, 38107822],
            [1007942400000, 41146179],
            [1008028800000, 44678658],
            [1008115200000, 47571177],
            [1008201600000, 50229526],
            [1008288000000, 57388396],
            [1008374400000, 66896158],
            [1008460800000, 72306190],
            [1008547200000, 74316787],
            [1008633600000, 76540422],
            [1008720000000, 78568848],
            [1008806400000, 80631240],
            [1008892800000, 84998552],
            [1008979200000, 90455331],
            [1009065600000, 95347822],
            [1009152000000, 97614189],
            [1009238400000, 102011604],
            [1009324800000, 106613026],
            [1009411200000, 110827400],
            [1009497600000, 116240472],
            [1009584000000, 122515856],
            [1009670400000, 127735114],
            [1009756800000, 132148523],
            [1009843200000, 136996174],
            [1009929600000, 139203974],
            [1010016000000, 140914794],
            [1010102400000, 144587122],
            [1010188800000, 149613880],
            [1010275200000, 151967372],
            [1010361600000, 152649860],
            [1010448000000, 153524200],
            [1010534400000, 154242642],
            [1010620800000, 154938080],
            [1010707200000, 157380785],
            [1010793600000, 160938576],
            [1010880000000, 162676461],
            [1010966400000, 163197147],
            [1011052800000, 163810005],
            [1011139200000, 164332487],
            [1011225600000, 164868864],
            [1011312000000, 166550328],
            [1011398400000, 168852614],
            [1011484800000, 170582433],
            [1011571200000, 171624204],
            [1011657600000, 172043444],
            [1011744000000, 172417896],
            [1011830400000, 172798377],
            [1011916800000, 173794611],
            [1012003200000, 175354933],
            [1012089600000, 175974750],
            [1012176000000, 176184198],
            [1012262400000, 176430818],
            [1012348800000, 176640188],
            [1012435200000, 176851441],
            [1012521600000, 177505583],
            [1012608000000, 178618905],
            [1012694400000, 178908056],
            [1012780800000, 179054841],
            [1012867200000, 179219330],
            [1012953600000, 179382349],
            [1013040000000, 179543031],
            [1013126400000, 179810073],
            [1013212800000, 180292479],
            [1013299200000, 180535266],
            [1013385600000, 180602491],
            [1013472000000, 180677937],
            [1013558400000, 180744331],
            [1013644800000, 180932332],
            [1013731200000, 181035808],
            [1013817600000, 181208093],
            [1013904000000, 181316482],
            [1013990400000, 181373756],
            [1014076800000, 181404253],
            [1014163200000, 181431458],
            [1014249600000, 181458443]
        ],
        name: 'oceanseleven',
        showInLegend: false,
        extra: {
            title: 'Ocean´s Eleven',
            genre: 'Crime Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#64382F'
        },
        showlabel: false,
        color: 'rgba(100,56,47,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1100044800000, 2568233
            ],
            [1100131200000, 7305683],
            [1100217600000, 13559815],
            [1100304000000, 23824903],
            [1100390400000, 30629146],
            [1100476800000, 31844469],
            [1100563200000, 33154628],
            [1100649600000, 34436941],
            [1100736000000, 35795181],
            [1100822400000, 39624575],
            [1100908800000, 46763883],
            [1100995200000, 51463282],
            [1101081600000, 52985777],
            [1101168000000, 55005137],
            [1101254400000, 58394261],
            [1101340800000, 62090564],
            [1101427200000, 69653842],
            [1101513600000, 77172342],
            [1101600000000, 81479861],
            [1101686400000, 82415914],
            [1101772800000, 83302210],
            [1101859200000, 84268507],
            [1101945600000, 85349769],
            [1102032000000, 88204162],
            [1102118400000, 92839111],
            [1102204800000, 96127863],
            [1102291200000, 96979152],
            [1102377600000, 98006493],
            [1102464000000, 99094953],
            [1102550400000, 100238397],
            [1102636800000, 102850324],
            [1102723200000, 106971456],
            [1102809600000, 109826809],
            [1102896000000, 110871129],
            [1102982400000, 112108290],
            [1103068800000, 113450782],
            [1103155200000, 115019201],
            [1103241600000, 117388361],
            [1103328000000, 120616552],
            [1103414400000, 123430336],
            [1103500800000, 125455602],
            [1103587200000, 127909723],
            [1103673600000, 130437733],
            [1103760000000, 133705986],
            [1103846400000, 136257105],
            [1103932800000, 137900387],
            [1104019200000, 140233149],
            [1104105600000, 142592282],
            [1104192000000, 144920778],
            [1104278400000, 147164143],
            [1104364800000, 149503345],
            [1104451200000, 151621905],
            [1104537600000, 153519325],
            [1104624000000, 155112441],
            [1104710400000, 155723490],
            [1104796800000, 156065725],
            [1104883200000, 156321919],
            [1104969600000, 156588129],
            [1105056000000, 157022955],
            [1105142400000, 157946549],
            [1105228800000, 158656180],
            [1105315200000, 158787547],
            [1105401600000, 158917691],
            [1105488000000, 159049797],
            [1105574400000, 159201278],
            [1105660800000, 159373931],
            [1105747200000, 159788018],
            [1105833600000, 160211136],
            [1105920000000, 160559289],
            [1106006400000, 160634743],
            [1106092800000, 160701770],
            [1106179200000, 160760203],
            [1106265600000, 160862987],
            [1106352000000, 161033496],
            [1106438400000, 161169517],
            [1106524800000, 161221792],
            [1106611200000, 161259018],
            [1106697600000, 161298253],
            [1106784000000, 161350163],
            [1106870400000, 161407770],
            [1106956800000, 161534552],
            [1107043200000, 161628521],
            [1107129600000, 161642353],
            [1107216000000, 161654848],
            [1107302400000, 161669937],
            [1107388800000, 161683248],
            [1107475200000, 161722682],
            [1107561600000, 161815422],
            [1107648000000, 161861886],
            [1107734400000, 161873188],
            [1107820800000, 161883276],
            [1107907200000, 161892775],
            [1107993600000, 161905868],
            [1108080000000, 161956254],
            [1108166400000, 162067483],
            [1108252800000, 162141686],
            [1108339200000, 162167799],
            [1108425600000, 162188192],
            [1108512000000, 162203494],
            [1108598400000, 162223333],
            [1108684800000, 162261811],
            [1108771200000, 162349455],
            [1108857600000, 162413545],
            [1108944000000, 162458888],
            [1109030400000, 162478912],
            [1109116800000, 162498228],
            [1109203200000, 162516900],
            [1109289600000, 162544853],
            [1109376000000, 162601539],
            [1109462400000, 162639735],
            [1109548800000, 162648584],
            [1109635200000, 162655462],
            [1109721600000, 162661726],
            [1109808000000, 162669576],
            [1109894400000, 162683287],
            [1109980800000, 162723796],
            [1110067200000, 162753127],
            [1110153600000, 162760311],
            [1110240000000, 162766708],
            [1110326400000, 162771848],
            [1110412800000, 162775358]
        ],
        name: 'polarexpress',
        showInLegend: false,
        extra: {
            title: 'The Polar Express',
            genre: 'Animation',

            mpaaRating: 'G',
            imgMainColor: '#335976'
        },
        showlabel: false,
        color: 'rgba(51,89,118,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1185494400000, 30758269
            ],
            [1185580800000, 54557638],
            [1185667200000, 74036787],
            [1185753600000, 83314302],
            [1185840000000, 90815727],
            [1185926400000, 97222671],
            [1186012800000, 102949705],
            [1186099200000, 110979172],
            [1186185600000, 120549999],
            [1186272000000, 128060578],
            [1186358400000, 132029148],
            [1186444800000, 135399213],
            [1186531200000, 138480147],
            [1186617600000, 141112342],
            [1186704000000, 144708172],
            [1186790400000, 149012515],
            [1186876800000, 152381993],
            [1186963200000, 153980416],
            [1187049600000, 155555996],
            [1187136000000, 157004541],
            [1187222400000, 158441795],
            [1187308800000, 160365519],
            [1187395200000, 163070991],
            [1187481600000, 165271443],
            [1187568000000, 166316281],
            [1187654400000, 167381653],
            [1187740800000, 168235300],
            [1187827200000, 169037169],
            [1187913600000, 170299545],
            [1188000000000, 172120630],
            [1188086400000, 173354858],
            [1188172800000, 173794359],
            [1188259200000, 174216753],
            [1188345600000, 174567063],
            [1188432000000, 174895901],
            [1188518400000, 175611850],
            [1188604800000, 176682978],
            [1188691200000, 177719745],
            [1188777600000, 178526451],
            [1188864000000, 178697093],
            [1188950400000, 178831754],
            [1189036800000, 178952301],
            [1189123200000, 179271655],
            [1189209600000, 179895833],
            [1189296000000, 180272179],
            [1189382400000, 180343492],
            [1189468800000, 180415350],
            [1189555200000, 180488157],
            [1189641600000, 180576669],
            [1189728000000, 180735854],
            [1189814400000, 181063823],
            [1189900800000, 181238479],
            [1189987200000, 181272146],
            [1190073600000, 181307260],
            [1190160000000, 181341362],
            [1190246400000, 181375422],
            [1190332800000, 181449352],
            [1190419200000, 181594283],
            [1190505600000, 181673339],
            [1190592000000, 181695750],
            [1190678400000, 181718734],
            [1190764800000, 181739623],
            [1190851200000, 181761193],
            [1190937600000, 181815531],
            [1191024000000, 181917832],
            [1191110400000, 181983159],
            [1191196800000, 182001213],
            [1191283200000, 182020226],
            [1191369600000, 182039171],
            [1191456000000, 182057645],
            [1191542400000, 182111246],
            [1191628800000, 182199358],
            [1191715200000, 182258534],
            [1191801600000, 182286046],
            [1191888000000, 182301475],
            [1191974400000, 182315720],
            [1192060800000, 182330477],
            [1192147200000, 182380170],
            [1192233600000, 182461265],
            [1192320000000, 182511152],
            [1192406400000, 182525639],
            [1192492800000, 182539837],
            [1192579200000, 182554348],
            [1192665600000, 182571101],
            [1192752000000, 182609556],
            [1192838400000, 182670859],
            [1192924800000, 182705963],
            [1193011200000, 182714181],
            [1193097600000, 182722721],
            [1193184000000, 182730478],
            [1193270400000, 182738634],
            [1193356800000, 182764112],
            [1193443200000, 182807667],
            [1193529600000, 182835843],
            [1193616000000, 182841664],
            [1193702400000, 182847592],
            [1193788800000, 182852551],
            [1193875200000, 182859766],
            [1193961600000, 182874384],
            [1194048000000, 182903799],
            [1194134400000, 182923106],
            [1194220800000, 182924273],
            [1194307200000, 182928813],
            [1194393600000, 182933210],
            [1194480000000, 182938287],
            [1194566400000, 182952145],
            [1194652800000, 182978949],
            [1194739200000, 182995577],
            [1194825600000, 183004070],
            [1194912000000, 183008827],
            [1194998400000, 183013128],
            [1195084800000, 183017628],
            [1195171200000, 183025169],
            [1195257600000, 183039740],
            [1195344000000, 183049643],
            [1195430400000, 183052125],
            [1195516800000, 183055292],
            [1195603200000, 183060508],
            [1195689600000, 183063814],
            [1195776000000, 183071475],
            [1195862400000, 183081118],
            [1195948800000, 183086156],
            [1196035200000, 183087383],
            [1196121600000, 183088772],
            [1196208000000, 183090205],
            [1196294400000, 183091468],
            [1196380800000, 183095213],
            [1196467200000, 183102190],
            [1196553600000, 183106242],
            [1196640000000, 183107021],
            [1196726400000, 183107739],
            [1196812800000, 183108586],
            [1196899200000, 183109321]
        ],
        name: 'simpsons',
        showInLegend: false,
        extra: {
            title: 'The Simpsons Movie',
            genre: 'Animation',

            mpaaRating: 'PG-13',
            imgMainColor: '#E1D2A0'
        },
        showlabel: false,
        color: 'rgba(225,210,160,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                976838400000, 11329000
            ],
            [976924800000, 24834000],
            [977011200000, 33614543],
            [977097600000, 36910566],
            [977184000000, 40727108],
            [977270400000, 44418510],
            [977356800000, 48567078],
            [977443200000, 54687078],
            [977529600000, 61584078],
            [977616000000, 64456501],
            [977702400000, 70199545],
            [977788800000, 77102197],
            [977875200000, 83204950],
            [977961600000, 89353356],
            [978048000000, 96978356],
            [978134400000, 105232356],
            [978220800000, 110187561],
            [978307200000, 115764804],
            [978393600000, 118465278],
            [978480000000, 120400295],
            [978566400000, 122342353],
            [978652800000, 127021353],
            [978739200000, 134243353],
            [978825600000, 137897386],
            [978912000000, 138850841],
            [978998400000, 139968183],
            [979084800000, 140916812],
            [979171200000, 141919413],
            [979257600000, 144899413],
            [979344000000, 149524413],
            [979430400000, 152195301],
            [979516800000, 153551869],
            [979603200000, 154228366],
            [979689600000, 154810070],
            [979776000000, 155389237],
            [979862400000, 157284237],
            [979948800000, 160601237],
            [980035200000, 162242652],
            [980121600000, 162636850],
            [980208000000, 163134185]
        ],
        name: 'whatwomenwant',
        showInLegend: false,
        extra: {
            title: 'What Women Want',
            genre: 'Fantasy Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#8B6660'
        },
        showlabel: false,
        color: 'rgba(139,102,96,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                962323200000, 13240000
            ],
            [962409600000, 28030000],
            [962496000000, 41325042],
            [962582400000, 53721450],
            [962668800000, 62742422],
            [962755200000, 67961695],
            [962841600000, 73076981],
            [962928000000, 81199981],
            [963014400000, 92209981],
            [963100800000, 100195906],
            [963187200000, 103303854],
            [963273600000, 106326275],
            [963360000000, 108850675],
            [963446400000, 111371575],
            [963532800000, 116235575],
            [963619200000, 123548575],
            [963705600000, 128501870],
            [963792000000, 130305709],
            [963878400000, 132295497],
            [963964800000, 134078890],
            [964051200000, 135673554],
            [964137600000, 138497554],
            [964224000000, 142661554],
            [964310400000, 145354506],
            [964396800000, 146586654],
            [964483200000, 147922354],
            [964569600000, 149233610],
            [964656000000, 150536242],
            [964742400000, 152655242],
            [964828800000, 155623242],
            [964915200000, 158053931],
            [965001600000, 158960538],
            [965088000000, 159965220],
            [965174400000, 160773608],
            [965260800000, 161502965],
            [965347200000, 162662965],
            [965433600000, 164184965],
            [965520000000, 165579835],
            [965606400000, 166157507],
            [965692800000, 166721138],
            [965779200000, 167230446],
            [965865600000, 167735273],
            [965952000000, 168475273],
            [966038400000, 169677273],
            [966124800000, 170483052],
            [966211200000, 170838665],
            [966297600000, 171183921],
            [966384000000, 171481462],
            [966470400000, 171795706],
            [966729600000, 173607196],
            [966816000000, 173794738],
            [966902400000, 174016300],
            [966988800000, 174204424],
            [967075200000, 174397585],
            [967334400000, 175604700],
            [967420800000, 175719413],
            [967507200000, 175869171],
            [967593600000, 176002763],
            [967680000000, 176139175],
            [968025600000, 177845359]
        ],
        name: 'perfectstorm',
        showInLegend: false,
        extra: {
            title: 'The Perfect Storm',
            genre: 'Action Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#252526'
        },
        showlabel: false,
        color: 'rgba(37,37,38,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                1352419200000, 268131
            ],
            [1352505600000, 615223],
            [1352592000000, 944308],
            [1352678400000, 1139941],
            [1352764800000, 1234855],
            [1352851200000, 1329557],
            [1352937600000, 1418836],
            [1353024000000, 7829415],
            [1353110400000, 16436283],
            [1353196800000, 22468242],
            [1353283200000, 24924910],
            [1353369600000, 28080869],
            [1353456000000, 32294080],
            [1353542400000, 37164383],
            [1353628800000, 47133625],
            [1353715200000, 56949850],
            [1353801600000, 62840796],
            [1353888000000, 64604157],
            [1353974400000, 66593312],
            [1354060800000, 68365208],
            [1354147200000, 70189473],
            [1354233600000, 74230136],
            [1354320000000, 80112147],
            [1354406400000, 83566169],
            [1354492800000, 84617807],
            [1354579200000, 85934546],
            [1354665600000, 87088719],
            [1354752000000, 88220634],
            [1354838400000, 90776933],
            [1354924800000, 94837763],
            [1355011200000, 97137447],
            [1355097600000, 97922871],
            [1355184000000, 98863995],
            [1355270400000, 99708362],
            [1355356800000, 100654187],
            [1355443200000, 102591738],
            [1355529600000, 105802978],
            [1355616000000, 107687319],
            [1355702400000, 108493235],
            [1355788800000, 109428100],
            [1355875200000, 110253963],
            [1355961600000, 111147824],
            [1356048000000, 112540273],
            [1356134400000, 114773478],
            [1356220800000, 116673598],
            [1356307200000, 117949977],
            [1356393600000, 120269948],
            [1356480000000, 122416972],
            [1356566400000, 124529797],
            [1356652800000, 126918339],
            [1356739200000, 129672182],
            [1356825600000, 131867159],
            [1356912000000, 134189097],
            [1356998400000, 136652420],
            [1357084800000, 137698888],
            [1357171200000, 138675219],
            [1357257600000, 140279765],
            [1357344000000, 142671771],
            [1357430400000, 144089046],
            [1357516800000, 144500408],
            [1357603200000, 145040261],
            [1357689600000, 145542887],
            [1357776000000, 146265060],
            [1357862400000, 148115433],
            [1357948800000, 150879747],
            [1358035200000, 152600253],
            [1358121600000, 153219971],
            [1358208000000, 153941914],
            [1358294400000, 154532275],
            [1358380800000, 155136079],
            [1358467200000, 156574258],
            [1358553600000, 159112829],
            [1358640000000, 160611342],
            [1358726400000, 161814307],
            [1358812800000, 162325035],
            [1358899200000, 162746805],
            [1358985600000, 163187834],
            [1359072000000, 164052983],
            [1359158400000, 165968047],
            [1359244800000, 167051523],
            [1359331200000, 167343000],
            [1359417600000, 167724837],
            [1359504000000, 168035652],
            [1359590400000, 168374518],
            [1359676800000, 169062029],
            [1359763200000, 170371291],
            [1359849600000, 170776742],
            [1359936000000, 170983384],
            [1360022400000, 171259490],
            [1360108800000, 171504042],
            [1360195200000, 171747469],
            [1360281600000, 172174882],
            [1360368000000, 173079242],
            [1360454400000, 173621006],
            [1360540800000, 173827804],
            [1360627200000, 174075379],
            [1360713600000, 174268736],
            [1360800000000, 174587927],
            [1360886400000, 174946563],
            [1360972800000, 175651649],
            [1361059200000, 176223110],
            [1361145600000, 176651047],
            [1361232000000, 176811625],
            [1361318400000, 176962546],
            [1361404800000, 177122490],
            [1361491200000, 177476466],
            [1361577600000, 178239307],
            [1361664000000, 178603571],
            [1361750400000, 178721708],
            [1361836800000, 178851765],
            [1361923200000, 178961429],
            [1362009600000, 179086056],
            [1362096000000, 179322873],
            [1362182400000, 179810157],
            [1362268800000, 180071293],
            [1362355200000, 180147681],
            [1362441600000, 180237704],
            [1362528000000, 180323110],
            [1362614400000, 180403931],
            [1362700800000, 180519134],
            [1362787200000, 180731370],
            [1362873600000, 180834311],
            [1362960000000, 180872418],
            [1363046400000, 180925436],
            [1363132800000, 180966860],
            [1363219200000, 181012586],
            [1363305600000, 181122229],
            [1363392000000, 181303959],
            [1363478400000, 181408467],
            [1363564800000, 181449757],
            [1363651200000, 181501812],
            [1363737600000, 181548491],
            [1363824000000, 181591780]
        ],
        name: 'lincoln',
        showInLegend: false,
        extra: {
            title: 'Lincoln',
            genre: 'Historical Drama',

            mpaaRating: 'PG-13',
            imgMainColor: '#7C7C7C'
        },
        showlabel: false,
        color: 'rgba(124,124,124,0.52)'
    }, {
        marker: {
            enabled: false
        },
        data: [
            [
                858902400000, 9587650
            ],
            [858988800000, 22475500],
            [859075200000, 31423025],
            [859161600000, 34424500],
            [859248000000, 38094550],
            [859334400000, 41394775],
            [859420800000, 45576925],
            [859507200000, 54706525],
            [859593600000, 64478050],
            [859680000000, 70954360],
            [859766400000, 74303110],
            [859852800000, 77366860],
            [859939200000, 79889110],
            [860025600000, 82410885],
            [860112000000, 88080540],
            [860198400000, 96239670],
            [860284800000, 100686180],
            [860371200000, 101850150],
            [860457600000, 103200930],
            [860544000000, 104350515],
            [860630400000, 105528855],
            [860716800000, 109604050],
            [860803200000, 116429635],
            [860889600000, 120015240],
            [860976000000, 120847830],
            [861062400000, 121823970],
            [861148800000, 122599140],
            [861235200000, 123402460],
            [861321600000, 126326005],
            [861408000000, 131082220],
            [861494400000, 133540325],
            [861580800000, 134264575],
            [861667200000, 135104705],
            [861753600000, 135872410],
            [861840000000, 136653520],
            [861926400000, 138700565],
            [862012800000, 142035960],
            [862099200000, 143839650],
            [862185600000, 144304975],
            [862272000000, 144798475],
            [862358400000, 145193135],
            [862444800000, 145629150],
            [862531200000, 147274280],
            [862617600000, 150230155],
            [862704000000, 151487405],
            [862790400000, 151812655],
            [862876800000, 152213795],
            [862963200000, 152523515],
            [863049600000, 152834075],
            [863136000000, 153874490],
            [863222400000, 155527570],
            [863308800000, 156452370],
            [863395200000, 156686100],
            [863481600000, 156952140],
            [863568000000, 157182300],
            [863654400000, 157412880],
            [863740800000, 158315905],
            [863827200000, 159806920],
            [863913600000, 160615430],
            [864000000000, 160887995],
            [864086400000, 161129315],
            [864172800000, 161340365],
            [864259200000, 161562015],
            [864345600000, 162129195],
            [864432000000, 163016955],
            [864518400000, 164036235],
            [864604800000, 164595195],
            [864691200000, 164767345],
            [864777600000, 164922770],
            [864864000000, 165094260],
            [864950400000, 165543070],
            [865036800000, 166282285],
            [865123200000, 166711300],
            [865209600000, 166856890],
            [865296000000, 167019405],
            [865382400000, 167162350],
            [865468800000, 167317475],
            [865555200000, 167659025],
            [865641600000, 168207590],
            [865728000000, 168507740],
            [865814400000, 168631865],
            [865900800000, 168765380],
            [865987200000, 168889395],
            [866073600000, 169038045],
            [866160000000, 169323830],
            [866246400000, 169754850],
            [866332800000, 170045320],
            [866419200000, 170182270],
            [866505600000, 170340295],
            [866592000000, 170488465],
            [866678400000, 170627655],
            [866764800000, 170821245],
            [866851200000, 171097290],
            [866937600000, 171276540],
            [867024000000, 171353870],
            [867110400000, 171444740],
            [867196800000, 171531990],
            [867283200000, 171625815],
            [867369600000, 172008015],
            [867456000000, 172493115],
            [867542400000, 172929215],
            [867628800000, 173184940],
            [867715200000, 173414380],
            [867801600000, 173600355],
            [867888000000, 173803630],
            [867974400000, 174046940],
            [868060800000, 174491610],
            [868147200000, 174806235],
            [868233600000, 174962605],
            [868320000000, 175127220],
            [868406400000, 175287705],
            [868492800000, 175452305],
            [868579200000, 175696565],
            [868665600000, 176025785],
            [868752000000, 176255885],
            [868838400000, 176380625],
            [868924800000, 176513810],
            [869011200000, 176628560],
            [869097600000, 176754175],
            [869184000000, 176938625],
            [869270400000, 177176640],
            [869356800000, 177361145],
            [869443200000, 177464395],
            [869529600000, 177567295],
            [869616000000, 177664975],
            [869702400000, 177770815],
            [869788800000, 177918715],
            [869875200000, 178128240],
            [869961600000, 178288465],
            [870048000000, 178361980],
            [870134400000, 178435505],
            [870220800000, 178506555],
            [870307200000, 178577025],
            [870393600000, 178683345],
            [870480000000, 178836180],
            [870566400000, 178958005],
            [870652800000, 179018345],
            [870739200000, 179078405],
            [870825600000, 179136320],
            [870912000000, 179194100],
            [870998400000, 179274705],
            [871084800000, 179391500],
            [871171200000, 179488555],
            [871257600000, 179537305],
            [871344000000, 179585920],
            [871430400000, 179631280],
            [871516800000, 179675020],
            [871603200000, 179749270],
            [871689600000, 179851035],
            [871776000000, 179933535],
            [871862400000, 179968895],
            [871948800000, 180004125],
            [872035200000, 180038000],
            [872121600000, 180076225],
            [872208000000, 180125445],
            [872294400000, 180199270],
            [872380800000, 180252765],
            [872467200000, 180271755],
            [872553600000, 180288635],
            [872640000000, 180305430],
            [872726400000, 180323280],
            [872812800000, 180365805],
            [872899200000, 180434790],
            [872985600000, 180501885],
            [873072000000, 180551970],
            [873158400000, 180563930],
            [873244800000, 180574910],
            [873331200000, 180584975],
            [873417600000, 180614895],
            [873504000000, 180670335],
            [873590400000, 180707295],
            [873676800000, 180717855],
            [873763200000, 180729230],
            [873849600000, 180739725],
            [873936000000, 180750240],
            [874022400000, 180783355],
            [874108800000, 180840635],
            [874195200000, 180876435],
            [874281600000, 180885335],
            [874368000000, 180895070],
            [874454400000, 180903920],
            [874540800000, 180913765],
            [874627200000, 180944845],
            [874713600000, 181003645],
            [874800000000, 181038925],
            [874886400000, 181047275],
            [874972800000, 181056405],
            [875059200000, 181063785],
            [875145600000, 181072805],
            [875232000000, 181104195],
            [875318400000, 181161865],
            [875404800000, 181199095],
            [875491200000, 181206390],
            [875577600000, 181213585],
            [875664000000, 181220770],
            [875750400000, 181229410],
            [875836800000, 181252420],
            [875923200000, 181292540],
            [876009600000, 181317320],
            [876096000000, 181322540],
            [876182400000, 181327715],
            [876268800000, 181333415],
            [876355200000, 181339685],
            [876441600000, 181355540],
            [876528000000, 181379540],
            [876614400000, 181395380],
            [876700800000, 181401140],
            [876787200000, 181404290],
            [876873600000, 181407005],
            [876960000000, 181410615]
        ],
        name: 'liarliar',
        showInLegend: false,
        extra: {
            title: 'Liar Liar',
            genre: 'Fantasy Comedy',

            mpaaRating: 'PG-13',
            imgMainColor: '#B1A493'
        },
        showlabel: false,
        color: 'rgba(177,164,147,0.52)'
    }]
});