const gameclock =
    [
        614.93, 614.89, 614.85, 614.81, 614.77, 614.73,
        614.69, 614.65, 614.61, 614.57, 614.53, 614.49, 614.45, 614.41,
        614.37, 614.33, 614.29, 614.25, 614.21, 614.17, 614.13, 614.09,
        614.05, 614.01, 613.97, 613.93, 613.89, 613.85, 613.81,
        613.77, 613.73, 613.69, 613.65, 613.61, 613.57, 613.53,
        613.49, 613.45, 613.41, 613.37, 613.33, 613.28, 613.25,
        613.21, 613.17, 613.13, 613.08, 613.05, 613.01, 612.96,
        612.92, 612.88, 612.84, 612.8
    ];

const playDescription =
    '<p style = \'margin:0px; text-align:center;\'>' +
    'Golden State Warriors vs. Toronto Raptors</p>' +
    '<p style=\'font-size: 10px; font-weight:bold; text-align:center; ' +
    'background-color: #e8c3ff; padding: 5px;\'>' +
    'Home: Carroll 25` 3PT Jump Shot (3 PTS) (Lowry 1 AST)</p>';


Highcharts.chart('container', {
    series: [{
        data: returnData(),
        type: 'scatter',
        dataLabels: {
            enabled: true,
            allowOverlap: true,
            useHTML: true,
            y: 38,
            formatter: function () {
                return '<span style="color:' + this.point.color + '">' +
                    this.point.name + this.point.jersey + '</span>';
            },
            shadow: false
        },
        showInLegend: false
    }],
    title: {
        align: 'center',
        useHTML: true,
        text: playDescription
    },
    motion: {
        enabled: true,
        updateInterval: 1,
        labels: gameclock,
        magnet: {
            round: 'floor',
            step: 0.08
        }
    },
    xAxis: {
        min: 0,
        max: 90,
        visible: false
    },
    yAxis: {
        min: 0,
        max: 50,
        visible: false
    },
    chart: {
        plotBackgroundImage: 'https://i.imgur.com/vw1woQt.jpg',
        animation: false
    },
    tooltip: {
        enabled: true,
        useHTML: true,
        headerFormat: '',
        hideDelay: 0,
        pointFormat:
            '<div style=\'text-align:center;\'><strong>{point.name} ' +
            '({point.team}{point.jersey})</strong><br>' +
            '({point.x}, {point.y})<br><strong>Scoring Percent: </strong>' +
            '{point.scorepercent}</div>'
    }
}, function (chart) {
    chart.motion.reset();

});
function getGingerbread() {
    return 'url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAzmVYSWZNTQAqAAAACAAIAQYAAwAAAAEAAgAAARIAAwAAAAEAAQAAARoABQAAAAEAAABuARsABQAAAAEAAAB2ASgAAwAAAAEAAgAAATEAAgAAAB4AAAB+ATIAAgAAABQAAACch2kABAAAAAEAAACwAAAAAAAAAEgAAAABAAAASAAAAAFBZG9iZSBQaG90b3Nob3AgQ1M1IE1hY2ludG9zaAAyMDExOjA1OjA5IDAwOjI3OjA3AAACoAIABAAAAAEAAAAgoAMABAAAAAEAAAAgAAAAAB8ntKIAAAAJcEhZcwAACxMAAAsTAQCanBgAAAQDaVRYdFhNTDpjb20uYWRvYmUueG1wAAAAAAA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJYTVAgQ29yZSA2LjAuMCI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnRpZmY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvIj4KICAgICAgICAgPGV4aWY6Q29sb3JTcGFjZT4xPC9leGlmOkNvbG9yU3BhY2U+CiAgICAgICAgIDxleGlmOlBpeGVsWERpbWVuc2lvbj41MTI8L2V4aWY6UGl4ZWxYRGltZW5zaW9uPgogICAgICAgICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+NTEyPC9leGlmOlBpeGVsWURpbWVuc2lvbj4KICAgICAgICAgPHhtcDpNb2RpZnlEYXRlPjIwMTEtMDUtMDlUMDA6Mjc6MDc8L3htcDpNb2RpZnlEYXRlPgogICAgICAgICA8eG1wOkNyZWF0b3JUb29sPkFkb2JlIFBob3Rvc2hvcCBDUzUgTWFjaW50b3NoPC94bXA6Q3JlYXRvclRvb2w+CiAgICAgICAgIDx0aWZmOlJlc29sdXRpb25Vbml0PjI8L3RpZmY6UmVzb2x1dGlvblVuaXQ+CiAgICAgICAgIDx0aWZmOlBob3RvbWV0cmljSW50ZXJwcmV0YXRpb24+MjwvdGlmZjpQaG90b21ldHJpY0ludGVycHJldGF0aW9uPgogICAgICAgICA8dGlmZjpDb21wcmVzc2lvbj41PC90aWZmOkNvbXByZXNzaW9uPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICAgICA8dGlmZjpYUmVzb2x1dGlvbj43MjwvdGlmZjpYUmVzb2x1dGlvbj4KICAgICAgICAgPHRpZmY6WVJlc29sdXRpb24+NzI8L3RpZmY6WVJlc29sdXRpb24+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgrwUjtRAAAJNElEQVRYCa1XC3CU1RX+/tf+m30k2TxICCYGhIQQoCIBjYokWEvBBxqbHXWAaarCVAoibxHMqsVoW2vslAGmU14dpG5Eqi0iVNkAioBBKI+EQMLTJEAIMY/dZPd/3J67wk4wSUGnd+af/7H3nu+753znnLvAzQ3B4/GIPU31er1ST9//n9+6Aj8w4fb7FxQ9WvRrAvgZXTIHInLhO3/+oUO4wQIObtIlL53+wnvDxzxUENc3FVGqgtras7BaLec6A4HpU4p++onH45M9nnz9Bva6/dx1d9//kZPj4Jg29J7tP7n34YLskXdrRuNFrX7/Xr3z6F790vZNabE229aSJe/8nIP/mHD06jqfxyflk9E3F7y99IFfTM73N13s/OLNedbQp8thfgMYRKwT0BpsTiXhllvX0mt/t9vdQXdOnNF1U6M3DwgcnCxYBo+6a9rhTatxbMJQi2XtcshEOWXuXDhmz0ObCMVSvVNz2ZxJT6bHjueIazxrVK+XSYyxG4U3TLBHAiSq8OJPNu2KV6G7Or0L4SwYL9y6ZgNqNAcGFExBjrsIURQgOcaF9MGZ6Dsw43ZuschT1Ol2C4YgCMznY/KNiPQaAm4s844x7PSB3Uw8DUQ/OQxZ4yehrrIKVaWLEN0nHQMyiUCoSY6Jd+GhOSuffXhRTIIoyScFh6tiTI7zKyIR4naIhEjPYT3x966jRzdx1nwHez9uivYHTtecWz0n0dp5wrT1yxXlpnIEg83QSQDiyNloP1CKpLsXsBBTBMkaC122QrO7YFjt510DstZlDMlc1r+/0NkbiR5DwME//viketfE+NZbsgdvScp3Q669YNqiY9Aaex86PgMc9yxCXF4BQkHAv+d3gvblMtb60XytcflMvXH+ZLNhzmOp9f/+YEnt0UOHfb5jydwDFNpueD2GYNWqCmXixEHBinqW1lxzLh/nK6E4ISppQzF86iScnfgbxKak41LFNsQogNpvJMxgi2A6dcWeJEGVLWjXFPNk6eKgNTZmUIvN+Sdyu7t4SLHggadrBNCNQEVFhZKTk6MtWLAx5XjZP/c5jmxNFqpXGNasEVLblnlgHc1wpY9Cy5blEI6UwhKfCkYhkUQGVQpCYpSJGkNUW4sYR9wMi4r6M8dzCFUQSJzXodPLdQR4IeHgL66rik8/f2AvK3shuaOtVrOmDlaYfhlq8hA0b18GqYWsEU4oFdBJW9EW0oMZoqrFoKjxaAmIsGQ/jrSnJmiwO9WalUt2ExbzFhZK7rKy60hEGgmPz4wZM8x9+xoz9LPHdqh73u8vNe/S7P2yFVO7DIMRV0KVY1IgxkXjlnnrcc42DA2f/gMptyYBkg1C+2mow6ch/dm32EW1j3Cx5rj8+eKinetb2icTgVBZZeX3HYCIKMaOHRt+jnUJb9maqgfp5RuDcnyOwmiHisUGWTKoxEkwtVYY5O64zKFIS0lFchTVayZBFDohu9LQtv9Npl/8RrhS+7X+/NsvTlkN5BFqO13cfrcKGSGQl5cXzlM90KqKTidamiCzlgooehVkC/mYwLVQiMIbBYWFcGTuAAT3fgB/v9vQePkCTD1IXlLBAhDqt65gQ+4YzcN7iC5MA0iq3/UV/t51RAjQx3BNOPbpR+Ko8Q9Cmrk0JOQWm4Hsl9Ee7IQiSWAi2aTLaKuH475FGFWyAfZ86szfNoEJNmhBP9SUDPj3e/U+iX3wzsLXX+JgT3p83XZ+jUREhG7hu5rkmzf7FdNQxg69vyCqru4C+g9MQ3NyMrQtz8GekIXOUBs0Uk5n3Umc3rYZroMbwEgCzDRhmiL5mTZbB/nyiaMYPCp3EgGlUF+ppzvfbLdqGPFAGTU4D01aAex+eeGMTO+jI56eMmNCluXszldvG3EnAhp0UVLDOW6xZyB0bBNa9nwIW/50VLcNgq51kBYYDM0P6+hE4dTquVpKYp+okucXTyFgeD3eyGb5+7URIcA/eIhhIQX7BHBqJUD6wfGGHZ/sl2QJ0oACMIOyQXLAQprooD2lFD6H1HGPweGIhWC0QxQtCIY0MLkPQl81Sg1H9mPMI0/MIjui2+MOUaZ1I9FjLyAiYtzAgcqsmppgKTA8b+uu/5zZ42OWPcWC4BoC0wgg5D8Da9/xEGxJCNash6CmQqcGoTMKgRBFzwYaz5zRs1//XA5I6t8eeXzUVCICj4eJ1GwjobjOA3wCHx7yxMyamnAnmw3UtjdfabAmJAs6eVkkETKtDZI1BUbjNui164GoLEgKidMIkRa4HoLQDSpKTpu8z32v0Xr8yJRt26oqVv3h3QQO3rUn9EiAkyDXUAMLHyr8HR2sQdNlSkMSO1Tyj43SjsGUBlFaOhA4W8UMjTGrvR+oRNBK8gKREeUYxOZmSQdf+lXQaGoc6UhKpsgCxcXFEc/3SoBPvDZkm0ODzUEZQOUsZEDTyD6zI9R0EprjTlOauEy4FIwVrnxdaahR0aQFhbOHJNGhSlRBVUSuPXwIcYkpfa/ajKRlN1FcA71650yZmpQqN33bAj8Jz5ZGJDQFWqAGUtw4M+GpErGxvaM1PfdB+5XqA9LZdU9rlm8gCRnpoqEmwF9bwU3p6XeNkyqrDvn4yyuvlPONh3UQcQX/oevwMiZRbTAOHNPGBVqufPbF719gcac2Qo3JFEQ6dFzeccgc+vedYp0/0PjLpyeMOFzNnHWVh9ZJhjb6zMFduPzePC1UQ5HMydWHzV9uPX/p3NHZMx8dQRj8rBneGMfr3QNlVBloSKxt6ZcbV4Ftftfw35srMxJbYOdu2J+ZbQiuJHHtE4Pn07S64Znhvdz5lwWls6Izhi9JfqMiMRgMQnXGy1XVh6sXznfn0zwOzhtgpCP2SiAxMTFs0W5HfXL27byoa5bPv6RMpyQbFK8PmfSMsmXzhgPlwDp+3CorKxMKCwtNOvnww8eaN+a8NdWWOiDn4IcbL63x/vm39K2N+o1cXl7OSdx48Hzls0pKNqev/+tnjR9uPshWlKxmJdOXsI82H2Glb5dxId191VKkrft6KDZ8Di9wV+fe/O0aCVoR9+rcP77mfX9f9b+2n/IvXbyCC2gut5TXcxj5n1nZ5/PJV6tf2Jt8/g8eXUjwtdwQnYNA7Sc8frzhqwZu9kY78l2nFw9l+M0u/l/z/gvRdrbmZIu5vQAAAABJRU5ErkJggg==)';
}

function getBasketball() {
    return 'url(data:image/png;base64,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)';
}

function returnData() {
    /* eslint-disable max-len */
    return [{
        sequence: [{
            x: 35.3629,
            y: 21.4331,
            scorepercent: ['NaN'],
            name: [''],
            jersey: [''],
            team: ['Ball'],
            marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] },
            color: ['orange']
        }, { x: 34.1164, y: 20.2644, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 32.8441, y: 19.2837, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.5501, y: 18.0913, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 30.3872, y: 17.1521, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.3107, y: 15.995, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.1057, y: 14.9401, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.9247, y: 13.8561, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 25.7434, y: 12.7494, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 24.5637, y: 11.7065, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 23.7741, y: 10.894, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 23.0342, y: 10.125, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.3859, y: 9.4257, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.871, y: 8.822, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.5314, y: 8.34, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.4089, y: 8.0059, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.5042, y: 8.0621, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.5784, y: 8.1611, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.6342, y: 8.2977, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.6742, y: 8.4669, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.701, y: 8.6634, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.7172, y: 8.8824, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.7256, y: 9.1185, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.7287, y: 9.3666, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.7291, y: 9.6218, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.5235, y: 9.964, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.7779, y: 9.6182, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.8748, y: 9.4042, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.1528, y: 9.1683, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.3494, y: 8.9073, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.3156, y: 8.9502, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.3139, y: 9.0888, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.2385, y: 9.167, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.2141, y: 9.1486, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.1347, y: 9.4202, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.7796, y: 9.6618, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.1902, y: 10.4357, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 20.6093, y: 10.9207, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 20.0143, y: 11.4986, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 19.4285, y: 11.9102, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 18.7543, y: 12.5929, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 18.2256, y: 13.093, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 17.6193, y: 13.6662, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 17.0448, y: 14.171, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 16.497, y: 14.8338, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 15.8933, y: 15.373, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 15.4748, y: 15.8443, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 14.9116, y: 16.0971, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 14.3276, y: 16.9055, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 13.7495, y: 17.6696, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 13.2066, y: 17.8493, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 12.46, y: 18.4812, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 12.113, y: 19.06, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 11.3955, y: 19.531, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 10.8162, y: 20.1451, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 10.3073, y: 20.6235, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 9.7533, y: 21.1698, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 9.1936, y: 21.7584, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 8.6498, y: 22.2139, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 8.1118, y: 22.5868, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 7.4945, y: 23.2059, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 7.0609, y: 23.5263, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 6.5123, y: 23.9921, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 5.961, y: 24.7259, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 5.1578, y: 25.1972, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 4.9083, y: 25.6498, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 4.7149, y: 25.7236, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 4.5451, y: 25.7668, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 4.3905, y: 25.7945, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 4.2424, y: 25.8221, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 4.1053, y: 25.85, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.9655, y: 25.8777, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.8227, y: 25.9053, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.6619, y: 26.0431, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.4484, y: 26.0774, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.346, y: 26.1637, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.9945, y: 26.0731, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.0598, y: 26.1414, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.7252, y: 26.1088, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.6936, y: 26.0461, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.4332, y: 26.3123, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.4319, y: 26.2204, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.1987, y: 26.1647, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.2635, y: 25.9537, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.2841, y: 25.894, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.3441, y: 25.8811, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.3561, y: 25.6047, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.3569, y: 25.5107, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.2459, y: 25.4141, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.0269, y: 25.3599, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 1.7401, y: 25.6405, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 1.4531, y: 25.9207, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 1.143, y: 25.7109, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 0.9111, y: 26.1968, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 0.6461, y: 26.5172, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 0.3075, y: 26.7933, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.0766, y: 27.0384, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.4594, y: 27.1993, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.8245, y: 27.2716, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.9183, y: 27.4734, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.984, y: 27.8026, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -1.0226, y: 28.1548, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -1.0352, y: 28.4254, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.8417, y: 28.5857, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.6482, y: 28.746, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: -0.4547, y: 28.9062, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 0.1552, y: 29.2081, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 1.2487, y: 29.6265, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 2.5878, y: 30.0508, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 3.934, y: 30.3708, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 5.3539, y: 30.5561, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 6.6314, y: 31.1271, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 8.0782, y: 31.3488, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 9.4354, y: 31.6931, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 10.8619, y: 31.9679, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 12.1969, y: 32.4286, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 13.5883, y: 32.7552, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 14.9988, y: 33.1545, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 16.3446, y: 33.5738, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 17.6516, y: 34.0002, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 18.9762, y: 34.3357, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 20.4116, y: 34.7291, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 21.6981, y: 35.1556, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 22.881, y: 35.4658, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 24.2745, y: 35.8581, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 25.5103, y: 36.2464, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.8931, y: 36.5975, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.8653, y: 36.8658, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.1861, y: 37.1805, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.5932, y: 37.1154, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.9174, y: 36.9999, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.3955, y: 37.1278, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.5935, y: 37.1834, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 30.0525, y: 37.1261, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 30.6292, y: 38.0943, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.1831, y: 37.9478, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.7894, y: 38.5332, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 32.554, y: 39.0512, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 33.186, y: 39.6407, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 34.1939, y: 40.1793, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 34.596, y: 40.3802, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.2278, y: 40.5959, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.7214, y: 40.3744, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 36.2611, y: 40.3998, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 37.0022, y: 40.672, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 37.7735, y: 40.68, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 38.4756, y: 40.4972, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 39.0425, y: 40.3464, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 39.8168, y: 40.2534, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 40.5044, y: 40.1935, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.0463, y: 40.0606, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.3471, y: 40.0413, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.7479, y: 39.8756, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.9411, y: 40.0011, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 42.2359, y: 39.9204, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 42.5294, y: 39.8403, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 42.7777, y: 39.8768, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 43.2693, y: 39.8229, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 43.6019, y: 39.8223, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 44.0814, y: 39.8511, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 44.4985, y: 39.792, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 44.9572, y: 39.8591, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 45.4387, y: 39.9043, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 45.9686, y: 39.9312, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 46.5915, y: 40.0486, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 47.2345, y: 40.1095, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 47.724, y: 40.1885, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 48.329, y: 40.2692, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 49.2261, y: 40.2891, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 49.5881, y: 40.0965, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.4095, y: 40.2341, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.851, y: 40.136, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.7418, y: 40.3086, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.5391, y: 40.6354, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.4299, y: 40.8304, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.9314, y: 40.8511, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 51.3604, y: 40.8613, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 52.2025, y: 40.5671, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 52.5669, y: 40.556, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 52.7819, y: 41.0677, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 54.7224, y: 41.0559, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 55.6262, y: 41.1398, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 55.5726, y: 41.0232, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 55.5859, y: 41.2671, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 57.0774, y: 41.1963, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 56.4414, y: 41.3243, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 56.8576, y: 41.3899, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 57.2614, y: 41.4941, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 57.6422, y: 41.4783, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 58.1207, y: 41.2129, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 58.4634, y: 41.3222, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 58.9002, y: 41.473, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 59.2656, y: 41.1429, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 59.6625, y: 41.3518, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 59.9764, y: 41.3274, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 60.1325, y: 41.524, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 60.584, y: 41.1807, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 60.8552, y: 41.1977, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 61.2071, y: 41.1066, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 61.5785, y: 41.0156, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 61.9095, y: 41.0585, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 62.3058, y: 40.9417, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 62.7373, y: 40.8789, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 63.0731, y: 41.1033, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 63.4454, y: 41.2587, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 63.9491, y: 41.8883, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 64.4191, y: 42.7085, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 64.7033, y: 43.2638, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 65.095, y: 43.8087, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 66.3695, y: 43.7262, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 66.7231, y: 44.2696, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 67.1056, y: 44.7382, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 67.7937, y: 44.6594, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 68.8677, y: 44.2301, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 69.0907, y: 44.5453, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 69.4861, y: 44.7911, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 69.8172, y: 44.8131, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 70.1998, y: 45.1166, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 70.5797, y: 45.2967, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 71.1205, y: 45.2856, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 71.5432, y: 45.2918, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 71.8271, y: 45.3919, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 72.346, y: 45.043, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 72.6896, y: 44.4912, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.1118, y: 44.571, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.5669, y: 44.4443, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.7518, y: 43.9756, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.6932, y: 43.9395, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.7462, y: 44.0926, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.7939, y: 44.1021, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.8251, y: 44.1114, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.9478, y: 44.3706, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.868, y: 44.4286, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 74.1271, y: 44.2719, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 74.4044, y: 43.614, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 74.8824, y: 43.384, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 75.41, y: 42.755, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 75.9896, y: 41.9993, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 76.4108, y: 41.4129, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 76.9525, y: 40.8382, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 77.2644, y: 40.146, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 77.8552, y: 39.4842, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 78.2513, y: 38.8507, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 78.6933, y: 38.4479, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 79.3134, y: 37.5822, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 79.5258, y: 37.3792, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 80.2484, y: 36.3984, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 80.5402, y: 36.0104, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 81.0117, y: 35.1742, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 81.4102, y: 34.7142, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 81.923, y: 34.091, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 82.3515, y: 33.7254, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 82.8636, y: 33.1245, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 83.2589, y: 32.5183, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 83.7889, y: 31.8763, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 84.1839, y: 31.3227, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 84.608, y: 30.8645, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 85.0861, y: 29.9611, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 85.4719, y: 29.6255, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 85.942, y: 28.974, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 86.3619, y: 28.4241, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 86.8439, y: 27.7496, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 87.2137, y: 27.2334, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 87.7631, y: 26.7955, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 88.1022, y: 26.1906, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 88.5673, y: 25.4129, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.0979, y: 24.7907, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2398, y: 24.7796, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2153, y: 25.025, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.17, y: 25.511, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.1455, y: 25.8621, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2002, y: 25.9637, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.258, y: 26.0748, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2616, y: 26.4572, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.4243, y: 26.4613, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.3519, y: 26.7413, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.4325, y: 26.9581, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.4473, y: 27.1018, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.4378, y: 27.335, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.4224, y: 27.5384, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.4011, y: 27.7281, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.3758, y: 27.9078, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.3483, y: 28.0809, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.3206, y: 28.2509, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2945, y: 28.4214, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2719, y: 28.5959, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2546, y: 28.7779, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2446, y: 28.9708, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2405, y: 29.1826, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.3126, y: 29.3831, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.464, y: 29.3373, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.7007, y: 29.2282, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 90.0001, y: 29.0979, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 90.3397, y: 28.9888, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 90.6969, y: 28.943, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 91.1382, y: 29.5393, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 91.5794, y: 30.1355, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 91.871, y: 29.9744, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 92.0957, y: 29.6198, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 92.3301, y: 29.2653, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 92.6503, y: 29.1041, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 93.2065, y: 29.7748, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 93.606, y: 30.0396, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 93.8554, y: 29.9913, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.1024, y: 29.812, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.4467, y: 30.0337, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.5404, y: 29.8979, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.7038, y: 30.0114, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.9389, y: 30.2929, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.9733, y: 30.6487, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.9529, y: 30.622, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.9043, y: 30.5582, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.8462, y: 30.4814, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.7976, y: 30.4158, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.7772, y: 30.3856, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.8193, y: 30.3827, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.8097, y: 30.493, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.7269, y: 30.5311, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.618, y: 30.5764, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.5623, y: 30.8367, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.4056, y: 31.195, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.3663, y: 31.4233, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.4556, y: 31.6786, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.6052, y: 31.9592, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.7266, y: 32.2807, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.8363, y: 32.5667, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.7233, y: 32.6764, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.5742, y: 32.845, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 94.4169, y: 32.9701, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 93.8718, y: 33.2339, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 93.0948, y: 33.625, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 91.5657, y: 34.286, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 90.4468, y: 34.2489, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 89.2153, y: 34.6615, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 87.8064, y: 34.9538, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 86.5243, y: 35.3535, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 85.2255, y: 35.8764, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 83.9711, y: 36.2142, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 82.6957, y: 36.5798, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 81.248, y: 37.0284, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 80.094, y: 37.3434, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 78.7351, y: 37.4998, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 77.4159, y: 38.1619, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 76.1443, y: 38.2702, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 75.0042, y: 38.5298, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 73.7556, y: 38.9944, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 72.3156, y: 39.4385, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 71.1636, y: 39.5619, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 70.0092, y: 39.9659, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 68.6074, y: 40.4803, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 67.3603, y: 40.7227, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 66.1258, y: 41.0201, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 65.033, y: 41.4683, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 63.6147, y: 42.0467, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 62.5243, y: 42.3394, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 61.2158, y: 42.7048, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 60.136, y: 42.8999, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 58.7278, y: 43.4108, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 57.5077, y: 43.9605, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 56.844, y: 44.031, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 56.1867, y: 44.2558, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 55.5681, y: 44.7428, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 54.9217, y: 44.4014, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 54.3555, y: 44.7196, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 53.6967, y: 44.9425, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 53.0644, y: 45.1115, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 52.6049, y: 45.2029, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 51.9462, y: 45.5195, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 51.5251, y: 45.3484, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.9464, y: 45.3566, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.5882, y: 45.3889, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 50.3321, y: 45.0163, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 49.9815, y: 44.9628, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 49.461, y: 44.4304, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 48.7905, y: 44.8308, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 48.0973, y: 44.692, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 47.5364, y: 44.6218, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 46.7754, y: 44.6662, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 46.142, y: 43.9127, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 45.2585, y: 44.0431, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 44.5118, y: 43.6596, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 43.8689, y: 43.8023, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 43.438, y: 43.6162, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 43.0331, y: 43.5654, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 42.6816, y: 43.2866, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 42.3471, y: 42.8801, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.9968, y: 42.6237, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.5824, y: 43.1734, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 41.1559, y: 42.9332, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 40.7371, y: 43.0404, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 40.3177, y: 42.8315, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 39.9827, y: 42.8963, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 39.4756, y: 42.751, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 39.0736, y: 42.8952, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 38.5116, y: 42.4768, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 38.0373, y: 42.3511, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 37.5722, y: 42.0563, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 37.05, y: 41.9737, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 36.6715, y: 42.0438, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 36.3297, y: 42.004, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.9658, y: 41.8787, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.7618, y: 41.8419, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.5882, y: 41.8414, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.501, y: 41.8949, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.4246, y: 41.933, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 35.1153, y: 41.7615, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 34.8484, y: 41.9133, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 34.5454, y: 41.6475, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 34.2141, y: 41.5023, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 33.8725, y: 41.4469, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 33.5254, y: 41.361, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 33.1743, y: 41.3674, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 32.6783, y: 41.2377, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 32.4675, y: 41.1006, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 32.17, y: 41.0353, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.9911, y: 40.9839, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.8555, y: 40.9854, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.6557, y: 40.9963, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.4941, y: 40.8417, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.3398, y: 40.8239, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.2859, y: 40.9307, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 31.0681, y: 40.9534, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 30.8697, y: 40.9119, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 30.6678, y: 40.9785, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 30.3129, y: 41.0517, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.8385, y: 41.0526, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.6019, y: 41.6219, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.1983, y: 41.5532, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 29.0669, y: 41.8913, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.99, y: 42.1092, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.9537, y: 42.3382, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.7974, y: 42.5263, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.9163, y: 42.7552, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.7027, y: 42.7987, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.6393, y: 42.861, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.3809, y: 42.9022, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 28.2554, y: 42.8795, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.9819, y: 42.8565, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.893, y: 42.8526, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.7101, y: 42.8049, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.6722, y: 42.9216, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.6299, y: 42.9033, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.5097, y: 42.9415, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.4993, y: 42.9625, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.3355, y: 42.9891, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.2287, y: 43.0079, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.1706, y: 43.0414, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.0153, y: 43.0129, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 27.1202, y: 43.1183, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.8828, y: 42.9689, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.9862, y: 43.2345, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.7304, y: 43.1914, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.5982, y: 43.4017, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }, { x: 26.5293, y: 43.4706, scorepercent: ['NaN'], name: [''], jersey: [''], team: ['Ball'], marker: { enabled: [true], symbol: getBasketball(), height: [20], width: [20] }, color: ['orange'] }]
    }, { sequence: [{ x: 10.086, y: 11.1015, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.3037, y: 11.2926, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5417, y: 11.5086, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7953, y: 11.7071, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.1012, y: 11.9153, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.4602, y: 12.1289, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.7378, y: 12.3246, scorepercent: ['58.82%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.0176, y: 12.5495, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.295, y: 12.7742, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.6051, y: 12.9921, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.9527, y: 13.2065, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.2739, y: 13.4445, scorepercent: ['22.22%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.6622, y: 13.6766, scorepercent: ['22.22%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.1402, y: 13.8786, scorepercent: ['22.22%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.5889, y: 14.1289, scorepercent: ['22.22%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.023, y: 14.3158, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.4504, y: 14.508, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.8629, y: 14.6733, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.2549, y: 14.856, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.5916, y: 15.0285, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.8741, y: 15.2203, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.245, y: 15.4184, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.6255, y: 15.5712, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.9906, y: 15.724, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.2712, y: 15.821, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.5329, y: 15.9597, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.803, y: 16.0554, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19, y: 16.133, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.1202, y: 16.1835, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.2618, y: 16.1556, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.3995, y: 16.1002, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.575, y: 16.0203, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.7607, y: 15.9313, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.922, y: 15.7591, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.0284, y: 15.607, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.0893, y: 15.358, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1268, y: 15.0997, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1454, y: 14.838, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1773, y: 14.5642, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2261, y: 14.2793, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2693, y: 13.9966, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3164, y: 13.7028, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3559, y: 13.3989, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3824, y: 13.0854, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.397, y: 12.772, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.4104, y: 12.4697, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3801, y: 12.1748, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3398, y: 11.9257, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3027, y: 11.733, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.31, y: 11.5132, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3247, y: 11.29, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3614, y: 11.0831, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3744, y: 10.8599, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.4016, y: 10.669, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.433, y: 10.5158, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.4446, y: 10.316, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.4604, y: 10.1249, scorepercent: ['37.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.4838, y: 9.9499, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.5295, y: 9.7816, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.5901, y: 9.6197, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.6972, y: 9.4946, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.7728, y: 9.3408, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.8855, y: 9.1847, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.0572, y: 9.0857, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.1998, y: 8.9481, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.3749, y: 8.8766, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.5373, y: 8.8017, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.7243, y: 8.7565, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.9028, y: 8.6879, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.1093, y: 8.6425, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.3278, y: 8.5997, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.5852, y: 8.5999, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.827, y: 8.6206, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.0848, y: 8.6537, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.3361, y: 8.6978, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.5663, y: 8.6941, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.8483, y: 8.7466, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.0839, y: 8.7159, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2907, y: 8.6512, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.53, y: 8.5755, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.7788, y: 8.4998, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.0329, y: 8.4286, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.3236, y: 8.4157, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.624, y: 8.4002, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.9409, y: 8.3946, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.2679, y: 8.3856, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.6104, y: 8.3857, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9798, y: 8.3601, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.339, y: 8.3403, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.722, y: 8.3131, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.1114, y: 8.2989, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.5201, y: 8.2713, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.9488, y: 8.2318, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.4016, y: 8.2614, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.8797, y: 8.3376, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.3813, y: 8.4132, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.8849, y: 8.5035, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.3635, y: 8.5376, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.8317, y: 8.5409, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.3019, y: 8.5411, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.775, y: 8.5474, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.2134, y: 8.516, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.6946, y: 8.525, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.1695, y: 8.5105, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.6379, y: 8.4941, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.1078, y: 8.4815, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.5695, y: 8.4575, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.0462, y: 8.4984, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.5246, y: 8.4751, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.0149, y: 8.4541, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.5041, y: 8.435, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.0119, y: 8.399, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.5382, y: 8.3611, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.084, y: 8.3599, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.6295, y: 8.3603, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.181, y: 8.3608, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.7428, y: 8.3539, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.2831, y: 8.3149, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.8446, y: 8.2949, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.4081, y: 8.2715, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.9647, y: 8.2454, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.5337, y: 8.2249, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.1072, y: 8.1941, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.6749, y: 8.1516, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.2422, y: 8.112, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.8155, y: 8.0629, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.3997, y: 8.023, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.9761, y: 7.9843, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.5558, y: 7.9361, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.1466, y: 7.8817, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.7488, y: 7.8274, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.3512, y: 7.767, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.9503, y: 7.6991, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.5559, y: 7.6315, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.1694, y: 7.5763, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.7973, y: 7.5251, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.429, y: 7.4818, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.0678, y: 7.435, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.714, y: 7.3822, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.368, y: 7.3355, scorepercent: ['25%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.0261, y: 7.3039, scorepercent: ['25%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.6871, y: 7.2723, scorepercent: ['25%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.3622, y: 7.2525, scorepercent: ['25%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.0486, y: 7.25, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.7355, y: 7.2575, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.4168, y: 7.2722, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.1116, y: 7.298, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.8202, y: 7.3323, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.5326, y: 7.379, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.2621, y: 7.4263, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.9945, y: 7.4823, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.7199, y: 7.5602, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.4452, y: 7.6613, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.174, y: 7.7819, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.8997, y: 7.9096, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.6212, y: 8.0507, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.3426, y: 8.2099, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.0573, y: 8.3813, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.7697, y: 8.5585, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.4314, y: 8.7802, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.095, y: 9.0077, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.7808, y: 9.2352, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.4864, y: 9.4601, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.1888, y: 9.6856, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.834, y: 9.947, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.4625, y: 10.2104, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.1214, y: 10.4343, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.7636, y: 10.6597, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.3898, y: 10.8908, scorepercent: ['16.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.001, y: 11.1221, scorepercent: ['23.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.5966, y: 11.3436, scorepercent: ['23.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.1743, y: 11.5493, scorepercent: ['23.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.7391, y: 11.7381, scorepercent: ['23.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.2914, y: 11.916, scorepercent: ['23.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.8781, y: 12.0505, scorepercent: ['23.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.4505, y: 12.1823, scorepercent: ['52.94%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.9752, y: 12.3118, scorepercent: ['52.94%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 79.4552, y: 12.4428, scorepercent: ['52.94%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 79.9177, y: 12.5658, scorepercent: ['52.94%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 80.406, y: 12.6517, scorepercent: ['52.94%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 80.879, y: 12.7271, scorepercent: ['52.94%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 81.2975, y: 12.8169, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 81.6973, y: 12.8363, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 82.0985, y: 12.8248, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 82.488, y: 12.7971, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 82.8653, y: 12.7504, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 83.2294, y: 12.6891, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 83.5826, y: 12.6104, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 83.9226, y: 12.5171, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 84.2486, y: 12.3986, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 84.5654, y: 12.254, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 84.8793, y: 12.1391, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.1725, y: 11.965, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.4598, y: 11.8202, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.7348, y: 11.6626, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.003, y: 11.4962, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.2637, y: 11.3201, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.5229, y: 11.185, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.7572, y: 11.0573, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.983, y: 10.9224, scorepercent: ['53.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.201, y: 10.7875, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.4057, y: 10.6493, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.6004, y: 10.5091, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.7803, y: 10.3683, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.9262, y: 10.2536, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.0634, y: 10.1365, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.1826, y: 9.9774, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.2979, y: 9.8596, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.3942, y: 9.6971, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.4837, y: 9.5287, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5618, y: 9.3535, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.633, y: 9.1757, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6958, y: 9.0065, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7512, y: 8.8395, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.794, y: 8.6775, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8175, y: 8.5091, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8311, y: 8.324, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8341, y: 8.1491, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8334, y: 7.9761, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.879, y: 7.7382, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.9085, y: 7.5099, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.9292, y: 7.2901, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.9212, y: 7.0793, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.9072, y: 6.8742, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8826, y: 6.6769, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8612, y: 6.4858, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.8249, y: 6.2967, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7817, y: 6.1043, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7343, y: 5.9165, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6895, y: 5.737, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6553, y: 5.5877, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6331, y: 5.4727, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.625, y: 5.3825, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6318, y: 5.3187, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5684, y: 5.3566, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5575, y: 5.4007, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5101, y: 5.4905, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5357, y: 5.5865, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5686, y: 5.7124, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6021, y: 5.8673, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6303, y: 6.0562, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6172, y: 6.2611, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.64, y: 6.5222, scorepercent: ['63.64%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6647, y: 6.8197, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6853, y: 7.1404, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7047, y: 7.4718, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7178, y: 7.8144, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7233, y: 8.1592, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7099, y: 8.5111, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7425, y: 8.8409, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.729, y: 9.1959, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.761, y: 9.5359, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7422, y: 9.9017, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7224, y: 10.2712, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6977, y: 10.6455, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6772, y: 11.0167, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.7028, y: 11.4104, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6907, y: 11.7812, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.68, y: 12.1402, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6715, y: 12.4935, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6673, y: 12.8453, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6561, y: 13.2045, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6431, y: 13.5608, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.6306, y: 13.9147, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5873, y: 14.2942, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5564, y: 14.639, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.5031, y: 14.9789, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.4313, y: 15.3072, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.3397, y: 15.6282, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.238, y: 15.9363, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 88.1221, y: 16.2284, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.9972, y: 16.4988, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.8593, y: 16.7529, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.7062, y: 16.9899, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.535, y: 17.2128, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.3469, y: 17.4188, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 87.1504, y: 17.6081, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.9281, y: 17.787, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.6882, y: 17.9463, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.458, y: 18.0568, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 86.1842, y: 18.1746, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.9188, y: 18.2745, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.65, y: 18.3682, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.3693, y: 18.4489, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 85.0861, y: 18.5159, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 84.7832, y: 18.5781, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 84.4685, y: 18.6462, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 84.1428, y: 18.7049, scorepercent: ['42.86%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 83.8128, y: 18.7707, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 83.5046, y: 18.7927, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 83.1786, y: 18.8231, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 82.8369, y: 18.8538, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 82.4645, y: 18.9229, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 82.0826, y: 18.9918, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 81.6931, y: 19.0668, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 81.3067, y: 19.1491, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 80.8934, y: 19.2242, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 80.4734, y: 19.2927, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 80.0502, y: 19.3674, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 79.6224, y: 19.4389, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 79.1931, y: 19.5087, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.7311, y: 19.6231, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.2651, y: 19.7325, scorepercent: ['18.18%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.7823, y: 19.8355, scorepercent: ['53.85%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.2638, y: 19.9727, scorepercent: ['53.85%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.7403, y: 20.0796, scorepercent: ['44.44%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.2439, y: 20.1755, scorepercent: ['44.44%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.752, y: 20.2081, scorepercent: ['44.44%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.2941, y: 20.2145, scorepercent: ['44.44%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.8114, y: 20.2617, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.3238, y: 20.2983, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.8448, y: 20.3395, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.3582, y: 20.3806, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.872, y: 20.4016, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.3697, y: 20.4144, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.8994, y: 20.4274, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.4323, y: 20.3364, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.9677, y: 20.2425, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.4961, y: 20.1595, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.0315, y: 20.0895, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.5536, y: 20.0351, scorepercent: ['66.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.0744, y: 19.9327, scorepercent: ['40%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.5788, y: 19.8693, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.054, y: 19.8199, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.5494, y: 19.7151, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.0697, y: 19.5848, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.5758, y: 19.45, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.0807, y: 19.3127, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.5688, y: 19.2041, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.0561, y: 19.1152, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.5098, y: 19.0111, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.99, y: 18.9394, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.4628, y: 18.8606, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.9527, y: 18.7415, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.422, y: 18.6023, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.8861, y: 18.4492, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.3317, y: 18.3326, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.8508, y: 18.1498, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.3656, y: 17.9695, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.8653, y: 17.7869, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.3416, y: 17.6264, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.834, y: 17.4534, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.3201, y: 17.2672, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.8191, y: 17.0492, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.3194, y: 16.8023, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.8185, y: 16.5684, scorepercent: ['100%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.3105, y: 16.3453, scorepercent: ['100%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.8112, y: 16.1193, scorepercent: ['100%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.3066, y: 15.879, scorepercent: ['100%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.8254, y: 15.6251, scorepercent: ['100%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.355, y: 15.4102, scorepercent: ['100%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.8708, y: 15.1943, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.345, y: 15.0002, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.8108, y: 14.8005, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.3228, y: 14.5812, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.8047, y: 14.3794, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.2859, y: 14.1745, scorepercent: ['33.33%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.7616, y: 13.9826, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.2475, y: 13.7791, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.7384, y: 13.5845, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.227, y: 13.3712, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.7143, y: 13.1494, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.1928, y: 12.9355, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.6752, y: 12.7574, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.1508, y: 12.6069, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.6297, y: 12.4187, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.1108, y: 12.2312, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.5937, y: 12.0495, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.0744, y: 11.8655, scorepercent: ['N/A'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.5207, y: 11.7116, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.9929, y: 11.5416, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.4611, y: 11.3799, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.9515, y: 11.212, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.4351, y: 11.061, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.9214, y: 10.9125, scorepercent: ['50%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.4145, y: 10.7795, scorepercent: ['50%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.9149, y: 10.6466, scorepercent: ['50%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.4192, y: 10.5145, scorepercent: ['50%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.9164, y: 10.3837, scorepercent: ['50%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.4082, y: 10.2377, scorepercent: ['50%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.9126, y: 10.1048, scorepercent: ['28.57%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.4255, y: 9.9769, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.9427, y: 9.8541, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.4728, y: 9.7431, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.0101, y: 9.6374, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.5503, y: 9.5311, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.0567, y: 9.3959, scorepercent: ['0%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.5482, y: 9.281, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.0538, y: 9.1446, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.5837, y: 9.0118, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.127, y: 8.9394, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.6767, y: 8.8836, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.2274, y: 8.8363, scorepercent: ['20%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.7859, y: 8.7865, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.3952, y: 8.7679, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.9666, y: 8.7234, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.5394, y: 8.6844, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.1166, y: 8.6545, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.6978, y: 8.6302, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.28, y: 8.6003, scorepercent: ['27.27%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.8651, y: 8.5765, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.4877, y: 8.5869, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.1468, y: 8.6189, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.7812, y: 8.6305, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.4041, y: 8.6891, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.0067, y: 8.6441, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.635, y: 8.6222, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.2238, y: 8.6256, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.8516, y: 8.6254, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.4375, y: 8.613, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.0494, y: 8.583, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.6643, y: 8.5557, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.301, y: 8.5888, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9487, y: 8.6214, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.6067, y: 8.6684, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2788, y: 8.7283, scorepercent: ['12.5%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.9616, y: 8.8023, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.6368, y: 8.8498, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.3435, y: 8.9451, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.0003, y: 8.9603, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.6333, y: 8.9785, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.2483, y: 8.9723, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.9471, y: 8.9793, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.638, y: 9.0398, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.3085, y: 9.0479, scorepercent: ['41.67%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.9979, y: 9.0985, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.693, y: 9.1485, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3743, y: 9.1372, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.0511, y: 9.1229, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.7221, y: 9.0991, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.3806, y: 9.1215, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.0328, y: 9.1407, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.6852, y: 9.1597, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.3274, y: 9.1814, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.0273, y: 9.2437, scorepercent: ['54.55%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.7766, y: 9.3008, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.5309, y: 9.4168, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.2638, y: 9.4916, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.9842, y: 9.5225, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.7456, y: 9.6069, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.5204, y: 9.6962, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.3075, y: 9.7901, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.1081, y: 9.8954, scorepercent: ['36.36%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.9071, y: 10.0014, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.7086, y: 10.1105, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5316, y: 10.1673, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.3583, y: 10.2237, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.1546, y: 10.2256, scorepercent: ['57.14%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.9591, y: 10.2279, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.7632, y: 10.2284, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.5659, y: 10.2787, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.3707, y: 10.2707, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.1822, y: 10.3216, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.9916, y: 10.3187, scorepercent: ['36.84%'], name: ['B.Rush'], jersey: [' #4'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }] }, { sequence: [{ x: 30.3078, y: 23.7893, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.2466, y: 23.6999, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.1762, y: 23.6075, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.0962, y: 23.5128, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.013, y: 23.4289, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.9235, y: 23.3461, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.8259, y: 23.2692, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.6873, y: 23.1546, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.5832, y: 23.0988, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.5223, y: 23.1029, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.4161, y: 23.0734, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.3528, y: 23.0988, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.2601, y: 23.1126, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.2052, y: 23.1566, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.1558, y: 23.2126, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.1049, y: 23.2709, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.0028, y: 23.2935, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.9039, y: 23.3215, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.8109, y: 23.3545, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.7124, y: 23.3893, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.6136, y: 23.4277, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.5154, y: 23.4686, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.4569, y: 23.5593, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.3633, y: 23.6014, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.2241, y: 23.5982, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.1282, y: 23.6355, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.9861, y: 23.6273, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.8693, y: 23.6434, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.7152, y: 23.6401, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.5518, y: 23.638, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.3894, y: 23.6463, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.3217, y: 23.7335, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.2175, y: 23.8004, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.1087, y: 23.871, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.0062, y: 23.946, scorepercent: ['66.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9382, y: 24.0656, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.8495, y: 24.2026, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.7744, y: 24.3394, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.6894, y: 24.4853, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.6171, y: 24.6137, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.557, y: 24.7407, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.4792, y: 24.8721, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.4056, y: 24.9498, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.3341, y: 25.0312, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.2664, y: 25.1175, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.1956, y: 25.1962, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.0813, y: 25.2414, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.0046, y: 25.3122, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.9279, y: 25.3817, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.8498, y: 25.4485, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.7407, y: 25.4774, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.653, y: 25.4932, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.5496, y: 25.5108, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.4526, y: 25.5271, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.3446, y: 25.5634, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.2279, y: 25.6116, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.1309, y: 25.6625, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.041, y: 25.7731, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9515, y: 25.8846, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8651, y: 25.9933, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.7883, y: 26.107, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.7186, y: 26.2222, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.6592, y: 26.3368, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.607, y: 26.4589, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5623, y: 26.5805, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5264, y: 26.7053, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4978, y: 26.8315, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4775, y: 26.9656, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4628, y: 27.0955, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4569, y: 27.2286, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4555, y: 27.3616, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4623, y: 27.4953, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.468, y: 27.625, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4789, y: 27.7612, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4913, y: 27.8942, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5028, y: 28.0262, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5155, y: 28.156, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5244, y: 28.2903, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.533, y: 28.4229, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5404, y: 28.5626, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5877, y: 28.7349, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.6343, y: 28.9097, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.6778, y: 29.0819, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.7251, y: 29.258, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.7708, y: 29.4418, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8163, y: 29.6232, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8615, y: 29.8025, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8655, y: 29.961, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8714, y: 30.1195, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8803, y: 30.2895, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8939, y: 30.4673, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9105, y: 30.6512, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9303, y: 30.8359, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9545, y: 31.0244, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9823, y: 31.2112, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9689, y: 31.3656, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9585, y: 31.5205, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.955, y: 31.6728, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9523, y: 31.8266, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9544, y: 31.973, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9618, y: 32.1288, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9703, y: 32.2897, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.0269, y: 32.4833, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.086, y: 32.6777, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.1867, y: 32.8998, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.2953, y: 33.1196, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.4108, y: 33.3414, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.4883, y: 33.5397, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.575, y: 33.7402, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.6666, y: 33.9407, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.7676, y: 34.1435, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.8731, y: 34.3475, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.987, y: 34.5561, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.1089, y: 34.7681, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.2358, y: 34.9852, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.3696, y: 35.2017, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.5155, y: 35.4149, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.67, y: 35.6188, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.8364, y: 35.822, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9797, y: 35.994, scorepercent: ['75%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.1313, y: 36.1644, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.2922, y: 36.3321, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.5077, y: 36.5264, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.7316, y: 36.7173, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.9648, y: 36.9015, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.2376, y: 37.1182, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.4949, y: 37.2905, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.761, y: 37.4577, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.0346, y: 37.6151, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.318, y: 37.7664, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.6068, y: 37.9074, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.9171, y: 38.0573, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.2542, y: 38.2132, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.6156, y: 38.3763, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.9481, y: 38.5046, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.293, y: 38.6365, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.6502, y: 38.7712, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.0199, y: 38.8983, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.3946, y: 39.0192, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.8152, y: 39.161, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.2075, y: 39.2598, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.645, y: 39.3991, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.0925, y: 39.5374, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.5545, y: 39.6774, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.0347, y: 39.8237, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.5299, y: 39.9768, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.0245, y: 40.1095, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.5124, y: 40.2318, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.9955, y: 40.3349, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.5265, y: 40.4611, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.0884, y: 40.5514, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.6521, y: 40.6251, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.2187, y: 40.6943, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.7913, y: 40.7617, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.3368, y: 40.8045, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.8949, y: 40.8471, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.4538, y: 40.8805, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.0169, y: 40.9068, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.5825, y: 40.9324, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.1482, y: 40.9479, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.6985, y: 40.9757, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.2485, y: 41.0054, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.799, y: 41.0365, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.3446, y: 41.0572, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.8914, y: 41.0817, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.4057, y: 41.127, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.9178, y: 41.1747, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.4287, y: 41.2267, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.9422, y: 41.2765, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.4514, y: 41.3212, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.9625, y: 41.3492, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.4608, y: 41.3683, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.9626, y: 41.3903, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.4598, y: 41.4051, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.9465, y: 41.4191, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.4476, y: 41.4153, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.9511, y: 41.4112, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.453, y: 41.4013, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.9579, y: 41.3978, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.4494, y: 41.4029, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.9411, y: 41.3995, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.4286, y: 41.394, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.9062, y: 41.3831, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.3595, y: 41.4255, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.8128, y: 41.418, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.2489, y: 41.4592, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.6825, y: 41.5139, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.0998, y: 41.5723, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.5139, y: 41.63, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.9188, y: 41.6832, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.3423, y: 41.6943, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.7782, y: 41.6685, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.1915, y: 41.6342, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.5815, y: 41.6019, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.956, y: 41.551, scorepercent: ['28.57%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.3075, y: 41.565, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.6437, y: 41.5558, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.9805, y: 41.5431, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.3334, y: 41.502, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.702, y: 41.4994, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.0804, y: 41.5025, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.4448, y: 41.4573, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.828, y: 41.4646, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.2099, y: 41.4768, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.6272, y: 41.4646, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.0203, y: 41.4703, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.3661, y: 41.5578, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.7526, y: 41.6752, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.139, y: 41.7682, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.5375, y: 41.8706, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.9503, y: 41.9128, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.4009, y: 42.0221, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.8769, y: 42.1771, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.3704, y: 42.2838, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.8433, y: 42.4333, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.3226, y: 42.5341, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.8165, y: 42.6861, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.2931, y: 42.7799, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.7648, y: 42.8867, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.1993, y: 43.0285, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.6136, y: 43.1965, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.0356, y: 43.3524, scorepercent: ['14.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.399, y: 43.5156, scorepercent: ['14.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.7438, y: 43.7308, scorepercent: ['14.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.0844, y: 43.9364, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.413, y: 44.135, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.6997, y: 44.2671, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.9374, y: 44.3775, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.1393, y: 44.5062, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.3207, y: 44.5853, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.4688, y: 44.6807, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.5921, y: 44.7815, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.6918, y: 44.8957, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.7706, y: 44.9838, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.837, y: 45.0402, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.8977, y: 45.0971, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.9622, y: 45.1091, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.0426, y: 45.0804, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.1364, y: 45.012, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.2128, y: 44.9406, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.2869, y: 44.8772, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.3689, y: 44.856, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.4546, y: 44.8165, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.5336, y: 44.7788, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.6068, y: 44.7626, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.6855, y: 44.7386, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.7729, y: 44.6966, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.8679, y: 44.6345, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.992, y: 44.58, scorepercent: ['31.82%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.12, y: 44.5461, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.2504, y: 44.5069, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.3566, y: 44.4786, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.463, y: 44.4636, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.5755, y: 44.4557, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.699, y: 44.4505, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8287, y: 44.4532, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.9469, y: 44.4394, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.0612, y: 44.4199, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.1742, y: 44.396, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.2892, y: 44.3632, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.3995, y: 44.3306, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.5105, y: 44.2974, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.6137, y: 44.2707, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.6923, y: 44.2436, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.7691, y: 44.2154, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.8493, y: 44.1813, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.9469, y: 44.147, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.039, y: 44.109, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.1201, y: 44.0703, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.1877, y: 44.0339, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.2335, y: 43.989, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.271, y: 43.9332, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.2927, y: 43.8829, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.3052, y: 43.8263, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.302, y: 43.7715, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.287, y: 43.7041, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.2468, y: 43.6346, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.1913, y: 43.5565, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.1112, y: 43.4711, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.0118, y: 43.3813, scorepercent: ['36.05%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.8941, y: 43.2868, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.7525, y: 43.1833, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.5817, y: 43.0809, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.3916, y: 42.9744, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.186, y: 42.8617, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.9653, y: 42.7396, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.7303, y: 42.6145, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.4891, y: 42.4783, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.2315, y: 42.3475, scorepercent: ['42.86%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.9664, y: 42.2159, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.6824, y: 42.0869, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.3617, y: 42.0103, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.0292, y: 41.9414, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.6908, y: 41.868, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.3438, y: 41.7897, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.9992, y: 41.6547, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.6452, y: 41.5177, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.2866, y: 41.3775, scorepercent: ['39.29%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.9234, y: 41.2366, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.549, y: 41.0956, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.1615, y: 40.9606, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.7643, y: 40.8258, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.362, y: 40.6857, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.9583, y: 40.5364, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.5565, y: 40.3671, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.1541, y: 40.1999, scorepercent: ['51.61%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.7742, y: 39.9801, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.3888, y: 39.7488, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.993, y: 39.5369, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.5832, y: 39.3375, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.1394, y: 39.2173, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.672, y: 39.1213, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.2014, y: 39.0256, scorepercent: ['70%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.7224, y: 38.9333, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.2547, y: 38.8149, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.8227, y: 38.7035, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.36, y: 38.5921, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.8652, y: 38.483, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.3915, y: 38.3368, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.8971, y: 38.2169, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.3693, y: 38.1398, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.8763, y: 38.0114, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.3878, y: 37.8772, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.9002, y: 37.7276, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.4187, y: 37.566, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.934, y: 37.4013, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.4652, y: 37.225, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.9947, y: 37.0455, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.5212, y: 36.866, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.0262, y: 36.7139, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.4927, y: 36.5605, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.9784, y: 36.4116, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.4969, y: 36.268, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.9826, y: 36.1804, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.47, y: 36.0896, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.9903, y: 35.9486, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.4803, y: 35.8548, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.9674, y: 35.777, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.4598, y: 35.6987, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.9454, y: 35.6199, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.4484, y: 35.5239, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.9617, y: 35.4243, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.4799, y: 35.3261, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.0008, y: 35.2247, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.4951, y: 35.1209, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.9933, y: 35.0107, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.4955, y: 34.9053, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.9866, y: 34.8024, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.4813, y: 34.7061, scorepercent: ['100%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.9779, y: 34.6286, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.4843, y: 34.5541, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.9772, y: 34.4938, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.4666, y: 34.4372, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.9533, y: 34.3931, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.4468, y: 34.3521, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.9433, y: 34.3188, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.4288, y: 34.2955, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.9164, y: 34.294, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.3989, y: 34.3109, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.9132, y: 34.3506, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.4263, y: 34.4029, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.9437, y: 34.4611, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.4575, y: 34.5143, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.9763, y: 34.5613, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.4968, y: 34.5971, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.0069, y: 34.6571, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.527, y: 34.7256, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.0521, y: 34.8034, scorepercent: ['50%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.5744, y: 34.8882, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.0952, y: 34.9917, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.6153, y: 35.1064, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.1397, y: 35.2261, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.6547, y: 35.3432, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.1718, y: 35.4685, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.6876, y: 35.6035, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.2201, y: 35.7419, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.7662, y: 35.886, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.329, y: 36.001, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.9049, y: 36.163, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.4915, y: 36.3358, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.0941, y: 36.5614, scorepercent: ['25%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.6926, y: 36.7353, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.3092, y: 36.9076, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.9152, y: 37.0428, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.5285, y: 37.1884, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.1515, y: 37.3323, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.7704, y: 37.516, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.4074, y: 37.6885, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.0619, y: 37.8484, scorepercent: ['0%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.7319, y: 37.9953, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.4134, y: 38.0875, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.0986, y: 38.1646, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.7826, y: 38.2733, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.4715, y: 38.3254, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.174, y: 38.35, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.885, y: 38.3009, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.6217, y: 38.2811, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.3578, y: 38.2504, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.1256, y: 38.2543, scorepercent: ['N/A'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9057, y: 38.2369, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.694, y: 38.2025, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.5101, y: 38.109, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.3382, y: 38.0111, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.1793, y: 37.8944, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.0388, y: 37.7654, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.9039, y: 37.6786, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.7665, y: 37.6113, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.6405, y: 37.5541, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.5216, y: 37.5001, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.4098, y: 37.4546, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.2952, y: 37.4141, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.1896, y: 37.3803, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.0868, y: 37.3486, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.987, y: 37.3165, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8894, y: 37.3024, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.7939, y: 37.2908, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.6971, y: 37.2925, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5918, y: 37.3001, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4744, y: 37.3353, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3721, y: 37.418, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2678, y: 37.517, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.1691, y: 37.6134, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.0643, y: 37.7147, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.9535, y: 37.7907, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.8318, y: 37.8845, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.7044, y: 37.9849, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.5915, y: 38.124, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.4292, y: 38.2796, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.2605, y: 38.4315, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.0859, y: 38.5717, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.9063, y: 38.7204, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.7502, y: 38.8853, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.5979, y: 39.0479, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.4163, y: 39.1664, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.2156, y: 39.2434, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.0142, y: 39.3028, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.8057, y: 39.3065, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.6057, y: 39.2961, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.4258, y: 39.354, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.2419, y: 39.356, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.0716, y: 39.3938, scorepercent: ['33.33%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.8768, y: 39.4435, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.7428, y: 39.4798, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.6121, y: 39.5077, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.5028, y: 39.5224, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3864, y: 39.4732, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2473, y: 39.3966, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1141, y: 39.3129, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.0407, y: 39.2906, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.9874, y: 39.2146, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.9003, y: 39.1367, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.824, y: 39.0975, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.7542, y: 39.0645, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.6716, y: 38.9856, scorepercent: ['46.67%'], name: ['S.Curry'], jersey: [' #30'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }] }, { sequence: [{ x: 20.3833, y: 18.7923, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1396, y: 18.8447, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.9203, y: 18.9595, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.6791, y: 18.9823, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.4286, y: 19.009, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.1714, y: 19.0211, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.9163, y: 19.0154, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.6492, y: 18.9975, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.3976, y: 18.9593, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.1533, y: 18.9336, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.8881, y: 18.9075, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.6362, y: 18.8475, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.3803, y: 18.7784, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.135, y: 18.6947, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.884, y: 18.6198, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.6291, y: 18.544, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.379, y: 18.4712, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.1237, y: 18.3277, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.8794, y: 18.2148, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.6333, y: 18.1081, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.3944, y: 18.0065, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.1542, y: 17.9266, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.9319, y: 17.848, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.699, y: 17.7807, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.4622, y: 17.6993, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.2491, y: 17.6087, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.0358, y: 17.5271, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.8338, y: 17.4418, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.6319, y: 17.3552, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.4374, y: 17.2572, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.2461, y: 17.1554, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.0575, y: 17.0319, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.8702, y: 16.9213, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.6891, y: 16.8201, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.5156, y: 16.7123, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.3462, y: 16.604, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.184, y: 16.4816, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.0304, y: 16.3612, scorepercent: ['40%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.8838, y: 16.2439, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.7424, y: 16.1322, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.5991, y: 16.0233, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.4585, y: 15.92, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.3148, y: 15.8265, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.1678, y: 15.742, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.0153, y: 15.6626, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8668, y: 15.5908, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7223, y: 15.5345, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5782, y: 15.486, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.44, y: 15.4432, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.3063, y: 15.4067, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.1767, y: 15.3729, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.05, y: 15.3443, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.9191, y: 15.321, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.7933, y: 15.3051, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.6707, y: 15.2991, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.5542, y: 15.2987, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.441, y: 15.3069, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.3339, y: 15.3165, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.2282, y: 15.3312, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.129, y: 15.3504, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.0342, y: 15.3749, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9475, y: 15.4085, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8715, y: 15.4562, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8027, y: 15.5143, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.7385, y: 15.5722, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.6807, y: 15.6397, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.6288, y: 15.7069, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.5829, y: 15.7764, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.5411, y: 15.8444, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.5047, y: 15.9066, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4752, y: 15.9726, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4544, y: 16.0361, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4427, y: 16.0993, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4423, y: 16.1623, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4544, y: 16.2273, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4734, y: 16.2914, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.4963, y: 16.3462, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.5247, y: 16.3975, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.5599, y: 16.4441, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.6025, y: 16.497, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.6519, y: 16.5424, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.7109, y: 16.5877, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.7802, y: 16.6299, scorepercent: ['52.17%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8554, y: 16.6699, scorepercent: ['37.04%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9384, y: 16.7095, scorepercent: ['37.04%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.0292, y: 16.7481, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.1265, y: 16.7842, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.2357, y: 16.8231, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.3598, y: 16.8668, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.4754, y: 16.8686, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.6035, y: 16.8642, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.7696, y: 16.9084, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.9443, y: 16.9474, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.1287, y: 16.9779, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.3314, y: 16.9987, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5906, y: 17.0604, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8431, y: 17.1077, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.1019, y: 17.1488, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.3425, y: 17.1437, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.5967, y: 17.1345, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.8596, y: 17.1148, scorepercent: ['29.73%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.1221, y: 17.0803, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.3996, y: 17.039, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.6913, y: 16.9956, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.0205, y: 16.9858, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.368, y: 16.9699, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.7127, y: 16.9215, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.0702, y: 16.8714, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.4427, y: 16.8207, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.8153, y: 16.763, scorepercent: ['47.06%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.1587, y: 16.6544, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5262, y: 16.5417, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.8677, y: 16.385, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.2683, y: 16.2754, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.6826, y: 16.161, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.123, y: 16.0673, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.6014, y: 15.98, scorepercent: ['30.77%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.0413, y: 15.8595, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.4754, y: 15.7201, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.9059, y: 15.5719, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.3337, y: 15.4198, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.747, y: 15.2387, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1889, y: 15.1019, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.6244, y: 14.9074, scorepercent: ['37.93%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.0688, y: 14.7184, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.5221, y: 14.5671, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.9953, y: 14.4134, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.4991, y: 14.3098, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.9663, y: 14.1464, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.453, y: 14.0163, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.9358, y: 13.8477, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4114, y: 13.6727, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.936, y: 13.5284, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.4389, y: 13.3552, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.937, y: 13.1807, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.4563, y: 13.032, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9619, y: 12.8508, scorepercent: ['33.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.4531, y: 12.628, scorepercent: ['100%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.9507, y: 12.4539, scorepercent: ['100%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.4513, y: 12.2687, scorepercent: ['100%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.9412, y: 12.047, scorepercent: ['100%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.4163, y: 11.8303, scorepercent: ['100%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.9354, y: 11.6224, scorepercent: ['100%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.4505, y: 11.4445, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.9487, y: 11.2303, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.4337, y: 11.0281, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.9072, y: 10.8202, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.3747, y: 10.6104, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.8792, y: 10.4383, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.4014, y: 10.2751, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.9183, y: 10.1004, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.4602, y: 9.9613, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.9967, y: 9.8143, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.5374, y: 9.6684, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.0767, y: 9.529, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.6138, y: 9.3913, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.1547, y: 9.2543, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.6728, y: 9.1026, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.2202, y: 8.9617, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.7631, y: 8.8281, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.3234, y: 8.6958, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.887, y: 8.5742, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.4463, y: 8.4607, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.0025, y: 8.3408, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.5533, y: 8.2172, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.0958, y: 8.0851, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.6359, y: 7.9501, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.1818, y: 7.8183, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.7266, y: 7.6989, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.2808, y: 7.5789, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.8364, y: 7.4658, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.3839, y: 7.358, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.9345, y: 7.2479, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.4803, y: 7.1457, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.0246, y: 7.0361, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.56, y: 6.9308, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.0974, y: 6.8269, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.641, y: 6.7187, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.1833, y: 6.6104, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.7235, y: 6.5091, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.2612, y: 6.4031, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.8013, y: 6.2962, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.327, y: 6.196, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.8557, y: 6.0899, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.3732, y: 5.9824, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.8968, y: 5.8784, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.4296, y: 5.7766, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.9519, y: 5.6745, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.4736, y: 5.5762, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.022, y: 5.466, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.5694, y: 5.3513, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.1028, y: 5.2392, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.6359, y: 5.1276, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.1589, y: 5.024, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.6746, y: 4.9211, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.1848, y: 4.8252, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.6961, y: 4.7324, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.2135, y: 4.6306, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.7329, y: 4.5268, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.2534, y: 4.4306, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.7597, y: 4.3204, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.2574, y: 4.2213, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.7441, y: 4.1265, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.2266, y: 4.0389, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.6701, y: 3.9776, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.1053, y: 3.9306, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.551, y: 3.8836, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.9919, y: 3.8365, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.4357, y: 3.7872, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.8773, y: 3.735, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.3124, y: 3.6816, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.7348, y: 3.6317, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.1489, y: 3.5849, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.5451, y: 3.5488, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.9297, y: 3.5114, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.3088, y: 3.4822, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.6812, y: 3.4424, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.0562, y: 3.4073, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.4288, y: 3.3687, scorepercent: ['36.36%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.8004, y: 3.3288, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.1718, y: 3.2794, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.5328, y: 3.2425, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.8709, y: 3.2068, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.1882, y: 3.2211, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.5062, y: 3.1863, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.8044, y: 3.2089, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.0965, y: 3.2348, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.3826, y: 3.2703, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.6804, y: 3.2777, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.9692, y: 3.2945, scorepercent: ['25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.2541, y: 3.3158, scorepercent: ['58.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.5249, y: 3.3416, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.7788, y: 3.3633, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.02, y: 3.3938, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.2538, y: 3.4191, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.4724, y: 3.4517, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.6796, y: 3.4787, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.8885, y: 3.5049, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.0936, y: 3.489, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.2809, y: 3.5259, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.4728, y: 3.5082, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.6495, y: 3.4901, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.8156, y: 3.4625, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.9556, y: 3.4581, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.0876, y: 3.453, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.2026, y: 3.4472, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.3154, y: 3.4505, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.4471, y: 3.4249, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.5295, y: 3.3888, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.5831, y: 3.378, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.6517, y: 3.3945, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.711, y: 3.4113, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.7652, y: 3.4799, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8184, y: 3.5513, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8553, y: 3.6251, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8732, y: 3.6523, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8808, y: 3.6814, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8756, y: 3.7155, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8589, y: 3.7573, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8317, y: 3.7933, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.8003, y: 3.8301, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.7555, y: 3.8632, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.6734, y: 3.9325, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.6219, y: 4.0054, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.5647, y: 4.1051, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.475, y: 4.1791, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.3826, y: 4.2602, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.2816, y: 4.2979, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.1744, y: 4.2904, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.0678, y: 4.2841, scorepercent: ['38.89%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.9646, y: 4.3326, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.8595, y: 4.3861, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.7423, y: 4.4431, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.6413, y: 4.4533, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.4943, y: 4.4781, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.3534, y: 4.5043, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.2147, y: 4.5803, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.0688, y: 4.6528, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.9189, y: 4.7334, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.7773, y: 4.7683, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.6266, y: 4.8082, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.4715, y: 4.848, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.3104, y: 4.8854, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.1396, y: 4.9704, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.9669, y: 5.0546, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.7934, y: 5.1323, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.6192, y: 5.2111, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.4447, y: 5.2924, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.2471, y: 5.4272, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.0881, y: 5.5564, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.9134, y: 5.6858, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.7297, y: 5.7658, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.5464, y: 5.85, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.3602, y: 5.9287, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.1752, y: 6.0095, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.9917, y: 6.0878, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.801, y: 6.1697, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.6093, y: 6.2574, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.4119, y: 6.3477, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.2117, y: 6.4421, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.0049, y: 6.4992, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.796, y: 6.555, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.6155, y: 6.6096, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.4328, y: 6.6662, scorepercent: ['42.11%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.2469, y: 6.7334, scorepercent: ['56.25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.0368, y: 6.857, scorepercent: ['56.25%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.8329, y: 6.9379, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.6311, y: 7.0571, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.4277, y: 7.1823, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.2262, y: 7.3088, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.0309, y: 7.39, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.8481, y: 7.4601, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.6666, y: 7.5204, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.4854, y: 7.5822, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.2939, y: 7.7072, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.1177, y: 7.8701, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.9232, y: 8.0445, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.6866, y: 8.2727, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.451, y: 8.4969, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.2142, y: 8.7147, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.0028, y: 8.8786, scorepercent: ['50%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.782, y: 9.086, scorepercent: ['58.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.5564, y: 9.2638, scorepercent: ['58.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.3333, y: 9.4396, scorepercent: ['58.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.1007, y: 9.6171, scorepercent: ['58.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.8626, y: 9.846, scorepercent: ['58.33%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.6096, y: 10.0885, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.3397, y: 10.3387, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.0845, y: 10.5937, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.8116, y: 10.784, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.5467, y: 11.0058, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.2919, y: 11.2251, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.0309, y: 11.4, scorepercent: ['41.18%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.7698, y: 11.5844, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.4999, y: 11.7645, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.2239, y: 11.9451, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.9441, y: 12.1227, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.6561, y: 12.332, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.3894, y: 12.4748, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.1148, y: 12.6235, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.8335, y: 12.7569, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.5554, y: 12.8857, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.2794, y: 13.0221, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.9808, y: 13.1428, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.6917, y: 13.2692, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.3651, y: 13.3769, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.0293, y: 13.4746, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.7057, y: 13.5702, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.3765, y: 13.655, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.0475, y: 13.7454, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.7064, y: 13.8323, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.3575, y: 13.9236, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.0103, y: 13.9864, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.6286, y: 14.1192, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.2449, y: 14.2311, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.8511, y: 14.3668, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.4408, y: 14.4969, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.0277, y: 14.6162, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.5991, y: 14.7352, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.1632, y: 14.8453, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.7308, y: 14.9606, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.2922, y: 15.0806, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.848, y: 15.1864, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.4047, y: 15.2897, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.957, y: 15.3792, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.4665, y: 15.4311, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.9898, y: 15.4843, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.5157, y: 15.5321, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.0357, y: 15.6103, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.5538, y: 15.6981, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.066, y: 15.7269, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.6054, y: 15.7398, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.1451, y: 15.7548, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.7044, y: 15.7805, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.2773, y: 15.8124, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.8482, y: 15.8331, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.3981, y: 15.8695, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.9408, y: 15.9026, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.4739, y: 15.9283, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.007, y: 15.9553, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.5823, y: 16.0158, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.1343, y: 16.0639, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.6742, y: 16.1018, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.2185, y: 16.0967, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.7682, y: 16.0937, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.3192, y: 16.1395, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.8443, y: 16.2087, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.3663, y: 16.2702, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.8763, y: 16.3291, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.3821, y: 16.3834, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.8906, y: 16.4296, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.4309, y: 16.4492, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.9793, y: 16.4745, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.5358, y: 16.5109, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.0988, y: 16.5472, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.6618, y: 16.5728, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.2416, y: 16.6125, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.8317, y: 16.6455, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.4258, y: 16.6768, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.0533, y: 16.7411, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.6939, y: 16.8026, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.3463, y: 16.8579, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.9981, y: 16.9245, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.6464, y: 16.9419, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.2896, y: 16.9181, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.9404, y: 16.9073, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.5977, y: 16.8996, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.2612, y: 16.8912, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.9348, y: 16.8687, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.6113, y: 16.8426, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.326, y: 16.8816, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.0459, y: 16.9201, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.7741, y: 16.9682, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.5141, y: 17.0223, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.2363, y: 17.0364, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.9622, y: 16.9947, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.6877, y: 16.9465, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.4214, y: 16.8922, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.1935, y: 16.8712, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.9816, y: 16.8835, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.7545, y: 16.9248, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.5321, y: 16.9666, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.32, y: 17.0082, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.1066, y: 17.0038, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.9159, y: 17.061, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.7103, y: 17.0681, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.5099, y: 17.0607, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.3103, y: 17.0387, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.1054, y: 17.0115, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.9022, y: 16.984, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.7115, y: 17.0158, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.5329, y: 17.0584, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.3744, y: 17.1077, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.2017, y: 17.1707, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.0361, y: 17.2449, scorepercent: ['0%'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.8943, y: 17.283, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.7578, y: 17.3208, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.586, y: 17.3216, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.4535, y: 17.4173, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.3118, y: 17.4526, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.168, y: 17.4834, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.0246, y: 17.5178, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.883, y: 17.5598, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.7482, y: 17.6032, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.6121, y: 17.6421, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.4641, y: 17.6668, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.3137, y: 17.683, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.1533, y: 17.6827, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9928, y: 17.6768, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.8334, y: 17.6654, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.6757, y: 17.6513, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.5193, y: 17.634, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3998, y: 17.6484, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2496, y: 17.6258, scorepercent: ['N/A'], name: ['K.Thompson'], jersey: [' #11'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }] }, { sequence: [{ x: 24.2241, y: 29.9066, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2735, y: 29.9665, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3025, y: 30.0187, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3277, y: 30.0664, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3356, y: 30.0996, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3295, y: 30.1219, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.3004, y: 30.1341, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2506, y: 30.1361, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.1778, y: 30.1344, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.0824, y: 30.1196, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.9699, y: 30.0906, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.846, y: 30.0464, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.7078, y: 29.9904, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.5553, y: 29.925, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.3971, y: 29.8541, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.2347, y: 29.7805, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.0735, y: 29.7053, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.9215, y: 29.6322, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.7706, y: 29.5591, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.6194, y: 29.4882, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.4733, y: 29.4169, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.3295, y: 29.3424, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.1974, y: 29.2664, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.068, y: 29.1836, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.9432, y: 29.0978, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.8149, y: 29.0102, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.6805, y: 28.9244, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.5357, y: 28.8377, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.3856, y: 28.7558, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.2253, y: 28.6847, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.0534, y: 28.6007, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.8686, y: 28.52, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.6733, y: 28.4414, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.4672, y: 28.3623, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2516, y: 28.2875, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.056, y: 28.2414, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.8588, y: 28.2103, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.6605, y: 28.1887, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.4144, y: 28.131, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.1732, y: 28.0793, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.9778, y: 28.0651, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.7428, y: 28.0313, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.5137, y: 28.0094, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.2875, y: 27.9975, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.0665, y: 27.9816, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.8511, y: 27.9877, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.6198, y: 28.013, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.3706, y: 28.0476, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.1105, y: 28.0805, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.8462, y: 28.1199, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.5792, y: 28.0966, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.3015, y: 28.0699, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.0097, y: 28.0402, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.7597, y: 28.0591, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.4991, y: 28.0813, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.1844, y: 28.0648, scorepercent: ['42.86%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.8988, y: 28.0833, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.6011, y: 28.0935, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.3061, y: 28.0819, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.002, y: 28.0709, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.6643, y: 28.0052, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.3046, y: 27.8686, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.957, y: 27.7377, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.6194, y: 27.6225, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.2949, y: 27.5038, scorepercent: ['44.44%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.8915, y: 27.4697, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.4453, y: 27.4747, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.0867, y: 27.4874, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8117, y: 27.5033, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5424, y: 27.5242, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.2917, y: 27.5574, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.0582, y: 27.5942, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.8491, y: 27.6388, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.6431, y: 27.6937, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.4599, y: 27.7613, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.3036, y: 27.8955, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.2111, y: 28.0652, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.1179, y: 28.1788, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.0226, y: 28.2434, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9326, y: 28.3207, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8894, y: 28.3765, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9519, y: 28.4068, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9449, y: 28.4191, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.873, y: 28.412, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8178, y: 28.3864, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.7705, y: 28.3512, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.7646, y: 28.3271, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.7751, y: 28.2908, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8137, y: 28.2429, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.8662, y: 28.1723, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9529, y: 28.0777, scorepercent: ['47.06%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.0448, y: 27.9897, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.1386, y: 27.8944, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.2248, y: 27.7714, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.3481, y: 27.6588, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.5446, y: 27.5434, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.7298, y: 27.4164, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.9361, y: 27.2915, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.1925, y: 27.175, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5007, y: 27.0666, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8084, y: 26.9634, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.0755, y: 26.8106, scorepercent: ['38.46%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.3591, y: 26.6481, scorepercent: ['62.5%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.6515, y: 26.4982, scorepercent: ['62.5%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.9755, y: 26.4006, scorepercent: ['62.5%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.3165, y: 26.2962, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.6715, y: 26.137, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.0798, y: 26.0967, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.5568, y: 26.123, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.0271, y: 26.1076, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.4779, y: 26.0449, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.9417, y: 25.9589, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.424, y: 25.8712, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.9152, y: 25.7929, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.3941, y: 25.717, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.8937, y: 25.6351, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.4441, y: 25.5735, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.003, y: 25.519, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.557, y: 25.4592, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.0965, y: 25.3492, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.6594, y: 25.2427, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2466, y: 25.2195, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.8575, y: 25.1221, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.4648, y: 25.0249, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.0898, y: 24.9406, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.7062, y: 24.8993, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.3155, y: 24.8682, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.9294, y: 24.8237, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.528, y: 24.7751, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.1416, y: 24.7354, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.7839, y: 24.7178, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.3856, y: 24.6399, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9825, y: 24.5526, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.6101, y: 24.4829, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.2294, y: 24.4013, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.8625, y: 24.3368, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.4872, y: 24.249, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.1193, y: 24.1985, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.78, y: 24.1786, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.4442, y: 24.1686, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.1265, y: 24.1411, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.8266, y: 24.1133, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.5194, y: 24.1173, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.2141, y: 24.1368, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.9024, y: 24.1574, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.5842, y: 24.1736, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.3166, y: 24.2648, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.0664, y: 24.387, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.8144, y: 24.5074, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.5907, y: 24.6555, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.3529, y: 24.8055, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.1178, y: 24.9666, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.8644, y: 25.1042, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.593, y: 25.2183, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.3366, y: 25.2677, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.0973, y: 25.2612, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.8668, y: 25.2029, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.6629, y: 25.0766, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.4723, y: 24.8734, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.294, y: 24.6016, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.1279, y: 24.2612, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.9742, y: 23.8523, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.8328, y: 23.3747, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.7037, y: 22.8286, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.5594, y: 22.3479, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.4, y: 21.9327, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.2255, y: 21.583, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.0358, y: 21.2987, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.831, y: 21.0799, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.5986, y: 20.9951, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.3389, y: 21.0444, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.0517, y: 21.2277, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.737, y: 21.5451, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.3949, y: 21.9965, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.0294, y: 22.5346, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.6088, y: 23.1651, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.1725, y: 23.851, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.6751, y: 24.6347, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.1891, y: 25.5041, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.701, y: 26.3095, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.202, y: 27.0479, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.7098, y: 27.7422, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.2162, y: 28.395, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.7418, y: 29.0066, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.2342, y: 29.5812, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.7121, y: 30.1011, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.167, y: 30.5898, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.5989, y: 31.0474, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.0195, y: 31.4551, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.3922, y: 31.8843, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.7885, y: 32.2709, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.1423, y: 32.7114, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.5256, y: 33.1703, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.8661, y: 33.66, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.2045, y: 34.196, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.5499, y: 34.7812, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.8844, y: 35.393, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.1115, y: 35.9333, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.2108, y: 36.4021, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.314, y: 36.845, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.4023, y: 37.2736, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.4876, y: 37.6553, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.5698, y: 37.9901, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.6532, y: 38.291, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.7622, y: 38.5472, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.838, y: 38.8267, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.9102, y: 39.046, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.9683, y: 39.247, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.0003, y: 39.3904, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.0321, y: 39.4705, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.0397, y: 39.5005, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.0351, y: 39.4751, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.1028, y: 39.4541, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.2399, y: 39.4839, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.36, y: 39.5187, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.4762, y: 39.5344, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.6252, y: 39.5966, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.7718, y: 39.6945, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.8652, y: 39.7503, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.9865, y: 39.8142, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.1515, y: 39.7986, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.3294, y: 39.8071, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.5131, y: 39.7773, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.7148, y: 39.7486, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.8983, y: 39.7087, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.1309, y: 39.6084, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.3915, y: 39.4868, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.6127, y: 39.3732, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.8418, y: 39.2328, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.1005, y: 39.0584, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.4313, y: 38.8785, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.7264, y: 38.6536, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.0676, y: 38.3514, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.4563, y: 38.0827, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.825, y: 37.7875, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.1698, y: 37.5558, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.5085, y: 37.3062, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.8186, y: 37.0064, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.1002, y: 36.6563, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.4415, y: 36.2753, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.7282, y: 35.9701, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.9906, y: 35.74, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.3147, y: 35.5064, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.6494, y: 35.2733, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.9806, y: 35.0578, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.2444, y: 34.8609, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.5029, y: 34.6561, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.7168, y: 34.4907, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.917, y: 34.3239, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.0964, y: 34.197, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.2443, y: 34.0076, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.3815, y: 33.8119, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.5204, y: 33.6618, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.6582, y: 33.5413, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.7149, y: 33.4583, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.7669, y: 33.346, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.8049, y: 33.1263, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.8323, y: 32.9304, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.7902, y: 32.8033, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.7397, y: 32.6407, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.6813, y: 32.4536, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.6278, y: 32.2252, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.5478, y: 31.986, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.4446, y: 31.7511, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.3025, y: 31.5115, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.1684, y: 31.3311, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 78.0072, y: 31.1573, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.8283, y: 30.9884, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.6975, y: 30.819, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.554, y: 30.6452, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.3996, y: 30.4608, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 77.1864, y: 30.3389, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.939, y: 30.2127, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.7352, y: 30.0072, scorepercent: ['25%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.5031, y: 29.809, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 76.2414, y: 29.6202, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.9462, y: 29.476, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.6604, y: 29.3392, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.3757, y: 29.208, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 75.076, y: 29.0487, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.7522, y: 28.8804, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.4397, y: 28.6969, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 74.1384, y: 28.5075, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.7806, y: 28.3273, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.4167, y: 28.1565, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 73.0448, y: 27.9969, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.718, y: 27.7677, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 72.3499, y: 27.6015, scorepercent: ['66.67%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.9598, y: 27.4553, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.5633, y: 27.3404, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 71.1736, y: 27.2314, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.7837, y: 27.1206, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 70.3751, y: 26.9933, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.9489, y: 26.86, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.5373, y: 26.7258, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 69.1489, y: 26.567, scorepercent: ['36.36%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.7067, y: 26.4692, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 68.2478, y: 26.3685, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.7643, y: 26.2911, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 67.2766, y: 26.2192, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.7807, y: 26.1465, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 66.2597, y: 26.123, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.7784, y: 26.0336, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 65.3045, y: 25.9324, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.82, y: 25.8181, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 64.3242, y: 25.7109, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.8072, y: 25.6233, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 63.3158, y: 25.5306, scorepercent: ['50%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.8036, y: 25.4974, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 62.3322, y: 25.4186, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.8484, y: 25.3637, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 61.4072, y: 25.266, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.9548, y: 25.1931, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 60.4848, y: 25.1375, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.9984, y: 25.128, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.5428, y: 25.1259, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.0745, y: 25.1063, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.5996, y: 25.1055, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.1192, y: 25.1264, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.6459, y: 25.1627, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.1762, y: 25.2073, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.7241, y: 25.246, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.2421, y: 25.3214, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.7833, y: 25.3584, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.2872, y: 25.4546, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.7783, y: 25.572, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.2682, y: 25.696, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.7645, y: 25.8091, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.2866, y: 25.8992, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.8249, y: 25.949, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.3311, y: 26.0048, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.8486, y: 26.0933, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.366, y: 26.1817, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.8835, y: 26.2702, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.401, y: 26.3587, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.9185, y: 26.4471, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.436, y: 26.5356, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.9619, y: 26.6245, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.4962, y: 26.714, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.039, y: 26.8039, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.5902, y: 26.8942, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.1498, y: 26.9851, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.7178, y: 27.0764, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.2942, y: 27.1683, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.8791, y: 27.2605, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.4724, y: 27.3533, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.0741, y: 27.4465, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.6888, y: 27.544, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.3164, y: 27.6457, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.957, y: 27.7516, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.6105, y: 27.8617, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.277, y: 27.9761, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.948, y: 28.0941, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.611, y: 28.2079, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.2766, y: 28.3207, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.943, y: 28.4303, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.6138, y: 28.5345, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.2719, y: 28.6402, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.9217, y: 28.7418, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.5648, y: 28.8241, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.2088, y: 28.9046, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.8655, y: 28.9324, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.5104, y: 29.005, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.1534, y: 29.0649, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.7864, y: 29.0903, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.4124, y: 29.1198, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.0366, y: 29.134, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.6458, y: 29.1437, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.2704, y: 29.1293, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.8935, y: 29.1124, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.52, y: 29.106, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.1482, y: 29.1189, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.7815, y: 29.1411, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.4206, y: 29.1752, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.0766, y: 29.2142, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.7114, y: 29.2633, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.3769, y: 29.3493, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.0385, y: 29.3829, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.6594, y: 29.4328, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.2479, y: 29.521, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.8509, y: 29.6031, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.4918, y: 29.6815, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.1281, y: 29.783, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.7638, y: 29.9134, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.4018, y: 29.9863, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.0311, y: 30.0394, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.6425, y: 30.0549, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.2849, y: 30.0849, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.9436, y: 30.1222, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.5852, y: 30.1766, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.2442, y: 30.2228, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.86, y: 30.2692, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.4839, y: 30.3182, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.1518, y: 30.365, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.8541, y: 30.4081, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.5601, y: 30.4382, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.2317, y: 30.4824, scorepercent: ['N/A'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9231, y: 30.5022, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.6317, y: 30.477, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.3111, y: 30.4606, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.9834, y: 30.4594, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.6512, y: 30.4313, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.3132, y: 30.372, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9782, y: 30.3, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.687, y: 30.2468, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.4144, y: 30.1969, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.1719, y: 30.1935, scorepercent: ['100%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.9389, y: 30.2278, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.7141, y: 30.2506, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.5079, y: 30.2676, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.2928, y: 30.2981, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.0879, y: 30.3132, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.8965, y: 30.3167, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.7039, y: 30.3527, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.5536, y: 30.4278, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.4348, y: 30.4943, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.3522, y: 30.6018, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.2691, y: 30.7056, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.1817, y: 30.793, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.0787, y: 30.8497, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.9821, y: 30.8858, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.8736, y: 30.8718, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.7745, y: 30.803, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.6792, y: 30.7275, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.5864, y: 30.6342, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.5022, y: 30.5212, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.4199, y: 30.4134, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.3408, y: 30.3083, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.2618, y: 30.209, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.1841, y: 30.1124, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.1048, y: 30.0078, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.0176, y: 29.9116, scorepercent: ['20%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.9259, y: 29.8208, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.8331, y: 29.7372, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.7336, y: 29.6599, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.5843, y: 29.6356, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.473, y: 29.6035, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3938, y: 29.6668, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.3085, y: 29.7511, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2094, y: 29.8389, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.1218, y: 29.8912, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.011, y: 29.9223, scorepercent: ['33.33%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.9223, y: 30.0088, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.8263, y: 30.0994, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.7219, y: 30.197, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.6104, y: 30.3065, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.5036, y: 30.4189, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.3778, y: 30.5384, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.2066, y: 30.6554, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.0917, y: 30.7696, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.0124, y: 30.8371, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.8847, y: 30.9243, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.7186, y: 30.9309, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.5378, y: 30.9214, scorepercent: ['0%'], name: ['F.Ezeli'], jersey: [' #31'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }] }, { sequence: [{ x: 14.078, y: 20.3454, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.1439, y: 20.3689, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.2071, y: 20.395, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.2654, y: 20.4194, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.3228, y: 20.4415, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.3736, y: 20.3854, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.4255, y: 20.3726, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.4712, y: 20.3071, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.5214, y: 20.2923, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.574, y: 20.2701, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.6212, y: 20.2486, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.6759, y: 20.2261, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.7348, y: 20.2076, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.7957, y: 20.1747, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.859, y: 20.1472, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.9211, y: 20.1248, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.9791, y: 20.1176, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.0714, y: 20.1312, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.1568, y: 20.1485, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.2414, y: 20.1713, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.3305, y: 20.2169, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.3946, y: 20.2274, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.4517, y: 20.241, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5012, y: 20.2547, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5103, y: 20.2265, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.556, y: 20.23, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5521, y: 20.2123, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5451, y: 20.1746, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5219, y: 20.1785, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.4907, y: 20.1749, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.4548, y: 20.1736, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.413, y: 20.1521, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.326, y: 20.1281, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.2733, y: 20.1717, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.2027, y: 20.221, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.1351, y: 20.2708, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.0452, y: 20.3401, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.948, y: 20.4343, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.8413, y: 20.5453, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.7672, y: 20.6655, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.6497, y: 20.7601, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.5534, y: 20.8864, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.441, y: 21.0411, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.3331, y: 21.1753, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.2189, y: 21.3248, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.0993, y: 21.4793, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.9679, y: 21.6496, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.829, y: 21.8114, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.6519, y: 21.9149, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.4772, y: 22.0203, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.281, y: 22.1308, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.1159, y: 22.2766, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.9459, y: 22.4229, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.7673, y: 22.5548, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.5821, y: 22.7289, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.394, y: 22.9243, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.2098, y: 23.0881, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.0274, y: 23.2396, scorepercent: ['14.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.8393, y: 23.4001, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.6432, y: 23.5609, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.4403, y: 23.6837, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.2417, y: 23.7941, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.0447, y: 23.9037, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8426, y: 23.9985, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.6328, y: 24.096, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.4765, y: 24.1859, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.3721, y: 24.2611, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.2608, y: 24.3128, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.148, y: 24.3677, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.0263, y: 24.4076, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.8948, y: 24.4184, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.753, y: 24.4496, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.5983, y: 24.4818, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.4359, y: 24.5032, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.2684, y: 24.5153, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.0962, y: 24.5598, scorepercent: ['15%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.9135, y: 24.6093, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.6566, y: 24.6839, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.3257, y: 24.7917, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 7.987, y: 24.9055, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 7.5791, y: 25.0038, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 7.1213, y: 25.1155, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 6.6566, y: 25.228, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 6.193, y: 25.3461, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 5.7321, y: 25.4715, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 5.2686, y: 25.6032, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 4.8095, y: 25.7419, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 4.3563, y: 25.8881, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 3.908, y: 26.0421, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 3.4638, y: 26.1987, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 3.0274, y: 26.3618, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 2.5493, y: 26.489, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 2.1416, y: 26.596, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.85, y: 26.6776, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.5793, y: 26.7385, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.3323, y: 26.8098, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.0903, y: 26.858, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.8717, y: 26.904, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.6755, y: 26.9345, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.5006, y: 26.9528, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.334, y: 26.951, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.1818, y: 26.9421, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.044, y: 26.9179, scorepercent: ['55.93%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.067, y: 26.8948, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.1682, y: 26.8536, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.2545, y: 26.8072, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.2718, y: 26.8024, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.2516, y: 26.7892, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.2584, y: 26.7737, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.2473, y: 26.7507, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.222, y: 26.7219, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.1764, y: 26.6884, scorepercent: ['45.17%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.1114, y: 26.6446, scorepercent: ['56.98%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: -0.0353, y: 26.5995, scorepercent: ['56.98%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.0466, y: 26.5142, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.1603, y: 26.4266, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.2904, y: 26.3368, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.4485, y: 26.2471, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.6355, y: 26.2002, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 0.8479, y: 26.1693, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.0918, y: 26.1382, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.337, y: 26.0892, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.5842, y: 26.0346, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 1.8804, y: 25.9937, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 2.1996, y: 25.9802, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 2.5427, y: 25.9624, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 2.9006, y: 25.9651, scorepercent: ['61.92%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 3.2684, y: 25.9755, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 3.6549, y: 26.0081, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 4.0593, y: 26.0824, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 4.5054, y: 26.2095, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 4.9353, y: 26.2919, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 5.3831, y: 26.4235, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 5.8238, y: 26.4968, scorepercent: ['62.3%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 6.2899, y: 26.5693, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 6.737, y: 26.6022, scorepercent: ['55.45%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 7.2222, y: 26.6861, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 7.7203, y: 26.7774, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.2094, y: 26.8642, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 8.6935, y: 26.9443, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.1741, y: 27.0412, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 9.6691, y: 27.1201, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.1517, y: 27.1503, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.6363, y: 27.172, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.1376, y: 27.2078, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.6133, y: 27.2063, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.1224, y: 27.2487, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.6498, y: 27.291, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.149, y: 27.2921, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.6455, y: 27.2884, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.185, y: 27.3616, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.7095, y: 27.3787, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.212, y: 27.3411, scorepercent: ['31.58%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.7345, y: 27.3454, scorepercent: ['31.58%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.2684, y: 27.3492, scorepercent: ['31.58%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.7934, y: 27.3115, scorepercent: ['31.58%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.2685, y: 27.2046, scorepercent: ['31.58%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.7686, y: 27.1478, scorepercent: ['31.58%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.2792, y: 27.1, scorepercent: ['20%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.7872, y: 27.0389, scorepercent: ['20%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.2686, y: 26.9603, scorepercent: ['20%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.7522, y: 26.8788, scorepercent: ['20%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2248, y: 26.7607, scorepercent: ['20%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.7397, y: 26.7018, scorepercent: ['20%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.2619, y: 26.6662, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.757, y: 26.5829, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.2429, y: 26.4955, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.7585, y: 26.462, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.2629, y: 26.392, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.7973, y: 26.3575, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.379, y: 26.3993, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9984, y: 26.4987, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.6112, y: 26.5896, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.2604, y: 26.6865, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.8732, y: 26.7867, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.4945, y: 26.8592, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.1272, y: 26.9466, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.7639, y: 27.0622, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.3767, y: 27.1536, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.9517, y: 27.1577, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.5599, y: 27.2233, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.1463, y: 27.2596, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.7345, y: 27.3024, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.3308, y: 27.3237, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.8888, y: 27.2848, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.4135, y: 27.2057, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.934, y: 27.1269, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.4613, y: 27.0429, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.941, y: 26.9411, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.4538, y: 26.8285, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.9905, y: 26.7517, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.5197, y: 26.6557, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.0305, y: 26.5167, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.5562, y: 26.3803, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.1095, y: 26.3031, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.637, y: 26.1636, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.2032, y: 26.0646, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.7644, y: 25.949, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.3076, y: 25.8304, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.8558, y: 25.7187, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.4085, y: 25.5997, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.9757, y: 25.498, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.5459, y: 25.4084, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.1115, y: 25.3027, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.6679, y: 25.1907, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.2154, y: 25.0722, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.7537, y: 24.9473, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.283, y: 24.816, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.807, y: 24.6758, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.324, y: 24.5423, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.8353, y: 24.3904, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.3408, y: 24.22, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.8336, y: 24.0496, scorepercent: ['27.27%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.3302, y: 23.8975, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.8171, y: 23.7451, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.2905, y: 23.5974, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.7507, y: 23.4418, scorepercent: ['30.77%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.1999, y: 23.275, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.6502, y: 23.1091, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.1015, y: 22.9444, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.554, y: 22.7806, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.0075, y: 22.6179, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.4546, y: 22.4963, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.9023, y: 22.3777, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.3331, y: 22.2618, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.7489, y: 22.157, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.1481, y: 22.0635, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.5458, y: 21.9697, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.922, y: 21.8584, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.2897, y: 21.7478, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.6613, y: 21.6241, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.0292, y: 21.5051, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.383, y: 21.4016, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.7236, y: 21.3134, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.0478, y: 21.2306, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.3527, y: 21.1568, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.63, y: 21.0964, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.8912, y: 21.01, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.1213, y: 20.94, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.3383, y: 20.8725, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.5786, y: 20.7898, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.7599, y: 20.7523, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.9162, y: 20.7279, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.0523, y: 20.7125, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.1661, y: 20.7082, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.2467, y: 20.7234, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.3007, y: 20.7458, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.3311, y: 20.7705, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.3389, y: 20.7973, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.3269, y: 20.8346, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.2982, y: 20.8724, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.2504, y: 20.9084, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.1796, y: 20.942, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 59.0901, y: 20.9713, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.9826, y: 20.9949, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.818, y: 21.0473, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.6801, y: 21.0681, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.5267, y: 21.0821, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.3568, y: 21.0928, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 58.1727, y: 21.098, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.9764, y: 21.0985, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.7663, y: 21.0954, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.5471, y: 21.086, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.3171, y: 21.0709, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 57.0765, y: 21.0514, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.8253, y: 21.0342, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.5742, y: 21.017, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.323, y: 20.9997, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 56.0718, y: 20.9824, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.8206, y: 20.9652, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.5694, y: 20.9479, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.3182, y: 20.9307, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 55.067, y: 20.9135, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.8158, y: 20.8962, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.5646, y: 20.8789, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.3135, y: 20.8617, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 54.0623, y: 20.8444, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.8111, y: 20.8272, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.5599, y: 20.81, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.3087, y: 20.7927, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 53.0575, y: 20.7755, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.8063, y: 20.7582, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.5551, y: 20.741, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.3039, y: 20.7237, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 52.0528, y: 20.7065, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.8016, y: 20.6892, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.5504, y: 20.672, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.2992, y: 20.6547, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 51.048, y: 20.6375, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.7968, y: 20.6202, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.5456, y: 20.603, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.2944, y: 20.5857, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 50.0432, y: 20.5685, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.7921, y: 20.5512, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.5409, y: 20.534, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.2897, y: 20.5167, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 49.0385, y: 20.4995, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.7873, y: 20.4822, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.5361, y: 20.465, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.2849, y: 20.4477, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 48.0337, y: 20.4305, scorepercent: ['38.1%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.7825, y: 20.4132, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.5314, y: 20.396, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.2802, y: 20.3787, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 47.029, y: 20.3615, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.7778, y: 20.3442, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.5266, y: 20.327, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.2754, y: 20.3097, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 46.0242, y: 20.2925, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.773, y: 20.2752, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.5218, y: 20.258, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.2707, y: 20.2407, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 45.0195, y: 20.2235, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.7683, y: 20.2062, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.5171, y: 20.189, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.2659, y: 20.1717, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 44.0147, y: 20.1545, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.7635, y: 20.1372, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.5123, y: 20.12, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.2612, y: 20.1027, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 43.01, y: 20.0855, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.7588, y: 20.0682, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.5076, y: 20.051, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.2564, y: 20.0337, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 42.0052, y: 20.0165, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.754, y: 19.9992, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.5028, y: 19.982, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.2516, y: 19.9647, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 41.0005, y: 19.9475, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.7493, y: 19.9302, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.4981, y: 19.913, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 40.2469, y: 19.8957, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.9957, y: 19.8785, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.7445, y: 19.8612, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.4933, y: 19.844, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 39.2421, y: 19.8267, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.9909, y: 19.8095, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.7398, y: 19.7922, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.4886, y: 19.775, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 38.2374, y: 19.7577, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.9862, y: 19.7405, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.735, y: 19.7232, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.4838, y: 19.706, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 37.2326, y: 19.6887, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.9814, y: 19.6715, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.7302, y: 19.6542, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.4791, y: 19.637, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 36.2279, y: 19.6197, scorepercent: ['25%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.9767, y: 19.6025, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.7255, y: 19.5852, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.4743, y: 19.568, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 35.209, y: 19.5462, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.94, y: 19.5222, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.6585, y: 19.4943, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.37, y: 19.4691, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 34.072, y: 19.4467, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.7644, y: 19.4229, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.446, y: 19.4017, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 33.1143, y: 19.3696, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.7772, y: 19.3399, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.4328, y: 19.3048, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 32.0765, y: 19.2715, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.7109, y: 19.2325, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 31.3318, y: 19.1887, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.9445, y: 19.1451, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.5518, y: 19.0966, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 30.161, y: 19.0504, scorepercent: ['100%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.7632, y: 18.9999, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 29.3632, y: 18.9523, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.9613, y: 18.8972, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.5601, y: 18.841, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 28.1594, y: 18.7898, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.7642, y: 18.7358, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 27.3725, y: 18.6919, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.9787, y: 18.6542, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.5828, y: 18.625, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 26.194, y: 18.5967, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.7867, y: 18.5052, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 25.3848, y: 18.4205, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.9902, y: 18.3425, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.597, y: 18.2699, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 24.2287, y: 18.1951, scorepercent: ['N/A'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.8653, y: 18.144, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.5178, y: 18.1086, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 23.1732, y: 18.1102, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.8683, y: 18.1224, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.5193, y: 18.1367, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 22.1453, y: 18.1959, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.8024, y: 18.3059, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.4584, y: 18.4204, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 21.1336, y: 18.5627, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.8102, y: 18.6741, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.5065, y: 18.8817, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 20.2331, y: 19.1519, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.9487, y: 19.4151, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.6625, y: 19.7011, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.3595, y: 20.0116, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 19.06, y: 20.3306, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.7539, y: 20.6569, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.476, y: 20.9738, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 18.1914, y: 21.2956, scorepercent: ['0%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.9347, y: 21.64, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.7079, y: 21.9624, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.4567, y: 22.2629, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 17.2103, y: 22.5716, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.9448, y: 22.872, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.6787, y: 23.2282, scorepercent: ['26.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.4156, y: 23.5826, scorepercent: ['34.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 16.1215, y: 23.8668, scorepercent: ['34.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.8518, y: 24.1912, scorepercent: ['34.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.5895, y: 24.5122, scorepercent: ['34.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.317, y: 24.8037, scorepercent: ['34.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 15.0409, y: 25.1005, scorepercent: ['34.29%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.7818, y: 25.4293, scorepercent: ['27.78%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.5039, y: 25.7575, scorepercent: ['27.78%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 14.2068, y: 26.0882, scorepercent: ['27.78%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.9461, y: 26.4208, scorepercent: ['27.78%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.6819, y: 26.7045, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.4345, y: 26.9974, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 13.2042, y: 27.3439, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.979, y: 27.6489, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.7638, y: 27.9808, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.5632, y: 28.3071, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.3841, y: 28.6579, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.2174, y: 28.9504, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 12.0645, y: 29.243, scorepercent: ['66.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.9179, y: 29.5589, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.7915, y: 29.8625, scorepercent: ['10%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.6627, y: 30.1469, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.5398, y: 30.4257, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.4228, y: 30.7089, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.317, y: 31.0421, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.2098, y: 31.3819, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 11.0993, y: 31.7048, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.9795, y: 31.9776, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8932, y: 32.3166, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.824, y: 32.6144, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7579, y: 32.9042, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7026, y: 33.191, scorepercent: ['16.67%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.6473, y: 33.5071, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5947, y: 33.8148, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5922, y: 34.1084, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5727, y: 34.383, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5695, y: 34.6415, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5944, y: 34.915, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.6178, y: 35.1694, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.5923, y: 35.3268, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.6309, y: 35.5455, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.6683, y: 35.7508, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7221, y: 35.953, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7597, y: 36.1226, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.7958, y: 36.3021, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.8758, y: 36.4441, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }, { x: 10.9368, y: 36.5746, scorepercent: ['33.33%'], name: ['D.Green'], jersey: [' #23'], team: ['GSW'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['blue'] }] }, { sequence: [{ x: 19.6767, y: 14.2571, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.663, y: 14.1354, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.638, y: 14.0397, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.6024, y: 13.9552, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5793, y: 13.8799, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5576, y: 13.8097, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.549, y: 13.7452, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5416, y: 13.7052, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5416, y: 13.686, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5323, y: 13.7154, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5252, y: 13.7617, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.4967, y: 13.8315, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.4527, y: 13.8437, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.42, y: 13.9046, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3601, y: 14.0073, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3273, y: 14.1098, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3178, y: 14.1892, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3187, y: 14.2611, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3384, y: 14.3408, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3546, y: 14.4413, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.385, y: 14.5445, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.4183, y: 14.635, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.4595, y: 14.713, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5025, y: 14.7716, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.5629, y: 14.8266, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.6381, y: 14.8714, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.7529, y: 14.8891, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.8531, y: 14.8888, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.9618, y: 14.8758, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.1124, y: 14.835, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.2372, y: 14.7873, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.3544, y: 14.7967, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.4695, y: 14.7667, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.5823, y: 14.7258, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.7023, y: 14.6749, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.8164, y: 14.6148, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.9302, y: 14.5549, scorepercent: ['64.29%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.0466, y: 14.4851, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.1692, y: 14.4116, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.2982, y: 14.3323, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.4238, y: 14.2494, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.5397, y: 14.1691, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.679, y: 14.1308, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.8177, y: 14.0908, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.9546, y: 14.0435, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1051, y: 13.996, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2739, y: 13.92, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.4512, y: 13.8916, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.6312, y: 13.8731, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.8045, y: 13.86, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.9822, y: 13.8512, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.167, y: 13.8487, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.3575, y: 13.8714, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.539, y: 13.8713, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.7172, y: 13.8847, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.9154, y: 13.9539, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.1147, y: 14.0252, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.3099, y: 14.0835, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.5109, y: 14.1605, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.7198, y: 14.2852, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.9323, y: 14.4235, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.1463, y: 14.5596, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.3601, y: 14.6927, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.586, y: 14.8317, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.8119, y: 14.9262, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.0489, y: 15.0313, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.2856, y: 15.1439, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.5287, y: 15.2511, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.7857, y: 15.384, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.0429, y: 15.4954, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.2967, y: 15.6173, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5455, y: 15.7348, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.8016, y: 15.8524, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0623, y: 15.957, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.305, y: 15.9591, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.5928, y: 15.9485, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.8911, y: 15.9863, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.1857, y: 16.0188, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.4806, y: 16.0492, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.8103, y: 16.1479, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.0941, y: 16.2055, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.3811, y: 16.2537, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.6699, y: 16.2956, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.9592, y: 16.3273, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.2636, y: 16.3779, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.5632, y: 16.3689, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.8754, y: 16.3653, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.191, y: 16.3663, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.5182, y: 16.3781, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.8772, y: 16.4458, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.2085, y: 16.5246, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.5362, y: 16.5583, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.8879, y: 16.6026, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.2414, y: 16.6468, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.5733, y: 16.6746, scorepercent: ['20%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.9566, y: 16.7401, scorepercent: ['20%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.3505, y: 16.8086, scorepercent: ['20%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.7518, y: 16.8744, scorepercent: ['20%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.1602, y: 16.954, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.5778, y: 17.0337, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.0026, y: 17.1152, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.4392, y: 17.1965, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.8819, y: 17.2669, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.3241, y: 17.3345, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.7556, y: 17.3984, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.1974, y: 17.4758, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.6465, y: 17.552, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.0909, y: 17.6237, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.5437, y: 17.7005, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.0036, y: 17.7728, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.4667, y: 17.85, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.9249, y: 17.9323, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.3841, y: 18.0164, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.8423, y: 18.1097, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.2981, y: 18.2064, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.7477, y: 18.3091, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.1927, y: 18.4151, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.6363, y: 18.5309, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.0797, y: 18.6443, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.5316, y: 18.7616, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.9724, y: 18.8727, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.4186, y: 18.9934, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.8601, y: 19.1115, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.2914, y: 19.226, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.7196, y: 19.344, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.1373, y: 19.4527, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.5621, y: 19.5614, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.9811, y: 19.6745, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.3993, y: 19.7849, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.8145, y: 19.8972, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.23, y: 20.0067, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.6481, y: 20.0975, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.0679, y: 20.2078, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.4847, y: 20.3221, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.8984, y: 20.4384, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.3111, y: 20.553, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.7122, y: 20.6638, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.1166, y: 20.7748, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.5251, y: 20.8962, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.9268, y: 21.0201, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.3361, y: 21.1572, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.7414, y: 21.2892, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.1526, y: 21.4203, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.566, y: 21.5486, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.9754, y: 21.6817, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.3823, y: 21.8248, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.7755, y: 21.9959, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.1634, y: 22.1517, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.5477, y: 22.3151, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.9261, y: 22.4815, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.3055, y: 22.6505, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.6809, y: 22.8222, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.0568, y: 22.9926, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.4189, y: 23.1728, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.7807, y: 23.3534, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.1337, y: 23.533, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.4873, y: 23.7018, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.83, y: 23.8772, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.1653, y: 24.0618, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.495, y: 24.2368, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.8107, y: 24.4118, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.102, y: 24.6189, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.3826, y: 24.814, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.6556, y: 25.0054, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.9147, y: 25.2062, scorepercent: ['11.11%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.1604, y: 25.4148, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.4289, y: 25.5623, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.6476, y: 25.7773, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.8903, y: 25.9193, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.1125, y: 26.0843, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.3247, y: 26.2533, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.5185, y: 26.4381, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.7015, y: 26.6145, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.8702, y: 26.7871, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.0327, y: 26.9523, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.1912, y: 27.098, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.3534, y: 27.212, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.5263, y: 27.3036, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.6917, y: 27.4005, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.8487, y: 27.4807, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.993, y: 27.551, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.0831, y: 27.709, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.2285, y: 27.748, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.3379, y: 27.8204, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.454, y: 27.8636, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.5768, y: 27.9022, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.6956, y: 27.9387, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.8217, y: 27.9735, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.9481, y: 27.9953, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.069, y: 28.0292, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.1836, y: 28.0634, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.3117, y: 28.0911, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.4322, y: 28.1359, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.5447, y: 28.1717, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.6599, y: 28.1974, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.7808, y: 28.2152, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.9157, y: 28.1805, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.015, y: 28.2628, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.1316, y: 28.3655, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.2579, y: 28.4708, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.3852, y: 28.5665, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.5227, y: 28.6622, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.6572, y: 28.761, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.8042, y: 28.8649, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.9503, y: 28.9633, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.1139, y: 29.0608, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.2785, y: 29.2077, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.4355, y: 29.3472, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.6172, y: 29.4253, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.8123, y: 29.5033, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.0179, y: 29.5842, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.2285, y: 29.7255, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.4727, y: 29.7486, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.7106, y: 29.8169, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.9466, y: 29.8796, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.1834, y: 29.9555, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.42, y: 29.9701, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.6615, y: 29.9894, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.8985, y: 30.0532, scorepercent: ['47.62%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.1503, y: 30.0644, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.404, y: 30.0817, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.6608, y: 30.0411, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.9221, y: 30.018, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.1771, y: 30.0551, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.4289, y: 30.0962, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.6927, y: 30.095, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.9626, y: 30.0554, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.1922, y: 30.1117, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.4454, y: 30.1044, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.6822, y: 30.1539, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.8958, y: 30.2074, scorepercent: ['39.06%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.1331, y: 30.3058, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.3571, y: 30.413, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.6093, y: 30.4634, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.8597, y: 30.5431, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.1214, y: 30.6082, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.3666, y: 30.686, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.6122, y: 30.7679, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.853, y: 30.8431, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0936, y: 30.9237, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.3142, y: 31.0456, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.5369, y: 31.1636, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7993, y: 31.2342, scorepercent: ['54.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.0384, y: 31.318, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.3031, y: 31.4203, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.5571, y: 31.4717, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.7821, y: 31.5345, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.0157, y: 31.5746, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.2232, y: 31.6108, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.419, y: 31.6633, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.598, y: 31.7203, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.8385, y: 31.7848, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.0126, y: 31.813, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.1302, y: 31.7804, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.2298, y: 31.7192, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3195, y: 31.6495, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3959, y: 31.5622, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.4339, y: 31.4718, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.4512, y: 31.3631, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.4405, y: 31.1414, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.436, y: 30.9505, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.4358, y: 30.7645, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.4222, y: 30.5687, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3962, y: 30.3732, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3604, y: 30.1577, scorepercent: ['37.84%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.2942, y: 29.9579, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.1603, y: 29.7698, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.0556, y: 29.5328, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.022, y: 29.3564, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.9713, y: 29.1521, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.8931, y: 28.9906, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.857, y: 28.8304, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.8245, y: 28.6114, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7991, y: 28.4499, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7797, y: 28.3019, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7666, y: 28.1325, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7399, y: 27.9308, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7026, y: 27.7896, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.6347, y: 27.6635, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.5706, y: 27.5029, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.5129, y: 27.3204, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.4481, y: 27.0856, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.3851, y: 26.9159, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.2736, y: 26.7329, scorepercent: ['35.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.1704, y: 26.5777, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.0836, y: 26.3702, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.9182, y: 26.202, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.7423, y: 26.0803, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.5519, y: 25.9087, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.3875, y: 25.6833, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.203, y: 25.4754, scorepercent: ['48.57%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.9985, y: 25.2342, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7667, y: 24.971, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.5229, y: 24.7166, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.246, y: 24.5172, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.9537, y: 24.3169, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.6535, y: 24.1029, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.3458, y: 23.889, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.0346, y: 23.6303, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.6932, y: 23.4433, scorepercent: ['38.36%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.3318, y: 23.2685, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.9768, y: 23.0486, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.6038, y: 22.8202, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.2137, y: 22.5897, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.746, y: 22.4557, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.2531, y: 22.3477, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.7554, y: 22.2828, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.2617, y: 22.1772, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.7929, y: 22.0163, scorepercent: ['47.73%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.3319, y: 21.8284, scorepercent: ['47.73%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.8381, y: 21.6974, scorepercent: ['47.73%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.327, y: 21.586, scorepercent: ['47.73%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.81, y: 21.49, scorepercent: ['47.73%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.284, y: 21.4324, scorepercent: ['47.73%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.7523, y: 21.3131, scorepercent: ['42.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.2532, y: 21.1994, scorepercent: ['42.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.7154, y: 21.103, scorepercent: ['42.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.1933, y: 20.9726, scorepercent: ['42.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.6668, y: 20.8622, scorepercent: ['42.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.1304, y: 20.759, scorepercent: ['42.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.606, y: 20.6125, scorepercent: ['57.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.0699, y: 20.479, scorepercent: ['57.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.5238, y: 20.3515, scorepercent: ['57.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.9623, y: 20.2434, scorepercent: ['57.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.3857, y: 20.1362, scorepercent: ['57.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.8669, y: 19.9306, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.3354, y: 19.7444, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.7823, y: 19.5776, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.2318, y: 19.3877, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.6872, y: 19.2159, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.0999, y: 19.044, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.5348, y: 18.8615, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.952, y: 18.7198, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.3658, y: 18.5602, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.801, y: 18.3709, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.2395, y: 18.2061, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.67, y: 18.0372, scorepercent: ['33.33%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.1069, y: 17.8737, scorepercent: ['33.33%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.5346, y: 17.7294, scorepercent: ['33.33%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.9486, y: 17.5946, scorepercent: ['33.33%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.3197, y: 17.5148, scorepercent: ['33.33%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.6984, y: 17.4206, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.1001, y: 17.2994, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.4865, y: 17.2119, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.8841, y: 17.1166, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.2832, y: 17.0031, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.6849, y: 16.8987, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.077, y: 16.8126, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.4671, y: 16.729, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.8448, y: 16.6492, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.2196, y: 16.5633, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.602, y: 16.4813, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.98, y: 16.4084, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.3591, y: 16.3386, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.7469, y: 16.2847, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.1359, y: 16.2238, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.5201, y: 16.161, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.8928, y: 16.1089, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.2683, y: 16.0607, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.6315, y: 16.0172, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.9973, y: 15.9864, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.3704, y: 15.953, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.7458, y: 15.913, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.1218, y: 15.8683, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.503, y: 15.8282, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.882, y: 15.7791, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.2555, y: 15.7267, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.629, y: 15.6704, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.0007, y: 15.6256, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.3727, y: 15.601, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.7425, y: 15.5845, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.0943, y: 15.5744, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.4914, y: 15.6076, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.8982, y: 15.6662, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.3104, y: 15.7346, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.7213, y: 15.8217, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.131, y: 15.8739, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.5267, y: 15.937, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.9301, y: 16.0388, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.3517, y: 16.1604, scorepercent: ['0%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.7849, y: 16.3232, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.2307, y: 16.5149, scorepercent: ['N/A'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.6842, y: 16.7254, scorepercent: ['100%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.1423, y: 16.9476, scorepercent: ['100%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6178, y: 17.1741, scorepercent: ['100%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.117, y: 17.4298, scorepercent: ['100%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.6689, y: 17.7376, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.1965, y: 18.0166, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.7215, y: 18.2923, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.2546, y: 18.5674, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.7849, y: 18.8414, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.3156, y: 19.1717, scorepercent: ['66.67%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.8711, y: 19.5151, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.4468, y: 19.8596, scorepercent: ['50%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.0452, y: 20.213, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.6206, y: 20.5369, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1969, y: 20.8558, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.7792, y: 21.1827, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.3724, y: 21.53, scorepercent: ['53.85%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.9621, y: 21.8944, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.5024, y: 22.2298, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.0543, y: 22.5056, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.6, y: 22.7932, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.1662, y: 23.0995, scorepercent: ['37.14%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.7779, y: 23.4264, scorepercent: ['61.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.4156, y: 23.762, scorepercent: ['61.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.0737, y: 24.0898, scorepercent: ['61.9%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.7466, y: 24.4154, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.42, y: 24.7311, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.062, y: 25.0582, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.7665, y: 25.414, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.4764, y: 25.744, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.1986, y: 26.0688, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.9019, y: 26.3883, scorepercent: ['41.18%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.6202, y: 26.6832, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.3937, y: 26.999, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.0882, y: 27.2966, scorepercent: ['52.86%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.7905, y: 27.5339, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.5053, y: 27.7713, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.2017, y: 28.0516, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.9855, y: 28.34, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.7759, y: 28.6451, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.5736, y: 28.951, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.3855, y: 29.2797, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.1975, y: 29.5978, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.9621, y: 29.9244, scorepercent: ['38.1%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.7474, y: 30.2765, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.5453, y: 30.6376, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.3907, y: 30.9935, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.283, y: 31.2988, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.1958, y: 31.5986, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.1921, y: 31.9406, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.2096, y: 32.3007, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.2211, y: 32.6778, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.2309, y: 33.0101, scorepercent: ['51.92%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.1671, y: 33.346, scorepercent: ['32.31%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.1131, y: 33.6777, scorepercent: ['32.31%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.0591, y: 34.0206, scorepercent: ['32.31%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.9966, y: 34.3499, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.9649, y: 34.6773, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.953, y: 35.0433, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.942, y: 35.4249, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.9237, y: 35.7618, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.8956, y: 36.0947, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.8305, y: 36.5027, scorepercent: ['51.02%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.7541, y: 36.9196, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.6706, y: 37.3463, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.5902, y: 37.8064, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.5156, y: 38.2418, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.4438, y: 38.6788, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.3686, y: 39.1114, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.2903, y: 39.5551, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.2133, y: 39.9982, scorepercent: ['31.43%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.1375, y: 40.4269, scorepercent: ['53.49%'], name: ['L.Scola'], jersey: [' #4'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }] }, { sequence: [{ x: 36.9515, y: 23.1625, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9471, y: 23.1373, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9508, y: 23.1219, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9609, y: 23.1055, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9765, y: 23.0973, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9996, y: 23.0984, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.0374, y: 23.1162, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.0883, y: 23.1507, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.1168, y: 23.1747, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.1749, y: 23.2383, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.2323, y: 23.3024, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.2906, y: 23.3779, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.3446, y: 23.4539, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.394, y: 23.5309, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.4455, y: 23.6121, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.4967, y: 23.6961, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.5463, y: 23.7827, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.6002, y: 23.8636, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.6504, y: 23.9514, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.7106, y: 24.0323, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.771, y: 24.1135, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.8364, y: 24.1936, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.9052, y: 24.2667, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.9797, y: 24.3375, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.0635, y: 24.3995, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.1507, y: 24.4564, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.2472, y: 24.4998, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.3488, y: 24.5366, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.4588, y: 24.5708, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.5725, y: 24.5984, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.6941, y: 24.6249, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.824, y: 24.6484, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.9518, y: 24.6641, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.0873, y: 24.6768, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.2192, y: 24.6925, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.3573, y: 24.7059, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.493, y: 24.7154, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.629, y: 24.7274, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.7637, y: 24.7363, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.8977, y: 24.7462, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.0286, y: 24.7563, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.1591, y: 24.7733, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.2927, y: 24.7875, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.431, y: 24.8014, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.5764, y: 24.8112, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.7128, y: 24.8224, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.8562, y: 24.8344, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.9958, y: 24.8567, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.134, y: 24.8753, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.2768, y: 24.8892, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.4213, y: 24.903, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.5715, y: 24.9224, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.7256, y: 24.9414, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.883, y: 24.9607, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.0417, y: 24.9849, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.2035, y: 25.0059, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.3655, y: 25.0201, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.5256, y: 25.0334, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.6818, y: 25.0479, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.8327, y: 25.0642, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.9902, y: 25.075, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.1437, y: 25.0876, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.3004, y: 25.0935, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.4594, y: 25.1041, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.6157, y: 25.12, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.7722, y: 25.137, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.9279, y: 25.1482, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.0873, y: 25.1605, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.2457, y: 25.179, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.4011, y: 25.1961, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.5549, y: 25.2169, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.7111, y: 25.2469, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.8674, y: 25.2829, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.0229, y: 25.3239, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.1779, y: 25.3713, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.3332, y: 25.4279, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.484, y: 25.4866, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.6415, y: 25.5509, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.7955, y: 25.617, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.9496, y: 25.6807, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.1007, y: 25.7397, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.2514, y: 25.7988, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.4041, y: 25.8896, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.5612, y: 25.9664, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.7188, y: 26.0588, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.8761, y: 26.1512, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.0329, y: 26.2446, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.193, y: 26.3396, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.3494, y: 26.4363, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.5031, y: 26.5346, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.6544, y: 26.6264, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.8074, y: 26.7157, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.9482, y: 26.817, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.0887, y: 26.9135, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.222, y: 27.0149, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.3475, y: 27.1277, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.4735, y: 27.2348, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.59, y: 27.3154, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.7043, y: 27.4043, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.8164, y: 27.4805, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.9309, y: 27.5569, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.0367, y: 27.6278, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.1429, y: 27.7024, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.2549, y: 27.7755, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.3706, y: 27.8474, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.4753, y: 27.9266, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.5791, y: 28.0136, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.6887, y: 28.0896, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.785, y: 28.133, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.8865, y: 28.1782, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.9902, y: 28.2199, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.0978, y: 28.276, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.2008, y: 28.3342, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.312, y: 28.4006, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.453, y: 28.4629, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.5799, y: 28.5272, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.7232, y: 28.5941, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.876, y: 28.6502, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.0071, y: 28.7257, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.1341, y: 28.8073, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.2714, y: 28.8912, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.4083, y: 28.971, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.5567, y: 29.0589, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.7206, y: 29.1827, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.8866, y: 29.3045, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.0589, y: 29.4317, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.2262, y: 29.5634, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.4015, y: 29.6971, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.5674, y: 29.8322, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.7051, y: 29.9694, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.8514, y: 30.1148, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.9853, y: 30.2638, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.1042, y: 30.4259, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.2428, y: 30.5737, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.383, y: 30.7238, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.5307, y: 30.8712, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.6829, y: 31.0236, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.8347, y: 31.1773, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.9945, y: 31.3396, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.1565, y: 31.5058, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.3303, y: 31.6731, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.5035, y: 31.8392, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.6793, y: 31.9997, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.8599, y: 32.1594, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.041, y: 32.3206, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.2329, y: 32.4826, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.4244, y: 32.6443, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.6202, y: 32.8017, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.8233, y: 32.9593, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.0357, y: 33.1038, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.2459, y: 33.24, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.4578, y: 33.3749, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.6673, y: 33.5119, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.8819, y: 33.6541, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.1016, y: 33.799, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.3086, y: 33.9423, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.5296, y: 34.0346, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.7518, y: 34.1281, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.9758, y: 34.2148, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.2073, y: 34.3041, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.4367, y: 34.3877, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.6709, y: 34.4684, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.9139, y: 34.5586, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.1489, y: 34.6372, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.3864, y: 34.7304, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.6125, y: 34.874, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.8404, y: 35.0161, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.0705, y: 35.1525, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.2953, y: 35.2777, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.5206, y: 35.396, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.7509, y: 35.5119, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.9517, y: 35.7266, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.1463, y: 35.9385, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.3388, y: 36.1555, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.5259, y: 36.3648, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.7143, y: 36.5682, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.8965, y: 36.7718, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.0727, y: 36.9604, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.2351, y: 37.1471, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.4219, y: 37.2777, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.6179, y: 37.3646, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.8084, y: 37.448, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.9973, y: 37.5305, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.181, y: 37.6092, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.3549, y: 37.6887, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.5317, y: 37.7437, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.7032, y: 37.7848, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.8697, y: 37.8203, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.0369, y: 37.8463, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.1998, y: 37.873, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.3507, y: 37.9038, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.5141, y: 37.8794, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.6543, y: 37.9006, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.8167, y: 37.8837, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.9439, y: 37.9098, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.0715, y: 37.9303, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.1942, y: 37.955, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.3101, y: 37.9717, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.4112, y: 37.9941, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.5108, y: 38.0449, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.6109, y: 38.1242, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.7387, y: 38.1572, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.904, y: 38.1819, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.0899, y: 38.2017, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.2923, y: 38.2232, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.4871, y: 38.2567, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.7292, y: 38.3681, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.9957, y: 38.4693, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.2465, y: 38.6103, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.5174, y: 38.7439, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.7101, y: 38.8957, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.8279, y: 39.06, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.9464, y: 39.2595, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.0859, y: 39.4438, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.2455, y: 39.6321, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.3915, y: 39.8335, scorepercent: ['27.03%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.541, y: 40.0382, scorepercent: ['45.45%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.6548, y: 40.2657, scorepercent: ['45.45%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.7928, y: 40.5527, scorepercent: ['45.45%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.9204, y: 40.8468, scorepercent: ['45.45%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.0571, y: 41.1199, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.1493, y: 41.3745, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.2613, y: 41.6289, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.3889, y: 41.927, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.5061, y: 42.2749, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.7059, y: 42.6725, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.9734, y: 43, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.2452, y: 43.2853, scorepercent: ['34.74%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.5709, y: 43.5432, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.937, y: 43.7685, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.3028, y: 43.9769, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.6492, y: 44.197, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.9928, y: 44.4183, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.3191, y: 44.6307, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.5984, y: 44.879, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.8962, y: 45.1356, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.1634, y: 45.4412, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.4099, y: 45.7115, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.6615, y: 45.9299, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.9023, y: 46.0992, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.1634, y: 46.1992, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.4509, y: 46.3606, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.7581, y: 46.5419, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.0179, y: 46.7701, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.2345, y: 47.0031, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.4755, y: 47.2365, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.7356, y: 47.4578, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.0017, y: 47.6727, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.2441, y: 47.8529, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.5349, y: 47.9949, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.8152, y: 48.1338, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.1255, y: 48.218, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.44, y: 48.3009, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7423, y: 48.3964, scorepercent: ['37.5%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.0548, y: 48.5057, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.3514, y: 48.6121, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.6403, y: 48.7088, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.9215, y: 48.7858, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.1947, y: 48.8544, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.4587, y: 48.9107, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7121, y: 48.9566, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.9573, y: 49.0015, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.2026, y: 49.0377, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.4461, y: 49.0563, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.6883, y: 49.0591, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.9299, y: 49.0585, scorepercent: ['48.48%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.1569, y: 49.0502, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.3691, y: 49.0399, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.5788, y: 49.0186, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.7858, y: 48.9862, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.9912, y: 48.9457, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.1899, y: 48.8948, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.3745, y: 48.8425, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.5549, y: 48.7794, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.7289, y: 48.7139, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8911, y: 48.6451, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.0461, y: 48.5743, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.1977, y: 48.4964, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.3368, y: 48.4215, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.4681, y: 48.3475, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.5867, y: 48.2733, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.7052, y: 48.1995, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.8186, y: 48.1238, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.9222, y: 48.0527, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.0106, y: 47.9778, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.082, y: 47.9078, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.1388, y: 47.84, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.1836, y: 47.7738, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.2134, y: 47.7087, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.2303, y: 47.6386, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.2349, y: 47.567, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.2273, y: 47.4928, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.2057, y: 47.4221, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.1725, y: 47.3513, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.1209, y: 47.2826, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.0569, y: 47.2155, scorepercent: ['38.71%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.9718, y: 47.1527, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.8728, y: 47.093, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.7623, y: 47.038, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.6395, y: 46.9888, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.506, y: 46.9417, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.3619, y: 46.8975, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.205, y: 46.8531, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.0437, y: 46.8031, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8736, y: 46.754, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.6931, y: 46.7048, scorepercent: ['44.68%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.5051, y: 46.6557, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.2975, y: 46.6104, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.0778, y: 46.5653, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.8487, y: 46.5229, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.6028, y: 46.4822, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.3494, y: 46.4402, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.0882, y: 46.3918, scorepercent: ['31.25%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.8151, y: 46.3421, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.5286, y: 46.2901, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.253, y: 46.2396, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.939, y: 46.1843, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.6058, y: 46.1332, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.2524, y: 46.0918, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.883, y: 46.0479, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.5076, y: 46.0106, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.1138, y: 45.977, scorepercent: ['44.23%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7202, y: 45.944, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.3124, y: 45.9167, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.9118, y: 45.8418, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.4977, y: 45.8064, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.0757, y: 45.7628, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.6449, y: 45.73, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.2002, y: 45.694, scorepercent: ['37.35%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.7527, y: 45.6681, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.2753, y: 45.6383, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.8154, y: 45.6161, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.3546, y: 45.5975, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.8869, y: 45.5746, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.4193, y: 45.5601, scorepercent: ['36.36%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.9455, y: 45.5415, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.4718, y: 45.5141, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.9975, y: 45.4834, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.519, y: 45.4575, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.0174, y: 45.4655, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.5209, y: 45.4268, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.0101, y: 45.4612, scorepercent: ['14.29%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.4896, y: 45.4898, scorepercent: ['100%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.9756, y: 45.5168, scorepercent: ['100%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.4657, y: 45.4856, scorepercent: ['100%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.941, y: 45.4613, scorepercent: ['100%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.4142, y: 45.4441, scorepercent: ['100%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.8813, y: 45.4327, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.343, y: 45.4221, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.7935, y: 45.4151, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.2372, y: 45.4087, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.6741, y: 45.4097, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.094, y: 45.4142, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.511, y: 45.4101, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.9271, y: 45.4257, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.3402, y: 45.45, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.7516, y: 45.4121, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.1431, y: 45.3774, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.5253, y: 45.3513, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.8632, y: 45.3716, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.2025, y: 45.395, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.5356, y: 45.4116, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.8728, y: 45.4207, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.2123, y: 45.4281, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.5597, y: 45.4199, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.9074, y: 45.4136, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.2572, y: 45.4041, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.6142, y: 45.3889, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.9751, y: 45.3646, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.3323, y: 45.3391, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.6835, y: 45.3106, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.0385, y: 45.2824, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.4188, y: 45.2518, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.8039, y: 45.2195, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.2221, y: 45.193, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.6466, y: 45.1552, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.0788, y: 45.1136, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.5071, y: 45.0666, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.9372, y: 45.0161, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.3609, y: 44.9635, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.7849, y: 44.8969, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.2135, y: 44.8273, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.6474, y: 44.7569, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.0901, y: 44.704, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5444, y: 44.6431, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.0092, y: 44.5718, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.4848, y: 44.4866, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.9688, y: 44.3871, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.4637, y: 44.2824, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.9603, y: 44.1804, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.4585, y: 44.084, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.9683, y: 43.9801, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.4923, y: 43.8829, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.0308, y: 43.7958, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.5864, y: 43.7199, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.1581, y: 43.6564, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.7474, y: 43.5979, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.3532, y: 43.5385, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9741, y: 43.4628, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.6075, y: 43.3835, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.2554, y: 43.3058, scorepercent: ['N/A'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.9175, y: 43.2351, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.5891, y: 43.1743, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.2664, y: 43.1129, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.9561, y: 43.0518, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.6598, y: 42.9898, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.3734, y: 42.9333, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.1003, y: 42.8776, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.8332, y: 42.8156, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.574, y: 42.7554, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.3203, y: 42.7011, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.0732, y: 42.6482, scorepercent: ['33.33%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.8411, y: 42.5903, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.6161, y: 42.5925, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.4063, y: 42.5978, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.2136, y: 42.6099, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.0278, y: 42.6177, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.8467, y: 42.6228, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.6694, y: 42.6187, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.4975, y: 42.6147, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.3263, y: 42.5894, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.1679, y: 42.5717, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.0035, y: 42.5579, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.8334, y: 42.5532, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.6648, y: 42.5639, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.5036, y: 42.5754, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.3407, y: 42.5926, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.1702, y: 42.6223, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.002, y: 42.6027, scorepercent: ['50%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.8282, y: 42.5891, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.6506, y: 42.58, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.4781, y: 42.579, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.3117, y: 42.5879, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.1519, y: 42.6082, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.9975, y: 42.6166, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.8552, y: 42.6429, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.7046, y: 42.6644, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.5682, y: 42.681, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.4478, y: 42.6885, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.337, y: 42.6882, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.2294, y: 42.6843, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.1294, y: 42.6743, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0361, y: 42.6685, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.944, y: 42.6614, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.8549, y: 42.6524, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.7703, y: 42.6349, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6831, y: 42.6236, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5976, y: 42.6136, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5086, y: 42.6056, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.4195, y: 42.6056, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.3365, y: 42.6085, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.2616, y: 42.6105, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.1892, y: 42.612, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.119, y: 42.6098, scorepercent: ['0%'], name: ['K.Lowry'], jersey: [' #7'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }] }, { sequence: [{ x: 18.1704, y: 11.4837, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.8683, y: 11.5229, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.5833, y: 11.6066, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.2901, y: 11.6219, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.9876, y: 11.6782, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.6986, y: 11.7291, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.4098, y: 11.7636, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.1075, y: 11.7887, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.7979, y: 11.8289, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.5222, y: 11.8918, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.2693, y: 11.9607, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.0397, y: 12.009, scorepercent: ['34.25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.8101, y: 12.048, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.5864, y: 12.0788, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.3636, y: 12.0994, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.1244, y: 12.1251, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.8992, y: 12.1279, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.6542, y: 12.116, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.4483, y: 12.155, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.2282, y: 12.0962, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.0099, y: 12.0323, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.7899, y: 11.9604, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.5702, y: 11.8718, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.3595, y: 11.8104, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.1333, y: 11.7196, scorepercent: ['36.36%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.8944, y: 11.6074, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.654, y: 11.4703, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.4241, y: 11.3237, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.1955, y: 11.1643, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.967, y: 10.9983, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.7678, y: 10.8225, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.5769, y: 10.6604, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.3591, y: 10.5016, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.1418, y: 10.2931, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.9589, y: 10.1295, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.7606, y: 9.9071, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.5657, y: 9.727, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.3829, y: 9.5267, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.2248, y: 9.3384, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.0804, y: 9.1547, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.9527, y: 8.9755, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.8412, y: 8.8047, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.7415, y: 8.6365, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.6569, y: 8.4774, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.5935, y: 8.324, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.5522, y: 8.1765, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.5239, y: 8.0337, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.5109, y: 7.9003, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.511, y: 7.7767, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.4991, y: 7.7053, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.4966, y: 7.6317, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.5544, y: 7.5245, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.6323, y: 7.4499, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.6705, y: 7.3567, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.7663, y: 7.2471, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 8.8789, y: 7.1539, scorepercent: ['42.24%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.0166, y: 7.0629, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.1816, y: 6.9905, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.349, y: 6.9667, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.5144, y: 7.0006, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.6914, y: 7.0293, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 9.8622, y: 7.0201, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.0892, y: 7.0447, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.2909, y: 7.0501, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.5317, y: 7.0175, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 10.7824, y: 7.005, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.0048, y: 7, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.2348, y: 6.9918, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.513, y: 6.9365, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 11.773, y: 6.951, scorepercent: ['34.83%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.0348, y: 6.9529, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.2953, y: 6.9765, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.5853, y: 6.997, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 12.8341, y: 7.0019, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.0969, y: 6.9614, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.4056, y: 6.947, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 13.736, y: 6.977, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.0414, y: 7.0404, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.3907, y: 7.131, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.7259, y: 7.1909, scorepercent: ['36.92%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.0799, y: 7.3059, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.4454, y: 7.4396, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.8308, y: 7.6396, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.2314, y: 7.8576, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.6209, y: 8.0433, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.0084, y: 8.1914, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.4015, y: 8.3368, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.7633, y: 8.4708, scorepercent: ['40.54%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.1849, y: 8.584, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.6346, y: 8.7393, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.0545, y: 8.8913, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.4876, y: 9.0506, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.9636, y: 9.1786, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.446, y: 9.3126, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.9537, y: 9.4602, scorepercent: ['23.08%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.4303, y: 9.6178, scorepercent: ['30%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.9159, y: 9.777, scorepercent: ['30%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.3947, y: 9.8856, scorepercent: ['30%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.8722, y: 9.9913, scorepercent: ['30%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.3659, y: 10.0937, scorepercent: ['25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.881, y: 10.2424, scorepercent: ['25%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.4084, y: 10.3965, scorepercent: ['10%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.956, y: 10.5728, scorepercent: ['10%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.5166, y: 10.7448, scorepercent: ['10%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.0692, y: 10.8742, scorepercent: ['10%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.5886, y: 10.9565, scorepercent: ['10%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.1145, y: 11.0512, scorepercent: ['33.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6097, y: 11.1252, scorepercent: ['33.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.1555, y: 11.2098, scorepercent: ['33.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.7509, y: 11.3319, scorepercent: ['33.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.3575, y: 11.406, scorepercent: ['33.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.0079, y: 11.4931, scorepercent: ['100%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.6246, y: 11.5321, scorepercent: ['100%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.2507, y: 11.5766, scorepercent: ['100%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.9044, y: 11.6382, scorepercent: ['100%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.5701, y: 11.7049, scorepercent: ['100%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.238, y: 11.766, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.9038, y: 11.8133, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.577, y: 11.8642, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.27, y: 11.9241, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.9948, y: 12.0196, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.7133, y: 12.0879, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.4265, y: 12.139, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.1087, y: 12.1422, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.7615, y: 12.1282, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.4624, y: 12.1545, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.1202, y: 12.1569, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.8137, y: 12.1932, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.5089, y: 12.2151, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.1772, y: 12.2182, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.853, y: 12.2243, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.53, y: 12.2242, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.2126, y: 12.2279, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.8929, y: 12.2304, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.5517, y: 12.2202, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.2146, y: 12.1977, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.8885, y: 12.1984, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.5662, y: 12.1983, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.2332, y: 12.2222, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.899, y: 12.2405, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.5693, y: 12.2632, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.2409, y: 12.27, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.9178, y: 12.2825, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.599, y: 12.2936, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.2696, y: 12.3107, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.9336, y: 12.308, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.6022, y: 12.3071, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.2675, y: 12.3036, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.9481, y: 12.2725, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.6349, y: 12.2199, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.3071, y: 12.1924, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.9846, y: 12.1054, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.6723, y: 12.0279, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.3515, y: 11.9681, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.0274, y: 11.9002, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.7034, y: 11.8555, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.3917, y: 11.8601, scorepercent: ['28.57%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.0761, y: 11.8721, scorepercent: ['28.57%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.7657, y: 11.897, scorepercent: ['28.57%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.4534, y: 11.9641, scorepercent: ['28.57%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.1435, y: 12.0589, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.8274, y: 12.1758, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.5126, y: 12.3132, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.1739, y: 12.4911, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.8315, y: 12.7034, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.5053, y: 12.9162, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.2104, y: 13.1598, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.902, y: 13.4185, scorepercent: ['30.43%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.6035, y: 13.6616, scorepercent: ['30.43%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.298, y: 13.9284, scorepercent: ['35%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.9788, y: 14.2039, scorepercent: ['35%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.6535, y: 14.4584, scorepercent: ['35%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.3284, y: 14.7243, scorepercent: ['35%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.9985, y: 15.0004, scorepercent: ['35%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.6736, y: 15.2507, scorepercent: ['20%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.3344, y: 15.5095, scorepercent: ['20%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.9581, y: 15.7992, scorepercent: ['20%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.555, y: 16.0789, scorepercent: ['20%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.1501, y: 16.3504, scorepercent: ['35.48%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.7429, y: 16.622, scorepercent: ['35.48%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.3239, y: 16.9015, scorepercent: ['31.82%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.8507, y: 17.1983, scorepercent: ['31.82%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.367, y: 17.4936, scorepercent: ['31.82%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.8696, y: 17.8043, scorepercent: ['31.82%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.353, y: 18.1113, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.82, y: 18.3869, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.2642, y: 18.6583, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.6978, y: 18.9202, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.1064, y: 19.1761, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.5012, y: 19.4182, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.8729, y: 19.6423, scorepercent: ['36.07%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.2565, y: 19.817, scorepercent: ['45%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.6336, y: 19.9921, scorepercent: ['45%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.993, y: 20.1692, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.3338, y: 20.3375, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.659, y: 20.4824, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9631, y: 20.6228, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.2495, y: 20.752, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.5253, y: 20.8703, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.7929, y: 20.9801, scorepercent: ['38.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.0472, y: 21.0805, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.2883, y: 21.171, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.5139, y: 21.2502, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.7294, y: 21.3179, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.9311, y: 21.3728, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.1234, y: 21.4163, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.2991, y: 21.4511, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.4646, y: 21.472, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.6172, y: 21.4834, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.7491, y: 21.4963, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.8645, y: 21.5014, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.9732, y: 21.5017, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.073, y: 21.4993, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.1566, y: 21.4906, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.2254, y: 21.4861, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.2847, y: 21.4796, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.3324, y: 21.4771, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.3693, y: 21.4804, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.3949, y: 21.4936, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4147, y: 21.5164, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4332, y: 21.5508, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4444, y: 21.6033, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4514, y: 21.6719, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.46, y: 21.7489, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4684, y: 21.8241, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4789, y: 21.9086, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.487, y: 21.9987, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4951, y: 22.0852, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5026, y: 22.1666, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5164, y: 22.2377, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5255, y: 22.2986, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5355, y: 22.347, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5462, y: 22.3854, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5587, y: 22.4099, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5702, y: 22.4223, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.5839, y: 22.4232, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.6061, y: 22.4039, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.6338, y: 22.3666, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.6637, y: 22.3182, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.6991, y: 22.2567, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.7412, y: 22.1831, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.7913, y: 22.0939, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.8492, y: 21.9934, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.915, y: 21.8903, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.9876, y: 21.7796, scorepercent: ['51.16%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.0734, y: 21.6712, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.1615, y: 21.562, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.254, y: 21.4419, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.3476, y: 21.3177, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4415, y: 21.1873, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.5342, y: 21.0548, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.6224, y: 20.9221, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.7073, y: 20.7904, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.788, y: 20.6534, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.8615, y: 20.5252, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.9187, y: 20.404, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.9741, y: 20.2844, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0199, y: 20.1747, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0508, y: 20.0754, scorepercent: ['55.06%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0742, y: 19.9821, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.091, y: 19.8891, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0533, y: 19.7983, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0082, y: 19.7116, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.9756, y: 19.6482, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.9395, y: 19.5944, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.8966, y: 19.5488, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.8497, y: 19.5155, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.8032, y: 19.5038, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.7574, y: 19.5126, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.7409, y: 19.4895, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.7078, y: 19.5123, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.6731, y: 19.542, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.635, y: 19.5732, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.5847, y: 19.6034, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.5134, y: 19.6371, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4471, y: 19.6759, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.428, y: 19.7258, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4249, y: 19.7196, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4226, y: 19.7267, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4204, y: 19.7307, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4285, y: 19.7319, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4634, y: 19.7352, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.5019, y: 19.7192, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.5461, y: 19.6895, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.5675, y: 19.685, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.6196, y: 19.6284, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.6728, y: 19.5697, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.7327, y: 19.5091, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.8143, y: 19.4414, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.9182, y: 19.3687, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0166, y: 19.2922, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.1197, y: 19.2033, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.2088, y: 19.1712, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.282, y: 19.1039, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.3624, y: 19.0251, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.4362, y: 18.9392, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.4852, y: 18.8378, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.525, y: 18.7342, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.554, y: 18.6204, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5743, y: 18.5014, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5871, y: 18.3715, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5927, y: 18.234, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5926, y: 18.0851, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5824, y: 17.9319, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5607, y: 17.7711, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5319, y: 17.599, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.5111, y: 17.401, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.4713, y: 17.2189, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.4287, y: 17.0296, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.3725, y: 16.8416, scorepercent: ['44.44%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.308, y: 16.6394, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.2422, y: 16.4266, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.1702, y: 16.2033, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0948, y: 15.9764, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0163, y: 15.7525, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.9381, y: 15.5452, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.8342, y: 15.3273, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.7186, y: 15.1138, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.6067, y: 14.8956, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.4829, y: 14.6967, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.3352, y: 14.5128, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.1683, y: 14.3548, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.0064, y: 14.1788, scorepercent: ['34.78%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.8302, y: 14.0114, scorepercent: ['28.85%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.6463, y: 13.8476, scorepercent: ['28.85%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.4485, y: 13.6977, scorepercent: ['28.85%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.2388, y: 13.5559, scorepercent: ['28.85%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.0151, y: 13.4269, scorepercent: ['28.85%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.7793, y: 13.3071, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.5303, y: 13.1906, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.2774, y: 13.0152, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.0316, y: 12.8689, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.7701, y: 12.7755, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.4952, y: 12.6765, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.1813, y: 12.5953, scorepercent: ['39.02%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.8687, y: 12.5128, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.5856, y: 12.4022, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.2716, y: 12.3099, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9473, y: 12.2217, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.5666, y: 12.1892, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.21, y: 12.1253, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.8583, y: 12.0415, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.5131, y: 11.9509, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.1573, y: 11.866, scorepercent: ['44.59%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.802, y: 11.7887, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3743, y: 11.7937, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.9493, y: 11.784, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.5234, y: 11.7268, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.0561, y: 11.735, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.6135, y: 11.7151, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.1947, y: 11.6488, scorepercent: ['32.14%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7325, y: 11.6117, scorepercent: ['32.26%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.2605, y: 11.5862, scorepercent: ['32.26%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.7845, y: 11.5613, scorepercent: ['32.26%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.3473, y: 11.4911, scorepercent: ['32.26%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.8922, y: 11.4415, scorepercent: ['32.26%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.4178, y: 11.4186, scorepercent: ['32.26%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.9216, y: 11.4095, scorepercent: ['38.18%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.4163, y: 11.3986, scorepercent: ['38.18%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.8948, y: 11.3832, scorepercent: ['38.18%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.425, y: 11.3337, scorepercent: ['38.18%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.9108, y: 11.3256, scorepercent: ['38.18%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.3892, y: 11.3117, scorepercent: ['38.18%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.9023, y: 11.2742, scorepercent: ['29.03%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.4216, y: 11.1886, scorepercent: ['29.03%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.9126, y: 11.1467, scorepercent: ['29.03%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.3982, y: 11.1028, scorepercent: ['29.03%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.9045, y: 11.0387, scorepercent: ['29.03%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.4084, y: 10.9717, scorepercent: ['29.03%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.9214, y: 10.8558, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.4115, y: 10.8019, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.9034, y: 10.7455, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.3797, y: 10.6941, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.8631, y: 10.6411, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.3536, y: 10.5903, scorepercent: ['40%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.8407, y: 10.538, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.3625, y: 10.4459, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.8799, y: 10.3698, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.3775, y: 10.2691, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.8733, y: 10.2024, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.3735, y: 10.1316, scorepercent: ['8.33%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.8807, y: 10.0629, scorepercent: ['28.57%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.3884, y: 9.9884, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.8802, y: 9.9425, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.3591, y: 9.9491, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.841, y: 9.8987, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.3175, y: 9.8524, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.8191, y: 9.8005, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.3142, y: 9.731, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.8085, y: 9.6605, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.2974, y: 9.6017, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.7826, y: 9.5469, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.2901, y: 9.482, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.812, y: 9.4118, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.3323, y: 9.3523, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.8541, y: 9.2934, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.3697, y: 9.2346, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.8925, y: 9.1752, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.4351, y: 9.091, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.9816, y: 8.9833, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.5336, y: 8.8853, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.0901, y: 8.7898, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.6482, y: 8.6877, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.2246, y: 8.6051, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.7993, y: 8.527, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.3852, y: 8.4482, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.9719, y: 8.3741, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.5549, y: 8.2969, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.1441, y: 8.2278, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.7366, y: 8.1656, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.3296, y: 8.1069, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.9329, y: 8.0471, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.5442, y: 7.9957, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.164, y: 7.939, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.8103, y: 7.8878, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.4698, y: 7.833, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.1402, y: 7.7706, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.8236, y: 7.7004, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.5089, y: 7.6313, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.2056, y: 7.5497, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.8969, y: 7.4764, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.6017, y: 7.3964, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.3057, y: 7.3251, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.0062, y: 7.2588, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.7215, y: 7.2006, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.4404, y: 7.1382, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.1578, y: 7.0796, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.8783, y: 7.025, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.6091, y: 6.9823, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.3338, y: 6.9513, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.0498, y: 6.9242, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.7736, y: 6.9028, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.4957, y: 6.8925, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.2191, y: 6.8822, scorepercent: ['0%'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.9532, y: 6.8776, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.7044, y: 6.8646, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.4627, y: 6.8518, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.2433, y: 6.8279, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.0346, y: 6.7982, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.8232, y: 6.7629, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.6207, y: 6.7326, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.4217, y: 6.7013, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.2207, y: 6.6679, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.0147, y: 6.6262, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.811, y: 6.5853, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.6276, y: 6.544, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.4412, y: 6.5045, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.2619, y: 6.4628, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.0817, y: 6.425, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.9039, y: 6.3916, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.7284, y: 6.3635, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.5432, y: 6.3289, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.3417, y: 6.2981, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.142, y: 6.2667, scorepercent: ['N/A'], name: ['D.DeRozan'], jersey: [' #10'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }] }, { sequence: [{ x: 14.1159, y: 5.8146, scorepercent: ['42.86%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.5269, y: 5.8687, scorepercent: ['42.86%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 14.9436, y: 5.9719, scorepercent: ['42.86%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.3591, y: 6.0671, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 15.7551, y: 6.1261, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.1871, y: 6.2271, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.5969, y: 6.3522, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 16.994, y: 6.4367, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.3877, y: 6.4999, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.7871, y: 6.588, scorepercent: ['54.55%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.2103, y: 6.6931, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.5963, y: 6.8016, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.9785, y: 6.9084, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3193, y: 7.0081, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.6385, y: 7.1081, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.9426, y: 7.207, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.2361, y: 7.3097, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.5176, y: 7.4178, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.7784, y: 7.4919, scorepercent: ['36.36%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.0366, y: 7.6125, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.2793, y: 7.7258, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.4751, y: 7.8015, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.6658, y: 7.8788, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.8145, y: 7.9619, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.9289, y: 8.0169, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.0244, y: 8.0747, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1093, y: 8.1364, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1646, y: 8.188, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2078, y: 8.2399, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2355, y: 8.289, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2524, y: 8.3363, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2564, y: 8.3846, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.243, y: 8.4259, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2258, y: 8.4997, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1907, y: 8.5208, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1857, y: 8.5972, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2059, y: 8.6906, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2044, y: 8.7769, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1513, y: 8.8226, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.0895, y: 8.8635, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.0276, y: 8.9079, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.9657, y: 8.9439, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.9316, y: 8.9846, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.9598, y: 9.0443, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.0212, y: 9.0978, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1153, y: 9.144, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.2107, y: 9.1655, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.3773, y: 9.1906, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.5338, y: 9.2074, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.6865, y: 9.2031, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.7907, y: 9.1118, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.9378, y: 9.0307, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.117, y: 8.9506, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.3681, y: 8.9105, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.6718, y: 8.8709, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.9935, y: 8.808, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.3356, y: 8.7357, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.6889, y: 8.6555, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.0058, y: 8.5415, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.3234, y: 8.4269, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.6358, y: 8.3083, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.9646, y: 8.1959, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.2548, y: 8.0651, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.5892, y: 7.9333, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.9445, y: 7.8149, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.3376, y: 7.7313, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.7278, y: 7.6451, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.1139, y: 7.5536, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.5036, y: 7.4517, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.8715, y: 7.3378, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.2554, y: 7.2283, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.6526, y: 7.1267, scorepercent: ['60%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.0574, y: 7.0258, scorepercent: ['70%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.4636, y: 6.9384, scorepercent: ['70%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.8683, y: 6.8557, scorepercent: ['70%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.2827, y: 6.7806, scorepercent: ['70%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.7118, y: 6.7208, scorepercent: ['70%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.1423, y: 6.6669, scorepercent: ['70%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.57, y: 6.6195, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.9982, y: 6.5716, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.4239, y: 6.5382, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.8568, y: 6.5216, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.2962, y: 6.5231, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.7453, y: 6.5419, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.1917, y: 6.5695, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.6306, y: 6.6067, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.0635, y: 6.646, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.4933, y: 6.6898, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.9299, y: 6.7403, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.3657, y: 6.8049, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.7952, y: 6.8944, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.2094, y: 7.0023, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.6102, y: 7.133, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.0037, y: 7.2814, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.3858, y: 7.4495, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.752, y: 7.6235, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.1048, y: 7.7926, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.4383, y: 7.9699, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.7442, y: 8.1563, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.0387, y: 8.3591, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.3176, y: 8.5821, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.5734, y: 8.8205, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.8134, y: 9.079, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.0252, y: 9.3529, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.2174, y: 9.6323, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.3916, y: 9.9105, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.5575, y: 10.1834, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.7128, y: 10.4558, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.854, y: 10.7214, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.981, y: 10.9885, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.1001, y: 11.2469, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.1982, y: 11.5082, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.2835, y: 11.7634, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.3572, y: 12.0117, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.4222, y: 12.2433, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.4655, y: 12.4766, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5108, y: 12.7315, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5442, y: 12.9769, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5598, y: 13.1552, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5764, y: 13.3374, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5918, y: 13.5212, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5942, y: 13.6906, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.6045, y: 13.8519, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.6199, y: 14.0083, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.6525, y: 14.1555, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.6957, y: 14.3177, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.754, y: 14.4739, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.8343, y: 14.6255, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.9329, y: 14.7691, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.0418, y: 14.9197, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.1731, y: 15.0514, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.3124, y: 15.149, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.4704, y: 15.2415, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.6583, y: 15.3821, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.856, y: 15.505, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.0576, y: 15.6111, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.2794, y: 15.7125, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.5053, y: 15.8056, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.7422, y: 15.9023, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.9766, y: 15.9991, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.2212, y: 16.0886, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.472, y: 16.1746, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.7341, y: 16.259, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.0084, y: 16.3422, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.2937, y: 16.4209, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.5862, y: 16.4944, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.8828, y: 16.5637, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.1816, y: 16.6313, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.4866, y: 16.6886, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.7944, y: 16.7435, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.1127, y: 16.7922, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.4343, y: 16.8432, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.7602, y: 16.8936, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.0865, y: 16.9361, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.4224, y: 16.9767, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.7659, y: 17.008, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.1156, y: 17.0409, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.459, y: 17.072, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.8062, y: 17.1044, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.1516, y: 17.1308, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.5036, y: 17.1581, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.8568, y: 17.1809, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.2144, y: 17.2026, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.5733, y: 17.2271, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.9296, y: 17.2504, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.2914, y: 17.2804, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.6573, y: 17.3103, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.0229, y: 17.3427, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.3946, y: 17.3735, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.7833, y: 17.3726, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.1628, y: 17.3663, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.5358, y: 17.3665, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.9138, y: 17.3713, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.2869, y: 17.3716, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.665, y: 17.3822, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.0402, y: 17.3896, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.4082, y: 17.4533, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.7646, y: 17.5137, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.1134, y: 17.5707, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.4547, y: 17.622, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.7949, y: 17.6706, scorepercent: ['66.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.1335, y: 17.7047, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.4826, y: 17.731, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.8275, y: 17.7505, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.1676, y: 17.7553, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.5101, y: 17.7605, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.8582, y: 17.7593, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.2064, y: 17.7526, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.5512, y: 17.7537, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.8973, y: 17.7471, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.2411, y: 17.7479, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.5908, y: 17.6942, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.9522, y: 17.5887, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.3178, y: 17.4943, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.6791, y: 17.4577, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.033, y: 17.4171, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.3797, y: 17.3934, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.7186, y: 17.3696, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.0633, y: 17.3255, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.3953, y: 17.3065, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.7286, y: 17.2846, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.044, y: 17.2991, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.3508, y: 17.3208, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.6616, y: 17.3385, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.9692, y: 17.365, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.2797, y: 17.3886, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.591, y: 17.4178, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.8959, y: 17.5061, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.1942, y: 17.5898, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.5061, y: 17.6183, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.8098, y: 17.701, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.1147, y: 17.7288, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.411, y: 17.7606, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.7057, y: 17.8013, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.9772, y: 17.9041, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.2616, y: 17.9538, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.5523, y: 17.9863, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.8514, y: 18.013, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.1432, y: 18.0411, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.4304, y: 18.0682, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.7146, y: 18.0934, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73, y: 18.1114, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.2827, y: 18.1258, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.5679, y: 18.1451, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.8323, y: 18.2142, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.0911, y: 18.2193, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.343, y: 18.2722, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.5843, y: 18.3278, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.8292, y: 18.4, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.0766, y: 18.4254, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.2971, y: 18.5027, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.5332, y: 18.5102, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.7548, y: 18.5231, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.9619, y: 18.5304, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.1545, y: 18.5328, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.3291, y: 18.5329, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.4991, y: 18.4836, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.6631, y: 18.4371, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.8224, y: 18.372, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.9729, y: 18.2575, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0999, y: 18.1939, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.2197, y: 18.1353, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.3414, y: 18.0673, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.4373, y: 18, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.5367, y: 17.9329, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.6356, y: 17.8668, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7163, y: 17.8458, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7928, y: 17.8177, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.8729, y: 17.7859, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.9595, y: 17.7539, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.0554, y: 17.725, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.1522, y: 17.7495, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.254, y: 17.7763, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.3612, y: 17.8214, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.4835, y: 17.8775, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.634, y: 17.8994, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.7889, y: 17.9296, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.9472, y: 17.984, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.1108, y: 18.0514, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.2787, y: 18.1328, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.4537, y: 18.2316, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.6284, y: 18.3428, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.8055, y: 18.4596, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.9902, y: 18.5921, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.1814, y: 18.7283, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3804, y: 18.8809, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.5553, y: 19.002, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.7578, y: 19.1078, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.9513, y: 19.2093, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.1554, y: 19.3142, scorepercent: ['28.57%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.3474, y: 19.4164, scorepercent: ['28.57%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.5359, y: 19.5135, scorepercent: ['28.57%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.7127, y: 19.6023, scorepercent: ['28.57%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.8835, y: 19.7628, scorepercent: ['28.57%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.0448, y: 19.9318, scorepercent: ['28.57%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.2016, y: 20.0945, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.3578, y: 20.2488, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.5115, y: 20.4009, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.6549, y: 20.5372, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.7724, y: 20.6964, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8575, y: 20.8383, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9323, y: 21.0161, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9591, y: 21.2104, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.972, y: 21.4111, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9652, y: 21.5931, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9541, y: 21.7684, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9301, y: 21.9476, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8985, y: 22.1166, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8499, y: 22.1998, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8018, y: 22.2254, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.7255, y: 22.2339, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.6334, y: 22.2261, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.5312, y: 22.1968, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.3998, y: 22.1535, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.2601, y: 22.0765, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.1287, y: 21.9917, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.0005, y: 21.8968, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.8707, y: 21.8053, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.7442, y: 21.6974, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.5782, y: 21.619, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.4086, y: 21.4749, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.2209, y: 21.3201, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.0198, y: 21.1484, scorepercent: ['30.95%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.8101, y: 20.9645, scorepercent: ['43.48%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.5761, y: 20.8001, scorepercent: ['43.48%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3271, y: 20.6277, scorepercent: ['43.48%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.0544, y: 20.4638, scorepercent: ['43.48%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7543, y: 20.3051, scorepercent: ['43.48%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.4604, y: 20.0916, scorepercent: ['43.48%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.1785, y: 19.865, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.8674, y: 19.6413, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.5664, y: 19.4187, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.2556, y: 19.1494, scorepercent: ['27.27%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.8983, y: 18.9136, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.5086, y: 18.6864, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.1274, y: 18.5263, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.7382, y: 18.2911, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.3393, y: 18.0621, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.9626, y: 17.8061, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.5749, y: 17.5522, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.1576, y: 17.3152, scorepercent: ['33.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.7471, y: 17.0633, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.3368, y: 16.8013, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.9169, y: 16.5852, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.4411, y: 16.4158, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.9711, y: 16.2542, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.481, y: 16.0321, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.9804, y: 15.8297, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.5241, y: 15.5248, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.1174, y: 15.1735, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.6555, y: 14.8641, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.2036, y: 14.601, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.7125, y: 14.374, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.2408, y: 14.114, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.7662, y: 13.8528, scorepercent: ['37.5%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.3109, y: 13.5917, scorepercent: ['37.5%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.8439, y: 13.3313, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.3605, y: 13.0886, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.8813, y: 12.8384, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.4234, y: 12.553, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.9656, y: 12.2522, scorepercent: ['41.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.495, y: 11.9846, scorepercent: ['41.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.0265, y: 11.7088, scorepercent: ['41.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.5028, y: 11.5475, scorepercent: ['41.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.992, y: 11.3367, scorepercent: ['41.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.4951, y: 11.0918, scorepercent: ['41.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.9883, y: 10.8568, scorepercent: ['41.18%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.5461, y: 10.5551, scorepercent: ['41.18%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.0351, y: 10.3264, scorepercent: ['41.18%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.5028, y: 10.1239, scorepercent: ['41.18%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.9768, y: 9.9071, scorepercent: ['18.18%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.4524, y: 9.696, scorepercent: ['18.18%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.94, y: 9.477, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.4151, y: 9.2789, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.8936, y: 9.0736, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.3701, y: 8.8738, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.8425, y: 8.6849, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.3096, y: 8.5072, scorepercent: ['20%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.8007, y: 8.2856, scorepercent: ['16.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.2694, y: 8.1083, scorepercent: ['16.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.7444, y: 7.9088, scorepercent: ['16.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.2212, y: 7.7156, scorepercent: ['16.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.6694, y: 7.549, scorepercent: ['16.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.1362, y: 7.3857, scorepercent: ['16.67%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.629, y: 7.2027, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.1205, y: 7.0219, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.6093, y: 6.8433, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.097, y: 6.6747, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.5815, y: 6.5079, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.0661, y: 6.3475, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.5489, y: 6.1877, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.0403, y: 6.0397, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.5328, y: 5.8966, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.0407, y: 5.7485, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.5465, y: 5.6034, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.0438, y: 5.4776, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.5456, y: 5.3495, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.0495, y: 5.2366, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.5495, y: 5.1121, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.047, y: 4.9741, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.5504, y: 4.846, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.0425, y: 4.7082, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.5499, y: 4.5816, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.0636, y: 4.461, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.5812, y: 4.3461, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.1025, y: 4.2302, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.6221, y: 4.1074, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.1403, y: 3.9818, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.6427, y: 3.8751, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.146, y: 3.7732, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.6619, y: 3.6721, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.1692, y: 3.5789, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.6839, y: 3.4806, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.1884, y: 3.3498, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.7214, y: 3.2544, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.2521, y: 3.1583, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.7976, y: 3.0709, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.3293, y: 2.971, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.8214, y: 2.8582, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.3124, y: 2.7427, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.7989, y: 2.6385, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.3146, y: 2.5802, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.8348, y: 2.5356, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.3707, y: 2.4791, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.9211, y: 2.4307, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.4772, y: 2.3692, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.0454, y: 2.3165, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.6056, y: 2.2659, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.1786, y: 2.2562, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.7139, y: 2.1976, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.2628, y: 2.1619, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.8158, y: 2.1429, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.3723, y: 2.104, scorepercent: ['N/A'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.9588, y: 2.0784, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.552, y: 2.0622, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.1496, y: 2.0413, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.729, y: 1.9929, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.306, y: 1.9396, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.8779, y: 1.8917, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.4441, y: 1.8442, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.0143, y: 1.8093, scorepercent: ['0%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.5913, y: 1.7744, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 26.1672, y: 1.6934, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.77, y: 1.6647, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.4013, y: 1.6758, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 25.0334, y: 1.6636, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.6751, y: 1.6442, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 24.3236, y: 1.6492, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.9936, y: 1.6611, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.6659, y: 1.672, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.3438, y: 1.6908, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 23.0272, y: 1.7184, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.731, y: 1.7514, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.4495, y: 1.7832, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 22.1732, y: 1.8197, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.905, y: 1.8569, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.635, y: 1.8992, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.3809, y: 1.9888, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 21.1152, y: 2.03, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.8478, y: 2.0694, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.5852, y: 2.116, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.3246, y: 2.1776, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 20.0755, y: 2.2397, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.8334, y: 2.3097, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.6037, y: 2.3782, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.3926, y: 2.4381, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 19.1857, y: 2.4942, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.9805, y: 2.546, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.781, y: 2.5978, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.5907, y: 2.6499, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.4073, y: 2.6944, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.234, y: 2.7295, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 18.0746, y: 2.7689, scorepercent: ['50%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 17.9211, y: 2.8053, scorepercent: ['83.33%'], name: ['D.Carroll'], jersey: [' #5'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }] }, { sequence: [{ x: 27.6796, y: 30.974, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6638, y: 30.9713, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6537, y: 30.9749, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.651, y: 30.9896, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6259, y: 30.9761, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6333, y: 30.9604, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6647, y: 30.9932, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.748, y: 31.1071, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.8148, y: 31.185, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.8777, y: 31.2578, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9382, y: 31.3332, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9985, y: 31.4103, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0485, y: 31.4814, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0586, y: 31.5117, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.069, y: 31.541, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0519, y: 31.5425, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0234, y: 31.5413, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9841, y: 31.543, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.981, y: 31.5595, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9979, y: 31.605, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9704, y: 31.6064, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9328, y: 31.5986, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.86, y: 31.5515, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.7779, y: 31.5056, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.7025, y: 31.4532, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6293, y: 31.3961, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5618, y: 31.3342, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5044, y: 31.2755, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.4899, y: 31.2501, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.4817, y: 31.2253, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5037, y: 31.2258, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.5397, y: 31.2242, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6291, y: 31.2415, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.6925, y: 31.2278, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.7303, y: 31.1796, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.811, y: 31.1602, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.8832, y: 31.149, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 27.9679, y: 31.1303, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.0561, y: 31.1143, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.1569, y: 31.1022, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.2567, y: 31.095, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.3676, y: 31.0852, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.4888, y: 31.0794, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.595, y: 31.0735, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.7098, y: 31.0685, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.8321, y: 31.0647, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 28.9738, y: 31.057, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.0766, y: 31.0238, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.1857, y: 30.9948, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.3258, y: 31.015, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.4407, y: 31.0139, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.5699, y: 31.0132, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.7035, y: 31.0189, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 29.8555, y: 31.0287, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.0074, y: 31.0424, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.175, y: 31.0508, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.351, y: 31.071, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.5288, y: 31.0872, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.7348, y: 31.1, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 30.9409, y: 31.1043, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.1531, y: 31.1081, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.3583, y: 31.1114, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.5512, y: 31.0529, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.7646, y: 31.0518, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 31.9723, y: 30.9847, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.1846, y: 30.9173, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.4132, y: 30.8434, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.6451, y: 30.7758, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 32.8801, y: 30.7569, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.1158, y: 30.7294, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.3457, y: 30.7033, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.5727, y: 30.6694, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 33.8077, y: 30.6408, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.0474, y: 30.6246, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.2915, y: 30.6241, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.5457, y: 30.5773, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 34.8055, y: 30.5476, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.0955, y: 30.5812, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.3759, y: 30.5607, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 35.6871, y: 30.6055, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.0111, y: 30.6576, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.3432, y: 30.7068, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 36.6817, y: 30.7492, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.0226, y: 30.7407, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.3719, y: 30.7349, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 37.7355, y: 30.7291, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.1069, y: 30.7196, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.4836, y: 30.7023, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 38.8802, y: 30.6591, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.2826, y: 30.6013, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 39.6915, y: 30.5985, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.1095, y: 30.5871, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.5337, y: 30.5763, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 40.9646, y: 30.5623, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.3631, y: 30.5547, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 41.7562, y: 30.5328, scorepercent: ['100%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.1587, y: 30.5152, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.5716, y: 30.4976, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 42.9963, y: 30.4692, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.4295, y: 30.4381, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 43.8768, y: 30.395, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.322, y: 30.3589, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 44.7687, y: 30.3251, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.1985, y: 30.3151, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 45.63, y: 30.3062, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.0532, y: 30.2918, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.4701, y: 30.283, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 46.8841, y: 30.2791, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.2963, y: 30.2764, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 47.7504, y: 30.2615, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.2099, y: 30.2447, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 48.6541, y: 30.2302, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.0904, y: 30.2138, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.519, y: 30.1994, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 49.9439, y: 30.2014, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.3558, y: 30.2091, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 50.7737, y: 30.2214, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.1873, y: 30.2416, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 51.5949, y: 30.235, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.0125, y: 30.255, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.4326, y: 30.2751, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 52.8501, y: 30.2896, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.266, y: 30.2982, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 53.6781, y: 30.2946, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.0836, y: 30.2848, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.4755, y: 30.2752, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 54.8755, y: 30.25, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.2779, y: 30.231, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 55.6737, y: 30.2211, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.0621, y: 30.2041, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.4419, y: 30.1947, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 56.8017, y: 30.2324, scorepercent: ['33.33%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.1634, y: 30.2539, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.5292, y: 30.2946, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 57.8708, y: 30.2963, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.2186, y: 30.2997, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.5647, y: 30.3037, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 58.9039, y: 30.3151, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.2343, y: 30.3361, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.5651, y: 30.3459, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 59.8946, y: 30.3553, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.2108, y: 30.3856, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.521, y: 30.4014, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 60.8231, y: 30.4218, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.1421, y: 30.3821, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.4657, y: 30.337, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 61.8057, y: 30.2368, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.1431, y: 30.149, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.477, y: 30.0616, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 62.7994, y: 30.048, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.1266, y: 29.9827, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.474, y: 29.8569, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 63.8251, y: 29.7231, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.1734, y: 29.5961, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.5005, y: 29.5401, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 64.8333, y: 29.4976, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.1753, y: 29.3852, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.5022, y: 29.2891, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 65.8421, y: 29.2483, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.1792, y: 29.3177, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.5166, y: 29.3908, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 66.8507, y: 29.4615, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.175, y: 29.536, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.4961, y: 29.6185, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 67.826, y: 29.6511, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.1326, y: 29.733, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.4066, y: 29.8862, scorepercent: ['75%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.6808, y: 30.0371, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 68.9553, y: 30.1891, scorepercent: ['0%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.2403, y: 30.2922, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.5145, y: 30.4014, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 69.796, y: 30.513, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.0901, y: 30.632, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.3738, y: 30.696, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.6432, y: 30.7144, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 70.9133, y: 30.7347, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.1749, y: 30.7737, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.4589, y: 30.7613, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 71.7468, y: 30.7583, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.0398, y: 30.7551, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.3349, y: 30.7563, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.6411, y: 30.7543, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 72.9206, y: 30.8063, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.2003, y: 30.8603, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.4764, y: 30.917, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 73.7666, y: 30.9227, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.0263, y: 30.9904, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.2796, y: 31.0549, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.526, y: 31.1168, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 74.7642, y: 31.1748, scorepercent: ['25%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.0064, y: 31.2453, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.253, y: 31.3252, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.4811, y: 31.4636, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.6983, y: 31.6091, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 75.9087, y: 31.7667, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.0979, y: 31.9361, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.2617, y: 32.1114, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.4345, y: 32.2507, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.5969, y: 32.4021, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.7653, y: 32.5721, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.858, y: 32.8141, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 76.9432, y: 33.0258, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0422, y: 33.2543, scorepercent: ['27.27%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.1471, y: 33.5031, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.2456, y: 33.7813, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.267, y: 34.0581, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.2995, y: 34.3103, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.3033, y: 34.5638, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.2424, y: 34.8349, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.1713, y: 35.0979, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.112, y: 35.3508, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0705, y: 35.5957, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0397, y: 35.8328, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.023, y: 36.0583, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0069, y: 36.2588, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0307, y: 36.4419, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.0701, y: 36.6415, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.096, y: 36.8173, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.1098, y: 36.9696, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.1311, y: 37.093, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.2107, y: 37.2108, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.3218, y: 37.3247, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.4045, y: 37.4541, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.5496, y: 37.5472, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.7393, y: 37.616, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 77.9342, y: 37.6713, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.1278, y: 37.7099, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.3194, y: 37.7274, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.5158, y: 37.6643, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.7119, y: 37.5836, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 78.9256, y: 37.4837, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.1499, y: 37.3891, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.3719, y: 37.279, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.5848, y: 37.1978, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 79.7969, y: 37.0971, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.0074, y: 36.9755, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.1665, y: 36.8361, scorepercent: ['50%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.3754, y: 36.6439, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.5777, y: 36.4232, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.7388, y: 36.1848, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 80.8914, y: 35.9147, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.0385, y: 35.6391, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.1704, y: 35.3524, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.271, y: 35.1249, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.3493, y: 34.832, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.4295, y: 34.567, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.4951, y: 34.2842, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.5511, y: 33.9967, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.6284, y: 33.6529, scorepercent: ['57.14%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.6996, y: 33.3139, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.7645, y: 32.9673, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.7588, y: 32.6239, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.7978, y: 32.293, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.8346, y: 31.9543, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.8752, y: 31.6575, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.9177, y: 31.3882, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.953, y: 31.1239, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.9706, y: 30.8637, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 81.989, y: 30.6154, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.0525, y: 30.5056, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.1185, y: 30.4051, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.177, y: 30.3278, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.2496, y: 30.2753, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.3233, y: 30.2464, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.3962, y: 30.2173, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.4645, y: 30.206, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.608, y: 30.2117, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.7084, y: 30.2524, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.8191, y: 30.2913, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 82.9351, y: 30.3498, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.0582, y: 30.4156, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.1975, y: 30.489, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.3778, y: 30.5712, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.5877, y: 30.6545, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.7792, y: 30.6753, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 83.9768, y: 30.6699, scorepercent: ['35.48%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.1943, y: 30.6687, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.3825, y: 30.6777, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.5857, y: 30.6967, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 84.8184, y: 30.6662, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.1156, y: 30.6322, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.371, y: 30.6473, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 85.6865, y: 30.6024, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.0086, y: 30.5959, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.3429, y: 30.5645, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 86.6717, y: 30.5385, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.0041, y: 30.5074, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.3268, y: 30.4645, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 87.6705, y: 30.4666, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.0019, y: 30.4563, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.3747, y: 30.4348, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 88.7469, y: 30.4158, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 89.1491, y: 30.3871, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 89.5489, y: 30.3177, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 89.9026, y: 30.3128, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 90.1966, y: 30.3353, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 90.5178, y: 30.3436, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 90.8416, y: 30.4065, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.1883, y: 30.404, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.5281, y: 30.409, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.8603, y: 30.4119, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.1865, y: 30.4819, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.512, y: 30.579, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.7964, y: 30.6418, scorepercent: ['40%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.0743, y: 30.7227, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.3006, y: 30.807, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.4936, y: 30.9367, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.6765, y: 31.0683, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.8386, y: 31.2342, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.0541, y: 31.36, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.2802, y: 31.4583, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.4771, y: 31.5831, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.6088, y: 31.6941, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.7125, y: 31.868, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.7711, y: 32.0124, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.8301, y: 32.1562, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.9207, y: 32.2396, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.0048, y: 32.3263, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.0888, y: 32.4132, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.1535, y: 32.5048, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.2087, y: 32.6027, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.2933, y: 32.6435, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.3526, y: 32.6814, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.3837, y: 32.7387, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.3629, y: 32.8379, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.327, y: 32.9543, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.3202, y: 33.0187, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.3097, y: 33.0648, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.2837, y: 33.1102, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.2823, y: 33.1756, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.2728, y: 33.2453, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.2086, y: 33.3145, scorepercent: ['74.12%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.1377, y: 33.382, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.071, y: 33.4329, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 95.0037, y: 33.4835, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.9334, y: 33.5307, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.8338, y: 33.5952, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.7402, y: 33.6537, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.6582, y: 33.6941, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.5715, y: 33.7316, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.4805, y: 33.7633, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.3656, y: 33.7958, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.2208, y: 33.8572, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 94.0639, y: 33.9239, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.8989, y: 33.9918, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.7416, y: 34.0562, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.5717, y: 34.1322, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.384, y: 34.1968, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 93.171, y: 34.2766, scorepercent: ['66.67%'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.9442, y: 34.3577, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.6829, y: 34.468, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.4131, y: 34.5726, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 92.1674, y: 34.6215, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.8844, y: 34.6821, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.5967, y: 34.7039, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.2966, y: 34.7216, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 91.0074, y: 34.773, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 90.6907, y: 34.7582, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 90.3665, y: 34.7306, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 90.0274, y: 34.743, scorepercent: ['N/A'], name: ['B.Biyombo'], jersey: [' #8'], team: ['TOR'], marker: { enabled: [true], symbol: getGingerbread(), height: [40], width: [50] }, color: ['red'] }, { x: 89.6632, y: 34.7116,