Highcharts.setOptions({ // Apply to all charts
    chart: {
        events: {
            beforePrint: function () {
                this.oldhasUserSize = this.hasUserSize;
                this.resetParams = [this.chartWidth, this.chartHeight, false];
                this.setSize(600, 400, false);
            },
            afterPrint: function () {
                this.setSize.apply(this, this.resetParams);
                this.hasUserSize = this.oldhasUserSize;
            }
        }
    }
});

Highcharts.chart('container', {

    title: {
        text: 'Rescale to print'
    },

    subtitle: {
        text: 'Click the context menu and choose "Print chart".<br>The chart ' +
            'size is set to 600x400 and restored after print.'
    },

    xAxis: {
        categories: [
            'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
            'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
        ]
    },

    series: [{
        data: [
            29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1,
            95.6, 54.4
        ]
    }]

});
