// create the chart
const chart = Highcharts.chart('container', {
    chart: {
        events: {
            redraw: function () {
                const label = this.renderer.label(
                    'The chart was just ' +
                    'redrawn', 100, 120
                )
                    .attr({
                        fill: Highcharts.getOptions().colors[0],
                        padding: 10,
                        r: 5,
                        zIndex: 8
                    })
                    .css({
                        color: '#FFFFFF'
                    })
                    .add();

                setTimeout(() => {
                    label.fadeOut();
                }, 1000);
            }
        }
    },
    xAxis: {
        categories: [
            'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
            'Oct', 'Nov', 'Dec'
        ]
    },
    series: [{
        data: [
            29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1,
            95.6, 54.4
        ]
    }]
});

// activate the button
document.getElementById('button').addEventListener('click', e => {
    chart.addSeries({
        data: [
            216.4, 194.1, 95.6, 54.4, 29.9, 71.5, 106.4, 129.2, 144.0, 176.0,
            135.6, 148.5
        ]
    });

    e.target.disabled = true;
});
