const data = [
    [1585143000000, 62.69, 64.56, 61.08, 61.38, 303602000],
    [1585229400000, 61.63, 64.67, 61.59, 64.61, 252087200],
    [1585315800000, 63.19, 63.97, 61.76, 61.94, 204216800],
    [1585575000000, 62.69, 63.88, 62.35, 63.7, 167976400],
    [1585661400000, 63.9, 65.62, 63, 63.57, 197002000],
    [1585747800000, 61.63, 62.18, 59.78, 60.23, 176218400],
    [1585834200000, 60.08, 61.29, 59.22, 61.23, 165934000],
    [1585920600000, 60.7, 61.42, 59.74, 60.35, 129880000],
    [1586179800000, 62.72, 65.78, 62.35, 65.62, 201820400],
    [1586266200000, 67.7, 67.93, 64.75, 64.86, 202887200],
    [1586352600000, 65.68, 66.84, 65.31, 66.52, 168895200],
    [1586439000000, 67.18, 67.52, 66.18, 67, 161834800],
    [1586784600000, 67.08, 68.43, 66.46, 68.31, 131022800],
    [1586871000000, 70, 72.06, 69.51, 71.76, 194994800],
    [1586957400000, 70.6, 71.58, 70.16, 71.11, 131154400],
    [1587043800000, 71.85, 72.05, 70.59, 71.67, 157125200],
    [1587130200000, 71.17, 71.74, 69.21, 70.7, 215250000],
    [1587389400000, 69.49, 70.42, 69.21, 69.23, 130015200],
    [1587475800000, 69.07, 69.31, 66.36, 67.09, 180991600],
    [1587562200000, 68.4, 69.47, 68.05, 69.03, 116862400],
    [1587648600000, 68.97, 70.44, 68.72, 68.76, 124814400],
    [1587735000000, 69.3, 70.75, 69.25, 70.74, 126161200],
    [1587994200000, 70.45, 71.14, 69.99, 70.79, 117087600],
    [1588080600000, 71.27, 71.46, 69.55, 69.64, 112004800],
    [1588167000000, 71.18, 72.42, 70.97, 71.93, 137280800],
    [1588253400000, 72.49, 73.63, 72.09, 73.45, 183064000],
    [1588339800000, 71.56, 74.75, 71.46, 72.27, 240616800],
    [1588599000000, 72.29, 73.42, 71.58, 73.29, 133568000],
    [1588685400000, 73.76, 75.25, 73.61, 74.39, 147751200],
    [1588771800000, 75.11, 75.81, 74.72, 75.16, 142333600],
    [1588858200000, 75.81, 76.29, 75.49, 75.93, 115215200],
    [1588944600000, 76.41, 77.59, 76.07, 77.53, 133838400],
    [1589203800000, 77.03, 79.26, 76.81, 78.75, 145946400],
    [1589290200000, 79.46, 79.92, 77.73, 77.85, 162301200],
    [1589376600000, 78.04, 78.99, 75.8, 76.91, 200622400],
    [1589463000000, 76.13, 77.45, 75.38, 77.39, 158929200],
    [1589549400000, 75.09, 76.97, 75.05, 76.93, 166348400],
    [1589808600000, 78.29, 79.13, 77.58, 78.74, 135178400],
    [1589895000000, 78.76, 79.63, 78.25, 78.29, 101729600],
    [1589981400000, 79.17, 79.88, 79.13, 79.81, 111504800],
    [1590067800000, 79.67, 80.22, 78.97, 79.21, 102688800],
    [1590154200000, 78.94, 79.81, 78.84, 79.72, 81803200],
    [1590499800000, 80.88, 81.06, 79.13, 79.18, 125522000],
    [1590586200000, 79.04, 79.68, 78.27, 79.53, 112945200],
    [1590672600000, 79.19, 80.86, 78.91, 79.56, 133560800],
    [1590759000000, 79.81, 80.29, 79.12, 79.49, 153532400],
    [1591018200000, 79.44, 80.59, 79.3, 80.46, 80791200],
    [1591104600000, 80.19, 80.86, 79.73, 80.83, 87642800],
    [1591191000000, 81.17, 81.55, 80.57, 81.28, 104491200],
    [1591277400000, 81.1, 81.4, 80.19, 80.58, 87560400],
    [1591363800000, 80.84, 82.94, 80.81, 82.88, 137250400],
    [1591623000000, 82.56, 83.4, 81.83, 83.36, 95654400],
    [1591709400000, 83.04, 86.4, 83, 86, 147712400],
    [1591795800000, 86.97, 88.69, 86.52, 88.21, 166651600],
    [1591882200000, 87.33, 87.76, 83.87, 83.97, 201662400],
    [1591968600000, 86.18, 86.95, 83.56, 84.7, 200146000],
    [1592227800000, 83.31, 86.42, 83.14, 85.75, 138808800],
    [1592314200000, 87.86, 88.3, 86.18, 88.02, 165428800],
    [1592400600000, 88.79, 88.85, 87.77, 87.9, 114406400],
    [1592487000000, 87.85, 88.36, 87.31, 87.93, 96820400],
    [1592573400000, 88.66, 89.14, 86.29, 87.43, 264476000],
    [1592832600000, 87.83, 89.86, 87.79, 89.72, 135445200],
    [1592919000000, 91, 93.1, 90.57, 91.63, 212155600],
    [1593005400000, 91.25, 92.2, 89.63, 90.01, 192623200],
    [1593091800000, 90.18, 91.25, 89.39, 91.21, 137522400],
    [1593178200000, 91.1, 91.33, 88.25, 88.41, 205256800],
    [1593437400000, 88.31, 90.54, 87.82, 90.44, 130646000],
    [1593523800000, 90.02, 91.5, 90, 91.2, 140223200]
];
// split the data set into ohlc and volume
const ohlc = [],
    volume = [],
    dataLength = data.length;

const H = Highcharts,
    /* eslint-disable no-underscore-dangle */
    bindingsUtils = H.NavigationBindings.prototype.utils;

H.seriesType(
    'customIndicatorBasedOnRSI',
    'rsi', {
        name: 'Custom Indicator',
        color: 'red'
    },
    {}
);

bindingsUtils.indicatorsWithAxes.push('customIndicatorBasedOnRSI');

for (let i = 0; i < dataLength; i += 1) {
    ohlc.push([
        data[i][0], // the date
        data[i][1], // open
        data[i][2], // high
        data[i][3], // low
        data[i][4] // close
    ]);

    volume.push([
        data[i][0], // the date
        data[i][5] // the volume
    ]);
}

Highcharts.stockChart('container', {
    yAxis: [
        {
            labels: {
                align: 'left'
            },
            height: '80%',
            resize: {
                enabled: true
            }
        },
        {
            labels: {
                align: 'left'
            },
            top: '80%',
            height: '20%',
            offset: 0
        }
    ],
    tooltip: {
        shape: 'square',
        headerShape: 'callout',
        borderWidth: 0,
        shadow: false,
        positioner: function (width, height, point) {
            const chart = this.chart;
            let position;

            if (point.isHeader) {
                position = {
                    x: Math.max(
                        // Left side limit
                        chart.plotLeft,
                        Math.min(
                            point.plotX + chart.plotLeft - width / 2,
                            // Right side limit
                            chart.chartWidth - width - chart.marginRight
                        )
                    ),
                    y: point.plotY
                };
            } else {
                position = {
                    x: point.series.chart.plotLeft,
                    y: point.series.yAxis.top - chart.plotTop
                };
            }

            return position;
        }
    },
    series: [
        {
            type: 'ohlc',
            id: 'aapl-ohlc',
            name: 'AAPL Stock Price',
            data: ohlc
        },
        {
            type: 'column',
            id: 'aapl-volume',
            name: 'AAPL Volume',
            data: volume,
            yAxis: 1
        }
    ],
    responsive: {
        rules: [
            {
                condition: {
                    maxWidth: 800
                },
                chartOptions: {
                    rangeSelector: {
                        inputEnabled: false
                    }
                }
            }
        ]
    }
});
