const colors = Highcharts.getOptions().colors,
    sunburstData = [{
        name: '(anonymous)',
        id: '39',
        parent: '38',
        value: 16716,
        color: colors[0]
    }, {
        name: 'a.objectEach',
        id: '38',
        parent: '37',
        value: 16716,
        color: colors[0]
    }, {
        name: 'u',
        id: '37',
        parent: '36',
        value: 16716,
        color: colors[0]
    }, {
        name: 'a.merge',
        id: '36',
        parent: '35',
        value: 16716,
        color: colors[0]
    }, {
        name: 'setOptions',
        id: '35',
        parent: '34',
        value: 16716,
        color: colors[0]
    }, {
        name: 'init',
        id: '34',
        parent: '33',
        value: 16716,
        color: colors[0]
    }, {
        name: 'I',
        id: '33',
        parent: '32',
        value: 16716,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '32',
        parent: '31',
        value: 16716,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '31',
        parent: '30',
        value: 33116,
        color: colors[2]
    }, {
        name: 'createAxes',
        id: '30',
        parent: '20',
        value: 33116,
        color: colors[0]
    }, {
        name: 'a.objectEach',
        id: '25',
        parent: '24',
        value: 16416,
        color: colors[0]
    }, {
        name: 'attr',
        id: '24',
        parent: '23',
        value: 16416,
        color: colors[0]
    }, {
        name: 'init',
        id: '23',
        parent: '22',
        value: 16416,
        color: colors[0]
    }, {
        name: 'a.SVGRenderer',
        id: '22',
        parent: '21',
        value: 16416,
        color: colors[0]
    }, {
        name: 'getContainer',
        id: '21',
        parent: '20',
        value: 32832,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '29',
        parent: '28',
        value: 16412,
        color: colors[2]
    }, {
        name: '(anonymous)',
        id: '28',
        parent: '27',
        value: 16412,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '27',
        parent: '26',
        value: 16412,
        color: colors[2]
    }, {
        name: 'resetMargins',
        id: '26',
        parent: '20',
        value: 16412,
        color: colors[0]
    }, {
        name: 'E.buildStacks',
        id: '83',
        parent: '82',
        value: 16872,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '82',
        parent: '80',
        value: 16872,
        color: colors[0]
    }, {
        name: 'a.fireEvent',
        id: '80',
        parent: '79',
        value: 33304,
        color: colors[0]
    }, {
        name: 'getSeriesExtremes',
        id: '79',
        parent: '78',
        value: 33304,
        color: colors[0]
    }, {
        name: 'setTickInterval',
        id: '81',
        parent: '78',
        value: 16632,
        color: colors[0]
    }, {
        name: 'setScale',
        id: '78',
        parent: '77',
        value: 49936,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '77',
        parent: '76',
        value: 49936,
        color: colors[0]
    }, {
        name: 'render',
        id: '123',
        parent: '122',
        value: 17056,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '122',
        parent: '76',
        value: 17056,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '76',
        parent: '47',
        value: 66992,
        color: colors[2]
    }, {
        name: 'renderItem',
        id: '61',
        parent: '60',
        value: 16560,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '60',
        parent: '55',
        value: 16560,
        color: colors[2]
    }, {
        name: 'E.stroke-widthSetter.E.strokeSetter',
        id: '70',
        parent: '69',
        value: 16400,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '69',
        parent: '68',
        value: 16400,
        color: colors[0]
    }, {
        name: 'a.objectEach',
        id: '68',
        parent: '67',
        value: 16400,
        color: colors[0]
    }, {
        name: 'attr',
        id: '67',
        parent: '55',
        value: 16400,
        color: colors[0]
    }, {
        name: 'positionItems',
        id: '71',
        parent: '55',
        value: 16464,
        color: colors[0]
    }, {
        name: 'render',
        id: '55',
        parent: '54',
        value: 49424,
        color: colors[0]
    }, {
        name: 'init',
        id: '54',
        parent: '53',
        value: 49424,
        color: colors[0]
    }, {
        name: 'a.Legend',
        id: '53',
        parent: '47',
        value: 49424,
        color: colors[0]
    }, {
        name: 'setTitle',
        id: '48',
        parent: '47',
        value: 16432,
        color: colors[0]
    }, {
        name: 'buildText',
        id: '98',
        parent: '97',
        value: 16400,
        color: colors[0]
    }, {
        name: 'add',
        id: '97',
        parent: '94',
        value: 16400,
        color: colors[0]
    }, {
        name: 'a.numberFormat',
        id: '96',
        parent: '95',
        value: 16400,
        color: colors[0]
    }, {
        name: 'defaultLabelFormatter',
        id: '95',
        parent: '94',
        value: 16400,
        color: colors[0]
    }, {
        name: 'addLabel',
        id: '94',
        parent: '93',
        value: 32800,
        color: colors[0]
    }, {
        name: 'a.Tick',
        id: '93',
        parent: '92',
        value: 32800,
        color: colors[0]
    }, {
        name: 'generateTick',
        id: '92',
        parent: '91',
        value: 32800,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '91',
        parent: '90',
        value: 32800,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '90',
        parent: '89',
        value: 32800,
        color: colors[2]
    }, {
        name: 'a.fireEvent',
        id: '108',
        parent: '107',
        value: 16408,
        color: colors[0]
    }, {
        name: 'autoLabelAlign',
        id: '107',
        parent: '105',
        value: 16408,
        color: colors[0]
    }, {
        name: 'renderUnsquish',
        id: '105',
        parent: '89',
        value: 32808,
        color: colors[0]
    }, {
        name: 'getOffset',
        id: '89',
        parent: '88',
        value: 65608,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '88',
        parent: '87',
        value: 65608,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '87',
        parent: '86',
        value: 65608,
        color: colors[2]
    }, {
        name: 'getAxisMargins',
        id: '86',
        parent: '47',
        value: 65608,
        color: colors[0]
    }, {
        name: 'plotGroup',
        id: '140',
        parent: '136',
        value: 16464,
        color: colors[0]
    }, {
        name: 'render',
        id: '136',
        parent: '135',
        value: 49948,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '135',
        parent: '134',
        value: 66860,
        color: colors[0]
    }, {
        name: 'forEach',
        id: '134',
        parent: '133',
        value: 66860,
        color: colors[2]
    }, {
        name: 'renderSeries',
        id: '133',
        parent: '47',
        value: 66860,
        color: colors[0]
    }, {
        name: 'render',
        id: '47',
        parent: '20',
        value: 298564,
        color: colors[0]
    }, {
        name: 'firstRender',
        id: '20',
        parent: '8',
        value: 380924,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '8',
        parent: '7',
        value: 397316,
        color: colors[0]
    }, {
        name: 'a.fireEvent',
        id: '7',
        parent: '6',
        value: 397316,
        color: colors[0]
    }, {
        name: 'init',
        id: '6',
        parent: '5',
        value: 397316,
        color: colors[0]
    }, {
        name: 'getArgs',
        id: '5',
        parent: '4',
        value: 397316,
        color: colors[0]
    }, {
        name: 'a.Chart',
        id: '4',
        parent: '3',
        value: 397316,
        color: colors[0]
    }, {
        name: 'a.chart',
        id: '3',
        parent: '2',
        value: 397316,
        color: colors[0]
    }, {
        name: '(anonymous)',
        id: '2',
        parent: '1',
        value: 397316,
        color: colors[0]
    }, {
        name: '(root)',
        id: '1',
        parent: '',
        value: 397316,
        color: colors[2]
    }],
    data = [{
        name: 'buildText',
        id: '98',
        value: 16400,
        color: colors[0],
        x: -22,
        low: 264848,
        high: 281248
    }, {
        name: 'a.numberFormat',
        id: '96',
        value: 16400,
        color: colors[0],
        x: -22,
        low: 281248,
        high: 297648
    }, {
        name: 'add',
        id: '97',
        value: 16400,
        color: colors[0],
        x: -21,
        low: 264848,
        high: 281248
    }, {
        name: 'defaultLabelFormatter',
        id: '95',
        value: 16400,
        color: colors[0],
        x: -21,
        low: 281248,
        high: 297648
    }, {
        name: '~',
        id: '39',
        value: 16716,
        color: colors[0],
        x: -20,
        low: 32792,
        high: 49508
    }, {
        name: 'addLabel',
        id: '94',
        value: 32800,
        color: colors[0],
        x: -20,
        low: 264848,
        high: 297648
    }, {
        name: 'a.objectEach',
        id: '38',
        value: 16716,
        color: colors[0],
        x: -19,
        low: 32792,
        high: 49508
    }, {
        name: 'a.Tick',
        id: '93',
        value: 32800,
        color: colors[0],
        x: -19,
        low: 264848,
        high: 297648
    }, {
        name: 'u',
        id: '37',
        value: 16716,
        color: colors[0],
        x: -18,
        low: 32792,
        high: 49508
    }, {
        name: 'E.buildStacks',
        id: '83',
        value: 16872,
        color: colors[0],
        x: -18,
        low: 148432,
        high: 165304
    }, {
        name: 'E.stroke-widthSetter.E.strokeSetter',
        id: '70',
        value: 16400,
        color: colors[0],
        x: -18,
        low: 215552,
        high: 231952
    }, {
        name: 'generateTick',
        id: '92',
        value: 32800,
        color: colors[0],
        x: -18,
        low: 264848,
        high: 297648
    }, {
        name: 'a.fireEvent',
        id: '108',
        value: 16408,
        color: colors[0],
        x: -18,
        low: 314048,
        high: 330456
    }, {
        name: 'a.merge',
        id: '36',
        value: 16716,
        color: colors[0],
        x: -17,
        low: 32792,
        high: 49508
    }, {
        name: '~',
        id: '82',
        value: 16872,
        color: colors[0],
        x: -17,
        low: 148432,
        high: 165304
    }, {
        name: '~',
        id: '69',
        value: 16400,
        color: colors[0],
        x: -17,
        low: 215552,
        high: 231952
    }, {
        name: '~',
        id: '91',
        value: 32800,
        color: colors[0],
        x: -17,
        low: 264848,
        high: 297648
    }, {
        name: 'autoLabelAlign',
        id: '107',
        value: 16408,
        color: colors[0],
        x: -17,
        low: 314048,
        high: 330456
    }, {
        name: 'setOptions',
        id: '35',
        value: 16716,
        color: colors[0],
        x: -16,
        low: 32792,
        high: 49508
    }, {
        name: 'a.fireEvent',
        id: '80',
        value: 33304,
        color: colors[0],
        x: -16,
        low: 132000,
        high: 165304
    }, {
        name: 'renderItem',
        id: '61',
        value: 16560,
        color: colors[0],
        x: -16,
        low: 198992,
        high: 215552
    }, {
        name: 'a.objectEach',
        id: '68',
        value: 16400,
        color: colors[0],
        x: -16,
        low: 215552,
        high: 231952
    }, {
        name: 'forEach',
        id: '90',
        value: 32800,
        color: colors[2],
        x: -16,
        low: 264848,
        high: 297648
    }, {
        name: 'renderUnsquish',
        id: '105',
        value: 32808,
        color: colors[0],
        x: -16,
        low: 297648,
        high: 330456
    }, {
        name: 'plotGroup',
        id: '140',
        value: 16464,
        color: colors[0],
        x: -16,
        low: 380852,
        high: 397316
    }, {
        name: 'init',
        id: '34',
        value: 16716,
        color: colors[0],
        x: -15,
        low: 32792,
        high: 49508
    }, {
        name: 'a.objectEach',
        id: '25',
        value: 16416,
        color: colors[0],
        x: -15,
        low: 65924,
        high: 82340
    }, {
        name: 'getSeriesExtremes',
        id: '79',
        value: 33304,
        color: colors[0],
        x: -15,
        low: 132000,
        high: 165304
    }, {
        name: 'setTickInterval',
        id: '81',
        value: 16632,
        color: colors[0],
        x: -15,
        low: 165304,
        high: 181936
    }, {
        name: 'forEach',
        id: '60',
        value: 16560,
        color: colors[2],
        x: -15,
        low: 198992,
        high: 215552
    }, {
        name: 'attr',
        id: '67',
        value: 16400,
        color: colors[0],
        x: -15,
        low: 215552,
        high: 231952
    }, {
        name: 'positionItems',
        id: '71',
        value: 16464,
        color: colors[0],
        x: -15,
        low: 231952,
        high: 248416
    }, {
        name: 'getOffset',
        id: '89',
        value: 65608,
        color: colors[0],
        x: -15,
        low: 264848,
        high: 330456
    }, {
        name: 'render',
        id: '136',
        value: 49948,
        color: colors[0],
        x: -15,
        low: 347368,
        high: 397316
    }, {
        name: 'I',
        id: '33',
        value: 16716,
        color: colors[0],
        x: -14,
        low: 32792,
        high: 49508
    }, {
        name: 'attr',
        id: '24',
        value: 16416,
        color: colors[0],
        x: -14,
        low: 65924,
        high: 82340
    }, {
        name: 'forEach',
        id: '29',
        value: 16412,
        color: colors[2],
        x: -14,
        low: 82340,
        high: 98752
    }, {
        name: 'setScale',
        id: '78',
        value: 49936,
        color: colors[0],
        x: -14,
        low: 132000,
        high: 181936
    }, {
        name: 'render',
        id: '123',
        value: 17056,
        color: colors[0],
        x: -14,
        low: 181936,
        high: 198992
    }, {
        name: 'render',
        id: '55',
        value: 49424,
        color: colors[0],
        x: -14,
        low: 198992,
        high: 248416
    }, {
        name: '~',
        id: '88',
        value: 65608,
        color: colors[0],
        x: -14,
        low: 264848,
        high: 330456
    }, {
        name: '~',
        id: '135',
        value: 66860,
        color: colors[0],
        x: -14,
        low: 330456,
        high: 397316
    }, {
        name: '~',
        id: '32',
        value: 16716,
        color: colors[0],
        x: -13,
        low: 32792,
        high: 49508
    }, {
        name: 'init',
        id: '23',
        value: 16416,
        color: colors[0],
        x: -13,
        low: 65924,
        high: 82340
    }, {
        name: '~',
        id: '28',
        value: 16412,
        color: colors[0],
        x: -13,
        low: 82340,
        high: 98752
    }, {
        name: '~',
        id: '77',
        value: 49936,
        color: colors[0],
        x: -13,
        low: 132000,
        high: 181936
    }, {
        name: '~',
        id: '122',
        value: 17056,
        color: colors[0],
        x: -13,
        low: 181936,
        high: 198992
    }, {
        name: 'init',
        id: '54',
        value: 49424,
        color: colors[0],
        x: -13,
        low: 198992,
        high: 248416
    }, {
        name: 'forEach',
        id: '87',
        value: 65608,
        color: colors[2],
        x: -13,
        low: 264848,
        high: 330456
    }, {
        name: 'forEach',
        id: '134',
        value: 66860,
        color: colors[2],
        x: -13,
        low: 330456,
        high: 397316
    }, {
        name: 'forEach',
        id: '31',
        value: 33116,
        color: colors[2],
        x: -12,
        low: 16392,
        high: 49508
    }, {
        name: 'a.SVGRenderer',
        id: '22',
        value: 16416,
        color: colors[0],
        x: -12,
        low: 65924,
        high: 82340
    }, {
        name: 'forEach',
        id: '27',
        value: 16412,
        color: colors[2],
        x: -12,
        low: 82340,
        high: 98752
    }, {
        name: 'forEach',
        id: '76',
        value: 66992,
        color: colors[2],
        x: -12,
        low: 132000,
        high: 198992
    }, {
        name: 'a.Legend',
        id: '53',
        value: 49424,
        color: colors[0],
        x: -12,
        low: 198992,
        high: 248416
    }, {
        name: 'setTitle',
        id: '48',
        value: 16432,
        color: colors[0],
        x: -12,
        low: 248416,
        high: 264848
    }, {
        name: 'getAxisMargins',
        id: '86',
        value: 65608,
        color: colors[0],
        x: -12,
        low: 264848,
        high: 330456
    }, {
        name: 'renderSeries',
        id: '133',
        value: 66860,
        color: colors[0],
        x: -12,
        low: 330456,
        high: 397316
    }, {
        name: 'createAxes',
        id: '30',
        value: 33116,
        color: colors[0],
        x: -11,
        low: 16392,
        high: 49508
    }, {
        name: 'getContainer',
        id: '21',
        value: 32832,
        color: colors[0],
        x: -11,
        low: 49508,
        high: 82340
    }, {
        name: 'resetMargins',
        id: '26',
        value: 16412,
        color: colors[0],
        x: -11,
        low: 82340,
        high: 98752
    }, {
        name: 'render',
        id: '47',
        value: 298564,
        color: colors[0],
        x: -11,
        low: 98752,
        high: 397316
    }, {
        name: 'firstRender',
        id: '20',
        value: 380924,
        color: colors[0],
        x: -10,
        low: 16392,
        high: 397316
    }, {
        name: '~',
        id: '8',
        value: 397316,
        color: colors[0],
        x: -9,
        low: 0,
        high: 397316
    }, {
        name: 'a.fireEvent',
        id: '7',
        value: 397316,
        color: colors[0],
        x: -8,
        low: 0,
        high: 397316
    }, {
        name: 'init',
        id: '6',
        value: 397316,
        color: colors[0],
        x: -7,
        low: 0,
        high: 397316
    }, {
        name: 'getArgs',
        id: '5',
        value: 397316,
        color: colors[0],
        x: -6,
        low: 0,
        high: 397316
    }, {
        name: 'a.Chart',
        id: '4',
        value: 397316,
        color: colors[0],
        x: -5,
        low: 0,
        high: 397316
    }, {
        name: 'a.chart',
        id: '3',
        value: 397316,
        color: colors[0],
        x: -4,
        low: 0,
        high: 397316
    }, {
        name: '~',
        id: '2',
        value: 397316,
        color: colors[0],
        x: -3,
        low: 0,
        high: 397316
    }, {
        name: '(root)',
        id: '1',
        value: 397316,
        color: colors[2],
        x: -2,
        low: 0,
        high: 397316
    }];

// Add new series type for the flame series

(function (H) {
    H.seriesType('flame', 'columnrange', {
        cursor: 'pointer',
        dataLabels: {
            enabled: true,
            format: '{point.name}',
            inside: true,
            align: 'center',
            crop: true,
            overflow: 'none',
            color: 'black',
            style: {
                textOutline: 'none',
                fontWeight: 'normal'
            }
        },
        point: {
            events: {
                click: function () {
                    const point = this,
                        chart = point.series.chart,
                        series = point.series,
                        xAxis = series.xAxis,
                        yAxis = series.yAxis;

                    xAxis.setExtremes(xAxis.min, point.x, false);
                    yAxis.setExtremes(point.low, point.high, false);

                    chart.showResetZoom();
                    chart.redraw();
                }
            }
        },
        pointPadding: 0,
        groupPadding: 0
    }, {
        drawDataLabels: H.seriesTypes.line.prototype.drawDataLabels
    });
}(Highcharts));

// Create the chart

const chart = Highcharts.chart('container', {
    chart: {
        inverted: true
    },
    title: {
        align: 'left',
        text: 'Flame chart (layout: flame)'
    },
    subtitle: {
        align: 'left',
        text: 'Highcharts chart rendering process'
    },
    legend: {
        enabled: false
    },
    xAxis: [{
        visible: false
    }, {
        visible: false,
        startOnTick: false,
        endOnTick: false,
        minPadding: 0,
        maxPadding: 0
    }],
    yAxis: [{
        visible: false
    }, {
        visible: false,
        min: 0,
        maxPadding: 0,
        startOnTick: false,
        endOnTick: false
    }],
    series: [{
        type: 'flame',
        data: data,
        yAxis: 1,
        xAxis: 1
    }, {
        visible: false,
        size: '100%',
        type: 'sunburst',
        data: sunburstData,
        allowDrillToNode: true,
        cursor: 'pointer',
        levels: [{
            level: 1,
            levelIsConstant: false,
            dataLabels: {
                enabled: false
            }
        }],
        dataLabels: {
            textPath: {
                attributes: {
                    dy: 5
                },
                enabled: true
            }
        }
    }],
    tooltip: {
        headerFormat: '',
        pointFormat: 'selfSize of <b>{point.name}</b> is <b>{point.value}</b>'
    }
});

// Set up buttons for the chart layout change

const icicleButton = document.getElementById('icicle'),
    flameButton = document.getElementById('flame'),
    sunburstButton = document.getElementById('sunburst'),
    allButtons = [icicleButton, flameButton, sunburstButton];

let activeButtonIndex = 1;

icicleButton.onclick = function () {
    chart.update({
        chart: {
            inverted: true
        },
        xAxis: [{}, {
            reversed: false
        }],
        title: {
            text: 'Flame chart (layout: icicle)'
        },
        series: [{
            visible: true
        }, {
            visible: false
        }]
    }, true, false, activeButtonIndex !== 2);

    allButtons[activeButtonIndex].disabled = false;
    icicleButton.disabled = true;
    activeButtonIndex = 0;
};

flameButton.onclick = function () {
    chart.update({
        chart: {
            inverted: true
        },
        xAxis: [{}, {
            reversed: true
        }],
        title: {
            text: 'Flame chart (layout: flame)'
        },
        series: [{
            visible: true
        }, {
            visible: false
        }]
    }, true, false, activeButtonIndex !== 2);

    allButtons[activeButtonIndex].disabled = false;
    flameButton.disabled = true;
    activeButtonIndex = 1;
};

sunburstButton.onclick = function () {
    chart.update({
        chart: {
            inverted: false
        },
        xAxis: [{}, {
            reversed: true
        }],
        title: {
            text: 'Flame chart (layout: sunburst)'
        },
        series: [{
            visible: false
        }, {
            visible: true
        }]
    }, true, false, false);

    allButtons[activeButtonIndex].disabled = false;
    sunburstButton.disabled = true;
    activeButtonIndex = 2;
};