Highcharts.setOptions({
    lang: {
        locale: 'ar',
        downloadJPEG: 'JPEG تحميل صورة',
        downloadPDF: 'PDF تحميل صورة',
        downloadPNG: 'PNG تحميل صورة',
        downloadSVG: 'SVF تحميل صورة',
        printChart: 'طباعة صورة'
    }
});

Highcharts.chart('container', {
    title: {
        text: 'متوسط درجة الحرارة الشهرية'
    },
    subtitle: {
        text: 'WorldClimate.com:المصدر '
    },
    xAxis: {
        reversed: true,
        categories: [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
        ]
    },
    yAxis: {
        title: {
            text: '(°C) درجة الحرارة '
        },
        opposite: true,
        plotLines: [
            {
                value: 0,
                width: 1,
                color: '#808080'
            }
        ]
    },
    tooltip: {
        valueSuffix: '°C'
    },
    legend: {
        layout: 'vertical',
        align: 'left',
        verticalAlign: 'middle',
        borderWidth: 0
    },
    series: [
        {
            name: 'طوكيو',
            data: [
                7.0, 6.9, 9.5, 14.5, 18.2, 21.5,
                25.2, 26.5, 23.3, 18.3, 13.9, 9.6
            ]
        },
        {
            name: 'نيويورك',
            data: [
                -0.2, 0.8, 5.7, 11.3, 17.0, 22.0,
                24.8, 24.1, 20.1, 14.1, 8.6, 2.5
            ]
        },
        {
            name: 'برلين',
            data: [
                -0.9, 0.6, 3.5, 8.4, 13.5, 17.0, 18.6, 17.9, 14.3, 9.0, 3.9, 1.0
            ]
        },
        {
            name: 'لندن',
            data: [
                3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 16.6, 14.2, 10.3, 6.6, 4.8
            ]
        }
    ]
});
