const chart = Highcharts.chart('container', {
    xAxis: {
        categories: [
            'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
            'Oct', 'Nov', 'Dec'
        ]
    },
    series: [{
        data: [
            29.9, 71.5, 106.4, 129.2, 144.0, 176.0,
            135.6, 148.5, 216.4, 194.1, 95.6, 54.4
        ]
    }]
});

// the button action
document.getElementById('button').addEventListener('click', e => {
    const extremes = chart.yAxis[0].getExtremes();

    chart.renderer.label(
        'dataMax: ' + extremes.dataMax + '<br/>' +
            'dataMin: ' + extremes.dataMin + '<br/>' +
            'max: ' + extremes.max + '<br/>' +
            'min: ' + extremes.min + '<br/>',
        100,
        100
    )
        .attr({
            fill: '#FCFFC5',
            zIndex: 8
        })
        .add();

    e.target.disabled = true;
});
