const chart = Highcharts.chart('container', {
    chart: {
        spacingTop: 3,
        spacingRight: 0,
        spacingBottom: 3,
        spacingLeft: 0
    },

    credits: {
        enabled: false
    },

    xAxis: {
        categories: [
            'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
            'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
        ]
    },

    series: [{
        data: [
            29.9, 71.5, 106.4, 129.2, 144.0, 176.0,
            135.6, 148.5, 216.4, 194.1, 95.6, 54.4
        ]
    }]

});

$('#resizer').resizable({
    // On resize, set the chart size to that of the resizer minus padding. If
    // your chart has a lot of data or other content, the redrawing might be
    // slow. In that case, we recommend that you use the 'stop' event instead of
    // 'resize'.
    resize: function () {
        chart.setSize(
            this.offsetWidth - 20,
            this.offsetHeight - 20,
            false
        );
    }
});
