const chart = Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Highcharts responsive chart'
    },
    subtitle: {
        text: 'Resize the frame to see the axes change'
    },
    xAxis: {
        categories: [
            'January', 'February', 'March', 'April', 'May', 'June',
            'July', 'August', 'September', 'October', 'November', 'December'
        ]
    },
    yAxis: {
        labels: {
            x: -15
        },
        title: {
            text: 'Items'
        }
    },
    series: [{
        name: 'Sales',
        data: [434, 523, 345, 785, 565, 843, 726, 590, 665, 434, 312, 432]
    }],
    responsive: {
        rules: [{
            condition: {
                maxWidth: 500
            },
            // Make the labels less space demanding on mobile
            chartOptions: {
                xAxis: {
                    labels: {
                        formatter: function () {
                            return this.value.charAt(0);
                        }
                    }
                },
                yAxis: {
                    labels: {
                        align: 'left',
                        x: 0,
                        y: -2
                    },
                    title: {
                        text: ''
                    }
                }
            }
        }]
    }
});

document.getElementById('small').addEventListener('click', () => {
    chart.setSize(400, 300);
});

document.getElementById('large').addEventListener('click', () => {
    chart.setSize(800, 300);
});
