let demoChart;

const reduced = window.matchMedia('(prefers-reduced-motion: reduce)').matches;

const baseColor = 'rgba(72,72,72,.2)';
const networklinkColor = '#000';
const baseTextColor = '#222';
const axisColor = '#333';
const streamLine = '#ebebeb';
let currentTimeout;

const colors = Highcharts.getOptions().colors;

// HERO CHART
Math.easeOutQuint = function (pos) {
    return (Math.pow((pos - 1), 5) + 1);
};


const fakeData = [
    { x: '1844-08-01', y: 20 },
    { x: '1848-08-01', y: 20 },
    { x: '1852-08-01', y: 20 },
    { x: '1856-08-01', y: 20 },
    { x: '1860-08-01', y: 20 },
    { x: '1864-08-01', y: 20 },
    { x: '1868-08-01', y: 20 },
    { x: '1872-08-01', y: 20 },
    { x: '1876-08-01', y: 20 },
    { x: '1880-08-01', y: 20 },
    { x: '1884-08-01', y: 20 },
    { x: '1888-08-01', y: 20 },
    { x: '1892-08-01', y: 20 },
    { x: '1896-08-01', y: 20 },
    { x: '1900-08-01', y: 20 },
    { x: '1904-08-01', y: 20 },
    { x: '1908-08-01', y: 20 },
    { x: '1912-08-01', y: 20 },
    { x: '1912-08-01', y: 20 },
    { x: '1916-08-01', y: 20 },
    { x: '1920-08-01', y: 20 },

    // /1924
    { x: -1449014400000, y: 20 },
    { x: -1322784000000, y: 20 },
    { x: -1196553600000, y: 20 },
    { x: -1070323200000, y: 20 },
    { x: -944092800000, y: 20 },
    { x: -817862400000, y: 20 },
    { x: -691632000000, y: 20 },
    { x: -565401600000, y: 20 },
    { x: -439171200000, y: 20 },
    { x: -312940800000, y: 20 },
    { x: -186710400000, y: 20 },
    { x: -60480000000, y: 20 },
    { x: 78847528000, y: 20 },
    { x: 191980800000, y: 20 },
    { x: 318211200000, y: 20 },
    { x: 444441600000, y: 20 },
    { x: 570672000000, y: 20 },
    // 1992
    { x: 696902400000, y: 20 },
    // 1994
    { x: 773072624000, y: 20 },
    { x: 899303024000, y: 20 },
    { x: 1025533424000, y: 20 },
    { x: 1151763824000, y: 20 },
    { x: 1277994224000, y: 20 },
    { x: 1404224624000, y: 20 },
    { x: 1580515200000, y: 20 }
];

const streamSeries = [{
    name: 'Finland',
    data:
    [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 4,
        3, 6, 0, 0, 6, 9, 7, 8, 10, 5, 5, 7, 9, 13, 7, 7, 6, 12, 7, 9, 5, 5
    ]
}, {
    name: 'Austria',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 4,
        2, 4, 0, 0, 8, 8, 11,
        6, 12, 11, 5, 6, 7, 1, 10, 21, 9, 17, 17, 23, 16, 17
    ]
}, {
    name: 'Sweden',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5,
        3, 7, 0, 0, 10, 4,
        10, 7, 7, 8, 4, 2, 4, 8, 6, 4, 3, 3, 7, 14, 11, 15
    ]
}, {
    name: 'Norway',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17,
        15, 10, 15, 0, 0, 10,
        16, 4, 6, 15, 14, 12, 7, 10, 9, 5, 20, 26, 25, 25, 19, 23, 26
    ]
}, {
    name: 'U.S.',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 6,
        12, 4, 0, 0, 9, 11,
        7, 10, 7, 7, 8, 10, 12, 8, 6, 11, 13, 13, 34, 25, 37, 28
    ]
}, {
    name: 'East Germany',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 5, 14, 19, 23, 24, 25, 0, 0, 0, 0, 0, 0, 0
    ]
}, {
    name: 'West Germany',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 7, 5, 10, 5, 4, 8, 0, 0, 0, 0, 0, 0, 0
    ]
}, {
    name: 'Germany',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 6, 0, 0, 0, 7, 2,
        8, 9, 0, 0, 0, 0, 0, 0, 26, 24, 29, 36, 29, 30, 19
    ]
}, {
    name: 'Netherlands',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
        2, 2, 9, 9, 6, 4, 0, 7, 4, 4, 11, 8, 9, 8, 24
    ]
}, {
    name: 'Italy',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 1, 2, 3,
        1, 4, 4, 5, 4, 2, 2, 5, 14, 20, 10, 13, 11, 5, 8
    ]
}, {
    name: 'Canada',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 7, 1, 0, 0, 3, 2, 3,
        4, 3, 3, 1, 3, 2, 4, 5, 7, 13, 15, 17, 24, 26, 25
    ]
}, {
    name: 'Switzerland',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
        1, 1, 3, 0, 0, 10, 2, 6,
        2, 0, 6, 10, 5, 5, 5, 15, 3, 9, 7, 11, 14, 9, 11
    ]
}, {
    name: 'Great Britain',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4,
        1, 0, 3, 0, 0, 2, 1, 0,
        0, 1, 0, 0, 1, 1, 1, 0, 0, 2, 1, 2, 1, 1, 4
    ]
}, {
    name: 'France',
    data: [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
        1, 1, 1, 0, 0, 5, 1, 0,
        3, 7, 9, 3, 1, 1, 3, 2, 9, 5, 8, 11, 9, 11, 15
    ]
}];

const streamDataArrays = [];

function addDates() {
    for (let ii = 0; ii < streamSeries.length; ++ii) {
        const tempArray = [];
        const data = streamSeries[ii].data;
        for (let kk = 0; kk < data.length; ++kk) {
            const xData = fakeData[kk].x;
            const yData = data[kk];
            tempArray.push({ x: xData, y: yData });
        }
        streamDataArrays.push(tempArray);
    }
}
addDates();

const categories =  {
    1844: { label: '' },
    1848: { label: '' },
    1852: { label: '' },
    1856: { label: '' },
    1860: { label: '' },
    1864: { label: '' },
    1868: { label: '' },
    1872: { label: '' },
    1876: { label: '' },
    1880: { label: '' },
    1884: { label: '' },
    1888: { label: '' },
    1892: { label: '' },
    1896: { label: '' },
    1900: { label: '' },
    1904: { label: '' },
    1908: { label: '' },
    1912: { label: '' },
    1916: { label: '' },
    1920: { label: '' },

    1924: { label: '1924 Chamonix' },
    1928: { label: '1928 St. Moritz' },
    1932: { label: '1932 Lake Placid' },
    1936: { label: '1936 Garmisch-Partenkirchen' },
    1940: { label: '1940 <i>Cancelled (Sapporo)</i>' },
    1944: { label: '1944 <i>Cancelled (Cortina d\'Ampezzo)</i>' },
    1948: { label: '1928 St. Moritz' },
    1952: { label: '1952 Oslo' },
    1956: { label: '1956 Cortina d\'Ampezzo' },
    1960: { label: '1960 Squaw Valley' },
    1964: { label: '1964 Innsbruck' },
    1968: { label: '1968 Grenoble' },
    1972: { label: '1972 Sapporo' },
    1976: { label: '1976 Innsbruck' },
    1980: { label: '1980 Lake Placid' },
    1984: { label: '1984 Sarajevo' },
    1988: { label: '1988 Calgary' },
    1992: { label: '1992 Albertville' },
    1994: { label: '1994 Lillehammer' },
    1998: { label: '1998 Nagano' },
    2002: { label: '2002 Salt Lake City' },
    2006: { label: '2006 Turin' },
    2010: { label: '2010 Vancouver' },
    2014: { label: '2014 Sochi' },
    2016: { label: '' },
    2020: { label: '' }
};


const splineSeries = [
    {
        type: 'spline',
        name: 'Import Europe',
        color: Highcharts.getOptions().colors[3],
        label: {
            enabled: false
        },
        lineWidth: 0,
        marker: {
            enabled: false

        },
        showInLegend: false,
        dashStyle: 'dash',
        data:
    [
        ['2002-05-01', 0.00],
        ['2002-06-01', 0.30],
        ['2002-07-01', 0.80],
        ['2002-08-01', 1.20],
        ['2002-09-01', 1.80],
        ['2002-10-01', 1.50],
        ['2002-11-01', 0.70],
        ['2002-12-01', 3.30],
        ['2002-13-01', 3.30],
        ['2003-02-01', 1.60],
        ['2003-03-01', 3.50],
        ['2003-04-01', 5.60],
        ['2003-05-01', 5.60],
        ['2003-06-01', 4.00],
        ['2003-07-01', 0.30],
        ['2003-08-01', -0.50],
        ['2003-09-01', -1.10],
        ['2003-10-01', -1.10],
        ['2003-11-01', -4.30],
        ['2003-12-01', -2.00],
        ['2003-13-01', -3.20],
        ['2004-02-01', -3.70],
        ['2004-03-01', -3.50],
        ['2004-04-01', -5.50],
        ['2004-05-01', -8.60],
        ['2004-06-01', -8.20],
        ['2004-07-01', -1.60],
        ['2004-08-01', -6.40],
        ['2004-09-01', -7.40],
        ['2004-10-01', -7.10],
        ['2004-11-01', 0.60],
        ['2004-12-01', 2.80],
        ['2004-13-01', 5.60],
        ['2005-02-01', 5.80],
        ['2005-03-01', 6.10],
        ['2005-04-01', 5.30],
        ['2005-05-01', 3.10],
        ['2005-06-01', 3.50],
        ['2005-07-01', 5.00],
        ['2005-08-01', 4.60],
        ['2005-09-01', 5.00],
        ['2005-10-01', 3.00],
        ['2005-11-01', 2.50],
        ['2005-12-01', 4.60],
        ['2005-13-01', 3.40],
        ['2006-02-01', 4.00],
        ['2006-03-01', 4.90],
        ['2006-04-01', 5.50],
        ['2006-05-01', 5.30],
        ['2006-06-01', 4.70],
        ['2006-07-01', 5.80],
        ['2006-08-01', 5.10],
        ['2006-09-01', 4.60],
        ['2006-10-01', 5.10],
        ['2006-11-01', 5.00],
        ['2006-12-01', 8.80],
        ['2006-13-01', 8.90],
        ['2007-02-01', 8.60],
        ['2007-03-01', 10.30],
        ['2007-04-01', 10.50],
        ['2007-05-01', 11.20],
        ['2007-06-01', 11.50],
        ['2007-07-01', 15.50],
        ['2007-08-01', 15.50],
        ['2007-09-01', 17.00],
        ['2007-10-01', 18.80],
        ['2007-11-01', 11.30],
        ['2007-12-01', 7.40],
        ['2007-13-01', 8.90],
        ['2008-02-01', 8.50],
        ['2008-03-01', 5.20],
        ['2008-04-01', 5.00],
        ['2008-05-01', 13.30],
        ['2008-06-01', 12.50],
        ['2008-07-01', 21.20],
        ['2008-08-01', 24.00],
        ['2008-09-01', 20.80],
        ['2008-10-01', 11.30],
        ['2008-11-01', 32.70],
        ['2008-12-01', 33.90],
        ['2008-13-01', 18.50],
        ['2009-02-01', 24.20],
        ['2009-03-01', 17.60],
        ['2009-04-01', 8.10],
        ['2009-05-01', -9.00],
        ['2009-06-01', -14.90],
        ['2009-07-01', -13.90],
        ['2009-08-01', -21.10],
        ['2009-09-01', -23.90],
        ['2009-10-01', -13.10],
        ['2009-11-01', -9.40],
        ['2009-12-01', -2.50],
        ['2009-13-01', 6.10],
        ['2010-02-01', -0.80],
        ['2010-03-01', 1.30],
        ['2010-04-01', 20.80],
        ['2010-05-01', 28.70],
        ['2010-06-01', 42.00],
        ['2010-07-01', 25.60],
        ['2010-08-01', 28.40],
        ['2010-09-01', 27.60],
        ['2010-10-01', 20.40],
        ['2010-11-01', 17.30],
        ['2010-12-01', 13.60],
        ['2010-13-01', 9.40],
        ['2011-02-01', 15.20],
        ['2011-03-01', 16.40],
        ['2011-04-01', 2.20],
        ['2011-05-01', -0.10],
        ['2011-06-01', 4.20],
        ['2011-07-01', 2.10],
        ['2011-08-01', 1.00],
        ['2011-09-01', 0.30],
        ['2011-10-01', 3.30],
        ['2011-11-01', -0.40],
        ['2011-12-01', -0.70],
        ['2011-13-01', 3.30],
        ['2012-02-01', 4.50],
        ['2012-03-01', 7.60],
        ['2012-04-01', 8.80],
        ['2012-05-01', 9.80],
        ['2012-06-01', 0.20],
        ['2012-07-01', 7.90],
        ['2012-08-01', 5.50],
        ['2012-09-01', 3.90],
        ['2012-10-01', 4.50],
        ['2012-11-01', 6.30],
        ['2012-12-01', 12.70],
        ['2012-13-01', 17.50],
        ['2013-02-01', 14.10],
        ['2013-03-01', 16.60],
        ['2013-04-01', 14.20],
        ['2013-05-01', 11.60],
        ['2013-06-01', 12.40],
        ['2013-07-01', 7.40],
        ['2013-08-01', 6.40],
        ['2013-09-01', 6.20],
        ['2013-10-01', 10.50],
        ['2013-11-01', 10.30],
        ['2013-12-01', 10.30],
        ['2013-13-01', 5.40],
        ['2014-02-01', 2.80],
        ['2014-03-01', 3.60],
        ['2014-04-01', 3.00],
        ['2014-05-01', 0.10],
        ['2014-06-01', 4.30],
        ['2014-07-01', -1.10],
        ['2014-08-01', 1.80],
        ['2014-09-01', 3.10],
        ['2014-10-01', 2.00],
        ['2014-11-01', 0.80],
        ['2014-12-01', 1.20],
        ['2014-13-01', 4.50],
        ['2015-02-01', 8.60],
        ['2015-03-01', 8.10],
        ['2015-04-01', 9.50],
        ['2015-05-01', 5.00],
        ['2015-06-01', 4.60],
        ['2015-07-01', 2.40],
        ['2015-08-01', 0.70],
        ['2015-09-01', -1.50],
        ['2015-10-01', -1.10],
        ['2015-11-01', 0.40],
        ['2015-12-01', 2.60],
        ['2015-13-01', -9.90],
        ['2016-02-01', -3.00],
        ['2016-03-01', -2.20],
        ['2016-04-01', -9.70],
        ['2016-05-01', 0.30],
        ['2016-06-01', -2.60],
        ['2016-07-01', -7.40],
        ['2016-08-01', -8.90],
        ['2016-09-01', -8.40],
        ['2016-10-01', -3.10],
        ['2016-11-01', -0.30],
        ['2016-12-01', -6.30],
        ['2016-13-01', -4.40],
        ['2017-02-01', -5.60],
        ['2017-03-01', -8.60],
        ['2017-04-01', -5.90],
        ['2017-05-01', -17.10],
        ['2017-06-01', -14.40],
        ['2017-07-01', -11.90],
        ['2017-08-01', -9.60],
        ['2017-09-01', -13.50],
        ['2017-10-01', -6.50],
        ['2017-11-01', -3.90],
        ['2017-12-01', 0.40],
        ['2017-13-01', 10.30],
        ['2018-02-01', 8.60],
        ['2018-03-01', 10.30],
        ['2018-04-01', 3.10],
        ['2018-05-01', 16.90],
        ['2018-06-01', 7.10],
        ['2018-07-01', 10.90],
        ['2018-08-01', 8.00],
        ['2018-09-01', 8.30],
        ['2018-10-01', 9.60],
        ['2018-11-01', 2.50],
        ['2018-12-01', 1.50],
        ['2018-13-01', 1.30],
        ['2019-02-01', -2.20],
        ['2019-03-01', -5.60],
        ['2019-04-01', 1.10],
        ['2019-05-01', -14.70],
        ['2019-06-01', -3.00],
        ['2019-07-01', -3.50],
        ['2019-08-01', -7.90],
        ['2019-09-01', -7.80],
        {
            x: '2019-10-01',
            y: -8.90,
            marker: { enable: false, symbol: 'circle', r: 5 }
        },
        ['2019-11-01', -11.30],
        ['2019-12-01', -6.30],
        ['2019-13-01', -6.50],
        ['2020-02-01', -9.50],
        ['2020-03-01', -7.50],
        ['2020-04-01', -11.90],
        ['2020-05-01', -26.30]
    ]
    },
    {
        type: 'spline',
        name: 'Import Asia',
        marker: {
            enabled: false
        },
        label: {
            enabled: false
        },
        showInLegend: false,
        id: 'importAsia',
        dashStyle: 'dotdash',
        color: Highcharts.getOptions().colors[7],
        data:
    [
        ['2002-05-01', 0.00],
        ['2002-06-01', 0.30],
        ['2002-07-01', 0.80],
        ['2002-08-01', 1.20],
        ['2002-09-01', 1.80],
        ['2002-10-01', 1.50],
        ['2002-11-01', 0.70],
        ['2002-12-01', 3.30],
        ['2002-13-01', 3.30],
        ['2003-02-01', 1.60],
        ['2003-03-01', 3.50],
        ['2003-04-01', 5.60],
        ['2003-05-01', 5.60],
        ['2003-06-01', 4.00],
        ['2003-07-01', 0.30],
        ['2003-08-01', -0.50],
        ['2003-09-01', -1.10],
        ['2003-10-01', -1.10],
        ['2003-11-01', -4.30],
        ['2003-12-01', -2.00],
        ['2003-13-01', -3.20],
        ['2004-02-01', -3.70],
        ['2004-03-01', -3.50],
        ['2004-04-01', -5.50],
        ['2004-05-01', -8.60],
        ['2004-06-01', -8.20],
        ['2004-07-01', -1.60],
        ['2004-08-01', -6.40],
        ['2004-09-01', -7.40],
        ['2004-10-01', -7.10],
        ['2004-11-01', 0.60],
        ['2004-12-01', 2.80],
        ['2004-13-01', 5.60],
        ['2005-02-01', 5.80],
        ['2005-03-01', 6.10],
        ['2005-04-01', 5.30],
        ['2005-05-01', 3.10],
        ['2005-06-01', 3.50],
        ['2005-07-01', 5.00],
        ['2005-08-01', 4.60],
        ['2005-09-01', 5.00],
        ['2005-10-01', 3.00],
        ['2005-11-01', 2.50],
        ['2005-12-01', 4.60],
        ['2005-13-01', 3.40],
        ['2006-02-01', 4.00],
        ['2006-03-01', 4.90],
        ['2006-04-01', 5.50],
        ['2006-05-01', 5.30],
        ['2006-06-01', 4.70],
        ['2006-07-01', 5.80],
        ['2006-08-01', 5.10],
        ['2006-09-01', 4.60],
        ['2006-10-01', 5.10],
        ['2006-11-01', 5.00],
        ['2006-12-01', 8.80],
        ['2006-13-01', 8.90],
        ['2007-02-01', 8.60],
        ['2007-03-01', 10.30],
        ['2007-04-01', 10.50],
        ['2007-05-01', 11.20],
        ['2007-06-01', 11.50],
        ['2007-07-01', 15.50],
        ['2007-08-01', 15.50],
        ['2007-09-01', 17.00],
        ['2007-10-01', 18.80],
        ['2007-11-01', 11.30],
        ['2007-12-01', 7.40],
        ['2007-13-01', 8.90],
        ['2008-02-01', 8.50],
        ['2008-03-01', 5.20],
        ['2008-04-01', 5.00],
        ['2008-05-01', 13.30],
        ['2008-06-01', 12.50],
        ['2008-07-01', 21.20],
        ['2008-08-01', 24.00],
        ['2008-09-01', 20.80],
        ['2008-10-01', 11.30],
        ['2008-11-01', 32.70],
        ['2008-12-01', 33.90],
        ['2008-13-01', 18.50],
        ['2009-02-01', 24.20],
        ['2009-03-01', 17.60],
        ['2009-04-01', 8.10],
        ['2009-05-01', -9.00],
        ['2009-06-01', -14.90],
        ['2009-07-01', -13.90],
        ['2009-08-01', -21.10],
        ['2009-09-01', -23.90],
        ['2009-10-01', -13.10],
        ['2009-11-01', -9.40],
        ['2009-12-01', -2.50],
        ['2009-13-01', 6.10],
        ['2010-02-01', -0.80],
        ['2010-03-01', 1.30],
        ['2010-04-01', 20.80],
        ['2010-05-01', 28.70],
        ['2010-06-01', 42.00],
        ['2010-07-01', 25.60],
        ['2010-08-01', 28.40],
        ['2010-09-01', 27.60],
        ['2010-10-01', 20.40],
        ['2010-11-01', 17.30],
        ['2010-12-01', 13.60],
        ['2010-13-01', 9.40],
        ['2011-02-01', 15.20],
        ['2011-03-01', 16.40],
        ['2011-04-01', 2.20],
        ['2011-05-01', -0.10],
        ['2011-06-01', 4.20],
        ['2011-07-01', 2.10],
        ['2011-08-01', 1.00],
        ['2011-09-01', 0.30],
        ['2011-10-01', 3.30],
        ['2011-11-01', -0.40],
        ['2011-12-01', -0.70],
        ['2011-13-01', 3.30],
        ['2012-02-01', 4.50],
        ['2012-03-01', 7.60],
        ['2012-04-01', 8.80],
        ['2012-05-01', 9.80],
        ['2012-06-01', 0.20],
        ['2012-07-01', 7.90],
        ['2012-08-01', 5.50],
        ['2012-09-01', 3.90],
        ['2012-10-01', 4.50],
        ['2012-11-01', 6.30],
        ['2012-12-01', 12.70],
        ['2012-13-01', 17.50],
        ['2013-02-01', 14.10],
        ['2013-03-01', 16.60],
        ['2013-04-01', 14.20],
        ['2013-05-01', 11.60],
        ['2013-06-01', 12.40],
        ['2013-07-01', 7.40],
        ['2013-08-01', 6.40],
        ['2013-09-01', 6.20],
        ['2013-10-01', 10.50],
        ['2013-11-01', 10.30],
        ['2013-12-01', 10.30],
        ['2013-13-01', 5.40],
        ['2014-02-01', 2.80],
        ['2014-03-01', 3.60],
        ['2014-04-01', 3.00],
        ['2014-05-01', 0.10],
        ['2014-06-01', 4.30],
        ['2014-07-01', -1.10],
        ['2014-08-01', 1.80],
        ['2014-09-01', 3.10],
        ['2014-10-01', 2.00],
        ['2014-11-01', 0.80],
        ['2014-12-01', 1.20],
        ['2014-13-01', 4.50],
        ['2015-02-01', 8.60],
        ['2015-03-01', 8.10],
        ['2015-04-01', 9.50],
        ['2015-05-01', 5.00],
        ['2015-06-01', 4.60],
        ['2015-07-01', 2.40],
        ['2015-08-01', 0.70],
        ['2015-09-01', -1.50],
        ['2015-10-01', -1.10],
        ['2015-11-01', 0.40],
        ['2015-12-01', 2.60],
        ['2015-13-01', -9.90],
        ['2016-02-01', -3.00],
        ['2016-03-01', -2.20],
        ['2016-04-01', -9.70],
        ['2016-05-01', 0.30],
        ['2016-06-01', -2.60],
        ['2016-07-01', -7.40],
        ['2016-08-01', -8.90],
        ['2016-09-01', -8.40],
        ['2016-10-01', -3.10],
        ['2016-11-01', -0.30],
        ['2016-12-01', -6.30],
        ['2016-13-01', -4.40],
        ['2017-02-01', -5.60],
        ['2017-03-01', -8.60],
        ['2017-04-01', -5.90],
        ['2017-05-01', -17.10],
        ['2017-06-01', -14.40],
        ['2017-07-01', -11.90],
        ['2017-08-01', -9.60],
        ['2017-09-01', -13.50],
        ['2017-10-01', -6.50],
        ['2017-11-01', -3.90],
        ['2017-12-01', 0.40],
        ['2017-13-01', 10.30],
        ['2018-02-01', 8.60],
        ['2018-03-01', 10.30],
        ['2018-04-01', 3.10],
        ['2018-05-01', 16.90],
        ['2018-06-01', 7.10],
        ['2018-07-01', 10.90],
        ['2018-08-01', 8.00],
        ['2018-09-01', 8.30],
        ['2018-10-01', 9.60],
        ['2018-11-01', 2.50],
        ['2018-12-01', 1.50],
        ['2018-13-01', 1.30],
        ['2019-02-01', -2.20],
        ['2019-03-01', -5.60],
        ['2019-04-01', 1.10],
        ['2019-05-01', -14.70],
        ['2019-06-01', -3.00],
        ['2019-07-01', -3.50],
        ['2019-08-01', -7.90],
        ['2019-09-01', -7.80],
        ['2019-10-01', -8.90],
        ['2019-11-01', -11.30],
        ['2019-12-01', -6.30],
        ['2019-13-01', -6.50],
        ['2020-02-01', -9.50],
        ['2020-03-01', -7.50],
        ['2020-04-01', -11.90],
        ['2020-05-01', -26.30]
    ]
    },
    {
        type: 'spline',
        marker: {
            enabled: false
        },
        label: {
            enabled: false
        },
        showInLegend: false,
        dashStyle: 'longDash',
        color: Highcharts.getOptions().colors[7],
        name: 'Export air passenger fares',
        data: [
            ['2002-05-01', -0.20],
            ['2002-06-01', -6.10],
            ['2002-07-01', -6.10],
            ['2002-08-01', -5.00],
            ['2002-09-01', -8.60],
            ['2002-10-01', -10.40],
            ['2002-11-01', -7.50],
            ['2002-12-01', -9.00],
            ['2002-13-01', -9.00],
            ['2003-02-01', -10.20],
            ['2003-03-01', -3.00],
            ['2003-04-01', -1.60],
            ['2003-05-01', -5.70],
            ['2003-06-01', -0.80],
            ['2003-07-01', 1.10],
            ['2003-08-01', 6.80],
            ['2003-09-01', 7.60],
            ['2003-10-01', 3.70],
            ['2003-11-01', 3.40],
            ['2003-12-01', 3.80],
            ['2003-13-01', 1.70],
            ['2004-02-01', 8.90],
            ['2004-03-01', 0.00],
            ['2004-04-01', 0.40],
            ['2004-05-01', 5.90],
            ['2004-06-01', 7.60],
            ['2004-07-01', 7.40],
            ['2004-08-01', 7.50],
            ['2004-09-01', 7.40],
            ['2004-10-01', 5.20],
            ['2004-11-01', 4.40],
            ['2004-12-01', 5.30],
            ['2004-13-01', 6.00],
            ['2005-02-01', -0.60],
            ['2005-03-01', 2.10],
            ['2005-04-01', 0.90],
            ['2005-05-01', 2.30],
            ['2005-06-01', -1.30],
            ['2005-07-01', -2.50],
            ['2005-08-01', -2.60],
            ['2005-09-01', -3.70],
            ['2005-10-01', -0.80],
            ['2005-11-01', 0.00],
            ['2005-12-01', -1.10],
            ['2005-13-01', 0.60],
            ['2006-02-01', 0.60],
            ['2006-03-01', 2.50],
            ['2006-04-01', 1.90],
            ['2006-05-01', -1.10],
            ['2006-06-01', 4.10],
            ['2006-07-01', 4.50],
            ['2006-08-01', 2.30],
            ['2006-09-01', 4.60],
            ['2006-10-01', 6.10],
            ['2006-11-01', 9.10],
            ['2006-12-01', 8.40],
            ['2006-13-01', 7.40],
            ['2007-02-01', 6.60],
            ['2007-03-01', 9.80],
            ['2007-04-01', 9.80],
            ['2007-05-01', 1.40],
            ['2007-06-01', 0.00],
            ['2007-07-01', -0.50],
            ['2007-08-01', -0.10],
            ['2007-09-01', 0.20],
            ['2007-10-01', 1.80],
            ['2007-11-01', 2.60],
            ['2007-12-01', 5.70],
            ['2007-13-01', 3.40],
            ['2008-02-01', 3.60],
            ['2008-03-01', 3.80],
            ['2008-04-01', 5.10],
            ['2008-05-01', 18.80],
            ['2008-06-01', 22.50],
            ['2008-07-01', 27.10],
            ['2008-08-01', 27.20],
            ['2008-09-01', 25.00],
            ['2008-10-01', 10.90],
            ['2008-11-01', 4.60],
            ['2008-12-01', 1.90],
            ['2008-13-01', 23.10],
            ['2009-02-01', -0.50],
            ['2009-03-01', -5.10],
            ['2009-04-01', -9.10],
            ['2009-05-01', -11.10],
            ['2009-06-01', -20.20],
            ['2009-07-01', -22.70],
            ['2009-08-01', -21.20],
            ['2009-09-01', -16.80],
            ['2009-10-01', -12.30],
            ['2009-11-01', -7.20],
            ['2009-12-01', 0.60],
            ['2009-13-01', -7.20],
            ['2010-02-01', 3.10],
            ['2010-03-01', 8.50],
            ['2010-04-01', 15.00],
            ['2010-05-01', 20.60],
            ['2010-06-01', 22.50],
            ['2010-07-01', 23.40],
            ['2010-08-01', 18.40],
            ['2010-09-01', 14.50],
            ['2010-10-01', 21.40],
            ['2010-11-01', 24.70],
            ['2010-12-01', 20.40],
            ['2010-13-01', 16.70],
            ['2011-02-01', 20.60],
            ['2011-03-01', 19.80],
            ['2011-04-01', 20.00],
            ['2011-05-01', 18.20],
            ['2011-06-01', 22.70],
            ['2011-07-01', 19.30],
            ['2011-08-01', 22.30],
            ['2011-09-01', 23.80],
            ['2011-10-01', 17.40],
            ['2011-11-01', 14.00],
            ['2011-12-01', 10.50],
            ['2011-13-01', 9.20],
            ['2012-02-01', 13.30],
            ['2012-03-01', 12.10],
            ['2012-04-01', 9.30],
            ['2012-05-01', 5.90],
            ['2012-06-01', 0.80],
            ['2012-07-01', 3.80],
            ['2012-08-01', -1.00],
            ['2012-09-01', -5.20],
            ['2012-10-01', -6.40],
            ['2012-11-01', -6.90],
            ['2012-12-01', -2.30],
            ['2012-13-01', -1.00],
            ['2013-02-01', -8.50],
            ['2013-03-01', -7.80],
            ['2013-04-01', -5.80],
            ['2013-05-01', -7.70],
            ['2013-06-01', -3.50],
            ['2013-07-01', -0.40],
            ['2013-08-01', -0.20],
            ['2013-09-01', 0.40],
            ['2013-10-01', 3.50],
            ['2013-11-01', 3.10],
            ['2013-12-01', 0.80],
            ['2013-13-01', 1.40],
            ['2014-02-01', 2.80],
            ['2014-03-01', 1.20],
            ['2014-04-01', 0.50],
            ['2014-05-01', 3.70],
            ['2014-06-01', 2.10],
            ['2014-07-01', -2.30],
            ['2014-08-01', -2.10],
            ['2014-09-01', 0.10],
            ['2014-10-01', 0.90],
            ['2014-11-01', 4.30],
            ['2014-12-01', -1.30],
            ['2014-13-01', -0.70],
            ['2015-02-01', -1.70],
            ['2015-03-01', 0.20],
            ['2015-04-01', -1.00],
            ['2015-05-01', -4.80],
            ['2015-06-01', -5.50],
            ['2015-07-01', -5.70],
            ['2015-08-01', -4.40],
            ['2015-09-01', -5.40],
            ['2015-10-01', -9.10],
            ['2015-11-01', -13.00],
            ['2015-12-01', -11.30],
            ['2015-13-01', -8.40],
            ['2016-02-01', -13.80],
            ['2016-03-01', -11.70],
            ['2016-04-01', -11.20],
            ['2016-05-01', -12.40],
            ['2016-06-01', -9.50],
            ['2016-07-01', -4.60],
            ['2016-08-01', -4.70],
            ['2016-09-01', -4.10],
            ['2016-10-01', -0.40],
            ['2016-11-01', 3.70],
            ['2016-12-01', 8.40],
            ['2016-13-01', 2.80],
            ['2017-02-01', 8.60],
            ['2017-03-01', 8.00],
            ['2017-04-01', 9.30],
            ['2017-05-01', 12.70],
            ['2017-06-01', 8.30],
            ['2017-07-01', 6.80],
            ['2017-08-01', 5.80],
            ['2017-09-01', 3.00],
            ['2017-10-01', 3.00],
            ['2017-11-01', 0.40],
            ['2017-12-01', 0.40],
            ['2017-13-01', 2.70],
            ['2018-02-01', 1.20],
            ['2018-03-01', 3.50],
            ['2018-04-01', 3.40],
            ['2018-05-01', 2.20],
            ['2018-06-01', -1.50],
            ['2018-07-01', -1.20],
            ['2018-08-01', -1.00],
            ['2018-09-01', -2.70],
            ['2018-10-01', -2.60],
            ['2018-11-01', -2.40],
            ['2018-12-01', -0.90],
            ['2018-13-01', -1.20],
            ['2019-02-01', -5.40],
            ['2019-03-01', -5.10],
            ['2019-04-01', -7.80],
            ['2019-05-01', -6.90],
            ['2019-06-01', -1.20],
            ['2019-07-01', -1.40],
            ['2019-08-01', 2.30],
            ['2019-09-01', 1.80],
            ['2019-10-01', -0.80],
            ['2019-11-01', 1.40],
            ['2019-12-01', -0.90],
            ['2019-13-01', 4.20],
            ['2020-02-01', 1.10],
            ['2020-03-01', 4.70],
            ['2020-04-01', -2.50],
            ['2020-05-01', -6.90]
        ]
    },
    {
        type: 'spline',
        dashStyle: 'solid',
        label: {
            enabled: false
        },
        showInLegend: false,
        color: Highcharts.getOptions().colors[7],
        name: 'Export air passenger fares',
        data: [
            ['2002-05-01', 0.50],
            ['2002-06-01', 1.90],
            ['2002-07-01', 2.80],
            ['2002-08-01', 7.50],
            ['2002-09-01', 10.00],
            ['2002-10-01', 5.50],
            ['2002-11-01', 2.30],
            ['2002-12-01', 4.50],
            ['2002-13-01', 4.90],
            ['2003-02-01', 9.20],
            ['2003-03-01', 9.00],
            ['2003-04-01', 11.20],
            ['2003-05-01', 10.90],
            ['2003-06-01', 10.50],
            ['2003-07-01', 13.40],
            ['2003-08-01', 11.90],
            ['2003-09-01', 10.20],
            ['2003-10-01', 9.20],
            ['2003-11-01', 15.10],
            ['2003-12-01', 14.80],
            ['2003-13-01', 14.70],
            ['2004-02-01', 15.70],
            ['2004-03-01', 15.10],
            ['2004-04-01', 13.70],
            ['2004-05-01', 13.70],
            ['2004-06-01', 8.30],
            ['2004-07-01', 5.80],
            ['2004-08-01', 4.90],
            ['2004-09-01', 9.30],
            ['2004-10-01', 10.30],
            ['2004-11-01', 6.20],
            ['2004-12-01', 9.80],
            ['2004-13-01', 13.20],
            ['2005-02-01', 10.30],
            ['2005-03-01', 9.10],
            ['2005-04-01', 10.60],
            ['2005-05-01', 7.80],
            ['2005-06-01', 15.50],
            ['2005-07-01', 10.00],
            ['2005-08-01', 13.70],
            ['2005-09-01', 11.00],
            ['2005-10-01', 7.20],
            ['2005-11-01', 6.30],
            ['2005-12-01', -1.60],
            ['2005-13-01', -4.30],
            ['2006-02-01', -6.00],
            ['2006-03-01', 0.20],
            ['2006-04-01', -4.00],
            ['2006-05-01', -1.30],
            ['2006-06-01', -2.50],
            ['2006-07-01', 2.30],
            ['2006-08-01', -0.50],
            ['2006-09-01', -0.50],
            ['2006-10-01', 2.10],
            ['2006-11-01', 3.00],
            ['2006-12-01', 6.40],
            ['2006-13-01', 7.00],
            ['2007-02-01', 6.90],
            ['2007-03-01', 3.20],
            ['2007-04-01', 7.20],
            ['2007-05-01', 9.30],
            ['2007-06-01', 7.50],
            ['2007-07-01', 5.70],
            ['2007-08-01', 5.70],
            ['2007-09-01', 3.90],
            ['2007-10-01', 8.60],
            ['2007-11-01', 10.00],
            ['2007-12-01', 11.50],
            ['2007-13-01', 13.40],
            ['2008-02-01', 14.30],
            ['2008-03-01', 9.80],
            ['2008-04-01', 11.60],
            ['2008-05-01', 6.30],
            ['2008-06-01', 6.00],
            ['2008-07-01', 16.40],
            ['2008-08-01', 17.60],
            ['2008-09-01', 20.60],
            ['2008-10-01', 11.20],
            ['2008-11-01', 5.50],
            ['2008-12-01', 5.20],
            ['2008-13-01', 5.70],
            ['2009-02-01', 1.90],
            ['2009-03-01', -3.50],
            ['2009-04-01', -9.40],
            ['2009-05-01', -11.00],
            ['2009-06-01', -15.50],
            ['2009-07-01', -19.40],
            ['2009-08-01', -21.80],
            ['2009-09-01', -19.50],
            ['2009-10-01', -17.80],
            ['2009-11-01', -14.40],
            ['2009-12-01', -11.30],
            ['2009-13-01', -5.20],
            ['2010-02-01', -4.40],
            ['2010-03-01', 5.10],
            ['2010-04-01', 11.30],
            ['2010-05-01', 19.20],
            ['2010-06-01', 22.00],
            ['2010-07-01', 27.60],
            ['2010-08-01', 30.50],
            ['2010-09-01', 21.20],
            ['2010-10-01', 21.90],
            ['2010-11-01', 21.20],
            ['2010-12-01', 15.00],
            ['2010-13-01', 8.30],
            ['2011-02-01', 13.20],
            ['2011-03-01', 4.10],
            ['2011-04-01', 9.60],
            ['2011-05-01', 8.10],
            ['2011-06-01', 12.20],
            ['2011-07-01', 5.80],
            ['2011-08-01', 10.20],
            ['2011-09-01', 18.10],
            ['2011-10-01', 11.90],
            ['2011-11-01', 11.90],
            ['2011-12-01', 13.00],
            ['2011-13-01', 13.10],
            ['2012-02-01', 9.50],
            ['2012-03-01', 15.60],
            ['2012-04-01', 7.10],
            ['2012-05-01', 6.20],
            ['2012-06-01', 8.40],
            ['2012-07-01', 8.70],
            ['2012-08-01', 3.80],
            ['2012-09-01', -3.60],
            ['2012-10-01', -2.50],
            ['2012-11-01', -0.70],
            ['2012-12-01', -0.70],
            ['2012-13-01', -2.50],
            ['2013-02-01', 2.60],
            ['2013-03-01', -1.40],
            ['2013-04-01', 0.10],
            ['2013-05-01', -3.20],
            ['2013-06-01', -4.40],
            ['2013-07-01', -3.40],
            ['2013-08-01', -4.70],
            ['2013-09-01', -3.60],
            ['2013-10-01', -1.20],
            ['2013-11-01', -3.60],
            ['2013-12-01', -3.10],
            ['2013-13-01', 3.20],
            ['2014-02-01', -1.60],
            ['2014-03-01', -6.30],
            ['2014-04-01', -3.60],
            ['2014-05-01', 1.90],
            ['2014-06-01', -1.20],
            ['2014-07-01', 0.40],
            ['2014-08-01', 0.50],
            ['2014-09-01', 3.90],
            ['2014-10-01', 1.80],
            ['2014-11-01', 1.60],
            ['2014-12-01', -1.80],
            ['2014-13-01', -2.00],
            ['2015-02-01', -4.00],
            ['2015-03-01', -5.10],
            ['2015-04-01', -7.80],
            ['2015-05-01', -13.80],
            ['2015-06-01', -13.10],
            ['2015-07-01', -14.20],
            ['2015-08-01', -14.20],
            ['2015-09-01', -17.50],
            ['2015-10-01', -17.00],
            ['2015-11-01', -15.60],
            ['2015-12-01', -11.50],
            ['2015-13-01', -14.60],
            ['2016-02-01', -11.00],
            ['2016-03-01', -10.90],
            ['2016-04-01', -4.90],
            ['2016-05-01', -7.20],
            ['2016-06-01', -10.20],
            ['2016-07-01', -9.20],
            ['2016-08-01', -9.90],
            ['2016-09-01', -7.10],
            ['2016-10-01', -6.70],
            ['2016-11-01', -3.00],
            ['2016-12-01', 1.40],
            ['2016-13-01', 4.70],
            ['2017-02-01', 0.50],
            ['2017-03-01', 2.70],
            ['2017-04-01', -0.50],
            ['2017-05-01', -0.50],
            ['2017-06-01', 1.90],
            ['2017-07-01', 2.20],
            ['2017-08-01', 4.40],
            ['2017-09-01', -2.20],
            ['2017-10-01', 1.00],
            ['2017-11-01', 2.00],
            ['2017-12-01', -1.60],
            ['2017-13-01', -5.80],
            ['2018-02-01', -1.90],
            ['2018-03-01', 2.30],
            ['2018-04-01', 1.70],
            ['2018-05-01', 4.10],
            ['2018-06-01', 1.40],
            ['2018-07-01', 1.50],
            ['2018-08-01', -1.80],
            ['2018-09-01', -3.30],
            ['2018-10-01', 2.40],
            ['2018-11-01', -2.90],
            ['2018-12-01', -3.30],
            ['2018-13-01', -5.00],
            ['2019-02-01', -2.90],
            ['2019-03-01', -4.00],
            ['2019-04-01', -5.80],
            ['2019-05-01', -3.50],
            ['2019-06-01', -2.10],
            ['2019-07-01', -3.00],
            ['2019-08-01', -1.40],
            ['2019-09-01', -0.80],
            ['2019-10-01', -3.20],
            ['2019-11-01', -3.60],
            ['2019-12-01', -0.50],
            ['2019-13-01', -2.60],
            ['2020-02-01', -2.20],
            ['2020-03-01', -2.60],
            ['2020-04-01', -8.10],
            ['2020-05-01', -14.10]
        ]
    },
    {
        type: 'spline',
        name: 'Export Europe',
        label: {
            enabled: false
        },
        showInLegend: false,
        color: Highcharts.getOptions().colors[0],
        dashStyle: 'dash',
        data: [
            ['2002-05-01', 5.00],
            ['2002-06-01', 6.80],
            ['2002-07-01', 9.00],
            ['2002-08-01', 10.80],
            ['2002-09-01', 11.10],
            ['2002-10-01', 8.30],
            ['2002-11-01', 8.00],
            ['2002-12-01', 10.30],
            ['2002-13-01', 11.40],
            ['2003-02-01', 14.20],
            ['2003-03-01', 15.20],
            ['2003-04-01', 18.20],
            ['2003-05-01', 17.40],
            ['2003-06-01', 19.30],
            ['2003-07-01', 25.80],
            ['2003-08-01', 23.90],
            ['2003-09-01', 19.30],
            ['2003-10-01', 15.40],
            ['2003-11-01', 21.40],
            ['2003-12-01', 19.20],
            ['2003-13-01', 18.50],
            ['2004-02-01', 19.20],
            ['2004-03-01', 20.80],
            ['2004-04-01', 19.80],
            ['2004-05-01', 13.20],
            ['2004-06-01', 6.70],
            ['2004-07-01', 2.70],
            ['2004-08-01', -1.10],
            ['2004-09-01', -1.00],
            ['2004-10-01', 7.90],
            ['2004-11-01', 3.80],
            ['2004-12-01', 9.70],
            ['2004-13-01', 13.60],
            ['2005-02-01', 10.60],
            ['2005-03-01', 6.00],
            ['2005-04-01', 8.00],
            ['2005-05-01', 8.10],
            ['2005-06-01', 18.80],
            ['2005-07-01', 10.60],
            ['2005-08-01', 18.60],
            ['2005-09-01', 19.10],
            ['2005-10-01', 9.10],
            ['2005-11-01', 6.50],
            ['2005-12-01', -5.00],
            ['2005-13-01', -9.40],
            ['2006-02-01', -11.60],
            ['2006-03-01', -4.60],
            ['2006-04-01', -10.50],
            ['2006-05-01', 0.50],
            ['2006-06-01', -4.60],
            ['2006-07-01', 1.70],
            ['2006-08-01', -2.20],
            ['2006-09-01', 0.30],
            ['2006-10-01', 6.00],
            ['2006-11-01', 7.10],
            ['2006-12-01', 11.00],
            ['2006-13-01', 12.70],
            ['2007-02-01', 14.20],
            ['2007-03-01', 8.00],
            ['2007-04-01', 12.90],
            ['2007-05-01', 11.10],
            ['2007-06-01', 10.10],
            ['2007-07-01', 6.30],
            ['2007-08-01', 6.30],
            ['2007-09-01', 6.70],
            ['2007-10-01', 7.30],
            ['2007-11-01', 7.80],
            ['2007-12-01', 9.60],
            ['2007-13-01', 12.60],
            ['2008-02-01', 11.50],
            ['2008-03-01', 7.90],
            ['2008-04-01', 8.00],
            ['2008-05-01', 4.80],
            ['2008-06-01', 7.00],
            ['2008-07-01', 24.80],
            ['2008-08-01', 21.30],
            ['2008-09-01', 17.40],
            ['2008-10-01', 12.90],
            ['2008-11-01', 9.90],
            ['2008-12-01', 9.70],
            ['2008-13-01', 2.20],
            ['2009-02-01', -0.20],
            ['2009-03-01', -5.70],
            ['2009-04-01', -13.70],
            ['2009-05-01', -17.50],
            ['2009-06-01', -22.10],
            ['2009-07-01', -22.40],
            ['2009-08-01', -22.10],
            ['2009-09-01', -22.00],
            ['2009-10-01', -21.20],
            ['2009-11-01', -15.50],
            ['2009-12-01', -8.00],
            ['2009-13-01', 0.40],
            ['2010-02-01', 1.50],
            ['2010-03-01', 17.80],
            ['2010-04-01', 27.90],
            ['2010-05-01', 33.40],
            ['2010-06-01', 37.20],
            ['2010-07-01', 38.10],
            ['2010-08-01', 33.40],
            ['2010-09-01', 24.90],
            ['2010-10-01', 29.50],
            ['2010-11-01', 23.60],
            ['2010-12-01', 4.00],
            ['2010-13-01', 1.00],
            ['2011-02-01', -0.80],
            ['2011-03-01', -6.60],
            ['2011-04-01', -7.20],
            ['2011-05-01', -3.20],
            ['2011-06-01', 2.80],
            ['2011-07-01', 0.50],
            ['2011-08-01', 7.80],
            ['2011-09-01', 13.30],
            ['2011-10-01', 6.80],
            ['2011-11-01', 7.10],
            ['2011-12-01', 14.80],
            ['2011-13-01', 9.30],
            ['2012-02-01', 12.80],
            ['2012-03-01', 20.40],
            ['2012-04-01', 14.60],
            ['2012-05-01', 13.10],
            ['2012-06-01', 5.20],
            ['2012-07-01', 4.90],
            ['2012-08-01', -4.10],
            ['2012-09-01', -7.50],
            ['2012-10-01', -4.60],
            ['2012-11-01', -6.20],
            ['2012-12-01', 1.80],
            ['2012-13-01', 4.50],
            ['2013-02-01', 4.00],
            ['2013-03-01', -0.30],
            ['2013-04-01', 6.10],
            ['2013-05-01', -5.70],
            ['2013-06-01', -0.80],
            ['2013-07-01', 1.90],
            ['2013-08-01', 2.70],
            ['2013-09-01', 2.90],
            ['2013-10-01', 1.80],
            ['2013-11-01', 0.50],
            ['2013-12-01', 2.30],
            ['2013-13-01', -0.10],
            ['2014-02-01', -3.00],
            ['2014-03-01', -3.80],
            ['2014-04-01', -2.40],
            ['2014-05-01', 5.20],
            ['2014-06-01', 5.00],
            ['2014-07-01', 1.80],
            ['2014-08-01', -0.70],
            ['2014-09-01', -4.60],
            ['2014-10-01', 4.40],
            ['2014-11-01', 7.00],
            ['2014-12-01', -2.20],
            ['2014-13-01', 4.40],
            ['2015-02-01', 1.50],
            ['2015-03-01', -0.80],
            ['2015-04-01', -3.10],
            ['2015-05-01', -9.80],
            ['2015-06-01', -9.80],
            ['2015-07-01', -13.00],
            ['2015-08-01', -9.00],
            ['2015-09-01', -10.30],
            ['2015-10-01', -8.60],
            ['2015-11-01', -10.80],
            ['2015-12-01', -2.30],
            ['2015-13-01', -11.70],
            ['2016-02-01', -7.30],
            ['2016-03-01', -6.70],
            ['2016-04-01', 6.50],
            ['2016-05-01', -1.70],
            ['2016-06-01', -9.00],
            ['2016-07-01', -7.10],
            ['2016-08-01', -13.60],
            ['2016-09-01', -9.90],
            ['2016-10-01', -9.30],
            ['2016-11-01', -3.60],
            ['2016-12-01', -3.70],
            ['2016-13-01', 9.30],
            ['2017-02-01', 3.10],
            ['2017-03-01', 10.50],
            ['2017-04-01', -8.00],
            ['2017-05-01', -5.70],
            ['2017-06-01', 0.90],
            ['2017-07-01', -2.40],
            ['2017-08-01', 2.80],
            ['2017-09-01', -5.90],
            ['2017-10-01', 6.40],
            ['2017-11-01', 6.80],
            ['2017-12-01', 5.30],
            ['2017-13-01', -6.60],
            ['2018-02-01', -5.40],
            ['2018-03-01', -4.00],
            ['2018-04-01', 2.70],
            ['2018-05-01', 7.20],
            ['2018-06-01', 3.60],
            ['2018-07-01', 2.30],
            ['2018-08-01', 0.80],
            ['2018-09-01', 4.30],
            ['2018-10-01', -3.80],
            ['2018-11-01', -6.80],
            ['2018-12-01', -6.50],
            ['2018-13-01', 0.60],
            ['2019-02-01', 3.10],
            ['2019-03-01', -5.90],
            ['2019-04-01', -7.20],
            ['2019-05-01', -5.20],
            ['2019-06-01', -4.30],
            ['2019-07-01', -5.30],
            ['2019-08-01', -2.50],
            ['2019-09-01', -2.80],
            ['2019-10-01', -6.20],
            ['2019-11-01', -8.80],
            ['2019-12-01', -5.90],
            ['2019-13-01', -9.70],
            ['2020-02-01', -8.00],
            ['2020-03-01', -7.60],
            ['2020-04-01', -12.30],
            ['2020-05-01', -24.30]
        ]
    },
    {
        type: 'spline',
        name: 'Export Asia',
        label: {
            enabled: false
        },
        showInLegend: false,
        color: Highcharts.getOptions().colors[0],
        dashStyle: 'dotdash',
        data: [
            ['2002-05-01', -8.00],
            ['2002-06-01', -1.10],
            ['2002-07-01', -2.70],
            ['2002-08-01', 4.70],
            ['2002-09-01', 17.10],
            ['2002-10-01', 5.30],
            ['2002-11-01', -2.40],
            ['2002-12-01', -0.30],
            ['2002-13-01', 2.30],
            ['2003-02-01', 7.40],
            ['2003-03-01', 10.80],
            ['2003-04-01', 11.60],
            ['2003-05-01', 11.50],
            ['2003-06-01', 5.70],
            ['2003-07-01', 8.90],
            ['2003-08-01', 4.80],
            ['2003-09-01', -1.00],
            ['2003-10-01', 2.10],
            ['2003-11-01', 13.30],
            ['2003-12-01', 15.70],
            ['2003-13-01', 12.70],
            ['2004-02-01', 12.90],
            ['2004-03-01', 12.20],
            ['2004-04-01', 10.10],
            ['2004-05-01', 14.80],
            ['2004-06-01', 8.00],
            ['2004-07-01', 6.20],
            ['2004-08-01', 8.80],
            ['2004-09-01', 19.40],
            ['2004-10-01', 16.00],
            ['2004-11-01', 8.20],
            ['2004-12-01', 9.90],
            ['2004-13-01', 13.50],
            ['2005-02-01', 10.30],
            ['2005-03-01', 11.50],
            ['2005-04-01', 12.90],
            ['2005-05-01', 5.60],
            ['2005-06-01', 14.60],
            ['2005-07-01', 8.30],
            ['2005-08-01', 8.70],
            ['2005-09-01', 4.00],
            ['2005-10-01', -0.70],
            ['2005-11-01', -1.10],
            ['2005-12-01', -5.50],
            ['2005-13-01', -9.20],
            ['2006-02-01', -10.50],
            ['2006-03-01', -2.70],
            ['2006-04-01', -8.10],
            ['2006-05-01', -6.60],
            ['2006-06-01', -7.60],
            ['2006-07-01', -2.40],
            ['2006-08-01', -4.30],
            ['2006-09-01', -4.70],
            ['2006-10-01', -4.30],
            ['2006-11-01', -2.40],
            ['2006-12-01', -0.50],
            ['2006-13-01', 1.50],
            ['2007-02-01', 0.80],
            ['2007-03-01', -5.30],
            ['2007-04-01', -1.30],
            ['2007-05-01', 3.70],
            ['2007-06-01', 3.90],
            ['2007-07-01', 3.20],
            ['2007-08-01', 3.10],
            ['2007-09-01', -1.90],
            ['2007-10-01', 10.80],
            ['2007-11-01', 11.50],
            ['2007-12-01', 9.90],
            ['2007-13-01', 16.70],
            ['2008-02-01', 23.40],
            ['2008-03-01', 17.10],
            ['2008-04-01', 21.40],
            ['2008-05-01', 18.20],
            ['2008-06-01', 9.60],
            ['2008-07-01', 17.00],
            ['2008-08-01', 19.70],
            ['2008-09-01', 29.80],
            ['2008-10-01', 15.30],
            ['2008-11-01', 7.60],
            ['2008-12-01', 14.60],
            ['2008-13-01', 14.80],
            ['2009-02-01', 5.40],
            ['2009-03-01', -1.10],
            ['2009-04-01', -3.70],
            ['2009-05-01', -9.30],
            ['2009-06-01', -9.10],
            ['2009-07-01', -20.00],
            ['2009-08-01', -21.60],
            ['2009-09-01', -19.70],
            ['2009-10-01', -16.40],
            ['2009-11-01', -12.90],
            ['2009-12-01', -15.80],
            ['2009-13-01', -12.30],
            ['2010-02-01', -9.20],
            ['2010-03-01', 4.90],
            ['2010-04-01', 11.40],
            ['2010-05-01', 21.40],
            ['2010-06-01', 24.80],
            ['2010-07-01', 42.20],
            ['2010-08-01', 45.70],
            ['2010-09-01', 42.00],
            ['2010-10-01', 33.60],
            ['2010-11-01', 34.10],
            ['2010-12-01', 38.80],
            ['2010-13-01', 23.80],
            ['2011-02-01', 30.50],
            ['2011-03-01', 9.70],
            ['2011-04-01', 14.20],
            ['2011-05-01', 9.20],
            ['2011-06-01', 16.20],
            ['2011-07-01', 5.00],
            ['2011-08-01', 7.90],
            ['2011-09-01', 11.40],
            ['2011-10-01', 10.80],
            ['2011-11-01', 11.90],
            ['2011-12-01', 9.40],
            ['2011-13-01', 13.50],
            ['2012-02-01', 7.90],
            ['2012-03-01', 10.00],
            ['2012-04-01', 2.30],
            ['2012-05-01', 7.80],
            ['2012-06-01', 1.80],
            ['2012-07-01', 9.70],
            ['2012-08-01', 4.40],
            ['2012-09-01', 5.20],
            ['2012-10-01', -3.70],
            ['2012-11-01', 0.70],
            ['2012-12-01', -4.90],
            ['2012-13-01', 0.70],
            ['2013-02-01', 4.30],
            ['2013-03-01', 0.40],
            ['2013-04-01', -3.90],
            ['2013-05-01', -8.60],
            ['2013-06-01', -7.10],
            ['2013-07-01', -6.40],
            ['2013-08-01', -10.00],
            ['2013-09-01', -11.80],
            ['2013-10-01', -10.90],
            ['2013-11-01', -13.50],
            ['2013-12-01', -10.30],
            ['2013-13-01', -9.60],
            ['2014-02-01', -8.00],
            ['2014-03-01', -11.80],
            ['2014-04-01', -6.90],
            ['2014-05-01', -0.70],
            ['2014-06-01', -0.30],
            ['2014-07-01', 0.50],
            ['2014-08-01', 3.30],
            ['2014-09-01', 1.00],
            ['2014-10-01', 0.70],
            ['2014-11-01', 1.10],
            ['2014-12-01', 2.40],
            ['2014-13-01', 0.20],
            ['2015-02-01', -8.30],
            ['2015-03-01', -3.80],
            ['2015-04-01', -7.80],
            ['2015-05-01', -14.70],
            ['2015-06-01', -14.50],
            ['2015-07-01', -14.90],
            ['2015-08-01', -16.20],
            ['2015-09-01', -15.20],
            ['2015-10-01', -14.60],
            ['2015-11-01', -11.30],
            ['2015-12-01', -12.90],
            ['2015-13-01', -14.60],
            ['2016-02-01', -9.10],
            ['2016-03-01', -7.90],
            ['2016-04-01', -6.70],
            ['2016-05-01', -4.80],
            ['2016-06-01', -6.10],
            ['2016-07-01', -6.60],
            ['2016-08-01', -5.70],
            ['2016-09-01', -4.30],
            ['2016-10-01', -6.40],
            ['2016-11-01', -5.70],
            ['2016-12-01', 1.50],
            ['2016-13-01', 1.30],
            ['2017-02-01', 2.20],
            ['2017-03-01', -2.70],
            ['2017-04-01', -1.70],
            ['2017-05-01', 0.20],
            ['2017-06-01', -7.50],
            ['2017-07-01', -4.20],
            ['2017-08-01', -5.20],
            ['2017-09-01', -9.90],
            ['2017-10-01', -4.90],
            ['2017-11-01', -8.30],
            ['2017-12-01', -11.40],
            ['2017-13-01', -5.00],
            ['2018-02-01', -2.80],
            ['2018-03-01', 4.50],
            ['2018-04-01', 4.40],
            ['2018-05-01', 0.50],
            ['2018-06-01', 3.20],
            ['2018-07-01', 6.30],
            ['2018-08-01', 10.70],
            ['2018-09-01', -2.90],
            ['2018-10-01', 13.50],
            ['2018-11-01', 9.30],
            ['2018-12-01', 7.40],
            ['2018-13-01', -0.70],
            ['2019-02-01', -0.70],
            ['2019-03-01', 0.30],
            ['2019-04-01', -0.50],
            ['2019-05-01', 0.00],
            ['2019-06-01', 3.40],
            ['2019-07-01', 1.90],
            ['2019-08-01', -0.80],
            ['2019-09-01', 0.30],
            ['2019-10-01', -3.20],
            ['2019-11-01', -1.30],
            ['2019-12-01', 2.80],
            ['2019-13-01', -3.10],
            ['2020-02-01', -1.50],
            ['2020-03-01', -1.90],
            ['2020-04-01', -7.90],
            ['2020-05-01', -9.70]
        ]
    },
    {
        type: 'spline',
        label: {
            enabled: false
        },
        showInLegend: false,
        name: 'Export Latin America/Caribbean',
        color: Highcharts.getOptions().colors[0],
        dashStyle: 'dot',
        data: [
            ['2002-05-01', 11.30],
            ['2002-06-01', 8.50],
            ['2002-07-01', 10.10],
            ['2002-08-01', 13.40],
            ['2002-09-01', 7.90],
            ['2002-10-01', 11.30],
            ['2002-11-01', 7.10],
            ['2002-12-01', 5.20],
            ['2002-13-01', -2.30],
            ['2003-02-01', 0.30],
            ['2003-03-01', -6.60],
            ['2003-04-01', -4.80],
            ['2003-05-01', -4.70],
            ['2003-06-01', -4.00],
            ['2003-07-01', -4.00],
            ['2003-08-01', -4.80],
            ['2003-09-01', -0.60],
            ['2003-10-01', 1.10],
            ['2003-11-01', 1.90],
            ['2003-12-01', 3.70],
            ['2003-13-01', 8.90],
            ['2004-02-01', 12.50],
            ['2004-03-01', 10.80],
            ['2004-04-01', 10.50],
            ['2004-05-01', 13.00],
            ['2004-06-01', 10.10],
            ['2004-07-01', 11.10],
            ['2004-08-01', 10.00],
            ['2004-09-01', 10.70],
            ['2004-10-01', 5.10],
            ['2004-11-01', 3.40],
            ['2004-12-01', 7.10],
            ['2004-13-01', 6.90],
            ['2005-02-01', 6.10],
            ['2005-03-01', 4.80],
            ['2005-04-01', 5.00],
            ['2005-05-01', 5.10],
            ['2005-06-01', 8.20],
            ['2005-07-01', 6.90],
            ['2005-08-01', 11.10],
            ['2005-09-01', 6.00],
            ['2005-10-01', 9.60],
            ['2005-11-01', 8.90],
            ['2005-12-01', 3.30],
            ['2005-13-01', 10.20],
            ['2006-02-01', 4.50],
            ['2006-03-01', 6.20],
            ['2006-04-01', 7.00],
            ['2006-05-01', 5.50],
            ['2006-06-01', 6.30],
            ['2006-07-01', 6.90],
            ['2006-08-01', 4.10],
            ['2006-09-01', 4.60],
            ['2006-10-01', 7.50],
            ['2006-11-01', 10.50],
            ['2006-12-01', 10.70],
            ['2006-13-01', 5.30],
            ['2007-02-01', 6.90],
            ['2007-03-01', 12.90],
            ['2007-04-01', 16.00],
            ['2007-05-01', 13.80],
            ['2007-06-01', 10.50],
            ['2007-07-01', 9.90],
            ['2007-08-01', 7.20],
            ['2007-09-01', 8.70],
            ['2007-10-01', 10.00],
            ['2007-11-01', 9.10],
            ['2007-12-01', 10.60],
            ['2007-13-01', 7.70],
            ['2008-02-01', 1.30],
            ['2008-03-01', -7.80],
            ['2008-04-01', -7.60],
            ['2008-05-01', -7.80],
            ['2008-06-01', -2.00],
            ['2008-07-01', 1.20],
            ['2008-08-01', 3.90],
            ['2008-09-01', 12.20],
            ['2008-10-01', 0.20],
            ['2008-11-01', -1.60],
            ['2008-12-01', -4.30],
            ['2008-13-01', 5.30],
            ['2009-02-01', 7.10],
            ['2009-03-01', 5.80],
            ['2009-04-01', -3.50],
            ['2009-05-01', -1.20],
            ['2009-06-01', -17.10],
            ['2009-07-01', -13.40],
            ['2009-08-01', -15.20],
            ['2009-09-01', -15.60],
            ['2009-10-01', -14.60],
            ['2009-11-01', -14.00],
            ['2009-12-01', -9.80],
            ['2009-13-01', -4.00],
            ['2010-02-01', -2.30],
            ['2010-03-01', -1.60],
            ['2010-04-01', 8.10],
            ['2010-05-01', 9.90],
            ['2010-06-01', 20.50],
            ['2010-07-01', 18.00],
            ['2010-08-01', 15.60],
            ['2010-09-01', 8.70],
            ['2010-10-01', 16.60],
            ['2010-11-01', 16.10],
            ['2010-12-01', 16.30],
            ['2010-13-01', 10.10],
            ['2011-02-01', 12.20],
            ['2011-03-01', 10.60],
            ['2011-04-01', 14.70],
            ['2011-05-01', 14.20],
            ['2011-06-01', 13.70],
            ['2011-07-01', 8.30],
            ['2011-08-01', 15.50],
            ['2011-09-01', 16.90],
            ['2011-10-01', 14.00],
            ['2011-11-01', 13.20],
            ['2011-12-01', 10.90],
            ['2011-13-01', 8.40],
            ['2012-02-01', 7.30],
            ['2012-03-01', 35.20],
            ['2012-04-01', 27.30],
            ['2012-05-01', 14.30],
            ['2012-06-01', 25.90],
            ['2012-07-01', 22.10],
            ['2012-08-01', 18.90],
            ['2012-09-01', 12.30],
            ['2012-10-01', 12.40],
            ['2012-11-01', 14.40],
            ['2012-12-01', 12.90],
            ['2012-13-01', -2.70],
            ['2013-02-01', 0.00],
            ['2013-03-01', -18.60],
            ['2013-04-01', -16.00],
            ['2013-05-01', -12.10],
            ['2013-06-01', -20.60],
            ['2013-07-01', -15.30],
            ['2013-08-01', -13.60],
            ['2013-09-01', -8.60],
            ['2013-10-01', -13.50],
            ['2013-11-01', -8.90],
            ['2013-12-01', -11.00],
            ['2013-13-01', 5.30],
            ['2014-02-01', 1.60],
            ['2014-03-01', 2.70],
            ['2014-04-01', 2.20],
            ['2014-05-01', 3.70],
            ['2014-06-01', 6.60],
            ['2014-07-01', 3.70],
            ['2014-08-01', -8.70],
            ['2014-09-01', -5.00],
            ['2014-10-01', -1.40],
            ['2014-11-01', -5.80],
            ['2014-12-01', -5.80],
            ['2014-13-01', -4.80],
            ['2015-02-01', -8.10],
            ['2015-03-01', -10.20],
            ['2015-04-01', -9.30],
            ['2015-05-01', -14.10],
            ['2015-06-01', -14.90],
            ['2015-07-01', -12.80],
            ['2015-08-01', -6.50],
            ['2015-09-01', -10.70],
            ['2015-10-01', -19.00],
            ['2015-11-01', -17.30],
            ['2015-12-01', -14.50],
            ['2015-13-01', -18.50],
            ['2016-02-01', -11.00],
            ['2016-03-01', -16.30],
            ['2016-04-01', -15.00],
            ['2016-05-01', -12.40],
            ['2016-06-01', -9.40],
            ['2016-07-01', -10.70],
            ['2016-08-01', -5.00],
            ['2016-09-01', -5.10],
            ['2016-10-01', 3.40],
            ['2016-11-01', 8.00],
            ['2016-12-01', 5.40],
            ['2016-13-01', 4.80],
            ['2017-02-01', -0.70],
            ['2017-03-01', 5.60],
            ['2017-04-01', 7.00],
            ['2017-05-01', 8.60],
            ['2017-06-01', 5.90],
            ['2017-07-01', 4.80],
            ['2017-08-01', 2.90],
            ['2017-09-01', 3.30],
            ['2017-10-01', 5.70],
            ['2017-11-01', -2.70],
            ['2017-12-01', 0.60],
            ['2017-13-01', -0.80],
            ['2018-02-01', 3.80],
            ['2018-03-01', 5.70],
            ['2018-04-01', 0.10],
            ['2018-05-01', 2.00],
            ['2018-06-01', -1.20],
            ['2018-07-01', 1.60],
            ['2018-08-01', -3.90],
            ['2018-09-01', -3.90],
            ['2018-10-01', -5.80],
            ['2018-11-01', -6.20],
            ['2018-12-01', -6.80],
            ['2018-13-01', -12.70],
            ['2019-02-01', -6.80],
            ['2019-03-01', -10.40],
            ['2019-04-01', -7.60],
            ['2019-05-01', -3.30],
            ['2019-06-01', -3.30],
            ['2019-07-01', -2.50],
            ['2019-08-01', 3.10],
            ['2019-09-01', 1.50],
            ['2019-10-01', 0.60],
            ['2019-11-01', 0.90],
            ['2019-12-01', 0.10],
            ['2019-13-01', 7.20],
            ['2020-02-01', 4.60],
            ['2020-03-01', 2.90],
            ['2020-04-01', -2.60],
            ['2020-05-01', -7.10]
        ]
    }];

// for the last chart in the animation (science)
const dataSource = [93, 93, 96, 100, 101, 102, 102];
const xiData = [];
const range = 20;
const startPoint = 88;
for (let i = 0; i < range; i++) {
    xiData[i] = startPoint + i;
}

const dataOrigine = [];
for (let i = 0; i < dataSource.length; i++) {
    dataOrigine.push([dataSource[i], 0]);
}

const dataPoint = [];
for (let i = 0; i < dataSource.length; i++) {
    dataPoint.push([dataSource[i], 0]);
}

let gData = [];

function GaussKDE(xi, x) {
    return (1 / Math.sqrt(2 * Math.PI)) * Math.exp(Math.pow(xi - x, 2) / -2);
}

const N = dataSource.length;
const kernelChart = [];
const kernel = [];

// Create the density estimate
for (let i = 0; i < xiData.length; i++) {
    let temp = 0;
    kernel.push([]);
    kernel[i].push(new Array(dataSource.length));
    for (let j = 0; j < dataSource.length; j++) {
        temp = temp + GaussKDE(xiData[i], dataSource[j]);
        kernel[i][j] = GaussKDE(xiData[i], dataSource[j]);
    }
    gData.push([xiData[i], (1 / N) * temp]);
}

let startNum = 60;
const tempArray = [];
for (let rr = 0; rr < 20; ++rr) {
    tempArray.push([startNum, 0]);
    startNum = startNum + 1;
}

gData = tempArray.concat(gData);

// Create the kernels
for (let i = 0; i < dataSource.length; i++) {
    kernelChart.push([]);
    kernelChart[i].push(new Array(kernel.length));
    for (let j = 0; j < kernel.length; j++) {
        kernelChart[i].push([xiData[j], (1 / N) * kernel[j][i]]);
    }
}

const kernelSeries = [
    {
        type: 'scatter',
        name: 'Observation',
        marker: {
            enabled: true,
            radius: 5,
            symbol: 'circle',
            fillColor: Highcharts.getOptions().colors[5],
            showInLegend: false
        },
        data: dataPoint,
        tooltip: {
            headerFormat: '{series.name}:',
            pointFormat: '<b>{point.x}</b>'
        },
        zIndex: 9,
        showInLegend: false
    },
    {
        name: 'KDE',
        type: 'spline',
        dashStyle: 'solid',
        lineWidth: 2,
        xAxis: 5,
        yAxis: 4,
        color: '#fff',
        fillOpacity: 0.05,
        data: gData,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[0] + ')',
        data: kernelChart[0],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[1] + ')',
        data: kernelChart[1],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[2] + ')',
        data: kernelChart[2],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[3] + ')',
        data: kernelChart[3],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[4] + ')',
        data: kernelChart[4],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[5] + ')',
        data: kernelChart[5],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false
    },
    {
        name: 'k(' + dataSource[6] + ')',
        data: kernelChart[6],
        type: 'spline',
        xAxis: 5,
        yAxis: 4,
        showInLegend: false

    }];

// homepage chart animation chart
/** **************************************/
// /Section 4 Network graph

function section4() {
    // /show everything immediately for accessibility
    if (reduced) {
        $('.highcharts-spline-series').fadeIn(100);
        $('.highcharts-scatter-series').fadeIn(100);
        demoChart.update({
            legend: {
                labelFormat: '{name} <span style="opacity: 0.4">{y}</span>',
                width: 1000,
                floating: true,
                verticalAlign: 'bottom'
            },
            plotOptions: {
                spline: {
                    lineWidth: 2,
                    xAxis: 5,
                    yAxis: 4,
                    dashStyle: 'dot',
                    color: Highcharts.getOptions().colors[3],
                    dataGrouping: {
                        enabled: false
                    }
                    // label: {
                    //     enabled: true
                    // }
                },
                scatter: {
                    lineWidth: 1,
                    xAxis: 5,
                    yAxis: 4,
                    dashStyle: 'shortdot',
                    color: Highcharts.getOptions().colors[5],
                    pointStart: xiData[0],
                    label: {
                        enabled: false
                    },
                    showInLegend: true
                }
            }
        });
        setTimeout(function () {
            demoChart.update({
                plotOptions: {
                    spline: {
                        label: {
                            enabled: true
                        }
                    },
                    scatter: {
                        label: {
                            enabled: true
                        }
                    }
                }
            });
        }, 500);
        $('.highcharts-legend').fadeIn();
        demoChart.series[19].update({ color: '#1E90FF' });
    }

    clearTimeout(currentTimeout);

    // /shows the networkgraph, sets up the splines,
    // shows new title and tab
    const p1 = function () {
        // /don't show network graph for accessibility
        if (!reduced) {
            $('.highcharts-networkgraph-series').fadeIn();
            $('.highcharts-spline-series').hide();
            $('.highcharts-scatter-series').hide();
            demoChart.update({
                legend: {
                    labelFormat: '{name} <span style="opacity: 0.4">{y}</span>',
                    width: 1000,
                    floating: true,
                    verticalAlign: 'bottom'
                },
                plotOptions: {
                    spline: {
                        lineWidth: 2,
                        xAxis: 5,
                        yAxis: 4,
                        dashStyle: 'dot',
                        color: Highcharts.getOptions().colors[3],
                        dataGrouping: {
                            enabled: false
                        },
                        label: {
                            enabled: true
                        }
                    },
                    scatter: {
                        lineWidth: 1,
                        xAxis: 5,
                        yAxis: 4,
                        dashStyle: 'shortdot',
                        color: Highcharts.getOptions().colors[5],
                        pointStart: xiData[0],
                        label: {
                            enabled: false
                        },
                        showInLegend: true
                    }
                }
            });
            $('.highcharts-pie-series').hide();
            $('.highcharts-spline-series').hide();
            $('.highcharts-scatter-series').hide();
        }
    };
    currentTimeout = window.setTimeout(p1, 100);

    // moves the node on the network graph
    const p2 = function () {
        // /don't show for accessibility
        if (!reduced) {
            demoChart.series[3].nodes[0].update({
                plotX: demoChart.chartWidth / 2 + 100,
                plotY: demoChart.chartHeight
            });
        }
    };
    currentTimeout = window.setTimeout(p2, 500);

    // shows the splines
    const p25 = function () {
        // /don't show the splines now for accessibility
        if (!reduced) {
            $('.highcharts-spline-series').fadeIn(100);
            $('.highcharts-scatter-series').fadeIn(100);
            $('.highcharts-legend').fadeIn();
        }
        demoChart.series[19].update({ color: '#1E90FF' });
    };
    currentTimeout = window.setTimeout(p25, 1000);

    // moves the node again
    const p3 = function () {
        // /only do the network stuff for the full animation
        if (!reduced) {
            demoChart.update({
                chart: {
                    animation: {
                        duration: 1000
                    }
                }
            });
            demoChart.series[3].nodes[0].update({
                mass: 1,
                plotX: demoChart.series[3].nodes[1].plotX,
                plotY: demoChart.series[3].nodes[1].plotY

            });
            demoChart.xAxis[5].setExtremes(78, 107);
        }
    };
    currentTimeout = window.setTimeout(p3, 2000);

    const p31 = function () {
        if (reduced) {
            top.window.endAnimation();
        }
    };
    currentTimeout = window.setTimeout(p31, 4500);

    // /consolidates all the nodes, hides most everything else,
    // shows the title and content
    const p4 = function () {
        // $('.highcharts-label').fadeOut();
        // $('.highcharts-streamgraph-series').fadeOut();
        // $('.highcharts-spline-series').fadeOut();
        // $('.highcharts-scatter-series').fadeOut();
        // $('.highcharts-legend').fadeOut();
        // /only manipulate the nodes for the full animation
        if (!reduced) {
            // demoChart.series[3].nodes[0].update({
            //     plotX: demoChart.chartWidth / 2,
            //     plotY: demoChart.chartHeight / 2

            // });
            // let pointCount = 0;
            // const updatePoints = setInterval(function () {
            //     demoChart.series[3].nodes[pointCount].plotY =
            //             demoChart.series[3].nodes[0].plotY;
            //     demoChart.series[3].nodes[pointCount].plotX =
            //             demoChart.series[3].nodes[0].plotX;
            //     demoChart.series[3].nodes[pointCount].mass = 1;
            //     pointCount = pointCount + 1;
            //     const nodeLength = demoChart.series[3].nodes.length;
            //     if (pointCount === nodeLength) {
            //         clearInterval(updatePoints);
            //         demoChart.series[3].hide();
            //     }
            // }, 10);
        }
    };
    currentTimeout = window.setTimeout(p4, 5000);
}
/** **************************************/
// //Section 3 Streamgraph

function section3() {

    // sets up new title, sets the plot options for
    // the streamgraph
    const s1 = function () {
        // /set the axes first and turn off animation for the series
        // /for accessibility
        if (!reduced) {
            demoChart.update({
                plotOptions: {
                    streamgraph: {
                        fillOpacity: 1,
                        lineWidth: 1,
                        lineColor: streamLine,
                        states: {
                            inactive: {
                                enabled: false
                            }
                        }
                    }

                }
            });
        }
    };
    currentTimeout = window.setTimeout(s1, 0);

    const s11 = function () {
        // /show everything immediatley for accessibility
        if (reduced) {
            let yearMax = 1860;
            if (demoChart.chartWidth < 500) {
                yearMax = 1920;
            }
            demoChart.xAxis[4].setExtremes(
                Date.UTC(yearMax, 7, 1)
                , '2016-12-01'
            );

            demoChart.series[5].update({
                animation: false
            });
            demoChart.series[6].update({
                animation: false
            });
            demoChart.series[7].update({
                animation: false
            });
            demoChart.update({
                plotOptions: {
                    streamgraph: {
                        fillOpacity: 1,
                        lineColor: streamLine,
                        label: {
                            enabled: true
                        },
                        lineWidth: 1

                    }

                }
            });
            $('.highcharts-streamgraph-series').fadeIn(1000);
            $('.highcharts-plot-line-label').hide();
            $('.highcharts-axis-labels').fadeIn(100);
            $('.highcharts-annotation-label').fadeIn(100);
            demoChart.xAxis[4].update({
                visible: true
            });
        }
    };
    currentTimeout = window.setTimeout(s11, 300);

    // sets animation duration to 1000, shows streamgraph
    const s2 = function () {
        if (!reduced) {
            $('.highcharts-streamgraph-series').fadeIn(1000);
            $('.highcharts-plot-line-label').hide();
            demoChart.update({
                chart: {
                    animation: {
                        duration: 1000
                    }
                }
            });
        }
    };

    currentTimeout = window.setTimeout(s2, 200);


    // shows the xAxis, sets the xAxis extremes for the
    // streamgraph, shows the labels, sets streamgraph
    // opacity to 1
    const s4 = function () {
        let yearMax = 1860;
        if (demoChart.chartWidth < 500) {
            yearMax = 1920;
        }
        // /adjust the axes for full animation
        if (!reduced) {
            demoChart.xAxis[4].setExtremes(
                Date.UTC(yearMax, 7, 1)
                , '2016-12-01'
            );

            $('.highcharts-axis-labels').fadeIn(100);
            $('.highcharts-pie-series').hide();
            $('.highcharts-annotation-label').fadeIn(100);
            demoChart.xAxis[4].update({
                visible: true
            });
        }
    };
    currentTimeout = window.setTimeout(s4, 1000);

    const s41 = function () {
        if (!reduced) {
            demoChart.update({
                plotOptions: {
                    streamgraph: {
                        fillOpacity: 1,
                        label: {
                            enabled: true
                        },
                        lineWidth: 1

                    }

                }
            });
        }
    };
    currentTimeout = window.setTimeout(s41, 3000);

    // sets the fill opacity to 0, hides the annotations,
    // sets the xAxis extremes
    const s5 = function () {
        // /set the axis for the fourth section now for accessibility
        if (reduced) {
            $('.highcharts-streamgraph-series').fadeOut(500);
            demoChart.xAxis[5].setExtremes(78, 107);
        } else {
            demoChart.update({
                plotOptions: {
                    streamgraph: {
                        fillOpacity: 0,
                        label: {
                            enabled: false
                        },
                        lineWidth: 1
                    }
                }
            });
        }

        $('.highcharts-annotation-label').hide();
        demoChart.xAxis[4].update({
            visible: false
        });
    };
    currentTimeout = window.setTimeout(s5, 5500);

    const s51 = function () {
        // /go to section 4 now for accessibility
        if (reduced) {
            section4();
        }
    };
    currentTimeout = window.setTimeout(s51, 6000);

    // hides the xAxis
    const s6 = function () {
        if (!reduced) {
            demoChart.update({
                plotOptions: {
                    streamgraph: {
                        fillOpacity: 0,
                        label: {
                            enabled: false
                        }
                    }
                }
            });

            demoChart.xAxis[4].setExtremes(
                '1970-08-01',
                '2016-12-01'
            );
        }
    };
    currentTimeout = window.setTimeout(s6, 6700);

    // turns off series labels, fades the titles,
    // goes to section 4
    const s7 = function () {
        if (!reduced) {
            section4();
        }
    };
    currentTimeout = window.setTimeout(s7, 7000);
}
/** **************************************/
// //Section 2 Splines and candlestick

function section2() {
    // /show everything immediately for accessibility
    if (reduced) {
        demoChart.series[19].update({
            animation: false
        });
        demoChart.series[20].update({
            animation: false
        });
        demoChart.series[21].update({
            animation: false
        });
        $('.highcharts-spline-series').fadeIn(100);
        $('.highcharts-candlestick-series').fadeIn(100);
    }

    // /update animation duration to 1000, hide the item series
    const f1 = function () {
        demoChart.update({
            chart: {
                animation: {
                    duration: 1000
                }
            }
        });
        demoChart.series[0].update({
            opacity: 0
        });
        // /set up the finance stuff for section 2 for accessibility
        if (reduced) {
            demoChart.xAxis[1].setExtremes(
                '2002-08-01',
                '2010-10-01'
            );
            demoChart.xAxis[0].setExtremes(
                '2019-12-09',
                '2020-02-13'
            );
            demoChart.update({
                tooltip: {
                    enabled: true
                }
            });
            demoChart.tooltip.refresh(
                [demoChart.series[2].points[22]]
            );
            $('.highcharts-tooltip').hide();
            $('.highcharts-tooltip').fadeIn(1000);
        }
    };
    currentTimeout = setTimeout(f1, 500);

    // set axes extremes for splines and candlestick,
    // show new title
    const f2 = function () {
        if (!reduced) {
            $('.highcharts-networkgraph-series').hide();

            demoChart.xAxis[1].setExtremes(
                '2002-08-01',
                '2010-10-01'
            );
            demoChart.xAxis[0].setExtremes(
                '2019-12-09',
                '2020-02-13'
            );

            $('.highcharts-candlestick-series').show();
        }
    };
    currentTimeout = setTimeout(f2, 1500);

    // /show candlestick tooltip
    const f3 = function () {
        if (!reduced) {
            demoChart.update({
                tooltip: {
                    enabled: true
                }
            });
            demoChart.tooltip.refresh(
                [demoChart.series[2].points[22]]
            );
            $('.highcharts-tooltip').hide();
            $('.highcharts-tooltip').fadeIn(1000);
        }
    };
    currentTimeout = setTimeout(f3, 2500);

    // hide the tooltip and candlestick, remove all the splines
    const f4 = function () {
        $('.highcharts-candlestick-series').hide();
        $('.highcharts-tooltip').hide();

        demoChart.update({
            tooltip: {
                enabled: false
            },
            chart: {
                animation: {
                    duration: 10
                }
            }
        });

        let startNum = demoChart.series.length - 1;
        const endNum = 27;
        $('.highcharts-spline-series').fadeOut();
        const removeSeries = setInterval(function () {
            demoChart.series[startNum].remove();
            startNum = startNum - 1;
            if (startNum < endNum) {
                clearInterval(removeSeries);
            }

        }, 0);

        demoChart.update({
            plotOptions: {
                streamgraph: {
                    fillOpacity: 0,
                    lineWidth: 1,
                    lineColor: baseColor
                }
            }
        });
        $('.highcharts-spline-series').fadeOut(1000);

    };
    currentTimeout = setTimeout(f4, 5000);

    // go to section 3
    const f5 = function () {
        section3();
    };
    currentTimeout = setTimeout(f5, 5500);

}
/** **************************************/
// //Section 1 Pie and item

function section1() {

    // /show immediately for accessibility
    if (reduced) {
        $('.highcharts-series-0').show();
        $('.highcharts-series-4').hide();
        demoChart.series[0].update({
            data: [
                {
                    y: 20,
                    color: Highcharts.getOptions().colors[7]
                },
                {
                    y: 20,
                    color: Highcharts.getOptions().colors[0]
                },
                {
                    y: 20,
                    color: { patternIndex: 7 }
                },
                {
                    y: 20,
                    color: Highcharts.getOptions().colors[2]
                },
                {
                    y: 20,
                    color: Highcharts.getOptions().colors[4]
                },
                {
                    y: 20,
                    color: { patternIndex: 0 }
                },
                {
                    y: 20,
                    color: Highcharts.getOptions().colors[9]
                }
            ],
            opacity: 1,
            marker: {
                radius: 10
            }
        });
    }
    // /swap graphs
    const s12 = function () {
        // /show for regular animation
        if (!reduced) {
            demoChart.series[0].update({
                data: [
                    {
                        y: 20,
                        color: Highcharts.getOptions().colors[7]
                    },
                    {
                        y: 20,
                        color: Highcharts.getOptions().colors[0]
                    },
                    {
                        y: 20,
                        color: { patternIndex: 7 }
                    },
                    {
                        y: 20,
                        color: Highcharts.getOptions().colors[2]
                    },
                    {
                        y: 20,
                        color: Highcharts.getOptions().colors[4]
                    },
                    {
                        y: 20,
                        color: { patternIndex: 0 }
                    },
                    {
                        y: 20,
                        color: Highcharts.getOptions().colors[9]
                    }
                ],
                opacity: 1,
                marker: {
                    radius: 10
                }
            });
            $('.highcharts-series-0').fadeIn();
            $('.highcharts-series-4').fadeOut(100);
        }
        // make an arch
        demoChart.update({
            plotOptions: {
                item: {
                    startAngle: -100,
                    size: '150%',
                    center: ['65.5%', '80%']
                }
            }
        });
    };
    currentTimeout = setTimeout(s12, 1500);
    // /expand the arch
    const s14 =  function () {
        // /don't show the splines now for accessibility
        // /otherwise, they will animate when added
        // /do not make the item chart really big
        if (!reduced) {
            $('.highcharts-spline-series').show();
            demoChart.series[0].update({
                showInLegend: false,
                innerSize: '200%'
            });
        }
        $('.highcharts-item-series').fadeOut(700);
        let count = 0;
        const addSeries = setInterval(function () {
            demoChart.addSeries(splineSeries[count]);
            // /show the spline after they are added for accessibility
            if (reduced) {
                $('.highcharts-spline-series').hide();
            }
            count = count + 1;
            if (count === splineSeries.length) {
                clearInterval(addSeries);
            }
        }, 0);
        // /set the axes now so they're ready for section 2 without animation
        if (reduced) {
            demoChart.xAxis[1].setExtremes(
                '2002-08-01',
                '2010-10-01'
            );
            demoChart.xAxis[0].setExtremes(
                '2019-12-09',
                '2020-02-13'
            );
        }
    };
    currentTimeout = setTimeout(s14, 4000);
    // /set current tab, go to section 2
    const s17 = function () {
        section2();
    };
    currentTimeout = setTimeout(s17, 5000);
}


const heroChart = {
    chart: {
        backgroundColor: 'transparent',
        style: {
            fontFamily: 'Arial',
            color: baseTextColor,
            fontSize: '18px'
        },
        spacing: [0, 0, 0, 0],
        margin: [0, 0, 0, 0],
        animation: {
            easing: 'easeOutQuint',
            duration: 1000,
            enabled: true
        },
        events: {
            load: function () {
                demoChart = this;
                demoChart.update({
                    chart: {
                        animation: {
                            easing: 'easeOutQuint',
                            duration: 1000
                        }
                    }
                });
                $('.highcharts-networkgraph-series').hide();
                $('.highcharts-series-0').hide();
                $('.highcharts-candlestick-series').hide();
                $('.highcharts-spline-series').hide();
                $('.highcharts-scatter-series').hide();
                $('.highcharts-streamgraph-series').hide();
                $('.highcharts-annotation-label').hide();

                section1();
            }
        }
    },
    stockTools: {
        gui: {
            enabled: false
        }
    },
    navigation: {
        annotationsOptions: {
            visible: false
        }
    },
    title: {
        floating: true,
        x: 250,
        y: 90,
        text: '',
        style: {
            fontSize: 16,
            color: baseTextColor,
            fontWeight: 'bold'
        }
    },
    credits: {
        enabled: false
    },
    exporting: {
        enabled: false
    },
    rangeSelector: {
        enabled: false
    },
    navigator: {
        enabled: false
    },
    scrollbar: {
        enabled: false
    },
    tooltip:
{
    enabled: false,
    backgroundColor: '#fff',
    shadow: false,
    borderColor: '#FF9D00',
    borderWidth: 3,
    borderRadius: 10,
    useHTML: true,
    distance: 20,
    formatter: function () {
        const date = new Date(this.points[0].point.x);
        let dateString = date.toString();
        dateString = dateString.substr(0, 16);
        const string =
        '<div id="tooltipGrid">' +
            '<div class="date" ><img ' +
            'src="/samples/graphics/homepage/apple.svg">' +
            dateString + '</div>' +
            '<div class="infoGrid">' +
                '<div class="label">Open</div><div class="data">' +
                    this.points[0].point.open + '</div>' +
                '<div class="label">High</div><div class="data">' +
                    this.points[0].point.high + '</div>' +
                '<div class="label">Low</div><div class="data">' +
                    this.points[0].point.low + '</div>' +
                '<div class="label">Close</div><div class="data">' +
                    this.points[0].point.close + '</div>' +
                '</div>' +
            '</div>';
        return string;
    }
},
    xAxis: [
    // /0
        {
            visible: false,
            type: 'datetime',
            min: '2002-12-08',
            max: '2010-12-20'
        },
        // /1
        {
            type: 'datetime',
            min: '2002-12-08',
            max: '2011-10-01',
            reversed: true,
            visible: false,
            labels: {
                style: {
                    color: axisColor
                }
            }
        },
        // /2
        {
            visible: false,
            type: 'linear',
            tickInterval: 1,
            min: 0,
            max: 11,
            labels: {
                style: {
                    color: axisColor
                }
            }
        },
        // /3
        {
            type: 'datetime',
            min: '1990-02-01',
            max: '2020-02-01',
            floating: true,
            visible: false,
            labels: {
                style: {
                    color: axisColor
                }
            }
        },
        // /4
        {
            type: 'datetime',
            visible: false,
            lineColor: 'transparent',
            tickColor: 'transparent',
            verticalAlign: 'middle',
            min: '1980-08-01',
            max: '2016-08-01',
            // tickPositions:xTicks,
            labels: {
                align: 'left',
                reserveSpace: false,

                style: {
                    color: 'transparent',
                    fontSize: '10px'
                },
                formatter: function () {
                    const year = new Date(this.pos).getFullYear();
                    if (this.pos >= '1921-08-01') {
                        return year;
                    }
                }
            },
            plotLines: [
                {
                    value: '1924-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1924].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1928-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1928].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1932-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1932].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1936-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1936].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1940-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1940].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1944-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1944].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1948-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1948].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1952-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1952].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1956-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1956].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1960-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1960].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1964-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1964].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1968-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1968].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1972-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1972].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1976-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1976].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1980-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1980].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1984-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1984].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1988-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1988].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: Date.UTC(11992, 7, 1),
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1992].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1994-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1994].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '1998-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[1998].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '2002-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[2002].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '2006-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[2006].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '2010-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[2010].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                },
                {
                    value: '2014-08-01',
                    width: 1,
                    color: '#fff',
                    dashStyle: 'dot',
                    zIndex: 20,
                    label: {
                        text: categories[2014].label,
                        verticalAlign: 'bottom',
                        y: -10,
                        rotation: -90,
                        style: { fontSize: '10px', color: baseColor }
                    }
                }
            ]
        },
        // /5
        {
            visible: false,
            min: 60,
            max: 70,
            labels: {
                style: {
                    color: '#333',
                    fontSize: 11
                }
            }
        }
    ],
    yAxis: [
    // /0
        {
            visible: false,
            min: 250,
            max: 400,
            tickInterval: 1,
            startOnTick: false,
            gridLineColor: 'transparent',
            labels: {
                style: {
                    color: axisColor
                },
                title: {
                    text: 'yAxis 0',
                    style: {
                        color: axisColor
                    }
                }
            }
        },
        // /1
        {
            visible: false,
            gridLineColor: 'transparent',
            min: -30,
            max: 40,
            labels: {
                style: {
                    color: axisColor
                }
            },
            startOnTick: true,
            endOnTick: true
        },
        // /2
        {
            visible: false,
            min: 0,
            max: 20,
            labels: {
                style: {
                    color: axisColor
                }
            }
        },
        // /3
        {
            visible: false,
            min: -50,
            max: 50,
            labels: {
                style: {
                    color: axisColor
                }
            }
        },
        // //4
        {
            visible: false,
            max: 0.33,
            min: 0,
            labels: {
                style: {
                    color: axisColor,
                    fontSize: 12
                }
            }

        },
        {
            visible: false
        }
    ],
    responsive: {
        rules: [{
            condition: {
                maxWidth: 800
            },
            chartOptions: {
                plotOptions: {
                    item: {
                        size: '60%',
                        center: ['50%', '72%']
                    },
                    pie: {
                        size: '60%',
                        center: ['50%', '75%']
                    }
                },
                yAxis: [
                // /0
                    {
                        visible: false,
                        min: 250,
                        max: 400,
                        tickInterval: 1,
                        startOnTick: false,
                        gridLineColor: 'transparent',
                        labels: {
                            style: {
                                color: axisColor
                            },
                            title: {
                                text: 'yAxis 0',
                                style: {
                                    color: axisColor
                                }
                            }
                        }

                    },
                    // /1
                    {
                        visible: false,
                        gridLineColor: 'transparent',
                        min: -30,
                        max: 40,
                        labels: {
                            style: {
                                color: axisColor
                            }
                        },
                        startOnTick: true,
                        endOnTick: true
                    },
                    // /2
                    {
                        visible: false,
                        min: 0,
                        max: 20,
                        labels: {
                            style: {
                                color: axisColor
                            }
                        }
                    },
                    // /3
                    {
                        visible: false,
                        min: -50,
                        max: 150,
                        labels: {
                            style: {
                                color: axisColor
                            }
                        }
                    },
                    // //4
                    {
                        visible: false,
                        max: 0.23,
                        min: 0,
                        labels: {
                            style: {
                                color: axisColor,
                                fontSize: 12
                            }
                        }

                    },
                    {
                        visible: false
                    }
                ]

            }
        }]
    },
    legend: {
        enabled: true,
        floating: true,
        x: 300,
        y: -10,
        width: 500,
        style: {
            fontSize: '16px'
        },
        labelFormat: '{label} <span style="opacity: 0.4">{y}</span>'
    },
    annotations: [{
        visible: true,
        labels: [
            {

                point: {
                    x: '1944-08-01',
                    xAxis: 4,
                    y: 10,
                    yAxis: 3
                },
                useHTML: true,
                text:
            '<div class="streamL">Cancelled during World War II</div>',
                zIndex: 30
            },
            {
                point: {
                    x: '1992-08-01',
                    xAxis: 4,
                    y: 10,
                    yAxis: 3
                },
                text: 'Soviet Union fell,<br>Germany united'
            }],
        labelOptions: {
            backgroundColor: Highcharts.getOptions().colors[1],
            borderRadius: 5,
            style: {
                fontSize: '12px',
                color: '#fff'
            },
            shadow: true
        }
    }],
    plotOptions: {
    // /ITEM
        item: {
            size: '80%',
            name: 'Item Chart',
            pointPadding: 1,
            innerSize: null,
            startAngle: 100,
            endAngle: 100,
            borderColor: baseColor,
            color: null,
            opacity: null,
            center: ['65.5%', '60%'],
            borderWidth: null,
            marker: {
                enabled: null,
                radius: 30
            },
            tooltip: {
                enabled: false
            },
            dataLabels: {
                enabled: null,
                format: '{point.label}',
                style: {
                    color: baseTextColor,
                    fontWeight: 200,
                    fontSize: 12
                }
            },
            showInLegend: false
        },
        pie: {
            center: ['65.5%', '60%'],
            size: '80%'
        },
        // /Streamgraph
        streamgraph: {
            fillOpacity: 1,
            lineColor: streamLine,
            lineWidth: 1,
            xAxis: 4,
            yAxis: 3,
            dataGrouping: {
                enabled: false
            },
            showInLegend: false,
            label: {
                enabled: false,
                minFontSize: 6,
                maxFontSize: 20,
                style: {
                    color: 'white'

                }
            },
            tooltip: {
                enabled: false
            }
        },
        // /line
        line: {

            color: baseColor,
            dashStyle: null,
            showInLegend: false,
            xAxis: 0,
            yAxis: 1,
            opacity: 1,
            dataLabels: {
                enabled: null
            },
            lineWidth: 0,
            lineColor: null,
            states: {
                inactive: {
                    enabled: false
                }
            },
            tooltip: {
                enabled: false
            },
            dataGrouping: {
                enabled: false
            }
        },
        // /Spline
        spline: {
            dataGrouping: {
                enabled: false,
                groupAll: true,
                units: [
                    ['month', [1, 3]],
                    ['year', 1]
                ]
            },
            showInLegend: false,
            dashStyle: null,
            xAxis: 0,
            yAxis: 1,
            opacity: 1,
            lineWidth: 1,
            lineColor: null,
            dataLabels: {
                enabled: null
            },
            label: {
                enabled: false

            },
            tooltip: {
                enabled: false
            },
            states: {
                inactive: {
                    enabled: false
                }
            }
        },
        // /Candlestick
        candlestick: {
            color: Highcharts.getOptions().colors[2],
            upColor: Highcharts.getOptions().colors[4],
            showInNavigator: true,
            showInLegend: false,
            dataGrouping: {
                enabled: false,
                groupAll: true,
                units: [
                    ['month', 1, 3]

                ]
            },
            marker: {
                enabled: false,
                lineWidth: 0
            },


            opacity: 1,
            dataLabels: {
                enabled: false
            }
        },
        // Area spline
        areaspline: {
            stacking: 'normal',
            fillOpacity: 0.1,

            allowOverlap: true,
            dataGrouping: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            showInLegend: false
        },
        // /Network
        networkgraph: {

            showInLegend: false,
            zIndex: 2,
            marker: {
                enabled: true,
                radius: null,
                symbol: 'circle',
                fillColor: 'transparent',
                lineColor: networklinkColor,
                lineWidth: 1
            },
            turboThreshold: 0
        },
        // ///scatter
        scatter: {
            marker: {
                enabled: true,
                radius: 5,
                fillColor: Highcharts.getOptions().colors[4]
            },
            dashStyle: 'shortdot',
            color: Highcharts.getOptions().colors[4],
            pointStart: xiData[0],
            xAxis: 5,
            yAxis: 4,
            label: {
                enabled: true
            },
            showInLegend: false,
            tooltip: {
                enabled: false
            }
        }
    },
    series: [
    // //0
        {
            type: 'item',
            zIndex: 2,
            showInLegend: false,
            showInNavigator: false,
            borderWidth: 1,
            pointPadding: 0,
            innerSize: '22%',
            color: 'transparent',
            label: {
                enabled: true
            },
            name: 'Representatives',
            data: [
                {
                    y: 39,
                    color: Highcharts.getOptions().colors[7]
                },
                {
                    color: Highcharts.getOptions().colors[0],
                    y: 123
                },
                {
                    color: { patternIndex: 7 },
                    y: 37
                },
                {
                    color: Highcharts.getOptions().colors[2],
                    y: 50
                },
                {
                    color: Highcharts.getOptions().colors[4],
                    y: 170
                },
                {
                    color: { patternIndex: 0 },
                    y: 16
                },
                {
                    color: Highcharts.getOptions().colors[9],
                    y: 64
                }
            ],
            dataLabels: {
                enabled: false,
                format: '{point.label}'
            },
            marker: {
                enabled: true,
                radius: 3
            },
            states: {
                inactive: {
                    enabled: false
                }
            }
        },
        // /1
        {
            type: 'line',
            lineWidth: 0,
            showInLegend: false,
            xAxis: 1,
            yAxis: 0,
            color: null,
            dataLabels: {
                enabled: false,
                formatter: function () {
                    return this.point.index;
                }
            },
            zIndex: 30,
            label: {
                enabled: false
            },
            marker: {
                enabled: null,
                radius: null,
                lineWidth: 1,
                lineColor: 'rgba(0,0,0,.2)'
            },
            dashStyle: 'solid',
            name: 'Import air passenger fares',
            data: [
                ['2002-05-01', 4.80],
                ['2002-06-01', 4.30],
                ['2002-07-01', 5.60],
                ['2002-08-01', 7.60],
                ['2002-09-01', 7.00],
                ['2002-10-01', 7.60],
                ['2002-11-01', 5.60],
                ['2002-12-01', 3.00],
                ['2002-13-01', 1.40],
                ['2003-02-01', 1.90],
                ['2003-03-01', 3.80],
                ['2003-04-01', 5.30],
                ['2003-05-01', 4.80],
                ['2003-06-01', 4.40],
                ['2003-07-01', 2.70],
                ['2003-08-01', 1.30],
                ['2003-09-01', 1.30],
                ['2003-10-01', 0.60],
                ['2003-11-01', -1.40],
                ['2003-12-01', 0.40],
                ['2003-13-01', -0.20],
                ['2004-02-01', -0.90],
                ['2004-03-01', -3.20],
                ['2004-04-01', -4.60],
                ['2004-05-01', -5.70],
                ['2004-06-01', -4.70],
                ['2004-07-01', 0.70],
                ['2004-08-01', -2.20],
                ['2004-09-01', -2.70],
                ['2004-10-01', -3.90],
                ['2004-11-01', 0.80],
                ['2004-12-01', 1.80],
                ['2004-13-01', 4.40],
                ['2005-02-01', 3.70],
                ['2005-03-01', 6.00],
                ['2005-04-01', 6.20],
                ['2005-05-01', 5.10],
                ['2005-06-01', 3.60],
                ['2005-07-01', 4.10],
                ['2005-08-01', 4.30],
                ['2005-09-01', 3.80],
                ['2005-10-01', 2.50],
                ['2005-11-01', 2.70],
                ['2005-12-01', 4.40],
                ['2005-13-01', 4.10],
                ['2006-02-01', 3.60],
                ['2006-03-01', 4.20],
                ['2006-04-01', 4.50],
                ['2006-05-01', 3.80],
                ['2006-06-01', 5.60],
                ['2006-07-01', 6.70],
                ['2006-08-01', 5.60],
                ['2006-09-01', 5.60],
                ['2006-10-01', 5.60],
                ['2006-11-01', 5.90],
                ['2006-12-01', 7.70],
                ['2006-13-01', 7.80],
                ['2007-02-01', 7.00],
                ['2007-03-01', 7.10],
                ['2007-04-01', 7.00],
                ['2007-05-01', 4.80],
                ['2007-06-01', 3.90],
                ['2007-07-01', 5.80],
                ['2007-08-01', 7.20],
                ['2007-09-01', 8.20],
                ['2007-10-01', 7.10],
                ['2007-11-01', 5.50],
                ['2007-12-01', 5.60],
                ['2007-13-01', 7.90],
                ['2008-02-01', 7.80],
                ['2008-03-01', 6.70],
                ['2008-04-01', 6.80],
                ['2008-05-01', 12.60],
                ['2008-06-01', 13.70],
                ['2008-07-01', 18.70],
                ['2008-08-01', 19.50],
                ['2008-09-01', 15.80],
                ['2008-10-01', 15.00],
                ['2008-11-01', 25.30],
                ['2008-12-01', 22.90],
                ['2008-13-01', 16.30],
                ['2009-02-01', 12.20],
                ['2009-03-01', 8.10],
                ['2009-04-01', 2.70],
                ['2009-05-01', -7.10],
                ['2009-06-01', -10.10],
                ['2009-07-01', -14.20],
                ['2009-08-01', -20.10],
                ['2009-09-01', -19.50],
                ['2009-10-01', -14.50],
                ['2009-11-01', -11.60],
                ['2009-12-01', -6.40],
                ['2009-13-01', -3.20],
                ['2010-02-01', -0.70],
                ['2010-03-01', 0.40],
                ['2010-04-01', 11.00],
                ['2010-05-01', 17.30],
                ['2010-06-01', 23.30],
                ['2010-07-01', 19.00],
                ['2010-08-01', 21.30],
                ['2010-09-01', 19.00],
                ['2010-10-01', 16.70],
                ['2010-11-01', 14.90],
                ['2010-12-01', 12.80],
                ['2010-13-01', 11.60],
                ['2011-02-01', 12.20],
                ['2011-03-01', 13.60],
                ['2011-04-01', 7.60],
                ['2011-05-01', 4.50],
                ['2011-06-01', 7.30],
                ['2011-07-01', 5.00],
                ['2011-08-01', 6.20],
                ['2011-09-01', 7.40],
                ['2011-10-01', 8.50],
                ['2011-11-01', 5.50],
                ['2011-12-01', 6.20],
                ['2011-13-01', 5.70],
                ['2012-02-01', 8.80],
                ['2012-03-01', 11.80],
                ['2012-04-01', 10.90],
                ['2012-05-01', 10.30],
                ['2012-06-01', 5.10],
                ['2012-07-01', 8.60],
                ['2012-08-01', 5.20],
                ['2012-09-01', 2.50],
                ['2012-10-01', 3.00],
                ['2012-11-01', 3.10],
                ['2012-12-01', 2.90],
                ['2012-13-01', 8.20],
                ['2013-02-01', 3.90],
                ['2013-03-01', 2.30],
                ['2013-04-01', 1.70],
                ['2013-05-01', 1.20],
                ['2013-06-01', 2.60],
                ['2013-07-01', 2.90],
                ['2013-08-01', 2.10],
                ['2013-09-01', -0.50],
                ['2013-10-01', 1.10],
                ['2013-11-01', 3.40],
                ['2013-12-01', 7.90],
                ['2013-13-01', 8.20],
                ['2014-02-01', 5.10],
                ['2014-03-01', 6.70],
                ['2014-04-01', 4.80],
                ['2014-05-01', 4.80],
                ['2014-06-01', 5.00],
                ['2014-07-01', 1.40],
                ['2014-08-01', 2.60],
                ['2014-09-01', 6.70],
                ['2014-10-01', 6.30],
                ['2014-11-01', 4.40],
                ['2014-12-01', 1.90],
                ['2014-13-01', 2.70],
                ['2015-02-01', 2.30],
                ['2015-03-01', -0.60],
                ['2015-04-01', 0.50],
                ['2015-05-01', -2.70],
                ['2015-06-01', -2.90],
                ['2015-07-01', -1.10],
                ['2015-08-01', -2.40],
                ['2015-09-01', -3.20],
                ['2015-10-01', -7.20],
                ['2015-11-01', -4.70],
                ['2015-12-01', -2.20],
                ['2015-13-01', -9.90],
                ['2016-02-01', -4.30],
                ['2016-03-01', -3.30],
                ['2016-04-01', -6.30],
                ['2016-05-01', -0.20],
                ['2016-06-01', -0.50],
                ['2016-07-01', -8.40],
                ['2016-08-01', -8.30],
                ['2016-09-01', -9.10],
                ['2016-10-01', -0.80],
                ['2016-11-01', 0.20],
                ['2016-12-01', -6.00],
                ['2016-13-01', -4.20],
                ['2017-02-01', -4.90],
                ['2017-03-01', -4.20],
                ['2017-04-01', -2.70],
                ['2017-05-01', -9.10],
                ['2017-06-01', -6.90],
                ['2017-07-01', -3.80],
                ['2017-08-01', -2.60],
                ['2017-09-01', -7.40],
                ['2017-10-01', -3.70],
                ['2017-11-01', -1.40],
                ['2017-12-01', -0.90],
                ['2017-13-01', 4.20],
                ['2018-02-01', 2.60],
                ['2018-03-01', 4.20],
                ['2018-04-01', 1.50],
                ['2018-05-01', 7.90],
                ['2018-06-01', 1.20],
                ['2018-07-01', 4.80],
                ['2018-08-01', 1.50],
                ['2018-09-01', 3.50],
                ['2018-10-01', 5.70],
                ['2018-11-01', -2.20],
                ['2018-12-01', 0.70],
                ['2018-13-01', 1.80],
                ['2019-02-01', 1.20],
                ['2019-03-01', -1.70],
                ['2019-04-01', -0.90],
                ['2019-05-01', -10.60],
                ['2019-06-01', -1.90],
                ['2019-07-01', -2.50],
                ['2019-08-01', -6.60],
                ['2019-09-01', -6.10],
                ['2019-10-01', -7.40],
                ['2019-11-01', -4.90],
                ['2019-12-01', -3.00],
                ['2019-13-01', -4.70],
                ['2020-02-01', -9.50],
                ['2020-03-01', -7.40],
                ['2020-04-01', -11.30],
                ['2020-05-01', -16.20]
            ]
        },
        // 2
        {
            type: 'candlestick',
            name: 'AAPL Stock Price',
            showInLegend: false,
            id: 0,
            xAxis: 0,
            yAxis: 0,
            data: [
                [1575297000000, 267.27, 268.25, 263.45, 264.16],
                [1575383400000, 258.31, 259.53, 256.29, 259.45],
                [1575469800000, 261.07, 263.31, 260.68, 261.74],
                [1575556200000, 263.79, 265.89, 262.73, 265.58],
                [1575642600000, 267.48, 271, 267.3, 270.71],
                [1575901800000, 270, 270.8, 264.91, 266.92],
                [1575988200000, 268.6, 270.07, 265.86, 268.48],
                [1576074600000, 268.81, 271.1, 268.5, 270.77],
                [1576161000000, 267.78, 272.56, 267.32, 271.46],
                [1576247400000, 271.46, 275.3, 270.93, 275.15],
                [1576506600000, 277, 280.79, 276.98, 279.86],
                [1576593000000, 279.57, 281.77, 278.8, 280.41],
                [1576679400000, 279.8, 281.9, 279.12, 279.74],
                [1576765800000, 279.5, 281.18, 278.95, 280.02],
                [1576852200000, 282.23, 282.65, 278.56, 279.44],
                [1577111400000, 280.53, 284.25, 280.37, 284],
                [1577197800000, 284.69, 284.89, 282.92, 284.27],
                [1577370600000, 284.82, 289.98, 284.7, 289.91],
                [1577457000000, 291.12, 293.97, 288.12, 289.8],
                [1577716200000, 289.46, 292.69, 285.22, 291.52],
                [1577802600000, 289.93, 293.68, 289.52, 293.65],
                [1577975400000, 296.24, 300.6, 295.19, 300.35],
                [1578061800000, 297.15, 300.58, 296.5, 297.43],
                [1578321000000, 293.79, 299.96, 292.75, 299.8],
                [1578407400000, 299.84, 300.9, 297.48, 298.39],
                [1578493800000, 297.16, 304.44, 297.16, 303.19],
                [1578580200000, 307.24, 310.43, 306.2, 309.63],
                [1578666600000, 310.6, 312.67, 308.25, 310.33],
                [1578925800000, 311.64, 317.07, 311.15, 316.96],
                [1579012200000, 316.7, 317.57, 312.17, 312.68],
                [1579098600000, 311.85, 315.5, 309.55, 311.34],
                [1579185000000, 313.59, 315.7, 312.09, 315.24],
                [1579271400000, 316.27, 318.74, 315, 318.73],
                [1579617000000, 317.19, 319.02, 316, 316.57],
                [1579703400000, 318.58, 319.99, 317.31, 317.7],
                [1579789800000, 317.92, 319.56, 315.65, 319.23],
                [1579876200000, 320.25, 323.33, 317.52, 318.31],
                [1580135400000, 310.06, 311.77, 304.88, 308.95],
                [1580221800000, 312.6, 318.4, 312.19, 317.69],
                [1580308200000, 324.45, 327.85, 321.38, 324.34],
                [1580394600000, 320.54, 324.09, 318.75, 323.87],
                [1580481000000, 320.93, 322.68, 308.29, 309.51],
                [1580740200000, 304.3, 313.49, 302.22, 308.66],
                [1580826600000, 315.31, 319.64, 313.63, 318.85],
                [1580913000000, 323.52, 324.76, 318.95, 321.45],
                [1580999400000, 322.57, 325.22, 320.26, 325.21],
                [1581085800000, 322.37, 323.4, 318, 320.03],
                [1581345000000, 314.18, 321.55, 313.85, 321.55],
                [1581431400000, 323.6, 323.9, 318.71, 319.61],
                [1581517800000, 321.47, 327.22, 321.47, 327.2],
                [1581604200000, 324.19, 326.22, 323.35, 324.87],
                [1581690600000, 324.74, 325.98, 322.85, 324.95],
                [1582036200000, 315.36, 319.75, 314.61, 319],
                [1582122600000, 320, 324.57, 320, 323.62],
                [1582209000000, 322.63, 324.65, 318.21, 320.3],
                [1582295400000, 318.62, 320.45, 310.5, 313.05],
                [1582554600000, 297.26, 304.18, 289.23, 298.18],
                [1582641000000, 300.95, 302.53, 286.13, 288.08],
                [1582727400000, 286.53, 297.88, 286.5, 292.65],
                [1582813800000, 281.1, 286, 272.96, 273.52],
                [1582900200000, 257.26, 278.41, 256.37, 273.36],
                [1583159400000, 282.28, 301.44, 277.72, 298.81],
                [1583245800000, 303.67, 304, 285.8, 289.32],
                [1583332200000, 296.44, 303.4, 293.13, 302.74],
                [1583418600000, 295.52, 299.55, 291.41, 292.92],
                [1583505000000, 282, 290.82, 281.23, 289.03],
                [1583760600000, 263.75, 278.09, 263, 266.17],
                [1583847000000, 277.14, 286.44, 269.37, 285.34],
                [1583933400000, 277.39, 281.22, 271.86, 275.43],
                [1584019800000, 255.94, 270, 248, 248.23],
                [1584106200000, 264.89, 279.92, 252.95, 277.97],
                [1584365400000, 241.95, 259.08, 240, 242.21],
                [1584451800000, 247.51, 257.61, 238.4, 252.86]
            ],
            color: null,
            upColor: '#90ed7d',
            marker: {
                enabled: true,
                lineWidth: 1
            }
        },
        // /3
        {
            type: 'networkgraph',
            zindex: 1,
            showInLegend: false,
            link: {
                color: networklinkColor,
                dashStyle: 'dot'
            },
            visible: true,
            layoutAlgorithm: {
                enableSimulation: true,
                initialPositions: 'random',
                // Applied only to links, should be 0
                attractiveForce: function () {
                    return 0;
                },
                repulsiveForce: function () {
                    return 1;
                },
                linkLength: 10,
                integration: 'euler',
                // Half of the repulsive force
                gravitationalConstant: 2
            },

            // data:[],
            data: [
                ['0', '1'],
                ['1', '2'],
                ['1', '3'],
                ['1', '4'],
                ['1', '5'],
                ['1', '6'],
                ['1', '7'],
                ['1', '8'],
                ['1', '9'],
                ['1', '10'],
                ['1', '11'],
                ['1', '12'],
                ['1', '13'],
                ['1', '14'],
                ['1', '15'],
                ['1', '16'],
                ['1', '17'],
                ['1', '18'],
                ['1', '19'],
                ['1', '20'],
                ['1', '21'],
                ['1', '22'],
                ['1', '23'],
                ['1', '24'],
                ['1', '25'],
                ['1', '26'],
                ['1', '27'],
                ['1', '28'],
                ['1', '29'],
                ['1', '30'],
                ['1', '31'],
                ['1', '32'],
                ['1', '33'],
                ['1', '34'],
                ['1', '35'],
                ['1', '36'],
                ['1', '37'],
                ['1', '38'],
                ['1', '39'],
                ['1', '40'],
                ['1', '41'],
                ['1', '42'],
                ['1', '43'],
                ['1', '44'],
                ['1', '45'],
                ['1', '46'],
                ['1', '47'],
                ['1', '48'],
                ['1', '49'],
                ['1', '50'],

                ['1', '51'],
                ['1', '52'],
                ['1', '53'],
                ['1', '54'],
                ['1', '55'],
                ['1', '56'],
                ['1', '57'],
                ['1', '58'],
                ['1', '59'],
                ['1', '60'],
                ['1', '61'],
                ['1', '62'],
                ['1', '63'],
                ['1', '64'],
                ['1', '65'],
                ['1', '66'],
                ['1', '67'],
                ['1', '68'],
                ['1', '69'],
                ['1', '70'],
                ['1', '71'],
                ['1', '72'],
                ['1', '73'],
                ['1', '74'],
                ['1', '75'],
                ['1', '76'],
                ['1', '77'],
                ['1', '78'],
                ['1', '79'],
                ['1', '80'],
                ['1', '81'],
                ['1', '82'],
                ['1', '83'],
                ['1', '84'],
                ['1', '85'],
                ['1', '86'],
                ['1', '87'],
                ['1', '88'],
                ['1', '89'],
                ['1', '90'],
                ['1', '91'],
                ['1', '92'],
                ['1', '93'],
                ['1', '94'],
                ['1', '95'],
                ['1', '96'],
                ['1', '97'],
                ['1', '98']
            ],
            nodes: [
                {
                    id: '0',

                    marker: {
                        radius: 8
                    },
                    mass: 300,

                    dataLabels: {
                        enabled: false
                    },
                    color: '#7cb5ec'
                }, {
                    id: '1',
                    mass: 1,
                    marker: {
                        radius: 3
                    },
                    color: '#434348'
                }, {
                    id: '2',
                    mass: 1,
                    marker: {
                        radius: 3
                    },
                    color: '#434348'
                }, {
                    id: '3',
                    mass: 1,
                    marker: {
                        radius: 3
                    },
                    color: '#90ed7d'
                }, {
                    id: '4',
                    mass: 1,
                    marker: {
                        radius: 3
                    },
                    color: '#90ed7d'
                }, {
                    id: '5',
                    mass: 1,
                    marker: {
                        radius: 4
                    },
                    color: '#7cb5ec'
                }, {
                    id: '6',
                    mass: 1,
                    marker: {
                        radius: 4
                    },
                    color: '#7cb5ec'
                }, {
                    id: '7',
                    mass: 1,
                    marker: {
                        radius: 10
                    },
                    color: '#7cb5ec'
                }, {
                    id: '8',
                    mass: 1,
                    marker: {
                        radius: 5
                    },
                    color: '#434348'
                }, {
                    id: '9',
                    mass: 1,
                    marker: {
                        radius: 6
                    },
                    color: '#90ed7d'
                }, {
                    id: '10',
                    mass: 1,
                    marker: {
                        radius: 6
                    },
                    color: '#90ed7d'
                }, {
                    id: '11',
                    mass: 1,
                    marker: {
                        radius: 7
                    },
                    color: '#7cb5ec'
                }, {
                    id: '12',
                    mass: 1,
                    marker: {
                        radius: 7
                    },
                    color: '#7cb5ec'
                }, {
                    id: '13',
                    mass: 1,
                    marker: {
                        radius: 8
                    },
                    color: '#434348'
                }, {
                    id: '14',
                    mass: 1,
                    marker: {
                        radius: 8
                    },
                    color: '#434348'
                }, {
                    id: '15',
                    mass: 1,
                    marker: {
                        radius: 9
                    },
                    color: '#90ed7d'
                }, {
                    id: '16',
                    mass: 1,
                    marker: {
                        radius: 9
                    },
                    color: '#90ed7d'
                }, {
                    id: '17',
                    mass: 1,
                    marker: {
                        radius: 10
                    },
                    color: '#7cb5ec'
                }, {
                    id: '18',
                    mass: 1,
                    marker: {
                        radius: 10
                    },
                    color: '#7cb5ec'
                }, {
                    id: '19',
                    mass: 1,
                    marker: {
                        radius: 1
                    },
                    color: '#434348'
                }, {
                    id: '20',
                    mass: 1,
                    marker: {
                        radius: 1
                    },
                    color: '#434348'
                }, {
                    id: '21',
                    mass: 1,
                    marker: {
                        radius: 2
                    },
                    color: '#90ed7d'
                }, {
                    id: '22',
                    mass: 1,
                    marker: {
                        radius: 2
                    },
                    color: '#90ed7d'
                }, {
                    id: '23',
                    mass: 1,
                    marker: {
                        radius: 3
                    },
                    color: '#7cb5ec'
                }, {
                    id: '24',
                    mass: 1,
                    marker: {
                        radius: 3
                    },
                    color: '#7cb5ec'
                }, {
                    id: '25',
                    mass: 1,
                    marker: {
                        radius: 4
                    },
                    color: '#434348'
                }, {
                    id: '26',
                    mass: 1,
                    marker: {
                        radius: 4
                    },
                    color: '#434348'
                }, {
                    id: '27',
                    mass: 1,
                    marker: {
                        radius: 5
                    },
                    color: '#90ed7d'
                }, {
                    id: '28',
                    mass: 1,
                    marker: {
                        radius: 5
                    },
                    color: '#90ed7d'
                }, {
                    id: '29',
                    mass: 1,
                    marker: {
                        radius: 6
                    },
                    color: '#7cb5ec'
                }, {
                    id: '30',
                    mass: 1,
                    marker: {
                        radius: 6
                    },
                    color: '#7cb5ec'
                }
            ]
        },
        // 4
        {
            type: 'pie',
            showInLegend: false,
            data: [
                {
                    y: 69,
                    color: Highcharts.getOptions().colors[7]
                },
                {
                    y: 153,
                    color: Highcharts.getOptions().colors[0]
                },
                {
                    y: 67,
                    color: { patternIndex: 7 }
                },
                {
                    y: 80,
                    color: Highcharts.getOptions().colors[2]
                },
                {
                    y: 200,
                    color: Highcharts.getOptions().colors[4]
                },
                {
                    y: 46,
                    color: { patternIndex: 0 }
                },
                {
                    y: 94,
                    color: Highcharts.getOptions().colors[9]
                }

            ],
            allowPointSelect: true,
            slicedOffset: 20,
            borderColor: '#fff',
            zIndex: 20,
            borderWidth: 5,
            innerSize: '30%',
            startAngle: 100,
            endAngle: 100,
            dataLabels: {
                enabled: false
            }
        },
        // /5 - 17
        {
            type: 'streamgraph',
            name: streamSeries[0].name,
            data: streamDataArrays[0],
            color: '#43abff'
        },
        {
            type: 'streamgraph',
            name: streamSeries[1].name,
            data: streamDataArrays[2],
            color: '#84c3ff'
        },
        {
            type: 'streamgraph',
            name: streamSeries[2].name,
            data: streamDataArrays[2],
            color: '#d0e3fc'
        },
        {
            type: 'streamgraph',
            name: streamSeries[3].name,
            data: streamDataArrays[3],
            color: '#7c95ff'
        },
        {
            type: 'streamgraph',
            name: streamSeries[4].name,
            data: streamDataArrays[4],
            color: '#ff4768'
        },
        {
            type: 'streamgraph',
            name: streamSeries[5].name,
            data: streamDataArrays[5],
            color: '#88eff9'
        },
        {
            type: 'streamgraph',
            name: streamSeries[6].name,
            data: streamDataArrays[6],
            color: '#737cff'
        },
        {
            type: 'streamgraph',
            name: streamSeries[7].name,
            data: streamDataArrays[7],
            color: '#afb9ff'
        },
        {
            type: 'streamgraph',
            name: streamSeries[8].name,
            data: streamDataArrays[8],
            color: '#e5e0ff'
        },
        {
            type: 'streamgraph',
            name: streamSeries[10].name,
            data: streamDataArrays[10],
            color: Highcharts.color(colors[5]).brighten(0.2).get()
        },
        {
            type: 'streamgraph',
            name: streamSeries[11].name,
            data: streamDataArrays[11],
            color: Highcharts.color(colors[4]).brighten(0.1).get()
        },
        {
            type: 'streamgraph',
            name: streamSeries[12].name,
            data: streamDataArrays[12],
            color: Highcharts.color(colors[5]).brighten(0.1).get()
        },
        {
            type: 'streamgraph',
            name: streamSeries[13].name,
            data: streamDataArrays[13],
            color: Highcharts.color(colors[0]).brighten(0.1).get()
        },
        // 18 - 26
        kernelSeries[0],
        kernelSeries[1],
        kernelSeries[2],
        kernelSeries[3],
        kernelSeries[4],
        kernelSeries[5],
        kernelSeries[6],
        kernelSeries[7],
        kernelSeries[8]
    ]
};

demoChart = Highcharts.stockChart('container', heroChart);