const gaugeOptions = {
    chart: {
        type: 'solidgauge'
    },
    title: null,
    pane: {
        center: ['50%', '85%'],
        size: '140%',
        startAngle: -90,
        endAngle: 90,
        background: {
            backgroundColor: '#EEE',
            innerRadius: '60%',
            outerRadius: '100%',
            shape: 'arc'
        }
    },
    tooltip: {
        enabled: false
    },
    // the value axis
    yAxis: {
        minColor: '#FFFFFF',
        maxColor: '#000000',
        lineWidth: 0,
        minorTickInterval: null,
        tickPixelInterval: 400,
        tickWidth: 0,
        title: {
            y: -70
        },
        labels: {
            y: 16
        }
    },
    plotOptions: {
        solidgauge: {
            dataLabels: {
                y: -30,
                borderWidth: 0,
                useHTML: true
            }
        }
    }
};

// The speed gauge
Highcharts.chart('container-speed', Highcharts.merge(gaugeOptions, {
    yAxis: {
        min: 0,
        max: 200,
        title: {
            text: 'Speed'
        }
    },
    credits: {
        enabled: false
    },
    series: [{
        name: 'Speed',
        data: [30],
        dataLabels: {
            format:
                '<div style="text-align:center">' +
                '<span style="font-size:25px;color:black">{y}</span><br/>' +
                '<span style="font-size:12px;color:silver">km/h</span>' +
                '</div>'
        },
        tooltip: {
            valueSuffix: ' km/h'
        }
    }]
}));

// The RPM gauge
Highcharts.chart('container-rpm', Highcharts.merge(gaugeOptions, {
    yAxis: {
        min: 0,
        max: 5,
        title: {
            text: 'RPM'
        }
    },
    series: [{
        name: 'RPM',
        data: [4],
        dataLabels: {
            format:
                '<div style="text-align:center">' +
                '<span style="font-size:25px;color:black">' +
                '{y:.1f}' +
                '</span><br/>' +
                '<span style="font-size:12px;color:silver">' +
                '* 1000 / min' +
                '</span>' +
                '</div>'
        },
        tooltip: {
            valueSuffix: ' revolutions/min'
        }
    }]
}));
