(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/ca/ca-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['ca-yt-6001', 10], ['ca-on-3560', 11], ['ca-qc-2499', 12],
        ['ca-qc-2489', 13], ['ca-nl-1011', 14], ['ca-nu-6205', 15],
        ['ca-mb-4623', 16], ['ca-bc-5945', 17], ['ca-bc-5943', 18],
        ['ca-bc-5949', 19], ['ca-bc-5947', 20], ['ca-nu-6204', 21],
        ['ca-nu-6208', 22], ['ca-ab-4817', 23], ['ca-bc-5959', 24],
        ['ca-bc-5955', 25], ['ca-bc-5957', 26], ['ca-nt-6106', 27],
        ['ca-nt-6101', 28], ['ca-qc-2401', 29], ['ca-ab-4816', 30],
        ['ca-sk-4718', 31], ['ca-on-3556', 32], ['ca-sk-4702', 33],
        ['ca-sk-4701', 34], ['ca-on-3558', 35], ['ca-qc-2402', 36],
        ['ca-qc-2462', 37], ['ca-qc-2490', 38], ['ca-nb-1315', 39],
        ['ca-qc-2497', 40], ['ca-qc-2496', 41], ['ca-sk-4709', 42],
        ['ca-on-3551', 43], ['ca-qc-2458', 44], ['ca-bc-5933', 45],
        ['ca-bc-5941', 46], ['ca-ns-1209', 47], ['ca-ns-1213', 48],
        ['ca-ns-1201', 49], ['ca-mb-4601', 50], ['ca-bc-5929', 51],
        ['ca-sk-4711', 52], ['ca-nb-1309', 53], ['ca-qc-2486', 54],
        ['ca-qc-2487', 55], ['ca-qc-2488', 56], ['ca-on-3559', 57],
        ['ca-qc-2492', 58], ['ca-qc-2485', 59], ['ca-on-3507', 60],
        ['ca-nl-1005', 61], ['ca-bc-5953', 62], ['ca-nt-6104', 63],
        ['ca-sk-4712', 64], ['ca-sk-4716', 65], ['ca-nb-1304', 66],
        ['ca-nb-1308', 67], ['ca-nb-1303', 68], ['ca-nb-1305', 69],
        ['ca-nb-1306', 70], ['ca-nb-1307', 71], ['ca-on-3520', 72],
        ['ca-nb-1302', 73], ['ca-nb-1301', 74], ['ca-on-3521', 75],
        ['ca-ns-1218', 76], ['ca-sk-4706', 77], ['ca-sk-4707', 78],
        ['ca-sk-4703', 79], ['ca-sk-4705', 80], ['ca-on-3547', 81],
        ['ca-qc-2484', 82], ['ca-qc-2482', 83], ['ca-qc-2483', 84],
        ['ca-qc-2480', 85], ['ca-qc-2478', 86], ['ca-on-3557', 87],
        ['ca-qc-2406', 88], ['ca-bc-5903', 89], ['ca-qc-2405', 90],
        ['ca-qc-2404', 91], ['ca-ab-4803', 92], ['ca-bc-5901', 93],
        ['ca-bc-5907', 94], ['ca-bc-5935', 95], ['ca-bc-5939', 96],
        ['ca-bc-5905', 97], ['ca-qc-2408', 98], ['ca-qc-2409', 99],
        ['ca-qc-2464', 100], ['ca-qc-2465', 101], ['ca-qc-2466', 102],
        ['ca-qc-2460', 103], ['ca-qc-2461', 104], ['ca-qc-2463', 105],
        ['ca-qc-2468', 106], ['ca-qc-2467', 107], ['ca-qc-2469', 108],
        ['ca-qc-2407', 109], ['ca-qc-2491', 110], ['ca-qc-2493', 111],
        ['ca-qc-2416', 112], ['ca-on-3538', 113], ['ca-on-3540', 114],
        ['ca-on-3523', 115], ['ca-on-3541', 116], ['ca-qc-2494', 117],
        ['ca-qc-2411', 118], ['ca-qc-2410', 119], ['ca-qc-2413', 120],
        ['ca-qc-2412', 121], ['ca-bc-5919', 122], ['ca-qc-2414', 123],
        ['ca-qc-2417', 124], ['ca-bc-5909', 125], ['ca-bc-5915', 126],
        ['ca-bc-5917', 127], ['ca-qc-2477', 128], ['ca-qc-2476', 129],
        ['ca-on-3502', 130], ['ca-qc-2475', 131], ['ca-qc-2474', 132],
        ['ca-qc-2473', 133], ['ca-qc-2472', 134], ['ca-on-3501', 135],
        ['ca-qc-2471', 136], ['ca-qc-2470', 137], ['ca-on-3518', 138],
        ['ca-ns-1203', 139], ['ca-nb-1313', 140], ['ca-ab-4801', 141],
        ['ca-ab-4802', 142], ['ca-ab-4805', 143], ['ca-ab-4804', 144],
        ['ca-ab-4806', 145], ['ca-ab-4807', 146], ['ca-ab-4808', 147],
        ['ca-ab-4809', 148], ['ca-qc-2445', 149], ['ca-qc-2446', 150],
        ['ca-on-3554', 151], ['ca-qc-2431', 152], ['ca-qc-2429', 153],
        ['ca-qc-2430', 154], ['ca-qc-2432', 155], ['ca-nl-1010', 156],
        ['ca-nb-1312', 157], ['ca-qc-2495', 158], ['ca-qc-2442', 159],
        ['ca-qc-2440', 160], ['ca-qc-2439', 161], ['ca-qc-2441', 162],
        ['ca-qc-2447', 163], ['ca-qc-2444', 164], ['ca-qc-2448', 165],
        ['ca-qc-2449', 166], ['ca-qc-2438', 167], ['ca-mb-4620', 168],
        ['ca-qc-2418', 169], ['ca-on-3552', 170], ['ca-on-3548', 171],
        ['ca-ab-4811', 172], ['ca-ab-4814', 173], ['ca-ab-4810', 174],
        ['ca-ab-4812', 175], ['ca-ab-4819', 176], ['ca-ab-4815', 177],
        ['ca-on-3506', 178], ['ca-nl-1007', 179], ['ca-nl-1003', 180],
        ['ca-nl-1008', 181], ['ca-nl-1006', 182], ['ca-nl-1004', 183],
        ['ca-nl-1001', 184], ['ca-qc-2415', 185], ['ca-qc-2459', 186],
        ['ca-qc-2455', 187], ['ca-qc-2454', 188], ['ca-qc-2457', 189],
        ['ca-qc-2456', 190], ['ca-qc-2451', 191], ['ca-qc-2450', 192],
        ['ca-qc-2453', 193], ['ca-qc-2452', 194], ['ca-sk-4708', 195],
        ['ca-on-3519', 196], ['ca-on-3513', 197], ['ca-on-3511', 198],
        ['ca-on-3512', 199], ['ca-on-3510', 200], ['ca-ns-1210', 201],
        ['ca-on-3515', 202], ['ca-on-3516', 203], ['ca-qc-2433', 204],
        ['ca-ns-1204', 205], ['ca-ns-1206', 206], ['ca-qc-2403', 207],
        ['ca-ns-1212', 208], ['ca-on-3544', 209], ['ca-ns-1211', 210],
        ['ca-ns-1216', 211], ['ca-ns-1215', 212], ['ca-ns-1217', 213],
        ['ca-ns-1214', 214], ['ca-on-3509', 215], ['ca-ns-1202', 216],
        ['ca-qc-2422', 217], ['ca-on-3546', 218], ['ca-qc-2426', 219],
        ['ca-qc-2427', 220], ['ca-qc-2419', 221], ['ca-on-3526', 222],
        ['ca-on-3524', 223], ['ca-on-3525', 224], ['ca-on-3529', 225],
        ['ca-on-3522', 226], ['ca-mb-4608', 227], ['ca-mb-4609', 228],
        ['ca-mb-4606', 229], ['ca-mb-4607', 230], ['ca-mb-4604', 231],
        ['ca-mb-4605', 232], ['ca-mb-4602', 233], ['ca-mb-4603', 234],
        ['ca-mb-4610', 235], ['ca-on-3528', 236], ['ca-on-3531', 237],
        ['ca-ab-4818', 238], ['ca-bc-5951', 239], ['ca-on-3542', 240],
        ['ca-on-3530', 241], ['ca-qc-2481', 242], ['ca-on-3543', 243],
        ['ca-on-3539', 244], ['ca-pe-1102', 245], ['ca-pe-1103', 246],
        ['ca-pe-1101', 247], ['ca-on-3514', 248], ['ca-qc-2428', 249],
        ['ca-ns-1208', 250], ['ca-ns-1205', 251], ['ca-ns-1207', 252],
        ['ca-qc-2435', 253], ['ca-qc-2434', 254], ['ca-qc-2437', 255],
        ['ca-qc-2436', 256], ['ca-mb-4618', 257], ['ca-on-3532', 258],
        ['ca-on-3534', 259], ['ca-on-3537', 260], ['ca-on-3536', 261],
        ['ca-mb-4611', 262], ['ca-mb-4614', 263], ['ca-mb-4613', 264],
        ['ca-mb-4619', 265], ['ca-mb-4612', 266], ['ca-mb-4615', 267],
        ['ca-mb-4617', 268], ['ca-mb-4616', 269], ['ca-nb-1314', 270],
        ['ca-nb-1311', 271], ['ca-nt-6105', 272], ['ca-nt-6102', 273],
        ['ca-bc-5923', 274], ['ca-bc-5924', 275], ['ca-bc-5926', 276],
        ['ca-bc-5927', 277], ['ca-bc-5921', 278], ['ca-qc-2421', 279],
        ['ca-qc-2420', 280], ['ca-qc-2423', 281], ['ca-qc-2425', 282],
        ['ca-mb-4621', 283], ['ca-sk-4714', 284], ['ca-sk-4717', 285],
        ['ca-sk-4715', 286], ['ca-sk-4710', 287], ['ca-sk-4713', 288],
        ['ca-on-3549', 289], ['ca-qc-2479', 290], ['ca-nl-1002', 291],
        ['ca-bc-5937', 292], ['ca-bc-5931', 293], ['ca-nb-1310', 294],
        ['ca-qc-2443', 295], ['ca-ab-4813', 296], ['ca-nl-1009', 297],
        ['ca-qc-2498', 298], ['ca-sk-4704', 299], ['ca-mb-4622', 300],
        ['ca-nt-6103', 301], ['ca-on-3553', 302], [null, 303]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/ca/ca-all-all.topo.json">Canada, admin2</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
