(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/cm/cm-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['cm-es', 10], ['cm-ad', 11], ['cm-nw', 12], ['cm-no', 13],
        ['cm-ce', 14], ['cm-ou', 15], ['cm-en', 16], ['cm-sw', 17],
        ['cm-lt', 18], ['cm-su', 19]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/cm/cm-all.topo.json">Cameroon</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
