(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-sh-01054000', 10], ['de-mv-13074000', 11], ['de-mv-13073000', 12],
        ['de-mv-13003000', 13], ['de-ni-03457000', 14], ['de-mv-13076000', 15],
        ['de-ni-03356000', 16], ['de-by-09184000', 17], ['de-by-09177000', 18],
        ['de-by-09175000', 19], ['de-sh-01061000', 20], ['de-rp-07138000', 21],
        ['de-rp-07143000', 22], ['de-rp-07313000', 23], ['de-bw-08125000', 24],
        ['de-bw-08226000', 25], ['de-sl-10045000', 26], ['de-th-16062000', 27],
        ['de-bb-12068000', 28], ['de-hb-04012000', 29], ['de-by-09377000', 30],
        ['de-by-09187000', 31], ['de-ni-03462000', 32], ['de-by-09372000', 33],
        ['de-bb-12071000', 34], ['de-sn-14626000', 35], ['de-ni-03459000', 36],
        ['de-by-09172000', 37], ['de-ni-03405000', 38], ['de-bw-08136000', 39],
        ['de-bw-08415000', 40], ['de-by-09472000', 41], ['de-by-09574000', 42],
        ['de-by-09564000', 43], ['de-ni-03241000', 44], ['de-ni-03252000', 45],
        ['de-by-09375000', 46], ['de-he-06534000', 47], ['de-he-06535000', 48],
        ['de-bw-08317000', 49], ['de-bw-08237000', 50], ['de-st-15001000', 51],
        ['de-st-15082000', 52], ['de-nw-05766000', 53], ['de-ni-03361000', 54],
        ['de-ni-03256000', 55], ['de-sn-14522000', 56], ['de-ni-03353000', 57],
        ['de-sh-01053000', 58], ['de-sn-14523000', 59], ['de-th-16075000', 60],
        ['de-th-16074000', 61], ['de-by-09163000', 62], ['de-by-09762000', 63],
        ['de-by-09474000', 64], ['de-by-09361000', 65], ['de-by-09471000', 66],
        ['de-by-09463000', 67], ['de-by-09461000', 68], ['de-ni-03156000', 69],
        ['de-by-09462000', 70], ['de-by-09678000', 71], ['de-by-09662000', 72],
        ['de-sl-10042000', 73], ['de-bb-12069000', 74], ['de-ni-03455000', 75],
        ['de-ni-03359000', 76], ['de-ni-03451000', 77], ['de-ni-03461000', 78],
        ['de-sh-01056000', 79], ['de-hh-02000000', 80], ['de-nw-05962000', 81],
        ['de-nw-05954000', 82], ['de-by-09478000', 83], ['de-sh-01001000', 84],
        ['de-nw-05974000', 85], ['de-nw-05119000', 86], ['de-nw-05170000', 87],
        ['de-rp-07319000', 88], ['de-rp-07338000', 89], ['de-bw-08222000', 90],
        ['de-rp-07337000', 91], ['de-by-09262000', 92], ['de-bw-08235000', 93],
        ['de-bw-08231000', 94], ['de-bw-08236000', 95], ['de-bw-08215000', 96],
        ['de-nw-05554000', 97], ['de-ni-03456000', 98], ['de-ni-03358000', 99],
        ['de-ni-03355000', 100], ['de-by-09277000', 101],
        ['de-rp-07314000', 102], ['de-ni-04011000', 103],
        ['de-ni-03254000', 104], ['de-ni-03102000', 105],
        ['de-ni-03158000', 106], ['de-nw-05366000', 107],
        ['de-rp-07232000', 108], ['de-by-09771000', 109],
        ['de-by-09772000', 110], ['de-by-09778000', 111],
        ['de-rp-07311000', 112], ['de-ni-03154000', 113],
        ['de-ni-03151000', 114], ['de-he-06432000', 115],
        ['de-by-09676000', 116], ['de-ni-03101000', 117],
        ['de-bw-08225000', 118], ['de-he-06437000', 119],
        ['de-by-09576000', 120], ['de-rp-07332000', 121],
        ['de-rp-07335000', 122], ['de-rp-07316000', 123],
        ['de-bw-08115000', 124], ['de-by-09777000', 125],
        ['de-rp-07140000', 126], ['de-rp-07339000', 127],
        ['de-he-06433000', 128], ['de-he-06436000', 129],
        ['de-ni-03403000', 130], ['de-th-16054000', 131],
        ['de-th-16070000', 132], ['de-rp-07318000', 133],
        ['de-nw-05758000', 134], ['de-nw-05754000', 135],
        ['de-nw-05334000', 136], ['de-nw-05370000', 137],
        ['de-nw-05162000', 138], ['de-nw-05166000', 139],
        ['de-th-16052000', 140], ['de-he-06636000', 141],
        ['de-th-16056000', 142], ['de-by-09674000', 143],
        ['de-th-16069000', 144], ['de-th-16072000', 145],
        ['de-th-16068000', 146], ['de-th-16067000', 147],
        ['de-nw-05374000', 148], ['de-rp-07132000', 149],
        ['de-nw-05124000', 150], ['de-he-06438000', 151],
        ['de-by-09179000', 152], ['de-by-09188000', 153],
        ['de-he-06414000', 154], ['de-nw-05762000', 155],
        ['de-nw-05958000', 156], ['de-nw-05120000', 157],
        ['de-nw-05122000', 158], ['de-by-09271000', 159],
        ['de-nw-05112000', 160], ['de-nw-05117000', 161],
        ['de-he-06412000', 162], ['de-nw-05378000', 163],
        ['de-nw-05158000', 164], ['de-nw-05316000', 165],
        ['de-th-16066000', 166], ['de-he-06411000', 167],
        ['de-by-09174000', 168], ['de-by-09162000', 169],
        ['de-bb-12053000', 170], ['de-nw-05113000', 171],
        ['de-bw-08436000', 172], ['de-by-09764000', 173],
        ['de-bw-08426000', 174], ['de-bw-08118000', 175],
        ['de-bw-08119000', 176], ['de-bw-08111000', 177],
        ['de-bw-08311000', 178], ['de-bw-08316000', 179],
        ['de-by-09186000', 180], ['de-bw-08421000', 181],
        ['de-by-09775000', 182], ['de-by-09183000', 183],
        ['de-st-15089000', 184], ['de-st-15003000', 185],
        ['de-sh-01062000', 186], ['de-sh-01055000', 187],
        ['de-sh-01060000', 188], ['de-sh-01058000', 189],
        ['de-nw-05914000', 190], ['de-nw-05978000', 191],
        ['de-bw-08117000', 192], ['de-bw-08116000', 193],
        ['de-nw-05970000', 194], ['de-he-06532000', 195],
        ['de-rp-07340000', 196], ['de-ni-03404000', 197],
        ['de-nw-05566000', 198], ['de-st-15088000', 199],
        ['de-st-15087000', 200], ['de-by-09774000', 201],
        ['de-bw-08425000', 202], ['de-by-09776000', 203],
        ['de-bw-08435000', 204], ['de-bw-08335000', 205],
        ['de-rp-07134000', 206], ['de-rp-07235000', 207],
        ['de-ni-03360000', 208], ['de-nw-05570000', 209],
        ['de-nw-05558000', 210], ['de-he-06431000', 211],
        ['de-rp-07331000', 212], ['de-ni-03153000', 213],
        ['de-he-06611000', 214], ['de-ni-03152000', 215],
        ['de-he-06633000', 216], ['de-nw-05315000', 217],
        ['de-th-16065000', 218], ['de-th-16061000', 219],
        ['de-sl-10043000', 220], ['de-sl-10044000', 221],
        ['de-nw-05562000', 222], ['de-rp-07312000', 223],
        ['de-nw-05358000', 224], ['de-sn-14729000', 225],
        ['de-st-14730000', 226], ['de-ni-03402000', 227],
        ['de-bw-08221000', 228], ['de-st-15083000', 229],
        ['de-bw-08326000', 230], ['de-bw-08212000', 231],
        ['de-rp-07334000', 232], ['de-bw-08216000', 233],
        ['de-nw-05362000', 234], ['de-nw-05382000', 235],
        ['de-rp-07131000', 236], ['de-by-09671000', 237],
        ['de-rp-07137000', 238], ['de-rp-07141000', 239],
        ['de-rp-07111000', 240], ['de-bw-08135000', 241],
        ['de-ni-03354000', 242], ['de-st-15090000', 243],
        ['de-by-09780000', 244], ['de-by-09376000', 245],
        ['de-st-15086000', 246], ['de-nw-05913000', 247],
        ['de-nw-05911000', 248], ['de-nw-05916000', 249],
        ['de-nw-05513000', 250], ['de-ni-03401000', 251],
        ['de-ni-03251000', 252], ['de-ni-03352000', 253],
        ['de-by-09779000', 254], ['de-by-09563000', 255],
        ['de-by-09562000', 256], ['de-by-09573000', 257],
        ['de-th-16073000', 258], ['de-he-06435000', 259],
        ['de-sn-14625000', 260], ['de-bb-12065000', 261],
        ['de-bb-12073000', 262], ['de-ni-03454000', 263],
        ['de-by-09189000', 264], ['de-sh-01057000', 265],
        ['de-sh-01002000', 266], ['de-nw-05154000', 267],
        ['de-by-09182000', 268], ['de-ni-03458000', 269],
        ['de-ni-03157000', 270], ['de-by-09371000', 271],
        ['de-by-09185000', 272], ['de-by-09176000', 273],
        ['de-by-09161000', 274], ['de-sl-10046000', 275],
        ['de-by-09178000', 276], ['de-by-09171000', 277],
        ['de-bw-08417000', 278], ['de-st-15085000', 279],
        ['de-ni-03255000', 280], ['de-nw-05966000', 281],
        ['de-by-09181000', 282], ['de-ni-03155000', 283],
        ['de-nw-05512000', 284], ['de-nw-05314000', 285],
        ['de-bw-08127000', 286], ['de-he-06434000', 287],
        ['de-bb-12070000', 288], ['de-th-16064000', 289],
        ['de-sh-01003000', 290], ['de-st-15084000', 291],
        ['de-th-16071000', 292], ['de-bb-12064000', 293],
        ['de-be-11000000', 294], ['de-bb-12072000', 295],
        ['de-bb-12063000', 296], ['de-by-09479000', 297],
        ['de-th-16076000', 298], ['de-nw-05111000', 299],
        ['de-by-09572000', 300], ['de-nw-05114000', 301],
        ['de-by-09661000', 302], ['de-rp-07231000', 303],
        ['de-by-09565000', 304], ['de-by-09473000', 305],
        ['de-by-09675000', 306], ['de-by-09571000', 307],
        ['de-bw-08128000', 308], ['de-nw-05915000', 309],
        ['de-bw-08327000', 310], ['de-bw-08325000', 311],
        ['de-he-06413000', 312], ['de-he-06440000', 313],
        ['de-rp-07315000', 314], ['de-by-09373000', 315],
        ['de-nw-05711000', 316], ['de-sh-01004000', 317],
        ['de-th-16077000', 318], ['de-sn-14511000', 319],
        ['de-sn-14524000', 320], ['de-th-16051000', 321],
        ['de-he-06635000', 322], ['de-bb-12060000', 323],
        ['de-by-09475000', 324], ['de-mv-13071000', 325],
        ['de-nw-05770000', 326], ['de-sn-14628000', 327],
        ['de-sn-14627000', 328], ['de-rp-07133000', 329],
        ['de-rp-07336000', 330], ['de-rp-07333000', 331],
        ['de-by-09673000', 332], ['de-by-09677000', 333],
        ['de-th-16053000', 334], ['de-by-09476000', 335],
        ['de-by-09477000', 336], ['de-he-06439000', 337],
        ['de-bb-12051000', 338], ['de-ni-03357000', 339],
        ['de-by-09274000', 340], ['de-by-09761000', 341],
        ['de-by-09575000', 342], ['de-by-09679000', 343],
        ['de-bw-08416000', 344], ['de-mv-13075000', 345],
        ['de-sh-01059000', 346], ['de-by-09672000', 347],
        ['de-mv-13004000', 348], ['de-ni-03452000', 349],
        ['de-sh-01051000', 350], ['de-mv-13072000', 351],
        ['de-bw-08337000', 352], ['de-bw-08211000', 353],
        ['de-by-09180000', 354], ['de-bb-12067000', 355],
        ['de-by-09275000', 356], ['de-by-09272000', 357],
        ['de-sn-14521000', 358], ['de-sl-10041000', 359],
        ['de-bw-08336000', 360], ['de-by-09279000', 361],
        ['de-sn-14713000', 362], ['de-bw-08315000', 363],
        ['de-rp-07233000', 364], ['de-by-09276000', 365],
        ['de-st-15081000', 366], ['de-bw-08437000', 367],
        ['de-he-06631000', 368], ['de-th-16063000', 369],
        ['de-he-06531000', 370], ['de-by-09273000', 371],
        ['de-st-15002000', 372], ['de-ni-03351000', 373],
        ['de-by-09261000', 374], ['de-st-15091000', 375],
        ['de-by-09773000', 376], ['de-ni-03103000', 377],
        ['de-bw-08126000', 378], ['de-nw-05774000', 379],
        ['de-nw-05116000', 380], ['de-by-09278000', 381],
        ['de-bw-08121000', 382], ['de-rp-07317000', 383],
        ['de-nw-05515000', 384], ['de-rp-07211000', 385],
        ['de-rp-07320000', 386], ['de-rp-07135000', 387],
        ['de-by-09763000', 388], ['de-ni-03460000', 389],
        ['de-by-09190000', 390], ['de-bb-12052000', 391],
        ['de-ni-03453000', 392], ['de-by-09374000', 393],
        ['de-by-09263000', 394], ['de-by-09362000', 395],
        ['de-bb-12066000', 396], ['de-bb-12062000', 397],
        ['de-by-09577000', 398], ['de-by-09561000', 399],
        ['de-he-06533000', 400], ['de-bb-12061000', 401],
        ['de-th-16055000', 402], ['de-sn-14612000', 403],
        ['de-bb-12054000', 404], ['de-by-09363000', 405],
        ['de-he-06632000', 406], ['de-by-09663000', 407],
        ['de-by-09173000', 408], ['de-ni-03257000', 409],
        ['de-he-06634000', 410], ['de-by-09464000', 411], [null, 412]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-all-all.topo.json">Germany, admin2</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
