(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-bb-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-bb-12060000-12060020', 10], ['de-bb-12060000-12060192', 11],
        ['de-bb-12062000-12062128', 12], ['de-bb-12073000-12073565', 13],
        ['de-bb-12073000-12073393', 14], ['de-bb-12061000-12061405', 15],
        ['de-bb-12061000-12061216', 16], ['de-bb-12063000-12063142', 17],
        ['de-bb-12060000-12060092', 18], ['de-bb-12064000-12064125', 19],
        ['de-bb-12069000-12069470', 20], ['de-bb-12069000-12069216', 21],
        ['de-bb-12069000-12069448', 22], ['de-bb-12069000-12069485', 23],
        ['de-bb-12069000-12069537', 24], ['de-bb-12060000-12060269', 25],
        ['de-bb-12065000-12065256', 26], ['de-bb-12065000-12065193', 27],
        ['de-bb-12065000-12065198', 28], ['de-bb-12068000-12068372', 29],
        ['de-bb-12070000-12070222', 30], ['de-bb-12070000-12070096', 31],
        ['de-bb-12068000-12068188', 32], ['de-bb-12066000-12066285', 33],
        ['de-bb-12062000-12062293', 34], ['de-bb-12063000-12063256', 35],
        ['de-bb-12063000-12063186', 36], ['de-bb-12063000-12063240', 37],
        ['de-bb-12073000-12073008', 38], ['de-bb-12073000-12073440', 39],
        ['de-bb-12070000-12070316', 40], ['de-bb-12070000-12070393', 41],
        ['de-bb-12067000-12067552', 42], ['de-bb-12067000-12067508', 43],
        ['de-bb-12069000-12069648', 44], ['de-bb-12051000-12051000', 45],
        ['de-bb-12063000-12063148', 46], ['de-bb-12069000-12069541', 47],
        ['de-bb-12069000-12069460', 48], ['de-bb-12067000-12067120', 49],
        ['de-bb-12067000-12067338', 50], ['de-bb-12069000-12069474', 51],
        ['de-bb-12069000-12069076', 52], ['de-bb-12063000-12063208', 53],
        ['de-bb-12064000-12064266', 54], ['de-bb-12069000-12069604', 55],
        ['de-bb-12062000-12062124', 56], ['de-bb-12062000-12062196', 57],
        ['de-bb-12073000-12073261', 58], ['de-bb-12073000-12073452', 59],
        ['de-bb-12061000-12061448', 60], ['de-bb-12061000-12061492', 61],
        ['de-bb-12069000-12069402', 62], ['de-bb-12064000-12064388', 63],
        ['de-bb-12064000-12064009', 64], ['de-bb-12073000-12073157', 65],
        ['de-bb-12073000-12073569', 66], ['de-bb-12060000-12060280', 67],
        ['de-bb-12067000-12067205', 68], ['de-bb-12067000-12067324', 69],
        ['de-bb-12064000-12064480', 70], ['de-bb-12064000-12064268', 71],
        ['de-bb-12066000-12066226', 72], ['de-bb-12060000-12060149', 73],
        ['de-bb-12067000-12067173', 74], ['de-bb-12063000-12063080', 75],
        ['de-bb-12063000-12063273', 76], ['de-bb-12065000-12065136', 77],
        ['de-bb-12063000-12063212', 78], ['de-bb-12063000-12063293', 79],
        ['de-bb-12063000-12063165', 80], ['de-bb-12063000-12063161', 81],
        ['de-bb-12063000-12063094', 82], ['de-bb-12064000-12064420', 83],
        ['de-bb-12067000-12067469', 84], ['de-bb-12064000-12064153', 85],
        ['de-bb-12064000-12064084', 86], ['de-bb-12063000-12063056', 87],
        ['de-bb-12063000-12063357', 88], ['de-bb-12071000-12071060', 89],
        ['de-bb-12052000-12052000', 90], ['de-bb-12061000-12061428', 91],
        ['de-bb-12061000-12061510', 92], ['de-bb-12061000-12061265', 93],
        ['de-bb-12067000-12067481', 94], ['de-bb-12061000-12061328', 95],
        ['de-bb-12068000-12068264', 96], ['de-bb-12068000-12068468', 97],
        ['de-bb-12073000-12073216', 98], ['de-bb-12073000-12073579', 99],
        ['de-bb-12066000-12066272', 100], ['de-bb-12066000-12066168', 101],
        ['de-bb-12066000-12066240', 102], ['de-bb-12068000-12068324', 103],
        ['de-bb-12063000-12063134', 104], ['de-bb-12069000-12069056', 105],
        ['de-bb-12069000-12069304', 106], ['de-bb-12069000-12069616', 107],
        ['de-bb-12066000-12066124', 108], ['de-bb-12063000-12063244', 109],
        ['de-bb-12063000-12063252', 110], ['de-bb-12069000-12069052', 111],
        ['de-bb-12068000-12068452', 112], ['de-bb-12068000-12068477', 113],
        ['de-bb-12071000-12071160', 114], ['de-bb-12064000-12064044', 115],
        ['de-bb-12070000-12070280', 116], ['de-bb-12070000-12070348', 117],
        ['de-bb-12070000-12070241', 118], ['de-bb-12063000-12063202', 119],
        ['de-bb-12072000-12072426', 120], ['de-bb-12073000-12073430', 121],
        ['de-bb-12069000-12069454', 122], ['de-bb-12073000-12073429', 123],
        ['de-bb-12069000-12069089', 124], ['de-bb-12069000-12069232', 125],
        ['de-bb-12069000-12069020', 126], ['de-bb-12069000-12069224', 127],
        ['de-bb-12064000-12064061', 128], ['de-bb-12064000-12064417', 129],
        ['de-bb-12067000-12067438', 130], ['de-bb-12064000-12064393', 131],
        ['de-bb-12064000-12064349', 132], ['de-bb-12064000-12064365', 133],
        ['de-bb-12064000-12064538', 134], ['de-bb-12064000-12064057', 135],
        ['de-bb-12069000-12069632', 136], ['de-bb-12071000-12071176', 137],
        ['de-bb-12069000-12069345', 138], ['de-bb-12060000-12060024', 139],
        ['de-bb-12053000-12053000', 140], ['de-bb-12060000-12060161', 141],
        ['de-bb-12071000-12071044', 142], ['de-bb-12071000-12071189', 143],
        ['de-bb-12071000-12071294', 144], ['de-bb-12069000-12069306', 145],
        ['de-bb-12069000-12069680', 146], ['de-bb-12060000-12060185', 147],
        ['de-bb-12060000-12060045', 148], ['de-bb-12067000-12067473', 149],
        ['de-bb-12064000-12064128', 150], ['de-bb-12060000-12060100', 151],
        ['de-bb-12060000-12060172', 152], ['de-bb-12062000-12062464', 153],
        ['de-bb-12066000-12066316', 154], ['de-bb-12061000-12061444', 155],
        ['de-bb-12061000-12061112', 156], ['de-bb-12068000-12068109', 157],
        ['de-bb-12068000-12068409', 158], ['de-bb-12063000-12063112', 159],
        ['de-bb-12060000-12060052', 160], ['de-bb-12064000-12064053', 161],
        ['de-bb-12064000-12064222', 162], ['de-bb-12068000-12068052', 163],
        ['de-bb-12068000-12068501', 164], ['de-bb-12064000-12064370', 165],
        ['de-bb-12064000-12064029', 166], ['de-bb-12067000-12067180', 167],
        ['de-bb-12067000-12067458', 168], ['de-bb-12073000-12073097', 169],
        ['de-bb-12073000-12073225', 170], ['de-bb-12064000-12064136', 171],
        ['de-bb-12064000-12064336', 172], ['de-bb-12067000-12067040', 173],
        ['de-bb-12067000-12067144', 174], ['de-bb-12067000-12067528', 175],
        ['de-bb-12068000-12068437', 176], ['de-bb-12065000-12065301', 177],
        ['de-bb-12064000-12064472', 178], ['de-bb-12061000-12061352', 179],
        ['de-bb-12061000-12061316', 180], ['de-bb-12061000-12061017', 181],
        ['de-bb-12064000-12064408', 182], ['de-bb-12067000-12067201', 183],
        ['de-bb-12064000-12064130', 184], ['de-bb-12064000-12064288', 185],
        ['de-bb-12066000-12066188', 186], ['de-bb-12073000-12073189', 187],
        ['de-bb-12066000-12066104', 188], ['de-bb-12073000-12073645', 189],
        ['de-bb-12073000-12073386', 190], ['de-bb-12073000-12073032', 191],
        ['de-bb-12062000-12062208', 192], ['de-bb-12069000-12069688', 193],
        ['de-bb-12061000-12061344', 194], ['de-bb-12061000-12061192', 195],
        ['de-bb-12061000-12061332', 196], ['de-bb-12064000-12064428', 197],
        ['de-bb-12054000-12054000', 198], ['de-bb-12064000-12064290', 199],
        ['de-bb-12072000-12072312', 200], ['de-bb-12067000-12067076', 201],
        ['de-bb-12064000-12064539', 202], ['de-bb-12066000-12066228', 203],
        ['de-bb-12067000-12067237', 204], ['de-bb-12064000-12064303', 205],
        ['de-bb-12067000-12067310', 206], ['de-bb-12063000-12063274', 207],
        ['de-bb-12068000-12068426', 208], ['de-bb-12068000-12068072', 209],
        ['de-bb-12065000-12065100', 210], ['de-bb-12065000-12065276', 211],
        ['de-bb-12062000-12062372', 212], ['de-bb-12064000-12064484', 213],
        ['de-bb-12061000-12061260', 214], ['de-bb-12061000-12061433', 215],
        ['de-bb-12062000-12062492', 216], ['de-bb-12062000-12062440', 217],
        ['de-bb-12060000-12060034', 218], ['de-bb-12060000-12060250', 219],
        ['de-bb-12062000-12062088', 220], ['de-bb-12062000-12062469', 221],
        ['de-bb-12062000-12062134', 222], ['de-bb-12062000-12062092', 223],
        ['de-bb-12061000-12061470', 224], ['de-bb-12061000-12061061', 225],
        ['de-bb-12071000-12071164', 226], ['de-bb-12071000-12071341', 227],
        ['de-bb-12061000-12061450', 228], ['de-bb-12070000-12070236', 229],
        ['de-bb-12070000-12070296', 230], ['de-bb-12070000-12070008', 231],
        ['de-bb-12071000-12071052', 232], ['de-bb-12061000-12061572', 233],
        ['de-bb-12071000-12071076', 234], ['de-bb-12060000-12060181', 235],
        ['de-bb-12071000-12071193', 236], ['de-bb-12064000-12064205', 237],
        ['de-bb-12067000-12067413', 238], ['de-bb-12067000-12067408', 239],
        ['de-bb-12068000-12068425', 240], ['de-bb-12068000-12068413', 241],
        ['de-bb-12070000-12070302', 242], ['de-bb-12065000-12065225', 243],
        ['de-bb-12065000-12065036', 244], ['de-bb-12066000-12066292', 245],
        ['de-bb-12066000-12066120', 246], ['de-bb-12066000-12066132', 247],
        ['de-bb-12066000-12066116', 248], ['de-bb-12062000-12062177', 249],
        ['de-bb-12062000-12062417', 250], ['de-bb-12070000-12070052', 251],
        ['de-bb-12070000-12070424', 252], ['de-bb-12072000-12072002', 253],
        ['de-bb-12066000-12066008', 254], ['de-bb-12060000-12060012', 255],
        ['de-bb-12060000-12060296', 256], ['de-bb-12067000-12067112', 257],
        ['de-bb-12067000-12067520', 258], ['de-bb-12067000-12067426', 259],
        ['de-bb-12067000-12067024', 260], ['de-bb-12067000-12067072', 261],
        ['de-bb-12067000-12067336', 262], ['de-bb-12067000-12067397', 263],
        ['de-bb-12071000-12071392', 264], ['de-bb-12064000-12064448', 265],
        ['de-bb-12064000-12064172', 266], ['de-bb-12065000-12065144', 267],
        ['de-bb-12065000-12065310', 268], ['de-bb-12068000-12068280', 269],
        ['de-bb-12070000-12070266', 270], ['de-bb-12064000-12064482', 271],
        ['de-bb-12064000-12064317', 272], ['de-bb-12068000-12068306', 273],
        ['de-bb-12067000-12067288', 274], ['de-bb-12062000-12062282', 275],
        ['de-bb-12062000-12062224', 276], ['de-bb-12062000-12062445', 277],
        ['de-bb-12069000-12069017', 278], ['de-bb-12069000-12069656', 279],
        ['de-bb-12067000-12067036', 280], ['de-bb-12063000-12063260', 281],
        ['de-bb-12060000-12060128', 282], ['de-bb-12073000-12073532', 283],
        ['de-bb-12062000-12062219', 284], ['de-bb-12073000-12073603', 285],
        ['de-bb-12065000-12065096', 286], ['de-bb-12067000-12067292', 287],
        ['de-bb-12067000-12067357', 288], ['de-bb-12068000-12068181', 289],
        ['de-bb-12070000-12070153', 290], ['de-bb-12069000-12069249', 291],
        ['de-bb-12060000-12060176', 292], ['de-bb-12061000-12061244', 293],
        ['de-bb-12061000-12061097', 294], ['de-bb-12061000-12061320', 295],
        ['de-bb-12071000-12071337', 296], ['de-bb-12072000-12072055', 297],
        ['de-bb-12067000-12067137', 298], ['de-bb-12064000-12064274', 299],
        ['de-bb-12064000-12064340', 300], ['de-bb-12073000-12073572', 301],
        ['de-bb-12073000-12073404', 302], ['de-bb-12064000-12064512', 303],
        ['de-bb-12064000-12064380', 304], ['de-bb-12072000-12072053', 305],
        ['de-bb-12062000-12062237', 306], ['de-bb-12062000-12062289', 307],
        ['de-bb-12062000-12062461', 308], ['de-bb-12071000-12071401', 309],
        ['de-bb-12071000-12071384', 310], ['de-bb-12072000-12072157', 311],
        ['de-bb-12066000-12066296', 312], ['de-bb-12066000-12066304', 313],
        ['de-bb-12067000-12067124', 314], ['de-bb-12065000-12065251', 315],
        ['de-bb-12066000-12066041', 316], ['de-bb-12062000-12062333', 317],
        ['de-bb-12064000-12064227', 318], ['de-bb-12061000-12061164', 319],
        ['de-bb-12070000-12070028', 320], ['de-bb-12070000-12070325', 321],
        ['de-bb-12070000-12070145', 322], ['de-bb-12060000-12060005', 323],
        ['de-bb-12061000-12061435', 324], ['de-bb-12065000-12065332', 325],
        ['de-bb-12065000-12065180', 326], ['de-bb-12060000-12060198', 327],
        ['de-bb-12065000-12065117', 328], ['de-bb-12065000-12065084', 329],
        ['de-bb-12072000-12072014', 330], ['de-bb-12061000-12061471', 331],
        ['de-bb-12072000-12072298', 332], ['de-bb-12062000-12062024', 333],
        ['de-bb-12062000-12062240', 334], ['de-bb-12069000-12069397', 335],
        ['de-bb-12069000-12069596', 336], ['de-bb-12069000-12069590', 337],
        ['de-bb-12073000-12073505', 338], ['de-bb-12066000-12066064', 339],
        ['de-bb-12071000-12071412', 340], ['de-bb-12066000-12066196', 341],
        ['de-bb-12071000-12071032', 342], ['de-bb-12061000-12061476', 343],
        ['de-bb-12071000-12071244', 344], ['de-bb-12071000-12071041', 345],
        ['de-bb-12073000-12073201', 346], ['de-bb-12073000-12073069', 347],
        ['de-bb-12071000-12071028', 348], ['de-bb-12065000-12065165', 349],
        ['de-bb-12066000-12066176', 350], ['de-bb-12063000-12063228', 351],
        ['de-bb-12068000-12068117', 352], ['de-bb-12062000-12062425', 353],
        ['de-bb-12066000-12066112', 354], ['de-bb-12062000-12062140', 355],
        ['de-bb-12070000-12070173', 356], ['de-bb-12070000-12070300', 357],
        ['de-bb-12062000-12062232', 358], ['de-bb-12061000-12061005', 359],
        ['de-bb-12067000-12067440', 360], ['de-bb-12067000-12067544', 361],
        ['de-bb-12070000-12070125', 362], ['de-bb-12073000-12073458', 363],
        ['de-bb-12073000-12073085', 364], ['de-bb-12071000-12071304', 365],
        ['de-bb-12071000-12071386', 366], ['de-bb-12071000-12071074', 367],
        ['de-bb-12071000-12071185', 368], ['de-bb-12071000-12071414', 369],
        ['de-bb-12071000-12071153', 370], ['de-bb-12062000-12062336', 371],
        ['de-bb-12062000-12062410', 372], ['de-bb-12061000-12061329', 373],
        ['de-bb-12069000-12069019', 374], ['de-bb-12069000-12069270', 375],
        ['de-bb-12069000-12069018', 376], ['de-bb-12068000-12068320', 377],
        ['de-bb-12072000-12072340', 378], ['de-bb-12072000-12072240', 379],
        ['de-bb-12072000-12072017', 380], ['de-bb-12072000-12072120', 381],
        ['de-bb-12071000-12071408', 382], ['de-bb-12071000-12071057', 383],
        ['de-bb-12066000-12066320', 384], ['de-bb-12062000-12062500', 385],
        ['de-bb-12062000-12062453', 386], ['de-bb-12073000-12073490', 387],
        ['de-bb-12073000-12073093', 388], ['de-bb-12073000-12073578', 389],
        ['de-bb-12073000-12073520', 390], ['de-bb-12060000-12060154', 391],
        ['de-bb-12073000-12073384', 392], ['de-bb-12063000-12063189', 393],
        ['de-bb-12071000-12071301', 394], ['de-bb-12070000-12070246', 395],
        ['de-bb-12070000-12070244', 396], ['de-bb-12068000-12068353', 397],
        ['de-bb-12069000-12069028', 398], ['de-bb-12072000-12072297', 399],
        ['de-bb-12060000-12060068', 400], ['de-bb-12062000-12062341', 401],
        ['de-bb-12064000-12064371', 402], ['de-bb-12073000-12073396', 403],
        ['de-bb-12070000-12070149', 404], ['de-bb-12061000-12061217', 405],
        ['de-bb-12071000-12071372', 406], ['de-bb-12069000-12069665', 407],
        ['de-bb-12066000-12066052', 408], ['de-bb-12070000-12070060', 409],
        ['de-bb-12072000-12072477', 410], ['de-bb-12067000-12067493', 411],
        ['de-bb-12060000-12060036', 412], ['de-bb-12063000-12063088', 413],
        ['de-bb-12073000-12073309', 414], ['de-bb-12069000-12069696', 415],
        ['de-bb-12072000-12072232', 416], ['de-bb-12072000-12072169', 417],
        ['de-bb-12066000-12066202', 418], ['de-bb-12061000-12061540', 419],
        ['de-bb-12068000-12068417', 420], ['de-bb-12061000-12061219', 421],
        ['de-bb-12070000-12070416', 422], ['de-bb-12063000-12063036', 423],
        ['de-bb-12064000-12064190', 424], ['de-bb-12061000-12061308', 425],
        ['de-bb-12061000-12061224', 426], ['de-bb-12065000-12065356', 427],
        ['de-bb-12061000-12061020', 428], [null, 429]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-bb-all-all.topo.json">Brandenburg</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
