(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-bw-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-bw-08136000-08136071', 10], ['de-bw-08215000-08215102', 11],
        ['de-bw-08216000-08216002', 12], ['de-bw-08117000-08117020', 13],
        ['de-bw-08117000-08117030', 14], ['de-bw-08337000-08337066', 15],
        ['de-bw-08225000-08225082', 16], ['de-bw-08128000-08128138', 17],
        ['de-bw-08225000-08225114', 18], ['de-bw-08335000-08335080', 19],
        ['de-bw-08326000-08326005', 20], ['de-bw-08317000-08317047', 21],
        ['de-bw-08317000-08317122', 22], ['de-bw-08226000-08226040', 23],
        ['de-bw-08226000-08226031', 24], ['de-bw-08226000-08226009', 25],
        ['de-bw-08326000-08326006', 26], ['de-bw-08426000-08426117', 27],
        ['de-bw-08426000-08426100', 28], ['de-bw-08426000-08426097', 29],
        ['de-bw-08317000-08317096', 30], ['de-bw-08335000-08335035', 31],
        ['de-bw-08436000-08436003', 32], ['de-bw-08436000-08436004', 33],
        ['de-bw-08211000-08211000', 34], ['de-bw-08216000-08216008', 35],
        ['de-bw-08216000-08216013', 36], ['de-bw-08215000-08215101', 37],
        ['de-bw-08215000-08215089', 38], ['de-bw-08136000-08136050', 39],
        ['de-bw-08136000-08136088', 40], ['de-bw-08118000-08118053', 41],
        ['de-bw-08426000-08426121', 42], ['de-bw-08335000-08335079', 43],
        ['de-bw-08326000-08326065', 44], ['de-bw-08337000-08337126', 45],
        ['de-bw-08317000-08317151', 46], ['de-bw-08125000-08125006', 47],
        ['de-bw-08226000-08226055', 48], ['de-bw-08317000-08317141', 49],
        ['de-bw-08136000-08136002', 50], ['de-bw-08425000-08425066', 51],
        ['de-bw-08425000-08425130', 52], ['de-bw-08416000-08416036', 53],
        ['de-bw-08116000-08116006', 54], ['de-bw-08415000-08415061', 55],
        ['de-bw-08336000-08336103', 56], ['de-bw-08215000-08215007', 57],
        ['de-bw-08215000-08215059', 58], ['de-bw-08236000-08236033', 59],
        ['de-bw-08125000-08125013', 60], ['de-bw-08125000-08125086', 61],
        ['de-bw-08216000-08216049', 62], ['de-bw-08317000-08317088', 63],
        ['de-bw-08317000-08317085', 64], ['de-bw-08115000-08115024', 65],
        ['de-bw-08317000-08317001', 66], ['de-bw-08336000-08336079', 67],
        ['de-bw-08315000-08315089', 68], ['de-bw-08315000-08315098', 69],
        ['de-bw-08215000-08215110', 70], ['de-bw-08215000-08215096', 71],
        ['de-bw-08335000-08335043', 72], ['de-bw-08435000-08435010', 73],
        ['de-bw-08435000-08435066', 74], ['de-bw-08326000-08326068', 75],
        ['de-bw-08225000-08225009', 76], ['de-bw-08125000-08125063', 77],
        ['de-bw-08315000-08315132', 78], ['de-bw-08316000-08316045', 79],
        ['de-bw-08316000-08316049', 80], ['de-bw-08316000-08316013', 81],
        ['de-bw-08226000-08226063', 82], ['de-bw-08226000-08226062', 83],
        ['de-bw-08128000-08128137', 84], ['de-bw-08226000-08226095', 85],
        ['de-bw-08226000-08226076', 86], ['de-bw-08127000-08127032', 87],
        ['de-bw-08127000-08127046', 88], ['de-bw-08316000-08316012', 89],
        ['de-bw-08327000-08327010', 90], ['de-bw-08327000-08327017', 91],
        ['de-bw-08327000-08327002', 92], ['de-bw-08437000-08437102', 93],
        ['de-bw-08417000-08417045', 94], ['de-bw-08316000-08316053', 95],
        ['de-bw-08127000-08127008', 96], ['de-bw-08226000-08226080', 97],
        ['de-bw-08221000-08221000', 98], ['de-bw-08226000-08226101', 99],
        ['de-bw-08226000-08226049', 100], ['de-bw-08125000-08125079', 101],
        ['de-bw-08125000-08125039', 102], ['de-bw-08127000-08127062', 103],
        ['de-bw-08127000-08127076', 104], ['de-bw-08337000-08337076', 105],
        ['de-bw-08335000-08335099', 106], ['de-bw-08335000-08335081', 107],
        ['de-bw-08225000-08225014', 108], ['de-bw-08225000-08225052', 109],
        ['de-bw-08225000-08225024', 110], ['de-bw-08426000-08426043', 111],
        ['de-bw-08315000-08315084', 112], ['de-bw-08311000-08311000', 113],
        ['de-bw-08315000-08315056', 114], ['de-bw-08119000-08119079', 115],
        ['de-bw-08119000-08119090', 116], ['de-bw-08119000-08119086', 117],
        ['de-bw-08315000-08315130', 118], ['de-bw-08315000-08315131', 119],
        ['de-bw-08226000-08226020', 120], ['de-bw-08128000-08128139', 121],
        ['de-bw-08125000-08125084', 122], ['de-bw-08119000-08119093', 123],
        ['de-bw-08226000-08226037', 124], ['de-bw-08435000-08435053', 125],
        ['de-bw-08226000-08226103', 126], ['de-bw-08215000-08215039', 127],
        ['de-bw-08212000-08212000', 128], ['de-bw-08437000-08437065', 129],
        ['de-bw-08437000-08437078', 130], ['de-bw-08118000-08118078', 131],
        ['de-bw-08118000-08118077', 132], ['de-bw-08119000-08119089', 133],
        ['de-bw-08225000-08225115', 134], ['de-bw-08225000-08225118', 135],
        ['de-bw-08337000-08337124', 136], ['de-bw-08337000-08337062', 137],
        ['de-bw-08231000-08231000', 138], ['de-bw-08236000-08236073', 139],
        ['de-bw-08337000-08337116', 140], ['de-bw-08336000-08336034', 141],
        ['de-bw-08315000-08315047', 142], ['de-bw-08315000-08315051', 143],
        ['de-bw-08417000-08417078', 144], ['de-bw-08325000-08325011', 145],
        ['de-bw-08335000-08335021', 146], ['de-bw-08335000-08335022', 147],
        ['de-bw-08325000-08325049', 148], ['de-bw-08128000-08128061', 149],
        ['de-bw-08128000-08128064', 150], ['de-bw-08128000-08128128', 151],
        ['de-bw-08128000-08128014', 152], ['de-bw-08225000-08225042', 153],
        ['de-bw-08225000-08225033', 154], ['de-bw-08125000-08125087', 155],
        ['de-bw-08337000-08337030', 156], ['de-bw-08337000-08337065', 157],
        ['de-bw-08336000-08336043', 158], ['de-bw-08336000-08336050', 159],
        ['de-bw-08236000-08236030', 160], ['de-bw-08425000-08425033', 161],
        ['de-bw-08425000-08425004', 162], ['de-bw-08336000-08336025', 163],
        ['de-bw-08336000-08336094', 164], ['de-bw-08316000-08316011', 165],
        ['de-bw-08316000-08316036', 166], ['de-bw-08316000-08316037', 167],
        ['de-bw-08327000-08327040', 168], ['de-bw-08327000-08327007', 169],
        ['de-bw-08327000-08327013', 170], ['de-bw-08236000-08236062', 171],
        ['de-bw-08236000-08236067', 172], ['de-bw-08237000-08237072', 173],
        ['de-bw-08237000-08237032', 174], ['de-bw-08119000-08119069', 175],
        ['de-bw-08119000-08119053', 176], ['de-bw-08425000-08425112', 177],
        ['de-bw-08425000-08425092', 178], ['de-bw-08115000-08115054', 179],
        ['de-bw-08115000-08115050', 180], ['de-bw-08235000-08235067', 181],
        ['de-bw-08236000-08236044', 182], ['de-bw-08235000-08235073', 183],
        ['de-bw-08425000-08425031', 184], ['de-bw-08425000-08425084', 185],
        ['de-bw-08136000-08136035', 186], ['de-bw-08136000-08136018', 187],
        ['de-bw-08226000-08226097', 188], ['de-bw-08215000-08215100', 189],
        ['de-bw-08215000-08215103', 190], ['de-bw-08215000-08215099', 191],
        ['de-bw-08215000-08215109', 192], ['de-bw-08226000-08226048', 193],
        ['de-bw-08436000-08436040', 194], ['de-bw-08436000-08436077', 195],
        ['de-bw-08425000-08425123', 196], ['de-bw-08425000-08425090', 197],
        ['de-bw-08316000-08316051', 198], ['de-bw-08128000-08128045', 199],
        ['de-bw-08435000-08435042', 200], ['de-bw-08436000-08436006', 201],
        ['de-bw-08119000-08119083', 202], ['de-bw-08119000-08119006', 203],
        ['de-bw-08415000-08415027', 204], ['de-bw-08415000-08415089', 205],
        ['de-bw-08235000-08235080', 206], ['de-bw-08235000-08235046', 207],
        ['de-bw-08235000-08235032', 208], ['de-bw-08237000-08237074', 209],
        ['de-bw-08235000-08235060', 210], ['de-bw-08226000-08226086', 211],
        ['de-bw-08326000-08326027', 212], ['de-bw-08225000-08225116', 213],
        ['de-bw-08226000-08226081', 214], ['de-bw-08226000-08226013', 215],
        ['de-bw-08315000-08315013', 216], ['de-bw-08335000-08335098', 217],
        ['de-bw-08226000-08226104', 218], ['de-bw-08226000-08226066', 219],
        ['de-bw-08226000-08226017', 220], ['de-bw-08226000-08226106', 221],
        ['de-bw-08315000-08315072', 222], ['de-bw-08416000-08416009', 223],
        ['de-bw-08115000-08115051', 224], ['de-bw-08325000-08325071', 225],
        ['de-bw-08325000-08325024', 226], ['de-bw-08326000-08326012', 227],
        ['de-bw-08225000-08225001', 228], ['de-bw-08128000-08128058', 229],
        ['de-bw-08226000-08226058', 230], ['de-bw-08235000-08235006', 231],
        ['de-bw-08226000-08226091', 232], ['de-bw-08215000-08215108', 233],
        ['de-bw-08336000-08336105', 234], ['de-bw-08336000-08336069', 235],
        ['de-bw-08337000-08337090', 236], ['de-bw-08327000-08327055', 237],
        ['de-bw-08327000-08327020', 238], ['de-bw-08317000-08317118', 239],
        ['de-bw-08317000-08317116', 240], ['de-bw-08317000-08317068', 241],
        ['de-bw-08415000-08415029', 242], ['de-bw-08116000-08116020', 243],
        ['de-bw-08116000-08116022', 244], ['de-bw-08336000-08336075', 245],
        ['de-bw-08336000-08336024', 246], ['de-bw-08215000-08215021', 247],
        ['de-bw-08215000-08215009', 248], ['de-bw-08315000-08315076', 249],
        ['de-bw-08315000-08315022', 250], ['de-bw-08315000-08315073', 251],
        ['de-bw-08315000-08315028', 252], ['de-bw-08325000-08325014', 253],
        ['de-bw-08118000-08118048', 254], ['de-bw-08118000-08118071', 255],
        ['de-bw-08118000-08118003', 256], ['de-bw-08225000-08225109', 257],
        ['de-bw-08421000-08421000', 258], ['de-bw-08135000-08135021', 259],
        ['de-bw-08111000-08111000', 260], ['de-bw-08118000-08118011', 261],
        ['de-bw-08222000-08222000', 262], ['de-bw-08426000-08426038', 263],
        ['de-bw-08426000-08426087', 264], ['de-bw-08426000-08426045', 265],
        ['de-bw-08436000-08436067', 266], ['de-bw-08425000-08425035', 267],
        ['de-bw-08226000-08226084', 268], ['de-bw-08118000-08118079', 269],
        ['de-bw-08118000-08118028', 270], ['de-bw-08125000-08125102', 271],
        ['de-bw-08121000-08121000', 272], ['de-bw-08125000-08125030', 273],
        ['de-bw-08317000-08317078', 274], ['de-bw-08317000-08317040', 275],
        ['de-bw-08317000-08317029', 276], ['de-bw-08136000-08136070', 277],
        ['de-bw-08136000-08136040', 278], ['de-bw-08119000-08119024', 279],
        ['de-bw-08127000-08127025', 280], ['de-bw-08127000-08127100', 281],
        ['de-bw-08119000-08119044', 282], ['de-bw-08119000-08119075', 283],
        ['de-bw-08119000-08119037', 284], ['de-bw-08116000-08116071', 285],
        ['de-bw-08116000-08116068', 286], ['de-bw-08116000-08116073', 287],
        ['de-bw-08125000-08125113', 288], ['de-bw-08125000-08125021', 289],
        ['de-bw-08226000-08226105', 290], ['de-bw-08226000-08226012', 291],
        ['de-bw-08317000-08317056', 292], ['de-bw-08317000-08317067', 293],
        ['de-bw-08237000-08237054', 294], ['de-bw-08317000-08317098', 295],
        ['de-bw-08115000-08115042', 296], ['de-bw-08118000-08118027', 297],
        ['de-bw-08115000-08115021', 298], ['de-bw-08115000-08115053', 299],
        ['de-bw-08115000-08115034', 300], ['de-bw-08336000-08336004', 301],
        ['de-bw-08317000-08317152', 302], ['de-bw-08216000-08216039', 303],
        ['de-bw-08216000-08216052', 304], ['de-bw-08118000-08118054', 305],
        ['de-bw-08118000-08118049', 306], ['de-bw-08119000-08119008', 307],
        ['de-bw-08119000-08119085', 308], ['de-bw-08119000-08119068', 309],
        ['de-bw-08118000-08118014', 310], ['de-bw-08136000-08136044', 311],
        ['de-bw-08119000-08119001', 312], ['de-bw-08119000-08119076', 313],
        ['de-bw-08226000-08226038', 314], ['de-bw-08415000-08415080', 315],
        ['de-bw-08416000-08416023', 316], ['de-bw-08226000-08226028', 317],
        ['de-bw-08416000-08416015', 318], ['de-bw-08226000-08226036', 319],
        ['de-bw-08416000-08416025', 320], ['de-bw-08425000-08425022', 321],
        ['de-bw-08425000-08425005', 322], ['de-bw-08337000-08337128', 323],
        ['de-bw-08337000-08337022', 324], ['de-bw-08315000-08315020', 325],
        ['de-bw-08315000-08315016', 326], ['de-bw-08226000-08226102', 327],
        ['de-bw-08215000-08215064', 328], ['de-bw-08426000-08426058', 329],
        ['de-bw-08426000-08426021', 330], ['de-bw-08115000-08115028', 331],
        ['de-bw-08336000-08336107', 332], ['de-bw-08336000-08336010', 333],
        ['de-bw-08125000-08125110', 334], ['de-bw-08436000-08436032', 335],
        ['de-bw-08436000-08436024', 336], ['de-bw-08128000-08128082', 337],
        ['de-bw-08126000-08126056', 338], ['de-bw-08127000-08127047', 339],
        ['de-bw-08436000-08436013', 340], ['de-bw-08436000-08436011', 341],
        ['de-bw-08127000-08127075', 342], ['de-bw-08425000-08425104', 343],
        ['de-bw-08425000-08425081', 344], ['de-bw-08425000-08425124', 345],
        ['de-bw-08426000-08426134', 346], ['de-bw-08436000-08436083', 347],
        ['de-bw-08226000-08226096', 348], ['de-bw-08437000-08437086', 349],
        ['de-bw-08225000-08225113', 350], ['de-bw-08225000-08225068', 351],
        ['de-bw-08128000-08128006', 352], ['de-bw-08126000-08126045', 353],
        ['de-bw-08126000-08126072', 354], ['de-bw-08126000-08126020', 355],
        ['de-bw-08436000-08436079', 356], ['de-bw-08127000-08127089', 357],
        ['de-bw-08436000-08436053', 358], ['de-bw-08437000-08437114', 359],
        ['de-bw-08417000-08417075', 360], ['de-bw-08335000-08335066', 361],
        ['de-bw-08436000-08436014', 362], ['de-bw-08436000-08436012', 363],
        ['de-bw-08436000-08436096', 364], ['de-bw-08226000-08226098', 365],
        ['de-bw-08335000-08335100', 366], ['de-bw-08335000-08335028', 367],
        ['de-bw-08437000-08437101', 368], ['de-bw-08437000-08437008', 369],
        ['de-bw-08437000-08437118', 370], ['de-bw-08335000-08335096', 371],
        ['de-bw-08437000-08437123', 372], ['de-bw-08436000-08436027', 373],
        ['de-bw-08426000-08426067', 374], ['de-bw-08437000-08437047', 375],
        ['de-bw-08426000-08426066', 376], ['de-bw-08435000-08435054', 377],
        ['de-bw-08436000-08436087', 378], ['de-bw-08437000-08437105', 379],
        ['de-bw-08426000-08426113', 380], ['de-bw-08436000-08436009', 381],
        ['de-bw-08426000-08426109', 382], ['de-bw-08426000-08426005', 383],
        ['de-bw-08437000-08437104', 384], ['de-bw-08437000-08437124', 385],
        ['de-bw-08436000-08436005', 386], ['de-bw-08436000-08436019', 387],
        ['de-bw-08426000-08426090', 388], ['de-bw-08426000-08426014', 389],
        ['de-bw-08425000-08425036', 390], ['de-bw-08436000-08436078', 391],
        ['de-bw-08426000-08426073', 392], ['de-bw-08436000-08436047', 393],
        ['de-bw-08426000-08426006', 394], ['de-bw-08436000-08436095', 395],
        ['de-bw-08436000-08436010', 396], ['de-bw-08436000-08436001', 397],
        ['de-bw-08436000-08436081', 398], ['de-bw-08435000-08435057', 399],
        ['de-bw-08435000-08435029', 400], ['de-bw-08426000-08426078', 401],
        ['de-bw-08236000-08236076', 402], ['de-bw-08236000-08236074', 403],
        ['de-bw-08426000-08426135', 404], ['de-bw-08425000-08425140', 405],
        ['de-bw-08236000-08236011', 406], ['de-bw-08236000-08236070', 407],
        ['de-bw-08437000-08437072', 408], ['de-bw-08216000-08216017', 409],
        ['de-bw-08216000-08216007', 410], ['de-bw-08317000-08317039', 411],
        ['de-bw-08435000-08435013', 412], ['de-bw-08226000-08226027', 413],
        ['de-bw-08426000-08426120', 414], ['de-bw-08315000-08315115', 415],
        ['de-bw-08426000-08426062', 416], ['de-bw-08315000-08315043', 417],
        ['de-bw-08426000-08426065', 418], ['de-bw-08437000-08437100', 419],
        ['de-bw-08426000-08426036', 420], ['de-bw-08426000-08426118', 421],
        ['de-bw-08426000-08426013', 422], ['de-bw-08226000-08226003', 423],
        ['de-bw-08215000-08215107', 424], ['de-bw-08317000-08317046', 425],
        ['de-bw-08317000-08317129', 426], ['de-bw-08317000-08317146', 427],
        ['de-bw-08325000-08325051', 428], ['de-bw-08325000-08325036', 429],
        ['de-bw-08437000-08437076', 430], ['de-bw-08426000-08426031', 431],
        ['de-bw-08416000-08416011', 432], ['de-bw-08416000-08416026', 433],
        ['de-bw-08425000-08425098', 434], ['de-bw-08415000-08415085', 435],
        ['de-bw-08426000-08426108', 436], ['de-bw-08426000-08426070', 437],
        ['de-bw-08327000-08327008', 438], ['de-bw-08315000-08315070', 439],
        ['de-bw-08315000-08315068', 440], ['de-bw-08315000-08315052', 441],
        ['de-bw-08125000-08125068', 442], ['de-bw-08315000-08315014', 443],
        ['de-bw-08125000-08125005', 444], ['de-bw-08125000-08125096', 445],
        ['de-bw-08125000-08125007', 446], ['de-bw-08425000-08425008', 447],
        ['de-bw-08425000-08425072', 448], ['de-bw-08425000-08425014', 449],
        ['de-bw-08425000-08425002', 450], ['de-bw-08116000-08116049', 451],
        ['de-bw-08116000-08116050', 452], ['de-bw-08116000-08116081', 453],
        ['de-bw-08118000-08118016', 454], ['de-bw-08118000-08118047', 455],
        ['de-bw-08127000-08127052', 456], ['de-bw-08426000-08426011', 457],
        ['de-bw-08425000-08425052', 458], ['de-bw-08425000-08425091', 459],
        ['de-bw-08436000-08436085', 460], ['de-bw-08425000-08425071', 461],
        ['de-bw-08415000-08415971', 462], ['de-bw-08136000-08136046', 463],
        ['de-bw-08117000-08117017', 464], ['de-bw-08117000-08117012', 465],
        ['de-bw-08118000-08118060', 466], ['de-bw-08118000-08118021', 467],
        ['de-bw-08117000-08117015', 468], ['de-bw-08117000-08117025', 469],
        ['de-bw-08136000-08136043', 470], ['de-bw-08136000-08136028', 471],
        ['de-bw-08335000-08335001', 472], ['de-bw-08325000-08325045', 473],
        ['de-bw-08325000-08325070', 474], ['de-bw-08336000-08336084', 475],
        ['de-bw-08336000-08336081', 476], ['de-bw-08436000-08436069', 477],
        ['de-bw-08436000-08436039', 478], ['de-bw-08125000-08125034', 479],
        ['de-bw-08125000-08125049', 480], ['de-bw-08425000-08425055', 481],
        ['de-bw-08335000-08335002', 482], ['de-bw-08426000-08426035', 483],
        ['de-bw-08437000-08437053', 484], ['de-bw-08115000-08115003', 485],
        ['de-bw-08216000-08216059', 486], ['de-bw-08226000-08226032', 487],
        ['de-bw-08226000-08226059', 488], ['de-bw-08426000-08426124', 489],
        ['de-bw-08335000-08335063', 490], ['de-bw-08315000-08315125', 491],
        ['de-bw-08315000-08315107', 492], ['de-bw-08417000-08417079', 493],
        ['de-bw-08437000-08437107', 494], ['de-bw-08316000-08316038', 495],
        ['de-bw-08316000-08316039', 496], ['de-bw-08316000-08316009', 497],
        ['de-bw-08316000-08316056', 498], ['de-bw-08317000-08317065', 499],
        ['de-bw-08317000-08317073', 500], ['de-bw-08317000-08317127', 501],
        ['de-bw-08315000-08315113', 502], ['de-bw-08125000-08125108', 503],
        ['de-bw-08215000-08215082', 504], ['de-bw-08236000-08236075', 505],
        ['de-bw-08216000-08216015', 506], ['de-bw-08215000-08215047', 507],
        ['de-bw-08235000-08235084', 508], ['de-bw-08235000-08235047', 509],
        ['de-bw-08216000-08216029', 510], ['de-bw-08435000-08435030', 511],
        ['de-bw-08327000-08327048', 512], ['de-bw-08327000-08327025', 513],
        ['de-bw-08327000-08327057', 514], ['de-bw-08316000-08316020', 515],
        ['de-bw-08235000-08235007', 516], ['de-bw-08235000-08235057', 517],
        ['de-bw-08315000-08315108', 518], ['de-bw-08236000-08236061', 519],
        ['de-bw-08315000-08315111', 520], ['de-bw-08336000-08336057', 521],
        ['de-bw-08337000-08337002', 522], ['de-bw-08215000-08215111', 523],
        ['de-bw-08215000-08215090', 524], ['de-bw-08425000-08425028', 525],
        ['de-bw-08337000-08337049', 526], ['de-bw-08426000-08426125', 527],
        ['de-bw-08435000-08435052', 528], ['de-bw-08435000-08435036', 529],
        ['de-bw-08435000-08435005', 530], ['de-bw-08226000-08226068', 531],
        ['de-bw-08425000-08425141', 532], ['de-bw-08425000-08425017', 533],
        ['de-bw-08235000-08235008', 534], ['de-bw-08337000-08337051', 535],
        ['de-bw-08337000-08337045', 536], ['de-bw-08337000-08337097', 537],
        ['de-bw-08426000-08426028', 538], ['de-bw-08426000-08426001', 539],
        ['de-bw-08317000-08317031', 540], ['de-bw-08435000-08435024', 541],
        ['de-bw-08235000-08235025', 542], ['de-bw-08337000-08337059', 543],
        ['de-bw-08326000-08326041', 544], ['de-bw-08326000-08326010', 545],
        ['de-bw-08326000-08326052', 546], ['de-bw-08327000-08327049', 547],
        ['de-bw-08326000-08326061', 548], ['de-bw-08326000-08326074', 549],
        ['de-bw-08336000-08336096', 550], ['de-bw-08226000-08226029', 551],
        ['de-bw-08215000-08215084', 552], ['de-bw-08327000-08327012', 553],
        ['de-bw-08337000-08337123', 554], ['de-bw-08215000-08215094', 555],
        ['de-bw-08125000-08125026', 556], ['de-bw-08417000-08417036', 557],
        ['de-bw-08317000-08317093', 558], ['de-bw-08215000-08215105', 559],
        ['de-bw-08315000-08315003', 560], ['de-bw-08315000-08315074', 561],
        ['de-bw-08337000-08337118', 562], ['de-bw-08337000-08337125', 563],
        ['de-bw-08337000-08337053', 564], ['de-bw-08216000-08216028', 565],
        ['de-bw-08317000-08317153', 566], ['de-bw-08136000-08136009', 567],
        ['de-bw-08136000-08136034', 568], ['de-bw-08415000-08415034', 569],
        ['de-bw-08125000-08125008', 570], ['de-bw-08125000-08125046', 571],
        ['de-bw-08415000-08415090', 572], ['de-bw-08415000-08415053', 573],
        ['de-bw-08425000-08425079', 574], ['de-bw-08117000-08117031', 575],
        ['de-bw-08125000-08125107', 576], ['de-bw-08425000-08425134', 577],
        ['de-bw-08317000-08317011', 578], ['de-bw-08327000-08327046', 579],
        ['de-bw-08327000-08327005', 580], ['de-bw-08216000-08216006', 581],
        ['de-bw-08118000-08118006', 582], ['de-bw-08236000-08236068', 583],
        ['de-bw-08317000-08317041', 584], ['de-bw-08215000-08215040', 585],
        ['de-bw-08118000-08118010', 586], ['de-bw-08125000-08125038', 587],
        ['de-bw-08337000-08337032', 588], ['de-bw-08118000-08118040', 589],
        ['de-bw-08118000-08118018', 590], ['de-bw-08115000-08115037', 591],
        ['de-bw-08115000-08115022', 592], ['de-bw-08325000-08325057', 593],
        ['de-bw-08417000-08417054', 594], ['de-bw-08416000-08416049', 595],
        ['de-bw-08115000-08115004', 596], ['de-bw-08426000-08426008', 597],
        ['de-bw-08226000-08226041', 598], ['de-bw-08226000-08226022', 599],
        ['de-bw-08435000-08435047', 600], ['de-bw-08435000-08435059', 601],
        ['de-bw-08226000-08226060', 602], ['de-bw-08435000-08435015', 603],
        ['de-bw-08327000-08327036', 604], ['de-bw-08327000-08327033', 605],
        ['de-bw-08116000-08116014', 606], ['de-bw-08116000-08116072', 607],
        ['de-bw-08225000-08225064', 608], ['de-bw-08225000-08225058', 609],
        ['de-bw-08236000-08236039', 610], ['de-bw-08235000-08235066', 611],
        ['de-bw-08235000-08235050', 612], ['de-bw-08317000-08317008', 613],
        ['de-bw-08237000-08237030', 614], ['de-bw-08237000-08237040', 615],
        ['de-bw-08337000-08337013', 616], ['de-bw-08417000-08417051', 617],
        ['de-bw-08417000-08417023', 618], ['de-bw-08417000-08417002', 619],
        ['de-bw-08336000-08336073', 620], ['de-bw-08326000-08326003', 621],
        ['de-bw-08326000-08326075', 622], ['de-bw-08327000-08327018', 623],
        ['de-bw-08216000-08216012', 624], ['de-bw-08327000-08327011', 625],
        ['de-bw-08327000-08327054', 626], ['de-bw-08425000-08425020', 627],
        ['de-bw-08136000-08136066', 628], ['de-bw-08136000-08136015', 629],
        ['de-bw-08136000-08136061', 630], ['de-bw-08119000-08119018', 631],
        ['de-bw-08425000-08425039', 632], ['de-bw-08425000-08425093', 633],
        ['de-bw-08317000-08317110', 634], ['de-bw-08315000-08315007', 635],
        ['de-bw-08336000-08336006', 636], ['de-bw-08118000-08118074', 637],
        ['de-bw-08425000-08425073', 638], ['de-bw-08326000-08326017', 639],
        ['de-bw-08316000-08316042', 640], ['de-bw-08116000-08116037', 641],
        ['de-bw-08116000-08116058', 642], ['de-bw-08236000-08236065', 643],
        ['de-bw-08317000-08317051', 644], ['de-bw-08325000-08325053', 645],
        ['de-bw-08326000-08326060', 646], ['de-bw-08326000-08326055', 647],
        ['de-bw-08125000-08125065', 648], ['de-bw-08125000-08125027', 649],
        ['de-bw-08325000-08325015', 650], ['de-bw-08325000-08325060', 651],
        ['de-bw-08325000-08325009', 652], ['de-bw-08337000-08337127', 653],
        ['de-bw-08136000-08136019', 654], ['de-bw-08136000-08136068', 655],
        ['de-bw-08119000-08119038', 656], ['de-bw-08116000-08116048', 657],
        ['de-bw-08116000-08116027', 658], ['de-bw-08117000-08117061', 659],
        ['de-bw-08136000-08136079', 660], ['de-bw-08317000-08317097', 661],
        ['de-bw-08317000-08317021', 662], ['de-bw-08317000-08317100', 663],
        ['de-bw-08425000-08425075', 664], ['de-bw-08425000-08425135', 665],
        ['de-bw-08425000-08425062', 666], ['de-bw-08216000-08216023', 667],
        ['de-bw-08425000-08425024', 668], ['de-bw-08135000-08135019', 669],
        ['de-bw-08125000-08125069', 670], ['de-bw-08128000-08128131', 671],
        ['de-bw-08127000-08127009', 672], ['de-bw-08116000-08116041', 673],
        ['de-bw-08316000-08316010', 674], ['de-bw-08119000-08119091', 675],
        ['de-bw-08316000-08316014', 676], ['de-bw-08425000-08425097', 677],
        ['de-bw-08117000-08117060', 678], ['de-bw-08116000-08116029', 679],
        ['de-bw-08135000-08135025', 680], ['de-bw-08317000-08317026', 681],
        ['de-bw-08115000-08115015', 682], ['de-bw-08317000-08317059', 683],
        ['de-bw-08317000-08317150', 684], ['de-bw-08226000-08226018', 685],
        ['de-bw-08317000-08317057', 686], ['de-bw-08317000-08317005', 687],
        ['de-bw-08235000-08235055', 688], ['de-bw-08125000-08125074', 689],
        ['de-bw-08125000-08125098', 690], ['de-bw-08415000-08415059', 691],
        ['de-bw-08136000-08136087', 692], ['de-bw-08136000-08136045', 693],
        ['de-bw-08415000-08415019', 694], ['de-bw-08415000-08415092', 695],
        ['de-bw-08125000-08125061', 696], ['de-bw-08119000-08119087', 697],
        ['de-bw-08136000-08136075', 698], ['de-bw-08117000-08117014', 699],
        ['de-bw-08415000-08415088', 700], ['de-bw-08119000-08119042', 701],
        ['de-bw-08425000-08425019', 702], ['de-bw-08437000-08437056', 703],
        ['de-bw-08437000-08437088', 704], ['de-bw-08436000-08436082', 705],
        ['de-bw-08436000-08436064', 706], ['de-bw-08417000-08417014', 707],
        ['de-bw-08417000-08417015', 708], ['de-bw-08317000-08317102', 709],
        ['de-bw-08417000-08417022', 710], ['de-bw-08226000-08226082', 711],
        ['de-bw-08325000-08325012', 712], ['de-bw-08118000-08118068', 713],
        ['de-bw-08118000-08118059', 714], ['de-bw-08216000-08216063', 715],
        ['de-bw-08126000-08126060', 716], ['de-bw-08126000-08126039', 717],
        ['de-bw-08317000-08317126', 718], ['de-bw-08127000-08127063', 719],
        ['de-bw-08127000-08127013', 720], ['de-bw-08126000-08126028', 721],
        ['de-bw-08125000-08125103', 722], ['de-bw-08336000-08336045', 723],
        ['de-bw-08127000-08127012', 724], ['de-bw-08125000-08125048', 725],
        ['de-bw-08326000-08326020', 726], ['de-bw-08315000-08315094', 727],
        ['de-bw-08336000-08336100', 728], ['de-bw-08417000-08417025', 729],
        ['de-bw-08136000-08136065', 730], ['de-bw-08117000-08117053', 731],
        ['de-bw-08127000-08127043', 732], ['de-bw-08116000-08116053', 733],
        ['de-bw-08136000-08136033', 734], ['de-bw-08126000-08126086', 735],
        ['de-bw-08118000-08118015', 736], ['de-bw-08118000-08118001', 737],
        ['de-bw-08136000-08136020', 738], ['de-bw-08127000-08127079', 739],
        ['de-bw-08136000-08136062', 740], ['de-bw-08117000-08117037', 741],
        ['de-bw-08117000-08117019', 742], ['de-bw-08117000-08117042', 743],
        ['de-bw-08117000-08117011', 744], ['de-bw-08125000-08125094', 745],
        ['de-bw-08117000-08117009', 746], ['de-bw-08118000-08118081', 747],
        ['de-bw-08118000-08118046', 748], ['de-bw-08425000-08425013', 749],
        ['de-bw-08116000-08116077', 750], ['de-bw-08116000-08116047', 751],
        ['de-bw-08426000-08426071', 752], ['de-bw-08116000-08116005', 753],
        ['de-bw-08117000-08117007', 754], ['de-bw-08117000-08117016', 755],
        ['de-bw-08118000-08118050', 756], ['de-bw-08118000-08118073', 757],
        ['de-bw-08226000-08226099', 758], ['de-bw-08226000-08226056', 759],
        ['de-bw-08116000-08116012', 760], ['de-bw-08116000-08116033', 761],
        ['de-bw-08425000-08425088', 762], ['de-bw-08117000-08117035', 763],
        ['de-bw-08117000-08117058', 764], ['de-bw-08119000-08119055', 765],
        ['de-bw-08117000-08117001', 766], ['de-bw-08116000-08116054', 767],
        ['de-bw-08116000-08116018', 768], ['de-bw-08125000-08125066', 769],
        ['de-bw-08118000-08118007', 770], ['de-bw-08116000-08116016', 771],
        ['de-bw-08125000-08125059', 772], ['de-bw-08136000-08136003', 773],
        ['de-bw-08415000-08415014', 774], ['de-bw-08415000-08415093', 775],
        ['de-bw-08136000-08136021', 776], ['de-bw-08116000-08116007', 777],
        ['de-bw-08119000-08119067', 778], ['de-bw-08425000-08425110', 779],
        ['de-bw-08425000-08425050', 780], ['de-bw-08119000-08119084', 781],
        ['de-bw-08425000-08425125', 782], ['de-bw-08117000-08117044', 783],
        ['de-bw-08436000-08436008', 784], ['de-bw-08117000-08117003', 785],
        ['de-bw-08127000-08127099', 786], ['de-bw-08117000-08117024', 787],
        ['de-bw-08117000-08117033', 788], ['de-bw-08435000-08435067', 789],
        ['de-bw-08435000-08435045', 790], ['de-bw-08435000-08435034', 791],
        ['de-bw-08115000-08115046', 792], ['de-bw-08435000-08435020', 793],
        ['de-bw-08115000-08115044', 794], ['de-bw-08436000-08436018', 795],
        ['de-bw-08118000-08118070', 796], ['de-bw-08425000-08425137', 797],
        ['de-bw-08425000-08425138', 798], ['de-bw-08125000-08125024', 799],
        ['de-bw-08425000-08425139', 800], ['de-bw-08425000-08425083', 801],
        ['de-bw-08415000-08415062', 802], ['de-bw-08116000-08116036', 803],
        ['de-bw-08116000-08116015', 804], ['de-bw-08135000-08135027', 805],
        ['de-bw-08437000-08437082', 806], ['de-bw-08119000-08119061', 807],
        ['de-bw-08225000-08225002', 808], ['de-bw-08136000-08136082', 809],
        ['de-bw-08136000-08136007', 810], ['de-bw-08135000-08135032', 811],
        ['de-bw-08215000-08215066', 812], ['de-bw-08117000-08117029', 813],
        ['de-bw-08126000-08126011', 814], ['de-bw-08127000-08127014', 815],
        ['de-bw-08119000-08119004', 816], ['de-bw-08127000-08127104', 817],
        ['de-bw-08127000-08127102', 818], ['de-bw-08426000-08426044', 819],
        ['de-bw-08215000-08215025', 820], ['de-bw-08426000-08426019', 821],
        ['de-bw-08436000-08436093', 822], ['de-bw-08127000-08127101', 823],
        ['de-bw-08119000-08119003', 824], ['de-bw-08416000-08416041', 825],
        ['de-bw-08415000-08415060', 826], ['de-bw-08416000-08416022', 827],
        ['de-bw-08116000-08116046', 828], ['de-bw-08136000-08136027', 829],
        ['de-bw-08116000-08116078', 830], ['de-bw-08117000-08117006', 831],
        ['de-bw-08136000-08136029', 832], ['de-bw-08117000-08117023', 833],
        ['de-bw-08136000-08136084', 834], ['de-bw-08117000-08117049', 835],
        ['de-bw-08425000-08425011', 836], ['de-bw-08415000-08415078', 837],
        ['de-bw-08117000-08117002', 838], ['de-bw-08117000-08117028', 839],
        ['de-bw-08417000-08417010', 840], ['de-bw-08417000-08417013', 841],
        ['de-bw-08117000-08117043', 842], ['de-bw-08127000-08127091', 843],
        ['de-bw-08117000-08117038', 844], ['de-bw-08118000-08118051', 845],
        ['de-bw-08118000-08118080', 846], ['de-bw-08118000-08118067', 847],
        ['de-bw-08425000-08425064', 848], ['de-bw-08119000-08119041', 849],
        ['de-bw-08225000-08225074', 850], ['de-bw-08127000-08127103', 851],
        ['de-bw-08225000-08225010', 852], ['de-bw-08136000-08136042', 853],
        ['de-bw-08136000-08136010', 854], ['de-bw-08118000-08118063', 855],
        ['de-bw-08317000-08317009', 856], ['de-bw-08327000-08327016', 857],
        ['de-bw-08327000-08327030', 858], ['de-bw-08327000-08327041', 859],
        ['de-bw-08315000-08315041', 860], ['de-bw-08225000-08225067', 861],
        ['de-bw-08417000-08417016', 862], ['de-bw-08115000-08115013', 863],
        ['de-bw-08316000-08316055', 864], ['de-bw-08317000-08317121', 865],
        ['de-bw-08317000-08317113', 866], ['de-bw-08317000-08317114', 867],
        ['de-bw-08327000-08327023', 868], ['de-bw-08327000-08327056', 869],
        ['de-bw-08316000-08316043', 870], ['de-bw-08316000-08316002', 871],
        ['de-bw-08315000-08315030', 872], ['de-bw-08325000-08325072', 873],
        ['de-bw-08126000-08126046', 874], ['de-bw-08125000-08125056', 875],
        ['de-bw-08125000-08125001', 876], ['de-bw-08425000-08425085', 877],
        ['de-bw-08226000-08226065', 878], ['de-bw-08226000-08226054', 879],
        ['de-bw-08327000-08327051', 880], ['de-bw-08416000-08416006', 881],
        ['de-bw-08416000-08416018', 882], ['de-bw-08216000-08216005', 883],
        ['de-bw-08237000-08237019', 884], ['de-bw-08237000-08237073', 885],
        ['de-bw-08237000-08237028', 886], ['de-bw-08116000-08116070', 887],
        ['de-bw-08116000-08116076', 888], ['de-bw-08136000-08136037', 889],
        ['de-bw-08126000-08126047', 890], ['de-bw-08126000-08126094', 891],
        ['de-bw-08126000-08126058', 892], ['de-bw-08135000-08135020', 893],
        ['de-bw-08135000-08135016', 894], ['de-bw-08415000-08415028', 895],
        ['de-bw-08415000-08415039', 896], ['de-bw-08327000-08327038', 897],
        ['de-bw-08317000-08317075', 898], ['de-bw-08235000-08235079', 899],
        ['de-bw-08236000-08236043', 900], ['de-bw-08235000-08235065', 901],
        ['de-bw-08335000-08335097', 902], ['de-bw-08336000-08336080', 903],
        ['de-bw-08316000-08316017', 904], ['de-bw-08326000-08326031', 905],
        ['de-bw-08125000-08125111', 906], ['de-bw-08325000-08325069', 907],
        ['de-bw-08115000-08115016', 908], ['de-bw-08416000-08416048', 909],
        ['de-bw-08225000-08225032', 910], ['de-bw-08417000-08417031', 911],
        ['de-bw-08336000-08336106', 912], ['de-bw-08417000-08417047', 913],
        ['de-bw-08327000-08327009', 914], ['de-bw-08417000-08417071', 915],
        ['de-bw-08115000-08115045', 916], ['de-bw-08117000-08117055', 917],
        ['de-bw-08115000-08115010', 918], ['de-bw-08115000-08115001', 919],
        ['de-bw-08116000-08116011', 920], ['de-bw-08425000-08425108', 921],
        ['de-bw-08117000-08117026', 922], ['de-bw-08127000-08127059', 923],
        ['de-bw-08415000-08415058', 924], ['de-bw-08437000-08437031', 925],
        ['de-bw-08126000-08126085', 926], ['de-bw-08126000-08126069', 927],
        ['de-bw-08126000-08126066', 928], ['de-bw-08337000-08337096', 929],
        ['de-bw-08316000-08316003', 930], ['de-bw-08336000-08336082', 931],
        ['de-bw-08317000-08317971', 932], ['de-bw-08235000-08235085', 933],
        ['de-bw-08226000-08226010', 934], ['de-bw-08225000-08225060', 935],
        ['de-bw-08116000-08116042', 936], ['de-bw-08236000-08236031', 937],
        ['de-bw-08116000-08116063', 938], ['de-bw-08236000-08236040', 939],
        ['de-bw-08115000-08115048', 940], ['de-bw-08317000-08317089', 941],
        ['de-bw-08415000-08415087', 942], ['de-bw-08317000-08317034', 943],
        ['de-bw-08215000-08215017', 944], ['de-bw-08215000-08215106', 945],
        ['de-bw-08417000-08417057', 946], ['de-bw-08416000-08416031', 947],
        ['de-bw-08118000-08118076', 948], ['de-bw-08236000-08236046', 949],
        ['de-bw-08325000-08325064', 950], ['de-bw-08117000-08117018', 951],
        ['de-bw-08435000-08435018', 952], ['de-bw-08337000-08337108', 953],
        ['de-bw-08327000-08327029', 954], ['de-bw-08327000-08327006', 955],
        ['de-bw-08327000-08327050', 956], ['de-bw-08336000-08336104', 957],
        ['de-bw-08336000-08336078', 958], ['de-bw-08235000-08235035', 959],
        ['de-bw-08236000-08236013', 960], ['de-bw-08236000-08236004', 961],
        ['de-bw-08336000-08336019', 962], ['de-bw-08336000-08336014', 963],
        ['de-bw-08336000-08336091', 964], ['de-bw-08116000-08116008', 965],
        ['de-bw-08136000-08136089', 966], ['de-bw-08116000-08116004', 967],
        ['de-bw-08116000-08116056', 968], ['de-bw-08116000-08116035', 969],
        ['de-bw-08136000-08136049', 970], ['de-bw-08415000-08415073', 971],
        ['de-bw-08415000-08415091', 972], ['de-bw-08235000-08235029', 973],
        ['de-bw-08125000-08125047', 974], ['de-bw-08215000-08215029', 975],
        ['de-bw-08327000-08327027', 976], ['de-bw-08415000-08415050', 977],
        ['de-bw-08216000-08216033', 978], ['de-bw-08216000-08216043', 979],
        ['de-bw-08236000-08236071', 980], ['de-bw-08315000-08315095', 981],
        ['de-bw-08315000-08315109', 982], ['de-bw-08315000-08315064', 983],
        ['de-bw-08327000-08327019', 984], ['de-bw-08316000-08316054', 985],
        ['de-bw-08316000-08316024', 986], ['de-bw-08326000-08326054', 987],
        ['de-bw-08236000-08236072', 988], ['de-bw-08235000-08235033', 989],
        ['de-bw-08118000-08118012', 990], ['de-bw-08235000-08235022', 991],
        ['de-bw-08315000-08315004', 992], ['de-bw-08237000-08237002', 993],
        ['de-bw-08336000-08336090', 994], ['de-bw-08426000-08426064', 995],
        ['de-bw-08336000-08336089', 996], ['de-bw-08426000-08426020', 997],
        ['de-bw-08325000-08325050', 998], ['de-bw-08325000-08325001', 999],
        ['de-bw-08417000-08417052', 1000], ['de-bw-08215000-08215097', 1001],
        ['de-bw-08235000-08235018', 1002], ['de-bw-08116000-08116043', 1003],
        ['de-bw-08417000-08417044', 1004], ['de-bw-08116000-08116079', 1005],
        ['de-bw-08326000-08326037', 1006], ['de-bw-08116000-08116019', 1007],
        ['de-bw-08336000-08336008', 1008], ['de-bw-08116000-08116080', 1009],
        ['de-bw-08315000-08315050', 1010], ['de-bw-08135000-08135015', 1011],
        ['de-bw-08315000-08315008', 1012], ['de-bw-08437000-08437005', 1013],
        ['de-bw-08117000-08117051', 1014], ['de-bw-08136000-08136024', 1015],
        ['de-bw-08117000-08117010', 1016], ['de-bw-08125000-08125057', 1017],
        ['de-bw-08226000-08226006', 1018], ['de-bw-08315000-08315133', 1019],
        ['de-bw-08335000-08335075', 1020], ['de-bw-08335000-08335077', 1021],
        ['de-bw-08335000-08335061', 1022], ['de-bw-08337000-08337060', 1023],
        ['de-bw-08335000-08335025', 1024], ['de-bw-08226000-08226046', 1025],
        ['de-bw-08216000-08216024', 1026], ['de-bw-08237000-08237004', 1027],
        ['de-bw-08216000-08216022', 1028], ['de-bw-08237000-08237061', 1029],
        ['de-bw-08125000-08125081', 1030], ['de-bw-08315000-08315037', 1031],
        ['de-bw-08336000-08336087', 1032], ['de-bw-08315000-08315102', 1033],
        ['de-bw-08335000-08335055', 1034], ['de-bw-08327000-08327004', 1035],
        ['de-bw-08237000-08237027', 1036], ['de-bw-08416000-08416050', 1037],
        ['de-bw-08216000-08216009', 1038], ['de-bw-08215000-08215046', 1039],
        ['de-bw-08315000-08315006', 1040], ['de-bw-08315000-08315033', 1041],
        ['de-bw-08315000-08315059', 1042], ['de-bw-08236000-08236028', 1043],
        ['de-bw-08236000-08236038', 1044], ['de-bw-08315000-08315015', 1045],
        ['de-bw-08337000-08337027', 1046], ['de-bw-08315000-08315048', 1047],
        ['de-bw-08115000-08115029', 1048], ['de-bw-08417000-08417029', 1049],
        ['de-bw-08237000-08237075', 1050], ['de-bw-08317000-08317145', 1051],
        ['de-bw-08315000-08315031', 1052], ['de-bw-08315000-08315039', 1053],
        ['de-bw-08435000-08435035', 1054], ['de-bw-08435000-08435016', 1055],
        ['de-bw-08115000-08115002', 1056], ['de-bw-08115000-08115052', 1057],
        ['de-bw-08236000-08236025', 1058], ['de-bw-08236000-08236019', 1059],
        ['de-bw-08216000-08216041', 1060], ['de-bw-08337000-08337038', 1061],
        ['de-bw-08226000-08226085', 1062], ['de-bw-08335000-08335015', 1063],
        ['de-bw-08127000-08127071', 1064], ['de-bw-08128000-08128039', 1065],
        ['de-bw-08128000-08128126', 1066], ['de-bw-08135000-08135010', 1067],
        ['de-bw-08135000-08135026', 1068], ['de-bw-08128000-08128020', 1069],
        ['de-bw-08335000-08335026', 1070], ['de-bw-08337000-08337106', 1071],
        ['de-bw-08436000-08436055', 1072], ['de-bw-08436000-08436049', 1073],
        ['de-bw-08417000-08417063', 1074], ['de-bw-08337000-08337070', 1075],
        ['de-bw-08437000-08437044', 1076], ['de-bw-08436000-08436094', 1077],
        ['de-bw-08237000-08237045', 1078], ['de-bw-08135000-08135031', 1079],
        ['de-bw-08235000-08235020', 1080], ['de-bw-08225000-08225091', 1081],
        ['de-bw-08225000-08225075', 1082], ['de-bw-08225000-08225117', 1083],
        ['de-bw-08118000-08118019', 1084], ['de-bw-08437000-08437059', 1085],
        ['de-bw-08128000-08128115', 1086], ['de-bw-08128000-08128047', 1087],
        ['de-bw-08115000-08115041', 1088], ['de-bw-08136000-08136060', 1089],
        ['de-bw-08226000-08226107', 1090], ['de-bw-08125000-08125058', 1091],
        ['de-bw-08128000-08128007', 1092], ['de-bw-08426000-08426128', 1093],
        ['de-bw-08127000-08127086', 1094], ['de-bw-08335000-08335057', 1095],
        ['de-bw-08436000-08436052', 1096], ['de-bw-08136000-08136038', 1097],
        ['de-bw-08125000-08125078', 1098], ['de-bw-08325000-08325061', 1099],
        ['de-bw-08337000-08337039', 1100], ['de-bw-08225000-08225039', 1101],
        ['de-bw-08236000-08236050', 1102], ['de-bw-08336000-08336036', 1103],
        ['de-bw-08415000-08415048', 1104], ['de-bw-08237000-08237024', 1105],
        ['de-bw-08426000-08426074', 1106], ['de-bw-08417000-08417008', 1107],
        ['de-bw-08119000-08119020', 1108], ['de-bw-08127000-08127056', 1109],
        ['de-bw-08127000-08127073', 1110], ['de-bw-08127000-08127023', 1111],
        ['de-bw-08125000-08125017', 1112], [null, 1113]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-bw-all-all.topo.json">Baden-Württemberg</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
