(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-by-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-by-09677000-09677151', 10], ['de-by-09189000-09189152', 11],
        ['de-by-09572000-09572158', 12], ['de-by-09671000-09671157', 13],
        ['de-by-09272000-09272145', 14], ['de-by-09575000-09575163', 15],
        ['de-by-09575000-09575168', 16], ['de-by-09173000-09173451', 17],
        ['de-by-09184000-09184134', 18], ['de-by-09184000-09184144', 19],
        ['de-by-09671000-09671460', 20], ['de-by-09272000-09272122', 21],
        ['de-by-09273000-09273152', 22], ['de-by-09678000-09678181', 23],
        ['de-by-09472000-09472121', 24], ['de-by-09675000-09675158', 25],
        ['de-by-09678000-09678164', 26], ['de-by-09672000-09672138', 27],
        ['de-by-09371000-09371154', 28], ['de-by-09171000-09171112', 29],
        ['de-by-09275000-09275137', 30], ['de-by-09172000-09172116', 31],
        ['de-by-09677000-09677135', 32], ['de-by-09678000-09678157', 33],
        ['de-by-09576000-09576148', 34], ['de-by-09576000-09576122', 35],
        ['de-by-09679000-09679451', 36], ['de-by-09677000-09677114', 37],
        ['de-by-09776000-09776112', 38], ['de-by-09677000-09677165', 39],
        ['de-by-09273000-09273137', 40], ['de-by-09375000-09375118', 41],
        ['de-by-09375000-09375148', 42], ['de-by-09672000-09672161', 43],
        ['de-by-09672000-09672463', 44], ['de-by-09272000-09272136', 45],
        ['de-by-09679000-09679154', 46], ['de-by-09677000-09677120', 47],
        ['de-by-09677000-09677200', 48], ['de-by-09672000-09672149', 49],
        ['de-by-09673000-09673456', 50], ['de-by-09275000-09275118', 51],
        ['de-by-09274000-09274193', 52], ['de-by-09274000-09274183', 53],
        ['de-by-09462000-09462000', 54], ['de-by-09775000-09775451', 55],
        ['de-by-09375000-09375114', 56], ['de-by-09371000-09371127', 57],
        ['de-by-09371000-09371123', 58], ['de-by-09177000-09177143', 59],
        ['de-by-09673000-09673141', 60], ['de-by-09471000-09471195', 61],
        ['de-by-09371000-09371120', 62], ['de-by-09377000-09377133', 63],
        ['de-by-09671000-09671156', 64], ['de-by-09263000-09263000', 65],
        ['de-by-09278000-09278170', 66], ['de-by-09473000-09473141', 67],
        ['de-by-09479000-09479458', 68], ['de-by-09372000-09372153', 69],
        ['de-by-09272000-09272121', 70], ['de-by-09374000-09374134', 71],
        ['de-by-09472000-09472198', 72], ['de-by-09473000-09473165', 73],
        ['de-by-09472000-09472131', 74], ['de-by-09679000-09679176', 75],
        ['de-by-09776000-09776125', 76], ['de-by-09479000-09479152', 77],
        ['de-by-09672000-09672139', 78], ['de-by-09474000-09474145', 79],
        ['de-by-09474000-09474132', 80], ['de-by-09188000-09188118', 81],
        ['de-by-09773000-09773153', 82], ['de-by-09773000-09773170', 83],
        ['de-by-09672000-09672166', 84], ['de-by-09272000-09272127', 85],
        ['de-by-09272000-09272140', 86], ['de-by-09272000-09272139', 87],
        ['de-by-09272000-09272126', 88], ['de-by-09671000-09671150', 89],
        ['de-by-09272000-09272143', 90], ['de-by-09272000-09272459', 91],
        ['de-by-09376000-09376117', 92], ['de-by-09671000-09671139', 93],
        ['de-by-09678000-09678452', 94], ['de-by-09374000-09374157', 95],
        ['de-by-09187000-09187123', 96], ['de-by-09376000-09376163', 97],
        ['de-by-09376000-09376162', 98], ['de-by-09184000-09184452', 99],
        ['de-by-09184000-09184132', 100], ['de-by-09574000-09574141', 101],
        ['de-by-09574000-09574155', 102], ['de-by-09574000-09574463', 103],
        ['de-by-09571000-09571179', 104], ['de-by-09773000-09773143', 105],
        ['de-by-09772000-09772137', 106], ['de-by-09473000-09473144', 107],
        ['de-by-09572000-09572131', 108], ['de-by-09377000-09377127', 109],
        ['de-by-09478000-09478451', 110], ['de-by-09475000-09475451', 111],
        ['de-by-09475000-09475128', 112], ['de-by-09574000-09574164', 113],
        ['de-by-09374000-09374129', 114], ['de-by-09471000-09471120', 115],
        ['de-by-09472000-09472464', 116], ['de-by-09162000-09162000', 117],
        ['de-by-09176000-09176138', 118], ['de-by-09176000-09176116', 119],
        ['de-by-09173000-09173145', 120], ['de-by-09672000-09672455', 121],
        ['de-by-09272000-09272458', 122], ['de-by-09272000-09272452', 123],
        ['de-by-09676000-09676151', 124], ['de-by-09676000-09676117', 125],
        ['de-by-09671000-09671457', 126], ['de-by-09671000-09671451', 127],
        ['de-by-09671000-09671124', 128], ['de-by-09671000-09671130', 129],
        ['de-by-09671000-09671113', 130], ['de-by-09662000-09662000', 131],
        ['de-by-09678000-09678178', 132], ['de-by-09678000-09678132', 133],
        ['de-by-09672000-09672454', 134], ['de-by-09677000-09677203', 135],
        ['de-by-09677000-09677193', 136], ['de-by-09677000-09677119', 137],
        ['de-by-09678000-09678455', 138], ['de-by-09678000-09678451', 139],
        ['de-by-09674000-09674180', 140], ['de-by-09678000-09678124', 141],
        ['de-by-09678000-09678183', 142], ['de-by-09676000-09676134', 143],
        ['de-by-09677000-09677186', 144], ['de-by-09677000-09677178', 145],
        ['de-by-09671000-09671133', 146], ['de-by-09671000-09671136', 147],
        ['de-by-09671000-09671114', 148], ['de-by-09677000-09677166', 149],
        ['de-by-09679000-09679169', 150], ['de-by-09679000-09679201', 151],
        ['de-by-09679000-09679156', 152], ['de-by-09679000-09679180', 153],
        ['de-by-09676000-09676169', 154], ['de-by-09671000-09671452', 155],
        ['de-by-09672000-09672111', 156], ['de-by-09672000-09672122', 157],
        ['de-by-09672000-09672142', 158], ['de-by-09678000-09678160', 159],
        ['de-by-09671000-09671134', 160], ['de-by-09678000-09678193', 161],
        ['de-by-09672000-09672155', 162], ['de-by-09679000-09679170', 163],
        ['de-by-09675000-09675113', 164], ['de-by-09575000-09575130', 165],
        ['de-by-09575000-09575138', 166], ['de-by-09575000-09575165', 167],
        ['de-by-09677000-09677154', 168], ['de-by-09677000-09677125', 169],
        ['de-by-09677000-09677157', 170], ['de-by-09575000-09575161', 171],
        ['de-by-09679000-09679138', 172], ['de-by-09679000-09679209', 173],
        ['de-by-09679000-09679147', 174], ['de-by-09571000-09571111', 175],
        ['de-by-09678000-09678170', 176], ['de-by-09678000-09678196', 177],
        ['de-by-09474000-09474154', 178], ['de-by-09678000-09678123', 179],
        ['de-by-09672000-09672143', 180], ['de-by-09572000-09572141', 181],
        ['de-by-09575000-09575124', 182], ['de-by-09571000-09571188', 183],
        ['de-by-09573000-09573115', 184], ['de-by-09573000-09573114', 185],
        ['de-by-09187000-09187128', 186], ['de-by-09187000-09187163', 187],
        ['de-by-09773000-09773113', 188], ['de-by-09180000-09180126', 189],
        ['de-by-09180000-09180451', 190], ['de-by-09180000-09180116', 191],
        ['de-by-09171000-09171118', 192], ['de-by-09772000-09772136', 193],
        ['de-by-09772000-09772185', 194], ['de-by-09473000-09473121', 195],
        ['de-by-09473000-09473166', 196], ['de-by-09478000-09478453', 197],
        ['de-by-09473000-09473158', 198], ['de-by-09473000-09473453', 199],
        ['de-by-09472000-09472451', 200], ['de-by-09463000-09463000', 201],
        ['de-by-09472000-09472470', 202], ['de-by-09475000-09475169', 203],
        ['de-by-09475000-09475156', 204], ['de-by-09473000-09473454', 205],
        ['de-by-09178000-09178155', 206], ['de-by-09178000-09178125', 207],
        ['de-by-09273000-09273178', 208], ['de-by-09273000-09273115', 209],
        ['de-by-09475000-09475127', 210], ['de-by-09374000-09374132', 211],
        ['de-by-09376000-09376150', 212], ['de-by-09374000-09374146', 213],
        ['de-by-09363000-09363000', 214], ['de-by-09374000-09374144', 215],
        ['de-by-09275000-09275125', 216], ['de-by-09275000-09275138', 217],
        ['de-by-09272000-09272463', 218], ['de-by-09577000-09577115', 219],
        ['de-by-09576000-09576126', 220], ['de-by-09571000-09571227', 221],
        ['de-by-09571000-09571136', 222], ['de-by-09774000-09774124', 223],
        ['de-by-09775000-09775455', 224], ['de-by-09273000-09273147', 225],
        ['de-by-09186000-09186162', 226], ['de-by-09772000-09772166', 227],
        ['de-by-09572000-09572455', 228], ['de-by-09572000-09572452', 229],
        ['de-by-09182000-09182131', 230], ['de-by-09374000-09374139', 231],
        ['de-by-09278000-09278143', 232], ['de-by-09278000-09278179', 233],
        ['de-by-09677000-09677155', 234], ['de-by-09677000-09677462', 235],
        ['de-by-09677000-09677461', 236], ['de-by-09678000-09678128', 237],
        ['de-by-09561000-09561000', 238], ['de-by-09571000-09571174', 239],
        ['de-by-09571000-09571166', 240], ['de-by-09571000-09571115', 241],
        ['de-by-09571000-09571155', 242], ['de-by-09671000-09671456', 243],
        ['de-by-09671000-09671153', 244], ['de-by-09676000-09676141', 245],
        ['de-by-09571000-09571225', 246], ['de-by-09279000-09279125', 247],
        ['de-by-09279000-09279128', 248], ['de-by-09279000-09279116', 249],
        ['de-by-09679000-09679155', 250], ['de-by-09273000-09273454', 251],
        ['de-by-09273000-09273453', 252], ['de-by-09771000-09771111', 253],
        ['de-by-09771000-09771165', 254], ['de-by-09771000-09771122', 255],
        ['de-by-09774000-09774198', 256], ['de-by-09772000-09772451', 257],
        ['de-by-09178000-09178156', 258], ['de-by-09186000-09186152', 259],
        ['de-by-09178000-09178113', 260], ['de-by-09178000-09178150', 261],
        ['de-by-09272000-09272462', 262], ['de-by-09278000-09278178', 263],
        ['de-by-09272000-09272120', 264], ['de-by-09272000-09272138', 265],
        ['de-by-09772000-09772168', 266], ['de-by-09772000-09772141', 267],
        ['de-by-09772000-09772148', 268], ['de-by-09576000-09576147', 269],
        ['de-by-09576000-09576121', 270], ['de-by-09571000-09571178', 271],
        ['de-by-09679000-09679206', 272], ['de-by-09774000-09774144', 273],
        ['de-by-09772000-09772223', 274], ['de-by-09671000-09671143', 275],
        ['de-by-09273000-09273163', 276], ['de-by-09274000-09274172', 277],
        ['de-by-09678000-09678136', 278], ['de-by-09176000-09176160', 279],
        ['de-by-09176000-09176148', 280], ['de-by-09577000-09577168', 281],
        ['de-by-09678000-09678122', 282], ['de-by-09671000-09671159', 283],
        ['de-by-09375000-09375174', 284], ['de-by-09362000-09362000', 285],
        ['de-by-09575000-09575127', 286], ['de-by-09677000-09677164', 287],
        ['de-by-09671000-09671454', 288], ['de-by-09676000-09676116', 289],
        ['de-by-09679000-09679192', 290], ['de-by-09663000-09663000', 291],
        ['de-by-09571000-09571205', 292], ['de-by-09679000-09679202', 293],
        ['de-by-09679000-09679194', 294], ['de-by-09678000-09678454', 295],
        ['de-by-09678000-09678190', 296], ['de-by-09679000-09679149', 297],
        ['de-by-09777000-09777176', 298], ['de-by-09777000-09777165', 299],
        ['de-by-09778000-09778186', 300], ['de-by-09777000-09777153', 301],
        ['de-by-09780000-09780145', 302], ['de-by-09678000-09678115', 303],
        ['de-by-09679000-09679142', 304], ['de-by-09479000-09479127', 305],
        ['de-by-09575000-09575133', 306], ['de-by-09575000-09575156', 307],
        ['de-by-09275000-09275141', 308], ['de-by-09277000-09277113', 309],
        ['de-by-09275000-09275124', 310], ['de-by-09171000-09171116', 311],
        ['de-by-09189000-09189149', 312], ['de-by-09374000-09374122', 313],
        ['de-by-09377000-09377146', 314], ['de-by-09183000-09183132', 315],
        ['de-by-09177000-09177117', 316], ['de-by-09177000-09177120', 317],
        ['de-by-09177000-09177113', 318], ['de-by-09277000-09277134', 319],
        ['de-by-09277000-09277153', 320], ['de-by-09183000-09183140', 321],
        ['de-by-09183000-09183113', 322], ['de-by-09183000-09183124', 323],
        ['de-by-09183000-09183122', 324], ['de-by-09183000-09183147', 325],
        ['de-by-09275000-09275111', 326], ['de-by-09275000-09275159', 327],
        ['de-by-09175000-09175112', 328], ['de-by-09175000-09175122', 329],
        ['de-by-09184000-09184130', 330], ['de-by-09184000-09184147', 331],
        ['de-by-09773000-09773188', 332], ['de-by-09178000-09178142', 333],
        ['de-by-09178000-09178144', 334], ['de-by-09475000-09475189', 335],
        ['de-by-09475000-09475175', 336], ['de-by-09477000-09477163', 337],
        ['de-by-09574000-09574129', 338], ['de-by-09574000-09574135', 339],
        ['de-by-09184000-09184118', 340], ['de-by-09777000-09777114', 341],
        ['de-by-09777000-09777139', 342], ['de-by-09161000-09161000', 343],
        ['de-by-09176000-09176129', 344], ['de-by-09184000-09184141', 345],
        ['de-by-09173000-09173120', 346], ['de-by-09176000-09176122', 347],
        ['de-by-09184000-09184454', 348], ['de-by-09180000-09180114', 349],
        ['de-by-09173000-09173133', 350], ['de-by-09676000-09676118', 351],
        ['de-by-09671000-09671138', 352], ['de-by-09471000-09471137', 353],
        ['de-by-09471000-09471140', 354], ['de-by-09677000-09677149', 355],
        ['de-by-09677000-09677127', 356], ['de-by-09671000-09671141', 357],
        ['de-by-09679000-09679177', 358], ['de-by-09677000-09677170', 359],
        ['de-by-09677000-09677463', 360], ['de-by-09775000-09775454', 361],
        ['de-by-09271000-09271126', 362], ['de-by-09272000-09272455', 363],
        ['de-by-09374000-09374154', 364], ['de-by-09275000-09275128', 365],
        ['de-by-09272000-09272119', 366], ['de-by-09779000-09779187', 367],
        ['de-by-09779000-09779163', 368], ['de-by-09771000-09771156', 369],
        ['de-by-09779000-09779196', 370], ['de-by-09779000-09779149', 371],
        ['de-by-09479000-09479147', 372], ['de-by-09186000-09186130', 373],
        ['de-by-09464000-09464000', 374], ['de-by-09475000-09475123', 375],
        ['de-by-09376000-09376122', 376], ['de-by-09376000-09376172', 377],
        ['de-by-09189000-09189141', 378], ['de-by-09778000-09778177', 379],
        ['de-by-09778000-09778139', 380], ['de-by-09778000-09778150', 381],
        ['de-by-09774000-09774192', 382], ['de-by-09774000-09774451', 383],
        ['de-by-09775000-09775452', 384], ['de-by-09775000-09775129', 385],
        ['de-by-09775000-09775161', 386], ['de-by-09679000-09679182', 387],
        ['de-by-09376000-09376159', 388], ['de-by-09772000-09772126', 389],
        ['de-by-09772000-09772147', 390], ['de-by-09172000-09172118', 391],
        ['de-by-09775000-09775115', 392], ['de-by-09775000-09775162', 393],
        ['de-by-09278000-09278171', 394], ['de-by-09278000-09278187', 395],
        ['de-by-09278000-09278159', 396], ['de-by-09779000-09779177', 397],
        ['de-by-09673000-09673129', 398], ['de-by-09776000-09776126', 399],
        ['de-by-09780000-09780119', 400], ['de-by-09575000-09575153', 401],
        ['de-by-09575000-09575121', 402], ['de-by-09575000-09575125', 403],
        ['de-by-09776000-09776115', 404], ['de-by-09573000-09573124', 405],
        ['de-by-09472000-09472115', 406], ['de-by-09471000-09471142', 407],
        ['de-by-09474000-09474168', 408], ['de-by-09273000-09273451', 409],
        ['de-by-09273000-09273113', 410], ['de-by-09273000-09273177', 411],
        ['de-by-09472000-09472154', 412], ['de-by-09477000-09477157', 413],
        ['de-by-09477000-09477164', 414], ['de-by-09573000-09573126', 415],
        ['de-by-09571000-09571189', 416], ['de-by-09571000-09571177', 417],
        ['de-by-09571000-09571216', 418], ['de-by-09571000-09571127', 419],
        ['de-by-09178000-09178122', 420], ['de-by-09477000-09477121', 421],
        ['de-by-09577000-09577120', 422], ['de-by-09577000-09577151', 423],
        ['de-by-09471000-09471175', 424], ['de-by-09471000-09471133', 425],
        ['de-by-09179000-09179125', 426], ['de-by-09179000-09179130', 427],
        ['de-by-09572000-09572453', 428], ['de-by-09572000-09572457', 429],
        ['de-by-09474000-09474147', 430], ['de-by-09474000-09474175', 431],
        ['de-by-09478000-09478176', 432], ['de-by-09472000-09472127', 433],
        ['de-by-09676000-09676124', 434], ['de-by-09678000-09678168', 435],
        ['de-by-09675000-09675156', 436], ['de-by-09675000-09675167', 437],
        ['de-by-09674000-09674111', 438], ['de-by-09672000-09672131', 439],
        ['de-by-09678000-09678175', 440], ['de-by-09679000-09679117', 441],
        ['de-by-09472000-09472454', 442], ['de-by-09574000-09574131', 443],
        ['de-by-09574000-09574146', 444], ['de-by-09778000-09778173', 445],
        ['de-by-09778000-09778187', 446], ['de-by-09778000-09778120', 447],
        ['de-by-09778000-09778165', 448], ['de-by-09778000-09778164', 449],
        ['de-by-09575000-09575147', 450], ['de-by-09575000-09575150', 451],
        ['de-by-09776000-09776118', 452], ['de-by-09780000-09780144', 453],
        ['de-by-09778000-09778130', 454], ['de-by-09778000-09778162', 455],
        ['de-by-09778000-09778219', 456], ['de-by-09778000-09778161', 457],
        ['de-by-09778000-09778151', 458], ['de-by-09778000-09778205', 459],
        ['de-by-09778000-09778214', 460], ['de-by-09678000-09678153', 461],
        ['de-by-09575000-09575134', 462], ['de-by-09575000-09575155', 463],
        ['de-by-09474000-09474143', 464], ['de-by-09675000-09675150', 465],
        ['de-by-09472000-09472146', 466], ['de-by-09672000-09672451', 467],
        ['de-by-09778000-09778157', 468], ['de-by-09778000-09778221', 469],
        ['de-by-09775000-09775141', 470], ['de-by-09775000-09775118', 471],
        ['de-by-09679000-09679144', 472], ['de-by-09677000-09677132', 473],
        ['de-by-09677000-09677131', 474], ['de-by-09576000-09576151', 475],
        ['de-by-09576000-09576137', 476], ['de-by-09478000-09478116', 477],
        ['de-by-09478000-09478127', 478], ['de-by-09478000-09478144', 479],
        ['de-by-09674000-09674201', 480], ['de-by-09471000-09471152', 481],
        ['de-by-09575000-09575118', 482], ['de-by-09371000-09371455', 483],
        ['de-by-09371000-09371136', 484], ['de-by-09780000-09780117', 485],
        ['de-by-09764000-09764000', 486], ['de-by-09774000-09774129', 487],
        ['de-by-09778000-09778149', 488], ['de-by-09774000-09774117', 489],
        ['de-by-09476000-09476183', 490], ['de-by-09476000-09476184', 491],
        ['de-by-09777000-09777138', 492], ['de-by-09777000-09777111', 493],
        ['de-by-09777000-09777128', 494], ['de-by-09777000-09777154', 495],
        ['de-by-09777000-09777124', 496], ['de-by-09777000-09777144', 497],
        ['de-by-09780000-09780451', 498], ['de-by-09776000-09776113', 499],
        ['de-by-09780000-09780127', 500], ['de-by-09776000-09776130', 501],
        ['de-by-09780000-09780147', 502], ['de-by-09778000-09778217', 503],
        ['de-by-09775000-09775142', 504], ['de-by-09775000-09775132', 505],
        ['de-by-09778000-09778451', 506], ['de-by-09778000-09778115', 507],
        ['de-by-09778000-09778184', 508], ['de-by-09371000-09371156', 509],
        ['de-by-09371000-09371119', 510], ['de-by-09776000-09776127', 511],
        ['de-by-09474000-09474176', 512], ['de-by-09774000-09774111', 513],
        ['de-by-09778000-09778158', 514], ['de-by-09774000-09774115', 515],
        ['de-by-09778000-09778134', 516], ['de-by-09778000-09778190', 517],
        ['de-by-09574000-09574451', 518], ['de-by-09574000-09574457', 519],
        ['de-by-09778000-09778121', 520], ['de-by-09576000-09576451', 521],
        ['de-by-09576000-09576117', 522], ['de-by-09778000-09778113', 523],
        ['de-by-09778000-09778207', 524], ['de-by-09471000-09471174', 525],
        ['de-by-09677000-09677159', 526], ['de-by-09677000-09677169', 527],
        ['de-by-09677000-09677452', 528], ['de-by-09262000-09262000', 529],
        ['de-by-09780000-09780125', 530], ['de-by-09780000-09780112', 531],
        ['de-by-09374000-09374123', 532], ['de-by-09374000-09374164', 533],
        ['de-by-09679000-09679188', 534], ['de-by-09679000-09679179', 535],
        ['de-by-09679000-09679114', 536], ['de-by-09575000-09575115', 537],
        ['de-by-09679000-09679161', 538], ['de-by-09679000-09679200', 539],
        ['de-by-09677000-09677175', 540], ['de-by-09673000-09673130', 541],
        ['de-by-09673000-09673136', 542], ['de-by-09674000-09674129', 543],
        ['de-by-09674000-09674133', 544], ['de-by-09471000-09471173', 545],
        ['de-by-09472000-09472175', 546], ['de-by-09674000-09674221', 547],
        ['de-by-09674000-09674195', 548], ['de-by-09574000-09574462', 549],
        ['de-by-09371000-09371135', 550], ['de-by-09371000-09371113', 551],
        ['de-by-09473000-09473452', 552], ['de-by-09776000-09776121', 553],
        ['de-by-09672000-09672457', 554], ['de-by-09672000-09672113', 555],
        ['de-by-09471000-09471122', 556], ['de-by-09471000-09471457', 557],
        ['de-by-09672000-09672464', 558], ['de-by-09672000-09672461', 559],
        ['de-by-09477000-09477118', 560], ['de-by-09477000-09477138', 561],
        ['de-by-09478000-09478145', 562], ['de-by-09478000-09478143', 563],
        ['de-by-09479000-09479457', 564], ['de-by-09472000-09472453', 565],
        ['de-by-09472000-09472138', 566], ['de-by-09778000-09778123', 567],
        ['de-by-09186000-09186143', 568], ['de-by-09577000-09577122', 569],
        ['de-by-09577000-09577113', 570], ['de-by-09185000-09185139', 571],
        ['de-by-09185000-09185149', 572], ['de-by-09176000-09176112', 573],
        ['de-by-09176000-09176153', 574], ['de-by-09772000-09772207', 575],
        ['de-by-09771000-09771114', 576], ['de-by-09679000-09679193', 577],
        ['de-by-09374000-09374124', 578], ['de-by-09679000-09679136', 579],
        ['de-by-09679000-09679175', 580], ['de-by-09374000-09374149', 581],
        ['de-by-09575000-09575144', 582], ['de-by-09675000-09675148', 583],
        ['de-by-09772000-09772216', 584], ['de-by-09673000-09673151', 585],
        ['de-by-09778000-09778188', 586], ['de-by-09371000-09371121', 587],
        ['de-by-09471000-09471119', 588], ['de-by-09273000-09273181', 589],
        ['de-by-09273000-09273172', 590], ['de-by-09273000-09273139', 591],
        ['de-by-09172000-09172124', 592], ['de-by-09186000-09186144', 593],
        ['de-by-09185000-09185158', 594], ['de-by-09185000-09185163', 595],
        ['de-by-09179000-09179117', 596], ['de-by-09179000-09179137', 597],
        ['de-by-09179000-09179114', 598], ['de-by-09174000-09174137', 599],
        ['de-by-09176000-09176143', 600], ['de-by-09176000-09176161', 601],
        ['de-by-09778000-09778118', 602], ['de-by-09577000-09577127', 603],
        ['de-by-09771000-09771169', 604], ['de-by-09772000-09772177', 605],
        ['de-by-09577000-09577161', 606], ['de-by-09577000-09577159', 607],
        ['de-by-09186000-09186139', 608], ['de-by-09577000-09577111', 609],
        ['de-by-09176000-09176137', 610], ['de-by-09176000-09176114', 611],
        ['de-by-09779000-09779217', 612], ['de-by-09779000-09779129', 613],
        ['de-by-09779000-09779126', 614], ['de-by-09178000-09178140', 615],
        ['de-by-09177000-09177133', 616], ['de-by-09474000-09474173', 617],
        ['de-by-09474000-09474140', 618], ['de-by-09474000-09474121', 619],
        ['de-by-09577000-09577138', 620], ['de-by-09185000-09185118', 621],
        ['de-by-09779000-09779181', 622], ['de-by-09779000-09779218', 623],
        ['de-by-09779000-09779178', 624], ['de-by-09565000-09565000', 625],
        ['de-by-09176000-09176451', 626], ['de-by-09572000-09572164', 627],
        ['de-by-09185000-09185143', 628], ['de-by-09575000-09575117', 629],
        ['de-by-09174000-09174143', 630], ['de-by-09174000-09174141', 631],
        ['de-by-09178000-09178123', 632], ['de-by-09178000-09178116', 633],
        ['de-by-09574000-09574150', 634], ['de-by-09176000-09176149', 635],
        ['de-by-09178000-09178137', 636], ['de-by-09178000-09178133', 637],
        ['de-by-09779000-09779185', 638], ['de-by-09779000-09779162', 639],
        ['de-by-09779000-09779184', 640], ['de-by-09773000-09773117', 641],
        ['de-by-09773000-09773119', 642], ['de-by-09275000-09275150', 643],
        ['de-by-09373000-09373160', 644], ['de-by-09373000-09373119', 645],
        ['de-by-09275000-09275153', 646], ['de-by-09373000-09373146', 647],
        ['de-by-09185000-09185153', 648], ['de-by-09373000-09373156', 649],
        ['de-by-09574000-09574157', 650], ['de-by-09574000-09574454', 651],
        ['de-by-09273000-09273121', 652], ['de-by-09176000-09176164', 653],
        ['de-by-09473000-09473175', 654], ['de-by-09671000-09671111', 655],
        ['de-by-09779000-09779451', 656], ['de-by-09571000-09571130', 657],
        ['de-by-09185000-09185157', 658], ['de-by-09185000-09185150', 659],
        ['de-by-09571000-09571183', 660], ['de-by-09176000-09176121', 661],
        ['de-by-09375000-09375162', 662], ['de-by-09375000-09375454', 663],
        ['de-by-09779000-09779201', 664], ['de-by-09779000-09779192', 665],
        ['de-by-09185000-09185125', 666], ['de-by-09178000-09178130', 667],
        ['de-by-09178000-09178145', 668], ['de-by-09774000-09774160', 669],
        ['de-by-09774000-09774162', 670], ['de-by-09774000-09774185', 671],
        ['de-by-09777000-09777183', 672], ['de-by-09777000-09777171', 673],
        ['de-by-09278000-09278197', 674], ['de-by-09375000-09375210', 675],
        ['de-by-09673000-09673457', 676], ['de-by-09673000-09673451', 677],
        ['de-by-09673000-09673186', 678], ['de-by-09673000-09673171', 679],
        ['de-by-09673000-09673161', 680], ['de-by-09479000-09479135', 681],
        ['de-by-09479000-09479150', 682], ['de-by-09773000-09773186', 683],
        ['de-by-09773000-09773137', 684], ['de-by-09571000-09571192', 685],
        ['de-by-09571000-09571154', 686], ['de-by-09571000-09571218', 687],
        ['de-by-09779000-09779147', 688], ['de-by-09275000-09275133', 689],
        ['de-by-09275000-09275134', 690], ['de-by-09774000-09774145', 691],
        ['de-by-09176000-09176167', 692], ['de-by-09576000-09576128', 693],
        ['de-by-09576000-09576454', 694], ['de-by-09674000-09674130', 695],
        ['de-by-09674000-09674164', 696], ['de-by-09172000-09172452', 697],
        ['de-by-09172000-09172132', 698], ['de-by-09671000-09671121', 699],
        ['de-by-09661000-09661000', 700], ['de-by-09671000-09671140', 701],
        ['de-by-09277000-09277124', 702], ['de-by-09277000-09277139', 703],
        ['de-by-09183000-09183128', 704], ['de-by-09171000-09171132', 705],
        ['de-by-09274000-09274194', 706], ['de-by-09377000-09377129', 707],
        ['de-by-09278000-09278123', 708], ['de-by-09278000-09278121', 709],
        ['de-by-09374000-09374111', 710], ['de-by-09672000-09672112', 711],
        ['de-by-09673000-09673454', 712], ['de-by-09276000-09276120', 713],
        ['de-by-09276000-09276144', 714], ['de-by-09374000-09374148', 715],
        ['de-by-09186000-09186126', 716], ['de-by-09186000-09186151', 717],
        ['de-by-09186000-09186128', 718], ['de-by-09176000-09176120', 719],
        ['de-by-09577000-09577177', 720], ['de-by-09577000-09577141', 721],
        ['de-by-09675000-09675147', 722], ['de-by-09376000-09376144', 723],
        ['de-by-09373000-09373112', 724], ['de-by-09373000-09373126', 725],
        ['de-by-09376000-09376112', 726], ['de-by-09174000-09174111', 727],
        ['de-by-09174000-09174135', 728], ['de-by-09373000-09373151', 729],
        ['de-by-09373000-09373115', 730], ['de-by-09572000-09572451', 731],
        ['de-by-09572000-09572160', 732], ['de-by-09177000-09177144', 733],
        ['de-by-09177000-09177142', 734], ['de-by-09775000-09775164', 735],
        ['de-by-09775000-09775149', 736], ['de-by-09177000-09177112', 737],
        ['de-by-09177000-09177126', 738], ['de-by-09178000-09178129', 739],
        ['de-by-09672000-09672127', 740], ['de-by-09773000-09773122', 741],
        ['de-by-09672000-09672121', 742], ['de-by-09672000-09672124', 743],
        ['de-by-09771000-09771155', 744], ['de-by-09771000-09771140', 745],
        ['de-by-09677000-09677456', 746], ['de-by-09176000-09176132', 747],
        ['de-by-09176000-09176111', 748], ['de-by-09176000-09176124', 749],
        ['de-by-09176000-09176118', 750], ['de-by-09375000-09375175', 751],
        ['de-by-09672000-09672465', 752], ['de-by-09178000-09178120', 753],
        ['de-by-09184000-09184119', 754], ['de-by-09772000-09772114', 755],
        ['de-by-09673000-09673184', 756], ['de-by-09778000-09778119', 757],
        ['de-by-09778000-09778144', 758], ['de-by-09774000-09774116', 759],
        ['de-by-09476000-09476171', 760], ['de-by-09678000-09678457', 761],
        ['de-by-09678000-09678453', 762], ['de-by-09678000-09678150', 763],
        ['de-by-09576000-09576127', 764], ['de-by-09178000-09178157', 765],
        ['de-by-09178000-09178136', 766], ['de-by-09178000-09178115', 767],
        ['de-by-09775000-09775139', 768], ['de-by-09774000-09774155', 769],
        ['de-by-09774000-09774118', 770], ['de-by-09675000-09675144', 771],
        ['de-by-09675000-09675149', 772], ['de-by-09675000-09675166', 773],
        ['de-by-09673000-09673172', 774], ['de-by-09772000-09772117', 775],
        ['de-by-09772000-09772159', 776], ['de-by-09174000-09174146', 777],
        ['de-by-09177000-09177116', 778], ['de-by-09375000-09375199', 779],
        ['de-by-09671000-09671453', 780], ['de-by-09773000-09773164', 781],
        ['de-by-09675000-09675114', 782], ['de-by-09176000-09176147', 783],
        ['de-by-09675000-09675146', 784], ['de-by-09176000-09176139', 785],
        ['de-by-09176000-09176131', 786], ['de-by-09178000-09178138', 787],
        ['de-by-09676000-09676160', 788], ['de-by-09676000-09676126', 789],
        ['de-by-09373000-09373121', 790], ['de-by-09772000-09772167', 791],
        ['de-by-09772000-09772111', 792], ['de-by-09774000-09774191', 793],
        ['de-by-09375000-09375127', 794], ['de-by-09778000-09778136', 795],
        ['de-by-09577000-09577136', 796], ['de-by-09571000-09571451', 797],
        ['de-by-09571000-09571113', 798], ['de-by-09577000-09577114', 799],
        ['de-by-09571000-09571214', 800], ['de-by-09177000-09177130', 801],
        ['de-by-09178000-09178143', 802], ['de-by-09575000-09575122', 803],
        ['de-by-09575000-09575146', 804], ['de-by-09273000-09273111', 805],
        ['de-by-09273000-09273166', 806], ['de-by-09675000-09675161', 807],
        ['de-by-09577000-09577133', 808], ['de-by-09675000-09675131', 809],
        ['de-by-09675000-09675165', 810], ['de-by-09675000-09675179', 811],
        ['de-by-09774000-09774135', 812], ['de-by-09774000-09774171', 813],
        ['de-by-09677000-09677189', 814], ['de-by-09676000-09676452', 815],
        ['de-by-09676000-09676122', 816], ['de-by-09671000-09671160', 817],
        ['de-by-09676000-09676111', 818], ['de-by-09679000-09679128', 819],
        ['de-by-09774000-09774151', 820], ['de-by-09774000-09774178', 821],
        ['de-by-09679000-09679135', 822], ['de-by-09774000-09774140', 823],
        ['de-by-09671000-09671120', 824], ['de-by-09778000-09778180', 825],
        ['de-by-09672000-09672140', 826], ['de-by-09778000-09778199', 827],
        ['de-by-09676000-09676121', 828], ['de-by-09675000-09675142', 829],
        ['de-by-09675000-09675177', 830], ['de-by-09675000-09675116', 831],
        ['de-by-09771000-09771149', 832], ['de-by-09771000-09771112', 833],
        ['de-by-09674000-09674163', 834], ['de-by-09771000-09771158', 835],
        ['de-by-09675000-09675169', 836], ['de-by-09176000-09176166', 837],
        ['de-by-09678000-09678138', 838], ['de-by-09771000-09771129', 839],
        ['de-by-09678000-09678176', 840], ['de-by-09771000-09771160', 841],
        ['de-by-09676000-09676140', 842], ['de-by-09575000-09575135', 843],
        ['de-by-09779000-09779180', 844], ['de-by-09779000-09779188', 845],
        ['de-by-09779000-09779226', 846], ['de-by-09577000-09577162', 847],
        ['de-by-09575000-09575451', 848], ['de-by-09273000-09273452', 849],
        ['de-by-09671000-09671152', 850], ['de-by-09779000-09779169', 851],
        ['de-by-09677000-09677133', 852], ['de-by-09677000-09677122', 853],
        ['de-by-09675000-09675112', 854], ['de-by-09778000-09778163', 855],
        ['de-by-09676000-09676133', 856], ['de-by-09677000-09677454', 857],
        ['de-by-09677000-09677172', 858], ['de-by-09679000-09679185', 859],
        ['de-by-09780000-09780116', 860], ['de-by-09780000-09780113', 861],
        ['de-by-09473000-09473120', 862], ['de-by-09780000-09780131', 863],
        ['de-by-09174000-09174131', 864], ['de-by-09174000-09174147', 865],
        ['de-by-09373000-09373143', 866], ['de-by-09577000-09577148', 867],
        ['de-by-09774000-09774452', 868], ['de-by-09774000-09774150', 869],
        ['de-by-09775000-09775152', 870], ['de-by-09780000-09780140', 871],
        ['de-by-09780000-09780143', 872], ['de-by-09780000-09780137', 873],
        ['de-by-09780000-09780128', 874], ['de-by-09471000-09471452', 875],
        ['de-by-09174000-09174122', 876], ['de-by-09184000-09184149', 877],
        ['de-by-09184000-09184135', 878], ['de-by-09478000-09478111', 879],
        ['de-by-09477000-09477136', 880], ['de-by-09185000-09185166', 881],
        ['de-by-09476000-09476185', 882], ['de-by-09477000-09477151', 883],
        ['de-by-09185000-09185113', 884], ['de-by-09572000-09572127', 885],
        ['de-by-09178000-09178124', 886], ['de-by-09779000-09779203', 887],
        ['de-by-09374000-09374155', 888], ['de-by-09772000-09772217', 889],
        ['de-by-09472000-09472133', 890], ['de-by-09472000-09472199', 891],
        ['de-by-09272000-09272457', 892], ['de-by-09372000-09372116', 893],
        ['de-by-09471000-09471460', 894], ['de-by-09675000-09675127', 895],
        ['de-by-09575000-09575116', 896], ['de-by-09477000-09477129', 897],
        ['de-by-09679000-09679134', 898], ['de-by-09675000-09675111', 899],
        ['de-by-09675000-09675162', 900], ['de-by-09671000-09671135', 901],
        ['de-by-09679000-09679141', 902], ['de-by-09679000-09679126', 903],
        ['de-by-09676000-09676145', 904], ['de-by-09676000-09676144', 905],
        ['de-by-09678000-09678456', 906], ['de-by-09671000-09671126', 907],
        ['de-by-09671000-09671128', 908], ['de-by-09677000-09677148', 909],
        ['de-by-09571000-09571222', 910], ['de-by-09571000-09571169', 911],
        ['de-by-09771000-09771176', 912], ['de-by-09671000-09671461', 913],
        ['de-by-09571000-09571181', 914], ['de-by-09677000-09677458', 915],
        ['de-by-09571000-09571193', 916], ['de-by-09679000-09679118', 917],
        ['de-by-09678000-09678135', 918], ['de-by-09679000-09679165', 919],
        ['de-by-09679000-09679164', 920], ['de-by-09672000-09672466', 921],
        ['de-by-09679000-09679143', 922], ['de-by-09671000-09671119', 923],
        ['de-by-09474000-09474144', 924], ['de-by-09474000-09474119', 925],
        ['de-by-09572000-09572121', 926], ['de-by-09372000-09372157', 927],
        ['de-by-09372000-09372171', 928], ['de-by-09372000-09372168', 929],
        ['de-by-09573000-09573122', 930], ['de-by-09563000-09563000', 931],
        ['de-by-09476000-09476175', 932], ['de-by-09476000-09476179', 933],
        ['de-by-09476000-09476164', 934], ['de-by-09173000-09173131', 935],
        ['de-by-09180000-09180136', 936], ['de-by-09173000-09173113', 937],
        ['de-by-09471000-09471117', 938], ['de-by-09471000-09471191', 939],
        ['de-by-09674000-09674121', 940], ['de-by-09575000-09575179', 941],
        ['de-by-09574000-09574161', 942], ['de-by-09674000-09674139', 943],
        ['de-by-09371000-09371128', 944], ['de-by-09477000-09477142', 945],
        ['de-by-09477000-09477119', 946], ['de-by-09279000-09279126', 947],
        ['de-by-09279000-09279112', 948], ['de-by-09679000-09679453', 949],
        ['de-by-09571000-09571228', 950], ['de-by-09677000-09677126', 951],
        ['de-by-09677000-09677182', 952], ['de-by-09677000-09677177', 953],
        ['de-by-09677000-09677146', 954], ['de-by-09475000-09475142', 955],
        ['de-by-09475000-09475154', 956], ['de-by-09775000-09775143', 957],
        ['de-by-09774000-09774143', 958], ['de-by-09775000-09775126', 959],
        ['de-by-09774000-09774122', 960], ['de-by-09476000-09476146', 961],
        ['de-by-09179000-09179132', 962], ['de-by-09179000-09179121', 963],
        ['de-by-09471000-09471186', 964], ['de-by-09674000-09674159', 965],
        ['de-by-09573000-09573111', 966], ['de-by-09476000-09476180', 967],
        ['de-by-09476000-09476166', 968], ['de-by-09477000-09477156', 969],
        ['de-by-09676000-09676119', 970], ['de-by-09676000-09676143', 971],
        ['de-by-09377000-09377455', 972], ['de-by-09571000-09571135', 973],
        ['de-by-09473000-09473138', 974], ['de-by-09473000-09473132', 975],
        ['de-by-09676000-09676112', 976], ['de-by-09676000-09676165', 977],
        ['de-by-09274000-09274111', 978], ['de-by-09274000-09274146', 979],
        ['de-by-09274000-09274185', 980], ['de-by-09274000-09274165', 981],
        ['de-by-09776000-09776124', 982], ['de-by-09672000-09672117', 983],
        ['de-by-09672000-09672114', 984], ['de-by-09277000-09277117', 985],
        ['de-by-09672000-09672126', 986], ['de-by-09672000-09672456', 987],
        ['de-by-09776000-09776114', 988], ['de-by-09777000-09777125', 989],
        ['de-by-09777000-09777159', 990], ['de-by-09477000-09477117', 991],
        ['de-by-09477000-09477148', 992], ['de-by-09673000-09673452', 993],
        ['de-by-09673000-09673114', 994], ['de-by-09673000-09673163', 995],
        ['de-by-09376000-09376119', 996], ['de-by-09376000-09376141', 997],
        ['de-by-09572000-09572147', 998], ['de-by-09575000-09575181', 999],
        ['de-by-09774000-09774136', 1000], ['de-by-09773000-09773111', 1001],
        ['de-by-09773000-09773144', 1002], ['de-by-09171000-09171115', 1003],
        ['de-by-09171000-09171126', 1004], ['de-by-09372000-09372164', 1005],
        ['de-by-09372000-09372142', 1006], ['de-by-09278000-09278147', 1007],
        ['de-by-09278000-09278189', 1008], ['de-by-09279000-09279130', 1009],
        ['de-by-09274000-09274145', 1010], ['de-by-09274000-09274191', 1011],
        ['de-by-09372000-09372174', 1012], ['de-by-09276000-09276113', 1013],
        ['de-by-09372000-09372113', 1014], ['de-by-09171000-09171111', 1015],
        ['de-by-09774000-09774133', 1016], ['de-by-09374000-09374118', 1017],
        ['de-by-09372000-09372126', 1018], ['de-by-09676000-09676135', 1019],
        ['de-by-09776000-09776117', 1020], ['de-by-09476000-09476152', 1021],
        ['de-by-09779000-09779176', 1022], ['de-by-09771000-09771145', 1023],
        ['de-by-09475000-09475162', 1024], ['de-by-09475000-09475120', 1025],
        ['de-by-09772000-09772163', 1026], ['de-by-09376000-09376167', 1027],
        ['de-by-09376000-09376176', 1028], ['de-by-09473000-09473174', 1029],
        ['de-by-09279000-09279124', 1030], ['de-by-09271000-09271138', 1031],
        ['de-by-09271000-09271119', 1032], ['de-by-09271000-09271132', 1033],
        ['de-by-09175000-09175114', 1034], ['de-by-09778000-09778209', 1035],
        ['de-by-09774000-09774166', 1036], ['de-by-09187000-09187121', 1037],
        ['de-by-09189000-09189451', 1038], ['de-by-09182000-09182127', 1039],
        ['de-by-09173000-09173118', 1040], ['de-by-09372000-09372178', 1041],
        ['de-by-09176000-09176155', 1042], ['de-by-09577000-09577163', 1043],
        ['de-by-09472000-09472155', 1044], ['de-by-09472000-09472456', 1045],
        ['de-by-09176000-09176123', 1046], ['de-by-09176000-09176126', 1047],
        ['de-by-09186000-09186125', 1048], ['de-by-09185000-09185131', 1049],
        ['de-by-09771000-09771162', 1050], ['de-by-09178000-09178132', 1051],
        ['de-by-09275000-09275156', 1052], ['de-by-09475000-09475453', 1053],
        ['de-by-09476000-09476177', 1054], ['de-by-09189000-09189140', 1055],
        ['de-by-09189000-09189160', 1056], ['de-by-09189000-09189129', 1057],
        ['de-by-09187000-09187176', 1058], ['de-by-09187000-09187116', 1059],
        ['de-by-09261000-09261000', 1060], ['de-by-09274000-09274113', 1061],
        ['de-by-09375000-09375452', 1062], ['de-by-09274000-09274156', 1063],
        ['de-by-09277000-09277121', 1064], ['de-by-09274000-09274179', 1065],
        ['de-by-09275000-09275121', 1066], ['de-by-09275000-09275120', 1067],
        ['de-by-09577000-09577140', 1068], ['de-by-09577000-09577149', 1069],
        ['de-by-09371000-09371151', 1070], ['de-by-09371000-09371141', 1071],
        ['de-by-09177000-09177123', 1072], ['de-by-09175000-09175123', 1073],
        ['de-by-09175000-09175118', 1074], ['de-by-09175000-09175451', 1075],
        ['de-by-09376000-09376149', 1076], ['de-by-09372000-09372169', 1077],
        ['de-by-09376000-09376133', 1078], ['de-by-09376000-09376148', 1079],
        ['de-by-09278000-09278118', 1080], ['de-by-09272000-09272453', 1081],
        ['de-by-09177000-09177127', 1082], ['de-by-09177000-09177115', 1083],
        ['de-by-09577000-09577179', 1084], ['de-by-09779000-09779117', 1085],
        ['de-by-09372000-09372143', 1086], ['de-by-09472000-09472458', 1087],
        ['de-by-09372000-09372115', 1088], ['de-by-09275000-09275160', 1089],
        ['de-by-09274000-09274174', 1090], ['de-by-09274000-09274127', 1091],
        ['de-by-09376000-09376171', 1092], ['de-by-09375000-09375130', 1093],
        ['de-by-09182000-09182129', 1094], ['de-by-09171000-09171127', 1095],
        ['de-by-09180000-09180123', 1096], ['de-by-09275000-09275135', 1097],
        ['de-by-09275000-09275151', 1098], ['de-by-09187000-09187165', 1099],
        ['de-by-09163000-09163000', 1100], ['de-by-09187000-09187169', 1101],
        ['de-by-09183000-09183118', 1102], ['de-by-09180000-09180117', 1103],
        ['de-by-09778000-09778137', 1104], ['de-by-09778000-09778169', 1105],
        ['de-by-09780000-09780114', 1106], ['de-by-09763000-09763000', 1107],
        ['de-by-09171000-09171134', 1108], ['de-by-09375000-09375451', 1109],
        ['de-by-09375000-09375209', 1110], ['de-by-09474000-09474171', 1111],
        ['de-by-09172000-09172122', 1112], ['de-by-09189000-09189127', 1113],
        ['de-by-09189000-09189162', 1114], ['de-by-09271000-09271141', 1115],
        ['de-by-09279000-09279113', 1116], ['de-by-09274000-09274176', 1117],
        ['de-by-09274000-09274153', 1118], ['de-by-09187000-09187168', 1119],
        ['de-by-09187000-09187167', 1120], ['de-by-09187000-09187179', 1121],
        ['de-by-09175000-09175136', 1122], ['de-by-09479000-09479453', 1123],
        ['de-by-09479000-09479159', 1124], ['de-by-09479000-09479158', 1125],
        ['de-by-09274000-09274184', 1126], ['de-by-09183000-09183114', 1127],
        ['de-by-09189000-09189161', 1128], ['de-by-09189000-09189119', 1129],
        ['de-by-09471000-09471169', 1130], ['de-by-09189000-09189118', 1131],
        ['de-by-09189000-09189150', 1132], ['de-by-09189000-09189145', 1133],
        ['de-by-09376000-09376131', 1134], ['de-by-09374000-09374159', 1135],
        ['de-by-09376000-09376173', 1136], ['de-by-09271000-09271113', 1137],
        ['de-by-09271000-09271148', 1138], ['de-by-09272000-09272152', 1139],
        ['de-by-09175000-09175119', 1140], ['de-by-09372000-09372163', 1141],
        ['de-by-09372000-09372154', 1142], ['de-by-09274000-09274121', 1143],
        ['de-by-09275000-09275131', 1144], ['de-by-09277000-09277112', 1145],
        ['de-by-09189000-09189154', 1146], ['de-by-09189000-09189111', 1147],
        ['de-by-09777000-09777129', 1148], ['de-by-09189000-09189133', 1149],
        ['de-by-09189000-09189126', 1150], ['de-by-09183000-09183148', 1151],
        ['de-by-09574000-09574140', 1152], ['de-by-09574000-09574160', 1153],
        ['de-by-09277000-09277151', 1154], ['de-by-09278000-09278120', 1155],
        ['de-by-09278000-09278116', 1156], ['de-by-09277000-09277118', 1157],
        ['de-by-09572000-09572139', 1158], ['de-by-09183000-09183145', 1159],
        ['de-by-09271000-09271130', 1160], ['de-by-09278000-09278151', 1161],
        ['de-by-09278000-09278190', 1162], ['de-by-09183000-09183119', 1163],
        ['de-by-09374000-09374452', 1164], ['de-by-09187000-09187137', 1165],
        ['de-by-09278000-09278182', 1166], ['de-by-09275000-09275119', 1167],
        ['de-by-09272000-09272151', 1168], ['de-by-09275000-09275126', 1169],
        ['de-by-09183000-09183139', 1170], ['de-by-09271000-09271122', 1171],
        ['de-by-09276000-09276123', 1172], ['de-by-09776000-09776131', 1173],
        ['de-by-09276000-09276134', 1174], ['de-by-09274000-09274134', 1175],
        ['de-by-09571000-09571224', 1176], ['de-by-09372000-09372151', 1177],
        ['de-by-09186000-09186122', 1178], ['de-by-09372000-09372112', 1179],
        ['de-by-09186000-09186158', 1180], ['de-by-09186000-09186116', 1181],
        ['de-by-09272000-09272456', 1182], ['de-by-09272000-09272134', 1183],
        ['de-by-09272000-09272461', 1184], ['de-by-09377000-09377117', 1185],
        ['de-by-09377000-09377159', 1186], ['de-by-09377000-09377118', 1187],
        ['de-by-09377000-09377132', 1188], ['de-by-09372000-09372147', 1189],
        ['de-by-09375000-09375205', 1190], ['de-by-09375000-09375143', 1191],
        ['de-by-09375000-09375183', 1192], ['de-by-09375000-09375170', 1193],
        ['de-by-09183000-09183138', 1194], ['de-by-09183000-09183135', 1195],
        ['de-by-09375000-09375171', 1196], ['de-by-09375000-09375191', 1197],
        ['de-by-09773000-09773139', 1198], ['de-by-09375000-09375120', 1199],
        ['de-by-09773000-09773150', 1200], ['de-by-09375000-09375131', 1201],
        ['de-by-09574000-09574111', 1202], ['de-by-09371000-09371116', 1203],
        ['de-by-09780000-09780121', 1204], ['de-by-09780000-09780133', 1205],
        ['de-by-09574000-09574117', 1206], ['de-by-09373000-09373113', 1207],
        ['de-by-09375000-09375156', 1208], ['de-by-09373000-09373134', 1209],
        ['de-by-09371000-09371148', 1210], ['de-by-09571000-09571190', 1211],
        ['de-by-09571000-09571196', 1212], ['de-by-09278000-09278146', 1213],
        ['de-by-09673000-09673131', 1214], ['de-by-09273000-09273116', 1215],
        ['de-by-09271000-09271151', 1216], ['de-by-09374000-09374117', 1217],
        ['de-by-09374000-09374137', 1218], ['de-by-09374000-09374453', 1219],
        ['de-by-09375000-09375119', 1220], ['de-by-09277000-09277114', 1221],
        ['de-by-09275000-09275112', 1222], ['de-by-09277000-09277144', 1223],
        ['de-by-09377000-09377131', 1224], ['de-by-09479000-09479112', 1225],
        ['de-by-09279000-09279127', 1226], ['de-by-09271000-09271111', 1227],
        ['de-by-09271000-09271139', 1228], ['de-by-09471000-09471207', 1229],
        ['de-by-09375000-09375116', 1230], ['de-by-09274000-09274120', 1231],
        ['de-by-09183000-09183129', 1232], ['de-by-09276000-09276139', 1233],
        ['de-by-09276000-09276127', 1234], ['de-by-09276000-09276129', 1235],
        ['de-by-09276000-09276138', 1236], ['de-by-09276000-09276126', 1237],
        ['de-by-09183000-09183126', 1238], ['de-by-09277000-09277111', 1239],
        ['de-by-09277000-09277131', 1240], ['de-by-09372000-09372137', 1241],
        ['de-by-09374000-09374158', 1242], ['de-by-09374000-09374128', 1243],
        ['de-by-09374000-09374133', 1244], ['de-by-09371000-09371150', 1245],
        ['de-by-09371000-09371122', 1246], ['de-by-09272000-09272149', 1247],
        ['de-by-09272000-09272116', 1248], ['de-by-09171000-09171129', 1249],
        ['de-by-09172000-09172114', 1250], ['de-by-09172000-09172115', 1251],
        ['de-by-09172000-09172117', 1252], ['de-by-09172000-09172454', 1253],
        ['de-by-09573000-09573133', 1254], ['de-by-09271000-09271127', 1255],
        ['de-by-09571000-09571226', 1256], ['de-by-09571000-09571229', 1257],
        ['de-by-09571000-09571165', 1258], ['de-by-09575000-09575128', 1259],
        ['de-by-09271000-09271116', 1260], ['de-by-09479000-09479461', 1261],
        ['de-by-09479000-09479161', 1262], ['de-by-09371000-09371129', 1263],
        ['de-by-09373000-09373140', 1264], ['de-by-09571000-09571175', 1265],
        ['de-by-09474000-09474161', 1266], ['de-by-09376000-09376178', 1267],
        ['de-by-09183000-09183127', 1268], ['de-by-09183000-09183125', 1269],
        ['de-by-09274000-09274118', 1270], ['de-by-09274000-09274154', 1271],
        ['de-by-09189000-09189113', 1272], ['de-by-09372000-09372125', 1273],
        ['de-by-09278000-09278172', 1274], ['de-by-09183000-09183116', 1275],
        ['de-by-09376000-09376168', 1276], ['de-by-09677000-09677137', 1277],
        ['de-by-09674000-09674147', 1278], ['de-by-09677000-09677128', 1279],
        ['de-by-09678000-09678192', 1280], ['de-by-09177000-09177137', 1281],
        ['de-by-09671000-09671112', 1282], ['de-by-09675000-09675170', 1283],
        ['de-by-09679000-09679131', 1284], ['de-by-09572000-09572154', 1285],
        ['de-by-09375000-09375182', 1286], ['de-by-09278000-09278144', 1287],
        ['de-by-09572000-09572120', 1288], ['de-by-09374000-09374150', 1289],
        ['de-by-09471000-09471151', 1290], ['de-by-09273000-09273141', 1291],
        ['de-by-09471000-09471155', 1292], ['de-by-09471000-09471455', 1293],
        ['de-by-09273000-09273175', 1294], ['de-by-09474000-09474158', 1295],
        ['de-by-09474000-09474122', 1296], ['de-by-09374000-09374168', 1297],
        ['de-by-09471000-09471459', 1298], ['de-by-09371000-09371118', 1299],
        ['de-by-09472000-09472150', 1300], ['de-by-09479000-09479455', 1301],
        ['de-by-09475000-09475454', 1302], ['de-by-09276000-09276116', 1303],
        ['de-by-09189000-09189142', 1304], ['de-by-09172000-09172111', 1305],
        ['de-by-09187000-09187117', 1306], ['de-by-09187000-09187129', 1307],
        ['de-by-09673000-09673135', 1308], ['de-by-09187000-09187118', 1309],
        ['de-by-09187000-09187162', 1310], ['de-by-09679000-09679205', 1311],
        ['de-by-09375000-09375211', 1312], ['de-by-09679000-09679204', 1313],
        ['de-by-09375000-09375190', 1314], ['de-by-09375000-09375213', 1315],
        ['de-by-09375000-09375153', 1316], ['de-by-09571000-09571137', 1317],
        ['de-by-09571000-09571114', 1318], ['de-by-09277000-09277128', 1319],
        ['de-by-09277000-09277140', 1320], ['de-by-09375000-09375179', 1321],
        ['de-by-09277000-09277152', 1322], ['de-by-09177000-09177138', 1323],
        ['de-by-09177000-09177122', 1324], ['de-by-09473000-09473159', 1325],
        ['de-by-09679000-09679122', 1326], ['de-by-09679000-09679153', 1327],
        ['de-by-09189000-09189159', 1328], ['de-by-09189000-09189120', 1329],
        ['de-by-09671000-09671148', 1330], ['de-by-09272000-09272141', 1331],
        ['de-by-09571000-09571198', 1332], ['de-by-09571000-09571134', 1333],
        ['de-by-09187000-09187173', 1334], ['de-by-09187000-09187134', 1335],
        ['de-by-09187000-09187181', 1336], ['de-by-09187000-09187177', 1337],
        ['de-by-09677000-09677459', 1338], ['de-by-09187000-09187164', 1339],
        ['de-by-09679000-09679124', 1340], ['de-by-09679000-09679187', 1341],
        ['de-by-09275000-09275117', 1342], ['de-by-09275000-09275114', 1343],
        ['de-by-09271000-09271128', 1344], ['de-by-09177000-09177121', 1345],
        ['de-by-09177000-09177124', 1346], ['de-by-09377000-09377142', 1347],
        ['de-by-09377000-09377137', 1348], ['de-by-09277000-09277154', 1349],
        ['de-by-09479000-09479126', 1350], ['de-by-09276000-09276146', 1351],
        ['de-by-09189000-09189452', 1352], ['de-by-09172000-09172128', 1353],
        ['de-by-09171000-09171113', 1354], ['de-by-09171000-09171122', 1355],
        ['de-by-09473000-09473151', 1356], ['de-by-09277000-09277149', 1357],
        ['de-by-09277000-09277138', 1358], ['de-by-09271000-09271146', 1359],
        ['de-by-09278000-09278184', 1360], ['de-by-09171000-09171119', 1361],
        ['de-by-09187000-09187120', 1362], ['de-by-09278000-09278141', 1363],
        ['de-by-09277000-09277126', 1364], ['de-by-09277000-09277122', 1365],
        ['de-by-09376000-09376454', 1366], ['de-by-09171000-09171131', 1367],
        ['de-by-09275000-09275116', 1368], ['de-by-09275000-09275130', 1369],
        ['de-by-09272000-09272118', 1370], ['de-by-09187000-09187452', 1371],
        ['de-by-09372000-09372150', 1372], ['de-by-09271000-09271135', 1373],
        ['de-by-09187000-09187170', 1374], ['de-by-09187000-09187451', 1375],
        ['de-by-09276000-09276142', 1376], ['de-by-09574000-09574458', 1377],
        ['de-by-09574000-09574152', 1378], ['de-by-09272000-09272129', 1379],
        ['de-by-09574000-09574156', 1380], ['de-by-09187000-09187174', 1381],
        ['de-by-09187000-09187142', 1382], ['de-by-09479000-09479136', 1383],
        ['de-by-09479000-09479459', 1384], ['de-by-09377000-09377154', 1385],
        ['de-by-09377000-09377141', 1386], ['de-by-09377000-09377158', 1387],
        ['de-by-09277000-09277147', 1388], ['de-by-09377000-09377148', 1389],
        ['de-by-09780000-09780122', 1390], ['de-by-09188000-09188451', 1391],
        ['de-by-09188000-09188137', 1392], ['de-by-09777000-09777151', 1393],
        ['de-by-09674000-09674153', 1394], ['de-by-09678000-09678174', 1395],
        ['de-by-09772000-09772209', 1396], ['de-by-09772000-09772162', 1397],
        ['de-by-09175000-09175132', 1398], ['de-by-09188000-09188139', 1399],
        ['de-by-09175000-09175139', 1400], ['de-by-09575000-09575166', 1401],
        ['de-by-09575000-09575152', 1402], ['de-by-09673000-09673147', 1403],
        ['de-by-09673000-09673167', 1404], ['de-by-09185000-09185123', 1405],
        ['de-by-09181000-09181135', 1406], ['de-by-09181000-09181133', 1407],
        ['de-by-09185000-09185116', 1408], ['de-by-09185000-09185140', 1409],
        ['de-by-09772000-09772151', 1410], ['de-by-09772000-09772149', 1411],
        ['de-by-09185000-09185168', 1412], ['de-by-09186000-09186137', 1413],
        ['de-by-09171000-09171130', 1414], ['de-by-09276000-09276148', 1415],
        ['de-by-09471000-09471115', 1416], ['de-by-09471000-09471150', 1417],
        ['de-by-09177000-09177119', 1418], ['de-by-09273000-09273159', 1419],
        ['de-by-09677000-09677116', 1420], ['de-by-09677000-09677453', 1421],
        ['de-by-09188000-09188113', 1422], ['de-by-09779000-09779115', 1423],
        ['de-by-09180000-09180132', 1424], ['de-by-09180000-09180112', 1425],
        ['de-by-09180000-09180129', 1426], ['de-by-09476000-09476182', 1427],
        ['de-by-09180000-09180115', 1428], ['de-by-09173000-09173123', 1429],
        ['de-by-09173000-09173126', 1430], ['de-by-09179000-09179147', 1431],
        ['de-by-09271000-09271125', 1432], ['de-by-09271000-09271153', 1433],
        ['de-by-09678000-09678134', 1434], ['de-by-09478000-09478139', 1435],
        ['de-by-09473000-09473170', 1436], ['de-by-09376000-09376160', 1437],
        ['de-by-09779000-09779228', 1438], ['de-by-09676000-09676123', 1439],
        ['de-by-09676000-09676158', 1440], ['de-by-09377000-09377149', 1441],
        ['de-by-09676000-09676125', 1442], ['de-by-09776000-09776122', 1443],
        ['de-by-09673000-09673113', 1444], ['de-by-09279000-09279137', 1445],
        ['de-by-09171000-09171117', 1446], ['de-by-09271000-09271123', 1447],
        ['de-by-09575000-09575157', 1448], ['de-by-09377000-09377119', 1449],
        ['de-by-09675000-09675139', 1450], ['de-by-09274000-09274114', 1451],
        ['de-by-09274000-09274182', 1452], ['de-by-09374000-09374140', 1453],
        ['de-by-09189000-09189115', 1454], ['de-by-09187000-09187159', 1455],
        ['de-by-09674000-09674210', 1456], ['de-by-09674000-09674184', 1457],
        ['de-by-09675000-09675178', 1458], ['de-by-09673000-09673170', 1459],
        ['de-by-09673000-09673142', 1460], ['de-by-09186000-09186149', 1461],
        ['de-by-09186000-09186147', 1462], ['de-by-09186000-09186113', 1463],
        ['de-by-09571000-09571208', 1464], ['de-by-09771000-09771144', 1465],
        ['de-by-09577000-09577173', 1466], ['de-by-09772000-09772134', 1467],
        ['de-by-09185000-09185127', 1468], ['de-by-09779000-09779453', 1469],
        ['de-by-09673000-09673134', 1470], ['de-by-09673000-09673162', 1471],
        ['de-by-09673000-09673453', 1472], ['de-by-09174000-09174121', 1473],
        ['de-by-09771000-09771113', 1474], ['de-by-09771000-09771141', 1475],
        ['de-by-09577000-09577158', 1476], ['de-by-09779000-09779198', 1477],
        ['de-by-09779000-09779148', 1478], ['de-by-09174000-09174115', 1479],
        ['de-by-09174000-09174113', 1480], ['de-by-09474000-09474160', 1481],
        ['de-by-09174000-09174126', 1482], ['de-by-09773000-09773116', 1483],
        ['de-by-09372000-09372165', 1484], ['de-by-09674000-09674171', 1485],
        ['de-by-09674000-09674149', 1486], ['de-by-09184000-09184138', 1487],
        ['de-by-09675000-09675141', 1488], ['de-by-09676000-09676455', 1489],
        ['de-by-09679000-09679146', 1490], ['de-by-09572000-09572142', 1491],
        ['de-by-09572000-09572115', 1492], ['de-by-09674000-09674160', 1493],
        ['de-by-09572000-09572130', 1494], ['de-by-09572000-09572149', 1495],
        ['de-by-09572000-09572133', 1496], ['de-by-09572000-09572459', 1497],
        ['de-by-09374000-09374163', 1498], ['de-by-09471000-09471456', 1499],
        ['de-by-09674000-09674187', 1500], ['de-by-09472000-09472188', 1501],
        ['de-by-09472000-09472166', 1502], ['de-by-09576000-09576143', 1503],
        ['de-by-09471000-09471454', 1504], ['de-by-09674000-09674190', 1505],
        ['de-by-09474000-09474134', 1506], ['de-by-09372000-09372138', 1507],
        ['de-by-09372000-09372144', 1508], ['de-by-09182000-09182112', 1509],
        ['de-by-09187000-09187157', 1510], ['de-by-09275000-09275146', 1511],
        ['de-by-09572000-09572119', 1512], ['de-by-09472000-09472460', 1513],
        ['de-by-09472000-09472461', 1514], ['de-by-09677000-09677457', 1515],
        ['de-by-09475000-09475137', 1516], ['de-by-09679000-09679137', 1517],
        ['de-by-09679000-09679452', 1518], ['de-by-09679000-09679196', 1519],
        ['de-by-09184000-09184120', 1520], ['de-by-09181000-09181124', 1521],
        ['de-by-09674000-09674219', 1522], ['de-by-09181000-09181140', 1523],
        ['de-by-09181000-09181130', 1524], ['de-by-09777000-09777121', 1525],
        ['de-by-09675000-09675117', 1526], ['de-by-09675000-09675155', 1527],
        ['de-by-09679000-09679130', 1528], ['de-by-09777000-09777164', 1529],
        ['de-by-09777000-09777158', 1530], ['de-by-09777000-09777130', 1531],
        ['de-by-09575000-09575143', 1532], ['de-by-09777000-09777118', 1533],
        ['de-by-09777000-09777112', 1534], ['de-by-09777000-09777172', 1535],
        ['de-by-09779000-09779167', 1536], ['de-by-09779000-09779111', 1537],
        ['de-by-09779000-09779130', 1538], ['de-by-09475000-09475113', 1539],
        ['de-by-09475000-09475171', 1540], ['de-by-09779000-09779154', 1541],
        ['de-by-09679000-09679174', 1542], ['de-by-09672000-09672458', 1543],
        ['de-by-09679000-09679167', 1544], ['de-by-09772000-09772125', 1545],
        ['de-by-09779000-09779155', 1546], ['de-by-09779000-09779131', 1547],
        ['de-by-09673000-09673182', 1548], ['de-by-09673000-09673455', 1549],
        ['de-by-09574000-09574158', 1550], ['de-by-09562000-09562000', 1551],
        ['de-by-09780000-09780118', 1552], ['de-by-09780000-09780124', 1553],
        ['de-by-09479000-09479452', 1554], ['de-by-09377000-09377157', 1555],
        ['de-by-09673000-09673175', 1556], ['de-by-09377000-09377116', 1557],
        ['de-by-09777000-09777173', 1558], ['de-by-09777000-09777147', 1559],
        ['de-by-09673000-09673116', 1560], ['de-by-09673000-09673153', 1561],
        ['de-by-09375000-09375201', 1562], ['de-by-09190000-09190143', 1563],
        ['de-by-09672000-09672462', 1564], ['de-by-09475000-09475146', 1565],
        ['de-by-09773000-09773182', 1566], ['de-by-09772000-09772121', 1567],
        ['de-by-09772000-09772145', 1568], ['de-by-09778000-09778202', 1569],
        ['de-by-09375000-09375165', 1570], ['de-by-09471000-09471154', 1571],
        ['de-by-09278000-09278112', 1572], ['de-by-09179000-09179142', 1573],
        ['de-by-09182000-09182120', 1574], ['de-by-09173000-09173141', 1575],
        ['de-by-09175000-09175111', 1576], ['de-by-09376000-09376164', 1577],
        ['de-by-09564000-09564000', 1578], ['de-by-09672000-09672145', 1579],
        ['de-by-09673000-09673160', 1580], ['de-by-09673000-09673126', 1581],
        ['de-by-09677000-09677455', 1582], ['de-by-09472000-09472111', 1583],
        ['de-by-09474000-09474129', 1584], ['de-by-09472000-09472469', 1585],
        ['de-by-09673000-09673156', 1586], ['de-by-09171000-09171124', 1587],
        ['de-by-09171000-09171123', 1588], ['de-by-09171000-09171114', 1589],
        ['de-by-09373000-09373147', 1590], ['de-by-09777000-09777167', 1591],
        ['de-by-09777000-09777175', 1592], ['de-by-09780000-09780115', 1593],
        ['de-by-09278000-09278192', 1594], ['de-by-09780000-09780132', 1595],
        ['de-by-09188000-09188141', 1596], ['de-by-09190000-09190159', 1597],
        ['de-by-09188000-09188117', 1598], ['de-by-09778000-09778171', 1599],
        ['de-by-09779000-09779112', 1600], ['de-by-09571000-09571223', 1601],
        ['de-by-09571000-09571145', 1602], ['de-by-09571000-09571200', 1603],
        ['de-by-09571000-09571199', 1604], ['de-by-09672000-09672135', 1605],
        ['de-by-09673000-09673123', 1606], ['de-by-09673000-09673458', 1607],
        ['de-by-09774000-09774189', 1608], ['de-by-09376000-09376170', 1609],
        ['de-by-09573000-09573129', 1610], ['de-by-09376000-09376161', 1611],
        ['de-by-09374000-09374127', 1612], ['de-by-09471000-09471159', 1613],
        ['de-by-09461000-09461000', 1614], ['de-by-09472000-09472463', 1615],
        ['de-by-09674000-09674120', 1616], ['de-by-09673000-09673117', 1617],
        ['de-by-09272000-09272146', 1618], ['de-by-09773000-09773125', 1619],
        ['de-by-09673000-09673183', 1620], ['de-by-09673000-09673133', 1621],
        ['de-by-09776000-09776120', 1622], ['de-by-09672000-09672136', 1623],
        ['de-by-09673000-09673146', 1624], ['de-by-09373000-09373159', 1625],
        ['de-by-09373000-09373114', 1626], ['de-by-09672000-09672468', 1627],
        ['de-by-09779000-09779146', 1628], ['de-by-09472000-09472468', 1629],
        ['de-by-09672000-09672134', 1630], ['de-by-09271000-09271114', 1631],
        ['de-by-09271000-09271140', 1632], ['de-by-09189000-09189157', 1633],
        ['de-by-09180000-09180113', 1634], ['de-by-09274000-09274188', 1635],
        ['de-by-09190000-09190160', 1636], ['de-by-09190000-09190145', 1637],
        ['de-by-09275000-09275152', 1638], ['de-by-09190000-09190154', 1639],
        ['de-by-09184000-09184148', 1640], ['de-by-09182000-09182123', 1641],
        ['de-by-09190000-09190115', 1642], ['de-by-09180000-09180125', 1643],
        ['de-by-09184000-09184139', 1644], ['de-by-09175000-09175124', 1645],
        ['de-by-09672000-09672163', 1646], ['de-by-09773000-09773187', 1647],
        ['de-by-09574000-09574128', 1648], ['de-by-09780000-09780139', 1649],
        ['de-by-09184000-09184129', 1650], ['de-by-09184000-09184136', 1651],
        ['de-by-09190000-09190140', 1652], ['de-by-09190000-09190118', 1653],
        ['de-by-09779000-09779138', 1654], ['de-by-09775000-09775111', 1655],
        ['de-by-09474000-09474146', 1656], ['de-by-09671000-09671155', 1657],
        ['de-by-09476000-09476154', 1658], ['de-by-09476000-09476178', 1659],
        ['de-by-09476000-09476145', 1660], ['de-by-09773000-09773136', 1661],
        ['de-by-09674000-09674223', 1662], ['de-by-09376000-09376175', 1663],
        ['de-by-09376000-09376147', 1664], ['de-by-09773000-09773147', 1665],
        ['de-by-09474000-09474124', 1666], ['de-by-09773000-09773183', 1667],
        ['de-by-09776000-09776129', 1668], ['de-by-09771000-09771146', 1669],
        ['de-by-09172000-09172131', 1670], ['de-by-09761000-09761000', 1671],
        ['de-by-09574000-09574132', 1672], ['de-by-09189000-09189134', 1673],
        ['de-by-09375000-09375181', 1674], ['de-by-09374000-09374121', 1675],
        ['de-by-09183000-09183451', 1676], ['de-by-09276000-09276122', 1677],
        ['de-by-09276000-09276118', 1678], ['de-by-09175000-09175137', 1679],
        ['de-by-09175000-09175115', 1680], ['de-by-09190000-09190144', 1681],
        ['de-by-09190000-09190158', 1682], ['de-by-09190000-09190142', 1683],
        ['de-by-09181000-09181114', 1684], ['de-by-09181000-09181137', 1685],
        ['de-by-09374000-09374160', 1686], ['de-by-09190000-09190120', 1687],
        ['de-by-09276000-09276117', 1688], ['de-by-09190000-09190113', 1689],
        ['de-by-09190000-09190136', 1690], ['de-by-09177000-09177114', 1691],
        ['de-by-09278000-09278154', 1692], ['de-by-09183000-09183130', 1693],
        ['de-by-09171000-09171121', 1694], ['de-by-09372000-09372161', 1695],
        ['de-by-09376000-09376146', 1696], ['de-by-09372000-09372177', 1697],
        ['de-by-09172000-09172112', 1698], ['de-by-09183000-09183143', 1699],
        ['de-by-09183000-09183115', 1700], ['de-by-09187000-09187182', 1701],
        ['de-by-09187000-09187126', 1702], ['de-by-09376000-09376453', 1703],
        ['de-by-09372000-09372149', 1704], ['de-by-09376000-09376125', 1705],
        ['de-by-09271000-09271143', 1706], ['de-by-09187000-09187138', 1707],
        ['de-by-09187000-09187125', 1708], ['de-by-09187000-09187145', 1709],
        ['de-by-09375000-09375113', 1710], ['de-by-09183000-09183112', 1711],
        ['de-by-09183000-09183144', 1712], ['de-by-09174000-09174118', 1713],
        ['de-by-09187000-09187131', 1714], ['de-by-09779000-09779206', 1715],
        ['de-by-09277000-09277141', 1716], ['de-by-09277000-09277133', 1717],
        ['de-by-09181000-09181129', 1718], ['de-by-09181000-09181113', 1719],
        ['de-by-09190000-09190129', 1720], ['de-by-09272000-09272454', 1721],
        ['de-by-09777000-09777182', 1722], ['de-by-09777000-09777141', 1723],
        ['de-by-09375000-09375180', 1724], ['de-by-09177000-09177131', 1725],
        ['de-by-09179000-09179136', 1726], ['de-by-09377000-09377145', 1727],
        ['de-by-09274000-09274141', 1728], ['de-by-09184000-09184114', 1729],
        ['de-by-09375000-09375117', 1730], ['de-by-09273000-09273133', 1731],
        ['de-by-09176000-09176150', 1732], ['de-by-09278000-09278113', 1733],
        ['de-by-09773000-09773179', 1734], ['de-by-09176000-09176165', 1735],
        ['de-by-09779000-09779136', 1736], ['de-by-09778000-09778183', 1737],
        ['de-by-09273000-09273164', 1738], ['de-by-09375000-09375122', 1739],
        ['de-by-09374000-09374147', 1740], ['de-by-09374000-09374119', 1741],
        ['de-by-09575000-09575119', 1742], ['de-by-09575000-09575145', 1743],
        ['de-by-09374000-09374131', 1744], ['de-by-09575000-09575112', 1745],
        ['de-by-09272000-09272150', 1746], ['de-by-09187000-09187186', 1747],
        ['de-by-09776000-09776116', 1748], ['de-by-09776000-09776128', 1749],
        ['de-by-09187000-09187124', 1750], ['de-by-09776000-09776111', 1751],
        ['de-by-09183000-09183134', 1752], ['de-by-09271000-09271149', 1753],
        ['de-by-09187000-09187150', 1754], ['de-by-09279000-09279122', 1755],
        ['de-by-09279000-09279135', 1756], ['de-by-09372000-09372158', 1757],
        ['de-by-09771000-09771130', 1758], ['de-by-09172000-09172134', 1759],
        ['de-by-09773000-09773133', 1760], ['de-by-09189000-09189165', 1761],
        ['de-by-09779000-09779231', 1762], ['de-by-09276000-09276121', 1763],
        ['de-by-09272000-09272460', 1764], ['de-by-09187000-09187113', 1765],
        ['de-by-09189000-09189137', 1766], ['de-by-09277000-09277145', 1767],
        ['de-by-09278000-09278134', 1768], ['de-by-09172000-09172130', 1769],
        ['de-by-09189000-09189135', 1770], ['de-by-09571000-09571171', 1771],
        ['de-by-09272000-09272128', 1772], ['de-by-09571000-09571152', 1773],
        ['de-by-09375000-09375161', 1774], ['de-by-09571000-09571125', 1775],
        ['de-by-09183000-09183151', 1776], ['de-by-09671000-09671458', 1777],
        ['de-by-09671000-09671459', 1778], ['de-by-09372000-09372146', 1779],
        ['de-by-09376000-09376116', 1780], ['de-by-09276000-09276135', 1781],
        ['de-by-09171000-09171125', 1782], ['de-by-09187000-09187154', 1783],
        ['de-by-09183000-09183136', 1784], ['de-by-09171000-09171135', 1785],
        ['de-by-09475000-09475161', 1786], ['de-by-09278000-09278198', 1787],
        ['de-by-09375000-09375208', 1788], ['de-by-09276000-09276143', 1789],
        ['de-by-09376000-09376151', 1790], ['de-by-09179000-09179126', 1791],
        ['de-by-09177000-09177139', 1792], ['de-by-09180000-09180118', 1793],
        ['de-by-09278000-09278139', 1794], ['de-by-09374000-09374166', 1795],
        ['de-by-09576000-09576141', 1796], ['de-by-09276000-09276111', 1797],
        ['de-by-09190000-09190148', 1798], ['de-by-09375000-09375204', 1799],
        ['de-by-09472000-09472139', 1800], ['de-by-09472000-09472116', 1801],
        ['de-by-09272000-09272147', 1802], ['de-by-09171000-09171133', 1803],
        ['de-by-09477000-09477127', 1804], ['de-by-09477000-09477143', 1805],
        ['de-by-09187000-09187139', 1806], ['de-by-09477000-09477159', 1807],
        ['de-by-09274000-09274132', 1808], ['de-by-09274000-09274126', 1809],
        ['de-by-09274000-09274187', 1810], ['de-by-09575000-09575167', 1811],
        ['de-by-09278000-09278117', 1812], ['de-by-09278000-09278177', 1813],
        ['de-by-09275000-09275145', 1814], ['de-by-09183000-09183131', 1815],
        ['de-by-09274000-09274119', 1816], ['de-by-09189000-09189143', 1817],
        ['de-by-09189000-09189114', 1818], ['de-by-09374000-09374170', 1819],
        ['de-by-09576000-09576113', 1820], ['de-by-09373000-09373167', 1821],
        ['de-by-09274000-09274124', 1822], ['de-by-09275000-09275143', 1823],
        ['de-by-09275000-09275149', 1824], ['de-by-09179000-09179118', 1825],
        ['de-by-09179000-09179119', 1826], ['de-by-09179000-09179113', 1827],
        ['de-by-09673000-09673173', 1828], ['de-by-09190000-09190141', 1829],
        ['de-by-09173000-09173115', 1830], ['de-by-09673000-09673127', 1831],
        ['de-by-09190000-09190132', 1832], ['de-by-09184000-09184146', 1833],
        ['de-by-09173000-09173134', 1834], ['de-by-09777000-09777168', 1835],
        ['de-by-09377000-09377139', 1836], ['de-by-09377000-09377112', 1837],
        ['de-by-09777000-09777131', 1838], ['de-by-09173000-09173452', 1839],
        ['de-by-09175000-09175128', 1840], ['de-by-09175000-09175121', 1841],
        ['de-by-09175000-09175131', 1842], ['de-by-09184000-09184127', 1843],
        ['de-by-09180000-09180122', 1844], ['de-by-09181000-09181115', 1845],
        ['de-by-09181000-09181123', 1846], ['de-by-09181000-09181139', 1847],
        ['de-by-09173000-09173130', 1848], ['de-by-09180000-09180124', 1849],
        ['de-by-09777000-09777155', 1850], ['de-by-09777000-09777140', 1851],
        ['de-by-09778000-09778216', 1852], ['de-by-09373000-09373153', 1853],
        ['de-by-09474000-09474138', 1854], ['de-by-09471000-09471208', 1855],
        ['de-by-09479000-09479169', 1856], ['de-by-09371000-09371132', 1857],
        ['de-by-09376000-09376153', 1858], ['de-by-09577000-09577125', 1859],
        ['de-by-09471000-09471189', 1860], ['de-by-09779000-09779186', 1861],
        ['de-by-09572000-09572114', 1862], ['de-by-09574000-09574147', 1863],
        ['de-by-09377000-09377113', 1864], ['de-by-09479000-09479129', 1865],
        ['de-by-09475000-09475184', 1866], ['de-by-09475000-09475174', 1867],
        ['de-by-09473000-09473134', 1868], ['de-by-09672000-09672157', 1869],
        ['de-by-09279000-09279134', 1870], ['de-by-09275000-09275144', 1871],
        ['de-by-09189000-09189146', 1872], ['de-by-09187000-09187156', 1873],
        ['de-by-09275000-09275132', 1874], ['de-by-09371000-09371131', 1875],
        ['de-by-09276000-09276128', 1876], ['de-by-09374000-09374458', 1877],
        ['de-by-09277000-09277142', 1878], ['de-by-09576000-09576142', 1879],
        ['de-by-09573000-09573125', 1880], ['de-by-09279000-09279115', 1881],
        ['de-by-09274000-09274112', 1882], ['de-by-09274000-09274135', 1883],
        ['de-by-09576000-09576111', 1884], ['de-by-09172000-09172129', 1885],
        ['de-by-09372000-09372124', 1886], ['de-by-09187000-09187132', 1887],
        ['de-by-09272000-09272142', 1888], ['de-by-09276000-09276115', 1889],
        ['de-by-09276000-09276130', 1890], ['de-by-09278000-09278129', 1891],
        ['de-by-09372000-09372135', 1892], ['de-by-09372000-09372130', 1893],
        ['de-by-09277000-09277148', 1894], ['de-by-09375000-09375115', 1895],
        ['de-by-09278000-09278148', 1896], ['de-by-09275000-09275148', 1897],
        ['de-by-09275000-09275127', 1898], ['de-by-09471000-09471185', 1899],
        ['de-by-09471000-09471214', 1900], ['de-by-09572000-09572460', 1901],
        ['de-by-09477000-09477135', 1902], ['de-by-09374000-09374162', 1903],
        ['de-by-09571000-09571146', 1904], ['de-by-09574000-09574145', 1905],
        ['de-by-09573000-09573134', 1906], ['de-by-09183000-09183120', 1907],
        ['de-by-09573000-09573127', 1908], ['de-by-09374000-09374165', 1909],
        ['de-by-09371000-09371157', 1910], ['de-by-09272000-09272451', 1911],
        ['de-by-09271000-09271118', 1912], ['de-by-09271000-09271152', 1913],
        ['de-by-09277000-09277116', 1914], ['de-by-09479000-09479111', 1915],
        ['de-by-09278000-09278167', 1916], ['de-by-09372000-09372170', 1917],
        ['de-by-09372000-09372167', 1918], ['de-by-09372000-09372117', 1919],
        ['de-by-09372000-09372155', 1920], ['de-by-09762000-09762000', 1921],
        ['de-by-09778000-09778168', 1922], ['de-by-09778000-09778218', 1923],
        ['de-by-09376000-09376169', 1924], ['de-by-09189000-09189124', 1925],
        ['de-by-09275000-09275122', 1926], ['de-by-09275000-09275154', 1927],
        ['de-by-09375000-09375196', 1928], ['de-by-09273000-09273127', 1929],
        ['de-by-09277000-09277119', 1930], ['de-by-09278000-09278149', 1931],
        ['de-by-09277000-09277127', 1932], ['de-by-09182000-09182116', 1933],
        ['de-by-09182000-09182119', 1934], ['de-by-09677000-09677181', 1935],
        ['de-by-09188000-09188124', 1936], ['de-by-09188000-09188132', 1937],
        ['de-by-09175000-09175113', 1938], ['de-by-09184000-09184121', 1939],
        ['de-by-09471000-09471128', 1940], ['de-by-09471000-09471461', 1941],
        ['de-by-09179000-09179134', 1942], ['de-by-09778000-09778116', 1943],
        ['de-by-09778000-09778127', 1944], ['de-by-09188000-09188126', 1945],
        ['de-by-09179000-09179149', 1946], ['de-by-09780000-09780134', 1947],
        ['de-by-09184000-09184113', 1948], ['de-by-09671000-09671122', 1949],
        ['de-by-09181000-09181142', 1950], ['de-by-09184000-09184140', 1951],
        ['de-by-09772000-09772170', 1952], ['de-by-09777000-09777145', 1953],
        ['de-by-09188000-09188120', 1954], ['de-by-09777000-09777163', 1955],
        ['de-by-09777000-09777170', 1956], ['de-by-09184000-09184137', 1957],
        ['de-by-09190000-09190133', 1958], ['de-by-09190000-09190151', 1959],
        ['de-by-09190000-09190149', 1960], ['de-by-09190000-09190111', 1961],
        ['de-by-09772000-09772197', 1962], ['de-by-09181000-09181143', 1963],
        ['de-by-09181000-09181141', 1964], ['de-by-09179000-09179140', 1965],
        ['de-by-09179000-09179138', 1966], ['de-by-09777000-09777177', 1967],
        ['de-by-09182000-09182114', 1968], ['de-by-09778000-09778203', 1969],
        ['de-by-09778000-09778111', 1970], ['de-by-09190000-09190131', 1971],
        ['de-by-09190000-09190135', 1972], ['de-by-09177000-09177135', 1973],
        ['de-by-09772000-09772202', 1974], ['de-by-09772000-09772130', 1975],
        ['de-by-09190000-09190130', 1976], ['de-by-09477000-09477158', 1977],
        ['de-by-09190000-09190117', 1978], ['de-by-09374000-09374156', 1979],
        ['de-by-09474000-09474135', 1980], ['de-by-09181000-09181121', 1981],
        ['de-by-09780000-09780120', 1982], ['de-by-09771000-09771168', 1983],
        ['de-by-09571000-09571194', 1984], ['de-by-09179000-09179111', 1985],
        ['de-by-09371000-09371140', 1986], ['de-by-09181000-09181146', 1987],
        ['de-by-09181000-09181132', 1988], ['de-by-09574000-09574138', 1989],
        ['de-by-09779000-09779224', 1990], ['de-by-09774000-09774196', 1991],
        ['de-by-09774000-09774127', 1992], ['de-by-09377000-09377115', 1993],
        ['de-by-09377000-09377143', 1994], ['de-by-09184000-09184123', 1995],
        ['de-by-09574000-09574461', 1996], ['de-by-09574000-09574452', 1997],
        ['de-by-09182000-09182111', 1998], ['de-by-09173000-09173135', 1999],
        ['de-by-09472000-09472141', 2000], ['de-by-09181000-09181126', 2001],
        ['de-by-09472000-09472459', 2002], ['de-by-09777000-09777149', 2003],
        ['de-by-09477000-09477139', 2004], ['de-by-09777000-09777179', 2005],
        ['de-by-09471000-09471131', 2006], ['de-by-09471000-09471172', 2007],
        ['de-by-09180000-09180134', 2008], ['de-by-09572000-09572143', 2009],
        ['de-by-09181000-09181145', 2010], ['de-by-09181000-09181128', 2011],
        ['de-by-09181000-09181122', 2012], ['de-by-09777000-09777135', 2013],
        ['de-by-09180000-09180133', 2014], ['de-by-09190000-09190121', 2015],
        ['de-by-09673000-09673174', 2016], ['de-by-09772000-09772160', 2017],
        ['de-by-09772000-09772215', 2018], ['de-by-09181000-09181134', 2019],
        ['de-by-09772000-09772186', 2020], ['de-by-09181000-09181127', 2021],
        ['de-by-09173000-09173111', 2022], ['de-by-09190000-09190153', 2023],
        ['de-by-09471000-09471123', 2024], ['de-by-09471000-09471145', 2025],
        ['de-by-09572000-09572135', 2026], ['de-by-09187000-09187172', 2027],
        ['de-by-09187000-09187114', 2028], ['de-by-09780000-09780123', 2029],
        ['de-by-09576000-09576453', 2030], ['de-by-09475000-09475141', 2031],
        ['de-by-09475000-09475145', 2032], ['de-by-09774000-09774121', 2033],
        ['de-by-09774000-09774174', 2034], ['de-by-09775000-09775135', 2035],
        ['de-by-09774000-09774148', 2036], ['de-by-09476000-09476189', 2037],
        ['de-by-09779000-09779452', 2038], ['de-by-09779000-09779197', 2039],
        ['de-by-09772000-09772171', 2040], ['de-by-09573000-09573130', 2041],
        ['de-by-09677000-09677129', 2042], ['de-by-09671000-09671162', 2043],
        ['de-by-09189000-09189155', 2044], ['de-by-09189000-09189130', 2045],
        ['de-by-09189000-09189148', 2046], ['de-by-09774000-09774119', 2047],
        ['de-by-09571000-09571139', 2048], ['de-by-09571000-09571132', 2049],
        ['de-by-09779000-09779194', 2050], ['de-by-09278000-09278140', 2051],
        ['de-by-09472000-09472118', 2052], ['de-by-09571000-09571170', 2053],
        ['de-by-09673000-09673149', 2054], ['de-by-09678000-09678130', 2055],
        ['de-by-09675000-09675174', 2056], ['de-by-09184000-09184112', 2057],
        ['de-by-09778000-09778196', 2058], ['de-by-09775000-09775134', 2059],
        ['de-by-09773000-09773112', 2060], ['de-by-09273000-09273165', 2061],
        ['de-by-09273000-09273125', 2062], ['de-by-09174000-09174150', 2063],
        ['de-by-09772000-09772131', 2064], ['de-by-09772000-09772211', 2065],
        ['de-by-09375000-09375184', 2066], ['de-by-09577000-09577172', 2067],
        ['de-by-09772000-09772156', 2068], ['de-by-09473000-09473153', 2069],
        ['de-by-09473000-09473112', 2070], ['de-by-09475000-09475182', 2071],
        ['de-by-09474000-09474123', 2072], ['de-by-09471000-09471111', 2073],
        ['de-by-09572000-09572456', 2074], ['de-by-09472000-09472156', 2075],
        ['de-by-09475000-09475452', 2076], ['de-by-09476000-09476451', 2077],
        ['de-by-09475000-09475181', 2078], ['de-by-09475000-09475158', 2079],
        ['de-by-09472000-09472190', 2080], ['de-by-09478000-09478120', 2081],
        ['de-by-09573000-09573123', 2082], ['de-by-09471000-09471165', 2083],
        ['de-by-09478000-09478155', 2084], ['de-by-09476000-09476159', 2085],
        ['de-by-09572000-09572126', 2086], ['de-by-09471000-09471462', 2087],
        ['de-by-09180000-09180135', 2088], ['de-by-09373000-09373155', 2089],
        ['de-by-09180000-09180131', 2090], ['de-by-09371000-09371452', 2091],
        ['de-by-09371000-09371111', 2092], ['de-by-09371000-09371144', 2093],
        ['de-by-09472000-09472176', 2094], ['de-by-09474000-09474156', 2095],
        ['de-by-09188000-09188127', 2096], ['de-by-09188000-09188121', 2097],
        ['de-by-09179000-09179123', 2098], ['de-by-09479000-09479456', 2099],
        ['de-by-09479000-09479463', 2100], ['de-by-09574000-09574154', 2101],
        ['de-by-09471000-09471220', 2102], ['de-by-09472000-09472143', 2103],
        ['de-by-09472000-09472119', 2104], ['de-by-09471000-09471453', 2105],
        ['de-by-09574000-09574120', 2106], ['de-by-09574000-09574139', 2107],
        ['de-by-09472000-09472164', 2108], ['de-by-09574000-09574464', 2109],
        ['de-by-09574000-09574455', 2110], ['de-by-09474000-09474126', 2111],
        ['de-by-09572000-09572137', 2112], ['de-by-09574000-09574460', 2113],
        ['de-by-09575000-09575113', 2114], ['de-by-09371000-09371126', 2115],
        ['de-by-09361000-09361000', 2116], ['de-by-09173000-09173137', 2117],
        ['de-by-09190000-09190152', 2118], ['de-by-09190000-09190139', 2119],
        ['de-by-09472000-09472177', 2120], ['de-by-09777000-09777152', 2121],
        ['de-by-09181000-09181131', 2122], ['de-by-09181000-09181116', 2123],
        ['de-by-09177000-09177134', 2124], ['de-by-09477000-09477128', 2125],
        ['de-by-09477000-09477124', 2126], ['de-by-09175000-09175127', 2127],
        ['de-by-09175000-09175135', 2128], ['de-by-09472000-09472180', 2129],
        ['de-by-09472000-09472184', 2130], ['de-by-09175000-09175133', 2131],
        ['de-by-09374000-09374451', 2132], ['de-by-09190000-09190126', 2133],
        ['de-by-09573000-09573120', 2134], ['de-by-09182000-09182132', 2135],
        ['de-by-09182000-09182124', 2136], ['de-by-09472000-09472140', 2137],
        ['de-by-09175000-09175116', 2138], ['de-by-09479000-09479462', 2139],
        ['de-by-09180000-09180119', 2140], ['de-by-09479000-09479460', 2141],
        ['de-by-09479000-09479138', 2142], ['de-by-09472000-09472197', 2143],
        ['de-by-09674000-09674118', 2144], ['de-by-09572000-09572159', 2145],
        ['de-by-09571000-09571122', 2146], ['de-by-09571000-09571217', 2147],
        ['de-by-09574000-09574112', 2148], ['de-by-09472000-09472457', 2149],
        ['de-by-09376000-09376455', 2150], ['de-by-09576000-09576452', 2151],
        ['de-by-09181000-09181120', 2152], ['de-by-09181000-09181138', 2153],
        ['de-by-09179000-09179145', 2154], ['de-by-09187000-09187130', 2155],
        ['de-by-09187000-09187122', 2156], ['de-by-09182000-09182133', 2157],
        ['de-by-09474000-09474133', 2158], ['de-by-09377000-09377128', 2159],
        ['de-by-09371000-09371146', 2160], ['de-by-09572000-09572454', 2161],
        ['de-by-09572000-09572111', 2162], ['de-by-09478000-09478165', 2163],
        ['de-by-09471000-09471209', 2164], ['de-by-09574000-09574456', 2165],
        ['de-by-09574000-09574465', 2166], ['de-by-09472000-09472167', 2167],
        ['de-by-09186000-09186146', 2168], ['de-by-09474000-09474137', 2169],
        ['de-by-09174000-09174136', 2170], ['de-by-09574000-09574453', 2171],
        ['de-by-09273000-09273119', 2172], ['de-by-09772000-09772184', 2173],
        ['de-by-09472000-09472179', 2174], ['de-by-09572000-09572132', 2175],
        ['de-by-09479000-09479166', 2176], ['de-by-09778000-09778204', 2177],
        ['de-by-09576000-09576132', 2178], ['de-by-09772000-09772179', 2179],
        ['de-by-09576000-09576455', 2180], ['de-by-09772000-09772214', 2181],
        ['de-by-09479000-09479145', 2182], ['de-by-09182000-09182137', 2183],
        ['de-by-09182000-09182136', 2184], ['de-by-09572000-09572458', 2185],
        ['de-by-09184000-09184122', 2186], ['de-by-09574000-09574123', 2187],
        ['de-by-09181000-09181118', 2188], ['de-by-09184000-09184142', 2189],
        ['de-by-09184000-09184145', 2190], ['de-by-09184000-09184457', 2191],
        ['de-by-09179000-09179131', 2192], ['de-by-09190000-09190157', 2193],
        ['de-by-09188000-09188144', 2194], ['de-by-09188000-09188145', 2195],
        ['de-by-09772000-09772115', 2196], ['de-by-09773000-09773140', 2197],
        ['de-by-09577000-09577150', 2198], ['de-by-09571000-09571141', 2199],
        ['de-by-09186000-09186132', 2200], ['de-by-09174000-09174151', 2201],
        ['de-by-09179000-09179128', 2202], ['de-by-09772000-09772178', 2203],
        ['de-by-09180000-09180127', 2204], ['de-by-09173000-09173142', 2205],
        ['de-by-09772000-09772157', 2206], ['de-by-09182000-09182125', 2207],
        ['de-by-09173000-09173112', 2208], ['de-by-09173000-09173140', 2209],
        ['de-by-09173000-09173127', 2210], ['de-by-09181000-09181111', 2211],
        ['de-by-09772000-09772200', 2212], ['de-by-09190000-09190138', 2213],
        ['de-by-09777000-09777157', 2214], ['de-by-09771000-09771163', 2215],
        ['de-by-09475000-09475165', 2216], ['de-by-09175000-09175453', 2217],
        ['de-by-09175000-09175452', 2218], ['de-by-09475000-09475168', 2219],
        ['de-by-09475000-09475136', 2220], ['de-by-09475000-09475112', 2221],
        ['de-by-09476000-09476453', 2222], ['de-by-09571000-09571128', 2223],
        ['de-by-09182000-09182134', 2224], ['de-by-09173000-09173124', 2225],
        ['de-by-09190000-09190114', 2226], ['de-by-09777000-09777166', 2227],
        ['de-by-09180000-09180128', 2228], ['de-by-09177000-09177118', 2229],
        ['de-by-09184000-09184131', 2230], ['de-by-09173000-09173147', 2231],
        ['de-by-09181000-09181451', 2232], ['de-by-09181000-09181144', 2233],
        ['de-by-09676000-09676139', 2234], ['de-by-09676000-09676132', 2235],
        ['de-by-09676000-09676153', 2236], ['de-by-09678000-09678186', 2237],
        ['de-by-09676000-09676156', 2238], ['de-by-09676000-09676136', 2239],
        ['de-by-09671000-09671127', 2240], ['de-by-09676000-09676128', 2241],
        ['de-by-09777000-09777169', 2242], ['de-by-09676000-09676131', 2243],
        ['de-by-09189000-09189139', 2244], ['de-by-09187000-09187148', 2245],
        ['de-by-09279000-09279132', 2246], ['de-by-09771000-09771142', 2247],
        ['de-by-09274000-09274128', 2248], ['de-by-09372000-09372175', 2249],
        ['de-by-09183000-09183123', 2250], ['de-by-09773000-09773146', 2251],
        ['de-by-09575000-09575129', 2252], ['de-by-09780000-09780146', 2253],
        ['de-by-09372000-09372128', 2254], ['de-by-09171000-09171137', 2255],
        ['de-by-09571000-09571180', 2256], ['de-by-09677000-09677142', 2257],
        [null, 2258]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-by-all-all.topo.json">Bayern</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
