(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-he-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-he-06635000-06635014', 10], ['de-he-06435000-06435004', 11],
        ['de-he-06535000-06535007', 12], ['de-he-06531000-06531018', 13],
        ['de-he-06531000-06531002', 14], ['de-he-06635000-06635020', 15],
        ['de-he-06437000-06437002', 16], ['de-he-06437000-06437006', 17],
        ['de-he-06636000-06636004', 18], ['de-he-06633000-06633012', 19],
        ['de-he-06636000-06636200', 20], ['de-he-06633000-06633019', 21],
        ['de-he-06438000-06438011', 22], ['de-he-06432000-06432002', 23],
        ['de-he-06534000-06534014', 24], ['de-he-06534000-06534010', 25],
        ['de-he-06632000-06632018', 26], ['de-he-06632000-06632012', 27],
        ['de-he-06533000-06533014', 28], ['de-he-06434000-06434013', 29],
        ['de-he-06433000-06433013', 30], ['de-he-06632000-06632011', 31],
        ['de-he-06634000-06634019', 32], ['de-he-06631000-06631012', 33],
        ['de-he-06435000-06435028', 34], ['de-he-06435000-06435002', 35],
        ['de-he-06636000-06636006', 36], ['de-he-06634000-06634024', 37],
        ['de-he-06533000-06533011', 38], ['de-he-06634000-06634006', 39],
        ['de-he-06634000-06634022', 40], ['de-he-06632000-06632006', 41],
        ['de-he-06535000-06535011', 42], ['de-he-06535000-06535012', 43],
        ['de-he-06636000-06636016', 44], ['de-he-06532000-06532009', 45],
        ['de-he-06532000-06532005', 46], ['de-he-06534000-06534019', 47],
        ['de-he-06534000-06534005', 48], ['de-he-06437000-06437013', 49],
        ['de-he-06437000-06437012', 50], ['de-he-06633000-06633200', 51],
        ['de-he-06433000-06433001', 52], ['de-he-06439000-06439004', 53],
        ['de-he-06438000-06438008', 54], ['de-he-06435000-06435019', 55],
        ['de-he-06635000-06635010', 56], ['de-he-06635000-06635013', 57],
        ['de-he-06432000-06432008', 58], ['de-he-06433000-06433006', 59],
        ['de-he-06439000-06439017', 60], ['de-he-06635000-06635021', 61],
        ['de-he-06633000-06633018', 62], ['de-he-06432000-06432014', 63],
        ['de-he-06411000-06411000', 64], ['de-he-06435000-06435014', 65],
        ['de-he-06634000-06634023', 66], ['de-he-06634000-06634011', 67],
        ['de-he-06634000-06634027', 68], ['de-he-06432000-06432010', 69],
        ['de-he-06432000-06432004', 70], ['de-he-06436000-06436007', 71],
        ['de-he-06412000-06412000', 72], ['de-he-06631000-06631016', 73],
        ['de-he-06633000-06633027', 74], ['de-he-06633000-06633005', 75],
        ['de-he-06633000-06633004', 76], ['de-he-06534000-06534012', 77],
        ['de-he-06534000-06534007', 78], ['de-he-06532000-06532001', 79],
        ['de-he-06532000-06532013', 80], ['de-he-06531000-06531013', 81],
        ['de-he-06534000-06534013', 82], ['de-he-06435000-06435016', 83],
        ['de-he-06436000-06436011', 84], ['de-he-06436000-06436012', 85],
        ['de-he-06534000-06534015', 86], ['de-he-06534000-06534004', 87],
        ['de-he-06636000-06636011', 88], ['de-he-06534000-06534003', 89],
        ['de-he-06634000-06634008', 90], ['de-he-06633000-06633003', 91],
        ['de-he-06631000-06631021', 92], ['de-he-06631000-06631017', 93],
        ['de-he-06434000-06434010', 94], ['de-he-06434000-06434006', 95],
        ['de-he-06636000-06636002', 96], ['de-he-06440000-06440013', 97],
        ['de-he-06440000-06440019', 98], ['de-he-06532000-06532004', 99],
        ['de-he-06532000-06532006', 100], ['de-he-06439000-06439010', 101],
        ['de-he-06433000-06433011', 102], ['de-he-06438000-06438001', 103],
        ['de-he-06432000-06432023', 104], ['de-he-06433000-06433008', 105],
        ['de-he-06433000-06433009', 106], ['de-he-06438000-06438009', 107],
        ['de-he-06435000-06435022', 108], ['de-he-06435000-06435023', 109],
        ['de-he-06435000-06435007', 110], ['de-he-06532000-06532010', 111],
        ['de-he-06532000-06532020', 112], ['de-he-06534000-06534009', 113],
        ['de-he-06534000-06534008', 114], ['de-he-06534000-06534020', 115],
        ['de-he-06631000-06631022', 116], ['de-he-06631000-06631015', 117],
        ['de-he-06532000-06532023', 118], ['de-he-06531000-06531007', 119],
        ['de-he-06532000-06532002', 120], ['de-he-06532000-06532015', 121],
        ['de-he-06635000-06635007', 122], ['de-he-06635000-06635002', 123],
        ['de-he-06533000-06533019', 124], ['de-he-06533000-06533013', 125],
        ['de-he-06440000-06440001', 126], ['de-he-06440000-06440017', 127],
        ['de-he-06440000-06440023', 128], ['de-he-06440000-06440025', 129],
        ['de-he-06440000-06440008', 130], ['de-he-06434000-06434012', 131],
        ['de-he-06436000-06436001', 132], ['de-he-06633000-06633028', 133],
        ['de-he-06435000-06435024', 134], ['de-he-06435000-06435020', 135],
        ['de-he-06632000-06632009', 136], ['de-he-06632000-06632020', 137],
        ['de-he-06631000-06631008', 138], ['de-he-06440000-06440020', 139],
        ['de-he-06440000-06440007', 140], ['de-he-06440000-06440010', 141],
        ['de-he-06436000-06436005', 142], ['de-he-06633000-06633020', 143],
        ['de-he-06437000-06437008', 144], ['de-he-06434000-06434008', 145],
        ['de-he-06438000-06438007', 146], ['de-he-06438000-06438013', 147],
        ['de-he-06531000-06531012', 148], ['de-he-06531000-06531014', 149],
        ['de-he-06636000-06636001', 150], ['de-he-06532000-06532011', 151],
        ['de-he-06439000-06439007', 152], ['de-he-06439000-06439006', 153],
        ['de-he-06632000-06632017', 154], ['de-he-06632000-06632013', 155],
        ['de-he-06634000-06634005', 156], ['de-he-06439000-06439016', 157],
        ['de-he-06531000-06531015', 158], ['de-he-06531000-06531016', 159],
        ['de-he-06531000-06531004', 160], ['de-he-06440000-06440002', 161],
        ['de-he-06440000-06440018', 162], ['de-he-06434000-06434011', 163],
        ['de-he-06440000-06440022', 164], ['de-he-06438000-06438006', 165],
        ['de-he-06531000-06531017', 166], ['de-he-06534000-06534011', 167],
        ['de-he-06436000-06436009', 168], ['de-he-06432000-06432011', 169],
        ['de-he-06631000-06631003', 170], ['de-he-06631000-06631005', 171],
        ['de-he-06437000-06437007', 172], ['de-he-06432000-06432007', 173],
        ['de-he-06438000-06438012', 174], ['de-he-06435000-06435015', 175],
        ['de-he-06435000-06435017', 176], ['de-he-06535000-06535001', 177],
        ['de-he-06535000-06535010', 178], ['de-he-06433000-06433005', 179],
        ['de-he-06433000-06433002', 180], ['de-he-06433000-06433012', 181],
        ['de-he-06433000-06433014', 182], ['de-he-06433000-06433010', 183],
        ['de-he-06433000-06433007', 184], ['de-he-06533000-06533003', 185],
        ['de-he-06434000-06434009', 186], ['de-he-06531000-06531011', 187],
        ['de-he-06435000-06435021', 188], ['de-he-06440000-06440014', 189],
        ['de-he-06435000-06435026', 190], ['de-he-06432000-06432022', 191],
        ['de-he-06432000-06432001', 192], ['de-he-06432000-06432003', 193],
        ['de-he-06432000-06432018', 194], ['de-he-06435000-06435006', 195],
        ['de-he-06438000-06438002', 196], ['de-he-06439000-06439008', 197],
        ['de-he-06439000-06439015', 198], ['de-he-06439000-06439011', 199],
        ['de-he-06436000-06436006', 200], ['de-he-06535000-06535015', 201],
        ['de-he-06632000-06632015', 202], ['de-he-06632000-06632004', 203],
        ['de-he-06633000-06633009', 204], ['de-he-06436000-06436008', 205],
        ['de-he-06432000-06432013', 206], ['de-he-06535000-06535013', 207],
        ['de-he-06531000-06531010', 208], ['de-he-06435000-06435003', 209],
        ['de-he-06435000-06435029', 210], ['de-he-06533000-06533004', 211],
        ['de-he-06533000-06533007', 212], ['de-he-06533000-06533005', 213],
        ['de-he-06434000-06434001', 214], ['de-he-06531000-06531009', 215],
        ['de-he-06432000-06432020', 216], ['de-he-06432000-06432016', 217],
        ['de-he-06534000-06534002', 218], ['de-he-06432000-06432009', 219],
        ['de-he-06437000-06437003', 220], ['de-he-06437000-06437001', 221],
        ['de-he-06432000-06432019', 222], ['de-he-06532000-06532019', 223],
        ['de-he-06440000-06440024', 224], ['de-he-06440000-06440016', 225],
        ['de-he-06440000-06440021', 226], ['de-he-06436000-06436004', 227],
        ['de-he-06435000-06435200', 228], ['de-he-06438000-06438003', 229],
        ['de-he-06633000-06633011', 230], ['de-he-06633000-06633029', 231],
        ['de-he-06439000-06439003', 232], ['de-he-06439000-06439014', 233],
        ['de-he-06433000-06433003', 234], ['de-he-06438000-06438005', 235],
        ['de-he-06534000-06534006', 236], ['de-he-06433000-06433004', 237],
        ['de-he-06439000-06439001', 238], ['de-he-06439000-06439005', 239],
        ['de-he-06435000-06435010', 240], ['de-he-06437000-06437005', 241],
        ['de-he-06435000-06435018', 242], ['de-he-06440000-06440015', 243],
        ['de-he-06440000-06440005', 244], ['de-he-06434000-06434004', 245],
        ['de-he-06532000-06532017', 246], ['de-he-06532000-06532012', 247],
        ['de-he-06434000-06434005', 248], ['de-he-06435000-06435013', 249],
        ['de-he-06634000-06634012', 250], ['de-he-06634000-06634003', 251],
        ['de-he-06634000-06634009', 252], ['de-he-06634000-06634002', 253],
        ['de-he-06531000-06531005', 254], ['de-he-06436000-06436003', 255],
        ['de-he-06534000-06534018', 256], ['de-he-06632000-06632016', 257],
        ['de-he-06634000-06634010', 258], ['de-he-06436000-06436010', 259],
        ['de-he-06533000-06533012', 260], ['de-he-06533000-06533010', 261],
        ['de-he-06435000-06435008', 262], ['de-he-06634000-06634014', 263],
        ['de-he-06440000-06440012', 264], ['de-he-06436000-06436002', 265],
        ['de-he-06634000-06634018', 266], ['de-he-06440000-06440003', 267],
        ['de-he-06533000-06533015', 268], ['de-he-06533000-06533009', 269],
        ['de-he-06535000-06535008', 270], ['de-he-06631000-06631014', 271],
        ['de-he-06440000-06440009', 272], ['de-he-06535000-06535018', 273],
        ['de-he-06632000-06632007', 274], ['de-he-06632000-06632002', 275],
        ['de-he-06435000-06435027', 276], ['de-he-06631000-06631004', 277],
        ['de-he-06435000-06435001', 278], ['de-he-06533000-06533018', 279],
        ['de-he-06435000-06435009', 280], ['de-he-06532000-06532014', 281],
        ['de-he-06535000-06535002', 282], ['de-he-06534000-06534016', 283],
        ['de-he-06635000-06635006', 284], ['de-he-06635000-06635012', 285],
        ['de-he-06437000-06437011', 286], ['de-he-06531000-06531003', 287],
        ['de-he-06434000-06434003', 288], ['de-he-06633000-06633001', 289],
        ['de-he-06635000-06635011', 290], ['de-he-06533000-06533017', 291],
        ['de-he-06532000-06532003', 292], ['de-he-06532000-06532022', 293],
        ['de-he-06533000-06533001', 294], ['de-he-06636000-06636014', 295],
        ['de-he-06636000-06636008', 296], ['de-he-06636000-06636015', 297],
        ['de-he-06631000-06631011', 298], ['de-he-06636000-06636003', 299],
        ['de-he-06636000-06636007', 300], ['de-he-06634000-06634013', 301],
        ['de-he-06634000-06634015', 302], ['de-he-06438000-06438010', 303],
        ['de-he-06535000-06535017', 304], ['de-he-06535000-06535003', 305],
        ['de-he-06531000-06531006', 306], ['de-he-06535000-06535009', 307],
        ['de-he-06534000-06534001', 308], ['de-he-06631000-06631001', 309],
        ['de-he-06535000-06535004', 310], ['de-he-06631000-06631018', 311],
        ['de-he-06535000-06535019', 312], ['de-he-06632000-06632005', 313],
        ['de-he-06636000-06636012', 314], ['de-he-06635000-06635017', 315],
        ['de-he-06632000-06632014', 316], ['de-he-06634000-06634004', 317],
        ['de-he-06531000-06531001', 318], ['de-he-06533000-06533008', 319],
        ['de-he-06634000-06634016', 320], ['de-he-06535000-06535014', 321],
        ['de-he-06635000-06635004', 322], ['de-he-06633000-06633006', 323],
        ['de-he-06633000-06633023', 324], ['de-he-06634000-06634007', 325],
        ['de-he-06535000-06535005', 326], ['de-he-06633000-06633024', 327],
        ['de-he-06633000-06633013', 328], ['de-he-06532000-06532021', 329],
        ['de-he-06636000-06636009', 330], ['de-he-06440000-06440006', 331],
        ['de-he-06440000-06440004', 332], ['de-he-06435000-06435012', 333],
        ['de-he-06438000-06438004', 334], ['de-he-06611000-06611000', 335],
        ['de-he-06633000-06633017', 336], ['de-he-06633000-06633026', 337],
        ['de-he-06633000-06633008', 338], ['de-he-06635000-06635015', 339],
        ['de-he-06631000-06631013', 340], ['de-he-06631000-06631020', 341],
        ['de-he-06413000-06413000', 342], ['de-he-06439000-06439002', 343],
        ['de-he-06435000-06435025', 344], ['de-he-06437000-06437010', 345],
        ['de-he-06437000-06437009', 346], ['de-he-06631000-06631006', 347],
        ['de-he-06631000-06631009', 348], ['de-he-06631000-06631023', 349],
        ['de-he-06635000-06635009', 350], ['de-he-06635000-06635003', 351],
        ['de-he-06631000-06631002', 352], ['de-he-06631000-06631007', 353],
        ['de-he-06632000-06632008', 354], ['de-he-06532000-06532008', 355],
        ['de-he-06532000-06532016', 356], ['de-he-06633000-06633015', 357],
        ['de-he-06533000-06533006', 358], ['de-he-06432000-06432012', 359],
        ['de-he-06432000-06432015', 360], ['de-he-06414000-06414000', 361],
        ['de-he-06533000-06533016', 362], ['de-he-06432000-06432006', 363],
        ['de-he-06632000-06632010', 364], ['de-he-06633000-06633021', 365],
        ['de-he-06633000-06633016', 366], ['de-he-06633000-06633010', 367],
        ['de-he-06534000-06534022', 368], ['de-he-06534000-06534021', 369],
        ['de-he-06633000-06633025', 370], ['de-he-06633000-06633002', 371],
        ['de-he-06633000-06633007', 372], ['de-he-06633000-06633014', 373],
        ['de-he-06634000-06634026', 374], ['de-he-06634000-06634017', 375],
        ['de-he-06432000-06432005', 376], ['de-he-06634000-06634020', 377],
        ['de-he-06634000-06634021', 378], ['de-he-06532000-06532018', 379],
        ['de-he-06439000-06439012', 380], ['de-he-06635000-06635019', 381],
        ['de-he-06532000-06532007', 382], ['de-he-06631000-06631010', 383],
        ['de-he-06635000-06635008', 384], ['de-he-06535000-06535006', 385],
        ['de-he-06439000-06439013', 386], ['de-he-06636000-06636005', 387],
        ['de-he-06437000-06437004', 388], ['de-he-06635000-06635005', 389],
        ['de-he-06632000-06632003', 390], ['de-he-06437000-06437014', 391],
        ['de-he-06440000-06440011', 392], ['de-he-06535000-06535016', 393],
        ['de-he-06632000-06632001', 394], ['de-he-06635000-06635022', 395],
        ['de-he-06435000-06435005', 396], ['de-he-06635000-06635016', 397],
        ['de-he-06531000-06531008', 398], ['de-he-06635000-06635001', 399],
        ['de-he-06636000-06636013', 400], ['de-he-06633000-06633022', 401],
        ['de-he-06435000-06435011', 402], ['de-he-06434000-06434002', 403],
        ['de-he-06434000-06434007', 404], ['de-he-06636000-06636010', 405],
        ['de-he-06437000-06437015', 406], ['de-he-06634000-06634001', 407],
        ['de-he-06534000-06534017', 408], ['de-he-06634000-06634025', 409],
        ['de-he-06439000-06439009', 410], ['de-he-06632000-06632019', 411],
        ['de-he-06533000-06533002', 412], ['de-he-06631000-06631019', 413],
        ['de-he-06432000-06432021', 414], ['de-he-06432000-06432017', 415],
        ['de-he-06635000-06635018', 416], [null, 417]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-he-all-all.topo.json">Hessen</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
