(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-mv-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-mv-13073000-13073059', 10], ['de-mv-13073000-13073070', 11],
        ['de-mv-13073000-13073037', 12], ['de-mv-13073000-13073088', 13],
        ['de-mv-13073000-13073031', 14], ['de-mv-13075000-13075103', 15],
        ['de-mv-13071000-13071073', 16], ['de-mv-13071000-13071042', 17],
        ['de-mv-13076000-13076071', 18], ['de-mv-13004000-13004000', 19],
        ['de-mv-13075000-13075105', 20], ['de-mv-13075000-13075104', 21],
        ['de-mv-13072000-13072036', 22], ['de-mv-13073000-13073011', 23],
        ['de-mv-13076000-13076155', 24], ['de-mv-13076000-13076128', 25],
        ['de-mv-13076000-13076014', 26], ['de-mv-13076000-13076054', 27],
        ['de-mv-13075000-13075074', 28], ['de-mv-13071000-13071007', 29],
        ['de-mv-13072000-13072059', 30], ['de-mv-13075000-13075147', 31],
        ['de-mv-13075000-13075116', 32], ['de-mv-13075000-13075029', 33],
        ['de-mv-13075000-13075132', 34], ['de-mv-13071000-13071008', 35],
        ['de-mv-13071000-13071128', 36], ['de-mv-13075000-13075135', 37],
        ['de-mv-13076000-13076106', 38], ['de-mv-13076000-13076040', 39],
        ['de-mv-13076000-13076104', 40], ['de-mv-13071000-13071037', 41],
        ['de-mv-13075000-13075015', 42], ['de-mv-13071000-13071137', 43],
        ['de-mv-13071000-13071053', 44], ['de-mv-13072000-13072046', 45],
        ['de-mv-13072000-13072062', 46], ['de-mv-13072000-13072060', 47],
        ['de-mv-13073000-13073092', 48], ['de-mv-13075000-13075026', 49],
        ['de-mv-13075000-13075010', 50], ['de-mv-13075000-13075039', 51],
        ['de-mv-13074000-13074087', 52], ['de-mv-13074000-13074019', 53],
        ['de-mv-13076000-13076074', 54], ['de-mv-13076000-13076083', 55],
        ['de-mv-13074000-13074021', 56], ['de-mv-13074000-13074068', 57],
        ['de-mv-13075000-13075092', 58], ['de-mv-13073000-13073090', 59],
        ['de-mv-13075000-13075091', 60], ['de-mv-13074000-13074050', 61],
        ['de-mv-13074000-13074012', 62], ['de-mv-13074000-13074062', 63],
        ['de-mv-13073000-13073094', 64], ['de-mv-13073000-13073053', 65],
        ['de-mv-13075000-13075120', 66], ['de-mv-13075000-13075069', 67],
        ['de-mv-13075000-13075033', 68], ['de-mv-13072000-13072024', 69],
        ['de-mv-13072000-13072063', 70], ['de-mv-13073000-13073034', 71],
        ['de-mv-13073000-13073057', 72], ['de-mv-13071000-13071011', 73],
        ['de-mv-13071000-13071012', 74], ['de-mv-13075000-13075023', 75],
        ['de-mv-13075000-13075140', 76], ['de-mv-13071000-13071100', 77],
        ['de-mv-13071000-13071024', 78], ['de-mv-13073000-13073021', 79],
        ['de-mv-13073000-13073095', 80], ['de-mv-13075000-13075090', 81],
        ['de-mv-13075000-13075114', 82], ['de-mv-13073000-13073069', 83],
        ['de-mv-13073000-13073025', 84], ['de-mv-13073000-13073100', 85],
        ['de-mv-13073000-13073105', 86], ['de-mv-13075000-13075144', 87],
        ['de-mv-13075000-13075051', 88], ['de-mv-13075000-13075085', 89],
        ['de-mv-13072000-13072008', 90], ['de-mv-13071000-13071038', 91],
        ['de-mv-13071000-13071028', 92], ['de-mv-13071000-13071040', 93],
        ['de-mv-13071000-13071141', 94], ['de-mv-13071000-13071172', 95],
        ['de-mv-13071000-13071149', 96], ['de-mv-13075000-13075049', 97],
        ['de-mv-13073000-13073026', 98], ['de-mv-13073000-13073091', 99],
        ['de-mv-13075000-13075058', 100], ['de-mv-13075000-13075106', 101],
        ['de-mv-13071000-13071020', 102], ['de-mv-13075000-13075108', 103],
        ['de-mv-13075000-13075079', 104], ['de-mv-13075000-13075005', 105],
        ['de-mv-13075000-13075134', 106], ['de-mv-13075000-13075009', 107],
        ['de-mv-13073000-13073076', 108], ['de-mv-13075000-13075145', 109],
        ['de-mv-13075000-13075028', 110], ['de-mv-13073000-13073022', 111],
        ['de-mv-13071000-13071029', 112], ['de-mv-13071000-13071131', 113],
        ['de-mv-13072000-13072030', 114], ['de-mv-13072000-13072021', 115],
        ['de-mv-13072000-13072097', 116], ['de-mv-13072000-13072111', 117],
        ['de-mv-13071000-13071034', 118], ['de-mv-13072000-13072096', 119],
        ['de-mv-13072000-13072106', 120], ['de-mv-13071000-13071117', 121],
        ['de-mv-13071000-13071021', 122], ['de-mv-13072000-13072040', 123],
        ['de-mv-13072000-13072038', 124], ['de-mv-13073000-13073045', 125],
        ['de-mv-13073000-13073064', 126], ['de-mv-13071000-13071058', 127],
        ['de-mv-13075000-13075152', 128], ['de-mv-13071000-13071136', 129],
        ['de-mv-13075000-13075070', 130], ['de-mv-13071000-13071157', 131],
        ['de-mv-13075000-13075138', 132], ['de-mv-13075000-13075055', 133],
        ['de-mv-13074000-13074018', 134], ['de-mv-13073000-13073077', 135],
        ['de-mv-13073000-13073008', 136], ['de-mv-13072000-13072113', 137],
        ['de-mv-13073000-13073001', 138], ['de-mv-13071000-13071130', 139],
        ['de-mv-13075000-13075093', 140], ['de-mv-13071000-13071031', 141],
        ['de-mv-13071000-13071079', 142], ['de-mv-13071000-13071160', 143],
        ['de-mv-13072000-13072109', 144], ['de-mv-13072000-13072103', 145],
        ['de-mv-13072000-13072041', 146], ['de-mv-13071000-13071015', 147],
        ['de-mv-13072000-13072082', 148], ['de-mv-13072000-13072025', 149],
        ['de-mv-13075000-13075046', 150], ['de-mv-13071000-13071088', 151],
        ['de-mv-13071000-13071124', 152], ['de-mv-13075000-13075065', 153],
        ['de-mv-13072000-13072054', 154], ['de-mv-13072000-13072088', 155],
        ['de-mv-13076000-13076114', 156], ['de-mv-13071000-13071143', 157],
        ['de-mv-13072000-13072072', 158], ['de-mv-13075000-13075115', 159],
        ['de-mv-13071000-13071076', 160], ['de-mv-13071000-13071057', 161],
        ['de-mv-13075000-13075060', 162], ['de-mv-13076000-13076049', 163],
        ['de-mv-13072000-13072015', 164], ['de-mv-13072000-13072032', 165],
        ['de-mv-13072000-13072094', 166], ['de-mv-13071000-13071103', 167],
        ['de-mv-13072000-13072023', 168], ['de-mv-13071000-13071078', 169],
        ['de-mv-13075000-13075113', 170], ['de-mv-13075000-13075035', 171],
        ['de-mv-13075000-13075038', 172], ['de-mv-13071000-13071018', 173],
        ['de-mv-13071000-13071139', 174], ['de-mv-13071000-13071048', 175],
        ['de-mv-13071000-13071050', 176], ['de-mv-13071000-13071158', 177],
        ['de-mv-13071000-13071022', 178], ['de-mv-13073000-13073074', 179],
        ['de-mv-13071000-13071084', 180], ['de-mv-13072000-13072064', 181],
        ['de-mv-13072000-13072098', 182], ['de-mv-13075000-13075072', 183],
        ['de-mv-13075000-13075087', 184], ['de-mv-13074000-13074044', 185],
        ['de-mv-13075000-13075076', 186], ['de-mv-13075000-13075027', 187],
        ['de-mv-13073000-13073084', 188], ['de-mv-13073000-13073048', 189],
        ['de-mv-13075000-13075041', 190], ['de-mv-13075000-13075040', 191],
        ['de-mv-13072000-13072019', 192], ['de-mv-13072000-13072091', 193],
        ['de-mv-13071000-13071108', 194], ['de-mv-13073000-13073072', 195],
        ['de-mv-13075000-13075150', 196], ['de-mv-13075000-13075110', 197],
        ['de-mv-13075000-13075043', 198], ['de-mv-13071000-13071173', 199],
        ['de-mv-13071000-13071102', 200], ['de-mv-13073000-13073082', 201],
        ['de-mv-13073000-13073096', 202], ['de-mv-13073000-13073051', 203],
        ['de-mv-13072000-13072112', 204], ['de-mv-13071000-13071010', 205],
        ['de-mv-13071000-13071170', 206], ['de-mv-13075000-13075119', 207],
        ['de-mv-13075000-13075063', 208], ['de-mv-13071000-13071033', 209],
        ['de-mv-13071000-13071025', 210], ['de-mv-13074000-13074073', 211],
        ['de-mv-13074000-13074028', 212], ['de-mv-13074000-13074078', 213],
        ['de-mv-13072000-13072085', 214], ['de-mv-13072000-13072014', 215],
        ['de-mv-13076000-13076034', 216], ['de-mv-13076000-13076143', 217],
        ['de-mv-13074000-13074013', 218], ['de-mv-13074000-13074058', 219],
        ['de-mv-13074000-13074066', 220], ['de-mv-13072000-13072073', 221],
        ['de-mv-13072000-13072048', 222], ['de-mv-13072000-13072042', 223],
        ['de-mv-13072000-13072120', 224], ['de-mv-13073000-13073033', 225],
        ['de-mv-13073000-13073086', 226], ['de-mv-13071000-13071101', 227],
        ['de-mv-13071000-13071174', 228], ['de-mv-13076000-13076109', 229],
        ['de-mv-13072000-13072028', 230], ['de-mv-13076000-13076103', 231],
        ['de-mv-13076000-13076048', 232], ['de-mv-13076000-13076075', 233],
        ['de-mv-13071000-13071056', 234], ['de-mv-13074000-13074009', 235],
        ['de-mv-13072000-13072005', 236], ['de-mv-13072000-13072069', 237],
        ['de-mv-13072000-13072092', 238], ['de-mv-13075000-13075142', 239],
        ['de-mv-13076000-13076088', 240], ['de-mv-13076000-13076016', 241],
        ['de-mv-13076000-13076147', 242], ['de-mv-13076000-13076004', 243],
        ['de-mv-13073000-13073103', 244], ['de-mv-13073000-13073009', 245],
        ['de-mv-13076000-13076089', 246], ['de-mv-13076000-13076091', 247],
        ['de-mv-13075000-13075141', 248], ['de-mv-13075000-13075102', 249],
        ['de-mv-13076000-13076002', 250], ['de-mv-13073000-13073089', 251],
        ['de-mv-13071000-13071171', 252], ['de-mv-13075000-13075123', 253],
        ['de-mv-13071000-13071054', 254], ['de-mv-13071000-13071105', 255],
        ['de-mv-13075000-13075044', 256], ['de-mv-13076000-13076092', 257],
        ['de-mv-13071000-13071097', 258], ['de-mv-13071000-13071152', 259],
        ['de-mv-13071000-13071118', 260], ['de-mv-13075000-13075080', 261],
        ['de-mv-13075000-13075018', 262], ['de-mv-13075000-13075083', 263],
        ['de-mv-13075000-13075081', 264], ['de-mv-13072000-13072102', 265],
        ['de-mv-13072000-13072034', 266], ['de-mv-13076000-13076126', 267],
        ['de-mv-13076000-13076028', 268], ['de-mv-13073000-13073028', 269],
        ['de-mv-13076000-13076105', 270], ['de-mv-13076000-13076108', 271],
        ['de-mv-13075000-13075086', 272], ['de-mv-13075000-13075061', 273],
        ['de-mv-13075000-13075125', 274], ['de-mv-13073000-13073046', 275],
        ['de-mv-13075000-13075034', 276], ['de-mv-13075000-13075124', 277],
        ['de-mv-13072000-13072043', 278], ['de-mv-13076000-13076096', 279],
        ['de-mv-13076000-13076062', 280], ['de-mv-13076000-13076163', 281],
        ['de-mv-13076000-13076036', 282], ['de-mv-13076000-13076055', 283],
        ['de-mv-13076000-13076122', 284], ['de-mv-13074000-13074024', 285],
        ['de-mv-13076000-13076118', 286], ['de-mv-13074000-13074076', 287],
        ['de-mv-13074000-13074017', 288], ['de-mv-13074000-13074092', 289],
        ['de-mv-13074000-13074081', 290], ['de-mv-13076000-13076117', 291],
        ['de-mv-13076000-13076113', 292], ['de-mv-13076000-13076017', 293],
        ['de-mv-13076000-13076012', 294], ['de-mv-13072000-13072051', 295],
        ['de-mv-13076000-13076123', 296], ['de-mv-13076000-13076152', 297],
        ['de-mv-13072000-13072095', 298], ['de-mv-13071000-13071162', 299],
        ['de-mv-13073000-13073029', 300], ['de-mv-13076000-13076018', 301],
        ['de-mv-13076000-13076053', 302], ['de-mv-13076000-13076067', 303],
        ['de-mv-13074000-13074077', 304], ['de-mv-13074000-13074054', 305],
        ['de-mv-13073000-13073032', 306], ['de-mv-13074000-13074014', 307],
        ['de-mv-13071000-13071112', 308], ['de-mv-13074000-13074069', 309],
        ['de-mv-13074000-13074059', 310], ['de-mv-13073000-13073066', 311],
        ['de-mv-13072000-13072090', 312], ['de-mv-13074000-13074025', 313],
        ['de-mv-13073000-13073041', 314], ['de-mv-13076000-13076060', 315],
        ['de-mv-13076000-13076119', 316], ['de-mv-13076000-13076039', 317],
        ['de-mv-13074000-13074045', 318], ['de-mv-13072000-13072011', 319],
        ['de-mv-13073000-13073067', 320], ['de-mv-13072000-13072018', 321],
        ['de-mv-13074000-13074051', 322], ['de-mv-13076000-13076130', 323],
        ['de-mv-13072000-13072078', 324], ['de-mv-13072000-13072053', 325],
        ['de-mv-13072000-13072013', 326], ['de-mv-13076000-13076078', 327],
        ['de-mv-13076000-13076033', 328], ['de-mv-13072000-13072052', 329],
        ['de-mv-13072000-13072074', 330], ['de-mv-13074000-13074006', 331],
        ['de-mv-13076000-13076058', 332], ['de-mv-13076000-13076027', 333],
        ['de-mv-13076000-13076098', 334], ['de-mv-13076000-13076011', 335],
        ['de-mv-13076000-13076157', 336], ['de-mv-13076000-13076081', 337],
        ['de-mv-13076000-13076084', 338], ['de-mv-13076000-13076008', 339],
        ['de-mv-13076000-13076057', 340], ['de-mv-13076000-13076151', 341],
        ['de-mv-13076000-13076164', 342], ['de-mv-13076000-13076124', 343],
        ['de-mv-13074000-13074038', 344], ['de-mv-13074000-13074048', 345],
        ['de-mv-13072000-13072071', 346], ['de-mv-13076000-13076095', 347],
        ['de-mv-13076000-13076030', 348], ['de-mv-13072000-13072056', 349],
        ['de-mv-13072000-13072119', 350], ['de-mv-13076000-13076068', 351],
        ['de-mv-13074000-13074091', 352], ['de-mv-13074000-13074020', 353],
        ['de-mv-13074000-13074023', 354], ['de-mv-13075000-13075129', 355],
        ['de-mv-13071000-13071049', 356], ['de-mv-13072000-13072022', 357],
        ['de-mv-13073000-13073061', 358], ['de-mv-13073000-13073058', 359],
        ['de-mv-13073000-13073047', 360], ['de-mv-13074000-13074002', 361],
        ['de-mv-13072000-13072045', 362], ['de-mv-13074000-13074026', 363],
        ['de-mv-13074000-13074005', 364], ['de-mv-13075000-13075022', 365],
        ['de-mv-13075000-13075013', 366], ['de-mv-13076000-13076063', 367],
        ['de-mv-13072000-13072058', 368], ['de-mv-13076000-13076021', 369],
        ['de-mv-13076000-13076144', 370], ['de-mv-13076000-13076066', 371],
        ['de-mv-13072000-13072039', 372], ['de-mv-13072000-13072110', 373],
        ['de-mv-13071000-13071083', 374], ['de-mv-13071000-13071066', 375],
        ['de-mv-13071000-13071107', 376], ['de-mv-13075000-13075095', 377],
        ['de-mv-13075000-13075107', 378], ['de-mv-13073000-13073038', 379],
        ['de-mv-13073000-13073073', 380], ['de-mv-13076000-13076038', 381],
        ['de-mv-13076000-13076158', 382], ['de-mv-13076000-13076162', 383],
        ['de-mv-13073000-13073065', 384], ['de-mv-13072000-13072104', 385],
        ['de-mv-13073000-13073056', 386], ['de-mv-13073000-13073078', 387],
        ['de-mv-13072000-13072006', 388], ['de-mv-13072000-13072007', 389],
        ['de-mv-13072000-13072047', 390], ['de-mv-13076000-13076141', 391],
        ['de-mv-13076000-13076086', 392], ['de-mv-13071000-13071064', 393],
        ['de-mv-13071000-13071072', 394], ['de-mv-13071000-13071142', 395],
        ['de-mv-13074000-13074034', 396], ['de-mv-13074000-13074047', 397],
        ['de-mv-13076000-13076080', 398], ['de-mv-13076000-13076024', 399],
        ['de-mv-13073000-13073017', 400], ['de-mv-13072000-13072057', 401],
        ['de-mv-13075000-13075139', 402], ['de-mv-13076000-13076101', 403],
        ['de-mv-13072000-13072055', 404], ['de-mv-13075000-13075071', 405],
        ['de-mv-13075000-13075109', 406], ['de-mv-13072000-13072077', 407],
        ['de-mv-13076000-13076093', 408], ['de-mv-13074000-13074003', 409],
        ['de-mv-13074000-13074008', 410], ['de-mv-13075000-13075011', 411],
        ['de-mv-13075000-13075032', 412], ['de-mv-13076000-13076094', 413],
        ['de-mv-13075000-13075008', 414], ['de-mv-13074000-13074075', 415],
        ['de-mv-13071000-13071146', 416], ['de-mv-13071000-13071120', 417],
        ['de-mv-13071000-13071163', 418], ['de-mv-13075000-13075064', 419],
        ['de-mv-13074000-13074071', 420], ['de-mv-13071000-13071002', 421],
        ['de-mv-13074000-13074022', 422], ['de-mv-13074000-13074063', 423],
        ['de-mv-13074000-13074039', 424], ['de-mv-13073000-13073014', 425],
        ['de-mv-13073000-13073010', 426], ['de-mv-13076000-13076149', 427],
        ['de-mv-13076000-13076042', 428], ['de-mv-13075000-13075007', 429],
        ['de-mv-13074000-13074032', 430], ['de-mv-13073000-13073080', 431],
        ['de-mv-13075000-13075059', 432], ['de-mv-13076000-13076161', 433],
        ['de-mv-13076000-13076100', 434], ['de-mv-13076000-13076129', 435],
        ['de-mv-13076000-13076148', 436], ['de-mv-13076000-13076131', 437],
        ['de-mv-13076000-13076019', 438], ['de-mv-13074000-13074084', 439],
        ['de-mv-13074000-13074046', 440], ['de-mv-13072000-13072114', 441],
        ['de-mv-13076000-13076079', 442], ['de-mv-13076000-13076025', 443],
        ['de-mv-13076000-13076007', 444], ['de-mv-13076000-13076044', 445],
        ['de-mv-13074000-13074057', 446], ['de-mv-13074000-13074065', 447],
        ['de-mv-13074000-13074055', 448], ['de-mv-13074000-13074033', 449],
        ['de-mv-13076000-13076076', 450], ['de-mv-13076000-13076115', 451],
        ['de-mv-13076000-13076097', 452], ['de-mv-13076000-13076107', 453],
        ['de-mv-13076000-13076120', 454], ['de-mv-13074000-13074030', 455],
        ['de-mv-13073000-13073016', 456], ['de-mv-13072000-13072010', 457],
        ['de-mv-13072000-13072031', 458], ['de-mv-13071000-13071153', 459],
        ['de-mv-13075000-13075148', 460], ['de-mv-13075000-13075088', 461],
        ['de-mv-13073000-13073093', 462], ['de-mv-13075000-13075096', 463],
        ['de-mv-13073000-13073050', 464], ['de-mv-13072000-13072037', 465],
        ['de-mv-13075000-13075068', 466], ['de-mv-13075000-13075057', 467],
        ['de-mv-13075000-13075077', 468], ['de-mv-13071000-13071080', 469],
        ['de-mv-13073000-13073106', 470], ['de-mv-13071000-13071115', 471],
        ['de-mv-13075000-13075089', 472], ['de-mv-13075000-13075136', 473],
        ['de-mv-13071000-13071087', 474], ['de-mv-13075000-13075050', 475],
        ['de-mv-13073000-13073020', 476], ['de-mv-13071000-13071068', 477],
        ['de-mv-13073000-13073035', 478], ['de-mv-13073000-13073062', 479],
        ['de-mv-13072000-13072089', 480], ['de-mv-13072000-13072101', 481],
        ['de-mv-13072000-13072020', 482], ['de-mv-13076000-13076085', 483],
        ['de-mv-13076000-13076135', 484], ['de-mv-13076000-13076140', 485],
        ['de-mv-13076000-13076133', 486], ['de-mv-13075000-13075020', 487],
        ['de-mv-13074000-13074060', 488], ['de-mv-13072000-13072050', 489],
        ['de-mv-13076000-13076050', 490], ['de-mv-13076000-13076069', 491],
        ['de-mv-13076000-13076139', 492], ['de-mv-13072000-13072093', 493],
        ['de-mv-13071000-13071055', 494], ['de-mv-13076000-13076137', 495],
        ['de-mv-13076000-13076160', 496], ['de-mv-13074000-13074027', 497],
        ['de-mv-13074000-13074083', 498], ['de-mv-13071000-13071127', 499],
        ['de-mv-13072000-13072027', 500], ['de-mv-13075000-13075037', 501],
        ['de-mv-13072000-13072116', 502], ['de-mv-13076000-13076134', 503],
        ['de-mv-13076000-13076005', 504], ['de-mv-13071000-13071098', 505],
        ['de-mv-13071000-13071164', 506], ['de-mv-13071000-13071061', 507],
        ['de-mv-13071000-13071116', 508], ['de-mv-13071000-13071090', 509],
        ['de-mv-13071000-13071135', 510], ['de-mv-13071000-13071035', 511],
        ['de-mv-13071000-13071123', 512], ['de-mv-13073000-13073060', 513],
        ['de-mv-13073000-13073099', 514], ['de-mv-13073000-13073023', 515],
        ['de-mv-13073000-13073013', 516], ['de-mv-13073000-13073087', 517],
        ['de-mv-13071000-13071004', 518], ['de-mv-13071000-13071059', 519],
        ['de-mv-13073000-13073006', 520], ['de-mv-13071000-13071044', 521],
        ['de-mv-13071000-13071006', 522], ['de-mv-13073000-13073063', 523],
        ['de-mv-13076000-13076022', 524], ['de-mv-13075000-13075042', 525],
        ['de-mv-13076000-13076077', 526], ['de-mv-13076000-13076006', 527],
        ['de-mv-13076000-13076146', 528], ['de-mv-13076000-13076087', 529],
        ['de-mv-13071000-13071095', 530], ['de-mv-13076000-13076090', 531],
        ['de-mv-13072000-13072068', 532], ['de-mv-13076000-13076065', 533],
        ['de-mv-13071000-13071092', 534], ['de-mv-13072000-13072105', 535],
        ['de-mv-13076000-13076013', 536], ['de-mv-13071000-13071039', 537],
        ['de-mv-13072000-13072065', 538], ['de-mv-13072000-13072118', 539],
        ['de-mv-13071000-13071003', 540], ['de-mv-13073000-13073018', 541],
        ['de-mv-13075000-13075066', 542], ['de-mv-13075000-13075133', 543],
        ['de-mv-13075000-13075146', 544], ['de-mv-13073000-13073097', 545],
        ['de-mv-13072000-13072003', 546], ['de-mv-13073000-13073044', 547],
        ['de-mv-13073000-13073068', 548], ['de-mv-13073000-13073004', 549],
        ['de-mv-13071000-13071047', 550], ['de-mv-13074000-13074056', 551],
        ['de-mv-13075000-13075117', 552], ['de-mv-13073000-13073005', 553],
        ['de-mv-13072000-13072079', 554], ['de-mv-13072000-13072061', 555],
        ['de-mv-13073000-13073083', 556], ['de-mv-13075000-13075012', 557],
        ['de-mv-13071000-13071023', 558], ['de-mv-13071000-13071013', 559],
        ['de-mv-13075000-13075137', 560], ['de-mv-13075000-13075075', 561],
        ['de-mv-13075000-13075084', 562], ['de-mv-13075000-13075004', 563],
        ['de-mv-13071000-13071132', 564], ['de-mv-13075000-13075130', 565],
        ['de-mv-13003000-13003000', 566], ['de-mv-13072000-13072012', 567],
        ['de-mv-13075000-13075101', 568], ['de-mv-13076000-13076138', 569],
        ['de-mv-13076000-13076102', 570], ['de-mv-13076000-13076010', 571],
        ['de-mv-13076000-13076064', 572], ['de-mv-13076000-13076035', 573],
        ['de-mv-13074000-13074011', 574], ['de-mv-13076000-13076023', 575],
        ['de-mv-13071000-13071111', 576], ['de-mv-13071000-13071019', 577],
        ['de-mv-13071000-13071009', 578], ['de-mv-13072000-13072067', 579],
        ['de-mv-13072000-13072044', 580], ['de-mv-13076000-13076015', 581],
        ['de-mv-13072000-13072107', 582], ['de-mv-13076000-13076072', 583],
        ['de-mv-13072000-13072033', 584], ['de-mv-13071000-13071104', 585],
        ['de-mv-13073000-13073104', 586], ['de-mv-13071000-13071016', 587],
        ['de-mv-13071000-13071161', 588], ['de-mv-13076000-13076099', 589],
        ['de-mv-13074000-13074082', 590], ['de-mv-13074000-13074036', 591],
        ['de-mv-13071000-13071125', 592], ['de-mv-13074000-13074031', 593],
        ['de-mv-13071000-13071081', 594], ['de-mv-13071000-13071041', 595],
        ['de-mv-13074000-13074079', 596], ['de-mv-13075000-13075121', 597],
        ['de-mv-13074000-13074052', 598], ['de-mv-13075000-13075122', 599],
        ['de-mv-13074000-13074067', 600], ['de-mv-13075000-13075127', 601],
        ['de-mv-13074000-13074029', 602], ['de-mv-13071000-13071017', 603],
        ['de-mv-13072000-13072002', 604], ['de-mv-13076000-13076159', 605],
        ['de-mv-13074000-13074043', 606], ['de-mv-13076000-13076043', 607],
        ['de-mv-13074000-13074040', 608], ['de-mv-13075000-13075045', 609],
        ['de-mv-13075000-13075047', 610], ['de-mv-13076000-13076026', 611],
        ['de-mv-13076000-13076056', 612], ['de-mv-13071000-13071156', 613],
        ['de-mv-13071000-13071122', 614], ['de-mv-13073000-13073054', 615],
        ['de-mv-13073000-13073002', 616], ['de-mv-13075000-13075154', 617],
        ['de-mv-13075000-13075131', 618], ['de-mv-13075000-13075031', 619],
        ['de-mv-13075000-13075078', 620], ['de-mv-13076000-13076037', 621],
        ['de-mv-13076000-13076001', 622], ['de-mv-13076000-13076046', 623],
        ['de-mv-13075000-13075021', 624], ['de-mv-13075000-13075094', 625],
        ['de-mv-13076000-13076116', 626], ['de-mv-13071000-13071155', 627],
        ['de-mv-13071000-13071043', 628], ['de-mv-13071000-13071138', 629],
        ['de-mv-13076000-13076145', 630], ['de-mv-13076000-13076110', 631],
        ['de-mv-13076000-13076009', 632], ['de-mv-13076000-13076142', 633],
        ['de-mv-13071000-13071168', 634], ['de-mv-13071000-13071165', 635],
        ['de-mv-13071000-13071148', 636], ['de-mv-13075000-13075111', 637],
        ['de-mv-13073000-13073007', 638], ['de-mv-13073000-13073055', 639],
        ['de-mv-13073000-13073015', 640], ['de-mv-13072000-13072016', 641],
        ['de-mv-13072000-13072035', 642], ['de-mv-13071000-13071109', 643],
        ['de-mv-13075000-13075151', 644], ['de-mv-13072000-13072004', 645],
        ['de-mv-13072000-13072049', 646], ['de-mv-13076000-13076070', 647],
        ['de-mv-13074000-13074064', 648], ['de-mv-13074000-13074088', 649],
        ['de-mv-13074000-13074001', 650], ['de-mv-13074000-13074015', 651],
        ['de-mv-13071000-13071069', 652], ['de-mv-13076000-13076020', 653],
        ['de-mv-13076000-13076121', 654], ['de-mv-13076000-13076156', 655],
        ['de-mv-13074000-13074016', 656], ['de-mv-13074000-13074072', 657],
        ['de-mv-13074000-13074061', 658], ['de-mv-13076000-13076029', 659],
        ['de-mv-13071000-13071089', 660], ['de-mv-13071000-13071074', 661],
        ['de-mv-13071000-13071169', 662], ['de-mv-13071000-13071030', 663],
        ['de-mv-13071000-13071036', 664], ['de-mv-13071000-13071114', 665],
        ['de-mv-13071000-13071093', 666], ['de-mv-13071000-13071001', 667],
        ['de-mv-13072000-13072026', 668], ['de-mv-13071000-13071154', 669],
        ['de-mv-13074000-13074049', 670], ['de-mv-13073000-13073085', 671],
        ['de-mv-13072000-13072121', 672], ['de-mv-13074000-13074089', 673],
        ['de-mv-13075000-13075006', 674], ['de-mv-13073000-13073102', 675],
        ['de-mv-13073000-13073024', 676], ['de-mv-13076000-13076153', 677],
        ['de-mv-13074000-13074070', 678], ['de-mv-13072000-13072080', 679],
        ['de-mv-13076000-13076073', 680], ['de-mv-13071000-13071119', 681],
        ['de-mv-13072000-13072029', 682], ['de-mv-13071000-13071067', 683],
        ['de-mv-13071000-13071046', 684], ['de-mv-13071000-13071140', 685],
        ['de-mv-13072000-13072117', 686], ['de-mv-13072000-13072086', 687],
        ['de-mv-13072000-13072083', 688], ['de-mv-13071000-13071099', 689],
        ['de-mv-13071000-13071096', 690], ['de-mv-13073000-13073049', 691],
        ['de-mv-13071000-13071150', 692], ['de-mv-13075000-13075054', 693],
        ['de-mv-13075000-13075002', 694], ['de-mv-13075000-13075017', 695],
        ['de-mv-13075000-13075126', 696], ['de-mv-13071000-13071144', 697],
        ['de-mv-13071000-13071045', 698], ['de-mv-13071000-13071077', 699],
        ['de-mv-13075000-13075118', 700], ['de-mv-13075000-13075048', 701],
        ['de-mv-13071000-13071159', 702], ['de-mv-13075000-13075098', 703],
        ['de-mv-13075000-13075082', 704], ['de-mv-13075000-13075016', 705],
        ['de-mv-13074000-13074080', 706], ['de-mv-13071000-13071071', 707],
        ['de-mv-13075000-13075128', 708], ['de-mv-13072000-13072087', 709],
        ['de-mv-13075000-13075073', 710], ['de-mv-13075000-13075053', 711],
        ['de-mv-13072000-13072081', 712], ['de-mv-13075000-13075025', 713],
        ['de-mv-13075000-13075036', 714], ['de-mv-13071000-13071065', 715],
        ['de-mv-13071000-13071032', 716], ['de-mv-13073000-13073030', 717],
        ['de-mv-13073000-13073052', 718], ['de-mv-13072000-13072076', 719],
        ['de-mv-13075000-13075097', 720], ['de-mv-13071000-13071145', 721],
        ['de-mv-13071000-13071060', 722], ['de-mv-13071000-13071070', 723],
        ['de-mv-13075000-13075149', 724], ['de-mv-13071000-13071026', 725],
        ['de-mv-13075000-13075067', 726], ['de-mv-13071000-13071063', 727],
        ['de-mv-13071000-13071106', 728], ['de-mv-13071000-13071014', 729],
        ['de-mv-13071000-13071027', 730], ['de-mv-13074000-13074053', 731],
        ['de-mv-13074000-13074004', 732], ['de-mv-13075000-13075056', 733],
        ['de-mv-13074000-13074090', 734], ['de-mv-13076000-13076003', 735],
        ['de-mv-13076000-13076082', 736], ['de-mv-13076000-13076112', 737],
        ['de-mv-13074000-13074074', 738], ['de-mv-13074000-13074042', 739],
        ['de-mv-13073000-13073042', 740], ['de-mv-13073000-13073043', 741],
        ['de-mv-13073000-13073036', 742], ['de-mv-13072000-13072001', 743],
        ['de-mv-13072000-13072017', 744], ['de-mv-13072000-13072075', 745],
        ['de-mv-13073000-13073012', 746], ['de-mv-13076000-13076125', 747],
        ['de-mv-13074000-13074035', 748], ['de-mv-13074000-13074007', 749],
        ['de-mv-13073000-13073081', 750], ['de-mv-13073000-13073027', 751],
        ['de-mv-13075000-13075003', 752], ['de-mv-13071000-13071167', 753],
        ['de-mv-13073000-13073040', 754], ['de-mv-13076000-13076132', 755],
        ['de-mv-13076000-13076127', 756], ['de-mv-13071000-13071133', 757],
        ['de-mv-13073000-13073071', 758], ['de-mv-13074000-13074010', 759],
        ['de-mv-13073000-13073019', 760], ['de-mv-13073000-13073101', 761],
        ['de-mv-13074000-13074037', 762], ['de-mv-13076000-13076136', 763],
        ['de-mv-13072000-13072108', 764], ['de-mv-13073000-13073075', 765],
        ['de-mv-13071000-13071091', 766], ['de-mv-13073000-13073003', 767],
        ['de-mv-13075000-13075001', 768], ['de-mv-13073000-13073039', 769],
        ['de-mv-13071000-13071126', 770], ['de-mv-13075000-13075143', 771],
        ['de-mv-13073000-13073098', 772], ['de-mv-13071000-13071005', 773],
        ['de-mv-13071000-13071166', 774], ['de-mv-13074000-13074085', 775],
        ['de-mv-13076000-13076154', 776], ['de-mv-13076000-13076041', 777],
        ['de-mv-13072000-13072084', 778], ['de-mv-13072000-13072099', 779],
        ['de-mv-13071000-13071075', 780], ['de-mv-13071000-13071110', 781],
        ['de-mv-13076000-13076111', 782], ['de-mv-13072000-13072066', 783],
        ['de-mv-13072000-13072009', 784], ['de-mv-13071000-13071113', 785],
        ['de-mv-13076000-13076032', 786], ['de-mv-13071000-13071147', 787],
        ['de-mv-13073000-13073079', 788], ['de-mv-13076000-13076051', 789],
        [null, 790]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-mv-all-all.topo.json">Mecklenburg-Vorpommern</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
