(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-ni-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-ni-03452000-03452501', 10], ['de-ni-03457000-03457501', 11],
        ['de-ni-03458000-03458003', 12], ['de-ni-03458000-03458009', 13],
        ['de-ni-03453000-03453009', 14], ['de-ni-03453000-03453011', 15],
        ['de-ni-03459000-03459025', 16], ['de-ni-03353000-03353041', 17],
        ['de-ni-03153000-03153013', 18], ['de-ni-03458000-03458012', 19],
        ['de-ni-03155000-03155003', 20], ['de-ni-03153000-03153016', 21],
        ['de-ni-03251000-03251002', 22], ['de-ni-03355000-03355037', 23],
        ['de-ni-03459000-03459014', 24], ['de-ni-03459000-03459027', 25],
        ['de-ni-03154000-03154020', 26], ['de-ni-03357000-03357044', 27],
        ['de-ni-03255000-03255002', 28], ['de-ni-04011000-04011000', 29],
        ['de-ni-03254000-03254029', 30], ['de-ni-03255000-03255004', 31],
        ['de-ni-03353000-03353037', 32], ['de-ni-03151000-03151017', 33],
        ['de-ni-03151000-03151018', 34], ['de-ni-03255000-03255508', 35],
        ['de-ni-03255000-03255008', 36], ['de-ni-03255000-03255504', 37],
        ['de-ni-03459000-03459005', 38], ['de-ni-03255000-03255009', 39],
        ['de-ni-03456000-03456018', 40], ['de-ni-03456000-03456005', 41],
        ['de-ni-03352000-03352046', 42], ['de-ni-03151000-03151026', 43],
        ['de-ni-03403000-03403000', 44], ['de-ni-03451000-03451005', 45],
        ['de-ni-03456000-03456015', 46], ['de-ni-03157000-03157006', 47],
        ['de-ni-03455000-03455026', 48], ['de-ni-03454000-03454036', 49],
        ['de-ni-03454000-03454053', 50], ['de-ni-03462000-03462006', 51],
        ['de-ni-03462000-03462012', 52], ['de-ni-03358000-03358017', 53],
        ['de-ni-03254000-03254015', 54], ['de-ni-03353000-03353017', 55],
        ['de-ni-03455000-03455025', 56], ['de-ni-03451000-03451007', 57],
        ['de-ni-03359000-03359038', 58], ['de-ni-03459000-03459012', 59],
        ['de-ni-03459000-03459029', 60], ['de-ni-03459000-03459008', 61],
        ['de-ni-03360000-03360006', 62], ['de-ni-03359000-03359022', 63],
        ['de-ni-03153000-03153001', 64], ['de-ni-03153000-03153002', 65],
        ['de-ni-03153000-03153011', 66], ['de-ni-03153000-03153015', 67],
        ['de-ni-03158000-03158020', 68], ['de-ni-03158000-03158018', 69],
        ['de-ni-03255000-03255007', 70], ['de-ni-03156000-03156009', 71],
        ['de-ni-03156000-03156012', 72], ['de-ni-03352000-03352008', 73],
        ['de-ni-03352000-03352045', 74], ['de-ni-03454000-03454035', 75],
        ['de-ni-03454000-03454054', 76], ['de-ni-03255000-03255503', 77],
        ['de-ni-03252000-03252006', 78], ['de-ni-03252000-03252004', 79],
        ['de-ni-03357000-03357039', 80], ['de-ni-03251000-03251022', 81],
        ['de-ni-03454000-03454018', 82], ['de-ni-03254000-03254019', 83],
        ['de-ni-03151000-03151021', 84], ['de-ni-03157000-03157005', 85],
        ['de-ni-03157000-03157007', 86], ['de-ni-03354000-03354006', 87],
        ['de-ni-03256000-03256032', 88], ['de-ni-03151000-03151031', 89],
        ['de-ni-03151000-03151024', 90], ['de-ni-03154000-03154010', 91],
        ['de-ni-03152000-03152019', 92], ['de-ni-03354000-03354020', 93],
        ['de-ni-03153000-03153012', 94], ['de-ni-03153000-03153504', 95],
        ['de-ni-03254000-03254018', 96], ['de-ni-03256000-03256030', 97],
        ['de-ni-03154000-03154004', 98], ['de-ni-03103000-03103000', 99],
        ['de-ni-03154000-03154503', 100], ['de-ni-03154000-03154013', 101],
        ['de-ni-03354000-03354005', 102], ['de-ni-03452000-03452006', 103],
        ['de-ni-03457000-03457020', 104], ['de-ni-03452000-03452010', 105],
        ['de-ni-03452000-03452016', 106], ['de-ni-03257000-03257013', 107],
        ['de-ni-03257000-03257035', 108], ['de-ni-03257000-03257023', 109],
        ['de-ni-03257000-03257027', 110], ['de-ni-03257000-03257025', 111],
        ['de-ni-03454000-03454006', 112], ['de-ni-03454000-03454011', 113],
        ['de-ni-03151000-03151015', 114], ['de-ni-03157000-03157001', 115],
        ['de-ni-03151000-03151012', 116], ['de-ni-03152000-03152021', 117],
        ['de-ni-03241000-03241011', 118], ['de-ni-03241000-03241008', 119],
        ['de-ni-03152000-03152023', 120], ['de-ni-03241000-03241019', 121],
        ['de-ni-03152000-03152005', 122], ['de-ni-03255000-03255030', 123],
        ['de-ni-03255000-03255021', 124], ['de-ni-03454000-03454022', 125],
        ['de-ni-03357000-03357050', 126], ['de-ni-03353000-03353014', 127],
        ['de-ni-03255000-03255025', 128], ['de-ni-03456000-03456025', 129],
        ['de-ni-03456000-03456017', 130], ['de-ni-03454000-03454044', 131],
        ['de-ni-03457000-03457021', 132], ['de-ni-03457000-03457022', 133],
        ['de-ni-03454000-03454012', 134], ['de-ni-03454000-03454031', 135],
        ['de-ni-03454000-03454051', 136], ['de-ni-03454000-03454041', 137],
        ['de-ni-03354000-03354022', 138], ['de-ni-03454000-03454009', 139],
        ['de-ni-03459000-03459009', 140], ['de-ni-03360000-03360020', 141],
        ['de-ni-03360000-03360024', 142], ['de-ni-03454000-03454020', 143],
        ['de-ni-03360000-03360022', 144], ['de-ni-03354000-03354027', 145],
        ['de-ni-03354000-03354502', 146], ['de-ni-03354000-03354024', 147],
        ['de-ni-03360000-03360018', 148], ['de-ni-03354000-03354002', 149],
        ['de-ni-03354000-03354016', 150], ['de-ni-03254000-03254020', 151],
        ['de-ni-03254000-03254028', 152], ['de-ni-03256000-03256028', 153],
        ['de-ni-03256000-03256035', 154], ['de-ni-03352000-03352040', 155],
        ['de-ni-03458000-03458011', 156], ['de-ni-03458000-03458006', 157],
        ['de-ni-03458000-03458008', 158], ['de-ni-03454000-03454003', 159],
        ['de-ni-03357000-03357046', 160], ['de-ni-03251000-03251003', 161],
        ['de-ni-03251000-03251043', 162], ['de-ni-03454000-03454055', 163],
        ['de-ni-03453000-03453007', 164], ['de-ni-03453000-03453004', 165],
        ['de-ni-03459000-03459001', 166], ['de-ni-03459000-03459031', 167],
        ['de-ni-03355000-03355001', 168], ['de-ni-03355000-03355011', 169],
        ['de-ni-03353000-03353033', 170], ['de-ni-03454000-03454004', 171],
        ['de-ni-03453000-03453013', 172], ['de-ni-03454000-03454008', 173],
        ['de-ni-03156000-03156004', 174], ['de-ni-03156000-03156014', 175],
        ['de-ni-03351000-03351019', 176], ['de-ni-03151000-03151028', 177],
        ['de-ni-03353000-03353023', 178], ['de-ni-03459000-03459033', 179],
        ['de-ni-03355000-03355017', 180], ['de-ni-03353000-03353007', 181],
        ['de-ni-03454000-03454034', 182], ['de-ni-03355000-03355042', 183],
        ['de-ni-03454000-03454032', 184], ['de-ni-03355000-03355007', 185],
        ['de-ni-03355000-03355004', 186], ['de-ni-03360000-03360013', 187],
        ['de-ni-03460000-03460010', 188], ['de-ni-03458000-03458007', 189],
        ['de-ni-03351000-03351003', 190], ['de-ni-03351000-03351006', 191],
        ['de-ni-03351000-03351016', 192], ['de-ni-03357000-03357043', 193],
        ['de-ni-03357000-03357042', 194], ['de-ni-03459000-03459003', 195],
        ['de-ni-03453000-03453010', 196], ['de-ni-03454000-03454057', 197],
        ['de-ni-03453000-03453008', 198], ['de-ni-03459000-03459016', 199],
        ['de-ni-03459000-03459006', 200], ['de-ni-03454000-03454021', 201],
        ['de-ni-03251000-03251044', 202], ['de-ni-03454000-03454010', 203],
        ['de-ni-03456000-03456003', 204], ['de-ni-03251000-03251029', 205],
        ['de-ni-03151000-03151025', 206], ['de-ni-03151000-03151004', 207],
        ['de-ni-03454000-03454015', 208], ['de-ni-03251000-03251009', 209],
        ['de-ni-03151000-03151039', 210], ['de-ni-03454000-03454002', 211],
        ['de-ni-03158000-03158503', 212], ['de-ni-03154000-03154017', 213],
        ['de-ni-03353000-03353018', 214], ['de-ni-03357000-03357029', 215],
        ['de-ni-03353000-03353022', 216], ['de-ni-03353000-03353040', 217],
        ['de-ni-03353000-03353012', 218], ['de-ni-03454000-03454033', 219],
        ['de-ni-03357000-03357028', 220], ['de-ni-03357000-03357052', 221],
        ['de-ni-03356000-03356002', 222], ['de-ni-03357000-03357048', 223],
        ['de-ni-03358000-03358011', 224], ['de-ni-03358000-03358012', 225],
        ['de-ni-03251000-03251001', 226], ['de-ni-03251000-03251032', 227],
        ['de-ni-03359000-03359033', 228], ['de-ni-03359000-03359032', 229],
        ['de-ni-03251000-03251031', 230], ['de-ni-03151000-03151002', 231],
        ['de-ni-03459000-03459002', 232], ['de-ni-03459000-03459026', 233],
        ['de-ni-03353000-03353027', 234], ['de-ni-03358000-03358019', 235],
        ['de-ni-03355000-03355010', 236], ['de-ni-03353000-03353015', 237],
        ['de-ni-03353000-03353038', 238], ['de-ni-03459000-03459004', 239],
        ['de-ni-03353000-03353035', 240], ['de-ni-03454000-03454048', 241],
        ['de-ni-03454000-03454042', 242], ['de-ni-03454000-03454059', 243],
        ['de-ni-03459000-03459011', 244], ['de-ni-03454000-03454019', 245],
        ['de-ni-03256000-03256007', 246], ['de-ni-03158000-03158006', 247],
        ['de-ni-03101000-03101000', 248], ['de-ni-03357000-03357019', 249],
        ['de-ni-03256000-03256008', 250], ['de-ni-03154000-03154014', 251],
        ['de-ni-03151000-03151008', 252], ['de-ni-03151000-03151040', 253],
        ['de-ni-03151000-03151019', 254], ['de-ni-03151000-03151005', 255],
        ['de-ni-03158000-03158502', 256], ['de-ni-03154000-03154003', 257],
        ['de-ni-03154000-03154026', 258], ['de-ni-03154000-03154506', 259],
        ['de-ni-03359000-03359020', 260], ['de-ni-03359000-03359039', 261],
        ['de-ni-03359000-03359026', 262], ['de-ni-03158000-03158036', 263],
        ['de-ni-03158000-03158032', 264], ['de-ni-03354000-03354009', 265],
        ['de-ni-03355000-03355025', 266], ['de-ni-03355000-03355013', 267],
        ['de-ni-03241000-03241015', 268], ['de-ni-03241000-03241021', 269],
        ['de-ni-03454000-03454037', 270], ['de-ni-03256000-03256025', 271],
        ['de-ni-03454000-03454058', 272], ['de-ni-03454000-03454005', 273],
        ['de-ni-03257000-03257010', 274], ['de-ni-03458000-03458014', 275],
        ['de-ni-03458000-03458015', 276], ['de-ni-03360000-03360014', 277],
        ['de-ni-03360000-03360004', 278], ['de-ni-03458000-03458013', 279],
        ['de-ni-03459000-03459017', 280], ['de-ni-03360000-03360010', 281],
        ['de-ni-03451000-03451004', 282], ['de-ni-03454000-03454001', 283],
        ['de-ni-03359000-03359035', 284], ['de-ni-03359000-03359040', 285],
        ['de-ni-03254000-03254032', 286], ['de-ni-03256000-03256011', 287],
        ['de-ni-03401000-03401000', 288], ['de-ni-03458000-03458005', 289],
        ['de-ni-03252000-03252002', 290], ['de-ni-03257000-03257024', 291],
        ['de-ni-03358000-03358001', 292], ['de-ni-03358000-03358009', 293],
        ['de-ni-03358000-03358014', 294], ['de-ni-03241000-03241005', 295],
        ['de-ni-03351000-03351018', 296], ['de-ni-03154000-03154024', 297],
        ['de-ni-03257000-03257018', 298], ['de-ni-03257000-03257032', 299],
        ['de-ni-03257000-03257007', 300], ['de-ni-03257000-03257030', 301],
        ['de-ni-03257000-03257037', 302], ['de-ni-03155000-03155012', 303],
        ['de-ni-03155000-03155009', 304], ['de-ni-03155000-03155501', 305],
        ['de-ni-03257000-03257029', 306], ['de-ni-03257000-03257003', 307],
        ['de-ni-03355000-03355015', 308], ['de-ni-03355000-03355018', 309],
        ['de-ni-03452000-03452009', 310], ['de-ni-03452000-03452019', 311],
        ['de-ni-03251000-03251038', 312], ['de-ni-03251000-03251039', 313],
        ['de-ni-03361000-03361004', 314], ['de-ni-03454000-03454047', 315],
        ['de-ni-03454000-03454050', 316], ['de-ni-03454000-03454029', 317],
        ['de-ni-03357000-03357001', 318], ['de-ni-03357000-03357020', 319],
        ['de-ni-03357000-03357005', 320], ['de-ni-03454000-03454040', 321],
        ['de-ni-03257000-03257026', 322], ['de-ni-03459000-03459020', 323],
        ['de-ni-03252000-03252007', 324], ['de-ni-03251000-03251042', 325],
        ['de-ni-03251000-03251005', 326], ['de-ni-03251000-03251017', 327],
        ['de-ni-03257000-03257017', 328], ['de-ni-03257000-03257006', 329],
        ['de-ni-03454000-03454023', 330], ['de-ni-03241000-03241002', 331],
        ['de-ni-03241000-03241017', 332], ['de-ni-03357000-03357025', 333],
        ['de-ni-03257000-03257002', 334], ['de-ni-03256000-03256009', 335],
        ['de-ni-03361000-03361002', 336], ['de-ni-03251000-03251033', 337],
        ['de-ni-03251000-03251048', 338], ['de-ni-03251000-03251026', 339],
        ['de-ni-03351000-03351013', 340], ['de-ni-03358000-03358023', 341],
        ['de-ni-03351000-03351501', 342], ['de-ni-03152000-03152002', 343],
        ['de-ni-03156000-03156015', 344], ['de-ni-03254000-03254036', 345],
        ['de-ni-03257000-03257004', 346], ['de-ni-03457000-03457014', 347],
        ['de-ni-03454000-03454038', 348], ['de-ni-03454000-03454030', 349],
        ['de-ni-03354000-03354013', 350], ['de-ni-03154000-03154007', 351],
        ['de-ni-03154000-03154501', 352], ['de-ni-03353000-03353006', 353],
        ['de-ni-03351000-03351005', 354], ['de-ni-03351000-03351022', 355],
        ['de-ni-03351000-03351015', 356], ['de-ni-03351000-03351002', 357],
        ['de-ni-03351000-03351017', 358], ['de-ni-03256000-03256001', 359],
        ['de-ni-03351000-03351007', 360], ['de-ni-03256000-03256036', 361],
        ['de-ni-03357000-03357002', 362], ['de-ni-03357000-03357012', 363],
        ['de-ni-03254000-03254008', 364], ['de-ni-03153000-03153014', 365],
        ['de-ni-03359000-03359029', 366], ['de-ni-03359000-03359009', 367],
        ['de-ni-03359000-03359027', 368], ['de-ni-03156000-03156008', 369],
        ['de-ni-03152000-03152029', 370], ['de-ni-03454000-03454045', 371],
        ['de-ni-03454000-03454049', 372], ['de-ni-03256000-03256014', 373],
        ['de-ni-03454000-03454013', 374], ['de-ni-03454000-03454052', 375],
        ['de-ni-03454000-03454060', 376], ['de-ni-03459000-03459021', 377],
        ['de-ni-03459000-03459007', 378], ['de-ni-03352000-03352043', 379],
        ['de-ni-03352000-03352025', 380], ['de-ni-03251000-03251011', 381],
        ['de-ni-03359000-03359030', 382], ['de-ni-03359000-03359018', 383],
        ['de-ni-03251000-03251030', 384], ['de-ni-03454000-03454046', 385],
        ['de-ni-03359000-03359015', 386], ['de-ni-03352000-03352020', 387],
        ['de-ni-03459000-03459022', 388], ['de-ni-03255000-03255505', 389],
        ['de-ni-03255000-03255506', 390], ['de-ni-03255000-03255026', 391],
        ['de-ni-03255000-03255501', 392], ['de-ni-03257000-03257009', 393],
        ['de-ni-03257000-03257005', 394], ['de-ni-03359000-03359012', 395],
        ['de-ni-03156000-03156501', 396], ['de-ni-03156000-03156013', 397],
        ['de-ni-03154000-03154021', 398], ['de-ni-03153000-03153008', 399],
        ['de-ni-03255000-03255010', 400], ['de-ni-03152000-03152025', 401],
        ['de-ni-03152000-03152015', 402], ['de-ni-03152000-03152008', 403],
        ['de-ni-03256000-03256003', 404], ['de-ni-03256000-03256015', 405],
        ['de-ni-03256000-03256013', 406], ['de-ni-03361000-03361003', 407],
        ['de-ni-03255000-03255015', 408], ['de-ni-03256000-03256010', 409],
        ['de-ni-03355000-03355029', 410], ['de-ni-03358000-03358016', 411],
        ['de-ni-03254000-03254026', 412], ['de-ni-03254000-03254017', 413],
        ['de-ni-03257000-03257015', 414], ['de-ni-03358000-03358008', 415],
        ['de-ni-03151000-03151023', 416], ['de-ni-03151000-03151001', 417],
        ['de-ni-03157000-03157008', 418], ['de-ni-03360000-03360019', 419],
        ['de-ni-03360000-03360025', 420], ['de-ni-03360000-03360030', 421],
        ['de-ni-03360000-03360005', 422], ['de-ni-03158000-03158008', 423],
        ['de-ni-03355000-03355012', 424], ['de-ni-03154000-03154012', 425],
        ['de-ni-03459000-03459034', 426], ['de-ni-03151000-03151020', 427],
        ['de-ni-03151000-03151006', 428], ['de-ni-03358000-03358007', 429],
        ['de-ni-03357000-03357037', 430], ['de-ni-03151000-03151013', 431],
        ['de-ni-03357000-03357034', 432], ['de-ni-03357000-03357032', 433],
        ['de-ni-03352000-03352042', 434], ['de-ni-03352000-03352018', 435],
        ['de-ni-03255000-03255003', 436], ['de-ni-03255000-03255019', 437],
        ['de-ni-03357000-03357047', 438], ['de-ni-03357000-03357053', 439],
        ['de-ni-03255000-03255033', 440], ['de-ni-03357000-03357026', 441],
        ['de-ni-03152000-03152011', 442], ['de-ni-03152000-03152024', 443],
        ['de-ni-03254000-03254001', 444], ['de-ni-03158000-03158025', 445],
        ['de-ni-03158000-03158015', 446], ['de-ni-03158000-03158034', 447],
        ['de-ni-03404000-03404000', 448], ['de-ni-03353000-03353001', 449],
        ['de-ni-03353000-03353019', 450], ['de-ni-03360000-03360015', 451],
        ['de-ni-03360000-03360016', 452], ['de-ni-03359000-03359028', 453],
        ['de-ni-03357000-03357038', 454], ['de-ni-03357000-03357030', 455],
        ['de-ni-03357000-03357036', 456], ['de-ni-03357000-03357057', 457],
        ['de-ni-03352000-03352035', 458], ['de-ni-03356000-03356009', 459],
        ['de-ni-03461000-03461004', 460], ['de-ni-03352000-03352031', 461],
        ['de-ni-03352000-03352028', 462], ['de-ni-03457000-03457019', 463],
        ['de-ni-03256000-03256023', 464], ['de-ni-03457000-03457009', 465],
        ['de-ni-03357000-03357051', 466], ['de-ni-03357000-03357024', 467],
        ['de-ni-03357000-03357031', 468], ['de-ni-03257000-03257008', 469],
        ['de-ni-03357000-03357033', 470], ['de-ni-03257000-03257011', 471],
        ['de-ni-03241000-03241014', 472], ['de-ni-03152000-03152017', 473],
        ['de-ni-03241000-03241020', 474], ['de-ni-03257000-03257016', 475],
        ['de-ni-03257000-03257001', 476], ['de-ni-03357000-03357054', 477],
        ['de-ni-03257000-03257036', 478], ['de-ni-03257000-03257019', 479],
        ['de-ni-03257000-03257021', 480], ['de-ni-03355000-03355021', 481],
        ['de-ni-03355000-03355032', 482], ['de-ni-03355000-03355009', 483],
        ['de-ni-03355000-03355030', 484], ['de-ni-03355000-03355038', 485],
        ['de-ni-03355000-03355005', 486], ['de-ni-03355000-03355022', 487],
        ['de-ni-03355000-03355033', 488], ['de-ni-03156000-03156002', 489],
        ['de-ni-03153000-03153009', 490], ['de-ni-03241000-03241009', 491],
        ['de-ni-03254000-03254003', 492], ['de-ni-03358000-03358006', 493],
        ['de-ni-03256000-03256006', 494], ['de-ni-03256000-03256022', 495],
        ['de-ni-03357000-03357023', 496], ['de-ni-03355000-03355003', 497],
        ['de-ni-03358000-03358013', 498], ['de-ni-03358000-03358018', 499],
        ['de-ni-03358000-03358003', 500], ['de-ni-03152000-03152022', 501],
        ['de-ni-03152000-03152018', 502], ['de-ni-03152000-03152020', 503],
        ['de-ni-03353000-03353011', 504], ['de-ni-03353000-03353030', 505],
        ['de-ni-03355000-03355031', 506], ['de-ni-03355000-03355028', 507],
        ['de-ni-03355000-03355023', 508], ['de-ni-03152000-03152010', 509],
        ['de-ni-03156000-03156007', 510], ['de-ni-03257000-03257031', 511],
        ['de-ni-03155000-03155007', 512], ['de-ni-03252000-03252001', 513],
        ['de-ni-03361000-03361010', 514], ['de-ni-03251000-03251041', 515],
        ['de-ni-03459000-03459015', 516], ['de-ni-03459000-03459024', 517],
        ['de-ni-03351000-03351011', 518], ['de-ni-03351000-03351014', 519],
        ['de-ni-03351000-03351009', 520], ['de-ni-03351000-03351004', 521],
        ['de-ni-03241000-03241006', 522], ['de-ni-03241000-03241001', 523],
        ['de-ni-03156000-03156005', 524], ['de-ni-03255000-03255035', 525],
        ['de-ni-03452000-03452017', 526], ['de-ni-03452000-03452014', 527],
        ['de-ni-03459000-03459019', 528], ['de-ni-03457000-03457015', 529],
        ['de-ni-03352000-03352058', 530], ['de-ni-03352000-03352059', 531],
        ['de-ni-03356000-03356001', 532], ['de-ni-03352000-03352007', 533],
        ['de-ni-03452000-03452003', 534], ['de-ni-03452000-03452008', 535],
        ['de-ni-03462000-03462008', 536], ['de-ni-03462000-03462015', 537],
        ['de-ni-03461000-03461007', 538], ['de-ni-03352000-03352032', 539],
        ['de-ni-03461000-03461009', 540], ['de-ni-03461000-03461003', 541],
        ['de-ni-03452000-03452012', 542], ['de-ni-03152000-03152014', 543],
        ['de-ni-03255000-03255034', 544], ['de-ni-03255000-03255001', 545],
        ['de-ni-03255000-03255032', 546], ['de-ni-03254000-03254014', 547],
        ['de-ni-03358000-03358020', 548], ['de-ni-03255000-03255016', 549],
        ['de-ni-03252000-03252005', 550], ['de-ni-03254000-03254013', 551],
        ['de-ni-03252000-03252008', 552], ['de-ni-03251000-03251037', 553],
        ['de-ni-03251000-03251047', 554], ['de-ni-03456000-03456010', 555],
        ['de-ni-03456000-03456009', 556], ['de-ni-03452000-03452021', 557],
        ['de-ni-03254000-03254002', 558], ['de-ni-03457000-03457017', 559],
        ['de-ni-03453000-03453001', 560], ['de-ni-03156000-03156006', 561],
        ['de-ni-03457000-03457018', 562], ['de-ni-03158000-03158016', 563],
        ['de-ni-03158000-03158002', 564], ['de-ni-03154000-03154006', 565],
        ['de-ni-03158000-03158035', 566], ['de-ni-03158000-03158023', 567],
        ['de-ni-03158000-03158037', 568], ['de-ni-03154000-03154002', 569],
        ['de-ni-03158000-03158029', 570], ['de-ni-03255000-03255028', 571],
        ['de-ni-03251000-03251028', 572], ['de-ni-03251000-03251015', 573],
        ['de-ni-03251000-03251014', 574], ['de-ni-03254000-03254021', 575],
        ['de-ni-03255000-03255005', 576], ['de-ni-03257000-03257028', 577],
        ['de-ni-03359000-03359036', 578], ['de-ni-03256000-03256005', 579],
        ['de-ni-03256000-03256027', 580], ['de-ni-03352000-03352051', 581],
        ['de-ni-03255000-03255014', 582], ['de-ni-03158000-03158026', 583],
        ['de-ni-03402000-03402000', 584], ['de-ni-03358000-03358004', 585],
        ['de-ni-03358000-03358021', 586], ['de-ni-03154000-03154005', 587],
        ['de-ni-03154000-03154025', 588], ['de-ni-03458000-03458010', 589],
        ['de-ni-03355000-03355049', 590], ['de-ni-03354000-03354003', 591],
        ['de-ni-03354000-03354008', 592], ['de-ni-03352000-03352050', 593],
        ['de-ni-03352000-03352015', 594], ['de-ni-03462000-03462017', 595],
        ['de-ni-03152000-03152006', 596], ['de-ni-03354000-03354011', 597],
        ['de-ni-03354000-03354012', 598], ['de-ni-03354000-03354018', 599],
        ['de-ni-03156000-03156010', 600], ['de-ni-03156000-03156011', 601],
        ['de-ni-03357000-03357022', 602], ['de-ni-03357000-03357045', 603],
        ['de-ni-03361000-03361005', 604], ['de-ni-03456000-03456001', 605],
        ['de-ni-03456000-03456014', 606], ['de-ni-03456000-03456023', 607],
        ['de-ni-03456000-03456013', 608], ['de-ni-03456000-03456006', 609],
        ['de-ni-03456000-03456024', 610], ['de-ni-03241000-03241007', 611],
        ['de-ni-03456000-03456011', 612], ['de-ni-03456000-03456012', 613],
        ['de-ni-03361000-03361012', 614], ['de-ni-03454000-03454007', 615],
        ['de-ni-03357000-03357006', 616], ['de-ni-03158000-03158005', 617],
        ['de-ni-03255000-03255013', 618], ['de-ni-03252000-03252003', 619],
        ['de-ni-03459000-03459030', 620], ['de-ni-03453000-03453006', 621],
        ['de-ni-03454000-03454028', 622], ['de-ni-03352000-03352036', 623],
        ['de-ni-03457000-03457013', 624], ['de-ni-03457000-03457016', 625],
        ['de-ni-03353000-03353021', 626], ['de-ni-03352000-03352030', 627],
        ['de-ni-03457000-03457010', 628], ['de-ni-03352000-03352003', 629],
        ['de-ni-03353000-03353008', 630], ['de-ni-03455000-03455014', 631],
        ['de-ni-03462000-03462005', 632], ['de-ni-03452000-03452015', 633],
        ['de-ni-03452000-03452022', 634], ['de-ni-03352000-03352041', 635],
        ['de-ni-03462000-03462010', 636], ['de-ni-03352000-03352038', 637],
        ['de-ni-03352000-03352011', 638], ['de-ni-03352000-03352013', 639],
        ['de-ni-03352000-03352057', 640], ['de-ni-03457000-03457006', 641],
        ['de-ni-03352000-03352037', 642], ['de-ni-03461000-03461001', 643],
        ['de-ni-03461000-03461006', 644], ['de-ni-03352000-03352048', 645],
        ['de-ni-03356000-03356008', 646], ['de-ni-03356000-03356005', 647],
        ['de-ni-03356000-03356007', 648], ['de-ni-03356000-03356004', 649],
        ['de-ni-03356000-03356010', 650], ['de-ni-03356000-03356003', 651],
        ['de-ni-03255000-03255012', 652], ['de-ni-03255000-03255502', 653],
        ['de-ni-03356000-03356006', 654], ['de-ni-03462000-03462011', 655],
        ['de-ni-03255000-03255027', 656], ['de-ni-03359000-03359002', 657],
        ['de-ni-03462000-03462016', 658], ['de-ni-03359000-03359037', 659],
        ['de-ni-03462000-03462001', 660], ['de-ni-03461000-03461008', 661],
        ['de-ni-03352000-03352009', 662], ['de-ni-03352000-03352016', 663],
        ['de-ni-03352000-03352014', 664], ['de-ni-03352000-03352019', 665],
        ['de-ni-03352000-03352054', 666], ['de-ni-03462000-03462002', 667],
        ['de-ni-03462000-03462019', 668], ['de-ni-03352000-03352029', 669],
        ['de-ni-03352000-03352047', 670], ['de-ni-03352000-03352024', 671],
        ['de-ni-03459000-03459023', 672], ['de-ni-03353000-03353016', 673],
        ['de-ni-03353000-03353005', 674], ['de-ni-03357000-03357008', 675],
        ['de-ni-03353000-03353002', 676], ['de-ni-03353000-03353020', 677],
        ['de-ni-03353000-03353029', 678], ['de-ni-03357000-03357041', 679],
        ['de-ni-03357000-03357015', 680], ['de-ni-03355000-03355002', 681],
        ['de-ni-03355000-03355034', 682], ['de-ni-03353000-03353010', 683],
        ['de-ni-03355000-03355027', 684], ['de-ni-03358000-03358002', 685],
        ['de-ni-03158000-03158014', 686], ['de-ni-03254000-03254016', 687],
        ['de-ni-03155000-03155013', 688], ['de-ni-03152000-03152013', 689],
        ['de-ni-03255000-03255020', 690], ['de-ni-03255000-03255017', 691],
        ['de-ni-03358000-03358022', 692], ['de-ni-03353000-03353024', 693],
        ['de-ni-03158000-03158011', 694], ['de-ni-03353000-03353003', 695],
        ['de-ni-03353000-03353032', 696], ['de-ni-03353000-03353031', 697],
        ['de-ni-03353000-03353034', 698], ['de-ni-03353000-03353004', 699],
        ['de-ni-03353000-03353042', 700], ['de-ni-03151000-03151011', 701],
        ['de-ni-03453000-03453002', 702], ['de-ni-03357000-03357013', 703],
        ['de-ni-03257000-03257038', 704], ['de-ni-03353000-03353028', 705],
        ['de-ni-03359000-03359006', 706], ['de-ni-03352000-03352055', 707],
        ['de-ni-03352000-03352012', 708], ['de-ni-03451000-03451008', 709],
        ['de-ni-03455000-03455007', 710], ['de-ni-03451000-03451001', 711],
        ['de-ni-03457000-03457011', 712], ['de-ni-03352000-03352022', 713],
        ['de-ni-03352000-03352056', 714], ['de-ni-03359000-03359014', 715],
        ['de-ni-03359000-03359025', 716], ['de-ni-03359000-03359024', 717],
        ['de-ni-03359000-03359017', 718], ['de-ni-03357000-03357016', 719],
        ['de-ni-03357000-03357035', 720], ['de-ni-03352000-03352034', 721],
        ['de-ni-03352000-03352010', 722], ['de-ni-03457000-03457008', 723],
        ['de-ni-03457000-03457003', 724], ['de-ni-03455000-03455027', 725],
        ['de-ni-03462000-03462018', 726], ['de-ni-03462000-03462004', 727],
        ['de-ni-03462000-03462009', 728], ['de-ni-03462000-03462003', 729],
        ['de-ni-03354000-03354026', 730], ['de-ni-03359000-03359019', 731],
        ['de-ni-03352000-03352044', 732], ['de-ni-03357000-03357021', 733],
        ['de-ni-03357000-03357017', 734], ['de-ni-03359000-03359010', 735],
        ['de-ni-03359000-03359034', 736], ['de-ni-03359000-03359007', 737],
        ['de-ni-03254000-03254035', 738], ['de-ni-03254000-03254030', 739],
        ['de-ni-03353000-03353025', 740], ['de-ni-03353000-03353026', 741],
        ['de-ni-03254000-03254027', 742], ['de-ni-03254000-03254004', 743],
        ['de-ni-03254000-03254011', 744], ['de-ni-03254000-03254033', 745],
        ['de-ni-03256000-03256021', 746], ['de-ni-03355000-03355026', 747],
        ['de-ni-03454000-03454026', 748], ['de-ni-03251000-03251006', 749],
        ['de-ni-03360000-03360007', 750], ['de-ni-03251000-03251018', 751],
        ['de-ni-03454000-03454056', 752], ['de-ni-03455000-03455015', 753],
        ['de-ni-03454000-03454025', 754], ['de-ni-03455000-03455020', 755],
        ['de-ni-03251000-03251046', 756], ['de-ni-03251000-03251019', 757],
        ['de-ni-03452000-03452027', 758], ['de-ni-03352000-03352049', 759],
        ['de-ni-03452000-03452011', 760], ['de-ni-03452000-03452026', 761],
        ['de-ni-03452000-03452023', 762], ['de-ni-03452000-03452024', 763],
        ['de-ni-03452000-03452025', 764], ['de-ni-03452000-03452001', 765],
        ['de-ni-03152000-03152016', 766], ['de-ni-03452000-03452007', 767],
        ['de-ni-03462000-03462013', 768], ['de-ni-03453000-03453012', 769],
        ['de-ni-03454000-03454024', 770], ['de-ni-03454000-03454016', 771],
        ['de-ni-03459000-03459010', 772], ['de-ni-03459000-03459028', 773],
        ['de-ni-03361000-03361001', 774], ['de-ni-03460000-03460007', 775],
        ['de-ni-03459000-03459013', 776], ['de-ni-03241000-03241016', 777],
        ['de-ni-03241000-03241003', 778], ['de-ni-03151000-03151041', 779],
        ['de-ni-03361000-03361008', 780], ['de-ni-03360000-03360029', 781],
        ['de-ni-03351000-03351010', 782], ['de-ni-03361000-03361006', 783],
        ['de-ni-03361000-03361013', 784], ['de-ni-03257000-03257020', 785],
        ['de-ni-03360000-03360023', 786], ['de-ni-03257000-03257033', 787],
        ['de-ni-03351000-03351020', 788], ['de-ni-03357000-03357011', 789],
        ['de-ni-03357000-03357040', 790], ['de-ni-03356000-03356011', 791],
        ['de-ni-03357000-03357018', 792], ['de-ni-03357000-03357010', 793],
        ['de-ni-03357000-03357055', 794], ['de-ni-03352000-03352039', 795],
        ['de-ni-03352000-03352027', 796], ['de-ni-03355000-03355006', 797],
        ['de-ni-03355000-03355008', 798], ['de-ni-03359000-03359013', 799],
        ['de-ni-03357000-03357056', 800], ['de-ni-03357000-03357027', 801],
        ['de-ni-03357000-03357004', 802], ['de-ni-03353000-03353039', 803],
        ['de-ni-03156000-03156003', 804], ['de-ni-03153000-03153005', 805],
        ['de-ni-03251000-03251021', 806], ['de-ni-03154000-03154019', 807],
        ['de-ni-03154000-03154023', 808], ['de-ni-03158000-03158027', 809],
        ['de-ni-03158000-03158007', 810], ['de-ni-03158000-03158031', 811],
        ['de-ni-03158000-03158022', 812], ['de-ni-03158000-03158009', 813],
        ['de-ni-03358000-03358015', 814], ['de-ni-03241000-03241018', 815],
        ['de-ni-03351000-03351024', 816], ['de-ni-03358000-03358005', 817],
        ['de-ni-03351000-03351023', 818], ['de-ni-03351000-03351021', 819],
        ['de-ni-03151000-03151034', 820], ['de-ni-03151000-03151027', 821],
        ['de-ni-03158000-03158028', 822], ['de-ni-03153000-03153004', 823],
        ['de-ni-03460000-03460003', 824], ['de-ni-03152000-03152001', 825],
        ['de-ni-03152000-03152012', 826], ['de-ni-03152000-03152027', 827],
        ['de-ni-03152000-03152009', 828], ['de-ni-03152000-03152004', 829],
        ['de-ni-03155000-03155005', 830], ['de-ni-03454000-03454017', 831],
        ['de-ni-03256000-03256002', 832], ['de-ni-03151000-03151036', 833],
        ['de-ni-03151000-03151009', 834], ['de-ni-03151000-03151022', 835],
        ['de-ni-03355000-03355014', 836], ['de-ni-03456000-03456019', 837],
        ['de-ni-03460000-03460004', 838], ['de-ni-03158000-03158038', 839],
        ['de-ni-03158000-03158019', 840], ['de-ni-03158000-03158024', 841],
        ['de-ni-03158000-03158021', 842], ['de-ni-03352000-03352004', 843],
        ['de-ni-03359000-03359004', 844], ['de-ni-03355000-03355024', 845],
        ['de-ni-03359000-03359005', 846], ['de-ni-03355000-03355040', 847],
        ['de-ni-03359000-03359011', 848], ['de-ni-03359000-03359031', 849],
        ['de-ni-03255000-03255023', 850], ['de-ni-03255000-03255022', 851],
        ['de-ni-03254000-03254007', 852], ['de-ni-03255000-03255036', 853],
        ['de-ni-03254000-03254039', 854], ['de-ni-03155000-03155001', 855],
        ['de-ni-03254000-03254034', 856], ['de-ni-03254000-03254023', 857],
        ['de-ni-03254000-03254024', 858], ['de-ni-03352000-03352002', 859],
        ['de-ni-03352000-03352052', 860], ['de-ni-03254000-03254022', 861],
        ['de-ni-03158000-03158004', 862], ['de-ni-03359000-03359001', 863],
        ['de-ni-03359000-03359021', 864], ['de-ni-03254000-03254040', 865],
        ['de-ni-03152000-03152003', 866], ['de-ni-03152000-03152028', 867],
        ['de-ni-03156000-03156001', 868], ['de-ni-03357000-03357009', 869],
        ['de-ni-03254000-03254012', 870], ['de-ni-03254000-03254037', 871],
        ['de-ni-03158000-03158010', 872], ['de-ni-03456000-03456007', 873],
        ['de-ni-03460000-03460002', 874], ['de-ni-03459000-03459032', 875],
        ['de-ni-03355000-03355016', 876], ['de-ni-03359000-03359008', 877],
        ['de-ni-03357000-03357003', 878], ['de-ni-03254000-03254038', 879],
        ['de-ni-03255000-03255031', 880], ['de-ni-03254000-03254025', 881],
        ['de-ni-03151000-03151035', 882], ['de-ni-03151000-03151038', 883],
        ['de-ni-03151000-03151003', 884], ['de-ni-03151000-03151032', 885],
        ['de-ni-03251000-03251035', 886], ['de-ni-03157000-03157004', 887],
        ['de-ni-03257000-03257014', 888], ['de-ni-03151000-03151014', 889],
        ['de-ni-03257000-03257034', 890], ['de-ni-03257000-03257022', 891],
        ['de-ni-03257000-03257012', 892], ['de-ni-03157000-03157002', 893],
        ['de-ni-03157000-03157003', 894], ['de-ni-03251000-03251025', 895],
        ['de-ni-03251000-03251023', 896], ['de-ni-03158000-03158501', 897],
        ['de-ni-03151000-03151037', 898], ['de-ni-03154000-03154011', 899],
        ['de-ni-03151000-03151016', 900], ['de-ni-03158000-03158017', 901],
        ['de-ni-03354000-03354004', 902], ['de-ni-03359000-03359003', 903],
        ['de-ni-03357000-03357014', 904], ['de-ni-03256000-03256017', 905],
        ['de-ni-03241000-03241012', 906], ['de-ni-03351000-03351001', 907],
        ['de-ni-03351000-03351012', 908], ['de-ni-03156000-03156016', 909],
        ['de-ni-03355000-03355019', 910], ['de-ni-03353000-03353036', 911],
        ['de-ni-03353000-03353009', 912], ['de-ni-03353000-03353013', 913],
        ['de-ni-03360000-03360009', 914], ['de-ni-03358000-03358010', 915],
        ['de-ni-03151000-03151501', 916], ['de-ni-03154000-03154015', 917],
        ['de-ni-03154000-03154022', 918], ['de-ni-03154000-03154502', 919],
        ['de-ni-03355000-03355039', 920], ['de-ni-03155000-03155006', 921],
        ['de-ni-03152000-03152007', 922], ['de-ni-03102000-03102000', 923],
        ['de-ni-03256000-03256026', 924], ['de-ni-03256000-03256012', 925],
        ['de-ni-03256000-03256029', 926], ['de-ni-03256000-03256031', 927],
        ['de-ni-03256000-03256020', 928], ['de-ni-03255000-03255018', 929],
        ['de-ni-03357000-03357007', 930], ['de-ni-03256000-03256004', 931],
        ['de-ni-03360000-03360012', 932], ['de-ni-03360000-03360003', 933],
        ['de-ni-03360000-03360026', 934], ['de-ni-03360000-03360017', 935],
        ['de-ni-03360000-03360011', 936], ['de-ni-03360000-03360008', 937],
        ['de-ni-03360000-03360002', 938], ['de-ni-03354000-03354501', 939],
        ['de-ni-03355000-03355041', 940], ['de-ni-03355000-03355036', 941],
        ['de-ni-03251000-03251008', 942], ['de-ni-03251000-03251004', 943],
        ['de-ni-03251000-03251027', 944], ['de-ni-03251000-03251040', 945],
        ['de-ni-03360000-03360001', 946], ['de-ni-03251000-03251034', 947],
        ['de-ni-03251000-03251024', 948], ['de-ni-03153000-03153006', 949],
        ['de-ni-03456000-03456004', 950], ['de-ni-03153000-03153007', 951],
        ['de-ni-03251000-03251012', 952], ['de-ni-03460000-03460009', 953],
        ['de-ni-03453000-03453003', 954], ['de-ni-03158000-03158033', 955],
        ['de-ni-03456000-03456026', 956], ['de-ni-03158000-03158030', 957],
        ['de-ni-03254000-03254005', 958], ['de-ni-03158000-03158012', 959],
        ['de-ni-03254000-03254031', 960], ['de-ni-03158000-03158013', 961],
        ['de-ni-03254000-03254010', 962], ['de-ni-03155000-03155010', 963],
        ['de-ni-03454000-03454027', 964], ['de-ni-03256000-03256033', 965],
        ['de-ni-03256000-03256024', 966], ['de-ni-03256000-03256019', 967],
        ['de-ni-03256000-03256018', 968], ['de-ni-03357000-03357049', 969],
        ['de-ni-03151000-03151030', 970], ['de-ni-03456000-03456002', 971],
        ['de-ni-03359000-03359023', 972], ['de-ni-03154000-03154018', 973],
        ['de-ni-03154000-03154008', 974], ['de-ni-03154000-03154504', 975],
        ['de-ni-03251000-03251013', 976], ['de-ni-03354000-03354019', 977],
        ['de-ni-03154000-03154009', 978], ['de-ni-03354000-03354023', 979],
        ['de-ni-03354000-03354007', 980], ['de-ni-03154000-03154001', 981],
        ['de-ni-03354000-03354015', 982], ['de-ni-03154000-03154016', 983],
        ['de-ni-03458000-03458002', 984], ['de-ni-03354000-03354014', 985],
        ['de-ni-03254000-03254009', 986], ['de-ni-03254000-03254006', 987],
        ['de-ni-03354000-03354021', 988], ['de-ni-03354000-03354010', 989],
        ['de-ni-03354000-03354017', 990], ['de-ni-03354000-03354025', 991],
        ['de-ni-03351000-03351008', 992], ['de-ni-03151000-03151033', 993],
        ['de-ni-03151000-03151029', 994], ['de-ni-03151000-03151010', 995],
        ['de-ni-03151000-03151007', 996], ['de-ni-03256000-03256016', 997],
        ['de-ni-03241000-03241010', 998], ['de-ni-03456000-03456016', 999],
        ['de-ni-03456000-03456020', 1000], ['de-ni-03456000-03456008', 1001],
        ['de-ni-03458000-03458004', 1002], ['de-ni-03458000-03458001', 1003],
        ['de-ni-03355000-03355020', 1004], ['de-ni-03251000-03251007', 1005],
        ['de-ni-03355000-03355035', 1006], ['de-ni-03453000-03453005', 1007],
        ['de-ni-03251000-03251036', 1008], ['de-ni-03456000-03456027', 1009],
        ['de-ni-03459000-03459018', 1010], ['de-ni-03460000-03460005', 1011],
        ['de-ni-03460000-03460006', 1012], ['de-ni-03251000-03251020', 1013],
        ['de-ni-03251000-03251045', 1014], ['de-ni-03454000-03454039', 1015],
        ['de-ni-03454000-03454043', 1016], ['de-ni-03452000-03452002', 1017],
        ['de-ni-03455000-03455021', 1018], ['de-ni-03155000-03155002', 1019],
        ['de-ni-03457000-03457024', 1020], ['de-ni-03152000-03152026', 1021],
        ['de-ni-03457000-03457002', 1022], ['de-ni-03462000-03462007', 1023],
        ['de-ni-03462000-03462014', 1024], ['de-ni-03452000-03452013', 1025],
        ['de-ni-03452000-03452020', 1026], ['de-ni-03405000-03405000', 1027],
        ['de-ni-03451000-03451002', 1028], ['de-ni-03361000-03361009', 1029],
        ['de-ni-03256000-03256034', 1030], ['de-ni-03241000-03241004', 1031],
        ['de-ni-03354000-03354001', 1032], ['de-ni-03460000-03460008', 1033],
        ['de-ni-03155000-03155011', 1034], ['de-ni-03358000-03358501', 1035],
        ['de-ni-03457000-03457012', 1036], ['de-ni-03460000-03460001', 1037],
        ['de-ni-03461000-03461005', 1038], ['de-ni-03461000-03461002', 1039],
        ['de-ni-03359000-03359016', 1040], ['de-ni-03454000-03454014', 1041],
        ['de-ni-03241000-03241013', 1042], [null, 1043]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-ni-all-all.topo.json">Niedersachsen</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
