(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-nw-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-nw-05382000-05382016', 10], ['de-nw-05334000-05334002', 11],
        ['de-nw-05758000-05758028', 12], ['de-nw-05166000-05166012', 13],
        ['de-nw-05166000-05166028', 14], ['de-nw-05374000-05374008', 15],
        ['de-nw-05374000-05374012', 16], ['de-nw-05566000-05566016', 17],
        ['de-nw-05766000-05766036', 18], ['de-nw-05370000-05370040', 19],
        ['de-nw-05362000-05362008', 20], ['de-nw-05362000-05362016', 21],
        ['de-nw-05166000-05166016', 22], ['de-nw-05562000-05562008', 23],
        ['de-nw-05562000-05562028', 24], ['de-nw-05962000-05962028', 25],
        ['de-nw-05374000-05374024', 26], ['de-nw-05566000-05566008', 27],
        ['de-nw-05566000-05566012', 28], ['de-nw-05154000-05154032', 29],
        ['de-nw-05758000-05758012', 30], ['de-nw-05758000-05758016', 31],
        ['de-nw-05758000-05758020', 32], ['de-nw-05754000-05754008', 33],
        ['de-nw-05754000-05754032', 34], ['de-nw-05124000-05124000', 35],
        ['de-nw-05374000-05374036', 36], ['de-nw-05962000-05962012', 37],
        ['de-nw-05120000-05120000', 38], ['de-nw-05954000-05954016', 39],
        ['de-nw-05554000-05554044', 40], ['de-nw-05554000-05554016', 41],
        ['de-nw-05378000-05378016', 42], ['de-nw-05378000-05378008', 43],
        ['de-nw-05766000-05766016', 44], ['de-nw-05378000-05378020', 45],
        ['de-nw-05370000-05370032', 46], ['de-nw-05370000-05370008', 47],
        ['de-nw-05554000-05554052', 48], ['de-nw-05554000-05554036', 49],
        ['de-nw-05554000-05554024', 50], ['de-nw-05554000-05554056', 51],
        ['de-nw-05162000-05162024', 52], ['de-nw-05162000-05162020', 53],
        ['de-nw-05758000-05758024', 54], ['de-nw-05558000-05558036', 55],
        ['de-nw-05562000-05562016', 56], ['de-nw-05558000-05558016', 57],
        ['de-nw-05766000-05766052', 58], ['de-nw-05158000-05158020', 59],
        ['de-nw-05762000-05762008', 60], ['de-nw-05762000-05762016', 61],
        ['de-nw-05966000-05966008', 62], ['de-nw-05374000-05374004', 63],
        ['de-nw-05566000-05566052', 64], ['de-nw-05566000-05566084', 65],
        ['de-nw-05334000-05334012', 66], ['de-nw-05366000-05366020', 67],
        ['de-nw-05366000-05366032', 68], ['de-nw-05382000-05382020', 69],
        ['de-nw-05382000-05382040', 70], ['de-nw-05362000-05362012', 71],
        ['de-nw-05382000-05382012', 72], ['de-nw-05334000-05334020', 73],
        ['de-nw-05762000-05762004', 74], ['de-nw-05774000-05774028', 75],
        ['de-nw-05774000-05774032', 76], ['de-nw-05754000-05754040', 77],
        ['de-nw-05770000-05770012', 78], ['de-nw-05766000-05766044', 79],
        ['de-nw-05954000-05954020', 80], ['de-nw-05954000-05954032', 81],
        ['de-nw-05954000-05954012', 82], ['de-nw-05774000-05774040', 83],
        ['de-nw-05774000-05774036', 84], ['de-nw-05954000-05954028', 85],
        ['de-nw-05382000-05382060', 86], ['de-nw-05154000-05154020', 87],
        ['de-nw-05154000-05154048', 88], ['de-nw-05554000-05554004', 89],
        ['de-nw-05566000-05566060', 90], ['de-nw-05154000-05154060', 91],
        ['de-nw-05970000-05970044', 92], ['de-nw-05378000-05378032', 93],
        ['de-nw-05966000-05966016', 94], ['de-nw-05970000-05970012', 95],
        ['de-nw-05315000-05315000', 96], ['de-nw-05158000-05158026', 97],
        ['de-nw-05382000-05382068', 98], ['de-nw-05382000-05382056', 99],
        ['de-nw-05966000-05966028', 100], ['de-nw-05970000-05970040', 101],
        ['de-nw-05366000-05366040', 102], ['de-nw-05382000-05382064', 103],
        ['de-nw-05970000-05970032', 104], ['de-nw-05382000-05382024', 105],
        ['de-nw-05970000-05970024', 106], ['de-nw-05958000-05958016', 107],
        ['de-nw-05966000-05966020', 108], ['de-nw-05970000-05970004', 109],
        ['de-nw-05966000-05966024', 110], ['de-nw-05974000-05974036', 111],
        ['de-nw-05958000-05958012', 112], ['de-nw-05774000-05774016', 113],
        ['de-nw-05958000-05958004', 114], ['de-nw-05974000-05974044', 115],
        ['de-nw-05170000-05170008', 116], ['de-nw-05112000-05112000', 117],
        ['de-nw-05158000-05158028', 118], ['de-nw-05566000-05566028', 119],
        ['de-nw-05566000-05566020', 120], ['de-nw-05382000-05382008', 121],
        ['de-nw-05314000-05314000', 122], ['de-nw-05382000-05382028', 123],
        ['de-nw-05914000-05914000', 124], ['de-nw-05954000-05954008', 125],
        ['de-nw-05154000-05154064', 126], ['de-nw-05154000-05154056', 127],
        ['de-nw-05154000-05154016', 128], ['de-nw-05154000-05154040', 129],
        ['de-nw-05366000-05366036', 130], ['de-nw-05362000-05362024', 131],
        ['de-nw-05758000-05758004', 132], ['de-nw-05758000-05758032', 133],
        ['de-nw-05766000-05766064', 134], ['de-nw-05774000-05774024', 135],
        ['de-nw-05754000-05754044', 136], ['de-nw-05962000-05962036', 137],
        ['de-nw-05962000-05962032', 138], ['de-nw-05962000-05962060', 139],
        ['de-nw-05770000-05770008', 140], ['de-nw-05166000-05166008', 141],
        ['de-nw-05154000-05154028', 142], ['de-nw-05358000-05358004', 143],
        ['de-nw-05334000-05334004', 144], ['de-nw-05554000-05554012', 145],
        ['de-nw-05554000-05554048', 146], ['de-nw-05554000-05554040', 147],
        ['de-nw-05554000-05554060', 148], ['de-nw-05554000-05554068', 149],
        ['de-nw-05974000-05974056', 150], ['de-nw-05978000-05978012', 151],
        ['de-nw-05978000-05978016', 152], ['de-nw-05362000-05362036', 153],
        ['de-nw-05166000-05166032', 154], ['de-nw-05166000-05166036', 155],
        ['de-nw-05362000-05362032', 156], ['de-nw-05978000-05978024', 157],
        ['de-nw-05978000-05978020', 158], ['de-nw-05158000-05158008', 159],
        ['de-nw-05158000-05158004', 160], ['de-nw-05558000-05558044', 161],
        ['de-nw-05558000-05558028', 162], ['de-nw-05358000-05358008', 163],
        ['de-nw-05358000-05358040', 164], ['de-nw-05962000-05962040', 165],
        ['de-nw-05170000-05170024', 166], ['de-nw-05170000-05170020', 167],
        ['de-nw-05962000-05962008', 168], ['de-nw-05378000-05378012', 169],
        ['de-nw-05378000-05378024', 170], ['de-nw-05374000-05374052', 171],
        ['de-nw-05154000-05154044', 172], ['de-nw-05158000-05158016', 173],
        ['de-nw-05162000-05162028', 174], ['de-nw-05362000-05362004', 175],
        ['de-nw-05162000-05162012', 176], ['de-nw-05358000-05358016', 177],
        ['de-nw-05358000-05358020', 178], ['de-nw-05358000-05358024', 179],
        ['de-nw-05358000-05358048', 180], ['de-nw-05566000-05566036', 181],
        ['de-nw-05558000-05558040', 182], ['de-nw-05566000-05566024', 183],
        ['de-nw-05334000-05334028', 184], ['de-nw-05334000-05334032', 185],
        ['de-nw-05362000-05362020', 186], ['de-nw-05974000-05974028', 187],
        ['de-nw-05358000-05358060', 188], ['de-nw-05358000-05358044', 189],
        ['de-nw-05970000-05970036', 190], ['de-nw-05154000-05154012', 191],
        ['de-nw-05170000-05170040', 192], ['de-nw-05766000-05766040', 193],
        ['de-nw-05766000-05766048', 194], ['de-nw-05358000-05358032', 195],
        ['de-nw-05978000-05978036', 196], ['de-nw-05974000-05974052', 197],
        ['de-nw-05974000-05974040', 198], ['de-nw-05774000-05774020', 199],
        ['de-nw-05170000-05170052', 200], ['de-nw-05154000-05154024', 201],
        ['de-nw-05566000-05566040', 202], ['de-nw-05170000-05170004', 203],
        ['de-nw-05170000-05170048', 204], ['de-nw-05382000-05382076', 205],
        ['de-nw-05374000-05374028', 206], ['de-nw-05366000-05366044', 207],
        ['de-nw-05358000-05358012', 208], ['de-nw-05566000-05566032', 209],
        ['de-nw-05566000-05566044', 210], ['de-nw-05116000-05116000', 211],
        ['de-nw-05166000-05166024', 212], ['de-nw-05166000-05166020', 213],
        ['de-nw-05962000-05962044', 214], ['de-nw-05962000-05962056', 215],
        ['de-nw-05170000-05170012', 216], ['de-nw-05554000-05554032', 217],
        ['de-nw-05334000-05334024', 218], ['de-nw-05382000-05382044', 219],
        ['de-nw-05154000-05154052', 220], ['de-nw-05566000-05566072', 221],
        ['de-nw-05170000-05170028', 222], ['de-nw-05766000-05766008', 223],
        ['de-nw-05711000-05711000', 224], ['de-nw-05122000-05122000', 225],
        ['de-nw-05158000-05158032', 226], ['de-nw-05978000-05978008', 227],
        ['de-nw-05113000-05113000', 228], ['de-nw-05382000-05382048', 229],
        ['de-nw-05366000-05366004', 230], ['de-nw-05382000-05382004', 231],
        ['de-nw-05370000-05370012', 232], ['de-nw-05334000-05334008', 233],
        ['de-nw-05358000-05358036', 234], ['de-nw-05366000-05366012', 235],
        ['de-nw-05162000-05162004', 236], ['de-nw-05770000-05770024', 237],
        ['de-nw-05770000-05770004', 238], ['de-nw-05362000-05362040', 239],
        ['de-nw-05962000-05962016', 240], ['de-nw-05962000-05962048', 241],
        ['de-nw-05766000-05766020', 242], ['de-nw-05766000-05766004', 243],
        ['de-nw-05766000-05766056', 244], ['de-nw-05762000-05762024', 245],
        ['de-nw-05762000-05762028', 246], ['de-nw-05766000-05766060', 247],
        ['de-nw-05766000-05766032', 248], ['de-nw-05770000-05770036', 249],
        ['de-nw-05558000-05558008', 250], ['de-nw-05558000-05558020', 251],
        ['de-nw-05114000-05114000', 252], ['de-nw-05913000-05913000', 253],
        ['de-nw-05562000-05562036', 254], ['de-nw-05562000-05562004', 255],
        ['de-nw-05978000-05978032', 256], ['de-nw-05558000-05558024', 257],
        ['de-nw-05974000-05974016', 258], ['de-nw-05974000-05974020', 259],
        ['de-nw-05566000-05566068', 260], ['de-nw-05754000-05754028', 261],
        ['de-nw-05754000-05754024', 262], ['de-nw-05570000-05570028', 263],
        ['de-nw-05570000-05570036', 264], ['de-nw-05754000-05754016', 265],
        ['de-nw-05754000-05754012', 266], ['de-nw-05562000-05562012', 267],
        ['de-nw-05374000-05374048', 268], ['de-nw-05382000-05382036', 269],
        ['de-nw-05962000-05962004', 270], ['de-nw-05374000-05374032', 271],
        ['de-nw-05382000-05382052', 272], ['de-nw-05374000-05374044', 273],
        ['de-nw-05558000-05558032', 274], ['de-nw-05566000-05566004', 275],
        ['de-nw-05758000-05758036', 276], ['de-nw-05117000-05117000', 277],
        ['de-nw-05962000-05962052', 278], ['de-nw-05774000-05774012', 279],
        ['de-nw-05974000-05974032', 280], ['de-nw-05974000-05974008', 281],
        ['de-nw-05974000-05974024', 282], ['de-nw-05374000-05374016', 283],
        ['de-nw-05334000-05334016', 284], ['de-nw-05370000-05370028', 285],
        ['de-nw-05958000-05958044', 286], ['de-nw-05170000-05170016', 287],
        ['de-nw-05512000-05512000', 288], ['de-nw-05170000-05170036', 289],
        ['de-nw-05566000-05566056', 290], ['de-nw-05758000-05758008', 291],
        ['de-nw-05966000-05966004', 292], ['de-nw-05754000-05754036', 293],
        ['de-nw-05958000-05958040', 294], ['de-nw-05958000-05958008', 295],
        ['de-nw-05958000-05958036', 296], ['de-nw-05970000-05970016', 297],
        ['de-nw-05554000-05554020', 298], ['de-nw-05554000-05554064', 299],
        ['de-nw-05762000-05762020', 300], ['de-nw-05370000-05370016', 301],
        ['de-nw-05370000-05370024', 302], ['de-nw-05370000-05370020', 303],
        ['de-nw-05382000-05382032', 304], ['de-nw-05513000-05513000', 305],
        ['de-nw-05911000-05911000', 306], ['de-nw-05570000-05570024', 307],
        ['de-nw-05515000-05515000', 308], ['de-nw-05558000-05558004', 309],
        ['de-nw-05770000-05770016', 310], ['de-nw-05570000-05570032', 311],
        ['de-nw-05570000-05570004', 312], ['de-nw-05158000-05158036', 313],
        ['de-nw-05158000-05158012', 314], ['de-nw-05915000-05915000', 315],
        ['de-nw-05154000-05154004', 316], ['de-nw-05754000-05754052', 317],
        ['de-nw-05366000-05366016', 318], ['de-nw-05366000-05366028', 319],
        ['de-nw-05566000-05566092', 320], ['de-nw-05566000-05566088', 321],
        ['de-nw-05566000-05566048', 322], ['de-nw-05358000-05358028', 323],
        ['de-nw-05358000-05358052', 324], ['de-nw-05566000-05566080', 325],
        ['de-nw-05762000-05762012', 326], ['de-nw-05316000-05316000', 327],
        ['de-nw-05378000-05378004', 328], ['de-nw-05370000-05370036', 329],
        ['de-nw-05370000-05370004', 330], ['de-nw-05358000-05358056', 331],
        ['de-nw-05111000-05111000', 332], ['de-nw-05162000-05162008', 333],
        ['de-nw-05570000-05570048', 334], ['de-nw-05570000-05570008', 335],
        ['de-nw-05158000-05158024', 336], ['de-nw-05962000-05962020', 337],
        ['de-nw-05562000-05562032', 338], ['de-nw-05754000-05754048', 339],
        ['de-nw-05554000-05554028', 340], ['de-nw-05570000-05570012', 341],
        ['de-nw-05570000-05570020', 342], ['de-nw-05770000-05770032', 343],
        ['de-nw-05570000-05570040', 344], ['de-nw-05974000-05974012', 345],
        ['de-nw-05374000-05374040', 346], ['de-nw-05762000-05762032', 347],
        ['de-nw-05774000-05774004', 348], ['de-nw-05954000-05954024', 349],
        ['de-nw-05170000-05170032', 350], ['de-nw-05374000-05374020', 351],
        ['de-nw-05558000-05558012', 352], ['de-nw-05774000-05774008', 353],
        ['de-nw-05954000-05954004', 354], ['de-nw-05570000-05570052', 355],
        ['de-nw-05754000-05754020', 356], ['de-nw-05334000-05334036', 357],
        ['de-nw-05570000-05570044', 358], ['de-nw-05562000-05562014', 359],
        ['de-nw-05162000-05162022', 360], ['de-nw-05978000-05978040', 361],
        ['de-nw-05562000-05562024', 362], ['de-nw-05916000-05916000', 363],
        ['de-nw-05562000-05562020', 364], ['de-nw-05962000-05962024', 365],
        ['de-nw-05154000-05154036', 366], ['de-nw-05958000-05958020', 367],
        ['de-nw-05958000-05958048', 368], ['de-nw-05754000-05754004', 369],
        ['de-nw-05770000-05770028', 370], ['de-nw-05970000-05970028', 371],
        ['de-nw-05970000-05970008', 372], ['de-nw-05766000-05766012', 373],
        ['de-nw-05958000-05958024', 374], ['de-nw-05762000-05762036', 375],
        ['de-nw-05154000-05154008', 376], ['de-nw-05366000-05366008', 377],
        ['de-nw-05554000-05554008', 378], ['de-nw-05382000-05382072', 379],
        ['de-nw-05770000-05770044', 380], ['de-nw-05566000-05566096', 381],
        ['de-nw-05766000-05766028', 382], ['de-nw-05958000-05958028', 383],
        ['de-nw-05958000-05958032', 384], ['de-nw-05166000-05166004', 385],
        ['de-nw-05770000-05770040', 386], ['de-nw-05362000-05362028', 387],
        ['de-nw-05566000-05566064', 388], ['de-nw-05366000-05366024', 389],
        ['de-nw-05966000-05966012', 390], ['de-nw-05162000-05162016', 391],
        ['de-nw-05770000-05770020', 392], ['de-nw-05170000-05170044', 393],
        ['de-nw-05974000-05974004', 394], ['de-nw-05974000-05974048', 395],
        ['de-nw-05119000-05119000', 396], ['de-nw-05978000-05978028', 397],
        ['de-nw-05954000-05954036', 398], ['de-nw-05766000-05766024', 399],
        ['de-nw-05570000-05570016', 400], ['de-nw-05566000-05566076', 401],
        ['de-nw-05970000-05970020', 402], ['de-nw-05978000-05978004', 403],
        ['de-nw-05378000-05378028', 404], ['de-nw-05762000-05762040', 405],
        [null, 406]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-nw-all-all.topo.json">Nordrhein-Westfalen</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
