(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-sn-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-sn-14627000-14627090', 10], ['de-sn-14627000-14627120', 11],
        ['de-sn-14625000-14625480', 12], ['de-sn-14625000-14625010', 13],
        ['de-sn-14627000-14627200', 14], ['de-sn-14627000-14627190', 15],
        ['de-sn-14524000-14524240', 16], ['de-sn-14627000-14627020', 17],
        ['de-sn-14521000-14521140', 18], ['de-sn-14625000-14625640', 19],
        ['de-sn-14625000-14625330', 20], ['de-sn-14628000-14628070', 21],
        ['de-sn-14628000-14628270', 22], ['de-sn-14625000-14625340', 23],
        ['de-sn-14625000-14625610', 24], ['de-sn-14729000-14729250', 25],
        ['de-sn-14729000-14729070', 26], ['de-sn-14625000-14625600', 27],
        ['de-sn-14625000-14625320', 28], ['de-sn-14627000-14627050', 29],
        ['de-sn-14627000-14627340', 30], ['de-sn-14625000-14625040', 31],
        ['de-sn-14625000-14625100', 32], ['de-sn-14625000-14625110', 33],
        ['de-sn-14625000-14625530', 34], ['de-sn-14729000-14729060', 35],
        ['de-sn-14522000-14522010', 36], ['de-sn-14522000-14522070', 37],
        ['de-sn-14523000-14523330', 38], ['de-sn-14521000-14521030', 39],
        ['de-sn-14521000-14521530', 40], ['de-sn-14523000-14523320', 41],
        ['de-sn-14523000-14523050', 42], ['de-sn-14523000-14523420', 43],
        ['de-sn-14625000-14625470', 44], ['de-sn-14625000-14625080', 45],
        ['de-sn-14625000-14625540', 46], ['de-sn-14625000-14625420', 47],
        ['de-sn-14625000-14625350', 48], ['de-sn-14626000-14626600', 49],
        ['de-sn-14626000-14626100', 50], ['de-sn-14625000-14625440', 51],
        ['de-sn-14521000-14521280', 52], ['de-sn-14521000-14521470', 53],
        ['de-sn-14626000-14626200', 54], ['de-sn-14626000-14626160', 55],
        ['de-sn-14625000-14625280', 56], ['de-sn-14625000-14625500', 57],
        ['de-sn-14626000-14626480', 58], ['de-sn-14626000-14626460', 59],
        ['de-sn-14626000-14626590', 60], ['de-sn-14524000-14524270', 61],
        ['de-sn-14523000-14523460', 62], ['de-sn-14523000-14523290', 63],
        ['de-sn-14523000-14523130', 64], ['de-sn-14523000-14523370', 65],
        ['de-sn-14523000-14523200', 66], ['de-sn-14729000-14729090', 67],
        ['de-sn-14729000-14729320', 68], ['de-sn-14729000-14729110', 69],
        ['de-sn-14729000-14729330', 70], ['de-sn-14729000-14729050', 71],
        ['de-sn-14524000-14524180', 72], ['de-sn-14625000-14625170', 73],
        ['de-sn-14625000-14625140', 74], ['de-sn-14524000-14524060', 75],
        ['de-sn-14626000-14626440', 76], ['de-sn-14626000-14626320', 77],
        ['de-sn-14628000-14628390', 78], ['de-sn-14628000-14628370', 79],
        ['de-sn-14626000-14626020', 80], ['de-sn-14626000-14626350', 81],
        ['de-sn-14626000-14626580', 82], ['de-sn-14626000-14626190', 83],
        ['de-sn-14625000-14625510', 84], ['de-sn-14521000-14521640', 85],
        ['de-sn-14521000-14521710', 86], ['de-sn-14625000-14625410', 87],
        ['de-sn-14522000-14522220', 88], ['de-sn-14627000-14627230', 89],
        ['de-sn-14729000-14729080', 90], ['de-sn-14522000-14522600', 91],
        ['de-sn-14522000-14522510', 92], ['de-sn-14521000-14521440', 93],
        ['de-sn-14521000-14521130', 94], ['de-sn-14521000-14521360', 95],
        ['de-sn-14521000-14521270', 96], ['de-sn-14521000-14521090', 97],
        ['de-sn-14521000-14521510', 98], ['de-sn-14521000-14521180', 99],
        ['de-sn-14521000-14521600', 100], ['de-sn-14524000-14524290', 101],
        ['de-sn-14729000-14729020', 102], ['de-sn-14524000-14524040', 103],
        ['de-sn-14729000-14729190', 104], ['de-sn-14729000-14729260', 105],
        ['de-sn-14628000-14628020', 106], ['de-sn-14628000-14628010', 107],
        ['de-sn-14628000-14628130', 108], ['de-sn-14729000-14729040', 109],
        ['de-sn-14729000-14729410', 110], ['de-sn-14524000-14524110', 111],
        ['de-sn-14523000-14523170', 112], ['de-sn-14627000-14627010', 113],
        ['de-sn-14627000-14627150', 114], ['de-sn-14729000-14729030', 115],
        ['de-sn-14523000-14523380', 116], ['de-sn-14521000-14521540', 117],
        ['de-sn-14628000-14628320', 118], ['de-sn-14628000-14628030', 119],
        ['de-sn-14626000-14626370', 120], ['de-sn-14522000-14522020', 121],
        ['de-sn-14626000-14626210', 122], ['de-sn-14523000-14523410', 123],
        ['de-sn-14522000-14522320', 124], ['de-sn-14626000-14626280', 125],
        ['de-sn-14626000-14626530', 126], ['de-sn-14625000-14625430', 127],
        ['de-sn-14627000-14627220', 128], ['de-sn-14625000-14625220', 129],
        ['de-sn-14521000-14521290', 130], ['de-sn-14524000-14524160', 131],
        ['de-sn-14729000-14729160', 132], ['de-sn-14524000-14524020', 133],
        ['de-sn-14524000-14524280', 134], ['de-sn-14521000-14521590', 135],
        ['de-sn-14521000-14521420', 136], ['de-sn-14521000-14521620', 137],
        ['de-sn-14522000-14522200', 138], ['de-sn-14521000-14521120', 139],
        ['de-sn-14522000-14522190', 140], ['de-sn-14522000-14522290', 141],
        ['de-sn-14521000-14521250', 142], ['de-sn-14521000-14521630', 143],
        ['de-sn-14522000-14522390', 144], ['de-sn-14524000-14524230', 145],
        ['de-sn-14524000-14524010', 146], ['de-sn-14524000-14524140', 147],
        ['de-sn-14524000-14524210', 148], ['de-sn-14729000-14729290', 149],
        ['de-sn-14522000-14522580', 150], ['de-sn-14521000-14521240', 151],
        ['de-sn-14524000-14524120', 152], ['de-sn-14522000-14522340', 153],
        ['de-sn-14522000-14522110', 154], ['de-sn-14729000-14729100', 155],
        ['de-sn-14729000-14729170', 156], ['de-sn-14729000-14729430', 157],
        ['de-sn-14626000-14626570', 158], ['de-sn-14626000-14626240', 159],
        ['de-sn-14626000-14626450', 160], ['de-sn-14626000-14626230', 161],
        ['de-sn-14729000-14729220', 162], ['de-sn-14625000-14625590', 163],
        ['de-sn-14625000-14625380', 164], ['de-sn-14628000-14628260', 165],
        ['de-sn-14523000-14523360', 166], ['de-sn-14523000-14523430', 167],
        ['de-sn-14522000-14522470', 168], ['de-sn-14522000-14522520', 169],
        ['de-sn-14628000-14628205', 170], ['de-sn-14628000-14628400', 171],
        ['de-sn-14626000-14626050', 172], ['de-sn-14626000-14626310', 173],
        ['de-sn-14524000-14524170', 174], ['de-sn-14523000-14523150', 175],
        ['de-sn-14523000-14523280', 176], ['de-sn-14625000-14625030', 177],
        ['de-sn-14626000-14626060', 178], ['de-sn-14625000-14625160', 179],
        ['de-sn-14521000-14521460', 180], ['de-sn-14524000-14524200', 181],
        ['de-sn-14524000-14524250', 182], ['de-sn-14522000-14522050', 183],
        ['de-sn-14522000-14522430', 184], ['de-sn-14522000-14522230', 185],
        ['de-sn-14628000-14628380', 186], ['de-sn-14627000-14627290', 187],
        ['de-sn-14522000-14522620', 188], ['de-sn-14627000-14627130', 189],
        ['de-sn-14522000-14522450', 190], ['de-sn-14627000-14627080', 191],
        ['de-sn-14626000-14626610', 192], ['de-sn-14626000-14626140', 193],
        ['de-sn-14626000-14626170', 194], ['de-sn-14627000-14627310', 195],
        ['de-sn-14627000-14627140', 196], ['de-sn-14524000-14524220', 197],
        ['de-sn-14522000-14522460', 198], ['de-sn-14729000-14729230', 199],
        ['de-sn-14729000-14729150', 200], ['de-sn-14522000-14522490', 201],
        ['de-sn-14522000-14522280', 202], ['de-sn-14625000-14625200', 203],
        ['de-sn-14626000-14626400', 204], ['de-sn-14524000-14524260', 205],
        ['de-sn-14524000-14524190', 206], ['de-sn-14628000-14628140', 207],
        ['de-sn-14627000-14627360', 208], ['de-sn-14521000-14521220', 209],
        ['de-sn-14521000-14521690', 210], ['de-sn-14521000-14521010', 211],
        ['de-sn-14521000-14521150', 212], ['de-sn-14523000-14523270', 213],
        ['de-sn-14521000-14521380', 214], ['de-sn-14521000-14521160', 215],
        ['de-sn-14521000-14521610', 216], ['de-sn-14521000-14521080', 217],
        ['de-sn-14521000-14521700', 218], ['de-sn-14521000-14521550', 219],
        ['de-sn-14521000-14521340', 220], ['de-sn-14521000-14521400', 221],
        ['de-sn-14521000-14521060', 222], ['de-sn-14523000-14523160', 223],
        ['de-sn-14523000-14523110', 224], ['de-sn-14625000-14625050', 225],
        ['de-sn-14521000-14521100', 226], ['de-sn-14524000-14524150', 227],
        ['de-sn-14524000-14524130', 228], ['de-sn-14524000-14524320', 229],
        ['de-sn-14626000-14626085', 230], ['de-sn-14521000-14521200', 231],
        ['de-sn-14523000-14523250', 232], ['de-sn-14729000-14729380', 233],
        ['de-sn-14625000-14625290', 234], ['de-sn-14625000-14625090', 235],
        ['de-sn-14729000-14729370', 236], ['de-sn-14627000-14627040', 237],
        ['de-sn-14523000-14523010', 238], ['de-sn-14627000-14627180', 239],
        ['de-sn-14522000-14522480', 240], ['de-sn-14521000-14521110', 241],
        ['de-sn-14521000-14521170', 242], ['de-sn-14522000-14522530', 243],
        ['de-sn-14522000-14522360', 244], ['de-sn-14628000-14628250', 245],
        ['de-sn-14628000-14628040', 246], ['de-sn-14522000-14522150', 247],
        ['de-sn-14522000-14522420', 248], ['de-sn-14628000-14628300', 249],
        ['de-sn-14729000-14729140', 250], ['de-sn-14628000-14628220', 251],
        ['de-sn-14524000-14524070', 252], ['de-sn-14626000-14626245', 253],
        ['de-sn-14729000-14729010', 254], ['de-sn-14522000-14522260', 255],
        ['de-sn-14522000-14522060', 256], ['de-sn-14522000-14522350', 257],
        ['de-sn-14522000-14522550', 258], ['de-sn-14522000-14522540', 259],
        ['de-sn-14522000-14522300', 260], ['de-sn-14626000-14626010', 261],
        ['de-sn-14627000-14627170', 262], ['de-sn-14521000-14521020', 263],
        ['de-sn-14521000-14521560', 264], ['de-sn-14626000-14626180', 265],
        ['de-sn-14521000-14521450', 266], ['de-sn-14627000-14627280', 267],
        ['de-sn-14626000-14626270', 268], ['de-sn-14522000-14522440', 269],
        ['de-sn-14626000-14626030', 270], ['de-sn-14626000-14626300', 271],
        ['de-sn-14626000-14626470', 272], ['de-sn-14626000-14626540', 273],
        ['de-sn-14729000-14729340', 274], ['de-sn-14626000-14626510', 275],
        ['de-sn-14522000-14522370', 276], ['de-sn-14522000-14522080', 277],
        ['de-sn-14729000-14729360', 278], ['de-sn-14524000-14524080', 279],
        ['de-sn-14524000-14524330', 280], ['de-sn-14524000-14524050', 281],
        ['de-sn-14524000-14524030', 282], ['de-sn-14626000-14626330', 283],
        ['de-sn-14626000-14626520', 284], ['de-sn-14524000-14524090', 285],
        ['de-sn-14521000-14521370', 286], ['de-sn-14522000-14522380', 287],
        ['de-sn-14524000-14524310', 288], ['de-sn-14522000-14522330', 289],
        ['de-sn-14521000-14521210', 290], ['de-sn-14521000-14521230', 291],
        ['de-sn-14521000-14521040', 292], ['de-sn-14628000-14628310', 293],
        ['de-sn-14628000-14628190', 294], ['de-sn-14521000-14521490', 295],
        ['de-sn-14628000-14628210', 296], ['de-sn-14626000-14626070', 297],
        ['de-sn-14522000-14522500', 298], ['de-sn-14521000-14521050', 299],
        ['de-sn-14626000-14626390', 300], ['de-sn-14521000-14521390', 301],
        ['de-sn-14521000-14521670', 302], ['de-sn-14523000-14523190', 303],
        ['de-sn-14523000-14523340', 304], ['de-sn-14523000-14523100', 305],
        ['de-sn-14523000-14523260', 306], ['de-sn-14626000-14626410', 307],
        ['de-sn-14625000-14625560', 308], ['de-sn-14625000-14625525', 309],
        ['de-sn-14522000-14522120', 310], ['de-sn-14626000-14626150', 311],
        ['de-sn-14522000-14522590', 312], ['de-sn-14522000-14522170', 313],
        ['de-sn-14625000-14625630', 314], ['de-sn-14627000-14627100', 315],
        ['de-sn-14627000-14627210', 316], ['de-sn-14522000-14522090', 317],
        ['de-sn-14522000-14522250', 318], ['de-sn-14729000-14729300', 319],
        ['de-sn-14729000-14729400', 320], ['de-sn-14628000-14628170', 321],
        ['de-sn-14521000-14521260', 322], ['de-sn-14521000-14521570', 323],
        ['de-sn-14521000-14521500', 324], ['de-sn-14628000-14628350', 325],
        ['de-sn-14628000-14628150', 326], ['de-sn-14628000-14628060', 327],
        ['de-sn-14511000-14511000', 328], ['de-sn-14522000-14522140', 329],
        ['de-sn-14626000-14626250', 330], ['de-sn-14521000-14521310', 331],
        ['de-sn-14523000-14523450', 332], ['de-sn-14523000-14523440', 333],
        ['de-sn-14628000-14628410', 334], ['de-sn-14522000-14522240', 335],
        ['de-sn-14522000-14522035', 336], ['de-sn-14522000-14522180', 337],
        ['de-sn-14628000-14628360', 338], ['de-sn-14523000-14523020', 339],
        ['de-sn-14625000-14625490', 340], ['de-sn-14625000-14625060', 341],
        ['de-sn-14628000-14628100', 342], ['de-sn-14625000-14625130', 343],
        ['de-sn-14521000-14521520', 344], ['de-sn-14628000-14628080', 345],
        ['de-sn-14522000-14522400', 346], ['de-sn-14521000-14521430', 347],
        ['de-sn-14625000-14625150', 348], ['de-sn-14523000-14523365', 349],
        ['de-sn-14523000-14523350', 350], ['de-sn-14523000-14523230', 351],
        ['de-sn-14523000-14523080', 352], ['de-sn-14523000-14523245', 353],
        ['de-sn-14625000-14625360', 354], ['de-sn-14626000-14626260', 355],
        ['de-sn-14625000-14625190', 356], ['de-sn-14625000-14625020', 357],
        ['de-sn-14626000-14626120', 358], ['de-sn-14626000-14626560', 359],
        ['de-sn-14523000-14523090', 360], ['de-sn-14523000-14523120', 361],
        ['de-sn-14627000-14627070', 362], ['de-sn-14625000-14625450', 363],
        ['de-sn-14625000-14625180', 364], ['de-sn-14625000-14625270', 365],
        ['de-sn-14627000-14627260', 366], ['de-sn-14713000-14713000', 367],
        ['de-sn-14729000-14729350', 368], ['de-sn-14625000-14625300', 369],
        ['de-sn-14625000-14625230', 370], ['de-sn-14626000-14626290', 371],
        ['de-sn-14522000-14522570', 372], ['de-sn-14628000-14628050', 373],
        ['de-sn-14628000-14628110', 374], ['de-sn-14612000-14612000', 375],
        ['de-sn-14625000-14625390', 376], ['de-sn-14625000-14625460', 377],
        ['de-sn-14523000-14523310', 378], ['de-sn-14729000-14729245', 379],
        ['de-sn-14627000-14627250', 380], ['de-sn-14626000-14626420', 381],
        ['de-sn-14522000-14522310', 382], ['de-sn-14628000-14628340', 383],
        ['de-sn-14628000-14628330', 384], ['de-sn-14625000-14625550', 385],
        ['de-sn-14626000-14626430', 386], ['de-sn-14627000-14627060', 387],
        ['de-sn-14523000-14523030', 388], ['de-sn-14627000-14627240', 389],
        ['de-sn-14625000-14625570', 390], ['de-sn-14627000-14627270', 391],
        ['de-sn-14521000-14521330', 392], ['de-sn-14521000-14521320', 393],
        ['de-sn-14628000-14628230', 394], ['de-sn-14626000-14626110', 395],
        ['de-sn-14729000-14729270', 396], ['de-sn-14627000-14627110', 397],
        ['de-sn-14523000-14523060', 398], ['de-sn-14522000-14522210', 399],
        ['de-sn-14625000-14625120', 400], ['de-sn-14626000-14626490', 401],
        ['de-sn-14625000-14625310', 402], ['de-sn-14625000-14625250', 403],
        ['de-sn-14625000-14625580', 404], ['de-sn-14524000-14524300', 405],
        ['de-sn-14627000-14627030', 406], ['de-sn-14524000-14524100', 407],
        ['de-sn-14523000-14523300', 408], ['de-sn-14523000-14523040', 409],
        ['de-sn-14521000-14521410', 410], ['de-sn-14628000-14628240', 411],
        ['de-sn-14626000-14626500', 412], ['de-sn-14628000-14628090', 413],
        ['de-sn-14521000-14521355', 414], ['de-sn-14625000-14625370', 415],
        ['de-sn-14628000-14628160', 416], ['de-sn-14625000-14625240', 417],
        [null, 418]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-sn-all-all.topo.json">Sachsen</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
