(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-st-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-st-14730000-14730190', 10], ['de-st-15084000-15084012', 11],
        ['de-st-15088000-15088295', 12], ['de-st-15082000-15082256', 13],
        ['de-st-15087000-15087010', 14], ['de-st-14730000-14730045', 15],
        ['de-st-15083000-15083495', 16], ['de-st-15083000-15083020', 17],
        ['de-st-15081000-15081026', 18], ['de-st-15081000-15081045', 19],
        ['de-st-15089000-15089043', 20], ['de-st-15089000-15089041', 21],
        ['de-st-14730000-14730050', 22], ['de-st-15001000-15001000', 23],
        ['de-st-15082000-15082301', 24], ['de-st-15082000-15082241', 25],
        ['de-st-15089000-15089042', 26], ['de-st-15083000-15083490', 27],
        ['de-st-15088000-15088355', 28], ['de-st-15084000-15084250', 29],
        ['de-st-15087000-15087075', 30], ['de-st-15087000-15087130', 31],
        ['de-st-15087000-15087031', 32], ['de-st-15087000-15087165', 33],
        ['de-st-15088000-15088216', 34], ['de-st-15083000-15083485', 35],
        ['de-st-15090000-15090180', 36], ['de-st-15090000-15090245', 37],
        ['de-st-15088000-15088030', 38], ['de-st-15083000-15083323', 39],
        ['de-st-15088000-15088250', 40], ['de-st-15083000-15083230', 41],
        ['de-st-15085000-15085145', 42], ['de-st-15083000-15083115', 43],
        ['de-st-15084000-15084282', 44], ['de-st-15084000-15084125', 45],
        ['de-st-15084000-15084335', 46], ['de-st-15084000-15084470', 47],
        ['de-st-15090000-15090135', 48], ['de-st-15087000-15087101', 49],
        ['de-st-15083000-15083320', 50], ['de-st-15085000-15085055', 51],
        ['de-st-15085000-15085227', 52], ['de-st-15089000-15089365', 53],
        ['de-st-14730000-14730100', 54], ['de-st-14730000-14730120', 55],
        ['de-st-15084000-15084590', 56], ['de-st-14730000-14730280', 57],
        ['de-st-14730000-14730360', 58], ['de-st-14730000-14730320', 59],
        ['de-st-15084000-15084133', 60], ['de-st-14730000-14730080', 61],
        ['de-st-15081000-15081440', 62], ['de-st-15081000-15081225', 63],
        ['de-st-15083000-15083060', 64], ['de-st-15083000-15083411', 65],
        ['de-st-15089000-15089015', 66], ['de-st-15089000-15089165', 67],
        ['de-st-15088000-15088305', 68], ['de-st-15084000-15084246', 69],
        ['de-st-15081000-15081280', 70], ['de-st-15084000-15084445', 71],
        ['de-st-15084000-15084550', 72], ['de-st-15088000-15088205', 73],
        ['de-st-15088000-15088100', 74], ['de-st-15089000-15089175', 75],
        ['de-st-15088000-15088065', 76], ['de-st-15081000-15081240', 77],
        ['de-st-15090000-15090415', 78], ['de-st-14730000-14730160', 79],
        ['de-st-15081000-15081545', 80], ['de-st-15088000-15088319', 81],
        ['de-st-15002000-15002000', 82], ['de-st-15084000-15084565', 83],
        ['de-st-15084000-15084275', 84], ['de-st-15089000-15089185', 85],
        ['de-st-15084000-15084132', 86], ['de-st-15087000-15087045', 87],
        ['de-st-15087000-15087210', 88], ['de-st-15089000-15089307', 89],
        ['de-st-15087000-15087015', 90], ['de-st-15084000-15084170', 91],
        ['de-st-15088000-15088235', 92], ['de-st-15083000-15083505', 93],
        ['de-st-15083000-15083515', 94], ['de-st-15083000-15083535', 95],
        ['de-st-15087000-15087275', 96], ['de-st-15087000-15087370', 97],
        ['de-st-15083000-15083565', 98], ['de-st-15086000-15086015', 99],
        ['de-st-15083000-15083040', 100], ['de-st-15086000-15086145', 101],
        ['de-st-15083000-15083120', 102], ['de-st-15083000-15083270', 103],
        ['de-st-15083000-15083130', 104], ['de-st-15083000-15083390', 105],
        ['de-st-15085000-15085287', 106], ['de-st-15083000-15083125', 107],
        ['de-st-15085000-15085090', 108], ['de-st-15084000-15084560', 109],
        ['de-st-15084000-15084355', 110], ['de-st-15085000-15085365', 111],
        ['de-st-15085000-15085040', 112], ['de-st-15090000-15090010', 113],
        ['de-st-15090000-15090310', 114], ['de-st-15086000-15086080', 115],
        ['de-st-15090000-15090500', 116], ['de-st-15090000-15090550', 117],
        ['de-st-15090000-15090220', 118], ['de-st-15089000-15089045', 119],
        ['de-st-15089000-15089310', 120], ['de-st-15085000-15085160', 121],
        ['de-st-15089000-15089130', 122], ['de-st-15088000-15088365', 123],
        ['de-st-15088000-15088265', 124], ['de-st-15088000-15088340', 125],
        ['de-st-15085000-15085135', 126], ['de-st-15085000-15085285', 127],
        ['de-st-15085000-15085125', 128], ['de-st-15083000-15083025', 129],
        ['de-st-15083000-15083415', 130], ['de-st-15085000-15085190', 131],
        ['de-st-15083000-15083557', 132], ['de-st-15081000-15081135', 133],
        ['de-st-15083000-15083580', 134], ['de-st-15083000-15083361', 135],
        ['de-st-15083000-15083030', 136], ['de-st-14730000-14730210', 137],
        ['de-st-14730000-14730170', 138], ['de-st-14730000-14730060', 139],
        ['de-st-15083000-15083298', 140], ['de-st-14730000-14730230', 141],
        ['de-st-14730000-14730200', 142], ['de-st-15090000-15090520', 143],
        ['de-st-15090000-15090007', 144], ['de-st-14730000-14730250', 145],
        ['de-st-15085000-15085235', 146], ['de-st-15003000-15003000', 147],
        ['de-st-15086000-15086055', 148], ['de-st-15089000-15089026', 149],
        ['de-st-15084000-15084130', 150], ['de-st-15089000-15089305', 151],
        ['de-st-15089000-15089030', 152], ['de-st-15083000-15083275', 153],
        ['de-st-15082000-15082180', 154], ['de-st-15088000-15088025', 155],
        ['de-st-15088000-15088220', 156], ['de-st-15081000-15081290', 157],
        ['de-st-15090000-15090535', 158], ['de-st-15090000-15090546', 159],
        ['de-st-15090000-15090070', 160], ['de-st-15087000-15087470', 161],
        ['de-st-15087000-15087070', 162], ['de-st-15090000-15090635', 163],
        ['de-st-15083000-15083245', 164], ['de-st-15090000-15090285', 165],
        ['de-st-14730000-14730310', 166], ['de-st-14730000-14730010', 167],
        ['de-st-14730000-14730030', 168], ['de-st-15090000-15090270', 169],
        ['de-st-15090000-15090225', 170], ['de-st-15090000-15090610', 171],
        ['de-st-15090000-15090008', 172], ['de-st-14730000-14730090', 173],
        ['de-st-15088000-15088195', 174], ['de-st-15082000-15082340', 175],
        ['de-st-15091000-15091020', 176], ['de-st-15084000-15084135', 177],
        ['de-st-15084000-15084025', 178], ['de-st-15084000-15084285', 179],
        ['de-st-15090000-15090435', 180], ['de-st-15081000-15081095', 181],
        ['de-st-15089000-15089075', 182], ['de-st-15083000-15083190', 183],
        ['de-st-15087000-15087125', 184], ['de-st-15087000-15087440', 185],
        ['de-st-15087000-15087250', 186], ['de-st-15089000-15089245', 187],
        ['de-st-14730000-14730340', 188], ['de-st-15088000-15088150', 189],
        ['de-st-15089000-15089195', 190], ['de-st-15082000-15082377', 191],
        ['de-st-14730000-14730270', 192], ['de-st-15085000-15085230', 193],
        ['de-st-15085000-15085110', 194], ['de-st-14730000-14730020', 195],
        ['de-st-15090000-15090485', 196], ['de-st-15084000-15084375', 197],
        ['de-st-15084000-15084115', 198], ['de-st-15084000-15084013', 199],
        ['de-st-15090000-15090445', 200], ['de-st-15084000-15084207', 201],
        ['de-st-15083000-15083355', 202], ['de-st-15084000-15084360', 203],
        ['de-st-15084000-15084150', 204], ['de-st-15089000-15089005', 205],
        ['de-st-15085000-15085330', 206], ['de-st-15084000-15084015', 207],
        ['de-st-15085000-15085140', 208], ['de-st-15083000-15083035', 209],
        ['de-st-15084000-15084490', 210], ['de-st-15084000-15084235', 211],
        ['de-st-15083000-15083205', 212], ['de-st-14730000-14730140', 213],
        ['de-st-14730000-14730150', 214], ['de-st-14730000-14730110', 215],
        ['de-st-15089000-15089235', 216], ['de-st-15088000-15088020', 217],
        ['de-st-15087000-15087205', 218], ['de-st-15087000-15087260', 219],
        ['de-st-15082000-15082440', 220], ['de-st-14730000-14730180', 221],
        ['de-st-15082000-15082015', 222], ['de-st-14730000-14730070', 223],
        ['de-st-15087000-15087412', 224], ['de-st-15081000-15081105', 225],
        ['de-st-15084000-15084341', 226], ['de-st-15091000-15091375', 227],
        ['de-st-15085000-15085185', 228], ['de-st-15081000-15081030', 229],
        ['de-st-15091000-15091060', 230], ['de-st-15086000-15086140', 231],
        ['de-st-15085000-15085228', 232], ['de-st-15081000-15081455', 233],
        ['de-st-15083000-15083531', 234], ['de-st-15082000-15082005', 235],
        ['de-st-14730000-14730330', 236], ['de-st-15091000-15091010', 237],
        ['de-st-15090000-15090003', 238], ['de-st-15091000-15091145', 239],
        ['de-st-15082000-15082430', 240], ['de-st-15090000-15090631', 241],
        ['de-st-15084000-15084442', 242], ['de-st-14730000-14730300', 243],
        ['de-st-15084000-15084315', 244], ['de-st-15087000-15087220', 245],
        ['de-st-15091000-15091391', 246], ['de-st-15091000-15091241', 247],
        ['de-st-15091000-15091110', 248], ['de-st-15087000-15087386', 249],
        ['de-st-15091000-15091160', 250], ['de-st-15087000-15087055', 251],
        ['de-st-15086000-15086040', 252], ['de-st-15086000-15086005', 253],
        ['de-st-15083000-15083440', 254], ['de-st-15088000-15088330', 255],
        ['de-st-15085000-15085370', 256], ['de-st-15089000-15089055', 257],
        ['de-st-15086000-15086035', 258], [null, 259]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-st-all-all.topo.json">Sachsen-Anhalt</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
