(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/de/de-th-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['de-th-16074000-16074034', 10], ['de-th-16074000-16074076', 11],
        ['de-th-16074000-16074016', 12], ['de-th-16071000-16071034', 13],
        ['de-th-16071000-16071067', 14], ['de-th-16065000-16065054', 15],
        ['de-th-16065000-16065033', 16], ['de-th-16063000-16063014', 17],
        ['de-th-16071000-16071077', 18], ['de-th-16071000-16071004', 19],
        ['de-th-16070000-16070021', 20], ['de-th-16069000-16069002', 21],
        ['de-th-16069000-16069005', 22], ['de-th-16069000-16069012', 23],
        ['de-th-16077000-16077012', 24], ['de-th-16073000-16073111', 25],
        ['de-th-16073000-16073035', 26], ['de-th-16075000-16075061', 27],
        ['de-th-16075000-16075068', 28], ['de-th-16066000-16066042', 29],
        ['de-th-16066000-16066056', 30], ['de-th-16074000-16074057', 31],
        ['de-th-16074000-16074008', 32], ['de-th-16070000-16070025', 33],
        ['de-th-16070000-16070002', 34], ['de-th-16074000-16074003', 35],
        ['de-th-16074000-16074041', 36], ['de-th-16067000-16067087', 37],
        ['de-th-16070000-16070028', 38], ['de-th-16067000-16067081', 39],
        ['de-th-16066000-16066078', 40], ['de-th-16077000-16077039', 41],
        ['de-th-16063000-16063075', 42], ['de-th-16069000-16069019', 43],
        ['de-th-16062000-16062054', 44], ['de-th-16062000-16062008', 45],
        ['de-th-16070000-16070054', 46], ['de-th-16070000-16070041', 47],
        ['de-th-16066000-16066043', 48], ['de-th-16076000-16076062', 49],
        ['de-th-16076000-16076027', 50], ['de-th-16071000-16071074', 51],
        ['de-th-16071000-16071063', 52], ['de-th-16077000-16077041', 53],
        ['de-th-16077000-16077026', 54], ['de-th-16071000-16071092', 55],
        ['de-th-16068000-16068056', 56], ['de-th-16061000-16061099', 57],
        ['de-th-16061000-16061038', 58], ['de-th-16061000-16061037', 59],
        ['de-th-16071000-16071072', 60], ['de-th-16071000-16071012', 61],
        ['de-th-16064000-16064008', 62], ['de-th-16064000-16064048', 63],
        ['de-th-16061000-16061019', 64], ['de-th-16061000-16061017', 65],
        ['de-th-16066000-16066074', 66], ['de-th-16067000-16067084', 67],
        ['de-th-16067000-16067072', 68], ['de-th-16064000-16064007', 69],
        ['de-th-16064000-16064033', 70], ['de-th-16076000-16076028', 71],
        ['de-th-16076000-16076008', 72], ['de-th-16063000-16063099', 73],
        ['de-th-16077000-16077011', 74], ['de-th-16077000-16077006', 75],
        ['de-th-16076000-16076092', 76], ['de-th-16076000-16076029', 77],
        ['de-th-16076000-16076034', 78], ['de-th-16052000-16052000', 79],
        ['de-th-16076000-16076003', 80], ['de-th-16076000-16076036', 81],
        ['de-th-16069000-16069001', 82], ['de-th-16069000-16069048', 83],
        ['de-th-16069000-16069041', 84], ['de-th-16077000-16077015', 85],
        ['de-th-16069000-16069015', 86], ['de-th-16074000-16074019', 87],
        ['de-th-16076000-16076043', 88], ['de-th-16074000-16074099', 89],
        ['de-th-16075000-16075114', 90], ['de-th-16075000-16075057', 91],
        ['de-th-16062000-16062065', 92], ['de-th-16062000-16062018', 93],
        ['de-th-16055000-16055000', 94], ['de-th-16071000-16071007', 95],
        ['de-th-16066000-16066059', 96], ['de-th-16066000-16066064', 97],
        ['de-th-16069000-16069053', 98], ['de-th-16063000-16063013', 99],
        ['de-th-16063000-16063039', 100], ['de-th-16077000-16077047', 101],
        ['de-th-16075000-16075101', 102], ['de-th-16075000-16075088', 103],
        ['de-th-16075000-16075065', 104], ['de-th-16076000-16076017', 105],
        ['de-th-16070000-16070013', 106], ['de-th-16070000-16070012', 107],
        ['de-th-16064000-16064035', 108], ['de-th-16075000-16075013', 109],
        ['de-th-16075000-16075033', 110], ['de-th-16071000-16071011', 111],
        ['de-th-16071000-16071023', 112], ['de-th-16071000-16071028', 113],
        ['de-th-16076000-16076038', 114], ['de-th-16076000-16076024', 115],
        ['de-th-16064000-16064023', 116], ['de-th-16064000-16064047', 117],
        ['de-th-16063000-16063008', 118], ['de-th-16067000-16067027', 119],
        ['de-th-16067000-16067088', 120], ['de-th-16061000-16061033', 121],
        ['de-th-16061000-16061036', 122], ['de-th-16076000-16076084', 123],
        ['de-th-16076000-16076088', 124], ['de-th-16076000-16076039', 125],
        ['de-th-16074000-16074004', 126], ['de-th-16074000-16074044', 127],
        ['de-th-16067000-16067086', 128], ['de-th-16067000-16067029', 129],
        ['de-th-16073000-16073028', 130], ['de-th-16073000-16073079', 131],
        ['de-th-16066000-16066038', 132], ['de-th-16066000-16066058', 133],
        ['de-th-16066000-16066065', 134], ['de-th-16073000-16073101', 135],
        ['de-th-16073000-16073108', 136], ['de-th-16061000-16061026', 137],
        ['de-th-16077000-16077022', 138], ['de-th-16067000-16067067', 139],
        ['de-th-16074000-16074024', 140], ['de-th-16074000-16074046', 141],
        ['de-th-16074000-16074103', 142], ['de-th-16074000-16074107', 143],
        ['de-th-16076000-16076026', 144], ['de-th-16074000-16074054', 145],
        ['de-th-16074000-16074028', 146], ['de-th-16074000-16074061', 147],
        ['de-th-16073000-16073038', 148], ['de-th-16076000-16076023', 149],
        ['de-th-16064000-16064018', 150], ['de-th-16064000-16064058', 151],
        ['de-th-16063000-16063071', 152], ['de-th-16063000-16063009', 153],
        ['de-th-16063000-16063093', 154], ['de-th-16063000-16063001', 155],
        ['de-th-16074000-16074025', 156], ['de-th-16074000-16074067', 157],
        ['de-th-16063000-16063017', 158], ['de-th-16074000-16074026', 159],
        ['de-th-16053000-16053000', 160], ['de-th-16073000-16073006', 161],
        ['de-th-16073000-16073005', 162], ['de-th-16074000-16074022', 163],
        ['de-th-16074000-16074102', 164], ['de-th-16069000-16069011', 165],
        ['de-th-16070000-16070001', 166], ['de-th-16071000-16071032', 167],
        ['de-th-16071000-16071059', 168], ['de-th-16077000-16077007', 169],
        ['de-th-16077000-16077048', 170], ['de-th-16077000-16077032', 171],
        ['de-th-16075000-16075069', 172], ['de-th-16075000-16075081', 173],
        ['de-th-16075000-16075035', 174], ['de-th-16063000-16063033', 175],
        ['de-th-16063000-16063068', 176], ['de-th-16067000-16067039', 177],
        ['de-th-16067000-16067059', 178], ['de-th-16067000-16067054', 179],
        ['de-th-16075000-16075125', 180], ['de-th-16071000-16071046', 181],
        ['de-th-16070000-16070018', 182], ['de-th-16070000-16070038', 183],
        ['de-th-16070000-16070015', 184], ['de-th-16069000-16069042', 185],
        ['de-th-16076000-16076059', 186], ['de-th-16072000-16072023', 187],
        ['de-th-16072000-16072013', 188], ['de-th-16069000-16069039', 189],
        ['de-th-16063000-16063036', 190], ['de-th-16072000-16072006', 191],
        ['de-th-16075000-16075119', 192], ['de-th-16075000-16075029', 193],
        ['de-th-16065000-16065058', 194], ['de-th-16065000-16065005', 195],
        ['de-th-16076000-16076014', 196], ['de-th-16071000-16071019', 197],
        ['de-th-16071000-16071095', 198], ['de-th-16071000-16071048', 199],
        ['de-th-16071000-16071087', 200], ['de-th-16076000-16076009', 201],
        ['de-th-16076000-16076019', 202], ['de-th-16066000-16066033', 203],
        ['de-th-16063000-16063044', 204], ['de-th-16063000-16063043', 205],
        ['de-th-16063000-16063045', 206], ['de-th-16076000-16076045', 207],
        ['de-th-16076000-16076083', 208], ['de-th-16064000-16064037', 209],
        ['de-th-16064000-16064001', 210], ['de-th-16076000-16076051', 211],
        ['de-th-16076000-16076006', 212], ['de-th-16076000-16076058', 213],
        ['de-th-16077000-16077019', 214], ['de-th-16070000-16070011', 215],
        ['de-th-16070000-16070019', 216], ['de-th-16061000-16061114', 217],
        ['de-th-16061000-16061094', 218], ['de-th-16077000-16077017', 219],
        ['de-th-16067000-16067036', 220], ['de-th-16067000-16067053', 221],
        ['de-th-16074000-16074077', 222], ['de-th-16074000-16074097', 223],
        ['de-th-16077000-16077008', 224], ['de-th-16077000-16077044', 225],
        ['de-th-16077000-16077001', 226], ['de-th-16077000-16077042', 227],
        ['de-th-16063000-16063066', 228], ['de-th-16069000-16069003', 229],
        ['de-th-16069000-16069047', 230], ['de-th-16070000-16070022', 231],
        ['de-th-16070000-16070016', 232], ['de-th-16073000-16073056', 233],
        ['de-th-16077000-16077037', 234], ['de-th-16077000-16077004', 235],
        ['de-th-16077000-16077049', 236], ['de-th-16065000-16065022', 237],
        ['de-th-16062000-16062004', 238], ['de-th-16065000-16065003', 239],
        ['de-th-16075000-16075085', 240], ['de-th-16075000-16075016', 241],
        ['de-th-16074000-16074007', 242], ['de-th-16075000-16075073', 243],
        ['de-th-16075000-16075093', 244], ['de-th-16065000-16065084', 245],
        ['de-th-16065000-16065085', 246], ['de-th-16070000-16070031', 247],
        ['de-th-16067000-16067071', 248], ['de-th-16065000-16065013', 249],
        ['de-th-16068000-16068034', 250], ['de-th-16071000-16071039', 251],
        ['de-th-16066000-16066086', 252], ['de-th-16066000-16066085', 253],
        ['de-th-16066000-16066041', 254], ['de-th-16070000-16070043', 255],
        ['de-th-16070000-16070029', 256], ['de-th-16070000-16070046', 257],
        ['de-th-16061000-16061097', 258], ['de-th-16061000-16061067', 259],
        ['de-th-16075000-16075079', 260], ['de-th-16070000-16070024', 261],
        ['de-th-16070000-16070035', 262], ['de-th-16070000-16070017', 263],
        ['de-th-16074000-16074095', 264], ['de-th-16074000-16074114', 265],
        ['de-th-16075000-16075099', 266], ['de-th-16066000-16066092', 267],
        ['de-th-16066000-16066008', 268], ['de-th-16075000-16075002', 269],
        ['de-th-16075000-16075042', 270], ['de-th-16073000-16073107', 271],
        ['de-th-16075000-16075086', 272], ['de-th-16075000-16075004', 273],
        ['de-th-16067000-16067068', 274], ['de-th-16067000-16067082', 275],
        ['de-th-16074000-16074049', 276], ['de-th-16068000-16068016', 277],
        ['de-th-16075000-16075102', 278], ['de-th-16075000-16075023', 279],
        ['de-th-16067000-16067004', 280], ['de-th-16071000-16071044', 281],
        ['de-th-16075000-16075048', 282], ['de-th-16076000-16076087', 283],
        ['de-th-16075000-16075034', 284], ['de-th-16074000-16074092', 285],
        ['de-th-16076000-16076012', 286], ['de-th-16074000-16074038', 287],
        ['de-th-16074000-16074105', 288], ['de-th-16074000-16074005', 289],
        ['de-th-16074000-16074069', 290], ['de-th-16074000-16074006', 291],
        ['de-th-16070000-16070034', 292], ['de-th-16068000-16068048', 293],
        ['de-th-16068000-16068036', 294], ['de-th-16068000-16068039', 295],
        ['de-th-16073000-16073074', 296], ['de-th-16073000-16073017', 297],
        ['de-th-16073000-16073084', 298], ['de-th-16073000-16073001', 299],
        ['de-th-16066000-16066079', 300], ['de-th-16066000-16066005', 301],
        ['de-th-16066000-16066016', 302], ['de-th-16070000-16070008', 303],
        ['de-th-16070000-16070053', 304], ['de-th-16061000-16061107', 305],
        ['de-th-16061000-16061052', 306], ['de-th-16076000-16076022', 307],
        ['de-th-16061000-16061077', 308], ['de-th-16061000-16061096', 309],
        ['de-th-16061000-16061084', 310], ['de-th-16069000-16069016', 311],
        ['de-th-16069000-16069051', 312], ['de-th-16061000-16061023', 313],
        ['de-th-16061000-16061062', 314], ['de-th-16067000-16067064', 315],
        ['de-th-16066000-16066023', 316], ['de-th-16066000-16066022', 317],
        ['de-th-16063000-16063037', 318], ['de-th-16063000-16063058', 319],
        ['de-th-16064000-16064075', 320], ['de-th-16066000-16066028', 321],
        ['de-th-16061000-16061003', 322], ['de-th-16066000-16066073', 323],
        ['de-th-16061000-16061076', 324], ['de-th-16066000-16066084', 325],
        ['de-th-16061000-16061012', 326], ['de-th-16061000-16061015', 327],
        ['de-th-16061000-16061115', 328], ['de-th-16063000-16063032', 329],
        ['de-th-16071000-16071057', 330], ['de-th-16071000-16071006', 331],
        ['de-th-16061000-16061085', 332], ['de-th-16061000-16061105', 333],
        ['de-th-16075000-16075046', 334], ['de-th-16063000-16063007', 335],
        ['de-th-16061000-16061065', 336], ['de-th-16061000-16061111', 337],
        ['de-th-16065000-16065079', 338], ['de-th-16065000-16065077', 339],
        ['de-th-16074000-16074075', 340], ['de-th-16074000-16074084', 341],
        ['de-th-16061000-16061027', 342], ['de-th-16064000-16064074', 343],
        ['de-th-16061000-16061041', 344], ['de-th-16077000-16077055', 345],
        ['de-th-16065000-16065012', 346], ['de-th-16065000-16065074', 347],
        ['de-th-16065000-16065075', 348], ['de-th-16065000-16065051', 349],
        ['de-th-16062000-16062041', 350], ['de-th-16062000-16062005', 351],
        ['de-th-16061000-16061113', 352], ['de-th-16065000-16065048', 353],
        ['de-th-16061000-16061116', 354], ['de-th-16061000-16061068', 355],
        ['de-th-16062000-16062025', 356], ['de-th-16061000-16061058', 357],
        ['de-th-16070000-16070049', 358], ['de-th-16062000-16062016', 359],
        ['de-th-16065000-16065061', 360], ['de-th-16065000-16065047', 361],
        ['de-th-16074000-16074045', 362], ['de-th-16051000-16051000', 363],
        ['de-th-16070000-16070044', 364], ['de-th-16074000-16074101', 365],
        ['de-th-16066000-16066047', 366], ['de-th-16074000-16074031', 367],
        ['de-th-16074000-16074048', 368], ['de-th-16071000-16071005', 369],
        ['de-th-16074000-16074073', 370], ['de-th-16070000-16070052', 371],
        ['de-th-16074000-16074116', 372], ['de-th-16064000-16064019', 373],
        ['de-th-16064000-16064064', 374], ['de-th-16074000-16074068', 375],
        ['de-th-16073000-16073082', 376], ['de-th-16069000-16069062', 377],
        ['de-th-16069000-16069037', 378], ['de-th-16066000-16066036', 379],
        ['de-th-16075000-16075124', 380], ['de-th-16064000-16064004', 381],
        ['de-th-16063000-16063098', 382], ['de-th-16067000-16067074', 383],
        ['de-th-16074000-16074059', 384], ['de-th-16073000-16073063', 385],
        ['de-th-16073000-16073021', 386], ['de-th-16076000-16076049', 387],
        ['de-th-16076000-16076044', 388], ['de-th-16076000-16076033', 389],
        ['de-th-16073000-16073055', 390], ['de-th-16070000-16070003', 391],
        ['de-th-16070000-16070037', 392], ['de-th-16076000-16076068', 393],
        ['de-th-16074000-16074017', 394], ['de-th-16073000-16073068', 395],
        ['de-th-16068000-16068057', 396], ['de-th-16068000-16068045', 397],
        ['de-th-16069000-16069049', 398], ['de-th-16068000-16068002', 399],
        ['de-th-16076000-16076042', 400], ['de-th-16077000-16077043', 401],
        ['de-th-16066000-16066069', 402], ['de-th-16066000-16066067', 403],
        ['de-th-16077000-16077036', 404], ['de-th-16077000-16077002', 405],
        ['de-th-16074000-16074047', 406], ['de-th-16067000-16067009', 407],
        ['de-th-16068000-16068044', 408], ['de-th-16073000-16073106', 409],
        ['de-th-16067000-16067025', 410], ['de-th-16075000-16075051', 411],
        ['de-th-16075000-16075121', 412], ['de-th-16075000-16075075', 413],
        ['de-th-16075000-16075056', 414], ['de-th-16071000-16071065', 415],
        ['de-th-16074000-16074037', 416], ['de-th-16071000-16071096', 417],
        ['de-th-16067000-16067005', 418], ['de-th-16067000-16067021', 419],
        ['de-th-16071000-16071054', 420], ['de-th-16075000-16075134', 421],
        ['de-th-16073000-16073002', 422], ['de-th-16075000-16075006', 423],
        ['de-th-16069000-16069021', 424], ['de-th-16069000-16069035', 425],
        ['de-th-16069000-16069028', 426], ['de-th-16062000-16062063', 427],
        ['de-th-16062000-16062007', 428], ['de-th-16070000-16070005', 429],
        ['de-th-16076000-16076052', 430], ['de-th-16075000-16075135', 431],
        ['de-th-16075000-16075009', 432], ['de-th-16061000-16061035', 433],
        ['de-th-16076000-16076004', 434], ['de-th-16075000-16075014', 435],
        ['de-th-16064000-16064021', 436], ['de-th-16076000-16076074', 437],
        ['de-th-16074000-16074056', 438], ['de-th-16061000-16061049', 439],
        ['de-th-16061000-16061083', 440], ['de-th-16065000-16065034', 441],
        ['de-th-16074000-16074096', 442], ['de-th-16061000-16061082', 443],
        ['de-th-16064000-16064038', 444], ['de-th-16062000-16062002', 445],
        ['de-th-16062000-16062058', 446], ['de-th-16067000-16067052', 447],
        ['de-th-16061000-16061087', 448], ['de-th-16061000-16061046', 449],
        ['de-th-16062000-16062033', 450], ['de-th-16071000-16071073', 451],
        ['de-th-16074000-16074018', 452], ['de-th-16071000-16071008', 453],
        ['de-th-16071000-16071055', 454], ['de-th-16071000-16071038', 455],
        ['de-th-16071000-16071071', 456], ['de-th-16069000-16069056', 457],
        ['de-th-16061000-16061069', 458], ['de-th-16062000-16062029', 459],
        ['de-th-16066000-16066061', 460], ['de-th-16066000-16066013', 461],
        ['de-th-16073000-16073094', 462], ['de-th-16075000-16075097', 463],
        ['de-th-16061000-16061002', 464], ['de-th-16075000-16075071', 465],
        ['de-th-16065000-16065001', 466], ['de-th-16065000-16065082', 467],
        ['de-th-16065000-16065018', 468], ['de-th-16077000-16077051', 469],
        ['de-th-16068000-16068027', 470], ['de-th-16065000-16065023', 471],
        ['de-th-16061000-16061057', 472], ['de-th-16061000-16061025', 473],
        ['de-th-16064000-16064073', 474], ['de-th-16064000-16064072', 475],
        ['de-th-16064000-16064014', 476], ['de-th-16074000-16074094', 477],
        ['de-th-16074000-16074085', 478], ['de-th-16061000-16061014', 479],
        ['de-th-16061000-16061001', 480], ['de-th-16067000-16067055', 481],
        ['de-th-16067000-16067006', 482], ['de-th-16067000-16067075', 483],
        ['de-th-16067000-16067003', 484], ['de-th-16067000-16067016', 485],
        ['de-th-16061000-16061066', 486], ['de-th-16071000-16071009', 487],
        ['de-th-16075000-16075063', 488], ['de-th-16073000-16073037', 489],
        ['de-th-16073000-16073013', 490], ['de-th-16071000-16071042', 491],
        ['de-th-16071000-16071053', 492], ['de-th-16074000-16074109', 493],
        ['de-th-16072000-16072005', 494], ['de-th-16071000-16071043', 495],
        ['de-th-16075000-16075008', 496], ['de-th-16074000-16074058', 497],
        ['de-th-16071000-16071052', 498], ['de-th-16071000-16071082', 499],
        ['de-th-16070000-16070055', 500], ['de-th-16068000-16068019', 501],
        ['de-th-16068000-16068041', 502], ['de-th-16068000-16068038', 503],
        ['de-th-16076000-16076086', 504], ['de-th-16076000-16076007', 505],
        ['de-th-16068000-16068033', 506], ['de-th-16066000-16066015', 507],
        ['de-th-16067000-16067013', 508], ['de-th-16067000-16067083', 509],
        ['de-th-16075000-16075012', 510], ['de-th-16061000-16061103', 511],
        ['de-th-16073000-16073054', 512], ['de-th-16074000-16074066', 513],
        ['de-th-16074000-16074108', 514], ['de-th-16066000-16066082', 515],
        ['de-th-16077000-16077018', 516], ['de-th-16068000-16068011', 517],
        ['de-th-16068000-16068006', 518], ['de-th-16068000-16068042', 519],
        ['de-th-16063000-16063076', 520], ['de-th-16073000-16073109', 521],
        ['de-th-16074000-16074021', 522], ['de-th-16074000-16074065', 523],
        ['de-th-16074000-16074042', 524], ['de-th-16067000-16067033', 525],
        ['de-th-16073000-16073066', 526], ['de-th-16068000-16068007', 527],
        ['de-th-16074000-16074052', 528], ['de-th-16074000-16074089', 529],
        ['de-th-16068000-16068052', 530], ['de-th-16065000-16065081', 531],
        ['de-th-16063000-16063053', 532], ['de-th-16063000-16063087', 533],
        ['de-th-16063000-16063011', 534], ['de-th-16062000-16062064', 535],
        ['de-th-16070000-16070032', 536], ['de-th-16062000-16062036', 537],
        ['de-th-16063000-16063083', 538], ['de-th-16061000-16061045', 539],
        ['de-th-16071000-16071089', 540], ['de-th-16071000-16071049', 541],
        ['de-th-16061000-16061032', 542], ['de-th-16061000-16061078', 543],
        ['de-th-16067000-16067044', 544], ['de-th-16067000-16067032', 545],
        ['de-th-16066000-16066051', 546], ['de-th-16075000-16075109', 547],
        ['de-th-16063000-16063018', 548], ['de-th-16063000-16063072', 549],
        ['de-th-16064000-16064066', 550], ['de-th-16066000-16066053', 551],
        ['de-th-16066000-16066048', 552], ['de-th-16061000-16061007', 553],
        ['de-th-16064000-16064027', 554], ['de-th-16063000-16063023', 555],
        ['de-th-16063000-16063028', 556], ['de-th-16062000-16062009', 557],
        ['de-th-16062000-16062037', 558], ['de-th-16068000-16068013', 559],
        ['de-th-16068000-16068053', 560], ['de-th-16062000-16062062', 561],
        ['de-th-16068000-16068003', 562], ['de-th-16065000-16065031', 563],
        ['de-th-16068000-16068047', 564], ['de-th-16068000-16068051', 565],
        ['de-th-16063000-16063059', 566], ['de-th-16063000-16063015', 567],
        ['de-th-16065000-16065057', 568], ['de-th-16065000-16065002', 569],
        ['de-th-16061000-16061075', 570], ['de-th-16077000-16077016', 571],
        ['de-th-16076000-16076069', 572], ['de-th-16061000-16061063', 573],
        ['de-th-16069000-16069008', 574], ['de-th-16064000-16064009', 575],
        ['de-th-16073000-16073067', 576], ['de-th-16062000-16062014', 577],
        ['de-th-16062000-16062059', 578], ['de-th-16062000-16062026', 579],
        ['de-th-16074000-16074112', 580], ['de-th-16071000-16071099', 581],
        ['de-th-16064000-16064029', 582], ['de-th-16074000-16074036', 583],
        ['de-th-16061000-16061101', 584], ['de-th-16071000-16071037', 585],
        ['de-th-16066000-16066025', 586], ['de-th-16061000-16061048', 587],
        ['de-th-16075000-16075003', 588], ['de-th-16075000-16075018', 589],
        ['de-th-16071000-16071022', 590], ['de-th-16073000-16073112', 591],
        ['de-th-16073000-16073105', 592], ['de-th-16070000-16070027', 593],
        ['de-th-16071000-16071025', 594], ['de-th-16071000-16071013', 595],
        ['de-th-16066000-16066045', 596], ['de-th-16066000-16066081', 597],
        ['de-th-16074000-16074053', 598], ['de-th-16071000-16071027', 599],
        ['de-th-16071000-16071097', 600], ['de-th-16061000-16061018', 601],
        ['de-th-16064000-16064055', 602], ['de-th-16061000-16061039', 603],
        ['de-th-16065000-16065052', 604], ['de-th-16068000-16068022', 605],
        ['de-th-16068000-16068029', 606], ['de-th-16062000-16062024', 607],
        ['de-th-16074000-16074093', 608], ['de-th-16074000-16074032', 609],
        ['de-th-16074000-16074086', 610], ['de-th-16061000-16061089', 611],
        ['de-th-16066000-16066057', 612], ['de-th-16066000-16066017', 613],
        ['de-th-16066000-16066018', 614], ['de-th-16061000-16061024', 615],
        ['de-th-16065000-16065019', 616], ['de-th-16063000-16063029', 617],
        ['de-th-16066000-16066076', 618], ['de-th-16075000-16075132', 619],
        ['de-th-16075000-16075062', 620], ['de-th-16075000-16075131', 621],
        ['de-th-16066000-16066049', 622], ['de-th-16065000-16065014', 623],
        ['de-th-16064000-16064043', 624], ['de-th-16065000-16065011', 625],
        ['de-th-16071000-16071015', 626], ['de-th-16071000-16071064', 627],
        ['de-th-16068000-16068023', 628], ['de-th-16068000-16068008', 629],
        ['de-th-16061000-16061117', 630], ['de-th-16066000-16066006', 631],
        ['de-th-16061000-16061059', 632], ['de-th-16064000-16064045', 633],
        ['de-th-16065000-16065046', 634], ['de-th-16074000-16074098', 635],
        ['de-th-16065000-16065076', 636], ['de-th-16071000-16071076', 637],
        ['de-th-16068000-16068017', 638], ['de-th-16069000-16069009', 639],
        ['de-th-16068000-16068032', 640], ['de-th-16074000-16074074', 641],
        ['de-th-16061000-16061004', 642], ['de-th-16067000-16067085', 643],
        ['de-th-16067000-16067065', 644], ['de-th-16066000-16066077', 645],
        ['de-th-16069000-16069025', 646], ['de-th-16066000-16066088', 647],
        ['de-th-16064000-16064032', 648], ['de-th-16064000-16064053', 649],
        ['de-th-16072000-16072015', 650], ['de-th-16064000-16064017', 651],
        ['de-th-16068000-16068021', 652], ['de-th-16068000-16068025', 653],
        ['de-th-16068000-16068001', 654], ['de-th-16061000-16061102', 655],
        ['de-th-16068000-16068031', 656], ['de-th-16061000-16061031', 657],
        ['de-th-16068000-16068005', 658], ['de-th-16068000-16068043', 659],
        ['de-th-16068000-16068028', 660], ['de-th-16068000-16068015', 661],
        ['de-th-16065000-16065056', 662], ['de-th-16061000-16061054', 663],
        ['de-th-16076000-16076055', 664], ['de-th-16076000-16076061', 665],
        ['de-th-16064000-16064003', 666], ['de-th-16064000-16064036', 667],
        ['de-th-16075000-16075127', 668], ['de-th-16073000-16073049', 669],
        ['de-th-16067000-16067022', 670], ['de-th-16069000-16069004', 671],
        ['de-th-16069000-16069026', 672], ['de-th-16076000-16076064', 673],
        ['de-th-16071000-16071051', 674], ['de-th-16071000-16071017', 675],
        ['de-th-16068000-16068009', 676], ['de-th-16068000-16068061', 677],
        ['de-th-16069000-16069058', 678], ['de-th-16069000-16069024', 679],
        ['de-th-16067000-16067026', 680], ['de-th-16069000-16069006', 681],
        ['de-th-16068000-16068046', 682], ['de-th-16071000-16071066', 683],
        ['de-th-16061000-16061043', 684], ['de-th-16062000-16062049', 685],
        ['de-th-16064000-16064065', 686], ['de-th-16063000-16063081', 687],
        ['de-th-16067000-16067035', 688], ['de-th-16063000-16063082', 689],
        ['de-th-16066000-16066052', 690], ['de-th-16068000-16068049', 691],
        ['de-th-16076000-16076073', 692], ['de-th-16074000-16074087', 693],
        ['de-th-16066000-16066093', 694], ['de-th-16074000-16074051', 695],
        ['de-th-16074000-16074063', 696], ['de-th-16074000-16074113', 697],
        ['de-th-16074000-16074079', 698], ['de-th-16067000-16067056', 699],
        ['de-th-16071000-16071056', 700], ['de-th-16077000-16077023', 701],
        ['de-th-16071000-16071093', 702], ['de-th-16074000-16074082', 703],
        ['de-th-16061000-16061028', 704], ['de-th-16071000-16071031', 705],
        ['de-th-16071000-16071088', 706], ['de-th-16071000-16071036', 707],
        ['de-th-16068000-16068055', 708], ['de-th-16064000-16064062', 709],
        ['de-th-16064000-16064061', 710], ['de-th-16065000-16065072', 711],
        ['de-th-16065000-16065067', 712], ['de-th-16074000-16074002', 713],
        ['de-th-16074000-16074091', 714], ['de-th-16074000-16074009', 715],
        ['de-th-16067000-16067037', 716], ['de-th-16070000-16070033', 717],
        ['de-th-16070000-16070014', 718], ['de-th-16071000-16071085', 719],
        ['de-th-16076000-16076089', 720], ['de-th-16075000-16075031', 721],
        ['de-th-16065000-16065032', 722], ['de-th-16061000-16061074', 723],
        ['de-th-16065000-16065042', 724], ['de-th-16068000-16068058', 725],
        ['de-th-16074000-16074001', 726], ['de-th-16074000-16074081', 727],
        ['de-th-16075000-16075084', 728], ['de-th-16075000-16075083', 729],
        ['de-th-16069000-16069043', 730], ['de-th-16071000-16071083', 731],
        ['de-th-16070000-16070042', 732], ['de-th-16071000-16071062', 733],
        ['de-th-16074000-16074064', 734], ['de-th-16071000-16071061', 735],
        ['de-th-16071000-16071047', 736], ['de-th-16075000-16075116', 737],
        ['de-th-16066000-16066001', 738], ['de-th-16075000-16075019', 739],
        ['de-th-16070000-16070004', 740], ['de-th-16063000-16063049', 741],
        ['de-th-16067000-16067063', 742], ['de-th-16061000-16061055', 743],
        ['de-th-16061000-16061061', 744], ['de-th-16075000-16075129', 745],
        ['de-th-16075000-16075054', 746], ['de-th-16074000-16074011', 747],
        ['de-th-16074000-16074012', 748], ['de-th-16076000-16076079', 749],
        ['de-th-16068000-16068037', 750], ['de-th-16065000-16065016', 751],
        ['de-th-16065000-16065039', 752], ['de-th-16064000-16064052', 753],
        ['de-th-16065000-16065038', 754], ['de-th-16064000-16064057', 755],
        ['de-th-16062000-16062039', 756], ['de-th-16073000-16073036', 757],
        ['de-th-16073000-16073077', 758], ['de-th-16065000-16065035', 759],
        ['de-th-16073000-16073076', 760], ['de-th-16068000-16068012', 761],
        ['de-th-16068000-16068004', 762], ['de-th-16065000-16065008', 763],
        ['de-th-16067000-16067011', 764], ['de-th-16064000-16064022', 765],
        ['de-th-16067000-16067047', 766], ['de-th-16071000-16071003', 767],
        ['de-th-16071000-16071079', 768], ['de-th-16070000-16070056', 769],
        ['de-th-16066000-16066024', 770], ['de-th-16066000-16066012', 771],
        ['de-th-16062000-16062006', 772], ['de-th-16075000-16075074', 773],
        ['de-th-16075000-16075105', 774], ['de-th-16074000-16074104', 775],
        ['de-th-16074000-16074033', 776], ['de-th-16063000-16063086', 777],
        ['de-th-16063000-16063016', 778], ['de-th-16063000-16063019', 779],
        ['de-th-16066000-16066083', 780], ['de-th-16068000-16068062', 781],
        ['de-th-16068000-16068026', 782], ['de-th-16068000-16068014', 783],
        ['de-th-16076000-16076031', 784], ['de-th-16071000-16071001', 785],
        ['de-th-16070000-16070006', 786], ['de-th-16070000-16070048', 787],
        ['de-th-16063000-16063052', 788], ['de-th-16063000-16063092', 789],
        ['de-th-16074000-16074043', 790], ['de-th-16063000-16063062', 791],
        ['de-th-16063000-16063084', 792], ['de-th-16074000-16074039', 793],
        ['de-th-16074000-16074072', 794], ['de-th-16069000-16069061', 795],
        ['de-th-16063000-16063024', 796], ['de-th-16069000-16069044', 797],
        ['de-th-16066000-16066075', 798], ['de-th-16068000-16068035', 799],
        ['de-th-16068000-16068024', 800], ['de-th-16066000-16066071', 801],
        ['de-th-16075000-16075077', 802], ['de-th-16075000-16075072', 803],
        ['de-th-16063000-16063003', 804], ['de-th-16068000-16068059', 805],
        ['de-th-16074000-16074055', 806], ['de-th-16066000-16066062', 807],
        ['de-th-16066000-16066063', 808], ['de-th-16063000-16063094', 809],
        ['de-th-16063000-16063004', 810], ['de-th-16077000-16077027', 811],
        ['de-th-16064000-16064046', 812], ['de-th-16063000-16063006', 813],
        ['de-th-16077000-16077029', 814], ['de-th-16077000-16077031', 815],
        ['de-th-16077000-16077009', 816], ['de-th-16077000-16077052', 817],
        ['de-th-16077000-16077005', 818], ['de-th-16075000-16075049', 819],
        ['de-th-16075000-16075087', 820], ['de-th-16073000-16073014', 821],
        ['de-th-16076000-16076065', 822], ['de-th-16073000-16073065', 823],
        ['de-th-16064000-16064005', 824], ['de-th-16075000-16075066', 825],
        ['de-th-16061000-16061047', 826], ['de-th-16075000-16075039', 827],
        ['de-th-16061000-16061034', 828], ['de-th-16061000-16061044', 829],
        ['de-th-16077000-16077034', 830], ['de-th-16061000-16061021', 831],
        ['de-th-16072000-16072011', 832], ['de-th-16072000-16072022', 833],
        ['de-th-16066000-16066039', 834], ['de-th-16066000-16066094', 835],
        ['de-th-16075000-16075047', 836], ['de-th-16074000-16074071', 837],
        ['de-th-16061000-16061086', 838], ['de-th-16061000-16061098', 839],
        ['de-th-16074000-16074029', 840], ['de-th-16067000-16067078', 841],
        ['de-th-16069000-16069059', 842], ['de-th-16054000-16054000', 843],
        ['de-th-16069000-16069017', 844], ['de-th-16063000-16063051', 845],
        ['de-th-16063000-16063054', 846], ['de-th-16063000-16063089', 847],
        ['de-th-16056000-16056000', 848], ['de-th-16066000-16066044', 849],
        ['de-th-16071000-16071068', 850], ['de-th-16063000-16063055', 851],
        ['de-th-16063000-16063046', 852], ['de-th-16071000-16071081', 853],
        ['de-th-16070000-16070023', 854], ['de-th-16067000-16067008', 855],
        ['de-th-16076000-16076067', 856], ['de-th-16063000-16063026', 857],
        ['de-th-16066000-16066002', 858], ['de-th-16066000-16066035', 859],
        ['de-th-16066000-16066019', 860], ['de-th-16075000-16075098', 861],
        ['de-th-16077000-16077003', 862], ['de-th-16071000-16071069', 863],
        ['de-th-16074000-16074106', 864], ['de-th-16076000-16076093', 865],
        ['de-th-16072000-16072009', 866], ['de-th-16072000-16072014', 867],
        ['de-th-16063000-16063097', 868], ['de-th-16072000-16072018', 869],
        ['de-th-16069000-16069052', 870], ['de-th-16073000-16073046', 871],
        ['de-th-16061000-16061056', 872], ['de-th-16077000-16077028', 873],
        ['de-th-16069000-16069046', 874], ['de-th-16067000-16067019', 875],
        ['de-th-16075000-16075133', 876], ['de-th-16061000-16061022', 877],
        ['de-th-16076000-16076081', 878], ['de-th-16076000-16076041', 879],
        ['de-th-16072000-16072019', 880], ['de-th-16075000-16075103', 881],
        ['de-th-16064000-16064071', 882], ['de-th-16063000-16063078', 883],
        ['de-th-16061000-16061091', 884], ['de-th-16072000-16072001', 885],
        ['de-th-16075000-16075106', 886], ['de-th-16075000-16075076', 887],
        [null, 888]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/de/de-th-all-all.topo.json">Thüringen</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
