(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/ls/ls-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['ls-be', 10], ['ls-ms', 11], ['ls-mh', 12], ['ls-qt', 13],
        ['ls-le', 14], ['ls-bb', 15], ['ls-mk', 16], ['ls-qn', 17],
        ['ls-tt', 18], ['ls-mf', 19]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/ls/ls-all.topo.json">Lesotho</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
