(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/lt/lt-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['lt-kp', 10], ['lt-as', 11], ['lt-ks', 12], ['lt-ma', 13],
        ['lt-pa', 14], ['lt-sh', 15], ['lt-tg', 16], ['lt-vi', 17],
        ['lt-un', 18], ['lt-tl', 19]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/lt/lt-all.topo.json">Lithuania</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
