(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/nl/nl-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['nl-fr-gm0088', 10], ['nl-3557-gm0448', 11], ['nl-gr-gm1651', 12],
        ['nl-ze-gm1676', 13], ['nl-fr-gm1900', 14], ['nl-3560-gm1924', 15],
        ['nl-gr-gm0007', 16], ['nl-fl-gm0050', 17], ['nl-fl-gm0034', 18],
        ['nl-ov-gm0193', 19], ['nl-3559-gm0307', 20], ['nl-3559-gm0308', 21],
        ['nl-3557-gm1911', 22], ['nl-3557-gm0398', 23], ['nl-ov-gm0153', 24],
        ['nl-3557-gm0394', 25], ['nl-3557-gm0358', 26], ['nl-3560-gm0629', 27],
        ['nl-li-gm1640', 28], ['nl-3559-gm0632', 29], ['nl-3560-gm1901', 30],
        ['nl-3560-gm0599', 31], ['nl-3560-gm0612', 32], ['nl-3560-gm0614', 33],
        ['nl-ge-gm1586', 34], ['nl-ge-gm0197', 35], ['nl-ge-gm1859', 36],
        ['nl-ov-gm1708', 37], ['nl-dr-gm0119', 38], ['nl-fr-gm0079', 39],
        ['nl-fr-gm0058', 40], ['nl-fr-gm0072', 41], ['nl-fr-gm0093', 42],
        ['nl-ov-gm0166', 43], ['nl-ge-gm0244', 44], ['nl-ge-gm0269', 45],
        ['nl-fl-gm0171', 46], ['nl-fl-gm0303', 47], ['nl-ge-gm0302', 48],
        ['nl-3557-gm0363', 49], ['nl-3557-gm0392', 50], ['nl-3557-gm0479', 51],
        ['nl-3557-gm0431', 52], ['nl-3557-gm0437', 53], ['nl-3559-gm0736', 54],
        ['nl-3557-gm0417', 55], ['nl-3557-gm0376', 56], ['nl-3559-gm0317', 57],
        ['nl-3557-gm0420', 58], ['nl-3557-gm0405', 59], ['nl-3557-gm1598', 60],
        ['nl-3557-gm0424', 61], ['nl-3557-gm0453', 62], ['nl-3557-gm0375', 63],
        ['nl-ze-gm0664', 64], ['nl-ze-gm0654', 65], ['nl-ze-gm1695', 66],
        ['nl-ze-gm0687', 67], ['nl-ze-gm0677', 68], ['nl-3558-gm0748', 69],
        ['nl-ze-gm0716', 70], ['nl-ze-gm0717', 71], ['nl-3558-gm1723', 72],
        ['nl-3558-gm0744', 73], ['nl-fl-gm0995', 74], ['nl-3557-gm0388', 75],
        ['nl-gr-gm0005', 76], ['nl-gr-gm1663', 77], ['nl-gr-gm0053', 78],
        ['nl-gr-gm0056', 79], ['nl-3558-gm1719', 80], ['nl-3558-gm1709', 81],
        ['nl-3558-gm0758', 82], ['nl-3558-gm1655', 83], ['nl-gr-gm1895', 84],
        ['nl-gr-gm1987', 85], ['nl-gr-gm0040', 86], ['nl-fr-gm0140', 87],
        ['nl-fr-gm0055', 88], ['nl-fr-gm0051', 89], ['nl-fr-gm0653', 90],
        ['nl-3558-gm0828', 91], ['nl-3558-gm1671', 92], ['nl-gr-gm0010', 93],
        ['nl-gr-gm0024', 94], ['nl-gr-gm0003', 95], ['nl-ge-gm0267', 96],
        ['nl-fr-gm1891', 97], ['nl-fr-gm1722', 98], ['nl-fr-gm0096', 99],
        ['nl-ov-gm1896', 100], ['nl-ge-gm0232', 101], ['nl-fr-gm0082', 102],
        ['nl-ge-gm0230', 103], ['nl-ge-gm0243', 104], ['nl-ge-gm0233', 105],
        ['nl-ge-gm0203', 106], ['nl-ge-gm0273', 107], ['nl-3559-gm0313', 108],
        ['nl-3557-gm0451', 109], ['nl-3557-gm0362', 110],
        ['nl-3557-gm0415', 111], ['nl-3557-gm0384', 112],
        ['nl-3557-gm0432', 113], ['nl-3557-gm0532', 114],
        ['nl-3557-gm0457', 115], ['nl-3557-gm0425', 116],
        ['nl-3557-gm0381', 117], ['nl-3557-gm0402', 118],
        ['nl-3557-gm0406', 119], ['nl-3557-gm0377', 120],
        ['nl-3560-gm0588', 121], ['nl-3560-gm0584', 122], ['nl-ze-gm0718', 123],
        ['nl-ze-gm0678', 124], ['nl-ze-gm0715', 125], ['nl-ze-gm1714', 126],
        ['nl-3558-gm0851', 127], ['nl-3558-gm1674', 128],
        ['nl-3560-gm1783', 129], ['nl-3560-gm0518', 130],
        ['nl-3560-gm0556', 131], ['nl-3560-gm1842', 132], ['nl-gr-gm0765', 133],
        ['nl-fr-gm0070', 134], ['nl-3557-gm0373', 135], ['nl-3557-gm0441', 136],
        ['nl-gr-gm0009', 137], ['nl-gr-gm0014', 138], ['nl-fr-gm0059', 139],
        ['nl-fr-gm1908', 140], ['nl-fr-gm0063', 141], ['nl-gr-gm0022', 142],
        ['nl-fr-gm0086', 143], ['nl-gr-gm0015', 144], ['nl-fr-gm0090', 145],
        ['nl-gr-gm0025', 146], ['nl-ov-gm0148', 147], ['nl-ov-gm0160', 148],
        ['nl-ov-gm0158', 149], ['nl-ov-gm0164', 150], ['nl-ov-gm0173', 151],
        ['nl-ov-gm0163', 152], ['nl-ov-gm0175', 153], ['nl-ov-gm0177', 154],
        ['nl-fl-gm0184', 155], ['nl-ov-gm0180', 156], ['nl-ge-gm0200', 157],
        ['nl-ge-gm0202', 158], ['nl-ge-gm1705', 159], ['nl-ge-gm0241', 160],
        ['nl-ge-gm0252', 161], ['nl-ge-gm0265', 162], ['nl-ge-gm0213', 163],
        ['nl-ge-gm0277', 164], ['nl-3559-gm0352', 165], ['nl-ge-gm0216', 166],
        ['nl-ge-gm0236', 167], ['nl-ge-gm0281', 168], ['nl-ge-gm0275', 169],
        ['nl-ge-gm0293', 170], ['nl-ge-gm0225', 171], ['nl-ge-gm0296', 172],
        ['nl-ge-gm0299', 173], ['nl-ge-gm0222', 174], ['nl-3559-gm0339', 175],
        ['nl-ge-gm0279', 176], ['nl-ge-gm0228', 177], ['nl-3559-gm0340', 178],
        ['nl-ge-gm0289', 179], ['nl-3559-gm0344', 180], ['nl-3559-gm0312', 181],
        ['nl-3559-gm0321', 182], ['nl-3559-gm0335', 183],
        ['nl-3559-gm0353', 184], ['nl-3559-gm0351', 185],
        ['nl-3559-gm0355', 186], ['nl-3557-gm0393', 187],
        ['nl-3557-gm0365', 188], ['nl-3557-gm0370', 189],
        ['nl-3560-gm0534', 190], ['nl-3557-gm0383', 191],
        ['nl-3557-gm0361', 192], ['nl-3557-gm0416', 193],
        ['nl-3557-gm0439', 194], ['nl-3557-gm0400', 195],
        ['nl-3557-gm0385', 196], ['nl-3557-gm0478', 197],
        ['nl-3557-gm0396', 198], ['nl-3560-gm0484', 199],
        ['nl-3560-gm0499', 200], ['nl-ge-gm0297', 201], ['nl-3560-gm0512', 202],
        ['nl-3558-gm0797', 203], ['nl-3558-gm0865', 204],
        ['nl-3560-gm0523', 205], ['nl-3558-gm0870', 206],
        ['nl-3560-gm0482', 207], ['nl-3560-gm0531', 208],
        ['nl-3560-gm0537', 209], ['nl-3560-gm0545', 210],
        ['nl-3560-gm0546', 211], ['nl-3560-gm0553', 212],
        ['nl-3560-gm0569', 213], ['nl-3557-gm0473', 214],
        ['nl-3560-gm0576', 215], ['nl-3560-gm0489', 216],
        ['nl-3560-gm0585', 217], ['nl-3560-gm0610', 218],
        ['nl-3560-gm0505', 219], ['nl-3560-gm0617', 220],
        ['nl-3560-gm0590', 221], ['nl-3560-gm0503', 222],
        ['nl-3560-gm1892', 223], ['nl-3560-gm0644', 224],
        ['nl-3560-gm0623', 225], ['nl-3560-gm0491', 226],
        ['nl-3560-gm0611', 227], ['nl-3560-gm0613', 228],
        ['nl-3560-gm0608', 229], ['nl-3559-gm0331', 230],
        ['nl-3560-gm0620', 231], ['nl-3559-gm0356', 232],
        ['nl-3560-gm0622', 233], ['nl-3560-gm0626', 234],
        ['nl-3560-gm0547', 235], ['nl-3560-gm0638', 236],
        ['nl-3560-gm0642', 237], ['nl-3560-gm0597', 238],
        ['nl-3560-gm0542', 239], ['nl-3560-gm0643', 240],
        ['nl-3560-gm0502', 241], ['nl-3560-gm0513', 242], ['nl-ge-gm0263', 243],
        ['nl-ge-gm0668', 244], ['nl-3560-gm0689', 245], ['nl-ge-gm0733', 246],
        ['nl-ge-gm0304', 247], ['nl-3559-gm1904', 248], ['nl-3558-gm0753', 249],
        ['nl-3558-gm0772', 250], ['nl-3558-gm0848', 251],
        ['nl-3558-gm0855', 252], ['nl-3558-gm0766', 253],
        ['nl-3558-gm0784', 254], ['nl-3558-gm0779', 255],
        ['nl-3558-gm0785', 256], ['nl-3558-gm0796', 257],
        ['nl-3558-gm0798', 258], ['nl-3558-gm1667', 259],
        ['nl-3558-gm0823', 260], ['nl-3558-gm1728', 261],
        ['nl-3558-gm1659', 262], ['nl-3558-gm0820', 263],
        ['nl-3558-gm0846', 264], ['nl-3558-gm0845', 265],
        ['nl-3558-gm0794', 266], ['nl-3558-gm1652', 267],
        ['nl-3558-gm0847', 268], ['nl-3557-gm0852', 269],
        ['nl-3558-gm0815', 270], ['nl-3558-gm1685', 271],
        ['nl-3558-gm0786', 272], ['nl-3558-gm0856', 273],
        ['nl-3558-gm0858', 274], ['nl-3558-gm0757', 275],
        ['nl-3558-gm1724', 276], ['nl-3558-gm0861', 277],
        ['nl-3558-gm0866', 278], ['nl-3558-gm0867', 279],
        ['nl-3558-gm0874', 280], ['nl-3557-gm0880', 281], ['nl-li-gm0889', 282],
        ['nl-li-gm0899', 283], ['nl-li-gm0881', 284], ['nl-li-gm0882', 285],
        ['nl-li-gm0917', 286], ['nl-li-gm0888', 287], ['nl-li-gm0971', 288],
        ['nl-li-gm1883', 289], ['nl-li-gm0938', 290], ['nl-li-gm0962', 291],
        ['nl-li-gm0935', 292], ['nl-li-gm0994', 293], ['nl-li-gm0986', 294],
        ['nl-3560-gm1525', 295], ['nl-3559-gm0345', 296],
        ['nl-3559-gm1581', 297], ['nl-3557-gm0458', 298], ['nl-li-gm0984', 299],
        ['nl-3558-gm1658', 300], ['nl-li-gm1669', 301], ['nl-li-gm1641', 302],
        ['nl-li-gm0957', 303], ['nl-3560-gm0627', 304], ['nl-3560-gm1672', 305],
        ['nl-3560-gm1621', 306], ['nl-3560-gm0637', 307],
        ['nl-3558-gm0873', 308], ['nl-gr-gm0018', 309], ['nl-li-gm0907', 310],
        ['nl-3558-gm0756', 311], ['nl-3558-gm1684', 312],
        ['nl-3557-gm1696', 313], ['nl-3559-gm0310', 314], ['nl-dr-gm1699', 315],
        ['nl-ov-gm1700', 316], ['nl-dr-gm0118', 317], ['nl-dr-gm1701', 318],
        ['nl-dr-gm1731', 319], ['nl-3558-gm1702', 320], ['nl-3558-gm0755', 321],
        ['nl-ge-gm0196', 322], ['nl-ge-gm0226', 323], ['nl-3558-gm1721', 324],
        ['nl-li-gm0965', 325], ['nl-li-gm1729', 326], ['nl-gr-gm1730', 327],
        ['nl-ge-gm1740', 328], ['nl-ge-gm0262', 329], ['nl-ov-gm1742', 330],
        ['nl-ov-gm0150', 331], ['nl-3558-gm1771', 332], ['nl-ge-gm0285', 333],
        ['nl-ov-gm1773', 334], ['nl-ge-gm1876', 335], ['nl-3560-gm1884', 336],
        ['nl-3558-gm0743', 337], ['nl-li-gm1894', 338], ['nl-3558-gm0762', 339],
        ['nl-3560-gm1916', 340], ['nl-3560-gm0568', 341],
        ['nl-3560-gm1926', 342], ['nl-3560-gm1927', 343],
        ['nl-3557-gm0498', 344], ['nl-3560-gm0530', 345],
        ['nl-3560-gm0501', 346], ['nl-ze-gm0703', 347], ['nl-3558-gm0840', 348],
        ['nl-3558-gm0879', 349], ['nl-li-gm0928', 350], ['nl-li-gm1711', 351],
        ['nl-ov-gm1774', 352], ['nl-gr-gm0037', 353], ['nl-dr-gm1680', 354],
        ['nl-gr-gm0047', 355], ['nl-fr-gm0080', 356], ['nl-fr-gm0081', 357],
        ['nl-fr-gm0098', 358], ['nl-dr-gm0109', 359], ['nl-ov-gm0147', 360],
        ['nl-ov-gm0141', 361], ['nl-ov-gm0189', 362], ['nl-ge-gm0214', 363],
        ['nl-ge-gm0209', 364], ['nl-ge-gm0246', 365], ['nl-ge-gm0221', 366],
        ['nl-ge-gm0268', 367], ['nl-ge-gm0282', 368], ['nl-ge-gm1955', 369],
        ['nl-ge-gm0301', 370], ['nl-3559-gm0327', 371], ['nl-3559-gm0342', 372],
        ['nl-3557-gm0399', 373], ['nl-3557-gm0397', 374],
        ['nl-3560-gm0575', 375], ['nl-3560-gm0579', 376],
        ['nl-3559-gm0589', 377], ['nl-3560-gm0603', 378],
        ['nl-3560-gm0707', 379], ['nl-fr-gm0737', 380], ['nl-3558-gm0738', 381],
        ['nl-3558-gm0770', 382], ['nl-3558-gm0809', 383],
        ['nl-3558-gm0788', 384], ['nl-3558-gm0824', 385],
        ['nl-3558-gm0826', 386], ['nl-3558-gm0777', 387],
        ['nl-3558-gm0860', 388], ['nl-li-gm0944', 389], ['nl-li-gm0946', 390],
        ['nl-li-gm1507', 391], ['nl-li-gm0893', 392], ['nl-3558-gm1706', 393],
        ['nl-gr-gm0048', 394], ['nl-dr-gm1681', 395], ['nl-dr-gm1690', 396],
        ['nl-ge-gm1734', 397], ['nl-li-gm0983', 398], ['nl-ge-gm1509', 399],
        ['nl-ov-gm0183', 400], ['nl-ge-gm0294', 401], ['nl-li-gm0988', 402],
        ['nl-li-gm1903', 403], ['nl-fr-gm0085', 404], ['nl-dr-gm0106', 405],
        ['nl-ov-gm1735', 406], ['nl-3557-gm0450', 407], ['nl-gr-gm0017', 408],
        ['nl-3560-gm0606', 409], ['nl-li-gm0951', 410], ['nl-fr-gm0060', 411],
        ['nl-ov-gm0168', 412], ['nl-dr-gm0114', 413], ['nl-li-gm0981', 414],
        ['nl-fr-gm0074', 415], ['nl-ge-gm0274', 416], ['nl-3558-gm0844', 417],
        [null, 418]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/nl/nl-all-all.topo.json">The Netherlands, admin2</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
