(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/no/no-all-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['no-vl-4628', 10], ['no-vl-4629', 11], ['no-vl-4630', 12],
        ['no-vl-4634', 13], ['no-vl-4632', 14], ['no-vl-4633', 15],
        ['no-vl-4620', 16], ['no-vl-4619', 17], ['no-vl-4622', 18],
        ['no-vl-4627', 19], ['no-vl-4601', 20], ['no-vl-4623', 21],
        ['no-vl-4625', 22], ['no-vl-4616', 23], ['no-vl-4615', 24],
        ['no-vl-4617', 25], ['no-vl-4611', 26], ['no-vl-4614', 27],
        ['no-vl-4613', 28], ['no-vl-4612', 29], ['no-vf-3901', 30],
        ['no-vf-3909', 31], ['no-vf-3907', 32], ['no-vf-3911', 33],
        ['no-vl-4646', 34], ['no-vl-4645', 35], ['no-vl-4637', 36],
        ['no-vl-4636', 37], ['no-te-4036', 38], ['no-te-4026', 39],
        ['no-te-4005', 40], ['no-te-4024', 41], ['no-te-4022', 42],
        ['no-te-4028', 43], ['no-te-4018', 44], ['no-te-4003', 45],
        ['no-te-4016', 46], ['no-te-4032', 47], ['no-te-4034', 48],
        ['no-te-4010', 49], ['no-te-4001', 50], ['no-te-4012', 51],
        ['no-te-4014', 52], ['no-te-4030', 53], ['no-td-5014', 54],
        ['no-mr-1573', 55], ['no-td-5020', 56], ['no-vl-4635', 57],
        ['no-ro-1127', 58], ['no-ro-1124', 59], ['no-ro-1120', 60],
        ['no-ro-1130', 61], ['no-ro-1121', 62], ['no-ro-1119', 63],
        ['no-ro-1111', 64], ['no-ro-1112', 65], ['no-ro-1101', 66],
        ['no-ro-1114', 67], ['no-ro-1122', 68], ['no-ro-1133', 69],
        ['no-ro-1134', 70], ['no-ro-1149', 71], ['no-ro-1145', 72],
        ['no-ro-1106', 73], ['no-ro-1146', 74], ['no-ro-1135', 75],
        ['no-ro-1160', 76], ['no-td-5054', 77], ['no-ag-4207', 78],
        ['no-ag-4228', 79], ['no-ag-4227', 80], ['no-ag-4224', 81],
        ['no-ag-4223', 82], ['no-ag-4206', 83], ['no-ag-4226', 84],
        ['no-ag-4201', 85], ['no-ag-4213', 86], ['no-ag-4222', 87],
        ['no-ag-4221', 88], ['no-ag-4220', 89], ['no-ag-4217', 90],
        ['no-ag-4219', 91], ['no-ag-4218', 92], ['no-ag-4216', 93],
        ['no-ag-4215', 94], ['no-ag-4202', 95], ['no-ag-4203', 96],
        ['no-ag-4212', 97], ['no-ag-4211', 98], ['no-of-3122', 99],
        ['no-of-3124', 100], ['no-of-3101', 101], ['no-of-3110', 102],
        ['no-of-3107', 103], ['no-of-3105', 104], ['no-of-3120', 105],
        ['no-of-3116', 106], ['no-of-3114', 107], ['no-of-3112', 108],
        ['no-ak-3242', 109], ['no-ak-3240', 110], ['no-ak-3209', 111],
        ['no-ak-3228', 112], ['no-ak-3238', 113], ['no-ak-3232', 114],
        ['no-ak-3230', 115], ['no-ak-3222', 116], ['no-ak-3224', 117],
        ['no-ak-3220', 118], ['no-ak-3216', 119], ['no-ak-3214', 120],
        ['no-ak-3212', 121], ['no-ak-3201', 122], ['no-td-5022', 123],
        ['no-td-5021', 124], ['no-td-5027', 125], ['no-td-5026', 126],
        ['no-td-5025', 127], ['no-td-5033', 128], ['no-fi-5605', 129],
        ['no-td-5032', 130], ['no-td-5028', 131], ['no-td-5029', 132],
        ['no-td-5031', 133], ['no-fi-5614', 134], ['no-fi-5616', 135],
        ['no-fi-5618', 136], ['no-fi-5620', 137], ['no-fi-5622', 138],
        ['no-fi-5626', 139], ['no-fi-5630', 140], ['no-fi-5632', 141],
        ['no-fi-5634', 142], ['no-fi-5607', 143], ['no-fi-5636', 144],
        ['no-fi-5628', 145], ['no-fi-5610', 146], ['no-fi-5612', 147],
        ['no-fi-5624', 148], ['no-fi-5601', 149], ['no-mr-1576', 150],
        ['no-td-5061', 151], ['no-mr-1566', 152], ['no-mr-1505', 153],
        ['no-mr-1560', 154], ['no-mr-1563', 155], ['no-mr-1554', 156],
        ['no-mr-1557', 157], ['no-mr-1539', 158], ['no-mr-1547', 159],
        ['no-mr-1535', 160], ['no-mr-1525', 161], ['no-mr-1580', 162],
        ['no-mr-1528', 163], ['no-mr-1532', 164], ['no-mr-1520', 165],
        ['no-mr-1511', 166], ['no-mr-1531', 167], ['no-mr-1517', 168],
        ['no-mr-1516', 169], ['no-mr-1515', 170], ['no-mr-1514', 171],
        ['no-td-5052', 172], ['no-td-5046', 173], ['no-td-5044', 174],
        ['no-td-5043', 175], ['no-td-5047', 176], ['no-td-5045', 177],
        ['no-td-5042', 178], ['no-td-5049', 179], ['no-td-5041', 180],
        ['no-td-5038', 181], ['no-td-5036', 182], ['no-td-5037', 183],
        ['no-td-5035', 184], ['no-td-5034', 185], ['no-ag-4214', 186],
        ['no-tr-5544', 187], ['no-tr-5546', 188], ['no-tr-5542', 189],
        ['no-tr-5540', 190], ['no-tr-5538', 191], ['no-tr-5536', 192],
        ['no-tr-5534', 193], ['no-tr-5501', 194], ['no-tr-5532', 195],
        ['no-tr-5524', 196], ['no-tr-5520', 197], ['no-tr-5526', 198],
        ['no-tr-5528', 199], ['no-tr-5522', 200], ['no-tr-5518', 201],
        ['no-tr-5516', 202], ['no-tr-5503', 203], ['no-tr-5510', 204],
        ['no-tr-5514', 205], ['no-no-1871', 206], ['no-no-1826', 207],
        ['no-no-1832', 208], ['no-no-1833', 209], ['no-no-1840', 210],
        ['no-no-1841', 211], ['no-no-1845', 212], ['no-no-1848', 213],
        ['no-no-1825', 214], ['no-no-1811', 215], ['no-no-1812', 216],
        ['no-no-1813', 217], ['no-no-1824', 218], ['no-no-1816', 219],
        ['no-no-1815', 220], ['no-no-1820', 221], ['no-no-1822', 222],
        ['no-no-1827', 223], ['no-no-1828', 224], ['no-no-1834', 225],
        ['no-no-1836', 226], ['no-no-1874', 227], ['no-no-1859', 228],
        ['no-no-1860', 229], ['no-no-1865', 230], ['no-no-1867', 231],
        ['no-no-1868', 232], ['no-no-1870', 233], ['no-no-1857', 234],
        ['no-no-1866', 235], ['no-no-1853', 236], ['no-no-1804', 237],
        ['no-no-1838', 238], ['no-no-1839', 239], ['no-no-1837', 240],
        ['no-no-1851', 241], ['no-vl-4638', 242], ['no-vl-4639', 243],
        ['no-vl-4641', 244], ['no-vl-4642', 245], ['no-vl-4643', 246],
        ['no-vl-4644', 247], ['no-vl-4651', 248], ['no-vl-4650', 249],
        ['no-vl-4648', 250], ['no-ak-3218', 251], ['no-in-3412', 252],
        ['no-in-3420', 253], ['no-in-3403', 254], ['no-in-3413', 255],
        ['no-in-3419', 256], ['no-in-3422', 257], ['no-in-3411', 258],
        ['no-bu-3312', 259], ['no-bu-3310', 260], ['no-bu-3303', 261],
        ['no-bu-3314', 262], ['no-bu-3334', 263], ['no-bu-3336', 264],
        ['no-bu-3338', 265], ['no-bu-3330', 266], ['no-bu-3328', 267],
        ['no-bu-3326', 268], ['no-bu-3324', 269], ['no-bu-3322', 270],
        ['no-bu-3320', 271], ['no-bu-3305', 272], ['no-bu-3318', 273],
        ['no-bu-3332', 274], ['no-bu-3316', 275], ['no-in-3433', 276],
        ['no-in-3432', 277], ['no-in-3431', 278], ['no-in-3434', 279],
        ['no-in-3435', 280], ['no-in-3437', 281], ['no-in-3436', 282],
        ['no-in-3438', 283], ['no-in-3439', 284], ['no-in-3440', 285],
        ['no-in-3405', 286], ['no-in-3441', 287], ['no-in-3407', 288],
        ['no-in-3442', 289], ['no-in-3443', 290], ['no-in-3446', 291],
        ['no-in-3447', 292], ['no-in-3448', 293], ['no-in-3449', 294],
        ['no-in-3451', 295], ['no-in-3452', 296], ['no-in-3454', 297],
        ['no-in-3450', 298], ['no-ak-3236', 299], ['no-ak-3234', 300],
        ['no-in-3453', 301], ['no-in-3416', 302], ['no-in-3401', 303],
        ['no-in-3415', 304], ['no-in-3414', 305], ['no-in-3417', 306],
        ['no-in-3418', 307], ['no-in-3421', 308], ['no-in-3423', 309],
        ['no-in-3424', 310], ['no-in-3425', 311], ['no-in-3430', 312],
        ['no-in-3426', 313], ['no-in-3427', 314], ['no-in-3428', 315],
        ['no-in-3429', 316], ['no-td-5053', 317], ['no-os-0301', 318],
        ['no-fi-5603', 319], ['no-tr-5512', 320], ['no-tr-5530', 321],
        ['no-no-1806', 322], ['no-no-1875', 323], ['no-td-5060', 324],
        ['no-td-5007', 325], ['no-td-5058', 326], ['no-td-5006', 327],
        ['no-td-5057', 328], ['no-td-5056', 329], ['no-td-5055', 330],
        ['no-td-5059', 331], ['no-td-5001', 332], ['no-mr-1506', 333],
        ['no-mr-1579', 334], ['no-mr-1578', 335], ['no-mr-1577', 336],
        ['no-vl-4649', 337], ['no-vl-4602', 338], ['no-vl-4647', 339],
        ['no-vl-4640', 340], ['no-vl-4621', 341], ['no-vl-4631', 342],
        ['no-vl-4626', 343], ['no-vl-4624', 344], ['no-vl-4618', 345],
        ['no-ro-1103', 346], ['no-ro-1108', 347], ['no-ag-4225', 348],
        ['no-ag-4204', 349], ['no-ag-4205', 350], ['no-te-4020', 351],
        ['no-vf-3905', 352], ['no-ak-3205', 353], ['no-ak-3226', 354],
        ['no-ak-3207', 355], ['no-of-3118', 356], ['no-of-3103', 357],
        ['no-bu-3301', 358], ['no-vf-3903', 359], ['no-ak-3203', 360],
        ['no-mr-1508', 361]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/no/no-all-all.topo.json">Norway, admin2</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
