(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/sr/sr-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['sr-ni', 10], ['sr-ma', 11], ['sr-pr', 12], ['sr-br', 13],
        ['sr-si', 14], ['sr-cm', 15], ['sr-cr', 16], ['sr-pm', 17],
        ['sr-sa', 18], ['sr-wa', 19]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/sr/sr-all.topo.json">Suriname</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
