(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/us/custom/us-113-congress.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['us-ca-24', 10], ['us-id-01', 11], ['us-tn-02', 12], ['us-ne-02', 13],
        ['us-md-06', 14], ['us-ma-09', 15], ['us-wi-08', 16], ['us-wi-03', 17],
        ['us-mi-01', 18], ['us-ut-03', 19], ['us-az-01', 20], ['us-me-02', 21],
        ['us-la-03', 22], ['us-tx-23', 23], ['us-nm-02', 24], ['us-tn-05', 25],
        ['us-sd-00', 26], ['us-wy-00', 27], ['us-ny-23', 28], ['us-pa-05', 29],
        ['us-co-03', 30], ['us-nm-03', 31], ['us-tx-14', 32], ['us-ca-47', 33],
        ['us-ca-26', 34], ['us-ca-14', 35], ['us-fl-26', 36], ['us-wv-01', 37],
        ['us-pa-18', 38], ['us-ri-02', 39], ['us-ct-02', 40], ['us-ny-10', 41],
        ['us-tn-04', 42], ['us-mi-02', 43], ['us-mi-03', 44], ['us-va-10', 45],
        ['us-mn-02', 46], ['us-mn-06', 47], ['us-mn-04', 48], ['us-il-01', 49],
        ['us-il-05', 50], ['us-il-07', 51], ['us-il-02', 52], ['us-ca-33', 53],
        ['us-ca-36', 54], ['us-ca-31', 55], ['us-ca-48', 56], ['us-ca-46', 57],
        ['us-ar-03', 58], ['us-ar-02', 59], ['us-ca-34', 60], ['us-ca-30', 61],
        ['us-ca-18', 62], ['us-ca-20', 63], ['us-ca-16', 64], ['us-ca-22', 65],
        ['us-ca-37', 66], ['us-ca-43', 67], ['us-ca-32', 68], ['us-ca-35', 69],
        ['us-ca-42', 70], ['us-ca-49', 71], ['us-ca-44', 72], ['us-ca-15', 73],
        ['us-ca-19', 74], ['us-ca-10', 75], ['us-ia-04', 76], ['us-ia-02', 77],
        ['us-mn-03', 78], ['us-mn-05', 79], ['us-ca-52', 80], ['us-ca-25', 81],
        ['us-ca-29', 82], ['us-ca-07', 83], ['us-ca-06', 84], ['us-ca-39', 85],
        ['us-al-05', 86], ['us-ca-02', 87], ['us-ca-12', 88], ['us-ca-05', 89],
        ['us-ca-11', 90], ['us-ca-03', 91], ['us-il-04', 92], ['us-il-16', 93],
        ['us-in-04', 94], ['us-in-01', 95], ['us-wi-01', 96], ['us-il-10', 97],
        ['us-ca-50', 98], ['us-ca-53', 99], ['us-ca-08', 100],
        ['us-il-06', 101], ['us-il-03', 102], ['us-ga-04', 103],
        ['us-ga-05', 104], ['us-ga-13', 105], ['us-ga-10', 106],
        ['us-tn-03', 107], ['us-ca-51', 108], ['us-ca-28', 109],
        ['us-ga-07', 110], ['us-ga-09', 111], ['us-ga-06', 112],
        ['us-ga-14', 113], ['us-la-06', 114], ['us-la-01', 115],
        ['us-ms-04', 116], ['us-ar-04', 117], ['us-la-05', 118],
        ['us-ar-01', 119], ['us-in-02', 120], ['us-in-05', 121],
        ['us-in-09', 122], ['us-in-07', 123], ['us-in-06', 124],
        ['us-in-03', 125], ['us-il-11', 126], ['us-il-09', 127],
        ['us-il-18', 128], ['us-il-15', 129], ['us-ca-40', 130],
        ['us-ca-13', 131], ['us-ca-45', 132], ['us-ia-03', 133],
        ['us-ga-11', 134], ['us-ca-04', 135], ['us-ca-09', 136],
        ['us-tn-08', 137], ['us-tn-09', 138], ['us-ca-41', 139],
        ['us-ca-27', 140], ['us-ca-17', 141], ['us-ky-01', 142],
        ['us-ky-05', 143], ['us-ky-03', 144], ['us-ky-02', 145],
        ['us-ky-04', 146], ['us-il-12', 147], ['us-il-08', 148],
        ['us-or-04', 149], ['us-ca-38', 150], ['us-al-04', 151],
        ['us-ms-01', 152], ['us-fl-22', 153], ['us-mo-01', 154],
        ['us-mo-03', 155], ['us-mo-08', 156], ['us-al-07', 157],
        ['us-al-06', 158], ['us-al-01', 159], ['us-al-02', 160],
        ['us-nj-03', 161], ['us-nj-05', 162], ['us-nj-07', 163],
        ['us-nj-02', 164], ['us-nj-09', 165], ['us-nj-06', 166],
        ['us-nj-10', 167], ['us-nv-02', 168], ['us-id-02', 169],
        ['us-ut-01', 170], ['us-ga-12', 171], ['us-sc-03', 172],
        ['us-sc-01', 173], ['us-sc-07', 174], ['us-sc-06', 175],
        ['us-ga-01', 176], ['us-wa-10', 177], ['us-wa-03', 178],
        ['us-wa-06', 179], ['us-oh-10', 180], ['us-oh-15', 181],
        ['us-oh-07', 182], ['us-oh-13', 183], ['us-oh-04', 184],
        ['us-oh-09', 185], ['us-oh-01', 186], ['us-oh-11', 187],
        ['us-oh-05', 188], ['us-mi-07', 189], ['us-mi-08', 190],
        ['us-oh-08', 191], ['us-oh-12', 192], ['us-va-01', 193],
        ['us-va-05', 194], ['us-va-04', 195], ['us-va-02', 196],
        ['us-va-09', 197], ['us-mi-06', 198], ['us-mi-04', 199],
        ['us-mi-14', 200], ['us-mi-13', 201], ['us-mi-10', 202],
        ['us-mi-05', 203], ['us-mi-11', 204], ['us-mi-09', 205],
        ['us-mi-12', 206], ['us-va-08', 207], ['us-wa-07', 208],
        ['us-wa-02', 209], ['us-wa-01', 210], ['us-wa-09', 211],
        ['us-wa-08', 212], ['us-nj-11', 213], ['us-nj-08', 214],
        ['us-co-01', 215], ['us-co-04', 216], ['us-ok-03', 217],
        ['us-co-02', 218], ['us-co-07', 219], ['us-co-06', 220],
        ['us-md-01', 221], ['us-pa-04', 222], ['us-va-11', 223],
        ['us-md-05', 224], ['us-md-03', 225], ['us-md-07', 226],
        ['us-md-02', 227], ['us-md-04', 228], ['us-md-08', 229],
        ['us-dc-98', 230], ['us-mo-04', 231], ['us-ks-03', 232],
        ['us-mo-07', 233], ['us-ks-02', 234], ['us-ma-03', 235],
        ['us-ma-05', 236], ['us-ma-07', 237], ['us-vt-00', 238],
        ['us-ma-02', 239], ['us-ma-04', 240], ['us-ma-06', 241],
        ['us-ma-08', 242], ['us-wv-03', 243], ['us-oh-06', 244],
        ['us-il-17', 245], ['us-wi-02', 246], ['us-wi-04', 247],
        ['us-wi-07', 248], ['us-wi-06', 249], ['us-nc-01', 250],
        ['us-sc-04', 251], ['us-nc-10', 252], ['us-nc-11', 253],
        ['us-sc-05', 254], ['us-nc-08', 255], ['us-nc-06', 256],
        ['us-nc-02', 257], ['us-nc-12', 258], ['us-nh-01', 259],
        ['us-nh-02', 260], ['us-ks-04', 261], ['us-ok-01', 262],
        ['us-de-00', 263], ['us-pa-01', 264], ['us-pa-13', 265],
        ['us-nj-01', 266], ['us-pa-07', 267], ['us-pa-02', 268],
        ['us-pa-03', 269], ['us-pa-10', 270], ['us-ny-22', 271],
        ['us-pa-06', 272], ['us-pa-16', 273], ['us-pa-08', 274],
        ['us-pa-09', 275], ['us-pa-15', 276], ['us-pa-12', 277],
        ['us-nj-12', 278], ['us-nj-04', 279], ['us-fl-08', 280],
        ['us-fl-17', 281], ['us-fl-09', 282], ['us-fl-07', 283],
        ['us-fl-27', 284], ['us-fl-14', 285], ['us-fl-13', 286],
        ['us-fl-24', 287], ['us-fl-16', 288], ['us-fl-11', 289],
        ['us-fl-15', 290], ['us-fl-23', 291], ['us-fl-06', 292],
        ['us-fl-12', 293], ['us-fl-18', 294], ['us-ga-08', 295],
        ['us-fl-02', 296], ['us-fl-20', 297], ['us-fl-25', 298],
        ['us-fl-19', 299], ['us-fl-03', 300], ['us-fl-10', 301],
        ['us-az-03', 302], ['us-az-05', 303], ['us-az-07', 304],
        ['us-az-06', 305], ['us-az-09', 306], ['us-ut-02', 307],
        ['us-az-04', 308], ['us-az-08', 309], ['us-tx-06', 310],
        ['us-tx-17', 311], ['us-tx-16', 312], ['us-tx-27', 313],
        ['us-tx-15', 314], ['us-tx-24', 315], ['us-tx-30', 316],
        ['us-tx-02', 317], ['us-tx-29', 318], ['us-tx-32', 319],
        ['us-tx-20', 320], ['us-tx-21', 321], ['us-tx-03', 322],
        ['us-tx-31', 323], ['us-tx-10', 324], ['us-ok-04', 325],
        ['us-tx-04', 326], ['us-ok-02', 327], ['us-la-04', 328],
        ['us-tx-25', 329], ['us-tx-35', 330], ['us-tx-28', 331],
        ['us-tx-11', 332], ['us-tx-13', 333], ['us-tx-26', 334],
        ['us-tx-07', 335], ['us-tx-22', 336], ['us-tx-36', 337],
        ['us-tx-09', 338], ['us-tx-18', 339], ['us-ri-01', 340],
        ['us-ma-01', 341], ['us-ct-01', 342], ['us-ct-05', 343],
        ['us-ct-03', 344], ['us-ct-04', 345], ['us-ny-03', 346],
        ['us-mt-00', 347], ['us-ny-01', 348], ['us-ny-27', 349],
        ['us-ny-25', 350], ['us-ny-14', 351], ['us-ny-06', 352],
        ['us-ny-07', 353], ['us-ny-05', 354], ['us-ny-24', 355],
        ['us-ny-16', 356], ['us-ny-17', 357], ['us-ny-11', 358],
        ['us-ny-15', 359], ['us-ny-08', 360], ['us-ny-12', 361],
        ['us-ny-18', 362], ['us-ny-02', 363], ['us-ny-04', 364],
        ['us-ny-13', 365], ['us-ny-09', 366], ['us-ny-21', 367],
        ['us-ny-19', 368], ['us-mn-07', 369], ['us-ne-01', 370],
        ['us-ne-03', 371], ['us-il-14', 372], ['us-or-01', 373],
        ['us-or-03', 374], ['us-tn-07', 375], ['us-nc-05', 376],
        ['us-tn-01', 377], ['us-il-13', 378], ['us-ga-03', 379],
        ['us-ca-01', 380], ['us-tn-06', 381], ['us-ga-02', 382],
        ['us-al-03', 383], ['us-mo-05', 384], ['us-mo-06', 385],
        ['us-nv-04', 386], ['us-nv-03', 387], ['us-nv-01', 388],
        ['us-sc-02', 389], ['us-oh-16', 390], ['us-oh-14', 391],
        ['us-oh-03', 392], ['us-va-03', 393], ['us-va-07', 394],
        ['us-va-06', 395], ['us-wa-04', 396], ['us-wi-05', 397],
        ['us-nc-07', 398], ['us-nc-04', 399], ['us-nc-13', 400],
        ['us-nc-09', 401], ['us-ok-05', 402], ['us-pa-17', 403],
        ['us-pa-14', 404], ['us-pa-11', 405], ['us-tx-19', 406],
        ['us-tx-08', 407], ['us-tx-01', 408], ['us-tx-33', 409],
        ['us-tx-12', 410], ['us-ny-26', 411], ['us-nc-03', 412],
        ['us-mn-08', 413], ['us-me-01', 414], ['us-tx-34', 415],
        ['us-mn-01', 416], ['us-ca-23', 417], ['us-oh-02', 418],
        ['us-fl-21', 419], ['us-fl-04', 420], ['us-fl-05', 421],
        ['us-az-02', 422], ['us-tx-05', 423], ['us-in-08', 424],
        ['us-la-02', 425], ['us-fl-01', 426], ['us-ms-03', 427],
        ['us-wv-02', 428], ['us-or-05', 429], ['us-nd-00', 430],
        ['us-ia-01', 431], ['us-wa-05', 432], ['us-ks-01', 433],
        ['us-ms-02', 434], ['us-or-02', 435], ['us-mo-02', 436],
        ['us-co-05', 437], ['us-ny-20', 438], ['us-nm-01', 439],
        ['us-ca-21', 440], ['us-ky-06', 441], ['us-ut-04', 442], [null, 443],
        ['us-hi-02', 444], ['us-hi-01', 445], ['us-ak-00', 446]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/us/custom/us-113-congress.topo.json">United States of America, congressional districts (113th)</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
