(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/us/us-all-all-highres.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['us-ca-083', 10], ['us-ca-111', 11], ['us-ca-037', 12],
        ['us-ri-009', 13], ['us-fl-087', 14], ['us-wa-069', 15],
        ['us-mi-089', 16], ['us-mi-003', 17], ['us-ma-001', 18],
        ['us-fl-086', 19], ['us-fl-017', 20], ['us-ny-103', 21],
        ['us-mi-033', 22], ['us-al-097', 23], ['us-co-014', 24],
        ['us-nc-031', 25], ['us-tx-007', 26], ['us-wi-003', 27],
        ['us-la-087', 28], ['us-wa-031', 29], ['us-md-019', 30],
        ['us-ma-007', 31], ['us-ma-019', 32], ['us-ny-045', 33],
        ['us-fl-037', 34], ['us-or-007', 35], ['us-co-031', 36],
        ['us-co-005', 37], ['us-tx-167', 38], ['us-ga-039', 39],
        ['us-wi-007', 40], ['us-ny-085', 41], ['us-la-075', 42],
        ['us-me-027', 43], ['us-fl-071', 44], ['us-wa-073', 45],
        ['us-nj-029', 46], ['us-ga-179', 47], ['us-fl-075', 48],
        ['us-nc-095', 49], ['us-sc-019', 50], ['us-md-039', 51],
        ['us-la-051', 52], ['us-va-001', 53], ['us-nc-129', 54],
        ['us-wa-033', 55], ['us-wa-049', 56], ['us-ms-047', 57],
        ['us-fl-021', 58], ['us-ms-059', 59], ['us-wa-055', 60],
        ['us-la-109', 61], ['us-me-015', 62], ['us-tx-321', 63],
        ['us-mi-097', 64], ['us-la-057', 65], ['us-fl-009', 66],
        ['us-me-009', 67], ['us-me-029', 68], ['us-me-013', 69],
        ['us-mi-029', 70], ['us-ri-005', 71], ['us-wa-045', 72],
        ['us-wa-057', 73], ['us-nc-019', 74], ['us-va-131', 75],
        ['us-ga-191', 76], ['us-wa-053', 77], ['us-nc-055', 78],
        ['us-nj-001', 79], ['us-wi-029', 80], ['us-va-600', 81],
        ['us-va-059', 82], ['us-tx-057', 83], ['us-nm-003', 84],
        ['us-nm-017', 85], ['us-nd-019', 86], ['us-ut-003', 87],
        ['us-nv-007', 88], ['us-or-037', 89], ['us-ca-049', 90],
        ['us-sd-121', 91], ['us-sd-095', 92], ['us-wa-047', 93],
        ['us-tx-371', 94], ['us-tx-043', 95], ['us-mi-141', 96],
        ['us-mt-005', 97], ['us-mt-041', 98], ['us-mn-075', 99],
        ['us-nm-031', 100], ['us-az-001', 101], ['us-tx-243', 102],
        ['us-tx-377', 103], ['us-tn-043', 104], ['us-mt-019', 105],
        ['us-va-750', 106], ['us-tn-105', 107], ['us-mt-013', 108],
        ['us-mt-015', 109], ['us-va-580', 110], ['us-nd-023', 111],
        ['us-co-097', 112], ['us-co-045', 113], ['us-va-690', 114],
        ['us-la-113', 115], ['us-mn-135', 116], ['us-nh-007', 117],
        ['us-tx-261', 118], ['us-wy-001', 119], ['us-wy-007', 120],
        ['us-ca-027', 121], ['us-ca-071', 122], ['us-ny-065', 123],
        ['us-ny-049', 124], ['us-va-515', 125], ['us-in-033', 126],
        ['us-in-151', 127], ['us-va-153', 128], ['us-va-179', 129],
        ['us-ga-097', 130], ['us-ga-067', 131], ['us-mt-053', 132],
        ['us-id-021', 133], ['us-ga-145', 134], ['us-ga-285', 135],
        ['us-wi-107', 136], ['us-wi-119', 137], ['us-tx-373', 138],
        ['us-va-820', 139], ['us-va-790', 140], ['us-va-540', 141],
        ['us-mt-101', 142], ['us-va-595', 143], ['us-tn-037', 144],
        ['us-oh-065', 145], ['us-oh-091', 146], ['us-va-678', 147],
        ['us-va-530', 148], ['us-va-720', 149], ['us-id-073', 150],
        ['us-or-045', 151], ['us-ny-057', 152], ['us-ny-035', 153],
        ['us-nd-075', 154], ['us-nd-009', 155], ['us-ut-025', 156],
        ['us-az-005', 157], ['us-co-011', 158], ['us-co-061', 159],
        ['us-me-007', 160], ['us-va-660', 161], ['us-va-683', 162],
        ['us-va-840', 163], ['us-mt-105', 164], ['us-az-027', 165],
        ['us-az-019', 166], ['us-az-013', 167], ['us-nv-033', 168],
        ['us-nv-011', 169], ['us-ca-075', 170], ['us-ca-041', 171],
        ['us-fl-053', 172], ['us-mi-019', 173], ['us-mi-163', 174],
        ['us-ny-059', 175], ['us-co-069', 176], ['us-co-013', 177],
        ['us-co-059', 178], ['us-nc-049', 179], ['us-wi-113', 180],
        ['us-md-011', 181], ['us-md-041', 182], ['us-md-045', 183],
        ['us-co-001', 184], ['us-co-035', 185], ['us-co-093', 186],
        ['us-tx-071', 187], ['us-tx-201', 188], ['us-me-031', 189],
        ['us-co-075', 190], ['us-co-123', 191], ['us-tx-061', 192],
        ['us-tx-215', 193], ['us-md-047', 194], ['us-fl-051', 195],
        ['us-la-101', 196], ['us-ny-061', 197], ['us-ny-005', 198],
        ['us-ny-047', 199], ['us-wa-035', 200], ['us-wa-067', 201],
        ['us-ga-127', 202], ['us-nj-009', 203], ['us-md-033', 204],
        ['us-tx-391', 205], ['us-az-017', 206], ['us-wy-031', 207],
        ['us-wy-021', 208], ['us-tn-021', 209], ['us-tn-147', 210],
        ['us-tn-149', 211], ['us-ne-031', 212], ['us-nv-023', 213],
        ['us-nv-021', 214], ['us-nv-017', 215], ['us-nv-003', 216],
        ['us-ut-027', 217], ['us-fl-029', 218], ['us-fl-067', 219],
        ['us-fl-121', 220], ['us-ut-023', 221], ['us-wa-017', 222],
        ['us-oh-003', 223], ['us-oh-137', 224], ['us-in-135', 225],
        ['us-in-065', 226], ['us-in-177', 227], ['us-tx-443', 228],
        ['us-tx-105', 229], ['us-tn-125', 230], ['us-va-685', 231],
        ['us-in-105', 232], ['us-in-093', 233], ['us-in-071', 234],
        ['us-in-101', 235], ['us-co-009', 236], ['us-co-071', 237],
        ['us-nc-137', 238], ['us-nc-013', 239], ['us-mn-031', 240],
        ['us-nm-043', 241], ['us-ut-037', 242], ['us-pa-101', 243],
        ['us-nj-007', 244], ['us-nc-103', 245], ['us-md-035', 246],
        ['us-wi-117', 247], ['us-or-041', 248], ['us-or-057', 249],
        ['us-ne-105', 250], ['us-co-125', 251], ['us-tx-389', 252],
        ['us-nc-187', 253], ['us-sc-015', 254], ['us-la-095', 255],
        ['us-ma-005', 256], ['us-ri-001', 257], ['us-ma-023', 258],
        ['us-wa-041', 259], ['us-wa-027', 260], ['us-mt-091', 261],
        ['us-md-003', 262], ['us-al-071', 263], ['us-al-095', 264],
        ['us-tn-051', 265], ['us-tn-031', 266], ['us-tn-145', 267],
        ['us-ga-293', 268], ['us-ga-231', 269], ['us-va-191', 270],
        ['us-va-520', 271], ['us-ga-249', 272], ['us-ga-269', 273],
        ['us-ga-079', 274], ['us-ga-197', 275], ['us-va-095', 276],
        ['us-va-830', 277], ['us-ga-273', 278], ['us-ga-037', 279],
        ['us-ga-177', 280], ['us-oh-063', 281], ['us-oh-173', 282],
        ['us-oh-175', 283], ['us-ut-033', 284], ['us-wy-023', 285],
        ['us-wy-037', 286], ['us-id-007', 287], ['us-wy-039', 288],
        ['us-la-023', 289], ['us-la-019', 290], ['us-tx-361', 291],
        ['us-mi-007', 292], ['us-tn-137', 293], ['us-ky-053', 294],
        ['us-ky-231', 295], ['us-fl-129', 296], ['us-fl-131', 297],
        ['us-fl-059', 298], ['us-fl-133', 299], ['us-ne-059', 300],
        ['us-ne-035', 301], ['us-ne-181', 302], ['us-ne-129', 303],
        ['us-ks-157', 304], ['us-ne-001', 305], ['us-mi-109', 306],
        ['us-mi-103', 307], ['us-mi-043', 308], ['us-mi-013', 309],
        ['us-wy-041', 310], ['us-sd-067', 311], ['us-sd-043', 312],
        ['us-in-069', 313], ['us-in-003', 314], ['us-ga-025', 315],
        ['us-ga-049', 316], ['us-ga-015', 317], ['us-ga-129', 318],
        ['us-ga-115', 319], ['us-ga-233', 320], ['us-ne-089', 321],
        ['us-ne-015', 322], ['us-ne-103', 323], ['us-mo-083', 324],
        ['us-mo-101', 325], ['us-mo-107', 326], ['us-wi-093', 327],
        ['us-wi-033', 328], ['us-co-109', 329], ['us-co-003', 330],
        ['us-co-027', 331], ['us-wi-063', 332], ['us-wi-053', 333],
        ['us-ny-101', 334], ['us-ny-003', 335], ['us-ny-121', 336],
        ['us-ny-051', 337], ['us-ga-063', 338], ['us-ga-089', 339],
        ['us-ks-111', 340], ['us-ks-073', 341], ['us-ks-031', 342],
        ['us-ks-207', 343], ['us-in-111', 344], ['us-il-091', 345],
        ['us-in-073', 346], ['us-in-149', 347], ['us-in-131', 348],
        ['us-in-181', 349], ['us-in-007', 350], ['us-tx-245', 351],
        ['us-al-049', 352], ['us-al-019', 353], ['us-mt-065', 354],
        ['us-mt-087', 355], ['us-co-017', 356], ['us-ks-199', 357],
        ['us-co-067', 358], ['us-co-111', 359], ['us-co-113', 360],
        ['us-ut-057', 361], ['us-ut-005', 362], ['us-id-041', 363],
        ['us-tx-327', 364], ['us-tx-413', 365], ['us-me-023', 366],
        ['us-me-001', 367], ['us-me-011', 368], ['us-mt-059', 369],
        ['us-mt-097', 370], ['us-ok-095', 371], ['us-tx-181', 372],
        ['us-wv-103', 373], ['us-pa-059', 374], ['us-pa-051', 375],
        ['us-al-091', 376], ['us-al-065', 377], ['us-al-105', 378],
        ['us-ky-209', 379], ['us-ky-017', 380], ['us-il-113', 381],
        ['us-il-147', 382], ['us-il-203', 383], ['us-il-019', 384],
        ['us-il-053', 385], ['us-il-139', 386], ['us-al-063', 387],
        ['us-id-051', 388], ['us-id-033', 389], ['us-nc-037', 390],
        ['us-nc-063', 391], ['us-ia-151', 392], ['us-ia-187', 393],
        ['us-ia-025', 394], ['us-ia-027', 395], ['us-tx-147', 396],
        ['us-tx-119', 397], ['us-tn-159', 398], ['us-tn-169', 399],
        ['us-or-029', 400], ['us-or-035', 401], ['us-tx-127', 402],
        ['us-tx-507', 403], ['us-fl-011', 404], ['us-mi-151', 405],
        ['us-nc-145', 406], ['us-ms-151', 407], ['us-ms-055', 408],
        ['us-ms-125', 409], ['us-ar-085', 410], ['us-ar-001', 411],
        ['us-tx-027', 412], ['us-tx-309', 413], ['us-fl-099', 414],
        ['us-ga-073', 415], ['us-ga-181', 416], ['us-ga-189', 417],
        ['us-ky-003', 418], ['us-tn-165', 419], ['us-or-005', 420],
        ['us-or-051', 421], ['us-tn-115', 422], ['us-tn-061', 423],
        ['us-in-179', 424], ['us-in-075', 425], ['us-in-009', 426],
        ['us-va-121', 427], ['us-va-063', 428], ['us-ms-145', 429],
        ['us-ms-009', 430], ['us-ia-109', 431], ['us-ia-147', 432],
        ['us-ia-063', 433], ['us-ia-053', 434], ['us-ia-159', 435],
        ['us-nc-001', 436], ['us-nc-151', 437], ['us-in-171', 438],
        ['us-ne-109', 439], ['us-ne-151', 440], ['us-ia-031', 441],
        ['us-ia-045', 442], ['us-va-073', 443], ['us-va-097', 444],
        ['us-va-119', 445], ['us-pa-123', 446], ['us-pa-053', 447],
        ['us-pa-065', 448], ['us-in-089', 449], ['us-tn-027', 450],
        ['us-wa-013', 451], ['us-or-063', 452], ['us-or-001', 453],
        ['us-ky-127', 454], ['us-ky-175', 455], ['us-il-025', 456],
        ['us-il-049', 457], ['us-il-051', 458], ['us-il-035', 459],
        ['us-tn-123', 460], ['us-in-157', 461], ['us-in-107', 462],
        ['us-in-063', 463], ['us-tx-277', 464], ['us-nd-035', 465],
        ['us-nd-099', 466], ['us-nd-067', 467], ['us-ks-071', 468],
        ['us-co-099', 469], ['us-ks-075', 470], ['us-mo-057', 471],
        ['us-mo-167', 472], ['us-mo-109', 473], ['us-il-029', 474],
        ['us-il-033', 475], ['us-il-079', 476], ['us-ia-073', 477],
        ['us-pa-031', 478], ['us-in-117', 479], ['us-in-037', 480],
        ['us-in-027', 481], ['us-in-083', 482], ['us-in-123', 483],
        ['us-in-025', 484], ['us-in-173', 485], ['us-in-147', 486],
        ['us-in-163', 487], ['us-va-057', 488], ['us-mn-043', 489],
        ['us-mn-147', 490], ['us-mn-047', 491], ['us-ia-195', 492],
        ['us-va-167', 493], ['us-va-027', 494], ['us-co-089', 495],
        ['us-ok-135', 496], ['us-ok-079', 497], ['us-ok-101', 498],
        ['us-mo-043', 499], ['us-mo-067', 500], ['us-mo-215', 501],
        ['us-in-115', 502], ['us-in-137', 503], ['us-in-031', 504],
        ['us-in-139', 505], ['us-la-021', 506], ['us-la-049', 507],
        ['us-mt-073', 508], ['us-ct-007', 509], ['us-ct-011', 510],
        ['us-in-161', 511], ['us-oh-017', 512], ['us-oh-165', 513],
        ['us-mo-145', 514], ['us-mo-119', 515], ['us-ne-033', 516],
        ['us-ne-007', 517], ['us-ne-157', 518], ['us-wy-015', 519],
        ['us-ne-165', 520], ['us-ga-263', 521], ['us-al-081', 522],
        ['us-nd-081', 523], ['us-nd-021', 524], ['us-mn-085', 525],
        ['us-mn-143', 526], ['us-ga-171', 527], ['us-ca-097', 528],
        ['us-id-065', 529], ['us-id-019', 530], ['us-ga-297', 531],
        ['us-ga-013', 532], ['us-ok-115', 533], ['us-ok-035', 534],
        ['us-ks-021', 535], ['us-pa-033', 536], ['us-il-167', 537],
        ['us-il-135', 538], ['us-il-005', 539], ['us-ms-071', 540],
        ['us-ms-115', 541], ['us-mn-055', 542], ['us-mn-045', 543],
        ['us-ia-191', 544], ['us-mn-099', 545], ['us-mn-109', 546],
        ['us-mn-039', 547], ['us-sd-097', 548], ['us-sd-087', 549],
        ['us-sd-099', 550], ['us-sd-101', 551], ['us-al-017', 552],
        ['us-in-047', 553], ['us-mn-121', 554], ['us-mn-067', 555],
        ['us-tx-177', 556], ['us-tx-149', 557], ['us-tx-011', 558],
        ['us-tx-045', 559], ['us-mi-071', 560], ['us-mi-131', 561],
        ['us-mn-133', 562], ['us-mn-105', 563], ['us-ia-119', 564],
        ['us-la-111', 565], ['us-la-061', 566], ['us-la-027', 567],
        ['us-pa-043', 568], ['us-pa-097', 569], ['us-pa-067', 570],
        ['us-pa-099', 571], ['us-pa-071', 572], ['us-ok-027', 573],
        ['us-ok-017', 574], ['us-ok-015', 575], ['us-wv-079', 576],
        ['us-wv-011', 577], ['us-ar-137', 578], ['us-ar-141', 579],
        ['us-co-119', 580], ['us-co-065', 581], ['us-co-117', 582],
        ['us-ny-089', 583], ['us-ny-041', 584], ['us-ny-091', 585],
        ['us-va-005', 586], ['us-va-045', 587], ['us-va-023', 588],
        ['us-va-161', 589], ['us-mo-081', 590], ['us-ga-045', 591],
        ['us-ga-223', 592], ['us-tn-041', 593], ['us-tn-141', 594],
        ['us-nd-013', 595], ['us-nd-101', 596], ['us-ma-027', 597],
        ['us-nh-011', 598], ['us-nh-005', 599], ['us-ny-111', 600],
        ['us-ny-027', 601], ['us-tx-225', 602], ['us-tx-313', 603],
        ['us-tx-041', 604], ['us-tx-477', 605], ['us-co-101', 606],
        ['us-co-041', 607], ['us-mo-105', 608], ['us-sc-033', 609],
        ['us-nc-155', 610], ['us-nc-051', 611], ['us-mi-001', 612],
        ['us-ca-067', 613], ['us-ca-017', 614], ['us-ca-061', 615],
        ['us-ca-115', 616], ['us-ar-129', 617], ['us-nc-093', 618],
        ['us-nc-165', 619], ['us-mo-005', 620], ['us-ia-071', 621],
        ['us-mo-087', 622], ['us-ne-131', 623], ['us-pa-023', 624],
        ['us-sd-073', 625], ['us-sd-015', 626], ['us-sd-023', 627],
        ['us-tn-177', 628], ['us-tn-185', 629], ['us-il-023', 630],
        ['us-sc-035', 631], ['us-ks-139', 632], ['us-oh-133', 633],
        ['us-oh-155', 634], ['us-oh-007', 635], ['us-pa-019', 636],
        ['us-pa-005', 637], ['us-pa-073', 638], ['us-pa-007', 639],
        ['us-ks-113', 640], ['us-ks-115', 641], ['us-mo-225', 642],
        ['us-mn-033', 643], ['us-al-057', 644], ['us-al-125', 645],
        ['us-al-099', 646], ['us-al-013', 647], ['us-al-035', 648],
        ['us-al-131', 649], ['us-ms-015', 650], ['us-ms-097', 651],
        ['us-ne-099', 652], ['us-id-081', 653], ['us-il-161', 654],
        ['us-ar-113', 655], ['us-ar-133', 656], ['us-wy-043', 657],
        ['us-wy-013', 658], ['us-ny-097', 659], ['us-ny-015', 660],
        ['us-ar-069', 661], ['us-wi-123', 662], ['us-wi-111', 663],
        ['us-wi-049', 664], ['us-wi-025', 665], ['us-wi-043', 666],
        ['us-mo-123', 667], ['us-mo-093', 668], ['us-tx-289', 669],
        ['us-tx-005', 670], ['us-ks-195', 671], ['us-ks-051', 672],
        ['us-ks-165', 673], ['us-ks-187', 674], ['us-tx-463', 675],
        ['us-tx-325', 676], ['us-tx-019', 677], ['us-tx-029', 678],
        ['us-tx-013', 679], ['us-mn-063', 680], ['us-ia-059', 681],
        ['us-mn-165', 682], ['us-ok-063', 683], ['us-ok-029', 684],
        ['us-tx-103', 685], ['us-tx-461', 686], ['us-in-051', 687],
        ['us-in-129', 688], ['us-va-510', 689], ['us-dc-001', 690],
        ['us-va-013', 691], ['us-mn-171', 692], ['us-co-037', 693],
        ['us-co-085', 694], ['us-fl-109', 695], ['us-ms-019', 696],
        ['us-mo-079', 697], ['us-mo-117', 698], ['us-mi-123', 699],
        ['us-mi-085', 700], ['us-mi-133', 701], ['us-il-031', 702],
        ['us-il-059', 703], ['us-al-033', 704], ['us-ms-141', 705],
        ['us-ms-003', 706], ['us-tn-071', 707], ['us-ms-139', 708],
        ['us-wv-051', 709], ['us-wv-035', 710], ['us-id-037', 711],
        ['us-id-039', 712], ['us-id-013', 713], ['us-oh-131', 714],
        ['us-oh-145', 715], ['us-oh-087', 716], ['us-oh-001', 717],
        ['us-oh-015', 718], ['us-fl-055', 719], ['us-fl-027', 720],
        ['us-mo-209', 721], ['us-ar-015', 722], ['us-va-089', 723],
        ['us-nc-169', 724], ['us-nc-157', 725], ['us-ia-121', 726],
        ['us-ia-039', 727], ['us-tx-203', 728], ['us-tx-401', 729],
        ['us-ia-181', 730], ['us-oh-161', 731], ['us-oh-125', 732],
        ['us-fl-043', 733], ['us-ga-199', 734], ['us-ga-077', 735],
        ['us-co-007', 736], ['us-co-105', 737], ['us-co-023', 738],
        ['us-tx-099', 739], ['us-mo-019', 740], ['us-mo-089', 741],
        ['us-mi-139', 742], ['us-mi-009', 743], ['us-nc-153', 744],
        ['us-sc-069', 745], ['us-nc-007', 746], ['us-id-055', 747],
        ['us-id-009', 748], ['us-il-011', 749], ['us-il-073', 750],
        ['us-il-037', 751], ['us-il-103', 752], ['us-ne-127', 753],
        ['us-mi-035', 754], ['us-mi-143', 755], ['us-ca-091', 756],
        ['us-ca-035', 757], ['us-fl-081', 758], ['us-co-015', 759],
        ['us-co-043', 760], ['us-ia-089', 761], ['us-ia-037', 762],
        ['us-ia-017', 763], ['us-ia-065', 764], ['us-ia-043', 765],
        ['us-il-093', 766], ['us-nd-089', 767], ['us-nd-057', 768],
        ['us-mi-095', 769], ['us-mi-153', 770], ['us-ok-019', 771],
        ['us-ok-099', 772], ['us-nm-055', 773], ['us-ms-011', 774],
        ['us-ar-017', 775], ['us-wv-027', 776], ['us-md-001', 777],
        ['us-wv-065', 778], ['us-pa-057', 779], ['us-tx-077', 780],
        ['us-tx-237', 781], ['us-tx-367', 782], ['us-id-049', 783],
        ['us-id-069', 784], ['us-mo-221', 785], ['us-ny-109', 786],
        ['us-ny-011', 787], ['us-ny-075', 788], ['us-ny-053', 789],
        ['us-tx-363', 790], ['us-tx-143', 791], ['us-tx-133', 792],
        ['us-tx-059', 793], ['us-tx-417', 794], ['us-tx-207', 795],
        ['us-va-085', 796], ['us-va-075', 797], ['us-oh-033', 798],
        ['us-oh-139', 799], ['us-il-067', 800], ['us-il-001', 801],
        ['us-il-009', 802], ['us-il-075', 803], ['us-ga-113', 804],
        ['us-ga-265', 805], ['us-ga-141', 806], ['us-tx-091', 807],
        ['us-tx-259', 808], ['us-ny-001', 809], ['us-ny-039', 810],
        ['us-ok-089', 811], ['us-ga-019', 812], ['us-ga-277', 813],
        ['us-ga-155', 814], ['us-ga-321', 815], ['us-ga-287', 816],
        ['us-ga-081', 817], ['us-ga-075', 818], ['us-sd-025', 819],
        ['us-sd-077', 820], ['us-sd-005', 821], ['us-ny-043', 822],
        ['us-mi-053', 823], ['us-mn-027', 824], ['us-mn-005', 825],
        ['us-mn-107', 826], ['us-mn-057', 827], ['us-tn-013', 828],
        ['us-tn-173', 829], ['us-tn-057', 830], ['us-nd-015', 831],
        ['us-nd-029', 832], ['us-nd-047', 833], ['us-tx-039', 834],
        ['us-tx-157', 835], ['us-tx-481', 836], ['us-tn-009', 837],
        ['us-mt-031', 838], ['us-ga-143', 839], ['us-il-041', 840],
        ['us-va-177', 841], ['us-va-137', 842], ['us-va-079', 843],
        ['us-wi-027', 844], ['us-wi-055', 845], ['us-wi-047', 846],
        ['us-wi-137', 847], ['us-ar-049', 848], ['us-ar-065', 849],
        ['us-ar-063', 850], ['us-ca-031', 851], ['us-ca-053', 852],
        ['us-ca-087', 853], ['us-ca-069', 854], ['us-mo-125', 855],
        ['us-mo-131', 856], ['us-nc-005', 857], ['us-nc-193', 858],
        ['us-nc-189', 859], ['us-nc-027', 860], ['us-ks-043', 861],
        ['us-mo-021', 862], ['us-mo-003', 863], ['us-mo-165', 864],
        ['us-mo-047', 865], ['us-ks-005', 866], ['us-ne-177', 867],
        ['us-ia-085', 868], ['us-ne-021', 869], ['us-ia-165', 870],
        ['us-ia-009', 871], ['us-ia-023', 872], ['us-ia-013', 873],
        ['us-ia-011', 874], ['us-ky-129', 875], ['us-ky-189', 876],
        ['us-ky-051', 877], ['us-pa-015', 878], ['us-pa-117', 879],
        ['us-oh-029', 880], ['us-wv-029', 881], ['us-mo-051', 882],
        ['us-mi-159', 883], ['us-mi-027', 884], ['us-mi-021', 885],
        ['us-in-091', 886], ['us-in-127', 887], ['us-pa-061', 888],
        ['us-va-141', 889], ['us-mi-119', 890], ['us-mi-135', 891],
        ['us-nm-007', 892], ['us-il-133', 893], ['us-il-163', 894],
        ['us-il-189', 895], ['us-pa-009', 896], ['us-pa-013', 897],
        ['us-ar-083', 898], ['us-ar-047', 899], ['us-ar-127', 900],
        ['us-nc-003', 901], ['us-vt-025', 902], ['us-nh-019', 903],
        ['us-vt-027', 904], ['us-nh-013', 905], ['us-mn-089', 906],
        ['us-mn-113', 907], ['us-va-101', 908], ['us-co-055', 909],
        ['us-tx-255', 910], ['us-tx-123', 911], ['us-ut-029', 912],
        ['us-ut-011', 913], ['us-tx-397', 914], ['us-tx-113', 915],
        ['us-tx-257', 916], ['us-tn-087', 917], ['us-il-159', 918],
        ['us-il-047', 919], ['us-il-191', 920], ['us-il-185', 921],
        ['us-al-009', 922], ['us-mt-051', 923], ['us-tx-311', 924],
        ['us-tx-131', 925], ['us-tx-247', 926], ['us-tx-047', 927],
        ['us-mo-163', 928], ['us-mo-173', 929], ['us-tx-251', 930],
        ['us-or-049', 931], ['us-or-023', 932], ['us-tx-159', 933],
        ['us-ny-113', 934], ['us-va-157', 935], ['us-va-113', 936],
        ['us-ga-057', 937], ['us-fl-095', 938], ['us-fl-069', 939],
        ['us-ok-111', 940], ['us-in-099', 941], ['us-in-049', 942],
        ['us-in-169', 943], ['us-mn-169', 944], ['us-la-035', 945],
        ['us-ms-149', 946], ['us-ms-021', 947], ['us-la-107', 948],
        ['us-mo-147', 949], ['us-mo-139', 950], ['us-ks-099', 951],
        ['us-nc-131', 952], ['us-nc-083', 953], ['us-ky-193', 954],
        ['us-pa-035', 955], ['us-ok-131', 956], ['us-ok-147', 957],
        ['us-ok-113', 958], ['us-wv-061', 959], ['us-wv-077', 960],
        ['us-wv-023', 961], ['us-wv-071', 962], ['us-wi-135', 963],
        ['us-wi-115', 964], ['us-wi-087', 965], ['us-tx-435', 966],
        ['us-tx-137', 967], ['us-tx-265', 968], ['us-tx-271', 969],
        ['us-mo-153', 970], ['us-tx-473', 971], ['us-al-053', 972],
        ['us-vt-009', 973], ['us-nh-009', 974], ['us-vt-017', 975],
        ['us-ga-137', 976], ['us-ga-139', 977], ['us-ga-157', 978],
        ['us-ga-135', 979], ['us-ga-279', 980], ['us-ga-283', 981],
        ['us-ga-061', 982], ['us-wi-125', 983], ['us-wi-041', 984],
        ['us-mn-007', 985], ['us-mn-077', 986], ['us-md-009', 987],
        ['us-tx-323', 988], ['us-nm-001', 989], ['us-nm-006', 990],
        ['us-nm-045', 991], ['us-nm-049', 992], ['us-nm-028', 993],
        ['us-nm-057', 994], ['us-nj-005', 995], ['us-ga-099', 996],
        ['us-nd-083', 997], ['us-nd-049', 998], ['us-nd-045', 999],
        ['us-id-023', 1000], ['us-nd-043', 1001], ['us-nd-103', 1002],
        ['us-tx-273', 1003], ['us-tx-489', 1004], ['us-il-055', 1005],
        ['us-il-065', 1006], ['us-il-081', 1007], ['us-ar-051', 1008],
        ['us-ar-105', 1009], ['us-ar-029', 1010], ['us-ar-149', 1011],
        ['us-ks-181', 1012], ['us-ks-023', 1013], ['us-ks-153', 1014],
        ['us-ia-185', 1015], ['us-va-775', 1016], ['us-va-770', 1017],
        ['us-tx-165', 1018], ['us-tx-317', 1019], ['us-tx-037', 1020],
        ['us-tx-067', 1021], ['us-ar-091', 1022], ['us-ar-073', 1023],
        ['us-mo-127', 1024], ['us-mo-111', 1025], ['us-ia-061', 1026],
        ['us-ia-097', 1027], ['us-nd-005', 1028], ['us-nd-063', 1029],
        ['us-ny-019', 1030], ['us-ny-031', 1031], ['us-oh-079', 1032],
        ['us-oh-163', 1033], ['us-oh-073', 1034], ['us-oh-129', 1035],
        ['us-oh-045', 1036], ['us-al-085', 1037], ['us-ia-113', 1038],
        ['us-ga-215', 1039], ['us-tx-003', 1040], ['us-tx-495', 1041],
        ['us-nm-025', 1042], ['us-nm-015', 1043], ['us-oh-149', 1044],
        ['us-oh-021', 1045], ['us-oh-109', 1046], ['us-oh-023', 1047],
        ['us-tx-117', 1048], ['us-nm-037', 1049], ['us-tx-359', 1050],
        ['us-ok-133', 1051], ['us-sc-081', 1052], ['us-sc-003', 1053],
        ['us-ga-251', 1054], ['us-ga-033', 1055], ['us-ga-165', 1056],
        ['us-ga-245', 1057], ['us-nc-029', 1058], ['us-nc-053', 1059],
        ['us-tx-305', 1060], ['us-tx-169', 1061], ['us-wi-079', 1062],
        ['us-wi-089', 1063], ['us-sc-047', 1064], ['us-sc-059', 1065],
        ['us-sc-045', 1066], ['us-sc-001', 1067], ['us-sd-019', 1068],
        ['us-wy-011', 1069], ['us-wy-005', 1070], ['us-mt-011', 1071],
        ['us-mt-025', 1072], ['us-nd-011', 1073], ['us-ma-013', 1074],
        ['us-ma-015', 1075], ['us-tx-055', 1076], ['us-tx-209', 1077],
        ['us-al-111', 1078], ['us-al-027', 1079], ['us-al-037', 1080],
        ['us-ks-161', 1081], ['us-ks-061', 1082], ['us-tn-163', 1083],
        ['us-tn-019', 1084], ['us-va-111', 1085], ['us-va-037', 1086],
        ['us-tn-179', 1087], ['us-tn-073', 1088], ['us-sc-071', 1089],
        ['us-va-181', 1090], ['us-va-093', 1091], ['us-va-175', 1092],
        ['us-va-800', 1093], ['us-va-550', 1094], ['us-nc-073', 1095],
        ['us-or-069', 1096], ['us-va-061', 1097], ['us-nv-005', 1098],
        ['us-in-035', 1099], ['us-wi-131', 1100], ['us-pa-085', 1101],
        ['us-pa-039', 1102], ['us-il-193', 1103], ['us-il-039', 1104],
        ['us-il-115', 1105], ['us-il-173', 1106], ['us-il-137', 1107],
        ['us-ut-039', 1108], ['us-mn-049', 1109], ['us-nc-173', 1110],
        ['us-fl-103', 1111], ['us-fl-101', 1112], ['us-fl-119', 1113],
        ['us-nd-091', 1114], ['us-nd-003', 1115], ['us-nd-073', 1116],
        ['us-nd-097', 1117], ['us-nc-011', 1118], ['us-wv-107', 1119],
        ['us-wv-073', 1120], ['us-wi-097', 1121], ['us-sc-063', 1122],
        ['us-md-005', 1123], ['us-md-510', 1124], ['us-wi-039', 1125],
        ['us-ok-059', 1126], ['us-ok-151', 1127], ['us-ok-003', 1128],
        ['us-ks-007', 1129], ['us-ky-063', 1130], ['us-ma-003', 1131],
        ['us-mo-041', 1132], ['us-mo-195', 1133], ['us-ks-167', 1134],
        ['us-tn-111', 1135], ['us-ar-023', 1136], ['us-id-003', 1137],
        ['us-id-045', 1138], ['us-ma-021', 1139], ['us-pa-037', 1140],
        ['us-pa-107', 1141], ['us-nc-109', 1142], ['us-nc-045', 1143],
        ['us-ar-019', 1144], ['us-ar-059', 1145], ['us-il-169', 1146],
        ['us-il-057', 1147], ['us-ca-051', 1148], ['us-nm-013', 1149],
        ['us-nd-039', 1150], ['us-ca-055', 1151], ['us-ca-095', 1152],
        ['us-tx-449', 1153], ['us-wv-057', 1154], ['us-nc-125', 1155],
        ['us-ks-009', 1156], ['us-nd-087', 1157], ['us-la-083', 1158],
        ['us-ne-041', 1159], ['us-ne-071', 1160], ['us-al-119', 1161],
        ['us-ms-069', 1162], ['us-al-093', 1163], ['us-al-133', 1164],
        ['us-fl-117', 1165], ['us-ms-131', 1166], ['us-ms-109', 1167],
        ['us-ms-035', 1168], ['us-ms-073', 1169], ['us-mi-037', 1170],
        ['us-mi-065', 1171], ['us-ks-149', 1172], ['us-ks-177', 1173],
        ['us-sd-061', 1174], ['us-sd-035', 1175], ['us-mn-061', 1176],
        ['us-co-073', 1177], ['us-co-063', 1178], ['us-ny-077', 1179],
        ['us-ny-115', 1180], ['us-in-005', 1181], ['us-in-081', 1182],
        ['us-tx-445', 1183], ['us-al-121', 1184], ['us-ia-021', 1185],
        ['us-ia-035', 1186], ['us-nc-197', 1187], ['us-nc-067', 1188],
        ['us-nc-081', 1189], ['us-nc-057', 1190], ['us-nv-510', 1191],
        ['us-ga-193', 1192], ['us-ga-261', 1193], ['us-mo-023', 1194],
        ['us-mo-223', 1195], ['us-mo-179', 1196], ['us-co-081', 1197],
        ['us-wy-025', 1198], ['us-wy-009', 1199], ['us-wi-065', 1200],
        ['us-il-177', 1201], ['us-wi-045', 1202], ['us-wi-105', 1203],
        ['us-mi-087', 1204], ['us-la-015', 1205], ['us-la-119', 1206],
        ['us-ar-027', 1207], ['us-ms-143', 1208], ['us-ms-119', 1209],
        ['us-ms-135', 1210], ['us-ms-161', 1211], ['us-la-053', 1212],
        ['us-la-039', 1213], ['us-la-079', 1214], ['us-tn-023', 1215],
        ['us-tn-077', 1216], ['us-tn-069', 1217], ['us-az-011', 1218],
        ['us-az-003', 1219], ['us-nm-023', 1220], ['us-ok-009', 1221],
        ['us-ok-055', 1222], ['us-ok-057', 1223], ['us-tx-075', 1224],
        ['us-mo-011', 1225], ['us-mo-097', 1226], ['us-mo-039', 1227],
        ['us-oh-037', 1228], ['us-sd-045', 1229], ['us-sd-129', 1230],
        ['us-sd-137', 1231], ['us-sd-041', 1232], ['us-sd-055', 1233],
        ['us-ms-111', 1234], ['us-ms-041', 1235], ['us-ms-039', 1236],
        ['us-ca-013', 1237], ['us-va-087', 1238], ['us-ny-119', 1239],
        ['us-ny-087', 1240], ['us-ny-071', 1241], ['us-nj-003', 1242],
        ['us-mo-017', 1243], ['us-wv-047', 1244], ['us-wv-059', 1245],
        ['us-wv-033', 1246], ['us-wv-049', 1247], ['us-nc-077', 1248],
        ['us-ne-179', 1249], ['us-ne-139', 1250], ['us-sc-005', 1251],
        ['us-nd-051', 1252], ['us-ne-023', 1253], ['us-ne-143', 1254],
        ['us-ne-141', 1255], ['us-nc-185', 1256], ['us-nc-069', 1257],
        ['us-de-005', 1258], ['us-mo-175', 1259], ['us-mo-137', 1260],
        ['us-ks-035', 1261], ['us-ks-015', 1262], ['us-mi-105', 1263],
        ['us-il-007', 1264], ['us-il-201', 1265], ['us-wi-127', 1266],
        ['us-sc-007', 1267], ['us-sc-077', 1268], ['us-in-011', 1269],
        ['us-in-097', 1270], ['us-in-023', 1271], ['us-in-015', 1272],
        ['us-in-057', 1273], ['us-in-095', 1274], ['us-il-027', 1275],
        ['us-id-063', 1276], ['us-id-067', 1277], ['us-id-031', 1278],
        ['us-id-053', 1279], ['us-ms-127', 1280], ['us-ms-121', 1281],
        ['us-tx-345', 1282], ['us-tx-101', 1283], ['us-tx-125', 1284],
        ['us-tx-153', 1285], ['us-or-039', 1286], ['us-or-003', 1287],
        ['us-ok-033', 1288], ['us-ok-137', 1289], ['us-tx-485', 1290],
        ['us-mi-155', 1291], ['us-ks-089', 1292], ['us-ks-123', 1293],
        ['us-ks-029', 1294], ['us-ms-091', 1295], ['us-il-085', 1296],
        ['us-in-059', 1297], ['us-va-620', 1298], ['us-tx-329', 1299],
        ['us-ks-101', 1300], ['us-ks-171', 1301], ['us-il-199', 1302],
        ['us-mt-029', 1303], ['us-ks-189', 1304], ['us-ky-067', 1305],
        ['us-ky-151', 1306], ['us-ky-203', 1307], ['us-sd-013', 1308],
        ['us-wv-001', 1309], ['us-tn-055', 1310], ['us-tn-099', 1311],
        ['us-ne-045', 1312], ['us-ne-013', 1313], ['us-pa-109', 1314],
        ['us-tx-469', 1315], ['us-tx-239', 1316], ['us-mi-147', 1317],
        ['us-ne-173', 1318], ['us-ne-043', 1319], ['us-vt-011', 1320],
        ['us-va-067', 1321], ['us-ok-011', 1322], ['us-ok-039', 1323],
        ['us-wv-093', 1324], ['us-wi-023', 1325], ['us-ia-157', 1326],
        ['us-ia-123', 1327], ['us-ia-125', 1328], ['us-ia-051', 1329],
        ['us-ia-179', 1330], ['us-ia-135', 1331], ['us-ks-091', 1332],
        ['us-ks-045', 1333], ['us-ks-059', 1334], ['us-ky-059', 1335],
        ['us-ky-237', 1336], ['us-ky-197', 1337], ['us-or-061', 1338],
        ['us-ga-151', 1339], ['us-nd-001', 1340], ['us-nd-041', 1341],
        ['us-sd-105', 1342], ['us-nd-085', 1343], ['us-pa-063', 1344],
        ['us-pa-021', 1345], ['us-tn-107', 1346], ['us-mi-093', 1347],
        ['us-mi-075', 1348], ['us-co-087', 1349], ['us-pa-127', 1350],
        ['us-pa-069', 1351], ['us-ok-123', 1352], ['us-ok-037', 1353],
        ['us-ok-081', 1354], ['us-tn-175', 1355], ['us-ok-125', 1356],
        ['us-ct-013', 1357], ['us-ga-003', 1358], ['us-tx-145', 1359],
        ['us-ks-033', 1360], ['us-ky-113', 1361], ['us-ky-171', 1362],
        ['us-ok-075', 1363], ['us-sd-079', 1364], ['us-nc-033', 1365],
        ['us-al-003', 1366], ['us-va-127', 1367], ['us-ga-053', 1368],
        ['us-in-077', 1369], ['us-va-019', 1370], ['us-va-009', 1371],
        ['us-va-011', 1372], ['us-nm-033', 1373], ['us-ne-077', 1374],
        ['us-ne-011', 1375], ['us-mo-149', 1376], ['us-tn-161', 1377],
        ['us-tn-083', 1378], ['us-pa-113', 1379], ['us-pa-131', 1380],
        ['us-in-167', 1381], ['us-il-045', 1382], ['us-in-165', 1383],
        ['us-mi-149', 1384], ['us-in-039', 1385], ['us-in-087', 1386],
        ['us-tx-189', 1387], ['us-tx-303', 1388], ['us-tx-107', 1389],
        ['us-mn-093', 1390], ['us-oh-005', 1391], ['us-ne-119', 1392],
        ['us-ne-167', 1393], ['us-fl-085', 1394], ['us-ga-227', 1395],
        ['us-ga-085', 1396], ['us-ga-319', 1397], ['us-ga-167', 1398],
        ['us-ar-095', 1399], ['us-ar-117', 1400], ['us-ar-147', 1401],
        ['us-mo-059', 1402], ['us-mo-169', 1403], ['us-va-143', 1404],
        ['us-ks-145', 1405], ['us-ks-137', 1406], ['us-ks-147', 1407],
        ['us-ks-065', 1408], ['us-ks-063', 1409], ['us-ks-109', 1410],
        ['us-la-099', 1411], ['us-la-097', 1412], ['us-la-055', 1413],
        ['us-oh-095', 1414], ['us-oh-123', 1415], ['us-oh-069', 1416],
        ['us-ar-031', 1417], ['us-ar-093', 1418], ['us-ar-035', 1419],
        ['us-ky-117', 1420], ['us-ky-081', 1421], ['us-ky-077', 1422],
        ['us-ky-097', 1423], ['us-ky-001', 1424], ['us-ky-217', 1425],
        ['us-nc-075', 1426], ['us-va-071', 1427], ['us-wv-055', 1428],
        ['us-nm-035', 1429], ['us-ne-049', 1430], ['us-ne-101', 1431],
        ['us-ne-135', 1432], ['us-ne-117', 1433], ['us-ks-039', 1434],
        ['us-ne-145', 1435], ['us-ne-149', 1436], ['us-tn-081', 1437],
        ['us-tn-085', 1438], ['us-il-125', 1439], ['us-il-107', 1440],
        ['us-va-077', 1441], ['us-va-197', 1442], ['us-ga-303', 1443],
        ['us-wi-035', 1444], ['us-tn-153', 1445], ['us-tn-007', 1446],
        ['us-tn-065', 1447], ['us-tx-471', 1448], ['us-tx-407', 1449],
        ['us-tx-291', 1450], ['us-ks-191', 1451], ['us-ok-071', 1452],
        ['us-mi-127', 1453], ['us-mn-001', 1454], ['us-mn-065', 1455],
        ['us-oh-085', 1456], ['us-ca-003', 1457], ['us-il-105', 1458],
        ['us-il-179', 1459], ['us-oh-135', 1460], ['us-ma-025', 1461],
        ['us-ma-017', 1462], ['us-tx-115', 1463], ['us-ny-069', 1464],
        ['us-ks-121', 1465], ['us-mo-037', 1466], ['us-mo-095', 1467],
        ['us-ga-153', 1468], ['us-ga-023', 1469], ['us-ga-235', 1470],
        ['us-ga-091', 1471], ['us-ny-023', 1472], ['us-mi-161', 1473],
        ['us-in-113', 1474], ['us-ga-225', 1475], ['us-ga-311', 1476],
        ['us-ga-163', 1477], ['us-wi-099', 1478], ['us-wi-085', 1479],
        ['us-wi-067', 1480], ['us-wi-078', 1481], ['us-wi-083', 1482],
        ['us-wa-063', 1483], ['us-wa-043', 1484], ['us-nj-039', 1485],
        ['us-nj-017', 1486], ['us-oh-075', 1487], ['us-oh-169', 1488],
        ['us-oh-151', 1489], ['us-oh-019', 1490], ['us-tx-187', 1491],
        ['us-wa-029', 1492], ['us-md-017', 1493], ['us-va-033', 1494],
        ['us-va-630', 1495], ['us-md-037', 1496], ['us-va-099', 1497],
        ['us-va-193', 1498], ['us-de-003', 1499], ['us-pa-029', 1500],
        ['us-nj-015', 1501], ['us-nj-033', 1502], ['us-nj-011', 1503],
        ['us-pa-011', 1504], ['us-pa-077', 1505], ['us-pa-095', 1506],
        ['us-md-015', 1507], ['us-md-029', 1508], ['us-wa-065', 1509],
        ['us-ia-101', 1510], ['us-ia-177', 1511], ['us-ne-137', 1512],
        ['us-ne-073', 1513], ['us-ms-087', 1514], ['us-ms-095', 1515],
        ['us-fl-033', 1516], ['us-fl-113', 1517], ['us-tx-439', 1518],
        ['us-va-169', 1519], ['us-ok-085', 1520], ['us-ga-289', 1521],
        ['us-oh-099', 1522], ['us-tx-381', 1523], ['us-tx-375', 1524],
        ['us-tx-437', 1525], ['us-mo-151', 1526], ['us-il-089', 1527],
        ['us-il-043', 1528], ['us-sc-031', 1529], ['us-sc-055', 1530],
        ['us-sc-079', 1531], ['us-sc-057', 1532], ['us-nc-119', 1533],
        ['us-nc-139', 1534], ['us-or-019', 1535], ['us-or-033', 1536],
        ['us-pa-089', 1537], ['us-ar-101', 1538], ['us-ar-071', 1539],
        ['us-ks-135', 1540], ['us-la-047', 1541], ['us-la-077', 1542],
        ['us-la-121', 1543], ['us-ne-067', 1544], ['us-ne-095', 1545],
        ['us-al-115', 1546], ['us-ms-101', 1547], ['us-ms-099', 1548],
        ['us-ms-123', 1549], ['us-ga-095', 1550], ['us-id-017', 1551],
        ['us-ga-047', 1552], ['us-md-027', 1553], ['us-md-013', 1554],
        ['us-md-021', 1555], ['us-ut-035', 1556], ['us-ct-003', 1557],
        ['us-ct-009', 1558], ['us-ct-015', 1559], ['us-oh-157', 1560],
        ['us-oh-067', 1561], ['us-oh-081', 1562], ['us-oh-013', 1563],
        ['us-oh-111', 1564], ['us-oh-059', 1565], ['us-oh-047', 1566],
        ['us-oh-027', 1567], ['us-oh-071', 1568], ['us-mn-071', 1569],
        ['us-id-077', 1570], ['us-id-011', 1571], ['us-id-029', 1572],
        ['us-wi-121', 1573], ['us-sd-071', 1574], ['us-va-036', 1575],
        ['us-va-149', 1576], ['us-va-041', 1577], ['us-al-023', 1578],
        ['us-al-129', 1579], ['us-in-055', 1580], ['us-ne-047', 1581],
        ['us-ne-111', 1582], ['us-nd-105', 1583], ['us-nd-017', 1584],
        ['us-il-151', 1585], ['us-il-069', 1586], ['us-ne-005', 1587],
        ['us-tx-163', 1588], ['us-ia-103', 1589], ['us-ks-001', 1590],
        ['us-ks-133', 1591], ['us-ky-089', 1592], ['us-ne-087', 1593],
        ['us-ne-085', 1594], ['us-ne-063', 1595], ['us-ne-057', 1596],
        ['us-co-115', 1597], ['us-co-095', 1598], ['us-ky-101', 1599],
        ['us-ms-105', 1600], ['us-md-023', 1601], ['us-mi-059', 1602],
        ['us-oh-171', 1603], ['us-oh-051', 1604], ['us-ky-177', 1605],
        ['us-ky-149', 1606], ['us-ky-141', 1607], ['us-nh-015', 1608],
        ['us-pa-133', 1609], ['us-ne-097', 1610], ['us-sd-075', 1611],
        ['us-nd-007', 1612], ['us-ne-003', 1613], ['us-mo-073', 1614],
        ['us-ky-061', 1615], ['us-ky-031', 1616], ['us-ga-211', 1617],
        ['us-ms-033', 1618], ['us-ms-137', 1619], ['us-ar-107', 1620],
        ['us-al-117', 1621], ['us-ok-149', 1622], ['us-nc-135', 1623],
        ['us-in-103', 1624], ['us-in-017', 1625], ['us-wi-061', 1626],
        ['us-ny-063', 1627], ['us-ny-029', 1628], ['us-ny-009', 1629],
        ['us-md-031', 1630], ['us-va-610', 1631], ['us-va-035', 1632],
        ['us-il-083', 1633], ['us-mo-183', 1634], ['us-mo-071', 1635],
        ['us-ks-013', 1636], ['us-ga-029', 1637], ['us-ga-109', 1638],
        ['us-ga-031', 1639], ['us-ky-119', 1640], ['us-ky-071', 1641],
        ['us-ky-159', 1642], ['us-ga-309', 1643], ['us-nc-107', 1644],
        ['us-tx-483', 1645], ['us-tx-211', 1646], ['us-tx-393', 1647],
        ['us-tx-295', 1648], ['us-ok-007', 1649], ['us-ks-175', 1650],
        ['us-or-009', 1651], ['us-sc-041', 1652], ['us-ut-053', 1653],
        ['us-ut-021', 1654], ['us-wy-033', 1655], ['us-wy-003', 1656],
        ['us-mt-003', 1657], ['us-pa-047', 1658], ['us-pa-083', 1659],
        ['us-ms-031', 1660], ['us-in-013', 1661], ['us-ky-065', 1662],
        ['us-tx-087', 1663], ['us-tx-089', 1664], ['us-il-063', 1665],
        ['us-mn-073', 1666], ['us-sd-051', 1667], ['us-sd-039', 1668],
        ['us-mn-081', 1669], ['us-mn-083', 1670], ['us-ga-043', 1671],
        ['us-tx-497', 1672], ['us-ga-307', 1673], ['us-ga-159', 1674],
        ['us-ga-237', 1675], ['us-ga-169', 1676], ['us-ga-009', 1677],
        ['us-ga-021', 1678], ['us-ny-079', 1679], ['us-va-199', 1680],
        ['us-va-735', 1681], ['us-va-700', 1682], ['us-ok-065', 1683],
        ['us-tx-173', 1684], ['us-tx-431', 1685], ['us-tx-335', 1686],
        ['us-tx-415', 1687], ['us-tx-383', 1688], ['us-ok-093', 1689],
        ['us-wa-051', 1690], ['us-nd-055', 1691], ['us-or-027', 1692],
        ['us-ia-081', 1693], ['us-ia-197', 1694], ['us-tx-419', 1695],
        ['us-tx-403', 1696], ['us-mo-055', 1697], ['us-wv-075', 1698],
        ['us-va-017', 1699], ['us-mn-111', 1700], ['us-ms-017', 1701],
        ['us-ms-081', 1702], ['us-la-067', 1703], ['us-al-047', 1704],
        ['us-al-001', 1705], ['us-tx-093', 1706], ['us-tx-425', 1707],
        ['us-mn-153', 1708], ['us-mn-021', 1709], ['us-co-079', 1710],
        ['us-nm-039', 1711], ['us-ms-163', 1712], ['us-mo-177', 1713],
        ['us-oh-041', 1714], ['us-oh-117', 1715], ['us-nd-031', 1716],
        ['us-ar-033', 1717], ['us-ok-001', 1718], ['us-ok-041', 1719],
        ['us-tx-053', 1720], ['us-tx-411', 1721], ['us-tx-299', 1722],
        ['us-il-109', 1723], ['us-il-187', 1724], ['us-il-071', 1725],
        ['us-ar-067', 1726], ['us-ar-037', 1727], ['us-tx-315', 1728],
        ['us-ky-083', 1729], ['us-tn-079', 1730], ['us-nc-087', 1731],
        ['us-nc-115', 1732], ['us-mn-037', 1733], ['us-or-025', 1734],
        ['us-or-013', 1735], ['us-nv-013', 1736], ['us-wi-001', 1737],
        ['us-wi-077', 1738], ['us-mo-045', 1739], ['us-mo-103', 1740],
        ['us-mo-001', 1741], ['us-mo-199', 1742], ['us-ky-015', 1743],
        ['us-ky-079', 1744], ['us-ky-021', 1745], ['us-ky-229', 1746],
        ['us-ky-155', 1747], ['us-la-115', 1748], ['us-la-009', 1749],
        ['us-la-059', 1750], ['us-mo-227', 1751], ['us-ne-163', 1752],
        ['us-sd-021', 1753], ['us-sd-063', 1754], ['us-mi-057', 1755],
        ['us-ia-001', 1756], ['us-ia-175', 1757], ['us-il-127', 1758],
        ['us-sd-007', 1759], ['us-ne-017', 1760], ['us-ne-171', 1761],
        ['us-ne-113', 1762], ['us-ne-121', 1763], ['us-ky-039', 1764],
        ['us-in-119', 1765], ['us-in-021', 1766], ['us-in-109', 1767],
        ['us-tx-139', 1768], ['us-tx-213', 1769], ['us-in-053', 1770],
        ['us-fl-035', 1771], ['us-ms-077', 1772], ['us-la-127', 1773],
        ['us-il-131', 1774], ['us-il-175', 1775], ['us-sd-029', 1776],
        ['us-ga-259', 1777], ['us-nj-025', 1778], ['us-ar-121', 1779],
        ['us-ar-021', 1780], ['us-ar-045', 1781], ['us-ia-107', 1782],
        ['us-il-061', 1783], ['us-il-171', 1784], ['us-ca-105', 1785],
        ['us-ca-045', 1786], ['us-ca-023', 1787], ['us-mn-025', 1788],
        ['us-mn-003', 1789], ['us-sd-009', 1790], ['us-sd-135', 1791],
        ['us-tn-059', 1792], ['us-va-183', 1793], ['us-in-141', 1794],
        ['us-ga-119', 1795], ['us-ga-257', 1796], ['us-ar-005', 1797],
        ['us-ms-007', 1798], ['us-ks-011', 1799], ['us-va-049', 1800],
        ['us-va-147', 1801], ['us-va-145', 1802], ['us-sc-085', 1803],
        ['us-wv-045', 1804], ['us-wv-109', 1805], ['us-wv-005', 1806],
        ['us-ca-029', 1807], ['us-tx-097', 1808], ['us-sc-075', 1809],
        ['us-ia-131', 1810], ['us-mn-101', 1811], ['us-mn-117', 1812],
        ['us-ri-007', 1813], ['us-mo-161', 1814], ['us-ms-117', 1815],
        ['us-ky-013', 1816], ['us-ky-235', 1817], ['us-tx-491', 1818],
        ['us-ga-107', 1819], ['us-la-025', 1820], ['us-pa-025', 1821],
        ['us-ne-133', 1822], ['us-tn-171', 1823], ['us-sc-083', 1824],
        ['us-nc-161', 1825], ['us-wi-005', 1826], ['us-wi-073', 1827],
        ['us-wv-101', 1828], ['us-wv-007', 1829], ['us-wv-015', 1830],
        ['us-wv-067', 1831], ['us-mo-085', 1832], ['us-mo-009', 1833],
        ['us-mn-123', 1834], ['us-ar-081', 1835], ['us-nv-019', 1836],
        ['us-ms-085', 1837], ['us-ms-005', 1838], ['us-ms-113', 1839],
        ['us-ms-147', 1840], ['us-la-105', 1841], ['us-tn-003', 1842],
        ['us-id-085', 1843], ['us-id-059', 1844], ['us-ky-091', 1845],
        ['us-ky-183', 1846], ['us-ky-107', 1847], ['us-ia-137', 1848],
        ['us-ia-129', 1849], ['us-ne-153', 1850], ['us-ne-025', 1851],
        ['us-ne-055', 1852], ['us-ga-071', 1853], ['us-il-157', 1854],
        ['us-mo-157', 1855], ['us-va-173', 1856], ['us-nm-011', 1857],
        ['us-nm-041', 1858], ['us-pa-111', 1859], ['us-oh-101', 1860],
        ['us-il-149', 1861], ['us-al-107', 1862], ['us-ok-045', 1863],
        ['us-il-145', 1864], ['us-ia-075', 1865], ['us-co-107', 1866],
        ['us-co-049', 1867], ['us-co-019', 1868], ['us-co-103', 1869],
        ['us-nj-035', 1870], ['us-nj-023', 1871], ['us-il-087', 1872],
        ['us-co-053', 1873], ['us-co-091', 1874], ['us-mn-059', 1875],
        ['us-pa-049', 1876], ['us-ms-029', 1877], ['us-ky-161', 1878],
        ['us-mn-095', 1879], ['us-tx-179', 1880], ['us-tx-129', 1881],
        ['us-fl-013', 1882], ['us-fl-005', 1883], ['us-tn-181', 1884],
        ['us-al-077', 1885], ['us-al-083', 1886], ['us-in-045', 1887],
        ['us-oh-115', 1888], ['us-oh-127', 1889], ['us-va-590', 1890],
        ['us-ga-011', 1891], ['us-ga-229', 1892], ['us-ga-305', 1893],
        ['us-ok-109', 1894], ['us-ok-069', 1895], ['us-ok-005', 1896],
        ['us-nc-099', 1897], ['us-ut-043', 1898], ['us-nv-015', 1899],
        ['us-nv-027', 1900], ['us-ky-023', 1901], ['us-ky-201', 1902],
        ['us-wi-037', 1903], ['us-mn-159', 1904], ['us-ky-043', 1905],
        ['us-nc-097', 1906], ['us-nc-159', 1907], ['us-nc-025', 1908],
        ['us-nc-167', 1909], ['us-va-083', 1910], ['us-nc-091', 1911],
        ['us-or-021', 1912], ['us-ar-009', 1913], ['us-tx-433', 1914],
        ['us-tx-253', 1915], ['us-tx-083', 1916], ['us-tx-185', 1917],
        ['us-mi-157', 1918], ['us-mi-049', 1919], ['us-la-007', 1920],
        ['us-la-093', 1921], ['us-la-005', 1922], ['us-ms-013', 1923],
        ['us-mt-033', 1924], ['us-mt-017', 1925], ['us-il-141', 1926],
        ['us-nd-077', 1927], ['us-sd-109', 1928], ['us-wi-095', 1929],
        ['us-ca-015', 1930], ['us-ok-127', 1931], ['us-wa-061', 1932],
        ['us-wa-007', 1933], ['us-ny-105', 1934], ['us-nc-149', 1935],
        ['us-nc-163', 1936], ['us-nc-085', 1937], ['us-nc-105', 1938],
        ['us-in-159', 1939], ['us-in-067', 1940], ['us-ks-027', 1941],
        ['us-ok-145', 1942], ['us-ok-097', 1943], ['us-ar-003', 1944],
        ['us-ar-043', 1945], ['us-ar-041', 1946], ['us-ar-079', 1947],
        ['us-tn-135', 1948], ['us-mn-163', 1949], ['us-va-740', 1950],
        ['us-tx-235', 1951], ['us-mo-025', 1952], ['us-mo-049', 1953],
        ['us-fl-007', 1954], ['us-fl-107', 1955], ['us-ky-163', 1956],
        ['us-ne-161', 1957], ['us-ne-075', 1958], ['us-id-071', 1959],
        ['us-id-035', 1960], ['us-ky-095', 1961], ['us-mn-035', 1962],
        ['us-az-021', 1963], ['us-az-009', 1964], ['us-ar-123', 1965],
        ['us-ks-183', 1966], ['us-fl-065', 1967], ['us-ms-037', 1968],
        ['us-la-037', 1969], ['us-la-091', 1970], ['us-ar-097', 1971],
        ['us-mi-025', 1972], ['us-mi-077', 1973], ['us-mi-015', 1974],
        ['us-al-029', 1975], ['us-ca-089', 1976], ['us-ia-153', 1977],
        ['us-ia-049', 1978], ['us-ga-183', 1979], ['us-tn-187', 1980],
        ['us-wa-003', 1981], ['us-mn-155', 1982], ['us-mn-167', 1983],
        ['us-mn-051', 1984], ['us-il-017', 1985], ['us-ga-247', 1986],
        ['us-ok-049', 1987], ['us-la-031', 1988], ['us-ca-019', 1989],
        ['us-ga-147', 1990], ['us-ga-105', 1991], ['us-al-005', 1992],
        ['us-al-109', 1993], ['us-al-011', 1994], ['us-nc-017', 1995],
        ['us-tn-035', 1996], ['us-tn-129', 1997], ['us-mi-137', 1998],
        ['us-ia-161', 1999], ['us-ut-041', 2000], ['us-ut-015', 2001],
        ['us-wa-019', 2002], ['us-mt-083', 2003], ['us-mt-109', 2004],
        ['us-nm-027', 2005], ['us-nm-053', 2006], ['us-ok-021', 2007],
        ['us-mn-173', 2008], ['us-tx-231', 2009], ['us-tx-223', 2010],
        ['us-tx-467', 2011], ['us-tx-353', 2012], ['us-tx-499', 2013],
        ['us-ks-019', 2014], ['us-nc-039', 2015], ['us-ga-291', 2016],
        ['us-ga-111', 2017], ['us-ky-195', 2018], ['us-fl-041', 2019],
        ['us-nc-035', 2020], ['us-ky-025', 2021], ['us-mo-181', 2022],
        ['us-tx-109', 2023], ['us-ar-135', 2024], ['us-nc-177', 2025],
        ['us-mn-131', 2026], ['us-mn-161', 2027], ['us-mn-139', 2028],
        ['us-mo-219', 2029], ['us-ky-227', 2030], ['us-la-017', 2031],
        ['us-ia-127', 2032], ['us-ia-169', 2033], ['us-ia-083', 2034],
        ['us-ok-141', 2035], ['us-ok-031', 2036], ['us-nc-113', 2037],
        ['us-wv-063', 2038], ['us-in-155', 2039], ['us-al-061', 2040],
        ['us-il-155', 2041], ['us-il-099', 2042], ['us-ia-055', 2043],
        ['us-ia-105', 2044], ['us-ks-127', 2045], ['us-id-015', 2046],
        ['us-nc-143', 2047], ['us-ga-101', 2048], ['us-fl-047', 2049],
        ['us-ms-045', 2050], ['us-ga-315', 2051], ['us-la-081', 2052],
        ['us-tn-093', 2053], ['us-tn-089', 2054], ['us-ks-209', 2055],
        ['us-ga-281', 2056], ['us-ms-129', 2057], ['us-ms-061', 2058],
        ['us-id-075', 2059], ['us-id-079', 2060], ['us-ia-067', 2061],
        ['us-ky-145', 2062], ['us-ky-225', 2063], ['us-ky-055', 2064],
        ['us-sd-125', 2065], ['us-tn-029', 2066], ['us-tn-067', 2067],
        ['us-sc-089', 2068], ['us-sc-067', 2069], ['us-la-117', 2070],
        ['us-mo-207', 2071], ['us-ga-093', 2072], ['us-mn-145', 2073],
        ['us-mn-009', 2074], ['us-ne-155', 2075], ['us-mn-141', 2076],
        ['us-tn-025', 2077], ['us-tx-337', 2078], ['us-tx-049', 2079],
        ['us-tx-333', 2080], ['us-wi-101', 2081], ['us-wi-059', 2082],
        ['us-wi-009', 2083], ['us-ok-103', 2084], ['us-ok-083', 2085],
        ['us-ok-121', 2086], ['us-wv-017', 2087], ['us-wv-087', 2088],
        ['us-wv-105', 2089], ['us-me-017', 2090], ['us-nh-003', 2091],
        ['us-wv-095', 2092], ['us-mn-079', 2093], ['us-wa-037', 2094],
        ['us-wi-133', 2095], ['us-ks-151', 2096], ['us-al-045', 2097],
        ['us-al-069', 2098], ['us-al-067', 2099], ['us-ca-109', 2100],
        ['us-ca-039', 2101], ['us-mo-075', 2102], ['us-ne-009', 2103],
        ['us-ut-009', 2104], ['us-nc-071', 2105], ['us-nm-019', 2106],
        ['us-mt-027', 2107], ['us-mt-037', 2108], ['us-nc-195', 2109],
        ['us-nc-101', 2110], ['us-ca-085', 2111], ['us-il-183', 2112],
        ['us-mo-189', 2113], ['us-ca-103', 2114], ['us-tx-151', 2115],
        ['us-la-085', 2116], ['us-nc-015', 2117], ['us-tn-143', 2118],
        ['us-nc-079', 2119], ['us-ky-131', 2120], ['us-il-123', 2121],
        ['us-tx-081', 2122], ['us-tn-133', 2123], ['us-mi-063', 2124],
        ['us-mi-129', 2125], ['us-mi-069', 2126], ['us-ga-069', 2127],
        ['us-ga-299', 2128], ['us-nd-037', 2129], ['us-la-103', 2130],
        ['us-oh-057', 2131], ['us-mn-137', 2132], ['us-oh-043', 2133],
        ['us-oh-093', 2134], ['us-ia-015', 2135], ['us-sd-027', 2136],
        ['us-ne-051', 2137], ['us-sd-127', 2138], ['us-md-025', 2139],
        ['us-sc-037', 2140], ['us-va-133', 2141], ['us-wi-015', 2142],
        ['us-ky-121', 2143], ['us-mi-067', 2144], ['us-tn-095', 2145],
        ['us-tn-131', 2146], ['us-ky-105', 2147], ['us-ky-035', 2148],
        ['us-va-015', 2149], ['us-va-003', 2150], ['us-va-029', 2151],
        ['us-va-043', 2152], ['us-wa-023', 2153], ['us-ky-109', 2154],
        ['us-sc-073', 2155], ['us-la-033', 2156], ['us-mi-081', 2157],
        ['us-nc-147', 2158], ['us-nc-065', 2159], ['us-mt-009', 2160],
        ['us-mt-111', 2161], ['us-ne-039', 2162], ['us-ga-001', 2163],
        ['us-ia-099', 2164], ['us-ms-153', 2165], ['us-ms-023', 2166],
        ['us-tx-155', 2167], ['us-tx-275', 2168], ['us-fl-105', 2169],
        ['us-al-087', 2170], ['us-al-123', 2171], ['us-or-043', 2172],
        ['us-or-017', 2173], ['us-ia-155', 2174], ['us-ia-145', 2175],
        ['us-mo-229', 2176], ['us-ny-107', 2177], ['us-tx-287', 2178],
        ['us-ga-121', 2179], ['us-tx-073', 2180], ['us-mo-007', 2181],
        ['us-sc-029', 2182], ['us-ar-055', 2183], ['us-tx-191', 2184],
        ['us-wi-013', 2185], ['us-wi-129', 2186], ['us-nc-141', 2187],
        ['us-nc-061', 2188], ['us-tx-221', 2189], ['us-sd-117', 2190],
        ['us-sd-119', 2191], ['us-nv-001', 2192], ['us-nv-031', 2193],
        ['us-ky-007', 2194], ['us-tx-009', 2195], ['us-tx-503', 2196],
        ['us-tx-023', 2197], ['us-tx-405', 2198], ['us-nv-029', 2199],
        ['us-ct-001', 2200], ['us-ca-009', 2201], ['us-ca-077', 2202],
        ['us-ms-159', 2203], ['us-ky-167', 2204], ['us-ne-183', 2205],
        ['us-ky-135', 2206], ['us-mn-149', 2207], ['us-ms-053', 2208],
        ['us-ms-051', 2209], ['us-al-025', 2210], ['us-ks-017', 2211],
        ['us-ky-143', 2212], ['us-ky-033', 2213], ['us-ky-221', 2214],
        ['us-sd-003', 2215], ['us-ne-061', 2216], ['us-ks-037', 2217],
        ['us-mn-023', 2218], ['us-sc-049', 2219], ['us-sc-013', 2220],
        ['us-id-043', 2221], ['us-va-053', 2222], ['us-va-081', 2223],
        ['us-fl-111', 2224], ['us-ny-073', 2225], ['us-ny-055', 2226],
        ['us-sd-083', 2227], ['us-wi-017', 2228], ['us-ky-157', 2229],
        ['us-ga-065', 2230], ['us-ga-185', 2231], ['us-mi-099', 2232],
        ['us-tx-331', 2233], ['us-ky-087', 2234], ['us-ky-099', 2235],
        ['us-ky-137', 2236], ['us-va-710', 2237], ['us-va-155', 2238],
        ['us-nc-179', 2239], ['us-nd-061', 2240], ['us-nd-053', 2241],
        ['us-fl-091', 2242], ['us-ca-001', 2243], ['us-il-013', 2244],
        ['us-in-085', 2245], ['us-ms-103', 2246], ['us-mt-045', 2247],
        ['us-nc-121', 2248], ['us-or-053', 2249], ['us-or-065', 2250],
        ['us-or-047', 2251], ['us-ia-173', 2252], ['us-oh-039', 2253],
        ['us-wv-039', 2254], ['us-wv-019', 2255], ['us-wv-025', 2256],
        ['us-il-121', 2257], ['us-va-051', 2258], ['us-va-007', 2259],
        ['us-ga-243', 2260], ['us-nm-029', 2261], ['us-tx-355', 2262],
        ['us-tx-409', 2263], ['us-wy-045', 2264], ['us-sd-081', 2265],
        ['us-sd-093', 2266], ['us-sd-033', 2267], ['us-al-089', 2268],
        ['us-tn-189', 2269], ['us-tx-063', 2270], ['us-tx-459', 2271],
        ['us-ok-067', 2272], ['us-wv-085', 2273], ['us-wv-021', 2274],
        ['us-la-045', 2275], ['us-nc-133', 2276], ['us-tx-349', 2277],
        ['us-tx-161', 2278], ['us-pa-087', 2279], ['us-tx-399', 2280],
        ['us-tx-441', 2281], ['us-tx-465', 2282], ['us-ks-193', 2283],
        ['us-ga-161', 2284], ['us-ar-145', 2285], ['us-ms-083', 2286],
        ['us-mo-053', 2287], ['us-il-197', 2288], ['us-nm-009', 2289],
        ['us-tx-369', 2290], ['us-sd-011', 2291], ['us-ms-027', 2292],
        ['us-ia-057', 2293], ['us-ia-087', 2294], ['us-ia-163', 2295],
        ['us-ks-143', 2296], ['us-fl-023', 2297], ['us-ny-095', 2298],
        ['us-ny-025', 2299], ['us-ok-117', 2300], ['us-ny-007', 2301],
        ['us-oh-009', 2302], ['us-wv-083', 2303], ['us-ca-057', 2304],
        ['us-wi-031', 2305], ['us-mn-017', 2306], ['us-ky-199', 2307],
        ['us-tx-241', 2308], ['us-ut-031', 2309], ['us-ut-017', 2310],
        ['us-ut-001', 2311], ['us-tn-011', 2312], ['us-tn-139', 2313],
        ['us-ga-213', 2314], ['us-mi-107', 2315], ['us-mi-117', 2316],
        ['us-ny-083', 2317], ['us-ga-017', 2318], ['us-ga-271', 2319],
        ['us-ar-077', 2320], ['us-fl-003', 2321], ['us-fl-031', 2322],
        ['us-ga-173', 2323], ['us-al-015', 2324], ['us-ky-057', 2325],
        ['us-ms-107', 2326], ['us-ga-239', 2327], ['us-tx-199', 2328],
        ['us-ct-005', 2329], ['us-oh-143', 2330], ['us-oh-147', 2331],
        ['us-il-153', 2332], ['us-ok-107', 2333], ['us-mi-145', 2334],
        ['us-vt-015', 2335], ['us-vt-005', 2336], ['us-il-119', 2337],
        ['us-tx-085', 2338], ['us-ne-053', 2339], ['us-fl-115', 2340],
        ['us-fl-015', 2341], ['us-pa-091', 2342], ['us-id-061', 2343],
        ['us-nj-037', 2344], ['us-nj-027', 2345], ['us-mo-211', 2346],
        ['us-ne-029', 2347], ['us-oh-113', 2348], ['us-tx-447', 2349],
        ['us-ga-059', 2350], ['us-ga-221', 2351], ['us-mi-017', 2352],
        ['us-tn-157', 2353], ['us-ca-011', 2354], ['us-ca-007', 2355],
        ['us-mn-115', 2356], ['us-tx-021', 2357], ['us-wa-039', 2358],
        ['us-wa-005', 2359], ['us-wa-071', 2360], ['us-ks-205', 2361],
        ['us-ks-049', 2362], ['us-ks-125', 2363], ['us-la-043', 2364],
        ['us-la-069', 2365], ['us-mi-011', 2366], ['us-ia-111', 2367],
        ['us-ks-141', 2368], ['us-ks-105', 2369], ['us-ks-169', 2370],
        ['us-ks-053', 2371], ['us-ny-099', 2372], ['us-ny-123', 2373],
        ['us-ky-125', 2374], ['us-tn-121', 2375], ['us-mo-213', 2376],
        ['us-co-047', 2377], ['us-ok-087', 2378], ['us-wv-031', 2379],
        ['us-va-171', 2380], ['us-va-139', 2381], ['us-ok-061', 2382],
        ['us-wv-089', 2383], ['us-nj-013', 2384], ['us-mo-115', 2385],
        ['us-ga-209', 2386], ['us-or-055', 2387], ['us-ga-133', 2388],
        ['us-sd-017', 2389], ['us-sd-085', 2390], ['us-sd-053', 2391],
        ['us-tx-135', 2392], ['us-tx-475', 2393], ['us-tx-293', 2394],
        ['us-wv-037', 2395], ['us-wv-003', 2396], ['us-mt-067', 2397],
        ['us-tx-121', 2398], ['us-sc-021', 2399], ['us-nc-199', 2400],
        ['us-tx-387', 2401], ['us-ga-301', 2402], ['us-tx-197', 2403],
        ['us-mo-099', 2404], ['us-mo-186', 2405], ['us-ky-085', 2406],
        ['us-ga-149', 2407], ['us-al-079', 2408], ['us-al-043', 2409],
        ['us-ms-093', 2410], ['us-ks-025', 2411], ['us-ks-081', 2412],
        ['us-la-013', 2413], ['us-ga-295', 2414], ['us-ia-095', 2415],
        ['us-ne-019', 2416], ['us-ne-093', 2417], ['us-tx-357', 2418],
        ['us-wa-015', 2419], ['us-tx-297', 2420], ['us-mo-135', 2421],
        ['us-ok-043', 2422], ['us-nc-023', 2423], ['us-nc-191', 2424],
        ['us-ar-061', 2425], ['us-nc-059', 2426], ['us-nc-111', 2427],
        ['us-ar-103', 2428], ['us-ar-099', 2429], ['us-co-121', 2430],
        ['us-tx-385', 2431], ['us-oh-011', 2432], ['us-oh-107', 2433],
        ['us-in-001', 2434], ['us-ky-153', 2435], ['us-tx-017', 2436],
        ['us-mo-027', 2437], ['us-wy-029', 2438], ['us-pa-093', 2439],
        ['us-ny-081', 2440], ['us-mi-031', 2441], ['us-mi-051', 2442],
        ['us-mi-111', 2443], ['us-ky-173', 2444], ['us-sc-023', 2445],
        ['us-ky-123', 2446], ['us-ia-193', 2447], ['us-ia-093', 2448],
        ['us-fl-123', 2449], ['us-mo-201', 2450], ['us-il-003', 2451],
        ['us-il-181', 2452], ['us-mo-113', 2453], ['us-ga-051', 2454],
        ['us-fl-125', 2455], ['us-ny-037', 2456], ['us-ia-141', 2457],
        ['us-ia-041', 2458], ['us-sd-107', 2459], ['us-me-005', 2460],
        ['us-ks-095', 2461], ['us-ga-241', 2462], ['us-wv-097', 2463],
        ['us-ar-119', 2464], ['us-ia-047', 2465], ['us-oh-055', 2466],
        ['us-ny-117', 2467], ['us-va-163', 2468], ['us-nd-095', 2469],
        ['us-pa-045', 2470], ['us-vt-021', 2471], ['us-vt-003', 2472],
        ['us-fl-019', 2473], ['us-nc-183', 2474], ['us-oh-061', 2475],
        ['us-az-015', 2476], ['us-mt-055', 2477], ['us-ia-019', 2478],
        ['us-sd-047', 2479], ['us-mn-069', 2480], ['us-ga-219', 2481],
        ['us-tx-493', 2482], ['us-fl-079', 2483], ['us-in-153', 2484],
        ['us-ga-027', 2485], ['us-ks-185', 2486], ['us-ks-159', 2487],
        ['us-mi-115', 2488], ['us-ky-139', 2489], ['us-tn-103', 2490],
        ['us-ky-103', 2491], ['us-ky-211', 2492], ['us-pa-001', 2493],
        ['us-sc-009', 2494], ['us-ut-013', 2495], ['us-ut-047', 2496],
        ['us-ut-049', 2497], ['us-mo-141', 2498], ['us-mo-015', 2499],
        ['us-ia-143', 2500], ['us-in-079', 2501], ['us-in-143', 2502],
        ['us-id-083', 2503], ['us-il-165', 2504], ['us-sc-061', 2505],
        ['us-wy-019', 2506], ['us-mi-165', 2507], ['us-mi-055', 2508],
        ['us-mi-079', 2509], ['us-la-003', 2510], ['us-la-011', 2511],
        ['us-sd-069', 2512], ['us-sc-027', 2513], ['us-mt-095', 2514],
        ['us-ky-219', 2515], ['us-tn-183', 2516], ['us-tn-017', 2517],
        ['us-mo-077', 2518], ['us-ne-185', 2519], ['us-ne-159', 2520],
        ['us-ca-099', 2521], ['us-ca-047', 2522], ['us-ca-043', 2523],
        ['us-al-103', 2524], ['us-ky-027', 2525], ['us-ms-043', 2526],
        ['us-ky-213', 2527], ['us-vt-013', 2528], ['us-va-125', 2529],
        ['us-fl-093', 2530], ['us-fl-097', 2531], ['us-ar-053', 2532],
        ['us-ga-175', 2533], ['us-ar-007', 2534], ['us-ar-143', 2535],
        ['us-fl-127', 2536], ['us-fl-083', 2537], ['us-va-135', 2538],
        ['us-nj-041', 2539], ['us-ny-021', 2540], ['us-ok-023', 2541],
        ['us-ks-041', 2542], ['us-tx-427', 2543], ['us-ga-103', 2544],
        ['us-ok-129', 2545], ['us-wi-103', 2546], ['us-tx-079', 2547],
        ['us-al-075', 2548], ['us-tn-117', 2549], ['us-ar-087', 2550],
        ['us-pa-041', 2551], ['us-pa-055', 2552], ['us-pa-079', 2553],
        ['us-mi-039', 2554], ['us-al-113', 2555], ['us-va-065', 2556],
        ['us-il-097', 2557], ['us-ga-195', 2558], ['us-ar-039', 2559],
        ['us-co-057', 2560], ['us-id-001', 2561], ['us-wi-141', 2562],
        ['us-ny-013', 2563], ['us-tn-091', 2564], ['us-nc-009', 2565],
        ['us-va-195', 2566], ['us-mo-035', 2567], ['us-ok-013', 2568],
        ['us-ia-033', 2569], ['us-ky-205', 2570], ['us-mo-031', 2571],
        ['us-mo-133', 2572], ['us-ky-075', 2573], ['us-mo-143', 2574],
        ['us-ar-139', 2575], ['us-ar-013', 2576], ['us-ar-025', 2577],
        ['us-la-073', 2578], ['us-ia-007', 2579], ['us-mo-197', 2580],
        ['us-al-059', 2581], ['us-ky-041', 2582], ['us-tx-267', 2583],
        ['us-tx-095', 2584], ['us-tx-307', 2585], ['us-tx-217', 2586],
        ['us-ks-055', 2587], ['us-sc-039', 2588], ['us-mn-091', 2589],
        ['us-tn-155', 2590], ['us-tx-263', 2591], ['us-mt-099', 2592],
        ['us-ne-069', 2593], ['us-il-117', 2594], ['us-oh-141', 2595],
        ['us-il-195', 2596], ['us-tx-141', 2597], ['us-tx-229', 2598],
        ['us-tx-301', 2599], ['us-oh-167', 2600], ['us-mo-091', 2601],
        ['us-ks-047', 2602], ['us-in-061', 2603], ['us-in-043', 2604],
        ['us-ky-111', 2605], ['us-ky-029', 2606], ['us-in-019', 2607],
        ['us-il-129', 2608], ['us-wi-139', 2609], ['us-ks-079', 2610],
        ['us-ks-155', 2611], ['us-wv-091', 2612], ['us-ky-093', 2613],
        ['us-sd-057', 2614], ['us-wi-069', 2615], ['us-ny-033', 2616],
        ['us-wv-081', 2617], ['us-ca-065', 2618], ['us-ca-059', 2619],
        ['us-ca-073', 2620], ['us-az-023', 2621], ['us-il-101', 2622],
        ['us-in-125', 2623], ['us-ky-047', 2624], ['us-mi-045', 2625],
        ['us-ms-157', 2626], ['us-ms-079', 2627], ['us-ms-025', 2628],
        ['us-in-029', 2629], ['us-in-175', 2630], ['us-la-125', 2631],
        ['us-fl-063', 2632], ['us-ga-253', 2633], ['us-va-115', 2634],
        ['us-tx-283', 2635], ['us-mt-075', 2636], ['us-wi-091', 2637],
        ['us-mn-157', 2638], ['us-mo-121', 2639], ['us-tx-279', 2640],
        ['us-ks-097', 2641], ['us-tx-015', 2642], ['us-mo-061', 2643],
        ['us-ga-087', 2644], ['us-ga-201', 2645], ['us-mi-101', 2646],
        ['us-tx-195', 2647], ['us-tx-233', 2648], ['us-ks-129', 2649],
        ['us-ok-139', 2650], ['us-ok-153', 2651], ['us-ia-003', 2652],
        ['us-ca-101', 2653], ['us-ca-113', 2654], ['us-pa-105', 2655],
        ['us-ks-077', 2656], ['us-ia-133', 2657], ['us-ny-017', 2658],
        ['us-il-143', 2659], ['us-ia-091', 2660], ['us-pa-003', 2661],
        ['us-mo-205', 2662], ['us-oh-097', 2663], ['us-ks-201', 2664],
        ['us-id-087', 2665], ['us-mi-113', 2666], ['us-nd-093', 2667],
        ['us-mo-203', 2668], ['us-tx-423', 2669], ['us-ok-143', 2670],
        ['us-ok-091', 2671], ['us-tx-395', 2672], ['us-tx-171', 2673],
        ['us-mi-125', 2674], ['us-nd-033', 2675], ['us-wy-027', 2676],
        ['us-wa-025', 2677], ['us-mn-129', 2678], ['us-fl-001', 2679],
        ['us-ne-091', 2680], ['us-ut-007', 2681], ['us-pa-017', 2682],
        ['us-nj-019', 2683], ['us-sd-059', 2684], ['us-pa-081', 2685],
        ['us-id-057', 2686], ['us-va-640', 2687], ['us-nm-059', 2688],
        ['us-ok-025', 2689], ['us-tx-111', 2690], ['us-tx-269', 2691],
        ['us-tx-451', 2692], ['us-fl-049', 2693], ['us-ky-037', 2694],
        ['us-oh-025', 2695], ['us-tx-501', 2696], ['us-or-071', 2697],
        ['us-ia-115', 2698], ['us-oh-121', 2699], ['us-oh-119', 2700],
        ['us-pa-075', 2701], ['us-mn-087', 2702], ['us-nj-031', 2703],
        ['us-tx-033', 2704], ['us-ok-073', 2705], ['us-tx-051', 2706],
        ['us-ms-133', 2707], ['us-mn-053', 2708], ['us-pa-027', 2709],
        ['us-tx-025', 2710], ['us-ia-171', 2711], ['us-ne-147', 2712],
        ['us-il-021', 2713], ['us-fl-089', 2714], ['us-ga-007', 2715],
        ['us-ga-275', 2716], ['us-ky-005', 2717], ['us-ky-185', 2718],
        ['us-tn-109', 2719], ['us-vt-007', 2720], ['us-ia-139', 2721],
        ['us-ky-223', 2722], ['us-ga-055', 2723], ['us-sc-051', 2724],
        ['us-ks-131', 2725], ['us-ne-083', 2726], ['us-ks-179', 2727],
        ['us-ne-065', 2728], ['us-ky-009', 2729], ['us-nd-025', 2730],
        ['us-ca-005', 2731], ['us-tn-049', 2732], ['us-mi-023', 2733],
        ['us-va-031', 2734], ['us-oh-105', 2735], ['us-ok-053', 2736],
        ['us-sd-115', 2737], ['us-tx-455', 2738], ['us-ga-205', 2739],
        ['us-ky-147', 2740], ['us-ky-191', 2741], ['us-ky-215', 2742],
        ['us-ne-175', 2743], ['us-tx-069', 2744], ['us-md-043', 2745],
        ['us-ky-133', 2746], ['us-va-680', 2747], ['us-ar-125', 2748],
        ['us-wv-053', 2749], ['us-ms-063', 2750], ['us-nd-079', 2751],
        ['us-mt-103', 2752], ['us-ky-049', 2753], ['us-mi-005', 2754],
        ['us-tn-005', 2755], ['us-mn-015', 2756], ['us-va-109', 2757],
        ['us-in-145', 2758], ['us-oh-049', 2759], ['us-ks-093', 2760],
        ['us-ia-117', 2761], ['us-ky-239', 2762], ['us-sc-053', 2763],
        ['us-sc-065', 2764], ['us-sc-087', 2765], ['us-mn-103', 2766],
        ['us-wi-075', 2767], ['us-wa-011', 2768], ['us-wa-059', 2769],
        ['us-wi-051', 2770], ['us-la-123', 2771], ['us-fl-077', 2772],
        ['us-ks-083', 2773], ['us-ks-069', 2774], ['us-ks-057', 2775],
        ['us-ks-119', 2776], ['us-ms-001', 2777], ['us-ms-057', 2778],
        ['us-ky-073', 2779], ['us-ga-217', 2780], ['us-sd-049', 2781],
        ['us-mi-061', 2782], ['us-tn-127', 2783], ['us-la-029', 2784],
        ['us-la-063', 2785], ['us-ma-009', 2786], ['us-wv-009', 2787],
        ['us-wv-013', 2788], ['us-va-021', 2789], ['us-wv-043', 2790],
        ['us-ca-033', 2791], ['us-ga-131', 2792], ['us-co-021', 2793],
        ['us-ut-055', 2794], ['us-in-133', 2795], ['us-id-047', 2796],
        ['us-tn-167', 2797], ['us-tn-075', 2798], ['us-tn-097', 2799],
        ['us-mo-171', 2800], ['us-nd-059', 2801], ['us-nc-041', 2802],
        ['us-nc-021', 2803], ['us-nc-089', 2804], ['us-ca-063', 2805],
        ['us-ar-115', 2806], ['us-tx-183', 2807], ['us-ar-089', 2808],
        ['us-mo-187', 2809], ['us-co-025', 2810], ['us-tx-487', 2811],
        ['us-or-015', 2812], ['us-ut-051', 2813], ['us-ar-011', 2814],
        ['us-tx-193', 2815], ['us-mn-041', 2816], ['us-mt-077', 2817],
        ['us-mt-043', 2818], ['us-mt-007', 2819], ['us-mt-023', 2820],
        ['us-mt-039', 2821], ['us-mt-001', 2822], ['us-tn-001', 2823],
        ['us-oh-077', 2824], ['us-ga-005', 2825], ['us-de-001', 2826],
        ['us-il-095', 2827], ['us-mt-107', 2828], ['us-tn-015', 2829],
        ['us-ky-165', 2830], ['us-sd-089', 2831], ['us-co-051', 2832],
        ['us-mi-047', 2833], ['us-mn-151', 2834], ['us-ga-267', 2835],
        ['us-tx-429', 2836], ['us-nc-117', 2837], ['us-mt-081', 2838],
        ['us-ga-317', 2839], ['us-ca-081', 2840], ['us-oh-159', 2841],
        ['us-oh-035', 2842], ['us-oh-153', 2843], ['us-oh-103', 2844],
        ['us-tx-285', 2845], ['us-ok-105', 2846], ['us-ga-125', 2847],
        ['us-or-059', 2848], ['us-sd-113', 2849], ['us-ks-117', 2850],
        ['us-la-065', 2851], ['us-ga-313', 2852], ['us-ks-203', 2853],
        ['us-ne-027', 2854], ['us-il-111', 2855], ['us-mt-069', 2856],
        ['us-mo-033', 2857], ['us-wa-021', 2858], ['us-wa-075', 2859],
        ['us-ne-169', 2860], ['us-tn-033', 2861], ['us-tn-053', 2862],
        ['us-ia-079', 2863], ['us-ga-255', 2864], ['us-ks-107', 2865],
        ['us-mo-217', 2866], ['us-in-121', 2867], ['us-ia-069', 2868],
        ['us-ga-035', 2869], ['us-tx-035', 2870], ['us-nd-069', 2871],
        ['us-il-015', 2872], ['us-or-031', 2873], ['us-al-051', 2874],
        ['us-ga-187', 2875], ['us-oh-083', 2876], ['us-tx-175', 2877],
        ['us-fl-061', 2878], ['us-tx-065', 2879], ['us-tx-379', 2880],
        ['us-ks-067', 2881], ['us-va-105', 2882], ['us-nm-051', 2883],
        ['us-ne-123', 2884], ['us-ar-109', 2885], ['us-co-077', 2886],
        ['us-mo-065', 2887], ['us-va-185', 2888], ['us-pa-103', 2889],
        ['us-pa-115', 2890], ['us-tx-343', 2891], ['us-pa-125', 2892],
        ['us-vt-001', 2893], ['us-vt-023', 2894], ['us-ks-103', 2895],
        ['us-ks-087', 2896], ['us-mi-121', 2897], ['us-ms-049', 2898],
        ['us-tx-281', 2899], ['us-va-107', 2900], ['us-mo-185', 2901],
        ['us-mt-071', 2902], ['us-mo-129', 2903], ['us-nc-127', 2904],
        ['us-mo-159', 2905], ['us-mt-063', 2906], ['us-va-047', 2907],
        ['us-wv-069', 2908], ['us-va-165', 2909], ['us-in-183', 2910],
        ['us-ca-093', 2911], ['us-sd-037', 2912], ['us-la-071', 2913],
        ['us-al-127', 2914], ['us-mo-063', 2915], ['us-fl-039', 2916],
        ['us-ga-083', 2917], ['us-va-187', 2918], ['us-tn-113', 2919],
        ['us-co-033', 2920], ['us-oh-089', 2921], ['us-al-101', 2922],
        ['us-al-041', 2923], ['us-ms-067', 2924], ['us-wi-021', 2925],
        ['us-mn-029', 2926], ['us-ks-163', 2927], ['us-in-041', 2928],
        ['us-ne-079', 2929], ['us-ne-081', 2930], ['us-ne-115', 2931],
        ['us-al-007', 2932], ['us-al-021', 2933], ['us-ms-075', 2934],
        ['us-mn-011', 2935], ['us-mn-013', 2936], ['us-va-091', 2937],
        ['us-nh-017', 2938], ['us-mi-041', 2939], ['us-ar-131', 2940],
        ['us-ga-207', 2941], ['us-mo-069', 2942], ['us-ga-117', 2943],
        ['us-tx-249', 2944], ['us-mi-073', 2945], ['us-tx-421', 2946],
        ['us-tx-341', 2947], ['us-sc-017', 2948], ['us-wy-035', 2949],
        ['us-ky-069', 2950], ['us-wi-019', 2951], ['us-sc-091', 2952],
        ['us-pa-119', 2953], ['us-va-570', 2954], ['us-va-670', 2955],
        ['us-va-730', 2956], ['us-la-001', 2957], ['us-sd-123', 2958],
        ['us-ia-077', 2959], ['us-ia-183', 2960], ['us-sd-111', 2961],
        ['us-ok-051', 2962], ['us-wi-109', 2963], ['us-pa-121', 2964],
        ['us-tx-479', 2965], ['us-nc-123', 2966], ['us-me-003', 2967],
        ['us-ms-065', 2968], ['us-tx-031', 2969], ['us-va-025', 2970],
        ['us-tn-045', 2971], ['us-ar-075', 2972], ['us-nd-027', 2973],
        ['us-wi-057', 2974], ['us-wi-081', 2975], ['us-tn-151', 2976],
        ['us-sd-031', 2977], ['us-nc-181', 2978], ['us-sc-011', 2979],
        ['us-tn-039', 2980], ['us-al-055', 2981], ['us-id-025', 2982],
        ['us-tn-119', 2983], ['us-il-077', 2984], ['us-sc-043', 2985],
        ['us-ut-019', 2986], ['us-ut-045', 2987], ['us-va-650', 2988],
        ['us-wi-011', 2989], ['us-va-069', 2990], ['us-wv-041', 2991],
        ['us-mn-119', 2992], ['us-mn-127', 2993], ['us-tn-047', 2994],
        ['us-la-089', 2995], ['us-ar-111', 2996], ['us-fl-045', 2997],
        ['us-tn-063', 2998], ['us-tx-351', 2999], ['us-tx-219', 3000],
        ['us-nc-175', 3001], ['us-nc-171', 3002], ['us-al-031', 3003],
        ['us-id-027', 3004], ['us-fl-073', 3005], ['us-ok-119', 3006],
        ['us-al-039', 3007], ['us-ky-045', 3008], ['us-ky-169', 3009],
        ['us-ky-207', 3010], ['us-me-019', 3011], ['us-me-025', 3012],
        ['us-ky-179', 3013], ['us-ky-187', 3014], ['us-mo-155', 3015],
        ['us-ne-125', 3016], ['us-tx-365', 3017], ['us-ky-011', 3018],
        ['us-ia-167', 3019], ['us-ca-021', 3020], ['us-mo-510', 3021],
        ['us-sd-091', 3022], ['us-ne-107', 3023], ['us-mt-079', 3024],
        ['us-ia-005', 3025], ['us-tx-339', 3026], ['us-tx-319', 3027],
        ['us-nc-043', 3028], ['us-ny-093', 3029], ['us-ks-197', 3030],
        ['us-ky-181', 3031], ['us-wi-071', 3032], ['us-nc-047', 3033],
        ['us-oh-053', 3034], ['us-oh-031', 3035], ['us-tx-205', 3036],
        ['us-ia-189', 3037], ['us-tx-505', 3038], ['us-ky-019', 3039],
        ['us-mn-019', 3040], ['us-ne-037', 3041], ['us-sc-025', 3042],
        ['us-tn-101', 3043], ['us-or-067', 3044], ['us-va-810', 3045],
        ['us-mt-057', 3046], ['us-mt-093', 3047], ['us-va-103', 3048],
        ['us-mo-013', 3049], ['us-nh-001', 3050], ['us-va-159', 3051],
        ['us-ks-173', 3052], ['us-tx-453', 3053], ['us-fl-057', 3054],
        ['us-nj-021', 3055], ['us-pa-129', 3056], ['us-ia-029', 3057],
        ['us-ky-115', 3058], ['us-ri-003', 3059], ['us-vt-019', 3060],
        ['us-ks-085', 3061], ['us-la-041', 3062], ['us-ms-155', 3063],
        ['us-ma-011', 3064], ['us-ar-057', 3065], ['us-mo-029', 3066],
        ['us-va-117', 3067], ['us-ky-233', 3068], ['us-ok-047', 3069],
        ['us-mi-091', 3070], ['us-ga-123', 3071], ['us-ms-089', 3072],
        ['us-tx-227', 3073], ['us-wv-099', 3074], ['us-va-760', 3075],
        ['us-ca-079', 3076], ['us-tx-001', 3077], ['us-nd-071', 3078],
        ['us-co-029', 3079], ['us-nm-021', 3080], ['us-co-083', 3081],
        ['us-mt-049', 3082], ['us-tx-457', 3083], ['us-wa-077', 3084],
        ['us-tx-347', 3085], ['us-mt-089', 3086], ['us-nm-047', 3087],
        ['us-sd-103', 3088], ['us-ia-149', 3089], ['us-id-005', 3090],
        ['us-az-025', 3091], ['us-az-012', 3092], ['us-sd-065', 3093],
        ['us-ok-077', 3094], ['us-ny-067', 3095], ['us-mn-097', 3096],
        ['us-wa-001', 3097], ['us-co-039', 3098], ['us-al-073', 3099],
        ['us-nm-061', 3100], ['us-nv-009', 3101], ['us-or-011', 3102],
        ['us-ca-107', 3103], ['us-az-007', 3104], ['us-ks-003', 3105],
        ['us-wa-009', 3106], ['us-mi-083', 3107], ['us-mt-035', 3108],
        ['us-nm-005', 3109], ['us-mt-047', 3110], ['us-ca-025', 3111],
        ['us-mt-085', 3112], ['us-nd-065', 3113], ['us-me-021', 3114],
        ['us-mt-061', 3115], ['us-mt-021', 3116], ['us-mn-125', 3117],
        ['us-wy-017', 3118], [null, 3119], ['us-hi-003', 3120],
        ['us-hi-007', 3121], ['us-hi-009', 3122], ['us-hi-001', 3123],
        ['us-hi-005', 3124], [null, 3125], ['us-ak-110', 3126],
        ['us-ak-261', 3127], ['us-ak-070', 3128], ['us-ak-013', 3129],
        ['us-ak-180', 3130], ['us-ak-016', 3131], ['us-ak-150', 3132],
        ['us-ak-290', 3133], ['us-ak-170', 3134], ['us-ak-068', 3135],
        ['us-ak-105', 3136], ['us-ak-164', 3137], ['us-ak-060', 3138],
        ['us-ak-130', 3139], ['us-ak-195', 3140], ['us-ak-220', 3141],
        ['us-ak-090', 3142], ['us-ak-020', 3143], ['us-ak-198', 3144],
        ['us-ak-100', 3145], ['us-ak-122', 3146], ['us-ak-050', 3147],
        ['us-ak-230', 3148], ['us-ak-240', 3149], ['us-ak-188', 3150],
        ['us-ak-270', 3151], ['us-ak-185', 3152], ['us-ak-282', 3153],
        ['us-ak-275', 3154], [null, 3155]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/us/us-all-all-highres.topo.json">United States of America, admin2, highres</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
