(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/countries/zm/zm-all.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['zm-lp', 10], ['zm-no', 11], ['zm-ce', 12], ['zm-ea', 13],
        ['zm-ls', 14], ['zm-co', 15], ['zm-nw', 16], ['zm-so', 17],
        ['zm-we', 18], ['zm-mu', 19]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/countries/zm/zm-all.topo.json">Zambia</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
