(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/custom/oceania.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['id', 10], ['pw', 11], ['sb', 12], ['au', 13], ['nz', 14], ['nr', 15],
        ['tv', 16], ['pg', 17], ['mh', 18], ['fm', 19], ['vu', 20], ['my', 21],
        ['fj', 22], ['ph', 23]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/custom/oceania.topo.json">Oceania</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
