// Prepare demo data
// Data is joined to map using value of 'hc-key' property by default.
// See API docs for 'joinBy' for more info on linking data and map.
var data = [
    ['fo', 0],
    ['us', 1],
    ['jp', 2],
    ['fr', 3],
    ['cn', 4],
    ['sw', 5],
    ['sh', 6],
    ['ph', 7],
    ['es', 8],
    ['bu', 9],
    ['mv', 10],
    ['sp', 11],
    ['gb', 12],
    ['gr', 13],
    ['dk', 14],
    ['gl', 15],
    ['pr', 16],
    ['um', 17],
    ['vi', 18],
    ['ca', 19],
    ['cv', 20],
    ['dm', 21],
    ['sc', 22],
    ['jm', 23],
    ['om', 24],
    ['vc', 25],
    ['bd', 26],
    ['sb', 27],
    ['lc', 28],
    ['no', 29],
    ['kn', 30],
    ['bh', 31],
    ['id', 32],
    ['mu', 33],
    ['ru', 34],
    ['tt', 35],
    ['br', 36],
    ['bs', 37],
    ['pw', 38],
    ['cl', 39],
    ['gd', 40],
    ['ag', 41],
    ['tw', 42],
    ['fj', 43],
    ['bb', 44],
    ['it', 45],
    ['mt', 46],
    ['sg', 47],
    ['cy', 48],
    ['km', 49],
    ['ug', 50],
    ['va', 51],
    ['sm', 52],
    ['az', 53],
    ['sd', 54],
    ['ly', 55],
    ['tj', 56],
    ['ls', 57],
    ['uz', 58],
    ['in', 59],
    ['pt', 60],
    ['mx', 61],
    ['ma', 62],
    ['tz', 63],
    ['ar', 64],
    ['sa', 65],
    ['nl', 66],
    ['ye', 67],
    ['ae', 68],
    ['ke', 69],
    ['ss', 70],
    ['tr', 71],
    ['pg', 72],
    ['fi', 73],
    ['se', 74],
    ['my', 75],
    ['vn', 76],
    ['pa', 77],
    ['ir', 78],
    ['ht', 79],
    ['do', 80],
    ['gw', 81],
    ['ba', 82],
    ['hr', 83],
    ['th', 84],
    ['ee', 85],
    ['cd', 86],
    ['kw', 87],
    ['de', 88],
    ['cz', 89],
    ['ch', 90],
    ['ie', 91],
    ['mm', 92],
    ['gq', 93],
    ['am', 94],
    ['tn', 95],
    ['tl', 96],
    ['mr', 97],
    ['dz', 98],
    ['pe', 99],
    ['ao', 100],
    ['mz', 101],
    ['cr', 102],
    ['sv', 103],
    ['kh', 104],
    ['gt', 105],
    ['bz', 106],
    ['kp', 107],
    ['kr', 108],
    ['ve', 109],
    ['gy', 110],
    ['hn', 111],
    ['ga', 112],
    ['il', 113],
    ['eg', 114],
    ['ni', 115],
    ['mw', 116],
    ['tm', 117],
    ['kz', 118],
    ['zm', 119],
    ['nc', 120],
    ['za', 121],
    ['lt', 122],
    ['et', 123],
    ['er', 124],
    ['gh', 125],
    ['si', 126],
    ['jo', 127],
    ['sy', 128],
    ['mc', 129],
    ['al', 130],
    ['uy', 131],
    ['cnm', 132],
    ['mn', 133],
    ['rw', 134],
    ['sx', 135],
    ['so', 136],
    ['bo', 137],
    ['cm', 138],
    ['cg', 139],
    ['eh', 140],
    ['me', 141],
    ['rs', 142],
    ['bj', 143],
    ['tg', 144],
    ['af', 145],
    ['ua', 146],
    ['sk', 147],
    ['jk', 148],
    ['pk', 149],
    ['bg', 150],
    ['ro', 151],
    ['qa', 152],
    ['li', 153],
    ['at', 154],
    ['sz', 155],
    ['hu', 156],
    ['ne', 157],
    ['lu', 158],
    ['ad', 159],
    ['ci', 160],
    ['lr', 161],
    ['sl', 162],
    ['bn', 163],
    ['be', 164],
    ['iq', 165],
    ['ge', 166],
    ['gm', 167],
    ['td', 168],
    ['ng', 169],
    ['kv', 170],
    ['lb', 171],
    ['dj', 172],
    ['bi', 173],
    ['sr', 174],
    ['sn', 175],
    ['gn', 176],
    ['zw', 177],
    ['pl', 178],
    ['mk', 179],
    ['py', 180],
    ['by', 181],
    ['lv', 182],
    ['bf', 183],
    ['na', 184],
    ['la', 185],
    ['ec', 186],
    ['co', 187],
    ['ml', 188],
    ['cf', 189],
    ['bt', 190],
    ['kg', 191],
    ['au', 192],
    ['nz', 193],
    ['cu', 194],
    ['mg', 195],
    ['vu', 196],
    ['is', 197],
    ['lk', 198],
    ['bw', 199],
    ['np', 200],
    ['md', 201]
];

// Create the chart
Highcharts.mapChart('container', {
    chart: {
        map: 'custom/world-eckert3-lowres'
    },

    title: {
        text: 'Highmaps basic demo'
    },

    subtitle: {
        text: 'Source map: <a href="https://code.highcharts.com/mapdata/custom/world-eckert3-lowres.js">World, Eckert III projection, low resolution</a>'
    },

    mapNavigation: {
        enabled: true,
        buttonOptions: {
            verticalAlign: 'bottom'
        }
    },

    colorAxis: {
        min: 0
    },

    series: [{
        data: data,
        name: 'Random data',
        states: {
            hover: {
                color: '#BADA55'
            }
        },
        dataLabels: {
            enabled: true,
            format: '{point.name}'
        }
    }]
});
