(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/historical/countries/no-2019/no-vf-all-2019.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['no-vf-701', 10], ['no-vf-723', 11], ['no-vf-706', 12],
        ['no-vf-722', 13], ['no-vf-711', 14], ['no-vf-709', 15],
        ['no-vf-714', 16], ['no-vf-720', 17], ['no-vf-716', 18],
        ['no-vf-704', 19], ['no-vf-713', 20], ['no-vf-728', 21],
        ['no-vf-702', 22], ['no-vf-719', 23]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/historical/countries/no-2019/no-vf-all-2019.topo.json">Vestfold (2019)</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
