(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/historical/countries/no-2023/no-all-all-2023.topo.json'
    ).then(response => response.json());

    // Prepare demo data. The data is joined to map using value of 'hc-key'
    // property by default. See API docs for 'joinBy' for more info on linking
    // data and map.
    const data = [
        ['no-tf-5429', 10], ['no-tf-5427', 11], ['no-vl-4625', 12],
        ['no-tf-5401', 13], ['no-td-5052', 14], ['no-mr-1576', 15],
        ['no-no-1837', 16], ['no-no-1834', 17], ['no-no-1835', 18],
        ['no-no-1838', 19], ['no-tf-5434', 20], ['no-tf-5432', 21],
        ['no-td-5037', 22], ['no-ag-4207', 23], ['no-tf-5436', 24],
        ['no-ro-1145', 25], ['no-vl-4633', 26], ['no-mr-1547', 27],
        ['no-no-1828', 28], ['no-no-1820', 29], ['no-tf-5420', 30],
        ['no-no-1848', 31], ['no-no-1865', 32], ['no-no-1868', 33],
        ['no-mr-1515', 34], ['no-no-1815', 35], ['no-no-1816', 36],
        ['no-no-1813', 37], ['no-no-1818', 38], ['no-mr-1532', 39],
        ['no-mr-1531', 40], ['no-ro-1151', 41], ['no-vl-4635', 42],
        ['no-vl-4636', 43], ['no-vi-3011', 44], ['no-no-1856', 45],
        ['no-no-1857', 46], ['no-tf-5423', 47], ['no-no-1804', 48],
        ['no-no-1845', 49], ['no-vl-4627', 50], ['no-no-1870', 51],
        ['no-tf-5413', 52], ['no-td-5038', 53], ['no-no-1866', 54],
        ['no-vl-4637', 55], ['no-td-5043', 56], ['no-td-5035', 57],
        ['no-td-5031', 58], ['no-ro-1144', 59], ['no-ro-1103', 60],
        ['no-vl-4626', 61], ['no-vl-4602', 62], ['no-td-5056', 63],
        ['no-mr-1506', 64], ['no-td-5060', 65], ['no-td-5007', 66],
        ['no-td-5058', 67], ['no-vt-3804', 68], ['no-vt-3803', 69],
        ['no-no-1836', 70], ['no-vt-3801', 71], ['no-ag-4227', 72],
        ['no-vl-4614', 73], ['no-tf-5406', 74], ['no-vl-4645', 75],
        ['no-mr-1514', 76], ['no-no-1812', 77], ['no-vt-3816', 78],
        ['no-vt-3807', 79], ['no-vi-3021', 80], ['no-vi-3022', 81],
        ['no-tf-5428', 82], ['no-tf-5426', 83], ['no-vt-3813', 84],
        ['no-vt-3814', 85], ['no-vt-3815', 86], ['no-ro-1149', 87],
        ['no-mr-1566', 88], ['no-vl-4628', 89], ['no-ag-4211', 90],
        ['no-ro-1120', 91], ['no-ro-1124', 92], ['no-ro-1127', 93],
        ['no-vl-4619', 94], ['no-vl-4620', 95], ['no-vl-4622', 96],
        ['no-vl-4624', 97], ['no-vi-3003', 98], ['no-ag-4212', 99],
        ['no-ag-4201', 100], ['no-ag-4203', 101], ['no-ag-4202', 102],
        ['no-no-1841', 103], ['no-no-1840', 104], ['no-in-3430', 105],
        ['no-in-3427', 106], ['no-in-3426', 107], ['no-in-3425', 108],
        ['no-in-3421', 109], ['no-in-3424', 110], ['no-mr-1539', 111],
        ['no-ag-4214', 112], ['no-in-3443', 113], ['no-vi-3037', 114],
        ['no-vi-3036', 115], ['no-vi-3032', 116], ['no-vi-3033', 117],
        ['no-in-3416', 118], ['no-vi-3034', 119], ['no-in-3442', 120],
        ['no-vi-3035', 121], ['no-in-3419', 122], ['no-vi-3031', 123],
        ['no-vi-3030', 124], ['no-td-5053', 125], ['no-in-3432', 126],
        ['no-in-3431', 127], ['no-ag-4206', 128], ['no-in-3434', 129],
        ['no-vi-3044', 130], ['no-vi-3018', 131], ['no-vi-3017', 132],
        ['no-vl-4615', 133], ['no-vl-4613', 134], ['no-no-1832', 135],
        ['no-no-1833', 136], ['no-no-1839', 137], ['no-tf-5435', 138],
        ['no-tf-5433', 139], ['no-tf-5403', 140], ['no-vt-3818', 141],
        ['no-vt-3820', 142], ['no-vt-3808', 143], ['no-vi-3040', 144],
        ['no-vi-3043', 145], ['no-td-5034', 146], ['no-td-5036', 147],
        ['no-td-5028', 148], ['no-td-5029', 149], ['no-ro-1133', 150],
        ['no-ro-1134', 151], ['no-ro-1130', 152], ['no-ro-1135', 153],
        ['no-td-5032', 154], ['no-td-5033', 155], ['no-td-5027', 156],
        ['no-in-3438', 157], ['no-in-3437', 158], ['no-vi-3039', 159],
        ['no-in-3449', 160], ['no-vi-3046', 161], ['no-vi-3047', 162],
        ['no-vi-3045', 163], ['no-vl-4617', 164], ['no-vl-4616', 165],
        ['no-vi-3049', 166], ['no-vi-3038', 167], ['no-vi-3048', 168],
        ['no-no-1871', 169], ['no-mr-1505', 170], ['no-tf-5442', 171],
        ['no-tf-5441', 172], ['no-ag-4222', 173], ['no-ag-4228', 174],
        ['no-ro-1146', 175], ['no-vl-4634', 176], ['no-vl-4632', 177],
        ['no-in-3441', 178], ['no-in-3451', 179], ['no-vi-3041', 180],
        ['no-in-3452', 181], ['no-in-3435', 182], ['no-in-3453', 183],
        ['no-in-3436', 184], ['no-in-3454', 185], ['no-in-3439', 186],
        ['no-vi-3015', 187], ['no-vi-3016', 188], ['no-vi-3001', 189],
        ['no-no-1824', 190], ['no-no-1822', 191], ['no-ag-4216', 192],
        ['no-ag-4223', 193], ['no-in-3422', 194], ['no-in-3412', 195],
        ['no-in-3413', 196], ['no-in-3418', 197], ['no-in-3440', 198],
        ['no-in-3411', 199], ['no-in-3414', 200], ['no-in-3415', 201],
        ['no-ag-4215', 202], ['no-tf-5415', 203], ['no-tf-5416', 204],
        ['no-tf-5417', 205], ['no-tf-5419', 206], ['no-vt-3824', 207],
        ['no-vt-3821', 208], ['no-ag-4221', 209], ['no-vt-3822', 210],
        ['no-vl-4629', 211], ['no-td-5025', 212], ['no-td-5022', 213],
        ['no-td-5041', 214], ['no-vl-4642', 215], ['no-vi-3042', 216],
        ['no-vl-4643', 217], ['no-vl-4644', 218], ['no-vl-4646', 219],
        ['no-in-3403', 220], ['no-in-3407', 221], ['no-vi-3050', 222],
        ['no-vi-3052', 223], ['no-vl-4612', 224], ['no-no-1860', 225],
        ['no-no-1867', 226], ['no-ag-4219', 227], ['no-ag-4220', 228],
        ['no-ag-4217', 229], ['no-ag-4218', 230], ['no-ro-1106', 231],
        ['no-ro-1114', 232], ['no-ro-1121', 233], ['no-ro-1101', 234],
        ['no-mr-1517', 235], ['no-mr-1516', 236], ['no-mr-1511', 237],
        ['no-no-1825', 238], ['no-no-1811', 239], ['no-mr-1535', 240],
        ['no-vl-4623', 241], ['no-in-3429', 242], ['no-in-3423', 243],
        ['no-vt-3806', 244], ['no-vt-3812', 245], ['no-vi-3023', 246],
        ['no-vi-3019', 247], ['no-os-3024', 248], ['no-mr-1554', 249],
        ['no-mr-1557', 250], ['no-in-3446', 251], ['no-in-3054', 252],
        ['no-vl-4638', 253], ['no-vl-4639', 254], ['no-vl-4641', 255],
        ['no-vi-3013', 256], ['no-vi-3012', 257], ['no-no-1859', 258],
        ['no-in-3447', 259], ['no-vi-3007', 260], ['no-no-1851', 261],
        ['no-no-1853', 262], ['no-in-3433', 263], ['no-mr-1525', 264],
        ['no-vl-4651', 265], ['no-mr-1520', 266], ['no-vl-4630', 267],
        ['no-ag-4213', 268], ['no-in-3417', 269], ['no-mr-1528', 270],
        ['no-os-301', 271], ['no-vi-3029', 272], ['no-tf-5418', 273],
        ['no-tf-5425', 274], ['no-tf-5424', 275], ['no-in-3448', 276],
        ['no-in-3405', 277], ['no-td-5045', 278], ['no-td-5042', 279],
        ['no-td-5021', 280], ['no-vi-3028', 281], ['no-vi-3027', 282],
        ['no-ag-4224', 283], ['no-td-5046', 284], ['no-td-5047', 285],
        ['no-vi-3006', 286], ['no-ro-1160', 287], ['no-vl-4601', 288],
        ['no-vl-4611', 289], ['no-ro-1111', 290], ['no-vl-4650', 291],
        ['no-vl-4648', 292], ['no-ro-1112', 293], ['no-ro-1119', 294],
        ['no-mr-1563', 295], ['no-mr-5061', 296], ['no-vi-3004', 297],
        ['no-no-1874', 298], ['no-tf-5437', 299], ['no-td-5020', 300],
        ['no-vt-3819', 301], ['no-in-3450', 302], ['no-no-1826', 303],
        ['no-vt-3823', 304], ['no-vt-3825', 305], ['no-td-5026', 306],
        ['no-vi-3051', 307], ['no-in-3401', 308], ['no-in-3053', 309],
        ['no-in-3420', 310], ['no-td-5044', 311], ['no-ag-4225', 312],
        ['no-ag-4226', 313], ['no-ag-4205', 314], ['no-ag-4204', 315],
        ['no-ro-1108', 316], ['no-ro-1122', 317], ['no-vl-4621', 318],
        ['no-vl-4631', 319], ['no-vl-4618', 320], ['no-mr-1578', 321],
        ['no-mr-1577', 322], ['no-vl-4649', 323], ['no-vl-4647', 324],
        ['no-vl-4640', 325], ['no-mr-1507', 326], ['no-td-5001', 327],
        ['no-td-5059', 328], ['no-mr-5055', 329], ['no-mr-1579', 330],
        ['no-td-5049', 331], ['no-td-5006', 332], ['no-td-5054', 333],
        ['no-td-5057', 334], ['no-no-1806', 335], ['no-no-1875', 336],
        ['no-tf-5414', 337], ['no-vi-3026', 338], ['no-tf-5421', 339],
        ['no-tf-5412', 340], ['no-tf-5411', 341], ['no-tf-5402', 342],
        ['no-vt-3805', 343], ['no-vt-3811', 344], ['no-vi-3005', 345],
        ['no-vi-3025', 346], ['no-vi-3002', 347], ['no-vi-5435', 348],
        ['no-vi-3014', 349], ['no-vt-3817', 350], ['no-vt-3802', 351],
        ['no-td-5014', 352], ['no-no-1827', 353], ['no-tf-5444', 354],
        ['no-tf-5404', 355], ['no-tf-5438', 356], ['no-mr-1573', 357],
        ['no-tf-5430', 358], ['no-tf-5440', 359], ['no-tf-5439', 360],
        ['no-tf-5443', 361], ['no-mr-1560', 362], ['no-tf-5422', 363],
        ['no-tf-5405', 364], ['no-in-3428', 365], [null, 366]
    ];

    // Create the chart
    Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Highcharts Maps basic demo'
        },

        subtitle: {
            text: 'Source map: <a href="https://code.highcharts.com/mapdata/historical/countries/no-2023/no-all-all-2023.topo.json">Norway, admin2 (2023)</a>'
        },

        mapNavigation: {
            enabled: true,
            buttonOptions: {
                verticalAlign: 'bottom'
            }
        },

        colorAxis: {
            min: 0
        },

        series: [{
            data: data,
            name: 'Random data',
            states: {
                hover: {
                    color: '#BADA55'
                }
            },
            dataLabels: {
                enabled: true,
                format: '{point.name}'
            }
        }]
    });

})();
