(async () => {
    // Load map
    const topology = await fetch(
        'https://code.highcharts.com/mapdata/custom/north-america.topo.json'
    ).then(response => response.json());


    // Map configuration
    const chart = Highcharts.mapChart('container', {
        chart: {
            map: topology
        },

        title: {
            text: 'Audio Chart',
            align: 'left'
        },

        subtitle: {
            text: 'Sonify the trajectory of an underwater probe',
            align: 'left'
        },

        sonification: {
            duration: 16000
        },

        mapView: {
            center: [-80, 35],
            zoom: 4.1
        },

        legend: {
            enabled: false
        },

        tooltip: {
            pointFormat: 'Lat: {point.lat}<br>Lon: {point.lon}'
        },

        plotOptions: {
            mappoint: {
                keys: ['lon', 'lat', 'custom.label'],
                lineWidth: 2,
                marker: {
                    enabled: false,
                    radius: 2
                },
                dataLabels: {
                    enabled: true,
                    format: '{point.options.custom.label}',
                    color: '#c03030'
                },
                sonification: {
                    tracks: [{
                        instrument: 'basic1',
                        roundToMusicalNotes: false,
                        mapping: {
                            pan: 'lon',
                            pitch: {
                                mapTo: 'lat',
                                min: 'g3',
                                max: 'c6'
                            },
                            volume: 0.7
                        }
                    }],
                    contextTracks: [{
                        timeInterval: 250,
                        valueProp: 'index',
                        instrument: 'flute',
                        mapping: {
                            pitch: 'c6',
                            pan: -1,
                            volume: 0.15
                        }
                    }, {
                        timeInterval: 333,
                        valueProp: 'index',
                        instrument: 'flute',
                        mapping: {
                            pitch: 'g3',
                            pan: 1,
                            volume: 0.35
                        }
                    }]
                }
            }
        },

        series: [{
            name: 'Base map',
            dataLabels: {
                enabled: true,
                format: '{point.name}',
                filter: {
                    property: 'labelrank',
                    operator: '>',
                    value: 25
                }
            },
            borderColor: '#5E5A5D',
            nullColor: '#A8D4AD',
            sonification: {
                enabled: false
            }
        }, {
            name: 'Track 1',
            type: 'mappoint',
            color: '#e04040',
            data: [
                [-85, 28, 'start'],
                [-85.088, 28.044],
                [-85.176, 28.088],
                [-85.265, 28.132],
                [-85.353, 28.176],
                [-85.441, 28.22],
                [-85.529, 28.265],
                [-85.617, 28.309],
                [-85.705, 28.353],
                [-85.794, 28.397],
                [-85.882, 28.441],
                [-85.97, 28.485],
                [-86.012, 28.5],
                [-86.029, 28.5],
                [-86.047, 28.5],
                [-86.065, 28.5],
                [-86.082, 28.5],
                [-86.1, 28.5],
                [-86.117, 28.5],
                [-86.135, 28.5],
                [-86.153, 28.5],
                [-86.17, 28.5],
                [-86.188, 28.5],
                [-86.222, 28.5],
                [-86.293, 28.5],
                [-86.364, 28.5],
                [-86.434, 28.5],
                [-86.505, 28.5],
                [-86.575, 28.5],
                [-86.646, 28.5],
                [-86.716, 28.5],
                [-86.787, 28.5],
                [-86.857, 28.5],
                [-86.928, 28.5],
                [-86.998, 28.5],
                [-87, 28.491],
                [-87, 28.483],
                [-87, 28.474],
                [-87, 28.465],
                [-87, 28.456],
                [-87, 28.447],
                [-87, 28.438],
                [-87, 28.43],
                [-87, 28.421],
                [-87, 28.412],
                [-87, 28.403],
                [-87.056, 28.394],
                [-87.144, 28.386],
                [-87.232, 28.377],
                [-87.321, 28.368],
                [-87.409, 28.359],
                [-87.497, 28.35],
                [-87.585, 28.341],
                [-87.673, 28.333],
                [-87.762, 28.324],
                [-87.85, 28.315],
                [-87.938, 28.306],
                [-88.026, 28.297],
                [-88.114, 28.289],
                [-88.202, 28.28],
                [-88.291, 28.271],
                [-88.379, 28.262],
                [-88.467, 28.253],
                [-88.555, 28.244],
                [-88.643, 28.236],
                [-88.731, 28.227],
                [-88.82, 28.218],
                [-88.908, 28.209],
                [-88.996, 28.2],
                [-89.084, 28.183],
                [-89.172, 28.166],
                [-89.261, 28.148],
                [-89.349, 28.13],
                [-89.437, 28.113],
                [-89.525, 28.095],
                [-89.613, 28.077],
                [-89.701, 28.06],
                [-89.79, 28.042],
                [-89.878, 28.024],
                [-89.966, 28.007],
                [-90.054, 28.027],
                [-90.142, 28.071],
                [-90.23, 28.115],
                [-90.319, 28.159],
                [-90.407, 28.203],
                [-90.495, 28.247],
                [-90.583, 28.292],
                [-90.671, 28.336],
                [-90.76, 28.38],
                [-90.848, 28.424],
                [-90.936, 28.468],
                [-91, 28.495],
                [-91, 28.478],
                [-91, 28.46],
                [-91, 28.442],
                [-91, 28.425],
                [-91, 28.407],
                [-91, 28.389],
                [-91, 28.372],
                [-91, 28.354],
                [-91, 28.336],
                [-91, 28.319],
                [-91, 28.301],
                [-91.082, 28.316],
                [-91.17, 28.334],
                [-91.259, 28.352],
                [-91.347, 28.369],
                [-91.435, 28.387],
                [-91.523, 28.405],
                [-91.611, 28.422],
                [-91.699, 28.44],
                [-91.788, 28.458],
                [-91.876, 28.475],
                [-91.964, 28.493],
                [-92.052, 28.448],
                [-92.14, 28.36],
                [-92.228, 28.272],
                [-92.317, 28.183],
                [-92.405, 28.095],
                [-92.493, 28.007],
                [-92.581, 27.919],
                [-92.669, 27.831],
                [-92.758, 27.742],
                [-92.846, 27.654],
                [-92.934, 27.566],
                [-93.022, 27.467],
                [-93.11, 27.335],
                [-93.198, 27.202],
                [-93.287, 27.07],
                [-93.375, 26.938],
                [-93.463, 26.806],
                [-93.551, 26.673],
                [-93.639, 26.541],
                [-93.727, 26.409],
                [-93.816, 26.277],
                [-93.904, 26.144],
                [-93.992, 26.012],
                [-94.16, 25.92],
                [-94.337, 25.832],
                [-94.513, 25.743],
                [-94.689, 25.655],
                [-94.866, 25.567],
                [-95.042, 25.479],
                [-95.218, 25.391],
                [-95.395, 25.303],
                [-95.571, 25.214],
                [-95.747, 25.126],
                [-95.924, 25.038],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96, 25],
                [-96.02, 25],
                [-96.108, 25],
                [-96.196, 25],
                [-96.285, 25],
                [-96.373, 25],
                [-96.461, 25],
                [-96.549, 25],
                [-96.637, 25],
                [-96.725, 25],
                [-96.814, 25],
                [-96.902, 25],
                [-96.99, 25],
                [-97.008, 24.961],
                [-97.017, 24.917],
                [-97.025, 24.873],
                [-97.034, 24.829],
                [-97.043, 24.785],
                [-97.052, 24.74],
                [-97.061, 24.696],
                [-97.07, 24.652],
                [-97.078, 24.608],
                [-97.087, 24.564],
                [-97.096, 24.52],
                [-97.095, 24.476],
                [-97.086, 24.432],
                [-97.078, 24.388],
                [-97.069, 24.344],
                [-97.06, 24.3],
                [-97.051, 24.256],
                [-97.042, 24.211],
                [-97.033, 24.167],
                [-97.025, 24.123],
                [-97.016, 24.079],
                [-97.007, 24.035],
                [-96.991, 24],
                [-96.947, 24],
                [-96.903, 24],
                [-96.859, 24],
                [-96.815, 24],
                [-96.771, 24],
                [-96.726, 24],
                [-96.682, 24],
                [-96.638, 24],
                [-96.594, 24],
                [-96.55, 24],
                [-96.506, 24],
                [-96.462, 23.947],
                [-96.418, 23.885],
                [-96.374, 23.823],
                [-96.33, 23.762],
                [-96.286, 23.7],
                [-96.241, 23.638],
                [-96.197, 23.576],
                [-96.153, 23.515],
                [-96.109, 23.453],
                [-96.065, 23.391],
                [-96.021, 23.329],
                [-95.954, 23.277],
                [-95.866, 23.233],
                [-95.778, 23.189],
                [-95.689, 23.145],
                [-95.601, 23.101],
                [-95.513, 23.057],
                [-95.425, 23.012],
                [-95.337, 22.968],
                [-95.248, 22.924],
                [-95.16, 22.88],
                [-95.072, 22.836],
                [-95.006, 22.798],
                [-95.042, 22.79],
                [-95.077, 22.781],
                [-95.112, 22.772],
                [-95.147, 22.763],
                [-95.183, 22.754],
                [-95.218, 22.745],
                [-95.253, 22.737],
                [-95.289, 22.728],
                [-95.324, 22.719],
                [-95.359, 22.71],
                [-95.394, 22.701],
                [-95.296, 22.648],
                [-95.173, 22.586],
                [-95.049, 22.525],
                [-94.926, 22.463],
                [-94.802, 22.401],
                [-94.679, 22.339],
                [-94.556, 22.278],
                [-94.432, 22.216],
                [-94.309, 22.154],
                [-94.185, 22.093],
                [-94.062, 22.031],
                [-93.956, 21.978],
                [-93.868, 21.934],
                [-93.78, 21.89],
                [-93.691, 21.846],
                [-93.603, 21.802],
                [-93.515, 21.758],
                [-93.427, 21.713],
                [-93.339, 21.669],
                [-93.251, 21.625],
                [-93.162, 21.581],
                [-93.074, 21.537],
                [-92.986, 21.493],
                [-92.898, 21.449],
                [-92.81, 21.405],
                [-92.721, 21.361],
                [-92.633, 21.317],
                [-92.545, 21.273],
                [-92.457, 21.228],
                [-92.369, 21.184],
                [-92.281, 21.14],
                [-92.192, 21.096],
                [-92.104, 21.052],
                [-92.016, 21.008],
                [-92.108, 20.964],
                [-92.24, 20.92],
                [-92.373, 20.876],
                [-92.505, 20.832],
                [-92.637, 20.788],
                [-92.77, 20.743],
                [-92.902, 20.699],
                [-93.034, 20.655],
                [-93.166, 20.611],
                [-93.299, 20.567],
                [-93.431, 20.523],
                [-93.437, 20.483],
                [-93.305, 20.448],
                [-93.172, 20.413],
                [-93.04, 20.377],
                [-92.908, 20.342],
                [-92.776, 20.307],
                [-92.643, 20.272],
                [-92.511, 20.236],
                [-92.379, 20.201],
                [-92.246, 20.166],
                [-92.114, 20.13],
                [-92, 20.111],
                [-92, 20.19],
                [-92, 20.27],
                [-92, 20.349],
                [-92, 20.428],
                [-92, 20.508],
                [-92, 20.587],
                [-92, 20.666],
                [-92, 20.746],
                [-92, 20.825],
                [-92, 20.904],
                [-92, 20.984],
                [-91.93, 21.035],
                [-91.842, 21.079],
                [-91.754, 21.123],
                [-91.665, 21.167],
                [-91.577, 21.211],
                [-91.489, 21.256],
                [-91.401, 21.3],
                [-91.313, 21.344],
                [-91.224, 21.388],
                [-91.136, 21.432],
                [-91.048, 21.476],
                [-91, 21.52],
                [-91, 21.564],
                [-91, 21.608],
                [-91, 21.652],
                [-91, 21.696],
                [-91, 21.74],
                [-91, 21.785],
                [-91, 21.829],
                [-91, 21.873],
                [-91, 21.917],
                [-91, 21.961],
                [-90.99, 21.995],
                [-90.902, 21.951],
                [-90.814, 21.907],
                [-90.725, 21.863],
                [-90.637, 21.819],
                [-90.549, 21.775],
                [-90.461, 21.73],
                [-90.373, 21.686],
                [-90.285, 21.642],
                [-90.196, 21.598],
                [-90.108, 21.554],
                [-90.02, 21.51],
                [-90, 21.548],
                [-90, 21.609],
                [-90, 21.671],
                [-90, 21.733],
                [-90, 21.795],
                [-90, 21.856],
                [-90, 21.918],
                [-90, 21.98],
                [-90, 22.041],
                [-90, 22.103],
                [-90, 22.165],
                [-89.962, 22.192],
                [-89.874, 22.175],
                [-89.786, 22.157],
                [-89.697, 22.139],
                [-89.609, 22.122],
                [-89.521, 22.104],
                [-89.433, 22.087],
                [-89.345, 22.069],
                [-89.257, 22.051],
                [-89.168, 22.034],
                [-89.08, 22.016],
                [-89, 22.004],
                [-89, 22.048],
                [-89, 22.092],
                [-89, 22.136],
                [-89, 22.18],
                [-89, 22.224],
                [-89, 22.269],
                [-89, 22.313],
                [-89, 22.357],
                [-89, 22.401],
                [-89, 22.445],
                [-89, 22.489],
                [-88.967, 22.5],
                [-88.923, 22.5],
                [-88.879, 22.5],
                [-88.835, 22.5],
                [-88.791, 22.5],
                [-88.746, 22.5],
                [-88.702, 22.5],
                [-88.658, 22.5],
                [-88.614, 22.5],
                [-88.57, 22.5],
                [-88.526, 22.5],
                [-88.464, 22.536],
                [-88.376, 22.624],
                [-88.288, 22.712],
                [-88.199, 22.801],
                [-88.111, 22.889],
                [-88.023, 22.977],
                [-87.935, 23.065],
                [-87.847, 23.153],
                [-87.759, 23.241],
                [-87.67, 23.33],
                [-87.582, 23.418],
                [-87.494, 23.497],
                [-87.406, 23.453],
                [-87.318, 23.409],
                [-87.229, 23.365],
                [-87.141, 23.321],
                [-87.053, 23.277],
                [-86.965, 23.232],
                [-86.877, 23.188],
                [-86.789, 23.144],
                [-86.7, 23.1],
                [-86.612, 23.056],
                [-86.524, 23.012],
                [-86.468, 23],
                [-86.424, 23],
                [-86.38, 23],
                [-86.336, 23],
                [-86.292, 23],
                [-86.247, 23],
                [-86.203, 23],
                [-86.159, 23],
                [-86.115, 23],
                [-86.071, 23],
                [-86.027, 23],
                [-85.966, 22.966],
                [-85.878, 22.878],
                [-85.79, 22.79],
                [-85.701, 22.701],
                [-85.613, 22.613],
                [-85.525, 22.525],
                [-85.437, 22.437],
                [-85.349, 22.349],
                [-85.261, 22.261],
                [-85.172, 22.172],
                [-85.084, 22.084],
                [-84.998, 21.996],
                [-84.954, 21.908],
                [-84.91, 21.82],
                [-84.866, 21.731],
                [-84.822, 21.643],
                [-84.778, 21.555],
                [-84.733, 21.467],
                [-84.689, 21.379],
                [-84.645, 21.291],
                [-84.601, 21.202],
                [-84.557, 21.114],
                [-84.513, 21.026],
                [-84.469, 20.969],
                [-84.425, 20.925],
                [-84.381, 20.881],
                [-84.337, 20.837],
                [-84.293, 20.793],
                [-84.248, 20.748],
                [-84.204, 20.704],
                [-84.16, 20.66],
                [-84.116, 20.616],
                [-84.072, 20.572],
                [-84.028, 20.528],
                [-84, 20.452],
                [-84, 20.32],
                [-84, 20.187],
                [-84, 20.055],
                [-84, 19.923],
                [-84, 19.791],
                [-84, 19.658],
                [-84, 19.526],
                [-84, 19.394],
                [-84, 19.262],
                [-84, 19.129],
                [-83.998, 19],
                [-83.91, 19.009],
                [-83.822, 19.018],
                [-83.733, 19.027],
                [-83.645, 19.035],
                [-83.557, 19.044],
                [-83.469, 19.053],
                [-83.381, 19.062],
                [-83.293, 19.071],
                [-83.204, 19.08],
                [-83.116, 19.088],
                [-83.028, 19.097],
                [-83, 19.106],
                [-83, 19.115],
                [-83, 19.124],
                [-83, 19.132],
                [-83, 19.141],
                [-83, 19.15],
                [-83, 19.159],
                [-83, 19.168],
                [-83, 19.177],
                [-83, 19.185],
                [-83, 19.194],
                [-82.97, 19.209],
                [-82.882, 19.235],
                [-82.794, 19.262],
                [-82.705, 19.288],
                [-82.617, 19.315],
                [-82.529, 19.341],
                [-82.441, 19.368],
                [-82.353, 19.394],
                [-82.265, 19.421],
                [-82.176, 19.447],
                [-82.088, 19.474],
                [-82, 19.5, 'end']
            ]
        }]
    });

    // Play chart button
    document.getElementById('sonify').onclick = () => {
        chart.toggleSonify();
    };
})();
