(async () => {

    const topology = await fetch(
        'https://code.highcharts.com/mapdata/custom/world.topo.json'
    ).then(response => response.json());

    Highcharts.getJSON('https://cdn.jsdelivr.net/gh/highcharts/highcharts@v7.0.0/samples/data/world-population-density.json', function (data) {

        // Initialize the chart
        const chart = Highcharts.mapChart('container', {

            chart: {
                height: 500 // initial height
            },

            title: {
                text: 'Set chart size by dragging handle'
            },

            mapNavigation: {
                enabled: true,
                buttonOptions: {
                    verticalAlign: 'bottom'
                }
            },

            colorAxis: {
                min: 1,
                max: 1000,
                type: 'logarithmic'
            },

            series: [{
                data: data,
                mapData: topology,
                joinBy: ['iso-a2', 'code'],
                name: 'Population density',
                tooltip: {
                    valueSuffix: '/km²'
                }
            }]
        });

        $('#resizer').resizable({
            // On resize, set the chart size to that of the
            // resizer minus padding. If your chart has a lot of data or other
            // content, the redrawing might be slow. In that case, we recommend
            // that you use the 'stop' event instead of 'resize'.
            resize: function () {
                chart.setSize(
                    this.offsetWidth - 20,
                    this.offsetHeight - 20,
                    false
                );
            }
        });
    });

})();