// Create the chart
Highcharts.mapChart('container', {

    title: {
        text: 'Turkey Fire Areas from 2000-2021'
    },

    subtitle: {
        text: 'Highcharts Maps using GeoHeatMap and TiledWebMap series'
    },

    mapNavigation: {
        enabled: true,
        buttonOptions: {
            verticalAlign: 'bottom'
        }
    },

    colorAxis: {
        dataClasses: [{
            from: 0,
            to: 1000,
            color: 'rgba(173,255,91,0.6)'
        }, {
            from: 1000,
            to: 5000,
            color: 'rgba(255,173,51,0.6)'
        }, {
            from: 5000,
            to: 15000,
            color: 'rgba(214,51,51,0.6)'
        }, {
            from: 15000,
            color: 'rgba(255,0,0,0.6)'
        }]
    },

    tooltip: {
        headerFormat: '<span style="font-size: 11px">Lon: {point.point.lon} ' +
            'Lat: {point.point.lat}</span><br/>',
        pointFormat: 'Number of fire points: {point.value}'
    },

    series: [{
        name: 'Basemap tiles',
        type: 'tiledwebmap',
        provider: {
            type: 'OpenStreetMap',
            theme: 'Standard',
            subdomain: 'a'
        }
    }, {
        name: 'GeoHeatMap',
        type: 'geoheatmap',
        interpolation: {
            enabled: true,
            blur: 1 // Change the value to change the interpolation blur
        },
        data: [{
            lon: 25,
            lat: 40,
            value: 41
        }, {
            lon: 26,
            lat: 38,
            value: 1320
        }, {
            lon: 26,
            lat: 39,
            value: 267
        }, {
            lon: 26,
            lat: 40,
            value: 1583
        }, {
            lon: 26,
            lat: 41,
            value: 1438
        }, {
            lon: 27,
            lat: 36,
            value: 46
        }, {
            lon: 27,
            lat: 37,
            value: 1661
        }, {
            lon: 27,
            lat: 38,
            value: 3472
        }, {
            lon: 27,
            lat: 39,
            value: 625
        }, {
            lon: 27,
            lat: 40,
            value: 1553
        }, {
            lon: 27,
            lat: 41,
            value: 2484
        }, {
            lon: 27,
            lat: 42,
            value: 1
        }, {
            lon: 28,
            lat: 36,
            value: 455
        }, {
            lon: 28,
            lat: 37,
            value: 1437
        }, {
            lon: 28,
            lat: 38,
            value: 601
        }, {
            lon: 28,
            lat: 39,
            value: 232
        }, {
            lon: 28,
            lat: 40,
            value: 1171
        }, {
            lon: 28,
            lat: 41,
            value: 498
        }, {
            lon: 29,
            lat: 36,
            value: 345
        }, {
            lon: 29,
            lat: 37,
            value: 2148
        }, {
            lon: 29,
            lat: 38,
            value: 2023
        }, {
            lon: 29,
            lat: 39,
            value: 251
        }, {
            lon: 29,
            lat: 40,
            value: 1720
        }, {
            lon: 29,
            lat: 41,
            value: 24
        }, {
            lon: 30,
            lat: 36,
            value: 549
        }, {
            lon: 30,
            lat: 37,
            value: 885
        }, {
            lon: 30,
            lat: 38,
            value: 798
        }, {
            lon: 30,
            lat: 39,
            value: 1043
        }, {
            lon: 30,
            lat: 40,
            value: 856
        }, {
            lon: 30,
            lat: 41,
            value: 123
        }, {
            lon: 31,
            lat: 36,
            value: 1366
        }, {
            lon: 31,
            lat: 37,
            value: 2027
        }, {
            lon: 31,
            lat: 38,
            value: 2992
        }, {
            lon: 31,
            lat: 39,
            value: 2225
        }, {
            lon: 31,
            lat: 40,
            value: 277
        }, {
            lon: 31,
            lat: 41,
            value: 665
        }, {
            lon: 32,
            lat: 36,
            value: 452
        }, {
            lon: 32,
            lat: 37,
            value: 2369
        }, {
            lon: 32,
            lat: 38,
            value: 4882
        }, {
            lon: 32,
            lat: 39,
            value: 3812
        }, {
            lon: 32,
            lat: 40,
            value: 892
        }, {
            lon: 32,
            lat: 41,
            value: 590
        }, {
            lon: 33,
            lat: 36,
            value: 702
        }, {
            lon: 33,
            lat: 37,
            value: 3081
        }, {
            lon: 33,
            lat: 38,
            value: 2608
        }, {
            lon: 33,
            lat: 39,
            value: 4644
        }, {
            lon: 33,
            lat: 40,
            value: 1506
        }, {
            lon: 33,
            lat: 41,
            value: 109
        }, {
            lon: 34,
            lat: 36,
            value: 2127
        }, {
            lon: 34,
            lat: 37,
            value: 951
        }, {
            lon: 34,
            lat: 38,
            value: 1492
        }, {
            lon: 34,
            lat: 39,
            value: 5875
        }, {
            lon: 34,
            lat: 40,
            value: 3198
        }, {
            lon: 34,
            lat: 41,
            value: 273
        }, {
            lon: 35,
            lat: 35,
            value: 10
        }, {
            lon: 35,
            lat: 36,
            value: 14989
        }, {
            lon: 35,
            lat: 37,
            value: 11431
        }, {
            lon: 35,
            lat: 38,
            value: 1221
        }, {
            lon: 35,
            lat: 39,
            value: 4316
        }, {
            lon: 35,
            lat: 40,
            value: 2281
        }, {
            lon: 35,
            lat: 41,
            value: 287
        }, {
            lon: 35,
            lat: 42,
            value: 7
        }, {
            lon: 36,
            lat: 35,
            value: 185
        }, {
            lon: 36,
            lat: 36,
            value: 4165
        }, {
            lon: 36,
            lat: 37,
            value: 7269
        }, {
            lon: 36,
            lat: 38,
            value: 847
        }, {
            lon: 36,
            lat: 39,
            value: 1021
        }, {
            lon: 36,
            lat: 40,
            value: 365
        }, {
            lon: 36,
            lat: 41,
            value: 296
        }, {
            lon: 37,
            lat: 36,
            value: 1280
        }, {
            lon: 37,
            lat: 37,
            value: 3466
        }, {
            lon: 37,
            lat: 38,
            value: 1157
        }, {
            lon: 37,
            lat: 39,
            value: 1442
        }, {
            lon: 37,
            lat: 40,
            value: 114
        }, {
            lon: 37,
            lat: 41,
            value: 12
        }, {
            lon: 38,
            lat: 36,
            value: 2351
        }, {
            lon: 38,
            lat: 37,
            value: 5561
        }, {
            lon: 38,
            lat: 38,
            value: 709
        }, {
            lon: 38,
            lat: 39,
            value: 189
        }, {
            lon: 38,
            lat: 40,
            value: 89
        }, {
            lon: 38,
            lat: 41,
            value: 1
        }, {
            lon: 39,
            lat: 36,
            value: 4175
        }, {
            lon: 39,
            lat: 37,
            value: 13217
        }, {
            lon: 39,
            lat: 38,
            value: 1482
        }, {
            lon: 39,
            lat: 39,
            value: 300
        }, {
            lon: 39,
            lat: 40,
            value: 154
        }, {
            lon: 39,
            lat: 41,
            value: 1
        }, {
            lon: 40,
            lat: 36,
            value: 3142
        }, {
            lon: 40,
            lat: 37,
            value: 23980
        }, {
            lon: 40,
            lat: 38,
            value: 6921
        }, {
            lon: 40,
            lat: 39,
            value: 326
        }, {
            lon: 40,
            lat: 40,
            value: 164
        }, {
            lon: 40,
            lat: 41,
            value: 15
        }, {
            lon: 41,
            lat: 37,
            value: 4835
        }, {
            lon: 41,
            lat: 38,
            value: 2686
        }, {
            lon: 41,
            lat: 39,
            value: 223
        }, {
            lon: 41,
            lat: 40,
            value: 57
        }, {
            lon: 41,
            lat: 41,
            value: 22
        }, {
            lon: 42,
            lat: 37,
            value: 2910
        }, {
            lon: 42,
            lat: 38,
            value: 268
        }, {
            lon: 42,
            lat: 39,
            value: 510
        }, {
            lon: 42,
            lat: 40,
            value: 65
        }, {
            lon: 42,
            lat: 41,
            value: 45
        }, {
            lon: 43,
            lat: 37,
            value: 536
        }, {
            lon: 43,
            lat: 38,
            value: 101
        }, {
            lon: 43,
            lat: 39,
            value: 123
        }, {
            lon: 43,
            lat: 40,
            value: 134
        }, {
            lon: 43,
            lat: 41,
            value: 19
        }, {
            lon: 44,
            lat: 36,
            value: 35
        }, {
            lon: 44,
            lat: 37,
            value: 616
        }, {
            lon: 44,
            lat: 38,
            value: 2
        }, {
            lon: 44,
            lat: 39,
            value: 389
        }, {
            lon: 44,
            lat: 40,
            value: 30
        }]
    }]
});
