const eventsData = [{
    x: -11494347287000,

    name: 'The newspaper',
    custom: {
        location: 'Strasbourg',
        details: 'The first newspaper was invented by Johann Carolus. It ' +
            'was named <i>Relation aller Fürnemmen und gedenckwürdigen ' +
            'Historien</i> (Account of all distinguished and commemorable ' +
            'stories). The Relation is recognised by the World Association ' +
            'of Newspapers, as well as many authors, as the world\'s first ' +
            'newspaper.'
    }
}, {
    x: -11399592920000,
    name: 'Telescope',
    custom: {
        location: 'Netherlands',
        details: 'Patent applied for by Hans Lippershey. Actual inventor ' +
            'unknown since it seemed to already be a common item being ' +
            'offered by the spectacle makers in the Netherlands with Jacob ' +
            'Metius also applying for patent and the son of Zacharias ' +
            'Janssen making a claim 47 years later that his father invented it.'
    }

}, {
    x: -11020901720000,
    name: 'Compound microscopes',
    custom: {
        details: 'A combination of an objective lens with an eyepiece to ' +
            'view a real image, first appear in Europe. Apparently derived ' +
            'from the telescope, actual inventor unknown, variously ' +
            'attributed to Zacharias Janssen (his son claiming it was ' +
            'invented in 1590), Cornelis Drebbel, and Galileo Galilei.'
    }
}, {
    x: -10705368920000,
    name: 'Slide rule',
    custom: {
        location: 'England',
        details: 'Invented by William Oughtred.'
    }
}, {
    x: -10295141720000,
    name: 'Barometer',
    custom: {
        details: 'Invented by Evangelista Torricelli, or possibly up to ' +
            'three years earlier by Gasparo Berti. Although Evangelista ' +
            'Torricelli is universally credited with inventing the barometer ' +
            'in 1643, historical documentation also suggests Gasparo Berti, ' +
            'an Italian mathematician and astronomer, unintentionally built ' +
            'a water barometer sometime between 1640 and 1643. French ' +
            'scientist and philosopher René Descartes described the design ' +
            'of an experiment to determine atmospheric pressure as early as ' +
            '1631, but there is no evidence that he built a working ' +
            'barometer at that time.'
    }
}, {
    x: -10074216920000,
    name: 'Vacuum pump',
    custom: {
        details: 'A vacuum pump is a type of pump device that draws gas ' +
            'particles from a sealed volume in order to leave behind a ' +
            'partial vacuum. The first vacuum pump was invented in 1650 by ' +
            'Otto von Guericke, and was preceded by the suction pump, which ' +
            'dates to antiquity.'
    }
}, {
    x: -9884828120000,
    name: 'Pendulum clock',
    custom: {
        details: 'Invented by Christiaan Huygens. It was first ' +
            'conceptualized in 1637 by Galileo Galilei but he was unable to ' +
            'create a working model.'
    }
}, {
    x: -9663989720000,
    name: 'Friction machine',
    custom: {
        details: 'The first electrostatic generators are called friction ' +
            'machines because of the friction in the generation process. A ' +
            'primitive form of frictional machine was invented around 1663 ' +
            'by Otto von Guericke, using a sulphur globe that could be ' +
            'rotated and rubbed by hand'
    }
}, {
    x: -9159068120000,
    name: 'Pressure cooker',
    custom: {
        details: 'In 1679, French physicist Denis Papin, better known for ' +
        'his studies on steam, invented the steam digester in an attempt to ' +
        'reduce the cooking time of food. His airtight cooker used steam ' +
        'pressure to raise the water\'s boiling point, thus cooking food ' +
        'more quickly. In 1681 Papin presented his invention to the Royal ' +
        'Society of London as a scientific study; he was later elected as ' +
        'a member.'
    }
}, {
    x: -8212383320000,
    name: 'Piano',
    custom: {
        details: 'Invented by Bartolomeo Cristofori.'
    }
}, {
    x: -8117688920000,
    name: 'Steam engine',
    custom: {
        details: 'Thomas Newcomen builds the first commercial steam engine ' +
            'to pump water out of mines.'
    }
}, {
    x: -7455000920000,
    name: 'Flying shuttle',
    custom: {
        details: 'The flying shuttle is a type of weaving shuttle. It was a ' +
            'pivotal advancement in the mechanisation of weaving during the ' +
            'initial stages of the Industrial Revolution, and facilitated ' +
            'the weaving of considerably broader fabrics, enabling the ' +
            'production of wider textiles. Moreover, its mechanical ' +
            'implementation paved the way for the introduction of automatic ' +
            'machine looms. The brainchild of John Kay, the flying shuttle ' +
            'received a patent in the year 1733.'
    }
}, {
    x: -7171004120000,
    name: 'Franklin stove',
    custom: {
        details: 'The Franklin stove is a metal-lined fireplace named after ' +
        'Benjamin Franklin, who invented it in 1743. It had a hollow baffle ' +
        'near the rear (to transfer more heat from the fire to a room\'s ' +
        'air) and relied on an "inverted siphon" to draw the fire\'s hot ' +
        'fumes around the baffle. It was intended to produce more heat and ' +
        'less smoke than an ordinary open fireplace, but it achieved few ' +
        'sales until it was improved by David Rittenhouse. It is also known ' +
        'as a "circulating stove" or the "Pennsylvania fireplace". It is no ' +
        'longer used today.'
    }
}, {
    x: -6855384920000,
    name: 'Lightning rod',
    custom: {
        details: 'A lightning rod is a metal rod mounted on a structure and ' +
            'intended to protect the structure from a lightning strike. If ' +
            'lightning hits the structure, it will preferentially strike the ' +
            'rod and be conducted to ground through a wire, instead of ' +
            'passing through the structure. The principle of the lightning ' +
            'rod was first detailed by Benjamin Franklin in Pennsylvania in ' +
            '1755, who in subsequent years developed his invention for ' +
            'household application (published in 1757) and made further ' +
            'improvements towards a reliable system around 1760.'
    }
}, {
    x: -6602924120000,
    name: 'Roller skates',
    custom: {
        details: 'Invented by John Hoseph Merlin.'
    }
}, {
    x: -6318927320000,
    name: 'First steam-powered vehicle capable of carrying passengers',
    custom: {
        details: 'Invented by Nicolas-Joseph Cugnot. This invention is ' +
            'effectively the first automobile.'
    }
}, {
    x: -6161160920000,
    name: 'Boring mahcine',
    custom: {
        details: 'Invented by John Wilkinson, the boring mahcine is ' +
            'considered by some to be the first machine tool.'
    }
}, {
    x: -5877164120000,
    name: 'First manned hot air balloon',
    custom: {
        location: 'France',
        details: 'The French brothers Joseph-Michel and Jacques-Étienne ' +
            'Montgolfier developed a hot-air balloon in Annonay, Ardèche, ' +
            'France, and demonstrated it publicly on September 19, 1783, ' +
            'making an unmanned flight lasting 10 minutes. After ' +
            'experimenting with unmanned balloons and flights with animals, ' +
            'the first balloon flight with humans aboard, a tethered flight, ' +
            'performed on or around October 15, 1783, by Jean-Francois ' +
            'Pilatre de Rozier, who made at least one tethered flight from ' +
            'the yard of the Reveillon workshop in the Faubourg Saint-Antoine.'
    }
}, {
    x: -5498472920000,
    name: 'Hydraulic press',
    custom: {
        details: 'Invented by Joseph Bramah.'
    }
}, {
    x: -5214476120000,
    name: 'Steam locomotive',
    custom: {
        details: 'Richard Trevithick built the first steam locomotive known ' +
            'to have hauled a load over a distance at Pen-y-darren in 1804, ' +
            'although he produced an earlier locomotive for trial at ' +
            'Coalbrookdale in 1802.'
    }
}, {
    x: -5025173720000,
    name: 'Wrist watch',
    custom: {
        details: 'Invented by Abraham-Louis Breguet.'
    }
}, {
    x: -4646482520000,
    name: 'Heliography',
    custom: {
        details: 'The first photographic process, invented by Nicéphore Niépce.'
    }
}, {
    x: -4394021720000,
    name: 'Lawn Mower',
    custom: {
        details: 'Invented by Edwin Budding'
    }
}, {
    x: -4078402520000,
    name: 'Blueprint',
    custom: {
        details: 'Invented by John Herschel'
    }
}, {
    x: -3699711320000,
    name: 'Dirigable airship',
    custom: {
        details: 'Henri Giffard becomes the first person to make a manned, ' +
            'controlled and powered flight using a dirigible.'
    }
}, {
    x: -3226412120000,
    name: 'Dynamite',
    custom: {
        details: 'Alfred Nobel invents dynamite, the first safely manageable ' +
            'explosive stronger than black powder.'
    }
}, {
    x: -3068559320000,
    name: 'Stainless steel',
    custom: {
        details: 'J.E.T. Woods and J. Clark invented stainless steel. Harry ' +
            'Brearley was the first to commercialize it.'
    }
}, {
    x: -2942328920000,
    name: 'Telephone',
    custom: {
        details: 'Alexander Graham Bell was the first to be awarded a patent ' +
        'for the electric telephone by the United States Patent and ' +
        'Trademark Office (USPTO) in March 1876. Before Bell\'s patent, the ' +
        'telephone transmitted sound in a way that was similar to the ' +
        'telegraph. This method used vibrations and circuits to send ' +
        'electrical pulses, but was missing key features. Bell found that ' +
        'this method produced a sound through intermittent currents, but in ' +
        'order for the telephone to work a fluctuating current reproduced ' +
        'sounds the best. The fluctuating currents became the basis for the ' +
        'working telephone, creating Bell\'s patent. That first patent by ' +
        'Bell was the master patent of the telephone, from which other ' +
        'patents for electric telephone devices and features flowed.'
    }
}, {
    x: -2847720920000,
    name: 'Incandescent light bulb',
    custom: {
        details: 'Joseph Swan and Thomas Edison both patent a functional ' +
        'incandescent light bulb. Some two dozen inventors had experimented ' +
        'with electric incandescent lighting over the first three-quarters ' +
        'of the 19th century but never came up with a practical design. ' +
        'Swan\'s, which he had been working on since the 1860s, had a low ' +
        'resistance so was only suited for small installations. Edison ' +
        'designed a high-resistance bulb as part of a large-scale commercial ' +
        'electric lighting utility.'
    }
}, {
    x: -2784562520000,
    name: 'Carbon arc welding',
    custom: {
        details: 'Nikolay Benardos presents carbon arc welding, the first ' +
            'practical arc welding method. Carbon arc welding (CAW) is a ' +
            'process which produces coalescence of metals by heating them ' +
            'with an arc between a non-consumable carbon (graphite) ' +
            'electrode and the work-piece. It was the first arc-welding ' +
            'process developed but is not used for many applications today, ' +
            'having been replaced by twin-carbon-arc welding and other ' +
            'variations. The purpose of arc welding is to form a bond ' +
            'between separate metal pieces. In carbon-arc welding a carbon ' +
            'electrode is used to produce an electric arc between the ' +
            'electrode and the materials being bonded. This arc produces ' +
            'temperatures in excess of 3,000 °C. At this temperature the ' +
            'separate metals form a bond and become welded together.'
    }
}, {
    x: -2626796120000,
    name: 'Zinc–carbon battery',
    custom: {
        details: 'Carl Gassner invents the zinc–carbon battery, the first ' +
            'dry cell battery, making portable electronics practical.'
    }
}, {
    x: -2500565720000,
    name: 'Pre-cut cardboard box',
    custom: {
        details: 'The Scottish-born Robert Gair invented the pre-cut ' +
        'cardboard or paperboard box in 1890 – flat pieces manufactured in ' +
        'bulk that folded into boxes. Gair\'s invention came about as a ' +
        'result of an accident: he was a Brooklyn printer and paper-bag ' +
        'maker during the 1870s, and one day, while he was printing an ' +
        'order of seed bags, a metal ruler normally used to crease bags ' +
        'shifted in position and cut them. Gair discovered that by cutting ' +
        'and creasing in one operation he could make prefabricated ' +
        'paperboard boxes. Applying this idea to corrugated boxboard was ' +
        'a straightforward development when the material became available ' +
        'around the turn of the twentieth century.'
    }
}, {
    x: -2405500330000,
    name: 'Diesel Engine',
    custom: {
        details: 'Rudolf Diesel invents the diesel engine (although Herbert ' +
            'Akroyd Stuart had experimented with compression ignition before ' +
            'Diesel).'
    }
}, {
    x: -2090053930000,
    name: 'First successful powered airplane',
    custom: {
        details: 'First sustained and controlled heavier-than-air powered ' +
            'flight achieved by an airplane flown at Kitty Hawk, North ' +
            'Carolina by Orville and Wilbur Wright.'
    }
}, {
    x: -1774434730000,
    name: 'Karplan turbine',
    custom: {
        details: 'The Kaplan turbine is a propeller-type water turbine which ' +
            'has adjustable blades. It was developed in 1913 by Austrian ' +
            'professor Viktor Kaplan, who combined automatically adjusted ' +
            'propeller blades with automatically adjusted wicket gates to ' +
            'achieve efficiency over a wide range of flow and water level.'
    }
}, {
    x: -1301049130000,
    name: 'Turbo-jet engine',
    custom: {
        details: 'Frank Whittle formally submitted his ideas for a turbo-jet ' +
            'engine. In October 1929, he developed his ideas further. On 16 ' +
            'January 1930, Whittle submitted his first patent (granted in ' +
            '1932).'
    }
}, {
    x: -1080210730000,
    name: 'Nylon',
    custom: {
        details: 'The first fully synthetic fiber is produced by Wallace ' +
            'Carothers while working at DuPont.'
    }
}, {
    x: -922357930000,
    name: 'Cavity magnetron',
    custom: {
        details: 'John Randall and Harry Boot would develop the high power, ' +
            'microwave generating, cavity magnetron, later applied to ' +
            'commercial Radar and Microwave oven appliances.'
    }
}, {
    x: -733055530000,
    name: 'Ejector seat',
    custom: {
        details: 'James Martin invents the ejector seat, inspired by the ' +
            'death of his friend and test pilot Captain Valentine Baker in ' +
            'an aeroplane crash in 1942.'
    }
}, {
    x: -606825130000,
    name: 'Video game',
    custom: {
        details: 'Bertie the Brain is one of the first games developed in ' +
            'the early history of video games. It was built in Toronto by ' +
            'Josef Kates for the 1950 Canadian National Exhibition. The four ' +
            'meter (13 foot) tall computer allowed exhibition attendees to ' +
            'play a game of tic-tac-toe against an artificial intelligence.'
    }
}, {
    x: -417436330000,
    name: 'Hard disk drive',
    custom: {
        details: 'The first production IBM hard disk drive, the 350 disk ' +
            'storage, shipped in 1957 as a component of the IBM 305 RAMAC ' +
            'system. It was approximately the size of two large ' +
            'refrigerators and stored five million six-bit characters (3.75 ' +
            'megabytes) on a stack of 52 disks (100 surfaces used). The 350 ' +
            'had a single arm with two read/write heads, one facing up and ' +
            'the other down, that moved both horizontally between a pair of ' +
            'adjacent platters and vertically from one pair of platters to a ' +
            'second set. Variants of the IBM 350 were the IBM 355, IBM 7300 ' +
            'and IBM 1405.'
    }
}, {
    x: -164975530000,
    name: 'Shinkansen',
    custom: {
        location: 'Japan',
        details: 'The first high-speed rail commercial passenger service. ' +
            'Among the key people credited with the construction of the ' +
            'first Shinkansen are Hideo Shima, the Chief Engineer, and ' +
            'Shinji Sogō, the first President of Japanese National Railways ' +
            '(JNR) who managed to persuade politicians to back the plan. ' +
            'Other significant people responsible for its technical ' +
            'development were Tadanao Miki, Tadashi Matsudaira, and Hajime ' +
            'Kawanabe based at the Railway Technical Research Institute ' +
            '(RTRI), part of JNR. They were responsible for much of the ' +
            'technical development of the first line, the Tōkaidō ' +
            'Shinkansen. All three had worked on aircraft design during ' +
            'World War II.'
    }
}, {
    x: 119021270000,
    name: 'Graphical user interface (GUI)',
    custom: {
        details: 'The first commercial graphical user interface is ' +
            'introduced in 1973 on the Xerox Alto. The modern GUI is later ' +
            'popularized by the Xerox Star and Apple Lisa.'
    }
}, {
    x: 339946070000,
    name: 'Flash memory',
    custom: {
        details: 'Flash memory (both NOR and NAND types) is invented by ' +
            'Fujio Masuoka while working for Toshiba. It is formally ' +
            'introduced to the public in 1984.'
    }
}, {
    x: 623942870000,
    name: 'World Wide Web',
    custom: {
        details: 'The Web was invented by English computer scientist Tim ' +
            'Berners-Lee while working at CERN. He was motivated by the ' +
            'problem of storing, updating, and finding documents and data ' +
            'files in that large and constantly changing organization, as ' +
            'well as distributing them to collaborators outside CERN.'
    }
}, {
    x: 813245270000,
    name: 'DVD',
    custom: {
        details: 'DVD is an optical disc storage format, invented and ' +
            'developed by Philips, Sony, Toshiba, and Panasonic in 1995. ' +
            'DVDs offer higher storage capacity than compact discs while ' +
            'having the same dimensions.'
    }
}, {
    x: 971098070000,
    name: 'Geocaching',
    custom: {
        location: 'Oregon',
        details: 'First documented placement of Geocaching, an outdoor ' +
            'recreational activity, in which participants use a Global ' +
            'Positioning System (GPS) receiver or mobile device and other ' +
            'navigational techniques to hide and seek containers, took place ' +
            'on May 3, 2000, by Dave Ulmer of Beavercreek, Oregon.'
    }
}, {
    x: 1255094870000,
    labelrank: 100,
    name: 'Highcharts',
    custom: {
        location: 'Vik i Sogn',
        details: 'Highcharts started as Torstein’s humble quest for a simple ' +
            'charting tool for updating his homepage with snow depth ' +
            'measurements from Vikjafjellet, the local mountain where his ' +
            'family keeps a cabin. Frustrated with the common flash plug-ins,' +
            ' and other proprietary solutions at the time, he decided to ' +
            'build a standards-based solution of his own, and share it with ' +
            'the world. It turns out he was doing more than scratching his ' +
            'itch. Since its launch in 2009, Highcharts has remained the ' +
            'secure choice for cutting-edge charting tools in a highly ' +
            'competitive data visualization market. Later in 2011, the first ' +
            'version og Highcharts Stock was released.'
    }
}, {
    x: 1476019670000,
    name: 'Laser Interferometer Gravitational-Wave Observatory',
    custom: {
        details: 'The Laser Interferometer Gravitational-Wave Observatory ' +
            'makes the first observation of gravitational waves, fulfilling ' +
            'Einstein\'s prediction.'
    }
}, {
    x: 1602250070000,
    name: 'Artificial intelligence-assisted coding',
    custom: {
        details: ''
    }
}];

Highcharts.stockChart('container', {
    chart: {
        inverted: true,
        zooming: {
            mouseWheel: {
                enabled: false
            }
        }
    },
    title: {
        text: 'List of historic inventions',
        align: 'left'
    },
    subtitle: {
        text: 'Source: <a href="https://en.wikipedia.org/wiki/Timeline_of_historic_inventions" >Wikipedia</a>',
        align: 'left'
    },
    rangeSelector: {
        buttons: [{
            type: 'year',
            count: 30,
            text: '30y'
        }, {
            type: 'year',
            count: 100,
            text: '100y'
        }]
    },
    navigator: {
        opposite: true,
        xAxis: {
            reversed: false,
            tickPixelInterval: 50
        }
    },
    xAxis: {
        visible: false,
        ordinal: false,
        min: '1900-01-01',
        reversed: false
    },
    yAxis: {
        visible: false,
        min: 0,
        max: 2
    },
    tooltip: {
        style: {
            width: '300px'
        },
        headerFormat: '<b>{point.key}</b><br>',
        pointFormat:
            'Year: {point.x:%Y}<br>' +
            '{#if point.custom.location}' +
                'Location: {point.custom.location}<br>{/if}' +
            '{point.custom.details}'
    },
    series: [{
        type: 'timeline',
        pointStart: '1600-01-01',
        pointIntervalUnit: 'year',
        marker: {
            enabled: true,
            radius: 4,
            symbol: 'circle'
        },
        data: eventsData,
        dataLabels: {
            format: '<b>{x:%Y}: {point.name}</b>'
        }
    }]
}, function (chart) {

    // Add mousewheel support:
    Highcharts.addEvent(
        chart.container,
        document.onmousewheel === undefined ? 'DOMMouseScroll' : 'mousewheel',
        function (event) {
            let range, delta, extr, step, newMin, newMax,
                prevent = true;
            const axis = chart.xAxis[0];
            const e = chart.pointer.normalize(event);
            // Firefox uses e.detail, WebKit and IE uses deltaY
            delta = e.detail || (e.deltaY / 120);
            delta = delta < 0 ?
                (axis.reversed ? -1 : 1) :
                (axis.reversed ? 1 : -1);

            if (chart.isInsidePlot(
                e.chartX - chart.plotLeft, e.chartY - chart.plotTop
            )) {
                extr = axis.getExtremes();
                range = (extr.max - extr.min);
                step = range * delta / 15;

                newMin = extr.min + step;
                newMax = extr.max + step;

                if (newMax > extr.dataMax) {
                    newMax = extr.dataMax;
                    newMin = newMax - range;
                    prevent = false;
                }
                if (newMin < extr.dataMin) {
                    newMin = extr.dataMin;
                    newMax = newMin + range;
                    prevent = false;
                }

                axis.setExtremes(newMin, newMax, true, false);

                if (prevent) {
                    if (e) {
                        if (e.preventDefault) {
                            e.preventDefault();
                        }
                        if (e.stopPropagation) {
                            e.stopPropagation();
                        }
                        e.cancelBubble = true;
                    }
                }
            }
        }
    );
});