(async () => {

    // Load the dataset
    const data = await fetch(
        'https://demo-live-data.highcharts.com/aapl-ohlcv.json'
    ).then(response => response.json());

    // split the data set into ohlc and volume
    const ohlc = [],
        volume = [],
        dataLength = data.length;

    for (let i = 0; i < dataLength; i += 1) {
        ohlc.push([
            data[i][0], // the date
            data[i][1], // open
            data[i][2], // high
            data[i][3], // low
            data[i][4] // close
        ]);

        volume.push([
            data[i][0], // the date
            data[i][5] // the volume
        ]);
    }

    Highcharts.stockChart('container', {

        rangeSelector: {
            selected: 1
        },

        title: {
            text: 'AAPL Stock Price'
        },

        legend: {
            enabled: true
        },

        plotOptions: {
            series: {
                showInLegend: true
            }
        },

        yAxis: [{
            height: '30%'
        }, {
            top: '40%',
            height: '20%'
        }, {
            top: '80%',
            height: '20%'
        }],

        series: [{
            type: 'ohlc',
            id: 'aapl',
            name: 'AAPL Stock Price',
            data: ohlc
        }, {
            data: volume,
            yAxis: 1,
            name: 'Volume',
            id: 'volumeSeries',
            type: 'column'
        }, {
            type: 'chaikin',
            linkedTo: 'aapl',
            yAxis: 2,
            params: {
                volumeSeriesID: 'volumeSeries'
            }
        }]
    });
})();