function getLinearRegression(xData, yData) {
    let sumX = 0,
        sumY = 0,
        sumXY = 0,
        sumX2 = 0,
        x,
        y;

    const linearData = [],
        linearXData = [],
        linearYData = [],
        n = xData.length;

    // Get sums:
    for (let i = 0; i < n; i++) {
        x = xData[i];
        y = yData[i];
        sumX += x;
        sumY += y;
        sumXY += x * y;
        sumX2 += x * x;
    }

    // Get slope and offset:
    let alpha = (n * sumXY - sumX * sumY) / (n * sumX2 - sumX * sumX);

    if (isNaN(alpha)) {
        alpha = 0;
    }

    const beta = (sumY - alpha * sumX) / n;

    // Calculate linear regression:
    for (let i = 0; i < n; i++) {
        x = xData[i];
        y = alpha * x + beta;

        // Prepare arrays required for getValues() method
        linearData[i] = [x, y];
        linearXData[i] = x;
        linearYData[i] = y;
    }

    return {
        xData: linearXData,
        yData: linearYData,
        values: linearData
    };
}

Highcharts.seriesType(
    'linearregression',
    'sma', {
        name: 'Linear Regression',
        enableMouseTracking: false,
        marker: {
            enabled: false
        },
        params: {} // linear regression doesn’t need params
    }, {
        getValues: function (series) {
            return this.getLinearRegression(series.xData, series.yData);
        },
        getLinearRegression: getLinearRegression
    }
);

Highcharts.chart('container', {
    chart: {
        type: 'scatter',
        zooming: {
            type: 'xy'
        }
    },
    title: {
        text: 'Height Versus Weight of 507 Individuals by Gender'
    },
    subtitle: {
        text: 'Source: Heinz  2003'
    },
    xAxis: {
        title: {
            enabled: true,
            text: 'Height (cm)'
        },
        startOnTick: true,
        endOnTick: true,
        showLastLabel: true
    },
    yAxis: {
        title: {
            text: 'Weight (kg)'
        }
    },
    legend: {
        layout: 'vertical',
        align: 'left',
        verticalAlign: 'top',
        x: 100,
        y: 70,
        floating: true,
        backgroundColor: '#FFFFFF',
        borderWidth: 1
    },
    plotOptions: {
        scatter: {
            marker: {
                radius: 5,
                states: {
                    hover: {
                        enabled: true,
                        lineColor: 'rgb(100,100,100)'
                    }
                }
            },
            states: {
                hover: {
                    marker: {
                        enabled: false
                    }
                }
            },
            tooltip: {
                headerFormat: '<b>{series.name}</b><br>',
                pointFormat: '{point.x} cm, {point.y} kg'
            }
        }
    },
    series: [{
        name: 'Female',
        id: 'female',
        color: 'rgba(223, 83, 83, .5)',
        data: [
            [147.2, 49.8],
            [149.5, 44.8],
            [149.9, 46.8],
            [151.1, 48.7],
            [151.1, 73.2],
            [152, 45.8],
            [152, 59.3],
            [152.4, 47.3],
            [152.4, 46.5],
            [152.4, 60.4],
            [152.4, 67.3],
            [153.4, 42],
            [154.4, 46.2],
            [154.5, 49],
            [154.9, 58.2],
            [154.9, 54.1],
            [155, 45.9],
            [155, 49.2],
            [155.8, 53.6],
            [156, 52.7],
            [156, 54.6],
            [156, 64.4],
            [156.2, 58.6],
            [156.2, 60],
            [156.5, 67.2],
            [157, 63],
            [157, 47.8],
            [157.5, 76.8],
            [157.5, 56],
            [157.5, 54.3],
            [157.5, 63.6],
            [157.5, 58.8],
            [157.5, 48.6],
            [157.5, 54.5],
            [157.5, 59.8],
            [158, 55.5],
            [158.2, 46.4],
            [158.8, 55.5],
            [158.8, 49.1],
            [159, 55.6],
            [159, 48.6],
            [159.1, 47.6],
            [159.2, 51.8],
            [159.4, 45.7],
            [159.4, 53.2],
            [159.5, 47.6],
            [159.5, 49.2],
            [159.5, 50.6],
            [159.8, 50],
            [159.8, 53.2],
            [160, 50],
            [160, 53.4],
            [160, 45],
            [160, 60],
            [160, 80.5],
            [160, 50.2],
            [160, 59],
            [160, 55.4],
            [160, 74.3],
            [160, 55.9],
            [160, 43.2],
            [160, 50.2],
            [160, 48.8],
            [160, 59.5],
            [160, 64.1],
            [160, 75.5],
            [160, 47],
            [160, 54.4],
            [160, 55.9],
            [160, 54.8],
            [160.2, 52.1],
            [160.2, 75.2],
            [160.7, 69.1],
            [160.7, 48.6],
            [160.7, 55.9],
            [160.9, 54.4],
            [161, 80],
            [161, 53.6],
            [161.2, 51.6],
            [161.2, 54.8],
            [161.2, 55.2],
            [161.3, 63.6],
            [161.3, 70.5],
            [161.3, 57.3],
            [161.3, 60.3],
            [161.3, 60.9],
            [161.3, 67.9],
            [161.3, 60.2],
            [161.4, 63.4],
            [162, 55],
            [162, 54.7],
            [162.1, 53.6],
            [162.1, 59.2],
            [162.2, 50.2],
            [162.5, 52.2],
            [162.5, 58.2],
            [162.6, 81.8],
            [162.6, 63.2],
            [162.6, 66.4],
            [162.6, 50],
            [162.6, 63.6],
            [162.6, 84.5],
            [162.6, 61.4],
            [162.6, 61.4],
            [162.6, 58.6],
            [162.6, 54.5],
            [162.6, 61.4],
            [162.6, 53.9],
            [162.6, 54.5],
            [162.6, 70.5],
            [162.8, 57.8],
            [162.8, 58],
            [162.9, 59.4],
            [163, 62],
            [163, 72],
            [163.2, 55.9],
            [163.2, 54],
            [163.2, 59.8],
            [163.2, 56.4],
            [163.5, 51.8],
            [163.5, 50],
            [163.8, 67.3],
            [163.8, 58.6],
            [163.8, 58.5],
            [164, 55.7],
            [164, 53.8],
            [164.1, 71.6],
            [164.3, 59.8],
            [164.4, 55.5],
            [164.5, 60.3],
            [164.5, 52.3],
            [164.5, 63.2],
            [165, 62],
            [165.1, 80.9],
            [165.1, 65.5],
            [165.1, 59.1],
            [165.1, 60.9],
            [165.1, 56.2],
            [165.1, 56.8],
            [165.1, 86.3],
            [165.1, 104.1],
            [165.1, 62.7],
            [165.1, 53.6],
            [165.1, 55.2],
            [165.1, 64.1],
            [165.1, 72.3],
            [165.1, 58.2],
            [165.5, 60],
            [165.7, 73.1],
            [166, 53.2],
            [166, 69.8],
            [166.2, 58.6],
            [166.4, 56.6],
            [166.4, 70.7],
            [166.4, 55],
            [166.8, 57.2],
            [166.8, 56.6],
            [167, 59.8],
            [167.1, 62.2],
            [167.5, 59],
            [167.6, 62.7],
            [167.6, 68.8],
            [167.6, 76.4],
            [167.6, 54.5],
            [167.6, 65.9],
            [167.6, 54.5],
            [167.6, 63.6],
            [167.6, 64.5],
            [167.6, 61],
            [167.6, 57.8],
            [167.6, 63],
            [167.6, 52.7],
            [167.6, 58.3],
            [167.6, 55.7],
            [167.6, 61.4],
            [167.6, 55],
            [167.6, 72.3],
            [167.8, 59],
            [168.2, 53.4],
            [168.2, 49.2],
            [168.3, 54.8],
            [168.5, 65.2],
            [168.9, 62],
            [168.9, 56.8],
            [168.9, 60.5],
            [168.9, 56.6],
            [168.9, 55],
            [168.9, 62.3],
            [168.9, 69],
            [168.9, 63],
            [169, 62.5],
            [169, 58.2],
            [169.4, 63.4],
            [169.5, 52.8],
            [169.5, 67.3],
            [169.5, 57.3],
            [170, 72.9],
            [170, 59],
            [170, 69.4],
            [170, 55.9],
            [170, 70.6],
            [170, 73.2],
            [170.2, 72.8],
            [170.2, 55.9],
            [170.2, 69.1],
            [170.2, 77.3],
            [170.2, 55],
            [170.2, 67.7],
            [170.2, 73.6],
            [170.2, 59.1],
            [170.2, 54.5],
            [170.2, 63.6],
            [170.3, 64.8],
            [170.5, 64.5],
            [170.5, 67.8],
            [170.9, 54.2],
            [171.4, 53.4],
            [171.8, 56.2],
            [172.1, 56.6],
            [172.5, 55.2],
            [172.7, 69.5],
            [172.7, 68.2],
            [172.7, 70.5],
            [172.7, 61.1],
            [172.7, 62],
            [172.7, 105.2],
            [172.7, 75.9],
            [172.9, 62.5],
            [173, 59.8],
            [173.2, 69.2],
            [173.2, 58.4],
            [173.4, 52.7],
            [174, 75.7],
            [174, 54.5],
            [174, 55.5],
            [174, 55.5],
            [174, 66.4],
            [174, 73.6],
            [175, 82.5],
            [175, 73.2],
            [175.2, 66.8],
            [175.2, 62.3],
            [175.2, 57.7],
            [175.3, 63.6],
            [175.3, 63.6],
            [175.3, 63.6],
            [175.3, 72.7],
            [175.3, 65.5],
            [176.2, 67.2],
            [176.2, 66.8],
            [176.5, 87.8],
            [176.5, 73.6],
            [176.5, 83],
            [176.5, 71.8],
            [177.8, 60],
            [178, 70.6],
            [179.8, 66.8],
            [179.9, 67.3],
            [180.3, 60.7],
            [182.9, 81.8]
        ]
    }, {
        name: 'Male',
        id: 'male',
        color: 'rgba(119, 152, 191, .5)',
        data: [
            [157.2, 58.4],
            [160, 72.3],
            [163, 57],
            [163.8, 72.2],
            [164.1, 55.2],
            [164.5, 70],
            [164.5, 63.2],
            [165.1, 65],
            [165.1, 70.5],
            [165.1, 65],
            [165.1, 66.4],
            [166.4, 85.9],
            [166.4, 75],
            [167, 64.6],
            [167, 68.2],
            [167, 59.1],
            [167.4, 67.7],
            [167.4, 53.9],
            [167.6, 72.3],
            [167.6, 82.7],
            [167.6, 64.5],
            [167.6, 84.5],
            [167.6, 68.6],
            [167.6, 75.5],
            [167.6, 76.3],
            [167.6, 69.1],
            [167.6, 66.8],
            [167.6, 74.1],
            [168.9, 69.1],
            [168.9, 75],
            [168.9, 55.5],
            [169.4, 65.9],
            [169.5, 75.6],
            [170, 59.5],
            [170, 61.3],
            [170.2, 77.3],
            [170.2, 72.7],
            [170.2, 65.9],
            [170.2, 85.5],
            [170.2, 69.1],
            [170.2, 62.3],
            [170.5, 67.7],
            [170.5, 56.8],
            [170.8, 93.2],
            [171.2, 79.1],
            [171.4, 84.7],
            [171.4, 70],
            [171.4, 72.7],
            [171.4, 91.4],
            [171.5, 61.4],
            [171.5, 70],
            [171.8, 66.1],
            [172.1, 74.9],
            [172.7, 72.3],
            [172.7, 73.4],
            [172.7, 66.2],
            [172.7, 75.3],
            [172.7, 90.9],
            [172.7, 84.1],
            [172.7, 95.9],
            [172.7, 76.8],
            [172.8, 69.1],
            [173, 60.9],
            [173, 72.4],
            [173.5, 81.8],
            [174, 86.8],
            [174, 72.2],
            [174, 70.9],
            [174, 82.5],
            [174, 65.6],
            [174, 71],
            [174, 88.6],
            [174, 80],
            [174, 73.9],
            [174, 86.2],
            [174, 73.4],
            [174.5, 63.9],
            [175, 70.2],
            [175, 62],
            [175.3, 84.1],
            [175.3, 90.9],
            [175.3, 87.7],
            [175.3, 70.9],
            [175.3, 69.1],
            [175.3, 73.6],
            [175.3, 67.7],
            [175.3, 72.1],
            [175.3, 91.1],
            [175.3, 71.8],
            [175.3, 67.3],
            [175.3, 81.8],
            [175.3, 64.5],
            [175.3, 71.8],
            [175.3, 86.4],
            [175.5, 80.9],
            [175.5, 63.2],
            [175.5, 70.9],
            [175.5, 70],
            [175.9, 77.7],
            [176, 78.8],
            [176, 74.6],
            [176, 85.9],
            [176, 86.4],
            [176.5, 80.2],
            [176.5, 73],
            [176.5, 82.3],
            [176.5, 73.6],
            [176.5, 85],
            [176.5, 87.9],
            [176.5, 68.4],
            [177, 72.5],
            [177, 68.2],
            [177, 71.6],
            [177, 68.9],
            [177.1, 83.4],
            [177.2, 94.1],
            [177.3, 73.2],
            [177.5, 72],
            [177.8, 74.8],
            [177.8, 58],
            [177.8, 79.5],
            [177.8, 78.6],
            [177.8, 71.8],
            [177.8, 116.4],
            [177.8, 83.6],
            [177.8, 84.1],
            [177.8, 80.9],
            [177.8, 80.5],
            [177.8, 102.5],
            [177.8, 63.6],
            [177.8, 64.1],
            [177.8, 77.7],
            [177.8, 93.6],
            [177.8, 81.8],
            [177.8, 68.6],
            [177.8, 96.8],
            [177.8, 81.8],
            [177.8, 61.4],
            [177.8, 76.6],
            [177.8, 75.5],
            [177.8, 72],
            [177.8, 86.4],
            [177.8, 82.7],
            [177.8, 87.7],
            [178, 89.6],
            [178.1, 72],
            [179.1, 89.1],
            [179.1, 92.7],
            [179.1, 75.5],
            [179.1, 87.3],
            [179.1, 79.1],
            [179.1, 71.8],
            [179.7, 86.4],
            [179.8, 84.5],
            [180, 76.6],
            [180.1, 93],
            [180.3, 83.2],
            [180.3, 73.6],
            [180.3, 77.7],
            [180.3, 83.2],
            [180.3, 85.5],
            [180.3, 88.6],
            [180.3, 82.6],
            [180.3, 82.7],
            [180.3, 71.4],
            [180.3, 82.8],
            [180.3, 93.2],
            [180.3, 75.5],
            [180.3, 83.2],
            [180.3, 73.2],
            [180.3, 76.4],
            [180.5, 77.8],
            [180.6, 72.5],
            [180.6, 72.7],
            [181.1, 66],
            [181.5, 74.8],
            [181.6, 75.5],
            [181.6, 70.5],
            [181.6, 84.5],
            [181.6, 78.9],
            [182, 67.2],
            [182, 72],
            [182.1, 75.7],
            [182.2, 87.1],
            [182.4, 74.5],
            [182.9, 85],
            [182.9, 75],
            [182.9, 80.9],
            [182.9, 87.3],
            [182.9, 89.1],
            [182.9, 88.7],
            [182.9, 79.5],
            [183, 65.9],
            [183, 90.9],
            [183.5, 74.8],
            [184, 79.6],
            [184, 81.6],
            [184, 86.4],
            [184.2, 77.3],
            [184.2, 94.5],
            [184.2, 80.1],
            [184.2, 76.8],
            [184.4, 68],
            [184.5, 78.4],
            [184.9, 86.4],
            [185.4, 66.8],
            [185.4, 102.3],
            [185.4, 94.1],
            [185.4, 83.6],
            [185.4, 76.4],
            [185.4, 81.8],
            [185.4, 84.1],
            [186, 84.8],
            [186.5, 72.6],
            [186.7, 101.4],
            [186.7, 91.8],
            [186.7, 87.8],
            [186.7, 86.4],
            [187.2, 78.8],
            [188, 87.3],
            [188, 85.9],
            [188, 84.1],
            [188, 91.4],
            [188, 90.5],
            [188, 84.1],
            [188, 94.3],
            [188, 83.6],
            [188, 85.9],
            [188, 80.5],
            [188, 72.4],
            [188, 93.2],
            [188, 82.7],
            [189.2, 84.1],
            [190.5, 84.1],
            [190.5, 108.6],
            [190.5, 80.9],
            [190.5, 98.2],
            [190.5, 89.1],
            [190.5, 73.6],
            [192, 102.3],
            [192, 101.6],
            [192, 90],
            [192.7, 93.8],
            [193, 95.9],
            [193.5, 80.7],
            [197.1, 90.9],
            [198.1, 85.5]
        ]
    }, {
        type: 'linearregression',
        linkedTo: 'female',
        name: 'Female - linear regression',
        color: 'rgba(223, 83, 83, .75)',
        showInLegend: true
    }, {
        type: 'linearregression',
        name: 'Male - linear regression',
        color: 'rgba(119, 152, 191, .75)',
        linkedTo: 'male',
        showInLegend: true
    }]
});
