(async () => {

    // Load the dataset
    const data = await fetch(
        'https://demo-live-data.highcharts.com/aapl-ohlcv.json'
    ).then(response => response.json());

    // split the data set into ohlc and volume
    const ohlc = [],
        volume = [],
        dataLength = data.length;

    for (let i = 0; i < dataLength; i += 1) {
        ohlc.push([
            data[i][0], // the date
            data[i][1], // open
            data[i][2], // high
            data[i][3], // low
            data[i][4] // close
        ]);

        volume.push([
            data[i][0], // the date
            data[i][5] // the volume
        ]);
    }

    Highcharts.stockChart('container', {

        rangeSelector: {
            selected: 2
        },

        title: {
            text: 'AAPL Stock Price'
        },

        legend: {
            enabled: true
        },

        plotOptions: {
            series: {
                showInLegend: true
            }
        },

        series: [{
            type: 'ohlc',
            id: 'aapl',
            name: 'AAPL Stock Price',
            data: ohlc
        }, {
            type: 'ikh',
            linkedTo: 'aapl',
            tenkanLine: {
                styles: {
                    lineColor: 'lightblue'
                }
            },
            kijunLine: {
                styles: {
                    lineColor: 'darkred'
                }
            },
            chikouLine: {
                styles: {
                    lineColor: 'lightgreen'
                }
            },
            senkouSpanA: {
                styles: {
                    lineColor: 'green'
                }
            },
            senkouSpanB: {
                styles: {
                    lineColor: 'red'
                }
            },
            senkouSpan: {
                color: 'rgba(0, 255, 0, 0.3)',
                negativeColor: 'rgba(255, 0, 0, 0.3)',
                styles: {
                    fill: 'rgba(0, 0, 255, 0.1)'
                }
            }
        }]
    });
})();