const eventsData = [{
    x: -7889270400000,
    y: 1,
    lbl: 'The Mississippi Bubble',
    causes: 'Banque Royale by John Law stopped payments of its note in ' +
        'exchange for specie and as result caused economic collapse in France.',
    country: 'Kingdom of France'
}, {
    x: -7889270400000,
    y: 1,
    lbl: 'South Sea Bubble of 1720',
    causes: 'Affected early European stock markets, during early days of ' +
        'chartered joint stock companies',
    country: 'United Kingdom'
}, {
    x: -6342883200000,
    y: 1,
    lbl: 'Bengal Bubble of 1769',
    causes: 'Primarily caused by the British East India Company, whose ' +
        'shares fell from £276 in December 1768 to £122 in 1784',
    country: 'United Kingdom'
}, {
    x: -6248275200000,
    y: 1,
    lbl: 'Credit crisis of 1772',
    causes: '',
    country: 'United Kingdom'
}, {
    x: -5648659200000,
    y: 1,
    lbl: 'Financial Crisis of 1791-92',
    causes:
        'Shares of First bank of US boom and bust in Aug and Sept 1791. ' +
        'Groundwork of Alexander Hamilton\'s cooperation with the Bank of ' +
        'New York to end this event would be crucial in ending the Panic of ' +
        '1792 next year.',
    country: 'United States'
}, {
    x: -5490892800000,
    y: 1,
    lbl: 'Panic of 1796–97',
    causes: '',
    country: 'United Kingdom'
}, {
    x: -4765132800000,
    y: 1,
    lbl: 'Panic of 1819',
    causes: '',
    country: 'United States'
}, {
    x: -4575744000000,
    y: 1,
    lbl: 'Panic of 1825',
    causes: '',
    country: 'United Kingdom'
}, {
    x: -4185914400000,
    y: 1,
    lbl: 'Panic of 1837',
    causes: '',
    country: 'United States'
}, {
    x: -3881520000000,
    y: 1,
    lbl: 'Panic of 1847',
    causes: '',
    country: 'United Kingdom'
}, {
    x: -3565900800000,
    y: 1,
    lbl: 'Panic of 1857',
    causes: '',
    country: 'United States'
}, {
    x: -3281904000000,
    y: 1,
    lbl: 'Panic of 1866',
    causes: '',
    country: 'United Kingdom'
}, {
    x: -3164234400000,
    y: 1,
    lbl: 'Black Friday',
    causes: '',
    country: 'United States'
}, {
    x: -3049927200000,
    y: 1,
    lbl: 'Panic of 1873',
    causes: 'Initiated the Long Depression in the United States and much of ' +
        'Europe'
}, {
    x: -2775430800000,
    y: 1,
    lbl: 'Paris Bourse crash of 1882',
    causes: '',
    country: 'France'
}, {
    x: -2713910400000,
    y: 1,
    lbl: 'Panic of 1884',
    causes: ''
}, {
    x: -2524521600000,
    y: 1,
    lbl: 'Encilhamento',
    causes: 'Lasting 3 years, 1890-1893, a boom and bust process that boomed ' +
        'in late 1880s and burst on early 1890s, causing a collapse in the ' +
        'Brazilian economy and aggravating an already unstable political ' +
        'situation.',
    country: 'Brazil'
}, {
    x: -2429827200000,
    y: 1,
    lbl: 'Panic of 1893',
    causes: '',
    country: 'United States'
}, {
    x: -2335219200000,
    y: 1,
    lbl: 'Panic of 1896',
    causes: '',
    country: 'United States'
}, {
    x: -2165709600000,
    y: 1,
    lbl: 'Panic of 1901',
    causes: 'Lasting 3 years, the market was spooked by the assassination of ' +
        'President McKinley in 1901, coupled with a severe drought later the ' +
        'same year.',
    country: 'United States'
}, {
    x: -1964570400000,
    y: 1,
    lbl: 'Panic of 1907',
    causes: 'Lasting over a year, markets took fright after U.S. President ' +
        'Theodore Roosevelt had threatened to rein in the monopolies that ' +
        'flourished in various industrial sectors, notably railways.',
    country: 'United States'
}, {
    x: -1268272800000,
    y: 1,
    lbl: 'Wall Street Crash of 1929',
    causes: 'Lasting over 4 years, the bursting of the speculative bubble in ' +
        'shares led to further selling as people who had borrowed money to ' +
        'buy shares had to cash them in, when their loans were called in. ' +
        'Also called the Great Crash or the Wall Street Crash, leading to ' +
        'the Great Depression.',
    country: 'United States'
}, {
    x: -1041379200000,
    y: 1,
    lbl: 'Recession of 1937–38',
    causes:
        'Lasting around a year, this share price fall was triggered by an ' +
        'economic recession within the Great Depression and doubts about the ' +
        'effectiveness of Franklin D. Roosevelt\'s New Deal policy.',
    country: 'United States'
}, {
    x: -239767200000,
    y: 1,
    lbl: 'Kennedy Slide of 1962',
    causes: 'Also known as the \'Flash Crash of 1962\'',
    country: 'United States'
}, {
    x: 47170800000,
    y: 1,
    lbl: 'Brazilian Markets Crash of 1971',
    causes: 'Lasting through the 1970s and early-1980s, this was the end of ' +
        'a boom that started in 1969, compounded by the 1970s energy crisis ' +
        'coupled with early 1980s Latin American debt crisis.',
    country: 'Brazil'
}, {
    x: 94690800000,
    y: 1,
    lbl: '1973–74 stock market crash',
    causes:
        'Lasting 23 months, dramatic rise in oil prices, the miners\' ' +
        'strike and the downfall of the Heath government.',
    country: 'United Kingdom'
}, {
    x: 397000800000,
    y: 1,
    lbl: 'Souk Al-Manakh stock market crash',
    causes: '',
    country: 'Kuwait'
}, {
    x: 561596400000,
    y: 1,
    lbl: 'Black Monday',
    causes: '',
    country: 'United States'
}, {
    x: 612655200000,
    y: 1,
    lbl: 'Rio de Janeiro Stock Exchange Crash',
    causes: 'Rio de Janeiro Stock Exchange Crash, due to its weak internal ' +
        'controls and absence of credit discipline, that led to its collapse,' +
        ' and of which it never recovered',
    country: 'Brazil'
}, {
    x: 624236400000,
    y: 1,
    lbl: 'Friday the 13th mini-crash',
    causes: 'Failed leveraged buyout of United Airlines causes crash',
    country: 'United States'
}, {
    x: 646783200000,
    y: 1,
    lbl: 'Early 1990s recession',
    causes: 'Iraq invaded Kuwait in July 1990, causing oil prices to ' +
        'increase. The Dow dropped 18% in three months, from 2,911.63 on ' +
        'July 3 to 2,381.99 on October 16,1990. This recession lasted ' +
        'approximately 8 months.',
    country: 'United States'
}, {
    x: 662688000000,
    y: 1,
    lbl: 'Japanese asset price bubble',
    causes: 'Lasting approximately twenty years, through at least the end of ' +
        '2011, share and property price bubble bursts and turns into a long ' +
        'deflationary recession. Some of the key economic events during the ' +
        'collapse of the Japanese asset price bubble include the 1997 Asian ' +
        'financial crisis and the Dot-com bubble. In addition, more recent ' +
        'economic events, such as the late-2000s financial crisis and August ' +
        '2011 stock markets fall have prolonged this period.',
    country: 'Japan'
}, {
    x: 716594400000,
    y: 1,
    lbl: 'Black Wednesday',
    causes: 'The Conservative government was forced to withdraw the pound ' +
        'sterling from the European Exchange Rate Mechanism (ERM) after they ' +
        'were unable to keep sterling above its agreed lower limit.',
    country: 'United Kingdom'
}, {
    x: 867794400000,
    y: 1,
    lbl: '1997 Asian financial crisis',
    causes: 'Investors deserted emerging Asian shares, including an ' +
        'overheated Hong Kong stock market. Crashes occur in Thailand, ' +
        'Indonesia, South Korea, Philippines, and elsewhere, reaching a ' +
        'climax in the October 27, 1997 mini-crash.',
    country: 'Thailand'
}, {
    x: 877906800000,
    y: 1,
    lbl: 'October 27, 1997, mini-crash',
    causes: 'Global stock market crash that was caused by an economic crisis ' +
        'in Asia.'
}, {
    x: 903304800000,
    y: 1,
    lbl: '1998 Russian financial crisis',
    causes: 'The Russian government devalues the ruble, defaults on domestic ' +
        'debt, and declares a moratorium on payment to foreign creditors.',
    country: 'Russia'
}, {
    x: 952642800000,
    y: 1,
    lbl: 'Dot-com bubble',
    causes: 'Collapse of a technology bubble.',
    country: 'United States'
}, {
    x: 1000159200000,
    y: 1,
    lbl: 'Economic effects arising from the September 11 attacks',
    causes: 'The September 11 attacks caused global stock markets to drop ' +
        'sharply. The attacks themselves caused approximately $40 billion in ' +
        'insurance losses, making it one of the largest insured events ever. ' +
        'See world economic effects arising from the September 11 attacks.'
}, {
    x: 1034114400000,
    y: 1,
    lbl: 'Stock market downturn of 2002',
    causes: 'Downturn in stock prices during 2002 in stock exchanges across ' +
        'the United States, Canada, Asia, and Europe. After recovering from ' +
        'lows reached following the September 11 attacks, indices slid ' +
        'steadily starting in March 2002, with dramatic declines in July and ' +
        'September leading to lows last reached in 1997 and 1998. See stock ' +
        'market downturn of 2002.'
}, {
    x: 1172530800000,
    y: 1,
    lbl: 'Chinese stock bubble of 2007',
    causes: 'The SSE Composite Index of the Shanghai Stock Exchange tumbles ' +
        '9% from unexpected selloffs, the largest drop in 10 years, ' +
        'triggering major drops in worldwide stock markets.',
    country: 'China'
}, {
    x: 1192053600000,
    y: 1,
    lbl: 'United States bear market of 2007–09',
    causes: 'Till June 2009, the Dow Jones Industrial Average, Nasdaq ' +
        'Composite and S&P 500 all experienced declines of greater than 20% ' +
        'from their peaks in late 2007.',
    country: 'United States'
}, {
    x: 1221516000000,
    y: 1,
    lbl: 'Financial crisis of 2007–08',
    causes: 'On September 16, 2008, failures of large financial institutions ' +
        'in the United States, due primarily to exposure of securities of ' +
        'packaged subprime loans and credit default swaps issued to insure ' +
        'these loans and their issuers, rapidly devolved into a global ' +
        'crisis resulting in a number of bank failures in Europe and sharp ' +
        'reductions in the value of equities (stock) and commodities ' +
        'worldwide. The failure of banks in Iceland resulted in a ' +
        'devaluation of the Icelandic króna and threatened the government ' +
        'with bankruptcy. Iceland was able to secure an emergency loan from ' +
        'the IMF in November. Later on, U.S. President George W. Bush signs ' +
        'the Emergency Economic Stabilization Act into law, creating a ' +
        'Troubled Asset Relief Program (TARP) to purchase failing bank ' +
        'assets. Had disastrous affects on the world economy along with ' +
        'world trade.',
    country: 'United States'
}, {
    x: 1259276400000,
    y: 1,
    lbl: '2009 Dubai debt standstill',
    causes: 'Dubai requests a debt deferment following its massive ' +
        'renovation and development projects, as well as the Great ' +
        'Recession. The announcement causes global stock markets to drop.',
    country: 'United Arab Emirates'
}, {
    x: 1272319200000,
    y: 1,
    lbl: 'European sovereign debt crisis',
    causes:
        'Standard & Poor\'s downgrades Greece\'s sovereign credit rating to ' +
        'junk four days after the activation of a €45-billion EU-IMF ' +
        'bailout, triggering the decline of stock markets worldwide and of ' +
        'the Euro\'s value, and furthering a European sovereign debt crisis.',
    country: 'Europe'
}, {
    x: 1273096800000,
    y: 1,
    lbl: '2010 Flash Crash',
    causes: 'The Dow Jones Industrial Average suffers its worst intra-day ' +
        'point loss, dropping nearly 1,000 points before partially recovering.',
    country: 'United States'
}, {
    x: 1312149600000,
    y: 1,
    lbl: 'August 2011 stock markets fall',
    causes: 'Stock markets around the world plummet during late July and ' +
        'early August, and are volatile for the rest of the year.'
}, {
    x: 1434060000000,
    y: 1,
    lbl: '2015–16 Chinese stock market crash',
    causes: 'China stock market crash starts in June and continues into July ' +
        'and August. In January 2016, Chinese stock market experiences a ' +
        'steep sell-off which sets off a global rout.',
    country: 'China'
}, {
    x: 1479475415333,
    y: 1,
    lbl: 'Aftermath of the United Kingdom European Union membership ' +
        'referendum, 2016',
    causes: 'World Markets tumble after the United Kingdom voted to leave ' +
        'the European Union. Investors lost more than the equivalent of 2 ' +
        'trillion United States dollars on 24 June 2016, making this day the ' +
        'worst single day drop in history according to data from S&P Global. ' +
        'The losses were extended to a combined total of the equivalent of 3 ' +
        'trillion dollars by additional selling on 27 June 2016 according to ' +
        'data from S&P Global.',
    country: 'United Kingdom'
}];

Highcharts.stockChart('container', {
    chart: {
        inverted: true
    },
    title: {
        text: 'List of stock market crashes and bear markets',
        align: 'left'
    },
    subtitle: {
        text: 'Source: Wikipedia',
        align: 'left'
    },
    rangeSelector: {
        buttons: [{
            type: 'year',
            count: 1,
            text: '1y'
        }, {
            type: 'year',
            count: 10,
            text: '10y'
        }, {
            type: 'year',
            count: 100,
            text: '100y'
        }]
    },
    navigator: {
        opposite: true,
        series: {
            type: 'line',
            marker: {
                enabled: true
            },
            lineWidth: 0
        },
        xAxis: {
            ordinal: false,
            reversed: false,
            tickPixelInterval: 50
        }
    },
    xAxis: {
        ordinal: false,
        labels: {
            enabled: false
        },
        tickLength: 0,
        lineWidth: 0,
        min: '1900-01-01',
        reversed: false
    },
    yAxis: {
        min: 0.75,
        max: 2,
        labels: {
            enabled: false
        },
        gridLineWidth: 0
    },
    tooltip: {
        shared: false,
        useHTML: true,
        styles: {
            'white-space': 'normal'
        },
        formatter: function () {
            let tooltipString = '<div>';

            if (this.series.name === 'Series 1') {
                return false;
            }

            if (this.point.options.country) {
                tooltipString =
                    '<div style="width: 140px;">Country: ' +
                    this.point.options.country + '</div>';
            }
            tooltipString +=
                '<div style="width: 140px;">Year: ' +
                Highcharts.dateFormat('%Y', this.x) + '</div>';
            if (this.point.options.causes) {
                tooltipString +=
                    '<div style="width: 300px;">Causes: ' +
                    this.point.options.causes + '</div>';
            }
            return tooltipString + '</div>';
        }
    },
    series: [{
        // pointStart: -10950249600000,
        pointStart: '1625-01-01',
        pointInterval: 5,
        pointIntervalUnit: 'year',
        data: [
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75,
            0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75
        ],
        states: {
            hover: {
                halo: {
                    size: 0
                }
            }
        },
        dataLabels: {
            enabled: true,
            formatter: function () {
                return Highcharts.dateFormat('%Y', this.x);
            }
        },
        showInNavigator: false
    }, {
        showInNavigator: true,
        dataLabels: {
            enabled: true,
            align: 'left',
            format: '{point.options.lbl}',
            backgroundColor: '#999999',
            style: {
                width: '300px',
                color: '#FFFFFF',
                textOutline: 'none'
            }
        },
        dataGrouping: {
            enabled: false
        },
        pointWidth: 1,
        threshold: 0.75,
        marker: {
            states: {
                hover: {
                    enabled: false
                }
            }
        },
        type: 'column',
        data: eventsData
    }]
}, function (chart) {

    // Add mousewheel support:
    Highcharts.addEvent(
        chart.container,
        document.onmousewheel === undefined ? 'DOMMouseScroll' : 'mousewheel',
        function (event) {
            let range, delta, extr, step, newMin, newMax,
                prevent = true;
            const axis = chart.xAxis[0];
            const e = chart.pointer.normalize(event);
            // Firefox uses e.detail, WebKit and IE uses wheelDelta
            delta = e.detail || -(e.wheelDelta / 120);
            delta = delta < 0 ?
                (axis.reversed ? -1 : 1) :
                (axis.reversed ? 1 : -1);

            if (chart.isInsidePlot(
                e.chartX - chart.plotLeft, e.chartY - chart.plotTop
            )) {
                extr = axis.getExtremes();
                range = (extr.max - extr.min);
                step = range * delta / 15;

                newMin = extr.min + step;
                newMax = extr.max + step;

                if (newMax > extr.dataMax) {
                    newMax = extr.dataMax;
                    newMin = newMax - range;
                    prevent = false;
                }
                if (newMin < extr.dataMin) {
                    newMin = extr.dataMin;
                    newMax = newMin + range;
                    prevent = false;
                }

                axis.setExtremes(newMin, newMax, true, false);

                if (prevent) {
                    if (e) {
                        if (e.preventDefault) {
                            e.preventDefault();
                        }
                        if (e.stopPropagation) {
                            e.stopPropagation();
                        }
                        e.cancelBubble = true;
                    }
                }
            }
        }
    );
});