(async () => {

    const usdeur = await fetch(
        'https://www.highcharts.com/samples/data/usdeur.json'
    ).then(response => response.json());

    Highcharts.stockChart('container', {
        title: {
            text: 'yAxis: {showFirstLabel: false}'
        },

        yAxis: {
            showFirstLabel: false,
            showLastLabel: true,
            labels: {
                y: 12
            }
        },

        rangeSelector: {
            selected: 1
        },

        series: [{
            name: 'USD to EUR',
            data: usdeur
        }]
    });
})();